// SPLINE GENERATOR SAMPLE: SPLINE BASED OBJECT
// ********************************************

// camera {location <0, 70, -20> look_at <0, 0, 0> angle 100}
//  light_source {<10, -60, 240> rgb 1}

// camera {  //  Camera Camera01
//   location  <59.741, -123.178, -24.309>
//   direction <0.0,     0.0,  2.5899>
//  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
//  up        <0.0,     0.0,  1.0>  // Where Z is up
//  right     <1.33333, 0.0,  0.0>
//  look_at   <33.012, 0.163, -3.128>
// }




#declare cleartubetxtr = texture {
   pigment { color rgbt <1.000, 0.430, 0.780, 1 > }
   finish {
     diffuse 0.500
     ambient .00
     specular 0.400
     roughness 0.0100
   }

}

#declare blacktubetxtr = texture {
   pigment {
     color rgbt<.000, 0, 0.0, 0>
   }
   finish {
     diffuse 0.500
     ambient .00
     specular 0.400
     roughness 0.0100
   }

}


#declare Smoothness =250   //usually 50 or more, 150 is smoother
 merge {

   #declare Smoothness = (1 / Smoothness)
   #declare Count = 0 #while (Count < 1)
      #declare spline_clock = Count #include "beertest.spl"
      #declare CurPoint = spline_pos
      #declare CurRadius = .5  

      #ifdef (PrevPoint)
         sphere {PrevPoint, PrevRadius hollow
                 texture { cleartubetxtr }   
                halo {
                        emitting
                //     spherical_mapping
                        constant
                   // linear
                        color_map {
                 [ 0 color rgbt <3, 0, 0, 1> ]
                 [ 1 color rgbt <3, 0, 0, .5> ]
                        }
                samples 10
                }
         
         
         } 
         cone {PrevPoint, PrevRadius, CurPoint, CurRadius hollow
                        texture { cleartubetxtr }
                     
                halo {
                        emitting
                //     spherical_mapping
                        constant
                    // linear
                        color_map {
                 [ 0 color rgbt <3, 0, 0, 1> ]
                 [ 1 color rgbt <3, 0, 0, .5> ]
                        }
                samples 10
                }
         
         
         }
      #end

      #declare PrevPoint = CurPoint
      #declare PrevRadius = CurRadius
   #declare Count = Count + Smoothness #end

}

#declare testt = 0
#if (testt = 1)
#else

// black out back
// #declare Smoothness = 250

 intersection {

merge {

 //  #declare Smoothness = (1 / Smoothness)
   #declare Count = 0 #while (Count < 1)
      #declare spline_clock = Count #include "beertest.spl"
      #declare CurPoint = spline_pos
      #declare CurRadius = CurRadius + .001  

      #ifdef (PrevPoint2)
         sphere {PrevPoint2, PrevRadius hollow
         
         } 
         cone {PrevPoint2, PrevRadius, CurPoint, CurRadius hollow
         
         }
      #end

      #declare PrevPoint2 = CurPoint
      #declare PrevRadius = CurRadius
   #declare Count = Count + Smoothness #end
            texture {blacktubetxtr} 

   }         
            
    box  { <-2, .501 , -2>, <64, 4, 104> 
            
            texture {blacktubetxtr} 
            }


 }

#end

#declare testtt = 1
#if (testtt = 1)
#else


// glow effect


// #declare Smoothness =50   //usually 50 or more, 150 is smoother

 merge {

 //  #declare Smoothness = (1 / Smoothness)
   #declare Count = 0 #while (Count < 1)
      #declare spline_clock = Count #include "beertest.spl"
      #declare CurPoint = spline_pos
      #declare CurRadius = 2  

      #ifdef (PrevPoint)
         sphere {PrevPoint, PrevRadius hollow
//                 texture { cleartubetxtr }   
                        pigment { color rgbt < 1,1,1,1,> }
                halo {
                        emitting
                //     spherical_mapping

                        constant
              max_value .3 
          //          linear
                        color_map {
                 [ 0 color rgbt <1, 0, 0, 1> ]
                 [ 1 color rgbt <1, 0, 0, .9> ]
                        }
                samples 10  //was 10
                }
         
         
         } 
         cone {PrevPoint, PrevRadius, CurPoint, CurRadius hollow
//                        texture { cleartubetxtr }
                        pigment { color rgbt < 1,1,1,1,> }
                     
                halo {
                        emitting
                //     spherical_mapping
                        constant
              max_value .3 

                  //  linear
                        color_map {
                 [ 0 color rgbt <1, 0, 0, 1> ]
                 [ 1 color rgbt <1, 0, 0, .9> ]
                        }
                samples 10  // was 10
                }
         
         
         }
      #end

      #declare PrevPoint = CurPoint
      #declare PrevRadius = CurRadius
   #declare Count = Count + Smoothness #end

}

#end
