// atom.inc
// by Robert Fremin
#version 3.1;

#ifndef (ATOM_INC)
#declare ATOM_INC = true;

#debug "=#= included atom.inc =#=\n"

// --> Atoms <--

#declare H = sphere { 0 1   pigment { White } }	// Hydrogen
#declare O = sphere { 0 1.5 pigment { Red   } }	// Oxygen
#declare C = sphere { 0 1.5 pigment { Black } }	// Carbon
#declare Dist = 4;		// distance between atoms


// Obj		= atomic object
// Where	= center of atom
//
#macro Atom(Obj, Where)
	object { Obj translate Where finish { specular .2 phong .6 phong_size 200 reflection .01 } }
#end


// From	= center of atom #1
// To	= center of atom #2
//
#macro Pin(From, To)
	cylinder
	{
		From To .2
		pigment { Gray70 }
	}
#end


// --> Molecules <--

#macro OH()
union
{
	Atom(H,-x*Dist)
	Atom(O,0)
	Pin(0,-x*Dist)
}
#end


#macro CH2_()
union
{
	Atom(C,0)

	#local pos1 = vrotate(-y*Dist,-x*45);
	Pin(0,pos1)
	Atom(H,pos1)

	#local pos2 = vrotate(-y*Dist, x*45);
	Pin(0,pos2)
	Atom(H,pos2)
}
#end


#macro Ethanol()	// C2H5OH
union
{
	#local v1 = y*5;
	#local v2 = v1 + vrotate(x*Dist,-z*45);
	#local v3 = v2 + x*Dist;
	#local v4 = v3 + vrotate(x*Dist,z*45);

	#local CH2_l = object { CH2_() rotate z*-45 }
	#local CH2_r = object { CH2_() rotate z*45 }

	Atom(OH(),v1)

	Pin(v1,v2)
	Atom(CH2_l,v2)

	Pin(v2,v3)
	Atom(CH2_r,v3)

	Pin(v3,v4)
	Atom(H,v4)

	translate y*.8
}
#end


#macro H2O()	// Water
union
{
	Atom(O,0)

	#local pos1 = vrotate(-y*Dist,-x*45);
	Pin(0,pos1)
	Atom(H,pos1)

	#local pos2 = vrotate(-y*Dist, x*45);
	Pin(0,pos2)
	Atom(H,pos2)

	rotate z*77
	translate y*1.5
}
#end


#end	// ifndef
