//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 3 textures and 46 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 07/28/1998    (28.07.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

Model conceived and created by Bill Marrs

*/ // End Scene Comment


// Scene Includes

#include "lens.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <7.500, 5.500, 6.500>
  direction <0.0,     0.0,  1.9002>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 1.000>
}

//
// *******  L I G H T S *******
//

light_source {   // side_light
  <-2.961, 4.248, 3.942>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Camera_light
  <7.000, 5.000, 6.000>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  TEXTURES  *******
//

#include "ring.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare rounded_tine = union {
  box { // tine_base
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.65, 0.1>
    rotate <-90.0, 21.594002, -0.0>
    translate  <0.366788, 0.0, 2.5129>
  }
  cylinder { // tine_round
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <0.6, -0.1, 3.1>
  }
  translate  <0.019025, 0.0, 0.019025>
}
#declare Tine = difference {
  object { rounded_tine }
  box { // tine_cutout
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.11, 0.6>
    rotate 29.289257*y
    translate  <0.294894, 0.0, 2.658804>
  }
}
#declare rounded_tine1 = union {
  box { // tine_base1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.65, 0.1>
    rotate <-90.0, 21.594002, -0.0>
    translate  <0.366788, 0.0, 2.5129>
  }
  cylinder { // tine_round1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <0.6, -0.1, 3.1>
  }
  translate  <0.019025, 0.0, 0.019025>
}
#declare Tine1 = difference {
  object { rounded_tine1 }
  box { // tine_cutout1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.11, 0.6>
    rotate 29.289257*y
    translate  <0.294894, 0.0, 2.658804>
  }
  rotate -60.0*z
}
#declare rounded_tine2 = union {
  box { // tine_base2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.65, 0.1>
    rotate <-90.0, 21.594002, -0.0>
    translate  <0.366788, 0.0, 2.5129>
  }
  cylinder { // tine_round2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <0.6, -0.1, 3.1>
  }
  translate  <0.019025, 0.0, 0.019025>
}
#declare Tine2 = difference {
  object { rounded_tine2 }
  box { // tine_cutout2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.11, 0.6>
    rotate 29.289257*y
    translate  <0.294894, 0.0, 2.658804>
  }
  rotate -120.0*z
}
#declare rounded_tine3 = union {
  box { // tine_base3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.65, 0.1>
    rotate <-90.0, 21.594002, -0.0>
    translate  <0.366788, 0.0, 2.5129>
  }
  cylinder { // tine_round3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <0.6, -0.1, 3.1>
  }
  translate  <0.019025, 0.0, 0.019025>
}
#declare Tine3 = difference {
  object { rounded_tine3 }
  box { // tine_cutout3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.11, 0.6>
    rotate 29.289257*y
    translate  <0.294894, 0.0, 2.658804>
  }
  rotate 180.0*z
}
#declare rounded_tine4 = union {
  box { // tine_base4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.65, 0.1>
    rotate <-90.0, 21.594002, -0.0>
    translate  <0.366788, 0.0, 2.5129>
  }
  cylinder { // tine_round4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <0.6, -0.1, 3.1>
  }
  translate  <0.019025, 0.0, 0.019025>
}
#declare Tine4 = difference {
  object { rounded_tine4 }
  box { // tine_cutout4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.11, 0.6>
    rotate 29.289257*y
    translate  <0.294894, 0.0, 2.658804>
  }
  rotate 120.0*z
}
#declare rounded_tine5 = union {
  box { // tine_base5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.65, 0.1>
    rotate <-90.0, 21.594002, -0.0>
    translate  <0.366788, 0.0, 2.5129>
  }
  cylinder { // tine_round5
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <0.60352, -0.100227, 3.098533>
  }
  translate  <0.019025, 0.0, 0.019025>
}
#declare Tine5 = difference {
  object { rounded_tine5 }
  box { // tine_cutout5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.11, 0.6>
    rotate 29.289257*y
    translate  <0.294894, 0.0, 2.658804>
  }
  rotate 60.0*z
}
#declare tines = union {
  object { Tine }
  object { Tine1 }
  object { Tine2 }
  object { Tine3 }
  object { Tine4 }
  object { Tine5 }
  texture {
    Soft_Silver
  }
}
#declare first_cut_round = union {
  box { // first_cut_proto1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, -45.0>
    translate  <-0.707107, 0.707107, 3.5>
  }
  box { // first_cut_proto2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, -90.0>
    translate  <0.0, 1.0, 3.5>
  }
  box { // first_cut_proto3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, -135.0>
    translate  <0.707107, 0.707107, 3.5>
  }
  box { // first_cut_proto4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, 180.0>
    translate  <1.0, -0.0, 3.5>
  }
  box { // first_cut_proto5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, 135.0>
    translate  <0.707107, -0.707107, 3.5>
  }
  box { // first_cut_proto6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, 90.0>
    translate  <-0.0, -1.0, 3.5>
  }
  box { // first_cut_proto7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -45.0, 45.0>
    translate  <-0.707107, -0.707107, 3.5>
  }
}
#declare second_cut_round = union {
  box { // second_cut_p1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, -67.5>
    translate  <-0.382683, 0.92388, 3.5>
  }
  box { // second_cut_p2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, -112.5>
    translate  <0.382683, 0.92388, 3.5>
  }
  box { // second_cut_p3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, -157.5>
    translate  <0.92388, 0.382683, 3.5>
  }
  box { // second_cut_p4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, 157.5>
    translate  <0.92388, -0.382683, 3.5>
  }
  box { // second_cut_p5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, 112.5>
    translate  <0.382683, -0.92388, 3.5>
  }
  box { // second_cut_p6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, 67.5>
    translate  <-0.382683, -0.92388, 3.5>
  }
  box { // second_cut_p7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    rotate <-0.0, -30.0, 22.5>
    translate  <-0.92388, -0.382683, 3.5>
  }
  translate  0.155*z
}
#declare diamond_with_cuts = difference {
  cone { // diamond_base_cone
    <0,0,0>, 0.0, <0,0,1>, 1.0
    translate  2.5*z
  }
  object { first_cut_round }
  object { second_cut_round }
  texture {
    Shiny_Orb
  }
}
#declare goldring = difference {
  torus { // ring_base_torus
    1.75, 0.25  rotate -x*90
    texture {
      Gold_Metal
    }
    rotate <-180.0, -90.0, 0.0>
  }
  cylinder { // ring_cutMout
    <0,0,1>, <0,0,0>, 1 
    texture {
      Gold_Metal
    }
    scale <1.65, 1.65, 0.75>
    rotate -90.0*y
    translate  0.4*x
  }
}
#declare Diamond_Ring = union {
  object { tines }
  object { diamond_with_cuts }
  object { goldring }
}
#declare letter = union {
  text {   // text
    ttf      "Brushsci.ttf",
    "A",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  translate  -1.7*y
}
#declare letter1 = union {
  text {   // text1
    ttf      "Brushsci.ttf",
    "l",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.104152, -0.109823, 0.080102>
  }

  rotate 8.0*x
  translate  <0.0, -1.677028, -0.26795>
}
#declare letter2 = union {
  text {   // text2
    ttf      "Brushsci.ttf",
    "l",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 16.0*x
  translate  <0.0, -1.610003, -0.480655>
}
#declare letter4 = union {
  text {   // text4
    ttf      "Brushsci.ttf",
    "m",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 32.0*x
  translate  <0.0, -1.477895, -0.86465>
}
#declare letter5 = union {
  text {   // text5
    ttf      "Brushsci.ttf",
    "y",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 40.0*x
  translate  <0.0, -1.32156, -1.079883>
}
#declare letter7 = union {
  text {   // text7
    ttf      "Brushsci.ttf",
    "l",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 56.0*x
  translate  <0.0, -1.035125, -1.36108>
}
#declare letter10 = union {
  text {   // text10
    ttf      "Brushsci.ttf",
    "e",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 80.0*x
  translate  <0.0, -0.55419, -1.555965>
}
#declare letter9 = union {
  text {   // text9
    ttf      "Brushsci.ttf",
    "v",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 72.0*x
  translate  <0.0, -0.728034, -1.498588>
}
#declare letter8 = union {
  text {   // text8
    ttf      "Brushsci.ttf",
    "o",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    scale <0.4, 0.4, 0.2>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.1, -0.1, 0.15>
  }

  rotate 64.0*x
  translate  <0.0, -0.891653, -1.436239>
}
#declare lettering = union {
  object { letter }
  object { letter1 }
  object { letter2 }
  object { letter4 }
  object { letter5 }
  object { letter7 }
  object { letter10 }
  object { letter9 }
  object { letter8 }
  texture {
    Gold_Metal
  }
}
difference { // etched_ring
  object { Diamond_Ring }
  object { lettering }
}






