#declare Glass =
texture {
  #if( Debug = 0)
    pigment{ color rgbf<0.98, 1.0, 0.99, 0.75> }
    //pigment{ color rgb<0.98, 1.0, 0.99> }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      refraction 1
      ior 1.5
      specular 1
      roughness 0.001
      caustics 0.1
    }
    normal{
      average
      normal_map{
        [ 0.5 bumps      0.2                           scale 0.5]
        [ 0.5 gradient y 0.01 turbulence 0.3 sine_wave scale 0.1]
      }
    }
    /*normal{      old
      bumps 0.25
      scale 0.5
    }*/
  #else
    pigment{ color rgbt<0.5, 1.0, 0.5, 0.8> }
    normal{
      bumps 0.25
      scale 0.5
    }
#end
}

#declare Water =
texture{
  #if( Debug = 0)
    pigment{ color rgbf <0.95, 0.95, 1.0, 0.9> }
    finish {
      reflection 0.2
      refraction 1.0
      ior 1.33
      caustics 0.1
    }
  #else
    pigment{ color rgbt<0.5, 0.5, 1.0, 0.5> }
#end
}

#declare Rippled_Water =
texture{
  Water
  normal{
    ripples 0.4
    scale 0.25
  }
}

#declare Porcelain =
texture{
  pigment{ rgb< 0.8, 0.8, 0.78>}
  normal {
    bumps 0.1
    scale 0.1
  }
  finish {
    ambient 0.2
    diffuse 0.65
    reflection 0.0025
    specular 0.2
    roughness 0.125
    phong 0.25
  }
}

#declare Cork_Texture =
texture {
    pigment {
        granite
        color_map {
            [0.00, 0.60 color rgb <0.93, 0.71, 0.532>
                        color rgb <0.98, 0.81, 0.60>]
            [0.60, 0.65 color rgb <0.50, 0.30, 0.20>
                        color rgb <0.50, 0.30, 0.20>]
            [0.65, 1.00 color rgb <0.80, 0.53, 0.46>
                        color rgb <0.85, 0.75, 0.35>]
        }
    }
    finish{
        specular 0.1
        roughness 0.5
    }
    scale< 0.25, 1, 0.25>     // Generally looks best scaled longer on one axis
}

#declare Ground_Glass =
texture {
  pigment{ color rgbt<0.98, 1.0, 0.99, 0.75> }
  finish {
    ambient 0.1
    diffuse 0.7
    //reflection 0.05
    refraction 1
    ior 1.5
    specular 1
    roughness 0.001
  }
}
