#include "chem_text.inc"   //Textures
//________________________________________________________

#declare Pan_Outer =
intersection{
  superellipsoid{
    <1, 0.25>
    rotate 90*x
    translate< 0, 1, 0>
    scale< 5, 2.0, 5>
  }
  merge{
    plane{
      y, 3.0
    }
    torus{
      4.85, 0.5
      translate< 0, 3.0, 0>
    }
    texture{ Glass}
    normal{
      granite
      scale 0.1
    }
  }
}
//________________________________________________________

#declare Pan_Inner =
intersection{
  superellipsoid {
    <1, 0.25>
    rotate 90*x
    translate< 0, 1, 0>
    scale< 5, 2.0, 5>
    scale< 0.95, 0.95, 0.95>
    translate< 0, 0.25, 0>
  }
  plane{ y, 6.0}
}
//________________________________________________________
//Pan

#declare Pan =
intersection{
  object{ Pan_Outer}
  object{
    Pan_Inner
    inverse
  }
  bounded_by { cylinder{ < 0, -0.1, 0>, < 0, 4.1, 0>, 5.5 } }
  texture{ Glass}
}
//________________________________________________________
//Pan water

#declare h = 3.0 //water height rel to y = 0
#declare rs = 0.25 //surface tension radius
#declare rw = 4.5 //water radius
#declare Pan_Water =
intersection{
  cylinder{
    <0, 0, 0>, < 0, h, 0>, 5.5
    texture{ Rippled_Water}
  }
  object{
    Pan_Inner
    texture{ Glass}
  }
  torus{
    rw, rs
    translate< 0, h, 0>
    texture{ Rippled_Water}
    inverse
  }
  cylinder{
    < 0, h-rs, 0>, < 0, h+rs, 0>, rw
    inverse
    texture{ Rippled_Water}
  }
}
//________________________________________________________
//Chipped pan edge
/*
#declare Chip =
sphere{
  < 0, 0, 0>, 0.5
  texture{ T_Glass4}
  //pigment{ Red}
  inverse
}
#declare r1 = seed(0)
#declare r2 = seed(12345)
#declare r3 = seed(54321)
intersection{
  object{
    Pan
    translate< 0, 0, 0>
    texture{ T_Glass4}
    //pigment{ Red}
  }
  #declare i=0
    #while (i < 50)
    #declare u1 = rand( r1)
    #declare u2 = rand( r2)
    #declare u3 = rand( r3)
    #declare u4 = rand( r3)
    #declare y1 = sqrt(-2*log(u1))*cos(2*pi*u2)
    #declare y2 = sqrt(-2*log(u1))*sin(2*pi*u2)
    object{
      Chip
      scale  1+0.1*y1
      translate< 0, 3, 4.3>
      rotate 360*u3*y
    }
    object{
      Chip
      scale  1+0.1*y2
      translate< 0, 3, 5.4>
      rotate 360*u4*y
    }
    #declare i=i+1
  #end
}
*/


