#include "colors.inc"
#include "glass.inc"
#include "metals.inc"

#declare Debug = false

#include "flask.inc"
#include "funnel.inc"
#include "cork.inc"
#include "delivery.inc"
#include "pan.inc"
#include "beehive.inc"
#include "jar.inc"
#include "oldwood.inc"
#include "zinc.inc"

global_settings{ max_trace_level 8}
global_settings{ assumed_gamma 1.8}

camera{
  location < -4, 50, -80>
  look_at  < -8, 6, 0>
  angle 15
}

light_source{
  <100, 100, -100> 2*White
  spotlight
  radius 2.5
  falloff 4
  tightness 10
  point_at <-6, 0, 4>
}

sky_sphere{
  pigment{
    gradient y
    color_map{
      [0.5 color Gray90]
      [0.8 color Gray60]
    }
  }
}

plane { y, -0.1
  texture{
    Old_Wood
    rotate 90*y
    scale 7.0
  }
}




object{
  Spilt_Water
  scale< 3, 0.2, 2>
  translate< -7, 0, -6.5>
}


object{
  Jar
  translate< -7, 0, 12>
}
object{
  Jar_Lid
  translate< -7, 7.301, 12>
}
object{
  Jar
  translate< -11, 0, 12.5>
}

union{
  object{
    Jar_Lid
  }
  object{
    Jar_Lid
    translate< -0.2, 0.101, 0.1>
  }
  object{
    Jar_Lid
    translate< 0.1, 0.202, 0.3>
  }
  translate< -5.5, 0, 6>
}

intersection{
  merge{
    object{
      Jar_Water
      rotate 180*z
      translate< -13.4, 7.3+0.28+1.4, -0.2>
    }
    object{
      Pan_Water
      translate< -13.0, 0, 0.1>
    }
  }
  object{ Bubbles inverse}
}
object{
  Jar
  rotate 180*z
  translate< -13.4, 7.3+0.28+1.4, -0.2>
}
object{
  Beehive
  rotate -75*y
  scale< 0.9, 0.7, 0.9>
  translate< -13.5, 0.28, 0>
}
object{
  Pan
  //scale< 1.2, 0, 1.2>
  translate< -13.0, 0, 0.1>
}
object{
  Flask
  translate< 0, 0.1, 0>
}
object{
  Flask_Acid
  translate< 0, 0.1, 0>
}
object{
  Zinc
  translate< 0, 0.1, 0>
}
object{
  Cork
  translate< 0, 9.5, 0>
}
object{
  Funnel
  translate< 0.33, 1.0, 0>
}
object{
  Tube
  translate< -0.33, 8.0, 0>
}


