// Author: Frank Epple.
// As this parts could be useful in other scenes, they are written into an include file.

// ----------------------------------------------------------------------------------------
// Material declarations
// ----------------------------------------------------------------------------------------

#declare MATERIAL_SAEULE = 
texture
{
  pigment
    { 
      wrinkles
      color_map
        {
          [0.0 rgb <1.00,1.00,1.00>]
          [0.3 rgb <0.90,0.90,0.90>]
          [0.7 rgb <0.97,0.97,0.97>]
          [1.0 rgb <0.93,0.93,0.93>]
        }
      scale 0.2
    }
  finish
    {
      ambient 0.32
      diffuse 0.6
    }
}

#declare GoldBase = <1.00, 0.875, 0.575>  // mine again
#declare CVect3 = GoldBase  - <0.00, 0.10, 0.20>
#declare P_Gold3    = rgb CVect3
#declare R_GoldC =  P_Gold3 * 0.40 + 0.25
#declare A_GoldC    =  P_Gold3 * 0.08 + 0.1
#declare D_GoldC    = 1-(((R_GoldC.red+R_GoldC.green+R_GoldC.blue)/3)
                       + ((A_GoldC.red+A_GoldC.green+A_GoldC.blue)/3))

#declare MATERIAL_BOWL =
texture
  {
    pigment { rgb <1.00, 0.725, 0.275> }
    finish
      {
        brilliance 4
        diffuse D_GoldC
        ambient A_GoldC
        reflection R_GoldC
        metallic 1
        specular 0.60
        roughness 1/80
      }
  }

// ----------------------------------------------------------------------------------------
// Sule
// ----------------------------------------------------------------------------------------

#ifndef (SAEULE_HEIGHT) #declare SAEULE_HEIGHT = 9 #end
#ifndef (SAEULE_RADIUS) #declare SAEULE_RADIUS = 1 #end
#ifndef (SAEULE_R2) #declare SAEULE_R2 = 0.09 #end
#ifndef (SAEULE_NUMBER) #declare SAEULE_NUMBER = 30 #end
#ifndef (SAEULE_POD) #declare SAEULE_POD=1 #end

#declare SAEULE = union
{
  union
    {
      cylinder
        {
          <0, 0, 0>
          <0, SAEULE_POD/4, 0>
          SAEULE_RADIUS*1.3
        }
      torus
        {
          SAEULE_RADIUS
          SAEULE_POD/8
          translate <0,SAEULE_POD*7/8,0>
        }
      torus
        {
          SAEULE_RADIUS
          SAEULE_POD/8
          translate <0,SAEULE_POD*4/8,0>
        }
    }

  difference
    {
      cylinder
        { 
          <0,0,0>
          <0,SAEULE_HEIGHT,0>
          SAEULE_RADIUS
        }

      #ifndef (FAST_RENDER)
      #declare N=0
      #while (N<SAEULE_NUMBER)
        #declare W=N*(360/SAEULE_NUMBER)
        union
          {
            cylinder
              {
                <SAEULE_RADIUS*cos(radians(W)),SAEULE_POD+0.5,SAEULE_RADIUS*sin(radians(W))>
                <SAEULE_RADIUS*cos(radians(W)),SAEULE_HEIGHT-0.5,SAEULE_RADIUS*sin(radians(W))>
                SAEULE_R2

              }

            sphere
              {
                <SAEULE_RADIUS*cos(radians(W)),SAEULE_POD+0.5,SAEULE_RADIUS*sin(radians(W))>
                SAEULE_R2
              }

            sphere
              {
                <SAEULE_RADIUS*cos(radians(W)),SAEULE_HEIGHT-0.5,SAEULE_RADIUS*sin(radians(W))>
                SAEULE_R2
              }
          }

        #declare N = N + 1
      #end
      #end
    }

  texture { MATERIAL_SAEULE }
}

#declare BOWL =
difference
  {
    union
      {
        sphere { <0,0,0>, 1.05 }
        cone
          {
            <0,0,0> 0.1 <0,-3.0,0> 0.05
            rotate <0,0,30>
          }
        cone
          {
            <0,0,0> 0.1 <0,-3.0,0> 0.05
            rotate <0,0,30>
            rotate <0,120,0>
          }
        cone
          {
            <0,0,0> 0.1 <0,-3.0,0> 0.05
            rotate <0,0,30>
            rotate <0,240,0>
          }
      }

    sphere { <0,0,0>, 1.0 }
    box { <-2,-0.3,-2>, <2,2,2> }
    box { <-4,-2.0,-4>, <5,-3,5> }  // Cutting the foots.
    translate <0,2,0> // Point zero in the middle of the foots.

    texture { MATERIAL_BOWL }
  }

#declare FRONTSHAPE=
prism {
  linear_sweep
  linear_spline
  0, 3,
  7,
  <-10, 0>, <-10, 2>, <-3, 5>, <3,5>, <10,2>, <10,0>, <-10, 0>
}

#declare FRONT =
union
{
  difference
  {
    object
    {
      FRONTSHAPE
    }

    object
    {
      FRONTSHAPE
      translate <0,2.7,0.4>
      scale <0.85,1.0,0.85>
    }
  }

  sphere
    {
      <0,2.0,2.5>, 1.5
    }

  rotate <-90,0,0>
  texture {MATERIAL_SAEULE}
}