// Author: Frank Epple.
// The four spheres containing the four elements. There was planned a sphere,
// containing the fifth element, but I liked the four elements stated by
// Empedokles more. But you can test the fifth element, I left it in this file.

#include "plants.inc"

// ----------------------------------------------------------------------------------------
// Some parameters to play with...
// ----------------------------------------------------------------------------------------

#declare GLASS_THICK = 0.01 // Thickness of the Glass of the spheres.
#declare SPHERE_FILL = 0.85  // Height of the filling of the spheres (earth and water).

// ----------------------------------------------------------------------------------------
// The sphere itself as baseobject for the five spheres.
// The sphere has a radius of 1 meter. The thickness of it's
// hull is 5 cm.
// ----------------------------------------------------------------------------------------

#declare MATERIAL_SPHERE =
texture
  {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish
      {
        ambient 0.2
        diffuse 0.2
        reflection .1
//        refraction 1
//        ior 1.004
        specular 1
        roughness 0.001
//        caustics 0.3
      }
  }

#declare SPHERE_TEMPLATE =
sphere
  {
    <0,0,0>
    1.0

    hollow
    texture {MATERIAL_SPHERE}
  }

/*intersection
{
  sphere
    {
      <0,0,0>
      1.0

      hollow
    }
  sphere
    {
      <0,0,0>
      1.0 - GLASS_THICK

      hollow
    }
    
  texture {MATERIAL_SPHERE}
}*/

// ----------------------------------------------------------------------------------------
// The sphere, containing the element 'earth'.
// ----------------------------------------------------------------------------------------

#declare MATERIAL_EARTH =
texture
	{
		pigment
      {
			  wrinkles
        scale .01
			  color_map
          {
            [0.00 color rgb <0.70, 0.60, 0.40> ]
 		        [0.20 color rgb <0.85, 0.75, 0.55> ]
				    [0.40 color rgb <0.40, 0.20, 0.15> ]
				    [0.99 color rgb <0.60, 0.60, 0.60> ]
            [1.00 color rgb <0.60, 0.35, 0.25> ]
			    }
			  sine_wave
			  /*
        color_map {
          [0.00 color rgb <0.00, 0.00, 0.00> ]
 		      [0.20 color rgb <0.25, 0.05, 0.05> ]
				  [0.40 color rgb <0.25, 0.05, 0.05> ]
				  [0.99 color rgb <0.30, 0.20, 0.15> ]
          [1.00 color rgb <0.60, 0.35, 0.25> ]
			  }*/

			  //	color rgb <0.30, 0.20, 0.15>
			  /*gradient y
			  scale .01
			  color_map {
				  [0 color rgb <1,1,1>]
				  [.8 color rgb <1,1,1>]
				  [.8 color rgb <1,0,0>]
				  [1 color rgb <1,0,0>]
			  }*/
		  }
	}

#declare SPHERE_EARTH =
union
{
  object {SPHERE_TEMPLATE}
  
  difference
    {
      sphere
        {
          <0,0,0>
          1.0 - GLASS_THICK

          texture {MATERIAL_EARTH}
        }
        
      height_field 
        {
          tga "earth.tga"
          smooth

          translate <-0.5,0,-0.5>
          scale <2.0, 0.3, 2.0>
          rotate <180,0,0>
          rotate <0,-70,0>

          texture {MATERIAL_EARTH}
        }
    }

  #declare Min_Length = 0.7   
  #declare Max_Length = 1.0   
  #declare Min_Radius = 0.015 
  #declare Max_Radius = 0.025 
  #declare Min_Angle  = 65    
  #declare Number_Of  = 14    

// Group 1
  object
    {
      GRASS1
      scale 0.4
      translate <-0.3,-0.2,0>
    }
  object
    {
      GRASS1
      scale 0.4
      translate <-0.4,-0.2,0.1>
    }
  object
    {
      GRASS1
      scale 0.4
      translate <-0.35,-0.2,0.2>
    }
  object
    {
      GRASS1
      scale 0.4
      translate <-0.4,-0.2,0.3>
    }
  object
    {
      GRASS1
      scale 0.4
      translate <-0.2,-0.2,0.25>
    }

// Group 2
  object
    {
      GRASS1
      scale 0.4
      translate <0.25,-0.2,-0.8>
    }
  object
    {
      GRASS1
      scale 0.4
      translate <0.2,-0.2,-0.7>
    }
  object
    {
      GRASS1
      scale 0.4
      translate <0.3,-0.2,-0.65>
    }
}

// ----------------------------------------------------------------------------------------
// The sphere, containing the element 'water'.
// ----------------------------------------------------------------------------------------

#declare MATERIAL_WATER =
texture
  {
    pigment { color rgb <0.0, 0.45, 0.9> }
  }

#declare MATERIAL_WATERSURFACE =
texture
  {                                                                 
    pigment { color rgb< 0.0, 0.1, 0.2 > }
    normal { bumps 0.2  scale < 0.1, 0.05, 0.05 > }
    finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
  }

#declare SPHERE_WATER =
union
{
  object {SPHERE_TEMPLATE}
  
  difference
    {
      sphere
        {
          <0,0,0>
          1.0 - GLASS_THICK

          texture {MATERIAL_WATER}
        }
        
      box
        {
          <2.0, 2.0, 2.0>
          <-2.0, -1.0+SPHERE_FILL, -2.0>
          
          texture {MATERIAL_WATERSURFACE}
        }
    }
}

// ----------------------------------------------------------------------------------------
// The sphere, containing the element 'fire'.
// It didn't work putting the halo inside the declared SPHERE_TEMPLATE. The halo
// was invisible then. So I didn't use the SPHERE_TEMPLATE for the Firesphere.
// ----------------------------------------------------------------------------------------

#declare SPHERE_FIRE =
union
  {
    object {SPHERE_TEMPLATE}
    
    sphere { 0, 1-GLASS_THICK
          pigment {color rgbt<1,1,1,1>}
          //texture{MATERIAL_SPHERE}
          halo {
            emitting
            spherical_mapping
            linear
            turbulence 1.5
            color_map {
              [ 0.0 color rgbt <1, 0, 0,  1.0> ]
              [ 0.5 color rgbt <1, 1, 0, -1.0> ]
              [ 1.0 color rgbt <1, 0, 0,  1.0> ]
            }
            frequency 2
            samples 20
            scale 0.5
          }
      hollow
    }
  }

// ----------------------------------------------------------------------------------------
// The sphere, containing the element 'air'.
// ----------------------------------------------------------------------------------------

#declare MATERIAL_AIR1 =
texture {
    pigment {
        bozo
        turbulence 3.2
        octaves 23
        omega .3
        lambda 2.5
        color_map {
            [0.0 color rgbf<.75, .75, .75, 0.2>]
            [0.1 color rgbf<.9, .9, .9, 0.4>]
            [0.2 color rgbf<1, 1, 1, 1.0>]
        }
    }

    finish {
        ambient 0.9
        diffuse 0.1
    }
}

#declare MATERIAL_AIR2 =
texture {
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0 color rgbf<.75, .75, .75, 0.2>]
            [0.1 color rgbf<.9, .9, .9, 0.4>]
            [0.2 color rgbf<1, 1, 1, 1.0>]
        }
    }

    finish {
        ambient 0.9
        diffuse 0.1
    }

    rotate <30,90,120>
}

#declare SPHERE_AIR =
union
  {
    object {SPHERE_TEMPLATE}

/*    sphere
      {
        <0,0,0>
        0.98
        pigment {rgbt<1,1,1,1>}

        halo {
          dust
          dust_type 1
          box_mapping
          linear
          turbulence 1
          colour_map {
            [0.00 color rgbt <0.7, 0.7, 1.0, 1.0> ]
            [0.25 color rgbt <1.0, 1.0, 1.0, 0.7> ]
            [0.50 color rgbt <0.9, 0.9, 0.9, 0.3> ]
            [0.75 color rgbt <0.8, 0.8, 0.8, 0.5> ]
            [1.00 color rgbt <0.7, 0.7, 0.8, 0.9> ]
          }
          samples 10
        }

        hollow
      }*/
    
    sphere
      {
        <0,0,0>
        0.9
        texture {MATERIAL_AIR1}
        hollow
        no_shadow
      }

/*    sphere
      {
        <0,0,0>
        0.65
        texture {MATERIAL_AIR2}
        hollow
        no_shadow
      }*/
  }

// ----------------------------------------------------------------------------------------
// The sphere, containing the fifth element.
// ----------------------------------------------------------------------------------------

#declare MATERIAL_FIFTH =
texture
{
  pigment
  {
    colour rgb<0.827,0.827,0.827>
  }
  normal
  {
    ripples 0.8
    frequency 4
    scale <2.0, 2.0, 2.0>
  }
  finish {
    diffuse 0.65
    brilliance 6.0
    phong 1.0
    phong_size 100
    metallic
    reflection 0.65
  }
}

#declare SPHERE_FIFTH =
union
  {
    object {SPHERE_TEMPLATE}

    blob
      {
        threshold 0.600000
        component 1.000000, 0.881360, <-0.835515, -0.445013, 0.071795>
        component 1.000000, 1.827351, <-0.127820, -0.884910, -0.697436>
        component 1.000000, 0.801859, <0.609977, -0.117647, 0.020513>
        component 1.000000, 0.730896, <0.261419, 0.000000, 0.348718>
        component 1.000000, 0.275871, <-1.068571, 1.232737, 1.590075>
        component 1.000000, 0.767082, <-0.966316, 0.086957, 0.812932>
        component 1.000000, 0.517928, <-0.853835, 0.567775, 1.150376>
        component 1.000000, 0.400695, <-1.027669, 0.925831, 1.426466>
        component 1.000000, 0.467198, <0.620229, 0.000000, 0.430769>
        component 1.000000, 0.518236, <0.897025, 0.000000, 0.328205>
        component 1.000000, 0.811465, <1.132815, 0.000000, -0.041026>

        scale 0.4
        rotate <0,-50,0>

        texture {MATERIAL_FIFTH}
      }
  }
