#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "gem.inc"
#include "stonework.inc"
#include "ball.inc"

camera { location <-0.25, 1.5, -3> look_at 0
	//blur_samples 10
	}
//camera { location <0, 4, 0> look_at 0 }

global_settings { max_trace_level 12 }

light_source { <-12, 12, -12> color rgb <0.2, 0.2, 0.3>
	shadowless atmosphere off }
light_source { <-12, 12, -12>
	color rgb <0.8, 0.8, 0.7>
	spotlight
	falloff 60
	tightness 75
	fade_distance 15
	fade_power 2
	atmosphere off
	}

background { color White*0.25 }

#declare InverseFillet = blob
{
   threshold 0.6

   #declare Loop = 10

   #while (Loop <= 60)
	sphere { < 1.01*cos(radians(Loop)), -1.01*sin(radians(Loop)), 0>, 0.05, 1 }
	#declare Loop = Loop + 1.125
   #end
 
}

#include "waveform.inc"

#declare Pool = difference {
object { WaveSurface texture { pigment { color rgbt <0.7, 0.73, 1, 0.75> }
		finish { ambient 0.6 refraction 0.65 ior 1.33 roughness 0.01}}}

difference {
	box { -2, 2 }
	cylinder {y*3, y*-3, 1
	 texture { pigment { color rgbt <0.7, 0.73, 1, 0.1> }
		finish { ambient 0.2 refraction 0.35 ior 1.33 roughness 0.01}} }
	}
	hollow

	scale <0.9, .15, 0.9>*0.99
	translate y*-0.08
}


#declare Bowl = union
{
	difference
		{
		sphere { 0, 1 }
		sphere { 0, 0.90 }
		plane { y*-1, 0 }

		#declare Loop = 0
			#while (Loop < 360)
			object { InverseFillet scale <1, 1, 2> rotate y*Loop }

			cone {  x*0.95, 0
				x*1.05, 0.025
				//scale 0.1 rotate z*-90 translate x*.99
				rotate z*-5 rotate y*(Loop+6) }
/*
			object { Gem scale 0.005 rotate z*-90
				translate x*0.99 rotate z*-10 rotate y*Loop+6 }
*/
			#declare Loop = Loop + 12
			#end
		}

	#declare Loop = 0
	#while (Loop < 360)
		sphere { <0.95, 0, 0>, 0.045 rotate y*Loop }
		#declare Loop = Loop + 3
	#end

	#declare Loop = 0
	#while (Loop < 360)
		object { Gem scale 0.0125 rotate z*-90
			translate x*1 rotate z*-5 rotate y*(Loop+6) }
		#declare Loop = Loop + 12
	#end

	hollow

	//pigment { color rgb <0.9, 0.8, 0.8> }
	texture { T_Grnt20 
		finish { ambient 0.3 specular 0.3 roughness 0.05 }
		}
}

#declare Minibowl = union
{
	difference
		{
		sphere { y*1.5, 0.85 }
		sphere { y*1.5, 0.8 }
		plane { y*-1, -0.85 }
		cylinder { <-1, 0, -1>, <1, 0, 1>, 0.1 
			scale <1.15, 0.6, 1.15> translate y*0.85 }
		cylinder { <1, 0, -1>, <-1, 0, 1>, 0.1 
			scale <1.15, 0.6, 1.15> translate y*0.85 }
		}

	hollow

	scale <0.75, 1, 0.75>
	//pigment { color rgb <0.9, 0.8, 0.8> }
	texture { T_Grnt20 
		finish { ambient 0.3 specular 0.3 roughness 0.05 }
		}
}

#declare HighPool = difference
{
	sphere { y*1.5, 0.7999 }
	plane { y*-1, -0.8475 }

	sphere { <0.5, 0.845, 0>, 0.09 rotate y*-45 }
	sphere { <0.5, 0.845, 0>, 0.09 rotate y*45 }
	sphere { <0.5, 0.845, 0>, 0.09 rotate y*-135 }
	sphere { <0.5, 0.845, 0>, 0.09 rotate y*135 }

	hollow

	scale <0.75, 1, 0.75>
	texture { pigment { color rgbt <0.7, 0.73, 1, 0.75> }
	  finish { ambient 0.6 refraction 0.65 ior 1.33 roughness 0.01}}
}

#declare Marker =
sphere { <0.5, 0.845, 0>, 0.09 rotate y*135
	scale <0.75, 1, 0.75>
	pigment { color Red } finish {ambient 0.8}}

#declare Stream1 = blob
        {
        threshold 0.75
        #declare Loop = 0
        #while (Loop <= 5.85)
                #declare Loop2 = 50
                #while (Loop2 <= 130)
                #declare Offset = ((90 - abs(Loop2-90))/90) + 1
                   sphere { <(-4.5 + Loop)*Offset+(Offset-1)*3, -(Loop*Loop), 0>, 0.75, 1
                        rotate y*Loop2 }
                #declare Loop2 = Loop2 + 5
                #end
                //sphere { <4.5 - Loop, -(Loop*Loop), 0>, 0.75, 1 }
        #declare Loop = Loop + 0.15 - (0.125*(Loop/5))
        #end
	}

#declare Post = difference
{
	intersection
		{ 
		cylinder { y*-1, y*0.7, 0.25 }
		sphere { 0, 0.9 }
		}
	torus { 1.65, 1.55 }

	//pigment { color rgb <0.9, 0.8, 0.8> }
	//finish { ambient 0.3 }
	texture { T_Grnt20 
		finish { ambient 0.3 specular 0.3 roughness 0.05 }
		}
}

#declare Source = difference
{
        sphere { 0, 1 }

        plane { x*1, -0.25 rotate z*-15 }
        plane { x*-1, -0.25 rotate z*15 }

        plane { x*1, -0.25 rotate z*-15 rotate y*-25 }
        plane { x*-1, -0.25 rotate z*15 rotate y*-25 }

        plane { x*1, -0.25 rotate z*-15 rotate y*25 }
        plane { x*-1, -0.25 rotate z*15 rotate y*25 }

        plane { x*1, -0.25 rotate z*-15 rotate y*50 }
        plane { x*-1, -0.25 rotate z*15 rotate y*50 }

        plane { x*1, -0.25 rotate z*-15 rotate y*-50 }
        plane { x*-1, -0.25 rotate z*15 rotate y*-50 }

	hollow

        pigment { color rgbt <1, 0, 0, 0.75> }
        finish { ambient 0.9 specular 1 roughness 0.001
		reflection 0.2
		refraction 0.9 ior 2.47}
}

#declare Floor = union
{
	box { <-10, -1, -10>, <10, -1.25, 10>
		texture
			{
			pigment { hexagon White*0.1, White*0.35, White*0.6 }
			finish { specular 0.35 roughness 0.1 ambient 0.3
				reflection 0.2 }
			normal { dents scale 0.1 }
			}
	}

	box { <-10.01, -1, -10>, <-10.5, -1.3, 10>
		texture { Jade finish { ambient 0.3 } } }

	box { <10.01, -1, -10>, <10.5, -1.3, 10>
		texture { Jade finish { ambient 0.3 } } }

	box { <-10.5, -1, -10.01>, <10.5, -1.3, -10.5>
		texture { Jade finish { ambient 0.3 } } }

	box { <-10.5, -1, 10.01>, <10.5, -1.3, 10.5>
		texture { Jade finish { ambient 0.3 } } }

	scale <0.25, 1, 0.25>
}

#declare Lake =
plane { y*1, -1.25 hollow
	texture {
		pigment { color rgbf <0.2, 0.2, 0.3> }
		finish { specular 0.9 refraction 0.8 ior 1.33 reflection 0.75
			roughness 0.001 }
		normal { waves scale <5, 0.1, 5> }
		normal { bozo scale 0.1 }
		}
}

#declare Enclosure = difference
{
	sphere { 0, 20 }
	sphere { 0, 18 }

	hollow

	scale <1, 0.65, 1>

        texture { T_Grnt25 }
        texture { Layer3 }
        texture { Layer2 }
        texture { Brickwork }

	finish { ambient 0.3 }
}

light_source { <0, 11, 0> color White*0.3 shadowless atmosphere off}

object { Enclosure }

object { Lake }

object { Bowl }
object { Pool }
object { Post }
object { Minibowl }
object { HighPool }
//object { Marker }

object { Stream1 scale 0.03 rotate y*-90 translate <0.445, 0.8425, 0> rotate y*45
	texture { pigment { color rgbt <0.7, 0.73, 1, 0.75> }
	  finish { ambient 0.6 refraction 0.65 ior 1.33 roughness 0.01}}}
object { Stream1 scale 0.03 rotate y*-90 translate <0.445, 0.8425, 0> rotate y*-45
	texture { pigment { color rgbt <0.7, 0.73, 1, 0.75> }
	  finish { ambient 0.6 refraction 0.65 ior 1.33 roughness 0.01}}}
object { Stream1 scale 0.03 rotate y*-90 translate <0.445, 0.8425, 0> rotate y*135
	texture { pigment { color rgbt <0.7, 0.73, 1, 0.75> }
	  finish { ambient 0.6 refraction 0.65 ior 1.33 roughness 0.01}}}
object { Stream1 scale 0.03 rotate y*-90 translate <0.445, 0.8425, 0> rotate y*-135
	texture { pigment { color rgbt <0.7, 0.73, 1, 0.75> }
	  finish { ambient 0.6 refraction 0.65 ior 1.33 roughness 0.01}}}

//object { Gem scale 0.025 }

/*
atmosphere {
    type 1
    color rgbft <0.1, 0.1, 0.1, 0.1, 0.9>
    samples 10
    distance 15
    scattering 0.5
}
*/

object { Source scale 0.25 translate y*0.8 }
light_source { <0, 0.81, 0> color Red*0.5 atmosphere off }

/*
light_source { <0, 0.82, 0>
		color Red*0.5
		atmospheric_attenuation on
		spotlight
		point_at y*11 tightness 10 falloff 30 radius 15 }
*/

//cone { <0, 0.8, 0>, 0.1, <0, 11, 0>, 0.5
cone { <0, -1, 0>, 0.035*0.9, <0, 1, 0>, 0.5
	pigment { color rgbt 1 }
	hollow

	halo {
		emitting
		//dust_type 1
		cylindrical_mapping
		linear
		turbulence 0.35
		color_map {
			[0 color rgbt <1, 0.25, 0.25, 1>]
			[1 color rgbt <1, 0.25, 0.25, 0.25>]
			}
		samples 10
		scale 0.5
		}

	scale <1, 6, 1>*2
	translate y*6.7
}

/*
light_source { <0.5, -0.25, 0> color White*0.25 rotate y*45 }
light_source { <0.5, -0.25, 0> color White*0.25 rotate y*-45 }
light_source { <0.5, -0.25, 0> color White*0.25 rotate y*135 }
light_source { <0.5, -0.25, 0> color White*0.25 rotate y*-135 }
*/
object { Floor }

object { SplashBall 
	translate <0.5+0.2, -0.115, 0> rotate y*135
        scale <0.75, 1, 0.75> }

object { SplashBall 
	translate <0.5+0.25, -0.115, 0> rotate y*45
        scale <0.75, 1, 0.75> }

object { SplashBall 
	translate <0.5+0.25, -0.115, 0> rotate y*-135
        scale <0.75, 1, 0.75> }

object { SplashBall 
	translate <0.5+0.25, -0.115, 0> rotate y*-45
        scale <0.75, 1, 0.75> }
