
#declare Nut1 =
union{
  intersection{
    cylinder{ <0,0,0>, <0,0.2,0>, 0.25 }
    box{ <-0.22,-0.1,-0.3>, <0.22,0.3,0.3> }
    box{ <-0.22,-0.1,-0.3>, <0.22,0.3,0.3> rotate 120*y }
    box{ <-0.22,-0.1,-0.3>, <0.22,0.3,0.3> rotate 240*y }}
  cylinder{ <0,0,0>, <0,0.3,0>, 0.11 }}

#declare Port_building=
union{
  intersection{
    box{ <0,0,-10>, <-20,8,68> translate -0.2*x }
    plane{ y, 0 rotate -60*z  translate <-0.2,7.8,0> } texture{ Simple2 }}
  text{ ttf "playbill.ttf", "4", 0.2, 0
    scale 3
    rotate <0,-90,0>
    translate <-0.19,4.4,11.75> texture { Simple0 }}
  text{ ttf "playbill.ttf", "5", 0.2, 0
    scale 3
    rotate <0,-90,0>
    translate <-0.19,4.4,31.75> texture { Simple0 }}
  text{ ttf "playbill.ttf", "6", 0.2, 0
    scale 3
    rotate <0,-90,0>
    translate <-0.19,4.4,51.75> texture { Simple0 }}
  object{ Lamp70 rotate -90*z translate <-0.2,7,12> }
  object{ Lamp70 rotate -90*z translate <-0.2,7,32> }
  object{ Lamp70 rotate -90*z translate <-0.2,7,52> }}

#declare Port_moorage =
  union{
    cylinder{ <  -1,1.6,0>, <  2,1.6,0>, 2      }
    cylinder{ <   5,4.6,0>, <  5,  5,0>, 2.3    }
    cone{ <5,5,0>, 0.2, <5,6.1,0>, 0 }
    intersection{
      sphere{ <5,6,0>, 0.2 }
      plane{ -y, -6 } translate -0.5*y }
    cylinder{ <-0.2,1.6,0>, <  0,1.6,0>, 2.5    }
    union{
      #declare Cnt=0
      #while( Cnt < 360 )
        box{ <-0.353,-0.353,-0.035>, <0.353,0.353,0.035> rotate 45*z translate 2*y rotate Cnt*x }
        object{ Nut1 scale 0.8 rotate -90*z translate 2.25*y rotate 22.5*x rotate Cnt*x }
        #declare Cnt = Cnt + 45
      #end translate 1.6*y }
    cylinder{ <-0.2,1.6,0>, <0.6,1.6,0>, 2.07   }
    intersection{
      torus{ 3,2.07 rotate -90*x }
      box{ <0,-10,-10>, <10,0,10> } translate <2,4.6,0>}
    object{ Stairs translate <4.2,4.8,0> }
    texture { Simple2 }}

#declare Port_lock =
union{
  difference{
    cylinder{ <-0.2,1.3,0>, <0,1.3,0>, 1.5 }
    intersection{
      cylinder{ <-0.3,1.3,0>, <0.1,1.3,0>, 0.75 }
      plane{ -z, 0.5 }}}
  torus{ 1, 0.05 rotate -90*z translate <0,1.3,0> }
  union{
    #declare Cnt=0
    #while( Cnt < 360 )
      #if(( Cnt - 135 )*( Cnt - 180 ))
        object{ Nut1 scale 0.7 rotate -90*z translate 1.25*y rotate 22.5*x rotate Cnt*x }
      #else
      #end
      #declare Cnt = Cnt + 45
    #end translate 1.3*y }
  sphere{<-1.1,1.3,0>, 1.25 }
  cylinder{ <0,0.85,-0.5>, <0,1.75,-0.5>, 0.08 }
  torus{ 0.4, 0.03 rotate -90*z translate <0.4,1.3,0> }
  cylinder{ <0,1.3,0>, <0.3,1.3,0>, 0.08 }
  union{
    #declare Cnt=0
    #while( Cnt < 360 )
      cylinder{ <0,0,0>, <0.1,0.4,0>, 0.03 rotate -20*x rotate Cnt*x }
      #declare Cnt = Cnt + 120
    #end translate <0.3,1.3,0> }
   texture{ Simple2 }}

#declare Port_lock_opened =
union{
  difference{
    cylinder{ <-0.2,1.3,0>, <0,1.3,0>, 1.5 }
    intersection{
      cylinder{ <-0.3,1.3,0>, <0.1,1.3,0>, 0.75 }
      plane{ -z, 0.5 }}}
  torus{ 1, 0.05 rotate -90*z translate <0,1.3,0> }
  union{
    #declare Cnt=0
    #while( Cnt < 360 )
      #if(( Cnt - 135 )*( Cnt - 180 ))
        object{ Nut1 scale 0.7 rotate -90*z translate 1.25*y rotate 22.5*x rotate Cnt*x }
      #else
      #end
      #declare Cnt = Cnt + 45
    #end translate 1.3*y }
  union{
    intersection{
      sphere{<-1.1,1.3,0>, 1.25 }
      cylinder{ <-0.2,1.3,0>, <1,1.3,0>, 0.75 }}
    cylinder{ <0,0.85,-0.5>, <0,1.75,-0.5>, 0.08 }
    torus{ 0.4, 0.03 rotate -90*z translate <0.4,1.3,0> }
    cylinder{ <0,1.3,0>, <0.3,1.3,0>, 0.08 }
    union{
      #declare Cnt=0
      #while( Cnt < 360 )
        sphere{ <1.25,0,0>, 0.03 rotate -30*y rotate Cnt*x }
        #declare Cnt = Cnt + 20
      #end translate <-1.1,1.3,0> }
    union{
      #declare Cnt=0
      #while( Cnt < 360 )
        cylinder{ <0,0,0>, <0.1,0.4,0>, 0.03 rotate -20*x rotate Cnt*x }
        #declare Cnt = Cnt + 120
      #end translate <0.3,1.3,0> } translate 0.5*z rotate 60*y translate -0.5*z }
   texture{ Simple2 }}

#declare Half_base = 0.4
#declare Half_width = Half_base/10
#declare Port_tower_element1 =
  box{ <-Half_width,-sqrt(2)*Half_base,-Half_width>, <Half_width,sqrt(2)*Half_base,Half_width>
       texture{ Simple2 }}
#declare Port_tower_element2 =
  union{
    object{ Port_tower_element1 rotate  45*z }
    object{ Port_tower_element1 rotate -45*z }
    }
#declare Port_tower_element3 =
  difference{
    box{ <-(Half_base+Half_width),0,-(Half_base+Half_width)>,
         <Half_base+Half_width,2*Half_base+Half_width,Half_base+Half_width> }
    union{
      box{ <-(Half_base-Half_width),-Half_width,-(Half_base+2*Half_width)>,
           <Half_base-Half_width,2*Half_base-Half_width,Half_base+2*Half_width> }
      box{ <-(Half_base-Half_width),-Half_width,-(Half_base+2*Half_width)>,
           <Half_base-Half_width,2*Half_base-Half_width,Half_base+2*Half_width> rotate 90*y }
      box{ <-(Half_base-Half_width),-Half_width,-(Half_base-Half_width)>,
           <Half_base-Half_width,2*(Half_base+Half_width),Half_base-Half_width> rotate 90*y }}
    texture{ Simple2 }}
#declare Port_tower_element =
  union{
    object{ Port_tower_element3 }
    object{ Port_tower_element2 translate <0,0,-Half_base> }
    object{ Port_tower_element2 translate <0,0,-Half_base> rotate  90*y }
    object{ Port_tower_element2 translate <0,0,-Half_base> rotate 180*y }
    object{ Port_tower_element2 translate <0,0,-Half_base> rotate 270*y }}
#declare Port_tower =
  union{
    object{ Port_tower_element }
    object{ Port_tower_element translate 2*Half_base*y }
    object{ Port_tower_element translate 4*Half_base*y }
    object{ Port_tower_element translate 6*Half_base*y }
    object{ Port_tower_element translate 8*Half_base*y }
    object{ Port_tower_element translate 10*Half_base*y }
    object{ Port_tower_element translate 12*Half_base*y }
    object{ Port_tower_element translate 14*Half_base*y }
    object{ Lamp70 scale 2 translate <0,17*Half_base,0> }}

#declare UPort =
union{
  object{ Port_building }
  object{ Port_tower    translate <-1.2,8,67> }
  object{ Port_moorage  translate 12*z }
  object{ Port_moorage  translate 32*z }
  object{ Port_moorage  translate 52*z }
  object{ Port_lock     translate  7*z }
  object{ Port_lock_opened     translate 27*z }
  object{ Port_lock     translate 47*z }
  }

