// At the Lake -- 10/29/98, Discord
// Height field .gifs created using Fractint for Windows
// Render time 5:04, pentium 166, 32M RAM
// povray verion 3.0
#include "colours.inc"

light_source {
  <120,100,-15>
  color PaleYellow
  }
  
camera {
  location <0,5,-12>
  look_at <0,5,25>
  }

sky_sphere {
  pigment {
    bozo
    turbulence .75
    color_map {
      [0.0 color DaySky]
      [0.2 color White]
      [0.3 color White*.9]
      [0.4 color DaySky]
      [0.7 color White*.85]
      [0.75 color White*.9]
      [0.8 color DaySky]
      [1.0 color White]
      }
    scale 2.5
    }
}

#declare Lake=
plane {
  y,-29
  pigment {
    waves
    turbulence .8
    color_map {
      [0.0 color rgbt <.1,.3,.7,.45>]
      [0.1 color rgbt <.4,.7,.8,.35>]
      [0.5 color rgbt <.1,.35,.7,.7>]
      [0.7 color rgbt <.1,.3,.7,.45>]
      [1.0 color rgbt <0,.25,.8,.45>]
      }
    scale 5
    }
  finish {ior 2.5 reflection .15 }
}

#declare FrontGrass=
height_field {
  gif "imagery/height1.gif"
  smooth
  pigment {
    marble
    turbulence .3
    color_map {
      [0.0 color Green]
      [0.1 color Green*1.1]
      [0.3 color Green*1.3]
      [0.5 color PaleGreen*.8]
      [0.8 color Green*1.5]
      [1.0 color PaleGreen]
      }
     rotate y*90
    }
  finish { ambient .2 phong .5 phong_size .25 }
  scale <45,10,10>
  translate <-20,-16.5,0>
  rotate x*-25
}

height_field {
  gif "include/imagery/height2.gif"
  smooth
  pigment {
    marble
    turbulence .75
    color_map {
      [0.0 color DarkChoc]
      [0.25 color Cinnamon]
      [0.5 color MilkChoc]
      [0.75 color Cinnamon]
      [0.9 color DeepGreen]
      [1.0 color Black]
      }
    scale .1
    }
  rotate x*150
  scale <13,20,20>
  translate <-17,-2,18>
  }

object { Lake }
object { FrontGrass }
