
// Glenn's POV-Ray Scene File - Water Trick Scene 2
// created 22-Sep-98 for the Internet Raytracing Competition (www.irtc.org)
// last update 22-Sep-98
// copyright 1998 Glenn McCarter (gmccarter@hotmail.com)
//
// Water Loop
//
// scene origin is at the center of the table under the loop

                                                   
#include "GIncludeRH.inc"
//#include "GRuler.inc"
#include "GObjectsRH31.inc"
#include "Sink.inc"

#version 3.1;
global_settings {
	adc_bailout 0.003922
	ambient_light <1.0,1.0,1.0>
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
  /* // Radiosity section: uncomment this to enable radiosity
  // calculations; must also turn on radiosity in your ini file.
	radiosity {
		brightness       3.3
		count            100
		distance_maximum 5
		error_bound      0.4
		gray_threshold   0.5
		low_error_factor 0.8
		minimum_reuse    0.015
		nearest_count    6
		recursion_limit  1
	}
  */ // end radiosity section
}

//===============================================
//             Variables
//===============================================

#declare LocalOrigin = <-24,-46,-4>;

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
	/* // Focal Blur section: uncomment to enable focal blur
		blur_samples 6
		aperture .5    //lower value = wider range in focus
		focal_point <0,0,0>
	*/ // end focal blur
	location  LocalOrigin+<-8, -6, 7> // render view
	look_at   LocalOrigin+<0, 0, 3.5>
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 60
//	location  <-16, -5, 9> // origin view
//	look_at   <0.0, 0.0, 0.0>
	location  <-12, -1, 7> // render view
	look_at   <0, 0, 3.5>
	}

camera {
//	Special_Cam
	Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BackDropTex =
	texture {
//		pigment { color rgb<.050,.042,.030> } // render
		pigment { color rgb<.00,.00,.00> } // test
		normal { bumps .25 scale 8 }
		finish { ambient .62 diffuse .7 specular .10 roughness .05 }
	}

#declare WaterTex =
	texture {
//		pigment { color rgb<.3,.3,1> } // test blue
		pigment { color rgbt<.68,.80,1,.8> } // mostly clear
		normal { bumps .3 scale 2 }
		finish { ambient .1 diffuse .2 specular .9 roughness .002 reflection .1 }
	}
#declare WaterInt =
	interior {
		ior 1.3
		caustics 1.0
	}
#declare WaterMat =
	material {
	 texture { WaterTex }
	 interior { WaterInt }
	}           
           
//===============================================
//             Lighting
//===============================================

object {StdBulb60Watt translate <4*Feet,0*Feet,4.5*Feet> }
object {StdBulb60Watt translate <-10*Feet,0*Feet,4.5*Feet> }
#declare FillSpot =
	light_source {
		<0,-2*Feet,4*Feet>
		color rgb <.39, .36, .25>
		spotlight
		point_at <0,0,5>
		radius 4    // degrees fully lit (*2)
		falloff 12   // degrees no lighting (*2)
		tightness 1
	}
object { FillSpot translate LocalOrigin }

//===============================================
//             Environment
//===============================================

background { color rgb <0.0, 0.0, 0.0> } // black
//object {GroundPlaneWhite translate z*-0}

#declare Ceiling = // for reflection
	box {
		<-18*Feet,-18*Feet,0>,<18*Feet,18*Feet,1>
		texture {
			pigment { color rgb<1,1,1> }
			finish { ambient .8 }
		}
	}
object { Ceiling rotate z*-40 translate <0,0,5*Feet> }

#declare BDRad = 2*Feet;
#declare BDHeight = 5*Feet;
#declare BackDropPaper =
	difference {
		box { // main
			<-80*Feet,-80*Feet,-80*Feet>,<80*Feet,80*Feet,BDHeight>
		}
		box { // upper
			<-88*Feet,-88*Feet,BDRad>,<0,88*Feet,BDHeight+1>
		}
		box { // lower
			<-88*Feet,-88*Feet,0>,<-BDRad,88*Feet,BDHeight+1>
		}
		cylinder { // corner radius
			<-BDRad,-88*Feet,BDRad>,<-BDRad,88*Feet,BDRad>,BDRad
		}
		texture { BackDropTex }
	}
object { BackDropPaper rotate z*40 translate <5*Feet,0,-30> }

//===============================================
//             Objects
//===============================================

#declare SinkGroup =
	union {
		object { DeepSink }
		object { ArchFaucet(12,10) translate <0,14,0> }
	}

#local CornerRad = 2.4;
#local EdgeRad = 1.1;
#declare TableTop =
	union {

		difference {
			box {
				<-24,-15,-1>,<24,15,0>
			}
			cylinder { <-24,-15,-2>,<-24,-15,2>,CornerRad } // corner cutout
			cylinder { <-24, 15,-2>,<-24, 15,2>,CornerRad }
			cylinder { < 24,-15,-2>,< 24,-15,2>,CornerRad }
			cylinder { < 24, 15,-2>,< 24, 15,2>,CornerRad }
		} // end difference

		cylinder { <-24+CornerRad,-15,-EdgeRad>,< 24-CornerRad,-15,-EdgeRad>,EdgeRad } // edge
		cylinder { <-24+CornerRad, 15,-EdgeRad>,< 24-CornerRad, 15,-EdgeRad>,EdgeRad }
		cylinder { <-24,-15+CornerRad,-EdgeRad>,<-24, 15-CornerRad,-EdgeRad>,EdgeRad }
		cylinder { < 24,-15+CornerRad,-EdgeRad>,< 24, 15-CornerRad,-EdgeRad>,EdgeRad }

		torus { CornerRad,EdgeRad rotate x*90 translate <-24+CornerRad,-15+CornerRad,-EdgeRad> } // corner
		torus { CornerRad,EdgeRad rotate x*90 translate <-24+CornerRad, 15-CornerRad,-EdgeRad> }
		torus { CornerRad,EdgeRad rotate x*90 translate < 24-CornerRad,-15+CornerRad,-EdgeRad> }
		torus { CornerRad,EdgeRad rotate x*90 translate < 24-CornerRad, 15-CornerRad,-EdgeRad> }

		cylinder { <-24+CornerRad,-15+CornerRad,-1>,<-24+CornerRad,-15+CornerRad,0>,CornerRad } // corner fill
		cylinder { <-24+CornerRad, 15-CornerRad,-1>,<-24+CornerRad, 15-CornerRad,0>,CornerRad }
		cylinder { < 24-CornerRad,-15+CornerRad,-1>,< 24-CornerRad,-15+CornerRad,0>,CornerRad }
		cylinder { < 24-CornerRad, 15-CornerRad,-1>,< 24-CornerRad, 15-CornerRad,0>,CornerRad }

		texture { GWoodTex finish{reflection .08} scale 3 rotate y*90}
	}


#declare BT  = 0.5; // Blob Threshold
#declare BRF = 0.3;  // Blob Radius Factor
#declare BSF = 1.0;  // Blob Strength Factor
#declare BNSF = 24.0; // Negative Strength Factor ( divisor )
#declare RS = seed(98543);
               
#declare WaterLoop =
	blob {
		threshold BT
		#declare BallCount = 1;
		#while ( BallCount < 90 )
			sphere {
				<0,0,0>,BRF*2.2,BSF
				scale <.8+rand(RS)*.1,.8+rand(RS)*.1,.8+rand(RS)*.1>
				translate <-.10+rand(RS)*.20,-.10+rand(RS)*.20,-.10-rand(RS)*.20> // jiggle
				translate <0,0,-3.0>
				rotate <BallCount*4,0,0>
			}
			#declare BallCount = BallCount +1;
		#end
		material { WaterMat }
	}

#declare BlobSpill =
	blob {
		threshold BT
		#declare BCount = 1;
		#while ( BCount < 8 )
			sphere {
				<0,0,0>,BRF*2.2,BSF
				translate <-.5+rand(RS)*1,-.5+rand(RS)*1,0>
			}
			#declare BCount = BCount + 1;
		#end			
		scale <3,1.2,.2>
		rotate z*90
		material { WaterMat }
	}

//===============================================
//             Object Placement
//===============================================
 
#declare LocalGroup =
	union {
		object { TableTop scale 1 rotate -z*40 translate <-17,3,0> }
		object { WaterLoop rotate <0,0,50> translate <0,0,3.5> }
		object { BlobSpill rotate <0,0,50> translate <0,0,.1> }
	}
object { LocalGroup translate LocalOrigin }
object { SinkGroup }


