
// Persistence of Vision Ray Tracer Scene Description File
// File: awater?.pov
// Vers: 3
// Desc: WATER was the subject, which inspired me to create an environment without any water
//       the water here is ment to be kind of a Fata Morgana.
// Date: sept 1998
// Auth: Alfred Houdijk
// As my first entry in the International Ray Tracing Competition

#version 3

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare IMPORT_SPATCH = 1
#include "wijnglas1.pov"
#include "waterkan1.pov"
#include "skull3.pov"
#include "bone1.pov"
#include "bone2.pov"

// Water texture based on Glass of Norm Bowler out of original POV include file
#declare AHWater =
texture {
    pigment { color rgbf <1,1,1, 1> }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection .125
        refraction 1
        ior 1.33
        specular 1
        roughness .001
//        fade_distance 5000
//        fade_power 2
        caustics 1
    }
}

// based on original POV include file
#declare AHGlass3 =
texture {
    pigment { color rgbf <1,1,1, 0.98> }
    finish  {
        ambient 0.1
        diffuse 0.1
        reflection 0.1
        refraction 0.9
        ior 1.5
        specular 0.8
        roughness 0.0003
        phong 1
        phong_size 400
        caustics 2
     }
}

global_settings
{
  assumed_gamma 1.0
  ambient_light White
}

// ----------------------------------------
camera
{
  location  <0.0, 1.5, -6.0> // y was 2
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 1.0,  0.0>

  focal_point < 0, 1, 1.5>    // glass of water in focus
  aperture 0.1     // a nice compromise 
  //  aperture 0.05    // almost everything is in focus
  //  aperture 1.5     // much blurring
//    with normal aa 4.35.24 awaterD2.jpg
//    blur_samples 4       // fewer samples, faster to render
//    blur_samples 20      // more samples, higher quality image 7.54.08 awaterC.jpg
    blur_samples 30      // more samples, higher quality image 8.14.23

 }



sky_sphere
{
  pigment
  {
    gradient y
    color_map { [ 0.0 color rgb 1 ]      // [0.0 color red 0.3 green 0.6 blue 0.7]  // was b=0.6
                [1.0 color blue 0.6] }
  }
}

#declare Sun =

// create a sphere shape
sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
  0.5       // radius of sphere
pigment { color White }
finish { ambient rgb <1,1,1> }
scale 3
}


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate  <15,11,50> // <-5, 13, 100> // was
  looks_like { Sun }
}



// ----------------------------------------
height_field {
    tga "c:\images\pov\height.tga"
    smooth
    texture {
    pigment { color Sienna           // rgb <0.7,0.5,0.3>
     }
    // normal { bumps 0.8 scale .02 }
     finish { crand 0.05 }
    }
    translate <-.425, -.5, -0.051>
    scale <170, 6.0, 170>
  }

union {
object { Skull3 //texture { pigment { color White }}
         scale <1.6,1.6,1.6>
         rotate <-8,0,-50>
         translate <-2.1,0,4>
         }
object { Bone1 //texture { pigment { color White }}
         scale <0.4, .40, 0.8>
         rotate <-90,31,-50>
         translate <-1.2,-0.60,2>
         }
object { Bone2 //texture { pigment { color White }}
         scale <0.5, 1.0, 0.5>
         rotate <0,0,-51>
         translate <-1, -0.60, 1.5>
         }
  texture { T_Stone17 scale .4}
translate <-.2,-1,0>
}


union {
 object { Wijnglas texture { AHGlass3 }
         translate <0,-0.9,0.5> }

 object { Waterkan texture { AHGlass3 }
         scale 0.5
         rotate <0,190,0>  // was 190
         translate <1.5,-0.9,1.9> }  // was <1.2,-0.9,2.0>
 translate <0.45, 0, .50>
 }

// tray
difference {
  intersection {
     sphere {  <0, 0, 0>  0.5  }
      cylinder {  -0.1*y,  0.1*y,  1.1 }
  }
  torus {  0.440,  0.01
      translate <0,0.1,0>
      }
texture { EMBWood1 scale .02 rotate 23*y translate <0,0.1,0>}
scale <4,1,4>
translate <1.5,-1,2>
}

/*
fog {  // reversed ground fog, so "air-fog"
    distance 500  // was 125
    colour rgbf<1,1,0.9, 0.20>
    fog_type 2
    fog_offset 5.5
    fog_alt 2
    turbulence 0.2
    turb_depth 0.2
    rotate <180,0,0>
  }
*/

 fog { // ground
    distance 50 // was 150
    colour rgbf <0.8, 0.6, 0.4, 0.3>
    fog_type 2
    fog_offset 1.4
    fog_alt 1
    turbulence 0.1
    turb_depth 0.2
  }

// Pyramid 1
 #declare Maxcount = 50
 #declare Scalefact =.2
 #declare Count=1
  #while (Count < Maxcount)

    box
    {
    <-Count, 0, -Count>  // one corner position <X1 Y1 Z1>
    < Count,  1,  Count>  // other corner position <X2 Y2 Z2>
    rotate <0,34,0>
    scale Scalefact
    translate <0, Scalefact*(Maxcount-Count) ,50>
    texture {
       pigment { color Gray50 }
       normal { bumps 0.4 scale 0.2 }
       finish {  crand .05 }
       }
    }
    #declare Count=Count+1
  #end

// Pyramid 2
 #declare Maxcount = 50
 #declare Scalefact =.2
 #declare Count=1
  #while (Count < Maxcount)

    box
    {
    <-Count, 0, -Count>  // one corner position <X1 Y1 Z1>
    < Count,  1,  Count>  // other corner position <X2 Y2 Z2>
    rotate <0,34,0>
    scale Scalefact
    translate <-16, Scalefact*(Maxcount-Count) ,90>
    texture {
       pigment { color Gray50 }
       normal { bumps 0.4 scale 0.2 }
       finish {  crand .05 }
       }
    }
    #declare Count=Count+1
  #end

