#local Thickness = .02;
#local Thick2 = .1;
#local Width = .6;
#local Depth = .75;
#local Hole = <Width-Thick2*2,0,Depth-Thick2*2>;
#local Plate = union {
	difference {
		box {<-Width,-Thickness,-Depth>,<Width,Thickness,Depth>}
		cylinder {<-Hole.x,-Thickness*2,-Hole.z>,	<-Hole.x, Thickness*2,-Hole.z>,	Thick2}
		cylinder {<-Hole.x,-Thickness*2, 0>,		<-Hole.x, Thickness*2, 0>,			Thick2}
		cylinder {<-Hole.x,-Thickness*2, Hole.z>,	<-Hole.x, Thickness*2, Hole.z>,	Thick2}
	}
	torus {Thick2,Thickness translate <-Hole.x, 0,-Hole.z>}
	torus {Thick2,Thickness translate <-Hole.x, 0, 0>}
	torus {Thick2,Thickness translate <-Hole.x, 0, Hole.z>}
	sphere {<-Width,0,-Depth>, Thickness}
	sphere {<-Width,0, Depth>, Thickness}
	sphere {< Width,0,-Depth>, Thickness}
	sphere {< Width,0, Depth>, Thickness}
	cylinder {<-Width, 0,-Depth>,<-Width, 0, Depth>, Thickness}
	cylinder {< Width, 0,-Depth>,< Width, 0, Depth>, Thickness}
	cylinder {<-Width, 0,-Depth>,< Width, 0,-Depth>, Thickness}
	cylinder {<-Width, 0, Depth>,< Width, 0, Depth>, Thickness}
}

#local GoldTexture = texture {
	pigment {color rgb <.75,.75,.25> quick_color rgb <1,1,0>}
	finish {
		specular 1
		reflection <.75,.75,.25>/4
		metallic
	}
}

#local GoldTexture2 = texture {
	pigment {
		image_map {
			sys "bcwater.bmp"
		}
		quick_color rgb <1,1,0>
	}
	finish {
		specular 1
		reflection <.75,.75,.25>/4
		metallic
	}
	translate -.5
	rotate x*90
	scale <Width,1,Depth>*2
}

#local Sealed = 14;
#local Unsealed = 7;

#declare Book = union {
/*
	The sealed plates.
*/
	#local Count = 0;
	#while (Count < Sealed)
		object {Plate translate y*Count*Thickness*2}
	#local Count = Count + 1;
	#end

/*
	The sealing bands.
*/
	// The top & bottom plates.
	union {
		#local Height = (Count+1)*Thickness*2;
		box {		 <-Width-Thickness, Count*Thickness*2,	-Hole.z+Thick2>,	<Width+Thickness, Height,-Thick2>}
		box {		 <-Width-Thickness, Count*Thickness*2,	 Hole.z-Thick2>,	<Width+Thickness, Height, Thick2>}
		box {		 <-Width-Thickness,-Thickness*2,			-Hole.z+Thick2>,	<Width+Thickness, 0,		-Thick2>}
		box {		 <-Width-Thickness,-Thickness*2,			 Hole.z-Thick2>,	<Width+Thickness, 0,		 Thick2>}
	}
	union {
		#local Height = (Count + .5)*Thickness*2;
		cylinder {<-Width-Thickness, Height,				-Hole.z+Thick2>,	<Width+Thickness, Height,-Hole.z+Thick2>, Thickness}
		cylinder {<-Width-Thickness, Height,				 Hole.z-Thick2>,	<Width+Thickness, Height, Hole.z-Thick2>, Thickness}
		cylinder {<-Width-Thickness, Height,				-Thick2>,			<Width+Thickness, Height,-Thick2>,			Thickness}
		cylinder {<-Width-Thickness, Height,				 Thick2>,			<Width+Thickness, Height, Thick2>,			Thickness}
	}
	union {
		#local Height = -Thickness*2;
		cylinder {<-Width-Thickness, Height,				-Hole.z+Thick2>,	<Width+Thickness, Height,-Hole.z+Thick2>, Thickness}
		cylinder {<-Width-Thickness, Height,				 Hole.z-Thick2>,	<Width+Thickness, Height, Hole.z-Thick2>, Thickness}
		cylinder {<-Width-Thickness, Height,				-Thick2>,			<Width+Thickness, Height,-Thick2>,			Thickness}
		cylinder {<-Width-Thickness, Height,				 Thick2>,			<Width+Thickness, Height, Thick2>,			Thickness}
	}

	// The side plates.
	#local Height = (Count-.5)*Thickness*2;
	union {
		box {<-Width-Thickness*4,0,-Hole.z+Thick2>,<-Width-Thickness*2,Height,-Thick2>}
		box {<-Width-Thickness*4,0, Hole.z-Thick2>,<-Width-Thickness*2,Height, Thick2>}
	}
	union {
		box {< Width+Thickness*4,0,-Hole.z+Thick2>,< Width+Thickness*2,Height,-Thick2>}
		box {< Width+Thickness*4,0, Hole.z-Thick2>,< Width+Thickness*2,Height, Thick2>}
	}
	#local XX = Width+Thickness*3;
	union {
		cylinder {<-XX,0,-Hole.z+Thick2>,<-XX,Height,-Hole.z+Thick2>,	Thickness}
		cylinder {<-XX,0,-Thick2>,			<-XX,Height,-Thick2>,			Thickness}
		cylinder {<-XX,0, Hole.z-Thick2>,<-XX,Height, Hole.z-Thick2>,	Thickness}
		cylinder {<-XX,0, Thick2>,			<-XX,Height, Thick2>,			Thickness}
	}
	union {
		cylinder {< XX,0,-Hole.z+Thick2>,< XX,Height,-Hole.z+Thick2>,	Thickness}
		cylinder {< XX,0,-Thick2>,			< XX,Height,-Thick2>,			Thickness}
		cylinder {< XX,0, Hole.z-Thick2>,< XX,Height, Hole.z-Thick2>,	Thickness}
		cylinder {< XX,0, Thick2>,			< XX,Height, Thick2>,			Thickness}
	}
	
	// The top corners.
	#local Height = (Count-.5)*Thickness*2;
	intersection {
		union {
			difference {
				cylinder {<-Width-Thickness,Height,				-Hole.z+Thick2>,	<-Width-Thickness,	Height,					Hole.z-Thick2>, Thickness*3}
				cylinder {<-Width-Thickness,Height,				-Hole.z>,			<-Width-Thickness,	Height,					Hole.z>,			 Thickness}
				box		{<-Width+Thickness,Height-Thickness,-Thick2>,			<-Width-Thickness*5, Height+Thickness*5,	Thick2>}
	   	}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,Height,-Hole.z+Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,Height, Hole.z-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,Height,-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,Height, Thick2>}
   	}
		box{<-Width-Thickness,Height,-Hole.z>,<-Width-Thickness*5,Height+Thickness*5,Hole.z>}
   }
	intersection {
		union {
			difference {
				cylinder {<Width+Thickness,Height,				-Hole.z+Thick2>,	<Width+Thickness,		Height,					Hole.z-Thick2>, Thickness*3}
				cylinder {<Width+Thickness,Height,				-Hole.z>,			<Width+Thickness,		Height,					Hole.z>,			 Thickness}
				box		{<Width-Thickness,Height-Thickness, -Thick2>,			<Width+Thickness*5,	Height+Thickness*5,	Thick2>}
	   	}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,Height,-Hole.z+Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,Height, Hole.z-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,Height,-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,Height, Thick2>}
   	}
		box{<Width+Thickness,Height,-Hole.z>,<Width+Thickness*5,Height+Thickness*5,Hole.z>}
   }
   // The bottom corners.
	#local Height = -Thickness*2;
	intersection {
		union {
			difference {
				cylinder {<-Width-Thickness,0,			-Hole.z+Thick2>,	<-Width-Thickness,	0,					Hole.z-Thick2>, Thickness*3}
				cylinder {<-Width-Thickness,0,			-Hole.z>,			<-Width-Thickness,	0,					Hole.z>,			 Thickness}
				box		{<-Width+Thickness,Thickness,	-Thick2>,			<-Width-Thickness*5, -Thickness*5,	Thick2>}
	   	}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,0,-Hole.z+Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,0, Hole.z-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,0,-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <-Width-Thickness,0, Thick2>}
   	}
		box{<-Width-Thickness,0,-Hole.z>,<-Width-Thickness*5,-Thickness*5,Hole.z>}
   }
	intersection {
		union {
			difference {
				cylinder {<Width+Thickness,0,				-Hole.z+Thick2>,	<Width+Thickness,		0,					Hole.z-Thick2>, Thickness*3}
				cylinder {<Width+Thickness,0,				-Hole.z>,			<Width+Thickness,		0,					Hole.z>,			 Thickness}
				box		{<Width-Thickness,Thickness,	-Thick2>,			<Width+Thickness*5,	-Thickness*5,	Thick2>}
	   	}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,0,-Hole.z+Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,0, Hole.z-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,0,-Thick2>}
	   	torus {Thickness*2, Thickness rotate x*90 translate <Width+Thickness,0, Thick2>}
   	}
		box{<Width+Thickness,0,-Hole.z>,<Width+Thickness*5,-Thickness*5,Hole.z>}
   }

/*
	The unsealed plates.
*/
	union {
		#local Count = Sealed+1;
		#while (Count < Sealed+1+Unsealed)
			object {Plate translate y*Count*Thickness*2}
		#local Count = Count + 1;
		#end
		texture {GoldTexture2}
	}

/*
	The binding loops.
*/
	union {
		#local Height = (Count+1)*Thickness*2;
		cylinder {<-Hole.x,-Thickness*2,-Hole.z>,	<-Hole.x,Height,-Hole.z>,	Thick2/3}
		cylinder {<-Hole.x,-Thickness*2, 0>,		<-Hole.x,Height, 0>,			Thick2/3}
		cylinder {<-Hole.x,-Thickness*2, Hole.z>,	<-Hole.x,Height, Hole.z>,	Thick2/3}
		cylinder {<-Width-Thick2*3,-Thickness*2,-Hole.z>,	<-Width-Thick2*3,Height,-Hole.z>,	Thick2/3}
		cylinder {<-Width-Thick2*3,-Thickness*2, 0>,			<-Width-Thick2*3,Height, 0>,			Thick2/3}
		cylinder {<-Width-Thick2*3,-Thickness*2, Hole.z>,	<-Width-Thick2*3,Height, Hole.z>,	Thick2/3}
		difference {
			union {
				torus {Thick2*2.5,Thick2/3 rotate x*90 translate <-Width-Thick2/2,Height,-Hole.z>}
				torus {Thick2*2.5,Thick2/3 rotate x*90 translate <-Width-Thick2/2,Height, 0>}
				torus {Thick2*2.5,Thick2/3 rotate x*90 translate <-Width-Thick2/2,Height, Hole.z>}
			}
			plane {y,Height}
		}
		#local Height = Thickness*2;
		difference {
			union {
				torus {Thick2*2.5,Thick2/3 rotate x*90 translate <-Width-Thick2/2,-Height,-Hole.z>}
				torus {Thick2*2.5,Thick2/3 rotate x*90 translate <-Width-Thick2/2,-Height, 0>}
				torus {Thick2*2.5,Thick2/3 rotate x*90 translate <-Width-Thick2/2,-Height, Hole.z>}
			}
			plane {-y,Height}
		}
	}

/*
	The texture.
*/
	texture {GoldTexture}
	translate y*Thickness*2
}

#declare MarbPig = pigment {
	agate
	agate_turb 1
	color_map {
		[0 color blue .5]
		[1 color rgb 1.5]
	}
	scale .25
	quick_color rgb 1
}

#declare DMarbPig = pigment {
	agate
	agate_turb 1
	color_map {
		[0 color blue .25]
		[1 color rgb .75]
	}
	scale .25
	quick_color rgb 1
}

#declare MarbTex = texture {
	pigment {MarbPig}
	finish {
		reflection .6
		specular 1
	}
}
#declare DMarbTex = texture {
	pigment {DMarbPig}
	normal {
		granite 2
		scale .1
	}
}

#declare StTex1 = texture {
	gradient y
	texture_map {
		[0 DMarbTex]
		[.2 DMarbTex]
		[.8 MarbTex]
		[1 MarbTex]
	}
	scale 1.43
	translate -y*1.125
}	

#declare Stand = difference {
	box 		{<-1.625,-5,-2.125>,	<2.125,	.3,5>}
	cylinder {<-1.625,.3,-2.2>,	<-1.625,	.3,5>,		1.125}
	cylinder {<2.125,	.3,-2.2>,	<2.125,	.3,5>,		1.125}
	cylinder {<-1.625,.3,-2.125>,	<2.125,	.3,-2.125>,	1.125}
	texture {
		gradient z
		texture_map {
			[0 StTex1 scale 1/3]
			[.4 StTex1 scale 1/3]
			[.8 DMarbTex scale 1/3]
			[1 DMarbTex scale 1/3]
		}
		scale 3
		translate z*-1
	}
}

#declare Room = union {
	difference {
		sphere {
			<0,0,-2.5>,4.5
			inverse
		}
		plane {y,0}
	}
	difference {
		sphere {
			<0,0,-2.5>,4.5
			inverse
			scale <1,.17,1>
		}
		plane {-y,0}
	}
	pigment {DMarbPig quick_color rgb .5}
	normal {
		granite 2
		scale .1
	}
}

#include "lights.inc"
#macro Pixie (a,b,c,d)
sphere {
	0,.4
	pigment {color transmit 1 quick_color rgb 1}
	finish {ambient 1}
	hollow
	interior {
		media {
			intervals 15
			samples 1,5
			emission a
			density {
				spherical
			}
			scale .4
		}			
	}
	translate b
}
light_sphere_atten(b,.4,a,d,2,c)
#end

/*
	a : angle about y axis to rotate.
	b : number of segments.
	c : thickness
	d : number of random stops
	e : "crawl" amount
	f : seed number
*/
#include "read.inc"
#macro Vine (A,B,C,D,E,F)
union {
	#local Ra = seed(F);
	#local Ar = array [D]
	#local Count = 0;
	#while (Count < D)
		#local Ar[Count] = (rand(Ra)-.5)*E;
	#local Count = Count + 1;
	#end

	#local Count = 0;
	#local CC = C*pow(1-(Count/B),2);
	#local Cur = vrotate(vrotate(<-4.5+CC,0,0>,-z*Count/B*90),y*(A+Spline(Count/B,Ar)))-z*2.5;
	sphere {Cur,C}
	#while (Count < B)
	#local Count = Count + 1;
		#local Old = Cur;
		#local OldCC = CC;
		#local CC = C*pow(1-(Count/B),2);
		#local Cur = vrotate(vrotate(<-4.5+CC,0,0>,-z*Count/B*90),y*(A+Spline(Count/B,Ar)))-z*2.5;
		union {
			cone{Old,OldCC,Cur,CC}
			sphere{Cur,CC}
			bounded_by {box{<min(Old.x-OldCC,Cur.x-CC),min(Old.y-OldCC,Cur.y-CC),min(Old.z-OldCC,Cur.z-CC)>,<max(Old.x+OldCC,Cur.x+CC),max(Old.y+OldCC,Cur.y+CC),max(Old.z+OldCC,Cur.z+CC)>}}
		}
	#end
	
	#undef Ar
	#undef Count
	texture {
		pigment {
			color green .5
		}
		normal {
			wrinkles .5
			scale .025
		}
	}
}
#end

#local CS = .25; // CornerSize
#local C11 = <-1.1+CS,	1.75-CS,-1.1+CS>;	#local D11 = <-1.1+CS,	-5,-1.1+CS>;
#local C12 = <-1.1+CS,	1.75-CS, 1.1-CS>; #local D12 = <-1.1+CS,	-5, 1.1-CS>;
#local C21 = < 1.1-CS,	1.75-CS,-1.1+CS>; #local D21 = < 1.1-CS,	-5,-1.1+CS>;
#local C22 = < 1.1-CS,	1.75-CS, 1.1-CS>; #local D22 = < 1.1-CS,	-5, 1.1-CS>;
#declare Case = merge {
	box {<-1.1+CS,	-5,-1.1>,	<1.1-CS,	1.75-CS,	1.1>}
	box {<-1.1,		-5,-1.1+CS>,<1.1,		1.75-CS,	1.1-CS>}
	box {<-1.1+CS,	-5,-1.1+CS>,<1.1-CS,	1.75,		1.1-CS>}
	sphere {C11,CS}
	sphere {C12,CS}
	sphere {C21,CS}
	sphere {C22,CS}
	cylinder {C11,C12,CS}
	cylinder {C11,C21,CS}
	cylinder {C22,C12,CS}
	cylinder {C22,C21,CS}
	cylinder {C11,D11,CS}
	cylinder {C12,D12,CS}
	cylinder {C21,D21,CS}
	cylinder {C22,D22,CS}
	texture {
		pigment {color rgbt<1,1,1,.75> quick_color rgb 1}
		finish {
			specular 1
		}
	}
	bounded_by {box {<-1.1,-5,-1.1>,<1.1,1.75,1.1>}}
}

#declare Water = difference {
	plane {y,0}
	union {
		box {<-1.1+CS,	-5,-1.1>,	<1.1-CS,	.1,	1.1>}
		box {<-1.1,		-5,-1.1+CS>,<1.1,		.1,	1.1-CS>}
		cylinder {C11-y*1.5,D11,CS}
		cylinder {C12-y*1.5,D12,CS}
		cylinder {C21-y*1.5,D21,CS}
		cylinder {C22-y*1.5,D22,CS}
		bounded_by {box {<-1.2,-5,-1.2>,<1.2,.1,1.2>}}
	}
	bounded_by {plane {y,.1}}
	texture {
		pigment {color rgbf <0,0,1,1> quick_color blue 1}
		finish {specular 1}
		normal {
			ripples 1
			scale 3
			frequency 10
		}
	}
	interior {ior 4/3}
}
