#include "colors.inc" 
#include "textures.inc" 
#include "glass.inc"

global_settings{ambient_light rgb<.85,.85,1>}

camera{location <0,8,-20>} 

light_source{<-10,100,-100>,color White}

background{color Gray70}

//Seaweed
plane{y,0.001
texture {    
    pigment {
      granite
        color_map {
          [0.0 color DarkGreen ]
          [0.05 color Brown ]
          [0.0725 color Maroon]
          [0.11 rgbf <1, 1, 1, 1> ]
          [1.0 rgbf <1, 1, 1, 1> ]
          }
        frequency 1
        scale 12.5
}}}

//The becalmed Ocean laps against the berg
plane{y,0
  texture{T_Winebottle_Glass}
    interior{I_Glass}
    normal{ripples, .5
    scale <1.25,.1,1>
    translate <-10,0,20>
    }
} 

//the murk of the depths
plane{y,-13
  pigment{color Black}
}
  
//It's above freezing, and it's foggy
fog{distance 200 rgb<.92,.92,1>}

//Snow_Tex is for melting and aerated sections of the surface
#declare Snow_Tex=texture{ 
  pigment{
    color White}
  finish{
   ambient .3
   diffuse .8
   }
  normal{bumps .6 scale <.13,.8,.13>}
}

//Icebergs have Blue ice due to air and minerals in the ice
#declare Blue_Ice=texture{ 
  pigment{
    color rgbf<.8,.8,1,.9>}
  finish{
   ambient .2
   diffuse .8
   phong .75
   phong_size 25
   }
} 

//the texture is stretched then tilted to suggest that
//ice formed at different position
#declare Mottled=texture{
   bozo
     texture_map{
       [0.5 Snow_Tex]
       [1.0 Blue_Ice]
       }
     scale <6,1,6>  
     rotate z*15
}  

//the iceberg
difference{
 lathe {
    cubic_spline
    11,
    <-1,2>,
    <0,2>,
    <.5,1.75>,
    <.8,1.33>,
    <1.2,1.1>,
    <1.3,.9>,
    <1.35,.5>,
    <.6,0>,
    <1.4,-.5>,
    <5,-2.5>,
    <20,-10>
   scale <10,8,8>
   }
 //chop a part off to destroy symmetry
 plane{<1,-2,-1>,-7}
   texture{Mottled}
  translate <-10,0,20>
  }

//berg in distance
difference{
  lathe {
    quadratic_spline
    18,
    <0,1.1>
    <0,1>,
    <1.2,.97>,
    <.6,.75>,
    <1.7,.7>,
    <1.85,.4>,
    <1.4,.3>,
    <2.2,0>,
    <2.1,-.05>,
    <1.7,-.12>,
    <1.95,-.2>,
    <1,-.45>,
    <1.1,-.55>,
    <1.6,-.58>,
    <1.3,-.7>,
    <.8,-.8>,
    <.7,-.93>,
    <0,-1>                    
    }
//chopped to add faces
  plane{z,-1}
    scale<30,25,12.5>
    texture{Mottled}
    scale 2
    rotate y*50
    rotate z*-45
    rotate x*-70
    translate<200,10,450>
 } 