// Fish
// Escher Perpetual Waterfall
// B. Wilkins
// October 1998

#declare fishy_text1 = texture
{
	pigment
	{
		leopard
		color_map
		{
			[0.0 	rgb <.55,.55,.55>]
			[1.0 	rgb <.7,.7,.7>]
		}
		scale <.1,.1,.1>
	}
}

#declare fishy_text2 = texture
{
	pigment
	{
		gradient y
		color_map
		{
			[0.0		rgbf <.2,0,0,.8>]
			[1.0		rgbf <.9,0,0,.8>]
		}
		scale <.1,.1,.1>
	}
}

#declare fin_pig = pigment
{
	radial
	frequency 15
	color_map
	{
		[0.0 	rgbf <1,0,0,.35>]
		[1.0 	rgbf <.75,.5,0,0>]
	}
}

#declare spot_fish = union
{
	#declare X = 0
	#declare Y = 0
	#declare LENGTH = 20
	#declare RADIUS = .5
	#declare RDEC = (RADIUS - .4)/LENGTH
	#declare ANGLE = (15/4)
	#declare I = 0
	#while(I<LENGTH)
		sphere
		{
			<0,0,0>
			RADIUS
			#declare YSCALE = sin(radians(((I/10)-0)*90))
			#declare YSCALE = max(YSCALE,0)
			scale <1,1+(1*YSCALE),.7>
			translate <X,Y,0>
		}

		// top fin
		#if((I>(LENGTH/3)) & (I<(LENGTH-(LENGTH/3))))
			cone
			{
				<0,0,0> RADIUS-.001
				<0,.4+RADIUS,0> 0
				scale <1,1+((6.25-abs(I-(LENGTH/3)))/6.25),.2>
				rotate <0,0,-I*ANGLE>
				translate <X,Y,0>
				pigment {fin_pig}
			}
		#end

		// side fin
		#if(I=10.235)
			cone
			{
				<0,0,0> 0
				<0,0,-.7> .75
				pigment {fin_pig}
				scale <.5,.05,1>
				rotate <-45,0,-30>
				translate <X,Y,0>
			}
			cone
			{
				<0,0,0> 0
				<0,0,.7> .75
				pigment {fin_pig}
				scale <.5,.05,1>
				rotate <45,0,30>
				translate <X,Y,0>
			}
		#end

		#declare X = X + (RADIUS/4)*cos(radians(I*ANGLE))
		#declare Y = Y - (RADIUS/4)*sin(radians(I*ANGLE))
		#declare I = I + RADIUS
		#declare RADIUS = RADIUS - RDEC
	#end

	// head
	sphere
	{
		<0,0,0>
		.5
		scale <1.4,.95,.7>
		translate <0,0,0>
	}
	// mouth
	torus
	{
		.4 .05
		scale <1,1,.65>
		rotate <0,0,-5>
		translate <-.3,0,0>
	}
	torus
	{
		.4 .05
		scale <1,1,.65>
		rotate <0,0,5>
		translate <-.3,0,0>
	}

	// eyes
	#declare feye = union
	{
		#declare FEYE_SIZE = .15
		disc
		{
			<0,0,0> z
			FEYE_SIZE
			pigment
			{
				onion
				color_map
				{
					[0.0 	rgb <0,0,0>]
					[0.5 	rgb <0,0,0>]
					[0.5 	rgb <1,1,0>]
					[1.0 	rgb <1,1,0>]
				}
				scale .5*FEYE_SIZE
			}
		}

		sphere
		{
			<0,0,0>
			FEYE_SIZE
			pigment {rgbt <1,1,1,.85>}
			scale <1,1,.5>
			finish {specular .6}
		}
	}

	object {feye translate <0,.3,-.35>}
	object {feye translate <0,.3,.35>}

	// tail
	cone
	{
		<0,0,0> 0
		<0,1,0> 1
		pigment {fin_pig}
		scale <1,1,.1>
		rotate <0,0,-180>
		translate <X,Y,0>
	}

	texture {fishy_text1}
	texture {fishy_text2}
	finish {specular .2 irid {.2 thickness .25 turbulence .75}}

	rotate <0,0,45>
	translate <(-(LENGTH/8))+1,0,0>
}
