// Reeds
// Escher Perpetual Waterfall
// B. Wilkins
// October 1998

#declare reed_leaf = union
{
	#declare leaf_bit = intersection
	{
		difference
		{
			sphere
			{
				<0,0,0>
				1
			}

			sphere
			{
				<0,0,0>
				1
				scale <.95,1,.95>
			}
		}

		plane {-y,0 pigment {Green}}
		plane {x,0 pigment {Green} rotate <0,-2.5,0>}
		plane {-x,0 pigment {Green} rotate <0,2.5,0>}
	}

	#declare clture = texture
	{
		pigment
		{
			gradient y
			color_map
			{
				[0.0	DarkGreen]
				[0.5	rgb <.18,.50,.18>]
				[1.0	DarkGreen]
			}
			turbulence .05
			frequency 20
		}
	}

	object
	{
		leaf_bit
		texture {clture rotate <0,0,-45>}
		rotate <0,2.5,0>
	}

	object
	{
		leaf_bit
		texture {clture rotate <0,0,45>}
		rotate <0,-2.5,0>
	}

	translate <0,0,1>
}

#declare br_reed = union
{
	cylinder
	{
		<0,0,0>
		<0,3.6,0>
		.02
		pigment {DarkGreen}
	}

	sphere
	{
		<0,0,0>
		1
		pigment {Brown}
		scale <.1,.45,.1>
		translate <0,3,0>
	}
}

#declare reeds = union
{
	#declare LSEED = seed(12)
	#declare LCOUNT = 9
	#declare L = 0
	#while(L<LCOUNT)
		object {reed_leaf scale <1,rand(LSEED)+1,1> rotate <0,(360/9)*L,0>}
		#declare L = L + 1
	#end

	#if(BR_REED = 1)
		object {br_reed}
	#end
}
