// Water Lily
// Escher Perpetual Waterfall
// B. Wilkins
// October 1998

// --------------------------- water lily leaf -----------------------
#declare giant_water_lily_leaf = difference
{
	#declare LILY_THICKNESS = .025
	cylinder
	{
		<0,-LILY_THICKNESS,0>
		<0,LILY_THICKNESS,0>
		1
	}

	prism
	{
		linear_sweep
		-(LILY_THICKNESS+.01)
		LILY_THICKNESS+.01
		4
		<0,0> , <-.25,1.01> , <.25,1.01> , <0,0>
	}

	texture
	{
		pigment
		{
			crackle
			color_map
			{
				[0.0	rgb <.18,.35,.18>]
				[0.05	rgb <.18,.35,.18>]
				[0.05	DarkGreen]
				[1.0	DarkGreen]
			}
			scale .2
			turbulence .25
		}
	}

	texture
	{
		pigment
		{
			radial
			color_map
			{
				[0.0	rgbt <1,1,1,1>]
				[0.495	rgbt <1,1,1,1>]
				[0.495	rgb <.18,.35,.18>]
				[0.5	rgb <.18,.50,.18>]
				[0.505	rgb <.18,.35,.18>]
				[0.505	rgbt <1,1,1,1>]
				[1.0	rgbt <1,1,1,1>]
			}
			turbulence .01
			rotate <0,-90,0>
		}
	}
}

#declare water_lily_leaf = object {giant_water_lily_leaf scale <.5,1,1.2>}


// ---------------------------- water lily flower ----------------------------
#declare FLOWER_TYPE_ORIG = 0
#declare FLOWER_TYPE_CORRECT = 1
#declare FLOWER_TYPE = FLOWER_TYPE_CORRECT

#declare petal =  bicubic_patch
{
	type 1 flatness 0.01 u_steps 3 v_steps 3,
	< -1.0375, 0.699999, -4.6125 >, < -0.0500004, 0.699999, -5.375 >, < -0.0500004, 0.699999, -5.375 >, < 0.95, 0.699999, -4.625 >,
	< -1.9875, 0.699999, -2.625 >, < -0.55, -0.3, -0.875 >, < 0.45, -0.3, -0.875 >, < 1.95, 0.699999, -2.625 >,
	< -2.9625, 0.699999, 0.325 >, < -1.05, -0.699999, 1.375 >, < 1.0125, -0.699999, 1.375 >, < 2.9625, 0.699999, 0.3125 >,
	< -2.55, 0.699999, 3.3125 >, < -1.0375, 0.599999, 5.375 >, < 0.962499, 0.599999, 5.375 >, < 2.3625, 0.699999, 3.31607 >
	translate  < 0, -0.625, -5.3125 >
	scale .5
 }

#if(PINK_LILY = 1)
	#declare LILY_L_PIG = pigment {rgb <.9,.85,.85>}
	#declare LILY_F_PIG = pigment {rgb <0.73,0.56,0.56>}
#else
	#declare LILY_L_PIG = pigment {rgb <0.96,1,0.98>}
	#declare LILY_F_PIG = pigment {rgb <0.8,0.8,0>}
#end

#declare water_lily_flower = union
{
	#declare LEVELS = 3
	#declare PETAL_COUNT = 8
	#declare I = 0
	#while(I < LEVELS)
		#declare J = 0
		#while(J < PETAL_COUNT)
			object
			{
				petal
				translate <0,0,-2*(1-(I/(LEVELS-1)))>
				#if(FLOWER_TYPE = FLOWER_TYPE_ORIG)
					rotate <(LEVELS-(0.5*I))*10,0,0>
				#else
					rotate <10+(I*10),0,0>
				#end
				rotate <0,(J*(360/PETAL_COUNT))+(I*22.5),0>
				pigment {LILY_L_PIG}
			}

			object
			{
				petal
				#if(FLOWER_TYPE = FLOWER_TYPE_CORRECT)
					scale <1,1,.5>
				#end
				translate <0,0,-2*(1-(I/(LEVELS-1)))>
				rotate <70+(I*5),0,0>
				rotate <0,(J*(360/PETAL_COUNT))+(I*22.5),0>
				pigment {LILY_F_PIG}
				finish {ambient .6}
			}

			#declare J = J + 1
		#end
		#declare I = I + 1
	#end

	scale .09375
}
