camera {
  location  <19.000, -18.700, 2.100>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>
  up        <0.0,     0.0,  1.0>
  right     <1.33333,  0.0,  0.0>
  look_at   <0.500, -1.100, 0.200>
}

light_source {
  <700.000, -700.000, 2006.400>
  color rgb <1.000, 1.000, 1.000>
}

#declare T_Sand =
   texture
   {
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.6875, 0.552067, 0.2, 0.0, 0.0> ]
            [ 0.1     rgbft <0.8229, 0.666667, 0.2, 0.0, 0.0> ]
            [ 0.2     rgbft <0.88, 0.6, 0.4, 0.0, 0.0> ]
            [ 0.3     rgbft <0.8854, 0.708333, 0.2, 0.0, 0.0> ]
            [ 0.4     rgbft <1.0, 0.739567, 0.2, 0.0, 0.0> ]
            [ 1.0     rgbft <0.88, 0.6, 0.4, 0.0, 0.0> ]
         }
         turbulence 0.35
         octaves 5
         lambda 3.25
         scale  0.037
         rotate -90.0 * y
         translate -2.0 * x
      }
   }
   texture
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.8854, 0.708333, 0.2, 0.479133, 0.0> ]
            [ 0.1     rgbft <0.8229, 0.666667, 0.2, 0.5, 0.0> ]
            [ 0.2     rgbft <0.88, 0.6, 0.4, 0.312467, 0.0> ]
            [ 0.3     rgbft <0.8854, 0.708333, 0.2, 0.479133, 0.0> ]
            [ 0.4     rgbft <1.0, 0.739567, 0.2, 0.479133, 0.0> ]
            [ 1.0     rgbft <0.88, 0.6, 0.4, 0.562467, 0.0> ]
         }
         turbulence 0.3
         octaves 5
         lambda 3.25
         scale 0.005
         rotate -90.0 * y
         translate -2.0 * x
      }
      finish
      {
        ambient 0.4
        diffuse 0.6
      }
   }

sky_sphere {
      pigment
      {
         gradient z
         color_map
         {
            [ 0.0     rgbft <0.495833, 0.7625, 1.0, 0.0, 0.0> ]
            [ 1.0     rgbft <0.352067, 0.7625, 1.0, 0.0, 0.0> ]
         }
      }
}


plane {
  z,0
  texture {
    T_Sand
  }
}


object {
  height_field {
    tga "dunes.tga"
    smooth
    water_level 0.0
  }
  rotate    <-90, 0, 0>
  scale     <  2, 2,-2>
  translate < -1,-1,-1>
  texture {
    T_Sand
  }
  scale <16.1, 16.6, 1.5>
  translate  1.5*z
}




