#declare final = 1;

#include "cpatrol.inc"

#declare wldiff = 30;

global_settings {
	max_trace_level 10
	number_of_waves 20
	}

camera {
	location <0, 3, -10>
	sky y
	right 4/3*x
	look_at <0,2,0>
	rotate 15*z
}

height_field {
	gif "hf6.gif"
#if (final=1)
	smooth
#end
	translate <-0.5,0,-0.5>
	scale <2000,25,2000>
	translate -y*30
	pigment {
		granite
		colour_map {
			[0 rgb <1,1,1>]
			[1 rgb <0.6,0.4,0>]
		}
	}
	normal {
		crackle 0.5
		}
	finish {
		ambient 0.1
		diffuse 0.9
		}
	}


#declare blcount = 0;
#while (blcount<360)
	light_source {
		<100,0,0>
		rgb <1,1,1>
		looks_like { union {
			sphere {
				<0,0,0> 1
				pigment {rgb <1,1,1>}
				finish { diffuse 0 ambient 1 }
				}
			cylinder {
				<0,0,0> <0,-50,0> 0.5
				pigment { rgb <0,0,0>}
				finish { phong 1 }
				}
			}}
		rotate y*(blcount)   
		translate -y*5
		translate z*200
		fade_distance 30
		fade_power 2
		}
	#declare blcount = blcount +wldiff;
	#end

#declare pod = union {
	light_source { <0,0,0> rgb <1,1,0> fade_distance 100 fade_power 2 }
	light_source { <0,0,-50> rgb <1,1,0> fade_distance 100 fade_power 2 }
	light_source { <50,0,0> rgb <1,1,0> fade_distance 100 fade_power 2 }
	light_source { <-50,0,0> rgb <1,1,0> fade_distance 100 fade_power 2 }
	union {
		sphere { <0,0,0> 49.9 }
		sphere { <-50,0,0> 24.9 }
		sphere { <0,0,-50> 24.9 }
		sphere { <0,0,50> 24.9 }
		sphere { <50,0,0> 24.9 }
		pigment { rgb <5,5,0> }
		finish { ambient 1 diffuse 0 }
		no_shadow
		hollow
	}
	difference {
		merge {
			sphere { <0,0,0> 50 }
			sphere { <-50,0,0> 25 }
			sphere { <50,0,0> 25 }
			sphere { <0,0,50> 25 }
			sphere { <0,0,-50> 25 }
		}
		cylinder { <0,-1,0> <0,1,0> 75.01 }
		pigment {
			rgb <1,1,1>
			}
		finish {
			ambient 0
			diffuse 0
			specular 1
			metallic
			}
		}
	light_source {
		<0,55,0>
		rgb <1,1,1>
		looks_like { union {
			sphere {
				<0,0,0> 1
				pigment {rgb <10,10,10>}
				finish { diffuse 0 ambient 1 }
				}
			cylinder {
				<0,0,0> <0,-5,0> 0.5
				pigment { rgb <0,0,0>}
				finish { phong 1 }
				}
			}}
		fade_distance 100
		fade_power 2		
		}
	}

object {
	pod
	translate z*200
	}

object { craft
	rotate 20*z
	rotate -10*y
	translate -y*1
	translate x*4
	translate z*3
	}

object { craft
	rotate 35*z
	rotate 5*y
	translate y*4
	translate -x*4
	translate z*5
	}

#if (final=1)
media {
	absorption rgb <0.04,0.02,0.01>
	intervals 100
	scattering { 3, rgb 0.001 }
	samples 1, 20
	confidence 0.9
	variance 1/256
	ratio 0.9
}
#end       
plane { z,600
	pigment { rgb <0,0,0> }
	hollow
	finish { ambient 0 diffuse 0}
}

