
#declare thick = .005;
#declare opening = .8;
#declare water_lev = .7;
#declare grit_lev = .2;


#declare bowl = difference {
/*
cylinder { y*-1, y*1, 1+thick }
cylinder { y*-1, y*1, 1 }
*/
	sphere{ 0, 1+thick
	}
	sphere{ 0, 1
	}
	cone{ <0,0,0>, 0 <0,1+thick+.01,0>, opening }
	prism {
	  linear_sweep
	  linear_spline
	  -1.0,0.0
	  11  // control points
	  <-1.0, -1.0>,
	  <-0.142301, -0.441624>,
	  <1.0, -1.0>,
	  <0.295262, -0.10643>,
	  <0.610829, 0.763113>,
	  <-0.131134, 0.530457>,
	  <-0.847716, 1.050761>,
	  <-0.42868, 0.376193>,
	  <-1.360406, 0.166497>,
	  <-0.433164, -0.126904>,
	  <-1.0, -1.0>
	  scale <.2,1,.2>
	  rotate -x*90

	  translate <0,0.45,-1> 
	  //translate <-0.2,0.45,-1> 
	  rotate y*60
	}
	//pigment{ color rgbf<0,1,0, .9> }
	//interior { ior 1.5 }
}



#declare water = 
difference {
	//sphere{ 0, 1-thick }
	sphere{ 0, 1 }
	//cylinder{ y*-1, y*1, 1 }
	plane{ -y, 2*(1-water_lev)-1
	}
	//pigment { Red }
	//pigment{ color rgbf<1, 1, 1, .8> }
	//pigment{ color rgbf<.7, .8, .8, .8> }
	//interior { ior 1.3 }
}



#declare grit = difference {
	sphere{ 0, 1-thick }
	plane{ -y, (1-(2*grit_lev))}
	//rotate x*180
	
}
