//  ****************************************************************************
//  **************************   NIGHT OF RAIN   *******************************
//  ****************************************************************************
//                 Image for the Internet Ray Traicing Competition
//                            August - October of 1998
//                      Procesed by Guillermo Espitia Rojas
//                             gespitia@latino.net.co
//  
//                            Pov-Ray for Windows 3.02
//
//  




global_settings {
  adc_bailout 0.003922
  ambient_light <0.498039,0.498039,0.498039>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <1.000,1.000,1.000> }

camera {
  location  <5.508, -14.101, 1.500>
  direction <0.0,     0.0,  1.4297>
  sky       <0.0,     0.0,  1.0> 
  up        <0.0,     0.0,  1.0> 
  right     <1.33333,  0.0,  0.0>
  look_at   <1.626, -4.752, 2.000>
}


//  ******  ILLUMINATION  ********

light_source {   // Light auxiliary platform                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     
  <0.000, -8.737, 1.000>
  color rgb <0.100, 0.100, 0.100>
  shadowless
  fade_distance  4.0
  fade_power 4.0
}

light_source {   // Light auxiliary rain
  <5.448, -14.123, 1.494>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  2.5
  fade_power 4.0
}

light_source {   // Light house lobby
  <0.000, 9.200, 4.050>
  color rgb <1.000, 0.800, 0.343>
  fade_distance  3.0
  fade_power 4.0
  atmospheric_attenuation on
}

light_source {   // Light house second floor
  <-5.150, 6.081, 8.388>
  color rgb <1.000, 0.800, 0.343>
  fade_distance  3.0
  fade_power 4.0
  atmospheric_attenuation on
}

light_source {   // Light house center left
  <-2.190, 4.800, 2.796>
  color rgb <0.629, 0.614, 0.343>
  fade_distance  1.2
  fade_power 4.0
}

light_source {   // Light house center right
  <2.190, 4.800, 2.800>
  color rgb <0.629, 0.614, 0.343>
  fade_distance  1.2
  fade_power 4.0
}

light_source {   // Light west inferior
  <-7.500, 3.500, 2.812>
  color rgb <0.629, 0.614, 0.343>
  fade_distance  3.0
  fade_power 4.0
}

light_source {   // Light west superior
  <-7.500, 3.500, 7.212>
  color rgb <0.629, 0.614, 0.343>
  fade_distance  3.0
  fade_power 4.0
}

light_source {   // Light post 1
  <-3.888, -7.400, 2.794>
  color rgb <0.600, 0.600, 0.600>
  fade_distance  3.0
  fade_power 4.0
}

light_source {   // Light post 2
  <3.889, -7.400, 2.795>
  color rgb <0.600, 0.600, 0.600>
  fade_distance  3.0
  fade_power 4.0
}

light_source {   // Light post 3
  <6.112, -7.400, 2.795>
  color rgb <0.600, 0.600, 0.600>
  fade_distance  3.0
  fade_power 4.0
}



// ********  TEXTURES  *******

#include "ger_agua_tex.inc"



// ********  OBJECTS  *******


//   SKY
#include "Cielo_Osc.inc"


//  LAMPS EXTERIOR HOUSE
#include "ger_agua_lamp.inc"


//    HOUSE
#include "ger_agua_house.inc"


//    STONE WALL
#include "ger_agua_stone.inc"


//    POST ILLUMINATION
#include "ger_agua_post.inc"


//    PLATFORM, ROAD, GRASS
#include "ger_agua_floor.inc"


//    RAIN
plane { // Lluvia
  z,0
  texture {
    T_Lluvia
  }
  no_shadow
  hollow
  rotate <90.0, 0.0, 21.237759>
  translate  <4.760958, -12.225523, 1.490275>
}


//    DOOR GARDEN
#include "ger_agua_door.inc"


//    GENTLEMAN
#include "ger_agua_gent.inc"




