//
// Include file for ger_agua.pov
// Contains Platform, road, grass
//
//                 Image for the Internet Ray Traicing Competition
//                            August - October of 1998
//                      Procesed by Guillermo Espitia Rojas



//   Platform

#declare Anden1 = object {
  height_field {
    gif "ande2-hf.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    T_Anden
  }
  scale <2.133, 1.175, 0.007>
  translate  <0.0, -6.575, -0.007>
}
#declare Sardinel = object {
  box { // Sardinel
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Sardinel
    }
    scale <0.6, 0.065, 0.15>
    translate  <0.0, -7.835, -0.15>
  }
}


//   Road

#declare Calzada1 = object {
  height_field {
    gif "pave-1.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    T_Anden
  }
  scale <1.5, 1.2, 0.01>
  rotate <0.0, 2.0, 90.0>
  translate  <0.0, -9.4, -0.12>
}



//   Grass

#declare Hierba1 = object {
  box { // Hierba1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexJardin
    }
    scale <9.1, 16.799999, 0.04>
    translate  <-10.7, 11.8, -0.02>
  }
}




#declare Anden = union {
  object { Anden1 }
  object { // Anden2->Anden1
    Anden1
    translate  -4.266*x
  }
  object { // Anden3->Anden1
    Anden1
    translate  4.266*x
  }
  box { // Agua_Anden
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Agua_Superficial
    }
    scale <6.399, 1.175, 0.0015>
    translate  <0.0, -6.575, 0.0015>
  }
}
#declare Sardineles = union {
  object { Sardinel }
  object { // Sardinel1->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <1.21, -0.0, 0.0>
  }
  object { // Sardinel2->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <2.42, -0.0, 0.0>
  }
  object { // Sardinel3->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <3.63, -0.0, 0.0>
  }
  object { // Sardinel4->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <4.84, -0.0, 0.0>
  }
  object { // Sardinel5->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <6.05, -0.0, 0.0>
  }
  object { // Sardinel6->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <7.26, -0.0, 0.0>
  }
  object { // Sardinel7->Sardinel
    Sardinel
    rotate -0.0*x
    translate  <-1.21, -0.0, 0.0>
  }
}


//   Water pool

#declare Charco = object {
  height_field {
    gif "hf-charc.gif"
    water_level 0.001
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    T_Agua_Charco
  }
  scale <3.6, 0.45, 0.01>
  translate  <2.414706, -8.350516, -0.121148>
}


//   Road

#declare Piso_Calzada = union {
  object { Calzada1 }
  object { // Calzada2->Calzada1
    Calzada1
    rotate 0.0*z
    translate  <2.4, -0.0, 0.0>
  }
  object { // Calzada3->Calzada1
    Calzada1
    rotate 0.0*z
    translate  <4.8, -0.0, 0.0>
  }
  box { // Agua_Calzada
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Agua_Superficial
    }
    scale <3.6, 1.5, 0.0015>
    rotate -2.0*x
    translate  <2.4, -9.399464, -0.108354>
  }
  object { Charco }
}



//    Stone floor

#declare Piso_Piedra = object {
  height_field {
    gif "ande2-hf.gif"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    T_Pied_Meteor_1
  }
  scale <1.6, 3.25, 0.03>
  translate  <0.0, -2.15, -0.015>
}



//   Stone floor + Grass

#declare Piso_Entrada = union {
  object { Piso_Piedra }
  box { // Agua_Piso_Acceso
    <-1, -1, -1>, <1, 1, 1>
    texture {
      T_Agua_Superficial
    }
    scale <1.6, 3.25, 0.0015>
    translate  <0.0, -2.15, 0.0015>
  }
  object { Hierba1 }
  object { // Hierba2->Hierba1
    Hierba1
    rotate -0.0*z
    translate  <21.4, -0.0, 0.0>
  }
}


//   Platform + Road + Stone floor + Grass

union { // Pisos_Exteriores
  object { Anden }
  object { Sardineles }
  object { Piso_Calzada }
  object { Piso_Entrada }
}


