//
// Include file for ger_agua.pov
// Contains House
//
//                 Image for the Internet Ray Traicing Competition
//                            August - October of 1998
//                      Procesed by Guillermo Espitia Rojas




#declare CSG43 = difference {
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  translate  <-2.5, -4.15, 4.64>
}
#declare CSG69 = difference {
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  translate  <-2.2, 1.85, 9.04>
}
#declare CSG103 = difference {
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  rotate 90.0*z
  translate  <-2.35, -0.05, 9.04>
}
#declare CSG114 = difference {
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  rotate 90.0*z
  translate  <2.65, -4.05, 4.64>
}
#declare PiedraMG = object {
  box { // PiedraMG
    <-1, -1, -1>, <1, 1, 1>
    scale <0.29, 0.29, 0.19>
    translate  <-2.31, -2.8, 4.34>
  }
}
#declare PiedrasTipicasM2 = union {
  object { PiedraMG }
  object { // PiedraMG1->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  0.6*y
  }
  object { // PiedraMG2->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  1.2*y
  }
  object { // PiedraMG3->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  1.8*y
  }
  object { // PiedraMG4->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  2.4*y
  }
  object { // PiedraMG5->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  3.0*y
  }
  object { // PiedraMG6->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  3.6*y
  }
  object { // PiedraMG7->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  4.2*y
  }
  object { // PiedraMG8->Piedra-G
    PiedraMG
    rotate <-0.0, 0.0, -0.0>
    translate  4.8*y
  }
  texture {
    Piedra1
  }
}
#declare CSGM1 = difference {
  box { // PiedraME
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.075, 0.39>
    translate  <-10.1, -1.025, 4.14>
  }
  box { // AuxM1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.35, 0.06, 0.25>
    translate  <-10.1, -1.1, 4.14>
  }
}
#declare AdornoM1 = union {
  object { CSGM1 }
  torus { // Torus001
    0.18, 0.03  rotate -x*90
    rotate 90.0*x
    translate  <-10.1, -1.07, 4.14>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale <0.15, 0.08, 0.15>
    translate  <-10.1, -1.07, 4.14>
  }
}
#declare PiedraMD = object {
  box { // PiedraMD
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.405, 0.19>
    translate  <-10.1, -0.525, 3.94>
  }
}
#declare PiedraMD8 = object {
  object { // PiedraMD8->Piedra-D
    PiedraMD
    translate  <8.0, -3.0, -0.0>
  }
}
#declare AdornColum = union {
  object { // AdornoM5->Adorno-1
    AdornoM1
    translate  <8.0, -3.0, 0.0>
  }
  object { PiedraMD8 }
  object { // PiedraMD9->Piedra-D8
    PiedraMD8
    translate  0.4*z
  }
  object { // PiedraMD14->Piedra-D8
    PiedraMD8
    translate  0.8*z
  }
  texture {
    Piedra2
  }
}
#declare CuboBase1 = object {
  box { // CuboBase1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.42, 0.42, 0.05>
    translate  0.59*z
  }
}
#declare ToroBase1 = object {
  torus { // ToroBase1
    0.35, 0.05  rotate -x*90
    translate  0.69*z
  }
}
#declare ToritBase1 = object {
  torus { // ToritBase1
    0.31, 0.04  rotate -x*90
    translate  0.79*z
  }
}
#declare CilMuesca = object {
  cylinder { // CilMuesca
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 2.6>
    translate  <0.3, 0.0, 0.84>
  }
}
#declare CSG113 = difference {
  cylinder { // CilBase1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 2.6>
    translate  0.84*z
  }
  cylinder { // CilMuesca24
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 2.6>
    translate  <0.3, 0.0, 0.84>
  }
  object { // CilMuesca25->CilMuesca
    CilMuesca
    rotate -15.0*z
    translate  0.0*x
  }
  object { // CilMuesca26->CilMuesca
    CilMuesca
    rotate -30.0*z
  }
  object { // CilMuesca27->CilMuesca
    CilMuesca
    rotate -45.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // CilMuesca28->CilMuesca
    CilMuesca
    rotate -60.0*z
    translate  -0.0*x
  }
  object { // CilMuesca29->CilMuesca
    CilMuesca
    rotate -75.0*z
    translate  -0.0*x
  }
  object { // CilMuesca30->CilMuesca
    CilMuesca
    rotate -90.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca31->CilMuesca
    CilMuesca
    rotate -105.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca32->CilMuesca
    CilMuesca
    rotate -120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca33->CilMuesca
    CilMuesca
    rotate -135.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca34->CilMuesca
    CilMuesca
    rotate -150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca35->CilMuesca
    CilMuesca
    rotate -165.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca36->CilMuesca
    CilMuesca
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca37->CilMuesca
    CilMuesca
    rotate 165.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca38->CilMuesca
    CilMuesca
    rotate 150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca39->CilMuesca
    CilMuesca
    rotate 135.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca40->CilMuesca
    CilMuesca
    rotate 120.0*z
    translate  0.0*x
  }
  object { // CilMuesca41->CilMuesca
    CilMuesca
    rotate 105.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca42->CilMuesca
    CilMuesca
    rotate 90.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca43->CilMuesca
    CilMuesca
    rotate 75.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca44->CilMuesca
    CilMuesca
    rotate 60.0*z
    translate  -0.0*y
  }
  object { // CilMuesca45->CilMuesca
    CilMuesca
    rotate 45.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // CilMuesca46->CilMuesca
    CilMuesca
    rotate 30.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // CilMuesca47->CilMuesca
    CilMuesca
    rotate 15.0*z
    translate  <-0.0, -0.0, 0.0>
  }
}
#declare Columna4 = union {
  box { // CuboBase3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.42, 0.42, 0.05>
    translate  0.59*z
  }
  object { // CuboBase4->CuboBase1
    CuboBase1
    translate  3.1*z
  }
  torus { // ToroBase3
    0.35, 0.05  rotate -x*90
    translate  0.69*z
  }
  object { // ToroBase4->ToroBase1
    ToroBase1
    translate  2.9*z
  }
  object { // ToritBase3->ToritBase1
    ToritBase1
    translate  2.7*z
  }
  torus { // ToritBase4
    0.31, 0.04  rotate -x*90
    translate  0.79*z
  }
  object { CSG113 }
  texture {
    TexColumna1
  }
  translate  <-2.1, -3.6, 0.0>
}
#declare PiedraMC = object {
  box { // PiedraMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.25, 0.19>
    translate  <-10.1, 0.15, 0.74>
  }
}
#declare PiedraMC1 = object {
  object { // PiedraMC1->Piedra-C
    PiedraMC
    translate  0.4*z
  }
}
#declare PiedraMC21 = object {
  object { // PiedraMC21->Piedra-C1
    PiedraMC1
    translate  5.2*x
  }
}
#declare PiedraMC42 = object {
  object { // PiedraMC42->Piedra-C
    PiedraMC
    translate  <2.6, 0.0, 0.0>
  }
}
#declare PiedraMA = object {
  box { // PiedraMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 0.19>
    translate  <-12.3, 0.2, 0.74>
  }
}
#declare PiedraMA4 = object {
  object { // PiedraMA4->Piedra-A
    PiedraMA
    translate  <0.0, 0.0, 3.2>
  }
}
#declare PiedraMA5 = object {
  object { // PiedraMA5->Piedra-A4
    PiedraMA4
    translate  1.6*z
  }
}
#declare PiedraMA8 = object {
  object { // PiedraMA8->Piedra-A5
    PiedraMA5
    translate  2.4*z
  }
}
#declare PiedraMA9 = object {
  object { // PiedraMA9->Piedra-A
    PiedraMA
    translate  <9.6, 0.0, 0.0>
  }
}
#declare PiedraMA13 = object {
  object { // PiedraMA13->Piedra-A9
    PiedraMA9
    translate  3.2*z
  }
}
#declare PiedraMA14 = object {
  object { // PiedraMA14->Piedra-A13
    PiedraMA13
    translate  1.6*z
  }
}
#declare PiedraMA17 = object {
  object { // PiedraMA17->Piedra-A14
    PiedraMA14
    translate  2.4*z
  }
}
#declare PiedraMB = object {
  box { // PiedraMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.19>
    translate  <-12.4, 0.1, 1.14>
  }
}
#declare PiedraMB10 = object {
  object { // PiedraMB10->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  9.8*x
  }
}
#declare PiedrasTipicasM1 = union {
  object { PiedraMC }
  object { PiedraMC1 }
  object { // PiedraMC2->Piedra-C
    PiedraMC
    translate  0.8*z
  }
  object { // PiedraMC3->Piedra-C
    PiedraMC
    translate  1.2*z
  }
  object { // PiedraMC4->Piedra-C
    PiedraMC
    translate  1.6*z
  }
  object { // PiedraMC5->Piedra-C
    PiedraMC
    translate  2.0*z
  }
  object { // PiedraMC6->Piedra-C
    PiedraMC
    translate  2.4*z
  }
  object { // PiedraMC7->Piedra-C
    PiedraMC
    translate  2.8*z
  }
  object { // PiedraMC8->Piedra-C
    PiedraMC
    translate  3.2*z
  }
  object { // PiedraMC9->Piedra-C
    PiedraMC
    translate  3.6*z
  }
  object { // PiedraMC10->Piedra-C
    PiedraMC
    translate  4.0*z
  }
  object { // PiedraMC11->Piedra-C
    PiedraMC
    translate  4.4*z
  }
  object { // PiedraMC12->Piedra-C
    PiedraMC
    translate  4.8*z
  }
  object { // PiedraMC13->Piedra-C
    PiedraMC
    translate  5.2*z
  }
  object { // PiedraMC14->Piedra-C
    PiedraMC
    translate  5.6*z
  }
  object { // PiedraMC15->Piedra-C
    PiedraMC
    translate  6.0*z
  }
  object { // PiedraMC16->Piedra-C
    PiedraMC
    translate  6.4*z
  }
  object { // PiedraMC17->Piedra-C
    PiedraMC
    translate  6.8*z
  }
  object { // PiedraMC18->Piedra-C
    PiedraMC
    translate  7.2*z
  }
  object { // PiedraMC19->Piedra-C
    PiedraMC
    translate  7.6*z
  }
  object { // PiedraMC20->Piedra-C
    PiedraMC
    translate  8.0*z
  }
  object { PiedraMC21 }
  object { // PiedraMC22->Piedra-C21
    PiedraMC21
    translate  0.4*z
  }
  object { // PiedraMC23->Piedra-C21
    PiedraMC21
    translate  0.8*z
  }
  object { // PiedraMC24->Piedra-C21
    PiedraMC21
    translate  1.2*z
  }
  object { // PiedraMC25->Piedra-C21
    PiedraMC21
    translate  1.6*z
  }
  object { // PiedraMC26->Piedra-C21
    PiedraMC21
    translate  2.0*z
  }
  object { // PiedraMC27->Piedra-C21
    PiedraMC21
    translate  2.4*z
  }
  object { // PiedraMC28->Piedra-C21
    PiedraMC21
    translate  2.8*z
  }
  object { // PiedraMC29->Piedra-C21
    PiedraMC21
    translate  3.2*z
  }
  object { // PiedraMC30->Piedra-C21
    PiedraMC21
    translate  3.6*z
  }
  object { // PiedraMC31->Piedra-C21
    PiedraMC21
    translate  4.0*z
  }
  object { // PiedraMC32->Piedra-C21
    PiedraMC21
    translate  4.4*z
  }
  object { // PiedraMC33->Piedra-C21
    PiedraMC21
    translate  4.8*z
  }
  object { // PiedraMC34->Piedra-C21
    PiedraMC21
    translate  5.2*z
  }
  object { // PiedraMC35->Piedra-C21
    PiedraMC21
    translate  5.6*z
  }
  object { // PiedraMC36->Piedra-C21
    PiedraMC21
    translate  6.0*z
  }
  object { // PiedraMC37->Piedra-C21
    PiedraMC21
    translate  6.4*z
  }
  object { // PiedraMC38->Piedra-C21
    PiedraMC21
    translate  6.8*z
  }
  object { // PiedraMC39->Piedra-C21
    PiedraMC21
    translate  7.2*z
  }
  object { // PiedraMC40->Piedra-C21
    PiedraMC21
    translate  7.6*z
  }
  object { // PiedraMC41->Piedra-C21
    PiedraMC21
    translate  8.0*z
  }
  object { PiedraMC42 }
  object { // PiedraMC43->Piedra-C42
    PiedraMC42
    translate  0.4*z
  }
  object { // PiedraMC44->Piedra-C42
    PiedraMC42
    translate  0.8*z
  }
  object { // PiedraMC45->Piedra-C42
    PiedraMC42
    translate  1.2*z
  }
  object { // PiedraMC46->Piedra-C42
    PiedraMC42
    translate  1.6*z
  }
  object { // PiedraMC47->Piedra-C42
    PiedraMC42
    translate  2.0*z
  }
  object { // PiedraMC48->Piedra-C42
    PiedraMC42
    translate  2.4*z
  }
  object { // PiedraMC49->Piedra-C42
    PiedraMC42
    translate  2.8*z
  }
  object { // PiedraMC50->Piedra-C42
    PiedraMC42
    translate  3.2*z
  }
  object { // PiedraMC51->Piedra-C42
    PiedraMC42
    translate  3.6*z
  }
  object { // PiedraMC52->Piedra-C42
    PiedraMC42
    translate  4.0*z
  }
  object { // PiedraMC53->Piedra-C42
    PiedraMC42
    translate  4.4*z
  }
  object { // PiedraMC54->Piedra-C42
    PiedraMC42
    translate  4.8*z
  }
  object { // PiedraMC55->Piedra-C42
    PiedraMC42
    translate  5.2*z
  }
  object { // PiedraMC56->Piedra-C42
    PiedraMC42
    translate  5.6*z
  }
  object { // PiedraMC57->Piedra-C42
    PiedraMC42
    translate  6.0*z
  }
  object { // PiedraMC58->Piedra-C42
    PiedraMC42
    translate  6.4*z
  }
  object { // PiedraMC59->Piedra-C42
    PiedraMC42
    translate  6.8*z
  }
  object { // PiedraMC60->Piedra-C42
    PiedraMC42
    translate  7.2*z
  }
  object { // PiedraMC61->Piedra-C42
    PiedraMC42
    translate  7.6*z
  }
  object { // PiedraMC62->Piedra-C42
    PiedraMC42
    translate  8.0*z
  }
  object { // PiedraMC63->Piedra-C
    PiedraMC
    translate  <2.6, 0.0, 0.0>
  }
  object { // PiedraMC64->Piedra-C
    PiedraMC
    translate  <5.2, 0.0, 0.0>
  }
}
#declare PiedrasEsq = union {
  object { PiedraMA }
  object { // PiedraMA1->Piedra-A
    PiedraMA
    translate  <0.0, 0.0, 0.8>
  }
  object { // PiedraMA2->Piedra-A
    PiedraMA
    translate  <0.0, 0.0, 1.6>
  }
  object { // PiedraMA3->Piedra-A
    PiedraMA
    translate  <0.0, 0.0, 2.4>
  }
  object { PiedraMA4 }
  object { PiedraMA5 }
  object { // PiedraMA6->Piedra-A5
    PiedraMA5
    translate  0.8*z
  }
  object { // PiedraMA7->Piedra-A5
    PiedraMA5
    translate  1.6*z
  }
  object { PiedraMA8 }
  object { PiedraMA9 }
  object { // PiedraMA10->Piedra-A9
    PiedraMA9
    translate  0.8*z
  }
  object { // PiedraMA11->Piedra-A9
    PiedraMA9
    translate  1.6*z
  }
  object { // PiedraMA12->Piedra-A9
    PiedraMA9
    translate  2.4*z
  }
  object { PiedraMA13 }
  object { PiedraMA14 }
  object { // PiedraMA15->Piedra-A14
    PiedraMA14
    translate  0.8*z
  }
  object { // PiedraMA16->Piedra-A14
    PiedraMA14
    translate  1.6*z
  }
  object { PiedraMA17 }
  object { PiedraMB }
  object { // PiedraMB1->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  0.8*z
  }
  object { // PiedraMB2->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  1.6*z
  }
  object { // PiedraMB3->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  2.4*z
  }
  object { // PiedraMB4->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  3.2*z
  }
  object { // PiedraMB5->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  4.0*z
  }
  object { // PiedraMB6->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  4.8*z
  }
  object { // PiedraMB7->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  5.6*z
  }
  object { // PiedraMB8->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  6.4*z
  }
  object { // PiedraMB9->Piedra-B
    PiedraMB
    rotate 0.0*z
    translate  7.2*z
  }
  object { PiedraMB10 }
  object { // PiedraMB11->Piedra-B10
    PiedraMB10
    translate  0.8*z
  }
  object { // PiedraMB12->Piedra-B10
    PiedraMB10
    translate  1.6*z
  }
  object { // PiedraMB13->Piedra-B10
    PiedraMB10
    translate  2.4*z
  }
  object { // PiedraMB14->Piedra-B10
    PiedraMB10
    translate  3.2*z
  }
  object { // PiedraMB15->Piedra-B10
    PiedraMB10
    translate  4.0*z
  }
  object { // PiedraMB16->Piedra-B10
    PiedraMB10
    translate  4.8*z
  }
  object { // PiedraMB17->Piedra-B10
    PiedraMB10
    translate  5.6*z
  }
  object { // PiedraMB18->Piedra-B10
    PiedraMB10
    translate  6.4*z
  }
  object { // PiedraMB19->Piedra-B10
    PiedraMB10
    translate  7.2*z
  }
  object { // PiedraMA18->Piedra-A8
    PiedraMA8
    translate  0.8*z
  }
  object { // PiedraMA19->Piedra-A17
    PiedraMA17
    translate  0.8*z
  }
  object { // PiedraMA20->Piedra-A4
    PiedraMA4
    translate  0.8*z
  }
  object { // PiedraMA21->Piedra-A13
    PiedraMA13
    translate  0.8*z
  }
}
#declare PIEDRAS = union {
  object { PiedrasTipicasM1 }
  object { PiedrasEsq }
  texture {
    Piedra1
  }
}
#declare CenefitaM1 = union {
  box { // CenefitaMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.15, 0.05>
    translate  <-10.1, -1.25, 4.89>
  }
  box { // CenefitaMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 0.1, 0.025>
    translate  <-10.1, -1.2, 4.815>
  }
  box { // CenefitaMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.65, 0.075, 0.025>
    translate  <-10.1, -1.175, 4.765>
  }
}
#declare CenefitaM3 = object {
  object { // CenefitaM3->Cenefita-1
    CenefitaM1
    translate  4.4*z
  }
}
#declare Cenefis = union {
  box { // CenefisMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.65, 0.05>
    translate  <-10.75, -0.75, 4.89>
  }
  box { // CenefisMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.6, 0.025>
    translate  <-10.7, -0.7, 4.815>
  }
  box { // CenefisMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.575, 0.025>
    translate  <-10.675, -0.675, 4.765>
  }
}
#declare Cenepupis = union {
  box { // CenepupisMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.65, 0.05>
    translate  <-4.25, -0.75, 4.89>
  }
  box { // CenepupisMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.6, 0.025>
    translate  <-4.3, -0.7, 4.815>
  }
  box { // CenepupisMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 0.575, 0.025>
    translate  <-4.325, -0.675, 4.765>
  }
}
#declare CenefaM1 = union {
  box { // CenefaMA
    <-1, -1, -1>, <1, 1, 1>
    scale <5.4, 0.15, 0.05>
    translate  <-7.5, -0.25, 4.89>
  }
  box { // CenefaMB
    <-1, -1, -1>, <1, 1, 1>
    scale <5.3, 0.1, 0.025>
    translate  <-7.5, -0.2, 4.815>
  }
  box { // CenefaMC
    <-1, -1, -1>, <1, 1, 1>
    scale <5.25, 0.075, 0.025>
    translate  <-7.5, -0.175, 4.765>
  }
  translate  4.4*z
}
#declare CENEFAS = union {
  object { CenefaM1 }
  object { CenefitaM1 }
  object { // CenefitaM2->Cenefita-1
    CenefitaM1
    translate  5.2*x
  }
  object { CenefitaM3 }
  object { // CenefitaM4->Cenefita-3
    CenefitaM3
    translate  5.2*x
  }
  object { Cenefis }
  object { // Cenefis1->Cenefis
    Cenefis
    translate  4.4*z
  }
  object { Cenepupis }
  object { // Cenepupis1->Cenepupis
    Cenepupis
    translate  4.4*z
  }
  texture {
    Piedra1
  }
}
#declare CSG1 = difference {
  cylinder { // CilBase
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 2.6>
    translate  0.84*z
  }
  object { CilMuesca }
  object { // CilMuesca1->CilMuesca
    CilMuesca
    rotate -15.0*z
    translate  0.0*x
  }
  object { // CilMuesca2->CilMuesca
    CilMuesca
    rotate -30.0*z
  }
  object { // CilMuesca3->CilMuesca
    CilMuesca
    rotate -45.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // CilMuesca4->CilMuesca
    CilMuesca
    rotate -60.0*z
    translate  -0.0*x
  }
  object { // CilMuesca5->CilMuesca
    CilMuesca
    rotate -75.0*z
    translate  -0.0*x
  }
  object { // CilMuesca6->CilMuesca
    CilMuesca
    rotate -90.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca7->CilMuesca
    CilMuesca
    rotate -105.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca8->CilMuesca
    CilMuesca
    rotate -120.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca9->CilMuesca
    CilMuesca
    rotate -135.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // CilMuesca10->CilMuesca
    CilMuesca
    rotate -150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca11->CilMuesca
    CilMuesca
    rotate -165.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca12->CilMuesca
    CilMuesca
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca13->CilMuesca
    CilMuesca
    rotate 165.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca14->CilMuesca
    CilMuesca
    rotate 150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // CilMuesca15->CilMuesca
    CilMuesca
    rotate 135.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca16->CilMuesca
    CilMuesca
    rotate 120.0*z
    translate  0.0*x
  }
  object { // CilMuesca17->CilMuesca
    CilMuesca
    rotate 105.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca18->CilMuesca
    CilMuesca
    rotate 90.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca19->CilMuesca
    CilMuesca
    rotate 75.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // CilMuesca20->CilMuesca
    CilMuesca
    rotate 60.0*z
    translate  -0.0*y
  }
  object { // CilMuesca21->CilMuesca
    CilMuesca
    rotate 45.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // CilMuesca22->CilMuesca
    CilMuesca
    rotate 30.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // CilMuesca23->CilMuesca
    CilMuesca
    rotate 15.0*z
    translate  <-0.0, -0.0, 0.0>
  }
}
#declare Columna = union {
  object { CuboBase1 }
  object { // CuboBase2->CuboBase1
    CuboBase1
    translate  3.1*z
  }
  object { ToroBase1 }
  object { // ToroBase2->ToroBase1
    ToroBase1
    translate  2.9*z
  }
  object { // ToritBase2->ToritBase1
    ToritBase1
    translate  2.7*z
  }
  object { ToritBase1 }
  object { CSG1 }
  translate  <-10.1, -0.6, 0.0>
}
#declare Columna1 = object {
  object { // Columna1->Columna
    Columna
    translate  5.2*x
  }
}
#declare Columna2 = object {
  object { // Columna2->Columna1
    Columna1
    translate  4.4*z
  }
}
#declare COLUMNAS = union {
  object { Columna1 }
  object { Columna2 }
  object { // Columna3->Columna2
    Columna2
    translate  -5.2*x
  }
  object { Columna }
  texture {
    TexColumna1
  }
}
#declare AdornoM2 = object {
  object { // AdornoM2->Adorno-1
    AdornoM1
    translate  5.2*x
  }
}
#declare PiedraMD1 = object {
  object { // PiedraMD1->Piedra-D
    PiedraMD
    translate  0.4*z
  }
}
#declare PiedraMD2 = object {
  object { // PiedraMD2->Piedra-D
    PiedraMD
    translate  <5.2, 0.0, -0.0>
  }
}
#declare PiedraMD3 = object {
  object { // PiedraMD3->Piedra-D2
    PiedraMD2
    translate  0.4*z
  }
}
#declare PiedraMD4 = object {
  object { // PiedraMD4->Piedra-D3
    PiedraMD3
    translate  4.0*z
  }
}
#declare PiedraMD6 = object {
  object { // PiedraMD6->Piedra-D1
    PiedraMD1
    translate  4.0*z
  }
}
#declare PiedrasCol = union {
  object { PiedraMD }
  object { PiedraMD1 }
  object { PiedraMD2 }
  object { PiedraMD3 }
  object { PiedraMD4 }
  object { // PiedraMD5->Piedra-D4
    PiedraMD4
    translate  0.4*z
  }
  object { PiedraMD6 }
  object { // PiedraMD7->Piedra-D6
    PiedraMD6
    translate  0.4*z
  }
  object { // PiedraMD10->Piedra-D
    PiedraMD
    translate  0.8*z
  }
  object { // PiedraMD11->Piedra-D2
    PiedraMD2
    translate  0.8*z
  }
  object { // PiedraMD12->Piedra-D4
    PiedraMD4
    translate  0.8*z
  }
  object { // PiedraMD13->Piedra-D6
    PiedraMD6
    translate  0.8*z
  }
}
#declare ADORNOCOL = union {
  object { AdornoM1 }
  object { AdornoM2 }
  object { // AdornoM3->Adorno-2
    AdornoM2
    translate  4.4*z
  }
  object { // AdornoM4->Adorno-1
    AdornoM1
    translate  4.4*z
  }
  object { PiedrasCol }
  texture {
    Piedra2
  }
}
#declare CSG3 = difference {
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  translate  <-12.55, -0.15, 9.04>
}
#declare CSG13 = object {
  object { // CSG13->CSG3
    CSG3
    rotate 0.0*z
    translate  10.1*x
  }
}
#declare CSG23 = difference {
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  translate  <-10.55, -1.15, 9.04>
}
#declare CSG28 = object {
  object { // CSG28->CSG23
    CSG23
    translate  6.1*x
  }
}
#declare CSG33 = difference {
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  translate  <-10.55, -1.15, 4.64>
}
#declare CSG38 = object {
  object { // CSG38->CSG33
    CSG33
    translate  6.1*x
  }
}
#declare CSG92 = difference {
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  rotate 90.0*z
  translate  <-4.35, -1.05, 4.64>
}
#declare CSG98 = object {
  object { // CSG98->CSG92
    CSG92
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.0, 4.4>
  }
}
#declare Grupo1 = union {
  object { CSG3 }
  object { // CSG4->CSG3
    CSG3
    rotate 0.0*z
    translate  0.2*x
  }
  object { // CSG5->CSG3
    CSG3
    rotate 0.0*z
    translate  0.4*x
  }
  object { // CSG6->CSG3
    CSG3
    rotate 0.0*z
    translate  0.6*x
  }
  object { // CSG7->CSG3
    CSG3
    rotate 0.0*z
    translate  0.8*x
  }
  object { // CSG8->CSG3
    CSG3
    rotate 0.0*z
    translate  1.0*x
  }
  object { // CSG9->CSG3
    CSG3
    rotate 0.0*z
    translate  1.2*x
  }
  object { // CSG10->CSG3
    CSG3
    rotate 0.0*z
    translate  1.4*x
  }
  object { // CSG11->CSG3
    CSG3
    rotate 0.0*z
    translate  1.6*x
  }
  object { // CSG12->CSG3
    CSG3
    rotate 0.0*z
    translate  1.8*x
  }
  object { CSG13 }
  object { // CSG14->CSG13
    CSG13
    translate  -0.2*x
  }
  object { // CSG15->CSG13
    CSG13
    translate  -0.4*x
  }
  object { // CSG16->CSG13
    CSG13
    translate  -0.6*x
  }
  object { // CSG17->CSG13
    CSG13
    translate  -0.8*x
  }
  object { // CSG18->CSG13
    CSG13
    translate  -1.0*x
  }
  object { // CSG19->CSG13
    CSG13
    translate  -1.2*x
  }
  object { // CSG20->CSG13
    CSG13
    translate  -1.4*x
  }
  object { // CSG21->CSG13
    CSG13
    translate  -1.6*x
  }
  object { // CSG22->CSG13
    CSG13
    translate  -1.8*x
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.08, 0.1>
    translate  <-11.6, -0.08, 9.04>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.08, 0.1>
    translate  <-3.4, -0.08, 9.04>
  }
}
#declare Grupo2 = union {
  object { CSG23 }
  object { // CSG24->CSG23
    CSG23
    translate  0.2*x
  }
  object { // CSG25->CSG23
    CSG23
    translate  0.4*x
  }
  object { // CSG26->CSG23
    CSG23
    translate  0.6*x
  }
  object { // CSG27->CSG23
    CSG23
    translate  0.8*x
  }
  object { CSG28 }
  object { // CSG29->CSG28
    CSG28
    translate  -0.2*x
  }
  object { // CSG30->CSG28
    CSG28
    translate  -0.4*x
  }
  object { // CSG31->CSG28
    CSG28
    translate  -0.6*x
  }
  object { // CSG32->CSG28
    CSG28
    translate  -0.8*x
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.1>
    translate  <-4.9, -1.08, 9.04>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.1>
    translate  <-10.1, -1.08, 9.04>
  }
}
#declare Grupo3 = union {
  object { CSG33 }
  object { // CSG34->CSG33
    CSG33
    translate  0.2*x
  }
  object { // CSG35->CSG33
    CSG33
    translate  0.4*x
  }
  object { // CSG36->CSG33
    CSG33
    translate  0.6*x
  }
  object { // CSG37->CSG33
    CSG33
    translate  0.8*x
  }
  object { CSG38 }
  object { // CSG39->CSG38
    CSG38
    translate  -0.2*x
  }
  object { // CSG40->CSG38
    CSG38
    translate  -0.4*x
  }
  object { // CSG41->CSG38
    CSG38
    translate  -0.6*x
  }
  object { // CSG42->CSG38
    CSG38
    translate  -0.8*x
  }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.1>
    translate  <-4.9, -1.08, 4.64>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.08, 0.1>
    translate  <-10.1, -1.08, 4.64>
  }
}
#declare Grupo6 = union {
  object { CSG92 }
  object { // CSG93->CSG92
    CSG92
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.2, 0.0>
  }
  object { // CSG94->CSG92
    CSG92
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.4, 0.0>
  }
  object { // CSG95->CSG92
    CSG92
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.6, 0.0>
  }
  object { // CSG96->CSG92
    CSG92
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 0.8, 0.0>
  }
  object { // CSG97->CSG92
    CSG92
    rotate <0.0, 0.0, -0.0>
    translate  <-0.0, 1.0, 0.0>
  }
  object { CSG98 }
  object { // CSG99->CSG98
    CSG98
    rotate 0.0*x
    translate  0.2*y
  }
  object { // CSG100->CSG98
    CSG98
    rotate 0.0*x
    translate  0.4*y
  }
  object { // CSG101->CSG98
    CSG98
    rotate 0.0*x
    translate  0.6*y
  }
  object { // CSG102->CSG98
    CSG98
    rotate 0.0*x
    translate  0.8*y
  }
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.55, 0.1>
    translate  <-4.42, -0.58, 9.04>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.55, 0.1>
    translate  <-4.42, -0.58, 4.64>
  }
}
#declare AdornoCenef = union {
  object { Grupo1 }
  object { Grupo2 }
  object { Grupo3 }
  object { Grupo6 }
  texture {
    Piedra1
  }
}
#declare Cube001 = object {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.193, 0.01, 0.19>
    translate  -3.7377*y
  }
}
#declare Cube2 = object {
  object { // Cube2->Cube001
    Cube001
    rotate -6.23*z
    translate  <0.0, -0.0, 0.0>
  }
}
#declare Cube3 = object {
  object { // Cube3->Cube001
    Cube001
    rotate -12.46*z
    translate  <0.0, -0.0, 0.0>
  }
}
#declare Cube4 = object {
  object { // Cube4->Cube001
    Cube001
    rotate -18.690001*z
    translate  <0.0, -0.0, 0.0>
  }
}
#declare Cube5 = object {
  object { // Cube5->Cube001
    Cube001
    rotate -24.92*z
    translate  <0.0, -0.0, 0.0>
  }
}
#declare Cube6 = object {
  object { // Cube6->Cube001
    Cube001
    rotate -31.15*z
    translate  <-0.0, 0.0, 0.0>
  }
}
#declare Cube7 = object {
  object { // Cube7->Cube001
    Cube001
    rotate 6.23*z
    translate  <-0.0, -0.0, 0.0>
  }
}
#declare Cube8 = object {
  object { // Cube8->Cube001
    Cube001
    rotate 12.46*z
    translate  <-0.0, -0.0, 0.0>
  }
}
#declare Cube9 = object {
  object { // Cube9->Cube001
    Cube001
    rotate 18.690001*z
    translate  <-0.0, -0.0, 0.0>
  }
}
#declare Cube10 = object {
  object { // Cube10->Cube001
    Cube001
    rotate 24.92*z
    translate  <-0.0, -0.0, 0.0>
  }
}
#declare Cube11 = object {
  object { // Cube11->Cube001
    Cube001
    rotate 31.15*z
    translate  <0.0, 0.0, 0.0>
  }
}
#declare EnchCirc = union {
  object { Cube001 }
  object { Cube2 }
  object { Cube3 }
  object { Cube4 }
  object { Cube5 }
  object { Cube6 }
  object { Cube7 }
  object { Cube8 }
  object { Cube9 }
  object { Cube10 }
  object { Cube11 }
  object { // Cube12->Cube001
    Cube001
    translate  <0.0, -0.0, -0.4>
  }
  object { // Cube13->Cube2
    Cube2
    rotate -0.0*z
    translate  -0.4*z
  }
  object { // Cube14->Cube3
    Cube3
    rotate 0.0*z
    translate  <0.0, -0.0, -0.4>
  }
  object { // Cube15->Cube5
    Cube5
    translate  <0.0, -0.0, -0.4>
  }
  object { // Cube16->Cube4
    Cube4
    translate  -0.4*z
  }
  object { // Cube17->Cube6
    Cube6
    translate  -0.4*z
  }
  object { // Cube18->Cube8
    Cube8
    rotate -0.0*z
    translate  <0.0, -0.0, -0.4>
  }
  object { // Cube19->Cube7
    Cube7
    rotate 0.0*z
    translate  -0.4*z
  }
  object { // Cube20->Cube9
    Cube9
    translate  -0.4*z
  }
  object { // Cube21->Cube10
    Cube10
    translate  <0.0, -0.0, -0.4>
  }
  object { // Cube22->Cube11
    Cube11
    translate  -0.4*z
  }
  translate  <-7.5, 2.0, 4.34>
}
#declare PisoVoladizo = union {
  cylinder { // PisoCil1
    <0,0,1>, <0,0,0>, 1
    scale <3.7377, 3.7377, 1.19>
    translate  <-7.5, 2.0, 3.75>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <4.0477, 4.0477, 0.1>
    translate  <-7.5, 2.0, 4.84>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <3.9477, 3.9477, 0.05>
    translate  <-7.5, 2.0, 4.79>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <3.8977, 3.8977, 0.05>
    translate  <-7.5, 2.0, 4.74>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    scale <3.8477, 3.8477, 0.05>
    translate  <-7.5, 2.0, 4.69>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    scale <3.7977, 3.7977, 0.05>
    translate  <-7.5, 2.0, 4.64>
  }
}
#declare Voladizo = difference {
  object { PisoVoladizo }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <4.1, 3.2, 0.7>
    translate  <-7.5, 3.2, 4.34>
  }
}
#declare CURVA = union {
  object { EnchCirc }
  object { Voladizo }
  texture {
    Piedra1
  }
}
#declare Hueco1 = object {
  box { // Hueco1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.3, 1.2>
    translate  <-8.8, 0.2, 1.74>
  }
}
#declare Hueco2 = object {
  object { // Hueco2->Hueco1
    Hueco1
    rotate 0.0*y
    translate  2.6*x
  }
}
#declare Hueco3 = object {
  object { // Hueco3->Hueco2
    Hueco2
    translate  4.4*z
  }
}
#declare CSGMA1 = difference {
  box { // MuroFrente
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.2, 4.4>
    translate  <-7.5, 0.2, 4.94>
  }
  object { Hueco1 }
  object { Hueco2 }
  object { Hueco3 }
  object { // Hueco4->Hueco3
    Hueco3
    translate  -2.6*x
  }
  texture {
    Muros1
  }
}
#declare MUROMFREN = union {
  object { CSGMA1 }
}
#declare FACHMFRENTE = union {
  object { PIEDRAS }
  object { CENEFAS }
  object { COLUMNAS }
  object { ADORNOCOL }
  object { AdornoCenef }
  object { CURVA }
  object { MUROMFREN }
  object { // CURVA1->CURVA
    CURVA
    translate  4.4*z
  }
}
#declare CSG134 = difference {
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.05, 0.1>
  }
  cone { // Cone10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.1, 0.2, 0.3>
    rotate 90.0*x
    translate  <0.0, 0.2, -0.1>
  }
  rotate 90.0*z
  translate  <12.65, -0.1, 9.04>
}
#declare PiedraMA22 = object {
  box { // PiedraMA22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 0.19>
    translate  <12.3, 14.8, 0.74>
  }
}
#declare PiedraMB20 = object {
  box { // PiedraMB20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.19>
    translate  <12.4, 14.9, 1.14>
  }
}
#declare Torus2 = object {
  torus { // Torus2
    0.05, 0.01  rotate -x*90
    translate  0.04*z
  }
}
#declare ParM1 = union {
  sphere { // Sphere3
    <0,0,0>,1
    scale <0.12, 0.12, 0.14>
    translate  0.185*z
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.015>
    translate  0.015*z
  }
  torus { // Torus4
    0.05, 0.01  rotate -x*90
    translate  0.04*z
  }
  cone { // Cone12
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.11, 0.11, 0.7>
    rotate 180.0*x
    translate  <0.0, 0.0, 0.933175>
  }
  cone { // Cone13
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.08, 0.08, 0.1>
    translate  0.559477*z
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <0.1, 0.1, 0.07>
    translate  0.7*z
  }
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.015>
    translate  0.805*z
  }
  object { // Torus5->Torus2
    Torus2
    translate  0.735*z
  }
  translate  -3.93*y
}
#declare Parales = union {
  object { // ParM2->Par-1
    ParM1
    rotate -5.102678*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ParM3->Par-1
    ParM1
    rotate -10.205356*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ParM4->Par-1
    ParM1
    rotate -15.308034*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ParM5->Par-1
    ParM1
    rotate -20.410711*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ParM6->Par-1
    ParM1
    rotate -25.51339*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ParM7->Par-1
    ParM1
    rotate -30.616068*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // ParM8->Par-1
    ParM1
    rotate -35.718746*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // ParM10->Par-1
    ParM1
    rotate 5.102678*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // ParM11->Par-1
    ParM1
    rotate 10.205356*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // ParM12->Par-1
    ParM1
    rotate 15.308034*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // ParM13->Par-1
    ParM1
    rotate 20.410711*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // ParM14->Par-1
    ParM1
    rotate 25.51339*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // ParM15->Par-1
    ParM1
    rotate 30.616068*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // ParM16->Par-1
    ParM1
    rotate 35.718746*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { ParM1 }
  translate  <-7.5, 2.0, 4.94>
}
#declare CSG002 = union {
  torus { // Torus002
    4.005, 0.075  rotate -x*90
    translate  <-7.5, 2.0, 5.835>
  }
  torus { // Torus003
    3.855, 0.075  rotate -x*90
    translate  <-7.5, 2.0, 5.835>
  }
}
#declare Pasam = difference {
  object { CSG002 }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    scale <4.2, 4.0, 0.1>
    translate  <-7.5, 3.3, 5.835>
  }
  box { // Cubito3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.0, 0.2>
    rotate -25.0*z
    translate  <-4.491932, -0.064351, 5.835>
  }
  box { // Cubito4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.0, 0.2>
    rotate 25.0*z
    translate  <-10.583136, -0.090962, 5.835>
  }
}
#declare Pasaman = difference {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1
    scale <4.005, 4.005, 0.15>
    translate  <-7.5, 2.0, 5.76>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1
    scale <3.855, 3.855, 0.2>
    translate  <-7.5, 2.0, 5.735>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <4.2, 4.0, 0.1>
    translate  <-7.5, 3.3, 5.835>
  }
  box { // Cubito1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.0, 0.2>
    rotate -25.0*z
    translate  <-4.506498, -0.057068, 5.835>
  }
  box { // Cubito2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 1.0, 0.2>
    rotate 25.0*z
    translate  <-10.561288, -0.080038, 5.835>
  }
}
#declare Pasamanos = union {
  object { Pasam }
  object { Pasaman }
}
#declare BarandaCirc1 = union {
  object { Parales }
  object { Pasamanos }
  texture {
    TexColumna1
  }
}
#declare ParalM2 = union {
  sphere { // Sphere5
    <0,0,0>,1
    scale <0.12, 0.12, 0.14>
    translate  0.185*z
  }
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.015>
    translate  0.015*z
  }
  torus { // Torus6
    0.05, 0.01  rotate -x*90
    translate  0.04*z
  }
  cone { // Cone14
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.11, 0.11, 0.7>
    rotate 180.0*x
    translate  <0.0, 0.0, 0.933175>
  }
  cone { // Cone15
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.08, 0.08, 0.1>
    translate  0.559477*z
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale <0.1, 0.1, 0.07>
    translate  0.7*z
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.015>
    translate  0.805*z
  }
  object { // Torus7->Torus2
    Torus2
    translate  0.735*z
  }
  translate  <-2.78, -4.28, 4.94>
}
#declare ParalM17 = object {
  object { // ParalM17->Paral-2
    ParalM2
    translate  5.2125*x
  }
}
#declare ParalM18 = object {
  object { // ParalM18->Paral-17
    ParalM17
    translate  0.3475*x
  }
}
#declare Cube023 = object {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 2.215, 0.075>
    translate  <-2.78, -2.215, 5.835>
  }
}
#declare PisoBase2 = object {
  box { // PisoBase2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 2.0, 0.26>
    translate  <-2.1, -2.0, 0.26>
  }
}
#declare MuroIzqCentro = object {
  box { // MuroIzqCentro
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.8, 4.4>
    translate  <-2.7, 1.2, 4.94>
  }
}
#declare Vano1 = object {
  box { // Vano1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.8, 0.715>
    translate  <12.3, 3.5, 2.225>
  }
}
#declare Vano4 = object {
  object { // Vano4->Vano1
    Vano1
    rotate <-0.0, -0.0, 0.0>
    translate  <0.0, -0.0, 4.4>
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 0.6>
    rotate 90.0*x
    translate  0.3*y
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.35, 1.8>
    translate  -0.201*z
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.35, 0.15>
    translate  <-1.35, 0.0, 1.5>
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 0.35, 0.15>
    translate  <1.35, 0.0, 1.5>
  }
  translate  <0.0, 2.2, 1.74>
}
#declare MarcoSup = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 0.2>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <1.96, 1.96, 0.24>
    translate  -0.02*z
  }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 2.0, 0.12>
    translate  <0.0, -0.45, 0.1>
  }
  rotate 90.0*x
  translate  <0.0, 0.1, 1.2>
}
#declare Marcote = union {
  object { MarcoSup }
  box { // MarcoIzq
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.1, 1.4>
    translate  <-1.18, 0.0, 1.4>
  }
  box { // MarcoDer
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.1, 1.4>
    translate  <1.18, 0.0, 1.4>
  }
  texture {
    Madera2
  }
}
#declare PeinCirc = difference {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <1.96, 1.96, 0.08>
    rotate 90.0*x
    translate  <0.0, 0.04, 1.2>
  }
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.05, 2.1>
    translate  0.5*z
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <1.88, 1.88, 0.1>
    rotate 90.0*x
    translate  <0.0, 0.05, 1.2>
  }
}
#declare RemateSup = union {
  box { // TableroSup
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Madera2
    }
    scale <1.08, 0.015, 0.3>
    translate  2.78*z
  }
  box { // Peinazo1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.16, 0.04, 0.04>
    translate  2.44*z
  }
  box { // Peinazo2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.04, 0.2>
    translate  <-1.12, 0.0, 2.6>
  }
  box { // Peinazo3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.04, 0.04, 0.2>
    translate  <1.12, 0.0, 2.6>
  }
  object { PeinCirc }
}
#declare Torus8 = object {
  torus { // Torus8
    0.15, 0.015  rotate -x*90
    rotate 90.0*x
    translate  <-0.7, -0.015, 2.68>
  }
}
#declare Cone16 = object {
  cone { // Cone16
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.04, 0.04, 0.03>
    rotate -90.0*x
    translate  <-0.7, -0.06, 2.68>
  }
}
#declare Torus004 = object {
  torus { // Torus004
    0.188, 0.012  rotate -x*90
    scale <1.0, 0.47, 1.0>
    rotate 90.0*x
    translate  <-0.2, -0.015, 2.68>
  }
}
#declare AdornosSup = union {
  object { Torus8 }
  torus { // Torus9
    0.1, 0.012  rotate -x*90
    rotate 90.0*x
    translate  <0.0, -0.015, 2.93>
  }
  torus { // Torus10
    0.35, 0.015  rotate -x*90
    scale <1.0, 0.14, 1.0>
    rotate 90.0*x
    translate  <0.0, -0.015, 2.93>
  }
  object { Cone16 }
  object { // Torus11->Torus8
    Torus8
    translate  1.4*x
  }
  object { // Cone17->Cone16
    Cone16
    rotate <-0.0, -0.0, -0.0>
    translate  <1.4, 0.0, 0.0>
  }
  object { Torus004 }
  object { // Torus12->Torus004
    Torus004
    rotate -0.0*x
    translate  0.2*x
  }
  object { // Torus13->Torus004
    Torus004
    rotate -0.0*x
    translate  0.4*x
  }
}
#declare Peina1 = object {
  box { // Peina1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.06, 0.04, 1.1925>
    translate  <-1.095, 0.0, 1.2025>
  }
}
#declare Peina2 = object {
  box { // Peina2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.065, 0.04, 1.1925>
    translate  <-0.07, 0.0, 1.2025>
  }
}
#declare Peina5 = object {
  box { // Peina5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.04, 0.065>
    translate  <-0.585, 0.0, 0.075>
  }
}
#declare Peina6 = object {
  object { // Peina6->Peina5
    Peina5
    rotate 0.0*y
    translate  0.985*z
  }
}
#declare Peina7 = object {
  object { // Peina7->Peina5
    Peina5
    rotate 0.0*y
    translate  2.255*z
  }
}
#declare PeinaPuerta = union {
  object { Peina1 }
  object { Peina2 }
  object { // Peina3->Peina1
    Peina1
    rotate 0.0*y
    translate  2.19*x
  }
  object { // Peina4->Peina2
    Peina2
    rotate -0.0*y
    translate  0.14*x
  }
  object { Peina5 }
  object { Peina6 }
  object { Peina7 }
  object { // Peina8->Peina5
    Peina5
    rotate -0.0*y
    translate  1.17*x
  }
  object { // Peina9->Peina6
    Peina6
    translate  1.17*x
  }
  object { // Peina10->Peina7
    Peina7
    translate  1.17*x
  }
}
#declare Cylndr6 = object {
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.013, 1.14>
    translate  <-0.735, 0.0, 1.125>
  }
}
#declare Cylndr7 = object {
  object { // Cylndr7->Cylndr6
    Cylndr6
    rotate -0.0*y
    translate  <0.3, 0.0, 0.0>
  }
}
#declare Cylndr8 = object {
  object { // Cylndr8->Cylndr7
    Cylndr7
    translate  0.87*x
  }
}
#declare Cylndr9 = object {
  object { // Cylndr9->Cylndr8
    Cylndr8
    translate  0.3*x
  }
}
#declare Cylndr10 = object {
  object { // Cylndr10->Cylndr6
    Cylndr6
    rotate -0.0*y
    translate  <-0.3, 0.0, 0.0>
  }
}
#declare Cylndr11 = object {
  object { // Cylndr11->Cylndr9
    Cylndr9
    translate  0.3*x
  }
}
#declare Cylndr14 = object {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.013, 0.9>
    rotate -90.0*y
    translate  <-0.135, 0.0, 1.125>
  }
}
#declare Cylndr18 = object {
  object { // Cylndr18->Cylndr14
    Cylndr14
    translate  1.17*x
  }
}
#declare Divisiones = union {
  object { Cylndr6 }
  object { Cylndr7 }
  object { Cylndr8 }
  object { Cylndr9 }
  object { Cylndr10 }
  object { Cylndr11 }
  object { // Cylndr12->Cylndr11
    Cylndr11
    translate  -0.9*x
  }
  object { // Cylndr13->Cylndr10
    Cylndr10
    translate  0.9*x
  }
  object { Cylndr14 }
  object { // Cylndr15->Cylndr14
    Cylndr14
    translate  0.38*z
  }
  object { // Cylndr16->Cylndr14
    Cylndr14
    translate  0.76*z
  }
  object { // Cylndr17->Cylndr14
    Cylndr14
    translate  1.14*z
  }
  object { Cylndr18 }
  object { // Cylndr19->Cylndr18
    Cylndr18
    translate  0.38*z
  }
  object { // Cylndr20->Cylndr18
    Cylndr18
    translate  0.76*z
  }
  object { // Cylndr21->Cylndr18
    Cylndr18
    translate  1.14*z
  }
  texture {
    Madera2
  }
}
#declare TableroInf = object {
  box { // TableroInf
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Madera2
    }
    scale <0.45, 0.015, 0.4275>
    translate  <-0.585, 0.0, 0.5675>
  }
}
#declare Torus005 = object {
  torus { // Torus005
    0.32, 0.012  rotate -x*90
    rotate 90.0*x
    translate  <-0.585, -0.015, 0.5675>
  }
}
#declare Torus006 = object {
  torus { // Torus006
    0.25, 0.012  rotate -x*90
    rotate 90.0*x
    translate  <-0.585, -0.015, 0.5675>
  }
}
#declare Cone18 = object {
  cone { // Cone18
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.05, 0.05, 0.04>
    rotate -90.0*x
    translate  <-0.585, -0.065, 0.5675>
  }
}
#declare Adornos = union {
  object { Torus005 }
  object { Torus006 }
  object { Cone18 }
  object { // Cone19->Cone18
    Cone18
    rotate <0.0, -0.0, -0.0>
    translate  <1.17, -0.0, 0.0>
  }
  object { // Torus14->Torus006
    Torus006
    translate  1.17*x
  }
  object { // Torus15->Torus005
    Torus005
    translate  1.17*x
  }
}
#declare Cristal1 = object {
  box { // Cristal1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass_2
    }
    scale <0.45, 0.003, 0.57>
    translate  <-0.585, 0.0, 1.695>
  }
}
#declare Torus007 = object {
  torus { // Torus007
    0.1, 0.015  rotate -x*90
    scale <1.0, 0.5, 1.0>
    rotate 90.0*y
    translate  <-0.08, -0.06, 1.06>
  }
}
#declare Sphere7 = object {
  sphere { // Sphere7
    <0,0,0>,1
    scale <0.03, 0.02, 0.02>
    translate  <-0.08, -0.12, 1.14>
  }
}
#declare Manij = union {
  object { Torus007 }
  object { Sphere7 }
  object { // Torus16->Torus007
    Torus007
    rotate -0.0*y
    translate  0.16*x
  }
  object { // Sphere8->Sphere7
    Sphere7
    rotate -0.0*x
    translate  <0.16, 0.0, 0.0>
  }
  texture {
    GOLD1
  }
}
#declare PUERTAMPRINC = union {
  object { Marcote }
  object { RemateSup }
  object { AdornosSup }
  object { PeinaPuerta }
  object { Divisiones }
  object { // TableroInf1->TableroInf
    TableroInf
    rotate -0.0*y
    translate  <1.17, 0.0, 0.0>
  }
  object { Adornos }
  object { Cristal1 }
  object { // Cristal2->Cristal1
    Cristal1
    rotate -0.0*y
    translate  1.17*x
  }
  object { TableroInf }
  object { Manij }
  texture {
    Madera1
  }
  translate  <0.0, 2.2, 0.54>
}
#declare Marco1 = union {
  box { // Cube58
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.1, 0.02>
    translate  <8.8, 0.2, 1.84>
  }
  box { // Cube59
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.1, 1.18>
    translate  <8.02, 0.2, 0.64>
  }
  box { // Cube60
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.1, 1.18>
    translate  <9.58, 0.2, 0.64>
  }
  texture {
    Madera2
  }
  translate  <-8.8, -0.2, 0.54>
}
#declare Cube61 = object {
  box { // Cube61
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.04, 1.1725>
    translate  <-0.705, 0.0, 1.1825>
  }
}
#declare Cube62 = object {
  object { // Cube62->Cube61
    Cube61
    rotate 0.0*y
    translate  <0.65, 0.0, 0.0>
  }
}
#declare Cube63 = object {
  object { // Cube63->Cube62
    Cube62
    translate  0.11*x
  }
}
#declare Cube70 = object {
  box { // Cube70
    <-1, -1, -1>, <1, 1, 1>
    scale <0.275, 0.04, 0.05>
    translate  <-0.38, 0.0, 0.06>
  }
}
#declare Cube65 = object {
  object { // Cube65->Cube70
    Cube70
    rotate 0.0*y
    translate  <0.76, 0.0, 0.0>
  }
}
#declare Cube66 = object {
  object { // Cube66->Cube65
    Cube65
    translate  2.245*z
  }
}
#declare Cube67 = object {
  object { // Cube67->Cube70
    Cube70
    rotate 0.0*y
    translate  <-0.0, 0.0, 2.245>
  }
}
#declare Peinaz = union {
  object { Cube61 }
  object { Cube62 }
  object { Cube63 }
  object { // Cube64->Cube63
    Cube63
    translate  0.65*x
  }
  object { Cube65 }
  object { Cube66 }
  object { Cube67 }
  object { // Cube68->Cube67
    Cube67
    rotate -0.0*y
    translate  <-0.0, 0.0, -1.24>
  }
  object { // Cube69->Cube66
    Cube66
    translate  -1.24*z
  }
  object { Cube70 }
}
#declare Cube71 = object {
  box { // Cube71
    <-1, -1, -1>, <1, 1, 1>
    scale <0.275, 0.015, 0.4525>
    translate  <-0.38, 0.0, 0.5625>
  }
}
#declare Tabler = union {
  object { Cube71 }
  object { // Cube72->Cube71
    Cube71
    rotate 0.0*y
    translate  0.76*x
  }
  texture {
    Madera2
  }
}
#declare Cylndr22 = object {
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.013, 1.14>
    translate  <-0.655, 0.0, 1.115>
  }
}
#declare Cylndr25 = object {
  object { // Cylndr25->Cylndr22
    Cylndr22
    rotate 0.0*y
    translate  <1.31, 0.0, -0.0>
  }
}
#declare Cylndr28 = object {
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.013, 0.55>
    rotate 90.0*y
    translate  <-0.655, 0.0, 2.255>
  }
}
#declare Cylndr46 = object {
  object { // Cylndr46->Cylndr28
    Cylndr28
    rotate -0.0*y
    translate  <0.76, 0.0, 0.0>
  }
}
#declare Divis = union {
  object { Cylndr22 }
  object { // Cylndr23->Cylndr22
    Cylndr22
    rotate 0.0*y
    translate  <0.275, 0.0, -0.0>
  }
  object { // Cylndr24->Cylndr22
    Cylndr22
    rotate 0.0*y
    translate  <0.55, 0.0, -0.0>
  }
  object { Cylndr25 }
  object { // Cylndr26->Cylndr25
    Cylndr25
    translate  -0.275*x
  }
  object { // Cylndr27->Cylndr25
    Cylndr25
    translate  -0.55*x
  }
  object { Cylndr28 }
  object { // Cylndr29->Cylndr28
    Cylndr28
    rotate -0.0*y
    translate  -0.38*z
  }
  object { // Cylndr44->Cylndr28
    Cylndr28
    rotate -0.0*y
    translate  -0.76*z
  }
  object { // Cylndr45->Cylndr28
    Cylndr28
    rotate -0.0*y
    translate  -1.14*z
  }
  object { Cylndr46 }
  object { // Cylndr47->Cylndr46
    Cylndr46
    translate  -0.38*z
  }
  object { // Cylndr48->Cylndr46
    Cylndr46
    translate  -0.76*z
  }
  object { // Cylndr49->Cylndr46
    Cylndr46
    translate  -1.14*z
  }
  texture {
    Madera2
  }
}
#declare Vidrio1 = object {
  box { // Vidrio1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass_2
    }
    scale <0.275, 0.003, 0.57>
    translate  <-0.38, 0.0, 1.685>
  }
}
#declare Maniji1 = object {
  torus { // Maniji1
    0.1, 0.015  rotate -x*90
    scale <1.0, 0.5, 1.0>
    rotate 90.0*y
    translate  <-0.06, -0.06, 1.065>
  }
}
#declare Sphere9 = object {
  sphere { // Sphere9
    <0,0,0>,1
    scale <0.03, 0.02, 0.02>
    translate  <-0.06, -0.12, 1.14>
  }
}
#declare Manijas = union {
  object { Maniji1 }
  object { // Maniji2->Maniji1
    Maniji1
    rotate 0.0*z
    translate  <0.12, -0.0, 0.0>
  }
  object { Sphere9 }
  object { // Sphere10->Sphere9
    Sphere9
    translate  0.12*x
  }
  texture {
    GOLD1
  }
}
#declare Torus17 = object {
  torus { // Torus17
    0.23, 0.01  rotate -x*90
    rotate 90.0*x
    translate  <-0.38, -0.015, 0.5625>
  }
}
#declare Torus18 = object {
  torus { // Torus18
    0.18, 0.0075  rotate -x*90
    rotate 90.0*x
    translate  <-0.38, -0.015, 0.5625>
  }
}
#declare Cone20 = object {
  cone { // Cone20
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.04, 0.04, 0.03>
    rotate -90.0*x
    translate  <-0.38, -0.055, 0.5625>
  }
}
#declare Adorni = union {
  object { Torus17 }
  object { Torus18 }
  object { Cone20 }
  object { // Torus19->Torus17
    Torus17
    translate  0.76*x
  }
  object { // Torus20->Torus18
    Torus18
    translate  0.76*x
  }
  object { // Cone21->Cone20
    Cone20
    rotate <0.0, 0.0, 0.0>
    translate  <0.76, -0.0, 0.0>
  }
}
#declare Puerta1 = union {
  object { Marco1 }
  object { Peinaz }
  object { Tabler }
  object { Divis }
  object { Vidrio1 }
  object { // Vidrio2->Vidrio1
    Vidrio1
    rotate 0.0*y
    translate  0.76*x
  }
  object { Manijas }
  object { Adorni }
  texture {
    Madera1
  }
  translate  <-8.8, 0.2, 0.54>
}
#declare Puerta2 = object {
  object { // Puerta2->Puerta1
    Puerta1
    translate  2.6*x
  }
}
#declare Puerta3 = object {
  object { // Puerta3->Puerta2
    Puerta2
    translate  4.4*z
  }
}
#declare Puerta4 = object {
  object { // Puerta4->Puerta3
    Puerta3
    translate  -2.6*x
  }
}
#declare Puerta5 = object {
  object { // Puerta5->Puerta4
    Puerta4
    translate  17.6*x
  }
}
#declare Puerta6 = object {
  object { // Puerta6->Puerta5
    Puerta5
    translate  -2.6*x
  }
}
#declare Puerta7 = object {
  object { // Puerta7->Puerta6
    Puerta6
    translate  -4.4*z
  }
}
#declare Marco = union {
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.1, 0.02>
    translate  2.38*z
  }
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.1, 0.675>
    translate  <-0.78, 0.0, 1.685>
  }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.1, 0.675>
    translate  <0.78, 0.0, 1.685>
  }
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 0.1, 0.02>
    translate  0.99*z
  }
}
#declare Cube50 = object {
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.04, 0.67>
    translate  <-0.705, 0.0, 1.685>
  }
}
#declare Cube51 = object {
  object { // Cube51->Cube50
    Cube50
    rotate 0.0*y
    translate  0.65*x
  }
}
#declare Cube52 = object {
  object { // Cube52->Cube51
    Cube51
    translate  0.11*x
  }
}
#declare Cube54 = object {
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    scale <0.275, 0.04, 0.05>
    translate  <-0.38, 0.0, 1.065>
  }
}
#declare Cube55 = object {
  object { // Cube55->Cube54
    Cube54
    rotate 0.0*y
    translate  <-0.0, 0.0, 1.24>
  }
}
#declare Cube56 = object {
  object { // Cube56->Cube55
    Cube55
    translate  0.76*x
  }
}
#declare Peina = union {
  object { Cube50 }
  object { Cube51 }
  object { Cube52 }
  object { // Cube53->Cube52
    Cube52
    translate  0.65*x
  }
  object { Cube54 }
  object { Cube55 }
  object { Cube56 }
  object { // Cube57->Cube56
    Cube56
    translate  -1.24*z
  }
  texture {
    Madera1
  }
}
#declare Cylndr30 = object {
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.013, 1.14>
    translate  <-0.655, 0.0, 1.115>
  }
}
#declare Cylndr32 = object {
  object { // Cylndr32->Cylndr30
    Cylndr30
    rotate 0.0*y
    translate  <0.55, 0.0, -0.0>
  }
}
#declare Cylndr33 = object {
  object { // Cylndr33->Cylndr32
    Cylndr32
    translate  0.21*x
  }
}
#declare Cylndr36 = object {
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.013, 0.55>
    rotate 90.0*y
    translate  <-0.655, 0.0, 2.255>
  }
}
#declare Cylndr40 = object {
  object { // Cylndr40->Cylndr36
    Cylndr36
    rotate -0.0*y
    translate  <0.76, 0.0, 0.0>
  }
}
#declare Divi = union {
  object { Cylndr30 }
  object { // Cylndr31->Cylndr30
    Cylndr30
    rotate 0.0*y
    translate  <0.275, 0.0, -0.0>
  }
  object { Cylndr32 }
  object { Cylndr33 }
  object { // Cylndr34->Cylndr33
    Cylndr33
    translate  0.275*x
  }
  object { // Cylndr35->Cylndr33
    Cylndr33
    translate  0.55*x
  }
  object { Cylndr36 }
  object { // Cylndr37->Cylndr36
    Cylndr36
    rotate -0.0*y
    translate  -0.38*z
  }
  object { // Cylndr38->Cylndr36
    Cylndr36
    rotate -0.0*y
    translate  -0.76*z
  }
  object { // Cylndr39->Cylndr36
    Cylndr36
    rotate -0.0*y
    translate  -1.14*z
  }
  object { Cylndr40 }
  object { // Cylndr41->Cylndr40
    Cylndr40
    translate  -0.38*z
  }
  object { // Cylndr42->Cylndr40
    Cylndr40
    translate  -0.76*z
  }
  object { // Cylndr43->Cylndr40
    Cylndr40
    translate  -1.14*z
  }
}
#declare Vidri1 = object {
  box { // Vidri1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Glass_2
    }
    scale <0.275, 0.003, 0.57>
    translate  <-0.38, 0.0, 1.685>
  }
}
#declare Ventana1 = union {
  object { Marco }
  object { Peina }
  object { Divi }
  object { Vidri1 }
  object { // Vidri2->Vidri1
    Vidri1
    rotate 0.0*y
    translate  0.76*x
  }
  texture {
    Madera2
  }
  rotate 90.0*z
  translate  <12.3, 3.5, 0.54>
}
#declare Ventana4 = object {
  object { // Ventana4->Ventana1
    Ventana1
    rotate -0.0*z
    translate  <0.0, 0.0, 4.4>
  }
}
#declare Muro_Lobby_Izq = object {
  box { // Muro_Lobby_Izq
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.5, 4.21>
    translate  <-2.7, 8.9, 4.73>
  }
}





#declare Grupo4 = union {
  object { CSG43 }
  object { // CSG44->CSG43
    CSG43
    translate  0.2*x
  }
  object { // CSG45->CSG43
    CSG43
    translate  0.4*x
  }
  object { // CSG46->CSG43
    CSG43
    translate  0.6*x
  }
  object { // CSG47->CSG43
    CSG43
    translate  0.8*x
  }
  object { // CSG48->CSG43
    CSG43
    translate  1.0*x
  }
  object { // CSG49->CSG43
    CSG43
    translate  1.2*x
  }
  object { // CSG50->CSG43
    CSG43
    translate  1.4*x
  }
  object { // CSG51->CSG43
    CSG43
    translate  1.6*x
  }
  object { // CSG52->CSG43
    CSG43
    translate  1.8*x
  }
  object { // CSG53->CSG43
    CSG43
    translate  2.0*x
  }
  object { // CSG54->CSG43
    CSG43
    translate  2.2*x
  }
  object { // CSG55->CSG43
    CSG43
    translate  2.4*x
  }
  object { // CSG56->CSG43
    CSG43
    translate  2.6*x
  }
  object { // CSG57->CSG43
    CSG43
    translate  2.8*x
  }
  object { // CSG58->CSG43
    CSG43
    translate  3.0*x
  }
  object { // CSG59->CSG43
    CSG43
    translate  3.2*x
  }
  object { // CSG60->CSG43
    CSG43
    translate  3.4*x
  }
  object { // CSG61->CSG43
    CSG43
    translate  3.6*x
  }
  object { // CSG62->CSG43
    CSG43
    translate  3.8*x
  }
  object { // CSG63->CSG43
    CSG43
    translate  4.0*x
  }
  object { // CSG64->CSG43
    CSG43
    translate  4.2*x
  }
  object { // CSG65->CSG43
    CSG43
    translate  4.4*x
  }
  object { // CSG66->CSG43
    CSG43
    translate  4.6*x
  }
  object { // CSG67->CSG43
    CSG43
    translate  4.8*x
  }
  object { // CSG68->CSG43
    CSG43
    translate  5.0*x
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <2.6, 0.08, 0.1>
    translate  <0.0, -4.08, 4.64>
  }
}
#declare Grupo5 = union {
  object { CSG69 }
  object { // CSG70->CSG69
    CSG69
    rotate -0.0*z
    translate  0.2*x
  }
  object { // CSG71->CSG69
    CSG69
    rotate -0.0*z
    translate  0.4*x
  }
  object { // CSG72->CSG69
    CSG69
    rotate -0.0*z
    translate  0.6*x
  }
  object { // CSG73->CSG69
    CSG69
    rotate -0.0*z
    translate  0.8*x
  }
  object { // CSG74->CSG69
    CSG69
    rotate -0.0*z
    translate  1.0*x
  }
  object { // CSG75->CSG69
    CSG69
    rotate -0.0*z
    translate  1.2*x
  }
  object { // CSG76->CSG69
    CSG69
    rotate -0.0*z
    translate  1.4*x
  }
  object { // CSG77->CSG69
    CSG69
    rotate -0.0*z
    translate  1.6*x
  }
  object { // CSG78->CSG69
    CSG69
    rotate -0.0*z
    translate  1.8*x
  }
  object { // CSG79->CSG69
    CSG69
    rotate -0.0*z
    translate  2.0*x
  }
  object { // CSG80->CSG69
    CSG69
    rotate -0.0*z
    translate  2.2*x
  }
  object { // CSG81->CSG69
    CSG69
    rotate -0.0*z
    translate  2.4*x
  }
  object { // CSG82->CSG69
    CSG69
    rotate -0.0*z
    translate  2.6*x
  }
  object { // CSG83->CSG69
    CSG69
    rotate -0.0*z
    translate  2.8*x
  }
  object { // CSG84->CSG69
    CSG69
    rotate -0.0*z
    translate  3.0*x
  }
  object { // CSG85->CSG69
    CSG69
    rotate -0.0*z
    translate  3.2*x
  }
  object { // CSG86->CSG69
    CSG69
    rotate -0.0*z
    translate  3.4*x
  }
  object { // CSG87->CSG69
    CSG69
    rotate -0.0*z
    translate  3.6*x
  }
  object { // CSG88->CSG69
    CSG69
    rotate -0.0*z
    translate  3.8*x
  }
  object { // CSG89->CSG69
    CSG69
    rotate -0.0*z
    translate  4.0*x
  }
  object { // CSG90->CSG69
    CSG69
    rotate -0.0*z
    translate  4.2*x
  }
  object { // CSG91->CSG69
    CSG69
    rotate -0.0*z
    translate  4.4*x
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.08, 0.1>
    translate  <0.0, 1.92, 9.04>
  }
}
#declare Grupo8 = union {
  object { CSG103 }
  object { // CSG104->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 0.2, 0.0>
  }
  object { // CSG105->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 0.4, 0.0>
  }
  object { // CSG106->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 0.6, 0.0>
  }
  object { // CSG107->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 0.8, 0.0>
  }
  object { // CSG108->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 1.0, 0.0>
  }
  object { // CSG109->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 1.2, 0.0>
  }
  object { // CSG110->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 1.4, 0.0>
  }
  object { // CSG111->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 1.6, 0.0>
  }
  object { // CSG112->CSG103
    CSG103
    rotate <0.0, 0.0, 0.0>
    translate  <-0.0, 1.8, 0.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 1.0, 0.1>
    translate  <-2.42, 0.9, 9.04>
  }
}
#declare Grupo9 = union {
  object { CSG114 }
  object { // CSG115->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.2, 0.0>
  }
  object { // CSG116->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.4, 0.0>
  }
  object { // CSG117->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.6, 0.0>
  }
  object { // CSG118->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.8, 0.0>
  }
  object { // CSG119->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.0, 0.0>
  }
  object { // CSG120->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.2, 0.0>
  }
  object { // CSG121->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.4, 0.0>
  }
  object { // CSG122->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.6, 0.0>
  }
  object { // CSG123->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.8, 0.0>
  }
  object { // CSG124->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.0, 0.0>
  }
  object { // CSG125->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.2, 0.0>
  }
  object { // CSG126->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.4, 0.0>
  }
  object { // CSG127->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.6, 0.0>
  }
  object { // CSG128->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.8, 0.0>
  }
  object { // CSG129->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.0, 0.0>
  }
  object { // CSG130->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.2, 0.0>
  }
  object { // CSG131->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.4, 0.0>
  }
  object { // CSG132->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.6, 0.0>
  }
  object { // CSG133->CSG114
    CSG114
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.8, 0.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 2.05, 0.1>
    translate  <2.58, -2.15, 4.64>
  }
}
#declare AdornoCenefa = union {
  object { Grupo4 }
  object { Grupo5 }
  object { Grupo8 }
  object { Grupo9 }
  texture {
    Piedra1
  }
}
#declare CenefLatCentro = union {
  box { // CenefoyMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.15, 0.05>
    translate  <-2.25, 0.75, 9.29>
  }
  box { // CenefoyMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.05, 0.025>
    translate  <-2.3, 0.75, 9.215>
  }
  box { // CenefoyMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 1.0, 0.025>
    translate  <-2.325, 0.75, 9.165>
  }
}
#declare CeneLatIzq = union {
  box { // CeneLatMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 2.15, 0.05>
    translate  <-2.75, -2.25, 4.89>
  }
  box { // CeneLatMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.025>
    translate  <-2.7, -2.2, 4.815>
  }
  box { // CeneLatMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 2.075, 0.025>
    translate  <-2.675, -2.175, 4.765>
  }
}
#declare Cenefilla = union {
  box { // CenefillaMA
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.15, 0.05>
    translate  <0.0, 1.75, 9.29>
  }
  box { // CenefillaMB
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.1, 0.025>
    translate  <0.0, 1.8, 9.215>
  }
  box { // CenefillaMC
    <-1, -1, -1>, <1, 1, 1>
    scale <2.4, 0.075, 0.025>
    translate  <0.0, 1.825, 9.165>
  }
}
#declare CeneFren = union {
  box { // CeneFrenMA
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9, 0.15, 0.05>
    translate  <0.0, -4.25, 4.89>
  }
  box { // CeneFrenMB
    <-1, -1, -1>, <1, 1, 1>
    scale <2.8, 0.1, 0.025>
    translate  <0.0, -4.2, 4.815>
  }
  box { // CeneFrenMC
    <-1, -1, -1>, <1, 1, 1>
    scale <2.75, 0.075, 0.025>
    translate  <0.0, -4.175, 4.765>
  }
}
#declare CenefLatDer = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 2.15, 0.05>
    translate  <2.75, -2.25, 4.89>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 2.1, 0.025>
    translate  <2.7, -2.2, 4.815>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 2.075, 0.025>
    translate  <2.675, -2.175, 4.765>
  }
}
#declare Cenefas = union {
  object { CenefLatCentro }
  object { CeneLatIzq }
  object { Cenefilla }
  object { CeneFren }
  object { CenefLatDer }
  texture {
    Piedra1
  }
}
#declare Dintel = difference {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 0.35, 0.35>
    translate  <0.0, -3.6, 4.19>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1
    scale <6.5, 6.5, 0.8>
    rotate 90.0*x
    translate  <0.0, -3.2, -2.46>
  }
  texture {
    Piedra1
  }
}
#declare FACHMCENTRAL = union {
  object { AdornoCenefa }
  object { Cenefas }
  object { PiedrasTipicasM2 }
  object { AdornColum }
  object { // Columna5->Columna4
    Columna4
    translate  <4.2, -0.0, 0.0>
  }
  object { Columna4 }
  object { // AdornColum1->AdornColum
    AdornColum
    translate  4.2*x
  }
  object { // PiedrasTipica3->PiedrasTipicas-2
    PiedrasTipicasM2
    translate  4.62*x
  }
  object { Dintel }
}
#declare CeneLateral = union {
  box { // CeneLateralMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 7.9, 0.05>
    translate  <-12.75, 7.5, 4.89>
  }
  box { // CeneLateralMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 7.8, 0.025>
    translate  <-12.7, 7.5, 4.815>
  }
  box { // CeneLateralMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 7.75, 0.025>
    translate  <-12.675, 7.5, 4.765>
  }
  texture {
    Piedra1
  }
  translate  4.4*z
}
#declare FACHMLATMIZQ = union {
  object { CeneLateral }
}
#declare TechoSup = difference {
  box { // Techo
    <-1, -1, -1>, <1, 1, 1>
    scale <12.1, 7.1, 0.2>
    translate  <0.0, 7.5, 9.14>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9, 1.1, 0.3>
    translate  <0.0, 1.3, 9.14>
  }
}
#declare TECHOS = union {
  box { // TechoCentral
    <-1, -1, -1>, <1, 1, 1>
    scale <2.6, 3.05, 0.2>
    translate  <0.0, -1.05, 4.74>
  }
  object { TechoSup }
  texture {
    Muros1
  }
}
#declare CenefLat = union {
  box { // CenefLatMA
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 7.9, 0.05>
    translate  <12.75, 7.5, 9.29>
  }
  box { // CenefLatMB
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 7.8, 0.025>
    translate  <12.7, 7.5, 9.215>
  }
  box { // CenefLatMC
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 7.75, 0.025>
    translate  <12.675, 7.5, 9.165>
  }
  texture {
    Piedra1
  }
}
#declare Grupo10 = union {
  object { CSG134 }
  object { // CSG135->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.2, 0.0>
  }
  object { // CSG136->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.4, 0.0>
  }
  object { // CSG137->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.6, 0.0>
  }
  object { // CSG138->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 0.8, 0.0>
  }
  object { // CSG139->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.0, 0.0>
  }
  object { // CSG140->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.2, 0.0>
  }
  object { // CSG141->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.4, 0.0>
  }
  object { // CSG142->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.6, 0.0>
  }
  object { // CSG143->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 1.8, 0.0>
  }
  object { // CSG144->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.0, 0.0>
  }
  object { // CSG145->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.2, 0.0>
  }
  object { // CSG146->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.4, 0.0>
  }
  object { // CSG147->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.6, 0.0>
  }
  object { // CSG148->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 2.8, 0.0>
  }
  object { // CSG149->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.0, 0.0>
  }
  object { // CSG150->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.2, 0.0>
  }
  object { // CSG151->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.4, 0.0>
  }
  object { // CSG152->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.6, 0.0>
  }
  object { // CSG153->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 3.8, 0.0>
  }
  object { // CSG154->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 4.0, 0.0>
  }
  object { // CSG155->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 4.2, 0.0>
  }
  object { // CSG156->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 4.4, 0.0>
  }
  object { // CSG157->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 4.6, 0.0>
  }
  object { // CSG158->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 4.8, 0.0>
  }
  object { // CSG159->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 5.0, 0.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 7.68, 0.1>
    translate  <12.58, 7.5, 9.04>
  }
}
#declare Grupo11 = union {
  object { // CSG160->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 5.2, 0.0>
  }
  object { // CSG161->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 5.4, 0.0>
  }
  object { // CSG162->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 5.6, 0.0>
  }
  object { // CSG163->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 5.8, 0.0>
  }
  object { // CSG164->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 6.0, 0.0>
  }
  object { // CSG165->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 6.2, 0.0>
  }
  object { // CSG166->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 6.4, 0.0>
  }
  object { // CSG167->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 6.6, 0.0>
  }
  object { // CSG168->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 6.8, 0.0>
  }
  object { // CSG169->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 7.0, 0.0>
  }
  object { // CSG170->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 7.2, 0.0>
  }
  object { // CSG171->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 7.4, 0.0>
  }
  object { // CSG172->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 7.6, 0.0>
  }
  object { // CSG173->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 7.8, 0.0>
  }
  object { // CSG174->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 8.0, 0.0>
  }
  object { // CSG175->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 8.2, 0.0>
  }
  object { // CSG176->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 8.4, 0.0>
  }
  object { // CSG177->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 8.6, 0.0>
  }
  object { // CSG178->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 8.8, 0.0>
  }
  object { // CSG179->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 9.0, 0.0>
  }
  object { // CSG180->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 9.2, 0.0>
  }
  object { // CSG181->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 9.4, 0.0>
  }
  object { // CSG182->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 9.6, 0.0>
  }
  object { // CSG183->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 9.8, 0.0>
  }
  object { // CSG184->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 10.0, 0.0>
  }
}
#declare Grupo12 = union {
  object { // CSG185->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 10.2, 0.0>
  }
  object { // CSG186->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 10.4, 0.0>
  }
  object { // CSG187->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 10.6, 0.0>
  }
  object { // CSG188->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 10.8, 0.0>
  }
  object { // CSG189->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 11.0, 0.0>
  }
  object { // CSG190->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 11.2, 0.0>
  }
  object { // CSG191->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 11.4, 0.0>
  }
  object { // CSG192->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 11.6, 0.0>
  }
  object { // CSG193->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 11.8, 0.0>
  }
  object { // CSG194->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 12.0, 0.0>
  }
  object { // CSG195->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 12.2, 0.0>
  }
  object { // CSG196->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 12.4, 0.0>
  }
  object { // CSG197->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 12.6, 0.0>
  }
  object { // CSG198->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 12.8, 0.0>
  }
  object { // CSG199->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 13.0, 0.0>
  }
  object { // CSG200->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 13.2, 0.0>
  }
  object { // CSG201->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 13.4, 0.0>
  }
  object { // CSG202->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 13.6, 0.0>
  }
  object { // CSG203->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 13.8, 0.0>
  }
  object { // CSG204->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 14.0, 0.0>
  }
  object { // CSG205->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 14.2, 0.0>
  }
  object { // CSG206->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 14.4, 0.0>
  }
  object { // CSG207->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 14.6, 0.0>
  }
  object { // CSG208->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 14.8, 0.0>
  }
  object { // CSG209->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 15.0, 0.0>
  }
  object { // CSG210->CSG134
    CSG134
    rotate <0.0, -0.0, -0.0>
    translate  <0.0, 15.2, 0.0>
  }
}
#declare AdorCenefa = union {
  object { Grupo10 }
  object { Grupo11 }
  object { Grupo12 }
  texture {
    Piedra1
  }
}
#declare PiedEsq = union {
  object { PiedraMA22 }
  object { // PiedraMA23->Piedra-A22
    PiedraMA22
    translate  0.8*z
  }
  object { // PiedraMA24->Piedra-A22
    PiedraMA22
    translate  1.6*z
  }
  object { // PiedraMA25->Piedra-A22
    PiedraMA22
    translate  2.4*z
  }
  object { // PiedraMA26->Piedra-A22
    PiedraMA22
    translate  3.2*z
  }
  object { // PiedraMA27->Piedra-A22
    PiedraMA22
    translate  4.0*z
  }
  object { // PiedraMA28->Piedra-A22
    PiedraMA22
    translate  4.8*z
  }
  object { // PiedraMA29->Piedra-A22
    PiedraMA22
    translate  5.6*z
  }
  object { // PiedraMA30->Piedra-A22
    PiedraMA22
    translate  6.4*z
  }
  object { // PiedraMA31->Piedra-A22
    PiedraMA22
    translate  7.2*z
  }
  object { // PiedraMA32->Piedra-A22
    PiedraMA22
    translate  8.0*z
  }
  object { PiedraMB20 }
  object { // PiedraMB21->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 0.8>
  }
  object { // PiedraMB22->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 1.6>
  }
  object { // PiedraMB23->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 2.4>
  }
  object { // PiedraMB24->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 3.2>
  }
  object { // PiedraMB25->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 4.0>
  }
  object { // PiedraMB26->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 4.8>
  }
  object { // PiedraMB27->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 5.6>
  }
  object { // PiedraMB28->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 6.4>
  }
  object { // PiedraMB29->Piedra-B20
    PiedraMB20
    translate  <-0.0, -0.0, 7.2>
  }
  texture {
    Piedra1
  }
}
#declare FACHMLATMDER = union {
  object { CenefLat }
  object { AdorCenefa }
  object { PiedEsq }
}
#declare Paral = union {
  object { ParalM2 }
  object { // ParalM3->Paral-2
    ParalM2
    translate  0.3475*x
  }
  object { // ParalM4->Paral-2
    ParalM2
    translate  0.695*x
  }
  object { // ParalM5->Paral-2
    ParalM2
    translate  1.0425*x
  }
  object { // ParalM6->Paral-2
    ParalM2
    translate  1.39*x
  }
  object { // ParalM7->Paral-2
    ParalM2
    translate  1.7375*x
  }
  object { // ParalM8->Paral-2
    ParalM2
    translate  2.085*x
  }
  object { // ParalM9->Paral-2
    ParalM2
    translate  2.4325*x
  }
  object { // ParalM10->Paral-2
    ParalM2
    translate  2.78*x
  }
  object { // ParalM11->Paral-2
    ParalM2
    translate  3.1275*x
  }
  object { // ParalM12->Paral-2
    ParalM2
    translate  3.475*x
  }
  object { // ParalM13->Paral-2
    ParalM2
    translate  3.8225*x
  }
  object { // ParalM14->Paral-2
    ParalM2
    translate  4.17*x
  }
  object { // ParalM15->Paral-2
    ParalM2
    translate  4.5175*x
  }
  object { // ParalM16->Paral-2
    ParalM2
    translate  4.865*x
  }
  object { ParalM17 }
  object { ParalM18 }
  object { // ParalM19->Paral-18
    ParalM18
    translate  0.34*y
  }
  object { // ParalM20->Paral-18
    ParalM18
    translate  0.68*y
  }
  object { // ParalM21->Paral-18
    ParalM18
    translate  1.02*y
  }
  object { // ParalM22->Paral-18
    ParalM18
    translate  1.36*y
  }
  object { // ParalM23->Paral-18
    ParalM18
    translate  1.7*y
  }
  object { // ParalM24->Paral-18
    ParalM18
    translate  2.04*y
  }
  object { // ParalM25->Paral-18
    ParalM18
    translate  2.38*y
  }
  object { // ParalM26->Paral-18
    ParalM18
    translate  2.72*y
  }
  object { // ParalM27->Paral-18
    ParalM18
    translate  3.06*y
  }
  object { // ParalM28->Paral-18
    ParalM18
    translate  3.4*y
  }
  object { // ParalM29->Paral-18
    ParalM18
    translate  3.74*y
  }
  object { // ParalM30->Paral-18
    ParalM18
    translate  4.08*y
  }
}
#declare PasamanRec = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <2.93, 0.15, 0.075>
    translate  <0.0, -4.28, 5.835>
  }
  object { Cube023 }
  object { // Cube43->Cube023
    Cube023
    rotate <0.0, 0.0, 0.0>
    translate  <5.56, 0.0, 0.0>
  }
}
#declare BarandaRecta = union {
  object { Paral }
  object { PasamanRec }
  texture {
    TexColumna1
  }
}
#declare PISOS = union {
  object { PisoBase2 }
  object { // PisoBase3->PisoBase2
    PisoBase2
    translate  4.2*x
  }
  box { // PisoBase4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 1.0, 0.26>
    translate  <0.0, -1.93, 0.26>
  }
  box { // Base1
    <-1, -1, -1>, <1, 1, 1>
    scale <13.4, 8.6, 0.26>
    translate  <0.0, 7.5, 0.26>
  }
  texture {
    Piso_Casa
  }
}
#declare VanosMVent = difference {
  box { // MuroLatDer
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.1, 4.4>
    translate  <12.3, 7.5, 4.94>
  }
  object { Vano1 }
  object { // Vano2->Vano1
    Vano1
    rotate <-0.0, -0.0, 0.0>
    translate  4.0*y
  }
  object { // Vano3->Vano1
    Vano1
    rotate <-0.0, -0.0, 0.0>
    translate  8.0*y
  }
  object { Vano4 }
  object { // Vano5->Vano4
    Vano4
    translate  4.0*y
  }
  object { // Vano6->Vano4
    Vano4
    translate  8.0*y
  }
}
#declare Vanos = difference {
  box { // MuroFrenCentro
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9, 0.2, 4.4>
    translate  <0.0, 2.2, 4.94>
  }
  box { // Hueco5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.3, 1.4>
    translate  <0.0, 2.2, 1.94>
  }
  box { // Hueco6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.3, 1.4>
    translate  <0.0, 2.2, 6.34>
  }
  object { CSG001 }
  object { // CSG211->CSG001
    CSG001
    translate  4.4*z
  }
}
#declare MurosM2 = union {
  box { // MuroAtras
    <-1, -1, -1>, <1, 1, 1>
    scale <12.5, 0.2, 4.4>
    translate  <0.0, 14.8, 4.94>
  }
  box { // MuroLatIzq
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 7.1, 4.4>
    translate  <-12.3, 7.5, 4.94>
  }
  object { MuroIzqCentro }
  object { // MuroDerCentro->MuroIzqCentro
    MuroIzqCentro
    rotate -0.0*y
    translate  5.4*x
  }
  object { VanosMVent }
  object { Vanos }
  texture {
    Muros1
  }
}
#declare ParalM1 = union {
  sphere { // Sphere2
    <0,0,0>,1
    scale <0.12, 0.12, 0.14>
    translate  0.185*z
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.1, 0.015>
    translate  0.015*z
  }
  object { Torus2 }
  cone { // Cone11
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.11, 0.11, 0.7>
    rotate 180.0*x
    translate  <0.0, 0.0, 0.933175>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.08, 0.08, 0.1>
    translate  0.559477*z
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.1, 0.1, 0.07>
    translate  0.7*z
  }
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    scale <0.08, 0.08, 0.015>
    translate  0.805*z
  }
  object { // Torus3->Torus2
    Torus2
    translate  0.735*z
  }
  texture {
    TexColumna1
  }
  translate  -1.0*z
}
#declare PuertaMVent = union {
  object { PUERTAMPRINC }
  object { // PUERTAMPRINC1->PUERTA-PRINC
    PUERTAMPRINC
    translate  4.4*z
  }
  object { Puerta2 }
  object { Puerta3 }
  object { Puerta4 }
  object { Puerta5 }
  object { Puerta6 }
  object { Puerta7 }
  object { // Puerta8->Puerta7
    Puerta7
    translate  2.6*x
  }
  object { Ventana1 }
  object { // Ventana2->Ventana1
    Ventana1
    rotate -0.0*z
    translate  <0.0, 4.0, 0.0>
  }
  object { // Ventana3->Ventana1
    Ventana1
    rotate -0.0*z
    translate  <0.0, 8.0, 0.0>
  }
  object { Ventana4 }
  object { // Ventana5->Ventana4
    Ventana4
    translate  4.0*y
  }
  object { // Ventana6->Ventana4
    Ventana4
    translate  8.0*y
  }
  object { Puerta1 }
}
#declare Muros_Internos = union {
  box { // Muro_Lobby_Atras
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9, 0.1, 2.21>
    translate  <0.0, 11.5, 2.73>
  }
  object { Muro_Lobby_Izq }
  object { // Muro_Lobby_Izq1->Muro_Lobby_Izq
    Muro_Lobby_Izq
    rotate 0.0*y
    translate  <5.4, 0.0, -0.0>
  }
  box { // Tapa_Lobby
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 2.5, 0.2>
    translate  <0.0, 8.9, 4.74>
  }
  box { // Piso_N2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.35, 3.0, 0.2>
    translate  <-5.25, 7.4, 4.74>
  }
  box { // Muro_N2_Izq
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.0, 2.0>
    translate  <-7.5, 7.4, 6.94>
  }
  box { // Muro_N2_Atras
    <-1, -1, -1>, <1, 1, 1>
    scale <2.25, 0.1, 2.0>
    translate  <-5.15, 10.3, 6.94>
  }
  texture {
    Muros1
  }
  translate  -4.0*y
}
union { // CASA
  object { FACHMCENTRAL }
  object { FACHMFRENTE }
  object { FACHMLATMIZQ }
  object { // FACHMFRENTE1->FACH-FRENTE
    FACHMFRENTE
    translate  15.0*x
  }
  object { TECHOS }
  object { FACHMLATMDER }
  object { BarandaCirc1 }
  object { BarandaRecta }
  object { // BarandaCirc2->BarandaCirc1
    BarandaCirc1
    translate  15.0*x
  }
  object { PISOS }
  object { MurosM2 }
  object { ParalM1 }
  object { PuertaMVent }
  object { Muros_Internos }
  translate  4.0*y
}



