//
// Include file for ger_agua.pov
// Contains Post Illumination
//
//                 Image for the Internet Ray Traicing Competition
//                            August - October of 1998
//                      Procesed by Guillermo Espitia Rojas




#declare CSGMBrazo = difference {
  torus { // Torus008
    0.6, 0.03  rotate -x*90
    scale <1.0, 0.6, 1.0>
    rotate -90.0*x
  }
  plane { // Plane001
    z,0
    rotate 14.384461*y
  }
  texture {
    T_Poste2
  }
  scale <1.0, 0.8, 1.0>
  rotate -34.423664*y
  translate  <0.573201, 0.0, 2.90846>
}
#declare AdornoSup1 = union {
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.005, 0.21>
    rotate 61.056747*y
    translate  <-0.194114, -0.000292, 0.403732>
  }
  torus { // Torus25
    0.02, 0.005  rotate -x*90
    scale <1.0, 1.0, 1.5>
    rotate -90.0*x
    translate  <-0.204343, 0.0, 0.421124>
  }
  torus { // Torus26
    0.01, 0.004  rotate -x*90
    rotate -90.0*x
    translate  <-0.199713, 0.000088, 0.415266>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1
    scale <0.004, 0.004, 0.35>
    rotate -21.879499*y
    translate  <-0.058225, 0.0, 0.066842>
  }
}
#declare Vidrio3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.030003, 0.000002>,
  <0.029998, 0.000001>,
  <0.095, 0.34274>,
  <-0.095, 0.34274>,
  <-0.030003, 0.000002>
  rotate -x*90
  scale <1.0, 1.0, 0.004>
  rotate 70.823402*x
  translate  <0.0, 0.052, 0.06731>
}
#declare Tapa_Inf = union {
  sphere { // Sphere11
    <0,0,0>,1
    scale <0.02, 0.02, 0.01>
    translate  0.022656*z
  }
  cone { // Cone22
    <0,0,0>, 0.008, <0,0,1>, 0.013
    scale <1.0, 1.0, 0.006>
    translate  0.032127*z
  }
  cone { // Cone23
    <0,0,0>, 0.013, <0,0,1>, 0.03
    scale <1.0, 1.0, 0.01>
    translate  0.038199*z
  }
  cone { // Cone24
    <0,0,0>, 0.03, <0,0,1>, 0.06
    scale <1.0, 1.0, 0.01>
    translate  0.048218*z
  }
  torus { // Torus21
    0.06, 0.01  rotate -x*90
    scale <1.0, 1.0, 0.8>
    translate  0.064524*z
  }
}
#declare Tapa_Sup = union {
  torus { // Torus22
    0.198, 0.01  rotate -x*90
    scale <1.0, 1.0, 1.1>
    translate  0.395*z
  }
  torus { // Torus23
    0.193, 0.01  rotate -x*90
    scale <1.0, 1.0, 0.4>
    translate  0.381546*z
  }
  cone { // Cone25
    <0,0,0>, 0.19, <0,0,1>, 0.01
    scale <1.0, 1.0, 0.1>
    translate  0.4*z
  }
  sphere { // Sphere12
    <0,0,0>,1
    scale <0.03, 0.03, 0.015>
    translate  0.515452*z
  }
  torus { // Torus24
    0.025, 0.008  rotate -x*90
    rotate -90.0*x
    translate  0.563355*z
  }
}
#declare Adornos1 = union {
  object { AdornoSup1 }
  object { // AdornoSup2->AdornoSup1
    AdornoSup1
    rotate -60.0*z
  }
  object { // AdornoSup3->AdornoSup1
    AdornoSup1
    rotate -120.0*z
  }
  object { // AdornoSup4->AdornoSup1
    AdornoSup1
    rotate -180.0*z
  }
  object { // AdornoSup5->AdornoSup1
    AdornoSup1
    rotate 120.0*z
  }
  object { // AdornoSup6->AdornoSup1
    AdornoSup1
    rotate 60.0*z
  }
}
#declare Vidrios = union {
  object { Vidrio3 }
  object { // Vidrio4->Vidrio3
    Vidrio3
    rotate <-0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Vidrio5->Vidrio3
    Vidrio3
    rotate <-0.0, 0.0, -120.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Vidrio6->Vidrio3
    Vidrio3
    rotate <-0.0, 0.0, -180.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Vidrio7->Vidrio3
    Vidrio3
    rotate <-0.0, 0.0, 120.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Vidrio8->Vidrio3
    Vidrio3
    rotate <-0.0, 0.0, 60.0>
    translate  <-0.0, 0.0, 0.0>
  }
  texture {
    TMVidrios
  }
}
#declare Iluminacion = union {
  cone { // Cone26
    <0,0,0>, 0.05, <0,0,1>, 0.08
    scale <1.0, 1.0, 0.02>
    translate  <0.003379, 0.0, 0.38>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.03>
    translate  0.35*z
  }
  sphere { // Bombilla
    <0,0,0>,1
    texture {
      T_Bombilla
    }
    no_shadow
    hollow
    scale <0.04, 0.04, 0.05>
    translate  0.302822*z
  }
  sphere { // Halo_Bombilla
    <0,0,0>,1
    texture {
      T_HaloBombilla
    }
    no_shadow
    hollow
    translate  0.29*z
  }
}
#declare Farol_Hexa = union {
  object { Tapa_Inf }
  object { Tapa_Sup }
  object { Adornos1 }
  object { Vidrios }
  object { Iluminacion }
  texture {
    T_Poste2
  }
  translate  <1.112, 0.0, 2.523936>
}
#declare Brazo1 = union {
  object { CSGMBrazo }
  object { Farol_Hexa }
  translate  -0.02*z
}
#declare Cone008 = object {
  cone { // Cone008
    <0,0,0>, 0.025, <0,0,1>, 0.019
    scale <1.0, 1.0, 0.2>
    rotate -11.3099*y
    translate  <0.244055, 0.0, 0.062097>
  }
}
#declare Cone009 = object {
  cone { // Cone009
    <0,0,0>, 0.008, <0,0,1>, 0.006
    scale <1.0, 1.0, 0.15>
    rotate -5.7106*y
    translate  <0.087, 0.0, 0.405>
  }
}
#declare Cylndr56 = object {
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.1>
    translate  <0.1, 0.0, 3.05>
  }
}




#declare Otros = union {
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 0.03>
  }
  torus { // Torus27
    0.2, 0.015  rotate -x*90
    translate  0.295*z
  }
  cone { // Cone003
    <0,0,0>, 0.197, <0,0,1>, 0.126
    scale <1.0, 1.0, 0.05>
    translate  0.31*z
  }
  torus { // Torus28
    0.126, 0.01  rotate -x*90
    translate  0.37*z
  }
  torus { // Torus29
    0.098, 0.01  rotate -x*90
    translate  0.59*z
  }
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1
    scale <0.098, 0.098, 0.02>
    translate  0.58*z
  }
  cone { // Cone005
    <0,0,0>, 0.06, <0,0,1>, 0.052
    translate  0.6*z
  }
  cone { // Cone006
    <0,0,0>, 0.06, <0,0,1>, 0.07
    open
    translate  2.0*z
  }
  torus { // Torus30
    0.1, 0.015  rotate -x*90
    translate  3.015*z
  }
  torus { // Torus31
    0.1, 0.015  rotate -x*90
    translate  3.185*z
  }
  cone { // Cone007
    <0,0,0>, 0.05, <0,0,1>, 0.03
    scale <1.0, 1.0, 0.05>
    translate  3.2*z
  }
  sphere { // Sphere13
    <0,0,0>,1
    scale 0.07
    translate  3.31*z
  }
}
#declare CSGM2 = difference {
  cone { // Cone27
    <0,0,0>, 0.25, <0,0,1>, 0.2
    scale <1.0, 1.0, 0.25>
    translate  0.03*z
  }
  object { Cone008 }
  object { // Cone28->Cone008
    Cone008
    rotate -22.5*z
    translate  0.0*y
  }
  object { // Cone29->Cone008
    Cone008
    rotate -45.0*z
    translate  -0.0*x
  }
  object { // Cone30->Cone008
    Cone008
    rotate -67.5*z
    translate  -0.0*x
  }
  object { // Cone31->Cone008
    Cone008
    rotate -90.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone32->Cone008
    Cone008
    rotate -112.5*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cone33->Cone008
    Cone008
    rotate -135.0*z
    translate  0.0*y
  }
  object { // Cone34->Cone008
    Cone008
    rotate -157.5*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone35->Cone008
    Cone008
    rotate -180.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone36->Cone008
    Cone008
    rotate 157.5*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone37->Cone008
    Cone008
    rotate 135.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cone38->Cone008
    Cone008
    rotate 112.5*z
    translate  0.0*x
  }
  object { // Cone39->Cone008
    Cone008
    rotate 90.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cone40->Cone008
    Cone008
    rotate 67.5*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cone41->Cone008
    Cone008
    rotate 45.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cone42->Cone008
    Cone008
    rotate 22.5*z
    translate  -0.0*y
  }
}
#declare CSGM3 = difference {
  cone { // Cone004
    <0,0,0>, 0.089, <0,0,1>, 0.07
    scale <1.0, 1.0, 0.2>
    translate  0.38*z
  }
  object { Cone009 }
  object { // Cone43->Cone009
    Cone009
    rotate <0.0, 0.0, -22.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone44->Cone009
    Cone009
    rotate <0.0, 0.0, -45.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cone45->Cone009
    Cone009
    rotate <-0.0, 0.0, -67.5>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cone46->Cone009
    Cone009
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cone47->Cone009
    Cone009
    rotate <0.0, 0.0, -112.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone48->Cone009
    Cone009
    rotate <0.0, 0.0, -135.0>
    translate  -0.0*z
  }
  object { // Cone49->Cone009
    Cone009
    rotate <0.0, 0.0, -157.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone50->Cone009
    Cone009
    rotate <0.0, 0.0, -180.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Cone51->Cone009
    Cone009
    rotate <-0.0, 0.0, 157.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone52->Cone009
    Cone009
    rotate <0.0, 0.0, 135.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone53->Cone009
    Cone009
    rotate <0.0, 0.0, 112.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone54->Cone009
    Cone009
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone55->Cone009
    Cone009
    rotate <0.0, 0.0, 67.5>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone56->Cone009
    Cone009
    rotate <0.0, 0.0, 45.0>
    translate  <0.0, 0.0, -0.0>
  }
  object { // Cone57->Cone009
    Cone009
    rotate <0.0, 0.0, 22.5>
    translate  <0.0, 0.0, -0.0>
  }
  scale <1.4, 1.4, 1.0>
}
#declare CSGM4 = difference {
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.2>
    translate  3.0*z
  }
  object { Cylndr56 }
  object { // Cylndr57->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, -30.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr58->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, -60.0>
    translate  -0.0*y
  }
  object { // Cylndr59->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr60->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, -120.0>
    translate  -0.0*x
  }
  object { // Cylndr61->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, -150.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr62->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr63->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, 150.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr64->Cylndr56
    Cylndr56
    rotate <-0.0, -0.0, 120.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr65->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr66->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, 60.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr67->Cylndr56
    Cylndr56
    rotate <0.0, -0.0, 30.0>
    translate  <0.0, -0.0, 0.0>
  }
}
#declare Centro = union {
  cone { // Cone001
    <0,0,0>, 0.04, <0,0,1>, 0.06
    scale <1.0, 1.0, 0.02>
    translate  1.62*z
  }
  sphere { // Sphere14
    <0,0,0>,1
    scale <0.08, 0.08, 0.06>
    translate  1.6795*z
  }
  cone { // Cone010
    <0,0,0>, 0.06, <0,0,1>, 0.04
    scale <1.0, 1.0, 0.02>
    translate  1.72*z
  }
  cone { // Cone011
    <0,0,0>, 0.04, <0,0,1>, 0.03
    scale <1.0, 1.0, 0.04>
    translate  1.74*z
  }
  cone { // Cone012
    <0,0,0>, 0.03, <0,0,1>, 0.045
    scale <1.0, 1.0, 0.02>
    translate  1.8*z
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.06, 0.06, 0.02>
    translate  1.833*z
  }
  cone { // Cone013
    <0,0,0>, 0.045, <0,0,1>, 0.03
    scale <1.0, 1.0, 0.015>
    translate  1.846427*z
  }
  cylinder { // Cylndr68
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 0.02>
    translate  1.85*z
  }
  cone { // Cone014
    <0,0,0>, 0.03, <0,0,1>, 0.04
    scale <1.0, 1.0, 0.05>
    translate  1.87*z
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale <0.07, 0.07, 0.05>
    translate  1.95*z
  }
  torus { // Torus32
    0.05, 0.01  rotate -x*90
    translate  1.99*z
  }
  torus { // Torus33
    0.03, 0.01  rotate -x*90
    translate  1.79*z
  }
  torus { // Torus34
    0.04, 0.01  rotate -x*90
    translate  1.61*z
  }
  scale <1.3, 1.3, 1.0>
}
#declare Poste = union {
  object { Otros }
  object { CSGM2 }
  object { CSGM3 }
  object { CSGM4 }
  object { Centro }
}
union { // PosteMAlumbrado
  object { Brazo1 }
  object { Poste }
  object { // Brazo2->Brazo1
    Brazo1
    rotate -180.0*z
  }
  texture {
    T_Poste2
  }
  translate  <5.0, -7.4, 0.0>
}


