#version 3.1;

#include "colors.inc"
#include "tear_drop.inc"

#macro hair (init_len,len_fac,rot_fac,hair_tex)
#local s1=init_len;
#local s2=s1*0.9;
#local s3=s2*0.9;
#local s4=s3*0.9;
#local s5=s4*0.9;
#local s6=s5*0.9;
#local s7=s6*0.9;
#local s8=s7*0.9;
#local s9=s8*0.9;
#local s10=s9*0.9;
#local s11=s10*0.9;
#local s12=s11*0.9;
#local s13=s12*0.9;
#local s14=s13*0.9;

#local r1=rot_fac;
#local r2=rot_fac;
#local r3=rot_fac;
#local r4=rot_fac;
#local r5=rot_fac;
#local r6=rot_fac;
#local r7=rot_fac;
#local r8=rot_fac;
#local r9=rot_fac;
#local r10=rot_fac;
#local r11=rot_fac;
#local r12=rot_fac;
#local r13=rot_fac;
#local r14=rot_fac;
#local r15=rot_fac;

object{
union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s1,  0>}
triangle{<-0.25,  s1, 0> < 0.25,  s1, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s1,  0>}
triangle{<0,  s1, -0.25> < 0,  s1, 0.25> < 0, 0,  0>}

union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s2,  0>}
triangle{<-0.25,  s2, 0> < 0.25,  s2, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s2,  0>}
triangle{<0,  s2, -0.25> < 0,  s2, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s3,  0>}
triangle{<-0.25,  s3, 0> < 0.25,  s3, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s3,  0>}
triangle{<0,  s3, -0.25> < 0,  s3, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s4,  0>}
triangle{<-0.25,  s4, 0> < 0.25,  s4, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s4,  0>}
triangle{<0,  s4, -0.25> < 0,  s4, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s5,  0>}
triangle{<-0.25,  s5, 0> < 0.25,  s5, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s5,  0>}
triangle{<0,  s5, -0.25> < 0,  s5, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s6,  0>}
triangle{<-0.25,  s6, 0> < 0.25,  s6, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s6,  0>}
triangle{<0,  s6, -0.25> < 0,  s6, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s7,  0>}
triangle{<-0.25,  s7, 0> < 0.25,  s7, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s7,  0>}
triangle{<0,  s7, -0.25> < 0,  s7, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s8,  0>}
triangle{<-0.25,  s8, 0> < 0.25,  s8, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s8,  0>}
triangle{<0,  s8, -0.25> < 0,  s8, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s9,  0>}
triangle{<-0.25,  s9, 0> < 0.25,  s9, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s9,  0>}
triangle{<0,  s9, -0.25> < 0,  s9, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s10,  0>}
triangle{<-0.25,  s10, 0> < 0.25,  s10, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s10,  0>}
triangle{<0,  s10, -0.25> < 0,  s10, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s11,  0>}
triangle{<-0.25,  s11, 0> < 0.25,  s11, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s11,  0>}
triangle{<0,  s11, -0.25> < 0,  s11, 0.25> < 0, 0,  0>}


union{
//C1 (bottom)
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s12,  0>}
triangle{<-0.25,  s12, 0> < 0.25,  s12, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s12,  0>}
triangle{<0,  s12, -0.25> < 0,  s12, 0.25> < 0, 0,  0>}


union{
//C2 (middle)
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s13,  0>}
triangle{<-0.25,  s13, 0> < 0.25,  s13, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s13,  0>}
triangle{<0,  s13, -0.25> < 0,  s13, 0.25> < 0, 0,  0>}


//C3 (top)
union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s14,  0>}
triangle{<-0.25,  s14, 0> < 0.25,  s14, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s14,  0>}
triangle{<0,  s14, -0.25> < 0,  s14, 0.25> < 0, 0,  0>}


rotate z*r14
translate<0,s13,0>
}


//For C2 (middle)
rotate z*r13
translate<0,s12,0>}

//For C1 (bottom)
rotate z*r12
translate<0,s11,0>}

rotate z*r11
translate<0,s10,0>}

rotate z*r10
translate<0,s9,0>}

rotate z*r9
translate<0,s8,0>}

rotate z*r8
translate<0,s7,0>}

rotate z*r7
translate<0,s6,0>}

rotate z*r6
translate<0,s5,0>}

rotate z*r5
translate<0,s4,0>}

rotate z*r4
translate<0,s3,0>}

rotate z*r3
translate<0,s2,0>}

rotate z*r2
translate<0,s1,0>}

rotate z*r1
translate<0,0,0>
texture{hair_tex}
}
}
#end

#macro different_hair (init_len,len_fac,rot_fac,hair_tex)
#local s1=init_len;
#local s2=s1*0.9;
#local s3=s2*0.9;
#local s4=s3*0.9;
#local s5=s4*0.9;
#local s6=s5*0.9;
#local s7=s6*0.9;
#local s8=s7*0.9;
#local s9=s8*0.9;
#local s10=s9*0.9;
#local s11=s10*0.9;
#local s12=s11*0.9;
#local s13=s12*0.9;
#local s14=s13*0.9;

#local r1=rot_fac;
#local r2=rot_fac;
#local r3=rot_fac;
#local r4=rot_fac;
#local r5=rot_fac;
#local r6=rot_fac;
#local r7=rot_fac;
#local r8=rot_fac;
#local r9=rot_fac;
#local r10=rot_fac;
#local r11=rot_fac;
#local r12=rot_fac;
#local r13=rot_fac;
#local r14=rot_fac;
#local r15=rot_fac;

object{
union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s1,  0>}
triangle{<-0.25,  s1, 0> < 0.25,  s1, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s1,  0>}
triangle{<0,  s1, -0.25> < 0,  s1, 0.25> < 0, 0,  0>}

union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s2,  0>}
triangle{<-0.25,  s2, 0> < 0.25,  s2, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s2,  0>}
triangle{<0,  s2, -0.25> < 0,  s2, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s3,  0>}
triangle{<-0.25,  s3, 0> < 0.25,  s3, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s3,  0>}
triangle{<0,  s3, -0.25> < 0,  s3, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s4,  0>}
triangle{<-0.25,  s4, 0> < 0.25,  s4, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s4,  0>}
triangle{<0,  s4, -0.25> < 0,  s4, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s5,  0>}
triangle{<-0.25,  s5, 0> < 0.25,  s5, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s5,  0>}
triangle{<0,  s5, -0.25> < 0,  s5, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s6,  0>}
triangle{<-0.25,  s6, 0> < 0.25,  s6, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s6,  0>}
triangle{<0,  s6, -0.25> < 0,  s6, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s7,  0>}
triangle{<-0.25,  s7, 0> < 0.25,  s7, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s7,  0>}
triangle{<0,  s7, -0.25> < 0,  s7, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s8,  0>}
triangle{<-0.25,  s8, 0> < 0.25,  s8, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s8,  0>}
triangle{<0,  s8, -0.25> < 0,  s8, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s9,  0>}
triangle{<-0.25,  s9, 0> < 0.25,  s9, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s9,  0>}
triangle{<0,  s9, -0.25> < 0,  s9, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s10,  0>}
triangle{<-0.25,  s10, 0> < 0.25,  s10, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s10,  0>}
triangle{<0,  s10, -0.25> < 0,  s10, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s11,  0>}
triangle{<-0.25,  s11, 0> < 0.25,  s11, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s11,  0>}
triangle{<0,  s11, -0.25> < 0,  s11, 0.25> < 0, 0,  0>}


union{
//C1 (bottom)
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s12,  0>}
triangle{<-0.25,  s12, 0> < 0.25,  s12, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s12,  0>}
triangle{<0,  s12, -0.25> < 0,  s12, 0.25> < 0, 0,  0>}


union{
//C2 (middle)
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s13,  0>}
triangle{<-0.25,  s13, 0> < 0.25,  s13, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s13,  0>}
triangle{<0,  s13, -0.25> < 0,  s13, 0.25> < 0, 0,  0>}


//C3 (top)
union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s14,  0>}
triangle{<-0.25,  s14, 0> < 0.25,  s14, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s14,  0>}
triangle{<0,  s14, -0.25> < 0,  s14, 0.25> < 0, 0,  0>}


rotate z*r14
translate<0,s13,0>
}


//For C2 (middle)
rotate z*r13
translate<0,s12,0>}

//For C1 (bottom)
rotate z*r12
translate<0,s11,0>}

rotate z*r11
translate<0,s10,0>}

rotate z*r10
translate<0,s9,0>}

rotate z*r9
translate<0,s8,0>}

rotate z*r8
translate<0,s7,0>}

rotate z*r7
translate<0,s6,0>}

rotate z*r6
translate<0,s5,0>}

rotate z*r5
translate<0,s4,0>}

rotate z*r4
translate<0,s3,0>}

rotate z*r3
translate<0,s2,0>}

rotate z*r2
translate<0,s1,0>}

rotate z*r1
translate<0,0,0>
texture{hair_tex}
}
}
#end


//************* puff_ball ********************************//
//  This macro creates a little "hair" effect around a ball
//************* recommeded values ************************//
//hair_count    1 to 1+
//lift_rad      10 to 10+
//seed_num      any
//limp_factor   0 to 0.3
//init_len      1 to 1+
//len_fac       0.5 to 1
//hair_tex      any
//*********************************************************//
#macro puff_ball(hair_count, lift_rad, seed_num, limp_factor, init_len, len_fac, hair_tex)
//hair (init_len,len_fac,rot_fac,texture{pigment{White}})
// init_len stays at 20.
// len_fac stays at 0.5
// rot_fac goes from 0 to 15

#local R1=seed(seed_num);
#local count_num=0;

#while(count_num<hair_count)
 #local z_rot=(rand(R1)*180)-90;
 union{hair (init_len,len_fac,z_rot*limp_factor,texture{hair_tex})
  translate<0,lift_rad,0> rotate<0,0,z_rot> rotate<0,rand(R1)*360,0>}
 #local count_num=count_num+1;
#end
#end


#macro hair_bop (init_len,len_fac,rot_fac,hair_tex,bop_rad,bop_tex)
#local s1=init_len;
#local s2=s1*0.9;
#local s3=s2*0.9;
#local s4=s3*0.9;
#local s5=s4*0.9;
#local s6=s5*0.9;
#local s7=s6*0.9;
#local s8=s7*0.9;
#local s9=s8*0.9;
#local s10=s9*0.9;
#local s11=s10*0.9;
#local s12=s11*0.9;
#local s13=s12*0.9;
#local s14=s13*0.9;

#local r1=rot_fac;
#local r2=rot_fac;
#local r3=rot_fac;
#local r4=rot_fac;
#local r5=rot_fac;
#local r6=rot_fac;
#local r7=rot_fac;
#local r8=rot_fac;
#local r9=rot_fac;
#local r10=rot_fac;
#local r11=rot_fac;
#local r12=rot_fac;
#local r13=rot_fac;
#local r14=rot_fac;
#local r15=rot_fac;

object{
union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s1,  0>}
triangle{<-0.25,  s1, 0> < 0.25,  s1, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s1,  0>}
triangle{<0,  s1, -0.25> < 0,  s1, 0.25> < 0, 0,  0>}

union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s2,  0>}
triangle{<-0.25,  s2, 0> < 0.25,  s2, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s2,  0>}
triangle{<0,  s2, -0.25> < 0,  s2, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s3,  0>}
triangle{<-0.25,  s3, 0> < 0.25,  s3, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s3,  0>}
triangle{<0,  s3, -0.25> < 0,  s3, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s4,  0>}
triangle{<-0.25,  s4, 0> < 0.25,  s4, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s4,  0>}
triangle{<0,  s4, -0.25> < 0,  s4, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s5,  0>}
triangle{<-0.25,  s5, 0> < 0.25,  s5, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s5,  0>}
triangle{<0,  s5, -0.25> < 0,  s5, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s6,  0>}
triangle{<-0.25,  s6, 0> < 0.25,  s6, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s6,  0>}
triangle{<0,  s6, -0.25> < 0,  s6, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s7,  0>}
triangle{<-0.25,  s7, 0> < 0.25,  s7, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s7,  0>}
triangle{<0,  s7, -0.25> < 0,  s7, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s8,  0>}
triangle{<-0.25,  s8, 0> < 0.25,  s8, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s8,  0>}
triangle{<0,  s8, -0.25> < 0,  s8, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s9,  0>}
triangle{<-0.25,  s9, 0> < 0.25,  s9, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s9,  0>}
triangle{<0,  s9, -0.25> < 0,  s9, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s10,  0>}
triangle{<-0.25,  s10, 0> < 0.25,  s10, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s10,  0>}
triangle{<0,  s10, -0.25> < 0,  s10, 0.25> < 0, 0,  0>}


union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s11,  0>}
triangle{<-0.25,  s11, 0> < 0.25,  s11, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s11,  0>}
triangle{<0,  s11, -0.25> < 0,  s11, 0.25> < 0, 0,  0>}


union{
//C1 (bottom)
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s12,  0>}
triangle{<-0.25,  s12, 0> < 0.25,  s12, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s12,  0>}
triangle{<0,  s12, -0.25> < 0,  s12, 0.25> < 0, 0,  0>}


union{
//C2 (middle)
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s13,  0>}
triangle{<-0.25,  s13, 0> < 0.25,  s13, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s13,  0>}
triangle{<0,  s13, -0.25> < 0,  s13, 0.25> < 0, 0,  0>}


//C3 (top)
union{
triangle{<-0.25,  0, 0> < 0.25,  0, 0> < 0, s14,  0>}
triangle{<-0.25,  s14, 0> < 0.25,  s14, 0> < 0, 0,  0>}
triangle{<0,  0, -0.25> < 0,  0, 0.25> < 0, s14,  0>}
triangle{<0,  s14, -0.25> < 0,  s14, 0.25> < 0, 0,  0>}

//sphere{<0,s14,0>,bop_rad scale<0.2,2,1> texture{bop_tex}}
object{tear_drop scale<0.25,1,0.5> scale bop_rad texture{bop_tex}}

rotate z*r14
translate<0,s13,0>
}


//For C2 (middle)
rotate z*r13
translate<0,s12,0>}

//For C1 (bottom)
rotate z*r12
translate<0,s11,0>}

rotate z*r11
translate<0,s10,0>}

rotate z*r10
translate<0,s9,0>}

rotate z*r9
translate<0,s8,0>}

rotate z*r8
translate<0,s7,0>}

rotate z*r7
translate<0,s6,0>}

rotate z*r6
translate<0,s5,0>}

rotate z*r5
translate<0,s4,0>}

rotate z*r4
translate<0,s3,0>}

rotate z*r3
translate<0,s2,0>}

rotate z*r2
translate<0,s1,0>}

rotate z*r1
translate<0,0,0>
texture{hair_tex}
}
}
#end

//************* puff_ball_bop ********************************//
//  This macro creates a little "hair" effect around a ball
//************* recommeded values ************************//
//hair_count    1 to 1+
//lift_rad      10 to 10+
//seed_num      any
//limp_factor   0 to 0.3
//init_len      1 to 1+
//len_fac       0.5 to 1
//hair_tex      any
//*********************************************************//
#macro puff_ball_bop(hair_count, lift_rad, seed_num, limp_factor, init_len, len_fac, hair_tex,bop_rad_max)
//hair (init_len,len_fac,rot_fac,texture{pigment{White}})
// init_len stays at 20.
// len_fac stays at 0.5
// rot_fac goes from 0 to 15

#local R1=seed(seed_num);
#local count_num=0;

#while(count_num<hair_count)
 #local z_rot=(rand(R1)*180)-90;
 union{hair_bop (init_len,len_fac,z_rot*limp_factor,texture{hair_tex},(abs(z_rot)/10)+5,texture{finish{phong 1.0 ambient<0.2,0.05,0.2>} pigment{rgb<(rand(R1)*0.1)+0.2,(rand(R1)*0.3)+0.4,(rand(R1)*0.1)+0.1>}})
  translate<0,lift_rad,0> rotate<0,0,z_rot> rotate<0,rand(R1)*360,0>}
 #local count_num=count_num+1;
 #debug concat("Processing hair object number ",str(count_num,0,0),"\n")
#end
#end
