//#version 3.1; #include "colors.inc" global_settings{assumed_gamma 1.0}
// ----------------------------------------
//camera{location  <0.0, 50, 0> direction 1.5*z right     4/3*x look_at   <0.0, 0.0, 3>}
//light_source {0*x  color red 1.0  green 1.0  blue 1.0 translate <-30, 30, -30>}
// ----------------------------------------
#include "textures.inc"

#declare Small_pipes_tex=texture{pigment{Black} finish{phong 1.0 ambient 0.2 reflection 0.1.15}}
#declare Box_tex=texture{Sandalwood}

#declare arm_1=object{
// Layer 1
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, -0.258, 0.074> <0.223, -0.258, 0.073> <0.515, -0.261, 0.070> <0.734, -0.258, 0.069> 
		<0.003, -0.313, -0.045> <0.222, -0.313, -0.047> <0.514, -0.317, -0.049> <0.733, -0.313, -0.050> 
		<0.002, -0.098, -0.290> <0.220, -0.098, -0.291> <0.512, -0.098, -0.298> <0.731, -0.098, -0.295> 
		<0.002, 0.030, -0.259> <0.221, 0.030, -0.260> <0.513, 0.031, -0.267> <0.731, 0.030, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, -0.258, 0.074> <0.005, -0.192, 0.214> <0.006, 0.142, 0.313> <0.005, 0.242, 0.196> 
		<0.223, -0.258, 0.073> <0.224, -0.192, 0.213> <0.225, 0.142, 0.311> <0.224, 0.242, 0.194> 
		<0.515, -0.261, 0.070> <0.516, -0.196, 0.210> <0.517, 0.145, 0.310> <0.516, 0.245, 0.193> 
		<0.734, -0.258, 0.069> <0.735, -0.192, 0.209> <0.735, 0.142, 0.307> <0.735, 0.242, 0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 0.242, 0.196> <0.004, 0.341, 0.082> <0.002, 0.177, -0.223> <0.002, 0.030, -0.259> 
		<0.224, 0.242, 0.194> <0.223, 0.341, 0.080> <0.221, 0.177, -0.225> <0.221, 0.030, -0.260> 
		<0.516, 0.245, 0.193> <0.515, 0.344, 0.079> <0.513, 0.177, -0.232> <0.513, 0.031, -0.267> 
		<0.735, 0.242, 0.191> <0.734, 0.341, 0.077> <0.732, 0.177, -0.228> <0.731, 0.030, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.734, -0.258, 0.069> <0.973, -0.254, 0.068> <1.292, -0.239, 0.057> <1.531, -0.234, 0.068> 
		<0.733, -0.313, -0.050> <0.972, -0.310, -0.051> <1.291, -0.290, -0.052> <1.530, -0.285, -0.041> 
		<0.731, -0.098, -0.295> <0.971, -0.098, -0.291> <1.290, -0.088, -0.282> <1.529, -0.089, -0.264> 
		<0.731, 0.030, -0.264> <0.971, 0.030, -0.260> <1.290, 0.029, -0.253> <1.529, 0.028, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.734, -0.258, 0.069> <0.735, -0.192, 0.209> <0.735, 0.142, 0.307> <0.735, 0.242, 0.191> 
		<0.973, -0.254, 0.068> <0.974, -0.189, 0.208> <0.975, 0.138, 0.305> <0.974, 0.239, 0.188> 
		<1.292, -0.239, 0.057> <1.293, -0.180, 0.185> <1.293, 0.134, 0.277> <1.293, 0.226, 0.170> 
		<1.531, -0.234, 0.068> <1.532, -0.175, 0.195> <1.533, 0.129, 0.285> <1.532, 0.221, 0.178> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.735, 0.242, 0.191> <0.734, 0.341, 0.077> <0.732, 0.177, -0.228> <0.731, 0.030, -0.264> 
		<0.974, 0.239, 0.188> <0.973, 0.337, 0.074> <0.971, 0.176, -0.225> <0.971, 0.030, -0.260> 
		<1.293, 0.226, 0.170> <1.292, 0.315, 0.066> <1.290, 0.162, -0.221> <1.290, 0.029, -0.253> 
		<1.532, 0.221, 0.178> <1.531, 0.311, 0.075> <1.529, 0.161, -0.203> <1.529, 0.028, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.531, -0.234, 0.068> <1.640, -0.232, 0.073> <1.782, -0.234, 0.112> <1.891, -0.234, 0.120> 
		<1.530, -0.285, -0.041> <1.639, -0.283, -0.036> <1.768, -0.285, 0.004> <1.877, -0.285, 0.012> 
		<1.529, -0.089, -0.264> <1.627, -0.089, -0.257> <1.751, -0.089, -0.222> <1.848, -0.089, -0.211> 
		<1.529, 0.028, -0.236> <1.627, 0.028, -0.229> <1.754, 0.028, -0.193> <1.852, 0.028, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.531, -0.234, 0.068> <1.532, -0.175, 0.195> <1.533, 0.129, 0.285> <1.532, 0.221, 0.178> 
		<1.640, -0.232, 0.073> <1.641, -0.172, 0.200> <1.646, 0.127, 0.288> <1.645, 0.219, 0.182> 
		<1.782, -0.234, 0.112> <1.798, -0.175, 0.239> <1.806, 0.130, 0.329> <1.792, 0.221, 0.223> 
		<1.891, -0.234, 0.120> <1.907, -0.175, 0.247> <1.919, 0.130, 0.336> <1.905, 0.221, 0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.532, 0.221, 0.178> <1.531, 0.311, 0.075> <1.529, 0.161, -0.203> <1.529, 0.028, -0.236> 
		<1.645, 0.219, 0.182> <1.644, 0.309, 0.078> <1.627, 0.161, -0.196> <1.627, 0.028, -0.229> 
		<1.792, 0.221, 0.223> <1.779, 0.311, 0.120> <1.759, 0.162, -0.161> <1.754, 0.028, -0.193> 
		<1.905, 0.221, 0.230> <1.892, 0.311, 0.127> <1.856, 0.162, -0.150> <1.852, 0.028, -0.182> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.891, -0.234, 0.120> <2.001, -0.234, 0.128> <2.151, -0.239, 0.141> <2.259, -0.234, 0.120> 
		<1.877, -0.285, 0.012> <1.987, -0.285, 0.019> <2.103, -0.289, 0.039> <2.211, -0.284, 0.018> 
		<1.848, -0.089, -0.211> <1.930, -0.089, -0.201> <2.030, -0.091, -0.188> <2.111, -0.092, -0.196> 
		<1.852, 0.028, -0.182> <1.933, 0.028, -0.173> <2.043, 0.029, -0.160> <2.124, 0.028, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.891, -0.234, 0.120> <1.907, -0.175, 0.247> <1.919, 0.130, 0.336> <1.905, 0.221, 0.230> 
		<2.001, -0.234, 0.128> <2.017, -0.175, 0.254> <2.039, 0.130, 0.343> <2.026, 0.221, 0.237> 
		<2.151, -0.239, 0.141> <2.205, -0.182, 0.258> <2.236, 0.136, 0.350> <2.190, 0.226, 0.251> 
		<2.259, -0.234, 0.120> <2.314, -0.177, 0.237> <2.354, 0.132, 0.324> <2.308, 0.221, 0.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.905, 0.221, 0.230> <1.892, 0.311, 0.127> <1.856, 0.162, -0.150> <1.852, 0.028, -0.182> 
		<2.026, 0.221, 0.237> <2.013, 0.311, 0.134> <1.937, 0.162, -0.141> <1.933, 0.028, -0.173> 
		<2.190, 0.226, 0.251> <2.143, 0.316, 0.151> <2.058, 0.167, -0.129> <2.043, 0.029, -0.160> 
		<2.308, 0.221, 0.225> <2.262, 0.312, 0.125> <2.139, 0.166, -0.137> <2.124, 0.028, -0.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.259, -0.234, 0.120> <2.372, -0.229, 0.098> <2.511, -0.208, 0.032> <2.613, -0.202, -0.020> 
		<2.211, -0.284, 0.018> <2.324, -0.279, -0.004> <2.436, -0.250, -0.043> <2.538, -0.244, -0.095> 
		<2.111, -0.092, -0.196> <2.195, -0.092, -0.204> <2.298, -0.084, -0.224> <2.375, -0.085, -0.258> 
		<2.124, 0.028, -0.168> <2.208, 0.028, -0.177> <2.320, 0.025, -0.202> <2.397, 0.025, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.259, -0.234, 0.120> <2.314, -0.177, 0.237> <2.354, 0.132, 0.324> <2.308, 0.221, 0.225> 
		<2.372, -0.229, 0.098> <2.426, -0.172, 0.215> <2.477, 0.127, 0.297> <2.431, 0.217, 0.198> 
		<2.511, -0.208, 0.032> <2.592, -0.162, 0.113> <2.651, 0.125, 0.188> <2.581, 0.198, 0.118> 
		<2.613, -0.202, -0.020> <2.694, -0.156, 0.060> <2.762, 0.119, 0.128> <2.692, 0.192, 0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.308, 0.221, 0.225> <2.262, 0.312, 0.125> <2.139, 0.166, -0.137> <2.124, 0.028, -0.168> 
		<2.431, 0.217, 0.198> <2.384, 0.307, 0.099> <2.223, 0.166, -0.145> <2.208, 0.028, -0.177> 
		<2.581, 0.198, 0.118> <2.505, 0.278, 0.042> <2.346, 0.155, -0.176> <2.320, 0.025, -0.202> 
		<2.692, 0.192, 0.058> <2.615, 0.272, -0.018> <2.423, 0.155, -0.210> <2.397, 0.025, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.613, -0.202, -0.020> <2.682, -0.198, -0.055> <2.750, -0.202, -0.143> <2.823, -0.202, -0.169> 
		<2.538, -0.244, -0.095> <2.607, -0.240, -0.130> <2.699, -0.245, -0.229> <2.771, -0.245, -0.255> 
		<2.375, -0.085, -0.258> <2.466, -0.085, -0.298> <2.568, -0.080, -0.405> <2.662, -0.080, -0.435> 
		<2.397, 0.025, -0.236> <2.488, 0.024, -0.276> <2.582, 0.025, -0.381> <2.677, 0.025, -0.411> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.613, -0.202, -0.020> <2.694, -0.156, 0.060> <2.762, 0.119, 0.128> <2.692, 0.192, 0.058> 
		<2.682, -0.198, -0.055> <2.762, -0.152, 0.025> <2.823, 0.116, 0.095> <2.753, 0.189, 0.025> 
		<2.750, -0.202, -0.143> <2.808, -0.153, -0.047> <2.861, 0.116, 0.025> <2.812, 0.192, -0.056> 
		<2.823, -0.202, -0.169> <2.881, -0.153, -0.074> <2.926, 0.116, 0.000> <2.876, 0.192, -0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.692, 0.192, 0.058> <2.615, 0.272, -0.018> <2.423, 0.155, -0.210> <2.397, 0.025, -0.236> 
		<2.753, 0.189, 0.025> <2.676, 0.269, -0.051> <2.513, 0.154, -0.250> <2.488, 0.024, -0.276> 
		<2.812, 0.192, -0.056> <2.761, 0.271, -0.140> <2.599, 0.147, -0.354> <2.582, 0.025, -0.381> 
		<2.876, 0.192, -0.081> <2.825, 0.271, -0.166> <2.693, 0.147, -0.384> <2.677, 0.025, -0.411> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.823, -0.202, -0.169> <2.884, -0.202, -0.191> <2.974, -0.202, -0.178> <3.039, -0.202, -0.174> 
		<2.771, -0.245, -0.255> <2.832, -0.245, -0.277> <2.970, -0.246, -0.272> <3.034, -0.246, -0.268> 
		<2.662, -0.080, -0.435> <2.763, -0.080, -0.467> <2.920, -0.076, -0.463> <3.025, -0.076, -0.461> 
		<2.677, 0.025, -0.411> <2.777, 0.025, -0.443> <2.921, 0.025, -0.438> <3.026, 0.025, -0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.823, -0.202, -0.169> <2.881, -0.153, -0.074> <2.926, 0.116, 0.000> <2.876, 0.192, -0.081> 
		<2.884, -0.202, -0.191> <2.942, -0.153, -0.096> <2.972, 0.116, -0.018> <2.923, 0.192, -0.100> 
		<2.974, -0.202, -0.178> <2.979, -0.150, -0.068> <2.998, 0.113, 0.009> <2.993, 0.192, -0.083> 
		<3.039, -0.202, -0.174> <3.044, -0.150, -0.064> <3.048, 0.113, 0.013> <3.043, 0.192, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.876, 0.192, -0.081> <2.825, 0.271, -0.166> <2.693, 0.147, -0.384> <2.677, 0.025, -0.411> 
		<2.923, 0.192, -0.100> <2.872, 0.271, -0.184> <2.793, 0.147, -0.416> <2.777, 0.025, -0.443> 
		<2.993, 0.192, -0.083> <2.989, 0.269, -0.173> <2.923, 0.140, -0.411> <2.921, 0.025, -0.438> 
		<3.043, 0.192, -0.079> <3.039, 0.269, -0.168> <3.028, 0.140, -0.408> <3.026, 0.025, -0.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.039, -0.202, -0.174> <3.097, -0.202, -0.170> <3.191, -0.209, -0.187> <3.230, -0.202, -0.144> 
		<3.034, -0.246, -0.268> <3.092, -0.246, -0.265> <3.226, -0.252, -0.277> <3.265, -0.245, -0.234> 
		<3.025, -0.076, -0.461> <3.116, -0.076, -0.459> <3.278, -0.077, -0.491> <3.337, -0.078, -0.422> 
		<3.026, 0.025, -0.436> <3.117, 0.025, -0.434> <3.268, 0.026, -0.467> <3.328, 0.025, -0.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.039, -0.202, -0.174> <3.044, -0.150, -0.064> <3.048, 0.113, 0.013> <3.043, 0.192, -0.079> 
		<3.097, -0.202, -0.170> <3.102, -0.150, -0.060> <3.094, 0.113, 0.018> <3.089, 0.192, -0.074> 
		<3.191, -0.209, -0.187> <3.152, -0.159, -0.083> <3.130, 0.120, 0.002> <3.163, 0.198, -0.085> 
		<3.230, -0.202, -0.144> <3.190, -0.152, -0.040> <3.161, 0.114, 0.036> <3.194, 0.192, -0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.043, 0.192, -0.079> <3.039, 0.269, -0.168> <3.028, 0.140, -0.408> <3.026, 0.025, -0.436> 
		<3.089, 0.192, -0.074> <3.085, 0.269, -0.164> <3.119, 0.140, -0.406> <3.117, 0.025, -0.434> 
		<3.163, 0.198, -0.085> <3.197, 0.276, -0.173> <3.258, 0.144, -0.439> <3.268, 0.026, -0.467> 
		<3.194, 0.192, -0.051> <3.228, 0.270, -0.139> <3.317, 0.143, -0.370> <3.328, 0.025, -0.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.230, -0.202, -0.144> <3.346, -0.181, -0.014> <3.438, -0.137, 0.203> <3.516, -0.117, 0.359> 
		<3.265, -0.245, -0.234> <3.381, -0.225, -0.104> <3.493, -0.163, 0.188> <3.571, -0.142, 0.344> 
		<3.337, -0.078, -0.422> <3.491, -0.080, -0.241> <3.590, -0.042, 0.095> <3.685, -0.044, 0.314> 
		<3.328, 0.025, -0.398> <3.482, 0.023, -0.217> <3.576, 0.019, 0.099> <3.670, 0.017, 0.318> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.230, -0.202, -0.144> <3.190, -0.152, -0.040> <3.161, 0.114, 0.036> <3.194, 0.192, -0.051> 
		<3.346, -0.181, -0.014> <3.306, -0.131, 0.090> <3.263, 0.095, 0.147> <3.296, 0.173, 0.060> 
		<3.438, -0.137, 0.203> <3.375, -0.108, 0.220> <3.335, 0.087, 0.255> <3.388, 0.133, 0.241> 
		<3.516, -0.117, 0.359> <3.452, -0.087, 0.376> <3.406, 0.069, 0.388> <3.459, 0.115, 0.374> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.194, 0.192, -0.051> <3.228, 0.270, -0.139> <3.317, 0.143, -0.370> <3.328, 0.025, -0.398> 
		<3.296, 0.173, 0.060> <3.330, 0.251, -0.028> <3.471, 0.141, -0.189> <3.482, 0.023, -0.217> 
		<3.388, 0.133, 0.241> <3.442, 0.179, 0.226> <3.559, 0.089, 0.104> <3.576, 0.019, 0.099> 
		<3.459, 0.115, 0.374> <3.513, 0.161, 0.360> <3.653, 0.086, 0.322> <3.670, 0.017, 0.318> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.516, -0.117, 0.359> <3.534, -0.112, 0.396> <3.548, -0.127, 0.454> <3.548, -0.117, 0.494> 
		<3.571, -0.142, 0.344> <3.589, -0.137, 0.381> <3.594, -0.153, 0.424> <3.595, -0.142, 0.464> 
		<3.685, -0.044, 0.314> <3.696, -0.044, 0.339> <3.698, -0.042, 0.375> <3.690, -0.043, 0.402> 
		<3.670, 0.017, 0.318> <3.681, 0.016, 0.343> <3.686, 0.017, 0.383> <3.678, 0.017, 0.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.516, -0.117, 0.359> <3.452, -0.087, 0.376> <3.406, 0.069, 0.388> <3.459, 0.115, 0.374> 
		<3.534, -0.112, 0.396> <3.471, -0.082, 0.413> <3.428, 0.064, 0.429> <3.481, 0.109, 0.415> 
		<3.548, -0.127, 0.454> <3.493, -0.097, 0.489> <3.449, 0.079, 0.509> <3.495, 0.126, 0.479> 
		<3.548, -0.117, 0.494> <3.494, -0.086, 0.529> <3.456, 0.068, 0.554> <3.501, 0.115, 0.525> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.459, 0.115, 0.374> <3.513, 0.161, 0.360> <3.653, 0.086, 0.322> <3.670, 0.017, 0.318> 
		<3.481, 0.109, 0.415> <3.534, 0.155, 0.401> <3.664, 0.086, 0.348> <3.681, 0.016, 0.343> 
		<3.495, 0.126, 0.479> <3.539, 0.171, 0.451> <3.672, 0.085, 0.392> <3.686, 0.017, 0.383> 
		<3.501, 0.115, 0.525> <3.545, 0.160, 0.496> <3.664, 0.084, 0.419> <3.678, 0.017, 0.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, -0.014, 0.764> <3.527, -0.019, 0.759> <3.542, -0.003, 0.749> <3.540, 0.007, 0.750> 
		<3.528, -0.045, 0.683> <3.536, -0.049, 0.678> <3.584, 0.000, 0.647> <3.582, 0.010, 0.648> 
		<3.549, -0.095, 0.578> <3.595, -0.121, 0.548> <3.658, -0.045, 0.508> <3.646, 0.014, 0.515> 
		<3.548, -0.117, 0.494> <3.595, -0.142, 0.464> <3.690, -0.043, 0.402> <3.678, 0.017, 0.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, -0.014, 0.764> <3.528, -0.045, 0.683> <3.549, -0.095, 0.578> <3.548, -0.117, 0.494> 
		<3.511, -0.010, 0.769> <3.519, -0.040, 0.689> <3.495, -0.065, 0.614> <3.494, -0.086, 0.529> 
		<3.505, 0.015, 0.773> <3.501, 0.043, 0.700> <3.466, 0.051, 0.630> <3.456, 0.068, 0.554> 
		<3.512, 0.023, 0.769> <3.509, 0.050, 0.696> <3.511, 0.097, 0.600> <3.501, 0.115, 0.525> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.512, 0.023, 0.769> <3.509, 0.050, 0.696> <3.511, 0.097, 0.600> <3.501, 0.115, 0.525> 
		<3.519, 0.030, 0.764> <3.516, 0.058, 0.691> <3.555, 0.143, 0.572> <3.545, 0.160, 0.496> 
		<3.538, 0.018, 0.752> <3.579, 0.021, 0.650> <3.632, 0.082, 0.524> <3.664, 0.084, 0.419> 
		<3.540, 0.007, 0.750> <3.582, 0.010, 0.648> <3.646, 0.014, 0.515> <3.678, 0.017, 0.410> 
	}
}
}

#declare BL_Pipe=object{
 intersection{
  union{
   torus{3.025, 0.125}
   torus{0.975, 0.125}   
   difference{
    torus{2, 1.15}
    torus{2, 0.9}
    box{<-10,0,-10>,<10,10,10>}   
   }  
   difference{
    torus{2, 0.9}
    box{<-10,-0.25,-10>,<10,10,10>}   
   }
   torus{3.25,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   torus{0.75,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   union{
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,0>,<10,10,10> rotate<0,-62,0>}
     texture{Box_tex translate<4,23,78>}
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-58,0>}
     box{<-10,-10,0>,<10,10,10> rotate<0,-32,0>}
     texture{Box_tex translate<45,345,2>}     
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-28,0>}
     texture{Box_tex translate<343,3,2333>}     
    }
   }
  }
  box{<-10,-10,0>,<0,10,-10>}
  translate<2,0,2>
 }
}

#declare TL_Pipe=object{
 intersection{
  union{
   torus{3.025, 0.125}
   torus{0.975, 0.125}   
   difference{
    torus{2, 1.15}
    torus{2, 0.9}
    box{<-10,0,-10>,<10,10,10>}   
   }  
   difference{
    torus{2, 0.9}
    box{<-10,-0.25,-10>,<10,10,10>}   
   }   
   torus{3.25,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   torus{0.75,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
      union{
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,0>,<10,10,10> rotate<0,-62,0>}
     texture{Box_tex translate<333,222,111>}     
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-58,0>}
     box{<-10,-10,0>,<10,10,10> rotate<0,-32,0>}
     texture{Box_tex translate<454,4,2>}
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-28,0>}
     texture{Box_tex translate<2,0,45>}
    }
    rotate<0,90,0>
   }
  }
  box{<-10,-10,10>,<0,10,0>}
  translate<2,0,-2>  
 }
}

#declare TR_Pipe=object{
 intersection{
  union{
   torus{3.025, 0.125}
   torus{0.975, 0.125}   
   difference{
    torus{2, 1.15}
    torus{2, 0.9}
    box{<-10,0,-10>,<10,10,10>}   
   }  
   difference{
    torus{2, 0.9}
    box{<-10,-0.25,-10>,<10,10,10>}   
   }
   torus{3.25,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   torus{0.75,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   union{
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,0>,<10,10,10> rotate<0,-62,0>}
     texture{Box_tex translate<34,34,34>}
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-58,0>}
     box{<-10,-10,0>,<10,10,10> rotate<0,-32,0>} 
     texture{Box_tex translate<0,555,0>}
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-28,0>}
     texture{Box_tex translate<343,9,67>}
    }
    rotate<0,180,0>
   }
  }
  box{<0,-10,10>,<10,10,0>}
  translate<-2,0,-2>  
 }
}

#declare BR_Pipe=object{
 intersection{
  union{
   torus{3.025, 0.125}
   torus{0.975, 0.125}   
   difference{
    torus{2, 1.15}
    torus{2, 0.9}
    box{<-10,0,-10>,<10,10,10>}   
   }  
   difference{
    torus{2, 0.9}
    box{<-10,-0.25,-10>,<10,10,10>}   
   }
   torus{3.25,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   torus{0.75,0.05 translate<0,-0.3,0> texture{Small_pipes_tex}}
   union{
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,0>,<10,10,10> rotate<0,-62,0>}
     texture{Box_tex translate<33,777,6>}
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-58,0>}
     box{<-10,-10,0>,<10,10,10> rotate<0,-32,0>} 
     texture{Box_tex translate<12,12,233>}
    }
    difference{
     cylinder{<0,-0.25,0>,<0,-0.1,0>,2.85}
     cylinder{<0,-10,0>,<0,10,0>,1.15}
     box{<-10,-10,-10>,<10,10,0> rotate<0,-28,0>}
     texture{Box_tex translate<23,2323,1>}
    }
    rotate<0,270,0>
   }
  }
  box{<0,-10,-10>,<10,10,0>}
  translate<-2,0,2>    
 }
}

#declare X_Pipe=object{
 union{
  cylinder{<-2,0,1.025>,<2,0,1.025>,0.125}
  cylinder{<-2,0,-1.025>,<2,0,-1.025>,0.125}
  difference{
   cylinder{<-2,0,0>,<2,0,0>,1.15}
   cylinder{<-10,0,0>,<10,0,0>,0.9}  
   box{<-10,0,-10>,<10,10,10>}
  }
  difference{
   cylinder{<-2,0,0>,<2,0,0>,1.15}
   box{<-10,-0.25,-10>,<10,10,10>}   
  }
  cone{<-0.1,-0.3,-0.95>,0.1,<-0.1,-0.3,-1.25>,0.05}
  sphere{<-0.1,-0.3,-1.25>,0.125}
  cone{<0.75,-0.3,0.95>,0.1,<0.75,-0.3,1.25>,0.05}
  sphere{<0.75,-0.3,1.25>,0.125}
  cylinder{<-2,-0.3,-1.25>,<2,-0.3,-1.25>,0.05 texture{Small_pipes_tex}}
  cylinder{<-2,-0.3,1.25>,<2,-0.3,1.25>,0.05 texture{Small_pipes_tex}}  
  box{<-1.9,-0.25,-0.85>,<-1.1,-0.1,0.85> texture{Box_tex translate<3,34,888>}}
  box{<-0.9,-0.25,-0.85>,<-0.1,-0.1,0.85> texture{Box_tex translate<433,2,2222>}}  
  box{<1.9,-0.25,-0.85>,<1.1,-0.1,0.85> texture{Box_tex translate<2,2,433>}}
  box{<0.9,-0.25,-0.85>,<0.1,-0.1,0.85> texture{Box_tex translate<88,4,333>}}
 }
}

#declare Z_Pipe=object{
 union{
  cylinder{<1.025,0,-2>,<1.025,0,2>,0.125}//*
  cylinder{<1.025,0,-1>,<1.025,0,1>,0.15}
  torus{0.125,0.025 rotate<90,0,0> translate<1.025,0,-1>}
  torus{0.125,0.025 rotate<90,0,0> translate<1.025,0,1>}
    
  cylinder{<-1.025,0,-2>,<-1.025,0,2>,0.125}//*
  cylinder{<-1.025,0,-1>,<-1.025,0,1>,0.15}
  torus{0.125,0.025 rotate<90,0,0> translate<-1.025,0,-1>}
  torus{0.125,0.025 rotate<90,0,0> translate<-1.025,0,1>}
  
  difference{
   cylinder{<0,0,-2>,<0,0,2>,1.15}
   cylinder{<0,0,-10>,<0,0,10>,0.9}
   box{<-10,0,-10>,<10,10,10>}   
  }
  difference{
   cylinder{<0,0,-2>,<0,0,2>,1.15}
   box{<-10,-0.25,-10>,<10,10,10>}   
  }
  cone{<-0.95,-0.3,-0.1>,0.1,<-1.25,-0.3,-0.1>,0.05}
  sphere{<-1.25,-0.3,-0.1>,0.125}
  cylinder{<-1.25,-0.3,-2>,<-1.25,-0.3,2>,0.05 texture{Small_pipes_tex}}
  cone{<0.95,-0.3,0.75>,0.1,<1.25,-0.3,0.75>,0.05}
  sphere{<1.25,-0.3,0.75>,0.125}
  cylinder{<1.25,-0.3,-2>,<1.25,-0.3,2>,0.05 texture{Small_pipes_tex}}
  
  box{<-0.85,-0.25,-1.9>,<0.85,-0.1,-1.1>  texture{Box_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,-1> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,-1> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,-1.8> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,-1.8> texture{Small_pipes_tex}}  
  
  box{<-0.85,-0.25,-0.9>,<0.85,-0.1,-0.1> texture{Box_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,-0.8> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,-0.8> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,-0.2> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,-0.2> texture{Small_pipes_tex}}

  
  box{<-0.85,-0.25,1.9>,<0.85,-0.1,1.1> texture{Box_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,1.9> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,1.9> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,1.2> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,1.2> texture{Small_pipes_tex}}

  
  box{<-0.85,-0.25,0.9>,<0.85,-0.1,0.1> texture{Box_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,0.8> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,0.8> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<-0.75,-0.1,0.2> texture{Small_pipes_tex}}
  sphere{<0,0,0>,0.025 scale<1,0.5,1> translate<0.75,-0.1,0.2> texture{Small_pipes_tex}}

 }
}





#declare R1=seed(1223);
#declare old_dir=0;
#declare cur_dir=0;
#declare pipe_count=0;
#declare cur_vec=<0,0,0>;

#declare walk=object{
union{
object{Z_Pipe translate <0,0,-12>}
object{arm_1 scale 0.3 rotate<15,2,0> translate <1,-1,-12>}
object{arm_1 scale 0.25 rotate<2,180,0> translate <-1,-1,-12>}

object{Z_Pipe translate <0,0,-8>}
object{arm_1 scale 0.25 rotate<172,0,0> translate <1,-1,-7>}
object{arm_1 scale 0.25 rotate<0,180,0> translate <-1,-1,-8>}

object{Z_Pipe translate <0,0,-4>}
object{arm_1 scale 0.3 rotate<2,0,0> translate <1,-1,-4>}
object{arm_1 scale 0.25 rotate<0,180,0> translate <-1,-1.15,-4.5>}

object{Z_Pipe translate <0,0,0>}
object{arm_1 scale 0.4 rotate<10,2,0> translate <1,-1,0>}
object{arm_1 scale 0.25 rotate<0,180,0> translate <-1,-1,0>}

#while (pipe_count < 1000)
 #declare rand_rot=floor(rand(R1)*2); //int of 0 or 1
 #if(rand_rot=0)
  #declare y_rot=180;
 #else
  #declare y_rot=0;
 #end
 #declare cur_dir=floor(rand(R1)*3); //int of 0, 1, or 2
 
 #if(cur_dir=0 & old_dir=0)
  #declare cur_vec=cur_vec+<0,0,4>;
  object{Z_Pipe rotate<0,y_rot,0> translate cur_vec}
 #end

 #if(cur_dir=0 & old_dir=1) 
  #declare cur_vec=cur_vec+<-4,0,0>;
  object{BL_Pipe translate cur_vec}
  #declare cur_vec=cur_vec+<0,0,4>;
  object{Z_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end

 #if(cur_dir=0 & old_dir=2)
  #declare cur_vec=cur_vec+<4,0,0>;
  object{BR_Pipe translate cur_vec}
  #declare cur_vec=cur_vec+<0,0,4>;
  object{Z_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end
  
 #if(cur_dir=1 & old_dir=0)
  #declare cur_vec=cur_vec+<0,0,4>;
  object{TR_Pipe translate cur_vec}
  #declare cur_vec=cur_vec+<-4,0,0>;
  object{X_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end

 #if(cur_dir=2 & old_dir=0)
  #declare cur_vec=cur_vec+<0,0,4>;
  object{TL_Pipe translate cur_vec}
  #declare cur_vec=cur_vec+<4,0,0>;
  object{X_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end

 #if(cur_dir=1 & old_dir=1)
  #declare cur_vec=cur_vec+<-4,0,0>;
  object{X_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end

 #if(cur_dir=2 & old_dir=2)
  #declare cur_vec=cur_vec+<4,0,0>;
  object{X_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end
  
 #if(cur_dir=1 & old_dir=2)
  #declare cur_vec=cur_vec+<4,0,0>;
  #declare cur_dir=2;
  object{X_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end
 
 #if(cur_dir=2 & old_dir=1)
  #declare cur_vec=cur_vec+<-4,0,0>;
  #declare cur_dir=1;
  object{X_Pipe rotate<0,y_rot,0> translate cur_vec}  
 #end
  
 #debug str(cur_dir,0,0)
 
 #declare old_dir=cur_dir; 
 #declare pipe_count=pipe_count+1;
#end
}
}

//object{walk pigment{Black}}