
// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: 10/31/98
// Auth: Jared Saxton
//

#version 3.1;

#declare place_sky=1;
#declare place_water=1;
#declare place_hills=1;
#declare place_guy=1;
#declare place_walk=1;
#declare place_tree=1;
#declare place_balls=0;
    
    
#include "colors.inc"
//#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
//#include "floater.inc"
#if(place_guy=1)
 #include "character_2.inc"
 #declare carrier_pole_tex=texture{T_Chrome_2E}
#end
#if(place_walk=1)
 #include "pipes.inc"
#end
#if(place_tree=1)
 #include "tree.inc"
#end
#if(place_tree=1)
 #include "hair_macros.inc"
#end
                  
global_settings
{
  assumed_gamma 1.0
  ambient_light<0.5,0.5,0.8>
}


// ----------------------------------------
camera
{
  location  <0.0, 25, -100.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-20.0, 30,  0.0>
  aperture 1
  focal_point<0,0,0>
}

//light_source{0*x // light's position (translated below)
//  color red 0.3  green 0.3  blue 0.8  // light's color
//  translate <1200, 1200, -1200>}

light_source
{
  0*x // light's position (translated below)
  color rgb <1,1,0.8>  // light's color
//  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <-50, 0, 0> <0, 0, 50> // lights spread out across this distance (x * z)
  5, 5                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <1200, 1200, -1200>   // <x y z> position of light
}

// ----------------------------------------

#if(place_tree=1)
 #declare The_Tree=object{
 union{
   #declare tree_tex_1=texture{pigment{gradient y color_map{
        [0 0.9  color Black color rgb<0.3,0.6,0.1>]
        [0.9 0.95 color rgb<0.3,0.6,0.1> color rgb<0.6,0.9,0.4>]
        [0.95 1.0 color rgb<0.6,0.9,0.4> color rgb<0.2,0.5,0> ]
        } turbulence 0.25} finish{phong 1.0} rotate<60,0,0> scale<30,30,30>}
   #declare tree_tex_2=texture{pigment{spiral1 3 color_map{
        [0 0.25 color Clear color rgbf<0.8,0.1,0.1,0.8>]
        [0.25 0.75 color rgbf<0.8,0.1,0.1,0.7> color rgbf<0.8,0.1,0.1,0.8>]
        [0.75 1.0 color rgbf<0.8,0.4,0.1,0.9> color Clear]
        } turbulence 0.5} rotate<60,0,0> scale<30,70,30>}
   object{tree_trunk rotate<0,90,0> scale<30,50,30> translate<0,-230,0>
    texture{tree_tex_1}
    texture{tree_tex_2}
   }
   //#macro puff_ball_bop(hair_count, lift_rad, seed_num, limp_factor, init_len, len_fac, hair_tex,bop_rad_max)
   union{
    puff_ball_bop(300,0,5, 0.1, 40, 0.6, texture{pigment{rgb<0.1,0.4,0.1>}}, 10)
    translate<0,0,0>
   }
   scale 0.05
   translate<-10,24,-15>
  }
 }
#end

//#declare main_bld_tex=texture{T_Stone44 scale 0.6}
#declare main_bld_tex=texture{T_Stone44 scale 30}

#declare Blue_Sky_Map =
color_map {
    [0.5 color rgbf<0.25,0.25,0.5,0.7>]
    [0.6 rgb 0.7]
    [1.0 rgb 0.3]
}

// Basic Blue Sky w/ clouds.
#declare Blue_Sky = 
pigment {
    bozo
    color_map { Blue_Sky_Map }
    turbulence 0.3
}

#declare Strange_Sky_Map =
color_map {
    [0.5 rgbf <0.2,0.2,0.5>]
    [0.6 rgb <0.7,0.6,0.6>]
    [1.0 rgb <0.3,0.2,0.2>]
}

#declare Strange_Sky = 
pigment {
    bozo
    color_map { Strange_Sky_Map }
    turbulence 0.5
}

#if(place_sky=1)
 sphere{<0,0,0>,20000 inverse texture{pigment{Strange_Sky scale <10000,1000,10000>}} texture{pigment{Blue_Sky scale <12000,3000,12000>}}} //change radius to 150 for way-ominous look
#end

#if(place_hills=1)
 height_field{tga "c:\images\hill_hf.tga" smooth texture{pigment{image_map { tga "c:\images\hill_map.tga" map_type 0 interpolate 2 once } rotate x*90}}
  rotate<0,180,0>  scale<15,1.75,5> scale 20 translate <15,-1,250> scale 40}
height_field{tga "c:\images\hill_hf.tga" smooth texture{pigment{image_map { tga "c:\images\hill_map.tga" map_type 0 interpolate 2 once } rotate x*90}}
  scale<5,0.75,5> scale 20 translate <-25,-1,20> scale 40}
#end

#if(place_water=1)
 plane { y, 0 interior{ior 1.33} texture {pigment { color rgbt <0.3,0.5,0.4,0.5> } finish { phong 1 phong_size 6000 reflection 0.4 } normal{  bumps 0.15 scale 2 }    }  }  
#end

#if(place_guy=1)
#declare carrier_pole_tex=texture{pigment{Black} finish{phong 1.0}}
#declare pot_tex=texture{pigment{Gray05}} texture{pigment{crackle color_map{[0.0 0.01 color White color Clear][0.01 1.0 color Clear color Clear]} turbulence 0.25 scale 15  }}  texture{pigment{crackle color_map{[0.0 0.025 color Gray10 color Clear][0.025 1.0 color Clear color Clear]} turbulence 0.5 scale 10 translate<1,1,1> } finish{phong 1.0}}
#declare rope_tex=texture{pigment{Brown}}
#declare water_carrier=object{
 union{
  cylinder{<-8,0,0>,<8,0,0>,0.25 texture{carrier_pole_tex}}
  intersection{
   torus{1,0.25 rotate<90,0,0> translate<-8,-1,0>}
   box{<-20,-1,-10>,<-8,10,10>}
   texture{carrier_pole_tex}
  }
  intersection{
   torus{1,0.25 rotate<90,0,0> translate<-10,-1,0>}
   box{<-10,-1,-10>,<0,-10,10>}
   texture{carrier_pole_tex}
  }
  intersection{
   torus{1,0.25 rotate<90,0,0> translate<8,-1,0>}
   box{<20,-1,-10>,<8,10,10>}
   texture{carrier_pole_tex}
  }
  intersection{
   torus{1,0.25 rotate<90,0,0> translate<10,-1,0>}
   box{<0,-1,-10>,<10,-10,10>}
   texture{carrier_pole_tex}
  }
  cylinder{<-10,-2,0>,<-12,-2,0>,0.25 texture{carrier_pole_tex}}
  cylinder{<10,-2,0>,<12,-2,0>,0.25 texture{carrier_pole_tex}}

  cylinder{<-12,-2,0>,<-13,-2,0>,0.125 pigment{White}}
  intersection{
   torus{0.25,0.125 rotate<90,0,0> translate<-13,-2.25,0>}
   box{<-100,-2.25,-100>,<-13,100,100>}
   pigment{White}
  }
  difference{
   torus{0.5,0.125 rotate<90,0,0> translate<-13.75,-2.25,0>}
   box{<-100,-2.25,-100>,<100,10,100>}
   pigment{White}
  }
  
  cylinder{<12,-2,0>,<13,-2,0>,0.125 pigment{White}}
  intersection{
   torus{0.25,0.125 rotate<90,0,0> translate<13,-2.25,0>}
   box{<100,-2.25,-100>,<13,100,100>}
   pigment{White}
  }
  difference{
   torus{0.5,0.125 rotate<90,0,0> translate<13.75,-2.25,0>}
   box{<-100,-2.25,-100>,<100,10,100>}
   pigment{White}
  }
  
  sphere{<13.75,-2.75,0>,0.3 texture{rope_tex}}
  sphere{<-13.75,-2.75,0>,0.3 texture{rope_tex}}
  cylinder{<13.75,-2.75,0>,<13.75,-4.5,0>,0.2 texture{rope_tex}}
  cylinder{<-13.75,-2.75,0>,<-13.75,-4.5,0>,0.2 texture{rope_tex}}
  
  torus{0.5,0.2 rotate<90,0,0> translate<13.75,-4.7,0> texture{rope_tex}}
  torus{0.5,0.2 rotate<90,0,0> translate<-13.75,-4.7,0> texture{rope_tex}}

  sphere{<-5.5,0,0>,1 pigment{Pink}}
  sphere{<5.5,0,0>,1 pigment{Pink}}
 }
}

#declare pot_1=object{
 union{
  lathe {
   cubic_spline // linear_spline | quadratic_spline | cubic_spline
   5, // number of points
   <1, 0>, <2, 0>, <4, 3>, <2, 7>, <1, 0> // the list of <u,v> points
  }
  torus{2.2,0.3 translate<0,7,0>}
  difference{
   cylinder{<0,7,0>,<0,0,0>,2}
   cylinder{<0,-10,0>,<0,10,0>,1.9}
  }
  difference{
   torus{1,0.5}
   cylinder{<0,-10,0>,<0,10,0>,0.8}
   rotate<0,0,90> translate<0,6,-3.25>
  }
  difference{
   torus{1,0.5}
   cylinder{<0,-10,0>,<0,10,0>,0.8}
   box{<-10,-10,-10>,<10,10,-1.25>}
   rotate<0,0,90> translate<0,6,3.25>
  }
  cylinder{<0,0,0>,<0,1,0>,2}
  translate<0,-7,0>
  scale 0.75
 }
}

#declare full_water_carrier=object{
 union{
  object{water_carrier}
  object{pot_1 rotate<0,15,0> rotate<-30,0,0> translate<-14.5,-6.2,-2.25> texture{pot_tex}}
  object{pot_1 rotate<-50,0,0> translate<13.75,-7.1,-2.25> texture{pot_tex}}
 }
}
#end


#if(place_balls=1)
 #declare Obj_Num = 5;
 #declare Ball_Array = array[Obj_Num]
 #declare Rad_Array = array[Obj_Num]
 #declare X_Bound = 1000;
 #declare Y_Bound = 1;
 #declare Z_Bound = 1000;
 #declare Min_Dist = 1;
 #declare Max_Rad = 5;
 #declare Min_Rad = 1;
 #declare R1 = seed(212);
 #declare Ball_Array[0] = <rand(R1)*X_Bound*2-X_Bound,rand(R1)*Y_Bound*2-Y_Bound,rand(R1)*Z_Bound*2-Z_Bound>;
 #declare Rad_Array[0] = rand(R1)*Max_Rad;
 #declare Main_Count = 1;
 
 #while(Main_Count < Obj_Num)
         #debug concat("Processing object number ",str(Main_Count,0,0),"\n")
         #declare Collision = 0;
         #declare Ball_Array[Main_Count] = <rand(R1)*X_Bound*2-X_Bound,rand(R1)*Y_Bound*2-Y_Bound,rand(R1)*Z_Bound*2-Z_Bound>;
         #declare Rad_Array[Main_Count] = (rand(R1)*(Max_Rad-Min_Rad))+Min_Rad;//      1 to 5 = (rand(R1)*(5-1))+1
         #declare Sub_Count = 0;
         #while(Sub_Count < Main_Count)
                 #if(vlength(Ball_Array[Sub_Count] - Ball_Array[Main_Count]) <= Rad_Array[Sub_Count]+Rad_Array[Main_Count])
                        #declare Collision = 1;
                        #declare Sub_Count = Main_Count;
                #end
                #declare Sub_Count = Sub_Count+1;
         #end
         #if(Collision = 0)
                 #declare Main_Count = Main_Count+1;
         #end
 #end
 union{
 #declare Main_Count=0;
 #while(Main_Count < Obj_Num)
   sphere {Ball_Array[Main_Count], Rad_Array[Main_Count] interior{ior 1.33} texture {pigment { color rgbt <0.3,0.5,0.4,0.6> } finish { phong 1 phong_size 6000 reflection 0.4 } normal{  bumps 0.15 scale 0.5 }}}
  #declare Main_Count=Main_Count+1;
 #end
 scale 2 translate<-45,8,30>
 }
#end

#if(place_guy=1)
 object{scarry_guy scale 3 translate<-45,2.5,10>}
 object{full_water_carrier rotate<0,0,-3> translate<-45,9.5,4.5>}
#end
//object{floater_house_1 rotate<0,30,0> translate<20,15,-10> texture{main_bld_tex finish{ambient<0.1,0.1,0.2>}}}
#if(place_walk=1)
// object{walk scale<8,5,5> translate<-45,3,26> texture{pigment{Black} finish{phong 1.0}}}
object{walk scale<8,5,5> translate<-45,3,26> texture{tree_tex_1 rotate<90,0,0>} texture{tree_tex_2 rotate<90,0,0>}}
#end
#if(place_tree=1)
 object{The_Tree scale 2 translate<20,0,150>}
#end
