// Date: 21 Oct 98
// Auth: SjG libelle@webbwerks.com
// Heaven Weeps: IRTC Contest entry for Water.

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"

#declare PI = 3.14159265358979
#declare radToDeg = 180/PI
#declare degToRad = PI/180

#declare testing = 0

#declare Water = texture {
  pigment {
    color rgbf <0.9, 0.9, 1.0, 0.95>
  }
  finish {
    ambient 0.9
    diffuse 0.7
    reflection 0.4
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 100
  }
  scale <0.2,0.2,0.2>
}
#declare StdCam = camera
	{
	location  <-1.0, 0.0, -10.0>
	direction z 
	up        y
	right     4/3*x
	look_at   <0.0, 0.95,  0.0>
	}
	
#declare mainLight =  light_source
		{
		0*x
		color red 1.0  green 1.0  blue 1.0
		translate <-20,40,-40>
		}
	
#declare secondaryLight = light_source
	{
	0*x
	color red 1  green 1  blue 1
	translate <50,20,-50>
	shadowless
	}
	
#declare tertiaryLight = light_source
	{
	0*x
	color red 0.4  green 0.4  blue 0.4
	translate <-40,40,-50>
	shadowless
	}
	
#declare icoSilver = texture{T_Silver_3D}
#declare icoSilver2 = texture{T_Silver_1A}
#declare icoGold = texture{T_Gold_3D}
#declare icoGlass = texture{NBglass}
#declare UltraWhite = rgb <2,2,2>


// Needs to lie in the XZ plane
#declare icoBaseTriangle = union {
	cylinder {<0.5,0,.4330127>,<0.5,0,0>,0.1
		texture{icoSilver}}
	cylinder {<0.5,0,.4330127>,<0,0,1.7320508>,0.1
		texture{icoSilver}}
	cylinder {<0.5,0,.4330127>,<1,0,.4330127>,0.1
		texture{icoSilver}}
	cone {<0.5,0,0.4330127>,0.1,<0.5,0.7,0.4330127>,0.01
		texture{icoSilver}}
	cone {<0.5,0,0.4330127>,0.1,<0.5,-0.7,0.4330127>,0.01
		texture{icoSilver}}
	}


#declare icoFaceThickness = 0.05
#declare icoEdgeTexture = texture {icoSilver2}
#declare moorRosetteOrder = 1

#declare theIco = #include "moorIco.inc"


#declare icoBaseTriangle = union {
	cylinder {<0.5,0,.4330127>,<0.5,0,0>,0.0125
		texture{icoSilver}}
	cylinder {<0.5,0,.4330127>,<0,0,1.7320508>,0.0125
		texture{icoSilver}}
	cylinder {<0.5,0,.4330127>,<1,0,.4330127>,0.0125
		texture{icoSilver}}
}

#declare icoFaceThickness = 0.00625
#declare icoEdgeTexture = texture {icoSilver}
#declare moorRosetteOrder = 1

#declare theIco2 = #include "moorIco.inc"


#declare icoBaseTriangle4 = box {
	<-0.1,0,0.2>,<1.1,0.2,.27>	texture{icoSilver}
}

#if (testing >= 1)
#declare goldCentered = sphere {<0,0,0>,0.7 texture{pigment{rgb<1,1,0>}}}
#else
#declare goldCentered = union {
	object {theIco scale <2,2,2> rotate <-1,-5 - clock*360,0>}
	object {theIco2 scale <2.5,2.5,2.5> rotate <clock*360,60,0>}
	scale <.1,.1,.1>
}
#end

#declare dullCloud = pigment {
    wrinkles
    turbulence 1
    octaves 8
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color rgb <0.078, 0.025, 0.307>
                    color rgb <0.050, 0.020, 0.012>]
        [0.1, 0.5   color rgbt <0.050, 0.020, 0.012, 0>
                    color rgbt <0.01258, 0.01258, 0.02435, 0.2>  ]
        [0.5, 1.001 color rgbt <0.01258, 0.01258, 0.02435, 0.2>
                    color rgbt <0.01258, 0.01258, 0.02435, 0.5> ]
    }
    scale <6, 1, 6>
	}
	
#declare lighterCloud = pigment {
    bozo
    color_map {
        [0.0, 0.1   color rgb <0.001, 0.001, 0.001>
                    color rgb <0.12, 0.012, 0.0125>]
        [0.1, 0.5   color rgbt <0.12, 0.012, 0.0125, 0>
                    color rgbt <0.03, 0.03, 0.03, 0.3> ]
        [0.5, 1.001 color rgbt <0.03, 0.03, 0.04, 0.3>
                    color rgbt <0.4, 0.1, 0.25, 0.01>]
    }
    turbulence 0.6
    octaves 6
    omega 0.71
    lambda 2.2
    scale <1, 6, 1>
}

#declare theSky = sky_sphere {
	pigment {
		granite
		frequency 1.18
		turbulence 0.25
		color_map {
			[0.01	color LightBlue]
			[0.04	color UltraWhite]  //04
			[0.041	color Black]  //041
			}
	scale <0.03,0.03,0.03> //0.025
	}
   pigment {
		gradient y
			pigment_map {
				[0.01 rgbt <0.4, 0.3, 0.45, 0.001> ] // horizon
				[0.25 dullCloud scale 0.25 rotate z*5]
				[0.40 lighterCloud scale <0.25, 0.15, 0.25> rotate z*10]
    		}
    	}
	translate <0,0.05,0>
	rotate <0,clock*360,0>
	}
	



#declare daSplash = blob {

#declare randSeed = seed(6167)
#if (testing = 1)
	#declare gridRes = 1
#else
	#declare gridRes = 20
#end


#declare theCount = 0
#while (theCount < 25)
	sphere {<-2.5+rand(randSeed)*4,17+rand(randSeed)*4,-2.5+rand(randSeed)*4>,
		max(2*rand(randSeed),1),max(8*rand(randSeed),2)}
	#declare theCount = theCount + 5
#end

sphere {<-0.9,15,0>,2,0.8}
sphere {<-0.3,15.5,0>,1,1}


// detail the center area...
#declare step = PI/10
#declare xgrid = -gridRes*PI
#declare zgrid = -gridRes*PI
#while (zgrid < gridRes*PI)
	#declare xgrid = -gridRes*PI
	#while (xgrid < gridRes*PI)
		#declare daRadius = sqrt(xgrid*xgrid + zgrid*zgrid)
		sphere {<xgrid, 15*(sin(daRadius)/daRadius), zgrid>,
			max(2*rand(randSeed),1.12), rand(randSeed)/2} // was over 4
		#declare xgrid = xgrid + step 
	#end
	#declare zgrid = zgrid + step
#end


	sturm

	texture { Water }
}

 
// --=--=--=--=--=--=--=--=--=--=--=--=--=-- 
// Actual scene gets put together here...
// --=--=--=--=--=--=--=--=--=--=--=--=--=-- 
camera{StdCam}
object{mainLight}
object{mainLight translate <0,-0.25,0>}
object{mainLight translate <0,-0.5,0>}
object{secondaryLight}
object{tertiaryLight}
sky_sphere{theSky}

object{theIco rotate<0,30,0> translate <0,7,0>}
object{theIco translate <50,16,100>}
object{theIco translate <-30,12,50>}
object{theIco translate <30,16,40>}
object{theIco translate <-60,12,72>}

object{daSplash scale <0.25, 0.25, 0.25> translate <0,-2,0> }

