// Moorish Icosahedron Geometrics include file
// for POV-ray 3.x
// Initial implementation attempt
// 6-28-97 Samuel J. Goldstein libelle@webbwerks.com

#declare cleanIcoTriangle = intersection {
	object{icoBaseTriangle}
	plane{-x,0 rotate <0,-90,0> texture{icoEdgeTexture}}
	plane{x,0 translate <1,0,0> texture{icoEdgeTexture}}
	plane{-x,0 rotate <0, 30, 0> texture{icoEdgeTexture}}
	}
		
#declare fullIcoTriangle = union {
	object {cleanIcoTriangle }
	object {cleanIcoTriangle scale <1,-1,-1>}
	}
	
#declare icoFace=union {
	object {fullIcoTriangle}
	object {fullIcoTriangle rotate <0,120,0>}
	object {fullIcoTriangle rotate <0,240,0>}
	translate <0,-(2*icoFaceThickness),0>
	rotate <-90.0,0,0>
	rotate <0,0,30.0>
	translate <0,1.0,0> 
}

#declare extendLen = 2.3839601 // because the side of the triangle is 1.7320508
#declare topExtend = extendLen - 4*icoFaceThickness*cos(radians(-52.622632))
#declare topDrop = 4*icoFaceThickness*sin(radians(-52.622632))
#declare centerDrop = 0.8660254 * cos(radians(169.18768))

#declare icosHalf = union { 
	object{icoFace rotate <-52.622632,0,0>
		translate <0,topDrop,topExtend> rotate <0,0,0>}
   object{icoFace rotate <-52.622632,0,0>
   	translate <0,topDrop,topExtend> rotate <0,-72,0>}
   object{icoFace rotate <-52.622632,0,0>
   	translate <0,topDrop,topExtend> rotate <0,-144,0>}
   object{icoFace rotate <-52.622632,0,0>
   	translate <0,topDrop,topExtend> rotate <0,-216,0>}
   object{icoFace rotate <-52.622632,0,0>
   	translate <0,topDrop,topExtend> rotate <0,-288,0>}
   object{icoFace rotate <169.18768,0,0>
   	translate <0,0,extendLen> rotate <0,0,0>}
   object{icoFace rotate <169.18768,0,0>
   	translate <0,0,extendLen> rotate <0,-72,0>}
   object{icoFace rotate <169.18768,0,0>
   	translate <0,0,extendLen> rotate <0,-144,0>}
   object{icoFace rotate <169.18768,0,0>
   	translate <0,0,extendLen> rotate <0,-216,0>}
   object{icoFace rotate <169.18768,0,0>
   	translate <0,0,extendLen> rotate <0,-288,0>}
   }

union { 
	object{icosHalf}
	object{icosHalf scale <1,-1,1> rotate <0,-36,0> translate <0,-2.9467408,0>}
	translate <0,1.4733704,0>
   }
