//  Heavywater
//  S.T. McWhinnie
//  stubbs@dundee.net
//

//  Date : 10/31/1998    (31.10.1998)
//

/*
  
*/

/* // Scene Comment

This scene was primarily created with Moray V3.01 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-67.005, 72.357, 34.191>
  direction <0.0,     0.0,  1.2029>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-16.300, 8.404, -14.210>
}


light_source {   // corner lite
  <-53.783, 58.796, -15>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  20.0
  fade_power 2.0 
}

light_source {   // Spotlight SpotLite002
  <24.090, 74.479, 1.401>
  color  rgb <0.950, 0.721, 0.516>
  fade_distance  30.0
  fade_power 2.0 
}


light_source {   // backlite
  <75, -73.751, -5>
  color  rgb <1.000, 1.000, 1.000>
  fade_distance 10.0
  fade_power 2
}

light_source {   //  hanging lite group
  <12.014, -73.751, -5>
  color  rgb <1.000, 1.000, 1.000>
         fade_distance 10.0
  fade_power 2
}

light_source {   // Light1
  <0.000, 0.000, -40.000>
  color rgb <0.000, 0.000, 1.000>
  fade_distance  10.0
  fade_power 1.0
}


//
// ********  TEXTURES  *******
//

#include "tanktest6.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <76.870003, 41.752058, 0.000000>, <76.870003, 41.752058, 0.114796>, <76.930182, 41.726634, 0.272326>, <77.004954, 41.695037, 0.353500>, 
      <76.329261, 38.291299, 0.000000>, <76.329261, 38.291299, 0.114796>, <76.389440, 38.265875, 0.272326>, <76.464211, 38.234278, 0.353500>, 
      <76.579482, 33.375821, 0.000000>, <76.579482, 33.375821, 0.114796>, <76.656026, 33.342518, 0.272326>, <76.730797, 33.310922, 0.353500>, 
      <75.067526, 30.216195, 0.000000>, <75.067526, 30.216195, 0.114796>, <75.127706, 30.190774, 0.272326>, <75.202477, 30.159174, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.004954, 41.695037, -0.353500>, <76.930182, 41.726634, -0.272326>, <76.870003, 41.752058, -0.114796>, <76.870003, 41.752058, 0.000000>, 
      <76.464211, 38.234278, -0.353500>, <76.389440, 38.265875, -0.272326>, <76.329261, 38.291299, -0.114796>, <76.329261, 38.291299, 0.000000>, 
      <76.730797, 33.310922, -0.353500>, <76.656026, 33.342518, -0.272326>, <76.579482, 33.375821, -0.114796>, <76.579482, 33.375821, 0.000000>, 
      <75.202477, 30.159174, -0.353500>, <75.127706, 30.190774, -0.272326>, <75.067526, 30.216195, -0.114796>, <75.067526, 30.216195, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.330566, 41.557430, -0.500000>, <77.224826, 41.602115, -0.500000>, <77.079718, 41.663440, -0.434673>, <77.004954, 41.695037, -0.353500>, 
      <76.789824, 38.096672, -0.500000>, <76.684083, 38.141357, -0.500000>, <76.538976, 38.202682, -0.434673>, <76.464211, 38.234278, -0.353500>, 
      <77.094566, 33.154522, -0.500000>, <76.988826, 33.199210, -0.500000>, <76.805568, 33.279325, -0.434673>, <76.730797, 33.310922, -0.353500>, 
      <75.528090, 30.021568, -0.500000>, <75.422349, 30.066256, -0.500000>, <75.277242, 30.127578, -0.434673>, <75.202477, 30.159174, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.656179, 41.419824, -0.353500>, <77.581414, 41.451421, -0.434672>, <77.436307, 41.512746, -0.500000>, <77.330566, 41.557430, -0.500000>, 
      <77.115443, 37.959066, -0.353500>, <77.040672, 37.990662, -0.434672>, <76.895571, 38.051987, -0.500000>, <76.789824, 38.096672, -0.500000>, 
      <77.456563, 32.998458, -0.353500>, <77.381798, 33.030061, -0.434672>, <77.200307, 33.109834, -0.500000>, <77.094566, 33.154522, -0.500000>, 
      <75.853709, 29.883962, -0.353500>, <75.778938, 29.915558, -0.434672>, <75.633837, 29.976880, -0.500000>, <75.528090, 30.021568, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.791130, 41.362794, 0.000000>, <77.791130, 41.362794, -0.114797>, <77.730950, 41.388221, -0.272326>, <77.656179, 41.419824, -0.353500>, 
      <77.250387, 37.902035, 0.000000>, <77.250387, 37.902035, -0.114797>, <77.190208, 37.927462, -0.272326>, <77.115443, 37.959066, -0.353500>, 
      <77.606093, 32.933885, 0.000000>, <77.606093, 32.933885, -0.114797>, <77.531334, 32.966858, -0.272326>, <77.456563, 32.998458, -0.353500>, 
      <75.988653, 29.826931, 0.000000>, <75.988653, 29.826931, -0.114797>, <75.928474, 29.852362, -0.272326>, <75.853709, 29.883962, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.656179, 41.419824, 0.353500>, <77.730950, 41.388221, 0.272326>, <77.791130, 41.362794, 0.114797>, <77.791130, 41.362794, 0.000000>, 
      <77.115443, 37.959066, 0.353500>, <77.190208, 37.927462, 0.272326>, <77.250387, 37.902035, 0.114797>, <77.250387, 37.902035, 0.000000>, 
      <77.456563, 32.998458, 0.353500>, <77.531334, 32.966858, 0.272326>, <77.606093, 32.933885, 0.114797>, <77.606093, 32.933885, 0.000000>, 
      <75.853709, 29.883962, 0.353500>, <75.928474, 29.852362, 0.272326>, <75.988653, 29.826931, 0.114797>, <75.988653, 29.826931, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.330566, 41.557430, 0.500000>, <77.436307, 41.512746, 0.500000>, <77.581414, 41.451421, 0.434672>, <77.656179, 41.419824, 0.353500>, 
      <76.789824, 38.096672, 0.500000>, <76.895571, 38.051987, 0.500000>, <77.040672, 37.990662, 0.434672>, <77.115443, 37.959066, 0.353500>, 
      <77.094566, 33.154522, 0.500000>, <77.200307, 33.109834, 0.500000>, <77.381798, 33.030061, 0.434672>, <77.456563, 32.998458, 0.353500>, 
      <75.528090, 30.021568, 0.500000>, <75.633837, 29.976880, 0.500000>, <75.778938, 29.915558, 0.434672>, <75.853709, 29.883962, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <77.330566, 41.557430, 0.500000>, <76.789824, 38.096672, 0.500000>, <77.094566, 33.154522, 0.500000>, <75.528090, 30.021568, 0.500000>, 
      <77.224826, 41.602115, 0.500000>, <76.684083, 38.141357, 0.500000>, <76.988826, 33.199210, 0.500000>, <75.422349, 30.066256, 0.500000>, 
      <77.079718, 41.663440, 0.434673>, <76.538976, 38.202682, 0.434673>, <76.805568, 33.279325, 0.434673>, <75.277242, 30.127578, 0.434673>, 
      <77.004954, 41.695037, 0.353500>, <76.464211, 38.234278, 0.353500>, <76.730797, 33.310922, 0.353500>, <75.202477, 30.159174, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.115885, 27.637581, 0.000000>, <71.790413, 27.670275, 0.000000>, <74.344582, 28.705411, 0.000000>, <75.067526, 30.216195, 0.000000>, 
      <70.115885, 27.637581, 0.114797>, <71.790413, 27.670275, 0.114797>, <74.344582, 28.705411, 0.114796>, <75.067526, 30.216195, 0.114796>, 
      <70.116506, 27.572253, 0.272327>, <71.838918, 27.608371, 0.272327>, <74.376019, 28.640621, 0.272326>, <75.127706, 30.190774, 0.272326>, 
      <70.117286, 27.491082, 0.353500>, <71.839699, 27.527200, 0.353500>, <74.450790, 28.609021, 0.353500>, <75.202477, 30.159174, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.117286, 27.491082, -0.353500>, <71.839699, 27.527200, -0.353500>, <74.450790, 28.609021, -0.353500>, <75.202477, 30.159174, -0.353500>, 
      <70.116506, 27.572253, -0.272327>, <71.838918, 27.608371, -0.272327>, <74.376019, 28.640621, -0.272326>, <75.127706, 30.190774, -0.272326>, 
      <70.115885, 27.637581, -0.114797>, <71.790413, 27.670275, -0.114797>, <74.344582, 28.705411, -0.114796>, <75.067526, 30.216195, -0.114796>, 
      <70.115885, 27.637581, 0.000000>, <71.790413, 27.670275, 0.000000>, <74.344582, 28.705411, 0.000000>, <75.067526, 30.216195, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.120653, 27.137600, -0.500000>, <71.958630, 27.182502, -0.500000>, <74.705882, 28.377139, -0.500000>, <75.528090, 30.021568, -0.500000>, 
      <70.119558, 27.252390, -0.500000>, <71.957542, 27.297296, -0.500000>, <74.600134, 28.421824, -0.500000>, <75.422349, 30.066256, -0.500000>, 
      <70.118054, 27.409914, -0.434673>, <71.840467, 27.446029, -0.434673>, <74.525562, 28.577424, -0.434673>, <75.277242, 30.127578, -0.434673>, 
      <70.117286, 27.491082, -0.353500>, <71.839699, 27.527200, -0.353500>, <74.450790, 28.609021, -0.353500>, <75.202477, 30.159174, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.124013, 26.784118, -0.353500>, <72.077600, 26.838552, -0.353500>, <74.959405, 28.146240, -0.353500>, <75.853709, 29.883962, -0.353500>, 
      <70.123245, 26.865286, -0.434673>, <72.076826, 26.919722, -0.434673>, <74.884634, 28.177840, -0.434672>, <75.778938, 29.915558, -0.434672>, 
      <70.121741, 27.022810, -0.500000>, <71.959725, 27.067712, -0.500000>, <74.811622, 28.332451, -0.500000>, <75.633837, 29.976880, -0.500000>, 
      <70.120653, 27.137600, -0.500000>, <71.958630, 27.182502, -0.500000>, <74.705882, 28.377139, -0.500000>, <75.528090, 30.021568, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.125414, 26.637624, 0.000000>, <72.126912, 26.696224, 0.000000>, <75.064038, 28.050832, 0.000000>, <75.988653, 29.826931, 0.000000>, 
      <70.125414, 26.637624, -0.114796>, <72.126912, 26.696224, -0.114796>, <75.064038, 28.050832, -0.114797>, <75.988653, 29.826931, -0.114797>, 
      <70.124787, 26.702949, -0.272326>, <72.078368, 26.757384, -0.272326>, <75.034170, 28.114640, -0.272326>, <75.928474, 29.852362, -0.272326>, 
      <70.124013, 26.784118, -0.353500>, <72.077600, 26.838552, -0.353500>, <74.959405, 28.146240, -0.353500>, <75.853709, 29.883962, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.124013, 26.784118, 0.353500>, <72.077600, 26.838552, 0.353500>, <74.959405, 28.146240, 0.353500>, <75.853709, 29.883962, 0.353500>, 
      <70.124787, 26.702949, 0.272326>, <72.078368, 26.757384, 0.272326>, <75.034170, 28.114640, 0.272326>, <75.928474, 29.852362, 0.272326>, 
      <70.125414, 26.637624, 0.114796>, <72.126912, 26.696224, 0.114796>, <75.064038, 28.050832, 0.114797>, <75.988653, 29.826931, 0.114797>, 
      <70.125414, 26.637624, 0.000000>, <72.126912, 26.696224, 0.000000>, <75.064038, 28.050832, 0.000000>, <75.988653, 29.826931, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.120653, 27.137600, 0.500000>, <71.958630, 27.182502, 0.500000>, <74.705882, 28.377139, 0.500000>, <75.528090, 30.021568, 0.500000>, 
      <70.121741, 27.022810, 0.500000>, <71.959725, 27.067712, 0.500000>, <74.811622, 28.332451, 0.500000>, <75.633837, 29.976880, 0.500000>, 
      <70.123245, 26.865286, 0.434673>, <72.076826, 26.919722, 0.434673>, <74.884634, 28.177840, 0.434672>, <75.778938, 29.915558, 0.434672>, 
      <70.124013, 26.784118, 0.353500>, <72.077600, 26.838552, 0.353500>, <74.959405, 28.146240, 0.353500>, <75.853709, 29.883962, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <70.120653, 27.137600, 0.500000>, <70.119558, 27.252390, 0.500000>, <70.118054, 27.409914, 0.434673>, <70.117286, 27.491082, 0.353500>, 
      <71.958630, 27.182502, 0.500000>, <71.957542, 27.297296, 0.500000>, <71.840467, 27.446029, 0.434673>, <71.839699, 27.527200, 0.353500>, 
      <74.705882, 28.377139, 0.500000>, <74.600134, 28.421824, 0.500000>, <74.525562, 28.577424, 0.434673>, <74.450790, 28.609021, 0.353500>, 
      <75.528090, 30.021568, 0.500000>, <75.422349, 30.066256, 0.500000>, <75.277242, 30.127578, 0.434673>, <75.202477, 30.159174, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.011758, 29.082717, 0.000000>, <32.934883, 29.750922, 0.000000>, <54.181779, 27.326483, 0.000000>, <70.115885, 27.637581, 0.000000>, 
      <17.011758, 29.082717, 0.114797>, <32.934883, 29.750922, 0.114797>, <54.181779, 27.326483, 0.114797>, <70.115885, 27.637581, 0.114797>, 
      <17.025952, 29.018947, 0.272327>, <32.940806, 29.666934, 0.272327>, <54.191968, 27.238352, 0.272327>, <70.116506, 27.572253, 0.272327>, 
      <17.043582, 28.939712, 0.353500>, <32.958438, 29.587699, 0.353500>, <54.192742, 27.157181, 0.353500>, <70.117286, 27.491082, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.043582, 28.939712, -0.353500>, <32.958438, 29.587699, -0.353500>, <54.192742, 27.157181, -0.353500>, <70.117286, 27.491082, -0.353500>, 
      <17.025952, 29.018947, -0.272327>, <32.940806, 29.666934, -0.272327>, <54.191968, 27.238352, -0.272327>, <70.116506, 27.572253, -0.272327>, 
      <17.011758, 29.082717, -0.114797>, <32.934883, 29.750922, -0.114797>, <54.181779, 27.326483, -0.114797>, <70.115885, 27.637581, -0.114797>, 
      <17.011758, 29.082717, 0.000000>, <32.934883, 29.750922, 0.000000>, <54.181779, 27.326483, 0.000000>, <70.115885, 27.637581, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.120370, 28.594653, -0.500000>, <33.015184, 29.193587, -0.500000>, <54.219302, 26.749126, -0.500000>, <70.120653, 27.137600, -0.500000>, 
      <17.095434, 28.706707, -0.500000>, <32.990250, 29.305642, -0.500000>, <54.218214, 26.863917, -0.500000>, <70.119558, 27.252390, -0.500000>, 
      <17.061216, 28.860477, -0.434673>, <32.976074, 29.508464, -0.434673>, <54.193517, 27.076013, -0.434673>, <70.118054, 27.409914, -0.434673>, 
      <17.043582, 28.939712, -0.353500>, <32.958438, 29.587699, -0.353500>, <54.192742, 27.157181, -0.353500>, <70.117286, 27.491082, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.197150, 28.249594, -0.353500>, <33.071786, 28.799107, -0.353500>, <54.246035, 26.341706, -0.353500>, <70.124013, 26.784118, -0.353500>, 
      <17.179520, 28.328829, -0.434673>, <33.054154, 28.878342, -0.434673>, <54.245261, 26.422875, -0.434673>, <70.123245, 26.865286, -0.434673>, 
      <17.145304, 28.482598, -0.500000>, <33.040115, 29.081533, -0.500000>, <54.220397, 26.634336, -0.500000>, <70.121741, 27.022810, -0.500000>, 
      <17.120370, 28.594653, -0.500000>, <33.015184, 29.193587, -0.500000>, <54.219302, 26.749126, -0.500000>, <70.120653, 27.137600, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.228976, 28.106592, 0.000000>, <33.095210, 28.635514, 0.000000>, <54.257165, 26.173040, 0.000000>, <70.125414, 26.637624, 0.000000>, 
      <17.228976, 28.106592, -0.114796>, <33.095210, 28.635514, -0.114796>, <54.257165, 26.173040, -0.114796>, <70.125414, 26.637624, -0.114796>, 
      <17.214782, 28.170358, -0.272327>, <33.089418, 28.719872, -0.272327>, <54.246803, 26.260536, -0.272326>, <70.124787, 26.702949, -0.272326>, 
      <17.197150, 28.249594, -0.353500>, <33.071786, 28.799107, -0.353500>, <54.246035, 26.341706, -0.353500>, <70.124013, 26.784118, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.197150, 28.249594, 0.353500>, <33.071786, 28.799107, 0.353500>, <54.246035, 26.341706, 0.353500>, <70.124013, 26.784118, 0.353500>, 
      <17.214782, 28.170358, 0.272327>, <33.089418, 28.719872, 0.272327>, <54.246803, 26.260536, 0.272326>, <70.124787, 26.702949, 0.272326>, 
      <17.228976, 28.106592, 0.114796>, <33.095210, 28.635514, 0.114796>, <54.257165, 26.173040, 0.114796>, <70.125414, 26.637624, 0.114796>, 
      <17.228976, 28.106592, 0.000000>, <33.095210, 28.635514, 0.000000>, <54.257165, 26.173040, 0.000000>, <70.125414, 26.637624, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.120370, 28.594653, 0.500000>, <33.015184, 29.193587, 0.500000>, <54.219302, 26.749126, 0.500000>, <70.120653, 27.137600, 0.500000>, 
      <17.145304, 28.482598, 0.500000>, <33.040115, 29.081533, 0.500000>, <54.220397, 26.634336, 0.500000>, <70.121741, 27.022810, 0.500000>, 
      <17.179520, 28.328829, 0.434673>, <33.054154, 28.878342, 0.434673>, <54.245261, 26.422875, 0.434673>, <70.123245, 26.865286, 0.434673>, 
      <17.197150, 28.249594, 0.353500>, <33.071786, 28.799107, 0.353500>, <54.246035, 26.341706, 0.353500>, <70.124013, 26.784118, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <17.120370, 28.594653, 0.500000>, <17.095434, 28.706707, 0.500000>, <17.061216, 28.860477, 0.434673>, <17.043582, 28.939712, 0.353500>, 
      <33.015184, 29.193587, 0.500000>, <32.990250, 29.305642, 0.500000>, <32.976074, 29.508464, 0.434673>, <32.958438, 29.587699, 0.353500>, 
      <54.219302, 26.749126, 0.500000>, <54.218214, 26.863917, 0.500000>, <54.193517, 27.076013, 0.434673>, <54.192742, 27.157181, 0.353500>, 
      <70.120653, 27.137600, 0.500000>, <70.119558, 27.252390, 0.500000>, <70.118054, 27.409914, 0.434673>, <70.117286, 27.491082, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.832446, 24.981917, 0.000000>, <8.990880, 27.467939, 0.000000>, <13.722368, 28.944678, 0.000000>, <17.011758, 29.082717, 0.000000>, 
      <6.832446, 24.981917, 0.114796>, <8.990880, 27.467939, 0.114796>, <13.722368, 28.944678, 0.114797>, <17.011758, 29.082717, 0.114797>, 
      <6.891608, 24.954216, 0.272327>, <9.036042, 27.403210, 0.272327>, <13.773472, 28.886522, 0.272327>, <17.025952, 29.018947, 0.272327>, 
      <6.965122, 24.919794, 0.353500>, <9.109554, 27.368787, 0.353500>, <13.791104, 28.807286, 0.353500>, <17.043582, 28.939712, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.965122, 24.919794, -0.353500>, <9.109554, 27.368787, -0.353500>, <13.791104, 28.807286, -0.353500>, <17.043582, 28.939712, -0.353500>, 
      <6.891608, 24.954216, -0.272327>, <9.036042, 27.403210, -0.272327>, <13.773472, 28.886522, -0.272327>, <17.025952, 29.018947, -0.272327>, 
      <6.832446, 24.981917, -0.114796>, <8.990880, 27.467939, -0.114796>, <13.722368, 28.944678, -0.114797>, <17.011758, 29.082717, -0.114797>, 
      <6.832446, 24.981917, 0.000000>, <8.990880, 27.467939, 0.000000>, <13.722368, 28.944678, 0.000000>, <17.011758, 29.082717, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.285264, 24.769890, -0.500000>, <9.396198, 27.129168, -0.500000>, <13.956824, 28.475446, -0.500000>, <17.120370, 28.594653, -0.500000>, 
      <7.181300, 24.818570, -0.500000>, <9.292234, 27.177846, -0.500000>, <13.931888, 28.587501, -0.500000>, <17.095434, 28.706707, -0.500000>, 
      <7.038635, 24.885373, -0.434673>, <9.183067, 27.334365, -0.434673>, <13.808738, 28.728051, -0.434673>, <17.061216, 28.860477, -0.434673>, 
      <6.965122, 24.919794, -0.353500>, <9.109554, 27.368787, -0.353500>, <13.791104, 28.807286, -0.353500>, <17.043582, 28.939712, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.605406, 24.619986, -0.353500>, <9.683275, 26.888966, -0.353500>, <14.122338, 28.143155, -0.353500>, <17.197150, 28.249594, -0.353500>, 
      <7.531892, 24.654408, -0.434673>, <9.609762, 26.923389, -0.434673>, <14.104706, 28.222390, -0.434673>, <17.179520, 28.328829, -0.434673>, 
      <7.389227, 24.721211, -0.500000>, <9.500160, 27.080490, -0.500000>, <13.981758, 28.363392, -0.500000>, <17.145304, 28.482598, -0.500000>, 
      <7.285264, 24.769890, -0.500000>, <9.396198, 27.129168, -0.500000>, <13.956824, 28.475446, -0.500000>, <17.120370, 28.594653, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.738082, 24.557864, 0.000000>, <9.802386, 26.789230, 0.000000>, <14.190869, 28.005315, 0.000000>, <17.228976, 28.106592, 0.000000>, 
      <7.738082, 24.557864, -0.114796>, <9.802386, 26.789230, -0.114796>, <14.190869, 28.005315, -0.114796>, <17.228976, 28.106592, -0.114796>, 
      <7.678919, 24.585563, -0.272327>, <9.756788, 26.854544, -0.272327>, <14.139970, 28.063920, -0.272327>, <17.214782, 28.170358, -0.272327>, 
      <7.605406, 24.619986, -0.353500>, <9.683275, 26.888966, -0.353500>, <14.122338, 28.143155, -0.353500>, <17.197150, 28.249594, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.605406, 24.619986, 0.353500>, <9.683275, 26.888966, 0.353500>, <14.122338, 28.143155, 0.353500>, <17.197150, 28.249594, 0.353500>, 
      <7.678919, 24.585563, 0.272327>, <9.756788, 26.854544, 0.272327>, <14.139970, 28.063920, 0.272327>, <17.214782, 28.170358, 0.272327>, 
      <7.738082, 24.557864, 0.114796>, <9.802386, 26.789230, 0.114796>, <14.190869, 28.005315, 0.114796>, <17.228976, 28.106592, 0.114796>, 
      <7.738082, 24.557864, 0.000000>, <9.802386, 26.789230, 0.000000>, <14.190869, 28.005315, 0.000000>, <17.228976, 28.106592, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.285264, 24.769890, 0.500000>, <9.396198, 27.129168, 0.500000>, <13.956824, 28.475446, 0.500000>, <17.120370, 28.594653, 0.500000>, 
      <7.389227, 24.721211, 0.500000>, <9.500160, 27.080490, 0.500000>, <13.981758, 28.363392, 0.500000>, <17.145304, 28.482598, 0.500000>, 
      <7.531892, 24.654408, 0.434673>, <9.609762, 26.923389, 0.434673>, <14.104706, 28.222390, 0.434673>, <17.179520, 28.328829, 0.434673>, 
      <7.605406, 24.619986, 0.353500>, <9.683275, 26.888966, 0.353500>, <14.122338, 28.143155, 0.353500>, <17.197150, 28.249594, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.285264, 24.769890, 0.500000>, <7.181300, 24.818570, 0.500000>, <7.038635, 24.885373, 0.434673>, <6.965122, 24.919794, 0.353500>, 
      <9.396198, 27.129168, 0.500000>, <9.292234, 27.177846, 0.500000>, <9.183067, 27.334365, 0.434673>, <9.109554, 27.368787, 0.353500>, 
      <13.956824, 28.475446, 0.500000>, <13.931888, 28.587501, 0.500000>, <13.808738, 28.728051, 0.434673>, <13.791104, 28.807286, 0.353500>, 
      <17.120370, 28.594653, 0.500000>, <17.095434, 28.706707, 0.500000>, <17.061216, 28.860477, 0.434673>, <17.043582, 28.939712, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.382960, 17.992542, 0.000000>, <6.596044, 19.943096, 0.000000>, <5.453510, 23.393698, 0.000000>, <6.832446, 24.981917, 0.000000>, 
      <7.382960, 17.992542, 0.114796>, <6.596044, 19.943096, 0.114796>, <5.453510, 23.393698, 0.114796>, <6.832446, 24.981917, 0.114796>, 
      <7.441584, 18.021366, 0.272327>, <6.663132, 19.934416, 0.272327>, <5.530992, 23.400358, 0.272327>, <6.891608, 24.954216, 0.272327>, 
      <7.514428, 18.057182, 0.353500>, <6.735976, 19.970232, 0.353500>, <5.604506, 23.365936, 0.353500>, <6.965122, 24.919794, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.514428, 18.057182, -0.353500>, <6.735976, 19.970232, -0.353500>, <5.604506, 23.365936, -0.353500>, <6.965122, 24.919794, -0.353500>, 
      <7.441584, 18.021366, -0.272327>, <6.663132, 19.934416, -0.272327>, <5.530992, 23.400358, -0.272327>, <6.891608, 24.954216, -0.272327>, 
      <7.382960, 17.992542, -0.114796>, <6.596044, 19.943096, -0.114796>, <5.453510, 23.393698, -0.114796>, <6.832446, 24.981917, -0.114796>, 
      <7.382960, 17.992542, 0.000000>, <6.596044, 19.943096, 0.000000>, <5.453510, 23.393698, 0.000000>, <6.832446, 24.981917, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.831658, 18.213154, -0.500000>, <7.074170, 20.035858, -0.500000>, <5.969118, 23.298904, -0.500000>, <7.285264, 24.769890, -0.500000>, 
      <7.728640, 18.162504, -0.500000>, <6.971152, 19.985208, -0.500000>, <5.865154, 23.347584, -0.500000>, <7.181300, 24.818570, -0.500000>, 
      <7.587273, 18.092998, -0.434673>, <6.808821, 20.006048, -0.434673>, <5.678020, 23.331514, -0.434673>, <7.038635, 24.885373, -0.434673>, 
      <7.514428, 18.057182, -0.353500>, <6.735976, 19.970232, -0.353500>, <5.604506, 23.365936, -0.353500>, <6.965122, 24.919794, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.148889, 18.369125, -0.353500>, <7.413162, 20.101718, -0.353500>, <6.334142, 23.231798, -0.353500>, <7.605406, 24.619986, -0.353500>, 
      <8.076044, 18.333309, -0.434673>, <7.340318, 20.065902, -0.434673>, <6.260628, 23.266221, -0.434673>, <7.531892, 24.654408, -0.434673>, 
      <7.934677, 18.263803, -0.500000>, <7.177189, 20.086507, -0.500000>, <6.073082, 23.250226, -0.500000>, <7.389227, 24.721211, -0.500000>, 
      <7.831658, 18.213154, -0.500000>, <7.074170, 20.035858, -0.500000>, <5.969118, 23.298904, -0.500000>, <7.285264, 24.769890, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.280357, 18.433765, 0.000000>, <7.553893, 20.129091, 0.000000>, <6.485550, 23.203965, 0.000000>, <7.738082, 24.557864, 0.000000>, 
      <8.280357, 18.433765, -0.114796>, <7.553893, 20.129091, -0.114796>, <6.485550, 23.203965, -0.114796>, <7.738082, 24.557864, -0.114796>, 
      <8.221733, 18.404941, -0.272327>, <7.486006, 20.137534, -0.272327>, <6.407655, 23.197376, -0.272327>, <7.678919, 24.585563, -0.272327>, 
      <8.148889, 18.369125, -0.353500>, <7.413162, 20.101718, -0.353500>, <6.334142, 23.231798, -0.353500>, <7.605406, 24.619986, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <8.148889, 18.369125, 0.353500>, <7.413162, 20.101718, 0.353500>, <6.334142, 23.231798, 0.353500>, <7.605406, 24.619986, 0.353500>, 
      <8.221733, 18.404941, 0.272327>, <7.486006, 20.137534, 0.272327>, <6.407655, 23.197376, 0.272327>, <7.678919, 24.585563, 0.272327>, 
      <8.280357, 18.433765, 0.114796>, <7.553893, 20.129091, 0.114796>, <6.485550, 23.203965, 0.114796>, <7.738082, 24.557864, 0.114796>, 
      <8.280357, 18.433765, 0.000000>, <7.553893, 20.129091, 0.000000>, <6.485550, 23.203965, 0.000000>, <7.738082, 24.557864, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.831658, 18.213154, 0.500000>, <7.074170, 20.035858, 0.500000>, <5.969118, 23.298904, 0.500000>, <7.285264, 24.769890, 0.500000>, 
      <7.934677, 18.263803, 0.500000>, <7.177189, 20.086507, 0.500000>, <6.073082, 23.250226, 0.500000>, <7.389227, 24.721211, 0.500000>, 
      <8.076044, 18.333309, 0.434673>, <7.340318, 20.065902, 0.434673>, <6.260628, 23.266221, 0.434673>, <7.531892, 24.654408, 0.434673>, 
      <8.148889, 18.369125, 0.353500>, <7.413162, 20.101718, 0.353500>, <6.334142, 23.231798, 0.353500>, <7.605406, 24.619986, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.831658, 18.213154, 0.500000>, <7.728640, 18.162504, 0.500000>, <7.587273, 18.092998, 0.434673>, <7.514428, 18.057182, 0.353500>, 
      <7.074170, 20.035858, 0.500000>, <6.971152, 19.985208, 0.500000>, <6.808821, 20.006048, 0.434673>, <6.735976, 19.970232, 0.353500>, 
      <5.969118, 23.298904, 0.500000>, <5.865154, 23.347584, 0.500000>, <5.678020, 23.331514, 0.434673>, <5.604506, 23.365936, 0.353500>, 
      <7.285264, 24.769890, 0.500000>, <7.181300, 24.818570, 0.500000>, <7.038635, 24.885373, 0.434673>, <6.965122, 24.919794, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <12.664775, 10.525151, 0.000000>, <11.400194, 12.960349, 0.000000>, <8.409570, 15.447856, 0.000000>, <7.382960, 17.992542, 0.000000>, 
      <12.664775, 10.525151, 0.114796>, <11.400194, 12.960349, 0.114796>, <8.409570, 15.447856, 0.114796>, <7.382960, 17.992542, 0.114796>, 
      <12.723398, 10.553975, 0.272327>, <11.474138, 12.997069, 0.272327>, <8.475804, 15.479763, 0.272327>, <7.441584, 18.021366, 0.272327>, 
      <12.796242, 10.589790, 0.353500>, <11.546982, 13.032884, 0.353500>, <8.548649, 15.515581, 0.353500>, <7.514428, 18.057182, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <12.796242, 10.589790, -0.353500>, <11.546982, 13.032884, -0.353500>, <8.548649, 15.515581, -0.353500>, <7.514428, 18.057182, -0.353500>, 
      <12.723398, 10.553975, -0.272327>, <11.474138, 12.997069, -0.272327>, <8.475804, 15.479763, -0.272327>, <7.441584, 18.021366, -0.272327>, 
      <12.664775, 10.525151, -0.114796>, <11.400194, 12.960349, -0.114796>, <8.409570, 15.447856, -0.114796>, <7.382960, 17.992542, -0.114796>, 
      <12.664775, 10.525151, 0.000000>, <11.400194, 12.960349, 0.000000>, <8.409570, 15.447856, 0.000000>, <7.382960, 17.992542, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.113473, 10.745762, -0.500000>, <11.900219, 13.206934, -0.500000>, <8.884693, 15.679290, -0.500000>, <7.831658, 18.213154, -0.500000>, 
      <13.010455, 10.695111, -0.500000>, <11.797201, 13.156283, -0.500000>, <8.781675, 15.628640, -0.500000>, <7.728640, 18.162504, -0.500000>, 
      <12.869087, 10.625606, -0.434673>, <11.619827, 13.068699, -0.434673>, <8.621494, 15.551397, -0.434673>, <7.587273, 18.092998, -0.434673>, 
      <12.796242, 10.589790, -0.353500>, <11.546982, 13.032884, -0.353500>, <8.548649, 15.515581, -0.353500>, <7.514428, 18.057182, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.430702, 10.901734, -0.353500>, <12.252130, 13.379701, -0.353500>, <9.221392, 15.843438, -0.353500>, <8.148889, 18.369125, -0.353500>, 
      <13.357858, 10.865918, -0.434673>, <12.179285, 13.343886, -0.434673>, <9.148547, 15.807622, -0.434673>, <8.076044, 18.333309, -0.434673>, 
      <13.216490, 10.796413, -0.500000>, <12.003237, 13.257585, -0.500000>, <8.987711, 15.729939, -0.500000>, <7.934677, 18.263803, -0.500000>, 
      <13.113473, 10.745762, -0.500000>, <11.900219, 13.206934, -0.500000>, <8.884693, 15.679290, -0.500000>, <7.831658, 18.213154, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.562171, 10.966373, 0.000000>, <12.397593, 13.450947, 0.000000>, <9.361127, 15.911606, 0.000000>, <8.280357, 18.433765, 0.000000>, 
      <13.562171, 10.966373, -0.114796>, <12.397593, 13.450947, -0.114796>, <9.361127, 15.911606, -0.114796>, <8.280357, 18.433765, -0.114796>, 
      <13.503547, 10.937549, -0.272327>, <12.324974, 13.415516, -0.272327>, <9.294236, 15.879256, -0.272327>, <8.221733, 18.404941, -0.272327>, 
      <13.430702, 10.901734, -0.353500>, <12.252130, 13.379701, -0.353500>, <9.221392, 15.843438, -0.353500>, <8.148889, 18.369125, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.430702, 10.901734, 0.353500>, <12.252130, 13.379701, 0.353500>, <9.221392, 15.843438, 0.353500>, <8.148889, 18.369125, 0.353500>, 
      <13.503547, 10.937549, 0.272327>, <12.324974, 13.415516, 0.272327>, <9.294236, 15.879256, 0.272327>, <8.221733, 18.404941, 0.272327>, 
      <13.562171, 10.966373, 0.114796>, <12.397593, 13.450947, 0.114796>, <9.361127, 15.911606, 0.114796>, <8.280357, 18.433765, 0.114796>, 
      <13.562171, 10.966373, 0.000000>, <12.397593, 13.450947, 0.000000>, <9.361127, 15.911606, 0.000000>, <8.280357, 18.433765, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.113473, 10.745762, 0.500000>, <11.900219, 13.206934, 0.500000>, <8.884693, 15.679290, 0.500000>, <7.831658, 18.213154, 0.500000>, 
      <13.216490, 10.796413, 0.500000>, <12.003237, 13.257585, 0.500000>, <8.987711, 15.729939, 0.500000>, <7.934677, 18.263803, 0.500000>, 
      <13.357858, 10.865918, 0.434673>, <12.179285, 13.343886, 0.434673>, <9.148547, 15.807622, 0.434673>, <8.076044, 18.333309, 0.434673>, 
      <13.430702, 10.901734, 0.353500>, <12.252130, 13.379701, 0.353500>, <9.221392, 15.843438, 0.353500>, <8.148889, 18.369125, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.113473, 10.745762, 0.500000>, <13.010455, 10.695111, 0.500000>, <12.869087, 10.625606, 0.434673>, <12.796242, 10.589790, 0.353500>, 
      <11.900219, 13.206934, 0.500000>, <11.797201, 13.156283, 0.500000>, <11.619827, 13.068699, 0.434673>, <11.546982, 13.032884, 0.353500>, 
      <8.884693, 15.679290, 0.500000>, <8.781675, 15.628640, 0.500000>, <8.621494, 15.551397, 0.434673>, <8.548649, 15.515581, 0.353500>, 
      <7.831658, 18.213154, 0.500000>, <7.728640, 18.162504, 0.500000>, <7.587273, 18.092998, 0.434673>, <7.514428, 18.057182, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.819192, 5.598322, 0.000000>, <14.232560, 7.059039, 0.000000>, <13.364396, 9.177894, 0.000000>, <12.664775, 10.525151, 0.000000>, 
      <13.819192, 5.598322, 0.114796>, <14.232560, 7.059039, 0.114796>, <13.364396, 9.177894, 0.114796>, <12.664775, 10.525151, 0.114796>, 
      <13.869765, 5.556969, 0.272327>, <14.314134, 7.055360, 0.272327>, <13.434946, 9.162450, 0.272327>, <12.723398, 10.553975, 0.272327>, 
      <13.932603, 5.505585, 0.353500>, <14.376973, 7.003977, 0.353500>, <13.507790, 9.198265, 0.353500>, <12.796242, 10.589790, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.932603, 5.505585, -0.353500>, <14.376973, 7.003977, -0.353500>, <13.507790, 9.198265, -0.353500>, <12.796242, 10.589790, -0.353500>, 
      <13.869765, 5.556969, -0.272327>, <14.314134, 7.055360, -0.272327>, <13.434946, 9.162450, -0.272327>, <12.723398, 10.553975, -0.272327>, 
      <13.819192, 5.598322, -0.114796>, <14.232560, 7.059039, -0.114796>, <13.364396, 9.177894, -0.114796>, <12.664775, 10.525151, -0.114796>, 
      <13.819192, 5.598322, 0.000000>, <14.232560, 7.059039, 0.000000>, <13.364396, 9.177894, 0.000000>, <12.664775, 10.525151, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.206262, 5.281815, -0.500000>, <14.725709, 6.870707, -0.500000>, <13.852597, 9.246396, -0.500000>, <13.113473, 10.745762, -0.500000>, 
      <14.117394, 5.354483, -0.500000>, <14.636838, 6.943375, -0.500000>, <13.749579, 9.195746, -0.500000>, <13.010455, 10.695111, -0.500000>, 
      <13.995443, 5.454201, -0.434673>, <14.439813, 6.952593, -0.434673>, <13.580634, 9.234080, -0.434673>, <12.869087, 10.625606, -0.434673>, 
      <13.932603, 5.505585, -0.353500>, <14.376973, 7.003977, -0.353500>, <13.507790, 9.198265, -0.353500>, <12.796242, 10.589790, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.479922, 5.058045, -0.353500>, <15.074741, 6.736929, -0.353500>, <14.195728, 9.293257, -0.353500>, <13.430702, 10.901734, -0.353500>, 
      <14.417082, 5.109429, -0.434673>, <15.011902, 6.788312, -0.434673>, <14.122883, 9.257442, -0.434673>, <13.357858, 10.865918, -0.434673>, 
      <14.295131, 5.209148, -0.500000>, <14.814576, 6.798040, -0.500000>, <13.955614, 9.297046, -0.500000>, <13.216490, 10.796413, -0.500000>, 
      <14.206262, 5.281815, -0.500000>, <14.725709, 6.870707, -0.500000>, <13.852597, 9.246396, -0.500000>, <13.113473, 10.745762, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.593333, 4.965310, 0.000000>, <15.219458, 6.681356, 0.000000>, <14.337450, 9.312350, 0.000000>, <13.562171, 10.966373, 0.000000>, 
      <14.593333, 4.965310, -0.114796>, <15.219458, 6.681356, -0.114796>, <14.337450, 9.312350, -0.114796>, <13.562171, 10.966373, -0.114796>, 
      <14.542762, 5.006662, -0.272327>, <15.137581, 6.685545, -0.272327>, <14.268573, 9.329072, -0.272327>, <13.503547, 10.937549, -0.272327>, 
      <14.479922, 5.058045, -0.353500>, <15.074741, 6.736929, -0.353500>, <14.195728, 9.293257, -0.353500>, <13.430702, 10.901734, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.479922, 5.058045, 0.353500>, <15.074741, 6.736929, 0.353500>, <14.195728, 9.293257, 0.353500>, <13.430702, 10.901734, 0.353500>, 
      <14.542762, 5.006662, 0.272327>, <15.137581, 6.685545, 0.272327>, <14.268573, 9.329072, 0.272327>, <13.503547, 10.937549, 0.272327>, 
      <14.593333, 4.965310, 0.114796>, <15.219458, 6.681356, 0.114796>, <14.337450, 9.312350, 0.114796>, <13.562171, 10.966373, 0.114796>, 
      <14.593333, 4.965310, 0.000000>, <15.219458, 6.681356, 0.000000>, <14.337450, 9.312350, 0.000000>, <13.562171, 10.966373, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.206262, 5.281815, 0.500000>, <14.725709, 6.870707, 0.500000>, <13.852597, 9.246396, 0.500000>, <13.113473, 10.745762, 0.500000>, 
      <14.295131, 5.209148, 0.500000>, <14.814576, 6.798040, 0.500000>, <13.955614, 9.297046, 0.500000>, <13.216490, 10.796413, 0.500000>, 
      <14.417082, 5.109429, 0.434673>, <15.011902, 6.788312, 0.434673>, <14.122883, 9.257442, 0.434673>, <13.357858, 10.865918, 0.434673>, 
      <14.479922, 5.058045, 0.353500>, <15.074741, 6.736929, 0.353500>, <14.195728, 9.293257, 0.353500>, <13.430702, 10.901734, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.206262, 5.281815, 0.500000>, <14.117394, 5.354483, 0.500000>, <13.995443, 5.454201, 0.434673>, <13.932603, 5.505585, 0.353500>, 
      <14.725709, 6.870707, 0.500000>, <14.636838, 6.943375, 0.500000>, <14.439813, 6.952593, 0.434673>, <14.376973, 7.003977, 0.353500>, 
      <13.852597, 9.246396, 0.500000>, <13.749579, 9.195746, 0.500000>, <13.580634, 9.234080, 0.434673>, <13.507790, 9.198265, 0.353500>, 
      <13.113473, 10.745762, 0.500000>, <13.010455, 10.695111, 0.500000>, <12.869087, 10.625606, 0.434673>, <12.796242, 10.589790, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.180770, 1.747422, 0.000000>, <11.738937, 2.060783, 0.000000>, <13.386414, 4.069014, 0.000000>, <13.819192, 5.598322, 0.000000>, 
      <10.180770, 1.747422, 0.114796>, <11.738937, 2.060783, 0.114796>, <13.386414, 4.069014, 0.114796>, <13.819192, 5.598322, 0.114796>, 
      <10.159404, 1.685688, 0.272327>, <11.763048, 1.992725, 0.272327>, <13.405527, 3.991583, 0.272327>, <13.869765, 5.556969, 0.272327>, 
      <10.132854, 1.608980, 0.353500>, <11.736499, 1.916016, 0.353500>, <13.468366, 3.940200, 0.353500>, <13.932603, 5.505585, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.132854, 1.608980, -0.353500>, <11.736499, 1.916016, -0.353500>, <13.468366, 3.940200, -0.353500>, <13.932603, 5.505585, -0.353500>, 
      <10.159404, 1.685688, -0.272327>, <11.763048, 1.992725, -0.272327>, <13.405527, 3.991583, -0.272327>, <13.869765, 5.556969, -0.272327>, 
      <10.180770, 1.747422, -0.114796>, <11.738937, 2.060783, -0.114796>, <13.386414, 4.069014, -0.114796>, <13.819192, 5.598322, -0.114796>, 
      <10.180770, 1.747422, 0.000000>, <11.738937, 2.060783, 0.000000>, <13.386414, 4.069014, 0.000000>, <13.819192, 5.598322, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.017236, 1.274921, -0.500000>, <11.731478, 1.567596, -0.500000>, <13.665872, 3.628859, -0.500000>, <14.206262, 5.281815, -0.500000>, 
      <10.054782, 1.383404, -0.500000>, <11.769024, 1.676079, -0.500000>, <13.577003, 3.701527, -0.500000>, <14.117394, 5.354483, -0.500000>, 
      <10.106305, 1.532271, -0.434673>, <11.709950, 1.839307, -0.434673>, <13.531206, 3.888816, -0.434673>, <13.995443, 5.454201, -0.434673>, 
      <10.132854, 1.608980, -0.353500>, <11.736499, 1.916016, -0.353500>, <13.468366, 3.940200, -0.353500>, <13.932603, 5.505585, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.901617, 0.940864, -0.353500>, <11.727557, 1.220198, -0.353500>, <13.863046, 3.316911, -0.353500>, <14.479922, 5.058045, -0.353500>, 
      <9.928166, 1.017572, -0.434673>, <11.754106, 1.296906, -0.434673>, <13.800206, 3.368294, -0.434673>, <14.417082, 5.109429, -0.434673>, 
      <9.979690, 1.166439, -0.500000>, <11.693931, 1.459114, -0.500000>, <13.754741, 3.556192, -0.500000>, <14.295131, 5.209148, -0.500000>, 
      <10.017236, 1.274921, -0.500000>, <11.731478, 1.567596, -0.500000>, <13.665872, 3.628859, -0.500000>, <14.206262, 5.281815, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.853702, 0.802421, 0.000000>, <11.726224, 1.076466, 0.000000>, <13.944667, 3.187483, 0.000000>, <14.593333, 4.965310, 0.000000>, 
      <9.853702, 0.802421, -0.114796>, <11.726224, 1.076466, -0.114796>, <13.944667, 3.187483, -0.114796>, <14.593333, 4.965310, -0.114796>, 
      <9.875068, 0.864155, -0.272327>, <11.701008, 1.143489, -0.272327>, <13.925885, 3.265527, -0.272327>, <14.542762, 5.006662, -0.272327>, 
      <9.901617, 0.940864, -0.353500>, <11.727557, 1.220198, -0.353500>, <13.863046, 3.316911, -0.353500>, <14.479922, 5.058045, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.901617, 0.940864, 0.353500>, <11.727557, 1.220198, 0.353500>, <13.863046, 3.316911, 0.353500>, <14.479922, 5.058045, 0.353500>, 
      <9.875068, 0.864155, 0.272327>, <11.701008, 1.143489, 0.272327>, <13.925885, 3.265527, 0.272327>, <14.542762, 5.006662, 0.272327>, 
      <9.853702, 0.802421, 0.114796>, <11.726224, 1.076466, 0.114796>, <13.944667, 3.187483, 0.114796>, <14.593333, 4.965310, 0.114796>, 
      <9.853702, 0.802421, 0.000000>, <11.726224, 1.076466, 0.000000>, <13.944667, 3.187483, 0.000000>, <14.593333, 4.965310, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.017236, 1.274921, 0.500000>, <11.731478, 1.567596, 0.500000>, <13.665872, 3.628859, 0.500000>, <14.206262, 5.281815, 0.500000>, 
      <9.979690, 1.166439, 0.500000>, <11.693931, 1.459114, 0.500000>, <13.754741, 3.556192, 0.500000>, <14.295131, 5.209148, 0.500000>, 
      <9.928166, 1.017572, 0.434673>, <11.754106, 1.296906, 0.434673>, <13.800206, 3.368294, 0.434673>, <14.417082, 5.109429, 0.434673>, 
      <9.901617, 0.940864, 0.353500>, <11.727557, 1.220198, 0.353500>, <13.863046, 3.316911, 0.353500>, <14.479922, 5.058045, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.017236, 1.274921, 0.500000>, <10.054782, 1.383404, 0.500000>, <10.106305, 1.532271, 0.434673>, <10.132854, 1.608980, 0.353500>, 
      <11.731478, 1.567596, 0.500000>, <11.769024, 1.676079, 0.500000>, <11.709950, 1.839307, 0.434673>, <11.736499, 1.916016, 0.353500>, 
      <13.665872, 3.628859, 0.500000>, <13.577003, 3.701527, 0.500000>, <13.531206, 3.888816, 0.434673>, <13.468366, 3.940200, 0.353500>, 
      <14.206262, 5.281815, 0.500000>, <14.117394, 5.354483, 0.500000>, <13.995443, 5.454201, 0.434673>, <13.932603, 5.505585, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.169481, 4.261005, 0.000000>, <8.021181, 3.449005, 0.000000>, <9.027120, 1.515412, 0.000000>, <10.180770, 1.747422, 0.000000>, 
      <7.169481, 4.261005, 0.114796>, <8.021181, 3.449005, 0.114796>, <9.027120, 1.515412, 0.114796>, <10.180770, 1.747422, 0.114796>, 
      <7.113220, 4.227805, 0.272327>, <7.984602, 3.392510, 0.272327>, <8.973866, 1.458703, 0.272327>, <10.159404, 1.685688, 0.272327>, 
      <7.043311, 4.186551, 0.353500>, <7.914693, 3.351255, 0.353500>, <8.947316, 1.381995, 0.353500>, <10.132854, 1.608980, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.043311, 4.186551, -0.353500>, <7.914693, 3.351255, -0.353500>, <8.947316, 1.381995, -0.353500>, <10.132854, 1.608980, -0.353500>, 
      <7.113220, 4.227805, -0.272327>, <7.984602, 3.392510, -0.272327>, <8.973866, 1.458703, -0.272327>, <10.159404, 1.685688, -0.272327>, 
      <7.169481, 4.261005, -0.114796>, <8.021181, 3.449005, -0.114796>, <9.027120, 1.515412, -0.114796>, <10.180770, 1.747422, -0.114796>, 
      <7.169481, 4.261005, 0.000000>, <8.021181, 3.449005, 0.000000>, <9.027120, 1.515412, 0.000000>, <10.180770, 1.747422, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.738868, 4.006894, -0.500000>, <7.657160, 3.114839, -0.500000>, <8.755253, 1.059461, -0.500000>, <10.017236, 1.274921, -0.500000>, 
      <6.837734, 4.065236, -0.500000>, <7.756026, 3.173181, -0.500000>, <8.792799, 1.167944, -0.500000>, <10.054782, 1.383404, -0.500000>, 
      <6.973403, 4.145296, -0.434673>, <7.844784, 3.310001, -0.434673>, <8.920767, 1.305286, -0.434673>, <10.106305, 1.532271, -0.434673>, 
      <7.043311, 4.186551, -0.353500>, <7.914693, 3.351255, -0.353500>, <8.947316, 1.381995, -0.353500>, <10.132854, 1.608980, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.434424, 3.827238, -0.353500>, <7.398782, 2.877634, -0.353500>, <8.563766, 0.736198, -0.353500>, <9.901617, 0.940864, -0.353500>, 
      <6.504333, 3.868492, -0.434673>, <7.468690, 2.918888, -0.434673>, <8.590316, 0.812907, -0.434673>, <9.928166, 1.017572, -0.434673>, 
      <6.640002, 3.948552, -0.500000>, <7.558294, 3.056497, -0.500000>, <8.717706, 0.950978, -0.500000>, <9.979690, 1.166439, -0.500000>, 
      <6.738868, 4.006894, -0.500000>, <7.657160, 3.114839, -0.500000>, <8.755253, 1.059461, -0.500000>, <10.017236, 1.274921, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.308255, 3.752784, 0.000000>, <7.291446, 2.779095, 0.000000>, <8.484548, 0.602045, 0.000000>, <9.853702, 0.802421, 0.000000>, 
      <6.308255, 3.752784, -0.114796>, <7.291446, 2.779095, -0.114796>, <8.484548, 0.602045, -0.114796>, <9.853702, 0.802421, -0.114796>, 
      <6.364516, 3.785984, -0.272327>, <7.328873, 2.836380, -0.272327>, <8.537217, 0.659489, -0.272327>, <9.875068, 0.864155, -0.272327>, 
      <6.434424, 3.827238, -0.353500>, <7.398782, 2.877634, -0.353500>, <8.563766, 0.736198, -0.353500>, <9.901617, 0.940864, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.434424, 3.827238, 0.353500>, <7.398782, 2.877634, 0.353500>, <8.563766, 0.736198, 0.353500>, <9.901617, 0.940864, 0.353500>, 
      <6.364516, 3.785984, 0.272327>, <7.328873, 2.836380, 0.272327>, <8.537217, 0.659489, 0.272327>, <9.875068, 0.864155, 0.272327>, 
      <6.308255, 3.752784, 0.114796>, <7.291446, 2.779095, 0.114796>, <8.484548, 0.602045, 0.114796>, <9.853702, 0.802421, 0.114796>, 
      <6.308255, 3.752784, 0.000000>, <7.291446, 2.779095, 0.000000>, <8.484548, 0.602045, 0.000000>, <9.853702, 0.802421, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.738868, 4.006894, 0.500000>, <7.657160, 3.114839, 0.500000>, <8.755253, 1.059461, 0.500000>, <10.017236, 1.274921, 0.500000>, 
      <6.640002, 3.948552, 0.500000>, <7.558294, 3.056497, 0.500000>, <8.717706, 0.950978, 0.500000>, <9.979690, 1.166439, 0.500000>, 
      <6.504333, 3.868492, 0.434673>, <7.468690, 2.918888, 0.434673>, <8.590316, 0.812907, 0.434673>, <9.928166, 1.017572, 0.434673>, 
      <6.434424, 3.827238, 0.353500>, <7.398782, 2.877634, 0.353500>, <8.563766, 0.736198, 0.353500>, <9.901617, 0.940864, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.738868, 4.006894, 0.500000>, <6.837734, 4.065236, 0.500000>, <6.973403, 4.145296, 0.434673>, <7.043311, 4.186551, 0.353500>, 
      <7.657160, 3.114839, 0.500000>, <7.756026, 3.173181, 0.500000>, <7.844784, 3.310001, 0.434673>, <7.914693, 3.351255, 0.353500>, 
      <8.755253, 1.059461, 0.500000>, <8.792799, 1.167944, 0.500000>, <8.920767, 1.305286, 0.434673>, <8.947316, 1.381995, 0.353500>, 
      <10.017236, 1.274921, 0.500000>, <10.054782, 1.383404, 0.500000>, <10.106305, 1.532271, 0.434673>, <10.132854, 1.608980, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.656909, 7.967190, 0.000000>, <5.187015, 8.040892, 0.000000>, <6.060746, 5.318059, 0.000000>, <7.169481, 4.261005, 0.000000>, 
      <3.656909, 7.967190, 0.114796>, <5.187015, 8.040892, 0.114796>, <6.060746, 5.318059, 0.114796>, <7.169481, 4.261005, 0.114796>, 
      <3.655044, 7.901890, 0.272327>, <5.144218, 7.977198, 0.272327>, <6.036816, 5.259632, 0.272327>, <7.113220, 4.227805, 0.272327>, 
      <3.652726, 7.820750, 0.353500>, <5.141900, 7.896058, 0.353500>, <5.966908, 5.218378, 0.353500>, <7.043311, 4.186551, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.652726, 7.820750, -0.353500>, <5.141900, 7.896058, -0.353500>, <5.966908, 5.218378, -0.353500>, <7.043311, 4.186551, -0.353500>, 
      <3.655044, 7.901890, -0.272327>, <5.144218, 7.977198, -0.272327>, <6.036816, 5.259632, -0.272327>, <7.113220, 4.227805, -0.272327>, 
      <3.656909, 7.967190, -0.114796>, <5.187015, 8.040892, -0.114796>, <6.060746, 5.318059, -0.114796>, <7.169481, 4.261005, -0.114796>, 
      <3.656909, 7.967190, 0.000000>, <5.187015, 8.040892, 0.000000>, <6.060746, 5.318059, 0.000000>, <7.169481, 4.261005, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.642631, 7.467394, -0.500000>, <5.033400, 7.546866, -0.500000>, <5.739670, 4.977543, -0.500000>, <6.738868, 4.006894, -0.500000>, 
      <3.645909, 7.582143, -0.500000>, <5.036679, 7.661615, -0.500000>, <5.838535, 5.035885, -0.500000>, <6.837734, 4.065236, -0.500000>, 
      <3.650408, 7.739610, -0.434673>, <5.139582, 7.814918, -0.434673>, <5.896999, 5.177124, -0.434673>, <6.973403, 4.145296, -0.434673>, 
      <3.652726, 7.820750, -0.353500>, <5.141900, 7.896058, -0.353500>, <5.966908, 5.218378, -0.353500>, <7.043311, 4.186551, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.632536, 7.114038, -0.353500>, <4.925496, 7.198190, -0.353500>, <5.511195, 4.736344, -0.353500>, <6.434424, 3.827238, -0.353500>, 
      <3.634854, 7.195178, -0.434673>, <4.927814, 7.279330, -0.434673>, <5.581103, 4.777598, -0.434673>, <6.504333, 3.868492, -0.434673>, 
      <3.639353, 7.352644, -0.500000>, <5.030122, 7.432117, -0.500000>, <5.640804, 4.919201, -0.500000>, <6.640002, 3.948552, -0.500000>, 
      <3.642631, 7.467394, -0.500000>, <5.033400, 7.546866, -0.500000>, <5.739670, 4.977543, -0.500000>, <6.738868, 4.006894, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.628353, 6.967598, 0.000000>, <4.880981, 7.053883, 0.000000>, <5.416114, 4.636302, 0.000000>, <6.308255, 3.752784, 0.000000>, 
      <3.628353, 6.967598, -0.114796>, <4.880981, 7.053883, -0.114796>, <5.416114, 4.636302, -0.114796>, <6.308255, 3.752784, -0.114796>, 
      <3.630218, 7.032898, -0.272327>, <4.923178, 7.117050, -0.272327>, <5.441286, 4.695090, -0.272327>, <6.364516, 3.785984, -0.272327>, 
      <3.632536, 7.114038, -0.353500>, <4.925496, 7.198190, -0.353500>, <5.511195, 4.736344, -0.353500>, <6.434424, 3.827238, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.632536, 7.114038, 0.353500>, <4.925496, 7.198190, 0.353500>, <5.511195, 4.736344, 0.353500>, <6.434424, 3.827238, 0.353500>, 
      <3.630218, 7.032898, 0.272327>, <4.923178, 7.117050, 0.272327>, <5.441286, 4.695090, 0.272327>, <6.364516, 3.785984, 0.272327>, 
      <3.628353, 6.967598, 0.114796>, <4.880981, 7.053883, 0.114796>, <5.416114, 4.636302, 0.114796>, <6.308255, 3.752784, 0.114796>, 
      <3.628353, 6.967598, 0.000000>, <4.880981, 7.053883, 0.000000>, <5.416114, 4.636302, 0.000000>, <6.308255, 3.752784, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.642631, 7.467394, 0.500000>, <5.033400, 7.546866, 0.500000>, <5.739670, 4.977543, 0.500000>, <6.738868, 4.006894, 0.500000>, 
      <3.639353, 7.352644, 0.500000>, <5.030122, 7.432117, 0.500000>, <5.640804, 4.919201, 0.500000>, <6.640002, 3.948552, 0.500000>, 
      <3.634854, 7.195178, 0.434673>, <4.927814, 7.279330, 0.434673>, <5.581103, 4.777598, 0.434673>, <6.504333, 3.868492, 0.434673>, 
      <3.632536, 7.114038, 0.353500>, <4.925496, 7.198190, 0.353500>, <5.511195, 4.736344, 0.353500>, <6.434424, 3.827238, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.642631, 7.467394, 0.500000>, <3.645909, 7.582143, 0.500000>, <3.650408, 7.739610, 0.434673>, <3.652726, 7.820750, 0.353500>, 
      <5.033400, 7.546866, 0.500000>, <5.036679, 7.661615, 0.500000>, <5.139582, 7.814918, 0.434673>, <5.141900, 7.896058, 0.353500>, 
      <5.739670, 4.977543, 0.500000>, <5.838535, 5.035885, 0.500000>, <5.896999, 5.177124, 0.434673>, <5.966908, 5.218378, 0.353500>, 
      <6.738868, 4.006894, 0.500000>, <6.837734, 4.065236, 0.500000>, <6.973403, 4.145296, 0.434673>, <7.043311, 4.186551, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056364, 3.912952, 0.000000>, <0.706574, 5.375209, 0.000000>, <2.009494, 7.887837, 0.000000>, <3.656909, 7.967190, 0.000000>, 
      <-0.056364, 3.912952, 0.114796>, <0.706574, 5.375209, 0.114796>, <2.009494, 7.887837, 0.114796>, <3.656909, 7.967190, 0.114796>, 
      <-0.001407, 3.877633, 0.272327>, <0.732027, 5.309407, 0.272327>, <2.048401, 7.820640, 0.272327>, <3.655044, 7.901890, 0.272327>, 
      <0.066880, 3.833748, 0.353500>, <0.800315, 5.265522, 0.353500>, <2.046083, 7.739500, 0.353500>, <3.652726, 7.820750, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.066880, 3.833748, -0.353500>, <0.800315, 5.265522, -0.353500>, <2.046083, 7.739500, -0.353500>, <3.652726, 7.820750, -0.353500>, 
      <-0.001407, 3.877633, -0.272327>, <0.732027, 5.309407, -0.272327>, <2.048401, 7.820640, -0.272327>, <3.655044, 7.901890, -0.272327>, 
      <-0.056364, 3.912952, -0.114796>, <0.706574, 5.375209, -0.114796>, <2.009494, 7.887837, -0.114796>, <3.656909, 7.967190, -0.114796>, 
      <-0.056364, 3.912952, 0.000000>, <0.706574, 5.375209, 0.000000>, <2.009494, 7.887837, 0.000000>, <3.656909, 7.967190, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364263, 3.642631, -0.500000>, <1.026832, 5.000898, -0.500000>, <2.133840, 7.381177, -0.500000>, <3.642631, 7.467394, -0.500000>, 
      <0.267690, 3.704695, -0.500000>, <0.930259, 5.062961, -0.500000>, <2.137118, 7.495926, -0.500000>, <3.645909, 7.582143, -0.500000>, 
      <0.135167, 3.789862, -0.434673>, <0.868602, 5.221636, -0.434673>, <2.043765, 7.658360, -0.434673>, <3.650408, 7.739610, -0.434673>, 
      <0.066880, 3.833748, -0.353500>, <0.800315, 5.265522, -0.353500>, <2.046083, 7.739500, -0.353500>, <3.652726, 7.820750, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.661646, 3.451514, -0.353500>, <1.253875, 4.736384, -0.353500>, <2.220736, 7.022150, -0.353500>, <3.632536, 7.114038, -0.353500>, 
      <0.593359, 3.495400, -0.434673>, <1.185587, 4.780270, -0.434673>, <2.223054, 7.103290, -0.434673>, <3.634854, 7.195178, -0.434673>, 
      <0.460836, 3.580567, -0.500000>, <1.123405, 4.938834, -0.500000>, <2.130561, 7.266427, -0.500000>, <3.639353, 7.352644, -0.500000>, 
      <0.364263, 3.642631, -0.500000>, <1.026832, 5.000898, -0.500000>, <2.133840, 7.381177, -0.500000>, <3.642631, 7.467394, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.784890, 3.372311, 0.000000>, <1.348143, 4.626810, 0.000000>, <2.256459, 6.873095, 0.000000>, <3.628353, 6.967598, 0.000000>, 
      <0.784890, 3.372311, -0.114796>, <1.348143, 4.626810, -0.114796>, <2.256459, 6.873095, -0.114796>, <3.628353, 6.967598, -0.114796>, 
      <0.729934, 3.407629, -0.272327>, <1.322162, 4.692498, -0.272327>, <2.218418, 6.941010, -0.272327>, <3.630218, 7.032898, -0.272327>, 
      <0.661646, 3.451514, -0.353500>, <1.253875, 4.736384, -0.353500>, <2.220736, 7.022150, -0.353500>, <3.632536, 7.114038, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.661646, 3.451514, 0.353500>, <1.253875, 4.736384, 0.353500>, <2.220736, 7.022150, 0.353500>, <3.632536, 7.114038, 0.353500>, 
      <0.729934, 3.407629, 0.272327>, <1.322162, 4.692498, 0.272327>, <2.218418, 6.941010, 0.272327>, <3.630218, 7.032898, 0.272327>, 
      <0.784890, 3.372311, 0.114796>, <1.348143, 4.626810, 0.114796>, <2.256459, 6.873095, 0.114796>, <3.628353, 6.967598, 0.114796>, 
      <0.784890, 3.372311, 0.000000>, <1.348143, 4.626810, 0.000000>, <2.256459, 6.873095, 0.000000>, <3.628353, 6.967598, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364263, 3.642631, 0.500000>, <1.026832, 5.000898, 0.500000>, <2.133840, 7.381177, 0.500000>, <3.642631, 7.467394, 0.500000>, 
      <0.460836, 3.580567, 0.500000>, <1.123405, 4.938834, 0.500000>, <2.130561, 7.266427, 0.500000>, <3.639353, 7.352644, 0.500000>, 
      <0.593359, 3.495400, 0.434673>, <1.185587, 4.780270, 0.434673>, <2.223054, 7.103290, 0.434673>, <3.634854, 7.195178, 0.434673>, 
      <0.661646, 3.451514, 0.353500>, <1.253875, 4.736384, 0.353500>, <2.220736, 7.022150, 0.353500>, <3.632536, 7.114038, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364263, 3.642631, 0.500000>, <0.267690, 3.704695, 0.500000>, <0.135167, 3.789862, 0.434673>, <0.066880, 3.833748, 0.353500>, 
      <1.026832, 5.000898, 0.500000>, <0.930259, 5.062961, 0.500000>, <0.868602, 5.221636, 0.434673>, <0.800315, 5.265522, 0.353500>, 
      <2.133840, 7.381177, 0.500000>, <2.137118, 7.495926, 0.500000>, <2.043765, 7.658360, 0.434673>, <2.046083, 7.739500, 0.353500>, 
      <3.642631, 7.467394, 0.500000>, <3.645909, 7.582143, 0.500000>, <3.650408, 7.739610, 0.434673>, <3.652726, 7.820750, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.366909, 1.173885, 0.000000>, <-0.602854, 2.865541, 0.000000>, <-0.056364, 3.912952, 0.000000>, 
      <-0.500000, 0.000000, 0.114796>, <-0.366909, 1.173885, 0.114796>, <-0.602854, 2.865541, 0.114796>, <-0.056364, 3.912952, 0.114796>, 
      <-0.434673, 0.000000, 0.272327>, <-0.308559, 1.150124, 0.272327>, <-0.528914, 2.847862, 0.272327>, <-0.001407, 3.877633, 0.272327>, 
      <-0.353500, 0.000000, 0.353500>, <-0.227386, 1.150124, 0.353500>, <-0.460626, 2.803977, 0.353500>, <0.066880, 3.833748, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, 0.000000, -0.353500>, <-0.227386, 1.150124, -0.353500>, <-0.460626, 2.803977, -0.353500>, <0.066880, 3.833748, -0.353500>, 
      <-0.434673, 0.000000, -0.272327>, <-0.308559, 1.150124, -0.272327>, <-0.528914, 2.847862, -0.272327>, <-0.001407, 3.877633, -0.272327>, 
      <-0.500000, 0.000000, -0.114796>, <-0.366909, 1.173885, -0.114796>, <-0.602854, 2.865541, -0.114796>, <-0.056364, 3.912952, -0.114796>, 
      <-0.500000, 0.000000, 0.000000>, <-0.366909, 1.173885, 0.000000>, <-0.602854, 2.865541, 0.000000>, <-0.056364, 3.912952, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -0.500000>, <0.109279, 1.092789, -0.500000>, <-0.117231, 2.655568, -0.500000>, <0.364263, 3.642631, -0.500000>, 
      <-0.114796, 0.000000, -0.500000>, <-0.005517, 1.092789, -0.500000>, <-0.213804, 2.717632, -0.500000>, <0.267690, 3.704695, -0.500000>, 
      <-0.272327, 0.000000, -0.434673>, <-0.146213, 1.150124, -0.434673>, <-0.392339, 2.760091, -0.434673>, <0.135167, 3.789862, -0.434673>, 
      <-0.353500, 0.000000, -0.353500>, <-0.227386, 1.150124, -0.353500>, <-0.460626, 2.803977, -0.353500>, <0.066880, 3.833748, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.353500, 0.000000, -0.353500>, <0.445944, 1.035454, -0.353500>, <0.226482, 2.507404, -0.353500>, <0.661646, 3.451514, -0.353500>, 
      <0.272327, 0.000000, -0.434673>, <0.364771, 1.035454, -0.434673>, <0.158195, 2.551290, -0.434673>, <0.593359, 3.495400, -0.434673>, 
      <0.114796, 0.000000, -0.500000>, <0.224075, 1.092789, -0.500000>, <-0.020658, 2.593504, -0.500000>, <0.460836, 3.580567, -0.500000>, 
      <0.000000, 0.000000, -0.500000>, <0.109279, 1.092789, -0.500000>, <-0.117231, 2.655568, -0.500000>, <0.364263, 3.642631, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.585467, 1.011693, 0.000000>, <0.369029, 2.446089, 0.000000>, <0.784890, 3.372311, 0.000000>, 
      <0.500000, 0.000000, -0.114796>, <0.585467, 1.011693, -0.114796>, <0.369029, 2.446089, -0.114796>, <0.784890, 3.372311, -0.114796>, 
      <0.434673, 0.000000, -0.272327>, <0.527117, 1.035454, -0.272327>, <0.294770, 2.463519, -0.272327>, <0.729934, 3.407629, -0.272327>, 
      <0.353500, 0.000000, -0.353500>, <0.445944, 1.035454, -0.353500>, <0.226482, 2.507404, -0.353500>, <0.661646, 3.451514, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.353500, 0.000000, 0.353500>, <0.445944, 1.035454, 0.353500>, <0.226482, 2.507404, 0.353500>, <0.661646, 3.451514, 0.353500>, 
      <0.434673, 0.000000, 0.272327>, <0.527117, 1.035454, 0.272327>, <0.294770, 2.463519, 0.272327>, <0.729934, 3.407629, 0.272327>, 
      <0.500000, 0.000000, 0.114796>, <0.585467, 1.011693, 0.114796>, <0.369029, 2.446089, 0.114796>, <0.784890, 3.372311, 0.114796>, 
      <0.500000, 0.000000, 0.000000>, <0.585467, 1.011693, 0.000000>, <0.369029, 2.446089, 0.000000>, <0.784890, 3.372311, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <0.109279, 1.092789, 0.500000>, <-0.117231, 2.655568, 0.500000>, <0.364263, 3.642631, 0.500000>, 
      <0.114796, 0.000000, 0.500000>, <0.224075, 1.092789, 0.500000>, <-0.020658, 2.593504, 0.500000>, <0.460836, 3.580567, 0.500000>, 
      <0.272327, 0.000000, 0.434673>, <0.364771, 1.035454, 0.434673>, <0.158195, 2.551290, 0.434673>, <0.593359, 3.495400, 0.434673>, 
      <0.353500, 0.000000, 0.353500>, <0.445944, 1.035454, 0.353500>, <0.226482, 2.507404, 0.353500>, <0.661646, 3.451514, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <-0.114796, 0.000000, 0.500000>, <-0.272327, 0.000000, 0.434673>, <-0.353500, 0.000000, 0.353500>, 
      <0.109279, 1.092789, 0.500000>, <-0.005517, 1.092789, 0.500000>, <-0.146213, 1.150124, 0.434673>, <-0.227386, 1.150124, 0.353500>, 
      <-0.117231, 2.655568, 0.500000>, <-0.213804, 2.717632, 0.500000>, <-0.392339, 2.760091, 0.434673>, <-0.460626, 2.803977, 0.353500>, 
      <0.364263, 3.642631, 0.500000>, <0.267690, 3.704695, 0.500000>, <0.135167, 3.789862, 0.434673>, <0.066880, 3.833748, 0.353500>
    }
  }
  texture {
    rubberhose
  }
  rotate <-0.0, 0.0, 180.0>
  translate  <0.028531, -52.727711, -18.601657>
}
#declare flange = union {
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 0.3>
    translate  5.147455*z
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.1>
    translate  5.056951*z
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 0.3>
    translate  4.764936*z
  }
  texture {
    blackpipe
  }
}
#declare Cylndr30 = object {
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1 
    texture {
      metal_pipe
    }
    scale <0.5, 0.5, 5.0>
  }
}
#declare CSG2 = union {
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.2>
    rotate -90.0*x
    translate  <0.0, -1.290899, 4.423227>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.2>
    translate  <-0.0, -2.467895, 5.277499>
  }
}
#declare CSG3 = difference {
  torus { // Torus2
    1.5, 0.5  rotate -x*90
    rotate -90.0*y
    translate  <0.0, -1.480737, 5.410385>
  }
  object { CSG2 }
  texture {
    blackpipe
  }
}
#declare elbow = union {
  object { flange }
  object { Cylndr30 }
  object { CSG3 }
  object { // Cylndr2->Cylndr30
    Cylndr30
    rotate -90.0*x
    translate  <0.0, -7.096474, 6.900863>
  }
  object { // flange1->flange
    flange
    texture {
      blackpipe
    }
    rotate -90.0*x
    translate  <0.0, -6.910106, 6.915237>
  }
  translate  <0.0, -46.294465, -25.387287>
}
#declare hose1 = union { // hose1
  object { sPatchObj1 }
  object { elbow }
  translate  <-0.037403, 0.140059, -2.873403>
}


//
// Include file contains 'RotSwp001'
//
#include "tanktest6.in1"
#declare RotSwp001 = object {
  RotSwp001_Raw
  scale 0.577314
  rotate -90.0*x
  translate  <0.0, 0.984943, 2.684453>
}
#declare wheel = union {
  torus { // Torus4
    2.65, 0.15  rotate -x*90
    scale <1.0, 0.942062, 2.197382>
    translate  2.723078*z
  }
  object { // RotSwp4->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 90.0>
    translate  <0.008025, -0.003204, 0.0>
  }
  object { // RotSwp3->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.01605, 0.0>
  }
  object { // RotSwp2->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, -90.0>
    translate  <-0.041712, -0.014433, 0.0>
  }
  object { RotSwp001 }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.5
    translate  2.780831*z
  }
  texture {
    blackpipe
  }
  translate  <-57.41488, -4.475297, -14.418466>
}
#declare wheel_group = union {
  object { wheel }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    texture {
      blackpipe
    }
    scale <3.647168, 3.647168, 5.924065>
    rotate -90.0*x
    translate  <-57.373577, -7.476924, -16.99091>
  }
}
#declare wheel_group4 = object {
  object { // wheel_group4->wheel group
    wheel_group
    rotate -90.0*z
    translate  <17.609293, -145.154227, 0.0>
  }
}
#declare flange3 = union {
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 0.3>
    translate  5.147455*z
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.1>
    translate  5.056951*z
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 0.3>
    translate  4.764936*z
  }
  texture {
    blackpipe
  }
}
#declare CSG4 = union {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.2>
    rotate -90.0*x
    translate  <0.0, -1.290899, 4.423227>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 2.2>
    translate  <-0.0, -2.467895, 5.277499>
  }
}
#declare CSG5 = difference {
  torus { // Torus3
    1.5, 0.5  rotate -x*90
    rotate -90.0*y
    translate  <0.0, -1.480737, 5.410385>
  }
  object { CSG4 }
  texture {
    blackpipe
  }
}
#declare elbow2 = union {
  object { flange3 }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1 
    texture {
      metal_pipe
    }
    scale <0.5, 0.5, 5.0>
  }
  object { CSG5 }
  object { // Cylndr35->Cylndr30
    Cylndr30
    rotate -90.0*x
    translate  <0.0, -7.096474, 6.900863>
  }
  object { // flange4->flange
    flange
    texture {
      blackpipe
    }
    rotate -90.0*x
    translate  <0.0, -6.910106, 6.915237>
  }
  rotate -90.0*z
  translate  <-44.752967, -4.611153, -25.387287>
}
#declare straight_pipe = union {
  object { elbow2 }
  cylinder { // pipe2
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 50.0>
    rotate -90.0*y
    translate  <-51.813726, -4.598447, -18.477735>
    texture {
      metal_pipe
    }
  }
}
#declare straight_pipe4 = object {
  object { // straight_pipe4->straight pipe
    straight_pipe
    rotate -90.0*z
    translate  <1.803711, -2.339039, -1.271704>
  }
}


#declare Cylndr003 = object {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    texture {
      whitestuff
    }
    scale <0.5, 0.5, 10.0>
    translate  <18.909486, 89.967404, 0.003962>
  }
}


#declare Cylndr005 = object {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    texture {
      Texture4
    }
    no_shadow
    hollow
    scale <1.0, 1.0, 40.0>
    translate  -2.446737*z
  }
}
#declare Cylndr6 = object {
  object { // Cylndr6->Cylndr005
    Cylndr005
    translate  <-0.047845, 2.727189, 0.0>
  }
}
#declare core = union {
  object { // Cylndr10->Cylndr6
    Cylndr6
    translate  <-2.290047, -4.132219, 0.0>
  }
  object { // Cylndr11->Cylndr6
    Cylndr6
    translate  <-2.337892, -1.40503, 0.0>
  }
  object { // Cylndr9->Cylndr6
    Cylndr6
    translate  <0.095691, -5.454378, 0.0>
  }
  object { // Cylndr8->Cylndr6
    Cylndr6
    translate  <2.433583, -4.049348, 0.0>
  }
  object { // Cylndr7->Cylndr6
    Cylndr6
    translate  <2.385738, -1.322159, 0.0>
  }
  object { Cylndr6 }
  object { Cylndr005 }
  no_shadow
  scale 1.5
}
#declare core1 = object {
  object { // core1->core
    core
    translate  <-3.854734, 10.148058, 0.0>
  }
}




//
// ********  OBJECTS  *******
//

object { hose1 }


union { // vert_pipes3
  superellipsoid { // pipe_insulation9
    <1.0, 0.1>
    scale <3.0, 3.0, 15.0>
    rotate <-0.0, 0.0, -90.0>
    translate  <94.56935, -27.837432, 2.59836>
    texture {
      pipe_insulationMtop
      // Transform to world space
      translate <7.506532, -3.933724, 0.000000>
      rotate z*90.000000
    }
  }
  object { // wheel_group10->wheel group4
    wheel_group4
    rotate -90.0*y
    translate  <77.501143, 59.992691, -18.778336>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1 
    texture {
      metal_pipe
    }
    scale <2.0, 2.0, 15.53909>
    translate  <94.589036, -27.798581, -25.063828>
  }
  rotate -90.0*z
  translate  <-7.506532, 3.933724, 0.0>
}


cylinder { // Cylndr39
  <0,0,1>, <0,0,0>, 1 
  scale <1.0, 1.0, 190.0>
  rotate -90.0*y
  translate  <98.738679, -90.018876, -3.78727>
  texture {
    metal_pipe
  }
}


cylinder { // Cylndr009
  <0,0,1>, <0,0,0>, 1 
  scale <1.0, 1.0, 190.0>
  rotate -90.0*y
  translate  <98.738679, -90.018876, -6.492462>
  texture {
    metal_pipe
  }
}




union { // puter
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    texture {
      yellow_glow
    }
    scale <0.464365, 0.309373, 1.690627>
    translate  <-31.762979, -73.724423, -9.701355>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      orange_glow
    }
    scale <4.499564, 0.309373, 0.644464>
    translate  <-24.486002, -73.724423, -16.277236>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      red_glow
    }
    scale <-4.649016, -0.309373, -0.401699>
    rotate -180.0*z
    translate  <-24.395399, -73.724423, -14.407294>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      red_glow
    }
    scale <0.464365, 0.309373, 1.690627>
    translate  <-20.958007, -73.724423, -9.624836>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      orange_glow
    }
    scale <0.464365, 0.309373, 1.690627>
    translate  <-29.762979, -73.724423, -9.701355>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      orange_glow
    }
    scale <0.464365, 0.309373, 1.690627>
    translate  <-30.762979, -73.724423, -9.701355>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    texture {
      whitestuff
    }
    scale <7.491893, 3.624382, 7.215642>
    translate  <-26.243823, -77.488339, -14.088789>
  }
  text {   // Text001
    ttf      "C:\WINDOWS\Fonts\Stencil.ttf",
    "DANGER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    texture {
      orange_glow
    }
    scale <1.648895, 1.648895, 0.5>
    rotate <90.0, -0.0, 180.0>
    translate  <-22.269699, -74.044874, -9.667959>
  }

  translate  4.143761*y
}




union { // flashlight
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 1.341709>
    rotate -90.0*x
    translate  <25.868145, 11.152704, 12.232891>
  }
  cone { // Cone002
    <0,0,0>, 0.3, <0,0,1>, 0.6
    open
    scale <1.0, 0.981461, 0.592145>
    rotate 90.0*x
    translate  <25.889803, 11.185472, 12.224199>
  }
  texture {
    rubberhose
  }
  rotate <-10.262745, -26.111898, 8.464976>
  translate  <24.09, 74.479, 1.401>
}


union { // hanging_light_group
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      whitestuff
    }
    scale <5.0, 5.0, 2.0>
    rotate 180.0*x
    translate  <-40.27767, -42.515318, 9.978178>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    texture {
      whitestuff
    }
    scale <0.25, 0.25, 30.0>
    translate  <-40.289762, -42.589066, 9.828794>
  }
  translate  <52.267666, -30.885846, 0.0>
}


#declare vert_pipes2 = union {
  superellipsoid { // pipe_insulation8
    <1.0, 0.1>
    scale <3.0, 3.0, 15.0>
    rotate <-0.0, 0.0, -90.0>
    translate  <94.56935, -27.837432, 2.59836>
    texture {
      pipe_insulationMtop
      // Transform to world space
      translate <4.728168, 22.284963, 0.000000>
    }
  }
  object { // wheel_group9->wheel group4
    wheel_group4
    rotate -90.0*y
    translate  <77.501143, 59.992691, -18.778336>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1 
    texture {
      metal_pipe
    }
    scale <2.0, 2.0, 15.53909>
    translate  <94.589036, -27.798581, -25.063828>
  }
  translate  <-4.728168, -22.284963, 0.0>
}
#declare vert_pipes1 = union {
  superellipsoid { // pipe_insulation7
    <1.0, 0.1>
    scale <3.0, 3.0, 15.0>
    rotate <-0.0, 0.0, -90.0>
    translate  <94.56935, -27.837432, 2.59836>
    texture {
      pipe_insulationMtop
      // Transform to world space
      translate <3.978011, 11.782761, 0.000000>
    }
  }
  object { // wheel_group8->wheel group4
    wheel_group4
    rotate -90.0*y
    translate  <77.501143, 59.992691, -18.778336>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1 
    texture {
      metal_pipe
    }
    scale <2.0, 2.0, 15.53909>
    translate  <94.589036, -27.798581, -25.063828>
  }
  translate  <-3.978011, -11.782761, 0.0>
}
#declare vert_pipes = union {
  superellipsoid { // pipe_insulation4
    <1.0, 0.1>
    scale <3.0, 3.0, 15.0>
    rotate <-0.0, 0.0, -90.0>
    translate  <94.56935, -27.837432, 2.59836>
    texture {
      pipe_insulationMtop
      // Transform to world space
      translate <3.978011, 0.530401, 0.000000>
    }
  }
  object { // wheel_group7->wheel group4
    wheel_group4
    rotate -90.0*y
    translate  <77.501143, 59.992691, -18.778336>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    texture {
      metal_pipe
    }
    scale <2.0, 2.0, 15.53909>
    translate  <94.589036, -27.798581, -25.063828>
  }
  translate  <-3.978011, -0.530401, 0.0>
}
union { // pipes_and_such
  superellipsoid { // pipe_insulation6
    <1.0, 0.1>
    scale <3.0, 3.0, 80.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-57.432974, -1.20416, -16.774476>
    texture {
      pipe_insulationMtop
    }
  }
  superellipsoid { // pipe_insulation5
    <1.0, 0.1>
    scale <3.0, 3.0, 80.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-57.432974, -1.20416, -16.774476>
    texture {
      pipe_insulationMtop
    }
  }
  object { // wheel_group6->wheel group4
    wheel_group4
    rotate 0.0*z
    translate  <-20.0, -0.0, 0.0>
  }
  object { // wheel_group5->wheel group4
    wheel_group4
    rotate 0.0*z
    translate  <-10.0, -0.0, 0.0>
  }
  object { wheel_group4 }
  object { // wheel_group3->wheel group
    wheel_group
    translate  24.0*y
  }
  object { // wheel_group2->wheel group
    wheel_group
    translate  16.0*y
  }
  object { // wheel_group1->wheel group
    wheel_group
    translate  -20.586433*y
  }
  object { wheel_group }
  object { // straight_pipe7->straight pipe4
    straight_pipe4
    rotate <-0.0, 0.0, 0.0>
    translate  -9.0*x
  }
  object { // straight_pipe6->straight pipe4
    straight_pipe4
    rotate <-0.0, 0.0, 0.0>
    translate  -6.0*x
  }
  object { // straight_pipe5->straight pipe4
    straight_pipe4
    rotate <-0.0, 0.0, 0.0>
    translate  -3.0*x
  }
  object { straight_pipe4 }
  object { // straight_pipe3->straight pipe
    straight_pipe
    translate  -15.0*y
  }
  object { // straight_pipe2->straight pipe
    straight_pipe
    translate  -10.0*y
  }
  object { // straight_pipe1->straight pipe
    straight_pipe
    translate  19.642843*y
  }
  object { straight_pipe }
  object { // Group2->hose1
    hose1
    rotate -180.0*z
    translate  <3.75814, -1.642691, 0.0>
  }
  superellipsoid { // pipe_insulation3
    <1.0, 0.1>
    scale <2.0, 2.0, 80.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-66.184144, 3.330725, -16.774476>
    texture {
      pipe_insulationMtop
    }
  }
  superellipsoid { // pipe_insulation2
    <1.0, 0.1>
    scale <3.0, 3.0, 80.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-57.432974, -1.20416, -16.774476>
    texture {
      pipe_insulationMtop
    }
  }
  superellipsoid { // pipe_insulation1
    <1.0, 0.1>
    scale <3.0, 3.0, 80.0>
    rotate -90.0*y
    translate  <0.0, -87.726563, -16.774476>
    texture {
      pipe_insulationMtop
    }
  }
  object { vert_pipes2 }
  object { vert_pipes1 }
  object { vert_pipes }
}


cylinder { // pipe1
  <0,0,1>, <0,0,0>, 1 
  texture {
    metal_pipe
  }
  scale <0.5, 0.5, 150.0>
  rotate <0.0, -90.0, -90.0>
  translate  <85.255491, -81.116175, -16.901872>
}


object { // flange2->flange
  flange
  rotate -90.0*x
  translate  <85.258419, -86.563193, -16.884372>
}


object { // elbow1->elbow
  elbow
  rotate <0.0, -90.0, -180.0>
  translate  <103.740142, -135.000024, -16.853713>
}


cylinder { // pipe
  <0,0,1>, <0,0,0>, 1 
  texture {
    metal_pipe
  }
  scale <0.5, 0.5, 40.0>
  rotate <50.211586, -90.0, 0.0>
  translate  <86.190532, -43.081813, -21.121569>
}


union { // railing
  object { // Cylndr27->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -180.0, 0.0>
  }
  object { // Cylndr26->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -170.0, 0.0>
  }
  object { // Cylndr25->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -160.0, 0.0>
  }
  object { // Cylndr24->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -150.0, 0.0>
  }
  object { // Cylndr23->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -140.0, 0.0>
  }
  object { // Cylndr22->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -130.0, 0.0>
  }
  object { // Cylndr21->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -120.0, 0.0>
  }
  object { // Cylndr20->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -110.0, 0.0>
  }
  object { // Cylndr19->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -100.0, 0.0>
  }
  object { // Cylndr18->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -90.0, 0.0>
  }
  object { // Cylndr17->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -80.0, 0.0>
  }
  object { // Cylndr16->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -70.0, 0.0>
  }
  object { // Cylndr15->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -60.0, 0.0>
  }
  object { // Cylndr14->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -50.0, 0.0>
  }
  object { // Cylndr13->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -40.0, 0.0>
  }
  object { // Cylndr12->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -30.0, 0.0>
  }
  object { // Cylndr5->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -20.0, 0.0>
  }
  object { // Cylndr4->Cylndr003
    Cylndr003
    rotate -0.0*x
    translate  <0.0, -10.0, 0.0>
  }
  cylinder { // rail1
    <0,0,1>, <0,0,0>, 1 
    texture {
      whitestuff
    }
    scale <0.5, 0.5, 190.0>
    rotate -90.0*x
    translate  <18.995021, -91.651146, 10.249616>
  }
  box { // walkway
    <-1, -1, -1>, <1, 1, 1>
    scale <6.56994, -91.385414, -0.2>
    translate  <24.910556, 0.931472, 0.0>
    texture {
      Texture5
    }
  }
  object { Cylndr003 }
}


difference { // corecenter
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    texture {
      Texture4
    }
    no_shadow
    scale <19.0, 19.0, 44.429585>
  }
  object { // core6->core1
    core1
    rotate -0.0*x
    translate  <-6.861109, -8.412327, 0.0>
  }
  object { // core5->core1
    core1
    rotate -0.0*x
    translate  <-3.006375, -18.560385, 0.0>
  }
  object { // core4->core1
    core1
    rotate -0.0*x
    translate  <7.709468, -20.296116, 0.0>
  }
  object { // core3->core1
    core1
    rotate -0.0*x
    translate  <14.570577, -11.88379, 0.0>
  }
  object { // core2->core1
    core1
    rotate -0.0*x
    translate  <10.715843, -1.735732, 0.0>
  }
  object { core }
  object { core1 }
  no_shadow
  translate  -77.0*z
}


#declare CSG004 = union {
  superellipsoid { // SuperQ001
    <1.0, 0.5>
    scale <16.893368, 16.893368, 6.047898>
    translate  -48.51921*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale 19.715
    translate  -65.072823*z
  }
  torus { // Torus001
    1.125, 0.125  rotate -x*90
    scale -11.394813
    translate  -43.381882*z
  }
  texture {
    Texture4
  }
}
#declare outer_core_bool = union {
  cylinder { // vertical_cylinder
    <0,0,1>, <0,0,0>, 1 
    scale <25.0, 25.0, 67.057854>
    translate  <0.0, -0.933356, -78.692373>
  }
  scale 0.419812
  translate  -31.587467*z
}
difference { // reactor_shell
  object { CSG004 }
  object { outer_core_bool }
  texture {
    Texture4
  }
  no_shadow
  scale 2.382021
  translate  75.242024*z
}


box { // heavy_water
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Water2
  }
  hollow
  interior {ior 1.33
            media {
           
          scattering {4, 0.25 }
          }
  }
  scale <67.614655, 69.269745, 28.429565>
  translate  -60.083805*z
}


#declare CSG002 = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <59.326893, 59.326893, 20.832708>
    translate  -34.708023*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale 48.826107
  }
  translate  -8.165433*z
}
#declare CSG001 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <100.228264, 98.103508, 30.111063>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <94.319229, 91.986252, 40.660671>
    translate  <1.16649, 0.0, 18.663847>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      walls
    }
    scale <46.978771, 48.434998, 17.723185>
    translate  -26.810868*z
  }
}
union { // room
  object { CSG002 }
  object { CSG001 }
  texture {
    walls
  }
}




#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.305046, 0.410920>, <1.543582, -0.305046, 0.412481>, <1.454109, -0.216128, 0.415301>, <1.396527, -0.158546, 0.415301>, 
      <1.625000, -0.305046, 0.410920>, <1.625000, -0.305046, 0.410920>, <1.591193, -0.216128, 0.412672>, <1.533611, -0.158546, 0.412672>, 
      <1.625000, -0.305046, 0.410920>, <1.625000, -0.305046, 0.410920>, <1.658807, -0.216128, 0.409168>, <1.716389, -0.158546, 0.409168>, 
      <1.625000, -0.305046, 0.410920>, <1.706418, -0.305046, 0.409359>, <1.795891, -0.216128, 0.406539>, <1.853473, -0.158546, 0.406539>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.055046, 0.410920>, <1.906023, -0.061757, 0.410636>, <1.875918, -0.136101, 0.406539>, <1.853473, -0.158546, 0.406539>, 
      <1.728397, -0.023334, 0.412262>, <1.759420, -0.030044, 0.411978>, <1.738834, -0.136101, 0.409168>, <1.716389, -0.158546, 0.409168>, 
      <1.521603, -0.023334, 0.409578>, <1.490580, -0.030044, 0.409862>, <1.511166, -0.136101, 0.412672>, <1.533611, -0.158546, 0.412672>, 
      <1.375000, -0.055046, 0.410920>, <1.343977, -0.061757, 0.411204>, <1.374082, -0.136101, 0.415301>, <1.396527, -0.158546, 0.415301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375000, -0.055046, 0.110632>, <1.375000, -0.055046, 0.200718>, <1.375000, -0.055046, 0.320834>, <1.375000, -0.055046, 0.410920>, 
      <1.343977, -0.061757, 0.110916>, <1.343977, -0.061757, 0.201003>, <1.343977, -0.061757, 0.321118>, <1.343977, -0.061757, 0.411204>, 
      <1.374082, -0.136101, 0.115013>, <1.374082, -0.136101, 0.205099>, <1.374082, -0.136101, 0.325215>, <1.374082, -0.136101, 0.415301>, 
      <1.396527, -0.158546, 0.115013>, <1.396527, -0.158546, 0.205099>, <1.396527, -0.158546, 0.325215>, <1.396527, -0.158546, 0.415301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.305046, 0.110632>, <1.543582, -0.305046, 0.112193>, <1.454109, -0.216128, 0.115013>, <1.396527, -0.158546, 0.115013>, 
      <1.625000, -0.305046, 0.200718>, <1.543582, -0.305046, 0.202280>, <1.454109, -0.216128, 0.205099>, <1.396527, -0.158546, 0.205099>, 
      <1.625000, -0.305046, 0.320834>, <1.543582, -0.305046, 0.322395>, <1.454109, -0.216128, 0.325215>, <1.396527, -0.158546, 0.325215>, 
      <1.625000, -0.305046, 0.410920>, <1.543582, -0.305046, 0.412481>, <1.454109, -0.216128, 0.415301>, <1.396527, -0.158546, 0.415301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.305046, 0.110632>, <1.706418, -0.305046, 0.109071>, <1.795891, -0.216128, 0.106251>, <1.853473, -0.158546, 0.106251>, 
      <1.625000, -0.305046, 0.110632>, <1.625000, -0.305046, 0.110632>, <1.658807, -0.216128, 0.108880>, <1.716389, -0.158546, 0.108880>, 
      <1.625000, -0.305046, 0.110632>, <1.625000, -0.305046, 0.110632>, <1.591193, -0.216128, 0.112384>, <1.533611, -0.158546, 0.112384>, 
      <1.625000, -0.305046, 0.110632>, <1.543582, -0.305046, 0.112193>, <1.454109, -0.216128, 0.115013>, <1.396527, -0.158546, 0.115013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.305046, 0.110632>, <1.625000, -0.305046, 0.200718>, <1.625000, -0.305046, 0.320834>, <1.625000, -0.305046, 0.410920>, 
      <1.706418, -0.305046, 0.109071>, <1.706418, -0.305046, 0.199157>, <1.706418, -0.305046, 0.319272>, <1.706418, -0.305046, 0.409359>, 
      <1.795891, -0.216128, 0.106251>, <1.795891, -0.216128, 0.196337>, <1.795891, -0.216128, 0.316453>, <1.795891, -0.216128, 0.406539>, 
      <1.853473, -0.158546, 0.106251>, <1.853473, -0.158546, 0.196337>, <1.853473, -0.158546, 0.316453>, <1.853473, -0.158546, 0.406539>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.055046, 0.110632>, <1.906023, -0.061757, 0.110348>, <1.875918, -0.136101, 0.106251>, <1.853473, -0.158546, 0.106251>, 
      <1.875000, -0.055046, 0.200718>, <1.906023, -0.061757, 0.200434>, <1.875918, -0.136101, 0.196337>, <1.853473, -0.158546, 0.196337>, 
      <1.875000, -0.055046, 0.320834>, <1.906023, -0.061757, 0.320550>, <1.875918, -0.136101, 0.316453>, <1.853473, -0.158546, 0.316453>, 
      <1.875000, -0.055046, 0.410920>, <1.906023, -0.061757, 0.410636>, <1.875918, -0.136101, 0.406539>, <1.853473, -0.158546, 0.406539>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.055046, 0.110632>, <1.875000, -0.055046, 0.200718>, <1.875000, -0.055046, 0.320834>, <1.875000, -0.055046, 0.410920>, 
      <1.728397, -0.023334, 0.111974>, <1.728397, -0.023334, 0.202061>, <1.728397, -0.023334, 0.322176>, <1.728397, -0.023334, 0.412262>, 
      <1.521603, -0.023334, 0.109290>, <1.521603, -0.023334, 0.199376>, <1.521603, -0.023334, 0.319491>, <1.521603, -0.023334, 0.409578>, 
      <1.375000, -0.055046, 0.110632>, <1.375000, -0.055046, 0.200718>, <1.375000, -0.055046, 0.320834>, <1.375000, -0.055046, 0.410920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.055046, 0.110632>, <1.728397, -0.023334, 0.111974>, <1.521603, -0.023334, 0.109290>, <1.375000, -0.055046, 0.110632>, 
      <1.906023, -0.061757, 0.110348>, <1.759420, -0.030044, 0.111690>, <1.490580, -0.030044, 0.109574>, <1.343977, -0.061757, 0.110916>, 
      <1.875918, -0.136101, 0.106251>, <1.738834, -0.136101, 0.108880>, <1.511166, -0.136101, 0.112384>, <1.374082, -0.136101, 0.115013>, 
      <1.853473, -0.158546, 0.106251>, <1.716389, -0.158546, 0.108880>, <1.533611, -0.158546, 0.112384>, <1.396527, -0.158546, 0.115013>
    }
  }
  texture {
    visor
  }
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.624122, -0.013471, -1.830824>, <0.624122, -0.013471, -1.830824>, <0.598250, -0.002519, -1.825408>, <0.598250, -0.002519, -1.825408>, 
      <0.630888, -0.069516, -1.702588>, <0.602901, -0.067720, -1.696917>, <0.584945, -0.060856, -1.694433>, <0.564645, -0.041190, -1.689984>, 
      <0.641766, -0.097045, -1.602316>, <0.613780, -0.095249, -1.596645>, <0.575827, -0.080202, -1.588713>, <0.555527, -0.060536, -1.584264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.646995, -0.005647, -1.835285>, <0.646995, -0.005647, -1.835285>, <0.624122, -0.013471, -1.830824>, <0.624122, -0.013471, -1.830824>, 
      <0.646857, -0.038447, -1.682962>, <0.631674, -0.057585, -1.680216>, <0.654934, -0.071059, -1.707461>, <0.630888, -0.069516, -1.702588>, 
      <0.718011, -0.070965, -1.617188>, <0.702828, -0.090103, -1.614442>, <0.665812, -0.098588, -1.607188>, <0.641766, -0.097045, -1.602316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.651297, 0.020782, -1.835739>, <0.651297, 0.020782, -1.835739>, <0.646995, -0.005647, -1.835285>, <0.646995, -0.005647, -1.835285>, 
      <0.701302, 0.018307, -1.713018>, <0.700117, -0.008447, -1.713180>, <0.663397, -0.017598, -1.685954>, <0.646857, -0.038447, -1.682962>, 
      <0.732350, 0.017132, -1.618700>, <0.731165, -0.009622, -1.618862>, <0.734552, -0.050116, -1.620180>, <0.718011, -0.070965, -1.617188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.649457, 0.049948, -1.834949>, <0.649457, 0.049948, -1.834949>, <0.651297, 0.020782, -1.835739>, <0.651297, 0.020782, -1.835739>, 
      <0.696087, 0.093293, -1.712463>, <0.713037, 0.069778, -1.716269>, <0.702595, 0.047513, -1.712841>, <0.701302, 0.018307, -1.713018>, 
      <0.726218, 0.114354, -1.616066>, <0.743167, 0.090840, -1.619872>, <0.733643, 0.046338, -1.618523>, <0.732350, 0.017132, -1.618700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.624352, 0.058163, -1.829688>, <0.624352, 0.058163, -1.829688>, <0.649457, 0.049948, -1.834949>, <0.649457, 0.049948, -1.834949>, 
      <0.631455, 0.114149, -1.699893>, <0.657851, 0.113947, -1.705242>, <0.680472, 0.114956, -1.708957>, <0.696087, 0.093293, -1.712463>, 
      <0.642533, 0.141737, -1.598532>, <0.668930, 0.141535, -1.603881>, <0.710603, 0.136018, -1.612560>, <0.726218, 0.114354, -1.616066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.598413, 0.050339, -1.824605>, <0.598413, 0.050339, -1.824605>, <0.624352, 0.058163, -1.829688>, <0.624352, 0.058163, -1.829688>, 
      <0.565097, 0.093789, -1.688362>, <0.584160, 0.113382, -1.691911>, <0.604438, 0.114356, -1.694419>, <0.631455, 0.114149, -1.699893>, 
      <0.556069, 0.115657, -1.581589>, <0.575132, 0.135250, -1.585139>, <0.615517, 0.141944, -1.593058>, <0.642533, 0.141737, -1.598532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, <0.616560, 0.022346, -1.928755>, 
      <0.588362, 0.021173, -1.822987>, <0.588362, 0.021173, -1.822987>, <0.598413, 0.050339, -1.824605>, <0.598413, 0.050339, -1.824605>, 
      <0.538498, 0.019347, -1.684493>, <0.538593, 0.050236, -1.684024>, <0.543734, 0.071832, -1.684384>, <0.565097, 0.093789, -1.688362>, 
      <0.522567, 0.018436, -1.576193>, <0.522662, 0.049324, -1.575724>, <0.534706, 0.093700, -1.577611>, <0.556069, 0.115657, -1.581589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.022346, -1.928755>, <0.588362, 0.021173, -1.822987>, <0.538498, 0.019347, -1.684493>, <0.522567, 0.018436, -1.576193>, 
      <0.616560, 0.022346, -1.928755>, <0.588362, 0.021173, -1.822987>, <0.538419, -0.006436, -1.684884>, <0.522488, -0.007347, -1.576585>, 
      <0.616560, 0.022346, -1.928755>, <0.598250, -0.002519, -1.825408>, <0.546350, -0.023466, -1.685975>, <0.537232, -0.042812, -1.580255>, 
      <0.616560, 0.022346, -1.928755>, <0.598250, -0.002519, -1.825408>, <0.564645, -0.041190, -1.689984>, <0.555527, -0.060536, -1.584264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663737, -0.097045, -1.493886>, <0.657146, -0.097045, -1.526415>, <0.645219, -0.105784, -1.570484>, <0.641766, -0.097045, -1.602316>, 
      <0.644365, -0.096214, -1.472846>, <0.637774, -0.096214, -1.505375>, <0.617233, -0.103988, -1.564813>, <0.613780, -0.095249, -1.596645>, 
      <0.597405, -0.080435, -1.480968>, <0.590813, -0.080435, -1.513497>, <0.573021, -0.086155, -1.556182>, <0.575827, -0.080202, -1.588713>, 
      <0.577497, -0.060536, -1.475834>, <0.570906, -0.060536, -1.508363>, <0.552721, -0.066489, -1.551733>, <0.555527, -0.060536, -1.584264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.820737, -0.070965, -1.740015>, <0.811198, -0.070965, -1.787095>, <0.751452, -0.086248, -1.586275>, <0.718011, -0.070965, -1.617188>, 
      <0.766429, -0.139419, -1.730191>, <0.756890, -0.139419, -1.777271>, <0.736269, -0.105386, -1.583529>, <0.702828, -0.090103, -1.614442>, 
      <0.723272, -0.099598, -1.558546>, <0.716680, -0.099598, -1.591075>, <0.669265, -0.107328, -1.575356>, <0.665812, -0.098588, -1.607188>, 
      <0.663737, -0.097045, -1.493886>, <0.657146, -0.097045, -1.526415>, <0.645219, -0.105784, -1.570484>, <0.641766, -0.097045, -1.602316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.754320, 0.017132, -1.510272>, <0.747729, 0.017132, -1.542800>, <0.742727, 0.016739, -1.587177>, <0.732350, 0.017132, -1.618700>, 
      <0.772450, -0.029180, -1.568344>, <0.765859, -0.029180, -1.600873>, <0.741542, -0.010015, -1.587339>, <0.731165, -0.009622, -1.618862>, 
      <0.867960, -0.011443, -1.748557>, <0.858420, -0.011443, -1.795637>, <0.767993, -0.065399, -1.589266>, <0.734552, -0.050116, -1.620180>, 
      <0.820737, -0.070965, -1.740015>, <0.811198, -0.070965, -1.787095>, <0.751452, -0.086248, -1.586275>, <0.718011, -0.070965, -1.617188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.748189, 0.114354, -1.507635>, <0.741598, 0.114354, -1.540164>, <0.735911, 0.121130, -1.585054>, <0.726218, 0.114354, -1.616066>, 
      <0.765139, 0.090840, -1.511441>, <0.758547, 0.090840, -1.543970>, <0.752861, 0.097615, -1.588860>, <0.743167, 0.090840, -1.619872>, 
      <0.747388, 0.034840, -1.488067>, <0.740797, 0.034840, -1.520595>, <0.744020, 0.045945, -1.587000>, <0.733643, 0.046338, -1.618523>, 
      <0.754320, 0.017132, -1.510272>, <0.747729, 0.017132, -1.542800>, <0.742727, 0.016739, -1.587177>, <0.732350, 0.017132, -1.618700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.664503, 0.141737, -1.490103>, <0.657912, 0.141737, -1.522632>, <0.646014, 0.150405, -1.566684>, <0.642533, 0.141737, -1.598532>, 
      <0.690900, 0.141535, -1.495452>, <0.684309, 0.141535, -1.527980>, <0.672411, 0.150203, -1.572033>, <0.668930, 0.141535, -1.603881>, 
      <0.732574, 0.136018, -1.504129>, <0.725982, 0.136018, -1.536658>, <0.720296, 0.142793, -1.581548>, <0.710603, 0.136018, -1.612560>, 
      <0.748189, 0.114354, -1.507635>, <0.741598, 0.114354, -1.540164>, <0.735911, 0.121130, -1.585054>, <0.726218, 0.114354, -1.616066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.578039, 0.115657, -1.473159>, <0.571448, 0.115657, -1.505688>, <0.553329, 0.122294, -1.549185>, <0.556069, 0.115657, -1.581589>, 
      <0.596734, 0.135479, -1.477340>, <0.590143, 0.135479, -1.509869>, <0.572392, 0.141887, -1.552735>, <0.575132, 0.135250, -1.585139>, 
      <0.637487, 0.141944, -1.484629>, <0.630895, 0.141944, -1.517158>, <0.618998, 0.150612, -1.561210>, <0.615517, 0.141944, -1.593058>, 
      <0.664503, 0.141737, -1.490103>, <0.657912, 0.141737, -1.522632>, <0.646014, 0.150405, -1.566684>, <0.642533, 0.141737, -1.598532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.548208, 0.018436, -1.464093>, <0.541357, 0.018436, -1.497905>, <0.517546, 0.018149, -1.542063>, <0.522567, 0.018436, -1.576193>, 
      <0.548302, 0.049062, -1.463628>, <0.541451, 0.049062, -1.497440>, <0.517641, 0.049037, -1.541594>, <0.522662, 0.049324, -1.575724>, 
      <0.557266, 0.093633, -1.468513>, <0.550675, 0.093633, -1.501042>, <0.531966, 0.100337, -1.545207>, <0.534706, 0.093700, -1.577611>, 
      <0.578039, 0.115657, -1.473159>, <0.571448, 0.115657, -1.505688>, <0.553329, 0.122294, -1.549185>, <0.556069, 0.115657, -1.581589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.548208, 0.018436, -1.464093>, <0.548129, -0.007074, -1.464481>, <0.559746, -0.042792, -1.471256>, <0.577497, -0.060536, -1.475834>, 
      <0.541357, 0.018436, -1.497905>, <0.541278, -0.007074, -1.498292>, <0.553155, -0.042792, -1.503785>, <0.570906, -0.060536, -1.508363>, 
      <0.517546, 0.018149, -1.542063>, <0.517467, -0.007634, -1.542455>, <0.534427, -0.048765, -1.547724>, <0.552721, -0.066489, -1.551733>, 
      <0.522567, 0.018436, -1.576193>, <0.522488, -0.007347, -1.576585>, <0.537232, -0.042812, -1.580255>, <0.555527, -0.060536, -1.584264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.679430, -0.097045, -1.416436>, <0.676018, -0.097045, -1.439896>, <0.668445, -0.097045, -1.470651>, <0.663737, -0.097045, -1.493886>, 
      <0.651443, -0.095249, -1.410765>, <0.648031, -0.095249, -1.434225>, <0.649073, -0.096214, -1.449611>, <0.644365, -0.096214, -1.472846>, 
      <0.613491, -0.080202, -1.402832>, <0.610079, -0.080202, -1.426293>, <0.602113, -0.080435, -1.457733>, <0.597405, -0.080435, -1.480968>, 
      <0.593191, -0.060536, -1.398384>, <0.589779, -0.060536, -1.421844>, <0.582205, -0.060536, -1.452599>, <0.577497, -0.060536, -1.475834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.755675, -0.070965, -1.431308>, <0.755526, -0.070965, -1.525955>, <0.839533, -0.070965, -1.647253>, <0.820737, -0.070965, -1.740015>, 
      <0.740492, -0.090103, -1.428561>, <0.740343, -0.090103, -1.523208>, <0.785225, -0.139419, -1.637429>, <0.766429, -0.139419, -1.730191>, 
      <0.703476, -0.098588, -1.421308>, <0.700064, -0.098588, -1.444769>, <0.727980, -0.099598, -1.535311>, <0.723272, -0.099598, -1.558546>, 
      <0.679430, -0.097045, -1.416436>, <0.676018, -0.097045, -1.439896>, <0.668445, -0.097045, -1.470651>, <0.663737, -0.097045, -1.493886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.770013, 0.017132, -1.432823>, <0.766601, 0.017132, -1.456283>, <0.759028, 0.017132, -1.487037>, <0.754320, 0.017132, -1.510272>, 
      <0.768828, -0.009622, -1.432985>, <0.765416, -0.009622, -1.456445>, <0.777158, -0.029180, -1.545110>, <0.772450, -0.029180, -1.568344>, 
      <0.772216, -0.050116, -1.434300>, <0.772066, -0.050116, -1.528947>, <0.886756, -0.011443, -1.655796>, <0.867960, -0.011443, -1.748557>, 
      <0.755675, -0.070965, -1.431308>, <0.755526, -0.070965, -1.525955>, <0.839533, -0.070965, -1.647253>, <0.820737, -0.070965, -1.740015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.763882, 0.114354, -1.430187>, <0.760470, 0.114354, -1.453647>, <0.752897, 0.114354, -1.484401>, <0.748189, 0.114354, -1.507635>, 
      <0.780831, 0.090840, -1.433993>, <0.777420, 0.090840, -1.457453>, <0.769846, 0.090840, -1.488207>, <0.765139, 0.090840, -1.511441>, 
      <0.771306, 0.046338, -1.432646>, <0.767895, 0.046338, -1.456106>, <0.752096, 0.034840, -1.464832>, <0.747388, 0.034840, -1.488067>, 
      <0.770013, 0.017132, -1.432823>, <0.766601, 0.017132, -1.456283>, <0.759028, 0.017132, -1.487037>, <0.754320, 0.017132, -1.510272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.680197, 0.141737, -1.412653>, <0.676785, 0.141737, -1.436113>, <0.669211, 0.141737, -1.466868>, <0.664503, 0.141737, -1.490103>, 
      <0.706594, 0.141535, -1.418001>, <0.703182, 0.141535, -1.441462>, <0.695608, 0.141535, -1.472217>, <0.690900, 0.141535, -1.495452>, 
      <0.748267, 0.136018, -1.426680>, <0.744855, 0.136018, -1.450140>, <0.737282, 0.136018, -1.480894>, <0.732574, 0.136018, -1.504129>, 
      <0.763882, 0.114354, -1.430187>, <0.760470, 0.114354, -1.453647>, <0.752897, 0.114354, -1.484401>, <0.748189, 0.114354, -1.507635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.593732, 0.115657, -1.395711>, <0.590320, 0.115657, -1.419171>, <0.582747, 0.115657, -1.449925>, <0.578039, 0.115657, -1.473159>, 
      <0.612795, 0.135250, -1.399261>, <0.609383, 0.135250, -1.422720>, <0.601442, 0.135479, -1.454106>, <0.596734, 0.135479, -1.477340>, 
      <0.653180, 0.141944, -1.407179>, <0.649768, 0.141944, -1.430639>, <0.642195, 0.141944, -1.461394>, <0.637487, 0.141944, -1.484629>, 
      <0.680197, 0.141737, -1.412653>, <0.676785, 0.141737, -1.436113>, <0.669211, 0.141737, -1.466868>, <0.664503, 0.141737, -1.490103>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.560231, 0.018436, -1.390315>, <0.557125, 0.018436, -1.412524>, <0.552661, 0.018436, -1.442115>, <0.548208, 0.018436, -1.464093>, 
      <0.560326, 0.049324, -1.389846>, <0.557220, 0.049324, -1.412056>, <0.552755, 0.049062, -1.441649>, <0.548302, 0.049062, -1.463628>, 
      <0.572369, 0.093700, -1.391733>, <0.568957, 0.093700, -1.415193>, <0.561974, 0.093633, -1.445279>, <0.557266, 0.093633, -1.468513>, 
      <0.593732, 0.115657, -1.395711>, <0.590320, 0.115657, -1.419171>, <0.582747, 0.115657, -1.449925>, <0.578039, 0.115657, -1.473159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.560231, 0.018436, -1.390315>, <0.560152, -0.007347, -1.390706>, <0.574896, -0.042812, -1.394375>, <0.593191, -0.060536, -1.398384>, 
      <0.557125, 0.018436, -1.412524>, <0.557046, -0.007347, -1.412916>, <0.571484, -0.042812, -1.417835>, <0.589779, -0.060536, -1.421844>, 
      <0.552661, 0.018436, -1.442115>, <0.552583, -0.007074, -1.442502>, <0.564454, -0.042792, -1.448021>, <0.582205, -0.060536, -1.452599>, 
      <0.548208, 0.018436, -1.464093>, <0.548129, -0.007074, -1.464481>, <0.559746, -0.042792, -1.471256>, <0.577497, -0.060536, -1.475834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.745749, -0.097045, -0.929976>, <0.719989, -0.096511, -1.074993>, <0.700628, -0.097045, -1.270681>, <0.679430, -0.097045, -1.416436>, 
      <0.717762, -0.095249, -0.924305>, <0.692002, -0.094715, -1.069322>, <0.672641, -0.095249, -1.265011>, <0.651443, -0.095249, -1.410765>, 
      <0.679809, -0.080203, -0.916373>, <0.657961, -0.076667, -1.061988>, <0.634688, -0.080202, -1.257078>, <0.613491, -0.080202, -1.402832>, 
      <0.659509, -0.060536, -0.911924>, <0.637661, -0.057001, -1.057540>, <0.614389, -0.060536, -1.252630>, <0.593191, -0.060536, -1.398384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.821993, -0.070965, -0.944847>, <0.799056, -0.066984, -1.090284>, <0.755908, -0.070965, -1.284020>, <0.755675, -0.070965, -1.431308>, 
      <0.806810, -0.090103, -0.942101>, <0.783874, -0.086121, -1.087538>, <0.740725, -0.090103, -1.281273>, <0.740492, -0.090103, -1.428561>, 
      <0.769794, -0.098588, -0.934848>, <0.744034, -0.098055, -1.079865>, <0.724673, -0.098588, -1.275554>, <0.703476, -0.098588, -1.421308>, 
      <0.745749, -0.097045, -0.929976>, <0.719989, -0.096511, -1.074993>, <0.700628, -0.097045, -1.270681>, <0.679430, -0.097045, -1.416436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.836331, 0.017132, -0.946361>, <0.812779, 0.017354, -1.091754>, <0.791211, 0.017132, -1.287068>, <0.770013, 0.017132, -1.432823>, 
      <0.835146, -0.009622, -0.946523>, <0.811594, -0.009399, -1.091916>, <0.790026, -0.009622, -1.287230>, <0.768828, -0.009622, -1.432985>, 
      <0.838533, -0.050116, -0.947839>, <0.815597, -0.046135, -1.093276>, <0.772448, -0.050116, -1.287012>, <0.772216, -0.050116, -1.434300>, 
      <0.821993, -0.070965, -0.944847>, <0.799056, -0.066984, -1.090284>, <0.755908, -0.070965, -1.284020>, <0.755675, -0.070965, -1.431308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.830199, 0.114354, -0.943725>, <0.806928, 0.110431, -1.089111>, <0.785079, 0.114354, -1.284432>, <0.763882, 0.114354, -1.430187>, 
      <0.847148, 0.090840, -0.947531>, <0.823878, 0.086917, -1.092917>, <0.802029, 0.090840, -1.288238>, <0.780831, 0.090840, -1.433993>, 
      <0.837624, 0.046338, -0.946184>, <0.814072, 0.046561, -1.091577>, <0.792504, 0.046338, -1.286891>, <0.771306, 0.046338, -1.432646>, 
      <0.836331, 0.017132, -0.946361>, <0.812779, 0.017354, -1.091754>, <0.791211, 0.017132, -1.287068>, <0.770013, 0.017132, -1.432823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.746515, 0.141737, -0.926192>, <0.720751, 0.142354, -1.071208>, <0.701395, 0.141737, -1.266898>, <0.680197, 0.141737, -1.412653>, 
      <0.772911, 0.141535, -0.931540>, <0.747148, 0.142152, -1.076557>, <0.727792, 0.141535, -1.272247>, <0.706594, 0.141535, -1.418001>, 
      <0.814584, 0.136017, -0.940218>, <0.791313, 0.132094, -1.085604>, <0.769464, 0.136018, -1.280925>, <0.748267, 0.136018, -1.426680>, 
      <0.830199, 0.114354, -0.943725>, <0.806928, 0.110431, -1.089111>, <0.785079, 0.114354, -1.284432>, <0.763882, 0.114354, -1.430187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.660051, 0.115657, -0.909249>, <0.638198, 0.111680, -1.054853>, <0.614930, 0.115657, -1.249956>, <0.593732, 0.115657, -1.395711>, 
      <0.679114, 0.135250, -0.912799>, <0.657262, 0.131273, -1.058403>, <0.633993, 0.135250, -1.253505>, <0.612795, 0.135250, -1.399261>, 
      <0.719499, 0.141944, -0.920718>, <0.693735, 0.142561, -1.065734>, <0.674378, 0.141944, -1.261424>, <0.653180, 0.141944, -1.407179>, 
      <0.746515, 0.141737, -0.926192>, <0.720751, 0.142354, -1.071208>, <0.701395, 0.141737, -1.266898>, <0.680197, 0.141737, -1.412653>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626549, 0.018436, -0.903853>, <0.606120, 0.018603, -1.049718>, <0.580629, 0.018436, -1.244446>, <0.560231, 0.018436, -1.390315>, 
      <0.626644, 0.049324, -0.903384>, <0.606215, 0.049491, -1.049249>, <0.580723, 0.049324, -1.243977>, <0.560326, 0.049324, -1.389846>, 
      <0.638688, 0.093700, -0.905271>, <0.616835, 0.089723, -1.050875>, <0.593567, 0.093700, -1.245978>, <0.572369, 0.093700, -1.391733>, 
      <0.660051, 0.115657, -0.909249>, <0.638198, 0.111680, -1.054853>, <0.614930, 0.115657, -1.249956>, <0.593732, 0.115657, -1.395711>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626549, 0.018436, -0.903853>, <0.626470, -0.007347, -0.904244>, <0.641214, -0.042812, -0.907915>, <0.659509, -0.060536, -0.911924>, 
      <0.606120, 0.018603, -1.049718>, <0.606041, -0.007180, -1.050109>, <0.619366, -0.039276, -1.053530>, <0.637661, -0.057001, -1.057540>, 
      <0.580629, 0.018436, -1.244446>, <0.580550, -0.007347, -1.244837>, <0.596094, -0.042812, -1.248620>, <0.614389, -0.060536, -1.252630>, 
      <0.560231, 0.018436, -1.390315>, <0.560152, -0.007347, -1.390706>, <0.574896, -0.042812, -1.394375>, <0.593191, -0.060536, -1.398384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.780899, -0.099147, -0.845213>, <0.773180, -0.098451, -0.871636>, <0.750565, -0.097145, -0.902865>, <0.745749, -0.097045, -0.929976>, 
      <0.749541, -0.096854, -0.838848>, <0.741823, -0.096158, -0.865270>, <0.722578, -0.095348, -0.897194>, <0.717762, -0.095249, -0.924305>, 
      <0.704172, -0.094830, -0.825639>, <0.696641, -0.094326, -0.853324>, <0.684065, -0.080891, -0.888003>, <0.679809, -0.080203, -0.916373>, 
      <0.680037, -0.074589, -0.819565>, <0.672506, -0.074085, -0.847250>, <0.663766, -0.061225, -0.883555>, <0.659509, -0.060536, -0.911924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.846813, -0.086785, -0.853419>, <0.838283, -0.086217, -0.880936>, <0.826480, -0.071744, -0.916395>, <0.821993, -0.070965, -0.944847>, 
      <0.835036, -0.103221, -0.851998>, <0.826507, -0.102652, -0.879515>, <0.811298, -0.090881, -0.913648>, <0.806810, -0.090103, -0.942101>, 
      <0.800712, -0.100596, -0.849235>, <0.792993, -0.099900, -0.875657>, <0.774610, -0.098688, -0.907737>, <0.769794, -0.098588, -0.934848>, 
      <0.780899, -0.099147, -0.845213>, <0.773180, -0.098451, -0.871636>, <0.750565, -0.097145, -0.902865>, <0.745749, -0.097045, -0.929976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.863583, 0.016248, -0.855190>, <0.855049, 0.016279, -0.882433>, <0.840896, 0.017089, -0.918180>, <0.836331, 0.017132, -0.946361>, 
      <0.862197, -0.015042, -0.855379>, <0.853663, -0.015011, -0.882622>, <0.839711, -0.009665, -0.918342>, <0.835146, -0.009622, -0.946523>, 
      <0.865011, -0.061388, -0.855615>, <0.856481, -0.060819, -0.883132>, <0.843021, -0.050895, -0.919386>, <0.838533, -0.050116, -0.947839>, 
      <0.846813, -0.086785, -0.853419>, <0.838283, -0.086217, -0.880936>, <0.826480, -0.071744, -0.916395>, <0.821993, -0.070965, -0.944847>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.856411, 0.129952, -0.852107>, <0.847792, 0.129389, -0.879758>, <0.834776, 0.115126, -0.915131>, <0.830199, 0.114354, -0.943725>, 
      <0.875248, 0.101611, -0.855424>, <0.866629, 0.101048, -0.883075>, <0.851725, 0.091611, -0.918937>, <0.847148, 0.090840, -0.947531>, 
      <0.865096, 0.050405, -0.854983>, <0.856562, 0.050437, -0.882226>, <0.842189, 0.046295, -0.918003>, <0.837624, 0.046338, -0.946184>, 
      <0.863583, 0.016248, -0.855190>, <0.855049, 0.016279, -0.882433>, <0.840896, 0.017089, -0.918180>, <0.836331, 0.017132, -0.946361>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.781795, 0.139303, -0.840788>, <0.774023, 0.138603, -0.867398>, <0.751366, 0.141621, -0.898889>, <0.746515, 0.141737, -0.926192>, 
      <0.804152, 0.139109, -0.845326>, <0.796380, 0.138409, -0.871936>, <0.777762, 0.141419, -0.904238>, <0.772911, 0.141535, -0.931540>, 
      <0.843842, 0.148863, -0.849894>, <0.835223, 0.148300, -0.877545>, <0.819161, 0.136789, -0.911624>, <0.814584, 0.136017, -0.940218>, 
      <0.856411, 0.129952, -0.852107>, <0.847792, 0.129389, -0.879758>, <0.834776, 0.115126, -0.915131>, <0.830199, 0.114354, -0.943725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.680671, 0.131478, -0.816436>, <0.673084, 0.130907, -0.844332>, <0.664341, 0.116438, -0.880665>, <0.660051, 0.115657, -0.909249>, 
      <0.704008, 0.151692, -0.821536>, <0.696421, 0.151121, -0.849432>, <0.683404, 0.136031, -0.884215>, <0.679114, 0.135250, -0.912799>, 
      <0.751129, 0.139569, -0.834564>, <0.743357, 0.138869, -0.861174>, <0.724349, 0.141828, -0.893415>, <0.719499, 0.141944, -0.920718>, 
      <0.781795, 0.139303, -0.840788>, <0.774023, 0.138603, -0.867398>, <0.751366, 0.141621, -0.898889>, <0.746515, 0.141737, -0.926192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.641489, 0.017772, -0.810126>, <0.634213, 0.017796, -0.837654>, <0.630498, 0.018404, -0.875655>, <0.626549, 0.018436, -0.903853>, 
      <0.641600, 0.053898, -0.809577>, <0.634324, 0.053921, -0.837106>, <0.630593, 0.049292, -0.875185>, <0.626644, 0.049324, -0.903384>, 
      <0.653727, 0.108139, -0.810548>, <0.646139, 0.107568, -0.838444>, <0.642978, 0.094481, -0.876687>, <0.638688, 0.093700, -0.905271>, 
      <0.680671, 0.131478, -0.816436>, <0.673084, 0.130907, -0.844332>, <0.664341, 0.116438, -0.880665>, <0.660051, 0.115657, -0.909249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.641489, 0.017772, -0.810126>, <0.641396, -0.012382, -0.810584>, <0.657348, -0.055560, -0.813855>, <0.680037, -0.074589, -0.819565>, 
      <0.634213, 0.017796, -0.837654>, <0.634120, -0.012359, -0.838112>, <0.649817, -0.055056, -0.841539>, <0.672506, -0.074085, -0.847250>, 
      <0.630498, 0.018404, -0.875655>, <0.630419, -0.007379, -0.876046>, <0.645471, -0.043501, -0.879545>, <0.663766, -0.061225, -0.883555>, 
      <0.626549, 0.018436, -0.903853>, <0.626470, -0.007347, -0.904244>, <0.641214, -0.042812, -0.907915>, <0.659509, -0.060536, -0.911924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.799099, -0.101856, -0.747356>, <0.788059, -0.097107, -0.774703>, <0.789273, -0.099902, -0.816549>, <0.780899, -0.099147, -0.845213>, 
      <0.769985, -0.099988, -0.741457>, <0.758944, -0.095239, -0.768804>, <0.757915, -0.097609, -0.810184>, <0.749541, -0.096854, -0.838848>, 
      <0.730503, -0.084334, -0.733205>, <0.719431, -0.082378, -0.759786>, <0.711746, -0.095337, -0.797795>, <0.704172, -0.094830, -0.825639>, 
      <0.709385, -0.063875, -0.728577>, <0.698313, -0.061919, -0.755158>, <0.687612, -0.075096, -0.791721>, <0.680037, -0.074589, -0.819565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.878414, -0.074723, -0.762826>, <0.865518, -0.070862, -0.788524>, <0.855401, -0.087357, -0.825715>, <0.846813, -0.086785, -0.853419>, 
      <0.862620, -0.094632, -0.759969>, <0.849724, -0.090770, -0.785667>, <0.843624, -0.103793, -0.824294>, <0.835036, -0.103221, -0.851998>, 
      <0.824113, -0.103461, -0.752424>, <0.813073, -0.098712, -0.779772>, <0.809086, -0.101351, -0.820571>, <0.800712, -0.100596, -0.849235>, 
      <0.799099, -0.101856, -0.747356>, <0.788059, -0.097107, -0.774703>, <0.789273, -0.099902, -0.816549>, <0.780899, -0.099147, -0.845213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.893331, 0.016922, -0.764401>, <0.879729, 0.017136, -0.789629>, <0.872151, 0.016216, -0.827838>, <0.863583, 0.016248, -0.855190>, 
      <0.892098, -0.010910, -0.764569>, <0.878496, -0.010695, -0.789797>, <0.870765, -0.015074, -0.828028>, <0.862197, -0.015042, -0.855379>, 
      <0.895621, -0.053034, -0.765938>, <0.882725, -0.049173, -0.791637>, <0.873599, -0.061960, -0.827910>, <0.865011, -0.061388, -0.855615>, 
      <0.878414, -0.074723, -0.762826>, <0.865518, -0.070862, -0.788524>, <0.855401, -0.087357, -0.825715>, <0.846813, -0.086785, -0.853419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886952, 0.118060, -0.761660>, <0.872988, 0.114259, -0.786630>, <0.864998, 0.130513, -0.824559>, <0.856411, 0.129952, -0.852107>, 
      <0.904584, 0.093598, -0.765619>, <0.890620, 0.089797, -0.790589>, <0.883835, 0.102172, -0.827876>, <0.875248, 0.101611, -0.855424>, 
      <0.894677, 0.047304, -0.764217>, <0.881074, 0.047519, -0.789445>, <0.873664, 0.050374, -0.827632>, <0.865096, 0.050405, -0.854983>, 
      <0.893331, 0.016922, -0.764401>, <0.879729, 0.017136, -0.789629>, <0.872151, 0.016216, -0.827838>, <0.863583, 0.016248, -0.855190>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.799896, 0.146547, -0.743420>, <0.788807, 0.141574, -0.770619>, <0.790144, 0.140055, -0.812202>, <0.781795, 0.139303, -0.840788>, 
      <0.827356, 0.146337, -0.748984>, <0.816267, 0.141364, -0.776183>, <0.812501, 0.139861, -0.816740>, <0.804152, 0.139109, -0.845326>, 
      <0.870708, 0.140596, -0.758012>, <0.856744, 0.136795, -0.782982>, <0.852429, 0.149423, -0.822346>, <0.843842, 0.148863, -0.849894>, 
      <0.886952, 0.118060, -0.761660>, <0.872988, 0.114259, -0.786630>, <0.864998, 0.130513, -0.824559>, <0.856411, 0.129952, -0.852107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.709949, 0.119415, -0.725794>, <0.698856, 0.117223, -0.752286>, <0.688229, 0.132047, -0.788647>, <0.680671, 0.131478, -0.816436>, 
      <0.729780, 0.139798, -0.729487>, <0.718687, 0.137606, -0.755979>, <0.711566, 0.152261, -0.793747>, <0.704008, 0.151692, -0.821536>, 
      <0.771791, 0.146762, -0.737725>, <0.760702, 0.141789, -0.764924>, <0.759478, 0.140322, -0.805977>, <0.751129, 0.139569, -0.834564>, 
      <0.799896, 0.146547, -0.743420>, <0.788807, 0.141574, -0.770619>, <0.790144, 0.140055, -0.812202>, <0.781795, 0.139303, -0.840788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675098, 0.018278, -0.720181>, <0.664733, 0.018368, -0.747058>, <0.648850, 0.017748, -0.782276>, <0.641489, 0.017772, -0.810126>, 
      <0.675197, 0.050410, -0.719693>, <0.664832, 0.050500, -0.746570>, <0.648962, 0.053874, -0.781728>, <0.641600, 0.053898, -0.809577>, 
      <0.687726, 0.096574, -0.721656>, <0.676633, 0.094382, -0.748148>, <0.661285, 0.108709, -0.782759>, <0.653727, 0.108139, -0.810548>, 
      <0.709949, 0.119415, -0.725794>, <0.698856, 0.117223, -0.752286>, <0.688229, 0.132047, -0.788647>, <0.680671, 0.131478, -0.816436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675098, 0.018278, -0.720181>, <0.675015, -0.008544, -0.720588>, <0.690353, -0.045437, -0.724406>, <0.709385, -0.063875, -0.728577>, 
      <0.664733, 0.018368, -0.747058>, <0.664651, -0.008453, -0.747465>, <0.679282, -0.043481, -0.750987>, <0.698313, -0.061919, -0.755158>, 
      <0.648850, 0.017748, -0.782276>, <0.648758, -0.012406, -0.782734>, <0.664922, -0.056067, -0.786010>, <0.687612, -0.075096, -0.791721>, 
      <0.641489, 0.017772, -0.810126>, <0.641396, -0.012382, -0.810584>, <0.657348, -0.055560, -0.813855>, <0.680037, -0.074589, -0.819565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.970104, -0.180532, -0.376548>, <0.889770, -0.137741, -0.461866>, <0.845208, -0.121689, -0.633144>, <0.799099, -0.101856, -0.747356>, 
      <0.956473, -0.177634, -0.327252>, <0.876138, -0.134843, -0.412570>, <0.816093, -0.119821, -0.627244>, <0.769985, -0.099988, -0.741457>, 
      <0.944820, -0.153888, -0.256243>, <0.829108, -0.145146, -0.375117>, <0.794231, -0.095593, -0.580206>, <0.730503, -0.084334, -0.733205>, 
      <0.928530, -0.118492, -0.222986>, <0.812818, -0.109750, -0.341860>, <0.773114, -0.075134, -0.575578>, <0.709385, -0.063875, -0.728577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.011892, -0.136213, -0.524452>, <0.951960, -0.093712, -0.565189>, <0.915758, -0.085905, -0.688407>, <0.878414, -0.074723, -0.762826>, 
      <0.999003, -0.172488, -0.495804>, <0.939071, -0.129987, -0.536541>, <0.899964, -0.105813, -0.685550>, <0.862620, -0.094632, -0.759969>, 
      <0.982873, -0.183246, -0.422725>, <0.902539, -0.140456, -0.508043>, <0.870222, -0.123295, -0.638212>, <0.824113, -0.103461, -0.752424>, 
      <0.970104, -0.180532, -0.376548>, <0.889770, -0.137741, -0.461866>, <0.845208, -0.121689, -0.633144>, <0.799099, -0.101856, -0.747356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039041, 0.013486, -0.529772>, <0.985206, 0.017418, -0.592643>, <0.932656, 0.016303, -0.691465>, <0.893331, 0.016922, -0.764401>, 
      <1.035634, -0.032044, -0.528688>, <0.981799, -0.028112, -0.591559>, <0.931424, -0.011529, -0.691634>, <0.892098, -0.010910, -0.764569>, 
      <1.024159, -0.101689, -0.551717>, <0.964226, -0.059188, -0.592454>, <0.932964, -0.064216, -0.691520>, <0.895621, -0.053034, -0.765938>, 
      <1.011892, -0.136213, -0.524452>, <0.951960, -0.093712, -0.565189>, <0.915758, -0.085905, -0.688407>, <0.878414, -0.074723, -0.762826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.035455, 0.178690, -0.531947>, <0.979646, 0.153260, -0.589422>, <0.927620, 0.129130, -0.688939>, <0.886952, 0.118060, -0.761660>, 
      <1.047389, 0.140203, -0.560830>, <0.991580, 0.114774, -0.618306>, <0.945252, 0.104669, -0.692898>, <0.904584, 0.093598, -0.765619>, 
      <1.042739, 0.062911, -0.530948>, <0.988904, 0.066843, -0.593819>, <0.934002, 0.046685, -0.691282>, <0.894677, 0.047304, -0.764217>, 
      <1.039041, 0.013486, -0.529772>, <0.985206, 0.017418, -0.592643>, <0.932656, 0.016303, -0.691465>, <0.893331, 0.016922, -0.764401>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.973384, 0.225224, -0.370867>, <0.906094, 0.181163, -0.467243>, <0.846622, 0.167502, -0.628812>, <0.799896, 0.146547, -0.743420>, 
      <0.990386, 0.224864, -0.421736>, <0.923096, 0.180803, -0.518112>, <0.874082, 0.167292, -0.634376>, <0.827356, 0.146337, -0.748984>, 
      <1.022544, 0.220328, -0.500699>, <0.966735, 0.194898, -0.558174>, <0.911376, 0.151667, -0.685292>, <0.870708, 0.140596, -0.758012>, 
      <1.035455, 0.178690, -0.531947>, <0.979646, 0.153260, -0.589422>, <0.927620, 0.129130, -0.688939>, <0.886952, 0.118060, -0.761660>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.930850, 0.180905, -0.218969>, <0.830269, 0.160498, -0.350565>, <0.774219, 0.132113, -0.572306>, <0.709949, 0.119415, -0.725794>, 
      <0.946667, 0.216315, -0.249170>, <0.846087, 0.195909, -0.380766>, <0.794050, 0.152495, -0.575999>, <0.729780, 0.139798, -0.729487>, 
      <0.957803, 0.225554, -0.324248>, <0.890513, 0.181493, -0.420624>, <0.818518, 0.167717, -0.623117>, <0.771791, 0.146762, -0.737725>, 
      <0.973384, 0.225224, -0.370867>, <0.906094, 0.181163, -0.467243>, <0.846622, 0.167502, -0.628812>, <0.799896, 0.146547, -0.743420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.879793, 0.015701, -0.192170>, <0.774750, 0.018652, -0.325664>, <0.736226, 0.017747, -0.561668>, <0.675098, 0.018278, -0.720181>, 
      <0.880200, 0.068188, -0.191466>, <0.775157, 0.071139, -0.324959>, <0.736325, 0.049879, -0.561180>, <0.675197, 0.050410, -0.719693>, 
      <0.913958, 0.143089, -0.186717>, <0.813377, 0.122682, -0.318313>, <0.751996, 0.109271, -0.568168>, <0.687726, 0.096574, -0.721656>, 
      <0.930850, 0.180905, -0.218969>, <0.830269, 0.160498, -0.350565>, <0.774219, 0.132113, -0.572306>, <0.709949, 0.119415, -0.725794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.879793, 0.015701, -0.192170>, <0.879454, -0.028111, -0.192758>, <0.914597, -0.088217, -0.194540>, <0.928530, -0.118492, -0.222986>, 
      <0.774750, 0.018652, -0.325664>, <0.774411, -0.025160, -0.326251>, <0.798885, -0.079474, -0.313414>, <0.812818, -0.109750, -0.341860>, 
      <0.736226, 0.017747, -0.561668>, <0.736143, -0.009075, -0.562075>, <0.754082, -0.056696, -0.571407>, <0.773114, -0.075134, -0.575578>, 
      <0.675098, 0.018278, -0.720181>, <0.675015, -0.008544, -0.720588>, <0.690353, -0.045437, -0.724406>, <0.709385, -0.063875, -0.728577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.353500, -0.245619>, <1.167853, -0.317964, -0.265652>, <1.041846, -0.218746, -0.300356>, <0.970104, -0.180532, -0.376548>, 
      <1.295594, -0.307733, -0.154558>, <1.191919, -0.272197, -0.174592>, <1.028214, -0.215848, -0.251060>, <0.956473, -0.177634, -0.327252>, 
      <1.404622, -0.202238, -0.081199>, <1.280854, -0.206203, -0.170587>, <1.051199, -0.161925, -0.146958>, <0.944820, -0.153888, -0.256243>, 
      <1.396527, -0.115790, -0.022657>, <1.272759, -0.119755, -0.112045>, <1.034909, -0.126529, -0.113700>, <0.928530, -0.118492, -0.222986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.353500, -0.495619>, <1.295616, -0.411630, -0.454807>, <1.254290, -0.386279, -0.310837>, <1.271527, -0.353500, -0.245619>, 
      <1.275822, -0.355867, -0.499277>, <1.299911, -0.413998, -0.458466>, <1.150616, -0.350743, -0.330871>, <1.167853, -0.317964, -0.265652>, 
      <1.084612, -0.187783, -0.475023>, <1.071723, -0.224058, -0.446374>, <1.054615, -0.221460, -0.346533>, <1.041846, -0.218746, -0.300356>, 
      <1.011892, -0.136213, -0.524452>, <0.999003, -0.172488, -0.495804>, <0.982873, -0.183246, -0.422725>, <0.970104, -0.180532, -0.376548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.125038, 0.000000, -0.493804>, <1.151197, -0.111757, -0.491725>, <1.234656, -0.264525, -0.558087>, <1.271527, -0.353500, -0.495619>, 
      <1.105511, 0.001248, -0.473419>, <1.131670, -0.110509, -0.471341>, <1.238951, -0.266892, -0.561745>, <1.275822, -0.355867, -0.499277>, 
      <1.057398, 0.012145, -0.508334>, <1.053991, -0.033385, -0.507250>, <1.096879, -0.153259, -0.502288>, <1.084612, -0.187783, -0.475023>, 
      <1.039041, 0.013486, -0.529772>, <1.035634, -0.032044, -0.528688>, <1.024159, -0.101689, -0.551717>, <1.011892, -0.136213, -0.524452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.613971, -0.015930, -1.755286>, <2.613971, -0.015930, -1.755286>, <2.640099, -0.004978, -1.751283>, <2.640099, -0.004978, -1.751283>, 
      <2.596462, -0.073057, -1.653625>, <2.624715, -0.071260, -1.649482>, <2.643757, -0.064322, -1.646482>, <2.664268, -0.044656, -1.643142>, 
      <2.583153, -0.099504, -1.571086>, <2.611406, -0.097708, -1.566942>, <2.649734, -0.082661, -1.561082>, <2.670245, -0.062995, -1.557741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.590889, -0.008106, -1.758500>, <2.590889, -0.008106, -1.758500>, <2.613971, -0.015930, -1.755286>, <2.613971, -0.015930, -1.755286>, 
      <2.582205, -0.047599, -1.619135>, <2.597514, -0.066737, -1.617217>, <2.572187, -0.074600, -1.657185>, <2.596462, -0.073057, -1.653625>, 
      <2.506214, -0.073423, -1.581797>, <2.521524, -0.092561, -1.579879>, <2.558878, -0.101047, -1.574646>, <2.583153, -0.099504, -1.571086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.586570, 0.018323, -1.758720>, <2.586570, 0.018323, -1.758720>, <2.590889, -0.008106, -1.758500>, <2.590889, -0.008106, -1.758500>, 
      <2.524967, 0.015815, -1.661605>, <2.526141, -0.010939, -1.661831>, <2.565526, -0.026751, -1.621224>, <2.582205, -0.047599, -1.619135>, 
      <2.491814, 0.014673, -1.582530>, <2.492989, -0.012081, -1.582756>, <2.489536, -0.052575, -1.583887>, <2.506214, -0.073423, -1.581797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.588449, 0.047489, -1.758030>, <2.588449, 0.047489, -1.758030>, <2.586570, 0.018323, -1.758720>, <2.586570, 0.018323, -1.758720>, 
      <2.530509, 0.091339, -1.661435>, <2.513378, 0.067824, -1.664316>, <2.523685, 0.045021, -1.661358>, <2.524967, 0.015815, -1.661605>, 
      <2.498080, 0.111895, -1.580232>, <2.480949, 0.088381, -1.583112>, <2.490532, 0.043879, -1.582283>, <2.491814, 0.014673, -1.582530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.613803, 0.055705, -1.754140>, <2.613803, 0.055705, -1.754140>, <2.588449, 0.047489, -1.758030>, <2.588449, 0.047489, -1.758030>, 
      <2.596062, 0.112759, -1.650880>, <2.569414, 0.112557, -1.654788>, <2.546292, 0.113002, -1.658781>, <2.530509, 0.091339, -1.661435>, 
      <2.582593, 0.139279, -1.567266>, <2.555945, 0.139077, -1.571174>, <2.513862, 0.133559, -1.577578>, <2.498080, 0.111895, -1.580232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.639980, 0.047880, -1.750473>, <2.639980, 0.047880, -1.750473>, <2.613803, 0.055705, -1.754140>, <2.613803, 0.055705, -1.754140>, 
      <2.663920, 0.092412, -1.641617>, <2.644692, 0.112005, -1.644127>, <2.623336, 0.112966, -1.646880>, <2.596062, 0.112759, -1.650880>, 
      <2.669849, 0.113198, -1.555041>, <2.650622, 0.132791, -1.557551>, <2.609867, 0.139486, -1.563266>, <2.582593, 0.139279, -1.567266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, <2.627179, 0.019887, -1.834230>, 
      <2.650104, 0.018714, -1.749402>, <2.650104, 0.018714, -1.749402>, <2.639980, 0.047880, -1.750473>, <2.639980, 0.047880, -1.750473>, 
      <2.690228, 0.016843, -1.638323>, <2.690159, 0.047731, -1.637849>, <2.685467, 0.070455, -1.638805>, <2.663920, 0.092412, -1.641617>, 
      <2.703595, 0.015977, -1.551471>, <2.703525, 0.046865, -1.550998>, <2.691397, 0.091241, -1.552229>, <2.669849, 0.113198, -1.555041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, 0.019887, -1.834230>, <2.650104, 0.018714, -1.749402>, <2.690228, 0.016843, -1.638323>, <2.703595, 0.015977, -1.551471>, 
      <2.627179, 0.019887, -1.834230>, <2.650104, 0.018714, -1.749402>, <2.690286, -0.008940, -1.638718>, <2.703653, -0.009806, -1.551866>, 
      <2.627179, 0.019887, -1.834230>, <2.640099, -0.004978, -1.751283>, <2.682754, -0.026931, -1.640131>, <2.688731, -0.045271, -1.554731>, 
      <2.627179, 0.019887, -1.834230>, <2.640099, -0.004978, -1.751283>, <2.664268, -0.044656, -1.643142>, <2.670245, -0.062995, -1.557741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.567100, -0.099504, -1.461624>, <2.571916, -0.099504, -1.494462>, <2.578116, -0.109514, -1.539845>, <2.583153, -0.099504, -1.571086>, 
      <2.589083, -0.098744, -1.443326>, <2.593899, -0.098744, -1.476164>, <2.606369, -0.107718, -1.535702>, <2.611406, -0.097708, -1.566942>, 
      <2.633681, -0.082662, -1.451619>, <2.638497, -0.082662, -1.484458>, <2.652000, -0.089614, -1.528707>, <2.649734, -0.082661, -1.561082>, 
      <2.654192, -0.062995, -1.448279>, <2.659009, -0.062995, -1.481118>, <2.672511, -0.069947, -1.525367>, <2.670245, -0.062995, -1.557741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.352597, -0.073423, -1.699316>, <2.361016, -0.073423, -1.756727>, <2.456402, -0.090351, -1.557323>, <2.506214, -0.073423, -1.581797>, 
      <2.412613, -0.148446, -1.691796>, <2.421033, -0.148446, -1.749207>, <2.471711, -0.109488, -1.555404>, <2.521524, -0.092561, -1.579879>, 
      <2.493058, -0.102064, -1.523254>, <2.497874, -0.102064, -1.556092>, <2.553841, -0.111058, -1.543405>, <2.558878, -0.101047, -1.574646>, 
      <2.567100, -0.099504, -1.461624>, <2.571916, -0.099504, -1.494462>, <2.578116, -0.109514, -1.539845>, <2.583153, -0.099504, -1.571086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.475761, 0.014673, -1.473068>, <2.480577, 0.014673, -1.505907>, <2.478983, 0.014231, -1.551924>, <2.491814, 0.014673, -1.582530>, 
      <2.442875, -0.032413, -1.531138>, <2.447691, -0.032413, -1.563976>, <2.480157, -0.012523, -1.552150>, <2.492989, -0.012081, -1.582756>, 
      <2.301732, -0.009840, -1.705690>, <2.310151, -0.009840, -1.763100>, <2.439723, -0.069502, -1.559412>, <2.489536, -0.052575, -1.583887>, 
      <2.352597, -0.073423, -1.699316>, <2.361016, -0.073423, -1.756727>, <2.456402, -0.090351, -1.557323>, <2.506214, -0.073423, -1.581797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.482027, 0.111895, -1.470770>, <2.486843, 0.111895, -1.503608>, <2.486097, 0.119491, -1.550227>, <2.498080, 0.111895, -1.580232>, 
      <2.464896, 0.088381, -1.473650>, <2.469712, 0.088381, -1.506489>, <2.468966, 0.095976, -1.553108>, <2.480949, 0.088381, -1.583112>, 
      <2.487533, 0.031527, -1.452282>, <2.492348, 0.031527, -1.485121>, <2.477701, 0.043437, -1.551677>, <2.490532, 0.043879, -1.582283>, 
      <2.475761, 0.014673, -1.473068>, <2.480577, 0.014673, -1.505907>, <2.478983, 0.014231, -1.551924>, <2.491814, 0.014673, -1.582530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.566540, 0.139279, -1.457804>, <2.571356, 0.139279, -1.490643>, <2.577556, 0.149197, -1.535996>, <2.582593, 0.139279, -1.567266>, 
      <2.539892, 0.139077, -1.461713>, <2.544708, 0.139077, -1.494551>, <2.550907, 0.148995, -1.539904>, <2.555945, 0.139077, -1.571174>, 
      <2.497809, 0.133559, -1.468116>, <2.502625, 0.133559, -1.500955>, <2.501880, 0.141154, -1.547573>, <2.513862, 0.133559, -1.577578>, 
      <2.482027, 0.111895, -1.470770>, <2.486843, 0.111895, -1.503608>, <2.486097, 0.119491, -1.550227>, <2.498080, 0.111895, -1.580232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.653796, 0.113198, -1.445579>, <2.658612, 0.113198, -1.478418>, <2.672055, 0.120929, -1.522840>, <2.669849, 0.113198, -1.555041>, 
      <2.634569, 0.132791, -1.448089>, <2.639385, 0.132791, -1.480928>, <2.652827, 0.140522, -1.525349>, <2.650622, 0.132791, -1.557551>, 
      <2.593814, 0.139486, -1.453805>, <2.598629, 0.139486, -1.486643>, <2.604830, 0.149404, -1.531996>, <2.609867, 0.139486, -1.563266>, 
      <2.566540, 0.139279, -1.457804>, <2.571356, 0.139279, -1.490643>, <2.577556, 0.149197, -1.535996>, <2.582593, 0.139279, -1.567266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.687542, 0.015977, -1.442010>, <2.692358, 0.015977, -1.474848>, <2.708643, 0.015650, -1.518669>, <2.703595, 0.015977, -1.551471>, 
      <2.687472, 0.046865, -1.441536>, <2.692288, 0.046865, -1.474375>, <2.708574, 0.046538, -1.518196>, <2.703525, 0.046865, -1.550998>, 
      <2.675344, 0.091241, -1.442766>, <2.680160, 0.091241, -1.475605>, <2.693602, 0.098972, -1.520027>, <2.691397, 0.091241, -1.552229>, 
      <2.653796, 0.113198, -1.445579>, <2.658612, 0.113198, -1.478418>, <2.672055, 0.120929, -1.522840>, <2.669849, 0.113198, -1.555041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.687542, 0.015977, -1.442010>, <2.687600, -0.009806, -1.442405>, <2.672678, -0.045271, -1.445269>, <2.654192, -0.062995, -1.448279>, 
      <2.692358, 0.015977, -1.474848>, <2.692415, -0.009806, -1.475243>, <2.677494, -0.045271, -1.478107>, <2.659009, -0.062995, -1.481118>, 
      <2.708643, 0.015650, -1.518669>, <2.708701, -0.010133, -1.519064>, <2.690997, -0.052223, -1.522356>, <2.672511, -0.069947, -1.525367>, 
      <2.703595, 0.015977, -1.551471>, <2.703653, -0.009806, -1.551866>, <2.688731, -0.045271, -1.554731>, <2.670245, -0.062995, -1.557741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.555634, -0.099504, -1.383437>, <2.559394, -0.099504, -1.406844>, <2.563660, -0.099504, -1.438168>, <2.567100, -0.099504, -1.461624>, 
      <2.583887, -0.097708, -1.379294>, <2.587648, -0.097708, -1.402700>, <2.585643, -0.098744, -1.419870>, <2.589083, -0.098744, -1.443326>, 
      <2.622215, -0.082661, -1.373433>, <2.626128, -0.082661, -1.396814>, <2.630241, -0.082662, -1.428163>, <2.633681, -0.082662, -1.451619>, 
      <2.642726, -0.062995, -1.370092>, <2.646640, -0.062995, -1.393474>, <2.650753, -0.062995, -1.424823>, <2.654192, -0.062995, -1.448279>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.478695, -0.073423, -1.394149>, <2.472153, -0.073423, -1.492991>, <2.338223, -0.073423, -1.601306>, <2.352597, -0.073423, -1.699316>, 
      <2.494004, -0.092561, -1.392230>, <2.487463, -0.092561, -1.491072>, <2.398240, -0.148446, -1.593787>, <2.412613, -0.148446, -1.691796>, 
      <2.531359, -0.101047, -1.386997>, <2.535120, -0.101047, -1.410404>, <2.489618, -0.102064, -1.499798>, <2.493058, -0.102064, -1.523254>, 
      <2.555634, -0.099504, -1.383437>, <2.559394, -0.099504, -1.406844>, <2.563660, -0.099504, -1.438168>, <2.567100, -0.099504, -1.461624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.464295, 0.014673, -1.394882>, <2.467912, 0.014673, -1.418311>, <2.472321, 0.014673, -1.449612>, <2.475761, 0.014673, -1.473068>, 
      <2.465469, -0.012081, -1.395108>, <2.469087, -0.012081, -1.418537>, <2.439435, -0.032413, -1.507682>, <2.442875, -0.032413, -1.531138>, 
      <2.462016, -0.052575, -1.396238>, <2.455475, -0.052575, -1.495080>, <2.287358, -0.009840, -1.607680>, <2.301732, -0.009840, -1.705690>, 
      <2.478695, -0.073423, -1.394149>, <2.472153, -0.073423, -1.492991>, <2.338223, -0.073423, -1.601306>, <2.352597, -0.073423, -1.699316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.470560, 0.111895, -1.392583>, <2.474208, 0.111895, -1.416008>, <2.478587, 0.111895, -1.447314>, <2.482027, 0.111895, -1.470770>, 
      <2.453429, 0.088381, -1.395464>, <2.457077, 0.088381, -1.418888>, <2.461456, 0.088381, -1.450194>, <2.464896, 0.088381, -1.473650>, 
      <2.463013, 0.043879, -1.394635>, <2.466630, 0.043879, -1.418064>, <2.484093, 0.031527, -1.428826>, <2.487533, 0.031527, -1.452282>, 
      <2.464295, 0.014673, -1.394882>, <2.467912, 0.014673, -1.418311>, <2.472321, 0.014673, -1.449612>, <2.475761, 0.014673, -1.473068>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.555073, 0.139279, -1.379618>, <2.558882, 0.139279, -1.403017>, <2.563100, 0.139279, -1.434349>, <2.566540, 0.139279, -1.457804>, 
      <2.528425, 0.139077, -1.383526>, <2.532233, 0.139077, -1.406925>, <2.536452, 0.139077, -1.438257>, <2.539892, 0.139077, -1.461713>, 
      <2.486343, 0.133559, -1.389929>, <2.489990, 0.133559, -1.413354>, <2.494369, 0.133559, -1.444660>, <2.497809, 0.133559, -1.468116>, 
      <2.470560, 0.111895, -1.392583>, <2.474208, 0.111895, -1.416008>, <2.478587, 0.111895, -1.447314>, <2.482027, 0.111895, -1.470770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.642330, 0.113198, -1.367393>, <2.646276, 0.113198, -1.390769>, <2.650357, 0.113198, -1.422123>, <2.653796, 0.113198, -1.445579>, 
      <2.623102, 0.132791, -1.369902>, <2.627048, 0.132791, -1.393279>, <2.631129, 0.132791, -1.424633>, <2.634569, 0.132791, -1.448089>, 
      <2.582347, 0.139486, -1.375618>, <2.586155, 0.139486, -1.399017>, <2.590374, 0.139486, -1.430349>, <2.593814, 0.139486, -1.453805>, 
      <2.555073, 0.139279, -1.379618>, <2.558882, 0.139279, -1.403017>, <2.563100, 0.139279, -1.434349>, <2.566540, 0.139279, -1.457804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.676075, 0.015977, -1.363823>, <2.680058, 0.015977, -1.387193>, <2.684102, 0.015977, -1.418554>, <2.687542, 0.015977, -1.442010>, 
      <2.676006, 0.046865, -1.363350>, <2.679988, 0.046865, -1.386720>, <2.684032, 0.046865, -1.418080>, <2.687472, 0.046865, -1.441536>, 
      <2.663877, 0.091241, -1.364580>, <2.667823, 0.091241, -1.387956>, <2.671904, 0.091241, -1.419310>, <2.675344, 0.091241, -1.442766>, 
      <2.642330, 0.113198, -1.367393>, <2.646276, 0.113198, -1.390769>, <2.650357, 0.113198, -1.422123>, <2.653796, 0.113198, -1.445579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.676075, 0.015977, -1.363823>, <2.676133, -0.009806, -1.364218>, <2.661211, -0.045271, -1.367082>, <2.642726, -0.062995, -1.370092>, 
      <2.680058, 0.015977, -1.387193>, <2.680116, -0.009806, -1.387588>, <2.665125, -0.045271, -1.390464>, <2.646640, -0.062995, -1.393474>, 
      <2.684102, 0.015977, -1.418554>, <2.684160, -0.009806, -1.418949>, <2.669238, -0.045271, -1.421813>, <2.650753, -0.062995, -1.424823>, 
      <2.687542, 0.015977, -1.442010>, <2.687600, -0.009806, -1.442405>, <2.672678, -0.045271, -1.445269>, <2.654192, -0.062995, -1.448279>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.474325, -0.099504, -0.884214>, <2.498814, -0.094373, -1.033878>, <2.531562, -0.099504, -1.233618>, <2.555634, -0.099504, -1.383437>, 
      <2.499970, -0.097708, -0.871654>, <2.524458, -0.092577, -1.021317>, <2.559815, -0.097708, -1.229475>, <2.583887, -0.097708, -1.379294>, 
      <2.534686, -0.082662, -0.854386>, <2.557891, -0.079096, -1.012468>, <2.595830, -0.082661, -1.215810>, <2.622215, -0.082661, -1.373433>, 
      <2.553203, -0.062995, -0.844951>, <2.576407, -0.059430, -1.003033>, <2.616342, -0.062995, -1.212470>, <2.642726, -0.062995, -1.370092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.404315, -0.073423, -0.917873>, <2.430029, -0.069417, -1.060127>, <2.488245, -0.073423, -1.249850>, <2.478695, -0.073423, -1.394149>, 
      <2.418311, -0.092561, -0.911379>, <2.444025, -0.088555, -1.053632>, <2.503554, -0.092561, -1.247932>, <2.494004, -0.092561, -1.392230>, 
      <2.452292, -0.101047, -0.895006>, <2.476780, -0.095917, -1.044669>, <2.507287, -0.101047, -1.237178>, <2.531359, -0.101047, -1.386997>, 
      <2.474325, -0.099504, -0.884214>, <2.498814, -0.094373, -1.033878>, <2.531562, -0.099504, -1.233618>, <2.555634, -0.099504, -1.383437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.390826, 0.014673, -0.922962>, <2.416881, 0.014897, -1.063854>, <2.442431, 0.014673, -1.253278>, <2.464295, 0.014673, -1.394882>, 
      <2.392013, -0.012081, -0.922819>, <2.418068, -0.011857, -1.063711>, <2.443606, -0.012081, -1.253504>, <2.465469, -0.012081, -1.395108>, 
      <2.389068, -0.052575, -0.924949>, <2.414782, -0.048569, -1.067202>, <2.471566, -0.052575, -1.251940>, <2.462016, -0.052575, -1.396238>, 
      <2.404315, -0.073423, -0.917873>, <2.430029, -0.069417, -1.060127>, <2.488245, -0.073423, -1.249850>, <2.478695, -0.073423, -1.394149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.396092, 0.111895, -0.918862>, <2.422156, 0.107949, -1.060288>, <2.448427, 0.111895, -1.250434>, <2.470560, 0.111895, -1.392583>, 
      <2.380655, 0.088380, -0.926829>, <2.406719, 0.084435, -1.068254>, <2.431296, 0.088381, -1.253315>, <2.453429, 0.088381, -1.395464>, 
      <2.389529, 0.043879, -0.923118>, <2.415585, 0.044103, -1.064010>, <2.441149, 0.043879, -1.253031>, <2.463013, 0.043879, -1.394635>, 
      <2.390826, 0.014673, -0.922962>, <2.416881, 0.014897, -1.063854>, <2.442431, 0.014673, -1.253278>, <2.464295, 0.014673, -1.394882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.472628, 0.139279, -0.880748>, <2.497450, 0.134154, -1.030306>, <2.530707, 0.139279, -1.229896>, <2.555073, 0.139279, -1.379618>, 
      <2.448440, 0.139077, -0.892594>, <2.473262, 0.133952, -1.042153>, <2.504059, 0.139077, -1.233805>, <2.528425, 0.139077, -1.383526>, 
      <2.410314, 0.133558, -0.911523>, <2.436378, 0.129613, -1.052949>, <2.464210, 0.133559, -1.247781>, <2.486343, 0.133559, -1.389929>, 
      <2.396092, 0.111895, -0.918862>, <2.422156, 0.107949, -1.060288>, <2.448427, 0.111895, -1.250434>, <2.470560, 0.111895, -1.392583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.552002, 0.113198, -0.842501>, <2.575444, 0.109187, -1.000503>, <2.615736, 0.113198, -1.209839>, <2.642330, 0.113198, -1.367393>, 
      <2.534455, 0.132791, -0.850753>, <2.557897, 0.128780, -1.008756>, <2.596509, 0.132791, -1.212349>, <2.623102, 0.132791, -1.369902>, 
      <2.497383, 0.139486, -0.868623>, <2.522206, 0.134361, -1.018181>, <2.557981, 0.139486, -1.225897>, <2.582347, 0.139486, -1.375618>, 
      <2.472628, 0.139279, -0.880748>, <2.497450, 0.134154, -1.030306>, <2.530707, 0.139279, -1.229896>, <2.555073, 0.139279, -1.379618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.583052, 0.015977, -0.828813>, <2.609835, 0.016149, -0.989507>, <2.648710, 0.015977, -1.203227>, <2.676075, 0.015977, -1.363823>, 
      <2.582842, 0.046865, -0.828383>, <2.609625, 0.047037, -0.989078>, <2.648640, 0.046865, -1.202754>, <2.676006, 0.046865, -1.363350>, 
      <2.571666, 0.091241, -0.833252>, <2.595108, 0.087230, -0.991255>, <2.637284, 0.091241, -1.207026>, <2.663877, 0.091241, -1.364580>, 
      <2.552002, 0.113198, -0.842501>, <2.575444, 0.109187, -1.000503>, <2.615736, 0.113198, -1.209839>, <2.642330, 0.113198, -1.367393>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.583052, 0.015977, -0.828813>, <2.583228, -0.009806, -0.829171>, <2.569890, -0.045271, -0.836448>, <2.553203, -0.062995, -0.844951>, 
      <2.609835, 0.016149, -0.989507>, <2.610011, -0.009635, -0.989866>, <2.593095, -0.041705, -0.994530>, <2.576407, -0.059430, -1.003033>, 
      <2.648710, 0.015977, -1.203227>, <2.648768, -0.009806, -1.203622>, <2.634827, -0.045271, -1.209460>, <2.616342, -0.062995, -1.212470>, 
      <2.676075, 0.015977, -1.363823>, <2.676133, -0.009806, -1.364218>, <2.661211, -0.045271, -1.367082>, <2.642726, -0.062995, -1.370092>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.459016, -0.119747, -0.792942>, <2.467658, -0.119011, -0.820007>, <2.469739, -0.100465, -0.856182>, <2.474325, -0.099504, -0.884214>, 
      <2.489009, -0.117646, -0.778252>, <2.497651, -0.116911, -0.805317>, <2.495384, -0.098669, -0.843622>, <2.499970, -0.097708, -0.871654>, 
      <2.530596, -0.101665, -0.756326>, <2.539091, -0.101133, -0.784765>, <2.530376, -0.083324, -0.825023>, <2.534686, -0.082662, -0.854386>, 
      <2.551266, -0.077048, -0.747023>, <2.559761, -0.076516, -0.775462>, <2.548892, -0.063657, -0.815588>, <2.553203, -0.062995, -0.844951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.377136, -0.089244, -0.832309>, <2.385888, -0.088690, -0.858213>, <2.399452, -0.074180, -0.890972>, <2.404315, -0.073423, -0.917873>, 
      <2.393505, -0.111626, -0.824713>, <2.402256, -0.111072, -0.850617>, <2.413448, -0.093318, -0.884477>, <2.418311, -0.092561, -0.911379>, 
      <2.433247, -0.121552, -0.805563>, <2.441889, -0.120816, -0.832628>, <2.447706, -0.102008, -0.866974>, <2.452292, -0.101047, -0.895006>, 
      <2.459016, -0.119747, -0.792942>, <2.467658, -0.119011, -0.820007>, <2.469739, -0.100465, -0.856182>, <2.474325, -0.099504, -0.884214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.361358, 0.013789, -0.838261>, <2.370049, 0.013820, -0.863724>, <2.385933, 0.014631, -0.896505>, <2.390826, 0.014673, -0.922962>, 
      <2.362747, -0.017501, -0.838094>, <2.371438, -0.017470, -0.863557>, <2.387120, -0.012123, -0.896362>, <2.392013, -0.012081, -0.922819>, 
      <2.359304, -0.064861, -0.840584>, <2.368056, -0.064306, -0.866488>, <2.384206, -0.053332, -0.898047>, <2.389068, -0.052575, -0.924949>, 
      <2.377136, -0.089244, -0.832309>, <2.385888, -0.088690, -0.858213>, <2.399452, -0.074180, -0.890972>, <2.404315, -0.073423, -0.917873>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.367518, 0.127494, -0.833465>, <2.376337, 0.126946, -0.859420>, <2.391125, 0.112647, -0.891909>, <2.396092, 0.111895, -0.918862>, 
      <2.349463, 0.099993, -0.842782>, <2.358283, 0.099445, -0.868737>, <2.375688, 0.089132, -0.899875>, <2.380655, 0.088380, -0.926829>, 
      <2.359842, 0.047947, -0.838443>, <2.368534, 0.047977, -0.863906>, <2.384637, 0.043837, -0.896661>, <2.389529, 0.043879, -0.923118>, 
      <2.361358, 0.013789, -0.838261>, <2.370049, 0.013820, -0.863724>, <2.385933, 0.014631, -0.896505>, <2.390826, 0.014673, -0.922962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.457030, 0.159522, -0.788888>, <2.465731, 0.158782, -0.816127>, <2.467947, 0.140245, -0.852545>, <2.472628, 0.139279, -0.880748>, 
      <2.428741, 0.159285, -0.802743>, <2.437443, 0.158546, -0.829982>, <2.443759, 0.140043, -0.864392>, <2.448440, 0.139077, -0.892594>, 
      <2.384151, 0.152831, -0.824882>, <2.392970, 0.152283, -0.850836>, <2.405346, 0.134310, -0.884570>, <2.410314, 0.133558, -0.911523>, 
      <2.367518, 0.127494, -0.833465>, <2.376337, 0.126946, -0.859420>, <2.391125, 0.112647, -0.891909>, <2.396092, 0.111895, -0.918862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.549862, 0.129019, -0.744157>, <2.558418, 0.128416, -0.772789>, <2.547617, 0.113948, -0.812944>, <2.552002, 0.113198, -0.842501>, 
      <2.530341, 0.153415, -0.752105>, <2.538897, 0.152813, -0.780737>, <2.530070, 0.133542, -0.821197>, <2.534455, 0.132791, -0.850753>, 
      <2.485983, 0.159764, -0.774707>, <2.494684, 0.159024, -0.801946>, <2.492703, 0.140452, -0.840420>, <2.497383, 0.139486, -0.868623>, 
      <2.457030, 0.159522, -0.788888>, <2.465731, 0.158782, -0.816127>, <2.467947, 0.140245, -0.852545>, <2.472628, 0.139279, -0.880748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.572421, 0.015313, -0.741905>, <2.579758, 0.015335, -0.767127>, <2.578734, 0.015949, -0.802903>, <2.583052, 0.015977, -0.828813>, 
      <2.572184, 0.050092, -0.741421>, <2.579521, 0.050114, -0.766643>, <2.578523, 0.046837, -0.802473>, <2.582842, 0.046865, -0.828383>, 
      <2.570923, 0.102698, -0.735581>, <2.579479, 0.102096, -0.764214>, <2.567281, 0.091991, -0.803696>, <2.571666, 0.091241, -0.833252>, 
      <2.549862, 0.129019, -0.744157>, <2.558418, 0.128416, -0.772789>, <2.547617, 0.113948, -0.812944>, <2.552002, 0.113198, -0.842501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.572421, 0.015313, -0.741905>, <2.572615, -0.013151, -0.742301>, <2.568851, -0.056106, -0.739110>, <2.551266, -0.077048, -0.747023>, 
      <2.579758, 0.015335, -0.767127>, <2.579952, -0.013129, -0.767523>, <2.577345, -0.055574, -0.767549>, <2.559761, -0.076516, -0.775462>, 
      <2.578734, 0.015949, -0.802903>, <2.578910, -0.009834, -0.803261>, <2.565580, -0.045933, -0.807085>, <2.548892, -0.063657, -0.815588>, 
      <2.583052, 0.015977, -0.828813>, <2.583228, -0.009806, -0.829171>, <2.569890, -0.045271, -0.836448>, <2.553203, -0.062995, -0.844951>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.417820, -0.104314, -0.707251>, <2.430615, -0.100788, -0.732920>, <2.450229, -0.120495, -0.765423>, <2.459016, -0.119747, -0.792942>, 
      <2.444498, -0.102445, -0.694185>, <2.457293, -0.098920, -0.719854>, <2.480222, -0.118394, -0.750734>, <2.489009, -0.117646, -0.778252>, 
      <2.480613, -0.086793, -0.676222>, <2.493481, -0.084766, -0.701975>, <2.522338, -0.102182, -0.728676>, <2.530596, -0.101665, -0.756326>, 
      <2.499875, -0.066334, -0.666407>, <2.512743, -0.064308, -0.692160>, <2.543008, -0.077565, -0.719374>, <2.551266, -0.077048, -0.747023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.344990, -0.077182, -0.742266>, <2.357845, -0.073788, -0.767938>, <2.367885, -0.089830, -0.804925>, <2.377136, -0.089244, -0.832309>, 
      <2.359550, -0.097091, -0.735510>, <2.372405, -0.093697, -0.761182>, <2.384254, -0.112213, -0.797329>, <2.393505, -0.111626, -0.824713>, 
      <2.394899, -0.105919, -0.718478>, <2.407694, -0.102394, -0.744147>, <2.424460, -0.122300, -0.778045>, <2.433247, -0.121552, -0.805563>, 
      <2.417820, -0.104314, -0.707251>, <2.430615, -0.100788, -0.732920>, <2.450229, -0.120495, -0.765423>, <2.459016, -0.119747, -0.792942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.330956, 0.014463, -0.747559>, <2.343917, 0.014661, -0.773164>, <2.352087, 0.013757, -0.811100>, <2.361358, 0.013789, -0.838261>, 
      <2.332191, -0.013369, -0.747410>, <2.345152, -0.013171, -0.773015>, <2.353476, -0.017534, -0.810933>, <2.362747, -0.017501, -0.838094>, 
      <2.329129, -0.055494, -0.749626>, <2.341984, -0.052100, -0.775298>, <2.350053, -0.065447, -0.813200>, <2.359304, -0.064861, -0.840584>, 
      <2.344990, -0.077182, -0.742266>, <2.357845, -0.073788, -0.767938>, <2.367885, -0.089830, -0.804925>, <2.377136, -0.089244, -0.832309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.336435, 0.115601, -0.743295>, <2.349468, 0.112185, -0.768788>, <2.358243, 0.128070, -0.806169>, <2.367518, 0.127494, -0.833465>, 
      <2.320376, 0.091139, -0.751582>, <2.333409, 0.087723, -0.777076>, <2.340188, 0.100569, -0.815486>, <2.349463, 0.099993, -0.842782>, 
      <2.329607, 0.044846, -0.747721>, <2.342568, 0.045044, -0.773326>, <2.350572, 0.047914, -0.811282>, <2.359842, 0.047947, -0.838443>, 
      <2.330956, 0.014463, -0.747559>, <2.343917, 0.014661, -0.773164>, <2.352087, 0.013757, -0.811100>, <2.361358, 0.013789, -0.838261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.416054, 0.144089, -0.703645>, <2.429020, 0.140581, -0.729063>, <2.448285, 0.160266, -0.761511>, <2.457030, 0.159522, -0.788888>, 
      <2.390892, 0.143879, -0.715969>, <2.403858, 0.140371, -0.741387>, <2.419996, 0.160029, -0.775366>, <2.428741, 0.159285, -0.802743>, 
      <2.351229, 0.138137, -0.735661>, <2.364263, 0.134721, -0.761154>, <2.374876, 0.153407, -0.797585>, <2.384151, 0.152831, -0.824882>, 
      <2.336435, 0.115601, -0.743295>, <2.349468, 0.112185, -0.768788>, <2.358243, 0.128070, -0.806169>, <2.367518, 0.127494, -0.833465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.498626, 0.116957, -0.663857>, <2.511600, 0.114682, -0.689473>, <2.541618, 0.129600, -0.716564>, <2.549862, 0.129019, -0.744157>, 
      <2.480372, 0.137340, -0.672443>, <2.493346, 0.135064, -0.698059>, <2.522097, 0.153996, -0.724512>, <2.530341, 0.153415, -0.752105>, 
      <2.441807, 0.144304, -0.691032>, <2.454773, 0.140797, -0.716450>, <2.477238, 0.160508, -0.747331>, <2.485983, 0.159764, -0.774707>, 
      <2.416054, 0.144089, -0.703645>, <2.429020, 0.140581, -0.729063>, <2.448285, 0.160266, -0.761511>, <2.457030, 0.159522, -0.788888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.530926, 0.015819, -0.649617>, <2.543811, 0.015913, -0.677103>, <2.563942, 0.015287, -0.712757>, <2.572421, 0.015313, -0.741905>, 
      <2.530708, 0.047952, -0.649170>, <2.543592, 0.048045, -0.676657>, <2.563705, 0.050066, -0.712273>, <2.572184, 0.050092, -0.741421>, 
      <2.519082, 0.094115, -0.654236>, <2.532056, 0.091840, -0.679852>, <2.562679, 0.103279, -0.707988>, <2.570923, 0.102698, -0.735581>, 
      <2.498626, 0.116957, -0.663857>, <2.511600, 0.114682, -0.689473>, <2.541618, 0.129600, -0.716564>, <2.549862, 0.129019, -0.744157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.530926, 0.015819, -0.649617>, <2.531109, -0.011003, -0.649990>, <2.517234, -0.047896, -0.657561>, <2.499875, -0.066334, -0.666407>, 
      <2.543811, 0.015913, -0.677103>, <2.543993, -0.010909, -0.677477>, <2.530103, -0.045869, -0.683315>, <2.512743, -0.064308, -0.692160>, 
      <2.563942, 0.015287, -0.712757>, <2.564137, -0.013177, -0.713153>, <2.560592, -0.056623, -0.711461>, <2.543008, -0.077565, -0.719374>, 
      <2.572421, 0.015313, -0.741905>, <2.572615, -0.013151, -0.742301>, <2.568851, -0.056106, -0.739110>, <2.551266, -0.077048, -0.747023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.229518, -0.182990, -0.332511>, <2.316099, -0.147853, -0.420011>, <2.361141, -0.119933, -0.593539>, <2.417820, -0.104314, -0.707251>, 
      <2.243739, -0.179938, -0.286119>, <2.330319, -0.144800, -0.373618>, <2.387819, -0.118065, -0.580473>, <2.444498, -0.102445, -0.694185>, 
      <2.262662, -0.154370, -0.223009>, <2.378645, -0.139752, -0.331461>, <2.409512, -0.097989, -0.533931>, <2.480613, -0.086793, -0.676222>, 
      <2.272476, -0.120951, -0.189086>, <2.388458, -0.106333, -0.297539>, <2.428774, -0.077531, -0.524115>, <2.499875, -0.066334, -0.666407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.189916, -0.138672, -0.458430>, <2.266177, -0.101919, -0.509310>, <2.301072, -0.088777, -0.654562>, <2.344990, -0.077182, -0.742266>, 
      <2.198124, -0.171192, -0.433530>, <2.274385, -0.134438, -0.484409>, <2.315632, -0.108685, -0.647806>, <2.359550, -0.097091, -0.735510>, 
      <2.217301, -0.185613, -0.372371>, <2.303881, -0.150475, -0.459870>, <2.338220, -0.121538, -0.604765>, <2.394899, -0.105919, -0.718478>, 
      <2.229518, -0.182990, -0.332511>, <2.316099, -0.147853, -0.420011>, <2.361141, -0.119933, -0.593539>, <2.417820, -0.104314, -0.707251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.180551, 0.011027, -0.481071>, <2.240088, 0.015207, -0.550830>, <2.289494, 0.013830, -0.665651>, <2.330956, 0.014463, -0.747559>, 
      <2.181754, -0.034435, -0.479432>, <2.241290, -0.030255, -0.549192>, <2.290729, -0.014002, -0.665502>, <2.332191, -0.013369, -0.747410>, 
      <2.180975, -0.103245, -0.485557>, <2.257236, -0.066491, -0.536436>, <2.285211, -0.067088, -0.661922>, <2.329129, -0.055494, -0.749626>, 
      <2.189916, -0.138672, -0.458430>, <2.266177, -0.101919, -0.509310>, <2.301072, -0.088777, -0.654562>, <2.344990, -0.077182, -0.742266>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.181586, 0.176231, -0.469778>, <2.258846, 0.151864, -0.521344>, <2.293029, 0.126979, -0.658393>, <2.336435, 0.115601, -0.743295>, 
      <2.173529, 0.136274, -0.498175>, <2.250789, 0.111907, -0.549741>, <2.276970, 0.102517, -0.666680>, <2.320376, 0.091139, -0.751582>, 
      <2.179238, 0.060655, -0.482859>, <2.238775, 0.064835, -0.552618>, <2.288146, 0.044212, -0.665813>, <2.329607, 0.044846, -0.747721>, 
      <2.180551, 0.011027, -0.481071>, <2.240088, 0.015207, -0.550830>, <2.289494, 0.013830, -0.665651>, <2.330956, 0.014463, -0.747559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.223246, 0.222765, -0.330589>, <2.308072, 0.182170, -0.417680>, <2.358247, 0.159727, -0.590322>, <2.416054, 0.144089, -0.703645>, 
      <2.209834, 0.222421, -0.374346>, <2.294660, 0.181827, -0.461437>, <2.333084, 0.159517, -0.602646>, <2.390892, 0.143879, -0.715969>, 
      <2.189008, 0.213043, -0.443616>, <2.266269, 0.188676, -0.495181>, <2.307824, 0.149515, -0.650758>, <2.351229, 0.138137, -0.735661>, 
      <2.181586, 0.176231, -0.469778>, <2.258846, 0.151864, -0.521344>, <2.293029, 0.126979, -0.658393>, <2.336435, 0.115601, -0.743295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268041, 0.178446, -0.187727>, <2.378965, 0.159268, -0.301114>, <2.426659, 0.129579, -0.521766>, <2.498626, 0.116957, -0.663857>, 
      <2.257887, 0.211740, -0.219074>, <2.368811, 0.192562, -0.332461>, <2.408405, 0.149962, -0.530351>, <2.480372, 0.137340, -0.672443>, 
      <2.236974, 0.223117, -0.285804>, <2.321800, 0.182522, -0.372895>, <2.384000, 0.159942, -0.577709>, <2.441807, 0.144304, -0.691032>, 
      <2.223246, 0.222765, -0.330589>, <2.308072, 0.182170, -0.417680>, <2.358247, 0.159727, -0.590322>, <2.416054, 0.144089, -0.703645>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.287144, 0.013242, -0.133321>, <2.408829, 0.016177, -0.253836>, <2.458225, 0.015291, -0.494523>, <2.530926, 0.015819, -0.649617>, 
      <2.286366, 0.065729, -0.133082>, <2.408052, 0.068664, -0.253597>, <2.458006, 0.047424, -0.494076>, <2.530708, 0.047952, -0.649170>, 
      <2.279419, 0.141135, -0.152598>, <2.390343, 0.121957, -0.265985>, <2.447115, 0.106737, -0.512145>, <2.519082, 0.094115, -0.654236>, 
      <2.268041, 0.178446, -0.187727>, <2.378965, 0.159268, -0.301114>, <2.426659, 0.129579, -0.521766>, <2.498626, 0.116957, -0.663857>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.287144, 0.013242, -0.133321>, <2.287793, -0.030570, -0.133519>, <2.281320, -0.090833, -0.158515>, <2.272476, -0.120951, -0.189086>, 
      <2.408829, 0.016177, -0.253836>, <2.409478, -0.027635, -0.254035>, <2.397303, -0.076216, -0.266967>, <2.388458, -0.106333, -0.297539>, 
      <2.458225, 0.015291, -0.494523>, <2.458408, -0.011530, -0.494896>, <2.446134, -0.059092, -0.515270>, <2.428774, -0.077531, -0.524115>, 
      <2.530926, 0.015819, -0.649617>, <2.531109, -0.011003, -0.649990>, <2.517234, -0.047896, -0.657561>, <2.499875, -0.066334, -0.666407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.282617, -0.263241>, <2.056358, -0.254013, -0.273872>, <2.172942, -0.205951, -0.275334>, <2.229518, -0.182990, -0.332511>, 
      <1.956516, -0.263994, -0.186697>, <2.034401, -0.235390, -0.197328>, <2.187162, -0.202899, -0.228941>, <2.243739, -0.179938, -0.286119>, 
      <1.874636, -0.205605, -0.115813>, <1.982143, -0.210083, -0.191590>, <2.166940, -0.166434, -0.133502>, <2.262662, -0.154370, -0.223009>, 
      <1.853473, -0.147802, -0.061973>, <1.960979, -0.152280, -0.137750>, <2.176754, -0.133015, -0.099579>, <2.272476, -0.120951, -0.189086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.253821, -0.497736>, <2.018262, -0.227910, -0.442044>, <2.133409, -0.165905, -0.420730>, <2.189916, -0.138672, -0.458430>, 
      <1.952545, -0.303843, -0.454734>, <1.992334, -0.277932, -0.399043>, <2.141616, -0.198425, -0.395829>, <2.198124, -0.171192, -0.433530>, 
      <1.997503, -0.298757, -0.329580>, <2.075388, -0.270153, -0.340211>, <2.160724, -0.208573, -0.315194>, <2.217301, -0.185613, -0.372371>, 
      <1.978473, -0.282617, -0.263241>, <2.056358, -0.254013, -0.273872>, <2.172942, -0.205951, -0.275334>, <2.229518, -0.182990, -0.332511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.124962, 0.000000, -0.506196>, <2.135322, 0.000633, -0.490764>, <2.168490, 0.010180, -0.466939>, <2.180551, 0.011027, -0.481071>, 
      <2.124962, -0.087946, -0.504984>, <2.135322, -0.087314, -0.489553>, <2.169693, -0.035282, -0.465301>, <2.181754, -0.034435, -0.479432>, 
      <2.010648, -0.191747, -0.551099>, <2.050437, -0.165836, -0.495407>, <2.124467, -0.130478, -0.447856>, <2.180975, -0.103245, -0.485557>, 
      <1.978473, -0.253821, -0.497736>, <2.018262, -0.227910, -0.442044>, <2.133409, -0.165905, -0.420730>, <2.189916, -0.138672, -0.458430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, 0.228500, -0.504381>, <2.038450, 0.207081, -0.501124>, <2.130281, 0.192412, -0.435536>, <2.181586, 0.176231, -0.469778>, 
      <2.004514, 0.165660, -0.549145>, <2.064490, 0.144241, -0.545888>, <2.122224, 0.152455, -0.463933>, <2.173529, 0.136274, -0.498175>, 
      <2.124962, 0.081421, -0.507318>, <2.135322, 0.082054, -0.491886>, <2.167177, 0.059809, -0.468728>, <2.179238, 0.060655, -0.482859>, 
      <2.124962, 0.000000, -0.506196>, <2.135322, 0.000633, -0.490764>, <2.168490, 0.010180, -0.466939>, <2.180551, 0.011027, -0.481071>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, 0.353500, -0.254381>, <2.060094, 0.328636, -0.267536>, <2.166111, 0.250108, -0.271928>, <2.223246, 0.222765, -0.330589>, 
      <1.998810, 0.353500, -0.335730>, <2.080431, 0.328636, -0.348885>, <2.152699, 0.249764, -0.315685>, <2.209834, 0.222421, -0.374346>, 
      <1.951657, 0.293210, -0.458285>, <2.011634, 0.271791, -0.455029>, <2.137704, 0.229225, -0.409373>, <2.189008, 0.213043, -0.443616>, 
      <1.978473, 0.228500, -0.504381>, <2.038450, 0.207081, -0.501124>, <2.130281, 0.192412, -0.435536>, <2.181586, 0.176231, -0.469778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, 0.228500, -0.004381>, <1.979495, 0.189980, -0.041171>, <2.173056, 0.194868, -0.090633>, <2.268041, 0.178446, -0.187727>, 
      <1.874706, 0.301039, -0.056580>, <2.000728, 0.262519, -0.093371>, <2.162903, 0.228162, -0.121980>, <2.257887, 0.211740, -0.219074>, 
      <1.956195, 0.353500, -0.165268>, <2.037815, 0.328636, -0.178423>, <2.179838, 0.250460, -0.227144>, <2.236974, 0.223117, -0.285804>, 
      <1.978473, 0.353500, -0.254381>, <2.060094, 0.328636, -0.267536>, <2.166111, 0.250108, -0.271928>, <2.223246, 0.222765, -0.330589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, 0.000000, 0.000000>, <1.986839, 0.003593, -0.066199>, <2.194782, 0.011015, -0.041847>, <2.287144, 0.013242, -0.133321>, 
      <1.875000, 0.068073, 0.010419>, <1.986839, 0.071667, -0.055780>, <2.194004, 0.063502, -0.041609>, <2.286366, 0.065729, -0.133082>, 
      <1.837554, 0.174116, 0.034754>, <1.963576, 0.135596, -0.002037>, <2.184435, 0.157558, -0.055505>, <2.279419, 0.141135, -0.152598>, 
      <1.853473, 0.228500, -0.004381>, <1.979495, 0.189980, -0.041171>, <2.173056, 0.194868, -0.090633>, <2.268041, 0.178446, -0.187727>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, 0.000000, 0.000000>, <1.875000, -0.047954, -0.007339>, <1.840919, -0.113513, -0.030034>, <1.853473, -0.147802, -0.061973>, 
      <1.986839, 0.003593, -0.066199>, <1.986839, -0.044361, -0.073538>, <1.948425, -0.117990, -0.105811>, <1.960979, -0.152280, -0.137750>, 
      <2.194782, 0.011015, -0.041847>, <2.195431, -0.032797, -0.042046>, <2.185598, -0.102897, -0.069007>, <2.176754, -0.133015, -0.099579>, 
      <2.287144, 0.013242, -0.133321>, <2.287793, -0.030570, -0.133519>, <2.281320, -0.090833, -0.158515>, <2.272476, -0.120951, -0.189086>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.569558, 0.038554, 0.617960>, <1.569558, 0.038554, 0.617960>, <1.573379, 0.079116, 0.618738>, <1.573379, 0.079116, 0.618738>, 
      <1.507949, 0.025318, 0.613943>, <1.507949, 0.066067, 0.613943>, <1.497269, 0.094764, 0.618023>, <1.519873, 0.128670, 0.618023>, 
      <1.477071, 0.019138, 0.584770>, <1.477071, 0.059887, 0.584770>, <1.467205, 0.120440, 0.587363>, <1.489809, 0.154345, 0.587363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.573379, 0.020181, 0.618738>, <1.573379, 0.020181, 0.618738>, <1.569558, 0.038554, 0.617960>, <1.569558, 0.038554, 0.617960>, 
      <1.519079, -0.021407, 0.617213>, <1.505798, -0.008127, 0.617213>, <1.507949, 0.006536, 0.613943>, <1.507949, 0.025318, 0.613943>, 
      <1.489809, -0.042104, 0.587363>, <1.476528, -0.028823, 0.587363>, <1.477071, 0.000356, 0.584770>, <1.477071, 0.019138, 0.584770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.613937, -0.005825, 0.617960>, <1.613937, -0.005825, 0.617960>, <1.573379, 0.020181, 0.618738>, <1.573379, 0.020181, 0.618738>, 
      <1.622663, -0.084899, 0.617483>, <1.574487, -0.084899, 0.618407>, <1.553151, -0.055480, 0.617213>, <1.519079, -0.021407, 0.617213>, 
      <1.625000, -0.128791, 0.584770>, <1.576824, -0.128791, 0.585694>, <1.523881, -0.076176, 0.587363>, <1.489809, -0.042104, 0.587363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.654494, 0.020181, 0.617182>, <1.654494, 0.020181, 0.617182>, <1.613937, -0.005825, 0.617960>, <1.613937, -0.005825, 0.617960>, 
      <1.723595, -0.019576, 0.615983>, <1.689523, -0.053648, 0.615983>, <1.670840, -0.084899, 0.616559>, <1.622663, -0.084899, 0.617483>, 
      <1.760191, -0.042104, 0.582178>, <1.726119, -0.076176, 0.582178>, <1.673176, -0.128791, 0.583846>, <1.625000, -0.128791, 0.584770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.658315, 0.038554, 0.617960>, <1.658315, 0.038554, 0.617960>, <1.654494, 0.020181, 0.617182>, <1.654494, 0.020181, 0.617182>, 
      <1.733470, 0.026097, 0.617617>, <1.733470, 0.007315, 0.617617>, <1.736876, -0.006295, 0.615983>, <1.723595, -0.019576, 0.615983>, 
      <1.772929, 0.019138, 0.584770>, <1.772929, 0.000356, 0.584770>, <1.773472, -0.028823, 0.582178>, <1.760191, -0.042104, 0.582178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.654494, 0.079116, 0.617182>, <1.654494, 0.079116, 0.617182>, <1.658315, 0.038554, 0.617960>, <1.658315, 0.038554, 0.617960>, 
      <1.723064, 0.126741, 0.616473>, <1.745668, 0.092835, 0.616473>, <1.733470, 0.066846, 0.617617>, <1.733470, 0.026097, 0.617617>, 
      <1.760191, 0.154345, 0.582178>, <1.782794, 0.120440, 0.582178>, <1.772929, 0.059887, 0.584770>, <1.772929, 0.019138, 0.584770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, <1.609195, 0.046875, 0.632184>, 
      <1.613937, 0.105122, 0.617960>, <1.613937, 0.105122, 0.617960>, <1.654494, 0.079116, 0.617182>, <1.654494, 0.079116, 0.617182>, 
      <1.622600, 0.191204, 0.618370>, <1.670776, 0.191204, 0.617446>, <1.696336, 0.166833, 0.616473>, <1.723064, 0.126741, 0.616473>, 
      <1.625000, 0.241032, 0.584770>, <1.673176, 0.241032, 0.583846>, <1.733463, 0.194438, 0.582178>, <1.760191, 0.154345, 0.582178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, 0.046875, 0.632184>, <1.613937, 0.105122, 0.617960>, <1.622600, 0.191204, 0.618370>, <1.625000, 0.241032, 0.584770>, 
      <1.609195, 0.046875, 0.632184>, <1.613937, 0.105122, 0.617960>, <1.574424, 0.191204, 0.619294>, <1.576824, 0.241032, 0.585694>, 
      <1.609195, 0.046875, 0.632184>, <1.573379, 0.079116, 0.618738>, <1.546601, 0.168762, 0.618023>, <1.516537, 0.194438, 0.587363>, 
      <1.609195, 0.046875, 0.632184>, <1.573379, 0.079116, 0.618738>, <1.519873, 0.128670, 0.618023>, <1.489809, 0.154345, 0.587363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375000, 0.000000, 0.410920>, <1.387776, 0.002395, 0.470265>, <1.433371, 0.010391, 0.543483>, <1.477071, 0.019138, 0.584770>, 
      <1.375000, 0.068866, 0.410920>, <1.387776, 0.071262, 0.470265>, <1.433371, 0.051140, 0.543483>, <1.477071, 0.059887, 0.584770>, 
      <1.358327, 0.171200, 0.415301>, <1.370350, 0.161642, 0.476183>, <1.429475, 0.152663, 0.548885>, <1.467205, 0.120440, 0.587363>, 
      <1.396527, 0.228500, 0.415301>, <1.408550, 0.218942, 0.476183>, <1.452078, 0.186568, 0.548885>, <1.489809, 0.154345, 0.587363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.396527, -0.103500, 0.415301>, <1.408354, -0.095716, 0.475188>, <1.451197, -0.069406, 0.547986>, <1.489809, -0.042104, 0.587363>, 
      <1.374082, -0.081055, 0.415301>, <1.385909, -0.073271, 0.475188>, <1.437916, -0.056125, 0.547986>, <1.476528, -0.028823, 0.587363>, 
      <1.375000, -0.031742, 0.410920>, <1.387776, -0.029346, 0.470265>, <1.433371, -0.008391, 0.543483>, <1.477071, 0.000356, 0.584770>, 
      <1.375000, 0.000000, 0.410920>, <1.387776, 0.002395, 0.470265>, <1.433371, 0.010391, 0.543483>, <1.477071, 0.019138, 0.584770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.250000, 0.410920>, <1.625000, -0.234253, 0.472519>, <1.627712, -0.179723, 0.546810>, <1.625000, -0.128791, 0.584770>, 
      <1.543582, -0.250000, 0.412481>, <1.543582, -0.234253, 0.474080>, <1.579535, -0.179723, 0.547734>, <1.576824, -0.128791, 0.585694>, 
      <1.454109, -0.161082, 0.415301>, <1.465936, -0.153298, 0.475188>, <1.485269, -0.103478, 0.547986>, <1.523881, -0.076176, 0.587363>, 
      <1.396527, -0.103500, 0.415301>, <1.408354, -0.095716, 0.475188>, <1.451197, -0.069406, 0.547986>, <1.489809, -0.042104, 0.587363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.103500, 0.406539>, <1.841558, -0.095658, 0.467328>, <1.801983, -0.067831, 0.543573>, <1.760191, -0.042104, 0.582178>, 
      <1.795891, -0.161082, 0.406539>, <1.783976, -0.153240, 0.467328>, <1.767911, -0.101903, 0.543573>, <1.726119, -0.076176, 0.582178>, 
      <1.706418, -0.250000, 0.409359>, <1.706418, -0.234253, 0.470958>, <1.675888, -0.179723, 0.545886>, <1.673176, -0.128791, 0.583846>, 
      <1.625000, -0.250000, 0.410920>, <1.625000, -0.234253, 0.472519>, <1.627712, -0.179723, 0.546810>, <1.625000, -0.128791, 0.584770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, 0.000000, 0.410920>, <1.862224, 0.002395, 0.470265>, <1.819197, 0.010979, 0.546255>, <1.772929, 0.019138, 0.584770>, 
      <1.875000, -0.031742, 0.410920>, <1.862224, -0.029346, 0.470265>, <1.819197, -0.007803, 0.546255>, <1.772929, 0.000356, 0.584770>, 
      <1.875918, -0.081055, 0.406539>, <1.864003, -0.073213, 0.467328>, <1.815264, -0.054550, 0.543573>, <1.773472, -0.028823, 0.582178>, 
      <1.853473, -0.103500, 0.406539>, <1.841558, -0.095658, 0.467328>, <1.801983, -0.067831, 0.543573>, <1.760191, -0.042104, 0.582178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, 0.228500, 0.406539>, <1.841366, 0.218876, 0.468307>, <1.801241, 0.184866, 0.544259>, <1.760191, 0.154345, 0.582178>, 
      <1.891673, 0.171200, 0.406539>, <1.879566, 0.161576, 0.468307>, <1.823844, 0.150961, 0.544259>, <1.782794, 0.120440, 0.582178>, 
      <1.875000, 0.068866, 0.410920>, <1.862224, 0.071262, 0.470265>, <1.819197, 0.051728, 0.546255>, <1.772929, 0.059887, 0.584770>, 
      <1.875000, 0.000000, 0.410920>, <1.862224, 0.002395, 0.470265>, <1.819197, 0.010979, 0.546255>, <1.772929, 0.019138, 0.584770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, 0.410920>, <1.625000, 0.357097, 0.474283>, <1.627628, 0.295580, 0.547987>, <1.625000, 0.241032, 0.584770>, 
      <1.706418, 0.375000, 0.409359>, <1.706418, 0.357097, 0.472722>, <1.675804, 0.295580, 0.547063>, <1.673176, 0.241032, 0.583846>, 
      <1.808302, 0.296256, 0.406539>, <1.796196, 0.286632, 0.468307>, <1.774513, 0.224959, 0.544259>, <1.733463, 0.194438, 0.582178>, 
      <1.853473, 0.228500, 0.406539>, <1.841366, 0.218876, 0.468307>, <1.801241, 0.184866, 0.544259>, <1.760191, 0.154345, 0.582178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, 0.410920>, <1.543582, 0.375000, 0.412481>, <1.441698, 0.296256, 0.415301>, <1.396527, 0.228500, 0.415301>, 
      <1.625000, 0.357097, 0.474283>, <1.543582, 0.357097, 0.475844>, <1.453721, 0.286698, 0.476183>, <1.408550, 0.218942, 0.476183>, 
      <1.627628, 0.295580, 0.547987>, <1.579451, 0.295580, 0.548911>, <1.478807, 0.226661, 0.548885>, <1.452078, 0.186568, 0.548885>, 
      <1.625000, 0.241032, 0.584770>, <1.576824, 0.241032, 0.585694>, <1.516537, 0.194438, 0.587363>, <1.489809, 0.154345, 0.587363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375000, 0.000000, 0.110632>, <1.403174, -0.000506, 0.196198>, <1.356056, -0.003552, 0.322920>, <1.375000, 0.000000, 0.410920>, 
      <1.375000, 0.068866, 0.110632>, <1.403174, 0.068360, 0.196198>, <1.356056, 0.065314, 0.322920>, <1.375000, 0.068866, 0.410920>, 
      <1.358327, 0.171200, 0.115013>, <1.386120, 0.170700, 0.200704>, <1.341077, 0.184913, 0.327952>, <1.358327, 0.171200, 0.415301>, 
      <1.396527, 0.228500, 0.115013>, <1.424320, 0.228000, 0.200704>, <1.379277, 0.242213, 0.327952>, <1.396527, 0.228500, 0.415301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.396527, -0.103500, 0.115013>, <1.396527, -0.100973, 0.205064>, <1.379214, -0.114895, 0.327632>, <1.396527, -0.103500, 0.415301>, 
      <1.374082, -0.081055, 0.115013>, <1.374082, -0.078528, 0.205064>, <1.356769, -0.092451, 0.327632>, <1.374082, -0.081055, 0.415301>, 
      <1.375000, -0.031742, 0.110632>, <1.403174, -0.032248, 0.196198>, <1.356056, -0.035294, 0.322920>, <1.375000, -0.031742, 0.410920>, 
      <1.375000, 0.000000, 0.110632>, <1.403174, -0.000506, 0.196198>, <1.356056, -0.003552, 0.322920>, <1.375000, 0.000000, 0.410920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.250000, 0.110632>, <1.625000, -0.250000, 0.200718>, <1.625000, -0.272312, 0.323640>, <1.625000, -0.250000, 0.410920>, 
      <1.543582, -0.250000, 0.112193>, <1.543582, -0.250000, 0.202280>, <1.543582, -0.272312, 0.325202>, <1.543582, -0.250000, 0.412481>, 
      <1.454109, -0.161082, 0.115013>, <1.454109, -0.158555, 0.205064>, <1.436795, -0.172477, 0.327632>, <1.454109, -0.161082, 0.415301>, 
      <1.396527, -0.103500, 0.115013>, <1.396527, -0.100973, 0.205064>, <1.379214, -0.114895, 0.327632>, <1.396527, -0.103500, 0.415301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.103500, 0.106251>, <1.853473, -0.095019, 0.195937>, <1.870663, -0.114814, 0.318835>, <1.853473, -0.103500, 0.406539>, 
      <1.795891, -0.161082, 0.106251>, <1.795891, -0.152601, 0.195937>, <1.813081, -0.172396, 0.318835>, <1.795891, -0.161082, 0.406539>, 
      <1.706418, -0.250000, 0.109071>, <1.706418, -0.250000, 0.199157>, <1.706418, -0.272312, 0.322079>, <1.706418, -0.250000, 0.409359>, 
      <1.625000, -0.250000, 0.110632>, <1.625000, -0.250000, 0.200718>, <1.625000, -0.272312, 0.323640>, <1.625000, -0.250000, 0.410920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, 0.000000, 0.110632>, <1.875000, 0.000000, 0.200718>, <1.893945, -0.003552, 0.322920>, <1.875000, 0.000000, 0.410920>, 
      <1.875000, -0.031742, 0.110632>, <1.875000, -0.031742, 0.200718>, <1.893945, -0.035294, 0.322920>, <1.875000, -0.031742, 0.410920>, 
      <1.875918, -0.081055, 0.106251>, <1.875918, -0.072575, 0.195937>, <1.893108, -0.092369, 0.318835>, <1.875918, -0.081055, 0.406539>, 
      <1.853473, -0.103500, 0.106251>, <1.853473, -0.095019, 0.195937>, <1.870663, -0.114814, 0.318835>, <1.853473, -0.103500, 0.406539>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, 0.000000, 0.110632>, <1.875000, -0.031742, 0.110632>, <1.875918, -0.081055, 0.106251>, <1.853473, -0.103500, 0.106251>, 
      <1.875000, 0.000000, 0.077442>, <1.875000, -0.031742, 0.077442>, <1.875918, -0.085968, 0.054295>, <1.853473, -0.108413, 0.054295>, 
      <1.846450, -0.000917, 0.016899>, <1.846450, -0.048871, 0.009560>, <1.798287, -0.111737, 0.000015>, <1.810841, -0.146026, -0.031924>, 
      <1.875000, 0.000000, 0.000000>, <1.875000, -0.047954, -0.007339>, <1.840919, -0.113513, -0.030034>, <1.853473, -0.147802, -0.061973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, 0.228500, 0.106251>, <1.853473, 0.228500, 0.196337>, <1.870601, 0.242116, 0.319150>, <1.853473, 0.228500, 0.406539>, 
      <1.891673, 0.171200, 0.106251>, <1.891673, 0.171200, 0.196337>, <1.908801, 0.184816, 0.319150>, <1.891673, 0.171200, 0.406539>, 
      <1.875000, 0.068866, 0.110632>, <1.875000, 0.068866, 0.200718>, <1.893945, 0.065314, 0.322920>, <1.875000, 0.068866, 0.410920>, 
      <1.875000, 0.000000, 0.110632>, <1.875000, 0.000000, 0.200718>, <1.893945, -0.003552, 0.322920>, <1.875000, 0.000000, 0.410920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, 0.228500, 0.106251>, <1.891673, 0.171200, 0.106251>, <1.875000, 0.068866, 0.110632>, <1.875000, 0.000000, 0.110632>, 
      <1.853473, 0.228500, 0.073061>, <1.891673, 0.171200, 0.073061>, <1.875000, 0.068866, 0.077442>, <1.875000, 0.000000, 0.077442>, 
      <1.853473, 0.228500, 0.028809>, <1.837554, 0.174116, 0.067944>, <1.846450, 0.067156, 0.027318>, <1.846450, -0.000917, 0.016899>, 
      <1.853473, 0.228500, -0.004381>, <1.837554, 0.174116, 0.034754>, <1.875000, 0.068073, 0.010419>, <1.875000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, 0.110632>, <1.625000, 0.375000, 0.200718>, <1.625000, 0.399495, 0.324228>, <1.625000, 0.375000, 0.410920>, 
      <1.706418, 0.375000, 0.109071>, <1.706418, 0.375000, 0.199157>, <1.706418, 0.399495, 0.322667>, <1.706418, 0.375000, 0.409359>, 
      <1.808302, 0.296256, 0.106251>, <1.808302, 0.296256, 0.196337>, <1.825430, 0.309873, 0.319150>, <1.808302, 0.296256, 0.406539>, 
      <1.853473, 0.228500, 0.106251>, <1.853473, 0.228500, 0.196337>, <1.870601, 0.242116, 0.319150>, <1.853473, 0.228500, 0.406539>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, 0.110632>, <1.543582, 0.375000, 0.112193>, <1.441698, 0.296256, 0.115013>, <1.396527, 0.228500, 0.115013>, 
      <1.625000, 0.375000, 0.200718>, <1.543582, 0.375000, 0.202280>, <1.469491, 0.295757, 0.200704>, <1.424320, 0.228000, 0.200704>, 
      <1.625000, 0.399495, 0.324228>, <1.543582, 0.399495, 0.325789>, <1.424448, 0.309969, 0.327952>, <1.379277, 0.242213, 0.327952>, 
      <1.625000, 0.375000, 0.410920>, <1.543582, 0.375000, 0.412481>, <1.441698, 0.296256, 0.415301>, <1.396527, 0.228500, 0.415301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, 0.002459, -0.004566>, <1.134641, 0.005742, -0.067887>, <0.954869, 0.013592, -0.096759>, <0.879793, 0.015701, -0.192170>, 
      <1.212951, 0.066450, -0.001582>, <1.109395, 0.069733, -0.064903>, <0.955276, 0.066079, -0.096055>, <0.880200, 0.068188, -0.191466>, 
      <1.275273, 0.176360, 0.032476>, <1.179375, 0.166559, -0.036302>, <0.985329, 0.157570, -0.093338>, <0.913958, 0.143089, -0.186717>, 
      <1.259724, 0.230959, -0.006489>, <1.163826, 0.221158, -0.075267>, <1.002221, 0.195385, -0.125590>, <0.930850, 0.180905, -0.218969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, 0.002459, -0.004566>, <1.283959, 0.001008, 0.023416>, <1.358219, 0.000302, 0.059666>, <1.375000, 0.000000, 0.110632>, 
      <1.212951, 0.066450, -0.001582>, <1.258713, 0.064999, 0.026400>, <1.358219, 0.069168, 0.059666>, <1.375000, 0.068866, 0.110632>, 
      <1.275273, 0.176360, 0.032476>, <1.319729, 0.180904, 0.064360>, <1.341391, 0.171504, 0.062796>, <1.358327, 0.171200, 0.115013>, 
      <1.259724, 0.230959, -0.006489>, <1.304180, 0.235503, 0.025395>, <1.379591, 0.228804, 0.062796>, <1.396527, 0.228500, 0.115013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, 0.002459, -0.004566>, <1.283959, 0.001008, 0.023416>, <1.358219, 0.000302, 0.059666>, <1.375000, 0.000000, 0.110632>, 
      <1.260025, -0.052867, -0.007146>, <1.305787, -0.054318, 0.020836>, <1.358219, -0.031440, 0.059666>, <1.375000, -0.031742, 0.110632>, 
      <1.391925, -0.066645, 0.010624>, <1.425529, -0.065568, 0.034893>, <1.374082, -0.082218, 0.073564>, <1.374082, -0.081055, 0.115013>, 
      <1.396527, -0.115790, -0.022657>, <1.430131, -0.114714, 0.001612>, <1.396527, -0.104663, 0.073564>, <1.396527, -0.103500, 0.115013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, 0.002459, -0.004566>, <1.260025, -0.052867, -0.007146>, <1.391925, -0.066645, 0.010624>, <1.396527, -0.115790, -0.022657>, 
      <1.134641, 0.005742, -0.067887>, <1.156469, -0.049584, -0.070467>, <1.268158, -0.070609, -0.078764>, <1.272759, -0.119755, -0.112045>, 
      <0.954869, 0.013592, -0.096759>, <0.954530, -0.030220, -0.097347>, <1.020975, -0.096254, -0.085254>, <1.034909, -0.126529, -0.113700>, 
      <0.879793, 0.015701, -0.192170>, <0.879454, -0.028111, -0.192758>, <0.914597, -0.088217, -0.194540>, <0.928530, -0.118492, -0.222986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.250000, 0.000000>, <1.625000, -0.236894, 0.030492>, <1.625000, -0.250000, 0.077442>, <1.625000, -0.250000, 0.110632>, 
      <1.545704, -0.244445, 0.006823>, <1.545704, -0.231339, 0.037315>, <1.543582, -0.250000, 0.079004>, <1.543582, -0.250000, 0.112193>, 
      <1.465069, -0.156053, -0.015860>, <1.498673, -0.154976, 0.008410>, <1.454109, -0.162245, 0.073564>, <1.454109, -0.161082, 0.115013>, 
      <1.396527, -0.115790, -0.022657>, <1.430131, -0.114714, 0.001612>, <1.396527, -0.104663, 0.073564>, <1.396527, -0.103500, 0.115013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.250000, 0.000000>, <1.701882, -0.255386, -0.006615>, <1.784931, -0.178461, -0.043381>, <1.853473, -0.147802, -0.061973>, 
      <1.625000, -0.236894, 0.030492>, <1.701882, -0.242280, 0.023877>, <1.742299, -0.176686, -0.013332>, <1.810841, -0.146026, -0.031924>, 
      <1.625000, -0.250000, 0.077442>, <1.706418, -0.250000, 0.075881>, <1.795891, -0.165995, 0.054295>, <1.853473, -0.108413, 0.054295>, 
      <1.625000, -0.250000, 0.110632>, <1.706418, -0.250000, 0.109071>, <1.795891, -0.161082, 0.106251>, <1.853473, -0.103500, 0.106251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, 0.000000>, <1.625000, 0.372123, 0.033065>, <1.625000, 0.375000, 0.077442>, <1.625000, 0.375000, 0.110632>, 
      <1.706432, 0.374663, 0.000289>, <1.706432, 0.371785, 0.033354>, <1.706418, 0.375000, 0.075881>, <1.706418, 0.375000, 0.109071>, 
      <1.778465, 0.251427, 0.017517>, <1.778465, 0.251427, 0.050706>, <1.808302, 0.296256, 0.073061>, <1.808302, 0.296256, 0.106251>, 
      <1.853473, 0.228500, -0.004381>, <1.853473, 0.228500, 0.028809>, <1.853473, 0.228500, 0.073061>, <1.853473, 0.228500, 0.106251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, 0.000000>, <1.507191, 0.375488, -0.000418>, <1.369307, 0.274171, -0.004542>, <1.259724, 0.230959, -0.006489>, 
      <1.625000, 0.372123, 0.033065>, <1.507191, 0.372610, 0.032646>, <1.413763, 0.278715, 0.027341>, <1.304180, 0.235503, 0.025395>, 
      <1.625000, 0.375000, 0.077442>, <1.543582, 0.375000, 0.079004>, <1.424762, 0.296561, 0.062796>, <1.379591, 0.228804, 0.062796>, 
      <1.625000, 0.375000, 0.110632>, <1.543582, 0.375000, 0.112193>, <1.441698, 0.296256, 0.115013>, <1.396527, 0.228500, 0.115013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, 0.353500, -1.049582>, <2.027613, 0.323572, -1.022270>, <2.067544, 0.223402, -1.031552>, <2.063486, 0.159843, -1.031135>, 
      <1.973045, 0.379436, -1.145039>, <2.022185, 0.349508, -1.117727>, <2.071571, 0.266226, -1.134712>, <2.067513, 0.202667, -1.134295>, 
      <1.947408, 0.391902, -1.276162>, <1.996532, 0.392688, -1.276162>, <2.055982, 0.329181, -1.264271>, <2.075157, 0.283950, -1.264812>, 
      <1.943182, 0.397126, -1.375000>, <1.992307, 0.397912, -1.375000>, <2.057734, 0.347820, -1.374460>, <2.076910, 0.302589, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, 0.353500, -1.040821>, <1.276388, 0.379747, -1.138787>, <1.298963, 0.391827, -1.273672>, <1.302756, 0.397126, -1.375000>, 
      <1.222775, 0.323785, -1.012333>, <1.227636, 0.350032, -1.110299>, <1.249838, 0.392605, -1.273672>, <1.253631, 0.397904, -1.375000>, 
      <1.184216, 0.223593, -1.017212>, <1.179009, 0.266417, -1.124070>, <1.190891, 0.328699, -1.260278>, <1.188587, 0.347646, -1.373924>, 
      <1.186386, 0.159843, -1.018807>, <1.181179, 0.202667, -1.125665>, <1.171332, 0.283642, -1.261354>, <1.169028, 0.302589, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.079968, 0.074475, -1.378854>, <2.071269, 0.085262, -1.272224>, <2.076958, 0.172389, -1.137075>, <2.063486, 0.159843, -1.031135>, 
      <2.079968, 0.006025, -1.378854>, <2.071269, 0.016812, -1.272224>, <2.068923, 0.046522, -1.136249>, <2.055451, 0.033976, -1.030309>, 
      <2.103626, -0.090622, -1.375753>, <2.085837, -0.102130, -1.267637>, <2.068789, -0.135621, -1.100874>, <2.027854, -0.162103, -1.002076>, 
      <2.076910, -0.153639, -1.375000>, <2.059122, -0.165147, -1.266884>, <1.981396, -0.215430, -1.144472>, <1.940461, -0.241912, -1.045674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.079968, 0.074475, -1.378854>, <2.079968, 0.142925, -1.378854>, <2.103626, 0.239572, -1.375753>, <2.076910, 0.302589, -1.375000>, 
      <2.079968, 0.074475, -1.378854>, <2.071269, 0.153712, -1.272224>, <2.101873, 0.220933, -1.265564>, <2.075157, 0.283950, -1.264812>, 
      <2.079968, 0.074475, -1.378854>, <2.071269, 0.153712, -1.272224>, <2.080985, 0.215213, -1.240234>, <2.067513, 0.202667, -1.134295>, 
      <2.079968, 0.074475, -1.378854>, <2.071269, 0.085262, -1.272224>, <2.076958, 0.172389, -1.137075>, <2.063486, 0.159843, -1.031135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.162696, 0.074475, -1.382708>, <1.168719, 0.085508, -1.271054>, <1.171131, 0.172856, -1.129363>, <1.186386, 0.159843, -1.018807>, 
      <1.162696, 0.005975, -1.382708>, <1.168719, 0.017009, -1.271054>, <1.175799, 0.035712, -1.132795>, <1.191054, 0.022699, -1.022239>, 
      <1.141759, -0.090819, -1.376501>, <1.158010, -0.107807, -1.269419>, <1.161531, -0.158209, -1.102437>, <1.198785, -0.197151, -1.006966>, 
      <1.169028, -0.153639, -1.375000>, <1.185279, -0.170627, -1.267919>, <1.255953, -0.244504, -1.152233>, <1.293207, -0.283446, -1.056762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.162696, 0.074475, -1.382708>, <1.162696, 0.142975, -1.382708>, <1.141759, 0.239769, -1.376501>, <1.169028, 0.302589, -1.375000>, 
      <1.162696, 0.074475, -1.382708>, <1.168719, 0.154008, -1.271054>, <1.144063, 0.220822, -1.262855>, <1.171332, 0.283642, -1.261354>, 
      <1.162696, 0.074475, -1.382708>, <1.168719, 0.154008, -1.271054>, <1.165924, 0.215680, -1.236220>, <1.181179, 0.202667, -1.125665>, 
      <1.162696, 0.074475, -1.382708>, <1.168719, 0.085508, -1.271054>, <1.171131, 0.172856, -1.129363>, <1.186386, 0.159843, -1.018807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.248176, -1.375000>, <1.992307, -0.248962, -1.375000>, <2.057734, -0.198870, -1.374460>, <2.076910, -0.153639, -1.375000>, 
      <1.943182, -0.248176, -1.375000>, <1.991982, -0.248216, -1.276184>, <2.039946, -0.210378, -1.266344>, <2.059122, -0.165147, -1.266884>, 
      <1.943182, -0.248176, -1.375000>, <1.991982, -0.248216, -1.276184>, <1.975791, -0.210953, -1.243030>, <1.981396, -0.215430, -1.144472>, 
      <1.943182, -0.248176, -1.375000>, <1.942858, -0.247430, -1.276184>, <1.934857, -0.237435, -1.144232>, <1.940461, -0.241912, -1.045674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.248176, -1.375000>, <1.301636, -0.252314, -1.278997>, <1.297964, -0.278700, -1.152625>, <1.293207, -0.283446, -1.056762>, 
      <1.302756, -0.248176, -1.375000>, <1.252511, -0.253092, -1.278997>, <1.260710, -0.239758, -1.248097>, <1.255953, -0.244504, -1.152233>, 
      <1.302756, -0.248176, -1.375000>, <1.252511, -0.253092, -1.278997>, <1.204838, -0.215684, -1.266842>, <1.185279, -0.170627, -1.267919>, 
      <1.302756, -0.248176, -1.375000>, <1.253631, -0.248954, -1.375000>, <1.188587, -0.198696, -1.373924>, <1.169028, -0.153639, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, -0.240805, -1.250000>, <1.509183, -0.248222, -1.251980>, <1.372888, -0.356269, -1.098784>, <1.293207, -0.283446, -1.056762>, 
      <1.592922, -0.212995, -1.287500>, <1.477341, -0.220412, -1.289480>, <1.377644, -0.351523, -1.194648>, <1.297964, -0.278700, -1.152625>, 
      <1.530545, -0.155734, -1.320289>, <1.484101, -0.202271, -1.292494>, <1.373008, -0.251184, -1.278997>, <1.301636, -0.252314, -1.278997>, 
      <1.518625, -0.148104, -1.375000>, <1.472181, -0.194641, -1.347205>, <1.374128, -0.247046, -1.375000>, <1.302756, -0.248176, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.730904, -0.148104, -1.375000>, <1.776416, -0.194221, -1.347455>, <1.872786, -0.247050, -1.375000>, <1.943182, -0.248176, -1.375000>, 
      <1.719036, -0.155736, -1.320278>, <1.764549, -0.201853, -1.292733>, <1.872462, -0.246304, -1.276184>, <1.942858, -0.247430, -1.276184>, 
      <1.633514, -0.219579, -1.301638>, <1.746081, -0.212356, -1.299710>, <1.856686, -0.308822, -1.183229>, <1.934857, -0.237435, -1.144232>, 
      <1.624764, -0.240805, -1.250000>, <1.737332, -0.233582, -1.248072>, <1.862291, -0.313298, -1.084671>, <1.940461, -0.241912, -1.045674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, 0.427042, -1.274975>, <1.592922, 0.388046, -1.304982>, <1.531339, 0.308674, -1.318979>, <1.518625, 0.297054, -1.375000>, 
      <1.495735, 0.427042, -1.273376>, <1.463893, 0.388046, -1.303383>, <1.484895, 0.355210, -1.291184>, <1.472181, 0.343591, -1.347205>, 
      <1.370120, 0.413594, -1.098434>, <1.374981, 0.439842, -1.196400>, <1.370335, 0.390697, -1.273672>, <1.374128, 0.395996, -1.375000>, 
      <1.271527, 0.353500, -1.040821>, <1.276388, 0.379747, -1.138787>, <1.298963, 0.391827, -1.273672>, <1.302756, 0.397126, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.730904, 0.297054, -1.375000>, <1.718246, 0.308676, -1.318966>, <1.634482, 0.419889, -1.332329>, <1.624764, 0.427042, -1.274975>, 
      <1.776416, 0.343171, -1.347455>, <1.763758, 0.354793, -1.291422>, <1.762218, 0.419889, -1.333912>, <1.752499, 0.427042, -1.276558>, 
      <1.872786, 0.396000, -1.375000>, <1.877012, 0.390776, -1.276162>, <1.874483, 0.439464, -1.199819>, <1.879911, 0.413528, -1.104363>, 
      <1.943182, 0.397126, -1.375000>, <1.947408, 0.391902, -1.276162>, <1.973045, 0.379436, -1.145039>, <1.978473, 0.353500, -1.049582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.519784, 0.142216, -3.500000>, <1.519784, 0.142216, -3.462500>, <1.528153, 0.148714, -3.410972>, <1.519784, 0.142216, -3.375000>, 
      <1.519784, 0.185047, -3.500000>, <1.519784, 0.185047, -3.462500>, <1.528153, 0.191545, -3.410972>, <1.519784, 0.185047, -3.375000>, 
      <1.487701, 0.241029, -3.500000>, <1.487701, 0.241029, -3.462500>, <1.493361, 0.254823, -3.409408>, <1.487701, 0.241029, -3.375000>, 
      <1.456194, 0.270043, -3.500000>, <1.456194, 0.270043, -3.462500>, <1.461853, 0.283837, -3.409408>, <1.456194, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.456194, -0.300124, -3.500000>, <1.456194, -0.300124, -3.462500>, <1.461473, -0.318788, -3.407094>, <1.456194, -0.300124, -3.375000>, 
      <1.500131, -0.173462, -3.500000>, <1.500131, -0.173462, -3.462500>, <1.505410, -0.192126, -3.407094>, <1.500131, -0.173462, -3.375000>, 
      <1.519784, 0.008150, -3.500000>, <1.519784, 0.008150, -3.462500>, <1.528153, 0.014648, -3.410972>, <1.519784, 0.008150, -3.375000>, 
      <1.519784, 0.142216, -3.500000>, <1.519784, 0.142216, -3.462500>, <1.528153, 0.148714, -3.410972>, <1.519784, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.483442, -3.500000>, <1.302756, -0.483442, -3.462500>, <1.302756, -0.508488, -3.402909>, <1.302756, -0.483442, -3.375000>, 
      <1.374473, -0.483442, -3.500000>, <1.374473, -0.483442, -3.462500>, <1.374473, -0.508488, -3.402909>, <1.374473, -0.483442, -3.375000>, 
      <1.432691, -0.367881, -3.500000>, <1.432691, -0.367881, -3.462500>, <1.437969, -0.386545, -3.407094>, <1.432691, -0.367881, -3.375000>, 
      <1.456194, -0.300124, -3.500000>, <1.456194, -0.300124, -3.462500>, <1.461473, -0.318788, -3.407094>, <1.456194, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149318, -0.300124, -3.500000>, <1.149318, -0.300124, -3.462500>, <1.144039, -0.318788, -3.407094>, <1.149318, -0.300124, -3.375000>, 
      <1.172821, -0.367881, -3.500000>, <1.172821, -0.367881, -3.462500>, <1.167542, -0.386545, -3.407094>, <1.172821, -0.367881, -3.375000>, 
      <1.231039, -0.483442, -3.500000>, <1.231039, -0.483442, -3.462500>, <1.231039, -0.508488, -3.402909>, <1.231039, -0.483442, -3.375000>, 
      <1.302756, -0.483442, -3.500000>, <1.302756, -0.483442, -3.462500>, <1.302756, -0.508488, -3.402909>, <1.302756, -0.483442, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.085728, 0.142216, -3.500000>, <1.085728, 0.142216, -3.462500>, <1.077359, 0.148714, -3.410972>, <1.085728, 0.142216, -3.375000>, 
      <1.085728, 0.008150, -3.500000>, <1.085728, 0.008150, -3.462500>, <1.077359, 0.014648, -3.410972>, <1.085728, 0.008150, -3.375000>, 
      <1.105382, -0.173462, -3.500000>, <1.105382, -0.173462, -3.462500>, <1.100103, -0.192126, -3.407094>, <1.105382, -0.173462, -3.375000>, 
      <1.149318, -0.300124, -3.500000>, <1.149318, -0.300124, -3.462500>, <1.144039, -0.318788, -3.407094>, <1.149318, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149318, 0.270043, -3.500000>, <1.149318, 0.270043, -3.462500>, <1.143658, 0.283837, -3.409408>, <1.149318, 0.270043, -3.375000>, 
      <1.117811, 0.241029, -3.500000>, <1.117811, 0.241029, -3.462500>, <1.112151, 0.254823, -3.409408>, <1.117811, 0.241029, -3.375000>, 
      <1.085728, 0.185047, -3.500000>, <1.085728, 0.185047, -3.462500>, <1.077359, 0.191545, -3.410972>, <1.085728, 0.185047, -3.375000>, 
      <1.085728, 0.142216, -3.500000>, <1.085728, 0.142216, -3.462500>, <1.077359, 0.148714, -3.410972>, <1.085728, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.342071, -3.500000>, <1.302756, 0.342071, -3.462500>, <1.302756, 0.356592, -3.409574>, <1.302756, 0.342071, -3.375000>, 
      <1.251905, 0.342071, -3.500000>, <1.251905, 0.342071, -3.462500>, <1.251905, 0.356592, -3.409574>, <1.251905, 0.342071, -3.375000>, 
      <1.186724, 0.304490, -3.500000>, <1.186724, 0.304490, -3.462500>, <1.181065, 0.318284, -3.409408>, <1.186724, 0.304490, -3.375000>, 
      <1.149318, 0.270043, -3.500000>, <1.149318, 0.270043, -3.462500>, <1.143658, 0.283837, -3.409408>, <1.149318, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.342071, -3.500000>, <1.353607, 0.342071, -3.500000>, <1.418788, 0.304490, -3.500000>, <1.456194, 0.270043, -3.500000>, 
      <1.302756, 0.342071, -3.462500>, <1.353607, 0.342071, -3.462500>, <1.418788, 0.304490, -3.462500>, <1.456194, 0.270043, -3.462500>, 
      <1.302756, 0.356592, -3.409574>, <1.353607, 0.356592, -3.409574>, <1.424447, 0.318284, -3.409408>, <1.461853, 0.283837, -3.409408>, 
      <1.302756, 0.342071, -3.375000>, <1.353607, 0.342071, -3.375000>, <1.418788, 0.304490, -3.375000>, <1.456194, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.248176, -1.875000>, <1.302756, -0.248176, -1.725000>, <1.304505, -0.241717, -1.524851>, <1.302756, -0.248176, -1.375000>, 
      <1.365306, -0.248176, -1.875000>, <1.365306, -0.248176, -1.725000>, <1.375877, -0.240587, -1.524851>, <1.374128, -0.247046, -1.375000>, 
      <1.450275, -0.203079, -1.875000>, <1.464320, -0.202133, -1.725381>, <1.440482, -0.174350, -1.492695>, <1.472181, -0.194641, -1.347205>, 
      <1.488591, -0.153639, -1.875000>, <1.502636, -0.152693, -1.725381>, <1.486926, -0.127813, -1.520490>, <1.518625, -0.148104, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, -0.153639, -1.875000>, <1.169028, -0.153639, -1.725000>, <1.146793, -0.130396, -1.521511>, <1.169028, -0.153639, -1.375000>, 
      <1.191173, -0.197483, -1.873953>, <1.191173, -0.197483, -1.723953>, <1.166352, -0.175453, -1.520434>, <1.188587, -0.198696, -1.373924>, 
      <1.253625, -0.248176, -1.875000>, <1.253625, -0.248176, -1.725000>, <1.255380, -0.242495, -1.524851>, <1.253631, -0.248954, -1.375000>, 
      <1.302756, -0.248176, -1.875000>, <1.302756, -0.248176, -1.725000>, <1.304505, -0.241717, -1.524851>, <1.302756, -0.248176, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.139788, 0.074475, -1.882708>, <1.148274, 0.074475, -1.732791>, <1.154648, 0.059730, -1.531923>, <1.162696, 0.074475, -1.382708>, 
      <1.139788, 0.005442, -1.882708>, <1.148274, 0.005442, -1.732791>, <1.154648, -0.008769, -1.531923>, <1.162696, 0.005975, -1.382708>, 
      <1.137912, -0.092034, -1.876472>, <1.137912, -0.092034, -1.726472>, <1.119523, -0.067576, -1.523011>, <1.141759, -0.090819, -1.376501>, 
      <1.169028, -0.153639, -1.875000>, <1.169028, -0.153639, -1.725000>, <1.146793, -0.130396, -1.521511>, <1.169028, -0.153639, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, 0.302589, -1.875000>, <1.169028, 0.321515, -1.726199>, <1.166029, 0.327252, -1.522928>, <1.169028, 0.302589, -1.375000>, 
      <1.137912, 0.240984, -1.876472>, <1.137912, 0.259910, -1.727670>, <1.138760, 0.264432, -1.524429>, <1.141759, 0.239769, -1.376501>, 
      <1.139788, 0.143508, -1.882708>, <1.148274, 0.143508, -1.732791>, <1.154648, 0.128230, -1.531923>, <1.162696, 0.142975, -1.382708>, 
      <1.139788, 0.074475, -1.882708>, <1.148274, 0.074475, -1.732791>, <1.154648, 0.059730, -1.531923>, <1.162696, 0.074475, -1.382708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.397126, -1.875000>, <1.302756, 0.416052, -1.726199>, <1.308360, 0.404955, -1.524691>, <1.302756, 0.397126, -1.375000>, 
      <1.253625, 0.397126, -1.875000>, <1.253625, 0.416052, -1.726199>, <1.259235, 0.405732, -1.524691>, <1.253631, 0.397904, -1.375000>, 
      <1.191173, 0.346433, -1.873953>, <1.191173, 0.365359, -1.725151>, <1.185588, 0.372309, -1.521852>, <1.188587, 0.347646, -1.373924>, 
      <1.169028, 0.302589, -1.875000>, <1.169028, 0.321515, -1.726199>, <1.166029, 0.327252, -1.522928>, <1.169028, 0.302589, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.397126, -1.875000>, <1.302756, 0.416052, -1.726199>, <1.308360, 0.404955, -1.524691>, <1.302756, 0.397126, -1.375000>, 
      <1.365306, 0.397126, -1.875000>, <1.365306, 0.416052, -1.726199>, <1.379732, 0.403824, -1.524691>, <1.374128, 0.395996, -1.375000>, 
      <1.450275, 0.352029, -1.875000>, <1.464220, 0.369983, -1.726450>, <1.439582, 0.313797, -1.490849>, <1.472181, 0.343591, -1.347205>, 
      <1.488591, 0.302589, -1.875000>, <1.502536, 0.320543, -1.726450>, <1.486026, 0.267260, -1.518644>, <1.518625, 0.297054, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, 0.074475, -1.567711>, <1.530084, 0.074475, -1.567711>, <1.570906, 0.074475, -1.782065>, <1.552809, 0.074475, -1.875000>, 
      <1.624764, 0.168363, -1.567711>, <1.530084, 0.168363, -1.567711>, <1.570906, 0.145569, -1.782065>, <1.552809, 0.145569, -1.875000>, 
      <1.579713, 0.235844, -1.411559>, <1.547114, 0.206050, -1.555203>, <1.546086, 0.264349, -1.726450>, <1.532141, 0.246395, -1.875000>, 
      <1.518625, 0.297054, -1.375000>, <1.486026, 0.267260, -1.518644>, <1.502536, 0.320543, -1.726450>, <1.488591, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, 0.074475, -1.567711>, <1.624764, 0.168363, -1.567711>, <1.579713, 0.235844, -1.411559>, <1.518625, 0.297054, -1.375000>, 
      <1.624764, 0.168363, -1.567711>, <1.624764, 0.262252, -1.567711>, <1.592427, 0.247464, -1.355538>, <1.531339, 0.308674, -1.318979>, 
      <1.670211, 0.235555, -1.411732>, <1.657553, 0.247177, -1.355698>, <1.602641, 0.380893, -1.362336>, <1.592922, 0.388046, -1.304982>, 
      <1.730904, 0.297054, -1.375000>, <1.718246, 0.308676, -1.318966>, <1.634482, 0.419889, -1.332329>, <1.624764, 0.427042, -1.274975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, 0.074475, -1.567711>, <1.530084, 0.074475, -1.567711>, <1.570906, 0.074475, -1.782065>, <1.552809, 0.074475, -1.875000>, 
      <1.624764, -0.019413, -1.567711>, <1.530084, -0.019413, -1.567711>, <1.570906, 0.003381, -1.782065>, <1.552809, 0.003381, -1.875000>, 
      <1.579713, -0.086894, -1.411559>, <1.548014, -0.066603, -1.557049>, <1.546186, -0.096498, -1.725381>, <1.532141, -0.097445, -1.875000>, 
      <1.518625, -0.148104, -1.375000>, <1.486926, -0.127813, -1.520490>, <1.502636, -0.152693, -1.725381>, <1.488591, -0.153639, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, 0.074475, -1.567711>, <1.624764, -0.019413, -1.567711>, <1.670211, -0.086605, -1.411732>, <1.730904, -0.148104, -1.375000>, 
      <1.624764, -0.019413, -1.567711>, <1.624764, -0.113302, -1.567711>, <1.658344, -0.094236, -1.357010>, <1.719036, -0.155736, -1.320278>, 
      <1.579713, -0.086894, -1.411559>, <1.591633, -0.094524, -1.356849>, <1.601672, -0.191769, -1.339138>, <1.633514, -0.219579, -1.301638>, 
      <1.518625, -0.148104, -1.375000>, <1.530545, -0.155734, -1.320289>, <1.592922, -0.212995, -1.287500>, <1.624764, -0.240805, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.491906, 0.074475, -2.250000>, <1.506925, 0.074475, -2.137020>, <1.531025, 0.074475, -1.986873>, <1.552809, 0.074475, -1.875000>, 
      <1.491906, 0.113266, -2.250000>, <1.506925, 0.113266, -2.137020>, <1.531025, 0.145569, -1.986873>, <1.552809, 0.145569, -1.875000>, 
      <1.462354, 0.162394, -2.250000>, <1.475192, 0.189426, -2.135458>, <1.521156, 0.232251, -1.992024>, <1.532141, 0.246395, -1.875000>, 
      <1.436485, 0.191300, -2.250000>, <1.449323, 0.218332, -2.135458>, <1.477605, 0.288445, -1.992024>, <1.488591, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.436485, -0.153639, -2.250000>, <1.449135, -0.155154, -2.137136>, <1.477976, -0.154354, -1.988081>, <1.488591, -0.153639, -1.875000>, 
      <1.472102, -0.092884, -2.250000>, <1.484752, -0.094399, -2.137136>, <1.521526, -0.098160, -1.988081>, <1.532141, -0.097445, -1.875000>, 
      <1.491906, 0.004050, -2.250000>, <1.506925, 0.004050, -2.137020>, <1.531025, 0.003381, -1.986873>, <1.552809, 0.003381, -1.875000>, 
      <1.491906, 0.074475, -2.250000>, <1.506925, 0.074475, -2.137020>, <1.531025, 0.074475, -1.986873>, <1.552809, 0.074475, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.248176, -2.250000>, <1.302756, -0.250312, -2.137520>, <1.302756, -0.248176, -1.987500>, <1.302756, -0.248176, -1.875000>, 
      <1.351887, -0.248176, -2.250000>, <1.351887, -0.250312, -2.137520>, <1.365306, -0.248176, -1.987500>, <1.365306, -0.248176, -1.875000>, 
      <1.411638, -0.196024, -2.250000>, <1.424287, -0.197539, -2.137136>, <1.439660, -0.203795, -1.988081>, <1.450275, -0.203079, -1.875000>, 
      <1.436485, -0.153639, -2.250000>, <1.449135, -0.155154, -2.137136>, <1.477976, -0.154354, -1.988081>, <1.488591, -0.153639, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, -0.153639, -2.250000>, <1.168143, -0.155149, -2.137514>, <1.169028, -0.153639, -1.987500>, <1.169028, -0.153639, -1.875000>, 
      <1.193875, -0.196023, -2.250000>, <1.192990, -0.197533, -2.137514>, <1.191173, -0.197483, -1.986453>, <1.191173, -0.197483, -1.873953>, 
      <1.253625, -0.248176, -2.250000>, <1.253625, -0.250312, -2.137520>, <1.253625, -0.248176, -1.987500>, <1.253625, -0.248176, -1.875000>, 
      <1.302756, -0.248176, -2.250000>, <1.302756, -0.250312, -2.137520>, <1.302756, -0.248176, -1.987500>, <1.302756, -0.248176, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.113606, 0.074475, -2.250000>, <1.118228, 0.074475, -2.139630>, <1.133545, 0.074475, -1.992999>, <1.139788, 0.074475, -1.882708>, 
      <1.113606, 0.004050, -2.250000>, <1.118228, 0.004050, -2.139630>, <1.133545, 0.005442, -1.992999>, <1.139788, 0.005442, -1.882708>, 
      <1.133411, -0.092884, -2.250000>, <1.132526, -0.094394, -2.137514>, <1.137912, -0.092034, -1.988972>, <1.137912, -0.092034, -1.876472>, 
      <1.169028, -0.153639, -2.250000>, <1.168143, -0.155149, -2.137514>, <1.169028, -0.153639, -1.987500>, <1.169028, -0.153639, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, 0.191300, -2.250000>, <1.168129, 0.218253, -2.135791>, <1.169028, 0.287783, -1.991412>, <1.169028, 0.302589, -1.875000>, 
      <1.143159, 0.162394, -2.250000>, <1.142261, 0.189347, -2.135791>, <1.137912, 0.226178, -1.992883>, <1.137912, 0.240984, -1.876472>, 
      <1.113606, 0.113266, -2.250000>, <1.118228, 0.113266, -2.139630>, <1.133545, 0.143508, -1.992999>, <1.139788, 0.143508, -1.882708>, 
      <1.113606, 0.074475, -2.250000>, <1.118228, 0.074475, -2.139630>, <1.133545, 0.074475, -1.992999>, <1.139788, 0.074475, -1.882708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.285836, -2.250000>, <1.302756, 0.313391, -2.135931>, <1.302756, 0.382320, -1.991412>, <1.302756, 0.397126, -1.875000>, 
      <1.253625, 0.285836, -2.250000>, <1.253625, 0.313391, -2.135931>, <1.253625, 0.382320, -1.991412>, <1.253625, 0.397126, -1.875000>, 
      <1.201792, 0.227911, -2.250000>, <1.200893, 0.254864, -2.135791>, <1.191173, 0.331627, -1.990364>, <1.191173, 0.346433, -1.873953>, 
      <1.169028, 0.191300, -2.250000>, <1.168129, 0.218253, -2.135791>, <1.169028, 0.287783, -1.991412>, <1.169028, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.285836, -2.250000>, <1.351887, 0.285836, -2.250000>, <1.403721, 0.227911, -2.250000>, <1.436485, 0.191300, -2.250000>, 
      <1.302756, 0.313391, -2.135931>, <1.351887, 0.313391, -2.135931>, <1.416559, 0.254943, -2.135458>, <1.449323, 0.218332, -2.135458>, 
      <1.302756, 0.382320, -1.991412>, <1.365306, 0.382320, -1.991412>, <1.439290, 0.337886, -1.992024>, <1.477605, 0.288445, -1.992024>, 
      <1.302756, 0.397126, -1.875000>, <1.365306, 0.397126, -1.875000>, <1.450275, 0.352029, -1.875000>, <1.488591, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486341, 0.074475, -2.375000>, <1.487176, 0.074475, -2.337472>, <1.486960, 0.074475, -2.287210>, <1.491906, 0.074475, -2.250000>, 
      <1.486341, 0.111240, -2.375000>, <1.487176, 0.111240, -2.337472>, <1.486960, 0.113266, -2.287210>, <1.491906, 0.113266, -2.250000>, 
      <1.457287, 0.157389, -2.375000>, <1.457878, 0.158397, -2.337446>, <1.458279, 0.153814, -2.286352>, <1.462354, 0.162394, -2.250000>, 
      <1.432551, 0.184588, -2.375000>, <1.433142, 0.185596, -2.337446>, <1.432411, 0.182721, -2.286352>, <1.436485, 0.191300, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432551, -0.146928, -2.375000>, <1.433142, -0.147936, -2.337446>, <1.432300, -0.153138, -2.287335>, <1.436485, -0.153639, -2.250000>, 
      <1.467120, -0.087961, -2.375000>, <1.467711, -0.088969, -2.337446>, <1.467917, -0.092383, -2.287335>, <1.472102, -0.092884, -2.250000>, 
      <1.486341, 0.006122, -2.375000>, <1.487176, 0.006122, -2.337472>, <1.486960, 0.004050, -2.287210>, <1.491906, 0.004050, -2.250000>, 
      <1.486341, 0.074475, -2.375000>, <1.487176, 0.074475, -2.337472>, <1.486960, 0.074475, -2.287210>, <1.491906, 0.074475, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.238683, -2.375000>, <1.302756, -0.240110, -2.337419>, <1.302756, -0.247462, -2.287601>, <1.302756, -0.248176, -2.250000>, 
      <1.350442, -0.238683, -2.375000>, <1.350442, -0.240110, -2.337419>, <1.351887, -0.247462, -2.287601>, <1.351887, -0.248176, -2.250000>, 
      <1.408435, -0.188066, -2.375000>, <1.409025, -0.189074, -2.337446>, <1.407453, -0.195523, -2.287335>, <1.411638, -0.196024, -2.250000>, 
      <1.432551, -0.146928, -2.375000>, <1.433142, -0.147936, -2.337446>, <1.432300, -0.153138, -2.287335>, <1.436485, -0.153639, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, -0.146928, -2.375000>, <1.172371, -0.147936, -2.337446>, <1.169324, -0.153135, -2.287568>, <1.169028, -0.153639, -2.250000>, 
      <1.197078, -0.188066, -2.375000>, <1.196487, -0.189074, -2.337446>, <1.194171, -0.195519, -2.287568>, <1.193875, -0.196023, -2.250000>, 
      <1.255071, -0.238683, -2.375000>, <1.255071, -0.240110, -2.337419>, <1.253625, -0.247462, -2.287601>, <1.253625, -0.248176, -2.250000>, 
      <1.302756, -0.238683, -2.375000>, <1.302756, -0.240110, -2.337419>, <1.302756, -0.247462, -2.287601>, <1.302756, -0.248176, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.119171, 0.074475, -2.375000>, <1.118336, 0.074475, -2.337472>, <1.112035, 0.074475, -2.287504>, <1.113606, 0.074475, -2.250000>, 
      <1.119171, 0.006122, -2.375000>, <1.118336, 0.006122, -2.337472>, <1.112035, 0.004050, -2.287504>, <1.113606, 0.004050, -2.250000>, 
      <1.138393, -0.087961, -2.375000>, <1.137802, -0.088969, -2.337446>, <1.133707, -0.092380, -2.287568>, <1.133411, -0.092884, -2.250000>, 
      <1.172962, -0.146928, -2.375000>, <1.172371, -0.147936, -2.337446>, <1.169324, -0.153135, -2.287568>, <1.169028, -0.153639, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, 0.184588, -2.375000>, <1.172371, 0.185596, -2.337446>, <1.169316, 0.182670, -2.286567>, <1.169028, 0.191300, -2.250000>, 
      <1.148226, 0.157389, -2.375000>, <1.147635, 0.158397, -2.337446>, <1.143447, 0.153764, -2.286567>, <1.143159, 0.162394, -2.250000>, 
      <1.119171, 0.111240, -2.375000>, <1.118336, 0.111240, -2.337472>, <1.112035, 0.113266, -2.287504>, <1.113606, 0.113266, -2.250000>, 
      <1.119171, 0.074475, -2.375000>, <1.118336, 0.074475, -2.337472>, <1.112035, 0.074475, -2.287504>, <1.113606, 0.074475, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.276343, -2.375000>, <1.302756, 0.277770, -2.337419>, <1.302756, 0.277005, -2.286556>, <1.302756, 0.285836, -2.250000>, 
      <1.255071, 0.276343, -2.375000>, <1.255071, 0.277770, -2.337419>, <1.253625, 0.277005, -2.286556>, <1.253625, 0.285836, -2.250000>, 
      <1.205045, 0.219866, -2.375000>, <1.204454, 0.220875, -2.337446>, <1.202079, 0.219281, -2.286567>, <1.201792, 0.227911, -2.250000>, 
      <1.172962, 0.184588, -2.375000>, <1.172371, 0.185596, -2.337446>, <1.169316, 0.182670, -2.286567>, <1.169028, 0.191300, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.276343, -2.375000>, <1.350442, 0.276343, -2.375000>, <1.400468, 0.219866, -2.375000>, <1.432551, 0.184588, -2.375000>, 
      <1.302756, 0.277770, -2.337419>, <1.350442, 0.277770, -2.337419>, <1.401059, 0.220875, -2.337446>, <1.433142, 0.185596, -2.337446>, 
      <1.302756, 0.277005, -2.286556>, <1.351887, 0.277005, -2.286556>, <1.399647, 0.219332, -2.286352>, <1.432411, 0.182721, -2.286352>, 
      <1.302756, 0.285836, -2.250000>, <1.351887, 0.285836, -2.250000>, <1.403721, 0.227911, -2.250000>, <1.436485, 0.191300, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486341, 0.074475, -2.500000>, <1.490353, 0.074475, -2.462715>, <1.485506, 0.074475, -2.412491>, <1.486341, 0.074475, -2.375000>, 
      <1.486341, 0.111240, -2.500000>, <1.490353, 0.111240, -2.462715>, <1.485506, 0.111240, -2.412491>, <1.486341, 0.111240, -2.375000>, 
      <1.457287, 0.157389, -2.500000>, <1.460108, 0.162201, -2.462917>, <1.456697, 0.156383, -2.412482>, <1.457287, 0.157389, -2.375000>, 
      <1.432551, 0.184588, -2.500000>, <1.435372, 0.189400, -2.462917>, <1.431961, 0.183582, -2.412482>, <1.432551, 0.184588, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432551, -0.146928, -2.500000>, <1.435372, -0.151740, -2.462917>, <1.431961, -0.145922, -2.412482>, <1.432551, -0.146928, -2.375000>, 
      <1.467120, -0.087961, -2.500000>, <1.469941, -0.092773, -2.462917>, <1.466530, -0.086955, -2.412482>, <1.467120, -0.087961, -2.375000>, 
      <1.486341, 0.006122, -2.500000>, <1.490353, 0.006122, -2.462715>, <1.485506, 0.006122, -2.412491>, <1.486341, 0.006122, -2.375000>, 
      <1.486341, 0.074475, -2.500000>, <1.490353, 0.074475, -2.462715>, <1.485506, 0.074475, -2.412491>, <1.486341, 0.074475, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.238683, -2.500000>, <1.302756, -0.245453, -2.463116>, <1.302756, -0.237260, -2.412473>, <1.302756, -0.238683, -2.375000>, 
      <1.350442, -0.238683, -2.500000>, <1.350442, -0.245453, -2.463116>, <1.350442, -0.237260, -2.412473>, <1.350442, -0.238683, -2.375000>, 
      <1.408435, -0.188066, -2.500000>, <1.411256, -0.192878, -2.462917>, <1.407845, -0.187060, -2.412482>, <1.408435, -0.188066, -2.375000>, 
      <1.432551, -0.146928, -2.500000>, <1.435372, -0.151740, -2.462917>, <1.431961, -0.145922, -2.412482>, <1.432551, -0.146928, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, -0.146928, -2.500000>, <1.170141, -0.151740, -2.462917>, <1.173552, -0.145922, -2.412482>, <1.172962, -0.146928, -2.375000>, 
      <1.197078, -0.188066, -2.500000>, <1.194257, -0.192878, -2.462917>, <1.197668, -0.187059, -2.412482>, <1.197078, -0.188066, -2.375000>, 
      <1.255071, -0.238683, -2.500000>, <1.255071, -0.245453, -2.463116>, <1.255071, -0.237260, -2.412473>, <1.255071, -0.238683, -2.375000>, 
      <1.302756, -0.238683, -2.500000>, <1.302756, -0.245453, -2.463116>, <1.302756, -0.237260, -2.412473>, <1.302756, -0.238683, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.119171, 0.074475, -2.500000>, <1.115159, 0.074475, -2.462715>, <1.120006, 0.074475, -2.412491>, <1.119171, 0.074475, -2.375000>, 
      <1.119171, 0.006122, -2.500000>, <1.115159, 0.006122, -2.462715>, <1.120006, 0.006122, -2.412491>, <1.119171, 0.006122, -2.375000>, 
      <1.138393, -0.087961, -2.500000>, <1.135572, -0.092773, -2.462917>, <1.138983, -0.086955, -2.412482>, <1.138393, -0.087961, -2.375000>, 
      <1.172962, -0.146928, -2.500000>, <1.170141, -0.151740, -2.462917>, <1.173552, -0.145922, -2.412482>, <1.172962, -0.146928, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, 0.184588, -2.500000>, <1.170141, 0.189400, -2.462917>, <1.173552, 0.183582, -2.412482>, <1.172962, 0.184588, -2.375000>, 
      <1.148226, 0.157389, -2.500000>, <1.145405, 0.162201, -2.462917>, <1.148816, 0.156383, -2.412482>, <1.148226, 0.157389, -2.375000>, 
      <1.119171, 0.111240, -2.500000>, <1.115159, 0.111240, -2.462715>, <1.120006, 0.111240, -2.412491>, <1.119171, 0.111240, -2.375000>, 
      <1.119171, 0.074475, -2.500000>, <1.115159, 0.074475, -2.462715>, <1.120006, 0.074475, -2.412491>, <1.119171, 0.074475, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.276343, -2.500000>, <1.302756, 0.283113, -2.463116>, <1.302756, 0.274920, -2.412473>, <1.302756, 0.276343, -2.375000>, 
      <1.255071, 0.276343, -2.500000>, <1.255071, 0.283113, -2.463116>, <1.255071, 0.274920, -2.412473>, <1.255071, 0.276343, -2.375000>, 
      <1.205045, 0.219866, -2.500000>, <1.202224, 0.224678, -2.462917>, <1.205635, 0.218860, -2.412482>, <1.205045, 0.219866, -2.375000>, 
      <1.172962, 0.184588, -2.500000>, <1.170141, 0.189400, -2.462917>, <1.173552, 0.183582, -2.412482>, <1.172962, 0.184588, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.276343, -2.500000>, <1.350442, 0.276343, -2.500000>, <1.400468, 0.219866, -2.500000>, <1.432551, 0.184588, -2.500000>, 
      <1.302756, 0.283113, -2.463116>, <1.350442, 0.283113, -2.463116>, <1.403289, 0.224679, -2.462917>, <1.435372, 0.189400, -2.462917>, 
      <1.302756, 0.274920, -2.412473>, <1.350442, 0.274920, -2.412473>, <1.399878, 0.218860, -2.412482>, <1.431961, 0.183582, -2.412482>, 
      <1.302756, 0.276343, -2.375000>, <1.350442, 0.276343, -2.375000>, <1.400468, 0.219866, -2.375000>, <1.432551, 0.184588, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432542, 0.074475, -2.875000>, <1.442289, 0.074475, -2.761767>, <1.474183, 0.074475, -2.613000>, <1.486341, 0.074475, -2.500000>, 
      <1.432542, 0.092203, -2.875000>, <1.442289, 0.092203, -2.761767>, <1.474183, 0.111240, -2.613000>, <1.486341, 0.111240, -2.500000>, 
      <1.408033, 0.108238, -2.875000>, <1.414966, 0.120064, -2.761081>, <1.448655, 0.142665, -2.613464>, <1.457287, 0.157389, -2.500000>, 
      <1.394514, 0.119706, -2.875000>, <1.401447, 0.131532, -2.761081>, <1.423919, 0.169865, -2.613464>, <1.432551, 0.184588, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394514, -0.082045, -2.875000>, <1.401447, -0.093871, -2.761081>, <1.423919, -0.132204, -2.613464>, <1.432551, -0.146928, -2.500000>, 
      <1.418952, -0.040358, -2.875000>, <1.425885, -0.052185, -2.761081>, <1.458488, -0.073237, -2.613464>, <1.467120, -0.087961, -2.500000>, 
      <1.432542, 0.026153, -2.875000>, <1.442289, 0.026153, -2.761767>, <1.474183, 0.006122, -2.613000>, <1.486341, 0.006122, -2.500000>, 
      <1.432542, 0.074475, -2.875000>, <1.442289, 0.074475, -2.761767>, <1.474183, 0.074475, -2.613000>, <1.486341, 0.074475, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.146912, -2.875000>, <1.302756, -0.163738, -2.760409>, <1.302756, -0.217775, -2.613917>, <1.302756, -0.238683, -2.500000>, 
      <1.336467, -0.146912, -2.875000>, <1.336467, -0.163738, -2.760409>, <1.350442, -0.217775, -2.613917>, <1.350442, -0.238683, -2.500000>, 
      <1.377465, -0.111127, -2.875000>, <1.384398, -0.122953, -2.761081>, <1.399803, -0.173342, -2.613464>, <1.408435, -0.188066, -2.500000>, 
      <1.394514, -0.082045, -2.875000>, <1.401447, -0.093871, -2.761081>, <1.423919, -0.132204, -2.613464>, <1.432551, -0.146928, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.082045, -2.875000>, <1.204066, -0.093871, -2.761081>, <1.181594, -0.132204, -2.613464>, <1.172962, -0.146928, -2.500000>, 
      <1.228048, -0.111127, -2.875000>, <1.221115, -0.122953, -2.761081>, <1.205710, -0.173342, -2.613464>, <1.197078, -0.188066, -2.500000>, 
      <1.269045, -0.146912, -2.875000>, <1.269045, -0.163738, -2.760409>, <1.255071, -0.217775, -2.613917>, <1.255071, -0.238683, -2.500000>, 
      <1.302756, -0.146912, -2.875000>, <1.302756, -0.163738, -2.760409>, <1.302756, -0.217775, -2.613917>, <1.302756, -0.238683, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172971, 0.074475, -2.875000>, <1.163224, 0.074475, -2.761767>, <1.131330, 0.074475, -2.613000>, <1.119171, 0.074475, -2.500000>, 
      <1.172971, 0.026153, -2.875000>, <1.163224, 0.026153, -2.761767>, <1.131330, 0.006122, -2.613000>, <1.119171, 0.006122, -2.500000>, 
      <1.186561, -0.040358, -2.875000>, <1.179628, -0.052184, -2.761081>, <1.147025, -0.073237, -2.613464>, <1.138393, -0.087961, -2.500000>, 
      <1.210999, -0.082045, -2.875000>, <1.204066, -0.093871, -2.761081>, <1.181594, -0.132204, -2.613464>, <1.172962, -0.146928, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, 0.119706, -2.875000>, <1.204066, 0.131532, -2.761081>, <1.181594, 0.169865, -2.613464>, <1.172962, 0.184588, -2.500000>, 
      <1.197480, 0.108238, -2.875000>, <1.190547, 0.120064, -2.761081>, <1.156858, 0.142665, -2.613464>, <1.148226, 0.157389, -2.500000>, 
      <1.172971, 0.092203, -2.875000>, <1.163224, 0.092203, -2.761767>, <1.131330, 0.111240, -2.613000>, <1.119171, 0.111240, -2.500000>, 
      <1.172971, 0.074475, -2.875000>, <1.163224, 0.074475, -2.761767>, <1.131330, 0.074475, -2.613000>, <1.119171, 0.074475, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.184572, -2.875000>, <1.302756, 0.201398, -2.760409>, <1.302756, 0.255435, -2.613917>, <1.302756, 0.276343, -2.500000>, 
      <1.269045, 0.184572, -2.875000>, <1.269045, 0.201398, -2.760409>, <1.255071, 0.255435, -2.613917>, <1.255071, 0.276343, -2.500000>, 
      <1.236706, 0.141513, -2.875000>, <1.229773, 0.153339, -2.761081>, <1.213677, 0.205143, -2.613464>, <1.205045, 0.219866, -2.500000>, 
      <1.210999, 0.119706, -2.875000>, <1.204066, 0.131532, -2.761081>, <1.181594, 0.169865, -2.613464>, <1.172962, 0.184588, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.184572, -2.875000>, <1.336467, 0.184572, -2.875000>, <1.368807, 0.141513, -2.875000>, <1.394514, 0.119706, -2.875000>, 
      <1.302756, 0.201398, -2.760409>, <1.336467, 0.201398, -2.760409>, <1.375739, 0.153339, -2.761081>, <1.401447, 0.131532, -2.761081>, 
      <1.302756, 0.255435, -2.613917>, <1.350442, 0.255435, -2.613917>, <1.391836, 0.205143, -2.613464>, <1.423919, 0.169865, -2.613464>, 
      <1.302756, 0.276343, -2.500000>, <1.350442, 0.276343, -2.500000>, <1.400468, 0.219866, -2.500000>, <1.432551, 0.184588, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432542, 0.074475, -3.125000>, <1.432542, 0.092203, -3.125000>, <1.408033, 0.108238, -3.125000>, <1.394514, 0.119706, -3.125000>, 
      <1.446512, 0.085322, -3.205064>, <1.446512, 0.103050, -3.205064>, <1.418527, 0.133817, -3.210071>, <1.405008, 0.145285, -3.210071>, 
      <1.501486, 0.128008, -3.296347>, <1.501486, 0.170839, -3.296347>, <1.474201, 0.208125, -3.292923>, <1.442694, 0.237139, -3.292923>, 
      <1.519784, 0.142216, -3.375000>, <1.519784, 0.185047, -3.375000>, <1.487701, 0.241029, -3.375000>, <1.456194, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432542, 0.074475, -3.125000>, <1.419764, 0.064553, -3.051766>, <1.426110, 0.074475, -2.949724>, <1.432542, 0.074475, -2.875000>, 
      <1.432542, 0.092203, -3.125000>, <1.419764, 0.082281, -3.051766>, <1.426110, 0.092203, -2.949724>, <1.432542, 0.092203, -2.875000>, 
      <1.408033, 0.108238, -3.125000>, <1.399234, 0.086792, -3.053672>, <1.403501, 0.100508, -2.949463>, <1.408033, 0.108238, -2.875000>, 
      <1.394514, 0.119706, -3.125000>, <1.385715, 0.098260, -3.053672>, <1.389982, 0.111976, -2.949463>, <1.394514, 0.119706, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394514, -0.082045, -3.125000>, <1.386087, -0.052251, -3.056690>, <1.389982, -0.074315, -2.949463>, <1.394514, -0.082045, -2.875000>, 
      <1.418952, -0.040358, -3.125000>, <1.410526, -0.010564, -3.056690>, <1.414421, -0.032628, -2.949463>, <1.418952, -0.040358, -2.875000>, 
      <1.432542, 0.026153, -3.125000>, <1.419764, 0.016231, -3.051766>, <1.426110, 0.026153, -2.949724>, <1.432542, 0.026153, -2.875000>, 
      <1.432542, 0.074475, -3.125000>, <1.419764, 0.064553, -3.051766>, <1.426110, 0.074475, -2.949724>, <1.432542, 0.074475, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394514, -0.082045, -3.125000>, <1.418952, -0.040358, -3.125000>, <1.432542, 0.026153, -3.125000>, <1.432542, 0.074475, -3.125000>, 
      <1.405888, -0.122259, -3.217201>, <1.430326, -0.080573, -3.217201>, <1.446512, 0.037000, -3.205064>, <1.446512, 0.085322, -3.205064>, 
      <1.441944, -0.249740, -3.288362>, <1.485880, -0.123078, -3.288362>, <1.501486, -0.006058, -3.296347>, <1.501486, 0.128008, -3.296347>, 
      <1.456194, -0.300124, -3.375000>, <1.500131, -0.173462, -3.375000>, <1.519784, 0.008150, -3.375000>, <1.519784, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.146912, -3.125000>, <1.336467, -0.146912, -3.125000>, <1.377465, -0.111127, -3.125000>, <1.394514, -0.082045, -3.125000>, 
      <1.302756, -0.217137, -3.229337>, <1.336467, -0.217137, -3.229337>, <1.388839, -0.151342, -3.217201>, <1.405888, -0.122259, -3.217201>, 
      <1.302756, -0.399441, -3.281397>, <1.374473, -0.399441, -3.281397>, <1.418441, -0.317497, -3.288362>, <1.441944, -0.249740, -3.288362>, 
      <1.302756, -0.483442, -3.375000>, <1.374473, -0.483442, -3.375000>, <1.432691, -0.367881, -3.375000>, <1.456194, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.146912, -3.125000>, <1.302756, -0.105035, -3.062780>, <1.302756, -0.136016, -2.949204>, <1.302756, -0.146912, -2.875000>, 
      <1.336467, -0.146912, -3.125000>, <1.336467, -0.105035, -3.062780>, <1.336467, -0.136016, -2.949204>, <1.336467, -0.146912, -2.875000>, 
      <1.377465, -0.111127, -3.125000>, <1.369038, -0.081333, -3.056690>, <1.372933, -0.103397, -2.949463>, <1.377465, -0.111127, -2.875000>, 
      <1.394514, -0.082045, -3.125000>, <1.386087, -0.052251, -3.056690>, <1.389982, -0.074315, -2.949463>, <1.394514, -0.082045, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.082045, -3.125000>, <1.228048, -0.111127, -3.125000>, <1.269045, -0.146912, -3.125000>, <1.302756, -0.146912, -3.125000>, 
      <1.199625, -0.122259, -3.217201>, <1.216674, -0.151341, -3.217201>, <1.269045, -0.217137, -3.229337>, <1.302756, -0.217137, -3.229337>, 
      <1.163568, -0.249740, -3.288362>, <1.187072, -0.317497, -3.288362>, <1.231039, -0.399441, -3.281397>, <1.302756, -0.399441, -3.281397>, 
      <1.149318, -0.300124, -3.375000>, <1.172821, -0.367881, -3.375000>, <1.231039, -0.483442, -3.375000>, <1.302756, -0.483442, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.082045, -3.125000>, <1.219426, -0.052251, -3.056690>, <1.215531, -0.074315, -2.949463>, <1.210999, -0.082045, -2.875000>, 
      <1.228048, -0.111127, -3.125000>, <1.236475, -0.081333, -3.056690>, <1.232580, -0.103397, -2.949463>, <1.228048, -0.111127, -2.875000>, 
      <1.269045, -0.146912, -3.125000>, <1.269045, -0.105035, -3.062780>, <1.269045, -0.136016, -2.949204>, <1.269045, -0.146912, -2.875000>, 
      <1.302756, -0.146912, -3.125000>, <1.302756, -0.105035, -3.062780>, <1.302756, -0.136016, -2.949204>, <1.302756, -0.146912, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172971, 0.074475, -3.125000>, <1.172971, 0.026153, -3.125000>, <1.186561, -0.040358, -3.125000>, <1.210999, -0.082045, -3.125000>, 
      <1.159001, 0.085322, -3.205064>, <1.159001, 0.037000, -3.205064>, <1.175187, -0.080573, -3.217201>, <1.199625, -0.122259, -3.217201>, 
      <1.104027, 0.128008, -3.296347>, <1.104027, -0.006058, -3.296347>, <1.119632, -0.123078, -3.288362>, <1.163568, -0.249740, -3.288362>, 
      <1.085728, 0.142216, -3.375000>, <1.085728, 0.008150, -3.375000>, <1.105382, -0.173462, -3.375000>, <1.149318, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172971, 0.074475, -3.125000>, <1.185749, 0.064553, -3.051766>, <1.179403, 0.074475, -2.949724>, <1.172971, 0.074475, -2.875000>, 
      <1.172971, 0.026153, -3.125000>, <1.185749, 0.016231, -3.051766>, <1.179403, 0.026153, -2.949724>, <1.172971, 0.026153, -2.875000>, 
      <1.186561, -0.040358, -3.125000>, <1.194988, -0.010564, -3.056690>, <1.191093, -0.032628, -2.949463>, <1.186561, -0.040358, -2.875000>, 
      <1.210999, -0.082045, -3.125000>, <1.219426, -0.052251, -3.056690>, <1.215531, -0.074315, -2.949463>, <1.210999, -0.082045, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, 0.119706, -3.125000>, <1.197480, 0.108238, -3.125000>, <1.172971, 0.092203, -3.125000>, <1.172971, 0.074475, -3.125000>, 
      <1.200504, 0.145285, -3.210071>, <1.186986, 0.133817, -3.210071>, <1.159001, 0.103050, -3.205064>, <1.159001, 0.085322, -3.205064>, 
      <1.162818, 0.237139, -3.292923>, <1.131311, 0.208125, -3.292923>, <1.104027, 0.170839, -3.296347>, <1.104027, 0.128008, -3.296347>, 
      <1.149318, 0.270043, -3.375000>, <1.117811, 0.241029, -3.375000>, <1.085728, 0.185047, -3.375000>, <1.085728, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, 0.119706, -3.125000>, <1.219798, 0.098260, -3.053672>, <1.215531, 0.111976, -2.949463>, <1.210999, 0.119706, -2.875000>, 
      <1.197480, 0.108238, -3.125000>, <1.206279, 0.086791, -3.053672>, <1.202012, 0.100508, -2.949463>, <1.197480, 0.108238, -2.875000>, 
      <1.172971, 0.092203, -3.125000>, <1.185749, 0.082281, -3.051766>, <1.179403, 0.092203, -2.949724>, <1.172971, 0.092203, -2.875000>, 
      <1.172971, 0.074475, -3.125000>, <1.185749, 0.064553, -3.051766>, <1.179403, 0.074475, -2.949724>, <1.172971, 0.074475, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.184572, -3.125000>, <1.269045, 0.184572, -3.125000>, <1.236706, 0.141513, -3.125000>, <1.210999, 0.119706, -3.125000>, 
      <1.302756, 0.211204, -3.209547>, <1.269045, 0.211204, -3.209547>, <1.226212, 0.167092, -3.210071>, <1.200504, 0.145285, -3.210071>, 
      <1.302756, 0.307746, -3.293273>, <1.251905, 0.307746, -3.293273>, <1.200225, 0.271585, -3.292923>, <1.162818, 0.237139, -3.292923>, 
      <1.302756, 0.342071, -3.375000>, <1.251905, 0.342071, -3.375000>, <1.186724, 0.304490, -3.375000>, <1.149318, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.184572, -3.125000>, <1.302756, 0.162039, -3.053465>, <1.302756, 0.173676, -2.949204>, <1.302756, 0.184572, -2.875000>, 
      <1.269045, 0.184572, -3.125000>, <1.269045, 0.162039, -3.053465>, <1.269045, 0.173676, -2.949204>, <1.269045, 0.184572, -2.875000>, 
      <1.236706, 0.141513, -3.125000>, <1.245505, 0.120067, -3.053672>, <1.241238, 0.133783, -2.949463>, <1.236706, 0.141513, -2.875000>, 
      <1.210999, 0.119706, -3.125000>, <1.219798, 0.098260, -3.053672>, <1.215531, 0.111976, -2.949463>, <1.210999, 0.119706, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.184572, -3.125000>, <1.302756, 0.211204, -3.209547>, <1.302756, 0.307746, -3.293273>, <1.302756, 0.342071, -3.375000>, 
      <1.336467, 0.184572, -3.125000>, <1.336467, 0.211204, -3.209547>, <1.353607, 0.307746, -3.293273>, <1.353607, 0.342071, -3.375000>, 
      <1.368807, 0.141513, -3.125000>, <1.379301, 0.167092, -3.210071>, <1.405288, 0.271585, -3.292923>, <1.418788, 0.304490, -3.375000>, 
      <1.394514, 0.119706, -3.125000>, <1.405008, 0.145285, -3.210071>, <1.442694, 0.237139, -3.292923>, <1.456194, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.184572, -3.125000>, <1.336467, 0.184572, -3.125000>, <1.368807, 0.141513, -3.125000>, <1.394514, 0.119706, -3.125000>, 
      <1.302756, 0.162039, -3.053465>, <1.336467, 0.162039, -3.053465>, <1.360008, 0.120067, -3.053672>, <1.385715, 0.098260, -3.053672>, 
      <1.302756, 0.173676, -2.949204>, <1.336467, 0.173676, -2.949204>, <1.364275, 0.133784, -2.949463>, <1.389982, 0.111976, -2.949463>, 
      <1.302756, 0.184572, -2.875000>, <1.336467, 0.184572, -2.875000>, <1.368807, 0.141513, -2.875000>, <1.394514, 0.119706, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.726154, 0.142216, -3.500000>, <1.726154, 0.142216, -3.462500>, <1.717785, 0.148714, -3.410972>, <1.726154, 0.142216, -3.375000>, 
      <1.726154, 0.185047, -3.500000>, <1.726154, 0.185047, -3.462500>, <1.717785, 0.191545, -3.410972>, <1.726154, 0.185047, -3.375000>, 
      <1.758237, 0.241029, -3.500000>, <1.758237, 0.241029, -3.462500>, <1.752577, 0.254823, -3.409408>, <1.758237, 0.241029, -3.375000>, 
      <1.789744, 0.270043, -3.500000>, <1.789744, 0.270043, -3.462500>, <1.784085, 0.283837, -3.409408>, <1.789744, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.789744, -0.300124, -3.500000>, <1.789744, -0.300124, -3.462500>, <1.784465, -0.318788, -3.407094>, <1.789744, -0.300124, -3.375000>, 
      <1.745808, -0.173462, -3.500000>, <1.745808, -0.173462, -3.462500>, <1.740529, -0.192126, -3.407094>, <1.745808, -0.173462, -3.375000>, 
      <1.726154, 0.008150, -3.500000>, <1.726154, 0.008150, -3.462500>, <1.717785, 0.014648, -3.410972>, <1.726154, 0.008150, -3.375000>, 
      <1.726154, 0.142216, -3.500000>, <1.726154, 0.142216, -3.462500>, <1.717785, 0.148714, -3.410972>, <1.726154, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.483442, -3.500000>, <1.943182, -0.483442, -3.462500>, <1.943182, -0.508488, -3.402909>, <1.943182, -0.483442, -3.375000>, 
      <1.871465, -0.483442, -3.500000>, <1.871465, -0.483442, -3.462500>, <1.871465, -0.508488, -3.402909>, <1.871465, -0.483442, -3.375000>, 
      <1.813247, -0.367881, -3.500000>, <1.813247, -0.367881, -3.462500>, <1.807969, -0.386545, -3.407094>, <1.813247, -0.367881, -3.375000>, 
      <1.789744, -0.300124, -3.500000>, <1.789744, -0.300124, -3.462500>, <1.784465, -0.318788, -3.407094>, <1.789744, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.096620, -0.300124, -3.500000>, <2.096620, -0.300124, -3.462500>, <2.101899, -0.318788, -3.407094>, <2.096620, -0.300124, -3.375000>, 
      <2.073117, -0.367881, -3.500000>, <2.073117, -0.367881, -3.462500>, <2.078396, -0.386545, -3.407094>, <2.073117, -0.367881, -3.375000>, 
      <2.014899, -0.483442, -3.500000>, <2.014899, -0.483442, -3.462500>, <2.014899, -0.508488, -3.402909>, <2.014899, -0.483442, -3.375000>, 
      <1.943182, -0.483442, -3.500000>, <1.943182, -0.483442, -3.462500>, <1.943182, -0.508488, -3.402909>, <1.943182, -0.483442, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.160210, 0.142216, -3.500000>, <2.160210, 0.142216, -3.462500>, <2.168579, 0.148714, -3.410972>, <2.160210, 0.142216, -3.375000>, 
      <2.160210, 0.008150, -3.500000>, <2.160210, 0.008150, -3.462500>, <2.168579, 0.014648, -3.410972>, <2.160210, 0.008150, -3.375000>, 
      <2.140557, -0.173462, -3.500000>, <2.140557, -0.173462, -3.462500>, <2.145835, -0.192126, -3.407094>, <2.140557, -0.173462, -3.375000>, 
      <2.096620, -0.300124, -3.500000>, <2.096620, -0.300124, -3.462500>, <2.101899, -0.318788, -3.407094>, <2.096620, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.096620, 0.270043, -3.500000>, <2.096620, 0.270043, -3.462500>, <2.102280, 0.283837, -3.409408>, <2.096620, 0.270043, -3.375000>, 
      <2.128127, 0.241029, -3.500000>, <2.128127, 0.241029, -3.462500>, <2.133787, 0.254823, -3.409408>, <2.128127, 0.241029, -3.375000>, 
      <2.160210, 0.185047, -3.500000>, <2.160210, 0.185047, -3.462500>, <2.168579, 0.191545, -3.410972>, <2.160210, 0.185047, -3.375000>, 
      <2.160210, 0.142216, -3.500000>, <2.160210, 0.142216, -3.462500>, <2.168579, 0.148714, -3.410972>, <2.160210, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.342071, -3.500000>, <1.943182, 0.342071, -3.462500>, <1.943182, 0.356592, -3.409574>, <1.943182, 0.342071, -3.375000>, 
      <1.994033, 0.342071, -3.500000>, <1.994033, 0.342071, -3.462500>, <1.994033, 0.356592, -3.409574>, <1.994033, 0.342071, -3.375000>, 
      <2.059214, 0.304490, -3.500000>, <2.059214, 0.304490, -3.462500>, <2.064873, 0.318284, -3.409408>, <2.059214, 0.304490, -3.375000>, 
      <2.096620, 0.270043, -3.500000>, <2.096620, 0.270043, -3.462500>, <2.102280, 0.283837, -3.409408>, <2.096620, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.342071, -3.500000>, <1.892331, 0.342071, -3.500000>, <1.827150, 0.304490, -3.500000>, <1.789744, 0.270043, -3.500000>, 
      <1.943182, 0.342071, -3.462500>, <1.892331, 0.342071, -3.462500>, <1.827150, 0.304490, -3.462500>, <1.789744, 0.270043, -3.462500>, 
      <1.943182, 0.356592, -3.409574>, <1.892331, 0.356592, -3.409574>, <1.821491, 0.318284, -3.409408>, <1.784085, 0.283837, -3.409408>, 
      <1.943182, 0.342071, -3.375000>, <1.892331, 0.342071, -3.375000>, <1.827150, 0.304490, -3.375000>, <1.789744, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.719933, 0.074475, -1.875000>, <1.701968, 0.074475, -1.780180>, <1.721271, 0.074475, -1.567711>, <1.624764, 0.074475, -1.567711>, 
      <1.719933, 0.143973, -1.875000>, <1.701968, 0.143973, -1.780180>, <1.721271, 0.168363, -1.567711>, <1.624764, 0.168363, -1.567711>, 
      <1.720765, 0.245438, -1.875000>, <1.707426, 0.263397, -1.726406>, <1.702665, 0.205757, -1.555396>, <1.670211, 0.235555, -1.411732>, 
      <1.760309, 0.302589, -1.875000>, <1.746970, 0.320548, -1.726406>, <1.763358, 0.267256, -1.518664>, <1.730904, 0.297054, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.760309, -0.153639, -1.875000>, <1.746874, -0.152692, -1.725336>, <1.762461, -0.127810, -1.520509>, <1.730904, -0.148104, -1.375000>, 
      <1.720765, -0.096488, -1.875000>, <1.707330, -0.095541, -1.725336>, <1.701768, -0.066311, -1.557241>, <1.670211, -0.086605, -1.411732>, 
      <1.719933, 0.004977, -1.875000>, <1.701968, 0.004977, -1.780180>, <1.721271, -0.019413, -1.567711>, <1.624764, -0.019413, -1.567711>, 
      <1.719933, 0.074475, -1.875000>, <1.701968, 0.074475, -1.780180>, <1.721271, 0.074475, -1.567711>, <1.624764, 0.074475, -1.567711>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.248176, -1.875000>, <1.943182, -0.248176, -1.725000>, <1.943674, -0.249309, -1.524995>, <1.943182, -0.248176, -1.375000>, 
      <1.881423, -0.248176, -1.875000>, <1.881423, -0.248176, -1.725000>, <1.873278, -0.248183, -1.524995>, <1.872786, -0.247050, -1.375000>, 
      <1.795450, -0.204426, -1.875000>, <1.782014, -0.203479, -1.725336>, <1.807973, -0.173928, -1.492965>, <1.776416, -0.194221, -1.347455>, 
      <1.760309, -0.153639, -1.875000>, <1.746874, -0.152692, -1.725336>, <1.762461, -0.127810, -1.520509>, <1.730904, -0.148104, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, -0.153639, -1.875000>, <2.076910, -0.153639, -1.725000>, <2.101129, -0.137971, -1.522201>, <2.076910, -0.153639, -1.375000>, 
      <2.052063, -0.196023, -1.875000>, <2.052063, -0.196023, -1.725000>, <2.081953, -0.183202, -1.521660>, <2.057734, -0.198870, -1.374460>, 
      <1.992313, -0.248176, -1.875000>, <1.992313, -0.248176, -1.725000>, <1.992799, -0.250095, -1.524995>, <1.992307, -0.248962, -1.375000>, 
      <1.943182, -0.248176, -1.875000>, <1.943182, -0.248176, -1.725000>, <1.943674, -0.249309, -1.524995>, <1.943182, -0.248176, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132332, 0.074475, -1.875000>, <2.123352, 0.074475, -1.725599>, <2.092077, 0.059460, -1.527276>, <2.079968, 0.074475, -1.378854>, 
      <2.132332, 0.004050, -1.875000>, <2.123352, 0.004050, -1.725599>, <2.092077, -0.008990, -1.527276>, <2.079968, 0.006025, -1.378854>, 
      <2.112527, -0.092884, -1.875000>, <2.112527, -0.092884, -1.725000>, <2.127844, -0.074954, -1.522953>, <2.103626, -0.090622, -1.375753>, 
      <2.076910, -0.153639, -1.875000>, <2.076910, -0.153639, -1.725000>, <2.101129, -0.137971, -1.522201>, <2.076910, -0.153639, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, 0.302589, -1.875000>, <2.076910, 0.321515, -1.726199>, <2.079262, 0.327604, -1.522881>, <2.076910, 0.302589, -1.375000>, 
      <2.112527, 0.241834, -1.875000>, <2.112527, 0.260760, -1.726199>, <2.105978, 0.264587, -1.523634>, <2.103626, 0.239572, -1.375753>, 
      <2.132332, 0.144900, -1.875000>, <2.123352, 0.144900, -1.725599>, <2.092077, 0.127910, -1.527276>, <2.079968, 0.142925, -1.378854>, 
      <2.132332, 0.074475, -1.875000>, <2.123352, 0.074475, -1.725599>, <2.092077, 0.059460, -1.527276>, <2.079968, 0.074475, -1.378854>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.397126, -1.875000>, <1.943182, 0.416052, -1.726199>, <1.936783, 0.405036, -1.524655>, <1.943182, 0.397126, -1.375000>, 
      <1.992313, 0.397126, -1.875000>, <1.992313, 0.416052, -1.726199>, <1.985908, 0.405822, -1.524655>, <1.992307, 0.397912, -1.375000>, 
      <2.052063, 0.344973, -1.875000>, <2.052063, 0.363899, -1.726199>, <2.060087, 0.372835, -1.522341>, <2.057734, 0.347820, -1.374460>, 
      <2.076910, 0.302589, -1.875000>, <2.076910, 0.321515, -1.726199>, <2.079262, 0.327604, -1.522881>, <2.076910, 0.302589, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.397126, -1.875000>, <1.881423, 0.397126, -1.875000>, <1.795450, 0.353376, -1.875000>, <1.760309, 0.302589, -1.875000>, 
      <1.943182, 0.416052, -1.726199>, <1.881423, 0.416052, -1.726199>, <1.782110, 0.371335, -1.726406>, <1.746970, 0.320548, -1.726406>, 
      <1.936783, 0.405036, -1.524655>, <1.866387, 0.403910, -1.524655>, <1.808870, 0.313373, -1.491120>, <1.763358, 0.267256, -1.518664>, 
      <1.943182, 0.397126, -1.375000>, <1.872786, 0.396000, -1.375000>, <1.776416, 0.343171, -1.347455>, <1.730904, 0.297054, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.754032, 0.074475, -2.250000>, <1.745099, 0.074475, -2.137390>, <1.740961, 0.074475, -1.985990>, <1.719933, 0.074475, -1.875000>, 
      <1.754032, 0.113266, -2.250000>, <1.745099, 0.113266, -2.137390>, <1.740961, 0.143973, -1.985990>, <1.719933, 0.143973, -1.875000>, 
      <1.783584, 0.162394, -2.250000>, <1.771429, 0.189416, -2.135500>, <1.731264, 0.231303, -1.991954>, <1.720765, 0.245438, -1.875000>, 
      <1.809453, 0.191300, -2.250000>, <1.797298, 0.218322, -2.135500>, <1.770808, 0.288454, -1.991954>, <1.760309, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809453, -0.153639, -2.250000>, <1.797477, -0.155153, -2.137182>, <1.770453, -0.154354, -1.988005>, <1.760309, -0.153639, -1.875000>, 
      <1.773836, -0.092884, -2.250000>, <1.761860, -0.094399, -2.137182>, <1.730909, -0.097203, -1.988005>, <1.720765, -0.096488, -1.875000>, 
      <1.754032, 0.004050, -2.250000>, <1.745099, 0.004050, -2.137390>, <1.740961, 0.004977, -1.985990>, <1.719933, 0.004977, -1.875000>, 
      <1.754032, 0.074475, -2.250000>, <1.745099, 0.074475, -2.137390>, <1.740961, 0.074475, -1.985990>, <1.719933, 0.074475, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.248176, -2.250000>, <1.943182, -0.250312, -2.137520>, <1.943182, -0.248176, -1.987500>, <1.943182, -0.248176, -1.875000>, 
      <1.894051, -0.248176, -2.250000>, <1.894051, -0.250312, -2.137520>, <1.881423, -0.248176, -1.987500>, <1.881423, -0.248176, -1.875000>, 
      <1.834301, -0.196024, -2.250000>, <1.822324, -0.197538, -2.137182>, <1.805594, -0.205141, -1.988005>, <1.795450, -0.204426, -1.875000>, 
      <1.809453, -0.153639, -2.250000>, <1.797477, -0.155153, -2.137182>, <1.770453, -0.154354, -1.988005>, <1.760309, -0.153639, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, -0.153639, -2.250000>, <2.077795, -0.155149, -2.137514>, <2.076910, -0.153639, -1.987500>, <2.076910, -0.153639, -1.875000>, 
      <2.052063, -0.196023, -2.250000>, <2.052948, -0.197533, -2.137514>, <2.052063, -0.196023, -1.987500>, <2.052063, -0.196023, -1.875000>, 
      <1.992313, -0.248176, -2.250000>, <1.992313, -0.250312, -2.137520>, <1.992313, -0.248176, -1.987500>, <1.992313, -0.248176, -1.875000>, 
      <1.943182, -0.248176, -2.250000>, <1.943182, -0.250312, -2.137520>, <1.943182, -0.248176, -1.987500>, <1.943182, -0.248176, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132332, 0.074475, -2.250000>, <2.133584, 0.074475, -2.137507>, <2.139082, 0.074475, -1.987297>, <2.132332, 0.074475, -1.875000>, 
      <2.132332, 0.004050, -2.250000>, <2.133584, 0.004050, -2.137507>, <2.139082, 0.004050, -1.987297>, <2.132332, 0.004050, -1.875000>, 
      <2.112527, -0.092884, -2.250000>, <2.113412, -0.094394, -2.137514>, <2.112527, -0.092884, -1.987500>, <2.112527, -0.092884, -1.875000>, 
      <2.076910, -0.153639, -2.250000>, <2.077795, -0.155149, -2.137514>, <2.076910, -0.153639, -1.987500>, <2.076910, -0.153639, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, 0.191300, -2.250000>, <2.077809, 0.218253, -2.135791>, <2.076910, 0.287783, -1.991412>, <2.076910, 0.302589, -1.875000>, 
      <2.102779, 0.162394, -2.250000>, <2.103678, 0.189347, -2.135791>, <2.112527, 0.227028, -1.991412>, <2.112527, 0.241834, -1.875000>, 
      <2.132332, 0.113266, -2.250000>, <2.133584, 0.113266, -2.137507>, <2.139082, 0.144900, -1.987297>, <2.132332, 0.144900, -1.875000>, 
      <2.132332, 0.074475, -2.250000>, <2.133584, 0.074475, -2.137507>, <2.139082, 0.074475, -1.987297>, <2.132332, 0.074475, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.285836, -2.250000>, <1.943182, 0.313391, -2.135931>, <1.943182, 0.382320, -1.991412>, <1.943182, 0.397126, -1.875000>, 
      <1.992313, 0.285836, -2.250000>, <1.992313, 0.313391, -2.135931>, <1.992313, 0.382320, -1.991412>, <1.992313, 0.397126, -1.875000>, 
      <2.044146, 0.227911, -2.250000>, <2.045045, 0.254864, -2.135791>, <2.052063, 0.330167, -1.991412>, <2.052063, 0.344973, -1.875000>, 
      <2.076910, 0.191300, -2.250000>, <2.077809, 0.218253, -2.135791>, <2.076910, 0.287783, -1.991412>, <2.076910, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.285836, -2.250000>, <1.894051, 0.285836, -2.250000>, <1.842217, 0.227911, -2.250000>, <1.809453, 0.191300, -2.250000>, 
      <1.943182, 0.313391, -2.135931>, <1.894051, 0.313391, -2.135931>, <1.830062, 0.254933, -2.135500>, <1.797298, 0.218322, -2.135500>, 
      <1.943182, 0.382320, -1.991412>, <1.881423, 0.382320, -1.991412>, <1.805949, 0.339241, -1.991954>, <1.770808, 0.288454, -1.991954>, 
      <1.943182, 0.397126, -1.875000>, <1.881423, 0.397126, -1.875000>, <1.795450, 0.353376, -1.875000>, <1.760309, 0.302589, -1.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.759597, 0.074475, -2.375000>, <1.758762, 0.074475, -2.337472>, <1.757000, 0.074475, -2.287420>, <1.754032, 0.074475, -2.250000>, 
      <1.759597, 0.111240, -2.375000>, <1.758762, 0.111240, -2.337472>, <1.757000, 0.113266, -2.287420>, <1.754032, 0.113266, -2.250000>, 
      <1.788651, 0.157389, -2.375000>, <1.788060, 0.158397, -2.337446>, <1.787446, 0.153809, -2.286374>, <1.783584, 0.162394, -2.250000>, 
      <1.813387, 0.184588, -2.375000>, <1.812796, 0.185596, -2.337446>, <1.813314, 0.182716, -2.286374>, <1.809453, 0.191300, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813387, -0.146928, -2.375000>, <1.812796, -0.147936, -2.337446>, <1.813419, -0.153138, -2.287359>, <1.809453, -0.153639, -2.250000>, 
      <1.778818, -0.087961, -2.375000>, <1.778227, -0.088969, -2.337446>, <1.777802, -0.092383, -2.287359>, <1.773836, -0.092884, -2.250000>, 
      <1.759597, 0.006122, -2.375000>, <1.758762, 0.006122, -2.337472>, <1.757000, 0.004050, -2.287420>, <1.754032, 0.004050, -2.250000>, 
      <1.759597, 0.074475, -2.375000>, <1.758762, 0.074475, -2.337472>, <1.757000, 0.074475, -2.287420>, <1.754032, 0.074475, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.238683, -2.375000>, <1.943182, -0.240110, -2.337419>, <1.943182, -0.247462, -2.287601>, <1.943182, -0.248176, -2.250000>, 
      <1.895496, -0.238683, -2.375000>, <1.895496, -0.240110, -2.337419>, <1.894051, -0.247462, -2.287601>, <1.894051, -0.248176, -2.250000>, 
      <1.837504, -0.188066, -2.375000>, <1.836913, -0.189074, -2.337446>, <1.838266, -0.195522, -2.287359>, <1.834301, -0.196024, -2.250000>, 
      <1.813387, -0.146928, -2.375000>, <1.812796, -0.147936, -2.337446>, <1.813419, -0.153138, -2.287359>, <1.809453, -0.153639, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, -0.146928, -2.375000>, <2.073567, -0.147936, -2.337446>, <2.076614, -0.153135, -2.287568>, <2.076910, -0.153639, -2.250000>, 
      <2.048860, -0.188066, -2.375000>, <2.049451, -0.189074, -2.337446>, <2.051767, -0.195519, -2.287568>, <2.052063, -0.196023, -2.250000>, 
      <1.990867, -0.238683, -2.375000>, <1.990867, -0.240110, -2.337419>, <1.992313, -0.247462, -2.287601>, <1.992313, -0.248176, -2.250000>, 
      <1.943182, -0.238683, -2.375000>, <1.943182, -0.240110, -2.337419>, <1.943182, -0.247462, -2.287601>, <1.943182, -0.248176, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126767, 0.074475, -2.375000>, <2.127602, 0.074475, -2.337472>, <2.131914, 0.074475, -2.287535>, <2.132332, 0.074475, -2.250000>, 
      <2.126767, 0.006122, -2.375000>, <2.127602, 0.006122, -2.337472>, <2.131914, 0.004050, -2.287535>, <2.132332, 0.004050, -2.250000>, 
      <2.107545, -0.087961, -2.375000>, <2.108136, -0.088969, -2.337446>, <2.112231, -0.092380, -2.287568>, <2.112527, -0.092884, -2.250000>, 
      <2.072976, -0.146928, -2.375000>, <2.073567, -0.147936, -2.337446>, <2.076614, -0.153135, -2.287568>, <2.076910, -0.153639, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, 0.184588, -2.375000>, <2.073567, 0.185596, -2.337446>, <2.076622, 0.182670, -2.286567>, <2.076910, 0.191300, -2.250000>, 
      <2.097712, 0.157389, -2.375000>, <2.098303, 0.158397, -2.337446>, <2.102491, 0.153764, -2.286567>, <2.102779, 0.162394, -2.250000>, 
      <2.126767, 0.111240, -2.375000>, <2.127602, 0.111240, -2.337472>, <2.131914, 0.113266, -2.287535>, <2.132332, 0.113266, -2.250000>, 
      <2.126767, 0.074475, -2.375000>, <2.127602, 0.074475, -2.337472>, <2.131914, 0.074475, -2.287535>, <2.132332, 0.074475, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.276343, -2.375000>, <1.943182, 0.277770, -2.337419>, <1.943182, 0.277005, -2.286556>, <1.943182, 0.285836, -2.250000>, 
      <1.990867, 0.276343, -2.375000>, <1.990867, 0.277770, -2.337419>, <1.992313, 0.277005, -2.286556>, <1.992313, 0.285836, -2.250000>, 
      <2.040893, 0.219866, -2.375000>, <2.041484, 0.220875, -2.337446>, <2.043859, 0.219281, -2.286567>, <2.044146, 0.227911, -2.250000>, 
      <2.072976, 0.184588, -2.375000>, <2.073567, 0.185596, -2.337446>, <2.076622, 0.182670, -2.286567>, <2.076910, 0.191300, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.276343, -2.375000>, <1.895496, 0.276343, -2.375000>, <1.845470, 0.219866, -2.375000>, <1.813387, 0.184588, -2.375000>, 
      <1.943182, 0.277770, -2.337419>, <1.895496, 0.277770, -2.337419>, <1.844880, 0.220875, -2.337446>, <1.812796, 0.185596, -2.337446>, 
      <1.943182, 0.277005, -2.286556>, <1.894051, 0.277005, -2.286556>, <1.846078, 0.219327, -2.286374>, <1.813314, 0.182716, -2.286374>, 
      <1.943182, 0.285836, -2.250000>, <1.894051, 0.285836, -2.250000>, <1.842217, 0.227911, -2.250000>, <1.809453, 0.191300, -2.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.759597, 0.074475, -2.500000>, <1.755585, 0.074475, -2.462715>, <1.760432, 0.074475, -2.412491>, <1.759597, 0.074475, -2.375000>, 
      <1.759597, 0.111240, -2.500000>, <1.755585, 0.111240, -2.462715>, <1.760432, 0.111240, -2.412491>, <1.759597, 0.111240, -2.375000>, 
      <1.788651, 0.157389, -2.500000>, <1.785830, 0.162201, -2.462917>, <1.789241, 0.156383, -2.412482>, <1.788651, 0.157389, -2.375000>, 
      <1.813387, 0.184588, -2.500000>, <1.810566, 0.189400, -2.462917>, <1.813977, 0.183582, -2.412482>, <1.813387, 0.184588, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813387, -0.146928, -2.500000>, <1.810566, -0.151740, -2.462917>, <1.813977, -0.145922, -2.412482>, <1.813387, -0.146928, -2.375000>, 
      <1.778818, -0.087961, -2.500000>, <1.775997, -0.092773, -2.462917>, <1.779408, -0.086955, -2.412482>, <1.778818, -0.087961, -2.375000>, 
      <1.759597, 0.006122, -2.500000>, <1.755585, 0.006122, -2.462715>, <1.760432, 0.006122, -2.412491>, <1.759597, 0.006122, -2.375000>, 
      <1.759597, 0.074475, -2.500000>, <1.755585, 0.074475, -2.462715>, <1.760432, 0.074475, -2.412491>, <1.759597, 0.074475, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.238683, -2.500000>, <1.943182, -0.245453, -2.463116>, <1.943182, -0.237260, -2.412473>, <1.943182, -0.238683, -2.375000>, 
      <1.895496, -0.238683, -2.500000>, <1.895496, -0.245453, -2.463116>, <1.895496, -0.237260, -2.412473>, <1.895496, -0.238683, -2.375000>, 
      <1.837504, -0.188066, -2.500000>, <1.834682, -0.192878, -2.462917>, <1.838093, -0.187059, -2.412482>, <1.837504, -0.188066, -2.375000>, 
      <1.813387, -0.146928, -2.500000>, <1.810566, -0.151740, -2.462917>, <1.813977, -0.145922, -2.412482>, <1.813387, -0.146928, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, -0.146928, -2.500000>, <2.075797, -0.151740, -2.462917>, <2.072386, -0.145922, -2.412482>, <2.072976, -0.146928, -2.375000>, 
      <2.048860, -0.188066, -2.500000>, <2.051681, -0.192878, -2.462917>, <2.048270, -0.187059, -2.412482>, <2.048860, -0.188066, -2.375000>, 
      <1.990867, -0.238683, -2.500000>, <1.990867, -0.245453, -2.463116>, <1.990867, -0.237260, -2.412473>, <1.990867, -0.238683, -2.375000>, 
      <1.943182, -0.238683, -2.500000>, <1.943182, -0.245453, -2.463116>, <1.943182, -0.237260, -2.412473>, <1.943182, -0.238683, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126767, 0.074475, -2.500000>, <2.130779, 0.074475, -2.462715>, <2.125932, 0.074475, -2.412491>, <2.126767, 0.074475, -2.375000>, 
      <2.126767, 0.006122, -2.500000>, <2.130779, 0.006122, -2.462715>, <2.125932, 0.006122, -2.412491>, <2.126767, 0.006122, -2.375000>, 
      <2.107545, -0.087961, -2.500000>, <2.110366, -0.092773, -2.462917>, <2.106955, -0.086955, -2.412482>, <2.107545, -0.087961, -2.375000>, 
      <2.072976, -0.146928, -2.500000>, <2.075797, -0.151740, -2.462917>, <2.072386, -0.145922, -2.412482>, <2.072976, -0.146928, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, 0.184588, -2.500000>, <2.075797, 0.189400, -2.462917>, <2.072386, 0.183582, -2.412482>, <2.072976, 0.184588, -2.375000>, 
      <2.097712, 0.157389, -2.500000>, <2.100533, 0.162201, -2.462917>, <2.097122, 0.156383, -2.412482>, <2.097712, 0.157389, -2.375000>, 
      <2.126767, 0.111240, -2.500000>, <2.130779, 0.111240, -2.462715>, <2.125932, 0.111240, -2.412491>, <2.126767, 0.111240, -2.375000>, 
      <2.126767, 0.074475, -2.500000>, <2.130779, 0.074475, -2.462715>, <2.125932, 0.074475, -2.412491>, <2.126767, 0.074475, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.276343, -2.500000>, <1.943182, 0.283113, -2.463116>, <1.943182, 0.274920, -2.412473>, <1.943182, 0.276343, -2.375000>, 
      <1.990867, 0.276343, -2.500000>, <1.990867, 0.283113, -2.463116>, <1.990867, 0.274920, -2.412473>, <1.990867, 0.276343, -2.375000>, 
      <2.040893, 0.219866, -2.500000>, <2.043714, 0.224678, -2.462917>, <2.040303, 0.218860, -2.412482>, <2.040893, 0.219866, -2.375000>, 
      <2.072976, 0.184588, -2.500000>, <2.075797, 0.189400, -2.462917>, <2.072386, 0.183582, -2.412482>, <2.072976, 0.184588, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.276343, -2.500000>, <1.895496, 0.276343, -2.500000>, <1.845470, 0.219866, -2.500000>, <1.813387, 0.184588, -2.500000>, 
      <1.943182, 0.283113, -2.463116>, <1.895496, 0.283113, -2.463116>, <1.842649, 0.224679, -2.462917>, <1.810566, 0.189400, -2.462917>, 
      <1.943182, 0.274920, -2.412473>, <1.895496, 0.274920, -2.412473>, <1.846060, 0.218860, -2.412482>, <1.813977, 0.183582, -2.412482>, 
      <1.943182, 0.276343, -2.375000>, <1.895496, 0.276343, -2.375000>, <1.845470, 0.219866, -2.375000>, <1.813387, 0.184588, -2.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813396, 0.074475, -2.875000>, <1.803649, 0.074475, -2.761767>, <1.771755, 0.074475, -2.613000>, <1.759597, 0.074475, -2.500000>, 
      <1.813396, 0.092203, -2.875000>, <1.803649, 0.092203, -2.761767>, <1.771755, 0.111240, -2.613000>, <1.759597, 0.111240, -2.500000>, 
      <1.837905, 0.108238, -2.875000>, <1.830972, 0.120064, -2.761081>, <1.797283, 0.142665, -2.613464>, <1.788651, 0.157389, -2.500000>, 
      <1.851424, 0.119706, -2.875000>, <1.844491, 0.131532, -2.761081>, <1.822019, 0.169865, -2.613464>, <1.813387, 0.184588, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.851424, -0.082045, -2.875000>, <1.844491, -0.093871, -2.761081>, <1.822019, -0.132204, -2.613464>, <1.813387, -0.146928, -2.500000>, 
      <1.826986, -0.040358, -2.875000>, <1.820053, -0.052185, -2.761081>, <1.787450, -0.073237, -2.613464>, <1.778818, -0.087961, -2.500000>, 
      <1.813396, 0.026153, -2.875000>, <1.803649, 0.026153, -2.761767>, <1.771755, 0.006122, -2.613000>, <1.759597, 0.006122, -2.500000>, 
      <1.813396, 0.074475, -2.875000>, <1.803649, 0.074475, -2.761767>, <1.771755, 0.074475, -2.613000>, <1.759597, 0.074475, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.146912, -2.875000>, <1.943182, -0.163738, -2.760409>, <1.943182, -0.217775, -2.613917>, <1.943182, -0.238683, -2.500000>, 
      <1.909471, -0.146912, -2.875000>, <1.909471, -0.163738, -2.760409>, <1.895496, -0.217775, -2.613917>, <1.895496, -0.238683, -2.500000>, 
      <1.868473, -0.111127, -2.875000>, <1.861540, -0.122953, -2.761081>, <1.846135, -0.173342, -2.613464>, <1.837504, -0.188066, -2.500000>, 
      <1.851424, -0.082045, -2.875000>, <1.844491, -0.093871, -2.761081>, <1.822019, -0.132204, -2.613464>, <1.813387, -0.146928, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.082045, -2.875000>, <2.041872, -0.093871, -2.761081>, <2.064344, -0.132204, -2.613464>, <2.072976, -0.146928, -2.500000>, 
      <2.017890, -0.111127, -2.875000>, <2.024823, -0.122953, -2.761081>, <2.040228, -0.173342, -2.613464>, <2.048860, -0.188066, -2.500000>, 
      <1.976893, -0.146912, -2.875000>, <1.976893, -0.163738, -2.760409>, <1.990867, -0.217775, -2.613917>, <1.990867, -0.238683, -2.500000>, 
      <1.943182, -0.146912, -2.875000>, <1.943182, -0.163738, -2.760409>, <1.943182, -0.217775, -2.613917>, <1.943182, -0.238683, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072967, 0.074475, -2.875000>, <2.082714, 0.074475, -2.761767>, <2.114608, 0.074475, -2.613000>, <2.126767, 0.074475, -2.500000>, 
      <2.072967, 0.026153, -2.875000>, <2.082714, 0.026153, -2.761767>, <2.114608, 0.006122, -2.613000>, <2.126767, 0.006122, -2.500000>, 
      <2.059377, -0.040358, -2.875000>, <2.066310, -0.052184, -2.761081>, <2.098913, -0.073237, -2.613464>, <2.107545, -0.087961, -2.500000>, 
      <2.034939, -0.082045, -2.875000>, <2.041872, -0.093871, -2.761081>, <2.064344, -0.132204, -2.613464>, <2.072976, -0.146928, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, 0.119706, -2.875000>, <2.041872, 0.131532, -2.761081>, <2.064344, 0.169865, -2.613464>, <2.072976, 0.184588, -2.500000>, 
      <2.048458, 0.108238, -2.875000>, <2.055391, 0.120064, -2.761081>, <2.089080, 0.142665, -2.613464>, <2.097712, 0.157389, -2.500000>, 
      <2.072967, 0.092203, -2.875000>, <2.082714, 0.092203, -2.761767>, <2.114608, 0.111240, -2.613000>, <2.126767, 0.111240, -2.500000>, 
      <2.072967, 0.074475, -2.875000>, <2.082714, 0.074475, -2.761767>, <2.114608, 0.074475, -2.613000>, <2.126767, 0.074475, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.184572, -2.875000>, <1.943182, 0.201398, -2.760409>, <1.943182, 0.255435, -2.613917>, <1.943182, 0.276343, -2.500000>, 
      <1.976893, 0.184572, -2.875000>, <1.976893, 0.201398, -2.760409>, <1.990867, 0.255435, -2.613917>, <1.990867, 0.276343, -2.500000>, 
      <2.009232, 0.141513, -2.875000>, <2.016165, 0.153339, -2.761081>, <2.032261, 0.205143, -2.613464>, <2.040893, 0.219866, -2.500000>, 
      <2.034939, 0.119706, -2.875000>, <2.041872, 0.131532, -2.761081>, <2.064344, 0.169865, -2.613464>, <2.072976, 0.184588, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.184572, -2.875000>, <1.909471, 0.184572, -2.875000>, <1.877131, 0.141513, -2.875000>, <1.851424, 0.119706, -2.875000>, 
      <1.943182, 0.201398, -2.760409>, <1.909471, 0.201398, -2.760409>, <1.870198, 0.153339, -2.761081>, <1.844491, 0.131532, -2.761081>, 
      <1.943182, 0.255435, -2.613917>, <1.895496, 0.255435, -2.613917>, <1.854102, 0.205143, -2.613464>, <1.822019, 0.169865, -2.613464>, 
      <1.943182, 0.276343, -2.500000>, <1.895496, 0.276343, -2.500000>, <1.845470, 0.219866, -2.500000>, <1.813387, 0.184588, -2.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813396, 0.074475, -3.125000>, <1.813396, 0.092203, -3.125000>, <1.837905, 0.108238, -3.125000>, <1.851424, 0.119706, -3.125000>, 
      <1.799426, 0.085322, -3.205064>, <1.799426, 0.103050, -3.205064>, <1.827411, 0.133817, -3.210071>, <1.840930, 0.145285, -3.210071>, 
      <1.744452, 0.128008, -3.296347>, <1.744452, 0.170839, -3.296347>, <1.771737, 0.208125, -3.292923>, <1.803244, 0.237139, -3.292923>, 
      <1.726154, 0.142216, -3.375000>, <1.726154, 0.185047, -3.375000>, <1.758237, 0.241029, -3.375000>, <1.789744, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813396, 0.074475, -3.125000>, <1.826174, 0.064553, -3.051766>, <1.819828, 0.074475, -2.949724>, <1.813396, 0.074475, -2.875000>, 
      <1.813396, 0.092203, -3.125000>, <1.826174, 0.082281, -3.051766>, <1.819828, 0.092203, -2.949724>, <1.813396, 0.092203, -2.875000>, 
      <1.837905, 0.108238, -3.125000>, <1.846704, 0.086792, -3.053672>, <1.842437, 0.100508, -2.949463>, <1.837905, 0.108238, -2.875000>, 
      <1.851424, 0.119706, -3.125000>, <1.860223, 0.098260, -3.053672>, <1.855956, 0.111976, -2.949463>, <1.851424, 0.119706, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.851424, -0.082045, -3.125000>, <1.826986, -0.040358, -3.125000>, <1.813396, 0.026153, -3.125000>, <1.813396, 0.074475, -3.125000>, 
      <1.840050, -0.122259, -3.217201>, <1.815612, -0.080573, -3.217201>, <1.799426, 0.037000, -3.205064>, <1.799426, 0.085322, -3.205064>, 
      <1.803994, -0.249740, -3.288362>, <1.760058, -0.123078, -3.288362>, <1.744452, -0.006058, -3.296347>, <1.744452, 0.128008, -3.296347>, 
      <1.789744, -0.300124, -3.375000>, <1.745808, -0.173462, -3.375000>, <1.726154, 0.008150, -3.375000>, <1.726154, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.851424, -0.082045, -3.125000>, <1.859851, -0.052251, -3.056690>, <1.855956, -0.074315, -2.949463>, <1.851424, -0.082045, -2.875000>, 
      <1.826986, -0.040358, -3.125000>, <1.835412, -0.010564, -3.056690>, <1.831517, -0.032628, -2.949463>, <1.826986, -0.040358, -2.875000>, 
      <1.813396, 0.026153, -3.125000>, <1.826174, 0.016231, -3.051766>, <1.819828, 0.026153, -2.949724>, <1.813396, 0.026153, -2.875000>, 
      <1.813396, 0.074475, -3.125000>, <1.826174, 0.064553, -3.051766>, <1.819828, 0.074475, -2.949724>, <1.813396, 0.074475, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.146912, -3.125000>, <1.909471, -0.146912, -3.125000>, <1.868473, -0.111127, -3.125000>, <1.851424, -0.082045, -3.125000>, 
      <1.943182, -0.217137, -3.229337>, <1.909471, -0.217137, -3.229337>, <1.857099, -0.151342, -3.217201>, <1.840050, -0.122259, -3.217201>, 
      <1.943182, -0.399441, -3.281397>, <1.871465, -0.399441, -3.281397>, <1.827498, -0.317497, -3.288362>, <1.803994, -0.249740, -3.288362>, 
      <1.943182, -0.483442, -3.375000>, <1.871465, -0.483442, -3.375000>, <1.813247, -0.367881, -3.375000>, <1.789744, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.146912, -3.125000>, <1.943182, -0.105035, -3.062780>, <1.943182, -0.136016, -2.949204>, <1.943182, -0.146912, -2.875000>, 
      <1.909471, -0.146912, -3.125000>, <1.909471, -0.105035, -3.062780>, <1.909471, -0.136016, -2.949204>, <1.909471, -0.146912, -2.875000>, 
      <1.868473, -0.111127, -3.125000>, <1.876900, -0.081333, -3.056690>, <1.873005, -0.103397, -2.949463>, <1.868473, -0.111127, -2.875000>, 
      <1.851424, -0.082045, -3.125000>, <1.859851, -0.052251, -3.056690>, <1.855956, -0.074315, -2.949463>, <1.851424, -0.082045, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.082045, -3.125000>, <2.017890, -0.111127, -3.125000>, <1.976893, -0.146912, -3.125000>, <1.943182, -0.146912, -3.125000>, 
      <2.046313, -0.122259, -3.217201>, <2.029264, -0.151341, -3.217201>, <1.976893, -0.217137, -3.229337>, <1.943182, -0.217137, -3.229337>, 
      <2.082370, -0.249740, -3.288362>, <2.058866, -0.317497, -3.288362>, <2.014899, -0.399441, -3.281397>, <1.943182, -0.399441, -3.281397>, 
      <2.096620, -0.300124, -3.375000>, <2.073117, -0.367881, -3.375000>, <2.014899, -0.483442, -3.375000>, <1.943182, -0.483442, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.082045, -3.125000>, <2.026512, -0.052251, -3.056690>, <2.030407, -0.074315, -2.949463>, <2.034939, -0.082045, -2.875000>, 
      <2.017890, -0.111127, -3.125000>, <2.009463, -0.081333, -3.056690>, <2.013358, -0.103397, -2.949463>, <2.017890, -0.111127, -2.875000>, 
      <1.976893, -0.146912, -3.125000>, <1.976893, -0.105035, -3.062780>, <1.976893, -0.136016, -2.949204>, <1.976893, -0.146912, -2.875000>, 
      <1.943182, -0.146912, -3.125000>, <1.943182, -0.105035, -3.062780>, <1.943182, -0.136016, -2.949204>, <1.943182, -0.146912, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072967, 0.074475, -3.125000>, <2.072967, 0.026153, -3.125000>, <2.059377, -0.040358, -3.125000>, <2.034939, -0.082045, -3.125000>, 
      <2.086937, 0.085322, -3.205064>, <2.086937, 0.037000, -3.205064>, <2.070752, -0.080573, -3.217201>, <2.046313, -0.122259, -3.217201>, 
      <2.141912, 0.128008, -3.296347>, <2.141912, -0.006058, -3.296347>, <2.126306, -0.123078, -3.288362>, <2.082370, -0.249740, -3.288362>, 
      <2.160210, 0.142216, -3.375000>, <2.160210, 0.008150, -3.375000>, <2.140557, -0.173462, -3.375000>, <2.096620, -0.300124, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072967, 0.074475, -3.125000>, <2.060189, 0.064553, -3.051766>, <2.066535, 0.074475, -2.949724>, <2.072967, 0.074475, -2.875000>, 
      <2.072967, 0.026153, -3.125000>, <2.060189, 0.016231, -3.051766>, <2.066535, 0.026153, -2.949724>, <2.072967, 0.026153, -2.875000>, 
      <2.059377, -0.040358, -3.125000>, <2.050951, -0.010564, -3.056690>, <2.054846, -0.032628, -2.949463>, <2.059377, -0.040358, -2.875000>, 
      <2.034939, -0.082045, -3.125000>, <2.026512, -0.052251, -3.056690>, <2.030407, -0.074315, -2.949463>, <2.034939, -0.082045, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, 0.119706, -3.125000>, <2.048458, 0.108238, -3.125000>, <2.072967, 0.092203, -3.125000>, <2.072967, 0.074475, -3.125000>, 
      <2.045434, 0.145285, -3.210071>, <2.058952, 0.133817, -3.210071>, <2.086937, 0.103050, -3.205064>, <2.086937, 0.085322, -3.205064>, 
      <2.083120, 0.237139, -3.292923>, <2.114627, 0.208125, -3.292923>, <2.141912, 0.170839, -3.296347>, <2.141912, 0.128008, -3.296347>, 
      <2.096620, 0.270043, -3.375000>, <2.128127, 0.241029, -3.375000>, <2.160210, 0.185047, -3.375000>, <2.160210, 0.142216, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, 0.119706, -3.125000>, <2.026140, 0.098260, -3.053672>, <2.030407, 0.111976, -2.949463>, <2.034939, 0.119706, -2.875000>, 
      <2.048458, 0.108238, -3.125000>, <2.039659, 0.086791, -3.053672>, <2.043926, 0.100508, -2.949463>, <2.048458, 0.108238, -2.875000>, 
      <2.072967, 0.092203, -3.125000>, <2.060189, 0.082281, -3.051766>, <2.066535, 0.092203, -2.949724>, <2.072967, 0.092203, -2.875000>, 
      <2.072967, 0.074475, -3.125000>, <2.060189, 0.064553, -3.051766>, <2.066535, 0.074475, -2.949724>, <2.072967, 0.074475, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.184572, -3.125000>, <1.976893, 0.184572, -3.125000>, <2.009232, 0.141513, -3.125000>, <2.034939, 0.119706, -3.125000>, 
      <1.943182, 0.211204, -3.209547>, <1.976893, 0.211204, -3.209547>, <2.019726, 0.167092, -3.210071>, <2.045434, 0.145285, -3.210071>, 
      <1.943182, 0.307746, -3.293273>, <1.994033, 0.307746, -3.293273>, <2.045713, 0.271585, -3.292923>, <2.083120, 0.237139, -3.292923>, 
      <1.943182, 0.342071, -3.375000>, <1.994033, 0.342071, -3.375000>, <2.059214, 0.304490, -3.375000>, <2.096620, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.184572, -3.125000>, <1.943182, 0.162039, -3.053465>, <1.943182, 0.173676, -2.949204>, <1.943182, 0.184572, -2.875000>, 
      <1.976893, 0.184572, -3.125000>, <1.976893, 0.162039, -3.053465>, <1.976893, 0.173676, -2.949204>, <1.976893, 0.184572, -2.875000>, 
      <2.009232, 0.141513, -3.125000>, <2.000433, 0.120067, -3.053672>, <2.004700, 0.133783, -2.949463>, <2.009232, 0.141513, -2.875000>, 
      <2.034939, 0.119706, -3.125000>, <2.026140, 0.098260, -3.053672>, <2.030407, 0.111976, -2.949463>, <2.034939, 0.119706, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.184572, -3.125000>, <1.943182, 0.211204, -3.209547>, <1.943182, 0.307746, -3.293273>, <1.943182, 0.342071, -3.375000>, 
      <1.909471, 0.184572, -3.125000>, <1.909471, 0.211204, -3.209547>, <1.892331, 0.307746, -3.293273>, <1.892331, 0.342071, -3.375000>, 
      <1.877131, 0.141513, -3.125000>, <1.866637, 0.167092, -3.210071>, <1.840650, 0.271585, -3.292923>, <1.827150, 0.304490, -3.375000>, 
      <1.851424, 0.119706, -3.125000>, <1.840930, 0.145285, -3.210071>, <1.803244, 0.237139, -3.292923>, <1.789744, 0.270043, -3.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.184572, -3.125000>, <1.909471, 0.184572, -3.125000>, <1.877131, 0.141513, -3.125000>, <1.851424, 0.119706, -3.125000>, 
      <1.943182, 0.162039, -3.053465>, <1.909471, 0.162039, -3.053465>, <1.885930, 0.120067, -3.053672>, <1.860223, 0.098260, -3.053672>, 
      <1.943182, 0.173676, -2.949204>, <1.909471, 0.173676, -2.949204>, <1.881663, 0.133784, -2.949463>, <1.855956, 0.111976, -2.949463>, 
      <1.943182, 0.184572, -2.875000>, <1.909471, 0.184572, -2.875000>, <1.877131, 0.141513, -2.875000>, <1.851424, 0.119706, -2.875000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, 0.000000, -0.750000>, <1.250000, 0.068866, -0.750000>, <1.222831, 0.179804, -0.745619>, <1.271527, 0.228500, -0.745619>, 
      <1.260637, 0.027714, -0.841025>, <1.260637, 0.096580, -0.841025>, <1.246117, 0.200662, -0.836569>, <1.294813, 0.249358, -0.836569>, 
      <1.199385, 0.148754, -0.924600>, <1.197215, 0.212504, -0.923005>, <1.218171, 0.298924, -0.919543>, <1.266923, 0.328639, -0.948031>, 
      <1.186386, 0.159843, -1.018807>, <1.184216, 0.223593, -1.017212>, <1.222775, 0.323785, -1.012333>, <1.271527, 0.353500, -1.040821>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.279333, -0.745619>, <1.214417, -0.217654, -0.745619>, <1.250000, -0.084059, -0.750000>, <1.250000, 0.000000, -0.750000>, 
      <1.275112, -0.267749, -0.838407>, <1.218002, -0.206070, -0.838407>, <1.260637, -0.056345, -0.841025>, <1.260637, 0.027714, -0.841025>, 
      <1.288575, -0.288067, -0.963414>, <1.194153, -0.201772, -0.913617>, <1.204053, 0.011610, -0.928033>, <1.199385, 0.148754, -0.924600>, 
      <1.293207, -0.283446, -1.056762>, <1.198785, -0.197151, -1.006966>, <1.191054, 0.022699, -1.022239>, <1.186386, 0.159843, -1.018807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.279333, -0.745619>, <1.268530, -0.289017, -0.668048>, <1.268231, -0.351683, -0.492811>, <1.271527, -0.353500, -0.495619>, 
      <1.214417, -0.217654, -0.745619>, <1.211420, -0.227338, -0.668048>, <1.231360, -0.262708, -0.555279>, <1.234656, -0.264525, -0.558087>, 
      <1.250000, -0.084059, -0.750000>, <1.240500, -0.108811, -0.668700>, <1.210293, -0.115535, -0.553418>, <1.151197, -0.111757, -0.491725>, 
      <1.250000, 0.000000, -0.750000>, <1.240500, -0.024753, -0.668700>, <1.184134, -0.003778, -0.555497>, <1.125038, 0.000000, -0.493804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.750000>, <1.512457, -0.405479, -0.748605>, <1.347995, -0.361920, -0.745619>, <1.271527, -0.279333, -0.745619>, 
      <1.624952, -0.371241, -0.904229>, <1.512409, -0.371713, -0.902834>, <1.351580, -0.350336, -0.838407>, <1.275112, -0.267749, -0.838407>, 
      <1.600319, -0.300105, -1.105734>, <1.484737, -0.307522, -1.107714>, <1.368256, -0.360890, -1.005436>, <1.288575, -0.288067, -0.963414>, 
      <1.624764, -0.240805, -1.250000>, <1.509183, -0.248222, -1.251980>, <1.372888, -0.356269, -1.098784>, <1.293207, -0.283446, -1.056762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.276366, -0.754381>, <1.901800, -0.359174, -0.754381>, <1.737844, -0.404533, -0.751399>, <1.625000, -0.405007, -0.750000>, 
      <1.972334, -0.274442, -0.842880>, <1.895661, -0.357251, -0.842880>, <1.737796, -0.370767, -0.905627>, <1.624952, -0.371241, -0.904229>, 
      <1.945493, -0.245932, -0.957175>, <1.867323, -0.317318, -0.996172>, <1.712886, -0.292881, -1.103806>, <1.600319, -0.300105, -1.105734>, 
      <1.940461, -0.241912, -1.045674>, <1.862291, -0.313298, -1.084671>, <1.737332, -0.233582, -1.248072>, <1.624764, -0.240805, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, 0.000000, -0.750000>, <2.000000, -0.083171, -0.750000>, <2.034980, -0.215338, -0.754381>, <1.978473, -0.276366, -0.754381>, 
      <1.988992, 0.028622, -0.843996>, <1.988992, -0.054550, -0.843996>, <2.028840, -0.213414, -0.842880>, <1.972334, -0.274442, -0.842880>, 
      <2.051099, 0.148307, -0.933723>, <2.043063, 0.022439, -0.932897>, <2.032887, -0.166123, -0.913577>, <1.945493, -0.245932, -0.957175>, 
      <2.063486, 0.159843, -1.031135>, <2.055451, 0.033976, -1.030309>, <2.027854, -0.162103, -1.002076>, <1.940461, -0.241912, -1.045674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, 0.000000, -0.750000>, <2.009151, -0.023792, -0.671864>, <2.079176, -0.002796, -0.574393>, <2.124962, 0.000000, -0.506196>, 
      <2.000000, -0.083171, -0.750000>, <2.009151, -0.106964, -0.671864>, <2.079176, -0.090743, -0.573182>, <2.124962, -0.087946, -0.504984>, 
      <2.034980, -0.215338, -0.754381>, <2.040327, -0.217013, -0.677295>, <1.968627, -0.219111, -0.609914>, <2.010648, -0.191747, -0.551099>, 
      <1.978473, -0.276366, -0.754381>, <1.983821, -0.278041, -0.677295>, <1.936452, -0.281185, -0.556551>, <1.978473, -0.253821, -0.497736>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, 0.228500, -0.754381>, <2.027169, 0.179804, -0.754381>, <2.000000, 0.068866, -0.750000>, <2.000000, 0.000000, -0.750000>, 
      <1.978473, 0.249992, -0.848121>, <2.027169, 0.201296, -0.848121>, <1.988992, 0.097488, -0.843996>, <1.988992, 0.028622, -0.843996>, 
      <1.983742, 0.328321, -0.956913>, <2.032882, 0.298393, -0.929602>, <2.055156, 0.211865, -0.934141>, <2.051099, 0.148307, -0.933723>, 
      <1.978473, 0.353500, -1.049582>, <2.027613, 0.323572, -1.022270>, <2.067544, 0.223402, -1.031552>, <2.063486, 0.159843, -1.031135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, 0.228500, -0.754381>, <1.978473, 0.211739, -0.681278>, <1.978473, 0.228500, -0.579381>, <1.978473, 0.228500, -0.504381>, 
      <2.027169, 0.179804, -0.754381>, <2.027169, 0.163044, -0.681278>, <2.004514, 0.165660, -0.624145>, <2.004514, 0.165660, -0.549145>, 
      <2.000000, 0.068866, -0.750000>, <2.009151, 0.045074, -0.671864>, <2.079176, 0.078625, -0.575515>, <2.124962, 0.081421, -0.507318>, 
      <2.000000, 0.000000, -0.750000>, <2.009151, -0.023792, -0.671864>, <2.079176, -0.002796, -0.574393>, <2.124962, 0.000000, -0.506196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, -0.750000>, <1.739788, 0.375000, -0.751423>, <1.897300, 0.309673, -0.754381>, <1.978473, 0.228500, -0.754381>, 
      <1.624952, 0.385604, -0.907909>, <1.739740, 0.385604, -0.909331>, <1.897300, 0.331166, -0.848121>, <1.978473, 0.249992, -0.848121>, 
      <1.598521, 0.446357, -1.120101>, <1.726256, 0.446357, -1.121684>, <1.885180, 0.388350, -1.011694>, <1.983742, 0.328321, -0.956913>, 
      <1.624764, 0.427042, -1.274975>, <1.752499, 0.427042, -1.276558>, <1.879911, 0.413528, -1.104363>, <1.978473, 0.353500, -1.049582>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, -0.750000>, <1.624952, 0.385604, -0.907909>, <1.598521, 0.446357, -1.120101>, <1.624764, 0.427042, -1.274975>, 
      <1.510212, 0.375000, -0.748577>, <1.510164, 0.385604, -0.906486>, <1.469492, 0.446357, -1.118502>, <1.495735, 0.427042, -1.273376>, 
      <1.352700, 0.309673, -0.745619>, <1.375986, 0.330531, -0.836569>, <1.365516, 0.388734, -1.005644>, <1.370120, 0.413594, -1.098434>, 
      <1.271527, 0.228500, -0.745619>, <1.294813, 0.249358, -0.836569>, <1.266923, 0.328639, -0.948031>, <1.271527, 0.353500, -1.040821>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, 0.230959, -0.506489>, <1.195267, 0.243733, -0.561287>, <1.251515, 0.210574, -0.667455>, <1.271527, 0.228500, -0.745619>, 
      <1.133167, 0.172174, -0.543442>, <1.193710, 0.184948, -0.598240>, <1.202819, 0.161879, -0.667455>, <1.222831, 0.179804, -0.745619>, 
      <1.109212, 0.067614, -0.495061>, <1.168308, 0.063836, -0.556755>, <1.240500, 0.044113, -0.668700>, <1.250000, 0.068866, -0.750000>, 
      <1.125038, 0.000000, -0.493804>, <1.184134, -0.003778, -0.555497>, <1.240500, -0.024753, -0.668700>, <1.250000, 0.000000, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, 0.230959, -0.506489>, <1.133167, 0.172174, -0.543442>, <1.109212, 0.067614, -0.495061>, <1.125038, 0.000000, -0.493804>, 
      <1.109444, 0.225625, -0.483608>, <1.107887, 0.166840, -0.520561>, <1.089685, 0.068862, -0.474677>, <1.105511, 0.001248, -0.473419>, 
      <1.058371, 0.189132, -0.508347>, <1.070305, 0.150645, -0.537231>, <1.061097, 0.061570, -0.509510>, <1.057398, 0.012145, -0.508334>, 
      <1.035455, 0.178690, -0.531947>, <1.047389, 0.140203, -0.560830>, <1.042739, 0.062911, -0.530948>, <1.039041, 0.013486, -0.529772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.500000>, <1.518880, -0.419970, -0.499682>, <1.377569, -0.368952, -0.496933>, <1.271527, -0.353500, -0.495619>, 
      <1.625000, -0.405007, -0.575000>, <1.518880, -0.419970, -0.574682>, <1.374273, -0.367135, -0.494126>, <1.268231, -0.351683, -0.492811>, 
      <1.625023, -0.421047, -0.676735>, <1.512480, -0.421520, -0.675341>, <1.344998, -0.371604, -0.668048>, <1.268530, -0.289017, -0.668048>, 
      <1.625000, -0.405007, -0.750000>, <1.512457, -0.405479, -0.748605>, <1.347995, -0.361920, -0.745619>, <1.271527, -0.279333, -0.745619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.500000>, <1.625000, -0.405007, -0.575000>, <1.625023, -0.421047, -0.676735>, <1.625000, -0.405007, -0.750000>, 
      <1.739206, -0.388904, -0.500342>, <1.739206, -0.388904, -0.575342>, <1.737867, -0.420574, -0.678134>, <1.737844, -0.404533, -0.751399>, 
      <1.872431, -0.299177, -0.498415>, <1.830410, -0.326541, -0.557230>, <1.907148, -0.360850, -0.677295>, <1.901800, -0.359174, -0.754381>, 
      <1.978473, -0.253821, -0.497736>, <1.936452, -0.281185, -0.556551>, <1.983821, -0.278041, -0.677295>, <1.978473, -0.276366, -0.754381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, -0.500000>, <1.739796, 0.374665, -0.499713>, <1.870505, 0.267058, -0.510244>, <1.978473, 0.228500, -0.504381>, 
      <1.625000, 0.370644, -0.574874>, <1.739796, 0.370310, -0.574587>, <1.870505, 0.267058, -0.585244>, <1.978473, 0.228500, -0.579381>, 
      <1.625023, 0.369975, -0.675168>, <1.739810, 0.369975, -0.676591>, <1.897300, 0.292913, -0.681278>, <1.978473, 0.211739, -0.681278>, 
      <1.625000, 0.375000, -0.750000>, <1.739788, 0.375000, -0.751423>, <1.897300, 0.309673, -0.754381>, <1.978473, 0.228500, -0.754381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.375000, -0.500000>, <1.625000, 0.370644, -0.574874>, <1.625023, 0.369975, -0.675168>, <1.625000, 0.375000, -0.750000>, 
      <1.471690, 0.375447, -0.500383>, <1.471690, 0.371091, -0.575256>, <1.510235, 0.369975, -0.673746>, <1.510212, 0.375000, -0.748577>, 
      <1.281807, 0.274171, -0.504542>, <1.342349, 0.286946, -0.559340>, <1.332688, 0.291748, -0.667455>, <1.352700, 0.309673, -0.745619>, 
      <1.134724, 0.230959, -0.506489>, <1.195267, 0.243733, -0.561287>, <1.251515, 0.210574, -0.667455>, <1.271527, 0.228500, -0.745619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, 0.365791, -0.263863>, <1.114528, 0.365791, -0.344649>, <1.136590, 0.301441, -0.462183>, <1.134724, 0.230959, -0.506489>, 
      <1.066908, 0.347080, -0.278090>, <1.046711, 0.347080, -0.358876>, <1.111310, 0.296107, -0.439302>, <1.109444, 0.225625, -0.483608>, 
      <1.011859, 0.250417, -0.315762>, <1.028860, 0.250057, -0.366631>, <1.045459, 0.230769, -0.477099>, <1.058371, 0.189132, -0.508347>, 
      <0.973384, 0.225224, -0.370867>, <0.990386, 0.224864, -0.421736>, <1.022544, 0.220328, -0.500699>, <1.035455, 0.178690, -0.531947>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, 0.365791, -0.263863>, <1.066908, 0.347080, -0.278090>, <1.011859, 0.250417, -0.315762>, <0.973384, 0.225224, -0.370867>, 
      <1.157738, 0.365791, -0.171806>, <1.089922, 0.347080, -0.186033>, <0.996278, 0.250747, -0.269143>, <0.957803, 0.225554, -0.324248>, 
      <1.238296, 0.306202, -0.060187>, <1.142397, 0.296400, -0.128965>, <1.018038, 0.230796, -0.155791>, <0.946667, 0.216315, -0.249170>, 
      <1.259724, 0.230959, -0.006489>, <1.163826, 0.221158, -0.075267>, <1.002221, 0.195385, -0.125590>, <0.930850, 0.180905, -0.218969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.250000>, <1.625000, -0.427215, -0.321636>, <1.625000, -0.405007, -0.425000>, <1.625000, -0.405007, -0.500000>, 
      <1.736694, -0.393808, -0.252784>, <1.736694, -0.416016, -0.324421>, <1.739206, -0.388904, -0.425342>, <1.739206, -0.388904, -0.500342>, 
      <1.873922, -0.321014, -0.248971>, <1.892952, -0.337155, -0.315310>, <1.846503, -0.349198, -0.455414>, <1.872431, -0.299177, -0.498415>, 
      <1.978473, -0.282617, -0.263241>, <1.997503, -0.298757, -0.329580>, <1.952545, -0.303843, -0.454734>, <1.978473, -0.253821, -0.497736>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.250000>, <1.518398, -0.415696, -0.247343>, <1.371254, -0.387683, -0.226348>, <1.271527, -0.353500, -0.245619>, 
      <1.625000, -0.427215, -0.321636>, <1.518398, -0.437904, -0.318979>, <1.354018, -0.420462, -0.291567>, <1.254290, -0.386279, -0.310837>, 
      <1.625000, -0.405007, -0.425000>, <1.518880, -0.419970, -0.424682>, <1.401658, -0.427082, -0.456121>, <1.295616, -0.411630, -0.454807>, 
      <1.625000, -0.405007, -0.500000>, <1.518880, -0.419970, -0.499682>, <1.377569, -0.368952, -0.496933>, <1.271527, -0.353500, -0.495619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.250000>, <1.736694, -0.393808, -0.252784>, <1.873922, -0.321014, -0.248971>, <1.978473, -0.282617, -0.263241>, 
      <1.625000, -0.378876, -0.165711>, <1.736694, -0.367677, -0.168495>, <1.851966, -0.302392, -0.172427>, <1.956516, -0.263994, -0.186697>, 
      <1.625000, -0.284847, -0.081075>, <1.701882, -0.290234, -0.087690>, <1.806094, -0.236264, -0.097221>, <1.874636, -0.205605, -0.115813>, 
      <1.625000, -0.250000, 0.000000>, <1.701882, -0.255386, -0.006615>, <1.784931, -0.178461, -0.043381>, <1.853473, -0.147802, -0.061973>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.405007, -0.250000>, <1.625000, -0.378876, -0.165711>, <1.625000, -0.284847, -0.081075>, <1.625000, -0.250000, 0.000000>, 
      <1.518398, -0.415696, -0.247343>, <1.518398, -0.389565, -0.163054>, <1.545704, -0.279292, -0.074252>, <1.545704, -0.244445, 0.006823>, 
      <1.371254, -0.387683, -0.226348>, <1.395321, -0.341916, -0.135288>, <1.473163, -0.242501, -0.074402>, <1.465069, -0.156053, -0.015860>, 
      <1.271527, -0.353500, -0.245619>, <1.295594, -0.307733, -0.154558>, <1.404622, -0.202238, -0.081199>, <1.396527, -0.115790, -0.022657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.405007, -0.234168>, <1.625000, 0.405007, -0.314424>, <1.625000, 0.379661, -0.419879>, <1.625000, 0.375000, -0.500000>, 
      <1.477204, 0.407160, -0.235829>, <1.477204, 0.407160, -0.316085>, <1.471690, 0.380108, -0.420262>, <1.471690, 0.375447, -0.500383>, 
      <1.274394, 0.404326, -0.234563>, <1.254197, 0.404326, -0.315348>, <1.283673, 0.344653, -0.460236>, <1.281807, 0.274171, -0.504542>, 
      <1.134724, 0.365791, -0.263863>, <1.114528, 0.365791, -0.344649>, <1.136590, 0.301441, -0.462183>, <1.134724, 0.230959, -0.506489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.405007, -0.234168>, <1.732315, 0.403444, -0.232962>, <1.876997, 0.384412, -0.238026>, <1.978473, 0.353500, -0.254381>, 
      <1.625000, 0.405007, -0.314424>, <1.732315, 0.403444, -0.313218>, <1.897334, 0.384412, -0.319375>, <1.998810, 0.353500, -0.335730>, 
      <1.625000, 0.379661, -0.419879>, <1.739796, 0.379326, -0.419593>, <1.843689, 0.331768, -0.464148>, <1.951657, 0.293210, -0.458285>, 
      <1.625000, 0.375000, -0.500000>, <1.739796, 0.374665, -0.499713>, <1.870505, 0.267058, -0.510244>, <1.978473, 0.228500, -0.504381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.405007, -0.234168>, <1.477204, 0.407160, -0.235829>, <1.274394, 0.404326, -0.234563>, <1.134724, 0.365791, -0.263863>, 
      <1.625000, 0.405007, -0.163343>, <1.477204, 0.407160, -0.165004>, <1.297408, 0.404326, -0.142506>, <1.157738, 0.365791, -0.171806>, 
      <1.625000, 0.381140, -0.070558>, <1.507191, 0.381628, -0.070976>, <1.347879, 0.349414, -0.058240>, <1.238296, 0.306202, -0.060187>, 
      <1.625000, 0.375000, 0.000000>, <1.507191, 0.375488, -0.000418>, <1.369307, 0.274171, -0.004542>, <1.259724, 0.230959, -0.006489>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, 0.405007, -0.234168>, <1.625000, 0.405007, -0.163343>, <1.625000, 0.381140, -0.070558>, <1.625000, 0.375000, 0.000000>, 
      <1.732315, 0.403444, -0.232962>, <1.732315, 0.403444, -0.162137>, <1.706432, 0.380803, -0.070269>, <1.706432, 0.374663, 0.000289>, 
      <1.876997, 0.384412, -0.238026>, <1.854719, 0.384412, -0.148913>, <1.799698, 0.323966, -0.034683>, <1.778465, 0.251427, 0.017517>, 
      <1.978473, 0.353500, -0.254381>, <1.956195, 0.353500, -0.165268>, <1.874706, 0.301039, -0.056580>, <1.853473, 0.228500, -0.004381>
    }
  }
  texture {
    yellowstuff
  }
}
union { // radguyMfloor
  object { sPatchObj }
  object { sPatchObj2 }
  scale 4.1
  rotate -180.0*z
  translate  <12.8633, -55.824875, -7.622445>
}


#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.276606, 0.129163>, <1.543582, -1.277246, 0.130587>, <1.454109, -1.197291, 0.169594>, <1.396527, -1.144765, 0.193189>, 
      <1.625000, -1.276606, 0.129163>, <1.625000, -1.276606, 0.129163>, <1.591193, -1.196214, 0.167197>, <1.533611, -1.143688, 0.190791>, 
      <1.625000, -1.276606, 0.129163>, <1.625000, -1.276606, 0.129163>, <1.658807, -1.194778, 0.164000>, <1.716389, -1.142252, 0.187595>, 
      <1.625000, -1.276606, 0.129163>, <1.706418, -1.275966, 0.127739>, <1.795891, -1.193701, 0.161602>, <1.853473, -1.141175, 0.185197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -1.048558, 0.231603>, <1.906023, -1.054563, 0.228594>, <1.875918, -1.120701, 0.194394>, <1.853473, -1.141175, 0.185197>, 
      <1.728397, -1.020180, 0.245822>, <1.759420, -1.026185, 0.242813>, <1.738834, -1.121778, 0.196792>, <1.716389, -1.142252, 0.187595>, 
      <1.521603, -1.019080, 0.243373>, <1.490580, -1.025318, 0.240882>, <1.511166, -1.123214, 0.199988>, <1.533611, -1.143688, 0.190791>, 
      <1.375000, -1.048558, 0.231603>, <1.343977, -1.054796, 0.229112>, <1.374082, -1.124291, 0.202386>, <1.396527, -1.144765, 0.193189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375000, -0.925512, -0.042318>, <1.375000, -0.962426, 0.039858>, <1.375000, -1.011644, 0.149427>, <1.375000, -1.048558, 0.231603>, 
      <1.343977, -0.931750, -0.044809>, <1.343977, -0.968664, 0.037368>, <1.343977, -1.017882, 0.146936>, <1.343977, -1.054796, 0.229112>, 
      <1.374082, -1.001245, -0.071534>, <1.374082, -1.038159, 0.010642>, <1.374082, -1.087377, 0.120210>, <1.374082, -1.124291, 0.202386>, 
      <1.396527, -1.021719, -0.080731>, <1.396527, -1.058633, 0.001445>, <1.396527, -1.107851, 0.111013>, <1.396527, -1.144765, 0.193189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.153560, -0.144757>, <1.543582, -1.154200, -0.143333>, <1.454109, -1.074245, -0.104326>, <1.396527, -1.021719, -0.080731>, 
      <1.625000, -1.190474, -0.062581>, <1.543582, -1.191113, -0.061157>, <1.454109, -1.111159, -0.022149>, <1.396527, -1.058633, 0.001445>, 
      <1.625000, -1.239692, 0.046987>, <1.543582, -1.240332, 0.048411>, <1.454109, -1.160377, 0.087418>, <1.396527, -1.107851, 0.111013>, 
      <1.625000, -1.276606, 0.129163>, <1.543582, -1.277246, 0.130587>, <1.454109, -1.197291, 0.169594>, <1.396527, -1.144765, 0.193189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.153560, -0.144757>, <1.706418, -1.152920, -0.146181>, <1.795891, -1.070655, -0.112319>, <1.853473, -1.018129, -0.088724>, 
      <1.625000, -1.153560, -0.144757>, <1.625000, -1.153560, -0.144757>, <1.658807, -1.071732, -0.109921>, <1.716389, -1.019206, -0.086326>, 
      <1.625000, -1.153560, -0.144757>, <1.625000, -1.153560, -0.144757>, <1.591193, -1.073168, -0.106723>, <1.533611, -1.020642, -0.083129>, 
      <1.625000, -1.153560, -0.144757>, <1.543582, -1.154200, -0.143333>, <1.454109, -1.074245, -0.104326>, <1.396527, -1.021719, -0.080731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.153560, -0.144757>, <1.625000, -1.190474, -0.062581>, <1.625000, -1.239692, 0.046987>, <1.625000, -1.276606, 0.129163>, 
      <1.706418, -1.152920, -0.146181>, <1.706418, -1.189834, -0.064005>, <1.706418, -1.239052, 0.045563>, <1.706418, -1.275966, 0.127739>, 
      <1.795891, -1.070655, -0.112319>, <1.795891, -1.107568, -0.030142>, <1.795891, -1.156787, 0.079426>, <1.795891, -1.193701, 0.161602>, 
      <1.853473, -1.018129, -0.088724>, <1.853473, -1.055043, -0.006548>, <1.853473, -1.104261, 0.103021>, <1.853473, -1.141175, 0.185197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.925512, -0.042318>, <1.906023, -0.931517, -0.045327>, <1.875918, -0.997655, -0.079527>, <1.853473, -1.018129, -0.088724>, 
      <1.875000, -0.962426, 0.039858>, <1.906023, -0.968431, 0.036850>, <1.875918, -1.034569, 0.002649>, <1.853473, -1.055043, -0.006548>, 
      <1.875000, -1.011644, 0.149427>, <1.906023, -1.017649, 0.146418>, <1.875918, -1.083787, 0.112218>, <1.853473, -1.104261, 0.103021>, 
      <1.875000, -1.048558, 0.231603>, <1.906023, -1.054563, 0.228594>, <1.875918, -1.120701, 0.194394>, <1.853473, -1.141175, 0.185197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.925512, -0.042318>, <1.875000, -0.962426, 0.039858>, <1.875000, -1.011644, 0.149427>, <1.875000, -1.048558, 0.231603>, 
      <1.728397, -0.897134, -0.028099>, <1.728397, -0.934048, 0.054077>, <1.728397, -0.983267, 0.163645>, <1.728397, -1.020180, 0.245822>, 
      <1.521603, -0.896034, -0.030548>, <1.521603, -0.932948, 0.051628>, <1.521603, -0.982167, 0.161197>, <1.521603, -1.019080, 0.243373>, 
      <1.375000, -0.925512, -0.042318>, <1.375000, -0.962426, 0.039858>, <1.375000, -1.011644, 0.149427>, <1.375000, -1.048558, 0.231603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.925512, -0.042318>, <1.728397, -0.897134, -0.028099>, <1.521603, -0.896034, -0.030548>, <1.375000, -0.925512, -0.042318>, 
      <1.906023, -0.931517, -0.045327>, <1.759420, -0.903139, -0.031108>, <1.490581, -0.902272, -0.033039>, <1.343977, -0.931750, -0.044809>, 
      <1.875918, -0.997655, -0.079527>, <1.738834, -0.998732, -0.077129>, <1.511166, -1.000168, -0.073932>, <1.374082, -1.001245, -0.071534>, 
      <1.853473, -1.018129, -0.088724>, <1.716389, -1.019206, -0.086326>, <1.533611, -1.020642, -0.083129>, <1.396527, -1.021719, -0.080731>
    }
  }
  texture {
    visor
  }
}
#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.624122, 0.132209, -1.651007>, <0.624122, 0.132209, -1.651007>, <0.598250, 0.138754, -1.640688>, <0.598250, 0.138754, -1.640688>, 
      <0.630888, 0.017695, -1.570560>, <0.602901, 0.016283, -1.564781>, <0.584945, 0.020856, -1.559092>, <0.564645, 0.035348, -1.545072>, 
      <0.641766, -0.057926, -1.499189>, <0.613779, -0.059338, -1.493411>, <0.575827, -0.050604, -1.478814>, <0.555527, -0.036112, -1.464795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.646995, 0.141213, -1.650753>, <0.646995, 0.141213, -1.650753>, <0.624122, 0.132209, -1.651007>, <0.624122, 0.132209, -1.651007>, 
      <0.646857, 0.034044, -1.537647>, <0.631674, 0.016266, -1.545244>, <0.654934, 0.018908, -1.575524>, <0.630888, 0.017695, -1.570560>, 
      <0.718011, -0.027915, -1.498344>, <0.702828, -0.045693, -1.505941>, <0.665812, -0.056713, -1.504154>, <0.641766, -0.057926, -1.499189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.651297, 0.164030, -1.637409>, <0.651297, 0.164030, -1.637409>, <0.646995, 0.141213, -1.650753>, <0.646995, 0.141213, -1.650753>, 
      <0.701302, 0.098152, -1.533839>, <0.700117, 0.075377, -1.547878>, <0.663397, 0.053412, -1.529370>, <0.646857, 0.034044, -1.537647>, 
      <0.732350, 0.048142, -1.453863>, <0.731165, 0.025367, -1.467902>, <0.734552, -0.008547, -1.490068>, <0.718011, -0.027915, -1.498344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.649457, 0.188540, -1.621579>, <0.649457, 0.188540, -1.621579>, <0.651297, 0.164030, -1.637409>, <0.651297, 0.164030, -1.637409>, 
      <0.696087, 0.161933, -1.494404>, <0.713037, 0.143820, -1.509873>, <0.702595, 0.123014, -1.518513>, <0.701302, 0.098152, -1.533839>, 
      <0.726218, 0.129842, -1.401097>, <0.743168, 0.111728, -1.416567>, <0.733643, 0.073005, -1.438537>, <0.732350, 0.048142, -1.453863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.624352, 0.192826, -1.612816>, <0.624352, 0.192826, -1.612816>, <0.649457, 0.188540, -1.621579>, <0.649457, 0.188540, -1.621579>, 
      <0.631455, 0.173222, -1.472827>, <0.657852, 0.175828, -1.477502>, <0.680472, 0.178621, -1.480152>, <0.696087, 0.161933, -1.494404>, 
      <0.642533, 0.144128, -1.371888>, <0.668930, 0.146734, -1.376563>, <0.710603, 0.146530, -1.386845>, <0.726218, 0.129842, -1.401097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.598413, 0.183500, -1.612539>, <0.598413, 0.183500, -1.612539>, <0.624352, 0.192826, -1.612816>, <0.624352, 0.192826, -1.612816>, 
      <0.565097, 0.149835, -1.473554>, <0.584160, 0.168420, -1.466407>, <0.604438, 0.170554, -1.468042>, <0.631455, 0.173222, -1.472827>, 
      <0.556069, 0.113042, -1.370963>, <0.575132, 0.131627, -1.363816>, <0.615517, 0.141460, -1.367103>, <0.642533, 0.144128, -1.371888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, <0.616560, 0.213696, -1.716071>, 
      <0.588362, 0.157738, -1.626310>, <0.588362, 0.157738, -1.626310>, <0.598413, 0.183500, -1.612539>, <0.598413, 0.183500, -1.612539>, 
      <0.538498, 0.084219, -1.508927>, <0.538593, 0.110367, -1.492477>, <0.543734, 0.129007, -1.481564>, <0.565097, 0.149835, -1.473554>, 
      <0.522567, 0.027170, -1.416867>, <0.522662, 0.053318, -1.400417>, <0.534706, 0.092215, -1.378973>, <0.556069, 0.113042, -1.370963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616560, 0.213696, -1.716071>, <0.588362, 0.157738, -1.626310>, <0.538498, 0.084219, -1.508927>, <0.522567, 0.027170, -1.416867>, 
      <0.616560, 0.213696, -1.716071>, <0.588362, 0.157738, -1.626310>, <0.538419, 0.062393, -1.522658>, <0.522488, 0.005344, -1.430598>, 
      <0.616560, 0.213696, -1.716071>, <0.598250, 0.138754, -1.640688>, <0.546350, 0.048409, -1.532437>, <0.537232, -0.023051, -1.452160>, 
      <0.616560, 0.213696, -1.716071>, <0.598250, 0.138754, -1.640688>, <0.564645, 0.035348, -1.545072>, <0.555527, -0.036112, -1.464795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.663737, -0.114265, -1.406544>, <0.657146, -0.097363, -1.434338>, <0.645219, -0.081933, -1.476532>, <0.641766, -0.057926, -1.499189>, 
      <0.644365, -0.124487, -1.388135>, <0.637774, -0.107586, -1.415929>, <0.617233, -0.083345, -1.470753>, <0.613779, -0.059338, -1.493411>, 
      <0.597405, -0.106785, -1.386877>, <0.590813, -0.089884, -1.414670>, <0.573021, -0.072593, -1.454113>, <0.575827, -0.050604, -1.478814>, 
      <0.577497, -0.092450, -1.372151>, <0.570906, -0.075549, -1.399944>, <0.552721, -0.058101, -1.440093>, <0.555527, -0.036112, -1.464795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.820737, 0.035904, -1.603291>, <0.811197, 0.060366, -1.643517>, <0.751453, -0.057035, -1.479872>, <0.718011, -0.027915, -1.498344>, 
      <0.766429, -0.027689, -1.630464>, <0.756889, -0.003227, -1.670691>, <0.736270, -0.074814, -1.487469>, <0.702828, -0.045693, -1.505941>, 
      <0.723272, -0.082850, -1.463117>, <0.716680, -0.065948, -1.490911>, <0.669265, -0.080720, -1.481497>, <0.665812, -0.056713, -1.504154>, 
      <0.663737, -0.114265, -1.406544>, <0.657146, -0.097363, -1.434338>, <0.645219, -0.081933, -1.476532>, <0.641766, -0.057926, -1.499189>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.754320, -0.008195, -1.361220>, <0.747729, 0.008706, -1.389013>, <0.742727, 0.031428, -1.427133>, <0.732350, 0.048142, -1.453863>, 
      <0.772450, -0.017591, -1.434901>, <0.765859, -0.000690, -1.462694>, <0.741542, 0.008653, -1.441172>, <0.731165, 0.025367, -1.467902>, 
      <0.867959, 0.091200, -1.579663>, <0.858420, 0.115662, -1.619889>, <0.767993, -0.037667, -1.471596>, <0.734552, -0.008547, -1.490068>, 
      <0.820737, 0.035904, -1.603291>, <0.811197, 0.060366, -1.643517>, <0.751453, -0.057035, -1.479872>, <0.718011, -0.027915, -1.498344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.748189, 0.073502, -1.308452>, <0.741598, 0.090404, -1.336246>, <0.735911, 0.119518, -1.371079>, <0.726218, 0.129842, -1.401097>, 
      <0.765138, 0.055389, -1.323922>, <0.758547, 0.072290, -1.351715>, <0.752861, 0.101404, -1.386549>, <0.743168, 0.111728, -1.416567>, 
      <0.747388, -0.004602, -1.333047>, <0.740797, 0.012299, -1.360840>, <0.744020, 0.056290, -1.411807>, <0.733643, 0.073005, -1.438537>, 
      <0.754320, -0.008195, -1.361220>, <0.747729, 0.008706, -1.389013>, <0.742727, 0.031428, -1.427133>, <0.732350, 0.048142, -1.453863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.664503, 0.087790, -1.279244>, <0.657912, 0.104691, -1.307037>, <0.646014, 0.134987, -1.340172>, <0.642533, 0.144128, -1.371888>, 
      <0.690900, 0.090396, -1.283919>, <0.684309, 0.107298, -1.311712>, <0.672411, 0.137593, -1.344847>, <0.668930, 0.146734, -1.376563>, 
      <0.732573, 0.090190, -1.294200>, <0.725982, 0.107092, -1.321993>, <0.720296, 0.136206, -1.356828>, <0.710603, 0.146530, -1.386845>, 
      <0.748189, 0.073502, -1.308452>, <0.741598, 0.090404, -1.336246>, <0.735911, 0.119518, -1.371079>, <0.726218, 0.129842, -1.401097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.578039, 0.056703, -1.278318>, <0.571448, 0.073605, -1.306112>, <0.553329, 0.101876, -1.339828>, <0.556069, 0.113042, -1.370963>, 
      <0.596734, 0.075812, -1.271592>, <0.590143, 0.092713, -1.299385>, <0.572392, 0.120461, -1.332680>, <0.575132, 0.131627, -1.363816>, 
      <0.637487, 0.085123, -1.274459>, <0.630895, 0.102024, -1.302253>, <0.618998, 0.132319, -1.335388>, <0.615517, 0.141460, -1.367103>, 
      <0.664503, 0.087790, -1.279244>, <0.657912, 0.104691, -1.307037>, <0.646014, 0.134987, -1.340172>, <0.642533, 0.144128, -1.371888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.548208, -0.031075, -1.321086>, <0.541357, -0.013507, -1.349975>, <0.517546, 0.009191, -1.387855>, <0.522567, 0.027170, -1.416867>, 
      <0.548302, -0.005149, -1.304776>, <0.541451, 0.012418, -1.333665>, <0.517641, 0.035339, -1.371405>, <0.522662, 0.053318, -1.400417>, 
      <0.557266, 0.035471, -1.285792>, <0.550675, 0.052373, -1.313585>, <0.531966, 0.081048, -1.347837>, <0.534706, 0.092215, -1.378973>, 
      <0.578039, 0.056703, -1.278318>, <0.571448, 0.073605, -1.306112>, <0.553329, 0.101876, -1.339828>, <0.556069, 0.113042, -1.370963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.548208, -0.031075, -1.321086>, <0.548130, -0.052670, -1.334672>, <0.559746, -0.079668, -1.359020>, <0.577497, -0.092450, -1.372151>, 
      <0.541357, -0.013507, -1.349975>, <0.541278, -0.035102, -1.363561>, <0.553155, -0.062766, -1.386813>, <0.570906, -0.075549, -1.399944>, 
      <0.517546, 0.009191, -1.387855>, <0.517467, -0.012635, -1.401586>, <0.534427, -0.045040, -1.427458>, <0.552721, -0.058101, -1.440093>, 
      <0.522567, 0.027170, -1.416867>, <0.522488, 0.005344, -1.430598>, <0.537232, -0.023051, -1.452160>, <0.555527, -0.036112, -1.464795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.679430, -0.154506, -1.340369>, <0.676018, -0.142316, -1.360414>, <0.668445, -0.126337, -1.386692>, <0.663737, -0.114265, -1.406544>, 
      <0.651443, -0.155918, -1.334590>, <0.648032, -0.143728, -1.354635>, <0.649073, -0.136560, -1.368283>, <0.644365, -0.124487, -1.388135>, 
      <0.613491, -0.147184, -1.319995>, <0.610079, -0.134994, -1.340040>, <0.602113, -0.118858, -1.367024>, <0.597405, -0.106785, -1.386877>, 
      <0.593191, -0.132692, -1.305976>, <0.589779, -0.120502, -1.326021>, <0.582205, -0.104523, -1.352299>, <0.577497, -0.092450, -1.372151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.755675, -0.124495, -1.339525>, <0.755526, -0.075318, -1.420393>, <0.839533, -0.012294, -1.524034>, <0.820737, 0.035904, -1.603291>, 
      <0.740492, -0.142274, -1.347122>, <0.740343, -0.093097, -1.427990>, <0.785225, -0.075886, -1.551207>, <0.766429, -0.027689, -1.630464>, 
      <0.703476, -0.153293, -1.345334>, <0.700064, -0.141103, -1.365379>, <0.727980, -0.094922, -1.443265>, <0.723272, -0.082850, -1.463117>, 
      <0.679430, -0.154506, -1.340369>, <0.676018, -0.142316, -1.360414>, <0.668445, -0.126337, -1.386692>, <0.663737, -0.114265, -1.406544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.770013, -0.048437, -1.295046>, <0.766601, -0.036248, -1.315091>, <0.759028, -0.020268, -1.341368>, <0.754320, -0.008195, -1.361220>, 
      <0.768828, -0.071212, -1.309085>, <0.765416, -0.059022, -1.329130>, <0.777158, -0.029663, -1.415049>, <0.772450, -0.017591, -1.434901>, 
      <0.772215, -0.105127, -1.331249>, <0.772066, -0.055950, -1.412117>, <0.886755, 0.043002, -1.500406>, <0.867959, 0.091200, -1.579663>, 
      <0.755675, -0.124495, -1.339525>, <0.755526, -0.075318, -1.420393>, <0.839533, -0.012294, -1.524034>, <0.820737, 0.035904, -1.603291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.763882, 0.033262, -1.242279>, <0.760470, 0.045451, -1.262323>, <0.752897, 0.061430, -1.288600>, <0.748189, 0.073502, -1.308452>, 
      <0.780831, 0.015148, -1.257749>, <0.777420, 0.027338, -1.277794>, <0.769846, 0.043317, -1.304070>, <0.765138, 0.055389, -1.323922>, 
      <0.771306, -0.023575, -1.279720>, <0.767895, -0.011385, -1.299765>, <0.752096, -0.016675, -1.313195>, <0.747388, -0.004602, -1.333047>, 
      <0.770013, -0.048437, -1.295046>, <0.766601, -0.036248, -1.315091>, <0.759028, -0.020268, -1.341368>, <0.754320, -0.008195, -1.361220>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.680197, 0.047549, -1.213069>, <0.676785, 0.059739, -1.233114>, <0.669211, 0.075718, -1.259391>, <0.664503, 0.087790, -1.279244>, 
      <0.706594, 0.050155, -1.217744>, <0.703182, 0.062345, -1.237789>, <0.695608, 0.078324, -1.264067>, <0.690900, 0.090396, -1.283919>, 
      <0.748267, 0.049950, -1.228027>, <0.744855, 0.062139, -1.248071>, <0.737281, 0.078118, -1.274348>, <0.732573, 0.090190, -1.294200>, 
      <0.763882, 0.033262, -1.242279>, <0.760470, 0.045451, -1.262323>, <0.752897, 0.061430, -1.288600>, <0.748189, 0.073502, -1.308452>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.593732, 0.016462, -1.212145>, <0.590320, 0.028651, -1.232190>, <0.582747, 0.044631, -1.258466>, <0.578039, 0.056703, -1.278318>, 
      <0.612795, 0.035047, -1.204997>, <0.609383, 0.047237, -1.225042>, <0.601442, 0.063739, -1.251740>, <0.596734, 0.075812, -1.271592>, 
      <0.653180, 0.044881, -1.208284>, <0.649768, 0.057071, -1.228329>, <0.642195, 0.073050, -1.254607>, <0.637487, 0.085123, -1.274459>, 
      <0.680197, 0.047549, -1.213069>, <0.676785, 0.059739, -1.233114>, <0.669211, 0.075718, -1.259391>, <0.664503, 0.087790, -1.279244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.560231, -0.069409, -1.258049>, <0.557125, -0.057869, -1.277025>, <0.552662, -0.042495, -1.302307>, <0.548208, -0.031075, -1.321086>, 
      <0.560326, -0.043261, -1.241600>, <0.557220, -0.031722, -1.260576>, <0.552756, -0.016569, -1.285997>, <0.548302, -0.005149, -1.304776>, 
      <0.572369, -0.004365, -1.220155>, <0.568957, 0.007824, -1.240199>, <0.561974, 0.023399, -1.265940>, <0.557266, 0.035471, -1.285792>, 
      <0.593732, 0.016462, -1.212145>, <0.590320, 0.028651, -1.232190>, <0.582747, 0.044631, -1.258466>, <0.578039, 0.056703, -1.278318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.560231, -0.069409, -1.258049>, <0.560152, -0.091235, -1.271780>, <0.574896, -0.119631, -1.293341>, <0.593191, -0.132692, -1.305976>, 
      <0.557125, -0.057869, -1.277025>, <0.557046, -0.079696, -1.290756>, <0.571484, -0.107441, -1.313387>, <0.589779, -0.120502, -1.326021>, 
      <0.552662, -0.042495, -1.302307>, <0.552583, -0.064090, -1.315892>, <0.564454, -0.091740, -1.339168>, <0.582205, -0.104523, -1.352299>, 
      <0.548208, -0.031075, -1.321086>, <0.548130, -0.052670, -1.334672>, <0.559746, -0.079668, -1.359020>, <0.577497, -0.092450, -1.372151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.745749, -0.407263, -0.924728>, <0.719989, -0.331459, -1.048356>, <0.700628, -0.230238, -1.215833>, <0.679430, -0.154506, -1.340369>, 
      <0.717762, -0.408675, -0.918949>, <0.692002, -0.332870, -1.042577>, <0.672641, -0.231650, -1.210055>, <0.651443, -0.155918, -1.334590>, 
      <0.679809, -0.399941, -0.904353>, <0.657961, -0.321261, -1.026933>, <0.634688, -0.222916, -1.195459>, <0.613491, -0.147184, -1.319995>, 
      <0.659509, -0.385449, -0.890334>, <0.637661, -0.306769, -1.012914>, <0.614389, -0.208424, -1.181440>, <0.593191, -0.132692, -1.305976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.821993, -0.377254, -0.923883>, <0.799056, -0.298285, -1.046078>, <0.755908, -0.201024, -1.213679>, <0.755675, -0.124495, -1.339525>, 
      <0.806810, -0.395032, -0.931480>, <0.783874, -0.316064, -1.053675>, <0.740725, -0.218803, -1.221276>, <0.740492, -0.142274, -1.347122>, 
      <0.769794, -0.406050, -0.929693>, <0.744034, -0.330246, -1.053321>, <0.724673, -0.229025, -1.220798>, <0.703476, -0.153293, -1.345334>, 
      <0.745749, -0.407263, -0.924728>, <0.719989, -0.331459, -1.048356>, <0.700628, -0.230238, -1.215833>, <0.679430, -0.154506, -1.340369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.836331, -0.301194, -0.879403>, <0.812779, -0.225460, -1.003514>, <0.791211, -0.124169, -1.170510>, <0.770013, -0.048437, -1.295046>, 
      <0.835146, -0.323969, -0.893442>, <0.811594, -0.248235, -1.017553>, <0.790026, -0.146944, -1.184549>, <0.768828, -0.071212, -1.309085>, 
      <0.838534, -0.357886, -0.915607>, <0.815597, -0.278917, -1.037802>, <0.772448, -0.181656, -1.205403>, <0.772215, -0.105127, -1.331249>, 
      <0.821993, -0.377254, -0.923883>, <0.799056, -0.298285, -1.046078>, <0.755908, -0.201024, -1.213679>, <0.755675, -0.124495, -1.339525>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.830199, -0.219495, -0.826636>, <0.806928, -0.147307, -0.952894>, <0.785079, -0.042470, -1.117743>, <0.763882, 0.033262, -1.242279>, 
      <0.847148, -0.237609, -0.842106>, <0.823878, -0.165420, -0.968364>, <0.802029, -0.060583, -1.133213>, <0.780831, 0.015148, -1.257749>, 
      <0.837624, -0.276332, -0.864077>, <0.814072, -0.200597, -0.988188>, <0.792504, -0.099307, -1.155184>, <0.771306, -0.023575, -1.279720>, 
      <0.836331, -0.301194, -0.879403>, <0.812779, -0.225460, -1.003514>, <0.791211, -0.124169, -1.170510>, <0.770013, -0.048437, -1.295046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.746515, -0.205209, -0.797428>, <0.720751, -0.129333, -0.921012>, <0.701395, -0.028183, -1.088533>, <0.680197, 0.047549, -1.213069>, 
      <0.772911, -0.202603, -0.802103>, <0.747148, -0.126727, -0.925687>, <0.727792, -0.025576, -1.093208>, <0.706594, 0.050155, -1.217744>, 
      <0.814584, -0.202807, -0.812384>, <0.791313, -0.130619, -0.938643>, <0.769464, -0.025782, -1.103490>, <0.748267, 0.049950, -1.228027>, 
      <0.830199, -0.219495, -0.826636>, <0.806928, -0.147307, -0.952894>, <0.785079, -0.042470, -1.117743>, <0.763882, 0.033262, -1.242279>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.660051, -0.236295, -0.796502>, <0.638198, -0.164039, -0.922975>, <0.614930, -0.059270, -1.087609>, <0.593732, 0.016462, -1.212145>, 
      <0.679114, -0.217710, -0.789355>, <0.657262, -0.145454, -0.915828>, <0.633993, -0.040685, -1.080461>, <0.612795, 0.035047, -1.204997>, 
      <0.719499, -0.207876, -0.792643>, <0.693735, -0.132001, -0.916227>, <0.674378, -0.030850, -1.083749>, <0.653180, 0.044881, -1.208284>, 
      <0.746515, -0.205209, -0.797428>, <0.720751, -0.129333, -0.921012>, <0.701395, -0.028183, -1.088533>, <0.680197, 0.047549, -1.213069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626549, -0.322167, -0.842407>, <0.606120, -0.246235, -0.966950>, <0.580629, -0.145200, -1.133416>, <0.560231, -0.069409, -1.258049>, 
      <0.626644, -0.296019, -0.825957>, <0.606215, -0.220087, -0.950500>, <0.580723, -0.119053, -1.116966>, <0.560326, -0.043261, -1.241600>, 
      <0.638688, -0.257123, -0.804512>, <0.616835, -0.184867, -0.930985>, <0.593567, -0.080097, -1.095619>, <0.572369, -0.004365, -1.220155>, 
      <0.660051, -0.236295, -0.796502>, <0.638198, -0.164039, -0.922975>, <0.614930, -0.059270, -1.087609>, <0.593732, 0.016462, -1.212145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.626549, -0.322167, -0.842407>, <0.626470, -0.343993, -0.856138>, <0.641214, -0.372388, -0.877699>, <0.659509, -0.385449, -0.890334>, 
      <0.606120, -0.246235, -0.966950>, <0.606041, -0.268062, -0.980680>, <0.619366, -0.293708, -1.000279>, <0.637661, -0.306769, -1.012914>, 
      <0.580629, -0.145200, -1.133416>, <0.580549, -0.167027, -1.147147>, <0.596094, -0.195363, -1.168806>, <0.614389, -0.208424, -1.181440>, 
      <0.560231, -0.069409, -1.258049>, <0.560152, -0.091235, -1.271780>, <0.574896, -0.119631, -1.293341>, <0.593191, -0.132692, -1.305976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.780899, -0.453100, -0.853397>, <0.773180, -0.438777, -0.875611>, <0.750565, -0.421435, -0.901616>, <0.745749, -0.407263, -0.924728>, 
      <0.749542, -0.454448, -0.846767>, <0.741823, -0.440124, -0.868981>, <0.722578, -0.422846, -0.895837>, <0.717762, -0.408675, -0.918949>, 
      <0.704172, -0.459582, -0.834431>, <0.696641, -0.444767, -0.857823>, <0.684065, -0.415270, -0.880472>, <0.679809, -0.399941, -0.904353>, 
      <0.680037, -0.445444, -0.818724>, <0.672506, -0.430629, -0.842116>, <0.663766, -0.400778, -0.866453>, <0.659509, -0.385449, -0.890334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.846813, -0.438275, -0.853986>, <0.838283, -0.423492, -0.877202>, <0.826480, -0.392703, -0.899978>, <0.821993, -0.377254, -0.923883>, 
      <0.835036, -0.453056, -0.861311>, <0.826507, -0.438273, -0.884527>, <0.811298, -0.410481, -0.907575>, <0.806810, -0.395032, -0.931480>, 
      <0.800712, -0.452248, -0.857586>, <0.792993, -0.437925, -0.879800>, <0.774610, -0.420222, -0.906580>, <0.769794, -0.406050, -0.929693>, 
      <0.780899, -0.453100, -0.853397>, <0.773180, -0.438777, -0.875611>, <0.750565, -0.421435, -0.901616>, <0.745749, -0.407263, -0.924728>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.863583, -0.349321, -0.801965>, <0.855049, -0.335139, -0.825225>, <0.840896, -0.315873, -0.855347>, <0.836331, -0.301194, -0.879403>, 
      <0.862197, -0.375957, -0.818385>, <0.853663, -0.361776, -0.841645>, <0.839711, -0.338649, -0.869387>, <0.835146, -0.323969, -0.893442>, 
      <0.865011, -0.415434, -0.842666>, <0.856482, -0.400651, -0.865882>, <0.843021, -0.373334, -0.891701>, <0.838534, -0.357886, -0.915607>, 
      <0.846813, -0.438275, -0.853986>, <0.838283, -0.423492, -0.877202>, <0.826480, -0.392703, -0.899978>, <0.821993, -0.377254, -0.923883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.856411, -0.253772, -0.740252>, <0.847792, -0.239886, -0.764170>, <0.834776, -0.233693, -0.801804>, <0.830199, -0.219495, -0.826636>, 
      <0.875248, -0.276264, -0.757812>, <0.866629, -0.262378, -0.781729>, <0.851725, -0.251807, -0.817273>, <0.847148, -0.237609, -0.842106>, 
      <0.865096, -0.320244, -0.784041>, <0.856562, -0.306062, -0.807301>, <0.842189, -0.291011, -0.840021>, <0.837624, -0.276332, -0.864077>, 
      <0.863583, -0.349321, -0.801965>, <0.855049, -0.335139, -0.825225>, <0.840896, -0.315873, -0.855347>, <0.836331, -0.301194, -0.879403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.781795, -0.251663, -0.725722>, <0.774023, -0.238435, -0.748822>, <0.751366, -0.219495, -0.774160>, <0.746515, -0.205209, -0.797428>, 
      <0.804152, -0.249471, -0.729700>, <0.796380, -0.236243, -0.752800>, <0.777762, -0.216888, -0.778835>, <0.772911, -0.202603, -0.802103>, 
      <0.843842, -0.238764, -0.728535>, <0.835223, -0.224878, -0.752453>, <0.819161, -0.217005, -0.787552>, <0.814584, -0.202807, -0.812384>, 
      <0.856411, -0.253772, -0.740252>, <0.847792, -0.239886, -0.764170>, <0.834776, -0.233693, -0.801804>, <0.830199, -0.219495, -0.826636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.680671, -0.271002, -0.708980>, <0.673084, -0.256996, -0.733112>, <0.664341, -0.250480, -0.771673>, <0.660051, -0.236295, -0.796502>, 
      <0.704008, -0.251081, -0.702835>, <0.696421, -0.237074, -0.726966>, <0.683404, -0.231895, -0.764526>, <0.679114, -0.217710, -0.789355>, 
      <0.751129, -0.254670, -0.720265>, <0.743357, -0.241442, -0.743365>, <0.724349, -0.222162, -0.769375>, <0.719499, -0.207876, -0.792643>, 
      <0.781795, -0.251663, -0.725722>, <0.774023, -0.238435, -0.748822>, <0.751366, -0.219495, -0.774160>, <0.746515, -0.205209, -0.797428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.641489, -0.371434, -0.762669>, <0.634213, -0.357110, -0.786178>, <0.630498, -0.336846, -0.818330>, <0.626549, -0.322167, -0.842407>, 
      <0.641600, -0.340853, -0.743430>, <0.634324, -0.326529, -0.766938>, <0.630593, -0.310698, -0.801881>, <0.626644, -0.296019, -0.825957>, 
      <0.653726, -0.294003, -0.716075>, <0.646139, -0.279997, -0.740207>, <0.642978, -0.271307, -0.779683>, <0.638688, -0.257123, -0.804512>, 
      <0.680671, -0.271002, -0.708980>, <0.673084, -0.256996, -0.733112>, <0.664341, -0.250480, -0.771673>, <0.660051, -0.236295, -0.796502>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.641489, -0.371434, -0.762669>, <0.641396, -0.396960, -0.778728>, <0.657348, -0.432153, -0.803958>, <0.680037, -0.445444, -0.818724>, 
      <0.634213, -0.357110, -0.786178>, <0.634120, -0.382637, -0.802237>, <0.649817, -0.417338, -0.827350>, <0.672506, -0.430629, -0.842116>, 
      <0.630498, -0.336846, -0.818330>, <0.630419, -0.358672, -0.832061>, <0.645471, -0.387717, -0.853818>, <0.663766, -0.400778, -0.866453>, 
      <0.626549, -0.322167, -0.842407>, <0.626470, -0.343993, -0.856138>, <0.641214, -0.372388, -0.877699>, <0.659509, -0.385449, -0.890334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.799099, -0.506260, -0.771194>, <0.788059, -0.487993, -0.792092>, <0.789273, -0.468639, -0.829298>, <0.780899, -0.453100, -0.853397>, 
      <0.769985, -0.507729, -0.765183>, <0.758944, -0.489462, -0.786081>, <0.757915, -0.469986, -0.822668>, <0.749542, -0.454448, -0.846767>, 
      <0.730503, -0.498641, -0.750000>, <0.719431, -0.483159, -0.771694>, <0.711746, -0.474483, -0.810903>, <0.704172, -0.459582, -0.834431>, 
      <0.709385, -0.483565, -0.735415>, <0.698313, -0.468083, -0.757110>, <0.687612, -0.460345, -0.795197>, <0.680037, -0.445444, -0.818724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.878414, -0.475039, -0.770314>, <0.865518, -0.458388, -0.790265>, <0.855401, -0.453159, -0.830612>, <0.846813, -0.438275, -0.853986>, 
      <0.862620, -0.493534, -0.778217>, <0.849724, -0.476882, -0.798168>, <0.843624, -0.467940, -0.837937>, <0.835036, -0.453056, -0.861311>, 
      <0.824113, -0.504998, -0.776359>, <0.813073, -0.486732, -0.797257>, <0.809086, -0.467787, -0.833488>, <0.800712, -0.452248, -0.857586>, 
      <0.799099, -0.506260, -0.771194>, <0.788059, -0.487993, -0.792092>, <0.789273, -0.468639, -0.829298>, <0.780899, -0.453100, -0.853397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.893331, -0.395917, -0.724043>, <0.879729, -0.382626, -0.745487>, <0.872151, -0.363559, -0.778612>, <0.863583, -0.349321, -0.801965>, 
      <0.892098, -0.419609, -0.738648>, <0.878496, -0.406318, -0.760092>, <0.870765, -0.390196, -0.795031>, <0.862197, -0.375957, -0.818385>, 
      <0.895621, -0.454891, -0.761704>, <0.882725, -0.438239, -0.781655>, <0.873599, -0.430318, -0.819292>, <0.865011, -0.415434, -0.842666>, 
      <0.878414, -0.475039, -0.770314>, <0.865518, -0.458388, -0.790265>, <0.855401, -0.453159, -0.830612>, <0.846813, -0.438275, -0.853986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.886952, -0.310928, -0.669151>, <0.872988, -0.301202, -0.692461>, <0.864998, -0.267607, -0.716423>, <0.856411, -0.253772, -0.740252>, 
      <0.904584, -0.329771, -0.685244>, <0.890620, -0.320045, -0.708554>, <0.883835, -0.290098, -0.733983>, <0.875248, -0.276264, -0.757812>, 
      <0.894677, -0.370053, -0.708100>, <0.881074, -0.356762, -0.729544>, <0.873664, -0.334482, -0.760688>, <0.865096, -0.320244, -0.784041>, 
      <0.893331, -0.395917, -0.724043>, <0.879729, -0.382626, -0.745487>, <0.872151, -0.363559, -0.778612>, <0.863583, -0.349321, -0.801965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.799896, -0.296065, -0.638765>, <0.788807, -0.286182, -0.664588>, <0.790144, -0.265873, -0.700906>, <0.781795, -0.251663, -0.725722>, 
      <0.827356, -0.293354, -0.643629>, <0.816267, -0.283471, -0.669451>, <0.812501, -0.263681, -0.704885>, <0.804152, -0.249471, -0.729700>, 
      <0.870708, -0.293568, -0.654325>, <0.856744, -0.283842, -0.677635>, <0.852429, -0.252599, -0.704707>, <0.843842, -0.238764, -0.728535>, 
      <0.886952, -0.310928, -0.669151>, <0.872988, -0.301202, -0.692461>, <0.864998, -0.267607, -0.716423>, <0.856411, -0.253772, -0.740252>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.709949, -0.328405, -0.637802>, <0.698856, -0.316513, -0.661576>, <0.688229, -0.284954, -0.684941>, <0.680671, -0.271002, -0.708980>, 
      <0.729780, -0.309071, -0.630367>, <0.718687, -0.297179, -0.654141>, <0.711566, -0.265033, -0.678796>, <0.704008, -0.251081, -0.702835>, 
      <0.771791, -0.298840, -0.633787>, <0.760702, -0.288957, -0.659610>, <0.759478, -0.268880, -0.695449>, <0.751129, -0.254670, -0.720265>, 
      <0.799896, -0.296065, -0.638765>, <0.788807, -0.286182, -0.664588>, <0.790144, -0.265873, -0.700906>, <0.781795, -0.251663, -0.725722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675098, -0.417735, -0.685555>, <0.664733, -0.403693, -0.708472>, <0.648850, -0.385925, -0.738886>, <0.641489, -0.371434, -0.762669>, 
      <0.675197, -0.390534, -0.668443>, <0.664832, -0.376493, -0.691360>, <0.648961, -0.355343, -0.719647>, <0.641600, -0.340853, -0.743430>, 
      <0.687726, -0.350071, -0.646134>, <0.676633, -0.338179, -0.669908>, <0.661285, -0.307955, -0.692036>, <0.653726, -0.294003, -0.716075>, 
      <0.709949, -0.328405, -0.637802>, <0.698856, -0.316513, -0.661576>, <0.688229, -0.284954, -0.684941>, <0.680671, -0.271002, -0.708980>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.675098, -0.417735, -0.685555>, <0.675015, -0.440440, -0.699839>, <0.690353, -0.469978, -0.722271>, <0.709385, -0.483565, -0.735415>, 
      <0.664733, -0.403693, -0.708472>, <0.664651, -0.426399, -0.722756>, <0.679282, -0.454496, -0.743966>, <0.698313, -0.468083, -0.757110>, 
      <0.648850, -0.385925, -0.738886>, <0.648758, -0.411451, -0.754945>, <0.664922, -0.447053, -0.780431>, <0.687612, -0.460345, -0.795197>, 
      <0.641489, -0.371434, -0.762669>, <0.641396, -0.396960, -0.778728>, <0.657348, -0.432153, -0.803958>, <0.680037, -0.445444, -0.818724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.970104, -0.766148, -0.495247>, <0.889770, -0.685257, -0.545911>, <0.845208, -0.582549, -0.683914>, <0.799099, -0.506260, -0.771194>, 
      <0.956473, -0.789285, -0.451622>, <0.876138, -0.708394, -0.502286>, <0.816093, -0.584017, -0.677903>, <0.769985, -0.507729, -0.765183>, 
      <0.944820, -0.805891, -0.378612>, <0.829108, -0.736656, -0.475638>, <0.794231, -0.587757, -0.625124>, <0.730503, -0.498641, -0.750000>, 
      <0.928530, -0.792928, -0.331805>, <0.812818, -0.723693, -0.428831>, <0.773114, -0.572681, -0.610540>, <0.709385, -0.483565, -0.735415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.011892, -0.651433, -0.598592>, <0.951960, -0.593953, -0.611316>, <0.915758, -0.523259, -0.712539>, <0.878414, -0.475039, -0.770314>, 
      <0.999003, -0.697312, -0.592963>, <0.939071, -0.639832, -0.605686>, <0.899964, -0.541754, -0.720442>, <0.862620, -0.493534, -0.778217>, 
      <0.982873, -0.744475, -0.536112>, <0.902539, -0.663583, -0.586776>, <0.870222, -0.581287, -0.689079>, <0.824113, -0.504998, -0.776359>, 
      <0.970104, -0.766148, -0.495247>, <0.889770, -0.685257, -0.545911>, <0.845208, -0.582549, -0.683914>, <0.799099, -0.506260, -0.771194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.039041, -0.520763, -0.525356>, <0.985206, -0.484737, -0.577032>, <0.932656, -0.434342, -0.662047>, <0.893331, -0.395917, -0.724043>, 
      <1.035634, -0.560228, -0.548087>, <0.981799, -0.524201, -0.599762>, <0.931424, -0.458035, -0.676651>, <0.892098, -0.419609, -0.738648>, 
      <1.024159, -0.607769, -0.603950>, <0.964226, -0.550288, -0.616673>, <0.932965, -0.503111, -0.703929>, <0.895621, -0.454891, -0.761704>, 
      <1.011892, -0.651433, -0.598592>, <0.951960, -0.593953, -0.611316>, <0.915758, -0.523259, -0.712539>, <0.878414, -0.475039, -0.770314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.035455, -0.378479, -0.441377>, <0.979646, -0.370343, -0.503698>, <0.927620, -0.339254, -0.601265>, <0.886952, -0.310928, -0.669151>, 
      <1.047389, -0.396356, -0.486053>, <0.991580, -0.388220, -0.548374>, <0.945252, -0.358097, -0.617358>, <0.904584, -0.329771, -0.685244>, 
      <1.042739, -0.477922, -0.500681>, <0.988904, -0.441896, -0.552356>, <0.934002, -0.408479, -0.646104>, <0.894677, -0.370053, -0.708100>, 
      <1.039041, -0.520763, -0.525356>, <0.985206, -0.484737, -0.577032>, <0.932656, -0.434342, -0.662047>, <0.893331, -0.395917, -0.724043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.973384, -0.422414, -0.279569>, <0.906094, -0.409986, -0.384808>, <0.846622, -0.337709, -0.529953>, <0.799896, -0.296065, -0.638765>, 
      <0.990386, -0.396291, -0.323219>, <0.923096, -0.383862, -0.428458>, <0.874082, -0.334998, -0.534817>, <0.827356, -0.293354, -0.643629>, 
      <1.022544, -0.359139, -0.393044>, <0.966735, -0.351003, -0.455365>, <0.911376, -0.321894, -0.586439>, <0.870708, -0.293568, -0.654325>, 
      <1.035455, -0.378479, -0.441377>, <0.979646, -0.370343, -0.503698>, <0.927620, -0.339254, -0.601265>, <0.886952, -0.310928, -0.669151>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.930850, -0.539205, -0.172812>, <0.830269, -0.488266, -0.295853>, <0.774219, -0.397306, -0.500062>, <0.709949, -0.328405, -0.637802>, 
      <0.946667, -0.493258, -0.180217>, <0.846087, -0.442319, -0.303259>, <0.794050, -0.377972, -0.492626>, <0.729780, -0.309071, -0.630367>, 
      <0.957803, -0.446354, -0.239566>, <0.890513, -0.433926, -0.344805>, <0.818518, -0.340484, -0.524976>, <0.771791, -0.298840, -0.633787>, 
      <0.973384, -0.422414, -0.279569>, <0.906094, -0.409986, -0.384808>, <0.846622, -0.337709, -0.529953>, <0.799896, -0.296065, -0.638765>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.879793, -0.694283, -0.235752>, <0.774750, -0.622401, -0.348278>, <0.736226, -0.500549, -0.550395>, <0.675098, -0.417735, -0.685555>, 
      <0.880200, -0.649803, -0.207879>, <0.775157, -0.577920, -0.320405>, <0.736325, -0.473349, -0.533282>, <0.675197, -0.390534, -0.668443>, 
      <0.913958, -0.588273, -0.164904>, <0.813377, -0.537334, -0.287945>, <0.751996, -0.418972, -0.508394>, <0.687726, -0.350071, -0.646134>, 
      <0.930850, -0.539205, -0.172812>, <0.830269, -0.488266, -0.295853>, <0.774219, -0.397306, -0.500062>, <0.709949, -0.328405, -0.637802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.879793, -0.694283, -0.235752>, <0.879454, -0.731411, -0.259018>, <0.914597, -0.781841, -0.291770>, <0.928530, -0.792928, -0.331805>, 
      <0.774750, -0.622401, -0.348278>, <0.774411, -0.659529, -0.371544>, <0.798885, -0.712606, -0.388796>, <0.812818, -0.723693, -0.428831>, 
      <0.736226, -0.500549, -0.550395>, <0.736143, -0.523255, -0.564679>, <0.754082, -0.559094, -0.597396>, <0.773114, -0.572681, -0.610540>, 
      <0.675098, -0.417735, -0.685555>, <0.675015, -0.440440, -0.699839>, <0.690353, -0.469978, -0.722271>, <0.709385, -0.483565, -0.735415>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.981964, -0.473251>, <1.167853, -0.941192, -0.471904>, <1.041846, -0.838387, -0.450002>, <0.970104, -0.766148, -0.495247>, 
      <1.295594, -0.990173, -0.371667>, <1.191920, -0.949402, -0.370320>, <1.028214, -0.861525, -0.406377>, <0.956473, -0.789285, -0.451622>, 
      <1.404622, -0.938152, -0.254173>, <1.280854, -0.895095, -0.332608>, <1.051199, -0.869541, -0.289412>, <0.944820, -0.805891, -0.378612>, 
      <1.396527, -0.894707, -0.159237>, <1.272759, -0.851650, -0.237672>, <1.034909, -0.856578, -0.242605>, <0.928530, -0.792928, -0.331805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.852068, -0.686855>, <1.295616, -0.922941, -0.682188>, <1.254290, -0.976084, -0.546006>, <1.271527, -0.981964, -0.473251>, 
      <1.275822, -0.852190, -0.691211>, <1.299911, -0.923062, -0.686544>, <1.150616, -0.935313, -0.544659>, <1.167853, -0.941192, -0.471904>, 
      <1.084612, -0.721178, -0.583153>, <1.071723, -0.767057, -0.577524>, <1.054615, -0.816714, -0.490867>, <1.041846, -0.838387, -0.450002>, 
      <1.011892, -0.651433, -0.598592>, <0.999003, -0.697312, -0.592963>, <0.982873, -0.744475, -0.536112>, <0.970104, -0.766148, -0.495247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.125038, -0.550974, -0.501632>, <1.151197, -0.647541, -0.557923>, <1.234656, -0.743589, -0.693998>, <1.271527, -0.852068, -0.686855>, 
      <1.105511, -0.560499, -0.483566>, <1.131670, -0.657066, -0.539857>, <1.238951, -0.743711, -0.698354>, <1.275822, -0.852190, -0.691211>, 
      <1.057398, -0.533048, -0.507735>, <1.053991, -0.572512, -0.530466>, <1.096879, -0.677513, -0.588511>, <1.084612, -0.721178, -0.583153>, 
      <1.039041, -0.520763, -0.525356>, <1.035634, -0.560228, -0.548087>, <1.024159, -0.607769, -0.603950>, <1.011892, -0.651433, -0.598592>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.613971, -1.226218, -1.622029>, <2.613971, -1.226218, -1.622029>, <2.640099, -1.214625, -1.623298>, <2.640099, -1.214625, -1.623298>, 
      <2.596462, -1.232338, -1.505578>, <2.624715, -1.228891, -1.502661>, <2.643756, -1.221342, -1.503049>, <2.664268, -1.202234, -1.508776>, 
      <2.583153, -1.219441, -1.419870>, <2.611406, -1.215993, -1.416953>, <2.649734, -1.199909, -1.418372>, <2.670245, -1.180801, -1.424099>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.590889, -1.220630, -1.628379>, <2.590889, -1.220630, -1.628379>, <2.613971, -1.226218, -1.622029>, <2.613971, -1.226218, -1.622029>, 
      <2.582205, -1.194226, -1.485953>, <2.597514, -1.210528, -1.475747>, <2.572187, -1.235300, -1.508084>, <2.596462, -1.232338, -1.505578>, 
      <2.506214, -1.200815, -1.441036>, <2.521523, -1.217117, -1.430830>, <2.558878, -1.222403, -1.422376>, <2.583153, -1.219441, -1.419870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.586569, -1.197039, -1.640296>, <2.586569, -1.197039, -1.640296>, <2.590889, -1.220630, -1.628379>, <2.590889, -1.220630, -1.628379>, 
      <2.524966, -1.156222, -1.552140>, <2.526141, -1.180301, -1.540479>, <2.565526, -1.176466, -1.497071>, <2.582205, -1.194226, -1.485953>, 
      <2.491814, -1.122179, -1.480759>, <2.492988, -1.146259, -1.469097>, <2.489536, -1.183055, -1.452154>, <2.506214, -1.200815, -1.441036>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.588449, -1.170591, -1.652612>, <2.588449, -1.170591, -1.652612>, <2.586569, -1.197039, -1.640296>, <2.586569, -1.197039, -1.640296>, 
      <2.530509, -1.088454, -1.585479>, <2.513378, -1.110807, -1.577633>, <2.523685, -1.129935, -1.564871>, <2.524966, -1.156222, -1.552140>, 
      <2.498080, -1.034020, -1.521811>, <2.480949, -1.056373, -1.513966>, <2.490532, -1.095892, -1.493489>, <2.491814, -1.122179, -1.480759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.613803, -1.161503, -1.652769>, <2.613803, -1.161503, -1.652769>, <2.588449, -1.170591, -1.652612>, <2.588449, -1.170591, -1.652612>, 
      <2.596062, -1.064575, -1.585516>, <2.569414, -1.066489, -1.588929>, <2.546292, -1.067860, -1.592707>, <2.530509, -1.088454, -1.585479>, 
      <2.582593, -1.003727, -1.522333>, <2.555945, -1.005641, -1.525746>, <2.513863, -1.013426, -1.529039>, <2.498080, -1.034020, -1.521811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.639980, -1.166890, -1.646012>, <2.639980, -1.166890, -1.646012>, <2.613803, -1.161503, -1.652769>, <2.613803, -1.161503, -1.652769>, 
      <2.663920, -1.078704, -1.568192>, <2.644692, -1.062256, -1.579130>, <2.623336, -1.062616, -1.582023>, <2.596062, -1.064575, -1.585516>, 
      <2.669849, -1.021681, -1.499811>, <2.650621, -1.005233, -1.510749>, <2.609867, -1.001768, -1.518840>, <2.582593, -1.003727, -1.522333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, <2.627179, -1.229122, -1.708669>, 
      <2.650104, -1.192557, -1.632118>, <2.650104, -1.192557, -1.632118>, <2.639980, -1.166890, -1.646012>, <2.639980, -1.166890, -1.646012>, 
      <2.690228, -1.144976, -1.531728>, <2.690159, -1.117081, -1.545001>, <2.685467, -1.097137, -1.555934>, <2.663920, -1.078704, -1.568192>, 
      <2.703595, -1.107238, -1.453499>, <2.703526, -1.079343, -1.466772>, <2.691396, -1.040114, -1.487554>, <2.669849, -1.021681, -1.499811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.627179, -1.229122, -1.708669>, <2.650104, -1.192557, -1.632118>, <2.690228, -1.144976, -1.531728>, <2.703595, -1.107238, -1.453499>, 
      <2.627179, -1.229122, -1.708669>, <2.650104, -1.192557, -1.632118>, <2.690286, -1.168260, -1.520649>, <2.703653, -1.130522, -1.442419>, 
      <2.627179, -1.229122, -1.708669>, <2.640099, -1.214625, -1.623298>, <2.682753, -1.185012, -1.513937>, <2.688730, -1.163579, -1.429260>, 
      <2.627179, -1.229122, -1.708669>, <2.640099, -1.214625, -1.623298>, <2.664268, -1.202234, -1.508776>, <2.670245, -1.180801, -1.424099>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.567100, -1.170901, -1.321759>, <2.571916, -1.185463, -1.351192>, <2.578116, -1.214559, -1.387430>, <2.583153, -1.219441, -1.419870>, 
      <2.589083, -1.162105, -1.305695>, <2.593899, -1.176667, -1.335129>, <2.606369, -1.211112, -1.384512>, <2.611406, -1.215993, -1.416953>, 
      <2.633681, -1.151368, -1.320260>, <2.638496, -1.165930, -1.349694>, <2.651999, -1.191784, -1.386272>, <2.649734, -1.199909, -1.418372>, 
      <2.654192, -1.132260, -1.325988>, <2.659008, -1.146822, -1.355421>, <2.672511, -1.172676, -1.391998>, <2.670245, -1.180801, -1.424099>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.352597, -1.252929, -1.546367>, <2.361016, -1.278388, -1.597824>, <2.456402, -1.205134, -1.411592>, <2.506214, -1.200815, -1.441036>, 
      <2.412614, -1.316838, -1.506358>, <2.421033, -1.342296, -1.557815>, <2.471711, -1.221436, -1.401387>, <2.521523, -1.217117, -1.430830>, 
      <2.493058, -1.200525, -1.375862>, <2.497874, -1.215087, -1.405296>, <2.553841, -1.217521, -1.389936>, <2.558878, -1.222403, -1.422376>, 
      <2.567100, -1.170901, -1.321759>, <2.571916, -1.185463, -1.351192>, <2.578116, -1.214559, -1.387430>, <2.583153, -1.219441, -1.419870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.475761, -1.073639, -1.382648>, <2.480577, -1.088201, -1.412081>, <2.478982, -1.109003, -1.453131>, <2.491814, -1.122179, -1.480759>, 
      <2.442875, -1.141593, -1.413815>, <2.447691, -1.156155, -1.443249>, <2.480157, -1.133083, -1.441470>, <2.492988, -1.146259, -1.469097>, 
      <2.301732, -1.198766, -1.580275>, <2.310151, -1.224224, -1.631732>, <2.439723, -1.187374, -1.422711>, <2.489536, -1.183055, -1.452154>, 
      <2.352597, -1.252929, -1.546367>, <2.361016, -1.278388, -1.597824>, <2.456402, -1.205134, -1.411592>, <2.506214, -1.200815, -1.441036>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.482027, -0.985480, -1.423701>, <2.486843, -1.000042, -1.453134>, <2.486097, -1.013907, -1.498286>, <2.498080, -1.034020, -1.521811>, 
      <2.464896, -1.007833, -1.415855>, <2.469712, -1.022395, -1.445288>, <2.468966, -1.036260, -1.490441>, <2.480949, -1.056373, -1.513966>, 
      <2.487532, -1.049315, -1.371492>, <2.492348, -1.063877, -1.400925>, <2.477700, -1.082716, -1.465861>, <2.490532, -1.095892, -1.493489>, 
      <2.475761, -1.073639, -1.382648>, <2.480577, -1.088201, -1.412081>, <2.478982, -1.109003, -1.453131>, <2.491814, -1.122179, -1.480759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.566540, -0.955186, -1.424223>, <2.571356, -0.969748, -1.453656>, <2.577556, -0.980971, -1.498704>, <2.582593, -1.003727, -1.522333>, 
      <2.539892, -0.957100, -1.427637>, <2.544708, -0.971662, -1.457070>, <2.550908, -0.982885, -1.502117>, <2.555945, -1.005641, -1.525746>, 
      <2.497809, -0.964886, -1.430929>, <2.502625, -0.979448, -1.460362>, <2.501880, -0.993313, -1.505514>, <2.513863, -1.013426, -1.529039>, 
      <2.482027, -0.985480, -1.423701>, <2.486843, -1.000042, -1.453134>, <2.486097, -1.013907, -1.498286>, <2.498080, -1.034020, -1.521811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.653796, -0.973140, -1.401700>, <2.658612, -0.987703, -1.431133>, <2.672054, -1.000472, -1.474377>, <2.669849, -1.021681, -1.499811>, 
      <2.634568, -0.956692, -1.412638>, <2.639384, -0.971254, -1.442072>, <2.652827, -0.984024, -1.485315>, <2.650621, -1.005233, -1.510749>, 
      <2.593814, -0.953227, -1.420730>, <2.598630, -0.967789, -1.450163>, <2.604829, -0.979012, -1.495211>, <2.609867, -1.001768, -1.518840>, 
      <2.566540, -0.955186, -1.424223>, <2.571356, -0.969748, -1.453656>, <2.577556, -0.980971, -1.498704>, <2.582593, -1.003727, -1.522333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.687542, -1.058698, -1.355388>, <2.692358, -1.073260, -1.384821>, <2.708643, -1.092985, -1.423953>, <2.703595, -1.107238, -1.453499>, 
      <2.687473, -1.030803, -1.368662>, <2.692289, -1.045365, -1.398094>, <2.708574, -1.065090, -1.437226>, <2.703526, -1.079343, -1.466772>, 
      <2.675344, -0.991573, -1.389442>, <2.680159, -1.006136, -1.418876>, <2.693602, -1.018905, -1.462120>, <2.691396, -1.040114, -1.487554>, 
      <2.653796, -0.973140, -1.401700>, <2.658612, -0.987703, -1.431133>, <2.672054, -1.000472, -1.474377>, <2.669849, -1.021681, -1.499811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.687542, -1.058698, -1.355388>, <2.687600, -1.081983, -1.344309>, <2.672678, -1.115039, -1.331149>, <2.654192, -1.132260, -1.325988>, 
      <2.692358, -1.073260, -1.384821>, <2.692416, -1.096545, -1.373742>, <2.677493, -1.129601, -1.360582>, <2.659008, -1.146822, -1.355421>, 
      <2.708643, -1.092985, -1.423953>, <2.708701, -1.116270, -1.412874>, <2.690996, -1.155454, -1.397160>, <2.672511, -1.172676, -1.391998>, 
      <2.703595, -1.107238, -1.453499>, <2.703653, -1.130522, -1.442419>, <2.688730, -1.163579, -1.429260>, <2.670245, -1.180801, -1.424099>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.555634, -1.136229, -1.251680>, <2.559395, -1.146609, -1.272659>, <2.563660, -1.160499, -1.300735>, <2.567100, -1.170901, -1.321759>, 
      <2.583887, -1.132782, -1.248763>, <2.587648, -1.143161, -1.269742>, <2.585643, -1.151704, -1.284672>, <2.589083, -1.162105, -1.305695>, 
      <2.622215, -1.116697, -1.250183>, <2.626128, -1.127065, -1.271139>, <2.630241, -1.140966, -1.299237>, <2.633681, -1.151368, -1.320260>, 
      <2.642726, -1.097589, -1.255910>, <2.646640, -1.107957, -1.276866>, <2.650752, -1.121858, -1.304964>, <2.654192, -1.132260, -1.325988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.478695, -1.117602, -1.272845>, <2.472153, -1.161434, -1.361437>, <2.338224, -1.209467, -1.458521>, <2.352597, -1.252929, -1.546367>, 
      <2.494004, -1.133905, -1.262639>, <2.487463, -1.177736, -1.351231>, <2.398241, -1.273376, -1.418512>, <2.412614, -1.316838, -1.506358>, 
      <2.531359, -1.139191, -1.254186>, <2.535120, -1.149571, -1.275166>, <2.489618, -1.190124, -1.354839>, <2.493058, -1.200525, -1.375862>, 
      <2.555634, -1.136229, -1.251680>, <2.559395, -1.146609, -1.272659>, <2.563660, -1.160499, -1.300735>, <2.567100, -1.170901, -1.321759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.464295, -1.038969, -1.312569>, <2.467912, -1.049358, -1.333569>, <2.472321, -1.063238, -1.361625>, <2.475761, -1.073639, -1.382648>, 
      <2.465469, -1.063048, -1.300908>, <2.469087, -1.073438, -1.321908>, <2.439435, -1.131192, -1.392792>, <2.442875, -1.141593, -1.413815>, 
      <2.462017, -1.099843, -1.283963>, <2.455475, -1.143674, -1.372556>, <2.287359, -1.155304, -1.492429>, <2.301732, -1.198766, -1.580275>, 
      <2.478695, -1.117602, -1.272845>, <2.472153, -1.161434, -1.361437>, <2.338224, -1.209467, -1.458521>, <2.352597, -1.252929, -1.546367>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.470560, -0.950808, -1.353623>, <2.474207, -0.961195, -1.374618>, <2.478587, -0.975078, -1.402677>, <2.482027, -0.985480, -1.423701>, 
      <2.453429, -0.973162, -1.345777>, <2.457076, -0.983549, -1.366772>, <2.461456, -0.997432, -1.394832>, <2.464896, -1.007833, -1.415855>, 
      <2.463013, -1.012682, -1.325300>, <2.466630, -1.023071, -1.346300>, <2.484092, -1.038914, -1.350468>, <2.487532, -1.049315, -1.371492>, 
      <2.464295, -1.038969, -1.312569>, <2.467912, -1.049358, -1.333569>, <2.472321, -1.063238, -1.361625>, <2.475761, -1.073639, -1.382648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.555073, -0.920514, -1.354145>, <2.558881, -0.930890, -1.375118>, <2.563100, -0.944784, -1.403200>, <2.566540, -0.955186, -1.424223>, 
      <2.528425, -0.922428, -1.357558>, <2.532233, -0.932804, -1.378531>, <2.536452, -0.946699, -1.406613>, <2.539892, -0.957100, -1.427637>, 
      <2.486342, -0.930214, -1.360851>, <2.489990, -0.940601, -1.381846>, <2.494370, -0.954484, -1.409905>, <2.497809, -0.964886, -1.430929>, 
      <2.470560, -0.950808, -1.353623>, <2.474207, -0.961195, -1.374618>, <2.478587, -0.975078, -1.402677>, <2.482027, -0.985480, -1.423701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.642330, -0.938470, -1.331622>, <2.646276, -0.948836, -1.352573>, <2.650356, -0.962739, -1.380677>, <2.653796, -0.973140, -1.401700>, 
      <2.623102, -0.922021, -1.342560>, <2.627048, -0.932387, -1.363512>, <2.631129, -0.946291, -1.391615>, <2.634568, -0.956692, -1.412638>, 
      <2.582347, -0.918555, -1.350652>, <2.586155, -0.928931, -1.371624>, <2.590374, -0.942825, -1.399707>, <2.593814, -0.953227, -1.420730>, 
      <2.555073, -0.920514, -1.354145>, <2.558881, -0.930890, -1.375118>, <2.563100, -0.944784, -1.403200>, <2.566540, -0.955186, -1.424223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.676075, -1.024025, -1.285310>, <2.680057, -1.034388, -1.306257>, <2.684102, -1.048297, -1.334365>, <2.687542, -1.058698, -1.355388>, 
      <2.676006, -0.996130, -1.298583>, <2.679988, -1.006494, -1.319530>, <2.684032, -1.020401, -1.347638>, <2.687473, -1.030803, -1.368662>, 
      <2.663877, -0.956902, -1.319364>, <2.667823, -0.967268, -1.340316>, <2.671904, -0.981172, -1.368419>, <2.675344, -0.991573, -1.389442>, 
      <2.642330, -0.938470, -1.331622>, <2.646276, -0.948836, -1.352573>, <2.650356, -0.962739, -1.380677>, <2.653796, -0.973140, -1.401700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.676075, -1.024025, -1.285310>, <2.676133, -1.047310, -1.274231>, <2.661211, -1.080367, -1.261071>, <2.642726, -1.097589, -1.255910>, 
      <2.680057, -1.034388, -1.306257>, <2.680115, -1.057673, -1.295178>, <2.665125, -1.090736, -1.282028>, <2.646640, -1.107957, -1.276866>, 
      <2.684102, -1.048297, -1.334365>, <2.684160, -1.071581, -1.323286>, <2.669238, -1.104637, -1.310126>, <2.650752, -1.121858, -1.304964>, 
      <2.687542, -1.058698, -1.355388>, <2.687600, -1.081983, -1.344309>, <2.672678, -1.115039, -1.331149>, <2.654192, -1.132260, -1.325988>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.474325, -0.914849, -0.804226>, <2.498813, -0.976619, -0.940645>, <2.531562, -1.069792, -1.117397>, <2.555634, -1.136229, -1.251680>, 
      <2.499970, -0.907669, -0.793765>, <2.524458, -0.969439, -0.930184>, <2.559815, -1.066345, -1.114480>, <2.583887, -1.132782, -1.248763>, 
      <2.534687, -0.886526, -0.784960>, <2.557891, -0.953431, -0.928230>, <2.595831, -1.046799, -1.108905>, <2.622215, -1.116697, -1.250183>, 
      <2.553203, -0.864715, -0.785225>, <2.576408, -0.931620, -0.928495>, <2.616342, -1.027691, -1.114633>, <2.642726, -1.097589, -1.255910>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.404315, -0.906399, -0.845961>, <2.430029, -0.965891, -0.975239>, <2.488245, -1.053613, -1.143511>, <2.478695, -1.117602, -1.272845>, 
      <2.418311, -0.920672, -0.831653>, <2.444025, -0.980164, -0.960931>, <2.503555, -1.069915, -1.133305>, <2.494004, -1.133905, -1.262639>, 
      <2.452291, -0.921018, -0.813215>, <2.476780, -0.982787, -0.949633>, <2.507288, -1.072754, -1.119904>, <2.531359, -1.139191, -1.254186>, 
      <2.474325, -0.914849, -0.804226>, <2.498813, -0.976619, -0.940645>, <2.531562, -1.069792, -1.117397>, <2.555634, -1.136229, -1.251680>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.390826, -0.829696, -0.889588>, <2.416881, -0.891974, -1.015969>, <2.442432, -0.976175, -1.185650>, <2.464295, -1.038969, -1.312569>, 
      <2.392013, -0.853611, -0.877597>, <2.418068, -0.915890, -1.003977>, <2.443606, -1.000254, -1.173989>, <2.465469, -1.063048, -1.300908>, 
      <2.389068, -0.890850, -0.861548>, <2.414782, -0.950342, -0.990826>, <2.471567, -1.035854, -1.154629>, <2.462017, -1.099843, -1.283963>, 
      <2.404315, -0.906399, -0.845961>, <2.430029, -0.965891, -0.975239>, <2.488245, -1.053613, -1.143511>, <2.478695, -1.117602, -1.272845>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.396092, -0.740737, -0.929026>, <2.422156, -0.806988, -1.054036>, <2.448427, -0.887772, -1.226215>, <2.470560, -0.950808, -1.353623>, 
      <2.380655, -0.765346, -0.925739>, <2.406719, -0.831597, -1.050749>, <2.431296, -0.910126, -1.218369>, <2.453429, -0.973162, -1.345777>, 
      <2.389530, -0.803587, -0.902679>, <2.415585, -0.865865, -1.029060>, <2.441150, -0.949888, -1.198381>, <2.463013, -1.012682, -1.325300>, 
      <2.390826, -0.829696, -0.889588>, <2.416881, -0.891974, -1.015969>, <2.442432, -0.976175, -1.185650>, <2.464295, -1.038969, -1.312569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.472628, -0.699291, -0.907008>, <2.497450, -0.770206, -1.038785>, <2.530707, -0.854120, -1.219950>, <2.555073, -0.920514, -1.354145>, 
      <2.448440, -0.704726, -0.917536>, <2.473262, -0.775640, -1.049313>, <2.504059, -0.856035, -1.223363>, <2.528425, -0.922428, -1.357558>, 
      <2.410314, -0.718065, -0.932054>, <2.436378, -0.784317, -1.057065>, <2.464209, -0.867178, -1.233443>, <2.486342, -0.930214, -1.360851>, 
      <2.396092, -0.740737, -0.929026>, <2.422156, -0.806988, -1.054036>, <2.448427, -0.887772, -1.226215>, <2.470560, -0.950808, -1.353623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.552002, -0.705707, -0.861161>, <2.575444, -0.779368, -1.001000>, <2.615736, -0.868603, -1.190406>, <2.642330, -0.938470, -1.331622>, 
      <2.534455, -0.691805, -0.877247>, <2.557897, -0.765466, -1.017086>, <2.596508, -0.852155, -1.201345>, <2.623102, -0.922021, -1.342560>, 
      <2.497384, -0.693729, -0.896232>, <2.522206, -0.764644, -1.028009>, <2.557981, -0.852161, -1.216457>, <2.582347, -0.918555, -1.350652>, 
      <2.472628, -0.699291, -0.907008>, <2.497450, -0.770206, -1.038785>, <2.530707, -0.854120, -1.219950>, <2.555073, -0.920514, -1.354145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.583052, -0.786776, -0.805781>, <2.609835, -0.857882, -0.949887>, <2.648709, -0.952808, -1.141368>, <2.676075, -1.024025, -1.285310>, 
      <2.582841, -0.758900, -0.819093>, <2.609624, -0.830006, -0.963199>, <2.648640, -0.924914, -1.154641>, <2.676006, -0.996130, -1.298583>, 
      <2.571666, -0.721286, -0.843135>, <2.595108, -0.794947, -0.982974>, <2.637283, -0.887035, -1.178149>, <2.663877, -0.956902, -1.319364>, 
      <2.552002, -0.705707, -0.861161>, <2.575444, -0.779368, -1.001000>, <2.615736, -0.868603, -1.190406>, <2.642330, -0.938470, -1.331622>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.583052, -0.786776, -0.805781>, <2.583228, -0.810044, -0.794669>, <2.569890, -0.845058, -0.785464>, <2.553203, -0.864715, -0.785225>, 
      <2.609835, -0.857882, -0.949887>, <2.610010, -0.881150, -0.938775>, <2.593095, -0.911963, -0.928733>, <2.576408, -0.931620, -0.928495>, 
      <2.648709, -0.952808, -1.141368>, <2.648767, -0.976093, -1.130289>, <2.634828, -1.010470, -1.119794>, <2.616342, -1.027691, -1.114633>, 
      <2.676075, -1.024025, -1.285310>, <2.676133, -1.047310, -1.274231>, <2.661211, -1.080367, -1.261071>, <2.642726, -1.097589, -1.255910>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.459016, -0.892519, -0.713442>, <2.467658, -0.903861, -0.738027>, <2.469738, -0.903280, -0.778676>, <2.474325, -0.914849, -0.804226>, 
      <2.489009, -0.884122, -0.701207>, <2.497651, -0.895464, -0.725791>, <2.495384, -0.896100, -0.768214>, <2.499970, -0.907669, -0.793765>, 
      <2.530596, -0.860074, -0.688641>, <2.539091, -0.872208, -0.714367>, <2.530376, -0.874098, -0.758348>, <2.534687, -0.886526, -0.784960>, 
      <2.551266, -0.833885, -0.691219>, <2.559760, -0.846019, -0.716945>, <2.548893, -0.852287, -0.758613>, <2.553203, -0.864715, -0.785225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.377136, -0.882635, -0.762254>, <2.385887, -0.893625, -0.785718>, <2.399452, -0.895148, -0.821513>, <2.404315, -0.906399, -0.845961>, 
      <2.393505, -0.899328, -0.745520>, <2.402256, -0.910318, -0.768984>, <2.413448, -0.909421, -0.807205>, <2.418311, -0.920672, -0.831653>, 
      <2.433247, -0.899733, -0.723954>, <2.441889, -0.911076, -0.748539>, <2.447705, -0.909449, -0.787664>, <2.452291, -0.921018, -0.813215>, 
      <2.459016, -0.892519, -0.713442>, <2.467658, -0.903861, -0.738027>, <2.469738, -0.903280, -0.778676>, <2.474325, -0.914849, -0.804226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.361358, -0.792927, -0.813278>, <2.370049, -0.804191, -0.836114>, <2.385933, -0.818001, -0.865856>, <2.390826, -0.829696, -0.889588>, 
      <2.362746, -0.820897, -0.799253>, <2.371438, -0.832162, -0.822089>, <2.387120, -0.841917, -0.853864>, <2.392013, -0.853611, -0.877597>, 
      <2.359304, -0.864450, -0.780484>, <2.368055, -0.875440, -0.803948>, <2.384205, -0.879599, -0.837100>, <2.389068, -0.890850, -0.861548>, 
      <2.377136, -0.882635, -0.762254>, <2.385887, -0.893625, -0.785718>, <2.399452, -0.895148, -0.821513>, <2.404315, -0.906399, -0.845961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.367518, -0.688886, -0.859402>, <2.376337, -0.700887, -0.882422>, <2.391124, -0.728110, -0.905201>, <2.396092, -0.740737, -0.929026>, 
      <2.349464, -0.717667, -0.855557>, <2.358283, -0.729668, -0.878578>, <2.375687, -0.752719, -0.901914>, <2.380655, -0.765346, -0.925739>, 
      <2.359842, -0.762392, -0.828588>, <2.368533, -0.773656, -0.851425>, <2.384637, -0.791892, -0.878947>, <2.389530, -0.803587, -0.902679>, 
      <2.361358, -0.792927, -0.813278>, <2.370049, -0.804191, -0.836114>, <2.385933, -0.818001, -0.865856>, <2.390826, -0.829696, -0.889588>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.457030, -0.640413, -0.833650>, <2.465731, -0.653155, -0.857736>, <2.467947, -0.685919, -0.882159>, <2.472628, -0.699291, -0.907008>, 
      <2.428741, -0.646769, -0.845963>, <2.437443, -0.659511, -0.870050>, <2.443760, -0.691353, -0.892687>, <2.448440, -0.704726, -0.917536>, 
      <2.384151, -0.662371, -0.862943>, <2.392970, -0.674371, -0.885964>, <2.405346, -0.705439, -0.908230>, <2.410314, -0.718065, -0.932054>, 
      <2.367518, -0.688886, -0.859402>, <2.376337, -0.700887, -0.882422>, <2.391124, -0.728110, -0.905201>, <2.396092, -0.740737, -0.929026>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.549862, -0.647915, -0.780031>, <2.558417, -0.661153, -0.805427>, <2.547617, -0.691928, -0.835002>, <2.552002, -0.705707, -0.861161>, 
      <2.530341, -0.629574, -0.797973>, <2.538896, -0.642811, -0.823370>, <2.530070, -0.678026, -0.851088>, <2.534455, -0.691805, -0.877247>, 
      <2.485983, -0.633907, -0.821047>, <2.494684, -0.646650, -0.845133>, <2.492703, -0.680357, -0.871383>, <2.497384, -0.693729, -0.896232>, 
      <2.457030, -0.640413, -0.833650>, <2.465731, -0.653155, -0.857736>, <2.467947, -0.685919, -0.882159>, <2.472628, -0.699291, -0.907008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.572421, -0.748831, -0.727591>, <2.579758, -0.759996, -0.750207>, <2.578733, -0.775311, -0.782545>, <2.583052, -0.786776, -0.805781>, 
      <2.572184, -0.717445, -0.742580>, <2.579521, -0.728609, -0.765196>, <2.578523, -0.747436, -0.795857>, <2.582841, -0.758900, -0.819093>, 
      <2.570923, -0.667704, -0.760673>, <2.579478, -0.680941, -0.786070>, <2.567280, -0.707506, -0.816976>, <2.571666, -0.721286, -0.843135>, 
      <2.549862, -0.647915, -0.780031>, <2.558417, -0.661153, -0.805427>, <2.547617, -0.691928, -0.835002>, <2.552002, -0.705707, -0.861161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.572421, -0.748831, -0.727591>, <2.572615, -0.774519, -0.715323>, <2.568850, -0.811605, -0.693413>, <2.551266, -0.833885, -0.691219>, 
      <2.579758, -0.759996, -0.750207>, <2.579952, -0.785684, -0.737940>, <2.577345, -0.823739, -0.719139>, <2.559760, -0.846019, -0.716945>, 
      <2.578733, -0.775311, -0.782545>, <2.578909, -0.798579, -0.771433>, <2.565580, -0.832630, -0.758852>, <2.548893, -0.852287, -0.758613>, 
      <2.583052, -0.786776, -0.805781>, <2.583228, -0.810044, -0.794669>, <2.569890, -0.845058, -0.785464>, <2.553203, -0.864715, -0.785225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.417820, -0.840686, -0.643481>, <2.436375, -0.848884, -0.664061>, <2.450229, -0.880986, -0.688446>, <2.459016, -0.892519, -0.713442>, 
      <2.444498, -0.833217, -0.632599>, <2.463053, -0.841415, -0.653179>, <2.480222, -0.872589, -0.676210>, <2.489009, -0.884122, -0.701207>, 
      <2.480613, -0.811223, -0.623440>, <2.497463, -0.812507, -0.646836>, <2.522338, -0.848277, -0.663630>, <2.530596, -0.860074, -0.688641>, 
      <2.499875, -0.788533, -0.623715>, <2.516725, -0.789817, -0.647111>, <2.543008, -0.822087, -0.666209>, <2.551266, -0.833885, -0.691219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.344990, -0.831896, -0.686897>, <2.360559, -0.848094, -0.705091>, <2.367885, -0.871018, -0.737450>, <2.377136, -0.882635, -0.762254>, 
      <2.359550, -0.846744, -0.672013>, <2.375118, -0.862942, -0.690207>, <2.384254, -0.887710, -0.720716>, <2.393505, -0.899328, -0.745520>, 
      <2.394899, -0.847103, -0.652831>, <2.413454, -0.855301, -0.673412>, <2.424460, -0.888200, -0.698958>, <2.433247, -0.899733, -0.723954>, 
      <2.417820, -0.840686, -0.643481>, <2.436375, -0.848884, -0.664061>, <2.450229, -0.880986, -0.688446>, <2.459016, -0.892519, -0.713442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.330956, -0.752101, -0.732281>, <2.342549, -0.767794, -0.753328>, <2.352087, -0.780911, -0.788920>, <2.361358, -0.792927, -0.813278>, 
      <2.332191, -0.776981, -0.719806>, <2.343784, -0.792674, -0.740853>, <2.353476, -0.808882, -0.774895>, <2.362746, -0.820897, -0.799253>, 
      <2.329129, -0.815720, -0.703112>, <2.344697, -0.831919, -0.721306>, <2.350053, -0.852832, -0.755680>, <2.359304, -0.864450, -0.780484>, 
      <2.344990, -0.831896, -0.686897>, <2.360559, -0.848094, -0.705091>, <2.367885, -0.871018, -0.737450>, <2.377136, -0.882635, -0.762254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.336435, -0.659560, -0.773309>, <2.345746, -0.673382, -0.796840>, <2.358243, -0.676265, -0.835192>, <2.367518, -0.688886, -0.859402>, 
      <2.320376, -0.685160, -0.769889>, <2.329687, -0.698982, -0.793420>, <2.340189, -0.705046, -0.831348>, <2.349464, -0.717667, -0.855557>, 
      <2.329608, -0.724941, -0.745900>, <2.341201, -0.740634, -0.766946>, <2.350572, -0.750377, -0.804230>, <2.359842, -0.762392, -0.828588>, 
      <2.330956, -0.752101, -0.732281>, <2.342549, -0.767794, -0.753328>, <2.352087, -0.780911, -0.788920>, <2.361358, -0.792927, -0.813278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.416054, -0.616444, -0.750403>, <2.426215, -0.624918, -0.775926>, <2.448285, -0.627606, -0.809442>, <2.457030, -0.640413, -0.833650>, 
      <2.390892, -0.622097, -0.761355>, <2.401053, -0.630572, -0.786879>, <2.419996, -0.633962, -0.821755>, <2.428741, -0.646769, -0.845963>, 
      <2.351230, -0.635975, -0.776460>, <2.360541, -0.649797, -0.799990>, <2.374876, -0.649750, -0.838734>, <2.384151, -0.662371, -0.862943>, 
      <2.336435, -0.659560, -0.773309>, <2.345746, -0.673382, -0.796840>, <2.358243, -0.676265, -0.835192>, <2.367518, -0.688886, -0.859402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.498626, -0.623119, -0.702709>, <2.510248, -0.626846, -0.728800>, <2.541618, -0.635159, -0.755557>, <2.549862, -0.647915, -0.780031>, 
      <2.480372, -0.608657, -0.719443>, <2.491995, -0.612384, -0.745533>, <2.522097, -0.616818, -0.773499>, <2.530341, -0.629574, -0.797973>, 
      <2.441807, -0.610658, -0.739193>, <2.451968, -0.619132, -0.764716>, <2.477238, -0.621101, -0.796839>, <2.485983, -0.633907, -0.821047>, 
      <2.416054, -0.616444, -0.750403>, <2.426215, -0.624918, -0.775926>, <2.448285, -0.627606, -0.809442>, <2.457030, -0.640413, -0.833650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.530926, -0.707453, -0.645096>, <2.545080, -0.708538, -0.671930>, <2.563942, -0.735929, -0.701453>, <2.572421, -0.748831, -0.727591>, 
      <2.530707, -0.678455, -0.658945>, <2.544861, -0.679540, -0.685778>, <2.563705, -0.704542, -0.716442>, <2.572184, -0.717445, -0.742580>, 
      <2.519082, -0.639325, -0.683957>, <2.530704, -0.643052, -0.710047>, <2.562679, -0.654948, -0.736199>, <2.570923, -0.667704, -0.760673>, 
      <2.498626, -0.623119, -0.702709>, <2.510248, -0.626846, -0.728800>, <2.541618, -0.635159, -0.755557>, <2.549862, -0.647915, -0.780031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.530926, -0.707453, -0.645096>, <2.531109, -0.731659, -0.633537>, <2.517235, -0.768084, -0.623963>, <2.499875, -0.788533, -0.623715>, 
      <2.545080, -0.708538, -0.671930>, <2.545263, -0.732744, -0.660370>, <2.534084, -0.769368, -0.647359>, <2.516725, -0.789817, -0.647111>, 
      <2.563942, -0.735929, -0.701453>, <2.564136, -0.761617, -0.689186>, <2.560592, -0.799808, -0.668403>, <2.543008, -0.822087, -0.666209>, 
      <2.572421, -0.748831, -0.727591>, <2.572615, -0.774519, -0.715323>, <2.568850, -0.811605, -0.693413>, <2.551266, -0.833885, -0.691219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.229518, -0.791129, -0.458898>, <2.302464, -0.779248, -0.490777>, <2.366136, -0.817853, -0.586157>, <2.417820, -0.840686, -0.643481>, 
      <2.243738, -0.812626, -0.417673>, <2.316685, -0.800745, -0.449552>, <2.392814, -0.810384, -0.575275>, <2.444498, -0.833217, -0.632599>, 
      <2.262662, -0.823571, -0.350467>, <2.360862, -0.806389, -0.413399>, <2.411783, -0.805979, -0.527869>, <2.480613, -0.811223, -0.623440>, 
      <2.272476, -0.812643, -0.304119>, <2.370676, -0.795461, -0.367052>, <2.431045, -0.783289, -0.528144>, <2.499875, -0.788533, -0.623715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.189916, -0.687838, -0.543459>, <2.264732, -0.701330, -0.553670>, <2.303683, -0.788917, -0.638624>, <2.344990, -0.831896, -0.686897>, 
      <2.198123, -0.728561, -0.539080>, <2.272939, -0.742053, -0.549292>, <2.318243, -0.803765, -0.623739>, <2.359550, -0.846744, -0.672013>, 
      <2.217300, -0.772660, -0.494317>, <2.290246, -0.760779, -0.526196>, <2.343215, -0.824270, -0.595507>, <2.394899, -0.847103, -0.652831>, 
      <2.229518, -0.791129, -0.458898>, <2.302464, -0.779248, -0.490777>, <2.366136, -0.817853, -0.586157>, <2.417820, -0.840686, -0.643481>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.180551, -0.548168, -0.485023>, <2.240333, -0.608406, -0.548888>, <2.288052, -0.694022, -0.654389>, <2.330956, -0.752101, -0.732281>, 
      <2.181754, -0.587863, -0.507244>, <2.241535, -0.648101, -0.571109>, <2.289287, -0.718901, -0.641914>, <2.332191, -0.776981, -0.719806>, 
      <2.180974, -0.643474, -0.548229>, <2.255791, -0.656965, -0.558441>, <2.287822, -0.772742, -0.654838>, <2.329129, -0.815720, -0.703112>, 
      <2.189916, -0.687838, -0.543459>, <2.264732, -0.701330, -0.553670>, <2.303683, -0.788917, -0.638624>, <2.344990, -0.831896, -0.686897>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.181586, -0.412882, -0.389537>, <2.266728, -0.486453, -0.480245>, <2.289762, -0.590277, -0.655363>, <2.336435, -0.659560, -0.773309>, 
      <2.173529, -0.432267, -0.434561>, <2.258671, -0.505838, -0.525269>, <2.273703, -0.615877, -0.651943>, <2.320376, -0.685160, -0.769889>, 
      <2.179238, -0.504835, -0.460765>, <2.239020, -0.565074, -0.524630>, <2.286704, -0.666862, -0.668007>, <2.329608, -0.724941, -0.745900>, 
      <2.180551, -0.548168, -0.485023>, <2.240333, -0.608406, -0.548888>, <2.288052, -0.694022, -0.654389>, <2.330956, -0.752101, -0.732281>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.223246, -0.445443, -0.246433>, <2.314964, -0.496399, -0.379952>, <2.356034, -0.566389, -0.599644>, <2.416054, -0.616444, -0.750403>, 
      <2.209834, -0.423001, -0.283999>, <2.301552, -0.473957, -0.417518>, <2.330872, -0.572042, -0.610597>, <2.390892, -0.622097, -0.761355>, 
      <2.189009, -0.395023, -0.348056>, <2.274151, -0.468594, -0.438765>, <2.304557, -0.566692, -0.658513>, <2.351230, -0.635975, -0.776460>, 
      <2.181586, -0.412882, -0.389537>, <2.266728, -0.486453, -0.480245>, <2.289762, -0.590277, -0.655363>, <2.336435, -0.659560, -0.773309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268041, -0.557539, -0.147396>, <2.387459, -0.559961, -0.283995>, <2.425409, -0.599639, -0.538350>, <2.498626, -0.623119, -0.702709>, 
      <2.257887, -0.512804, -0.156880>, <2.377305, -0.515226, -0.293480>, <2.407155, -0.585177, -0.555084>, <2.480372, -0.608657, -0.719443>, 
      <2.236974, -0.468412, -0.207985>, <2.328692, -0.519368, -0.341505>, <2.381787, -0.560602, -0.588434>, <2.441807, -0.610658, -0.739193>, 
      <2.223246, -0.445443, -0.246433>, <2.314964, -0.496399, -0.379952>, <2.356034, -0.566389, -0.599644>, <2.416054, -0.616444, -0.750403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.287144, -0.726961, -0.186747>, <2.404415, -0.709066, -0.287830>, <2.458260, -0.701882, -0.507332>, <2.530926, -0.707453, -0.645096>, 
      <2.286366, -0.682239, -0.159272>, <2.403638, -0.664343, -0.260355>, <2.458041, -0.672884, -0.521180>, <2.530707, -0.678455, -0.658945>, 
      <2.279419, -0.607670, -0.136767>, <2.398837, -0.610092, -0.273367>, <2.445865, -0.615845, -0.519598>, <2.519082, -0.639325, -0.683957>, 
      <2.268041, -0.557539, -0.147396>, <2.387459, -0.559961, -0.283995>, <2.425409, -0.599639, -0.538350>, <2.498626, -0.623119, -0.702709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.287144, -0.726961, -0.186747>, <2.287793, -0.764291, -0.209681>, <2.281321, -0.802794, -0.262349>, <2.272476, -0.812643, -0.304119>, 
      <2.404415, -0.709066, -0.287830>, <2.405064, -0.746396, -0.310764>, <2.379521, -0.785613, -0.325282>, <2.370676, -0.795461, -0.367052>, 
      <2.458260, -0.701882, -0.507332>, <2.458443, -0.726088, -0.495772>, <2.448404, -0.762840, -0.528392>, <2.431045, -0.783289, -0.528144>, 
      <2.530926, -0.707453, -0.645096>, <2.531109, -0.731659, -0.633537>, <2.517235, -0.768084, -0.623963>, <2.499875, -0.788533, -0.623715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.912244, -0.451477>, <2.056358, -0.882281, -0.445698>, <2.153708, -0.803477, -0.425767>, <2.229518, -0.791129, -0.458898>, 
      <1.956516, -0.936103, -0.376401>, <2.034401, -0.906140, -0.370621>, <2.167928, -0.824973, -0.384542>, <2.243738, -0.812626, -0.417673>, 
      <1.874636, -0.923045, -0.285498>, <1.982142, -0.887499, -0.352569>, <2.153042, -0.842751, -0.280215>, <2.262662, -0.823571, -0.350467>, 
      <1.853473, -0.901632, -0.209462>, <1.960979, -0.866085, -0.276534>, <2.162855, -0.831823, -0.233868>, <2.272476, -0.812643, -0.304119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.765800, -0.636872>, <2.018262, -0.772598, -0.575825>, <2.118533, -0.674965, -0.533716>, <2.189916, -0.687838, -0.543459>, 
      <1.952545, -0.830882, -0.626121>, <1.992334, -0.837680, -0.565074>, <2.126741, -0.715688, -0.529337>, <2.198123, -0.728561, -0.539080>, 
      <1.997503, -0.891565, -0.516545>, <2.075387, -0.861602, -0.510765>, <2.141490, -0.785007, -0.461187>, <2.217300, -0.772660, -0.494317>, 
      <1.978473, -0.912244, -0.451477>, <2.056358, -0.882281, -0.445698>, <2.153708, -0.803477, -0.425767>, <2.229518, -0.791129, -0.458898>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.124962, -0.544535, -0.512219>, <2.135322, -0.552012, -0.498705>, <2.170084, -0.537621, -0.473841>, <2.180551, -0.548168, -0.485023>, 
      <2.124962, -0.620308, -0.556879>, <2.135322, -0.627785, -0.543365>, <2.171286, -0.577315, -0.496062>, <2.181754, -0.587863, -0.507244>, 
      <2.010648, -0.685036, -0.650213>, <2.050437, -0.691834, -0.589167>, <2.109592, -0.630601, -0.538487>, <2.180974, -0.643474, -0.548229>, 
      <1.978473, -0.765800, -0.636872>, <2.018262, -0.772598, -0.575825>, <2.118533, -0.674965, -0.533716>, <2.189916, -0.687838, -0.543459>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.350244, -0.391944>, <2.038450, -0.370237, -0.400290>, <2.144021, -0.380422, -0.349515>, <2.181586, -0.412882, -0.389537>, 
      <2.004514, -0.380677, -0.462841>, <2.064490, -0.400670, -0.471188>, <2.135964, -0.399807, -0.394540>, <2.173529, -0.432267, -0.434561>, 
      <2.124962, -0.474384, -0.470872>, <2.135322, -0.481862, -0.457359>, <2.168771, -0.494288, -0.449583>, <2.179238, -0.504835, -0.460765>, 
      <2.124962, -0.544535, -0.512219>, <2.135322, -0.552012, -0.498705>, <2.170084, -0.537621, -0.473841>, <2.180551, -0.548168, -0.485023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.373337, -0.113391>, <2.060094, -0.387746, -0.137550>, <2.176617, -0.419537, -0.178552>, <2.223246, -0.445443, -0.246433>, 
      <1.998810, -0.331070, -0.182897>, <2.080431, -0.345479, -0.207056>, <2.163204, -0.397095, -0.216118>, <2.209834, -0.423001, -0.283999>, 
      <1.951657, -0.318905, -0.318937>, <2.011634, -0.338898, -0.327283>, <2.151443, -0.362562, -0.308035>, <2.189009, -0.395023, -0.348056>, 
      <1.978473, -0.350244, -0.391944>, <2.038450, -0.370237, -0.400290>, <2.144021, -0.380422, -0.349515>, <2.181586, -0.412882, -0.389537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.610035, 0.035266>, <1.979495, -0.623832, -0.016183>, <2.178000, -0.555713, -0.044400>, <2.268041, -0.557539, -0.147396>, 
      <1.874706, -0.520934, 0.028356>, <2.000728, -0.534731, -0.023093>, <2.167846, -0.510978, -0.053884>, <2.257887, -0.512804, -0.156880>, 
      <1.956195, -0.419639, -0.037251>, <2.037815, -0.434048, -0.061410>, <2.190344, -0.442506, -0.140105>, <2.236974, -0.468412, -0.207985>, 
      <1.978473, -0.373337, -0.113391>, <2.060094, -0.387746, -0.137550>, <2.176617, -0.419537, -0.178552>, <2.223246, -0.445443, -0.246433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.807547, -0.079715>, <1.986839, -0.770081, -0.134409>, <2.189317, -0.741889, -0.102425>, <2.287144, -0.726961, -0.186747>, 
      <1.875000, -0.754797, -0.035444>, <1.986839, -0.717331, -0.090138>, <2.188540, -0.697167, -0.074950>, <2.286366, -0.682239, -0.159272>, 
      <1.837554, -0.676836, 0.040447>, <1.963576, -0.690632, -0.011002>, <2.189378, -0.605844, -0.033772>, <2.279419, -0.607670, -0.136767>, 
      <1.853473, -0.610035, 0.035266>, <1.979495, -0.623832, -0.016183>, <2.178000, -0.555713, -0.044400>, <2.268041, -0.557539, -0.147396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.807547, -0.079715>, <1.875000, -0.844707, -0.110902>, <1.840919, -0.888929, -0.164356>, <1.853473, -0.901632, -0.209462>, 
      <1.986839, -0.770081, -0.134409>, <1.986839, -0.807241, -0.165596>, <1.948425, -0.853383, -0.231428>, <1.960979, -0.866085, -0.276534>, 
      <2.189317, -0.741889, -0.102425>, <2.189966, -0.779220, -0.125359>, <2.171700, -0.821975, -0.192098>, <2.162855, -0.831823, -0.233868>, 
      <2.287144, -0.726961, -0.186747>, <2.287793, -0.764291, -0.209681>, <2.281321, -0.802794, -0.262349>, <2.272476, -0.812643, -0.304119>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.569558, -1.095687, 0.468313>, <1.569558, -1.095687, 0.468313>, <1.573379, -1.061434, 0.490053>, <1.573379, -1.061434, 0.490053>, 
      <1.507949, -1.104909, 0.458004>, <1.507949, -1.070092, 0.479176>, <1.497269, -1.047693, 0.497572>, <1.519873, -1.018724, 0.515189>, 
      <1.477071, -1.095032, 0.429867>, <1.477071, -1.060215, 0.451039>, <1.467206, -1.009825, 0.484716>, <1.489809, -0.980856, 0.502333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.573379, -1.111789, 0.459432>, <1.573379, -1.111789, 0.459432>, <1.569558, -1.095687, 0.468313>, <1.569558, -1.095687, 0.468313>, 
      <1.519079, -1.146531, 0.436520>, <1.505799, -1.135184, 0.443421>, <1.507949, -1.120956, 0.448245>, <1.507949, -1.104909, 0.458004>, 
      <1.489809, -1.148705, 0.400262>, <1.476528, -1.137358, 0.407162>, <1.477071, -1.111080, 0.420108>, <1.477071, -1.095032, 0.429867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.613937, -1.133605, 0.445255>, <1.613937, -1.133605, 0.445255>, <1.573379, -1.111789, 0.459432>, <1.573379, -1.111789, 0.459432>, 
      <1.622663, -1.200920, 0.403761>, <1.574487, -1.201400, 0.404550>, <1.553151, -1.175643, 0.418817>, <1.519079, -1.146531, 0.436520>, 
      <1.625000, -1.221425, 0.353005>, <1.576824, -1.221905, 0.353794>, <1.523881, -1.177817, 0.382559>, <1.489809, -1.148705, 0.400262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.654494, -1.110981, 0.458103>, <1.654494, -1.110981, 0.458103>, <1.613937, -1.133605, 0.445255>, <1.613937, -1.133605, 0.445255>, 
      <1.723595, -1.144327, 0.436421>, <1.689522, -1.173439, 0.418717>, <1.670840, -1.200440, 0.402972>, <1.622663, -1.200920, 0.403761>, 
      <1.760191, -1.146011, 0.395832>, <1.726119, -1.175123, 0.378129>, <1.673176, -1.220945, 0.352216>, <1.625000, -1.221425, 0.353005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.658315, -1.095687, 0.468313>, <1.658315, -1.095687, 0.468313>, <1.654494, -1.110981, 0.458103>, <1.654494, -1.110981, 0.458103>, 
      <1.733470, -1.106153, 0.461548>, <1.733470, -1.122201, 0.451789>, <1.736875, -1.132980, 0.443321>, <1.723595, -1.144327, 0.436421>, 
      <1.772929, -1.095032, 0.429867>, <1.772929, -1.111080, 0.420108>, <1.773472, -1.134664, 0.402732>, <1.760191, -1.146011, 0.395832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.654494, -1.060626, 0.488724>, <1.654494, -1.060626, 0.488724>, <1.658315, -1.095687, 0.468313>, <1.658315, -1.095687, 0.468313>, 
      <1.723064, -1.019566, 0.512862>, <1.745668, -1.048535, 0.495246>, <1.733470, -1.071336, 0.482720>, <1.733470, -1.106153, 0.461548>, 
      <1.760191, -0.978161, 0.497903>, <1.782794, -1.007130, 0.480286>, <1.772929, -1.060215, 0.451039>, <1.772929, -1.095032, 0.429867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, <1.609195, -1.095968, 0.484790>, 
      <1.613937, -1.038810, 0.502901>, <1.613937, -1.038810, 0.502901>, <1.654494, -1.060626, 0.488724>, <1.654494, -1.060626, 0.488724>, 
      <1.622600, -0.965473, 0.547979>, <1.670776, -0.964993, 0.547190>, <1.696336, -0.985310, 0.533694>, <1.723064, -1.019566, 0.512862>, 
      <1.625000, -0.905441, 0.545160>, <1.673176, -0.904961, 0.544371>, <1.733463, -0.943905, 0.518734>, <1.760191, -0.978161, 0.497903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.609195, -1.095968, 0.484790>, <1.613937, -1.038810, 0.502901>, <1.622600, -0.965473, 0.547979>, <1.625000, -0.905441, 0.545160>, 
      <1.609195, -1.095968, 0.484790>, <1.613937, -1.038810, 0.502901>, <1.574423, -0.965953, 0.548768>, <1.576823, -0.905921, 0.545949>, 
      <1.609195, -1.095968, 0.484790>, <1.573379, -1.061434, 0.490053>, <1.546601, -0.984468, 0.536020>, <1.516537, -0.946600, 0.523165>, 
      <1.609195, -1.095968, 0.484790>, <1.573379, -1.061434, 0.490053>, <1.519873, -1.018724, 0.515189>, <1.489809, -0.980856, 0.502333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375000, -1.021054, 0.271383>, <1.387776, -1.049842, 0.323333>, <1.433371, -1.081053, 0.390046>, <1.477071, -1.095032, 0.429867>, 
      <1.375000, -0.962213, 0.307165>, <1.387776, -0.991001, 0.359115>, <1.433371, -1.046237, 0.411219>, <1.477071, -1.060215, 0.451039>, 
      <1.358327, -0.877053, 0.364079>, <1.370350, -0.916853, 0.411131>, <1.429475, -0.962300, 0.468582>, <1.467206, -1.009825, 0.484716>, 
      <1.396527, -0.828095, 0.393851>, <1.408550, -0.867895, 0.440904>, <1.452078, -0.933331, 0.486199>, <1.489809, -0.980856, 0.502333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.396527, -1.111763, 0.221349>, <1.408354, -1.136228, 0.276562>, <1.451197, -1.151573, 0.352432>, <1.489809, -1.148705, 0.400262>, 
      <1.374082, -1.092586, 0.233011>, <1.385909, -1.117051, 0.288224>, <1.437916, -1.140225, 0.359332>, <1.476528, -1.137358, 0.407162>, 
      <1.375000, -1.048175, 0.254891>, <1.387776, -1.076963, 0.306840>, <1.433371, -1.097101, 0.380288>, <1.477071, -1.111080, 0.420108>, 
      <1.375000, -1.021054, 0.271383>, <1.387776, -1.049842, 0.323333>, <1.433371, -1.081053, 0.390046>, <1.477071, -1.095032, 0.429867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.234659, 0.141487>, <1.625000, -1.253210, 0.202300>, <1.627712, -1.245219, 0.294108>, <1.625000, -1.221425, 0.353005>, 
      <1.543582, -1.235470, 0.142821>, <1.543582, -1.254021, 0.203634>, <1.579535, -1.245699, 0.294897>, <1.576824, -1.221905, 0.353794>, 
      <1.454109, -1.160962, 0.191431>, <1.465935, -1.185427, 0.246643>, <1.485269, -1.180685, 0.334728>, <1.523881, -1.177817, 0.382559>, 
      <1.396527, -1.111763, 0.221349>, <1.408354, -1.136228, 0.276562>, <1.451197, -1.151573, 0.352432>, <1.489809, -1.148705, 0.400262>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -1.107210, 0.213863>, <1.841558, -1.132095, 0.269877>, <1.801983, -1.147934, 0.349480>, <1.760191, -1.146011, 0.395832>, 
      <1.795891, -1.156409, 0.183944>, <1.783976, -1.181294, 0.239958>, <1.767911, -1.177046, 0.331777>, <1.726119, -1.175123, 0.378129>, 
      <1.706418, -1.233848, 0.140153>, <1.706418, -1.252399, 0.200966>, <1.675888, -1.244739, 0.293319>, <1.673176, -1.220945, 0.352216>, 
      <1.625000, -1.234659, 0.141487>, <1.625000, -1.253210, 0.202300>, <1.627712, -1.245219, 0.294108>, <1.625000, -1.221425, 0.353005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -1.021054, 0.271383>, <1.862224, -1.049842, 0.323333>, <1.819197, -1.081992, 0.392719>, <1.772929, -1.095032, 0.429867>, 
      <1.875000, -1.048175, 0.254891>, <1.862224, -1.076963, 0.306841>, <1.819197, -1.098039, 0.382961>, <1.772929, -1.111080, 0.420108>, 
      <1.875918, -1.088033, 0.225525>, <1.864003, -1.112918, 0.281539>, <1.815264, -1.136587, 0.356381>, <1.773472, -1.134664, 0.402732>, 
      <1.853473, -1.107210, 0.213863>, <1.841558, -1.132095, 0.269877>, <1.801983, -1.147934, 0.349480>, <1.760191, -1.146011, 0.395832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.823543, 0.386364>, <1.841366, -0.863860, 0.434139>, <1.801241, -0.932381, 0.481363>, <1.760191, -0.978161, 0.497903>, 
      <1.891673, -0.872501, 0.356592>, <1.879566, -0.912818, 0.404367>, <1.823844, -0.961351, 0.463746>, <1.782794, -1.007130, 0.480286>, 
      <1.875000, -0.962214, 0.307165>, <1.862224, -0.991001, 0.359115>, <1.819197, -1.047175, 0.413892>, <1.772929, -1.060215, 0.451039>, 
      <1.875000, -1.021054, 0.271383>, <1.862224, -1.049842, 0.323333>, <1.819197, -1.081992, 0.392719>, <1.772929, -1.095032, 0.429867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.700646, 0.466227>, <1.625000, -0.748865, 0.511064>, <1.627628, -0.839722, 0.542074>, <1.625000, -0.905441, 0.545160>, 
      <1.706418, -0.699835, 0.464893>, <1.706418, -0.748054, 0.509729>, <1.675804, -0.839242, 0.541285>, <1.673176, -0.904961, 0.544371>, 
      <1.808302, -0.765651, 0.421569>, <1.796196, -0.805967, 0.469344>, <1.774512, -0.898125, 0.502194>, <1.733463, -0.943905, 0.518734>, 
      <1.853473, -0.823543, 0.386364>, <1.841366, -0.863860, 0.434139>, <1.801241, -0.932381, 0.481363>, <1.760191, -0.978161, 0.497903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.700646, 0.466227>, <1.543582, -0.701457, 0.467561>, <1.441698, -0.770203, 0.429056>, <1.396527, -0.828095, 0.393851>, 
      <1.625000, -0.748865, 0.511064>, <1.543582, -0.749677, 0.512398>, <1.453721, -0.810002, 0.476109>, <1.408550, -0.867895, 0.440904>, 
      <1.627628, -0.839722, 0.542074>, <1.579451, -0.840202, 0.542863>, <1.478807, -0.899075, 0.507031>, <1.452078, -0.933331, 0.486199>, 
      <1.625000, -0.905441, 0.545160>, <1.576823, -0.905921, 0.545949>, <1.516537, -0.946600, 0.523165>, <1.489809, -0.980856, 0.502333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375000, -0.865029, 0.014810>, <1.403174, -0.909921, 0.087656>, <1.356056, -0.978365, 0.194348>, <1.375000, -1.021054, 0.271383>, 
      <1.375000, -0.806188, 0.050592>, <1.403174, -0.851080, 0.123438>, <1.356056, -0.919525, 0.230130>, <1.375000, -0.962213, 0.307165>, 
      <1.358327, -0.721029, 0.107507>, <1.386120, -0.765980, 0.180463>, <1.341077, -0.819951, 0.296571>, <1.358327, -0.877053, 0.364079>, 
      <1.396527, -0.672071, 0.137279>, <1.424320, -0.717021, 0.210235>, <1.379277, -0.770993, 0.326343>, <1.396527, -0.828095, 0.393851>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.396527, -0.955738, -0.035223>, <1.396527, -1.000368, 0.043031>, <1.379214, -1.075948, 0.140522>, <1.396527, -1.111763, 0.221349>, 
      <1.374082, -0.936561, -0.023561>, <1.374082, -0.981191, 0.054693>, <1.356769, -1.056770, 0.152184>, <1.374082, -1.092586, 0.233011>, 
      <1.375000, -0.892150, -0.001683>, <1.403174, -0.937041, 0.071164>, <1.356056, -1.005486, 0.177856>, <1.375000, -1.048175, 0.254891>, 
      <1.375000, -0.865029, 0.014810>, <1.403174, -0.909921, 0.087656>, <1.356056, -0.978365, 0.194348>, <1.375000, -1.021054, 0.271383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.078634, -0.115085>, <1.625000, -1.125441, -0.038113>, <1.625000, -1.208374, 0.055321>, <1.625000, -1.234659, 0.141487>, 
      <1.543582, -1.079445, -0.113751>, <1.543582, -1.126253, -0.036779>, <1.543582, -1.209185, 0.056654>, <1.543582, -1.235470, 0.142821>, 
      <1.454109, -1.004937, -0.065141>, <1.454109, -1.049567, 0.013113>, <1.436795, -1.125147, 0.110603>, <1.454109, -1.160962, 0.191431>, 
      <1.396527, -0.955738, -0.035223>, <1.396527, -1.000368, 0.043031>, <1.379214, -1.075948, 0.140522>, <1.396527, -1.111763, 0.221349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.951185, -0.042709>, <1.853473, -0.990538, 0.038327>, <1.870663, -1.071307, 0.133048>, <1.853473, -1.107210, 0.213863>, 
      <1.795891, -1.000384, -0.072627>, <1.795891, -1.039738, 0.008409>, <1.813081, -1.120506, 0.103130>, <1.795891, -1.156409, 0.183944>, 
      <1.706418, -1.077823, -0.116419>, <1.706418, -1.124630, -0.039447>, <1.706418, -1.207563, 0.053987>, <1.706418, -1.233848, 0.140153>, 
      <1.625000, -1.078634, -0.115085>, <1.625000, -1.125441, -0.038113>, <1.625000, -1.208374, 0.055321>, <1.625000, -1.234659, 0.141487>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.865029, 0.014810>, <1.875000, -0.911837, 0.091782>, <1.893945, -0.978365, 0.194348>, <1.875000, -1.021054, 0.271383>, 
      <1.875000, -0.892150, -0.001682>, <1.875000, -0.938957, 0.075289>, <1.893945, -1.005486, 0.177856>, <1.875000, -1.048175, 0.254891>, 
      <1.875918, -0.932008, -0.031047>, <1.875918, -0.971361, 0.049989>, <1.893108, -1.052130, 0.144710>, <1.875918, -1.088033, 0.225525>, 
      <1.853473, -0.951185, -0.042709>, <1.853473, -0.990538, 0.038327>, <1.870663, -1.071307, 0.133048>, <1.853473, -1.107210, 0.213863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875000, -0.865029, 0.014810>, <1.875000, -0.892150, -0.001682>, <1.875918, -0.932008, -0.031047>, <1.853473, -0.951185, -0.042709>, 
      <1.875000, -0.847784, -0.013548>, <1.875000, -0.874905, -0.030040>, <1.875918, -0.909210, -0.077992>, <1.853473, -0.928387, -0.089654>, 
      <1.846450, -0.817111, -0.065753>, <1.846450, -0.854271, -0.096940>, <1.798287, -0.903025, -0.137759>, <1.810841, -0.915728, -0.182865>, 
      <1.875000, -0.807547, -0.079715>, <1.875000, -0.844707, -0.110902>, <1.840919, -0.888929, -0.164356>, <1.853473, -0.901632, -0.209462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.667518, 0.129793>, <1.853473, -0.714325, 0.206764>, <1.870601, -0.766503, 0.318772>, <1.853473, -0.823543, 0.386364>, 
      <1.891673, -0.716476, 0.100021>, <1.891673, -0.763284, 0.176992>, <1.908801, -0.815462, 0.289000>, <1.891673, -0.872501, 0.356592>, 
      <1.875000, -0.806188, 0.050592>, <1.875000, -0.852996, 0.127564>, <1.893945, -0.919525, 0.230129>, <1.875000, -0.962214, 0.307165>, 
      <1.875000, -0.865029, 0.014810>, <1.875000, -0.911837, 0.091782>, <1.893945, -0.978365, 0.194348>, <1.875000, -1.021054, 0.271383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.853473, -0.667518, 0.129793>, <1.891673, -0.716476, 0.100021>, <1.875000, -0.806188, 0.050592>, <1.875000, -0.865029, 0.014810>, 
      <1.853473, -0.650273, 0.101435>, <1.891673, -0.699232, 0.071663>, <1.875000, -0.788944, 0.022234>, <1.875000, -0.847784, -0.013548>, 
      <1.853473, -0.627280, 0.063624>, <1.837554, -0.694080, 0.068805>, <1.846450, -0.764361, -0.021481>, <1.846450, -0.817111, -0.065753>, 
      <1.853473, -0.610035, 0.035266>, <1.837554, -0.676836, 0.040447>, <1.875000, -0.754797, -0.035444>, <1.875000, -0.807547, -0.079715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.544621, 0.209654>, <1.625000, -0.591429, 0.286626>, <1.625000, -0.634673, 0.404882>, <1.625000, -0.700646, 0.466227>, 
      <1.706418, -0.543810, 0.208320>, <1.706418, -0.590617, 0.285292>, <1.706418, -0.633862, 0.403548>, <1.706418, -0.699835, 0.464893>, 
      <1.808302, -0.609626, 0.164998>, <1.808302, -0.656433, 0.241969>, <1.825430, -0.708611, 0.353978>, <1.808302, -0.765651, 0.421569>, 
      <1.853473, -0.667518, 0.129793>, <1.853473, -0.714325, 0.206764>, <1.870601, -0.766503, 0.318772>, <1.853473, -0.823543, 0.386364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.544621, 0.209654>, <1.543582, -0.545432, 0.210988>, <1.441698, -0.614179, 0.172484>, <1.396527, -0.672071, 0.137279>, 
      <1.625000, -0.591429, 0.286626>, <1.543582, -0.592240, 0.287960>, <1.469491, -0.659129, 0.245440>, <1.424320, -0.717021, 0.210235>, 
      <1.625000, -0.634673, 0.404882>, <1.543582, -0.635484, 0.406216>, <1.424448, -0.713100, 0.361548>, <1.379277, -0.770993, 0.326343>, 
      <1.625000, -0.700646, 0.466227>, <1.543582, -0.701457, 0.467561>, <1.441698, -0.770203, 0.429056>, <1.396527, -0.828095, 0.393851>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, -0.803073, -0.082339>, <1.134641, -0.767367, -0.134736>, <0.954869, -0.745659, -0.155327>, <0.879793, -0.694283, -0.235752>, 
      <1.212951, -0.749948, -0.046541>, <1.109395, -0.714242, -0.098937>, <0.955276, -0.701179, -0.127454>, <0.880200, -0.649803, -0.207879>, 
      <1.275273, -0.673735, 0.039667>, <1.179375, -0.646374, -0.024191>, <0.985329, -0.624419, -0.077595>, <0.913958, -0.588273, -0.164904>, 
      <1.259724, -0.606839, 0.034743>, <1.163826, -0.579477, -0.029115>, <1.002221, -0.575351, -0.085504>, <0.930850, -0.539205, -0.172812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, -0.803073, -0.082339>, <1.283959, -0.818852, -0.059185>, <1.358219, -0.838290, -0.028580>, <1.375000, -0.865029, 0.014810>, 
      <1.212951, -0.749948, -0.046541>, <1.258712, -0.765727, -0.023386>, <1.358219, -0.779450, 0.007202>, <1.375000, -0.806188, 0.050592>, 
      <1.275273, -0.673735, 0.039667>, <1.319729, -0.686419, 0.069270>, <1.341391, -0.693638, 0.063050>, <1.358327, -0.721029, 0.107507>, 
      <1.259724, -0.606839, 0.034743>, <1.304180, -0.619523, 0.064346>, <1.379591, -0.644680, 0.092822>, <1.396527, -0.672071, 0.137279>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, -0.803073, -0.082339>, <1.283959, -0.818852, -0.059185>, <1.358219, -0.838290, -0.028580>, <1.375000, -0.865029, 0.014810>, 
      <1.260025, -0.849004, -0.113290>, <1.305787, -0.864783, -0.090135>, <1.358219, -0.865411, -0.045072>, <1.375000, -0.892150, -0.001683>, 
      <1.391925, -0.870008, -0.105266>, <1.425529, -0.881699, -0.083970>, <1.374082, -0.916018, -0.059580>, <1.374082, -0.936561, -0.023561>, 
      <1.396527, -0.894707, -0.159237>, <1.430131, -0.906397, -0.137941>, <1.396527, -0.935195, -0.071242>, <1.396527, -0.955738, -0.035223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.238197, -0.803073, -0.082339>, <1.260025, -0.849004, -0.113290>, <1.391925, -0.870008, -0.105266>, <1.396527, -0.894707, -0.159237>, 
      <1.134641, -0.767367, -0.134736>, <1.156469, -0.813298, -0.165686>, <1.268158, -0.826951, -0.183701>, <1.272759, -0.851650, -0.237672>, 
      <0.954869, -0.745659, -0.155327>, <0.954530, -0.782787, -0.178593>, <1.020975, -0.845491, -0.202570>, <1.034909, -0.856578, -0.242605>, 
      <0.879793, -0.694283, -0.235752>, <0.879454, -0.731411, -0.259018>, <0.914597, -0.781841, -0.291770>, <0.928530, -0.792928, -0.331805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.021152, -0.209612>, <1.625000, -1.025797, -0.176749>, <1.625000, -1.061389, -0.143443>, <1.625000, -1.078634, -0.115085>, 
      <1.545704, -1.019950, -0.200896>, <1.545704, -1.024595, -0.168033>, <1.543582, -1.062200, -0.142109>, <1.543582, -1.079445, -0.113751>, 
      <1.465069, -0.932641, -0.174349>, <1.498673, -0.944331, -0.153054>, <1.454109, -0.984395, -0.101161>, <1.454109, -1.004937, -0.065141>, 
      <1.396527, -0.894707, -0.159237>, <1.430131, -0.906397, -0.137941>, <1.396527, -0.935195, -0.071242>, <1.396527, -0.955738, -0.035223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.021152, -0.209612>, <1.701882, -1.022317, -0.218062>, <1.784931, -0.937488, -0.209507>, <1.853473, -0.901632, -0.209462>, 
      <1.625000, -1.025797, -0.176749>, <1.701882, -1.026962, -0.185199>, <1.742299, -0.951584, -0.182910>, <1.810841, -0.915728, -0.182865>, 
      <1.625000, -1.061389, -0.143443>, <1.706418, -1.060578, -0.144777>, <1.795891, -0.977586, -0.119573>, <1.853473, -0.928387, -0.089654>, 
      <1.625000, -1.078634, -0.115085>, <1.706418, -1.077823, -0.116419>, <1.795891, -1.000384, -0.072627>, <1.853473, -0.951185, -0.042709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.487139, 0.115129>, <1.625000, -0.506777, 0.141885>, <1.625000, -0.527376, 0.181297>, <1.625000, -0.544621, 0.209654>, 
      <1.706432, -0.487577, 0.115201>, <1.706432, -0.507216, 0.141956>, <1.706418, -0.526565, 0.179963>, <1.706418, -0.543810, 0.208320>, 
      <1.778465, -0.601823, 0.065888>, <1.778465, -0.619068, 0.094246>, <1.808302, -0.592381, 0.136640>, <1.808302, -0.609626, 0.164998>, 
      <1.853473, -0.610035, 0.035266>, <1.853473, -0.627280, 0.063624>, <1.853473, -0.650273, 0.101435>, <1.853473, -0.667518, 0.129793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.487139, 0.115129>, <1.507191, -0.486505, 0.115025>, <1.369307, -0.570929, 0.058859>, <1.259724, -0.606839, 0.034743>, 
      <1.625000, -0.506777, 0.141885>, <1.507191, -0.506143, 0.141781>, <1.413763, -0.583613, 0.088462>, <1.304180, -0.619523, 0.064346>, 
      <1.625000, -0.527376, 0.181297>, <1.543582, -0.528188, 0.182630>, <1.424762, -0.586787, 0.128027>, <1.379591, -0.644680, 0.092822>, 
      <1.625000, -0.544621, 0.209654>, <1.543582, -0.545432, 0.210988>, <1.441698, -0.614179, 0.172484>, <1.396527, -0.672071, 0.137279>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.032635, -1.009545>, <2.027613, -0.062563, -0.982233>, <2.067544, -0.162733, -0.991514>, <2.063486, -0.226292, -0.991097>, 
      <1.973909, -0.002718, -1.103875>, <2.023049, -0.032646, -1.076563>, <2.071571, -0.119910, -1.094674>, <2.067513, -0.183469, -1.094257>, 
      <1.947408, 0.005766, -1.236124>, <1.996532, 0.006552, -1.236124>, <2.055982, -0.056955, -1.224234>, <2.075157, -0.102186, -1.224774>, 
      <1.943182, 0.010990, -1.334962>, <1.992307, 0.011776, -1.334962>, <2.057734, -0.038316, -1.334423>, <2.076910, -0.083547, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.032635, -1.000783>, <1.275622, -0.001704, -1.097408>, <1.298963, 0.005691, -1.233634>, <1.302756, 0.010990, -1.334962>, 
      <1.222775, -0.062350, -0.972295>, <1.226870, -0.031419, -1.068920>, <1.249838, 0.006469, -1.233634>, <1.253631, 0.011768, -1.334962>, 
      <1.184216, -0.162542, -0.977174>, <1.179009, -0.119719, -1.084032>, <1.190891, -0.057437, -1.220241>, <1.188587, -0.038490, -1.333886>, 
      <1.186386, -0.226292, -0.978770>, <1.181179, -0.183469, -1.085628>, <1.171332, -0.102494, -1.221318>, <1.169028, -0.083547, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.079968, -0.311660, -1.338817>, <2.071269, -0.300873, -1.232186>, <2.077083, -0.208235, -1.096222>, <2.063486, -0.226292, -0.991097>, 
      <2.079968, -0.380110, -1.338817>, <2.071269, -0.369323, -1.232186>, <2.069047, -0.334103, -1.095396>, <2.055451, -0.352159, -0.990271>, 
      <2.103626, -0.476757, -1.335715>, <2.085837, -0.488265, -1.227599>, <2.068789, -0.521756, -1.060837>, <2.027854, -0.548238, -0.962039>, 
      <2.076910, -0.539774, -1.334962>, <2.059122, -0.551282, -1.226846>, <1.981396, -0.601565, -1.104435>, <1.940461, -0.628047, -1.005637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.079968, -0.311660, -1.338817>, <2.079968, -0.243210, -1.338817>, <2.103626, -0.146564, -1.335716>, <2.076910, -0.083547, -1.334963>, 
      <2.079968, -0.311660, -1.338817>, <2.071269, -0.232423, -1.232186>, <2.101873, -0.165203, -1.225527>, <2.075157, -0.102186, -1.224774>, 
      <2.079968, -0.311660, -1.338817>, <2.071269, -0.232423, -1.232186>, <2.081110, -0.165412, -1.199382>, <2.067513, -0.183469, -1.094257>, 
      <2.079968, -0.311660, -1.338817>, <2.071269, -0.300873, -1.232186>, <2.077083, -0.208235, -1.096222>, <2.063486, -0.226292, -0.991097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.162696, -0.311661, -1.342671>, <1.168719, -0.300628, -1.231017>, <1.170990, -0.207564, -1.088483>, <1.186386, -0.226292, -0.978770>, 
      <1.162696, -0.380160, -1.342671>, <1.168719, -0.369127, -1.231017>, <1.175658, -0.344708, -1.091915>, <1.191054, -0.363436, -0.982202>, 
      <1.141759, -0.476955, -1.336463>, <1.158010, -0.493942, -1.229381>, <1.161531, -0.544343, -1.062400>, <1.198785, -0.583286, -0.966928>, 
      <1.169028, -0.539774, -1.334962>, <1.185279, -0.556762, -1.227881>, <1.255953, -0.630639, -1.112196>, <1.293207, -0.669581, -1.016725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.162696, -0.311661, -1.342671>, <1.162696, -0.243161, -1.342671>, <1.141759, -0.146367, -1.336464>, <1.169028, -0.083547, -1.334963>, 
      <1.162696, -0.311661, -1.342671>, <1.168719, -0.232128, -1.231017>, <1.144063, -0.165314, -1.222819>, <1.171332, -0.102494, -1.221318>, 
      <1.162696, -0.311661, -1.342671>, <1.168719, -0.232128, -1.231017>, <1.165783, -0.164741, -1.195340>, <1.181179, -0.183469, -1.085628>, 
      <1.162696, -0.311661, -1.342671>, <1.168719, -0.300628, -1.231017>, <1.170990, -0.207564, -1.088483>, <1.186386, -0.226292, -0.978770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.634312, -1.334963>, <1.992307, -0.635098, -1.334963>, <2.057734, -0.585005, -1.334422>, <2.076910, -0.539774, -1.334962>, 
      <1.943182, -0.634312, -1.334963>, <1.991982, -0.634351, -1.236147>, <2.039946, -0.596513, -1.226306>, <2.059122, -0.551282, -1.226846>, 
      <1.943182, -0.634312, -1.334963>, <1.991982, -0.634351, -1.236147>, <1.973956, -0.597896, -1.202905>, <1.981396, -0.601565, -1.104435>, 
      <1.943182, -0.634312, -1.334963>, <1.942858, -0.633566, -1.236147>, <1.933021, -0.624378, -1.104107>, <1.940461, -0.628047, -1.005637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.634312, -1.334963>, <1.301636, -0.638450, -1.238960>, <1.299529, -0.664623, -1.112487>, <1.293207, -0.669581, -1.016725>, 
      <1.302756, -0.634312, -1.334963>, <1.252511, -0.639228, -1.238960>, <1.262275, -0.625681, -1.207958>, <1.255953, -0.630639, -1.112196>, 
      <1.302756, -0.634312, -1.334963>, <1.252511, -0.639228, -1.238960>, <1.204838, -0.601819, -1.226804>, <1.185279, -0.556762, -1.227881>, 
      <1.302756, -0.634312, -1.334963>, <1.253631, -0.635090, -1.334963>, <1.188587, -0.584831, -1.333886>, <1.169028, -0.539774, -1.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, -0.626941, -1.209963>, <1.509183, -0.634358, -1.211943>, <1.372888, -0.742404, -1.058747>, <1.293207, -0.669581, -1.016725>, 
      <1.592922, -0.599131, -1.247463>, <1.477341, -0.606548, -1.249443>, <1.379210, -0.737446, -1.154509>, <1.299529, -0.664623, -1.112487>, 
      <1.530545, -0.541870, -1.280252>, <1.484101, -0.588407, -1.252457>, <1.373008, -0.637320, -1.238960>, <1.301636, -0.638450, -1.238960>, 
      <1.518625, -0.534240, -1.334962>, <1.472181, -0.580777, -1.307167>, <1.374128, -0.633182, -1.334963>, <1.302756, -0.634312, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.730904, -0.534240, -1.334962>, <1.776416, -0.580357, -1.307417>, <1.872786, -0.633186, -1.334963>, <1.943182, -0.634312, -1.334963>, 
      <1.719036, -0.541872, -1.280240>, <1.764549, -0.587989, -1.252696>, <1.872462, -0.632440, -1.236147>, <1.942858, -0.633566, -1.236147>, 
      <1.635882, -0.599234, -1.257945>, <1.748449, -0.592010, -1.256016>, <1.854851, -0.695765, -1.143104>, <1.933021, -0.624378, -1.104107>, 
      <1.624764, -0.626941, -1.209963>, <1.737332, -0.619718, -1.208035>, <1.862291, -0.699433, -1.044634>, <1.940461, -0.628047, -1.005637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, 0.040906, -1.234937>, <1.592922, 0.001910, -1.264945>, <1.531339, -0.077463, -1.278941>, <1.518625, -0.089082, -1.334963>, 
      <1.495735, 0.040906, -1.233338>, <1.463893, 0.001910, -1.263346>, <1.484895, -0.030926, -1.251146>, <1.472181, -0.042546, -1.307168>, 
      <1.370120, 0.027459, -1.058396>, <1.374215, 0.058390, -1.155021>, <1.370335, 0.004561, -1.233634>, <1.374128, 0.009860, -1.334962>, 
      <1.271527, -0.032635, -1.000783>, <1.275622, -0.001704, -1.097408>, <1.298963, 0.005691, -1.233634>, <1.302756, 0.010990, -1.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.730904, -0.089082, -1.334963>, <1.718246, -0.077460, -1.278929>, <1.632369, 0.041507, -1.293048>, <1.624764, 0.040906, -1.234937>, 
      <1.776416, -0.042965, -1.307418>, <1.763758, -0.031343, -1.251384>, <1.760104, 0.041507, -1.294631>, <1.752499, 0.040906, -1.236520>, 
      <1.872786, 0.009864, -1.334962>, <1.877012, 0.004640, -1.236124>, <1.875347, 0.057310, -1.158656>, <1.879911, 0.027393, -1.064326>, 
      <1.943182, 0.010990, -1.334962>, <1.947408, 0.005766, -1.236124>, <1.973909, -0.002718, -1.103875>, <1.978473, -0.032635, -1.009545>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.519784, -0.243920, -3.459963>, <1.519784, -0.243920, -3.422463>, <1.528153, -0.237422, -3.370935>, <1.519784, -0.243920, -3.334963>, 
      <1.519784, -0.201089, -3.459963>, <1.519784, -0.201089, -3.422463>, <1.528153, -0.194591, -3.370935>, <1.519784, -0.201089, -3.334963>, 
      <1.487701, -0.145107, -3.459962>, <1.487701, -0.145107, -3.422462>, <1.493361, -0.131313, -3.369370>, <1.487701, -0.145107, -3.334962>, 
      <1.456194, -0.116093, -3.459962>, <1.456194, -0.116093, -3.422462>, <1.461853, -0.102299, -3.369370>, <1.456194, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.456194, -0.686259, -3.459962>, <1.456194, -0.686259, -3.422462>, <1.461473, -0.704924, -3.367057>, <1.456194, -0.686260, -3.334963>, 
      <1.500131, -0.559597, -3.459962>, <1.500131, -0.559597, -3.422462>, <1.505410, -0.578262, -3.367057>, <1.500131, -0.559598, -3.334963>, 
      <1.519784, -0.377986, -3.459963>, <1.519784, -0.377986, -3.422463>, <1.528153, -0.371488, -3.370936>, <1.519784, -0.377986, -3.334963>, 
      <1.519784, -0.243920, -3.459963>, <1.519784, -0.243920, -3.422463>, <1.528153, -0.237422, -3.370935>, <1.519784, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.869577, -3.459963>, <1.302756, -0.869577, -3.422463>, <1.302756, -0.894623, -3.362873>, <1.302756, -0.869577, -3.334963>, 
      <1.374473, -0.869577, -3.459963>, <1.374473, -0.869577, -3.422463>, <1.374473, -0.894623, -3.362873>, <1.374473, -0.869577, -3.334963>, 
      <1.432691, -0.754016, -3.459962>, <1.432691, -0.754016, -3.422462>, <1.437969, -0.772680, -3.367057>, <1.432691, -0.754016, -3.334963>, 
      <1.456194, -0.686259, -3.459962>, <1.456194, -0.686259, -3.422462>, <1.461473, -0.704924, -3.367057>, <1.456194, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149318, -0.686259, -3.459962>, <1.149318, -0.686259, -3.422462>, <1.144039, -0.704924, -3.367057>, <1.149318, -0.686260, -3.334963>, 
      <1.172821, -0.754016, -3.459962>, <1.172821, -0.754016, -3.422462>, <1.167542, -0.772680, -3.367057>, <1.172821, -0.754016, -3.334963>, 
      <1.231039, -0.869577, -3.459963>, <1.231039, -0.869577, -3.422463>, <1.231039, -0.894623, -3.362873>, <1.231039, -0.869577, -3.334963>, 
      <1.302756, -0.869577, -3.459963>, <1.302756, -0.869577, -3.422463>, <1.302756, -0.894623, -3.362873>, <1.302756, -0.869577, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.085728, -0.243920, -3.459963>, <1.085728, -0.243920, -3.422463>, <1.077359, -0.237422, -3.370935>, <1.085728, -0.243920, -3.334963>, 
      <1.085728, -0.377986, -3.459963>, <1.085728, -0.377986, -3.422463>, <1.077359, -0.371488, -3.370936>, <1.085728, -0.377986, -3.334963>, 
      <1.105382, -0.559597, -3.459962>, <1.105382, -0.559597, -3.422462>, <1.100102, -0.578262, -3.367057>, <1.105381, -0.559598, -3.334963>, 
      <1.149318, -0.686259, -3.459962>, <1.149318, -0.686259, -3.422462>, <1.144039, -0.704924, -3.367057>, <1.149318, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.149318, -0.116093, -3.459962>, <1.149318, -0.116093, -3.422462>, <1.143658, -0.102299, -3.369370>, <1.149318, -0.116093, -3.334962>, 
      <1.117811, -0.145107, -3.459962>, <1.117811, -0.145107, -3.422462>, <1.112151, -0.131313, -3.369370>, <1.117811, -0.145107, -3.334962>, 
      <1.085728, -0.201089, -3.459963>, <1.085728, -0.201089, -3.422463>, <1.077359, -0.194591, -3.370935>, <1.085728, -0.201089, -3.334963>, 
      <1.085728, -0.243920, -3.459963>, <1.085728, -0.243920, -3.422463>, <1.077359, -0.237422, -3.370935>, <1.085728, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.044064, -3.459962>, <1.302756, -0.044064, -3.422462>, <1.302756, -0.029543, -3.369536>, <1.302756, -0.044064, -3.334962>, 
      <1.251905, -0.044064, -3.459962>, <1.251905, -0.044064, -3.422462>, <1.251905, -0.029543, -3.369536>, <1.251905, -0.044064, -3.334962>, 
      <1.186724, -0.081646, -3.459962>, <1.186724, -0.081646, -3.422462>, <1.181065, -0.067852, -3.369370>, <1.186724, -0.081646, -3.334962>, 
      <1.149318, -0.116093, -3.459962>, <1.149318, -0.116093, -3.422462>, <1.143658, -0.102299, -3.369370>, <1.149318, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.044064, -3.459962>, <1.353607, -0.044064, -3.459962>, <1.418788, -0.081646, -3.459962>, <1.456194, -0.116093, -3.459962>, 
      <1.302756, -0.044064, -3.422462>, <1.353607, -0.044064, -3.422462>, <1.418788, -0.081646, -3.422462>, <1.456194, -0.116093, -3.422462>, 
      <1.302756, -0.029543, -3.369536>, <1.353607, -0.029543, -3.369536>, <1.424447, -0.067852, -3.369370>, <1.461853, -0.102299, -3.369370>, 
      <1.302756, -0.044064, -3.334962>, <1.353607, -0.044064, -3.334962>, <1.418788, -0.081646, -3.334962>, <1.456194, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.634311, -1.834962>, <1.302756, -0.634311, -1.684962>, <1.304505, -0.627853, -1.484813>, <1.302756, -0.634312, -1.334963>, 
      <1.365306, -0.634311, -1.834962>, <1.365306, -0.634311, -1.684962>, <1.375877, -0.626723, -1.484813>, <1.374128, -0.633182, -1.334963>, 
      <1.450275, -0.589215, -1.834963>, <1.464320, -0.588269, -1.685344>, <1.440482, -0.560486, -1.452657>, <1.472181, -0.580777, -1.307167>, 
      <1.488591, -0.539775, -1.834963>, <1.502636, -0.538829, -1.685344>, <1.486926, -0.513949, -1.480452>, <1.518625, -0.534240, -1.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, -0.539775, -1.834963>, <1.169028, -0.539775, -1.684963>, <1.146793, -0.516531, -1.481473>, <1.169028, -0.539774, -1.334962>, 
      <1.191173, -0.583619, -1.833916>, <1.191173, -0.583619, -1.683915>, <1.166352, -0.561589, -1.480396>, <1.188587, -0.584831, -1.333886>, 
      <1.253625, -0.634311, -1.834962>, <1.253625, -0.634311, -1.684962>, <1.255380, -0.628630, -1.484813>, <1.253631, -0.635090, -1.334963>, 
      <1.302756, -0.634311, -1.834962>, <1.302756, -0.634311, -1.684962>, <1.304505, -0.627853, -1.484813>, <1.302756, -0.634312, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.139788, -0.311660, -1.842670>, <1.148274, -0.311660, -1.692753>, <1.154648, -0.326406, -1.491885>, <1.162696, -0.311661, -1.342671>, 
      <1.139788, -0.380693, -1.842670>, <1.148274, -0.380693, -1.692753>, <1.154648, -0.394905, -1.491885>, <1.162696, -0.380160, -1.342671>, 
      <1.137912, -0.478170, -1.836435>, <1.137912, -0.478170, -1.686434>, <1.119524, -0.453712, -1.482974>, <1.141759, -0.476955, -1.336463>, 
      <1.169028, -0.539775, -1.834963>, <1.169028, -0.539775, -1.684963>, <1.146793, -0.516531, -1.481473>, <1.169028, -0.539774, -1.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, -0.083546, -1.834962>, <1.169028, -0.064620, -1.686161>, <1.166029, -0.058884, -1.482891>, <1.169028, -0.083547, -1.334963>, 
      <1.137912, -0.145151, -1.836434>, <1.137912, -0.126225, -1.687633>, <1.138760, -0.121704, -1.484392>, <1.141759, -0.146367, -1.336464>, 
      <1.139788, -0.242627, -1.842670>, <1.148274, -0.242627, -1.692753>, <1.154648, -0.257906, -1.491886>, <1.162696, -0.243161, -1.342671>, 
      <1.139788, -0.311660, -1.842670>, <1.148274, -0.311660, -1.692753>, <1.154648, -0.326406, -1.491885>, <1.162696, -0.311661, -1.342671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.010990, -1.834963>, <1.302756, 0.029916, -1.686161>, <1.308360, 0.018818, -1.484653>, <1.302756, 0.010990, -1.334962>, 
      <1.253625, 0.010990, -1.834963>, <1.253625, 0.029916, -1.686161>, <1.259235, 0.019596, -1.484653>, <1.253631, 0.011768, -1.334962>, 
      <1.191173, -0.039702, -1.833915>, <1.191173, -0.020776, -1.685114>, <1.185588, -0.013827, -1.481814>, <1.188587, -0.038490, -1.333886>, 
      <1.169028, -0.083546, -1.834962>, <1.169028, -0.064620, -1.686161>, <1.166029, -0.058884, -1.482891>, <1.169028, -0.083547, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, 0.010990, -1.834963>, <1.302756, 0.029916, -1.686161>, <1.308360, 0.018818, -1.484653>, <1.302756, 0.010990, -1.334962>, 
      <1.365306, 0.010990, -1.834963>, <1.365306, 0.029916, -1.686161>, <1.379732, 0.017688, -1.484653>, <1.374128, 0.009860, -1.334962>, 
      <1.450275, -0.034106, -1.834962>, <1.464220, -0.016152, -1.686412>, <1.439582, -0.072339, -1.450811>, <1.472181, -0.042546, -1.307168>, 
      <1.488591, -0.083546, -1.834962>, <1.502536, -0.065592, -1.686412>, <1.486026, -0.118875, -1.478607>, <1.518625, -0.089082, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, -0.311661, -1.527674>, <1.530084, -0.311661, -1.527674>, <1.570906, -0.311661, -1.742028>, <1.552809, -0.311661, -1.834963>, 
      <1.624764, -0.217773, -1.527674>, <1.530084, -0.217773, -1.527674>, <1.570906, -0.240566, -1.742028>, <1.552809, -0.240566, -1.834963>, 
      <1.579713, -0.150292, -1.371522>, <1.547114, -0.180085, -1.515166>, <1.546086, -0.121786, -1.686412>, <1.532141, -0.139740, -1.834962>, 
      <1.518625, -0.089082, -1.334963>, <1.486026, -0.118875, -1.478607>, <1.502536, -0.065592, -1.686412>, <1.488591, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, -0.311661, -1.527674>, <1.624764, -0.217773, -1.527674>, <1.579713, -0.150292, -1.371522>, <1.518625, -0.089082, -1.334963>, 
      <1.624764, -0.217773, -1.527674>, <1.624764, -0.123884, -1.527674>, <1.592427, -0.138673, -1.315501>, <1.531339, -0.077463, -1.278941>, 
      <1.670211, -0.150581, -1.371695>, <1.657553, -0.138959, -1.315661>, <1.600527, 0.002511, -1.323056>, <1.592922, 0.001910, -1.264945>, 
      <1.730904, -0.089082, -1.334963>, <1.718246, -0.077460, -1.278929>, <1.632369, 0.041507, -1.293048>, <1.624764, 0.040906, -1.234937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, -0.311661, -1.527674>, <1.530084, -0.311661, -1.527674>, <1.570906, -0.311661, -1.742028>, <1.552809, -0.311661, -1.834963>, 
      <1.624764, -0.405549, -1.527674>, <1.530084, -0.405549, -1.527674>, <1.570906, -0.382755, -1.742028>, <1.552809, -0.382755, -1.834963>, 
      <1.579713, -0.473030, -1.371521>, <1.548014, -0.452739, -1.517012>, <1.546187, -0.482635, -1.685344>, <1.532141, -0.483581, -1.834963>, 
      <1.518625, -0.534240, -1.334962>, <1.486926, -0.513949, -1.480452>, <1.502636, -0.538829, -1.685344>, <1.488591, -0.539775, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.624764, -0.311661, -1.527674>, <1.624764, -0.405550, -1.527674>, <1.670211, -0.472741, -1.371694>, <1.730904, -0.534240, -1.334962>, 
      <1.624764, -0.405549, -1.527674>, <1.624764, -0.499438, -1.527673>, <1.658344, -0.480372, -1.316972>, <1.719036, -0.541872, -1.280240>, 
      <1.579713, -0.473030, -1.371521>, <1.591633, -0.480660, -1.316811>, <1.604040, -0.571423, -1.295444>, <1.635882, -0.599234, -1.257945>, 
      <1.518625, -0.534240, -1.334962>, <1.530545, -0.541870, -1.280252>, <1.592922, -0.599131, -1.247463>, <1.624764, -0.626941, -1.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.491906, -0.311661, -2.209964>, <1.506925, -0.311661, -2.096984>, <1.531025, -0.311661, -1.946836>, <1.552809, -0.311661, -1.834963>, 
      <1.491906, -0.272870, -2.209964>, <1.506925, -0.272870, -2.096984>, <1.531025, -0.240566, -1.946836>, <1.552809, -0.240566, -1.834963>, 
      <1.462354, -0.223742, -2.209962>, <1.475192, -0.196710, -2.095421>, <1.521156, -0.153884, -1.951986>, <1.532141, -0.139740, -1.834962>, 
      <1.436485, -0.194836, -2.209962>, <1.449323, -0.167804, -2.095420>, <1.477605, -0.097690, -1.951986>, <1.488591, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.436485, -0.539774, -2.209963>, <1.449135, -0.541289, -2.097099>, <1.477976, -0.540490, -1.948044>, <1.488591, -0.539775, -1.834963>, 
      <1.472102, -0.479020, -2.209963>, <1.484751, -0.480535, -2.097099>, <1.521526, -0.484296, -1.948045>, <1.532141, -0.483581, -1.834963>, 
      <1.491906, -0.382086, -2.209964>, <1.506925, -0.382086, -2.096984>, <1.531025, -0.382755, -1.946836>, <1.552809, -0.382755, -1.834963>, 
      <1.491906, -0.311661, -2.209964>, <1.506925, -0.311661, -2.096984>, <1.531025, -0.311661, -1.946836>, <1.552809, -0.311661, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.634312, -2.209963>, <1.302756, -0.636448, -2.097483>, <1.302756, -0.634311, -1.947462>, <1.302756, -0.634311, -1.834962>, 
      <1.351887, -0.634312, -2.209963>, <1.351887, -0.636448, -2.097483>, <1.365306, -0.634311, -1.947462>, <1.365306, -0.634311, -1.834962>, 
      <1.411637, -0.582159, -2.209963>, <1.424287, -0.583674, -2.097099>, <1.439660, -0.589930, -1.948044>, <1.450275, -0.589215, -1.834963>, 
      <1.436485, -0.539774, -2.209963>, <1.449135, -0.541289, -2.097099>, <1.477976, -0.540490, -1.948044>, <1.488591, -0.539775, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, -0.539774, -2.209963>, <1.168143, -0.541284, -2.097477>, <1.169028, -0.539775, -1.947463>, <1.169028, -0.539775, -1.834963>, 
      <1.193876, -0.582159, -2.209963>, <1.192991, -0.583669, -2.097476>, <1.191173, -0.583619, -1.946416>, <1.191173, -0.583619, -1.833916>, 
      <1.253625, -0.634312, -2.209963>, <1.253625, -0.636448, -2.097483>, <1.253625, -0.634311, -1.947462>, <1.253625, -0.634311, -1.834962>, 
      <1.302756, -0.634312, -2.209963>, <1.302756, -0.636448, -2.097483>, <1.302756, -0.634311, -1.947462>, <1.302756, -0.634311, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.113606, -0.311661, -2.209964>, <1.118228, -0.311661, -2.099593>, <1.133545, -0.311660, -1.952961>, <1.139788, -0.311660, -1.842670>, 
      <1.113606, -0.382086, -2.209964>, <1.118228, -0.382086, -2.099593>, <1.133545, -0.380693, -1.952961>, <1.139788, -0.380693, -1.842670>, 
      <1.133412, -0.479019, -2.209963>, <1.132527, -0.480530, -2.097477>, <1.137912, -0.478170, -1.948935>, <1.137912, -0.478170, -1.836435>, 
      <1.169028, -0.539774, -2.209963>, <1.168143, -0.541284, -2.097477>, <1.169028, -0.539775, -1.947463>, <1.169028, -0.539775, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.169028, -0.194836, -2.209962>, <1.168129, -0.167882, -2.095753>, <1.169028, -0.098352, -1.951374>, <1.169028, -0.083546, -1.834962>, 
      <1.143159, -0.223743, -2.209962>, <1.142261, -0.196789, -2.095753>, <1.137912, -0.159957, -1.952845>, <1.137912, -0.145151, -1.836434>, 
      <1.113606, -0.272870, -2.209964>, <1.118228, -0.272869, -2.099593>, <1.133545, -0.242627, -1.952961>, <1.139788, -0.242627, -1.842670>, 
      <1.113606, -0.311661, -2.209964>, <1.118228, -0.311661, -2.099593>, <1.133545, -0.311660, -1.952961>, <1.139788, -0.311660, -1.842670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.100299, -2.209963>, <1.302756, -0.072744, -2.095895>, <1.302756, -0.003816, -1.951375>, <1.302756, 0.010990, -1.834963>, 
      <1.253625, -0.100299, -2.209963>, <1.253625, -0.072744, -2.095895>, <1.253625, -0.003816, -1.951375>, <1.253625, 0.010990, -1.834963>, 
      <1.201792, -0.158225, -2.209962>, <1.200893, -0.131271, -2.095753>, <1.191173, -0.054508, -1.950327>, <1.191173, -0.039702, -1.833915>, 
      <1.169028, -0.194836, -2.209962>, <1.168129, -0.167882, -2.095753>, <1.169028, -0.098352, -1.951374>, <1.169028, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.100299, -2.209963>, <1.351887, -0.100299, -2.209963>, <1.403721, -0.158225, -2.209962>, <1.436485, -0.194836, -2.209962>, 
      <1.302756, -0.072744, -2.095895>, <1.351887, -0.072744, -2.095895>, <1.416559, -0.131193, -2.095420>, <1.449323, -0.167804, -2.095420>, 
      <1.302756, -0.003816, -1.951375>, <1.365306, -0.003816, -1.951375>, <1.439290, -0.048250, -1.951986>, <1.477605, -0.097690, -1.951986>, 
      <1.302756, 0.010990, -1.834963>, <1.365306, 0.010990, -1.834963>, <1.450275, -0.034106, -1.834962>, <1.488591, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486341, -0.311661, -2.334962>, <1.487176, -0.311661, -2.297435>, <1.486960, -0.311661, -2.247173>, <1.491906, -0.311661, -2.209964>, 
      <1.486341, -0.274896, -2.334962>, <1.487176, -0.274896, -2.297435>, <1.486960, -0.272870, -2.247173>, <1.491906, -0.272870, -2.209964>, 
      <1.457287, -0.228746, -2.334962>, <1.457878, -0.227738, -2.297407>, <1.458279, -0.232322, -2.246315>, <1.462354, -0.223742, -2.209962>, 
      <1.432551, -0.201547, -2.334962>, <1.433142, -0.200539, -2.297408>, <1.432411, -0.203415, -2.246314>, <1.436485, -0.194836, -2.209962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432551, -0.533063, -2.334963>, <1.433142, -0.534071, -2.297409>, <1.432300, -0.539273, -2.247298>, <1.436485, -0.539774, -2.209963>, 
      <1.467120, -0.474096, -2.334963>, <1.467711, -0.475104, -2.297409>, <1.467917, -0.478518, -2.247299>, <1.472102, -0.479020, -2.209963>, 
      <1.486341, -0.380014, -2.334962>, <1.487176, -0.380014, -2.297435>, <1.486960, -0.382086, -2.247174>, <1.491906, -0.382086, -2.209964>, 
      <1.486341, -0.311661, -2.334962>, <1.487176, -0.311661, -2.297435>, <1.486960, -0.311661, -2.247173>, <1.491906, -0.311661, -2.209964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.624818, -2.334962>, <1.302756, -0.626245, -2.297381>, <1.302756, -0.633598, -2.247564>, <1.302756, -0.634312, -2.209963>, 
      <1.350442, -0.624818, -2.334962>, <1.350442, -0.626245, -2.297381>, <1.351887, -0.633598, -2.247564>, <1.351887, -0.634312, -2.209963>, 
      <1.408435, -0.574201, -2.334963>, <1.409025, -0.575209, -2.297409>, <1.407453, -0.581658, -2.247298>, <1.411637, -0.582159, -2.209963>, 
      <1.432551, -0.533063, -2.334963>, <1.433142, -0.534071, -2.297409>, <1.432300, -0.539273, -2.247298>, <1.436485, -0.539774, -2.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, -0.533063, -2.334963>, <1.172371, -0.534071, -2.297409>, <1.169324, -0.539270, -2.247531>, <1.169028, -0.539774, -2.209963>, 
      <1.197078, -0.574201, -2.334963>, <1.196487, -0.575209, -2.297409>, <1.194171, -0.581654, -2.247531>, <1.193876, -0.582159, -2.209963>, 
      <1.255071, -0.624818, -2.334962>, <1.255071, -0.626245, -2.297381>, <1.253625, -0.633598, -2.247564>, <1.253625, -0.634312, -2.209963>, 
      <1.302756, -0.624818, -2.334962>, <1.302756, -0.626245, -2.297381>, <1.302756, -0.633598, -2.247564>, <1.302756, -0.634312, -2.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.119171, -0.311661, -2.334962>, <1.118336, -0.311661, -2.297435>, <1.112035, -0.311661, -2.247468>, <1.113606, -0.311661, -2.209964>, 
      <1.119171, -0.380014, -2.334962>, <1.118336, -0.380014, -2.297435>, <1.112035, -0.382086, -2.247468>, <1.113606, -0.382086, -2.209964>, 
      <1.138393, -0.474096, -2.334963>, <1.137802, -0.475104, -2.297409>, <1.133707, -0.478515, -2.247531>, <1.133412, -0.479019, -2.209963>, 
      <1.172962, -0.533063, -2.334963>, <1.172371, -0.534071, -2.297409>, <1.169324, -0.539270, -2.247531>, <1.169028, -0.539774, -2.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, -0.201547, -2.334962>, <1.172371, -0.200539, -2.297408>, <1.169316, -0.203466, -2.246529>, <1.169028, -0.194836, -2.209962>, 
      <1.148226, -0.228746, -2.334962>, <1.147635, -0.227738, -2.297407>, <1.143447, -0.232372, -2.246529>, <1.143159, -0.223743, -2.209962>, 
      <1.119171, -0.274896, -2.334962>, <1.118336, -0.274896, -2.297435>, <1.112035, -0.272870, -2.247468>, <1.113606, -0.272870, -2.209964>, 
      <1.119171, -0.311661, -2.334962>, <1.118336, -0.311661, -2.297435>, <1.112035, -0.311661, -2.247468>, <1.113606, -0.311661, -2.209964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.109793, -2.334963>, <1.302756, -0.108366, -2.297382>, <1.302756, -0.109130, -2.246520>, <1.302756, -0.100299, -2.209963>, 
      <1.255071, -0.109793, -2.334963>, <1.255071, -0.108366, -2.297382>, <1.253625, -0.109130, -2.246520>, <1.253625, -0.100299, -2.209963>, 
      <1.205045, -0.166269, -2.334962>, <1.204454, -0.165261, -2.297408>, <1.202079, -0.166855, -2.246529>, <1.201792, -0.158225, -2.209962>, 
      <1.172962, -0.201547, -2.334962>, <1.172371, -0.200539, -2.297408>, <1.169316, -0.203466, -2.246529>, <1.169028, -0.194836, -2.209962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.109793, -2.334963>, <1.350441, -0.109793, -2.334963>, <1.400468, -0.166269, -2.334962>, <1.432551, -0.201547, -2.334962>, 
      <1.302756, -0.108366, -2.297382>, <1.350441, -0.108366, -2.297382>, <1.401059, -0.165261, -2.297408>, <1.433142, -0.200539, -2.297408>, 
      <1.302756, -0.109130, -2.246520>, <1.351887, -0.109130, -2.246520>, <1.399647, -0.166804, -2.246314>, <1.432411, -0.203415, -2.246314>, 
      <1.302756, -0.100299, -2.209963>, <1.351887, -0.100299, -2.209963>, <1.403721, -0.158225, -2.209962>, <1.436485, -0.194836, -2.209962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.486341, -0.311660, -2.459963>, <1.490353, -0.311660, -2.422678>, <1.485506, -0.311661, -2.372453>, <1.486341, -0.311661, -2.334962>, 
      <1.486341, -0.274895, -2.459963>, <1.490353, -0.274895, -2.422678>, <1.485506, -0.274896, -2.372453>, <1.486341, -0.274896, -2.334962>, 
      <1.457287, -0.228746, -2.459963>, <1.460108, -0.223934, -2.422880>, <1.456697, -0.229752, -2.372444>, <1.457287, -0.228746, -2.334962>, 
      <1.432551, -0.201547, -2.459963>, <1.435372, -0.196735, -2.422880>, <1.431961, -0.202553, -2.372444>, <1.432551, -0.201547, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432551, -0.533063, -2.459963>, <1.435372, -0.537875, -2.422880>, <1.431961, -0.532057, -2.372445>, <1.432551, -0.533063, -2.334963>, 
      <1.467120, -0.474096, -2.459963>, <1.469941, -0.478908, -2.422880>, <1.466530, -0.473090, -2.372445>, <1.467120, -0.474096, -2.334963>, 
      <1.486341, -0.380013, -2.459963>, <1.490353, -0.380013, -2.422678>, <1.485506, -0.380014, -2.372453>, <1.486341, -0.380014, -2.334962>, 
      <1.486341, -0.311660, -2.459963>, <1.490353, -0.311660, -2.422678>, <1.485506, -0.311661, -2.372453>, <1.486341, -0.311661, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.624818, -2.459963>, <1.302756, -0.631588, -2.423079>, <1.302756, -0.623395, -2.372435>, <1.302756, -0.624818, -2.334962>, 
      <1.350442, -0.624818, -2.459963>, <1.350442, -0.631588, -2.423079>, <1.350442, -0.623395, -2.372435>, <1.350442, -0.624818, -2.334962>, 
      <1.408435, -0.574201, -2.459963>, <1.411256, -0.579013, -2.422880>, <1.407845, -0.573195, -2.372445>, <1.408435, -0.574201, -2.334963>, 
      <1.432551, -0.533063, -2.459963>, <1.435372, -0.537875, -2.422880>, <1.431961, -0.532057, -2.372445>, <1.432551, -0.533063, -2.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, -0.533063, -2.459963>, <1.170141, -0.537875, -2.422880>, <1.173552, -0.532057, -2.372445>, <1.172962, -0.533063, -2.334963>, 
      <1.197078, -0.574201, -2.459963>, <1.194257, -0.579013, -2.422880>, <1.197668, -0.573194, -2.372445>, <1.197078, -0.574201, -2.334963>, 
      <1.255071, -0.624818, -2.459963>, <1.255071, -0.631588, -2.423079>, <1.255071, -0.623395, -2.372435>, <1.255071, -0.624818, -2.334962>, 
      <1.302756, -0.624818, -2.459963>, <1.302756, -0.631588, -2.423079>, <1.302756, -0.623395, -2.372435>, <1.302756, -0.624818, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.119171, -0.311660, -2.459963>, <1.115159, -0.311660, -2.422678>, <1.120006, -0.311661, -2.372453>, <1.119171, -0.311661, -2.334962>, 
      <1.119171, -0.380013, -2.459963>, <1.115159, -0.380013, -2.422678>, <1.120006, -0.380014, -2.372453>, <1.119171, -0.380014, -2.334962>, 
      <1.138393, -0.474096, -2.459963>, <1.135572, -0.478908, -2.422880>, <1.138983, -0.473090, -2.372445>, <1.138393, -0.474096, -2.334963>, 
      <1.172962, -0.533063, -2.459963>, <1.170141, -0.537875, -2.422880>, <1.173552, -0.532057, -2.372445>, <1.172962, -0.533063, -2.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172962, -0.201547, -2.459963>, <1.170141, -0.196735, -2.422880>, <1.173552, -0.202553, -2.372444>, <1.172962, -0.201547, -2.334962>, 
      <1.148226, -0.228746, -2.459963>, <1.145405, -0.223934, -2.422880>, <1.148816, -0.229753, -2.372444>, <1.148226, -0.228746, -2.334962>, 
      <1.119171, -0.274895, -2.459963>, <1.115159, -0.274895, -2.422678>, <1.120006, -0.274896, -2.372453>, <1.119171, -0.274896, -2.334962>, 
      <1.119171, -0.311660, -2.459963>, <1.115159, -0.311660, -2.422678>, <1.120006, -0.311661, -2.372453>, <1.119171, -0.311661, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.109792, -2.459963>, <1.302756, -0.103022, -2.423079>, <1.302756, -0.111216, -2.372436>, <1.302756, -0.109793, -2.334963>, 
      <1.255071, -0.109792, -2.459963>, <1.255071, -0.103022, -2.423079>, <1.255071, -0.111216, -2.372436>, <1.255071, -0.109793, -2.334963>, 
      <1.205045, -0.166269, -2.459963>, <1.202224, -0.161457, -2.422880>, <1.205635, -0.167275, -2.372444>, <1.205045, -0.166269, -2.334962>, 
      <1.172962, -0.201547, -2.459963>, <1.170141, -0.196735, -2.422880>, <1.173552, -0.202553, -2.372444>, <1.172962, -0.201547, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.109792, -2.459963>, <1.350442, -0.109792, -2.459963>, <1.400468, -0.166269, -2.459963>, <1.432551, -0.201547, -2.459963>, 
      <1.302756, -0.103022, -2.423079>, <1.350442, -0.103022, -2.423079>, <1.403289, -0.161456, -2.422880>, <1.435372, -0.196735, -2.422880>, 
      <1.302756, -0.111216, -2.372436>, <1.350441, -0.111216, -2.372436>, <1.399878, -0.167275, -2.372444>, <1.431961, -0.202553, -2.372444>, 
      <1.302756, -0.109793, -2.334963>, <1.350441, -0.109793, -2.334963>, <1.400468, -0.166269, -2.334962>, <1.432551, -0.201547, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432542, -0.311661, -2.834963>, <1.442289, -0.311661, -2.721730>, <1.474183, -0.311660, -2.572963>, <1.486341, -0.311660, -2.459963>, 
      <1.432542, -0.293933, -2.834963>, <1.442289, -0.293933, -2.721730>, <1.474183, -0.274895, -2.572963>, <1.486341, -0.274895, -2.459963>, 
      <1.408033, -0.277898, -2.834963>, <1.414966, -0.266072, -2.721045>, <1.448655, -0.243470, -2.573427>, <1.457287, -0.228746, -2.459963>, 
      <1.394514, -0.266430, -2.834963>, <1.401447, -0.254604, -2.721045>, <1.423919, -0.216271, -2.573427>, <1.432551, -0.201547, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394514, -0.468181, -2.834963>, <1.401447, -0.480007, -2.721045>, <1.423919, -0.518339, -2.573427>, <1.432551, -0.533063, -2.459963>, 
      <1.418952, -0.426494, -2.834963>, <1.425885, -0.438320, -2.721045>, <1.458488, -0.459372, -2.573427>, <1.467120, -0.474096, -2.459963>, 
      <1.432542, -0.359983, -2.834963>, <1.442289, -0.359983, -2.721730>, <1.474183, -0.380013, -2.572963>, <1.486341, -0.380013, -2.459963>, 
      <1.432542, -0.311661, -2.834963>, <1.442289, -0.311661, -2.721730>, <1.474183, -0.311660, -2.572963>, <1.486341, -0.311660, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.533048, -2.834963>, <1.302756, -0.549874, -2.720372>, <1.302756, -0.603910, -2.573880>, <1.302756, -0.624818, -2.459963>, 
      <1.336467, -0.533048, -2.834963>, <1.336467, -0.549874, -2.720372>, <1.350442, -0.603910, -2.573880>, <1.350442, -0.624818, -2.459963>, 
      <1.377465, -0.497263, -2.834963>, <1.384398, -0.509089, -2.721045>, <1.399803, -0.559477, -2.573427>, <1.408435, -0.574201, -2.459963>, 
      <1.394514, -0.468181, -2.834963>, <1.401447, -0.480007, -2.721045>, <1.423919, -0.518339, -2.573427>, <1.432551, -0.533063, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.468181, -2.834963>, <1.204066, -0.480007, -2.721045>, <1.181594, -0.518339, -2.573427>, <1.172962, -0.533063, -2.459963>, 
      <1.228048, -0.497263, -2.834963>, <1.221115, -0.509089, -2.721045>, <1.205710, -0.559477, -2.573427>, <1.197078, -0.574201, -2.459963>, 
      <1.269045, -0.533048, -2.834963>, <1.269045, -0.549874, -2.720372>, <1.255071, -0.603910, -2.573880>, <1.255071, -0.624818, -2.459963>, 
      <1.302756, -0.533048, -2.834963>, <1.302756, -0.549874, -2.720372>, <1.302756, -0.603910, -2.573880>, <1.302756, -0.624818, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172971, -0.311661, -2.834963>, <1.163224, -0.311661, -2.721730>, <1.131330, -0.311660, -2.572963>, <1.119171, -0.311660, -2.459963>, 
      <1.172971, -0.359983, -2.834963>, <1.163224, -0.359983, -2.721730>, <1.131330, -0.380013, -2.572963>, <1.119171, -0.380013, -2.459963>, 
      <1.186561, -0.426494, -2.834963>, <1.179628, -0.438320, -2.721045>, <1.147025, -0.459372, -2.573427>, <1.138393, -0.474096, -2.459963>, 
      <1.210999, -0.468181, -2.834963>, <1.204066, -0.480007, -2.721045>, <1.181594, -0.518339, -2.573427>, <1.172962, -0.533063, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.266430, -2.834963>, <1.204066, -0.254604, -2.721045>, <1.181594, -0.216271, -2.573427>, <1.172962, -0.201547, -2.459963>, 
      <1.197480, -0.277898, -2.834963>, <1.190547, -0.266072, -2.721045>, <1.156858, -0.243470, -2.573427>, <1.148226, -0.228746, -2.459963>, 
      <1.172971, -0.293933, -2.834963>, <1.163224, -0.293933, -2.721730>, <1.131330, -0.274895, -2.572963>, <1.119171, -0.274895, -2.459963>, 
      <1.172971, -0.311661, -2.834963>, <1.163224, -0.311661, -2.721730>, <1.131330, -0.311660, -2.572963>, <1.119171, -0.311660, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.201564, -2.834963>, <1.302756, -0.184738, -2.720372>, <1.302756, -0.130701, -2.573880>, <1.302756, -0.109792, -2.459963>, 
      <1.269045, -0.201564, -2.834963>, <1.269045, -0.184738, -2.720372>, <1.255071, -0.130701, -2.573880>, <1.255071, -0.109792, -2.459963>, 
      <1.236706, -0.244622, -2.834963>, <1.229773, -0.232796, -2.721045>, <1.213677, -0.180992, -2.573427>, <1.205045, -0.166269, -2.459963>, 
      <1.210999, -0.266430, -2.834963>, <1.204066, -0.254604, -2.721045>, <1.181594, -0.216271, -2.573427>, <1.172962, -0.201547, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.201564, -2.834963>, <1.336467, -0.201564, -2.834963>, <1.368807, -0.244622, -2.834963>, <1.394514, -0.266430, -2.834963>, 
      <1.302756, -0.184738, -2.720372>, <1.336467, -0.184738, -2.720372>, <1.375739, -0.232796, -2.721045>, <1.401447, -0.254604, -2.721045>, 
      <1.302756, -0.130701, -2.573880>, <1.350442, -0.130701, -2.573880>, <1.391836, -0.180992, -2.573427>, <1.423919, -0.216271, -2.573427>, 
      <1.302756, -0.109792, -2.459963>, <1.350442, -0.109792, -2.459963>, <1.400468, -0.166269, -2.459963>, <1.432551, -0.201547, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432542, -0.311661, -3.084963>, <1.432542, -0.293933, -3.084963>, <1.408033, -0.277897, -3.084963>, <1.394514, -0.266429, -3.084963>, 
      <1.446512, -0.300814, -3.165027>, <1.446512, -0.283086, -3.165027>, <1.418527, -0.252319, -3.170034>, <1.405008, -0.240850, -3.170034>, 
      <1.501486, -0.258128, -3.256310>, <1.501486, -0.215297, -3.256310>, <1.474201, -0.178011, -3.252886>, <1.442694, -0.148997, -3.252886>, 
      <1.519784, -0.243920, -3.334963>, <1.519784, -0.201089, -3.334963>, <1.487701, -0.145107, -3.334962>, <1.456194, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432542, -0.311661, -3.084963>, <1.419764, -0.321583, -3.011729>, <1.426110, -0.311661, -2.909687>, <1.432542, -0.311661, -2.834963>, 
      <1.432542, -0.293933, -3.084963>, <1.419764, -0.303855, -3.011729>, <1.426110, -0.293933, -2.909687>, <1.432542, -0.293933, -2.834963>, 
      <1.408033, -0.277897, -3.084963>, <1.399234, -0.299344, -3.013636>, <1.403501, -0.285628, -2.909426>, <1.408033, -0.277898, -2.834963>, 
      <1.394514, -0.266429, -3.084963>, <1.385715, -0.287875, -3.013635>, <1.389982, -0.274160, -2.909426>, <1.394514, -0.266430, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394514, -0.468181, -3.084963>, <1.386087, -0.438387, -3.016653>, <1.389982, -0.460451, -2.909426>, <1.394514, -0.468181, -2.834963>, 
      <1.418952, -0.426494, -3.084963>, <1.410526, -0.396700, -3.016653>, <1.414421, -0.418764, -2.909426>, <1.418952, -0.426494, -2.834963>, 
      <1.432542, -0.359983, -3.084963>, <1.419764, -0.369905, -3.011729>, <1.426110, -0.359983, -2.909687>, <1.432542, -0.359983, -2.834963>, 
      <1.432542, -0.311661, -3.084963>, <1.419764, -0.321583, -3.011729>, <1.426110, -0.311661, -2.909687>, <1.432542, -0.311661, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.394514, -0.468181, -3.084963>, <1.418952, -0.426494, -3.084963>, <1.432542, -0.359983, -3.084963>, <1.432542, -0.311661, -3.084963>, 
      <1.405888, -0.508395, -3.177165>, <1.430326, -0.466709, -3.177165>, <1.446512, -0.349136, -3.165027>, <1.446512, -0.300814, -3.165027>, 
      <1.441944, -0.635876, -3.248325>, <1.485880, -0.509214, -3.248325>, <1.501486, -0.392194, -3.256310>, <1.501486, -0.258128, -3.256310>, 
      <1.456194, -0.686260, -3.334963>, <1.500131, -0.559598, -3.334963>, <1.519784, -0.377986, -3.334963>, <1.519784, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.533048, -3.084963>, <1.336467, -0.533048, -3.084963>, <1.377465, -0.497263, -3.084963>, <1.394514, -0.468181, -3.084963>, 
      <1.302756, -0.603273, -3.189300>, <1.336467, -0.603273, -3.189300>, <1.388839, -0.537478, -3.177165>, <1.405888, -0.508395, -3.177165>, 
      <1.302756, -0.785577, -3.241360>, <1.374473, -0.785577, -3.241360>, <1.418440, -0.703633, -3.248325>, <1.441944, -0.635876, -3.248325>, 
      <1.302756, -0.869577, -3.334963>, <1.374473, -0.869577, -3.334963>, <1.432691, -0.754016, -3.334963>, <1.456194, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.533048, -3.084963>, <1.302756, -0.491171, -3.022743>, <1.302756, -0.522152, -2.909168>, <1.302756, -0.533048, -2.834963>, 
      <1.336467, -0.533048, -3.084963>, <1.336467, -0.491171, -3.022743>, <1.336467, -0.522152, -2.909168>, <1.336467, -0.533048, -2.834963>, 
      <1.377465, -0.497263, -3.084963>, <1.369038, -0.467469, -3.016653>, <1.372933, -0.489533, -2.909426>, <1.377465, -0.497263, -2.834963>, 
      <1.394514, -0.468181, -3.084963>, <1.386087, -0.438387, -3.016653>, <1.389982, -0.460451, -2.909426>, <1.394514, -0.468181, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.468181, -3.084963>, <1.228048, -0.497263, -3.084963>, <1.269045, -0.533048, -3.084963>, <1.302756, -0.533048, -3.084963>, 
      <1.199625, -0.508395, -3.177165>, <1.216674, -0.537478, -3.177165>, <1.269045, -0.603273, -3.189300>, <1.302756, -0.603273, -3.189300>, 
      <1.163569, -0.635876, -3.248325>, <1.187072, -0.703633, -3.248325>, <1.231039, -0.785577, -3.241360>, <1.302756, -0.785577, -3.241360>, 
      <1.149318, -0.686260, -3.334963>, <1.172821, -0.754016, -3.334963>, <1.231039, -0.869577, -3.334963>, <1.302756, -0.869577, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.468181, -3.084963>, <1.219426, -0.438387, -3.016653>, <1.215531, -0.460451, -2.909426>, <1.210999, -0.468181, -2.834963>, 
      <1.228048, -0.497263, -3.084963>, <1.236475, -0.467469, -3.016653>, <1.232580, -0.489533, -2.909426>, <1.228048, -0.497263, -2.834963>, 
      <1.269045, -0.533048, -3.084963>, <1.269045, -0.491171, -3.022743>, <1.269045, -0.522152, -2.909168>, <1.269045, -0.533048, -2.834963>, 
      <1.302756, -0.533048, -3.084963>, <1.302756, -0.491171, -3.022743>, <1.302756, -0.522152, -2.909168>, <1.302756, -0.533048, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172971, -0.311661, -3.084963>, <1.172971, -0.359983, -3.084963>, <1.186561, -0.426494, -3.084963>, <1.210999, -0.468181, -3.084963>, 
      <1.159001, -0.300814, -3.165027>, <1.159001, -0.349136, -3.165027>, <1.175187, -0.466709, -3.177165>, <1.199625, -0.508395, -3.177165>, 
      <1.104027, -0.258128, -3.256310>, <1.104027, -0.392194, -3.256310>, <1.119632, -0.509214, -3.248325>, <1.163569, -0.635876, -3.248325>, 
      <1.085728, -0.243920, -3.334963>, <1.085728, -0.377986, -3.334963>, <1.105381, -0.559598, -3.334963>, <1.149318, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172971, -0.311661, -3.084963>, <1.185749, -0.321583, -3.011729>, <1.179403, -0.311661, -2.909687>, <1.172971, -0.311661, -2.834963>, 
      <1.172971, -0.359983, -3.084963>, <1.185749, -0.369905, -3.011729>, <1.179403, -0.359983, -2.909687>, <1.172971, -0.359983, -2.834963>, 
      <1.186561, -0.426494, -3.084963>, <1.194988, -0.396700, -3.016653>, <1.191093, -0.418764, -2.909426>, <1.186561, -0.426494, -2.834963>, 
      <1.210999, -0.468181, -3.084963>, <1.219426, -0.438387, -3.016653>, <1.215531, -0.460451, -2.909426>, <1.210999, -0.468181, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.266429, -3.084963>, <1.197480, -0.277897, -3.084963>, <1.172971, -0.293933, -3.084963>, <1.172971, -0.311661, -3.084963>, 
      <1.200505, -0.240850, -3.170034>, <1.186986, -0.252319, -3.170034>, <1.159001, -0.283086, -3.165027>, <1.159001, -0.300814, -3.165027>, 
      <1.162818, -0.148997, -3.252886>, <1.131311, -0.178011, -3.252886>, <1.104027, -0.215297, -3.256310>, <1.104027, -0.258128, -3.256310>, 
      <1.149318, -0.116093, -3.334962>, <1.117811, -0.145107, -3.334962>, <1.085728, -0.201089, -3.334963>, <1.085728, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.210999, -0.266429, -3.084963>, <1.219798, -0.287875, -3.013635>, <1.215531, -0.274160, -2.909426>, <1.210999, -0.266430, -2.834963>, 
      <1.197480, -0.277897, -3.084963>, <1.206279, -0.299344, -3.013636>, <1.202012, -0.285628, -2.909426>, <1.197480, -0.277898, -2.834963>, 
      <1.172971, -0.293933, -3.084963>, <1.185749, -0.303855, -3.011729>, <1.179403, -0.293933, -2.909687>, <1.172971, -0.293933, -2.834963>, 
      <1.172971, -0.311661, -3.084963>, <1.185749, -0.321583, -3.011729>, <1.179403, -0.311661, -2.909687>, <1.172971, -0.311661, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.201564, -3.084962>, <1.269045, -0.201564, -3.084962>, <1.236706, -0.244622, -3.084963>, <1.210999, -0.266429, -3.084963>, 
      <1.302756, -0.174931, -3.169509>, <1.269045, -0.174931, -3.169509>, <1.226212, -0.219043, -3.170034>, <1.200505, -0.240850, -3.170034>, 
      <1.302756, -0.078389, -3.253235>, <1.251905, -0.078389, -3.253235>, <1.200225, -0.114550, -3.252885>, <1.162818, -0.148997, -3.252886>, 
      <1.302756, -0.044064, -3.334962>, <1.251905, -0.044064, -3.334962>, <1.186724, -0.081646, -3.334962>, <1.149318, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.201564, -3.084962>, <1.302756, -0.224098, -3.013427>, <1.302756, -0.212460, -2.909167>, <1.302756, -0.201564, -2.834963>, 
      <1.269045, -0.201564, -3.084962>, <1.269045, -0.224098, -3.013427>, <1.269045, -0.212460, -2.909167>, <1.269045, -0.201564, -2.834963>, 
      <1.236706, -0.244622, -3.084963>, <1.245505, -0.266068, -3.013635>, <1.241238, -0.252353, -2.909426>, <1.236706, -0.244622, -2.834963>, 
      <1.210999, -0.266429, -3.084963>, <1.219798, -0.287875, -3.013635>, <1.215531, -0.274160, -2.909426>, <1.210999, -0.266430, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.201564, -3.084962>, <1.302756, -0.174931, -3.169509>, <1.302756, -0.078389, -3.253235>, <1.302756, -0.044064, -3.334962>, 
      <1.336467, -0.201564, -3.084962>, <1.336467, -0.174931, -3.169509>, <1.353607, -0.078389, -3.253235>, <1.353607, -0.044064, -3.334962>, 
      <1.368807, -0.244622, -3.084963>, <1.379301, -0.219043, -3.170034>, <1.405288, -0.114550, -3.252886>, <1.418788, -0.081646, -3.334962>, 
      <1.394514, -0.266429, -3.084963>, <1.405008, -0.240850, -3.170034>, <1.442694, -0.148997, -3.252886>, <1.456194, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.302756, -0.201564, -3.084962>, <1.336467, -0.201564, -3.084962>, <1.368807, -0.244622, -3.084963>, <1.394514, -0.266429, -3.084963>, 
      <1.302756, -0.224098, -3.013427>, <1.336467, -0.224098, -3.013427>, <1.360008, -0.266068, -3.013635>, <1.385715, -0.287875, -3.013635>, 
      <1.302756, -0.212460, -2.909167>, <1.336467, -0.212460, -2.909167>, <1.364275, -0.252352, -2.909426>, <1.389982, -0.274160, -2.909426>, 
      <1.302756, -0.201564, -2.834963>, <1.336467, -0.201564, -2.834963>, <1.368807, -0.244622, -2.834963>, <1.394514, -0.266430, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.726154, -0.243920, -3.459963>, <1.726154, -0.243920, -3.422463>, <1.717785, -0.237422, -3.370935>, <1.726154, -0.243920, -3.334963>, 
      <1.726154, -0.201089, -3.459963>, <1.726154, -0.201089, -3.422463>, <1.717785, -0.194591, -3.370935>, <1.726154, -0.201089, -3.334963>, 
      <1.758237, -0.145107, -3.459962>, <1.758237, -0.145107, -3.422462>, <1.752578, -0.131313, -3.369370>, <1.758237, -0.145107, -3.334962>, 
      <1.789744, -0.116093, -3.459962>, <1.789744, -0.116093, -3.422462>, <1.784085, -0.102299, -3.369370>, <1.789744, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.789744, -0.686259, -3.459962>, <1.789744, -0.686259, -3.422462>, <1.784465, -0.704924, -3.367057>, <1.789744, -0.686260, -3.334963>, 
      <1.745808, -0.559597, -3.459962>, <1.745808, -0.559597, -3.422462>, <1.740529, -0.578262, -3.367057>, <1.745807, -0.559598, -3.334963>, 
      <1.726154, -0.377986, -3.459963>, <1.726154, -0.377986, -3.422463>, <1.717785, -0.371488, -3.370936>, <1.726154, -0.377986, -3.334963>, 
      <1.726154, -0.243920, -3.459963>, <1.726154, -0.243920, -3.422463>, <1.717785, -0.237422, -3.370935>, <1.726154, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.869577, -3.459963>, <1.943182, -0.869577, -3.422463>, <1.943182, -0.894623, -3.362873>, <1.943182, -0.869577, -3.334963>, 
      <1.871465, -0.869577, -3.459963>, <1.871465, -0.869577, -3.422463>, <1.871465, -0.894623, -3.362873>, <1.871465, -0.869577, -3.334963>, 
      <1.813247, -0.754016, -3.459962>, <1.813247, -0.754016, -3.422462>, <1.807969, -0.772680, -3.367057>, <1.813247, -0.754016, -3.334963>, 
      <1.789744, -0.686259, -3.459962>, <1.789744, -0.686259, -3.422462>, <1.784465, -0.704924, -3.367057>, <1.789744, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.096620, -0.686259, -3.459962>, <2.096620, -0.686259, -3.422462>, <2.101899, -0.704924, -3.367057>, <2.096620, -0.686260, -3.334963>, 
      <2.073117, -0.754016, -3.459962>, <2.073117, -0.754016, -3.422462>, <2.078396, -0.772680, -3.367057>, <2.073117, -0.754016, -3.334963>, 
      <2.014899, -0.869577, -3.459963>, <2.014899, -0.869577, -3.422463>, <2.014899, -0.894623, -3.362873>, <2.014899, -0.869577, -3.334963>, 
      <1.943182, -0.869577, -3.459963>, <1.943182, -0.869577, -3.422463>, <1.943182, -0.894623, -3.362873>, <1.943182, -0.869577, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.160210, -0.243920, -3.459963>, <2.160210, -0.243920, -3.422463>, <2.168579, -0.237422, -3.370935>, <2.160210, -0.243920, -3.334963>, 
      <2.160210, -0.377986, -3.459963>, <2.160210, -0.377986, -3.422463>, <2.168579, -0.371488, -3.370936>, <2.160210, -0.377986, -3.334963>, 
      <2.140557, -0.559597, -3.459962>, <2.140557, -0.559597, -3.422462>, <2.145836, -0.578262, -3.367057>, <2.140557, -0.559598, -3.334963>, 
      <2.096620, -0.686259, -3.459962>, <2.096620, -0.686259, -3.422462>, <2.101899, -0.704924, -3.367057>, <2.096620, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.096620, -0.116093, -3.459962>, <2.096620, -0.116093, -3.422462>, <2.102280, -0.102299, -3.369370>, <2.096620, -0.116093, -3.334962>, 
      <2.128127, -0.145107, -3.459962>, <2.128127, -0.145107, -3.422462>, <2.133787, -0.131313, -3.369370>, <2.128127, -0.145107, -3.334962>, 
      <2.160210, -0.201089, -3.459963>, <2.160210, -0.201089, -3.422463>, <2.168579, -0.194591, -3.370935>, <2.160210, -0.201089, -3.334963>, 
      <2.160210, -0.243920, -3.459963>, <2.160210, -0.243920, -3.422463>, <2.168579, -0.237422, -3.370935>, <2.160210, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.044064, -3.459962>, <1.943182, -0.044064, -3.422462>, <1.943182, -0.029543, -3.369536>, <1.943182, -0.044064, -3.334962>, 
      <1.994033, -0.044064, -3.459962>, <1.994033, -0.044064, -3.422462>, <1.994033, -0.029543, -3.369536>, <1.994033, -0.044064, -3.334962>, 
      <2.059214, -0.081646, -3.459962>, <2.059214, -0.081646, -3.422462>, <2.064873, -0.067852, -3.369370>, <2.059214, -0.081646, -3.334962>, 
      <2.096620, -0.116093, -3.459962>, <2.096620, -0.116093, -3.422462>, <2.102280, -0.102299, -3.369370>, <2.096620, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.044064, -3.459962>, <1.892331, -0.044064, -3.459962>, <1.827151, -0.081646, -3.459962>, <1.789744, -0.116093, -3.459962>, 
      <1.943182, -0.044064, -3.422462>, <1.892331, -0.044064, -3.422462>, <1.827151, -0.081646, -3.422462>, <1.789744, -0.116093, -3.422462>, 
      <1.943182, -0.029543, -3.369536>, <1.892331, -0.029543, -3.369536>, <1.821491, -0.067852, -3.369370>, <1.784085, -0.102299, -3.369370>, 
      <1.943182, -0.044064, -3.334962>, <1.892331, -0.044064, -3.334962>, <1.827151, -0.081646, -3.334962>, <1.789744, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.719933, -0.311661, -1.834963>, <1.701968, -0.311661, -1.740143>, <1.721271, -0.311661, -1.527674>, <1.624764, -0.311661, -1.527674>, 
      <1.719933, -0.242163, -1.834963>, <1.701968, -0.242163, -1.740143>, <1.721271, -0.217773, -1.527674>, <1.624764, -0.217773, -1.527674>, 
      <1.720765, -0.140697, -1.834962>, <1.707426, -0.122738, -1.686369>, <1.702665, -0.180379, -1.515359>, <1.670211, -0.150581, -1.371695>, 
      <1.760309, -0.083546, -1.834962>, <1.746970, -0.065587, -1.686369>, <1.763358, -0.118880, -1.478627>, <1.730904, -0.089082, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.760309, -0.539775, -1.834963>, <1.746874, -0.538829, -1.685299>, <1.762461, -0.513946, -1.480471>, <1.730904, -0.534240, -1.334962>, 
      <1.720765, -0.482624, -1.834963>, <1.707330, -0.481678, -1.685299>, <1.701768, -0.452447, -1.517203>, <1.670211, -0.472741, -1.371694>, 
      <1.719933, -0.381159, -1.834963>, <1.701968, -0.381159, -1.740143>, <1.721271, -0.405550, -1.527674>, <1.624764, -0.405550, -1.527674>, 
      <1.719933, -0.311661, -1.834963>, <1.701968, -0.311661, -1.740143>, <1.721271, -0.311661, -1.527674>, <1.624764, -0.311661, -1.527674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.634311, -1.834962>, <1.943182, -0.634311, -1.684962>, <1.943674, -0.635445, -1.484958>, <1.943182, -0.634312, -1.334963>, 
      <1.881423, -0.634311, -1.834962>, <1.881423, -0.634311, -1.684962>, <1.873278, -0.634319, -1.484958>, <1.872786, -0.633186, -1.334963>, 
      <1.795450, -0.590562, -1.834963>, <1.782014, -0.589615, -1.685299>, <1.807973, -0.560064, -1.452927>, <1.776416, -0.580357, -1.307417>, 
      <1.760309, -0.539775, -1.834963>, <1.746874, -0.538829, -1.685299>, <1.762461, -0.513946, -1.480471>, <1.730904, -0.534240, -1.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, -0.539775, -1.834963>, <2.076910, -0.539775, -1.684963>, <2.101129, -0.524106, -1.482163>, <2.076910, -0.539774, -1.334962>, 
      <2.052063, -0.582159, -1.834963>, <2.052063, -0.582159, -1.684963>, <2.081953, -0.569338, -1.481623>, <2.057734, -0.585005, -1.334422>, 
      <1.992313, -0.634311, -1.834962>, <1.992313, -0.634311, -1.684962>, <1.992799, -0.636231, -1.484958>, <1.992307, -0.635098, -1.334963>, 
      <1.943182, -0.634311, -1.834962>, <1.943182, -0.634311, -1.684962>, <1.943674, -0.635445, -1.484958>, <1.943182, -0.634312, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132332, -0.311661, -1.834963>, <2.123352, -0.311661, -1.685562>, <2.092077, -0.326675, -1.487239>, <2.079968, -0.311660, -1.338817>, 
      <2.132332, -0.382086, -1.834963>, <2.123352, -0.382086, -1.685562>, <2.092077, -0.395125, -1.487239>, <2.079968, -0.380110, -1.338817>, 
      <2.112527, -0.479020, -1.834963>, <2.112527, -0.479020, -1.684963>, <2.127844, -0.461089, -1.482915>, <2.103626, -0.476757, -1.335715>, 
      <2.076910, -0.539775, -1.834963>, <2.076910, -0.539775, -1.684963>, <2.101129, -0.524106, -1.482163>, <2.076910, -0.539774, -1.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, -0.083546, -1.834962>, <2.076910, -0.064620, -1.686161>, <2.079262, -0.058532, -1.482843>, <2.076910, -0.083547, -1.334963>, 
      <2.112527, -0.144301, -1.834962>, <2.112527, -0.125375, -1.686161>, <2.105978, -0.121549, -1.483596>, <2.103626, -0.146564, -1.335716>, 
      <2.132332, -0.241236, -1.834963>, <2.123352, -0.241235, -1.685562>, <2.092077, -0.258225, -1.487239>, <2.079968, -0.243210, -1.338817>, 
      <2.132332, -0.311661, -1.834963>, <2.123352, -0.311661, -1.685562>, <2.092077, -0.326675, -1.487239>, <2.079968, -0.311660, -1.338817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.010990, -1.834963>, <1.943182, 0.029916, -1.686161>, <1.936783, 0.018900, -1.484617>, <1.943182, 0.010990, -1.334962>, 
      <1.992313, 0.010990, -1.834963>, <1.992313, 0.029916, -1.686161>, <1.985908, 0.019685, -1.484617>, <1.992307, 0.011776, -1.334962>, 
      <2.052063, -0.041162, -1.834962>, <2.052063, -0.022236, -1.686161>, <2.060087, -0.013301, -1.482303>, <2.057734, -0.038316, -1.334423>, 
      <2.076910, -0.083546, -1.834962>, <2.076910, -0.064620, -1.686161>, <2.079262, -0.058532, -1.482843>, <2.076910, -0.083547, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, 0.010990, -1.834963>, <1.881423, 0.010990, -1.834963>, <1.795449, -0.032759, -1.834962>, <1.760309, -0.083546, -1.834962>, 
      <1.943182, 0.029916, -1.686161>, <1.881423, 0.029916, -1.686161>, <1.782110, -0.014800, -1.686369>, <1.746970, -0.065587, -1.686369>, 
      <1.936783, 0.018900, -1.484617>, <1.866387, 0.017773, -1.484617>, <1.808870, -0.072762, -1.451082>, <1.763358, -0.118880, -1.478627>, 
      <1.943182, 0.010990, -1.334962>, <1.872786, 0.009864, -1.334962>, <1.776416, -0.042965, -1.307418>, <1.730904, -0.089082, -1.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.754032, -0.311661, -2.209964>, <1.745099, -0.311661, -2.097353>, <1.740961, -0.311661, -1.945953>, <1.719933, -0.311661, -1.834963>, 
      <1.754032, -0.272870, -2.209964>, <1.745099, -0.272870, -2.097353>, <1.740961, -0.242163, -1.945953>, <1.719933, -0.242163, -1.834963>, 
      <1.783584, -0.223742, -2.209962>, <1.771429, -0.196720, -2.095462>, <1.731264, -0.154833, -1.951916>, <1.720765, -0.140697, -1.834962>, 
      <1.809453, -0.194836, -2.209962>, <1.797298, -0.167814, -2.095461>, <1.770808, -0.097681, -1.951916>, <1.760309, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.809453, -0.539774, -2.209963>, <1.797477, -0.541288, -2.097145>, <1.770453, -0.540490, -1.947968>, <1.760309, -0.539775, -1.834963>, 
      <1.773836, -0.479020, -2.209963>, <1.761860, -0.480534, -2.097145>, <1.730909, -0.483339, -1.947968>, <1.720765, -0.482624, -1.834963>, 
      <1.754032, -0.382086, -2.209964>, <1.745099, -0.382086, -2.097354>, <1.740961, -0.381159, -1.945953>, <1.719933, -0.381159, -1.834963>, 
      <1.754032, -0.311661, -2.209964>, <1.745099, -0.311661, -2.097353>, <1.740961, -0.311661, -1.945953>, <1.719933, -0.311661, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.634312, -2.209963>, <1.943182, -0.636448, -2.097483>, <1.943182, -0.634311, -1.947462>, <1.943182, -0.634311, -1.834962>, 
      <1.894051, -0.634312, -2.209963>, <1.894051, -0.636448, -2.097483>, <1.881423, -0.634311, -1.947462>, <1.881423, -0.634311, -1.834962>, 
      <1.834301, -0.582159, -2.209963>, <1.822324, -0.583673, -2.097145>, <1.805594, -0.591277, -1.947968>, <1.795450, -0.590562, -1.834963>, 
      <1.809453, -0.539774, -2.209963>, <1.797477, -0.541288, -2.097145>, <1.770453, -0.540490, -1.947968>, <1.760309, -0.539775, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, -0.539774, -2.209963>, <2.077795, -0.541284, -2.097477>, <2.076910, -0.539775, -1.947463>, <2.076910, -0.539775, -1.834963>, 
      <2.052063, -0.582159, -2.209963>, <2.052948, -0.583669, -2.097476>, <2.052063, -0.582159, -1.947463>, <2.052063, -0.582159, -1.834963>, 
      <1.992313, -0.634312, -2.209963>, <1.992313, -0.636448, -2.097483>, <1.992313, -0.634311, -1.947462>, <1.992313, -0.634311, -1.834962>, 
      <1.943182, -0.634312, -2.209963>, <1.943182, -0.636448, -2.097483>, <1.943182, -0.634311, -1.947462>, <1.943182, -0.634311, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.132332, -0.311661, -2.209964>, <2.133584, -0.311661, -2.097471>, <2.139082, -0.311661, -1.947261>, <2.132332, -0.311661, -1.834963>, 
      <2.132332, -0.382086, -2.209964>, <2.133584, -0.382086, -2.097471>, <2.139082, -0.382086, -1.947261>, <2.132332, -0.382086, -1.834963>, 
      <2.112527, -0.479020, -2.209963>, <2.113412, -0.480530, -2.097477>, <2.112527, -0.479020, -1.947463>, <2.112527, -0.479020, -1.834963>, 
      <2.076910, -0.539774, -2.209963>, <2.077795, -0.541284, -2.097477>, <2.076910, -0.539775, -1.947463>, <2.076910, -0.539775, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.076910, -0.194836, -2.209962>, <2.077809, -0.167882, -2.095753>, <2.076910, -0.098352, -1.951374>, <2.076910, -0.083546, -1.834962>, 
      <2.102779, -0.223743, -2.209962>, <2.103677, -0.196789, -2.095753>, <2.112527, -0.159107, -1.951374>, <2.112527, -0.144301, -1.834962>, 
      <2.132332, -0.272870, -2.209964>, <2.133584, -0.272870, -2.097471>, <2.139082, -0.241236, -1.947260>, <2.132332, -0.241236, -1.834963>, 
      <2.132332, -0.311661, -2.209964>, <2.133584, -0.311661, -2.097471>, <2.139082, -0.311661, -1.947261>, <2.132332, -0.311661, -1.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.100299, -2.209963>, <1.943182, -0.072744, -2.095895>, <1.943182, -0.003816, -1.951375>, <1.943182, 0.010990, -1.834963>, 
      <1.992313, -0.100299, -2.209963>, <1.992313, -0.072744, -2.095895>, <1.992313, -0.003816, -1.951375>, <1.992313, 0.010990, -1.834963>, 
      <2.044146, -0.158225, -2.209962>, <2.045045, -0.131271, -2.095753>, <2.052063, -0.055968, -1.951374>, <2.052063, -0.041162, -1.834962>, 
      <2.076910, -0.194836, -2.209962>, <2.077809, -0.167882, -2.095753>, <2.076910, -0.098352, -1.951374>, <2.076910, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.100299, -2.209963>, <1.894051, -0.100299, -2.209963>, <1.842217, -0.158225, -2.209962>, <1.809453, -0.194836, -2.209962>, 
      <1.943182, -0.072744, -2.095895>, <1.894051, -0.072744, -2.095895>, <1.830062, -0.131202, -2.095461>, <1.797298, -0.167814, -2.095461>, 
      <1.943182, -0.003816, -1.951375>, <1.881423, -0.003816, -1.951375>, <1.805948, -0.046894, -1.951916>, <1.770808, -0.097681, -1.951916>, 
      <1.943182, 0.010990, -1.834963>, <1.881423, 0.010990, -1.834963>, <1.795449, -0.032759, -1.834962>, <1.760309, -0.083546, -1.834962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.759597, -0.311661, -2.334962>, <1.758762, -0.311661, -2.297435>, <1.757000, -0.311661, -2.247383>, <1.754032, -0.311661, -2.209964>, 
      <1.759597, -0.274896, -2.334962>, <1.758762, -0.274896, -2.297435>, <1.757000, -0.272870, -2.247383>, <1.754032, -0.272870, -2.209964>, 
      <1.788651, -0.228746, -2.334962>, <1.788060, -0.227738, -2.297407>, <1.787446, -0.232327, -2.246336>, <1.783584, -0.223742, -2.209962>, 
      <1.813387, -0.201547, -2.334962>, <1.812796, -0.200539, -2.297408>, <1.813314, -0.203420, -2.246336>, <1.809453, -0.194836, -2.209962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813387, -0.533063, -2.334963>, <1.812796, -0.534071, -2.297409>, <1.813419, -0.539273, -2.247322>, <1.809453, -0.539774, -2.209963>, 
      <1.778818, -0.474096, -2.334963>, <1.778227, -0.475104, -2.297409>, <1.777802, -0.478518, -2.247323>, <1.773836, -0.479020, -2.209963>, 
      <1.759597, -0.380014, -2.334962>, <1.758762, -0.380014, -2.297435>, <1.757000, -0.382086, -2.247383>, <1.754032, -0.382086, -2.209964>, 
      <1.759597, -0.311661, -2.334962>, <1.758762, -0.311661, -2.297435>, <1.757000, -0.311661, -2.247383>, <1.754032, -0.311661, -2.209964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.624818, -2.334962>, <1.943182, -0.626245, -2.297381>, <1.943182, -0.633598, -2.247564>, <1.943182, -0.634312, -2.209963>, 
      <1.895496, -0.624818, -2.334962>, <1.895496, -0.626245, -2.297381>, <1.894051, -0.633598, -2.247564>, <1.894051, -0.634312, -2.209963>, 
      <1.837504, -0.574201, -2.334963>, <1.836913, -0.575209, -2.297409>, <1.838266, -0.581657, -2.247322>, <1.834301, -0.582159, -2.209963>, 
      <1.813387, -0.533063, -2.334963>, <1.812796, -0.534071, -2.297409>, <1.813419, -0.539273, -2.247322>, <1.809453, -0.539774, -2.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, -0.533063, -2.334963>, <2.073567, -0.534071, -2.297409>, <2.076614, -0.539270, -2.247531>, <2.076910, -0.539774, -2.209963>, 
      <2.048860, -0.574201, -2.334963>, <2.049451, -0.575209, -2.297409>, <2.051767, -0.581654, -2.247531>, <2.052063, -0.582159, -2.209963>, 
      <1.990867, -0.624818, -2.334962>, <1.990867, -0.626245, -2.297381>, <1.992313, -0.633598, -2.247564>, <1.992313, -0.634312, -2.209963>, 
      <1.943182, -0.624818, -2.334962>, <1.943182, -0.626245, -2.297381>, <1.943182, -0.633598, -2.247564>, <1.943182, -0.634312, -2.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126767, -0.311661, -2.334962>, <2.127602, -0.311661, -2.297435>, <2.131914, -0.311661, -2.247498>, <2.132332, -0.311661, -2.209964>, 
      <2.126767, -0.380014, -2.334962>, <2.127602, -0.380014, -2.297435>, <2.131914, -0.382086, -2.247499>, <2.132332, -0.382086, -2.209964>, 
      <2.107545, -0.474096, -2.334963>, <2.108136, -0.475104, -2.297409>, <2.112231, -0.478515, -2.247531>, <2.112527, -0.479020, -2.209963>, 
      <2.072976, -0.533063, -2.334963>, <2.073567, -0.534071, -2.297409>, <2.076614, -0.539270, -2.247531>, <2.076910, -0.539774, -2.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, -0.201547, -2.334962>, <2.073567, -0.200539, -2.297408>, <2.076622, -0.203466, -2.246529>, <2.076910, -0.194836, -2.209962>, 
      <2.097712, -0.228746, -2.334962>, <2.098303, -0.227738, -2.297407>, <2.102491, -0.232372, -2.246529>, <2.102779, -0.223743, -2.209962>, 
      <2.126767, -0.274896, -2.334962>, <2.127602, -0.274896, -2.297435>, <2.131914, -0.272870, -2.247498>, <2.132332, -0.272870, -2.209964>, 
      <2.126767, -0.311661, -2.334962>, <2.127602, -0.311661, -2.297435>, <2.131914, -0.311661, -2.247498>, <2.132332, -0.311661, -2.209964>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.109793, -2.334963>, <1.943182, -0.108366, -2.297382>, <1.943182, -0.109130, -2.246520>, <1.943182, -0.100299, -2.209963>, 
      <1.990867, -0.109793, -2.334963>, <1.990867, -0.108366, -2.297382>, <1.992313, -0.109130, -2.246520>, <1.992313, -0.100299, -2.209963>, 
      <2.040893, -0.166269, -2.334962>, <2.041484, -0.165261, -2.297408>, <2.043859, -0.166855, -2.246529>, <2.044146, -0.158225, -2.209962>, 
      <2.072976, -0.201547, -2.334962>, <2.073567, -0.200539, -2.297408>, <2.076622, -0.203466, -2.246529>, <2.076910, -0.194836, -2.209962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.109793, -2.334963>, <1.895497, -0.109793, -2.334963>, <1.845470, -0.166269, -2.334962>, <1.813387, -0.201547, -2.334962>, 
      <1.943182, -0.108366, -2.297382>, <1.895497, -0.108366, -2.297382>, <1.844879, -0.165261, -2.297408>, <1.812796, -0.200539, -2.297408>, 
      <1.943182, -0.109130, -2.246520>, <1.894051, -0.109130, -2.246520>, <1.846078, -0.166809, -2.246336>, <1.813314, -0.203420, -2.246336>, 
      <1.943182, -0.100299, -2.209963>, <1.894051, -0.100299, -2.209963>, <1.842217, -0.158225, -2.209962>, <1.809453, -0.194836, -2.209962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.759597, -0.311660, -2.459963>, <1.755585, -0.311660, -2.422678>, <1.760432, -0.311661, -2.372453>, <1.759597, -0.311661, -2.334962>, 
      <1.759597, -0.274895, -2.459963>, <1.755585, -0.274895, -2.422678>, <1.760432, -0.274896, -2.372453>, <1.759597, -0.274896, -2.334962>, 
      <1.788651, -0.228746, -2.459963>, <1.785830, -0.223934, -2.422880>, <1.789241, -0.229752, -2.372444>, <1.788651, -0.228746, -2.334962>, 
      <1.813387, -0.201547, -2.459963>, <1.810566, -0.196735, -2.422880>, <1.813977, -0.202553, -2.372444>, <1.813387, -0.201547, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813387, -0.533063, -2.459963>, <1.810566, -0.537875, -2.422880>, <1.813977, -0.532057, -2.372445>, <1.813387, -0.533063, -2.334963>, 
      <1.778818, -0.474096, -2.459963>, <1.775997, -0.478908, -2.422880>, <1.779408, -0.473090, -2.372445>, <1.778818, -0.474096, -2.334963>, 
      <1.759597, -0.380013, -2.459963>, <1.755585, -0.380013, -2.422678>, <1.760432, -0.380014, -2.372453>, <1.759597, -0.380014, -2.334962>, 
      <1.759597, -0.311660, -2.459963>, <1.755585, -0.311660, -2.422678>, <1.760432, -0.311661, -2.372453>, <1.759597, -0.311661, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.624818, -2.459963>, <1.943182, -0.631588, -2.423079>, <1.943182, -0.623395, -2.372435>, <1.943182, -0.624818, -2.334962>, 
      <1.895496, -0.624818, -2.459963>, <1.895496, -0.631588, -2.423079>, <1.895496, -0.623395, -2.372435>, <1.895496, -0.624818, -2.334962>, 
      <1.837504, -0.574201, -2.459963>, <1.834682, -0.579013, -2.422880>, <1.838093, -0.573195, -2.372445>, <1.837504, -0.574201, -2.334963>, 
      <1.813387, -0.533063, -2.459963>, <1.810566, -0.537875, -2.422880>, <1.813977, -0.532057, -2.372445>, <1.813387, -0.533063, -2.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, -0.533063, -2.459963>, <2.075797, -0.537875, -2.422880>, <2.072386, -0.532057, -2.372445>, <2.072976, -0.533063, -2.334963>, 
      <2.048860, -0.574201, -2.459963>, <2.051681, -0.579013, -2.422880>, <2.048270, -0.573194, -2.372445>, <2.048860, -0.574201, -2.334963>, 
      <1.990867, -0.624818, -2.459963>, <1.990867, -0.631588, -2.423079>, <1.990867, -0.623395, -2.372435>, <1.990867, -0.624818, -2.334962>, 
      <1.943182, -0.624818, -2.459963>, <1.943182, -0.631588, -2.423079>, <1.943182, -0.623395, -2.372435>, <1.943182, -0.624818, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.126767, -0.311660, -2.459963>, <2.130779, -0.311660, -2.422678>, <2.125932, -0.311661, -2.372453>, <2.126767, -0.311661, -2.334962>, 
      <2.126767, -0.380013, -2.459963>, <2.130779, -0.380013, -2.422678>, <2.125932, -0.380014, -2.372453>, <2.126767, -0.380014, -2.334962>, 
      <2.107545, -0.474096, -2.459963>, <2.110366, -0.478908, -2.422880>, <2.106955, -0.473090, -2.372445>, <2.107545, -0.474096, -2.334963>, 
      <2.072976, -0.533063, -2.459963>, <2.075797, -0.537875, -2.422880>, <2.072386, -0.532057, -2.372445>, <2.072976, -0.533063, -2.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072976, -0.201547, -2.459963>, <2.075797, -0.196735, -2.422880>, <2.072386, -0.202553, -2.372444>, <2.072976, -0.201547, -2.334962>, 
      <2.097712, -0.228746, -2.459963>, <2.100533, -0.223934, -2.422880>, <2.097122, -0.229753, -2.372444>, <2.097712, -0.228746, -2.334962>, 
      <2.126767, -0.274895, -2.459963>, <2.130779, -0.274895, -2.422678>, <2.125932, -0.274896, -2.372453>, <2.126767, -0.274896, -2.334962>, 
      <2.126767, -0.311660, -2.459963>, <2.130779, -0.311660, -2.422678>, <2.125932, -0.311661, -2.372453>, <2.126767, -0.311661, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.109792, -2.459963>, <1.943182, -0.103022, -2.423079>, <1.943182, -0.111216, -2.372436>, <1.943182, -0.109793, -2.334963>, 
      <1.990867, -0.109792, -2.459963>, <1.990867, -0.103022, -2.423079>, <1.990867, -0.111216, -2.372436>, <1.990867, -0.109793, -2.334963>, 
      <2.040893, -0.166269, -2.459963>, <2.043714, -0.161457, -2.422880>, <2.040303, -0.167275, -2.372444>, <2.040893, -0.166269, -2.334962>, 
      <2.072976, -0.201547, -2.459963>, <2.075797, -0.196735, -2.422880>, <2.072386, -0.202553, -2.372444>, <2.072976, -0.201547, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.109792, -2.459963>, <1.895496, -0.109792, -2.459963>, <1.845470, -0.166269, -2.459963>, <1.813387, -0.201547, -2.459963>, 
      <1.943182, -0.103022, -2.423079>, <1.895496, -0.103022, -2.423079>, <1.842649, -0.161456, -2.422880>, <1.810566, -0.196735, -2.422880>, 
      <1.943182, -0.111216, -2.372436>, <1.895497, -0.111216, -2.372436>, <1.846060, -0.167275, -2.372444>, <1.813977, -0.202553, -2.372444>, 
      <1.943182, -0.109793, -2.334963>, <1.895497, -0.109793, -2.334963>, <1.845470, -0.166269, -2.334962>, <1.813387, -0.201547, -2.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813396, -0.311661, -2.834963>, <1.803649, -0.311661, -2.721730>, <1.771755, -0.311660, -2.572963>, <1.759597, -0.311660, -2.459963>, 
      <1.813396, -0.293933, -2.834963>, <1.803649, -0.293933, -2.721730>, <1.771755, -0.274895, -2.572963>, <1.759597, -0.274895, -2.459963>, 
      <1.837905, -0.277898, -2.834963>, <1.830972, -0.266072, -2.721045>, <1.797283, -0.243470, -2.573427>, <1.788651, -0.228746, -2.459963>, 
      <1.851424, -0.266430, -2.834963>, <1.844491, -0.254604, -2.721045>, <1.822019, -0.216271, -2.573427>, <1.813387, -0.201547, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.851424, -0.468181, -2.834963>, <1.844491, -0.480007, -2.721045>, <1.822019, -0.518339, -2.573427>, <1.813387, -0.533063, -2.459963>, 
      <1.826986, -0.426494, -2.834963>, <1.820053, -0.438320, -2.721045>, <1.787450, -0.459372, -2.573427>, <1.778818, -0.474096, -2.459963>, 
      <1.813396, -0.359983, -2.834963>, <1.803649, -0.359983, -2.721730>, <1.771755, -0.380013, -2.572963>, <1.759597, -0.380013, -2.459963>, 
      <1.813396, -0.311661, -2.834963>, <1.803649, -0.311661, -2.721730>, <1.771755, -0.311660, -2.572963>, <1.759597, -0.311660, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.533048, -2.834963>, <1.943182, -0.549874, -2.720372>, <1.943182, -0.603910, -2.573880>, <1.943182, -0.624818, -2.459963>, 
      <1.909471, -0.533048, -2.834963>, <1.909471, -0.549874, -2.720372>, <1.895496, -0.603910, -2.573880>, <1.895496, -0.624818, -2.459963>, 
      <1.868473, -0.497263, -2.834963>, <1.861540, -0.509089, -2.721045>, <1.846135, -0.559477, -2.573427>, <1.837504, -0.574201, -2.459963>, 
      <1.851424, -0.468181, -2.834963>, <1.844491, -0.480007, -2.721045>, <1.822019, -0.518339, -2.573427>, <1.813387, -0.533063, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.468181, -2.834963>, <2.041872, -0.480007, -2.721045>, <2.064344, -0.518339, -2.573427>, <2.072976, -0.533063, -2.459963>, 
      <2.017890, -0.497263, -2.834963>, <2.024823, -0.509089, -2.721045>, <2.040228, -0.559477, -2.573427>, <2.048860, -0.574201, -2.459963>, 
      <1.976893, -0.533048, -2.834963>, <1.976893, -0.549874, -2.720372>, <1.990867, -0.603910, -2.573880>, <1.990867, -0.624818, -2.459963>, 
      <1.943182, -0.533048, -2.834963>, <1.943182, -0.549874, -2.720372>, <1.943182, -0.603910, -2.573880>, <1.943182, -0.624818, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072967, -0.311661, -2.834963>, <2.082714, -0.311661, -2.721730>, <2.114608, -0.311660, -2.572963>, <2.126767, -0.311660, -2.459963>, 
      <2.072967, -0.359983, -2.834963>, <2.082714, -0.359983, -2.721730>, <2.114608, -0.380013, -2.572963>, <2.126767, -0.380013, -2.459963>, 
      <2.059377, -0.426494, -2.834963>, <2.066310, -0.438320, -2.721045>, <2.098913, -0.459372, -2.573427>, <2.107545, -0.474096, -2.459963>, 
      <2.034939, -0.468181, -2.834963>, <2.041872, -0.480007, -2.721045>, <2.064344, -0.518339, -2.573427>, <2.072976, -0.533063, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.266430, -2.834963>, <2.041872, -0.254604, -2.721045>, <2.064344, -0.216271, -2.573427>, <2.072976, -0.201547, -2.459963>, 
      <2.048458, -0.277898, -2.834963>, <2.055391, -0.266072, -2.721045>, <2.089080, -0.243470, -2.573427>, <2.097712, -0.228746, -2.459963>, 
      <2.072967, -0.293933, -2.834963>, <2.082714, -0.293933, -2.721730>, <2.114608, -0.274895, -2.572963>, <2.126767, -0.274895, -2.459963>, 
      <2.072967, -0.311661, -2.834963>, <2.082714, -0.311661, -2.721730>, <2.114608, -0.311660, -2.572963>, <2.126767, -0.311660, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.201564, -2.834963>, <1.943182, -0.184738, -2.720372>, <1.943182, -0.130701, -2.573880>, <1.943182, -0.109792, -2.459963>, 
      <1.976893, -0.201564, -2.834963>, <1.976893, -0.184738, -2.720372>, <1.990867, -0.130701, -2.573880>, <1.990867, -0.109792, -2.459963>, 
      <2.009232, -0.244622, -2.834963>, <2.016165, -0.232796, -2.721045>, <2.032261, -0.180992, -2.573427>, <2.040893, -0.166269, -2.459963>, 
      <2.034939, -0.266430, -2.834963>, <2.041872, -0.254604, -2.721045>, <2.064344, -0.216271, -2.573427>, <2.072976, -0.201547, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.201564, -2.834963>, <1.909471, -0.201564, -2.834963>, <1.877131, -0.244622, -2.834963>, <1.851424, -0.266430, -2.834963>, 
      <1.943182, -0.184738, -2.720372>, <1.909471, -0.184738, -2.720372>, <1.870198, -0.232796, -2.721045>, <1.844491, -0.254604, -2.721045>, 
      <1.943182, -0.130701, -2.573880>, <1.895496, -0.130701, -2.573880>, <1.854102, -0.180992, -2.573427>, <1.822019, -0.216271, -2.573427>, 
      <1.943182, -0.109792, -2.459963>, <1.895496, -0.109792, -2.459963>, <1.845470, -0.166269, -2.459963>, <1.813387, -0.201547, -2.459963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813396, -0.311661, -3.084963>, <1.813396, -0.293933, -3.084963>, <1.837905, -0.277897, -3.084963>, <1.851424, -0.266429, -3.084963>, 
      <1.799426, -0.300814, -3.165027>, <1.799426, -0.283086, -3.165027>, <1.827411, -0.252319, -3.170034>, <1.840930, -0.240850, -3.170034>, 
      <1.744452, -0.258128, -3.256310>, <1.744452, -0.215297, -3.256310>, <1.771737, -0.178011, -3.252886>, <1.803244, -0.148997, -3.252886>, 
      <1.726154, -0.243920, -3.334963>, <1.726154, -0.201089, -3.334963>, <1.758237, -0.145107, -3.334962>, <1.789744, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.813396, -0.311661, -3.084963>, <1.826174, -0.321583, -3.011729>, <1.819828, -0.311661, -2.909687>, <1.813396, -0.311661, -2.834963>, 
      <1.813396, -0.293933, -3.084963>, <1.826174, -0.303855, -3.011729>, <1.819828, -0.293933, -2.909687>, <1.813396, -0.293933, -2.834963>, 
      <1.837905, -0.277897, -3.084963>, <1.846704, -0.299344, -3.013636>, <1.842437, -0.285628, -2.909426>, <1.837905, -0.277898, -2.834963>, 
      <1.851424, -0.266429, -3.084963>, <1.860223, -0.287875, -3.013635>, <1.855956, -0.274160, -2.909426>, <1.851424, -0.266430, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.851424, -0.468181, -3.084963>, <1.826986, -0.426494, -3.084963>, <1.813396, -0.359983, -3.084963>, <1.813396, -0.311661, -3.084963>, 
      <1.840050, -0.508395, -3.177165>, <1.815612, -0.466709, -3.177165>, <1.799426, -0.349136, -3.165027>, <1.799426, -0.300814, -3.165027>, 
      <1.803994, -0.635876, -3.248325>, <1.760058, -0.509214, -3.248325>, <1.744452, -0.392194, -3.256310>, <1.744452, -0.258128, -3.256310>, 
      <1.789744, -0.686260, -3.334963>, <1.745807, -0.559598, -3.334963>, <1.726154, -0.377986, -3.334963>, <1.726154, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.851424, -0.468181, -3.084963>, <1.859851, -0.438387, -3.016653>, <1.855956, -0.460451, -2.909426>, <1.851424, -0.468181, -2.834963>, 
      <1.826986, -0.426494, -3.084963>, <1.835412, -0.396700, -3.016653>, <1.831517, -0.418764, -2.909426>, <1.826986, -0.426494, -2.834963>, 
      <1.813396, -0.359983, -3.084963>, <1.826174, -0.369905, -3.011729>, <1.819828, -0.359983, -2.909687>, <1.813396, -0.359983, -2.834963>, 
      <1.813396, -0.311661, -3.084963>, <1.826174, -0.321583, -3.011729>, <1.819828, -0.311661, -2.909687>, <1.813396, -0.311661, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.533048, -3.084963>, <1.909471, -0.533048, -3.084963>, <1.868473, -0.497263, -3.084963>, <1.851424, -0.468181, -3.084963>, 
      <1.943182, -0.603273, -3.189300>, <1.909471, -0.603273, -3.189300>, <1.857099, -0.537478, -3.177165>, <1.840050, -0.508395, -3.177165>, 
      <1.943182, -0.785577, -3.241360>, <1.871465, -0.785577, -3.241360>, <1.827498, -0.703633, -3.248325>, <1.803994, -0.635876, -3.248325>, 
      <1.943182, -0.869577, -3.334963>, <1.871465, -0.869577, -3.334963>, <1.813247, -0.754016, -3.334963>, <1.789744, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.533048, -3.084963>, <1.943182, -0.491171, -3.022743>, <1.943182, -0.522152, -2.909168>, <1.943182, -0.533048, -2.834963>, 
      <1.909471, -0.533048, -3.084963>, <1.909471, -0.491171, -3.022743>, <1.909471, -0.522152, -2.909168>, <1.909471, -0.533048, -2.834963>, 
      <1.868473, -0.497263, -3.084963>, <1.876900, -0.467469, -3.016653>, <1.873005, -0.489533, -2.909426>, <1.868473, -0.497263, -2.834963>, 
      <1.851424, -0.468181, -3.084963>, <1.859851, -0.438387, -3.016653>, <1.855956, -0.460451, -2.909426>, <1.851424, -0.468181, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.468181, -3.084963>, <2.017890, -0.497263, -3.084963>, <1.976893, -0.533048, -3.084963>, <1.943182, -0.533048, -3.084963>, 
      <2.046313, -0.508395, -3.177165>, <2.029264, -0.537478, -3.177165>, <1.976893, -0.603273, -3.189300>, <1.943182, -0.603273, -3.189300>, 
      <2.082370, -0.635876, -3.248325>, <2.058866, -0.703633, -3.248325>, <2.014899, -0.785577, -3.241360>, <1.943182, -0.785577, -3.241360>, 
      <2.096620, -0.686260, -3.334963>, <2.073117, -0.754016, -3.334963>, <2.014899, -0.869577, -3.334963>, <1.943182, -0.869577, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.468181, -3.084963>, <2.026512, -0.438387, -3.016653>, <2.030407, -0.460451, -2.909426>, <2.034939, -0.468181, -2.834963>, 
      <2.017890, -0.497263, -3.084963>, <2.009463, -0.467469, -3.016653>, <2.013358, -0.489533, -2.909426>, <2.017890, -0.497263, -2.834963>, 
      <1.976893, -0.533048, -3.084963>, <1.976893, -0.491171, -3.022743>, <1.976893, -0.522152, -2.909168>, <1.976893, -0.533048, -2.834963>, 
      <1.943182, -0.533048, -3.084963>, <1.943182, -0.491171, -3.022743>, <1.943182, -0.522152, -2.909168>, <1.943182, -0.533048, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072967, -0.311661, -3.084963>, <2.072967, -0.359983, -3.084963>, <2.059377, -0.426494, -3.084963>, <2.034939, -0.468181, -3.084963>, 
      <2.086937, -0.300814, -3.165027>, <2.086937, -0.349136, -3.165027>, <2.070751, -0.466709, -3.177165>, <2.046313, -0.508395, -3.177165>, 
      <2.141912, -0.258128, -3.256310>, <2.141912, -0.392194, -3.256310>, <2.126306, -0.509214, -3.248325>, <2.082370, -0.635876, -3.248325>, 
      <2.160210, -0.243920, -3.334963>, <2.160210, -0.377986, -3.334963>, <2.140557, -0.559598, -3.334963>, <2.096620, -0.686260, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.072967, -0.311661, -3.084963>, <2.060189, -0.321583, -3.011729>, <2.066535, -0.311661, -2.909687>, <2.072967, -0.311661, -2.834963>, 
      <2.072967, -0.359983, -3.084963>, <2.060189, -0.369905, -3.011729>, <2.066535, -0.359983, -2.909687>, <2.072967, -0.359983, -2.834963>, 
      <2.059377, -0.426494, -3.084963>, <2.050951, -0.396700, -3.016653>, <2.054846, -0.418764, -2.909426>, <2.059377, -0.426494, -2.834963>, 
      <2.034939, -0.468181, -3.084963>, <2.026512, -0.438387, -3.016653>, <2.030407, -0.460451, -2.909426>, <2.034939, -0.468181, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.266429, -3.084963>, <2.048458, -0.277897, -3.084963>, <2.072967, -0.293933, -3.084963>, <2.072967, -0.311661, -3.084963>, 
      <2.045434, -0.240850, -3.170034>, <2.058953, -0.252319, -3.170034>, <2.086937, -0.283086, -3.165027>, <2.086937, -0.300814, -3.165027>, 
      <2.083120, -0.148997, -3.252886>, <2.114627, -0.178011, -3.252886>, <2.141912, -0.215297, -3.256310>, <2.141912, -0.258128, -3.256310>, 
      <2.096620, -0.116093, -3.334962>, <2.128127, -0.145107, -3.334962>, <2.160210, -0.201089, -3.334963>, <2.160210, -0.243920, -3.334963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.034939, -0.266429, -3.084963>, <2.026140, -0.287875, -3.013635>, <2.030407, -0.274160, -2.909426>, <2.034939, -0.266430, -2.834963>, 
      <2.048458, -0.277897, -3.084963>, <2.039659, -0.299344, -3.013636>, <2.043926, -0.285628, -2.909426>, <2.048458, -0.277898, -2.834963>, 
      <2.072967, -0.293933, -3.084963>, <2.060189, -0.303855, -3.011729>, <2.066535, -0.293933, -2.909687>, <2.072967, -0.293933, -2.834963>, 
      <2.072967, -0.311661, -3.084963>, <2.060189, -0.321583, -3.011729>, <2.066535, -0.311661, -2.909687>, <2.072967, -0.311661, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.201564, -3.084962>, <1.976893, -0.201564, -3.084962>, <2.009232, -0.244622, -3.084963>, <2.034939, -0.266429, -3.084963>, 
      <1.943182, -0.174931, -3.169509>, <1.976893, -0.174931, -3.169509>, <2.019727, -0.219043, -3.170034>, <2.045434, -0.240850, -3.170034>, 
      <1.943182, -0.078389, -3.253235>, <1.994033, -0.078389, -3.253235>, <2.045713, -0.114550, -3.252886>, <2.083120, -0.148997, -3.252886>, 
      <1.943182, -0.044064, -3.334962>, <1.994033, -0.044064, -3.334962>, <2.059214, -0.081646, -3.334962>, <2.096620, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.201564, -3.084962>, <1.943182, -0.224098, -3.013427>, <1.943182, -0.212460, -2.909167>, <1.943182, -0.201564, -2.834963>, 
      <1.976893, -0.201564, -3.084962>, <1.976893, -0.224098, -3.013427>, <1.976893, -0.212460, -2.909167>, <1.976893, -0.201564, -2.834963>, 
      <2.009232, -0.244622, -3.084963>, <2.000433, -0.266068, -3.013635>, <2.004700, -0.252353, -2.909426>, <2.009232, -0.244622, -2.834963>, 
      <2.034939, -0.266429, -3.084963>, <2.026140, -0.287875, -3.013635>, <2.030407, -0.274160, -2.909426>, <2.034939, -0.266430, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.201564, -3.084962>, <1.943182, -0.174931, -3.169509>, <1.943182, -0.078389, -3.253235>, <1.943182, -0.044064, -3.334962>, 
      <1.909471, -0.201564, -3.084962>, <1.909471, -0.174931, -3.169509>, <1.892331, -0.078389, -3.253235>, <1.892331, -0.044064, -3.334962>, 
      <1.877131, -0.244622, -3.084963>, <1.866637, -0.219043, -3.170034>, <1.840650, -0.114550, -3.252886>, <1.827151, -0.081646, -3.334962>, 
      <1.851424, -0.266429, -3.084963>, <1.840930, -0.240850, -3.170034>, <1.803244, -0.148997, -3.252886>, <1.789744, -0.116093, -3.334962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.943182, -0.201564, -3.084962>, <1.909471, -0.201564, -3.084962>, <1.877131, -0.244622, -3.084963>, <1.851424, -0.266429, -3.084963>, 
      <1.943182, -0.224098, -3.013427>, <1.909471, -0.224098, -3.013427>, <1.885930, -0.266068, -3.013635>, <1.860223, -0.287875, -3.013635>, 
      <1.943182, -0.212460, -2.909167>, <1.909471, -0.212460, -2.909167>, <1.881663, -0.252352, -2.909426>, <1.855956, -0.274160, -2.909426>, 
      <1.943182, -0.201564, -2.834963>, <1.909471, -0.201564, -2.834963>, <1.877131, -0.244622, -2.834963>, <1.851424, -0.266430, -2.834963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, -0.417859, -0.720530>, <1.250000, -0.359018, -0.684748>, <1.222831, -0.266507, -0.623363>, <1.271527, -0.224900, -0.598062>, 
      <1.260394, -0.362850, -0.801369>, <1.260394, -0.304009, -0.765587>, <1.249059, -0.206227, -0.739991>, <1.297755, -0.164620, -0.714689>, 
      <1.199860, -0.242681, -0.882756>, <1.197690, -0.178932, -0.881160>, <1.217376, -0.103133, -0.844893>, <1.266128, -0.073418, -0.873382>, 
      <1.186386, -0.226292, -0.978770>, <1.184216, -0.162542, -0.977174>, <1.222775, -0.062350, -0.972295>, <1.271527, -0.032635, -1.000783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.658803, -0.861924>, <1.214915, -0.601388, -0.838167>, <1.250000, -0.489680, -0.764205>, <1.250000, -0.417859, -0.720530>, 
      <1.274226, -0.636087, -0.902987>, <1.217613, -0.578672, -0.879230>, <1.260394, -0.434671, -0.845044>, <1.260394, -0.362850, -0.801369>, 
      <1.290115, -0.672006, -0.969885>, <1.195693, -0.585711, -0.920088>, <1.204528, -0.379825, -0.886188>, <1.199860, -0.242681, -0.882756>, 
      <1.293207, -0.669581, -1.016725>, <1.198785, -0.583286, -0.966928>, <1.191054, -0.363436, -0.982202>, <1.186386, -0.226292, -0.978770>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.271527, -0.658803, -0.861924>, <1.267036, -0.696610, -0.793583>, <1.268231, -0.851974, -0.683512>, <1.271527, -0.852068, -0.686855>, 
      <1.214915, -0.601388, -0.838167>, <1.210423, -0.639195, -0.769826>, <1.231360, -0.743495, -0.690656>, <1.234656, -0.743589, -0.693998>, 
      <1.250000, -0.489680, -0.764205>, <1.240961, -0.537519, -0.693904>, <1.210293, -0.618714, -0.612598>, <1.151197, -0.647541, -0.557923>, 
      <1.250000, -0.417859, -0.720530>, <1.240961, -0.465698, -0.650228>, <1.184134, -0.522147, -0.556306>, <1.125038, -0.550974, -0.501632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.798176, -0.877897>, <1.510922, -0.799320, -0.876938>, <1.348364, -0.736729, -0.894168>, <1.271527, -0.658803, -0.861924>, 
      <1.624953, -0.744787, -0.976450>, <1.510874, -0.745931, -0.975490>, <1.351063, -0.714013, -0.935231>, <1.274226, -0.636087, -0.902987>, 
      <1.602713, -0.681896, -1.114796>, <1.487132, -0.689313, -1.116776>, <1.369795, -0.744829, -1.011907>, <1.290115, -0.672006, -0.969885>, 
      <1.624764, -0.626941, -1.209963>, <1.509183, -0.634358, -1.211943>, <1.372888, -0.742404, -1.058747>, <1.293207, -0.669581, -1.016725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.651715, -0.867869>, <1.901141, -0.730144, -0.900321>, <1.739814, -0.797025, -0.878863>, <1.625000, -0.798176, -0.877897>, 
      <1.974296, -0.636578, -0.908392>, <1.896964, -0.715007, -0.940844>, <1.739767, -0.743636, -0.977415>, <1.624953, -0.744787, -0.976450>, 
      <1.943733, -0.629660, -0.962332>, <1.865563, -0.701047, -1.001329>, <1.715281, -0.674673, -1.112868>, <1.602713, -0.681896, -1.114796>, 
      <1.940461, -0.628047, -1.005637>, <1.862291, -0.699433, -1.044634>, <1.737332, -0.619718, -1.208035>, <1.624764, -0.626941, -1.209963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, -0.417859, -0.720530>, <2.000000, -0.488922, -0.763745>, <2.034488, -0.594906, -0.844363>, <1.978473, -0.651715, -0.867869>, 
      <1.989235, -0.362129, -0.804390>, <1.989235, -0.433192, -0.847604>, <2.030311, -0.579769, -0.884885>, <1.974296, -0.636578, -0.908392>, 
      <2.050682, -0.243297, -0.892097>, <2.042646, -0.369164, -0.891271>, <2.031126, -0.549852, -0.918734>, <1.943733, -0.629660, -0.962332>, 
      <2.063486, -0.226292, -0.991097>, <2.055451, -0.352159, -0.990271>, <2.027854, -0.548238, -0.962039>, <1.940461, -0.628047, -1.005637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.000000, -0.417859, -0.720530>, <2.008738, -0.463091, -0.652466>, <2.079176, -0.511490, -0.571941>, <2.124962, -0.544535, -0.512219>, 
      <2.000000, -0.488922, -0.763745>, <2.008738, -0.534155, -0.695681>, <2.079176, -0.587263, -0.616601>, <2.124962, -0.620308, -0.556879>, 
      <2.034488, -0.594906, -0.844363>, <2.041916, -0.621827, -0.772294>, <1.968627, -0.677857, -0.714684>, <2.010648, -0.685036, -0.650213>, 
      <1.978473, -0.651715, -0.867869>, <1.985902, -0.678636, -0.795801>, <1.936452, -0.758621, -0.701343>, <1.978473, -0.765800, -0.636872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.220347, -0.605548>, <2.027169, -0.261954, -0.630850>, <2.000000, -0.359018, -0.684748>, <2.000000, -0.417859, -0.720530>, 
      <1.978473, -0.159228, -0.724396>, <2.027169, -0.200835, -0.749698>, <1.989235, -0.303289, -0.768608>, <1.989235, -0.362129, -0.804390>, 
      <1.984630, -0.072994, -0.882291>, <2.033770, -0.102922, -0.854979>, <2.054739, -0.179738, -0.892514>, <2.050682, -0.243297, -0.892097>, 
      <1.978473, -0.032635, -1.009545>, <2.027613, -0.062563, -0.982233>, <2.067544, -0.162733, -0.991514>, <2.063486, -0.226292, -0.991097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.978473, -0.220347, -0.605548>, <1.978473, -0.254647, -0.538851>, <1.978473, -0.311275, -0.456025>, <1.978473, -0.350244, -0.391944>, 
      <2.027169, -0.261954, -0.630850>, <2.027169, -0.296254, -0.564152>, <2.004514, -0.341708, -0.526922>, <2.004514, -0.380677, -0.462841>, 
      <2.000000, -0.359018, -0.684748>, <2.008738, -0.404251, -0.616684>, <2.079176, -0.441339, -0.530594>, <2.124962, -0.474384, -0.470872>, 
      <2.000000, -0.417859, -0.720530>, <2.008738, -0.463091, -0.652466>, <2.079176, -0.511490, -0.571941>, <2.124962, -0.544535, -0.512219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.097451, -0.525686>, <1.739788, -0.096712, -0.526902>, <1.897300, -0.150991, -0.563372>, <1.978473, -0.220347, -0.605548>, 
      <1.624947, -0.036941, -0.733856>, <1.739734, -0.036201, -0.735071>, <1.897300, -0.089872, -0.682220>, <1.978473, -0.159228, -0.724396>, 
      <1.596636, 0.038683, -1.019995>, <1.724371, 0.038683, -1.021578>, <1.886068, -0.012966, -0.937071>, <1.984630, -0.072994, -0.882291>, 
      <1.624764, 0.040906, -1.234937>, <1.752499, 0.040906, -1.236520>, <1.879911, 0.027393, -1.064326>, <1.978473, -0.032635, -1.009545>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.097451, -0.525686>, <1.624947, -0.036941, -0.733856>, <1.596636, 0.038683, -1.019995>, <1.624764, 0.040906, -1.234937>, 
      <1.510212, -0.098190, -0.524470>, <1.510159, -0.037680, -0.732640>, <1.467607, 0.038683, -1.018396>, <1.495735, 0.040906, -1.233338>, 
      <1.352700, -0.155544, -0.555886>, <1.378928, -0.095264, -0.672513>, <1.364721, -0.013324, -0.930994>, <1.370120, 0.027459, -1.058396>, 
      <1.271527, -0.224900, -0.598062>, <1.297755, -0.164620, -0.714689>, <1.266128, -0.073418, -0.873382>, <1.271527, -0.032635, -1.000783>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, -0.347048, -0.392467>, <1.195267, -0.307661, -0.432650>, <1.255335, -0.262115, -0.526060>, <1.271527, -0.224900, -0.598062>, 
      <1.133167, -0.378075, -0.454585>, <1.193710, -0.338689, -0.494768>, <1.206639, -0.303721, -0.551362>, <1.222831, -0.266507, -0.623363>, 
      <1.109212, -0.492550, -0.467575>, <1.168308, -0.463723, -0.522250>, <1.240961, -0.406857, -0.614446>, <1.250000, -0.359018, -0.684748>, 
      <1.125038, -0.550974, -0.501632>, <1.184134, -0.522147, -0.556306>, <1.240961, -0.465698, -0.650228>, <1.250000, -0.417859, -0.720530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, -0.347048, -0.392467>, <1.133167, -0.378075, -0.454585>, <1.109212, -0.492550, -0.467575>, <1.125038, -0.550974, -0.501632>, 
      <1.109444, -0.363494, -0.375688>, <1.107887, -0.394521, -0.437806>, <1.089685, -0.502075, -0.449510>, <1.105511, -0.560499, -0.483566>, 
      <1.058371, -0.381820, -0.415788>, <1.070305, -0.399696, -0.460463>, <1.061097, -0.490207, -0.483060>, <1.057398, -0.533048, -0.507735>, 
      <1.035455, -0.378479, -0.441377>, <1.047389, -0.396356, -0.486053>, <1.042739, -0.477922, -0.500681>, <1.039041, -0.520763, -0.525356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.893800, -0.717360>, <1.518880, -0.906750, -0.724863>, <1.377569, -0.864588, -0.696007>, <1.271527, -0.852068, -0.686855>, 
      <1.625000, -0.864861, -0.765370>, <1.518880, -0.877811, -0.772873>, <1.374273, -0.864494, -0.692664>, <1.268231, -0.851974, -0.683512>, 
      <1.625024, -0.824878, -0.828608>, <1.510945, -0.826021, -0.827648>, <1.343872, -0.774536, -0.825827>, <1.267036, -0.696610, -0.793583>, 
      <1.625000, -0.798176, -0.877897>, <1.510922, -0.799320, -0.876938>, <1.348364, -0.736729, -0.894168>, <1.271527, -0.658803, -0.861924>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.893800, -0.717360>, <1.625000, -0.864861, -0.765370>, <1.625024, -0.824878, -0.828608>, <1.625000, -0.798176, -0.877897>, 
      <1.739206, -0.879864, -0.709285>, <1.739206, -0.850925, -0.757296>, <1.739838, -0.823727, -0.829573>, <1.739814, -0.797025, -0.878863>, 
      <1.872431, -0.804200, -0.661018>, <1.830410, -0.797021, -0.725489>, <1.908569, -0.757065, -0.828253>, <1.901141, -0.730144, -0.900321>, 
      <1.978473, -0.765800, -0.636872>, <1.936452, -0.758621, -0.701343>, <1.985902, -0.678636, -0.795801>, <1.978473, -0.651715, -0.867869>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.227347, -0.312081>, <1.739796, -0.227782, -0.312010>, <1.870505, -0.314253, -0.376919>, <1.978473, -0.350244, -0.391944>, 
      <1.625000, -0.192165, -0.378317>, <1.739796, -0.192600, -0.378246>, <1.870505, -0.275284, -0.441000>, <1.978473, -0.311275, -0.456025>, 
      <1.625018, -0.118385, -0.453667>, <1.739806, -0.117646, -0.454882>, <1.897300, -0.185291, -0.496675>, <1.978473, -0.254647, -0.538851>, 
      <1.625000, -0.097451, -0.525686>, <1.739788, -0.096712, -0.526902>, <1.897300, -0.150991, -0.563372>, <1.978473, -0.220347, -0.605548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.227347, -0.312081>, <1.625000, -0.192165, -0.378317>, <1.625018, -0.118385, -0.453667>, <1.625000, -0.097451, -0.525686>, 
      <1.471690, -0.226766, -0.312176>, <1.471690, -0.191585, -0.378412>, <1.510231, -0.119125, -0.452451>, <1.510212, -0.098190, -0.524470>, 
      <1.281807, -0.311138, -0.368351>, <1.342350, -0.271751, -0.408534>, <1.336508, -0.192759, -0.483884>, <1.352700, -0.155544, -0.555886>, 
      <1.134724, -0.347048, -0.392467>, <1.195267, -0.307661, -0.432650>, <1.255335, -0.262115, -0.526060>, <1.271527, -0.224900, -0.598062>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, -0.357908, -0.115106>, <1.114528, -0.315933, -0.184131>, <1.136590, -0.309847, -0.317990>, <1.134724, -0.347048, -0.392467>, 
      <1.066907, -0.366503, -0.136984>, <1.046711, -0.324528, -0.206009>, <1.111310, -0.326294, -0.301211>, <1.109444, -0.363494, -0.375688>, 
      <1.011859, -0.429520, -0.219396>, <1.028860, -0.403397, -0.263047>, <1.045459, -0.362480, -0.367454>, <1.058371, -0.381820, -0.415788>, 
      <0.973384, -0.422414, -0.279569>, <0.990386, -0.396291, -0.323219>, <1.022544, -0.359139, -0.393044>, <1.035455, -0.378479, -0.441377>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.134724, -0.357908, -0.115106>, <1.066907, -0.366503, -0.136984>, <1.011859, -0.429520, -0.219396>, <0.973384, -0.422414, -0.279569>, 
      <1.157738, -0.405739, -0.036450>, <1.089922, -0.414334, -0.058328>, <0.996278, -0.453461, -0.179393>, <0.957803, -0.446354, -0.239566>, 
      <1.238296, -0.514649, 0.027957>, <1.142397, -0.487288, -0.035901>, <1.018038, -0.529404, -0.092909>, <0.946667, -0.493258, -0.180217>, 
      <1.259724, -0.606839, 0.034743>, <1.163826, -0.579477, -0.029115>, <1.002221, -0.575351, -0.085504>, <0.930850, -0.539205, -0.172812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.023696, -0.503755>, <1.625000, -1.005450, -0.576502>, <1.625000, -0.932518, -0.653127>, <1.625000, -0.893800, -0.717360>, 
      <1.736694, -1.012681, -0.500315>, <1.736694, -0.994434, -0.573062>, <1.739206, -0.918581, -0.645052>, <1.739206, -0.879864, -0.709285>, 
      <1.873923, -0.952466, -0.459235>, <1.892952, -0.931787, -0.524303>, <1.846503, -0.869282, -0.650267>, <1.872431, -0.804200, -0.661018>, 
      <1.978473, -0.912244, -0.451477>, <1.997503, -0.891565, -0.516545>, <1.952545, -0.830882, -0.626121>, <1.978473, -0.765800, -0.636872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.023696, -0.503755>, <1.518398, -1.034209, -0.507038>, <1.371254, -1.021183, -0.474547>, <1.271527, -0.981964, -0.473251>, 
      <1.625000, -1.005450, -0.576502>, <1.518398, -1.015963, -0.579785>, <1.354018, -1.015304, -0.547302>, <1.254290, -0.976084, -0.546006>, 
      <1.625000, -0.932518, -0.653127>, <1.518880, -0.945468, -0.660629>, <1.401658, -0.935460, -0.691340>, <1.295616, -0.922941, -0.682188>, 
      <1.625000, -0.893800, -0.717360>, <1.518880, -0.906750, -0.724863>, <1.377569, -0.864588, -0.696007>, <1.271527, -0.852068, -0.686855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.023696, -0.503755>, <1.736694, -1.012681, -0.500315>, <1.873923, -0.952466, -0.459235>, <1.978473, -0.912244, -0.451477>, 
      <1.625000, -1.045165, -0.418160>, <1.736694, -1.034149, -0.414720>, <1.851966, -0.976325, -0.384159>, <1.956516, -0.936103, -0.376401>, 
      <1.625000, -1.008801, -0.296990>, <1.701882, -1.009967, -0.305440>, <1.806094, -0.958901, -0.285542>, <1.874636, -0.923045, -0.285498>, 
      <1.625000, -1.021152, -0.209612>, <1.701882, -1.022317, -0.218062>, <1.784931, -0.937488, -0.209507>, <1.853473, -0.901632, -0.209462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -1.023696, -0.503755>, <1.625000, -1.045165, -0.418160>, <1.625000, -1.008801, -0.296990>, <1.625000, -1.021152, -0.209612>, 
      <1.518398, -1.034209, -0.507038>, <1.518398, -1.055678, -0.421444>, <1.545704, -1.007600, -0.288274>, <1.545704, -1.019950, -0.200896>, 
      <1.371254, -1.021183, -0.474547>, <1.395321, -1.029393, -0.372962>, <1.473163, -0.976086, -0.269286>, <1.465069, -0.932641, -0.174349>, 
      <1.271527, -0.981964, -0.473251>, <1.295594, -0.990173, -0.371667>, <1.404622, -0.938152, -0.254173>, <1.396527, -0.894707, -0.159237>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.339830, -0.069359>, <1.625000, -0.298131, -0.137931>, <1.625000, -0.264994, -0.241203>, <1.625000, -0.227347, -0.312081>, 
      <1.477204, -0.337127, -0.069659>, <1.477204, -0.295428, -0.138231>, <1.471690, -0.264413, -0.241298>, <1.471690, -0.226766, -0.312176>, 
      <1.274394, -0.340207, -0.070049>, <1.254197, -0.298232, -0.139074>, <1.283673, -0.273937, -0.293874>, <1.281807, -0.311138, -0.368351>, 
      <1.134724, -0.357908, -0.115106>, <1.114528, -0.315933, -0.184131>, <1.136590, -0.309847, -0.317990>, <1.134724, -0.347048, -0.392467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.339830, -0.069359>, <1.732315, -0.341792, -0.069141>, <1.876997, -0.355423, -0.083355>, <1.978473, -0.373337, -0.113391>, 
      <1.625000, -0.298131, -0.137931>, <1.732315, -0.300093, -0.137713>, <1.897334, -0.313155, -0.152862>, <1.998810, -0.331070, -0.182897>, 
      <1.625000, -0.264994, -0.241203>, <1.739796, -0.265429, -0.241132>, <1.843689, -0.282915, -0.303912>, <1.951657, -0.318905, -0.318937>, 
      <1.625000, -0.227347, -0.312081>, <1.739796, -0.227782, -0.312010>, <1.870505, -0.314253, -0.376919>, <1.978473, -0.350244, -0.391944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.339830, -0.069359>, <1.477204, -0.337127, -0.069659>, <1.274394, -0.340207, -0.070049>, <1.134724, -0.357908, -0.115106>, 
      <1.625000, -0.376630, -0.008844>, <1.477204, -0.373927, -0.009145>, <1.297408, -0.388038, 0.008607>, <1.157738, -0.405739, -0.036450>, 
      <1.625000, -0.445231, 0.058033>, <1.507191, -0.444597, 0.057929>, <1.347879, -0.478739, 0.052073>, <1.238296, -0.514649, 0.027957>, 
      <1.625000, -0.487139, 0.115129>, <1.507191, -0.486505, 0.115025>, <1.369307, -0.570929, 0.058859>, <1.259724, -0.606839, 0.034743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.625000, -0.339830, -0.069359>, <1.625000, -0.376630, -0.008844>, <1.625000, -0.445231, 0.058033>, <1.625000, -0.487139, 0.115129>, 
      <1.732315, -0.341792, -0.069141>, <1.732315, -0.378592, -0.008626>, <1.706432, -0.445670, 0.058105>, <1.706432, -0.487577, 0.115201>, 
      <1.876997, -0.355423, -0.083355>, <1.854719, -0.401724, -0.007215>, <1.799698, -0.512723, 0.058978>, <1.778465, -0.601823, 0.065888>, 
      <1.978473, -0.373337, -0.113391>, <1.956195, -0.419639, -0.037251>, <1.874706, -0.520934, 0.028356>, <1.853473, -0.610035, 0.035266>
    }
  }
  texture {
    yellowstuff
  }
}
union { // radguy_balcony
  object { sPatchObj3 }
  object { sPatchObj4 }
  scale 4.1
  rotate -90.0*z
  translate  <21.8603, 33.816959, 14.4>
}


union { // sPatchObj5
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.120736, 5.137410, 0.000000>, <61.120736, 5.137410, 0.114797>, <61.156070, 5.082464, 0.272327>, <61.199968, 5.014185, 0.353500>, 
      <58.721402, 2.585460, 0.000000>, <58.721402, 2.585460, 0.114797>, <58.756736, 2.530514, 0.272327>, <58.800634, 2.462235, 0.353500>, 
      <56.154163, -1.613803, 0.000000>, <56.154163, -1.613803, 0.114796>, <56.198554, -1.684488, 0.272327>, <56.242458, -1.752767, 0.353500>, 
      <53.122957, -3.369088, 0.000000>, <53.122957, -3.369088, 0.114796>, <53.158288, -3.424034, 0.272327>, <53.202186, -3.492313, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.199968, 5.014185, -0.353500>, <61.156070, 5.082464, -0.272327>, <61.120736, 5.137410, -0.114797>, <61.120736, 5.137410, 0.000000>, 
      <58.800634, 2.462235, -0.353500>, <58.756736, 2.530514, -0.272327>, <58.721402, 2.585460, -0.114797>, <58.721402, 2.585460, 0.000000>, 
      <56.242458, -1.752767, -0.353500>, <56.198554, -1.684488, -0.272327>, <56.154163, -1.613803, -0.114796>, <56.154163, -1.613803, 0.000000>, 
      <53.202186, -3.492313, -0.353500>, <53.158288, -3.424034, -0.272327>, <53.122957, -3.369088, -0.114796>, <53.122957, -3.369088, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.391136, 4.716836, -0.500000>, <61.329056, 4.813398, -0.500000>, <61.243872, 4.945906, -0.434673>, <61.199968, 5.014185, -0.353500>, 
      <58.991802, 2.164886, -0.500000>, <58.929722, 2.261448, -0.500000>, <58.844538, 2.393957, -0.434673>, <58.800634, 2.462235, -0.353500>, 
      <56.454522, -2.087162, -0.500000>, <56.392442, -1.990601, -0.500000>, <56.286349, -1.821046, -0.434673>, <56.242458, -1.752767, -0.353500>, 
      <53.393354, -3.789662, -0.500000>, <53.331274, -3.693100, -0.500000>, <53.246083, -3.560592, -0.434673>, <53.202186, -3.492313, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.582304, 4.419486, -0.353500>, <61.538406, 4.487766, -0.434673>, <61.453216, 4.620274, -0.500000>, <61.391136, 4.716836, -0.500000>, 
      <59.182970, 1.867536, -0.353500>, <59.139072, 1.935816, -0.434673>, <59.053882, 2.068324, -0.500000>, <58.991802, 2.164886, -0.500000>, 
      <56.665306, -2.420278, -0.353500>, <56.621408, -2.351998, -0.434673>, <56.516602, -2.183725, -0.500000>, <56.454522, -2.087162, -0.500000>, 
      <53.584518, -4.087013, -0.353500>, <53.540624, -4.018732, -0.434673>, <53.455434, -3.886224, -0.500000>, <53.393354, -3.789662, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.661530, 4.296251, 0.000000>, <61.661530, 4.296251, -0.114797>, <61.626195, 4.351205, -0.272327>, <61.582304, 4.419486, -0.353500>, 
      <59.262195, 1.744302, 0.000000>, <59.262195, 1.744302, -0.114797>, <59.226861, 1.799255, -0.272327>, <59.182970, 1.867536, -0.353500>, 
      <56.752314, -2.557970, 0.000000>, <56.752314, -2.557970, -0.114797>, <56.709203, -2.488559, -0.272327>, <56.665306, -2.420278, -0.353500>, 
      <53.663747, -4.210246, 0.000000>, <53.663747, -4.210246, -0.114797>, <53.628413, -4.155294, -0.272327>, <53.584518, -4.087013, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.582304, 4.419486, 0.353500>, <61.626195, 4.351205, 0.272327>, <61.661530, 4.296251, 0.114797>, <61.661530, 4.296251, 0.000000>, 
      <59.182970, 1.867536, 0.353500>, <59.226861, 1.799255, 0.272327>, <59.262195, 1.744302, 0.114797>, <59.262195, 1.744302, 0.000000>, 
      <56.665306, -2.420278, 0.353500>, <56.709203, -2.488559, 0.272327>, <56.752314, -2.557970, 0.114797>, <56.752314, -2.557970, 0.000000>, 
      <53.584518, -4.087013, 0.353500>, <53.628413, -4.155294, 0.272327>, <53.663747, -4.210246, 0.114797>, <53.663747, -4.210246, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.391136, 4.716836, 0.500000>, <61.453216, 4.620274, 0.500000>, <61.538406, 4.487766, 0.434673>, <61.582304, 4.419486, 0.353500>, 
      <58.991802, 2.164886, 0.500000>, <59.053882, 2.068324, 0.500000>, <59.139072, 1.935816, 0.434673>, <59.182970, 1.867536, 0.353500>, 
      <56.454522, -2.087162, 0.500000>, <56.516602, -2.183725, 0.500000>, <56.621408, -2.351998, 0.434673>, <56.665306, -2.420278, 0.353500>, 
      <53.393354, -3.789662, 0.500000>, <53.455434, -3.886224, 0.500000>, <53.540624, -4.018732, 0.434673>, <53.584518, -4.087013, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <61.391136, 4.716836, 0.500000>, <58.991802, 2.164886, 0.500000>, <56.454522, -2.087162, 0.500000>, <53.393354, -3.789662, 0.500000>, 
      <61.329056, 4.813398, 0.500000>, <58.929722, 2.261448, 0.500000>, <56.392442, -1.990601, 0.500000>, <53.331274, -3.693100, 0.500000>, 
      <61.243872, 4.945906, 0.434673>, <58.844538, 2.393957, 0.434673>, <56.286349, -1.821046, 0.434673>, <53.246083, -3.560592, 0.434673>, 
      <61.199968, 5.014185, 0.353500>, <58.800634, 2.462235, 0.353500>, <56.242458, -1.752767, 0.353500>, <53.202186, -3.492313, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.579917, -2.703683, 0.000000>, <48.455158, -4.131647, 0.000000>, <51.673571, -4.208383, 0.000000>, <53.122957, -3.369088, 0.000000>, 
      <47.579917, -2.703683, 0.114797>, <48.455158, -4.131647, 0.114797>, <51.673571, -4.208383, 0.114796>, <53.122957, -3.369088, 0.114796>, 
      <47.543571, -2.757970, 0.272327>, <48.450109, -4.222960, 0.272327>, <51.662963, -4.279612, 0.272327>, <53.158288, -3.424034, 0.272327>, 
      <47.498406, -2.825418, 0.353500>, <48.404941, -4.290409, 0.353500>, <51.706864, -4.347890, 0.353500>, <53.202186, -3.492313, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.498406, -2.825418, -0.353500>, <48.404941, -4.290409, -0.353500>, <51.706864, -4.347890, -0.353500>, <53.202186, -3.492313, -0.353500>, 
      <47.543571, -2.757970, -0.272327>, <48.450109, -4.222960, -0.272327>, <51.662963, -4.279612, -0.272327>, <53.158288, -3.424034, -0.272327>, 
      <47.579917, -2.703683, -0.114797>, <48.455158, -4.131647, -0.114797>, <51.673571, -4.208383, -0.114796>, <53.122957, -3.369088, -0.114796>, 
      <47.579917, -2.703683, 0.000000>, <48.455158, -4.131647, 0.000000>, <51.673571, -4.208383, 0.000000>, <53.122957, -3.369088, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.301712, -3.119142, -0.500000>, <48.284989, -4.672642, -0.500000>, <51.786602, -4.683274, -0.500000>, <53.393354, -3.789662, -0.500000>, 
      <47.365584, -3.023758, -0.500000>, <48.348861, -4.577257, -0.500000>, <51.724522, -4.586712, -0.500000>, <53.331274, -3.693100, -0.500000>, 
      <47.453238, -2.892866, -0.434673>, <48.359776, -4.357857, -0.434673>, <51.750758, -4.416169, -0.434673>, <53.246083, -3.560592, -0.434673>, 
      <47.498406, -2.825418, -0.353500>, <48.404941, -4.290409, -0.353500>, <51.706864, -4.347890, -0.353500>, <53.202186, -3.492313, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.105018, -3.412863, -0.353500>, <48.166701, -5.053681, -0.353500>, <51.865610, -5.016960, -0.353500>, <53.584518, -4.087013, -0.353500>, 
      <47.150186, -3.345417, -0.434673>, <48.211869, -4.986235, -0.434673>, <51.821712, -4.948680, -0.434673>, <53.540624, -4.018732, -0.434673>, 
      <47.237840, -3.214526, -0.500000>, <48.221114, -4.768025, -0.500000>, <51.848682, -4.779836, -0.500000>, <53.455434, -3.886224, -0.500000>, 
      <47.301712, -3.119142, -0.500000>, <48.284989, -4.672642, -0.500000>, <51.786602, -4.683274, -0.500000>, <53.393354, -3.789662, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.023507, -3.534592, 0.000000>, <48.118157, -5.211248, 0.000000>, <51.898160, -5.154776, 0.000000>, <53.663747, -4.210246, 0.000000>, 
      <47.023507, -3.534592, -0.114796>, <48.118157, -5.211248, -0.114796>, <51.898160, -5.154776, -0.114797>, <53.663747, -4.210246, -0.114797>, 
      <47.059853, -3.480310, -0.272327>, <48.121536, -5.121128, -0.272327>, <51.909504, -5.085241, -0.272327>, <53.628413, -4.155294, -0.272327>, 
      <47.105018, -3.412863, -0.353500>, <48.166701, -5.053681, -0.353500>, <51.865610, -5.016960, -0.353500>, <53.584518, -4.087013, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.105018, -3.412863, 0.353500>, <48.166701, -5.053681, 0.353500>, <51.865610, -5.016960, 0.353500>, <53.584518, -4.087013, 0.353500>, 
      <47.059853, -3.480310, 0.272327>, <48.121536, -5.121128, 0.272327>, <51.909504, -5.085241, 0.272327>, <53.628413, -4.155294, 0.272327>, 
      <47.023507, -3.534592, 0.114796>, <48.118157, -5.211248, 0.114796>, <51.898160, -5.154776, 0.114797>, <53.663747, -4.210246, 0.114797>, 
      <47.023507, -3.534592, 0.000000>, <48.118157, -5.211248, 0.000000>, <51.898160, -5.154776, 0.000000>, <53.663747, -4.210246, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.301712, -3.119142, 0.500000>, <48.284989, -4.672642, 0.500000>, <51.786602, -4.683274, 0.500000>, <53.393354, -3.789662, 0.500000>, 
      <47.237840, -3.214526, 0.500000>, <48.221114, -4.768025, 0.500000>, <51.848682, -4.779836, 0.500000>, <53.455434, -3.886224, 0.500000>, 
      <47.150186, -3.345417, 0.434673>, <48.211869, -4.986235, 0.434673>, <51.821712, -4.948680, 0.434673>, <53.540624, -4.018732, 0.434673>, 
      <47.105018, -3.412863, 0.353500>, <48.166701, -5.053681, 0.353500>, <51.865610, -5.016960, 0.353500>, <53.584518, -4.087013, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <47.301712, -3.119142, 0.500000>, <47.365584, -3.023758, 0.500000>, <47.453238, -2.892866, 0.434673>, <47.498406, -2.825418, 0.353500>, 
      <48.284989, -4.672642, 0.500000>, <48.348861, -4.577257, 0.500000>, <48.359776, -4.357857, 0.434673>, <48.404941, -4.290409, 0.353500>, 
      <51.786602, -4.683274, 0.500000>, <51.724522, -4.586712, 0.500000>, <51.750758, -4.416169, 0.434673>, <51.706864, -4.347890, 0.353500>, 
      <53.393354, -3.789662, 0.500000>, <53.331274, -3.693100, 0.500000>, <53.246083, -3.560592, 0.434673>, <53.202186, -3.492313, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <35.441107, 25.479059, 0.000000>, <41.748544, 18.773699, 0.000000>, <42.769206, 5.145052, 0.000000>, <47.579917, -2.703683, 0.000000>, 
      <35.441107, 25.479059, 0.114797>, <41.748544, 18.773699, 0.114797>, <42.769206, 5.145052, 0.114797>, <47.579917, -2.703683, 0.114797>, 
      <35.396320, 25.431501, 0.272327>, <41.668160, 18.684091, 0.272327>, <42.696118, 5.075655, 0.272327>, <47.543571, -2.757970, 0.272327>, 
      <35.340672, 25.372405, 0.353500>, <41.612512, 18.624994, 0.353500>, <42.650950, 5.008206, 0.353500>, <47.498406, -2.825418, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <35.340672, 25.372405, -0.353500>, <41.612512, 18.624994, -0.353500>, <42.650950, 5.008206, -0.353500>, <47.498406, -2.825418, -0.353500>, 
      <35.396320, 25.431501, -0.272327>, <41.668160, 18.684091, -0.272327>, <42.696118, 5.075655, -0.272327>, <47.543571, -2.757970, -0.272327>, 
      <35.441107, 25.479059, -0.114797>, <41.748544, 18.773699, -0.114797>, <42.769206, 5.145052, -0.114797>, <47.579917, -2.703683, -0.114797>, 
      <35.441107, 25.479059, 0.000000>, <41.748544, 18.773699, 0.000000>, <42.769206, 5.145052, 0.000000>, <47.579917, -2.703683, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <35.098333, 25.115045, -0.500000>, <41.282099, 18.266013, -0.500000>, <42.366650, 4.677873, -0.500000>, <47.301712, -3.119142, -0.500000>, 
      <35.177034, 25.198619, -0.500000>, <41.360803, 18.349587, -0.500000>, <42.430522, 4.773257, -0.500000>, <47.365584, -3.023758, -0.500000>, 
      <35.285024, 25.313309, -0.434673>, <41.556861, 18.565899, -0.434673>, <42.605786, 4.940759, -0.434673>, <47.453238, -2.892866, -0.434673>, 
      <35.340672, 25.372405, -0.353500>, <41.612512, 18.624994, -0.353500>, <42.650950, 5.008206, -0.353500>, <47.498406, -2.825418, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <34.855984, 24.857694, -0.353500>, <40.948586, 17.906874, -0.353500>, <42.083802, 4.347362, -0.353500>, <47.105018, -3.412863, -0.353500>, 
      <34.911632, 24.916790, -0.434673>, <41.004234, 17.965970, -0.434673>, <42.128966, 4.414808, -0.434673>, <47.150186, -3.345417, -0.434673>, 
      <35.019632, 25.031472, -0.500000>, <41.203398, 18.182438, -0.500000>, <42.302778, 4.582489, -0.500000>, <47.237840, -3.214526, -0.500000>, 
      <35.098333, 25.115045, -0.500000>, <41.282099, 18.266013, -0.500000>, <42.366650, 4.677873, -0.500000>, <47.301712, -3.119142, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <34.755549, 24.751042, 0.000000>, <40.809453, 17.758011, 0.000000>, <41.967008, 4.210342, 0.000000>, <47.023507, -3.534592, 0.000000>, 
      <34.755549, 24.751042, -0.114796>, <40.809453, 17.758011, -0.114796>, <41.967008, 4.210342, -0.114796>, <47.023507, -3.534592, -0.114796>, 
      <34.800336, 24.798600, -0.272327>, <40.892938, 17.847778, -0.272327>, <42.038637, 4.279915, -0.272327>, <47.059853, -3.480310, -0.272327>, 
      <34.855984, 24.857694, -0.353500>, <40.948586, 17.906874, -0.353500>, <42.083802, 4.347362, -0.353500>, <47.105018, -3.412863, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <34.855984, 24.857694, 0.353500>, <40.948586, 17.906874, 0.353500>, <42.083802, 4.347362, 0.353500>, <47.105018, -3.412863, 0.353500>, 
      <34.800336, 24.798600, 0.272327>, <40.892938, 17.847778, 0.272327>, <42.038637, 4.279915, 0.272327>, <47.059853, -3.480310, 0.272327>, 
      <34.755549, 24.751042, 0.114796>, <40.809453, 17.758011, 0.114796>, <41.967008, 4.210342, 0.114796>, <47.023507, -3.534592, 0.114796>, 
      <34.755549, 24.751042, 0.000000>, <40.809453, 17.758011, 0.000000>, <41.967008, 4.210342, 0.000000>, <47.023507, -3.534592, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <35.098333, 25.115045, 0.500000>, <41.282099, 18.266013, 0.500000>, <42.366650, 4.677873, 0.500000>, <47.301712, -3.119142, 0.500000>, 
      <35.019632, 25.031472, 0.500000>, <41.203398, 18.182438, 0.500000>, <42.302778, 4.582489, 0.500000>, <47.237840, -3.214526, 0.500000>, 
      <34.911632, 24.916790, 0.434673>, <41.004234, 17.965970, 0.434673>, <42.128966, 4.414808, 0.434673>, <47.150186, -3.345417, 0.434673>, 
      <34.855984, 24.857694, 0.353500>, <40.948586, 17.906874, 0.353500>, <42.083802, 4.347362, 0.353500>, <47.105018, -3.412863, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <35.098333, 25.115045, 0.500000>, <35.177034, 25.198619, 0.500000>, <35.285024, 25.313309, 0.434673>, <35.340672, 25.372405, 0.353500>, 
      <41.282099, 18.266013, 0.500000>, <41.360803, 18.349587, 0.500000>, <41.556861, 18.565899, 0.434673>, <41.612512, 18.624994, 0.353500>, 
      <42.366650, 4.677873, 0.500000>, <42.430522, 4.773257, 0.500000>, <42.605786, 4.940759, 0.434673>, <42.650950, 5.008206, 0.353500>, 
      <47.301712, -3.119142, 0.500000>, <47.365584, -3.023758, 0.500000>, <47.453238, -2.892866, 0.434673>, <47.498406, -2.825418, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <24.810410, 21.502312, 0.000000>, <27.169546, 23.957683, 0.000000>, <33.108093, 27.959261, 0.000000>, <35.441107, 25.479059, 0.000000>, 
      <24.810410, 21.502312, 0.114796>, <27.169546, 23.957683, 0.114796>, <33.108093, 27.959261, 0.114797>, <35.441107, 25.479059, 0.114797>, 
      <24.869573, 21.474611, 0.272327>, <27.155542, 23.902744, 0.272327>, <33.125850, 27.874134, 0.272327>, <35.396320, 25.431501, 0.272327>, 
      <24.943086, 21.440189, 0.353500>, <27.229056, 23.868322, 0.353500>, <33.070202, 27.815037, 0.353500>, <35.340672, 25.372405, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <24.943086, 21.440189, -0.353500>, <27.229056, 23.868322, -0.353500>, <33.070202, 27.815037, -0.353500>, <35.340672, 25.372405, -0.353500>, 
      <24.869573, 21.474611, -0.272327>, <27.155542, 23.902744, -0.272327>, <33.125850, 27.874134, -0.272327>, <35.396320, 25.431501, -0.272327>, 
      <24.810410, 21.502312, -0.114796>, <27.169546, 23.957683, -0.114796>, <33.108093, 27.959261, -0.114797>, <35.441107, 25.479059, -0.114797>, 
      <24.810410, 21.502312, 0.000000>, <27.169546, 23.957683, 0.000000>, <33.108093, 27.959261, 0.000000>, <35.441107, 25.479059, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.263229, 21.290285, -0.500000>, <27.374160, 23.649563, -0.500000>, <32.976810, 27.464806, -0.500000>, <35.098333, 25.115045, -0.500000>, 
      <25.159266, 21.338965, -0.500000>, <27.270198, 23.698242, -0.500000>, <33.055510, 27.548381, -0.500000>, <35.177034, 25.198619, -0.500000>, 
      <25.016600, 21.405768, -0.434673>, <27.302570, 23.833901, -0.434673>, <33.014554, 27.755942, -0.434673>, <35.285024, 25.313309, -0.434673>, 
      <24.943086, 21.440189, -0.353500>, <27.229056, 23.868322, -0.353500>, <33.070202, 27.815037, -0.353500>, <35.340672, 25.372405, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.583370, 21.140381, -0.353500>, <27.521712, 23.426166, -0.353500>, <32.880496, 27.111453, -0.353500>, <34.855984, 24.857694, -0.353500>, 
      <25.509858, 21.174803, -0.434673>, <27.448198, 23.460589, -0.434673>, <32.936147, 27.170550, -0.434673>, <34.911632, 24.916790, -0.434673>, 
      <25.367194, 21.241606, -0.500000>, <27.478125, 23.600883, -0.500000>, <32.898109, 27.381232, -0.500000>, <35.019632, 25.031472, -0.500000>, 
      <25.263229, 21.290285, -0.500000>, <27.374160, 23.649563, -0.500000>, <32.976810, 27.464806, -0.500000>, <35.098333, 25.115045, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.716045, 21.078259, 0.000000>, <27.583683, 23.332168, 0.000000>, <32.839690, 26.964106, 0.000000>, <34.755549, 24.751042, 0.000000>, 
      <25.716045, 21.078259, -0.114796>, <27.583683, 23.332168, -0.114796>, <32.839690, 26.964106, -0.114796>, <34.755549, 24.751042, -0.114796>, 
      <25.656883, 21.105958, -0.272327>, <27.595226, 23.391744, -0.272327>, <32.824848, 27.052358, -0.272327>, <34.800336, 24.798600, -0.272327>, 
      <25.583370, 21.140381, -0.353500>, <27.521712, 23.426166, -0.353500>, <32.880496, 27.111453, -0.353500>, <34.855984, 24.857694, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.583370, 21.140381, 0.353500>, <27.521712, 23.426166, 0.353500>, <32.880496, 27.111453, 0.353500>, <34.855984, 24.857694, 0.353500>, 
      <25.656883, 21.105958, 0.272327>, <27.595226, 23.391744, 0.272327>, <32.824848, 27.052358, 0.272327>, <34.800336, 24.798600, 0.272327>, 
      <25.716045, 21.078259, 0.114796>, <27.583683, 23.332168, 0.114796>, <32.839690, 26.964106, 0.114796>, <34.755549, 24.751042, 0.114796>, 
      <25.716045, 21.078259, 0.000000>, <27.583683, 23.332168, 0.000000>, <32.839690, 26.964106, 0.000000>, <34.755549, 24.751042, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.263229, 21.290285, 0.500000>, <27.374160, 23.649563, 0.500000>, <32.976810, 27.464806, 0.500000>, <35.098333, 25.115045, 0.500000>, 
      <25.367194, 21.241606, 0.500000>, <27.478125, 23.600883, 0.500000>, <32.898109, 27.381232, 0.500000>, <35.019632, 25.031472, 0.500000>, 
      <25.509858, 21.174803, 0.434673>, <27.448198, 23.460589, 0.434673>, <32.936147, 27.170550, 0.434673>, <34.911632, 24.916790, 0.434673>, 
      <25.583370, 21.140381, 0.353500>, <27.521712, 23.426166, 0.353500>, <32.880496, 27.111453, 0.353500>, <34.855984, 24.857694, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.263229, 21.290285, 0.500000>, <25.159266, 21.338965, 0.500000>, <25.016600, 21.405768, 0.434673>, <24.943086, 21.440189, 0.353500>, 
      <27.374160, 23.649563, 0.500000>, <27.270198, 23.698242, 0.500000>, <27.302570, 23.833901, 0.434673>, <27.229056, 23.868322, 0.353500>, 
      <32.976810, 27.464806, 0.500000>, <33.055510, 27.548381, 0.500000>, <33.014554, 27.755942, 0.434673>, <33.070202, 27.815037, 0.353500>, 
      <35.098333, 25.115045, 0.500000>, <35.177034, 25.198619, 0.500000>, <35.285024, 25.313309, 0.434673>, <35.340672, 25.372405, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.462950, 15.093853, 0.000000>, <26.828587, 16.461154, 0.000000>, <23.471523, 20.108806, 0.000000>, <24.810410, 21.502312, 0.000000>, 
      <25.462950, 15.093853, 0.114797>, <26.828587, 16.461154, 0.114797>, <23.471523, 20.108806, 0.114796>, <24.810410, 21.502312, 0.114796>, 
      <25.508243, 15.046776, 0.272327>, <26.881610, 16.423389, 0.272327>, <23.536656, 20.058800, 0.272327>, <24.869573, 21.474611, 0.272327>, 
      <25.564526, 14.988283, 0.353500>, <26.937891, 16.364894, 0.353500>, <23.610168, 20.024378, 0.353500>, <24.943086, 21.440189, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.564526, 14.988283, -0.353500>, <26.937891, 16.364894, -0.353500>, <23.610168, 20.024378, -0.353500>, <24.943086, 21.440189, -0.353500>, 
      <25.508243, 15.046776, -0.272327>, <26.881610, 16.423389, -0.272327>, <23.536656, 20.058800, -0.272327>, <24.869573, 21.474611, -0.272327>, 
      <25.462950, 15.093853, -0.114797>, <26.828587, 16.461154, -0.114797>, <23.471523, 20.108806, -0.114796>, <24.810410, 21.502312, -0.114796>, 
      <25.462950, 15.093853, 0.000000>, <26.828587, 16.461154, 0.000000>, <23.471523, 20.108806, 0.000000>, <24.810410, 21.502312, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.809624, 14.733550, -0.500000>, <27.201776, 16.132821, -0.500000>, <23.947085, 19.819299, -0.500000>, <25.263229, 21.290285, -0.500000>, 
      <25.730030, 14.816274, -0.500000>, <27.122182, 16.215542, -0.500000>, <23.843120, 19.867979, -0.500000>, <25.159266, 21.338965, -0.500000>, 
      <25.620806, 14.929789, -0.434673>, <26.994170, 16.306400, -0.434673>, <23.683682, 19.989955, -0.434673>, <25.016600, 21.405768, -0.434673>, 
      <25.564526, 14.988283, -0.353500>, <26.937891, 16.364894, -0.353500>, <23.610168, 20.024378, -0.353500>, <24.943086, 21.440189, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <26.054722, 14.478814, -0.353500>, <27.465846, 15.900997, -0.353500>, <24.287605, 19.612352, -0.353500>, <25.583370, 21.140381, -0.353500>, 
      <25.998440, 14.537310, -0.434674>, <27.409565, 15.959491, -0.434674>, <24.214093, 19.646774, -0.434673>, <25.509858, 21.174803, -0.434673>, 
      <25.889218, 14.650827, -0.500000>, <27.281370, 16.050096, -0.500000>, <24.051048, 19.770621, -0.500000>, <25.367194, 21.241606, -0.500000>, 
      <25.809624, 14.733550, -0.500000>, <27.201776, 16.132821, -0.500000>, <23.947085, 19.819299, -0.500000>, <25.263229, 21.290285, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <26.156296, 14.373250, 0.000000>, <27.575338, 15.805000, 0.000000>, <24.429861, 19.526061, 0.000000>, <25.716045, 21.078259, 0.000000>, 
      <26.156296, 14.373250, -0.114796>, <27.575338, 15.805000, -0.114796>, <24.429861, 19.526061, -0.114796>, <25.716045, 21.078259, -0.114796>, 
      <26.111002, 14.420322, -0.272327>, <27.522128, 15.842504, -0.272327>, <24.361118, 19.577931, -0.272327>, <25.656883, 21.105958, -0.272327>, 
      <26.054722, 14.478814, -0.353500>, <27.465846, 15.900997, -0.353500>, <24.287605, 19.612352, -0.353500>, <25.583370, 21.140381, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <26.054722, 14.478814, 0.353500>, <27.465846, 15.900997, 0.353500>, <24.287605, 19.612352, 0.353500>, <25.583370, 21.140381, 0.353500>, 
      <26.111002, 14.420322, 0.272327>, <27.522128, 15.842504, 0.272327>, <24.361118, 19.577931, 0.272327>, <25.656883, 21.105958, 0.272327>, 
      <26.156296, 14.373250, 0.114796>, <27.575338, 15.805000, 0.114796>, <24.429861, 19.526061, 0.114796>, <25.716045, 21.078259, 0.114796>, 
      <26.156296, 14.373250, 0.000000>, <27.575338, 15.805000, 0.000000>, <24.429861, 19.526061, 0.000000>, <25.716045, 21.078259, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.809624, 14.733550, 0.500000>, <27.201776, 16.132821, 0.500000>, <23.947085, 19.819299, 0.500000>, <25.263229, 21.290285, 0.500000>, 
      <25.889218, 14.650827, 0.500000>, <27.281370, 16.050096, 0.500000>, <24.051048, 19.770621, 0.500000>, <25.367194, 21.241606, 0.500000>, 
      <25.998440, 14.537310, 0.434674>, <27.409565, 15.959491, 0.434674>, <24.214093, 19.646774, 0.434673>, <25.509858, 21.174803, 0.434673>, 
      <26.054722, 14.478814, 0.353500>, <27.465846, 15.900997, 0.353500>, <24.287605, 19.612352, 0.353500>, <25.583370, 21.140381, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <25.809624, 14.733550, 0.500000>, <25.730030, 14.816274, 0.500000>, <25.620806, 14.929789, 0.434673>, <25.564526, 14.988283, 0.353500>, 
      <27.201776, 16.132821, 0.500000>, <27.122182, 16.215542, 0.500000>, <26.994170, 16.306400, 0.434673>, <26.937891, 16.364894, 0.353500>, 
      <23.947085, 19.819299, 0.500000>, <23.843120, 19.867979, 0.500000>, <23.683682, 19.989955, 0.434673>, <23.610168, 20.024378, 0.353500>, 
      <25.263229, 21.290285, 0.500000>, <25.159266, 21.338965, 0.500000>, <25.016600, 21.405768, 0.434673>, <24.943086, 21.440189, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.836930, 11.516687, 0.000000>, <17.443624, 13.642458, 0.000000>, <23.085978, 12.713986, 0.000000>, <25.462950, 15.093853, 0.000000>, 
      <14.836930, 11.516687, 0.114796>, <17.443624, 13.642458, 0.114796>, <23.085978, 12.713986, 0.114797>, <25.462950, 15.093853, 0.114797>, 
      <14.887219, 11.474992, 0.272327>, <17.490901, 13.597592, 0.272327>, <23.135698, 12.668622, 0.272327>, <25.508243, 15.046776, 0.272327>, 
      <14.949707, 11.423182, 0.353500>, <17.553389, 13.545782, 0.353500>, <23.191981, 12.610129, 0.353500>, <25.564526, 14.988283, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.949707, 11.423182, -0.353500>, <17.553389, 13.545782, -0.353500>, <23.191981, 12.610129, -0.353500>, <25.564526, 14.988283, -0.353500>, 
      <14.887219, 11.474992, -0.272327>, <17.490901, 13.597592, -0.272327>, <23.135698, 12.668622, -0.272327>, <25.508243, 15.046776, -0.272327>, 
      <14.836930, 11.516687, -0.114796>, <17.443624, 13.642458, -0.114796>, <23.085978, 12.713986, -0.114797>, <25.462950, 15.093853, -0.114797>, 
      <14.836930, 11.516687, 0.000000>, <17.443624, 13.642458, 0.000000>, <23.085978, 12.713986, 0.000000>, <25.462950, 15.093853, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.221834, 11.197553, -0.500000>, <17.818248, 13.312510, -0.500000>, <23.447715, 12.359566, -0.500000>, <25.809624, 14.733550, -0.500000>, 
      <15.133462, 11.270823, -0.500000>, <17.729877, 13.385782, -0.500000>, <23.368122, 12.442290, -0.500000>, <25.730030, 14.816274, -0.500000>, 
      <15.012195, 11.371371, -0.434673>, <17.615875, 13.493971, -0.434673>, <23.248261, 12.551634, -0.434673>, <25.620806, 14.929789, -0.434673>, 
      <14.949707, 11.423182, -0.353500>, <17.553389, 13.545782, -0.353500>, <23.191981, 12.610129, -0.353500>, <25.564526, 14.988283, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.493962, 10.971924, -0.353500>, <18.083115, 13.079245, -0.353500>, <23.703389, 12.109058, -0.353500>, <26.054722, 14.478814, -0.353500>, 
      <15.431475, 11.023734, -0.434673>, <18.020626, 13.131055, -0.434673>, <23.647106, 12.167553, -0.434674>, <25.998440, 14.537310, -0.434674>, 
      <15.310205, 11.124282, -0.500000>, <17.906621, 13.239240, -0.500000>, <23.527309, 12.276843, -0.500000>, <25.889218, 14.650827, -0.500000>, 
      <15.221834, 11.197553, -0.500000>, <17.818248, 13.312510, -0.500000>, <23.447715, 12.359566, -0.500000>, <25.809624, 14.733550, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.606739, 10.878417, 0.000000>, <18.192885, 12.982575, 0.000000>, <23.809326, 12.005262, 0.000000>, <26.156296, 14.373250, 0.000000>, 
      <15.606739, 10.878417, -0.114796>, <18.192885, 12.982575, -0.114796>, <23.809326, 12.005262, -0.114796>, <26.156296, 14.373250, -0.114796>, 
      <15.556450, 10.920114, -0.272327>, <18.145603, 13.027434, -0.272327>, <23.759669, 12.050565, -0.272327>, <26.111002, 14.420322, -0.272327>, 
      <15.493962, 10.971924, -0.353500>, <18.083115, 13.079245, -0.353500>, <23.703389, 12.109058, -0.353500>, <26.054722, 14.478814, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.493962, 10.971924, 0.353500>, <18.083115, 13.079245, 0.353500>, <23.703389, 12.109058, 0.353500>, <26.054722, 14.478814, 0.353500>, 
      <15.556450, 10.920114, 0.272327>, <18.145603, 13.027434, 0.272327>, <23.759669, 12.050565, 0.272327>, <26.111002, 14.420322, 0.272327>, 
      <15.606739, 10.878417, 0.114796>, <18.192885, 12.982575, 0.114796>, <23.809326, 12.005262, 0.114796>, <26.156296, 14.373250, 0.114796>, 
      <15.606739, 10.878417, 0.000000>, <18.192885, 12.982575, 0.000000>, <23.809326, 12.005262, 0.000000>, <26.156296, 14.373250, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.221834, 11.197553, 0.500000>, <17.818248, 13.312510, 0.500000>, <23.447715, 12.359566, 0.500000>, <25.809624, 14.733550, 0.500000>, 
      <15.310205, 11.124282, 0.500000>, <17.906621, 13.239240, 0.500000>, <23.527309, 12.276843, 0.500000>, <25.889218, 14.650827, 0.500000>, 
      <15.431475, 11.023734, 0.434673>, <18.020626, 13.131055, 0.434673>, <23.647106, 12.167553, 0.434674>, <25.998440, 14.537310, 0.434674>, 
      <15.493962, 10.971924, 0.353500>, <18.083115, 13.079245, 0.353500>, <23.703389, 12.109058, 0.353500>, <26.054722, 14.478814, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <15.221834, 11.197553, 0.500000>, <15.133462, 11.270823, 0.500000>, <15.012195, 11.371371, 0.434673>, <14.949707, 11.423182, 0.353500>, 
      <17.818248, 13.312510, 0.500000>, <17.729877, 13.385782, 0.500000>, <17.615875, 13.493971, 0.434673>, <17.553389, 13.545782, 0.353500>, 
      <23.447715, 12.359566, 0.500000>, <23.368122, 12.442290, 0.500000>, <23.248261, 12.551634, 0.434673>, <23.191981, 12.610129, 0.353500>, 
      <25.809624, 14.733550, 0.500000>, <25.730030, 14.816274, 0.500000>, <25.620806, 14.929789, 0.434673>, <25.564526, 14.988283, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.819192, 5.598321, 0.000000>, <14.594307, 7.224622, 0.000000>, <13.440760, 10.378106, 0.000000>, <14.836930, 11.516687, 0.000000>, 
      <13.819192, 5.598321, 0.114796>, <14.594307, 7.224622, 0.114796>, <13.440760, 10.378106, 0.114796>, <14.836930, 11.516687, 0.114796>, 
      <13.869765, 5.556969, 0.272327>, <14.663418, 7.174014, 0.272327>, <13.491062, 10.336804, 0.272327>, <14.887219, 11.474992, 0.272327>, 
      <13.932603, 5.505585, 0.353500>, <14.726256, 7.122630, 0.353500>, <13.553552, 10.284994, 0.353500>, <14.949707, 11.423182, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <13.932603, 5.505585, -0.353500>, <14.726256, 7.122630, -0.353500>, <13.553552, 10.284994, -0.353500>, <14.949707, 11.423182, -0.353500>, 
      <13.869765, 5.556969, -0.272327>, <14.663418, 7.174014, -0.272327>, <13.491062, 10.336804, -0.272327>, <14.887219, 11.474992, -0.272327>, 
      <13.819192, 5.598321, -0.114796>, <14.594307, 7.224622, -0.114796>, <13.440760, 10.378106, -0.114796>, <14.836930, 11.516687, -0.114796>, 
      <13.819192, 5.598321, 0.000000>, <14.594307, 7.224622, 0.000000>, <13.440760, 10.378106, 0.000000>, <14.836930, 11.516687, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.206262, 5.281815, -0.500000>, <15.042678, 6.876453, -0.500000>, <13.825714, 10.060316, -0.500000>, <15.221834, 11.197553, -0.500000>, 
      <14.117395, 5.354483, -0.500000>, <14.953811, 6.949121, -0.500000>, <13.737342, 10.133587, -0.500000>, <15.133462, 11.270823, -0.500000>, 
      <13.995443, 5.454201, -0.434673>, <14.789096, 7.071246, -0.434673>, <13.616040, 10.233184, -0.434673>, <15.012195, 11.371371, -0.434673>, 
      <13.932603, 5.505585, -0.353500>, <14.726256, 7.122630, -0.353500>, <13.553552, 10.284994, -0.353500>, <14.949707, 11.423182, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.479922, 5.058045, -0.353500>, <15.356445, 6.630276, -0.353500>, <14.097872, 9.835642, -0.353500>, <15.493962, 10.971924, -0.353500>, 
      <14.417082, 5.109428, -0.434673>, <15.293605, 6.681659, -0.434673>, <14.035386, 9.887452, -0.434673>, <15.431475, 11.023734, -0.434673>, 
      <14.295131, 5.209148, -0.500000>, <15.131547, 6.803786, -0.500000>, <13.914085, 9.987046, -0.500000>, <15.310205, 11.124282, -0.500000>, 
      <14.206262, 5.281815, -0.500000>, <15.042678, 6.876453, -0.500000>, <13.825714, 10.060316, -0.500000>, <15.221834, 11.197553, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.593333, 4.965310, 0.000000>, <15.485734, 6.528283, 0.000000>, <14.210662, 9.742532, 0.000000>, <15.606739, 10.878417, 0.000000>, 
      <14.593333, 4.965310, -0.114796>, <15.485734, 6.528283, -0.114796>, <14.210662, 9.742532, -0.114796>, <15.606739, 10.878417, -0.114796>, 
      <14.542762, 5.006662, -0.272327>, <15.419283, 6.578892, -0.272327>, <14.160360, 9.783831, -0.272327>, <15.556450, 10.920114, -0.272327>, 
      <14.479922, 5.058045, -0.353500>, <15.356445, 6.630276, -0.353500>, <14.097872, 9.835642, -0.353500>, <15.493962, 10.971924, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.479922, 5.058045, 0.353500>, <15.356445, 6.630276, 0.353500>, <14.097872, 9.835642, 0.353500>, <15.493962, 10.971924, 0.353500>, 
      <14.542762, 5.006662, 0.272327>, <15.419283, 6.578892, 0.272327>, <14.160360, 9.783831, 0.272327>, <15.556450, 10.920114, 0.272327>, 
      <14.593333, 4.965310, 0.114796>, <15.485734, 6.528283, 0.114796>, <14.210662, 9.742532, 0.114796>, <15.606739, 10.878417, 0.114796>, 
      <14.593333, 4.965310, 0.000000>, <15.485734, 6.528283, 0.000000>, <14.210662, 9.742532, 0.000000>, <15.606739, 10.878417, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.206262, 5.281815, 0.500000>, <15.042678, 6.876453, 0.500000>, <13.825714, 10.060316, 0.500000>, <15.221834, 11.197553, 0.500000>, 
      <14.295131, 5.209148, 0.500000>, <15.131547, 6.803786, 0.500000>, <13.914085, 9.987046, 0.500000>, <15.310205, 11.124282, 0.500000>, 
      <14.417082, 5.109428, 0.434673>, <15.293605, 6.681659, 0.434673>, <14.035386, 9.887452, 0.434673>, <15.431475, 11.023734, 0.434673>, 
      <14.479922, 5.058045, 0.353500>, <15.356445, 6.630276, 0.353500>, <14.097872, 9.835642, 0.353500>, <15.493962, 10.971924, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <14.206262, 5.281815, 0.500000>, <14.117395, 5.354483, 0.500000>, <13.995443, 5.454201, 0.434673>, <13.932603, 5.505585, 0.353500>, 
      <15.042678, 6.876453, 0.500000>, <14.953811, 6.949121, 0.500000>, <14.789096, 7.071246, 0.434673>, <14.726256, 7.122630, 0.353500>, 
      <13.825714, 10.060316, 0.500000>, <13.737342, 10.133587, 0.500000>, <13.616040, 10.233184, 0.434673>, <13.553552, 10.284994, 0.353500>, 
      <15.221834, 11.197553, 0.500000>, <15.133462, 11.270823, 0.500000>, <15.012195, 11.371371, 0.434673>, <14.949707, 11.423182, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.180770, 1.747422, 0.000000>, <11.738937, 2.060783, 0.000000>, <13.135377, 4.163582, 0.000000>, <13.819192, 5.598321, 0.000000>, 
      <10.180770, 1.747422, 0.114796>, <11.738937, 2.060783, 0.114796>, <13.135377, 4.163582, 0.114796>, <13.819192, 5.598321, 0.114796>, 
      <10.159404, 1.685689, 0.272327>, <11.763048, 1.992725, 0.272327>, <13.150369, 4.091221, 0.272327>, <13.869765, 5.556969, 0.272327>, 
      <10.132854, 1.608980, 0.353500>, <11.736499, 1.916016, 0.353500>, <13.213208, 4.039837, 0.353500>, <13.932603, 5.505585, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.132854, 1.608980, -0.353500>, <11.736499, 1.916016, -0.353500>, <13.213208, 4.039837, -0.353500>, <13.932603, 5.505585, -0.353500>, 
      <10.159404, 1.685689, -0.272327>, <11.763048, 1.992725, -0.272327>, <13.150369, 4.091221, -0.272327>, <13.869765, 5.556969, -0.272327>, 
      <10.180770, 1.747422, -0.114796>, <11.738937, 2.060783, -0.114796>, <13.135377, 4.163582, -0.114796>, <13.819192, 5.598321, -0.114796>, 
      <10.180770, 1.747422, 0.000000>, <11.738937, 2.060783, 0.000000>, <13.135377, 4.163582, 0.000000>, <13.819192, 5.598321, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.017236, 1.274921, -0.500000>, <11.731478, 1.567596, -0.500000>, <13.398477, 3.741761, -0.500000>, <14.206262, 5.281815, -0.500000>, 
      <10.054782, 1.383404, -0.500000>, <11.769024, 1.676079, -0.500000>, <13.309609, 3.814429, -0.500000>, <14.117395, 5.354483, -0.500000>, 
      <10.106305, 1.532271, -0.434673>, <11.709950, 1.839307, -0.434673>, <13.276048, 3.988453, -0.434673>, <13.995443, 5.454201, -0.434673>, 
      <10.132854, 1.608980, -0.353500>, <11.736499, 1.916016, -0.353500>, <13.213208, 4.039837, -0.353500>, <13.932603, 5.505585, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.901617, 0.940864, -0.353500>, <11.727557, 1.220198, -0.353500>, <13.580450, 3.444652, -0.353500>, <14.479922, 5.058045, -0.353500>, 
      <9.928166, 1.017573, -0.434673>, <11.754106, 1.296907, -0.434673>, <13.517611, 3.496036, -0.434673>, <14.417082, 5.109428, -0.434673>, 
      <9.979690, 1.166438, -0.500000>, <11.693931, 1.459114, -0.500000>, <13.487344, 3.669094, -0.500000>, <14.295131, 5.209148, -0.500000>, 
      <10.017236, 1.274921, -0.500000>, <11.731478, 1.567596, -0.500000>, <13.398477, 3.741761, -0.500000>, <14.206262, 5.281815, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.853702, 0.802421, 0.000000>, <11.726224, 1.076466, 0.000000>, <13.654981, 3.321859, 0.000000>, <14.593333, 4.965310, 0.000000>, 
      <9.853702, 0.802421, -0.114796>, <11.726224, 1.076466, -0.114796>, <13.654981, 3.321859, -0.114796>, <14.593333, 4.965310, -0.114796>, 
      <9.875068, 0.864155, -0.272327>, <11.701008, 1.143489, -0.272327>, <13.643290, 3.393268, -0.272327>, <14.542762, 5.006662, -0.272327>, 
      <9.901617, 0.940864, -0.353500>, <11.727557, 1.220198, -0.353500>, <13.580450, 3.444652, -0.353500>, <14.479922, 5.058045, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <9.901617, 0.940864, 0.353500>, <11.727557, 1.220198, 0.353500>, <13.580450, 3.444652, 0.353500>, <14.479922, 5.058045, 0.353500>, 
      <9.875068, 0.864155, 0.272327>, <11.701008, 1.143489, 0.272327>, <13.643290, 3.393268, 0.272327>, <14.542762, 5.006662, 0.272327>, 
      <9.853702, 0.802421, 0.114796>, <11.726224, 1.076466, 0.114796>, <13.654981, 3.321859, 0.114796>, <14.593333, 4.965310, 0.114796>, 
      <9.853702, 0.802421, 0.000000>, <11.726224, 1.076466, 0.000000>, <13.654981, 3.321859, 0.000000>, <14.593333, 4.965310, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.017236, 1.274921, 0.500000>, <11.731478, 1.567596, 0.500000>, <13.398477, 3.741761, 0.500000>, <14.206262, 5.281815, 0.500000>, 
      <9.979690, 1.166438, 0.500000>, <11.693931, 1.459114, 0.500000>, <13.487344, 3.669094, 0.500000>, <14.295131, 5.209148, 0.500000>, 
      <9.928166, 1.017573, 0.434673>, <11.754106, 1.296907, 0.434673>, <13.517611, 3.496036, 0.434673>, <14.417082, 5.109428, 0.434673>, 
      <9.901617, 0.940864, 0.353500>, <11.727557, 1.220198, 0.353500>, <13.580450, 3.444652, 0.353500>, <14.479922, 5.058045, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <10.017236, 1.274921, 0.500000>, <10.054782, 1.383404, 0.500000>, <10.106305, 1.532271, 0.434673>, <10.132854, 1.608980, 0.353500>, 
      <11.731478, 1.567596, 0.500000>, <11.769024, 1.676079, 0.500000>, <11.709950, 1.839307, 0.434673>, <11.736499, 1.916016, 0.353500>, 
      <13.398477, 3.741761, 0.500000>, <13.309609, 3.814429, 0.500000>, <13.276048, 3.988453, 0.434673>, <13.213208, 4.039837, 0.353500>, 
      <14.206262, 5.281815, 0.500000>, <14.117395, 5.354483, 0.500000>, <13.995443, 5.454201, 0.434673>, <13.932603, 5.505585, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.169481, 4.261005, 0.000000>, <8.021181, 3.449005, 0.000000>, <9.027120, 1.515413, 0.000000>, <10.180770, 1.747422, 0.000000>, 
      <7.169481, 4.261005, 0.114796>, <8.021181, 3.449005, 0.114796>, <9.027120, 1.515413, 0.114796>, <10.180770, 1.747422, 0.114796>, 
      <7.113221, 4.227805, 0.272327>, <7.984602, 3.392510, 0.272327>, <8.973866, 1.458704, 0.272327>, <10.159404, 1.685689, 0.272327>, 
      <7.043312, 4.186551, 0.353500>, <7.914694, 3.351256, 0.353500>, <8.947316, 1.381995, 0.353500>, <10.132854, 1.608980, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <7.043312, 4.186551, -0.353500>, <7.914694, 3.351256, -0.353500>, <8.947316, 1.381995, -0.353500>, <10.132854, 1.608980, -0.353500>, 
      <7.113221, 4.227805, -0.272327>, <7.984602, 3.392510, -0.272327>, <8.973866, 1.458704, -0.272327>, <10.159404, 1.685689, -0.272327>, 
      <7.169481, 4.261005, -0.114796>, <8.021181, 3.449005, -0.114796>, <9.027120, 1.515413, -0.114796>, <10.180770, 1.747422, -0.114796>, 
      <7.169481, 4.261005, 0.000000>, <8.021181, 3.449005, 0.000000>, <9.027120, 1.515413, 0.000000>, <10.180770, 1.747422, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.738868, 4.006894, -0.500000>, <7.657161, 3.114839, -0.500000>, <8.755253, 1.059460, -0.500000>, <10.017236, 1.274921, -0.500000>, 
      <6.837734, 4.065236, -0.500000>, <7.756026, 3.173181, -0.500000>, <8.792799, 1.167943, -0.500000>, <10.054782, 1.383404, -0.500000>, 
      <6.973403, 4.145297, -0.434673>, <7.844785, 3.310002, -0.434673>, <8.920767, 1.305286, -0.434673>, <10.106305, 1.532271, -0.434673>, 
      <7.043312, 4.186551, -0.353500>, <7.914694, 3.351256, -0.353500>, <8.947316, 1.381995, -0.353500>, <10.132854, 1.608980, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.434424, 3.827238, -0.353500>, <7.398781, 2.877634, -0.353500>, <8.563766, 0.736199, -0.353500>, <9.901617, 0.940864, -0.353500>, 
      <6.504332, 3.868492, -0.434673>, <7.468690, 2.918888, -0.434673>, <8.590316, 0.812907, -0.434673>, <9.928166, 1.017573, -0.434673>, 
      <6.640002, 3.948552, -0.500000>, <7.558294, 3.056497, -0.500000>, <8.717706, 0.950978, -0.500000>, <9.979690, 1.166438, -0.500000>, 
      <6.738868, 4.006894, -0.500000>, <7.657161, 3.114839, -0.500000>, <8.755253, 1.059460, -0.500000>, <10.017236, 1.274921, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.308255, 3.752784, 0.000000>, <7.291447, 2.779095, 0.000000>, <8.484548, 0.602044, 0.000000>, <9.853702, 0.802421, 0.000000>, 
      <6.308255, 3.752784, -0.114796>, <7.291447, 2.779095, -0.114796>, <8.484548, 0.602044, -0.114796>, <9.853702, 0.802421, -0.114796>, 
      <6.364515, 3.785984, -0.272327>, <7.328872, 2.836380, -0.272327>, <8.537217, 0.659490, -0.272327>, <9.875068, 0.864155, -0.272327>, 
      <6.434424, 3.827238, -0.353500>, <7.398781, 2.877634, -0.353500>, <8.563766, 0.736199, -0.353500>, <9.901617, 0.940864, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.434424, 3.827238, 0.353500>, <7.398781, 2.877634, 0.353500>, <8.563766, 0.736199, 0.353500>, <9.901617, 0.940864, 0.353500>, 
      <6.364515, 3.785984, 0.272327>, <7.328872, 2.836380, 0.272327>, <8.537217, 0.659490, 0.272327>, <9.875068, 0.864155, 0.272327>, 
      <6.308255, 3.752784, 0.114796>, <7.291447, 2.779095, 0.114796>, <8.484548, 0.602044, 0.114796>, <9.853702, 0.802421, 0.114796>, 
      <6.308255, 3.752784, 0.000000>, <7.291447, 2.779095, 0.000000>, <8.484548, 0.602044, 0.000000>, <9.853702, 0.802421, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.738868, 4.006894, 0.500000>, <7.657161, 3.114839, 0.500000>, <8.755253, 1.059460, 0.500000>, <10.017236, 1.274921, 0.500000>, 
      <6.640002, 3.948552, 0.500000>, <7.558294, 3.056497, 0.500000>, <8.717706, 0.950978, 0.500000>, <9.979690, 1.166438, 0.500000>, 
      <6.504332, 3.868492, 0.434673>, <7.468690, 2.918888, 0.434673>, <8.590316, 0.812907, 0.434673>, <9.928166, 1.017573, 0.434673>, 
      <6.434424, 3.827238, 0.353500>, <7.398781, 2.877634, 0.353500>, <8.563766, 0.736199, 0.353500>, <9.901617, 0.940864, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <6.738868, 4.006894, 0.500000>, <6.837734, 4.065236, 0.500000>, <6.973403, 4.145297, 0.434673>, <7.043312, 4.186551, 0.353500>, 
      <7.657161, 3.114839, 0.500000>, <7.756026, 3.173181, 0.500000>, <7.844785, 3.310002, 0.434673>, <7.914694, 3.351256, 0.353500>, 
      <8.755253, 1.059460, 0.500000>, <8.792799, 1.167943, 0.500000>, <8.920767, 1.305286, 0.434673>, <8.947316, 1.381995, 0.353500>, 
      <10.017236, 1.274921, 0.500000>, <10.054782, 1.383404, 0.500000>, <10.106305, 1.532271, 0.434673>, <10.132854, 1.608980, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.656909, 7.967189, 0.000000>, <5.187015, 8.040890, 0.000000>, <6.060746, 5.318059, 0.000000>, <7.169481, 4.261005, 0.000000>, 
      <3.656909, 7.967189, 0.114796>, <5.187015, 8.040890, 0.114796>, <6.060746, 5.318059, 0.114796>, <7.169481, 4.261005, 0.114796>, 
      <3.655044, 7.901889, 0.272327>, <5.144218, 7.977198, 0.272327>, <6.036817, 5.259632, 0.272327>, <7.113221, 4.227805, 0.272327>, 
      <3.652726, 7.820749, 0.353500>, <5.141900, 7.896058, 0.353500>, <5.966908, 5.218378, 0.353500>, <7.043312, 4.186551, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.652726, 7.820749, -0.353500>, <5.141900, 7.896058, -0.353500>, <5.966908, 5.218378, -0.353500>, <7.043312, 4.186551, -0.353500>, 
      <3.655044, 7.901889, -0.272327>, <5.144218, 7.977198, -0.272327>, <6.036817, 5.259632, -0.272327>, <7.113221, 4.227805, -0.272327>, 
      <3.656909, 7.967189, -0.114796>, <5.187015, 8.040890, -0.114796>, <6.060746, 5.318059, -0.114796>, <7.169481, 4.261005, -0.114796>, 
      <3.656909, 7.967189, 0.000000>, <5.187015, 8.040890, 0.000000>, <6.060746, 5.318059, 0.000000>, <7.169481, 4.261005, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.642631, 7.467393, -0.500000>, <5.033400, 7.546866, -0.500000>, <5.739670, 4.977543, -0.500000>, <6.738868, 4.006894, -0.500000>, 
      <3.645909, 7.582142, -0.500000>, <5.036679, 7.661615, -0.500000>, <5.838536, 5.035885, -0.500000>, <6.837734, 4.065236, -0.500000>, 
      <3.650408, 7.739609, -0.434673>, <5.139583, 7.814918, -0.434673>, <5.897000, 5.177124, -0.434673>, <6.973403, 4.145297, -0.434673>, 
      <3.652726, 7.820749, -0.353500>, <5.141900, 7.896058, -0.353500>, <5.966908, 5.218378, -0.353500>, <7.043312, 4.186551, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.632536, 7.114038, -0.353500>, <4.925496, 7.198190, -0.353500>, <5.511194, 4.736344, -0.353500>, <6.434424, 3.827238, -0.353500>, 
      <3.634854, 7.195178, -0.434673>, <4.927814, 7.279330, -0.434673>, <5.581103, 4.777598, -0.434673>, <6.504332, 3.868492, -0.434673>, 
      <3.639353, 7.352643, -0.500000>, <5.030122, 7.432116, -0.500000>, <5.640804, 4.919201, -0.500000>, <6.640002, 3.948552, -0.500000>, 
      <3.642631, 7.467393, -0.500000>, <5.033400, 7.546866, -0.500000>, <5.739670, 4.977543, -0.500000>, <6.738868, 4.006894, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.628353, 6.967597, 0.000000>, <4.880980, 7.053883, 0.000000>, <5.416114, 4.636302, 0.000000>, <6.308255, 3.752784, 0.000000>, 
      <3.628353, 6.967597, -0.114797>, <4.880980, 7.053883, -0.114797>, <5.416114, 4.636302, -0.114796>, <6.308255, 3.752784, -0.114796>, 
      <3.630218, 7.032898, -0.272327>, <4.923178, 7.117050, -0.272327>, <5.441286, 4.695090, -0.272327>, <6.364515, 3.785984, -0.272327>, 
      <3.632536, 7.114038, -0.353500>, <4.925496, 7.198190, -0.353500>, <5.511194, 4.736344, -0.353500>, <6.434424, 3.827238, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.632536, 7.114038, 0.353500>, <4.925496, 7.198190, 0.353500>, <5.511194, 4.736344, 0.353500>, <6.434424, 3.827238, 0.353500>, 
      <3.630218, 7.032898, 0.272327>, <4.923178, 7.117050, 0.272327>, <5.441286, 4.695090, 0.272327>, <6.364515, 3.785984, 0.272327>, 
      <3.628353, 6.967597, 0.114797>, <4.880980, 7.053883, 0.114797>, <5.416114, 4.636302, 0.114796>, <6.308255, 3.752784, 0.114796>, 
      <3.628353, 6.967597, 0.000000>, <4.880980, 7.053883, 0.000000>, <5.416114, 4.636302, 0.000000>, <6.308255, 3.752784, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.642631, 7.467393, 0.500000>, <5.033400, 7.546866, 0.500000>, <5.739670, 4.977543, 0.500000>, <6.738868, 4.006894, 0.500000>, 
      <3.639353, 7.352643, 0.500000>, <5.030122, 7.432116, 0.500000>, <5.640804, 4.919201, 0.500000>, <6.640002, 3.948552, 0.500000>, 
      <3.634854, 7.195178, 0.434673>, <4.927814, 7.279330, 0.434673>, <5.581103, 4.777598, 0.434673>, <6.504332, 3.868492, 0.434673>, 
      <3.632536, 7.114038, 0.353500>, <4.925496, 7.198190, 0.353500>, <5.511194, 4.736344, 0.353500>, <6.434424, 3.827238, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.642631, 7.467393, 0.500000>, <3.645909, 7.582142, 0.500000>, <3.650408, 7.739609, 0.434673>, <3.652726, 7.820749, 0.353500>, 
      <5.033400, 7.546866, 0.500000>, <5.036679, 7.661615, 0.500000>, <5.139583, 7.814918, 0.434673>, <5.141900, 7.896058, 0.353500>, 
      <5.739670, 4.977543, 0.500000>, <5.838536, 5.035885, 0.500000>, <5.897000, 5.177124, 0.434673>, <5.966908, 5.218378, 0.353500>, 
      <6.738868, 4.006894, 0.500000>, <6.837734, 4.065236, 0.500000>, <6.973403, 4.145297, 0.434673>, <7.043312, 4.186551, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056364, 3.912951, 0.000000>, <0.706574, 5.375209, 0.000000>, <2.009494, 7.887837, 0.000000>, <3.656909, 7.967189, 0.000000>, 
      <-0.056364, 3.912951, 0.114796>, <0.706574, 5.375209, 0.114796>, <2.009494, 7.887837, 0.114796>, <3.656909, 7.967189, 0.114796>, 
      <-0.001407, 3.877634, 0.272327>, <0.732027, 5.309407, 0.272327>, <2.048401, 7.820640, 0.272327>, <3.655044, 7.901889, 0.272327>, 
      <0.066880, 3.833748, 0.353500>, <0.800315, 5.265522, 0.353500>, <2.046083, 7.739500, 0.353500>, <3.652726, 7.820749, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.066880, 3.833748, -0.353500>, <0.800315, 5.265522, -0.353500>, <2.046083, 7.739500, -0.353500>, <3.652726, 7.820749, -0.353500>, 
      <-0.001407, 3.877634, -0.272327>, <0.732027, 5.309407, -0.272327>, <2.048401, 7.820640, -0.272327>, <3.655044, 7.901889, -0.272327>, 
      <-0.056364, 3.912951, -0.114796>, <0.706574, 5.375209, -0.114796>, <2.009494, 7.887837, -0.114796>, <3.656909, 7.967189, -0.114796>, 
      <-0.056364, 3.912951, 0.000000>, <0.706574, 5.375209, 0.000000>, <2.009494, 7.887837, 0.000000>, <3.656909, 7.967189, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364263, 3.642631, -0.500000>, <1.026832, 5.000898, -0.500000>, <2.133840, 7.381177, -0.500000>, <3.642631, 7.467393, -0.500000>, 
      <0.267690, 3.704695, -0.500000>, <0.930259, 5.062961, -0.500000>, <2.137118, 7.495926, -0.500000>, <3.645909, 7.582142, -0.500000>, 
      <0.135167, 3.789863, -0.434673>, <0.868602, 5.221636, -0.434673>, <2.043765, 7.658360, -0.434673>, <3.650408, 7.739609, -0.434673>, 
      <0.066880, 3.833748, -0.353500>, <0.800315, 5.265522, -0.353500>, <2.046083, 7.739500, -0.353500>, <3.652726, 7.820749, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.661646, 3.451514, -0.353500>, <1.253874, 4.736384, -0.353500>, <2.220735, 7.022150, -0.353500>, <3.632536, 7.114038, -0.353500>, 
      <0.593359, 3.495400, -0.434673>, <1.185587, 4.780269, -0.434673>, <2.223053, 7.103290, -0.434673>, <3.634854, 7.195178, -0.434673>, 
      <0.460836, 3.580567, -0.500000>, <1.123405, 4.938834, -0.500000>, <2.130561, 7.266427, -0.500000>, <3.639353, 7.352643, -0.500000>, 
      <0.364263, 3.642631, -0.500000>, <1.026832, 5.000898, -0.500000>, <2.133840, 7.381177, -0.500000>, <3.642631, 7.467393, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.784890, 3.372311, 0.000000>, <1.348143, 4.626811, 0.000000>, <2.256459, 6.873095, 0.000000>, <3.628353, 6.967597, 0.000000>, 
      <0.784890, 3.372311, -0.114796>, <1.348143, 4.626811, -0.114796>, <2.256459, 6.873095, -0.114797>, <3.628353, 6.967597, -0.114797>, 
      <0.729933, 3.407628, -0.272327>, <1.322162, 4.692498, -0.272327>, <2.218417, 6.941010, -0.272327>, <3.630218, 7.032898, -0.272327>, 
      <0.661646, 3.451514, -0.353500>, <1.253874, 4.736384, -0.353500>, <2.220735, 7.022150, -0.353500>, <3.632536, 7.114038, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.661646, 3.451514, 0.353500>, <1.253874, 4.736384, 0.353500>, <2.220735, 7.022150, 0.353500>, <3.632536, 7.114038, 0.353500>, 
      <0.729933, 3.407628, 0.272327>, <1.322162, 4.692498, 0.272327>, <2.218417, 6.941010, 0.272327>, <3.630218, 7.032898, 0.272327>, 
      <0.784890, 3.372311, 0.114796>, <1.348143, 4.626811, 0.114796>, <2.256459, 6.873095, 0.114797>, <3.628353, 6.967597, 0.114797>, 
      <0.784890, 3.372311, 0.000000>, <1.348143, 4.626811, 0.000000>, <2.256459, 6.873095, 0.000000>, <3.628353, 6.967597, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364263, 3.642631, 0.500000>, <1.026832, 5.000898, 0.500000>, <2.133840, 7.381177, 0.500000>, <3.642631, 7.467393, 0.500000>, 
      <0.460836, 3.580567, 0.500000>, <1.123405, 4.938834, 0.500000>, <2.130561, 7.266427, 0.500000>, <3.639353, 7.352643, 0.500000>, 
      <0.593359, 3.495400, 0.434673>, <1.185587, 4.780269, 0.434673>, <2.223053, 7.103290, 0.434673>, <3.634854, 7.195178, 0.434673>, 
      <0.661646, 3.451514, 0.353500>, <1.253874, 4.736384, 0.353500>, <2.220735, 7.022150, 0.353500>, <3.632536, 7.114038, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.364263, 3.642631, 0.500000>, <0.267690, 3.704695, 0.500000>, <0.135167, 3.789863, 0.434673>, <0.066880, 3.833748, 0.353500>, 
      <1.026832, 5.000898, 0.500000>, <0.930259, 5.062961, 0.500000>, <0.868602, 5.221636, 0.434673>, <0.800315, 5.265522, 0.353500>, 
      <2.133840, 7.381177, 0.500000>, <2.137118, 7.495926, 0.500000>, <2.043765, 7.658360, 0.434673>, <2.046083, 7.739500, 0.353500>, 
      <3.642631, 7.467393, 0.500000>, <3.645909, 7.582142, 0.500000>, <3.650408, 7.739609, 0.434673>, <3.652726, 7.820749, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, 0.000000, 0.000000>, <-0.366909, 1.173885, 0.000000>, <-0.602854, 2.865541, 0.000000>, <-0.056364, 3.912951, 0.000000>, 
      <-0.500000, 0.000000, 0.114796>, <-0.366909, 1.173885, 0.114796>, <-0.602854, 2.865541, 0.114796>, <-0.056364, 3.912951, 0.114796>, 
      <-0.434673, 0.000000, 0.272327>, <-0.308559, 1.150124, 0.272327>, <-0.528914, 2.847863, 0.272327>, <-0.001407, 3.877634, 0.272327>, 
      <-0.353500, 0.000000, 0.353500>, <-0.227386, 1.150124, 0.353500>, <-0.460626, 2.803977, 0.353500>, <0.066880, 3.833748, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.353500, 0.000000, -0.353500>, <-0.227386, 1.150124, -0.353500>, <-0.460626, 2.803977, -0.353500>, <0.066880, 3.833748, -0.353500>, 
      <-0.434673, 0.000000, -0.272327>, <-0.308559, 1.150124, -0.272327>, <-0.528914, 2.847863, -0.272327>, <-0.001407, 3.877634, -0.272327>, 
      <-0.500000, 0.000000, -0.114796>, <-0.366909, 1.173885, -0.114796>, <-0.602854, 2.865541, -0.114796>, <-0.056364, 3.912951, -0.114796>, 
      <-0.500000, 0.000000, 0.000000>, <-0.366909, 1.173885, 0.000000>, <-0.602854, 2.865541, 0.000000>, <-0.056364, 3.912951, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, -0.500000>, <0.109279, 1.092789, -0.500000>, <-0.117231, 2.655568, -0.500000>, <0.364263, 3.642631, -0.500000>, 
      <-0.114796, 0.000000, -0.500000>, <-0.005517, 1.092789, -0.500000>, <-0.213804, 2.717632, -0.500000>, <0.267690, 3.704695, -0.500000>, 
      <-0.272327, 0.000000, -0.434673>, <-0.146213, 1.150124, -0.434673>, <-0.392339, 2.760092, -0.434673>, <0.135167, 3.789863, -0.434673>, 
      <-0.353500, 0.000000, -0.353500>, <-0.227386, 1.150124, -0.353500>, <-0.460626, 2.803977, -0.353500>, <0.066880, 3.833748, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.353500, 0.000000, -0.353500>, <0.445944, 1.035454, -0.353500>, <0.226482, 2.507404, -0.353500>, <0.661646, 3.451514, -0.353500>, 
      <0.272327, 0.000000, -0.434673>, <0.364771, 1.035454, -0.434673>, <0.158195, 2.551289, -0.434673>, <0.593359, 3.495400, -0.434673>, 
      <0.114796, 0.000000, -0.500000>, <0.224075, 1.092789, -0.500000>, <-0.020659, 2.593504, -0.500000>, <0.460836, 3.580567, -0.500000>, 
      <0.000000, 0.000000, -0.500000>, <0.109279, 1.092789, -0.500000>, <-0.117231, 2.655568, -0.500000>, <0.364263, 3.642631, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, 0.000000, 0.000000>, <0.585467, 1.011693, 0.000000>, <0.369029, 2.446089, 0.000000>, <0.784890, 3.372311, 0.000000>, 
      <0.500000, 0.000000, -0.114796>, <0.585467, 1.011693, -0.114796>, <0.369029, 2.446089, -0.114796>, <0.784890, 3.372311, -0.114796>, 
      <0.434673, 0.000000, -0.272327>, <0.527117, 1.035454, -0.272327>, <0.294770, 2.463518, -0.272327>, <0.729933, 3.407628, -0.272327>, 
      <0.353500, 0.000000, -0.353500>, <0.445944, 1.035454, -0.353500>, <0.226482, 2.507404, -0.353500>, <0.661646, 3.451514, -0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.353500, 0.000000, 0.353500>, <0.445944, 1.035454, 0.353500>, <0.226482, 2.507404, 0.353500>, <0.661646, 3.451514, 0.353500>, 
      <0.434673, 0.000000, 0.272327>, <0.527117, 1.035454, 0.272327>, <0.294770, 2.463518, 0.272327>, <0.729933, 3.407628, 0.272327>, 
      <0.500000, 0.000000, 0.114796>, <0.585467, 1.011693, 0.114796>, <0.369029, 2.446089, 0.114796>, <0.784890, 3.372311, 0.114796>, 
      <0.500000, 0.000000, 0.000000>, <0.585467, 1.011693, 0.000000>, <0.369029, 2.446089, 0.000000>, <0.784890, 3.372311, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <0.109279, 1.092789, 0.500000>, <-0.117231, 2.655568, 0.500000>, <0.364263, 3.642631, 0.500000>, 
      <0.114796, 0.000000, 0.500000>, <0.224075, 1.092789, 0.500000>, <-0.020659, 2.593504, 0.500000>, <0.460836, 3.580567, 0.500000>, 
      <0.272327, 0.000000, 0.434673>, <0.364771, 1.035454, 0.434673>, <0.158195, 2.551289, 0.434673>, <0.593359, 3.495400, 0.434673>, 
      <0.353500, 0.000000, 0.353500>, <0.445944, 1.035454, 0.353500>, <0.226482, 2.507404, 0.353500>, <0.661646, 3.451514, 0.353500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.000000, 0.500000>, <-0.114796, 0.000000, 0.500000>, <-0.272327, 0.000000, 0.434673>, <-0.353500, 0.000000, 0.353500>, 
      <0.109279, 1.092789, 0.500000>, <-0.005517, 1.092789, 0.500000>, <-0.146213, 1.150124, 0.434673>, <-0.227386, 1.150124, 0.353500>, 
      <-0.117231, 2.655568, 0.500000>, <-0.213804, 2.717632, 0.500000>, <-0.392339, 2.760092, 0.434673>, <-0.460626, 2.803977, 0.353500>, 
      <0.364263, 3.642631, 0.500000>, <0.267690, 3.704695, 0.500000>, <0.135167, 3.789863, 0.434673>, <0.066880, 3.833748, 0.353500>
    }
  }
  texture {
    rubberhose
  }
  translate  <-0.557276, -78.241119, -21.480051>
}


