#declare IMPORT_SPATCH = on
#declare IMPORT_SPATCH1 = on
#ifdef( IMPORT_SPATCH1 )
  #include "bag_of_chips.pov"
#end

#macro QuadCurve( BeginCtrl, Begin, End, EndCtrl, Thickness, Step, Smooth )
  #local midM = End - Begin;
  #local initialM = End - BeginCtrl;
  #local finalM = EndCtrl - Begin;
  #local masterScale = <0, 0, 0>;
  #local curPos = Begin;  
  #local masterM = initialM/2 + finalM/2 + midM;
  #local masterScale = ( (masterM.x = 0) ? 0 : midM.x/masterM.x )*x +
  					   ( (masterM.y = 0) ? 0 : midM.y/masterM.y )*y +
  					   ( (masterM.z = 0) ? 0 : midM.z/masterM.z )*z;
  #local initialM = initialM * masterScale;
  #local finalM= finalM * masterScale;
  #local midM = midM * masterScale;
  
  sphere{ curPos, Thickness }
  
  #local cnt = 0; #while( cnt <= Step/2 )
    #local prevPos = curPos;
    #local curPos = curPos + ( initialM*( 1-cnt/(Step/2) )+midM*cnt/(Step/2) )/(Step/2);
    sphere{ curPos, Thickness }
    #if( Smooth = yes )
      cylinder{ prevPos, curPos, Thickness }
    #end
  #local cnt = cnt + 1; #end
  
  #local cnt = 0; #while( cnt < Step/2 - 3 )
    #local prevPos = curPos;
    #local curPos = curPos + ( midM*( 1-cnt/(Step/2) )+finalM*cnt/(Step/2) )/(Step/2);
    sphere{ curPos, Thickness }
    #if( Smooth = yes )
      cylinder{ prevPos, curPos, Thickness }
    #end
  #local cnt = cnt + 1; #end
  
  #if( Smooth = yes )
    cylinder{ curPos, End, Thickness }
  #end
#end

#macro CTD( Begin, End, Thickness )
  sphere{ Begin, Thickness }
  cylinder{ Begin, End, Thickness }  
#end



//global_settings { radiosity { distance_maximum 8 }}

#declare S1 = seed(0);
#declare MULTLIGHTS = off;
#declare AREALIGHT = off;
#declare DETAILEDBRICKWALL = off;
#declare DETAILEDCUP = off;      

camera{
  location <16, 19, -38> //<15, 12, -15>
  look_at <14, 5, 8> //<14, 5, 8>
  angle 35
}

light_source{
  <20, 14, 2>
  rgb <240, 232, 173>/255*1.25//-.125
  #if( AREALIGHT = on )
    area_light vrotate( 3*y, <-15, 0, -20> ), vrotate( .5*z, <-15, 0, -20> ), 6, 2
    jitter
    adaptive 1
  #end
}
#if( MULTLIGHTS = on )
  light_source{
    <20, 17, 2>
    rgb .075 *1.5
  }
  /*light_source{
    <10, 10, -40>
    rgb .2
    //rgb .05
    shadowless
  }*/
#end

/*--------------------------------------------------------------------------*/
/* LAMP */
/*--------------------------------------------------------------------------*/
union{
  difference{
    sphere{
      0, .5
      scale <6+5/8, 3.25*2, 6+5/8>
      pigment{ rgb 0 }
      finish{ specular .9 roughness .001 reflection .2 }
    }
    sphere{
      0, .5
      scale <6+5/8-1/16, 3.25*2-1/16, 6+5/8-1/16>
      pigment{ rgb <.95, .95, 1> }
      finish{ ambient .6 specular 1 roughness .002 reflection .2}
    }
    plane{
      y, 0
    }
    cone{ 2*y, 1.25-1/16, 6.24*y, 1-1/16 }
  }
  /*torus{
    (6+5/8-1/8)/2, 1/16-.0001
    translate y/16
    pigment{ rgb <.95, .95, 1> }
    finish{ ambient .6 specular 1 roughness .002 reflection .2 }
  }*/
  difference{
    cone{ 2*y, 1.25, 6.25*y, 1 }
    cone{ 2*y, 1.25-1/16, 6.24*y, 1-1/16
      pigment{ rgb <.95, .95, 1> }
      finish{ ambient .6 specular 1 roughness .002 reflection .2}
    }
    #local cnt = 0; #while( cnt < 8 )
      superellipsoid{ <.1, .1> scale <5, .5, 1/8> rotate 22.5*cnt*y translate 4.625*y}
    #local cnt = cnt + 1; #end
    pigment{ rgb 0 }
    finish{ specular .9 roughness .001 reflection .2 }
    hollow
  }
  rotate <-15, 0, -20>
  translate <20, 13, 2>
}
/*--------------------------------------------------------------------------*/
/* BRICK WALL */
/*--------------------------------------------------------------------------*/
//brick is 11.5" by 3.5"  
#if( DETAILEDBRICKWALL = on )
  difference{
    union{
      plane{ z, 30 }
      #local cnt = -18; #while( cnt < 40 )
        cylinder{
          <0, -18, 30>, <0, 24, 30>, 1/8+rand(S1)/8
          #declare cnt = cnt + rand(S1)/2;
          translate cnt*x
        }
      #end
      pigment{ rgb <151, 33, 15>/255 }
      //finish{ ambient .4 }
      hollow 
    }
    #local cnt = -24; #while( cnt < 24 )
      cylinder{
        <-18, 0, 30>, <40, 0, 30>, 9/32
        translate cnt*y
        pigment{ rgb .75 }
      }
    #local cnt = cnt + 4; #end
    #local cnt0 = -24; #while( cnt0 < 24 )
      #local cnt1 = -12;  #while( cnt1 < 40 )
        cylinder{
          <0, 0, 30>, <0, 4, 30>, 9/32
          translate <cnt1+6*mod( cnt0/4, 2 ), cnt0, 0>
          pigment{ rgb .75 }
        }
      #local cnt1 = cnt1 + 12; #end
    #local cnt0 = cnt0 + 4; #end
  }
#else
  plane{
    z, 30
    pigment{ brick rgb 1, rgb <151, 33, 15>/255 }
  }
#end


/*--------------------------------------------------------------------------*/
/* ANOTHER 'BRICK' WALL */
/*--------------------------------------------------------------------------*/
plane{
  x, 40
  texture{
    pigment{ rgb 1 }
    //normal{ crackle 1 }
  }
  hollow
}


/*--------------------------------------------------------------------------*/
/* FALLING CUP */
/*--------------------------------------------------------------------------*/
#if( DETAILEDCUP = on )
  union{
    difference{
      cone{ 0, 1.5, 5.5*y, 1.75 }
      cone{ y/16, 1.375, 6*y, 1.6875 }
      interior{ ior 1.5 }
      pigment{ rgbf <.1, .55, 1, .9> }
      finish{ specular .2 roughness .01 reflection .3 }
      normal{ bumps .5 scale .1 }
      rotate <15, 0, -30>
      hollow
    }
    difference{
      cone{ y/16, 1.374, 6.5*y, 1.6865 }
      blob{
        threshold .2
        sphere{ <.5, -.3, .5>, .7, 3 }
        sphere{ <-.5, -.2, .5>, .6, 3 }
        sphere{ <.5, .0, -.5>, .9, 3 }
        sphere{ <-.5, .1, -.5>, .8, 3 }
        scale <3, 2.5, 2>
        rotate <-15, 0, 40>
        translate 7*y
      }
      texture{
        pigment{ rgbf <.2, .1, .1, .25> }
        finish{ specular .7 roughness .05 reflection .2 }
        normal{ bumps .3 scale .5 }
      }
      texture{
        pigment{
          granite
          scale .5
          color_map{
            [0 rgbf 1]
            [0.5 rgbf 1]
            [1 rgb 1]
          }
        }
      }      
      rotate <15, 0, -30>
    }
    translate <9, .6875, 3.5>
  } 
  
  #local cnt = 0; #while( cnt < 4 )
    intersection{
      blob{
        threshold .5                               
        sphere{ <rand(S1), rand(S1), rand(S1)>, .5+rand(S1), 1 }
        sphere{ <rand(S1), rand(S1), rand(S1)>, .5+rand(S1), 1 }
        sphere{ <rand(S1), rand(S1), rand(S1)>, .5+rand(S1), 1 }
        sphere{ <rand(S1), rand(S1), rand(S1)>, .5+rand(S1), 1 }
        translate -.5
      }
      box{
        -.75, .75
        rotate <rand(S1), rand(S1), rand(S1)>
      }
      scale .4
      pigment{ rgbf <.875, 1, 1, .7> }
      interior{ ior 1.33 }
      finish{ specular 1 roughness .001 reflection .7}
      translate <1.5*rand(S1), .25*rand(S1)-1, 0>
      rotate 360*rand(S1)*y+<-15, 0, 37>
      translate 7.5*y+rand(S1)*x*3
      rotate <15, 0, -30>
      translate <9, .6875, 3.5>
      hollow
    }
  #local cnt = cnt + 1; #end

  blob{ 
    threshold .5
    #local cnt = 0; #while( cnt < 12 )
      sphere{ <rand(S1), rand(S1)/2, rand(S1)>, rand(S1), 1 translate -.5+<1.5*rand(S1), .25*rand(S1)-1, 0>
      rotate 360*rand(S1)*y+60*x+<-15, 0, 37>
      translate 7.5*y+rand(S1)*x*3}
    #local cnt = cnt + 1; #end 
    rotate <15, 0, -30>
    translate <9, .6875, 3.5>
    texture{ 
      pigment{ rgbf <.2, .1, .1, .25> }
      finish{ specular .7 roughness .05 reflection .2 }
      normal{ bumps .3 scale .5 }
    }
    texture{
      pigment{
        granite
        scale .5
        color_map{
          [0 rgbf 1]
          [0.5 rgbf 1]
          [1 rgb 1]
        }
      }
    }
    hollow
  }
#else
  cone{
    0, 1.5, 5.5*y, 1.75
    pigment{ rgbf <.1, .55, 1, .9> }
    rotate <15, 0, -30>
    translate <9, .6875, 3.5>
  }
#end
    

/*--------------------------------------------------------------------------*/
/* TABLE */
/*--------------------------------------------------------------------------*/
union{
  superellipsoid{
    <.025, .025>
    scale <20, 5/16, 12>
    translate <20, -5/16, 12>
    texture{
      pigment{
        wood
        scale <.025, .025, .1>
        rotate 75*y
        rotate 20*z
        turbulence .0625
        translate <8, 0, 4>
        color_map{
          [0 rgb <255, 214, 130>/255]
          [.6 rgb <255, 214, 130>/255]
          [1 rgb <255, 180, 100>/255]
          //[1 rgb <149, 86, 8>/255]
        }
      }
    }
  }
  superellipsoid{
    <.02, .02>
    scale <20, .3, 12>
    translate <20, -5/16, 12>
    texture{
      pigment{
        gradient y
        scale <3, .5, 3>
        translate -(5/16-.25)*y
        turbulence <.01, .05, .01>
        color_map{
          [0 rgb <49, 25, 14>/255]
          [.15 rgb <192, 128, 36>/255]
          [.3 rgb <255, 214, 130>/255]
          [.7 rgb <255, 214, 130>/255]
          [.85 rgb <192, 128, 36>/255]
          [1 rgb <49, 25, 14>/255]
        }
      } 
    }
    texture{
      pigment{
        granite
        scale <.5, .2, .5>
        color_map{
          [0 rgbf 1]
          [.4 rgbf 1]
          [1 rgb 0]
        }
      }
    }
  }
  union{
    superellipsoid{
      <.02, .02>
      scale <19.8, .5, .5>
      translate <20, -5/8-.5, .66>
    }
    superellipsoid{
      <.02, .02>
      scale <.5, .5, 19.8>
      translate <.66, -5/8-.5, 20>
    }
    superellipsoid{
      <.02, .02>
      scale <.5, 14, .5>
      translate <.66, -5/8-14, .66>
    }
    pigment{ rgb <255, 214, 130>/255 }
    finish{ specular 1 roughness .01 }
  }
}


/*--------------------------------------------------------------------------*/
/* MONITOR */
/*--------------------------------------------------------------------------*/
union{
  intersection{
    union{
      intersection{
        cylinder{
          <8, 21.25, -.1>, <8, 21.25, 4.5>, 22
        }
        box{
          -.75*y, <16, 13.25, 4.5>
        }
      }
      box{
        0, <16, 13.25, 4.5>
      }
    }
    cylinder{
      <8, -.75, 30>, <8, 13.25, 30>, 30
    }
    intersection{
      plane{
        x, 0
        rotate 30*y
        translate 1.5*x
        inverse
      }
      plane{
        y, 0
        rotate 30*x
        translate 11.75*y
      }
      plane{
        x, 0
        rotate -30*y
        translate 14.5*x
      }
      plane{
        y, 0
        rotate -30*x
        translate 1.75*y
        inverse
      }
      inverse
    }
    union{
      sphere{ -9/32*x, 9/32 }
      sphere{ 9/32*x, 9/32 }
      cylinder{ -9/32*x, 9/32*x, 9/32 }
      cylinder{ .5*z, 0, 7/32 translate -9/32*x }
      cylinder{ .5*z, 0, 7/32 translate 9/32*x }
      scale <1, 1, 2/3>
      translate -30*z
      rotate -3.4415220445*y
      translate <8, 0, 30>
      inverse
    }
    union{
      sphere{ -9/16*x, 9/32 }
      sphere{ 9/16*x, 9/32 }
      cylinder{ -9/16*x, 9/16*x, 9/32 }
      cylinder{ .5*z, 0, 7/32 translate -9/16*x }
      cylinder{ .5*z, 0, 7/32 }
      cylinder{ .5*z, 0, 7/32 translate 9/16*x }
      scale <1, 1, 2/3>
      translate -30*z
      rotate -6.69976517778*y
      translate <8, 0, 30>
      inverse
    }
    
    /*superellipsoid{
      <.1, .75>
      pigment{ rgb 1 }
      rotate 90*x
      scale <1.125/2, 9/32, 3/16>
      translate -30*z
      rotate -3.34415220445*y
      translate 30*z+8*x
      //translate 9.75*x
      inverse
    }
    superellipsoid{
      <.1, .5>
      pigment{ rgb 1 }
      rotate 90*x
      scale <1+11/16/2, 9/32, 3/16>
      translate -30*z
      rotate -6.69976517778*y
      translate 30*z+8*x
      //translate 11.5*x
      inverse
    }*/
    
    pigment{ rgb .8 }
    finish{ ambient .25 diffuse .7 }
  }
  union{
    cylinder{ .5*z, 0, 3/16 translate -9/32*x }
    cylinder{ .5*z, 0, 3/16 translate 9/32*x }
    translate -30*z
    rotate -3.4415220445*y
    translate <8, 0, 30>
    pigment{ rgb .8 }
    finish{ ambient .25 diffuse .7 }    
  }
  union{
    cylinder{ .5*z, 0, 3/16 translate -9/16*x }
    cylinder{ .5*z, 0, 3/16 }
    cylinder{ .5*z, 0, 3/16 translate 9/16*x }
    translate -30*z
    rotate -6.69976517778*y
    translate <8, 0, 30>
    pigment{ rgb .8 }
    finish{ ambient .25 diffuse .7 }
  }
  cylinder{ .5*z, -.01*z, 3/32
    translate -30*z+.5*y
    rotate -11*y
    translate <8, 0, 30>
    pigment{ green 1 }
    finish{ ambient 1 }
  }
  box{
    <1.875, -.625, 1>, <16-1.875, 0, 3>
    pigment{ rgb .8 }
    finish{ ambient .25 diffuse .7 }
  }
  intersection{
    box{ <1, 1, 0>, <15, 12.25, 4.5> }
    cylinder{ <8, 0, 30>, <8, 13.25, 30>, 30-3/8 }
    pigment{ rgb .2 }
    finish{ reflection .3 }
  }
  intersection{
    box{ <1, 1, 0>, <15, 12.25, 1> }
    cylinder{ <8, 0, 30>, <8, 13.25, 30>, 30-3/8+.0001 }
    box{ <2.25, 2.125, -1>, <13.75, 11.125, 1> inverse }
    pigment{ rgb 0 }
    finish{ reflection .2 }
  }  
  rotate <15, 20, 0>
  translate <15, 4.25, 12>
}
union{
  sphere{ 4.5*y, 4 }
  cylinder{ 0, 3/8*y, 11.5/2 }
  cone{ 3/8*y, 11.5/2, (1+3/8)*y, 7.5/2 }
  pigment{ rgb 1 }
  translate <8, 0, 7>
  rotate 20*y
  translate <15, 0, 12>
}


/*--------------------------------------------------------------------------*/
/* COMPUTER */
/*--------------------------------------------------------------------------*/
union{
  // the casing
  intersection{
    superellipsoid{
      <.05, .05>
      scale <3.5, 8, 7.75>
      translate <3.5, 8, 8.5>
    }  
    plane{ z, 1.3 inverse }
  }
  intersection{
    // front edges
    union{
      cylinder{ -3/8*x, -3/8*x+16*y, 3/4 scale <1, 1, .375> }
      cylinder{ (7+3/8)*x, (7+3/8)*x+16*y, 3/4 scale <1, 1, .375> }
      cylinder{ -.25*y, 7*x-.25*y, .5 scale <1, 1, .375> }
      cylinder{ 16.25*y, 7*x+16.25*y, .5 scale <1, 1, .375> }
      box{ 0, <7, 16, 1> }
      translate .2*z  
    }
    superellipsoid{
      <.05, .05>
      scale <3.5, 8, 1>
      translate <3.5, 8, .5>
    }
    // cut out space for power button
    cylinder{
      -z, z, 6/16
      translate <7-1.125, 8.5, 0>
      inverse
    }
    // cut out space for 5.25" bays
    box{
      -.1*z, <5.875, 5.125, 1>
      translate <.5625, 10.5, 0>
      inverse
    }
    // cut out space for 3.5" bays
    box{
      -.1*z, <4, 2.125, 1>
      translate <.5625, 7.875, 0>
      inverse
    }
  }
  // power button
  sphere{
    0, 5/16
    scale <1, 1, 1/5>
    translate <7-1.125, 8.5, .2>
  }
  // logo
  box{
    0, <1, 1, 1>
    pigment{ image_map{ png "Logo.png" } }
    translate <1, 6, .199>
  }
  cylinder{
    0, z, 3/32
    pigment{ green 1 }
    finish{ ambient 1 }
    translate <7-1.125, 8.5-1.125, .199>
  }
  cylinder{
    0, z, 3/32
    pigment{ red 1 }
    finish{ ambient 1 }
    translate <7-1.125, 8.5-2.25, .199>
  }
  // 5.25" bays
  box{
    .2*z, <5.8125, 1+2/3, 1>
    translate <.59375, 10.46875, 0>
  }
  box{
    .2*z, <5.8125, 1+2/3, 1>
    translate <.59375, 10.46875+1+2/3+1/32, 0>
  }
  intersection{
    box{
      .2*z, <5.8125, 1+2/3, 1>
      translate <.59375, 13.86458333, 0>
    }
    box{
      <-2.5-1/16, 0-1/16, 0>, <2.5+1/16, 11/16+1/16, 1>
      translate <3.5, 13.86458333+7/8, 0>
      inverse
    }
  }
  box{
    <-2.5, 0, .2>, <2.5, 11/16, 1>
    translate <3.5, 13.86458333+7/8+1/16, 0>
  }
  cylinder{
    0, .2*z, 1/8
    translate <1.125, 16-1.625, .19>
    pigment{ rgb .1 }
    //translate <1.5, .25, 6.125>
  }
  cylinder{
    -1/16*y, 1/16*y, 9/32
    translate <1.625, 16-1.625, .2+7/32>
    pigment{ rgb .4 }
  }
  cylinder{
    -1/16*z, .1*z, .5
    scale <3/4, 3/16, 1>
    translate <7-1.375, 16-1.625, .2> 
    pigment{ rgb .6 }
  }
  // 3.5" bays
  box{
    .2*z, <3.9375, 1.015625, 1>
    translate <.59375, 7.90625, 0>
  }
  intersection{
    box{
      .2*z, <3.9375, 1.015625, 1>
      translate <.59375, 7.90625+1.015625+1/32, 0>
    }
    box{
      <-1.875, -.375/sqrt(2)/2, -.375/sqrt(2)/2>,
      <1.875, .375/sqrt(2)/2, .375/sqrt(2)/2>
      rotate 45*x
      scale <1, 1, .25>
      translate <.59375+3.9375/2, 7.90625+1.015625+5/8, .2>
      inverse
    }
    box{
      <-.71875, -.75/sqrt(2)/2, -.75/sqrt(2)/2>,
      <.71875, .75/sqrt(2)/2, .75/sqrt(2)/2>
      rotate 45*x
      scale <1, 1, .5>
      translate <.59375+3.9375/2, 7.90625+1.015625+1/2, .2>
      inverse
    }
  }
  box{
   <-1.5, 3/64, -1.5>,
   <1.5, -3/64, 1.5>
   translate <.59375+3.9375/2, 7.90625+1.015625+5/8, .2+1>
   pigment{ rgb .1 }
   finish{ specular .8 roughness .01 }
  }
  // bulge on the bottom
  intersection{
    /*cylinder{
      <3.5, 3/8, .2+5+1/16-7/8>,
      <3.5, 3/8+4+7/8, .2+5+1/16-7/8>,
      5+1/16
    }*/
    #local cutOut = intersection{
      cylinder{ <0, 7.5625, -1>, <0, 7.5625, 2>, 7.875 }
      plane{ y, 0 }
      inverse
    }
    cylinder{
      <3.5, 3/8, .2+10+1/8-7/8+.5>,
      <3.5, 3/8+4+7/8, .2+10+1/8-7/8+.5>,
      10+1/8
    }                                                    
    box{
      <.59375, 3/8, -1>,
      <5.8125+.59375, 3/8+4+7/8, .2+5+1/16>
    }
    plane{
      y, 0
      rotate -45*x
      translate <0, 3/8+4+7/8, .2>
    }
    object{ cutOut translate <3.5, 4.5, 0> }
    object{ cutOut translate <3.5, 4.5-13/16, 0> }
    object{ cutOut translate <3.5, 4.5-2*13/16, 0> }
    object{ cutOut translate <3.5, 4.5-3*13/16, 0> }
    object{ cutOut translate <3.5, 4.5-4*13/16, 0> }
  }
  pigment{ rgb .7 }
  finish{ ambient .35 diffuse .6 }  rotate 3*y
  translate <1.5, .25, 6.125>
}


/*--------------------------------------------------------------------------*/
/* KEYBOARD */
/*--------------------------------------------------------------------------*/

union{
  height_field{
    tga "c:\download\keyboard\hf-keyboard.tga"
      //pigment{ rgb .7 }
      pigment{
        image_map{
          png "IM-Keyboard.png"
        }
        rotate 90*x
      }
      finish{ ambient .35 diffuse .6 }
    scale <18, .5, 6.75>
    //smooth
  }
  cylinder{ 0, 18*x, .25 translate .25*z pigment{ rgb .7 } finish{ ambient .35 diffuse .6 }}
  rotate <-6, 6, 0>
  translate <12.5, .25, 5.25>
}


/*--------------------------------------------------------------------------*/
/* MISCELLANEOUS STUFF */
/*--------------------------------------------------------------------------*/
// Keyboard cables
#declare one = -.5*z;
#declare two = 0*z;
#declare three = <-.5, .5, 1.5>;
#declare four = <-.75, .5, 3>;
#declare five = <-.75, .375, 8>;
#declare six = <-1, .125, 10>; 
#declare seven = <-1.25, 0, 12>;
#declare eight = <-1.5, -.25, 12.5>;
#declare nine =  <-1.5, -.5, 12.5>;

union{
  QuadCurve( one, two, three, four, 3/32, 25, yes )
  QuadCurve( two, three, four, five, 3/32, 25, yes )
  QuadCurve( three, four, five, six, 3/32, 25, yes )
  QuadCurve( four, five, six, seven, 3/32, 25, yes )
  QuadCurve( five, six, seven, eight, 3/32, 25, yes )
  QuadCurve( six, seven, eight, nine, 3/32, 25, yes )
  pigment{ rgb .7 }
  finish{ ambient .35 diffuse .6 }
  translate <15.5, .25, 12>
}

// Computer cables
#declare one = .5*y;
#declare two = 0*z;
#declare three = <2, -6, 1>;
#declare four = <-1, -9, 0>;
#declare five = <3, -30, 2>;
#declare six = <6, -24, -1>; 
#declare seven = <12, 1, 1>;
#declare eight = <15, 2, 1>;

union{
  QuadCurve( one, two, three, four, 3/16, 25, yes )
  QuadCurve( two, three, four, five, 3/16, 25, yes )
  QuadCurve( three, four, five, six, 3/16, 25, yes )
  QuadCurve( four, five, six, seven, 3/16, 25, yes )
  QuadCurve( five, six, seven, eight, 3/16, 25, yes )
  pigment{ rgb .7 }
  finish{ ambient .35 diffuse .6 }
  translate <8, 11, 24>
}

#declare one = .5*y;
#declare two = x;
#declare three = <3, -6, 1>;
#declare four = <0, -9, 0>;
#declare five = <-3, -35, 2>;
#declare six = <6, -30, -1>; 
#declare seven = <20, -35, 1>;
#declare eight = <25, 1, 0>;
#declare nine = <27, 2, 0>;

union{
  QuadCurve( one, two, three, four, 1/8, 25, yes )
  QuadCurve( two, three, four, five, 1/8, 25, yes )
  QuadCurve( three, four, five, six, 1/8, 25, yes )
  QuadCurve( four, five, six, seven, 1/8, 25, yes )
  QuadCurve( five, six, seven, eight, 1/8, 25, yes )
  QuadCurve( six, seven, eight, nine, 1/8, 25, yes )
  pigment{ rgb .5 }
  finish{ ambient .35 diffuse .6 }
  translate <8, 13, 24>
}

#declare one = .5*y;
#declare two = -x;
#declare three = <2, -2, 1>;
#declare four = <1, -9, 0>;
#declare five = <4, -30, 2>;
#declare six = <6, -40, -1>; 

union{
  QuadCurve( one, two, three, four, 1/8, 25, yes )
  QuadCurve( two, three, four, five, 1/8, 25, yes )
  QuadCurve( three, four, five, six, 1/8, 25, yes )
  pigment{ rgb .6 }
  finish{ ambient .35 diffuse .6 }
  translate <8.5, 14, 24.5>
}

#declare one = .5*y;
#declare two = -x;
#declare three = <2, -2, 2>;
#declare four = <4, -3, 0>;
#declare five = <7, -25, 1>;
#declare six = <8, -30, -1>; 

union{
  QuadCurve( one, two, three, four, 1/8, 25, yes )
  QuadCurve( two, three, four, five, 1/8, 25, yes )
  QuadCurve( three, four, five, six, 1/8, 25, yes )
  pigment{ rgb .5 }
  finish{ ambient .35 diffuse .6 }
  translate <8.5, 3, 24.5>
}
 
/*union{
  #local dt = 3/32
  CTD( 0, <-.25, .5, 1.5>, dt )
  CTD( <-.5, .5, 1.5>, <-.75, .5, 3>, dt )
  CTD( <-.75, .5, 3>, <-.75, .375, 8>, dt )
  CTD( <-.75, .375, 8>, <-1, .125, 10>, dt )
  CTD( <-1, .125, 10>, <-1.25, 0, 12>, dt )
  CTD( <-1.25, 0, 12>, <-1.5, -.25, 12.5>, dt )
  CTD( <-1.5, -.25, 12.5>, <-1.5, -1, 12.75>, dt )
  pigment{ rgb .7 }
  finish{ ambient .4 diffuse .4 }
  translate <15.5, .25, 12>
}*/

//---
#include "Copy of Copy of figure.inc"
/*union{
  difference{
    cone{
      0, 2.125/2, (3+13/16)*y, 2.875/2
      pigment{ rgb <.9, .1, .1> }
      normal{ crackle .15 turbulence 1 scale 2 }
    }
    cone{
      y/16, 2.125/2-1/16, (3+7/8)*y, 2.875/2-1/16
      texture{
        pigment{ rgb 1 }
        finish{ ambient .5 }
      }
      texture{ 
        pigment{
          granite
          scale 1
          color_map{
            [0 rgbf 1]
            [.6 rgbf 1]
            [1 rgb <.9, .9, .1>]
          }
        }
        finish{ ambient .4 }
      }
    }
  }
  torus{
    2.875/2, 1/16
    pigment{ rgb 1 }
    finish{ ambient .5 }
    translate (3+13/16)*y
  }
  union{
    torus{
      .098360655377*(3+5/16)+1.0625, 1/32
      translate (3+5/16)*y
    }
    torus{
      .098360655377*(3+5/16-5/16)+1.0625, 1/32
      translate (3+5/16-5/16)*y
    }
    torus{
      .098360655377*(3+5/16-5/8)+1.0625, 1/32
      translate (3+5/16-5/8)*y
    }
    pigment{ rgb <.9, .1, .1> }
    normal{ crackle .15 turbulence 1 scale 2 }
  }
  translate <2.75, 0, 2>
}*/
object{
  bag_of_chips
  /*pigment{
    image_map{ png "IM-Chips.png" }//once }
    translate <-.5, -5, 0>
    rotate 90*x
  }
  finish{ specular 1 roughness .01 }*/
  //normal{ bumps 1 scale .1}
  rotate -90*x
  rotate -78*z
  rotate 20*x
  scale <5, 5, 5>
  translate <4.5, 2.3, 3.5>
}

bicubic_patch {

/* +- 8.5" -+
   |        |
   
   1--2--3--4  -+
   |  |  |  |   |
   5--6--7--8
   |  |  |  |  11"
   9-10-11-12
   |  |  |  |   |
  13-14-15-16  -+*/

  #local Y1 = -.125;
  #local Y2 = -.25;
  #local Y3 = -.75;
  #local Y4 = -1.5;
  #local Y5 = 0.125;
  #local Y6 = 0.125;
  #local Y7 = 0.125;
  #local Y8 = -.25;
  #local Y9 = 0;
  #local Y10 = 0;
  #local Y11 = 0;
  #local Y12 = -.25;
  #local Y13 = 0;
  #local Y14 = 0;
  #local Y15 = 0;
  #local Y16 = -.25;
                 
  type 1
  u_steps 2
  v_steps 2
  <-5.5, Y1, -4.25>,<-5.5, Y2, -4.25+8.5/3>,<-5.5, Y3, 4.25-8.5/3>,<-5.5, Y4, 4.25>,
  <-5.5+11/3, Y5, -4.25>,<-5.5+11/3, Y6, -4.25+8.5/3>,<-5.5+11/3, Y7, 4.25-8.5/3>,<-5.5+11/3, Y8, 4.25>,
  <5.5-11/3, Y9, -4.25>,<5.5-11/3, Y10, -4.25+8.5/3>,<5.5-11/3, Y11, 4.25-8.5/3>,<5.5-11/3, Y12, 4.25>,
  <5.5, Y13, -4.25>,<5.5, Y14, -4.25+8.5/3>,<5.5, Y15, 4.25-8.5/3>,<5.5, Y16, 4.25> 
  pigment{
    image_map{ png "IM-Bull.png" filter 255, .5 }
    translate <-.5, -.5, 0>
    scale <8.5, 11, 1>
    rotate 90*x
    rotate 90*y
    //rgb 1
  }
  finish{ ambient .3 }
  normal{ granite 1 scale 10 }
  rotate -100*y
  translate <2.5, .001, 1.5>
}

bicubic_patch {

/* +- 8.5" -+
   |        |
   
   1--2--3--4  -+           /\ -x
   |  |  |  |   |           ||
   5--6--7--8            /_    _\
   |  |  |  |  11"    -z \-    -/ +z
   9-10-11-12               ||
   |  |  |  |   |           \/ +x
  13-14-15-16  -+ */

  #local Y1 = 0 -1.5;
  #local Y2 = 0 -1;
  #local Y3 = 0 -.5;
  #local Y4 = 0 -.5;
  #local Y5 = 1 -1;
  #local Y6 = .5;
  #local Y7 = .5;
  #local Y8 = 0;
  #local Y9 = 0 -.25;
  #local Y10 = .5;
  #local Y11 = .5;
  #local Y12 = 0;
  #local Y13 = .75 -.5;
  #local Y14 = 0;
  #local Y15 = .5;
  #local Y16 = 0;
                 
  type 1
  u_steps 2
  v_steps 2
  <-5.5, Y1, -4.25>,<-5.5, Y2, -4.25+8.5/3>,<-5.5, Y3, 4.25-8.5/3>,<-5.5, Y4, 4.25>,
  <-5.5+11/3, Y5, -4.25>,<-5.5+11/3, Y6, -4.25+8.5/3>,<-5.5+11/3, Y7, 4.25-8.5/3>,<-5.5+11/3, Y8, 4.25>,
  <5.5-11/3, Y9, -4.25>,<5.5-11/3, Y10, -4.25+8.5/3>,<5.5-11/3, Y11, 4.25-8.5/3>,<5.5-11/3, Y12, 4.25>,
  <5.5, Y13, -4.25>,<5.5, Y14, -4.25+8.5/3>,<5.5, Y15, 4.25-8.5/3>,<5.5, Y16, 4.25>
  pigment{
    image_map{ png "IM-Notepad.png" }
    translate <-.5, -.5, 0>
    scale <8.5, 11, 1>
    rotate 90*x
    rotate -90*y
  }
  finish{ ambient .3 }
  normal{ granite 1 scale 10 }
  rotate -30*y
  translate <1, .0011, 1>
}

// Sticky Note #1
bicubic_patch {

/* +-  3"  -+
   |        |
   
   4--3--2--1  -+           /\ +y
   |  |  |  |   |           ||
   8--7--6--5            /_    _\
   |  |  |  |   3"    -x \-    -/ +x
  12-11-10--9               ||
   |  |  |  |   |           \/ -y
  16-15-14-13  -+ */

  #local Y1 = -.25;
  #local Y2 = 0;
  #local Y3 = 0;
  #local Y4 = .5;
  #local Y5 = 0;
  #local Y6 = 0;
  #local Y7 = 0;
  #local Y8 = 0;
  #local Y9 = -.06;
  #local Y10 = 0;
  #local Y11 = 0;
  #local Y12 = -.125;
  #local Y13 = -.25;
  #local Y14 = -.125;
  #local Y15 = -.25;
  #local Y16 = -.375;
                 
  type 1
  u_steps 3
  v_steps 3
  <-1.5, 1.5, Y1>,<-.5, 1.5, Y2>,<.5, 1.5, Y3>,<1.5, 1.5, Y4>,
  <-1.5, .5, Y5>,<-.5, .5, Y6>,<.5, .5, Y7>,<1.5, .5, Y8>,
  <-1.5, -.5, Y9>,<-.5, -.5, Y10>,<.5, -.5, Y11>,<1.5, -.5, Y12>,
  <-1.5, -1.5, Y13>,<-.5, -1.5, Y14>,<.5, -1.5, Y15>,<1.5, -1.5, Y16>
  pigment{
    image_map{ png "IM-Sticky1.png" }
    scale 3
    translate <-1.5, -1.5, 0>
    //rgb <217, 217, 64>/255
  }
  finish{ ambient .3 }
  normal{ crackle 1 scale 3 }
  rotate <0, 22, -5>
  translate <16.75, 13.5, 13.25>
}

// Sticky Note #2
bicubic_patch {

/* +-  3"  -+
   |        |
   
   4--3--2--1  -+           /\ +y
   |  |  |  |   |           ||
   8--7--6--5            /_    _\
   |  |  |  |   3"    -x \-    -/ +x
  12-11-10--9               ||
   |  |  |  |   |           \/ -y
  16-15-14-13  -+ */

  #local Y1 = -.25;
  #local Y2 = 0;
  #local Y3 = 0;
  #local Y4 = .25;
  #local Y5 = 0;
  #local Y6 = 0;
  #local Y7 = -.125;
  #local Y8 = 0;
  #local Y9 = -.06;
  #local Y10 = 0;
  #local Y11 = 0;
  #local Y12 = -.125;
  #local Y13 = -.375;
  #local Y14 = -.25;
  #local Y15 = -.125;
  #local Y16 = -.25;
                 
  type 1
  u_steps 3
  v_steps 3
  <-1.5, 1.5, Y1>,<-.5, 1.5, Y2>,<.5, 1.5, Y3>,<1.5, 1.5, Y4>,
  <-1.5, .5, Y5>,<-.5, .5, Y6>,<.5, .5, Y7>,<1.5, .5, Y8>,
  <-1.5, -.5, Y9>,<-.5, -.5, Y10>,<.5, -.5, Y11>,<1.5, -.5, Y12>,
  <-1.5, -1.5, Y13>,<-.5, -1.5, Y14>,<.5, -1.5, Y15>,<1.5, -1.5, Y16>
  pigment{
    image_map{ png "IM-Sticky2.png" }
    scale 3
    translate <-1.5, -1.5, 0>
    //rgb <217, 217, 64>/255
  }
  finish{ ambient .3 }
  normal{ crackle 1 scale 2.5 translate 1 rotate 80*z }
  rotate <0, 22, 10>
  translate <16.75, 10.5, 13.25>
}

// Sticky Note #3
bicubic_patch {

/* +-  3"  -+
   |        |
   
   4--3--2--1  -+           /\ +y
   |  |  |  |   |           ||
   8--7--6--5            /_    _\
   |  |  |  |   3"    -x \-    -/ +x
  12-11-10--9               ||
   |  |  |  |   |           \/ -y
  16-15-14-13  -+ */

  #local Y1 = -.25;
  #local Y2 = 0;
  #local Y3 = 0;
  #local Y4 = .25;
  #local Y5 = 0;
  #local Y6 = 0;
  #local Y7 = -.06;
  #local Y8 = 0;
  #local Y9 = -.25;
  #local Y10 = 0;
  #local Y11 = -.25;
  #local Y12 = -.375;
  #local Y13 = -.5;
  #local Y14 = -.75;
  #local Y15 = -.5;
  #local Y16 = -.5;
                 
  type 1
  u_steps 3
  v_steps 3
  <-1.5, 1.5, Y1>,<-.5, 1.5, Y2>,<.5, 1.5, Y3>,<1.5, 1.5, Y4>,
  <-1.5, .5, Y5>,<-.5, .5, Y6>,<.5, .5, Y7>,<1.5, .5, Y8>,
  <-1.5, -.5, Y9>,<-.5, -.5, Y10>,<.5, -.5, Y11>,<1.5, -.5, Y12>,
  <-1.5, -1.5, Y13>,<-.5, -1.5, Y14>,<.5, -1.5, Y15>,<1.5, -1.5, Y16>
  pigment{
    image_map{ png "IM-Sticky3.png" }
    scale 3
    translate <-1.5, -1.5, 0>
    //rgb <217, 217, 64>/255
  }
  finish{ ambient .3 }
  normal{ crackle 1 scale 2.5 rotate 20*z }
  rotate <5, 30, 5>
  translate <16.5, 4, 12.25>
}

// Sticky Note #4
bicubic_patch {

/* +-  3"  -+
   |        |
   
   4--3--2--1  -+           /\ +y
   |  |  |  |   |           ||
   8--7--6--5            /_    _\
   |  |  |  |   3"    -x \-    -/ +x
  12-11-10--9               ||
   |  |  |  |   |           \/ -y
  16-15-14-13  -+ */

  #local Y1 = -.25;
  #local Y2 = 0;
  #local Y3 = 0;
  #local Y4 = -.25;
  #local Y5 = 0;
  #local Y6 = 0;
  #local Y7 = -.06;
  #local Y8 = 0;
  #local Y9 = 0;
  #local Y10 = 0;
  #local Y11 = 0;
  #local Y12 = .125;
  #local Y13 = -.25;
  #local Y14 = 0;
  #local Y15 = -.25;
  #local Y16 = -.25;
                 
  type 1
  u_steps 3
  v_steps 3
  <-1.5, 1.5, Y1>,<-.5, 1.5, Y2>,<.5, 1.5, Y3>,<1.5, 1.5, Y4>,
  <-1.5, .5, Y5>,<-.5, .5, Y6>,<.5, .5, Y7>,<1.5, .5, Y8>,
  <-1.5, -.5, Y9>,<-.5, -.5, Y10>,<.5, -.5, Y11>,<1.5, -.5, Y12>,
  <-1.5, -1.5, Y13>,<-.5, -1.5, Y14>,<.5, -1.5, Y15>,<1.5, -1.5, Y16>
  pigment{
    image_map{ png "IM-Sticky4.png" }
    scale 3
    translate <-1.5, -1.5, 0>
    //rgb <217, 217, 64>/255
  }
  finish{ ambient .3 }
  normal{ crackle 1 scale 3.5 rotate -40*z }
  rotate <7, 30, -10>
  translate <18, 5, 11.25>
}