#include "colors.inc"
#include "shapes.inc"
#include "WTF.inc"
camera {
   location <5010, 28, 4990>  
   sky       <0, 1, 0>
   up        <0, 1, 0>
   right     <1, 0, 0>
   look_at   <5000, 4000, 0>
   angle 100
}
light_source { <-5010, 29, 5000> color <.6,.6,.6.2> shadowless }
height_field {
     gif "hopeless.ghf"
     scale <10000,80, 10000>
     texture {
     pigment { rgbt < 0, 0, 0, 0 > }
     finish {crand 0.0 reflection 0.8  diffuse 0.5 ambient 0.2 phong 0}        
     }
     normal { agate 0.5  scale 16 }
     smooth
}
#declare the_sun =        
 pigment {
  gradient y
  color_map {
   [0 color rgbt 1.5*<1,0.95,0.90,0>]
   [0.0003 color rgbt 1.5*<1,.95,.9,0>]
   [0.0005 color rgbt <1,0.8,0.8,.2>]
   [0.05 color rgbt <.7,.6,.9,.2>]
   [0.1 color rgbt <.6,.6,1.2,.5>]
   [1 color rgbt <1,1,2,.7>]
  }
  scale 2
  translate -1
  rotate -93*x  
  rotate y*180 
  turbulence .00002
 }
#declare cl1 =
 pigment {
  wrinkles
  turbulence .5
  octaves 6
  lambda 5
  omega .5
  color_map {
   [0 color rgbt <1,1,1,1>]
   [0.5 color rgbt <0.96,0.97,0.97,0.87>]
   [1 color rgbt <1,1,1,1>]
  }
  scale <0.8,1,0.8>
  }
#declare cl2 =
 pigment {
  wrinkles
  turbulence .4
  octaves 6
  lambda 5
  omega .5
  color_map {
   [0 color rgbt <1,1,1,1>]
   [0.25 color rgbt <0.95,0.95,0.94,0.85>]
   [0.50 color rgbt <1,1,1,1>]
   [0.75 color rgbt <0.95,0.94,0.95,0.85>]
   [1 color rgbt <1,1,1,1>]
  }
  scale <0.7,1,0.7>
  }
plane {
  <0,1,0>, 227
  pigment {
  wrinkles
  turbulence .4
  octaves 6
  lambda 5
  omega .5
  color_map {
   [0 color rgbf <1,1,1,1>]
   [0.25 color rgbf <1.15,1.14,1.15,1.2>]
   [0.50 color rgbf <1.2,1.2,1.2,1.65>]
   [0.75 color rgbf <1.15,1.14,1.15,1.2>]
   [1 color rgbf <1,1,1,1>]
  }
}     
hollow
scale <45,1,15>
}
fog {
 distance 2000
 color rgbt <.6.6.6.66>
 fog_type 1
 fog_offset 1
 fog_alt 10
}
fog {
 distance 2000
 color rgbt <.6.6.6.66>
 fog_type 2
 fog_offset 20
 fog_alt 10 
 turbulence 0.2
 turb_depth 0.2
}
fog {
 distance 5000
 color rgbt <.6.6.6.66>
 fog_type 2
 fog_offset 40
 fog_alt 20
 turbulence 1
 turb_depth 0.2
}
sky_sphere {            
 pigment { the_sun }
 pigment { cl1 }
 pigment { cl2 }
}
