//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 6 lights, 28 textures and 381 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/25/1998    (25.10.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 4
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera De_Cerca
  location  <-2.700, 4.800, 11.400>
  direction <0.0,     0.0,  0.9700>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-0.700, 7.150, 11.750>
}

//    Other cameras are commented out.
/*
camera {  //  Camera Aerea
  location  <-8.900, -0.500, 15.900>
  direction <0.0,     0.0,  2.0024>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-1.048, 6.753, 11.500>
}

*/

/*
camera {  //  Camera CloseUP
  location  <-2.700, 4.800, 11.400>
  direction <0.0,     0.0,  0.9521>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-0.623, 7.101, 11.596>
}

*/

/*
camera {  //  Camera De_Cerca1
  location  <-3.150, 4.600, 11.450>
  direction <0.0,     0.0,  1.0465>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-2.300, 5.500, 11.500>
}

*/

/*
camera {  //  Camera Debug1
  location  <8.450, -1.800, 2.400>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <1.600, 0.000, 1.350>
}

*/

/*
camera {  //  Camera De_Cerca2
  location  <-2.953, 4.635, 11.502>
  direction <0.0,     0.0,  1.0465>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-0.914, 7.150, 11.616>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <-34.600, 5.650, 14.800>
  color rgb <0.700, 0.700, 0.700>
  shadowless
}

#declare AreaLite001 = light_source { // AreaLite001
  <-0.400, -2.350, 23.550>
  color  rgb<0.750, 0.750, 0.600>
  area_light <9.940, 0.000, 0.000>, <0.000, 0.560, 0.000>, 3, 2
  adaptive 2
  jitter
}


object { AreaLite001 }



//
// ********  TEXTURES  *******
//

#include "pileta3.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Chorro = object {
  cylinder { // Chorro
    <0,0,1>, <0,0,0>, 1 open
    texture {
      AguaChorro
    }
    hollow
    scale <0.1, 0.1, 3.0>
    translate  <-1.393637, 7.078635, 10.25>
  }
}






#declare Azulejo001 = object {
  superellipsoid { // Azulejo001
    <0.1, 0.1>
    scale <0.5, 0.1, 0.5>
    translate  <14.5, 10.0, 11.8>
  }
}
#declare AzulejosRealesX = union {
  object { Azulejo001 }
  object { // Azulejo2->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-1.02, -0.0, 0.0>
  }
  object { // Azulejo3->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-2.04, -0.0, 0.0>
  }
  object { // Azulejo4->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-3.06, -0.0, 0.0>
  }
  object { // Azulejo5->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-4.08, -0.0, 0.0>
  }
  object { // Azulejo6->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-5.1, -0.0, 0.0>
  }
  object { // Azulejo7->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-6.12, -0.0, 0.0>
  }
  object { // Azulejo8->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-7.14, -0.0, 0.0>
  }
  object { // Azulejo9->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-8.16, -0.0, 0.0>
  }
  object { // Azulejo10->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-9.18, -0.0, 0.0>
  }
  object { // Azulejo11->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-10.2, -0.0, 0.0>
  }
  object { // Azulejo12->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-11.22, -0.0, 0.0>
  }
  object { // Azulejo13->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-12.24, -0.0, 0.0>
  }
  object { // Azulejo14->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-13.26, -0.0, 0.0>
  }
  object { // Azulejo15->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-14.28, -0.0, 0.0>
  }
  object { // Azulejo16->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-15.3, -0.0, 0.0>
  }
  object { // Azulejo17->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-16.32, -0.0, 0.0>
  }
  object { // Azulejo18->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-17.34, -0.0, 0.0>
  }
  object { // Azulejo19->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-18.36, -0.0, 0.0>
  }
  object { // Azulejo20->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-19.38, -0.0, 0.0>
  }
  object { // Azulejo21->Azulejo001
    Azulejo001
    rotate 0.0*x
    translate  <-20.4, -0.0, 0.0>
  }
  texture {
    TAzulejo
  }
}
#declare TapaCanilla = intersection {
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1 
    scale <0.18, 0.18, 0.05>
    translate  0.8*z
  }
  sphere { // TapaCanilla1
    <0,0,0>,1
    scale <1.0, 1.0, 0.5>
    translate  0.349364*z
  }
}
#declare Canilla_3 = difference {
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.8>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate -10.0*y
    translate  <0.65, 0.0, 0.1>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate -10.0*x
    translate  <0.0, -0.65, 0.1>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate 10.0*y
    translate  <-0.65, 0.0, 0.1>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.8>
    rotate 10.0*x
    translate  <0.0, 0.65, 0.1>
  }
}
#declare Canilla2 = intersection {
  object { Canilla_3 }
  sphere { // Sphere5
    <0,0,0>,1
    translate  -0.1*z
  }
  texture {
    MetalPileta
  }
}


#declare PataTrasera2 = union {
  sphere { // Sphere15
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
}
#declare PataMedio2 = union {
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere16
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
}
#declare PataDelantera2 = union {
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere17
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
}
#declare PataTrasera3 = union {
  sphere { // Sphere18
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataMedio3 = union {
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere19
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataDelantera3 = union {
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr57
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
}
#declare Antena2 = union {
  cylinder { // Cylndr58
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <170.752625, 17.79323, 179.126266>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere21
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr59
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  rotate <-4.0, 70.0, -20.0>
  translate  <2.0, 0.15, 1.65>
}
#declare Antena3 = union {
  cylinder { // Cylndr60
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <171.0, 18.0, 180.0>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere22
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr61
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
  rotate <-2.922746, 71.100021, 12.285197>
  translate  <2.0, -0.1, 1.65>
}
#declare Parpado2 = difference {
  sphere { // Ojo7
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane9
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, -0.25, 1.75>
}
#declare Parpado3 = difference {
  sphere { // Ojo8
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane10
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, 0.25, 1.75>
}
#declare Cabeza1 = union {
  cone { // Tenaza2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <-15.0, -80.0, -1.5>
    translate  <2.6, 0.1, -0.25>
  }
  cone { // Tenaza3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <15.0, -80.0, 1.5>
    translate  <2.6, -0.1, -0.25>
  }
  sphere { // Craneo1
    <0,0,0>,1
    scale <0.7, 0.7, 0.6>
    rotate 10.0*y
    translate  1.45*x
  }
  sphere { // Ojo5
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, 0.25, 0.25>
  }
  sphere { // Ojo6
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, -0.25, 0.25>
  }
  object { Antena2 }
  object { Antena3 }
  object { Parpado2 }
  object { Parpado3 }
  translate  -0.25*x
}
#declare Hormiga1 = union {
  sphere { // Cola1
    <0,0,0>,1
    scale <1.48, 1.0, 1.0>
    rotate -10.0*y
    translate  <-1.85, 0.0, 0.05>
  }
  sphere { // Torax1
    <0,0,0>,1
    scale <0.56, 0.47, 0.33>
  }
  object { PataTrasera2 }
  object { PataMedio2 }
  object { PataDelantera2 }
  object { PataTrasera3 }
  object { PataMedio3 }
  object { PataDelantera3 }
  object { Cabeza1 }
  texture {
    THormiga
  }
  scale 0.03
  rotate <7.09597, -18.74724, -111.172836>
  translate  <-2.0, 6.15, 10.85>
}
#declare PataTrasera8 = union {
  sphere { // Sphere46
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
}
#declare PataMedio8 = union {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere47
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
}
#declare PataDelantera8 = union {
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere48
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
}
#declare PataTrasera9 = union {
  sphere { // Sphere49
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataMedio9 = union {
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere50
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataDelantera9 = union {
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere51
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
}
#declare Antena8 = union {
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <170.752625, 17.79323, 179.126266>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere52
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  rotate <-4.0, 70.0, -20.0>
  translate  <2.0, 0.15, 1.65>
}
#declare Antena9 = union {
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <171.0, 18.0, 180.0>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere53
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
  rotate <-2.922746, 71.100021, 12.285197>
  translate  <2.0, -0.1, 1.65>
}
#declare Parpado8 = difference {
  sphere { // Ojo19
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane15
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, -0.25, 1.75>
}
#declare Parpado9 = difference {
  sphere { // Ojo20
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane16
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, 0.25, 1.75>
}
#declare Cabeza4 = union {
  cone { // Tenaza8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <-15.0, -80.0, -1.5>
    translate  <2.6, 0.1, -0.25>
  }
  cone { // Tenaza9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <15.0, -80.0, 1.5>
    translate  <2.6, -0.1, -0.25>
  }
  sphere { // Craneo4
    <0,0,0>,1
    scale <0.7, 0.7, 0.6>
    rotate 10.0*y
    translate  1.45*x
  }
  sphere { // Ojo17
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, 0.25, 0.25>
  }
  sphere { // Ojo18
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, -0.25, 0.25>
  }
  object { Antena8 }
  object { Antena9 }
  object { Parpado8 }
  object { Parpado9 }
  translate  -0.25*x
}
#declare Hormiga4 = union {
  sphere { // Cola4
    <0,0,0>,1
    scale <1.48, 1.0, 1.0>
    rotate -10.0*y
    translate  <-1.85, 0.0, 0.05>
  }
  sphere { // Torax4
    <0,0,0>,1
    scale <0.56, 0.47, 0.33>
  }
  object { PataTrasera8 }
  object { PataMedio8 }
  object { PataDelantera8 }
  object { PataTrasera9 }
  object { PataMedio9 }
  object { PataDelantera9 }
  object { Cabeza4 }
  texture {
    THormiga
  }
  scale 0.03
  rotate <48.353783, -88.328629, 48.353096>
  translate  <-1.15, 9.85, 11.55>
}
#declare Tenazza = difference {
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.8, 0.3, 0.15>
    translate  3.0*x
  }
  plane { // Plane002
    z,0
    rotate 90.0*x
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.4>
    translate  <3.15, 0.0, -0.2>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <0.12, 0.12, 0.4>
    translate  <3.4, 0.0, -0.2>
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.4>
    translate  <3.65, 0.05, -0.2>
  }
  rotate 5.0*y
  translate  <-0.9, -0.1, 0.05>
}


#declare BezPtch3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.916779, -0.381051, 0.505884>, <-1.526126, -0.381051, 0.303530>, <-1.000000, -1.385846, 0.000000>, <0.000000, -1.442049, 0.000000>, 
      <-3.916779, -0.120838, 0.505884>, <-1.526126, -0.120838, 0.303530>, <-0.882297, -1.027589, -0.916096>, <0.021687, -1.075212, -0.966685>, 
      <-3.916779, 0.139375, 0.505884>, <-1.526126, 0.139375, 0.303530>, <-0.882297, 1.067899, -0.916096>, <0.021687, 1.099308, -0.966685>, 
      <-3.916779, 0.399587, 0.505884>, <-1.526126, 0.399587, 0.303530>, <-1.000000, 1.403734, 0.000000>, <0.000000, 1.452741, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.442049, 0.000000>, <1.000000, -1.498251, 0.000000>, <2.000000, -1.498251, 0.000000>, <3.000000, -0.757438, 0.000000>, 
      <0.021687, -1.075212, -0.966685>, <0.925672, -1.122835, -1.017273>, <1.925672, -1.122835, -1.017273>, <3.529624, -0.251890, 0.000000>, 
      <0.021687, 1.099308, -0.966685>, <0.925672, 1.130717, -1.017273>, <1.925672, 1.130717, -1.017273>, <3.529624, 0.253658, 0.000000>, 
      <0.000000, 1.452741, 0.000000>, <1.000000, 1.501749, 0.000000>, <2.000000, 1.501749, 0.000000>, <3.000000, 0.759206, 0.000000>
    }
  }
  texture {
    Chrome_Texture
  }
  scale 0.1
  translate  <0.75, 0.0, -0.05>
}
#declare Cuchara2 = union {
  superellipsoid { // mangoCuchara2
    <1.0, 0.1>
    texture {
      TMangoBeige
    }
    scale <0.02, 0.06, 0.4>
    rotate -90.0*y
  }
  object { BezPtch3 }
  rotate <63.697514, -78.831047, -63.259796>
  translate  <4.323521, 8.680264, 11.936177>
}
#declare Cuerpo = difference {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 0.8>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    scale <0.24, 0.24, 1.0>
    translate  0.1*z
  }
}
#declare MangoTaza = intersection {
  torus { // Torus003
    1.6, 0.4  rotate -x*90
    scale <0.1, 0.12, 0.2>
    rotate -90.0*x
    translate  <-0.374081, 0.0, 0.4>
  }
  plane { // Plane001
    z,0
    scale 0.1
    rotate 90.0*y
    translate  <-0.3, 0.0, 0.4>
  }
}
#declare Taza = union {
  object { Cuerpo }
  object { MangoTaza }
  torus { // Torus3
    1.75, 0.25  rotate -x*90
    scale <0.175, 0.175, 0.2>
  }
  torus { // Torus002
    1.7, 0.3  rotate -x*90
    scale <0.175, 0.175, 0.2>
    translate  0.8*z
  }
  texture {
    Esmalte
  }
  scale 1.2
  translate  <4.35, 8.55, 11.4>
}
#declare Vaso = difference {
  cone { // Cone001
    <0,0,0>, 0.25, <0,0,1>, 0.3
    scale <1.0, 1.0, 0.8>
  }
  cone { // Cone2
    <0,0,0>, 0.25, <0,0,1>, 0.3
    scale 0.8
    translate  0.15*z
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 0.4>
    rotate <-0.0, 1.0, -60.0>
    translate  <0.15, -0.259808, 0.15>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 0.4>
    rotate <-0.0, 1.0, -120.0>
    translate  <-0.15, -0.259808, 0.15>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 0.4>
    rotate <0.0, 1.0, 180.0>
    translate  <-0.3, 0.0, 0.15>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 0.4>
    rotate <0.0, 1.0, 120.0>
    translate  <-0.15, 0.259808, 0.15>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 0.4>
    rotate <0.0, 1.0, 60.0>
    translate  <0.15, 0.259808, 0.15>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.15, 0.4>
    rotate 1.0*y
    translate  <0.3, 0.0, 0.15>
  }
  texture {
    Vidrio
  }
  scale <1.3, 1.3, 1.2>
  translate  <4.3, 7.5, 11.3>
}
#declare Platito1 = lathe {
  linear_spline
  8  // control points
  <-0.000554, -0.051064>,
  <0.7848, -0.050239>,
  <0.957905, 0.035499>,
  <1.146683, 0.057161>,
  <1.147932, 0.06872>,
  <0.940867, 0.071333>,
  <0.756007, 0.019326>,
  <0.000874, 0.019326>
  rotate <90,0,90>
  texture {
    Durax
  }
  scale <0.5, 0.5, 1.0>
  translate  <2.75, 7.65, 11.45>
}
#declare Platito5 = lathe {
  linear_spline
  8  // control points
  <-0.000554, -0.051064>,
  <0.7848, -0.050239>,
  <0.957905, 0.035499>,
  <1.146683, 0.057161>,
  <1.147932, 0.06872>,
  <0.940867, 0.071333>,
  <0.756007, 0.019326>,
  <0.000874, 0.019326>
  rotate <90,0,90>
  texture {
    Texture1
  }
  rotate -90.0*y
  translate  <5.15, 8.45, 14.95>
}
#declare Vaso1 = object {
  object { // Vaso1->Vaso
    Vaso
    rotate <180.0, -0.0, -0.0>
    translate  <2.9, 16.55, 28.4>
  }
}
#declare Envase = lathe {
  linear_spline
  7  // control points
  <0.557364, 0.021851>,
  <0.372361, 2.093747>,
  <0.469773, 2.634643>,
  <0.173472, 2.784215>,
  <0.170299, 2.909577>,
  <0.044098, 2.938212>,
  <0.024966, 3.011793>
  rotate <90,0,90>
  texture {
    TDeter
  }
  rotate -35.0*z
  translate  <2.15, 9.05, 11.3>
}




//
// ********  OBJECTS  *******
//

box { // Cube004
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Pino_Tea
  }
  scale <8.0, 0.5, 0.1>
  translate  <7.0, 9.5, 17.55>
}




union { // Luces
  object { // AreaLite2->AreaLite001
    AreaLite001
    translate  <-2.0, 0.0, 0.0>
  }
}


union { // Aguas
  object { Chorro }
  box { // AguaPileta
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <3.5, 2.7, 2.0>
    translate  <-0.7, 7.0, 8.85>
    texture {
      Agua
    }
  }
}


#declare CieloRaso = difference {
  box { // ParedesAfuera1
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <18.0, 11.0, 14.0>
    translate  12.5*z
  }
  box { // ParedesAdentro1
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <15.0, 10.0, 12.5>
    translate  12.5*z
  }
  scale 1.02
  texture {
    PinturaPared
  }
}
#declare AzulejosReales = union {
  object { AzulejosRealesX }
  object { // AzulejosRealesX1->AzulejosRealesX
    AzulejosRealesX
    translate  1.02*z
  }
  object { // AzulejosRealesX2->AzulejosRealesX
    AzulejosRealesX
    translate  2.04*z
  }
}
#declare Pared = union {
  object { CieloRaso }
  object { AzulejosReales }
}
#declare Trapo = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.083943, -1.037809, -0.008543>, <-2.000000, -1.009829, -0.008543>, <-1.000000, -1.009829, -0.008543>, <0.000000, -1.009829, -0.008543>, 
      <-3.000000, -0.997335, 0.088892>, <-2.000000, -0.997335, 0.088892>, <-1.000000, -0.997335, 0.088892>, <0.000000, -0.997335, 0.088892>, 
      <-3.000000, 0.002665, 0.050939>, <-2.000000, 0.002665, 0.050939>, <-1.000000, 0.002665, 0.050939>, <0.000000, 0.002665, 0.050939>, 
      <-3.111924, 1.027981, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.009296, 0.002817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.009829, -0.008543>, <1.000000, -1.009829, -0.008543>, <2.000000, -1.009829, -0.008543>, <3.000000, -1.009829, -0.008543>, 
      <0.000000, -0.997335, 0.088892>, <1.000000, -0.997335, 0.088892>, <2.000000, -0.997335, 0.088892>, <3.000000, -0.997335, 0.088892>, 
      <0.000000, 0.002665, 0.050939>, <1.000000, 0.002665, 0.050939>, <2.000000, 0.002665, 0.050939>, <3.000000, 0.002665, 0.050939>, 
      <0.000000, 1.009296, 0.002817>, <1.000000, 1.018592, 0.005634>, <2.000000, 1.018592, 0.005634>, <3.027981, 1.051931, 0.081540>
    }
  }
  texture {
    TrapoTex
  }
  scale <0.557908, 0.373724, 1.0>
  translate  <-0.65, 4.6, 11.3>
}
#declare Grifo_3 = difference {
  torus { // Torus2
    0.45, 0.15  rotate -x*90
    rotate -90.0*y
    translate  <-0.8, 7.4, 13.3>
  }
  plane { // Plane4
    z,0
    translate  <-2.3, 7.4, 13.3>
  }
  plane { // Plane5
    z,0
    rotate <-120.0, -0.0, -0.0>
    translate  <-2.3, 7.4, 13.3>
  }
  translate  <0.1, 1.15, -0.65>
}
#declare Grifo_2 = difference {
  torus { // Torus001
    0.45, 0.15  rotate -x*90
    rotate -90.0*y
    translate  <-0.8, 7.4, 13.3>
  }
  plane { // Plane3
    z,0
    rotate 60.0*x
    translate  <-2.3, 7.4, 13.3>
  }
  plane { // Plane2
    z,0
    translate  <-2.3, 7.4, 13.3>
  }
  translate  <0.1, 0.007, 0.009>
}
#declare Canion = union {
  object { Grifo_3 }
  object { Grifo_2 }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.32>
    rotate 60.0*x
    translate  <-0.7, 8.775, 13.039>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.35>
    translate  <-0.7, 9.0, 12.3>
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.17, 0.3>
    translate  <-0.7, 6.95, 13.0>
  }
  rotate -20.0*z
  translate  <-3.12, 0.3, -0.1>
}
#declare Canilla1 = union {
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1 
    texture {
      Fria
    }
    scale <0.3, 0.3, 0.1>
    translate  0.72*z
  }
  object { // TapaCanilla2->TapaCanilla
    TapaCanilla
  }
  object { // Canilla3->Canilla2
    Canilla2
  }
  scale 0.6
  rotate 90.0*x
  translate  <0.5, 8.65, 12.1>
}
#declare Canilla = union {
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1 
    texture {
      Caliente
    }
    scale <0.3, 0.3, 0.1>
    translate  0.72*z
  }
  object { TapaCanilla }
  object { Canilla2 }
  scale 0.6
  rotate 90.0*x
  translate  <-2.0, 8.65, 12.1>
}
#declare Grifo = union {
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1 
    scale <0.12, 0.12, 1.4>
    rotate 90.0*x
    translate  <-2.0, 10.0, 12.1>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1 
    scale <0.12, 0.12, 1.4>
    rotate 90.0*x
    translate  <0.5, 10.0, 12.1>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale <0.5, 0.25, 0.3>
    translate  <-0.7, 9.0, 12.1>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 2.5>
    rotate -90.0*y
    translate  <0.5, 9.0, 12.1>
  }
  object { Canion }
  object { Canilla1 }
  object { Canilla }
  texture {
    MetalCanilla
  }
}
#declare Pileta = difference {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 2.7, 2.0>
    translate  <-0.7, 7.0, 9.0>
  }
  superellipsoid { // SuperQ2
    <0.1, 0.4>
    scale <2.8, 2.3, 2.0>
    translate  <-0.7, 7.0, 11.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    translate  <-0.7, 7.0, 7.5>
  }
  texture {
    MetalPileta
  }
}
#declare Marmol_Mesada = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 3.0, 0.15>
    translate  <5.0, 7.0, 11.15>
  }
  superellipsoid { // SuperQ001
    <0.1, 0.4>
    scale <2.7, 2.0, 2.0>
    translate  <-0.7, 7.0, 11.0>
  }
  texture {
    Marmol
  }
}
#declare Armario_de_Mesada = difference {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <9.9, 2.9, 5.5>
    translate  <5.1, 7.1, 5.5>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 2.7, 3.0>
    translate  <-0.7, 7.0, 10.0>
  }
  texture {
    Pino_Tea
    scale <2.53, 0.28, 1.0>
  }
  translate  -0.2*x
}
#declare ArmaduraLateral = union {
  sphere { // Sphere23
    <0,0,0>,1
    scale 0.03
    translate  <1.75, 0.0, 0.4>
  }
  sphere { // Sphere24
    <0,0,0>,1
    scale 0.03
    translate  <1.0, 0.0, 2.0>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.03
    translate  2.0*z
  }
  sphere { // Sphere2
    <0,0,0>,1
    scale 0.03
    translate  1.75*x
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.03
  }
  cylinder { // Cylndr68
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate 90.0*y
    translate  2.0*z
  }
  cylinder { // Cylndr69
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.76>
    rotate -25.0*y
    translate  <1.75, 0.0, 0.4>
  }
  cylinder { // Cylndr70
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.4>
    translate  1.75*x
  }
  cylinder { // Cylndr71
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.75>
    rotate 90.0*y
  }
  cylinder { // Cylndr72
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 2.0>
  }
}
#declare ArmaduraLateral2 = union {
  sphere { // Sphere25
    <0,0,0>,1
    scale 0.03
    translate  <1.75, 0.0, 0.4>
  }
  sphere { // Sphere26
    <0,0,0>,1
    scale 0.03
    translate  <1.0, 0.0, 2.0>
  }
  sphere { // Sphere27
    <0,0,0>,1
    scale 0.03
    translate  2.0*z
  }
  sphere { // Sphere28
    <0,0,0>,1
    scale 0.03
    translate  1.75*x
  }
  sphere { // Sphere29
    <0,0,0>,1
    scale 0.03
  }
  cylinder { // Cylndr73
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate 90.0*y
    translate  2.0*z
  }
  cylinder { // Cylndr74
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.76>
    rotate -25.0*y
    translate  <1.75, 0.0, 0.4>
  }
  cylinder { // Cylndr75
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.4>
    translate  1.75*x
  }
  cylinder { // Cylndr76
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.75>
    rotate 90.0*y
  }
  cylinder { // Cylndr77
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 2.0>
  }
  translate  3.0*y
}
#declare ArmaduraFrontal = union {
  cylinder { // Cylndr78
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <1.15, 0.0, 1.7>
  }
  cylinder { // Cylndr79
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  1.7*z
  }
  cylinder { // Cylndr80
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  0.4*z
  }
  cylinder { // Cylndr81
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <1.75, 0.0, 0.4>
  }
}
#declare ParrillaInf = union {
  cylinder { // Cylndr82
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  0.1*z
  }
  cylinder { // Cylndr83
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 0.15, 0.1>
  }
  cylinder { // Cylndr84
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 0.3, 0.1>
  }
  cylinder { // Cylndr85
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 0.45, 0.1>
  }
  cylinder { // Cylndr86
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 0.6, 0.1>
  }
  cylinder { // Cylndr87
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 0.75, 0.1>
  }
  cylinder { // Cylndr88
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 0.9, 0.1>
  }
  cylinder { // Cylndr89
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.05, 0.1>
  }
  cylinder { // Cylndr90
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.2, 0.1>
  }
  cylinder { // Cylndr91
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.35, 0.1>
  }
  cylinder { // Cylndr92
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.5, 0.1>
  }
  cylinder { // Cylndr93
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.65, 0.1>
  }
  cylinder { // Cylndr94
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.8, 0.1>
  }
  cylinder { // Cylndr95
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 1.95, 0.1>
  }
  cylinder { // Cylndr96
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 2.1, 0.1>
  }
  cylinder { // Cylndr97
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 2.25, 0.1>
  }
  cylinder { // Cylndr98
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 2.4, 0.1>
  }
  cylinder { // Cylndr99
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 2.55, 0.1>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 2.7, 0.1>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.75>
    rotate 90.0*y
    translate  <0.0, 2.85, 0.1>
  }
  translate  0.3*z
}
#declare ParrillaSup = union {
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  1.7*z
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 0.15, 1.7>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 0.3, 1.7>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 0.45, 1.7>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 0.6, 1.7>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 0.75, 1.7>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 0.9, 1.7>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.05, 1.7>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.2, 1.7>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.35, 1.7>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.5, 1.7>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.65, 1.7>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.8, 1.7>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 1.95, 1.7>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 2.1, 1.7>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 2.25, 1.7>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 2.4, 1.7>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 2.55, 1.7>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 2.7, 1.7>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <0.015, 0.015, 1.15>
    rotate 90.0*y
    translate  <0.0, 2.85, 1.7>
  }
}
#declare SecaPlatos = union {
  object { ArmaduraLateral }
  object { ArmaduraLateral2 }
  object { ArmaduraFrontal }
  object { ParrillaInf }
  object { ParrillaSup }
  texture {
    EsmalteMetalico
  }
  scale 1.5
  rotate -90.0*z
  translate  <5.0, 9.75, 13.55>
}
union { // Cocina
  object { Pared }
  object { Trapo }
  object { Grifo }
  object { Pileta }
  object { Marmol_Mesada }
  object { Armario_de_Mesada }
  object { SecaPlatos }
}


#declare PataTrasera4 = union {
  sphere { // Sphere30
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr62
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr63
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
}
#declare PataMedio4 = union {
  cylinder { // Cylndr64
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere31
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr65
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
}
#declare PataDelantera4 = union {
  cylinder { // Cylndr66
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere32
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr67
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
}
#declare PataTrasera5 = union {
  sphere { // Sphere33
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataMedio5 = union {
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere34
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataDelantera5 = union {
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere35
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
}
#declare Antena4 = union {
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <170.752625, 17.79323, 179.126266>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere36
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  rotate <-4.0, 70.0, -20.0>
  translate  <2.0, 0.15, 1.65>
}
#declare Antena5 = union {
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <171.0, 18.0, 180.0>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere37
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
  rotate <-2.922746, 71.100021, 12.285197>
  translate  <2.0, -0.1, 1.65>
}
#declare Parpado4 = difference {
  sphere { // Ojo11
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane11
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, -0.25, 1.75>
}
#declare Parpado5 = difference {
  sphere { // Ojo12
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane12
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, 0.25, 1.75>
}
#declare Cabeza2 = union {
  cone { // Tenaza4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <-15.0, -80.0, -1.5>
    translate  <2.6, 0.1, -0.25>
  }
  cone { // Tenaza5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <15.0, -80.0, 1.5>
    translate  <2.6, -0.1, -0.25>
  }
  sphere { // Craneo2
    <0,0,0>,1
    scale <0.7, 0.7, 0.6>
    rotate 10.0*y
    translate  1.45*x
  }
  sphere { // Ojo9
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, 0.25, 0.25>
  }
  sphere { // Ojo10
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, -0.25, 0.25>
  }
  object { Antena4 }
  object { Antena5 }
  object { Parpado4 }
  object { Parpado5 }
  translate  -0.25*x
}
#declare Hormiga2 = union {
  sphere { // Cola2
    <0,0,0>,1
    scale <1.48, 1.0, 1.0>
    rotate -10.0*y
    translate  <-1.85, 0.0, 0.05>
  }
  sphere { // Torax2
    <0,0,0>,1
    scale <0.56, 0.47, 0.33>
  }
  object { PataTrasera4 }
  object { PataMedio4 }
  object { PataDelantera4 }
  object { PataTrasera5 }
  object { PataMedio5 }
  object { PataDelantera5 }
  object { Cabeza2 }
  texture {
    THormiga
  }
  scale 0.03
  rotate <48.353783, -88.328629, 48.353096>
  translate  <-1.15, 8.95, 11.2>
}
#declare PataTrasera6 = union {
  sphere { // Sphere38
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
}
#declare PataMedio6 = union {
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere39
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
}
#declare PataDelantera6 = union {
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere40
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
}
#declare PataTrasera7 = union {
  sphere { // Sphere41
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataMedio7 = union {
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere42
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataDelantera7 = union {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere43
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
}
#declare Antena6 = union {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <170.752625, 17.79323, 179.126266>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere44
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  rotate <-4.0, 70.0, -20.0>
  translate  <2.0, 0.15, 1.65>
}
#declare Antena7 = union {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <171.0, 18.0, 180.0>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere45
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
  rotate <-2.922746, 71.100021, 12.285197>
  translate  <2.0, -0.1, 1.65>
}
#declare Parpado6 = difference {
  sphere { // Ojo15
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane13
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, -0.25, 1.75>
}
#declare Parpado7 = difference {
  sphere { // Ojo16
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane14
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, 0.25, 1.75>
}
#declare Cabeza3 = union {
  cone { // Tenaza6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <-15.0, -80.0, -1.5>
    translate  <2.6, 0.1, -0.25>
  }
  cone { // Tenaza7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.15, 0.2, 0.8>
    rotate <15.0, -80.0, 1.5>
    translate  <2.6, -0.1, -0.25>
  }
  sphere { // Craneo3
    <0,0,0>,1
    scale <0.7, 0.7, 0.6>
    rotate 10.0*y
    translate  1.45*x
  }
  sphere { // Ojo13
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, 0.25, 0.25>
  }
  sphere { // Ojo14
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, -0.25, 0.25>
  }
  object { Antena6 }
  object { Antena7 }
  object { Parpado6 }
  object { Parpado7 }
  translate  -0.25*x
}
#declare Hormiga3 = union {
  sphere { // Cola3
    <0,0,0>,1
    scale <1.48, 1.0, 1.0>
    rotate -10.0*y
    translate  <-1.85, 0.0, 0.05>
  }
  sphere { // Torax3
    <0,0,0>,1
    scale <0.56, 0.47, 0.33>
  }
  object { PataTrasera6 }
  object { PataMedio6 }
  object { PataDelantera6 }
  object { PataTrasera7 }
  object { PataMedio7 }
  object { PataDelantera7 }
  object { Cabeza3 }
  texture {
    THormiga
  }
  scale 0.03
  rotate <-11.170233, 28.024317, -112.795868>
  translate  <-0.15, 8.05, 11.25>
}
#declare PataTrasera10 = union {
  sphere { // Sphere54
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
}
#declare PataMedio10 = union {
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere55
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
}
#declare PataDelantera10 = union {
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere56
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
}
#declare PataTrasera11 = union {
  sphere { // Sphere57
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <139.503555, 50.926899, 177.117477>
    translate  <-0.95, -0.9, 0.5>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 2.0>
    rotate <-167.067291, -33.381031, 177.460785>
    translate  <-0.95, -0.9, 0.5>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataMedio11 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.0>
    rotate <119.564079, 14.821489, 177.834991>
    translate  <-0.15, -1.15, 0.4>
  }
  sphere { // Sphere58
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <-0.15, -1.15, 0.4>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.984909, -9.988514, 179.911499>
    translate  <-0.15, -1.15, 0.4>
  }
  scale <1.0, -1.0, 1.0>
}
#declare PataDelantera11 = union {
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 1.5>
    rotate <-164.894409, 24.969444, -179.745773>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere59
    <0,0,0>,1
    scale 0.05
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    rotate <117.483154, -67.014389, -166.646545>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
}
#declare Antena10 = union {
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <170.752625, 17.79323, 179.126266>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere60
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  rotate <-4.0, 70.0, -20.0>
  translate  <2.0, 0.15, 1.5>
}
#declare Antena11 = union {
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 1.0>
    rotate <171.0, 18.0, 180.0>
    translate  <0.75, -0.85, 0.2>
  }
  sphere { // Sphere61
    <0,0,0>,1
    scale 0.03
    rotate -10.0*y
    translate  <0.75, -0.85, 0.2>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <0.03, 0.03, 0.5>
    rotate <-47.048061, 5.44978, -24.564251>
    translate  <0.75, -0.85, 0.2>
  }
  scale <1.0, -1.0, 1.0>
  rotate <-2.922746, 71.100021, 12.285197>
  translate  <2.0, -0.1, 1.5>
}
#declare Parpado10 = difference {
  sphere { // Ojo23
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane18
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, -0.25, 1.75>
}
#declare Parpado11 = difference {
  sphere { // Ojo24
    <0,0,0>,1
    scale 0.22
    rotate 10.0*y
    translate  -1.5*z
  }
  plane { // Plane19
    z,0
    scale 0.3
    rotate -60.0*y
    translate  -1.5*z
  }
  translate  <2.1, 0.25, 1.75>
}
#declare Cabeza5 = union {
  sphere { // Craneo5
    <0,0,0>,1
    scale <0.7, 0.7, 0.6>
    rotate 10.0*y
    translate  1.45*x
  }
  sphere { // Ojo21
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, 0.25, 0.25>
  }
  sphere { // Ojo22
    <0,0,0>,1
    texture {
      TOjo
    }
    scale 0.2
    rotate 10.0*y
    translate  <2.1, -0.25, 0.25>
  }
  object { Antena10 }
  object { Antena11 }
  object { Parpado10 }
  object { Parpado11 }
  object { Tenazza }
  object { // Tenazza1->Tenazza
    Tenazza
    scale -1.0
    rotate <-180.0, -0.0, -180.0>
  }
  translate  -0.25*x
}
#declare HormigaPrinc = union {
  sphere { // Cola5
    <0,0,0>,1
    scale <1.48, 1.0, 1.0>
    rotate -10.0*y
    translate  <-1.85, 0.0, 0.05>
  }
  sphere { // Torax5
    <0,0,0>,1
    scale <0.56, 0.47, 0.33>
  }
  object { PataTrasera10 }
  object { PataMedio10 }
  object { PataDelantera10 }
  object { PataTrasera11 }
  object { PataMedio11 }
  object { PataDelantera11 }
  object { Cabeza5 }
  texture {
    THormiga
  }
  scale 0.04
  rotate <15.0, -20.0, -140.0>
  translate  <-2.4, 5.0, 11.35>
}
union { // Hormigas
  object { Hormiga1 }
  object { // Hormiga5->Hormiga1
    Hormiga1
    rotate <-0.0, -0.0, 0.0>
    translate  <0.15, 0.45, 0.0>
  }
  object { // Hormiga6->Hormiga1
    Hormiga1
    rotate <-0.0, -0.0, 0.0>
    translate  <0.6, 0.6, 0.0>
  }
  object { Hormiga2 }
  object { Hormiga3 }
  object { Hormiga4 }
  object { // Hormiga7->Hormiga4
    Hormiga4
    rotate <0.0, 0.0, 0.0>
    translate  <-0.05, 0.0, 0.4>
  }
  object { // Hormiga8->Hormiga4
    Hormiga4
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, -0.0, 0.8>
  }
  object { // Hormiga9->Hormiga4
    Hormiga4
    rotate <0.0, 0.0, 0.0>
    translate  <0.05, 0.0, 1.15>
  }
  object { // Hormiga10->Hormiga4
    Hormiga4
    rotate <0.0, 0.0, 0.0>
    translate  <0.05, 0.0, 1.55>
  }
  object { HormigaPrinc }
}


#declare CSG3 = union {
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.3, 0.1>
    translate  <0.6, -0.3, 0.0>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.06, 0.1>
    translate  <-0.2, -0.06, 0.0>
  }
}
#declare CSG2 = union {
  cone { // Cone7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 0.2, 0.05>
    rotate <180.0, 0.0, 180.0>
    translate  0.05*z
  }
  cone { // Cone8
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 0.2, 0.05>
    translate  -0.05*z
  }
}
#declare CSG4 = intersection {
  object { CSG3 }
  object { CSG2 }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.2, 0.02>
    translate  -0.01*z
  }
  texture {
    Chrome_Texture
  }
}
#declare Cuchillo1 = union {
  superellipsoid { // SuperQ10
    <1.0, 0.1>
    texture {
      TMangoRojo
    }
    scale <0.04, 0.09, 0.4>
    rotate -90.0*y
    translate  <-0.42, -0.06, 0.0>
  }
  object { CSG4 }
  rotate -83.04216*y
  translate  <4.517698, 8.609854, 12.364433>
}
#declare Platito = lathe {
  linear_spline
  8  // control points
  <-0.000554, -0.051064>,
  <0.7848, -0.050239>,
  <0.957905, 0.035499>,
  <1.146683, 0.057161>,
  <1.147932, 0.06872>,
  <0.940867, 0.071333>,
  <0.756007, 0.019326>,
  <0.000874, 0.019326>
  rotate <90,0,90>
  texture {
    Texture1
  }
  translate  <2.7, 7.45, 11.35>
}
#declare Cuerpo1 = difference {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 1.0>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 1.1>
    translate  0.05*z
  }
}
#declare MangoTaza1 = intersection {
  torus { // Torus4
    0.875, 0.125  rotate -x*90
    scale <0.2, 0.3, 0.6>
    rotate -90.0*x
    translate  <-0.5, 0.0, 0.6>
  }
  plane { // Plane6
    z,0
    scale 0.1
    rotate 90.0*y
    translate  <-0.4, 0.0, 0.55>
  }
}
#declare Taza1 = union {
  object { Cuerpo1 }
  object { MangoTaza1 }
  torus { // Torus5
    0.875, 0.125  rotate -x*90
    scale <0.45, 0.45, 0.2>
  }
  texture {
    EsmalteMetalico
  }
  scale 1.2
  rotate <-0.0, 0.0, 80.0>
  translate  <3.3, 9.25, 11.35>
}
#declare Cacerola_1 = difference {
  superellipsoid { // SuperQ3
    <1.0, 0.1>
    scale <1.5, 1.5, 1.35>
    translate  -0.2*z
  }
  superellipsoid { // SuperQ4
    <1.0, 0.1>
    scale <1.45, 1.45, 1.3>
    translate  -0.2*z
  }
  plane { // Plane7
    z,0
    scale 1.5
    rotate <180.0, 0.0, 180.0>
    translate  0.3*z
  }
}
#declare Olla = union {
  object { Cacerola_1 }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.15, 0.6>
    rotate -90.0*y
    translate  -1.35*x
  }
  superellipsoid { // SuperQ002
    <1.0, 0.1>
    texture {
      TMangoNegro
    }
    scale <0.15, 0.4, 0.25>
    rotate -90.0*y
    translate  -1.9*x
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.15, 0.6>
    rotate <0.0, -90.0, -180.0>
    translate  <1.35, -0.0, 0.0>
  }
  superellipsoid { // SuperQ5
    <1.0, 0.1>
    texture {
      TMangoNegro
    }
    scale <0.15, 0.4, 0.25>
    rotate <0.0, -90.0, -180.0>
    translate  <1.9, -0.0, 0.0>
  }
  texture {
    Chrome_Texture
  }
  rotate <-0.0, 0.0, -8.427443>
  translate  <6.3, 7.0, 12.85>
}
#declare Cacerola_2 = difference {
  superellipsoid { // SuperQ6
    <1.0, 0.1>
    scale <1.5, 1.5, 1.35>
  }
  superellipsoid { // SuperQ7
    <1.0, 0.1>
    scale <1.45, 1.45, 1.3>
  }
  plane { // Plane17
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  0.3*z
  }
}
#declare Cacerola = union {
  object { Cacerola_2 }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.15, 0.8>
    rotate -90.0*y
    translate  -1.35*x
  }
  superellipsoid { // SuperQ8
    <1.0, 0.1>
    texture {
      TMangoRojo
    }
    scale <0.15, 0.3, 1.0>
    rotate -90.0*y
    translate  -2.75*x
  }
  texture {
    Chrome_Texture
  }
  scale 0.7
  rotate <5.673324, 28.563902, -57.658855>
  translate  <0.7, 7.0, 10.45>
}
#declare CSG002 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.3, 0.1>
    translate  <0.6, -0.3, 0.0>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.06, 0.1>
    translate  <-0.2, -0.06, 0.0>
  }
}
#declare CSG001 = union {
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 0.2, 0.05>
    rotate <180.0, 0.0, 180.0>
    translate  0.05*z
  }
  cone { // Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 0.2, 0.05>
    translate  -0.05*z
  }
}
#declare CSG003 = intersection {
  object { CSG002 }
  object { CSG001 }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.2, 0.02>
    translate  -0.01*z
  }
  texture {
    Chrome_Texture
  }
}
#declare Cuchillo = union {
  superellipsoid { // SuperQ9
    <1.0, 0.1>
    texture {
      TMangoRojo
    }
    scale <0.04, 0.09, 0.4>
    rotate -90.0*y
    translate  <-0.42, -0.06, 0.0>
  }
  object { CSG003 }
  rotate <117.27317, 67.731255, 115.505547>
  translate  <1.15, 6.4, 10.3>
}
#declare DeterAdentro = intersection {
  object { // Detergente1->Envase
    Envase
    scale 0.95
    rotate -0.0*x
    translate  <0.1, 0.45, 0.6>
  }
  plane { // Plane003
    z,0
    translate  <2.2, 9.0, 12.05>
  }
  texture {
    TDeterAdentro
  }
}
#declare Detergente = union {
  object { Envase }
  object { DeterAdentro }
}
union { // Vajilla
  object { Cuchillo1 }
  object { Cuchara2 }
  object { Taza }
  object { Vaso }
  object { Platito }
  object { Taza1 }
  object { Olla }
  object { Platito1 }
  object { Cacerola }
  object { Cuchillo }
  object { // Platito2->Platito1
    Platito1
    rotate <0.0, 0.0, 0.0>
    translate  0.1*z
  }
  object { // Platito3->Platito1
    Platito1
    rotate <0.0, 0.0, 0.0>
    translate  0.2*z
  }
  object { Platito5 }
  object { // Platito6->Platito5
    Platito5
    rotate <0.0, 0.0, -0.0>
    translate  <0.225, 0.0, -0.0>
  }
  object { // Platito7->Platito5
    Platito5
    rotate <0.0, 0.0, -0.0>
    translate  <0.45, 0.0, -0.0>
  }
  object { // Platito8->Platito5
    Platito5
    rotate <0.0, 0.0, -0.0>
    translate  <0.675, 0.0, -0.0>
  }
  object { // Platito9->Platito5
    Platito5
    rotate <0.0, 0.0, -0.0>
    translate  <0.9, 0.0, -0.0>
  }
  object { Vaso1 }
  object { // Vaso2->Vaso1
    Vaso1
    rotate <-0.0, -0.0, -0.0>
    translate  <-1.4, -0.05, 0.0>
  }
  object { // Cuchara3->Cuchara2
    Cuchara2
    translate  -0.35*y
  }
  object { // Taza2->Taza
    Taza
    rotate <-0.0, 0.0, -0.0>
    translate  <7.6, 0.95, 6.4>
  }
  object { // Taza3->Taza
    Taza
    rotate <-0.0, 0.0, -0.0>
    translate  <8.75, 0.9, 6.35>
  }
  object { // Taza4->Taza
    Taza
    rotate <-0.0, 0.0, -0.0>
    translate  <10.0, 0.95, 6.35>
  }
  object { Detergente }
}


