//
// Gone Fishin'
//
// (c) Ian Shumsky / The OuterArm Software Collective 1998
//

#version 3.0

//
// Standard include files.
//

#include "colors.inc"
#include "glass.inc"
#include "boat.inc"

//
// General global settings for the image.
//

global_settings
{
    assumed_gamma 2.2
}

//
// Each object collection is controlled by a switch (for
// debugging purposes). Set all to 'true' to produce the full
// image.
//

#declare Do_Stars = true
#declare Do_Water = true
#declare Do_Moon  = true
#declare Do_Moon_Detail = true
#declare Do_Land  = true
#declare Area_Lights = true
#declare Do_Boat = true
#declare Do_Buoys = true

//
// cameras...
//

camera
{
   location <0, 20, 0>
   look_at <0.0, 15.0, 200.0>
}

//
// Other sky details, such as the general background colour, a sky_sphere
// to give a bit of a glow behind us...
//

background
{
    colour MidnightBlue / 5
}

sky_sphere
{
    pigment
    {
        gradient y
        color_map
        {
            [0.01 color MidnightBlue * 6]
            [0.05 color MidnightBlue * 5]
            [0.1  color MidnightBlue * 4]
            [0.15 color MidnightBlue * 3]
            [0.2  color MidnightBlue * 2]
            [0.3  color MidnightBlue]
            [0.4  color MidnightBlue / 2]
            [0.5  color MidnightBlue / 3]
            [0.6  color MidnightBlue / 4]
            [0.7  color MidnightBlue / 5]
            [1.0  color Black]
        }
        scale 2
        translate -1
    }
}

//
// Do the Ocean surface
//

box
{
    <-500, -10, -500> <500, 0, 500>
    texture
    {
        #if (Do_Water)
            pigment
            {
                color rgb <0.39 / 7, 0.41 / 7, 0.43 / 5>
            }

            finish
            {
                ambient 0.15
                brilliance 5
                diffuse 0.6
                metallic
                specular 0.80
                roughness 1 / 100
                reflection 0.85
            }

            normal
            {
                waves 0.05
                frequency 5000.0
                scale 3000.0
            }

            rotate <0, 90, 0>
        #else
            pigment
            {
                colour Blue
            }
        #end
    }
}

//
// Define the moon
//

#declare Moon = sphere
{
    <0, 0, 0> 1
    texture
    {
        pigment
        {
            #if (Do_Moon_Detail = true)
                image_map
                {
                    //
                    // This image map has come from:
                    // http://maps.jpl.nasa.gov/earth.html
                    //

                    gif "ear1ccc2.gif"
                    once
                    map_type 1
                }
            #else
                colour rgb <0.75, 0.75, 0.75>
            #end
        }
    }
}

//
// Set the main light source for the image - this will be
// the moon.
//

light_source
{
    <-450, 140, 1000>
    color White

    #if (Area_Lights = true)
        area_light <25, 0, 0>, <0, 25, 0>, 25, 25
        jitter
    #end

    #if (Do_Moon = true)
        looks_like
        {
            object
            {
                Moon
                rotate <0, 225, 0>
                scale 300
                translate <-450, 140, 1000>
            }
        }
    #end
}

//
// Some stars...
//

#if (Do_Stars = true)
    #declare R1 = seed(71069)
    #declare R2 = seed(96017)
    #declare NOS = 8000
    #declare star_distance = 1500

    #while (NOS > 0)
        #declare star_pos_r = 1 + (2 * rand (R1))

        #declare ver_angle =  rand (R1) * 90
        #declare hor_angle =  rand (R1) * 90

        #declare star_pos_y = star_distance * sin (radians (ver_angle))
        #declare temp_pos   = star_distance * cos (radians (ver_angle))
        #declare star_pos_x = temp_pos * cos (radians (hor_angle))
        #declare star_pos_z = temp_pos * sin (radians (hor_angle))

        #declare quadrant = rand (R1) * 4

        #if (quadrant < 1)
            #declare star_pos_x =  star_pos_x
            #declare star_pos_z =  star_pos_z
        #else
            #if (quadrant < 2)
                #declare star_pos_x = -star_pos_x
                #declare star_pos_z =  star_pos_z
            #else
                #if (quadrant < 3)
                    #declare star_pos_x =  star_pos_x
                    #declare star_pos_z = -star_pos_z
                #else
                    #declare star_pos_x = -star_pos_x
                    #declare star_pos_z = -star_pos_z
                #end
            #end
        #end

        #declare star_col_r = 1 + (rand (R2) / 5)
        #declare star_col_g = 1 + (rand (R2) / 10)
        #declare star_col_b = 1 + (rand (R2) / 2)

        light_source
        {
            <star_pos_x, star_pos_y, star_pos_z>
            color Black
            fade_distance 4
            fade_power 2

            looks_like
            {
                sphere
                {
                    <star_pos_x, star_pos_y, star_pos_z>, star_pos_r
                    pigment
                    {
                        colour rgb <star_col_r, star_col_g, star_col_b>
                    }
                    finish
                    {
                        ambient 1.0
                        diffuse 0.0
                    }
                }
            }
        }

        #declare NOS = NOS - 1
    #end
#end

//
// The next thing to add to the image is some land...
// This is just a height field which is positioned and scaled.
//

#if (Do_Land = true)
    height_field
    {
        //
        // This image comes with POV-Ray.
        //

        gif "fract003.gif"
        pigment
        {
            colour rgb <161 / 256, 99 / 256, 103 / 256>
        }

        scale <320, 256, 240>
        scale <2.0, 0.5, 2.0>
        translate <-160.0, -80, -120.0>
        translate <-80.0, 0.0, -30.0>
    }
#end

//
// Add a small boat
//

#if (Do_Boat = true)
    object
    {
        sailing_boat
        rotate <0, 190, 0>
        scale 10
        translate <-72, 26, 180>
    }
#end

//
// Now add some crab buoys.
//

#if (Do_Buoys = true)
    #declare buoy = union
    {
        sphere
        {
            <0, 0, 0> 2
            pigment
            {
                colour rgb <237 / 256, 43 / 256, 125 / 256>
            }
        }

        cylinder
        {
            <0, 0, 0> <0, 4, 0> 0.3
            pigment
            {
                colour rgb <237 / 256, 43 / 256, 125 / 256>
            }
        }

        cylinder
        {
            <0, -0.2, 0> <0, 0.2, 0> 2.2
            pigment
            {
                colour rgb <62 / 256, 1, 57 / 256>
            }
        }

        difference
        {
            sphere
            {
                <0, 4.5, 0> 0.5
            }

            sphere
            {
                <0, 4.5, 0> 0.45
            }

            texture
            {
                T_Glass3
                finish
                {
                    reflection 0.25
                    caustics 2.0
                    fade_distance 2
                    fade_power 2
                }
            }
        }

        //
        // Now add 3 area lights to the buoy inside the transparent hollow
        // sphere. Use three to give light in each plane
        //

        light_source
        {
            <0, 4.5, 0>
            color White / 2
            fade_distance 8
            fade_power 2

            #if (Area_Lights = true)
                area_light <0.4, 0, 0>, <0, 0.4, 0>, 5, 5
                jitter
            #end

            looks_like
            {
                sphere
                {
                    <0, 0, 0> 0.2
                    pigment
                    {
                        colour White * 0.9
                    }
                    finish
                    {
                        ambient 1.0
                        diffuse 0.0
                    }
                }
            }
        }

        light_source
        {
            <0, 4.5, 0>
            color White / 2
            fade_distance 8
            fade_power 2

            #if (Area_Lights = true)
                area_light <0.4, 0, 0>, <0, 0, 0.4>, 5, 5
                jitter
            #end

            looks_like
            {
                sphere
                {
                    <0, 0, 0> 0.2
                    pigment
                    {
                        colour White * 0.9
                    }
                    finish
                    {
                        ambient 1.0
                        diffuse 0.0
                    }
                }
            }
        }

        light_source
        {
            <0, 4.5, 0>
            color White / 2
            fade_distance 8
            fade_power 2

            #if (Area_Lights = true)
                area_light <0, 0.4, 0>, <0, 0, 0.4>, 5, 5
                jitter
            #end

            looks_like
            {
                sphere
                {
                    <0, 0, 0> 0.2
                    pigment
                    {
                        colour White * 0.9
                    }
                    finish
                    {
                        ambient 1.0
                        diffuse 0.0
                    }
                }
            }
        }
    }

    //
    // Now add several buoys around with various tilts and positions.
    //

    #declare R3 = seed(31469)
    #declare NOB = 8

    #while (NOB > 0)
        #declare bx = -50 + (rand (R3) * 100)
        #declare by = -0.25 + (rand (R3) / 2)
        #declare bz = 80 + (rand (R3) * 150)

        #declare rx = -20 + (rand (R3) * 40)
        #declare rz = -20 + (rand (R3) * 40)

        object
        {
            buoy
            rotate <rx, 0, rz>
            translate <bx, by, bz>
        }

        #declare NOB = NOB - 1
    #end

    //
    // And a final one near the front of the scene.
    //

    object
    {
        buoy
        rotate <-20 + (rand (R3) * 40), 0, -20 + (rand (R3) * 40)>
        translate <0, -0.25 + (rand (R3) / 2), 50>
    }
#end
