
// Persistence of Vision Ray Tracer Scene Description File
// File: Water.pov
// Vers: 3.1 Beta 4
// Desc: Water
// Date: 9/23/98
// Auth: Jason Lloyd

global_settings { number_of_waves 2 }
#declare r1 = seed(12);
// **************Scene camera***************

#declare camera1 = 
camera
{
  location  <695 , 8 , 367>
  right 1.85*x
  up 1*y
  look_at   <655 , 1 , 390>
}

// ****************End Scene Camera*********

light_source
{
  0*x 
  color rgb 2.0 
  area_light
  <80, 0, 0> <0, 0, 80> 
  4, 4               
  adaptive 0        
  jitter             
  translate <655*2, 12000, 390*2> 
}

// *****************Sky**************************
sky_sphere  //
{
  pigment {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

#declare cloudy_sky =
sphere { 0, 100000
  texture {
    pigment {
      leopard
      scale 5000
      turbulence .9
      color_map {
                [0.0 color rgbt 1]
                [0.05 color rgbf <1, 1, 1, .4>]
                [0.1 color rgbf <1, 1, 1, .4>]
                [0.15 color rgbt 1]
                [0.3 color rgbt 1]
                [0.35 color rgbf <1, 1, 1, .4>]
                [0.4 color rgbf <1, 1, 1, .4>]
                [0.45 color rgbt 1]
                [0.6 color rgbt 1]
                [0.65 color rgbf <1, 1, 1, .4>]
                [0.7 color rgbf <1, 1, 1, .4>]
                [0.75 color rgbt 1]
                [1.0 color rgbt 1]
      }
    }
    finish { ambient .9 }
  }
  hollow
  translate <0, -99000, 0>
}

// *****************End Sky**********************

// *****************Water************************
#declare water = union {
  plane { y, 1 texture {
      pigment { rgbt <.1, .1, .3, .5> }
      finish { phong .25 phong_size 20 reflection .1 }
      normal {
        spherical
        normal_map {
          [0.5  waves scale .2 ]
          [1.0  ripples scale .4 ]
        }
      }
    }
    interior { ior 1.5 }
    scale < .3, .5, .3 >
    translate <678 , 0 , 374>
  }
  
  plane { y, 0 texture { pigment { rgb <0, .5, .5> } } }
}

// *****************End Water********************

// *****************Land*************************

#declare land = difference {
  height_field {
    tga            
    "water.tga"   
    scale <1000, 150, 1000>
    smooth
    water_level .001
  }
  box { <4.5, 2, 0> <-4.5, -2, 30>
       rotate x*-10
       rotate y*135
       translate <668 , -1 , 383>
  }
  box { <.75, 20, 0> <-.75, 0 , 30>
       rotate z*78
       rotate x*-10
       rotate y*135
       translate <668, -.5, 383>
  }
  box { <.75, 20, 0> <-.75, 0 , 30>
       rotate z*-78
       rotate x*-10
       rotate y*135
       translate <668, -.5, 383>
  }
  texture {
    pigment { rgb <.6 , .6, .5> }
    finish { crand .2 }
    normal { bumps .1 }
    scale <1000, 150, 1000>
  }
  texture {
    pigment {
      gradient y
      color_map {
              [0.0 color rgbt 1]
              [0.015 color rgbt 1]
              [0.03 color green .3]
              [1.0 color green .3]
      }
    }
    finish { phong .05 phong_size 5 crand .07 }
    normal { bumps .03 }
    scale <1000, 150, 1000>
  }
}  

// *****************End Land*********************


// *****************River************************

#declare fieldcount = 5;
#declare river = union {
  #while (fieldcount > 0)
    height_field { gif "river3.gif"
      texture { pigment { rgb 1 } }
      texture {
        pigment {
          gradient x
          color_map {
            [0.0 color rgb .7]
            [0.3 color rgb .7]
            [0.4 color rgb <0 , .5 , .5>]
            [0.6 color rgb <0 , .5 , .5>]
            [0.7 color rgb .7]
            [1.0 color rgb .7]
          }
        }
        normal { granite scale .005 }
      }
      translate x*-.5
      translate z*fieldcount
    }
    #declare fieldcount = fieldcount - 1;
  #end
  
  box { <.4, .4, 1> <-.4, 0, 7>
    texture {
      pigment { rgbt <.1, .2, .3, .5> }
      finish { phong .25 phong_size 20 reflection .1 }
      normal { ripples turbulence 1.5 scale <.2, .1, .2> }
    }
    interior { ior 1.5 }
  }
  scale <10, 1, 5>
  rotate x*-10
  rotate y*135
  translate <668 , -.5 , 383>
}

// *****************End River********************


// *****************River Rocks******************

#declare river_rocks = union {
  
  object { #include "rock.inc"
    scale .5
    translate <676, 1.5, 377> 
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }
  
  object { #include "rock.inc"
    scale <.25, .5, .35>
    rotate x*-5
    translate <678, 2, 374>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <.25, .1, .35>
    rotate x*-5
    translate <673, 1.5, 376>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <.5, .1, .5>
    rotate x*-5
    translate <680, 2.8, 370>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <.2, .3, .2>
    rotate x*-5
    translate <682, 2.8, 370.5>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <.8, .5, .6>
    rotate x*-5
    translate <683, 2.9, 369>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <.2, .3, .2>
    rotate x*-5
    translate <684, 3.6, 366>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <.3, .4, .5>
    rotate x*-5
    translate <686, 3.6, 368>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

object { #include "rock.inc"
    scale .35 //<.3, .4, .5>
    translate <687, 4, 369.5>
    texture { pigment { rgb .7 } normal { granite scale .005 } }
  }

}

// *****************End River Rocks**************

// *****************Grass************************
#declare grass = union {
  #declare bladetexture = texture { pigment { green 1 transmit .7 } }
  
  #declare patch = mesh {   
    #declare blades_per_unit = 300;
    #while (blades_per_unit > 0)
      triangle { <rand(r1)*2-1, .5, rand(r1)*2-1>
                 <.1 + rand(r1)-.5, -5, rand(r1)-.5>
                 <rand(r1)-.6, -5, rand(r1)-.5>
      }
      #declare blades_per_unit = blades_per_unit - 1;
    #end
  }
  
  #declare lawn = union {
    #declare lawnx = -20;
    #while (lawnx < 0)
      #declare lawnz = 30;
      union {
        #while (lawnz > 0)
          #switch ( rand(r1) )
            #range (0, .25)
              #declare patch_rotate = 90;
            #break
            #range (.25, .5)
              #declare patch_rotate = 180;
            #break
            #range (.5, .75)
              #declare patch_rotate = 270;
            #break
            #else
              #declare patch_rotate = 0;
          #end
          object { patch
            rotate y*patch_rotate
            translate <lawnx, 0, lawnz>
          }
          #declare lawnz = lawnz - 1;
        #end
      }
      #declare lawnx = lawnx + 1;
    #end
    rotate z*-90
  }
  
  object { lawn texture { bladetexture }
    rotate z*78
    rotate x*-10
    rotate y*135
    translate x*6
    translate <668, .5, 383>
  }
  
  object { lawn texture { bladetexture }
    translate z*-40
    rotate y*180
    rotate z*-78
    rotate x*-10
    rotate y*135
    translate x*-6
    translate <668, -.5, 383>
  }

}

// *****************End Grass********************

// *****************Land Rocks*******************
#declare land_rocks = union {
  
  
  object { #include "rock.inc"
    scale .8
    translate <685, 3.5, 379> 
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale .5
    rotate y*90
    translate <692, 5, 374> 
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale <1, .5, .7>
    rotate y*75
    translate <672, 4.8, 365> 
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale 1.2
    translate <663, 5, 361> 
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }

  object { #include "rock.inc"
    scale .75
    translate <665 , 5.5 , 420> 
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }
  
  object { #include "rock.inc"
    scale .5
    translate <674, 5.5, 423>
    texture {
      pigment { rgb .7 }
      normal { granite scale .005 }
    }
  }
  
}

// *****************End Land Rocks***************

// *****************Vegitation***********************

#include "veg.inc"

#declare trees_right = union {
  #declare treex = 40;
  #while (treex > 0)
    #declare treez = 20;
    #while (treez > 0)
      object { Tree1 translate <treex+rand(r1)*5, treez/2+rand(r1)*5, treez+rand(r1)*5> }
      #declare treez = treez - 5;
    #end
    #declare treex = treex - 5;
  #end
  rotate y*25
  translate <650, 0, 415>
}

#declare trees_near_right = union {
  #declare treex = 10;
  #while (treex > 0)
    #declare treez = 20;
    #while (treez > 0)
      object { Tree1 translate <treex+rand(r1)*5, rand(r1)*5, treez+rand(r1)*5> }
      #declare treez = treez - 3;
    #end
    #declare treex = treex - 3;
  #end
  rotate y*25
  translate <685, 5, 373>
}

#declare trees_near_left = union {
  #declare treex = 10;
  #while (treex > 0)
    #declare treez = 40;
    #while (treez > 0)
      object { Tree1 translate <treex+rand(r1)*5, rand(r1)*5, treez+rand(r1)*5> }
      #declare treez = treez - 5;
    #end
    #declare treex = treex - 5;
  #end
  rotate y*-95
  translate <683, 5, 355>
}

#declare vegitation = union {
  object { trees_right }
  object { trees_near_right }
  object { trees_near_left }
  object { Fern translate <690, 5, 374> }
  object { Fern translate <691, 5.1, 377> }
  object { Fern translate <675, 4.5, 364> }
}


// *****************End Vegitation***************

// *****************Drift Wood*******************

#declare bark_texture = texture{
    pigment{ color rgb<0.501, 0.313, 0.184> } 
    normal{ bumps bump_size -2 scale< .02, .1, .02> }
   }
#declare drift_wood = union {
  
  // ***********Log 1**********
  cylinder { y*5, y*-5, .7 texture { bark_texture } rotate z*90 rotate y*5 translate <656, 1.3, 410> }
  cone { y*2, .1, y*0, .3 texture { bark_texture } rotate z*45 rotate y*7 translate <656, 1.3, 410> }
  cone { y*3, .2, y*0, .3 texture { bark_texture } rotate z*50 rotate y*-5 translate <659, 1.3, 411> }
}

// *****************End Drift Wood***************

// *****************Ground Fog*******************

#declare scene_fog = 
fog
{
  fog_type   2
  distance   60
  color      rgb 0.6 // gray
  fog_offset 1
  fog_alt    2
  turbulence 0.8
}

// *****************End Ground Fog***************

camera { camera1 }
object { land }
object { river }
object { water }
object { cloudy_sky }
object { river_rocks }
object { grass }
object { land_rocks }
object { vegitation }
object { drift_wood }
fog { scene_fog }
