// Various reef fishes

#declare Blue_Surgeon =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.531, -0.025, -0.006> <-0.418, -0.164, -0.034> <0.114, -0.039, -0.108> <0.066, -0.064, -0.101>
		<-0.622, 0.088, 0.017> <-0.509, -0.052, -0.011> <0.086, -0.053, -0.104> <0.038, -0.078, -0.097>
		<-0.420, 0.308, -0.005> <-0.307, 0.267, -0.032> <-0.038, 0.215, -0.103> <0.080, 0.183, -0.111>
		<-0.322, 0.417, -0.005> <-0.210, 0.377, -0.031> <-0.066, 0.313, -0.085> <0.052, 0.282, -0.093>
        pigment {color Gray20}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.322, 0.417, -0.005> <-0.322, 0.417, -0.005> <-0.322, 0.417, -0.005> <-0.322, 0.417, -0.005>
		<-0.273, 0.472, -0.005> <-0.161, 0.431, -0.031> <-0.161, 0.431, -0.031> <-0.210, 0.377, -0.031>
		<-0.085, 0.474, -0.003> <-0.085, 0.475, -0.003> <-0.086, 0.385, -0.072> <-0.066, 0.313, -0.085>
		<-0.085, 0.475, -0.003> <-0.085, 0.475, -0.003> <0.032, 0.354, -0.080> <0.052, 0.282, -0.093>
        pigment {color Gray20}
	}
    sphere {<-0.145, 0.28, -0.01>, 0.07
            pigment {color Black}
            finish {Shiny}
    }
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.531, -0.025, -0.006> <-0.498, -0.071, -0.006> <-0.477, -0.165, -0.001> <-0.423, -0.179, -0.007>
		<-0.418, -0.164, -0.034> <-0.386, -0.211, -0.034> <-0.333, -0.203, -0.018> <-0.279, -0.218, -0.024>
		<0.114, -0.039, -0.108> <0.096, -0.046, -0.109> <0.105, -0.180, -0.083> <0.116, -0.177, -0.085>
		<0.066, -0.064, -0.101> <0.048, -0.072, -0.101> <0.062, -0.190, -0.075> <0.073, -0.187, -0.077>
        pigment {gradient y
                 turbulence 0.2
                 color_map {
                 [0.0 color rgb <0.98, 0.98, 1>]
                 [0.7 color rgb <0.98, 0.98, 1>]
                 [1.0 color rgb <0.3, 0.2, 0.6>]}
                 translate <0, -0.1, 0>
                 scale 0.2
                 }
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 0.475, -0.003> <-0.086, 0.475, -0.003> <0.407, 0.434, -0.002> <0.603, 0.363, -0.002>
		<-0.085, 0.474, -0.003> <-0.086, 0.475, -0.003> <0.425, 0.488, 0.009> <0.622, 0.417, 0.008>
		<0.121, 0.624, -0.000> <0.259, 0.636, 0.001> <0.527, 0.538, 0.002> <0.656, 0.487, 0.001>
		<0.225, 0.633, 0.001> <0.364, 0.645, 0.002> <0.550, 0.591, 0.004> <0.679, 0.540, 0.003>
        pigment {wood
                 color_map {
                 [0.0 color rgb <0.92, 0.9, 0.2>]
                 [0.7 color rgb <0.92, 0.9, 0.2>]
                 [0.85 color rgb <0.3, 0.2, 0.6>]
                 [1.0 color rgb <0.92, 0.9, 0.2>]}
                 translate <20, 3, 0>
                 scale 0.05
                 }
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.991, 0.332, -0.003> <0.915, 0.415, -0.001> <0.784, 0.499, 0.002> <0.679, 0.540, 0.003>
		<1.056, 0.259, -0.004> <0.981, 0.342, -0.003> <0.761, 0.446, 0.001> <0.656, 0.487, 0.001>
		<1.090, 0.125, -0.005> <0.931, 0.223, -0.004> <0.797, 0.354, 0.008> <0.622, 0.417, 0.008>
		<1.133, 0.036, -0.006> <0.974, 0.135, -0.005> <0.779, 0.300, -0.003> <0.603, 0.363, -0.002>
        pigment {wood
                 color_map {
                 [0.0 color rgb <0.92, 0.9, 0.2>]
                 [0.7 color rgb <0.92, 0.9, 0.2>]
                 [0.85 color rgb <0.3, 0.2, 0.6>]
                 [1.0 color rgb <0.92, 0.9, 0.2>]}
                 translate <20, 3, 0>
                 scale 0.05
                 }

	}
  	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.578, 0.123, -0.007> <1.578, 0.123, -0.007> <1.578, 0.123, -0.007> <1.578, 0.123, -0.007>
		<1.444, 0.097, -0.007> <1.411, 0.028, -0.006> <1.411, 0.028, -0.006> <1.544, 0.054, -0.006>
		<1.266, 0.062, -0.006> <1.366, 0.019, -0.006> <1.371, 0.012, -0.004> <1.471, -0.031, -0.004>
		<1.133, 0.036, -0.006> <1.233, -0.007, -0.005> <1.366, -0.065, -0.005> <1.466, -0.108, -0.004>
        pigment {wood
                 color_map {
                 [0.0 color Gray20]
                 [0.3 color Gray20]
                 [0.3 color LightBlue]}
                 scale <0.3, 0.17, 0.3>
                 translate <2, -0.12, 0>
                 }
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.544, -0.404, -0.008> <1.413, -0.342, -0.008> <1.252, -0.209, -0.007> <1.108, -0.198, -0.006>
		<1.520, -0.315, -0.007> <1.390, -0.253, -0.006> <1.276, -0.143, -0.006> <1.132, -0.132, -0.006>
		<1.460, -0.200, -0.004> <1.360, -0.156, -0.005> <1.225, -0.077, -0.005> <1.125, -0.034, -0.006>
		<1.466, -0.108, -0.004> <1.366, -0.065, -0.005> <1.233, -0.007, -0.005> <1.133, 0.036, -0.006>
        pigment {wood
                 color_map {
                 [0.0 color Gray20]
                 [0.3 color Gray20]
                 [0.3 color LightBlue]}
                 scale <0.3, 0.17, 0.3>
                 translate <2, -0.12, 0>
                 }

	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.942, -0.479, -0.008> <1.019, -0.419, -0.007> <1.074, -0.290, -0.006> <1.108, -0.198, -0.006>
		<0.860, -0.543, -0.009> <0.937, -0.483, -0.008> <0.953, -0.281, -0.005> <0.987, -0.189, -0.005>
		<0.716, -0.585, -0.012> <0.752, -0.512, -0.010> <0.825, -0.381, 0.004> <0.846, -0.302, -0.003>
		<0.612, -0.587, -0.012> <0.648, -0.513, -0.010> <0.711, -0.421, 0.004> <0.732, -0.342, -0.004>
        pigment {color rgb <0.3, 0.5, 0.6>}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.612, -0.587, -0.012> <0.612, -0.587, -0.012> <0.612, -0.587, -0.012> <0.612, -0.587, -0.012>
		<0.509, -0.588, -0.012> <0.545, -0.515, -0.010> <0.545, -0.515, -0.010> <0.648, -0.513, -0.010>
		<0.364, -0.551, 0.002> <0.504, -0.528, 0.003> <0.577, -0.468, 0.004> <0.711, -0.421, 0.004>
		<0.281, -0.490, -0.008> <0.421, -0.467, -0.007> <0.598, -0.390, -0.004> <0.732, -0.342, -0.004>
        pigment {color rgb <0.3, 0.5, 0.6>}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.184, -0.763, -0.106> <0.184, -0.763, -0.106> <0.184, -0.763, -0.106> <0.184, -0.763, -0.106>
		<0.195, -0.665, -0.087> <0.188, -0.721, -0.098> <0.188, -0.721, -0.098> <0.177, -0.819, -0.118>
		<0.135, -0.528, -0.075> <0.121, -0.655, -0.100> <0.077, -0.790, -0.125> <0.063, -0.917, -0.151>
		<0.077, -0.449, -0.052> <0.062, -0.576, -0.078> <0.043, -0.745, -0.112> <0.029, -0.872, -0.138>
        pigment {color rgb <0.3, 0.5, 0.6>}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.060, -0.437, -0.013> <-0.060, -0.437, -0.013> <-0.060, -0.437, -0.013> <-0.060, -0.437, -0.013>
		<-0.075, -0.572, -0.040> <-0.071, -0.530, -0.032> <-0.071, -0.530, -0.032> <-0.056, -0.395, -0.004>
		<-0.052, -0.764, -0.107> <-0.037, -0.637, -0.081> <0.037, -0.543, -0.068> <0.052, -0.416, -0.043>
		<0.029, -0.872, -0.138> <0.043, -0.745, -0.112> <0.062, -0.576, -0.078> <0.077, -0.449, -0.052>
        pigment {color rgb <0.3, 0.5, 0.6>}
	}

	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.423, -0.179, -0.007> <-0.308, -0.266, -0.007> <-0.173, -0.411, -0.008> <-0.041, -0.469, -0.008>
		<-0.279, -0.218, -0.024> <-0.164, -0.305, -0.024> <-0.084, -0.450, -0.008> <0.047, -0.508, -0.008>
		<0.116, -0.177, -0.085> <0.046, -0.227, -0.078> <0.096, -0.439, -0.019> <0.185, -0.506, -0.009>
		<0.073, -0.187, -0.077> <0.003, -0.238, -0.070> <0.191, -0.424, -0.019> <0.281, -0.490, -0.008>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 0.475, -0.003> <-0.085, 0.475, -0.003> <0.032, 0.354, -0.080> <0.052, 0.282, -0.093>
		<-0.086, 0.475, -0.003> <-0.086, 0.475, -0.003> <0.181, 0.315, -0.091> <0.202, 0.242, -0.104>
		<0.407, 0.434, -0.002> <0.388, 0.380, -0.012> <0.544, 0.182, -0.068> <0.535, 0.181, -0.069>
		<0.603, 0.363, -0.002> <0.585, 0.309, -0.013> <0.567, 0.186, -0.064> <0.558, 0.185, -0.065>
    }
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.281, -0.490, -0.008> <0.421, -0.467, -0.007> <0.598, -0.390, -0.004> <0.732, -0.342, -0.004>
		<0.191, -0.424, -0.019> <0.332, -0.400, -0.018> <0.612, -0.339, -0.009> <0.746, -0.291, -0.009>
		<0.003, -0.238, -0.070> <0.125, -0.150, -0.083> <0.667, -0.203, -0.054> <0.715, -0.182, -0.053>
		<0.073, -0.187, -0.077> <0.196, -0.100, -0.090> <0.677, -0.193, -0.054> <0.725, -0.172, -0.054>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.108, -0.198, -0.006> <1.108, -0.198, -0.006> <1.108, -0.198, -0.006> <1.108, -0.198, -0.006>
		<0.987, -0.189, -0.005> <1.012, -0.122, -0.005> <1.012, -0.122, -0.005> <1.132, -0.132, -0.006>
		<0.846, -0.302, -0.003> <0.966, -0.188, -0.004> <1.005, -0.147, -0.005> <1.125, -0.034, -0.006>
		<0.732, -0.342, -0.004> <0.853, -0.229, -0.004> <1.013, -0.077, -0.005> <1.133, 0.036, -0.006>
   	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.108, -0.198, -0.006> <1.132, -0.132, -0.006> <1.125, -0.034, -0.006> <1.133, 0.036, -0.006>
		<0.987, -0.189, -0.005> <1.012, -0.122, -0.005> <1.003, -0.096, -0.020> <1.010, -0.026, -0.020>
		<0.846, -0.302, -0.003> <0.860, -0.251, -0.009> <0.741, -0.157, -0.054> <0.752, -0.147, -0.054>
		<0.732, -0.342, -0.004> <0.746, -0.291, -0.009> <0.715, -0.182, -0.053> <0.725, -0.172, -0.054>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.052, 0.282, -0.093> <0.080, 0.183, -0.111> <0.038, -0.078, -0.097> <0.066, -0.064, -0.101>
		<0.202, 0.242, -0.104> <0.229, 0.144, -0.122> <0.106, -0.049, -0.096> <0.134, -0.035, -0.100>
		<0.535, 0.181, -0.069> <0.527, 0.181, -0.070> <0.386, 0.045, -0.079> <0.379, -0.014, -0.081>
		<0.558, 0.185, -0.065> <0.550, 0.184, -0.066> <0.547, 0.071, -0.069> <0.541, 0.012, -0.071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.066, -0.064, -0.101> <0.048, -0.072, -0.101> <0.062, -0.190, -0.075> <0.073, -0.187, -0.077>
		<0.134, -0.035, -0.100> <0.116, -0.043, -0.101> <0.185, -0.102, -0.088> <0.196, -0.100, -0.090>
		<0.379, -0.014, -0.081> <0.442, -0.076, -0.075> <0.696, -0.185, -0.054> <0.677, -0.193, -0.054>
		<0.541, 0.012, -0.071> <0.603, -0.050, -0.065> <0.744, -0.164, -0.053> <0.725, -0.172, -0.054>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.603, 0.363, -0.002> <0.603, 0.363, -0.002> <0.603, 0.363, -0.002> <0.603, 0.363, -0.002>
		<0.779, 0.300, -0.003> <0.761, 0.246, -0.013> <0.761, 0.246, -0.013> <0.585, 0.309, -0.013>
		<0.974, 0.135, -0.005> <0.802, 0.179, -0.023> <0.594, 0.187, -0.061> <0.567, 0.186, -0.064>
		<1.133, 0.036, -0.006> <0.960, 0.081, -0.024> <0.586, 0.186, -0.062> <0.558, 0.185, -0.065>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.541, 0.012, -0.071> <0.603, -0.050, -0.065> <0.744, -0.164, -0.053> <0.725, -0.172, -0.054>
		<0.547, 0.071, -0.069> <0.609, 0.008, -0.063> <0.771, -0.139, -0.053> <0.752, -0.147, -0.054>
		<0.550, 0.184, -0.066> <0.578, 0.185, -0.063> <0.838, 0.018, -0.038> <1.010, -0.026, -0.020>
		<0.558, 0.185, -0.065> <0.586, 0.186, -0.062> <0.960, 0.081, -0.024> <1.133, 0.036, -0.006>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.732, -0.342, -0.004> <0.732, -0.342, -0.004> <0.732, -0.342, -0.004> <0.732, -0.342, -0.004>
		<0.746, -0.291, -0.009> <0.866, -0.178, -0.009> <0.866, -0.178, -0.009> <0.853, -0.229, -0.004>
		<0.715, -0.182, -0.053> <0.741, -0.157, -0.054> <0.890, -0.140, -0.020> <1.013, -0.077, -0.005>
		<0.725, -0.172, -0.054> <0.752, -0.147, -0.054> <1.010, -0.026, -0.020> <1.133, 0.036, -0.006>
	}
pigment {color rgb <0.3, 0.2, 0.6>}
finish {ambient 0.3 }
} // end Blue Surgeon union


// -----------------------------------


#declare Humbug_Damsel =

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.477, 0.348, -0.103> <0.981, 0.298, -0.178> <1.000, 0.314, 0.000>
		<0.428, 0.298, -0.103> <0.493, 0.293, -0.090> <0.982, 0.231, -0.178> <1.001, 0.246, 0.000>
		<0.512, 0.005, -0.034> <0.669, 0.079, -0.034> <0.886, 0.087, 0.000> <1.043, 0.160, 0.000>
		<0.555, -0.144, 0.000> <0.711, -0.070, 0.000> <0.920, 0.028, 0.000> <1.076, 0.102, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.428, 0.298, -0.103> <0.512, 0.005, -0.034> <0.555, -0.144, 0.000>
		<0.447, 0.398, -0.103> <0.463, 0.343, -0.090> <0.478, 0.161, 0.008> <0.520, 0.012, 0.043>
		<0.718, 0.748, -0.004> <0.701, 0.744, -0.000> <0.485, 0.360, 0.111> <0.453, 0.317, 0.127>
		<0.729, 0.763, 0.000> <0.712, 0.759, 0.004> <0.472, 0.418, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.428, 0.298, -0.103> <0.512, 0.005, -0.034> <0.555, -0.144, 0.000>
		<0.477, 0.348, -0.103> <0.493, 0.293, -0.090> <0.478, 0.161, 0.008> <0.520, 0.012, 0.043>
		<0.981, 0.298, -0.178> <0.999, 0.313, -0.006> <0.515, 0.311, 0.111> <0.453, 0.317, 0.127>
		<1.000, 0.314, 0.000> <1.019, 0.328, 0.173> <0.502, 0.368, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.428, 0.298, -0.103> <0.512, 0.005, -0.034> <0.555, -0.144, 0.000>
		<0.368, 0.405, -0.103> <0.384, 0.350, -0.090> <0.478, 0.161, 0.008> <0.520, 0.012, 0.043>
		<-0.012, 0.814, -0.189> <0.009, 0.831, 0.002> <0.405, 0.368, 0.111> <0.453, 0.317, 0.127>
		<0.008, 0.831, 0.000> <0.029, 0.847, 0.191> <0.393, 0.425, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.428, 0.298, -0.103> <0.512, 0.005, -0.034> <0.555, -0.144, 0.000>
		<0.477, 0.348, -0.103> <0.493, 0.293, -0.090> <0.669, 0.079, -0.034> <0.711, -0.070, 0.000>
		<0.981, 0.298, -0.178> <0.982, 0.231, -0.178> <1.038, 0.158, 0.000> <1.072, 0.100, 0.000>
		<1.000, 0.314, 0.000> <1.001, 0.246, 0.000> <1.043, 0.160, 0.000> <1.076, 0.102, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.428, 0.298, -0.103> <0.512, 0.005, -0.034> <0.555, -0.144, 0.000>
		<0.367, 0.335, -0.112> <0.383, 0.281, -0.100> <0.515, 0.005, -0.034> <0.558, -0.144, 0.000>
		<0.049, 0.214, -0.091> <0.058, 0.175, -0.081> <0.222, -0.194, 0.002> <0.222, -0.194, 0.000>
		<0.004, 0.197, -0.088> <0.013, 0.158, -0.078> <0.085, -0.161, 0.002> <0.085, -0.161, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.367, 0.335, -0.112> <0.049, 0.214, -0.091> <0.004, 0.197, -0.088>
		<0.368, 0.405, -0.103> <0.323, 0.388, -0.100> <0.021, 0.247, -0.081> <-0.024, 0.230, -0.078>
		<-0.012, 0.814, -0.189> <-0.115, 0.736, -0.189> <-0.198, 0.588, -0.119> <-0.272, 0.484, -0.119>
		<0.008, 0.831, 0.000> <-0.094, 0.753, 0.000> <-0.179, 0.596, 0.000> <-0.254, 0.492, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.447, 0.398, -0.103> <0.718, 0.748, -0.004> <0.729, 0.763, 0.000>
		<0.477, 0.348, -0.103> <0.512, 0.394, -0.090> <0.731, 0.752, -0.007> <0.742, 0.766, -0.003>
		<0.981, 0.298, -0.178> <0.979, 0.367, -0.178> <0.931, 0.543, 0.000> <0.966, 0.603, 0.000>
		<1.000, 0.314, 0.000> <0.999, 0.383, 0.000> <1.032, 0.475, 0.000> <1.068, 0.534, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.477, 0.348, -0.103> <0.981, 0.298, -0.178> <1.000, 0.314, 0.000>
		<0.368, 0.405, -0.103> <0.433, 0.401, -0.090> <0.999, 0.313, -0.006> <1.019, 0.328, 0.173>
		<-0.012, 0.814, -0.189> <0.009, 0.831, 0.002> <0.454, 0.418, 0.111> <0.502, 0.368, 0.127>
		<0.008, 0.831, 0.000> <0.029, 0.847, 0.191> <0.393, 0.425, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.447, 0.398, -0.103> <0.718, 0.748, -0.004> <0.729, 0.763, 0.000>
		<0.368, 0.405, -0.103> <0.403, 0.451, -0.090> <0.702, 0.752, -0.004> <0.713, 0.766, 0.000>
		<-0.012, 0.814, -0.189> <0.052, 0.863, -0.189> <0.333, 0.884, 0.000> <0.413, 0.876, 0.000>
		<0.008, 0.831, 0.000> <0.073, 0.879, 0.000> <0.191, 0.897, 0.000> <0.271, 0.890, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.412, 0.353, -0.115> <0.447, 0.398, -0.103> <0.718, 0.748, -0.004> <0.729, 0.763, 0.000>
		<0.368, 0.405, -0.103> <0.403, 0.451, -0.090> <0.701, 0.744, -0.000> <0.712, 0.759, 0.004>
		<-0.012, 0.814, -0.189> <0.009, 0.831, 0.002> <0.425, 0.468, 0.111> <0.472, 0.418, 0.127>
		<0.008, 0.831, 0.000> <0.029, 0.847, 0.191> <0.393, 0.425, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.197, -0.088> <0.013, 0.158, -0.078> <0.085, -0.161, 0.002> <0.085, -0.161, 0.000>
		<-0.028, 0.182, -0.078> <-0.019, 0.142, -0.068> <0.085, -0.161, -0.000> <0.084, -0.161, -0.002>
		<-0.299, 0.053, -0.098> <-0.282, 0.060, 0.011> <0.005, 0.153, 0.088> <0.040, 0.169, 0.100>
		<-0.284, 0.059, -0.000> <-0.267, 0.066, 0.109> <-0.000, 0.194, 0.100> <0.035, 0.210, 0.112>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.197, -0.088> <0.013, 0.158, -0.078> <0.085, -0.161, 0.002> <0.085, -0.161, 0.000>
		<-0.024, 0.230, -0.078> <-0.015, 0.190, -0.068> <0.085, -0.161, -0.000> <0.084, -0.161, -0.002>
		<-0.272, 0.484, -0.119> <-0.253, 0.492, 0.005> <0.008, 0.200, 0.088> <0.040, 0.169, 0.100>
		<-0.254, 0.492, 0.000> <-0.235, 0.500, 0.124> <0.003, 0.241, 0.100> <0.035, 0.210, 0.112>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.197, -0.088> <0.004, 0.197, -0.088> <0.004, 0.197, -0.088> <0.004, 0.197, -0.088>
		<-0.028, 0.182, -0.078> <-0.019, 0.142, -0.068> <-0.019, 0.142, -0.068> <0.013, 0.158, -0.078>
		<-0.299, 0.053, -0.098> <-0.198, -0.027, -0.098> <-0.040, -0.131, 0.002> <0.085, -0.161, 0.002>
		<-0.284, 0.059, -0.000> <-0.183, -0.021, -0.000> <-0.040, -0.131, -0.000> <0.085, -0.161, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.004, 0.197, -0.088> <-0.028, 0.182, -0.078> <-0.299, 0.053, -0.098> <-0.284, 0.059, -0.000>
		<-0.024, 0.230, -0.078> <-0.056, 0.214, -0.068> <-0.350, 0.094, -0.098> <-0.336, 0.101, -0.000>
		<-0.272, 0.484, -0.119> <-0.325, 0.410, -0.119> <-0.414, 0.261, 0.000> <-0.420, 0.171, -0.000>
		<-0.254, 0.492, 0.000> <-0.307, 0.418, 0.000> <-0.409, 0.327, 0.000> <-0.415, 0.237, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.415, 0.237, 0.000> <-0.420, 0.171, -0.000> <-0.336, 0.101, -0.000> <-0.284, 0.059, -0.000>
		<-0.409, 0.327, 0.000> <-0.414, 0.261, 0.000> <-0.319, 0.108, 0.109> <-0.267, 0.066, 0.109>
		<-0.307, 0.418, 0.000> <-0.288, 0.426, 0.124> <-0.032, 0.225, 0.088> <-0.000, 0.194, 0.100>
		<-0.254, 0.492, 0.000> <-0.235, 0.500, 0.124> <0.003, 0.241, 0.100> <0.035, 0.210, 0.112>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.958, -0.068, 0.000> <0.835, -0.065, 0.000> <0.552, -0.144, 0.000> <0.555, -0.144, 0.000>
		<1.056, -0.070, -0.000> <0.933, -0.067, 0.000> <0.709, -0.071, 0.000> <0.711, -0.070, 0.000>
		<1.177, -0.133, 0.000> <1.119, -0.054, 0.000> <0.969, -0.057, 0.000> <0.920, 0.028, 0.000>
		<1.271, -0.161, 0.000> <1.213, -0.082, 0.000> <1.125, 0.016, 0.000> <1.076, 0.102, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.958, -0.068, 0.000> <1.056, -0.070, -0.000> <1.177, -0.133, 0.000> <1.271, -0.161, 0.000>
		<0.835, -0.065, 0.000> <0.933, -0.067, 0.000> <1.119, -0.054, 0.000> <1.213, -0.082, 0.000>
		<0.552, -0.144, 0.000> <0.709, -0.071, 0.000> <1.121, 0.014, 0.000> <1.125, 0.016, 0.000>
		<0.555, -0.144, 0.000> <0.711, -0.070, 0.000> <1.072, 0.100, 0.000> <1.076, 0.102, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.271, 0.890, 0.000> <0.191, 0.897, 0.000> <0.073, 0.879, 0.000> <0.008, 0.831, 0.000>
		<0.413, 0.876, 0.000> <0.333, 0.884, 0.000> <0.094, 0.896, 0.191> <0.029, 0.847, 0.191>
		<0.713, 0.766, 0.000> <0.696, 0.762, 0.004> <0.425, 0.468, 0.111> <0.393, 0.425, 0.127>
		<0.729, 0.763, 0.000> <0.712, 0.759, 0.004> <0.472, 0.418, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.008, 0.746, 0.000> <1.110, 0.763, 0.000> <1.234, 0.829, 0.000> <1.331, 0.864, 0.000>
		<0.926, 0.732, 0.000> <1.027, 0.749, 0.000> <1.155, 0.730, 0.000> <1.252, 0.765, 0.000>
		<0.738, 0.761, 0.000> <0.752, 0.764, -0.003> <1.031, 0.711, 0.000> <1.133, 0.643, 0.000>
		<0.729, 0.763, 0.000> <0.742, 0.766, -0.003> <0.966, 0.603, 0.000> <1.068, 0.534, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.068, 0.534, 0.000> <1.032, 0.475, 0.000> <0.999, 0.383, 0.000> <1.000, 0.314, 0.000>
		<0.966, 0.603, 0.000> <0.931, 0.543, 0.000> <1.017, 0.398, 0.173> <1.019, 0.328, 0.173>
		<0.742, 0.766, -0.003> <0.726, 0.762, 0.001> <0.534, 0.411, 0.111> <0.502, 0.368, 0.127>
		<0.729, 0.763, 0.000> <0.712, 0.759, 0.004> <0.472, 0.418, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, 0.314, 0.000> <1.019, 0.328, 0.173> <0.502, 0.368, 0.127> <0.440, 0.375, 0.143>
		<1.001, 0.246, 0.000> <1.020, 0.261, 0.173> <0.515, 0.311, 0.111> <0.453, 0.317, 0.127>
		<1.043, 0.160, 0.000> <0.886, 0.087, 0.000> <0.677, 0.085, 0.043> <0.520, 0.012, 0.043>
		<1.076, 0.102, 0.000> <0.920, 0.028, 0.000> <0.711, -0.070, 0.000> <0.555, -0.144, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.000, 0.314, 0.000> <1.001, 0.246, 0.000> <1.043, 0.160, 0.000> <1.076, 0.102, 0.000>
		<1.019, 0.328, 0.173> <1.020, 0.261, 0.173> <1.038, 0.158, 0.000> <1.072, 0.100, 0.000>
		<0.502, 0.368, 0.127> <0.515, 0.311, 0.111> <0.677, 0.085, 0.043> <0.711, -0.070, 0.000>
		<0.440, 0.375, 0.143> <0.453, 0.317, 0.127> <0.520, 0.012, 0.043> <0.555, -0.144, 0.000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, -0.161, 0.000> <0.084, -0.161, -0.002> <0.040, 0.169, 0.100> <0.035, 0.210, 0.112>
		<0.222, -0.194, 0.000> <0.222, -0.194, -0.002> <0.085, 0.187, 0.103> <0.080, 0.228, 0.116>
		<0.558, -0.144, 0.000> <0.523, 0.012, 0.043> <0.408, 0.299, 0.124> <0.396, 0.357, 0.139>
		<0.555, -0.144, 0.000> <0.520, 0.012, 0.043> <0.453, 0.317, 0.127> <0.440, 0.375, 0.143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, -0.161, 0.000> <0.085, -0.161, 0.000> <0.085, -0.161, 0.000> <0.085, -0.161, 0.000>
		<-0.040, -0.131, -0.000> <-0.041, -0.131, -0.003> <-0.041, -0.131, -0.003> <0.084, -0.161, -0.002>
		<-0.183, -0.021, -0.000> <-0.166, -0.014, 0.109> <0.005, 0.153, 0.088> <0.040, 0.169, 0.100>
		<-0.284, 0.059, -0.000> <-0.267, 0.066, 0.109> <-0.000, 0.194, 0.100> <0.035, 0.210, 0.112>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.440, 0.375, 0.143> <0.396, 0.357, 0.139> <0.080, 0.228, 0.116> <0.035, 0.210, 0.112>
		<0.393, 0.425, 0.127> <0.348, 0.407, 0.123> <0.048, 0.259, 0.103> <0.003, 0.241, 0.100>
		<0.029, 0.847, 0.191> <-0.073, 0.769, 0.191> <-0.161, 0.604, 0.124> <-0.235, 0.500, 0.124>
		<0.008, 0.831, 0.000> <-0.094, 0.753, 0.000> <-0.179, 0.596, 0.000> <-0.254, 0.492, 0.000>
	}
    bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1, 0.2, 0> <1.1, 0.2, 0> <1.15, 0.2, 0> <1.2, 0.15, 0>
		<1, 0.3, 0> <1.1, 0.3, 0> <1.15, 0.3, 0> <1.15, 0.3, 0>
		<1, 0.4, 0> <1.1, 0.4, 0> <1.15, 0.4, 0> <1.15, 0.4, 0>
		<1, 0.5, 0> <1.1, 0.5, 0> <1.15, 0.5, 0> <1.2, 0.55, 0>
	}
    sphere {
           <0, 0.4, 0>, 0.08
           scale <1, 1, 2>
           pigment {color Black}
    }
pigment {wood
         turbulence 0.02
         color_map {
         [0.0 color Black]
         [0.5 color Black]
         [0.5 color White]
         [1.0 color White] }
         scale <0.6, 0.7, 1>
         translate <-0.6, 0.5, 0>
         }
scale 0.3
} // end damsel fish union


// -----------------------

#declare Clownfish =
object {Humbug_Damsel
pigment {gradient x
         turbulence 0.15
         color_map {
         [0.0 color Orange]
         [0.6 color Orange]
         [0.6 color Black]
         [0.8 color Black]
         [0.8 color White]
         [1.0 color White] }
         scale 2.1
         }
scale <1.2, 0.8, 1>
} // clownfish

// ----------------------------

#declare Long_Nose_Butterflyfish =
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.508, -0.119, 0.000> <-1.582, 0.061, 0.000> <-1.421, 0.329, 0.000> <-1.347, 0.508, 0.000>
		<-1.458, -0.242, 0.000> <-1.531, -0.062, 0.000> <-1.323, 0.198, -0.015> <-1.250, 0.378, -0.015>
		<-1.201, -0.173, 0.000> <-1.188, -0.097, -0.015> <-1.026, 0.080, -0.048> <-1.028, 0.086, -0.048>
		<-1.068, -0.178, 0.000> <-1.054, -0.103, -0.015> <-1.020, 0.067, -0.048> <-1.023, 0.073, -0.048>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.780, 0.119, 0.000> <0.809, 0.109, 0.000> <0.884, 0.083, 0.000> <0.864, 0.059, 0.000>
		<0.632, 0.166, 0.000> <0.662, 0.156, 0.000> <0.691, 0.109, 0.000> <0.671, 0.085, 0.000>
		<0.393, 0.140, 0.001> <0.375, 0.109, 0.001> <0.422, 0.159, 0.014> <0.414, 0.125, 0.014>
		<0.280, 0.246, 0.000> <0.262, 0.215, 0.000> <0.228, 0.178, 0.000> <0.220, 0.144, 0.000>
pigment {color Gray10}
	}

	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.347, 0.508, 0.000> <-1.267, 0.706, 0.000> <-1.097, 1.058, 0.000> <-1.000, 1.127, 0.000>
		<-1.250, 0.378, -0.015> <-1.170, 0.575, -0.015> <-1.046, 0.935, -0.010> <-0.949, 1.004, -0.010>
		<-1.028, 0.086, -0.048> <-1.036, 0.102, -0.049> <-0.831, 0.664, -0.037> <-0.827, 0.817, -0.030>
		<-1.023, 0.073, -0.048> <-1.030, 0.089, -0.049> <-0.833, 0.562, -0.042> <-0.829, 0.715, -0.035>

	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.068, -0.178, 0.000> <-1.068, -0.178, 0.000> <-1.068, -0.178, 0.000> <-1.068, -0.178, 0.000>
		<-0.870, -0.186, 0.000> <-0.856, -0.110, -0.015> <-0.856, -0.110, -0.015> <-1.054, -0.103, -0.015>
		<-0.604, -0.182, 0.000> <-0.800, -0.207, 0.009> <-1.013, 0.052, -0.048> <-1.020, 0.067, -0.048>
		<-0.407, -0.161, 0.000> <-0.603, -0.187, 0.009> <-1.016, 0.058, -0.048> <-1.023, 0.073, -0.048>

	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.703, 0.025, 0.000> <0.556, 0.003, 0.000> <0.359, -0.018, 0.000> <0.212, -0.042, 0.000>
		<0.752, 0.033, 0.000> <0.605, 0.010, 0.000> <0.361, 0.038, 0.000> <0.214, 0.014, 0.000>
		<0.833, 0.021, 0.000> <0.640, 0.047, 0.000> <0.401, 0.070, 0.014> <0.208, 0.090, 0.000>
		<0.864, 0.059, 0.000> <0.671, 0.085, 0.000> <0.414, 0.125, 0.014> <0.220, 0.144, 0.000>
pigment {gradient y
         color_map {
         [0.0 color Gray60]
         [0.5 color Gray60]
         [1.0 color Gray10]}
         scale 0.2
         }
	}

	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.212, -0.042, 0.000> <0.025, -0.074, 0.000> <-0.219, -0.141, 0.000> <-0.407, -0.161, 0.000>
		<0.214, 0.014, 0.000> <0.028, -0.018, 0.000> <-0.109, -0.127, -0.005> <-0.297, -0.147, -0.005>
		<0.208, 0.090, 0.000> <0.061, 0.104, -0.011> <-0.229, 0.190, -0.082> <-0.377, 0.118, -0.082>
		<0.220, 0.144, 0.000> <0.073, 0.159, -0.011> <-0.117, 0.244, -0.082> <-0.266, 0.172, -0.082>
pigment {gradient y
         turbulence 0.1
         color_map {
         [0.0 color Gray60]
         [0.1 color Gray60]
         [0.1 color Gray20]
         [0.15 color Gray20]
         [0.15 color Gray60]
         [0.25 color Gray60]
         [0.25 color Gray20]
         [0.3 color Gray60]
         [0.5 color Gray60]
         [1.0 color Gray10]}
         scale 0.2
         }

	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.280, 0.246, 0.000> <0.262, 0.215, 0.000> <0.228, 0.178, 0.000> <0.220, 0.144, 0.000>
		<0.129, 0.386, -0.001> <0.112, 0.356, -0.001> <0.081, 0.193, -0.011> <0.073, 0.159, -0.011>
		<0.097, 0.693, -0.006> <0.023, 0.485, -0.028> <0.069, 0.405, -0.053> <-0.117, 0.244, -0.082>
		<-0.017, 0.864, -0.006> <-0.092, 0.657, -0.028> <-0.080, 0.333, -0.053> <-0.266, 0.172, -0.082>
pigment {color Gray10}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.017, 0.864, -0.006> <-0.092, 0.657, -0.028> <-0.080, 0.333, -0.053> <-0.266, 0.172, -0.082>
		<-0.098, 0.986, -0.006> <-0.172, 0.778, -0.028> <-0.173, 0.252, -0.068> <-0.359, 0.091, -0.096>
		<-0.221, 1.169, -0.001> <-0.243, 0.958, -0.022> <-0.417, 0.501, -0.072> <-0.413, 0.506, -0.072>
		<-0.362, 1.206, 0.000> <-0.384, 0.995, -0.021> <-0.440, 0.498, -0.071> <-0.435, 0.503, -0.071>
//pigment {color Red}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.000, 1.127, 0.000> <-0.912, 1.190, 0.000> <-0.548, 1.256, 0.001> <-0.362, 1.206, 0.000>
		<-0.949, 1.004, -0.010> <-0.861, 1.066, -0.010> <-0.570, 1.045, -0.020> <-0.384, 0.995, -0.021>
		<-0.827, 0.817, -0.030> <-0.737, 0.769, -0.038> <-0.437, 0.501, -0.071> <-0.440, 0.498, -0.071>
		<-0.829, 0.715, -0.035> <-0.739, 0.667, -0.043> <-0.432, 0.506, -0.070> <-0.435, 0.503, -0.071>
//pigment {color Red}
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.829, 0.715, -0.035> <-0.829, 0.715, -0.035> <-0.829, 0.715, -0.035> <-0.829, 0.715, -0.035>
		<-0.833, 0.562, -0.042> <-0.743, 0.514, -0.050> <-0.743, 0.514, -0.050> <-0.739, 0.667, -0.043>
		<-1.030, 0.089, -0.049> <-0.973, 0.131, -0.051> <-0.477, 0.500, -0.068> <-0.432, 0.506, -0.070>
		<-1.023, 0.073, -0.048> <-0.966, 0.115, -0.051> <-0.480, 0.497, -0.069> <-0.435, 0.503, -0.071>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.266, 0.172, -0.082> <-0.377, 0.118, -0.082> <-0.297, -0.147, -0.005> <-0.407, -0.161, 0.000>
		<-0.359, 0.091, -0.096> <-0.471, 0.037, -0.096> <-0.493, -0.172, 0.004> <-0.603, -0.187, 0.009>
		<-0.413, 0.506, -0.072> <-0.457, 0.500, -0.070> <-0.958, 0.100, -0.050> <-1.016, 0.058, -0.048>
		<-0.435, 0.503, -0.071> <-0.480, 0.497, -0.069> <-0.966, 0.115, -0.051> <-1.023, 0.073, -0.048>

	}

	pigment {color rgb <1, 0.7, 0>}
    finish {ambient 0.6 diffuse 0.8}
}
