#include "colors.inc"
#include "textures.inc"

#include "stones1.inc"
#include "metals.inc"
#include "glass.inc"

#declare atmosphere_on = 1;
#declare cave_on       = 1;

#declare Brushed_scale = 40;

#declare r1 = seed (7)


global_settings {
	number_of_waves  15
}


#declare Cave_Rock =
texture {
	pigment {
		granite
		turbulence 0.0
		color_map {
   			[0.0, 0.3 color White color <0.33, 0.33, 0.33>]
    			[0.3, 0.4 color <0.33, 0.33, 0.33> color <0.35, 0.33, 0.33>]
    			[0.4, 0.6 color <0.35, 0.33, 0.33> color <0.36, 0.34, 0.33>]
    			[0.6, 1.0 color <0.36, 0.34, 0.33> color <0.33, 0.33, 0.33>]
   		}
 	}

	normal {
		crackle 1
		scale 2
	}

 	finish {
 		ambient     0.1
		diffuse     0.9
		brilliance  5
		specular    0.4
		roughness   0.001
 	}
}

#declare water_dt = 
	texture {
		pigment {
			color rgbf <0.3, 0.4, 1, 0.95>
		}

		normal {
			marble
			turbulence 0.2
		}
		normal {
			waves 0.4
			translate <-0.5, -0.5, -0.5>
			scale <99, 2, 99>

		}
		normal {
			ripples 0.6
			translate <-0.5, -0.5, -0.5>
			scale <99, 2, 99>
		}
		normal {
			ripples 0.7
			//translate <-0.5, -0.5, -0.5>
			//scale <80, 2, 80>
		}
		finish {
			refraction 1
			ior        1.33
			reflection 0.5
			specular   0.95
			roughness  0.08
			caustics   0.9
		}
	}


#declare fount_water_dt = 
	texture {
		pigment {
			color rgbf <0.8, 0.85, 1, 0.95>
		}

		normal {
			marble
			turbulence 0.2
		}
		normal {
			waves 0.4
			translate <-0.5, -0.5, -0.5>
			scale <99, 2, 99>

		}
		normal {
			ripples 0.6
			translate <-0.5, -0.5, -0.5>
			scale <99, 2, 99>
		}
		normal {
			ripples 0.7
			//translate <-0.5, -0.5, -0.5>
			//scale <80, 2, 80>
		}
		finish {
			refraction 1
			ior        1.33
			reflection 0.5
			specular   0.95
			roughness  0.08
			caustics   0.9
		}
	}

/*
//side chair cam
camera {
	location <10, 10, 2.9> 
	look_at  < 0,  5, 4.0>


}
*/

camera {
	location <-4, 14, -15>
	look_at  <0, 3,    2>
}


//outside cam
/*
camera {
	location <1,  100, 1>
	look_at  <1,    0, 0>

}
*/


light_source {
	<0, 38, 0>  color <0.49, 0.5, 0.47>
	atmospheric_attenuation on
}


//water
plane {
	y, 0
	texture {
		water_dt
	}
	hollow
}

#if (cave_on)
//cave floor
height_field {
	png "cave.png"
	smooth

	translate <-0.5, 0, -0.5>
	scale     <100, 4, 100>
	rotate    <0, 221, 0>
	translate y * -5

	texture {
		Cave_Rock
		scale 3
	}
	hollow
}

//cave
height_field {
	png "cave.png"
	smooth

	translate <-0.5, 0, -0.5>
	scale     <100, 49, 100>
	rotate    <0, 21, 0>
	translate y * -5

	texture {
		Cave_Rock
		scale 3
	}
	hollow
}

#end // end if cave on


//island
height_field {
	png "island4.png"
	smooth

	translate <-0.5, 0, -0.5>
	scale     <35, 8.7, 35>
	rotate    <0, 21, 0>
	translate y * -5

	texture {
		Cave_Rock
		scale 3
	}
	hollow
}


//fountain water

blob {
	threshold 0.2

#declare j = 0;
#while (j < 10016)
	#declare j = j + 1

	//#declare xx = rand (r1) * rand (r1) * 2 - 1;
	//#declare zz = rand (r1) * rand (r1) * 2 - 1;
	//#declare yy = rand (r1) * (1 - sqrt (xx * xx + zz * zz)) * 5;

	#declare xx = 0.4 + j / 17003
	#declare zz = 0
	#declare yy = (1 - pow (((xx + 0.2) * 2 - 1), 2)) * 4 + 0

	sphere {
	<xx, yy + 5, zz>, 0.05, 1
	texture {
		fount_water_dt
	}

	rotate y * rand (r1) * 360
	}

#end
translate y * -1
}

cylinder {
	<0, 3, 0>
	<0, 6.5, 0>, 0.2
	texture {
		Brushed_Aluminum
		scale Brushed_scale
	}
}

cylinder {
	< 0, 3.2001, 0>
	< 0, 3.5, 0>, 1.2

	texture { 
		fount_water_dt
	}
}

difference {
cylinder {
	< 0, 3.2, 0>
	< 0, 3.6, 0>, 1.3

	texture { 
		T_Stone17
	}
}

cylinder {
	< 0, 3.35, 0>
	< 0, 3.7, 0>, 1.2

	texture { 
		T_Stone17
	}
}
}

#declare stack_of_disks = 

#declare h = 4;
union {
#while (h < 4.5)
	#declare h = h + 0.05 
	cylinder {
		<0, h, 0>,
		<0, h + 0.02, 0>, (5 - h)  
		texture {
			Spun_Brass
			scale Brushed_scale
		}
	}
#end
}


#declare stack_of_washers =
difference {

	object {
		stack_of_disks
	}
	cylinder {
		<0, 3.9, 0>,
		<0, 7.1, 0>, 0.4
	}
	
}



#declare chair_basket = 

#difference {

#declare ang = 0;
union {
#while (ang < 360) 

	#declare ang = ang + 360 / 9

		cylinder {
			<-0.02, 5.5, 0>,
			< 0.02, 5.5, 0>, 1

			rotate y * ang
		}
#end
} // end union


box {
	<-4, 5.2, -4>,
	< 4, 12,  4>

}

sphere { 
	<0, 5.6, 0>, 0.95
}
	texture {
		Brushed_Aluminum
		scale Brushed_scale
	}


}//end difference
// end chair basket


#declare chair_base = 
//chair (base)
union {
	object {
		stack_of_washers
	}
	object {
		chair_basket
	}

	translate <0, 0, 4.3>
}




//chair back
#declare chair_back = 

union {

#declare ang = -50
#while (ang < 50) 
	#declare ang = ang + 10
	prism {
		linear_sweep
		quadratic_spline
		0
		1
		10
		< 0.2,  0.0>, < 0.0,  0.2>, <-1.4,  0.2>, <-1.9,  2.6>,
		<-2.0,  2.7>, <-2.1,  2.6>, <-2.1, -0.2>, < 0.0, -0.1>,
		< 0.2,  0.0>, < 0.0,  0.2>

		translate y * -0.5
		scale <1, .1, 1>
		rotate <-90, 90, 0>
		translate <ang * .02, 5.5, 3.4>

		texture {
			Brushed_Aluminum
			scale Brushed_scale
		}

	}

#end
} // end chair back


#declare chair_stuff = union {

	//seat
	superellipsoid {
		<0.2, 0.6>
		rotate x * -90
		scale <1.01, .2, 1.01>
		translate y * 0.6
	}

	//right arm
	superellipsoid {
		<0.25, 0.25>
		scale <0.1, 0.05, 0.7>
		translate <1.1, 1.3, 0.2>

	}

	//right arm supports
	cone {
		<1.1, 1.3, 0.6>, 0.09
		<1.0, 0.5, 0.5>, 0.06

	}

	cone {
		<1.1, 1.3, -0.2>, 0.09
		<1.0, 0.5, -0.1>, 0.06

	}


	//left arm
	superellipsoid {
		<0.25, 0.25>
		scale <0.1, 0.05, 0.7>
		translate <-1.1, 1.3, 0.2>

	}

	//left arm supports
	cone {
		<-1.1, 1.3, 0.6>, 0.09
		<-1.0, 0.5, 0.5>, 0.06

	}

	cone {
		<-1.1, 1.3, -0.2>, 0.09
		<-1.0, 0.5, -0.1>, 0.06

	}

	//chair back top

	sphere {
		<0, 0, 0>, 1

		scale     <1, 0.2, 0.1>
		translate <0.02, 3.5, 1.4>
	}

	texture {
		Brushed_Aluminum
		scale 10
	}


translate <0, 5, 4>

} // end chair union

#declare chair = 
union {
	object {
		chair_base
	}
	object {
		chair_back
	}

	object { 
		chair_stuff
	}
}


#declare ang = 0
#while (ang < 3)
object { 
	chair rotate y * 120 * ang
	translate y * -1
}
#declare ang = ang + 1
#end


//lights
#declare ang = 0

#while (ang < 360) 
	#declare ang = ang + 30
	
	cylinder {
		<0.7, 0, 0>,
		<10,  0, 0>, 0.1
		translate <37, 8, 0>
		rotate y * ang
		texture {
			T_Brass_3C

		}

	}


	sphere {

		<0, 0, 0>, 1 
		texture {
			pigment {
				color <0.6, 0.6, 1, 0.1, 0.95>
			}
			halo {
				emitting
				spherical_mapping
				linear
				color_map {
				[0.0 color rgbt <1.0, 1.0, 0.6, 1.0>]
				[1.0 color rgbt <1.0, 1.0, 1.0,-1.0>]
				}
				scale 0.7	
			}
			
			finish {
				reflection 0.1
				specular   0.9
				roughness  0.00001

			}
		} 
		translate <37, 8, 0>
		rotate y * ang
		hollow
		
	}
	light_source {
		<37, 8, 0> color <0.7, 0.7, 0.62> * 0.5
		rotate y * ang
		fade_distance 9
		fade_power 1
		atmospheric_attenuation on
	}


#end

#if (atmosphere_on)
atmosphere {
	type 2
	samples 10
	distance 1000
	scattering 0.011
	aa_level 2
	aa_threshold 0.2
	color rgbf <0.8, 0.8, 0.8, 0.1>
}
#end

/*
#declare xx = -100
#declare yy = -100
#declare zz = 0

#while (xx < 100) 

#declare yy = -100
#declare xx = xx + 10

#while (yy < 100)

#declare zz = 0
#declare yy = yy + 10

#while (zz < 100)

#declare zz = zz + 5
sphere {
	<xx, yy, zz>, 0.5
	texture {
		pigment {
			color Red
		}
	}
}
#end
#end
#end
*/







