
#ifndef (pic_w)
  #declare pic_w = 4
#end
#ifndef (pic_h)
  #declare pic_h = 6
#end
#ifndef (frame_t)
  #declare frame_t = 1
#end
#ifndef (stand_r)
  #declare stand_r = 0.375
#end
#ifndef (phi)
  #declare phi = 80
#end
#ifndef (theta)
  #declare theta = 60
#end
#ifndef (PictureTexture)
  #declare PictureTexture = texture{pigment{
    mandel 50
    color_map
    {
      [  0.1  color red 0.0 green 0.0 blue 0.0]
      [  0.3  color red 0.8 green 0.4 blue 0.2]
      [  0.5  color red 0.0 green 0.0 blue 0.0]
      [  0.7  color red 0.0 green 0.0 blue 0.8]
      [  1.0  color red 0.8 green 0.8 blue 0.8]
    }
  } }
#end
#ifndef (BackTexture)
  #declare BackTexture = texture{pigment{
      wood
      turbulence 0.1 // should have some!
      color_map
      {
        [  0.1  color red 0.0 green 0.0 blue 0.0]
        [  0.3  color red 0.8 green 0.4 blue 0.2]
        [  0.5  color red 0.0 green 0.0 blue 0.0]
        [  0.7  color red 0.0 green 0.0 blue 0.8]
        [  1.0  color red 0.8 green 0.8 blue 0.8]
      }
  } }
#end

#declare Ev = frame_t/2
#declare Fv = Ev + Ev
#declare Gv = Fv + pic_h
#declare Hv = Gv + Ev
#declare Iv = Hv + Ev
#declare Cv = pic_w/2
#declare Bv = Cv + Ev
#declare Av = Bv + Ev
#declare Dv = 0

#declare PFpln1 = plane { y-x, Av/sqrt(2) }
#declare PFpln4 = plane { y+x, Av/sqrt(2) }
#declare PFpln3 = plane { y-x, (Iv-Av)/sqrt(2) }
#declare PFpln2 = plane { y+x, (Iv-Av)/sqrt(2) }

#declare PFcyl1 = cylinder { <Bv,0,0>, <Bv,Iv,0>, Ev }
#declare PFcyl2 = cylinder { <-Bv,0,0>, <-Bv,Iv,0>, Ev }
#declare PFcyl4 = cylinder { <Av,Ev,0>, <-Av,Ev,0>, Ev }
#declare PFcyl3 = cylinder { <Av,Hv,0>, <-Av,Hv,0>, Ev }

#declare PFfra1 = intersection { object{PFcyl1} object{PFpln3} object{PFpln4 inverse} }
#declare PFfra2 = intersection { object{PFcyl2} object{PFpln1 inverse} object{PFpln2} }
#declare PFfra3 = intersection { object{PFcyl3} object{PFpln3 inverse} object{PFpln2 inverse} }
#declare PFfra4 = intersection { object{PFcyl4} object{PFpln1} object{PFpln4} }

#declare PictureFrame = merge
{
  object{PFfra1}
  object{PFfra2}
  object{PFfra3}
  object{PFfra4}
  translate <0,-Ev,0>
  rotate <phi-90,0,0>
  translate <0,Ev,0>
}

#declare PictureImage = merge
{
  box { <-Cv, Fv, -0.00001>, < Cv, Gv, 0 > texture{BackTexture} }
  box { <-Cv, Fv, 0 >, < Cv, Gv, 0.00001>
        texture{PictureTexture scale <pic_w,pic_h,1>
                               translate <-Cv,Fv,0>
                               } }
  translate <0,-Ev,0>
  rotate <phi-90,0,0>
  translate <0,Ev,0>
}

#declare phirad = phi*3.1415926535898/180
#declare thetarad = theta*3.1415926535898/180
#declare Xv = stand_r / abs( tan(phirad+thetarad) )

#declare Rv = Ev + pic_h/2*sin(phirad)+Xv*sin(thetarad)
#declare Sv = -pic_h/2*cos(phirad) + Xv*cos(thetarad)
#declare Tv = -stand_r * cos(phirad)
#declare Uv = Sv - ( Ev + pic_h/2 * sin(phirad) + stand_r*cos(thetarad) ) / tan(thetarad)

#declare PictureStand = intersection
{
  cylinder { <0,Rv,Sv>, <0,Tv,Uv>, stand_r }
  plane {-y, 0}
  plane {z,0 rotate <phi-90,0,0> translate <0,Ev,0>}
}

