
#ifndef (tile_x)
  #declare tile_x=1  //  x-size of the tile..
#end

#ifndef (tile_y)
  #declare tile_y=1  //  y-size of the tile..
#end

#ifndef (tile_z)
  #declare tile_z=0.1 // Thickness of the tile...
#end

#ifndef (numtile_x)
  #declare numtile_x=10 //  number of tiles (x direction)..
#end

#ifndef (numtile_y)
  #declare numtile_y=10  //  number of tiles (y direction)..
#end

#ifndef (cement_w)
  #declare cement_w=0.1  // width of cement.
#end

#declare tile_x = tile_x - cement_w
#declare tile_y = tile_y - cement_w

#ifndef (tile_texture)
  #declare tile_texture = texture { pigment {color White} finish {Shiny reflection 0.3} normal {bumps 0.3} }
#end  // default texture for tiles

#ifndef (cement_texture)
  #declare cement_texture = texture { pigment {color rgb <1,1,0.8>} normal {bumps 0.1 scale 0.01} }
#end  // default texture for cement

#ifndef (scale_texture)
  #declare scale_texture=yes
#end  //  decide whether tile_texture should be scaled to fit the tile.

//  at the end, WallTiling is the tiles and cement, (in the xy plane)
//  TilePlane is just the tiles, and CementPlane is just the cement.

#declare TFsingle_tile =
superellipsoid
{
  <0.1, 0.1>
  #if (scale_texture)
    texture{tile_texture}
    scale <tile_x,tile_y,tile_z>/2
  #else
    scale <tile_x,tile_y,tile_z>/2
    texture{tile_texture}
  #end
}

#declare x_width = (tile_x+cement_w)*numtile_x
#declare y_width = (tile_y+cement_w)*numtile_y
#declare CementPlane = box {
    <-x_width/2,-y_width/2,-0.00001>,<x_width/2,y_width/2,0.00001>
    texture{cement_texture}
}

#declare TilePlane=union {
  #declare num_x=0
  #while (num_x < numtile_x)
    #declare num_y=0
    #while (num_y < numtile_y)
      object{
        TFsingle_tile
        translate <(num_x-(numtile_x-1)/2)*(tile_x+cement_w),
                   (num_y-(numtile_y-1)/2)*(tile_y+cement_w),0>
      }
      #declare num_y=num_y+1
    #end
    #declare num_x=num_x+1
  #end
}

#declare WallTiling = union {
  object {TilePlane}
  object {CementPlane}
}

#declare tile_x = tile_x + cement_w
#declare tile_y = tile_y + cement_w
