#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

background { SkyBlue }

camera {
        location  <0, 800, -1000>
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <4/3, 0,  0>
        look_at   <0, 900, 0>
}

light_source {<0, 1000, -1500> color White*.9}
light_source {<500, 1500, -1500> color White*.7}
light_source {<-500, 1500, -1500> color White*.7}

// The Water
plane { <0,1,0>, 0
        texture { pigment { onion
                            turbulence 2.0
                            color_map { [ 0.0 color White ]
                                        [ 1.0 color rgb <0, .5, 1> ]
                                      }
                           scale .4          
                          }
                  normal {bumps 0.5 scale .8}
                  finish {phong 1 reflection .5 ambient 0.1 diffuse 0.2}
                }
        scale 50
}


// Rainbow
// /* <------- Rainbow Temp Out
#declare r_violet1 = colour red 1.0 green 0.5 blue 1.0 filter 1.0 transmit .80;
#declare r_violet2 = colour red 1.0 green 0.5 blue 1.0 filter 0.8 transmit .78;
#declare r_indigo  = colour red 0.5 green 0.5 blue 1.0 filter 0.8 transmit .76;
#declare r_blue    = colour red 0.2 green 0.2 blue 1.0 filter 0.8 transmit .74;
#declare r_cyan    = colour red 0.2 green 1.0 blue 1.0 filter 0.8 transmit .72;
#declare r_green   = colour red 0.2 green 1.0 blue 0.2 filter 0.8 transmit .72;
#declare r_yellow  = colour red 1.0 green 1.0 blue 0.2 filter 0.8 transmit .74;
#declare r_orange  = colour red 1.0 green 0.5 blue 0.2 filter 0.8 transmit .76;
#declare r_red1    = colour red 1.0 green 0.2 blue 0.2 filter 0.8 transmit .78;
#declare r_red2    = colour red 1.0 green 0.2 blue 0.2 filter 1.0 transmit .80;
rainbow {
  angle 37 
  width 5
  arc_angle 90
  falloff_angle 60
  distance 1.0e6
  direction <0.3, -0.6, 1>
  jitter 0.01
  colour_map {
    [0.000  colour r_violet1]
    [0.100  colour r_violet2]
    [0.214  colour r_indigo]
    [0.328  colour r_blue]
    [0.442  colour r_cyan]
    [0.556  colour r_green]
    [0.670  colour r_yellow]
    [0.784  colour r_orange]
    [0.900  colour r_red1]
  }
}
// <----- End Rainbow Out */

sky_sphere { S_Cloud4 }

// Upper Cloud
// /* <-------- Upper Cloud Temp Out
sphere { 0, 2
         pigment { color rgbt <1, 1, 1, 1> } 
         hollow
         halo { emitting 
                spherical_mapping
                linear
                turbulence <.7, 1.5, .7>
                color_map {
                           [ 0.40 color rgbt <0.90, 0.91, 0.99,  1> ] //Silver
                           [ 0.50 color rgbt <0.30, 0.30, 0.50, -1> ] //GrayBlue
                           [ 0.60 color rgbt <0.90, 0.75, 0.59,  -1> ] //Gold
                           [ 0.70 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear                           
                           [ 1.00 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear
                          } 
                samples 25
                aa_threshold 0.3
                aa_level 2
                jitter .2
              }
         rotate <0, -180, 0>
         scale <600, 600, 600>
         translate <-200, 800, 500>
       }
// <--------- End Upper Cloud Out */
        
// Lower Cloud
// /* <-------- Lower Cloud Temp Out
sphere { 0, 2
         pigment { color rgbt <1, 1, 1, 1> } 
         hollow
         halo { emitting 
                spherical_mapping
                linear
                turbulence <.5, 1.0, .5>
                color_map {
                           [ 0.40 color rgbt <0.90, 0.91, 0.99,  1> ] //Silver
                           [ 0.50 color rgbt <0.30, 0.30, 0.50, -1> ] //GrayBlue
                           [ 0.60 color rgbt <0.90, 0.75, 0.59,  -1> ] //Gold
                           [ 0.70 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear                           
                           [ 1.00 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear
                          } 
                samples 25
                aa_threshold 0.3
                aa_level 2
                jitter .2
              }
         scale <600, 300, 600>
         translate <100, 500, 0>
       }
// <--------- End Lower Cloud Out */
                                                    
// Lower Left Cloud
// /* <-------- Lower Cloud Temp Out
sphere { 0, 2
         pigment { color rgbt <1, 1, 1, 1> } 
         hollow
         halo { emitting 
                spherical_mapping
                linear
                turbulence <.5, 1.0, .5>
                color_map {
                           [ 0.40 color rgbt <0.90, 0.91, 0.99,  1> ] //Silver
                           [ 0.50 color rgbt <0.30, 0.30, 0.50, -1> ] //GrayBlue
                           [ 0.60 color rgbt <0.90, 0.75, 0.59,  -1> ] //Gold
                           [ 0.70 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear                           
                           [ 1.00 color rgbt <1.0, 1.0, 1.0, +1> ] //Clear
                          } 
                samples 25
                aa_threshold 0.3
                aa_level 2
                jitter .2
              }
         scale <600, 300, 600>
         rotate <0, 135, 0>
         translate <-100, 600, 0>
       }
// <--------- End Lower Left Cloud Out */
