// Various pieces of archetecture. Eg columns, lintles, domes ... greek style (well sort of)
// Also includes ruined (broken) versions of each item

#include "colors.inc"
#include "stones.inc"
#include "golds.inc"

/*
#declare T_Grnt8 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.179   color rgbf <0.843, 0.655, 0.655, 0.000>
                    color rgbf <0.886, 0.769, 0.627, 0.000>]
    [0.179, 0.368   color rgbf <0.886, 0.769, 0.627, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.368, 0.538   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.851, 0.671, 0.671, 0.000>]
    [0.538, 0.846   color rgbf <0.851, 0.671, 0.671, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.846, 0.983   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.827, 0.612, 0.612, 0.000>]
    [0.983, 1.001   color rgbf <0.827, 0.612, 0.612, 0.000>
                    color rgbf <0.843, 0.655, 0.655, 0.000>]
   }
 }
}
*/

// Algae look alike. Try layering over a texture to make it
// appear as if the object has been underwater
#declare Algae = texture
{
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgb<0.000, 0.427, 0.239>]
      [0.15 color rgbf<0.000, 0.553, 0.000, 0.400>]
      [0.30 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.70 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.85 color rgbf<0.000, 0.553, 0.000, 0.400>]
      [1.00 color rgb<0.000, 0.427, 0.239>]
    }
  }
  normal
  {
    bumps 0.15
    frequency 9
    scale <0.1, 0.1, 0.1>
  }
}



#declare Grey_Blue_Alabaster =     // from povlab.inc
 texture {
  pigment {
    bozo
    turbulence 1.2
    color_map {
      [0   0.2   color rgb <1, 1, 1>
                 color rgb <0.9, 0.9, 1>]
      [0.2 0.4   color rgb <0.9, 0.9, 1>
                 color rgb <0.8, 0.8, 0.9>]
      [0.4 0.6   color rgb <0.8, 0.8, 0.9>
                 color rgb <0.7, 0.7, 0.8>]
      [0.6 0.8   color rgb <0.7, 0.7, 0.8>
                 color rgb <0.65, 0.65, 0.7>]
      [0.8 1.001 color rgb <0.65, 0.65, 0.7>
                 color rgb <0.7, 0.7, 0.8>]
    }
  }
  finish { ambient 0.45 diffuse 0.4 }
}

#declare FountainTexture = texture {
  pigment {
    marble
    turbulence 0.6
    color_map {
      [0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                      color rgbf <0.745, 0.745, 0.753, 0.000>]
      [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                      color rgbf <0.902, 0.902, 0.859, 0.000>]
      [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                      color rgbf <0.729, 0.706, 0.694, 0.000>]
      [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                      color rgbf <0.588, 0.592, 0.635, 0.000>]
      [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                      color rgbf <0.608, 0.616, 0.659, 0.000>]
      [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                      color rgbf <0.894, 0.886, 0.886, 0.000>]
    }
  }
  scale <2, 5, 2>
  rotate <0, 0, 50>
  finish{ambient 0.2 crand 0.03}
}
texture{
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                      color rgbf <0.322, 0.369, 0.416, 0.847>]
      [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                      color rgbf <0.424, 0.369, 0.420, 0.549>]
      [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                      color rgbf <0.373, 0.424, 0.518, 0.965>]
      [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                      color rgbf <0.482, 0.573, 0.533, 0.741>]
      [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                      color rgbf <0.310, 0.384, 0.420, 0.631>]
    }
  }
  scale <1, 3, 2>
  rotate <0, 0, -30>
}
texture {
  pigment {
    color rgbf <0.752941, 0.752941, 0.752941, .3>
  }
  finish {
    phong 1
    phong_size 100
    ambient .25
    diffuse .5
    reflection .2
  }
}

// 1 unit = 1 metre

#declare column1=
 union {
  difference {
   cylinder {
    <0,0,0>,<0,3,0>,0.2
   }
   union {
    #declare around=0
    #while (around<12)
     union {
      cylinder {
       <0,0.1,0.2>,<0,2.9,0.2>,0.03
      }
      sphere {
       <0,0.1,0.2>,0.03
      }
      sphere {
       <0,2.9,0.2>,0.03
      }
      rotate y*around*30
     }
    #declare around=around+1
    #end
   }
  }
 box {
  <-0.32,-0.15,-0.32>,<0.32,-0.05,0.32>
 }
 torus {
  0.2,0.05
 }
 torus {
  0.25,0.05
  translate y*-0.05
 }
 box {
  <-0.32,3.05,-0.32>,<0.32,3.1,0.32>
 }
 torus {
  0.2,0.05
  translate y*3
 }
 torus {
  0.25,0.05
  translate y*3.05
 }
}

#declare RoofDome=
 difference {
  union {
   box {
    <-2.5,0,-2.5>,<2.5,0.2,2.5>
   }
   box {
    <-2.4,0.2,-2.4>,<2.4,0.4,2.4>
   }
   box {
    <-2.5,0.4,-2.5>,<2.5,0.6,2.5>
   }
   difference {
    sphere {
     <0,0.2,0>,2.3
    }
    box {
     <-2.5,0.2,-2.5>,<2.5,-2.4,2.5>
    }
   }
   cone {
    <0,2.3,0>,0.4,<0,5.1,0>,0.03
   }
  }
  sphere {
   <0,0.2,0>,2.1
  }
 }

#declare Doorway =
 union {
  box {
   <-1.25,0,-0.35>,<1.25,0.2,0.35>
  }
  object {column1 scale <1,0.8,1> translate <-0.94,0.24,0>}
  object {column1 scale <1,0.8,1> translate <0.94,0.24,0>}
  difference {
   union {
    box {
     <-1.4,2.68,-0.35>,<1.4,3.58,0.35>
    }
    box {
     <-1.4,2.68,-0.4>,<1.4,2.78,0>
    }
    box {
     <0,0,-0.4>,<1.8,-0.1,0>
     rotate z*32
     translate <-1.4,2.68,0>
    }
    box {
     <-1.8,0,-0.4>,<0,-0.1,0>
     rotate z*-32
     translate <1.4,2.68,0>
    }
   }
   union {
    box {
     <0,0,-0.5>,<2,1,0.4>
     rotate z*32
     translate <-1.4,2.68,0>
    }
    box {
     <0,0,-0.5>,<-2,1,0.4>
     rotate z*-32
     translate <1.4,2.68,0>
    }
    box {
     <-1.8,2,-0.5>,<1.8,2.68,0.5>
    }
   }
  }
 }

#declare Dome2=
 union {
  cylinder {
   <0,-0.3,0>,<0,0.2,0>,2.5
  }
  #declare around=0
  #while (around<7)
   object {column1 translate <2.1,0.24,0> rotate y*around*45}
   #declare around=around+1
  #end
  intersection {
   difference {
    cylinder {
     <0,3.28,0>,<0,3.68,0>,2.52
    }
    cylinder {
     <0,3.2,0>,<0,3.7,0>,1.7
    }
   }
   torus {
    2.1,0.4
    translate y*3.48
   }
  }
  torus {
   1.9,0.3
   translate y*3.7
  }
  torus {
   1.7,0.3
   translate y*4
  }
 }

#declare Altar=
 union {
  box {
   <-1.3,0.2,-0.8>,<1.3,0.3,0.8>
  }
  box {
   <-1.2,0.25,-0.74>,<1.2,0.4,0.74>
  }
  box {
   <-1.1,0.35,-0.68>,<1.1,0.5,0.68>
  }
  difference {
   box {
    <-1,0.45,-0.6>,<1,1,0.6>
   }
   union {
    box {
     <-0.85,0.9,-0.7>,<0.85,1.1,-0.5>
    }
    box {
     <-0.85,0.9,-0.7>,<0.85,1.1,-0.5>
    }
    box {
     <-1.1,0.9,-0.45>,<-0.9,1.1,0.45>
    }
    box {
     <1.1,0.9,-0.45>,<0.9,1.1,0.45>
    }
    box {
     <-0.75,0.95,-0.4>,<0.75,1.1,0.4>
    }
   }
  }
 }

#declare Fountain=
 union {
  cylinder {
   <0,0,0>,<0,0.05,0>,1.2
  }
  difference {
   cylinder {
    <0,0.05,0>,<0,0.15,0>,1.2
   }
   cylinder {
    <0,0,0>,<0,0.3,0>,1.1
   }
  }
  torus {
   1.15 ,0.05
   translate y*0.15
  }
  cylinder {
   <0,0,0>,<0,2,0>,0.07
  }
  difference {
   torus {
    0.15, 0.08
    translate y*2
   }
   box {
    <-0.3,2,-0.3>,<0.3,1,0.3>
   }
  }
  difference {
   torus {
    0.3, 0.23
    scale <1,0.5,1>
    translate y*1.4
   }
   box {
    <-0.8,1.4,-0.8>,<0.8,0,0.8>
   }
  }
  difference {
   torus {
    0.45, 0.38
    scale <1,0.4,1>
    translate y*0.8
   }
   box {
    <-2,0.8,-2>,<2,0,2>
   }
  }
 texture {FountainTexture}
}

#declare Trans=seed(82347)
#declare Rot=seed(3247)

#declare RuinedDome2=
 difference {
  object {Dome2}
  union {
   plane {
    -x,0
    rotate z*38
    //rotate y*15
    translate <1.1,1.1,0>
   }
   intersection {
    height_field { gif "noise2.gif"
                   scale <6,-0.1,6>
                   rotate z*-38
                   translate <-0.5,2.8,-2.6>
                   //pigment {Red}
                 }
    cylinder {
     <0,2,-2.1>,<0,4,-2.1>,0.5
    }
   }
   intersection {
    height_field { gif "noise2.gif"
                   scale <6,-0.1,6>
                   translate <-0.5,0.8,0>
                   //pigment {Red}
                 }
    cylinder {
     <0,0,-2.1>,<0,2,-2.1>,0.5
     rotate y*-45
    }
   }
   intersection {
    height_field { gif "noise2.gif"
                   scale <6,-0.15,6>
                   rotate z*-38
                   translate <-0.5,2.7,-2.6>
                   //pigment {Red}
                 }
    cylinder {
     <0,2,2.1>,<0,4,2.1>,0.5
    }
   }
   intersection {
     height_field { gif "noise2.gif"
                    scale <10,-0.20,10>
                    rotate z*-52
                    translate <1.1,1.3,-3>
                  }
    box {
     <0.7,-0.5,-3.8>,<3,1.8,2>
    }
//   pigment { Red }
  }
  intersection {
     height_field { gif "noise2.gif"
                    scale <10,-0.25,10>
                    rotate z*-52
                    translate <1.05,1.2,-3>
                  }
    box {
     <1,-0.5,-3.8>,<3,0.4,3.8>
    }
    //pigment { Red }
    rotate y*-25
   }
   intersection {
     height_field { gif "noise2.gif"
                    scale <10,-0.2,10>
                    rotate z*-52
                    translate <1.1,1.2,-5>
                  }
    box {
     <1,-0.5,-5>,<3,0.4,5>
    }
    //pigment { Blue }
    rotate y*-40
   }
   intersection {
     height_field { gif "noise2.gif"
                    scale <10,-0.25,10>
                    rotate z*-52
                    translate <-1.9,5,-5>
                    //pigment {rgb <1.0,0.0,0.0>}
                  }
    box {
     <-3,2.5,-3.8>,<3,6,3.8>
    }
    //pigment { rgbt <1.0,0.0,0.0,1.0> }
   }
    height_field { gif "noise2.gif"
                   scale <10,-0.25,10>
                   rotate z*-90
                   translate <-0.85,13,-5>
                  // pigment {rgb <1.0,0.0,0.0>}
                 }
  }
  bounded_by { box {
                <-2.8,-1,-2.8>,<2.8,5,2.8>
               }
             }
 }

#declare Sign=
 difference {
  box {
   <-1,0,-0.2>,<1,1,0.2>
  }
  union {
   text {ttf "maidword.ttf" "Atlantis" 0.1,0
         scale 0.2
         translate <-0.2,0.7,-0.21>
         texture {T_Gold_4B}
        }
   text {ttf "maidword.ttf" "2795 Ske ->" 0.1,0
         scale 0.2
         translate <-0.3,0.3,-0.21>
         texture {T_Gold_4B}
        }
   height_field { gif "noise2.gif"
                  scale <16,-0.18,16>
                  smooth
                  translate <-2,1,-2>
                  //pigment {Red}
                }

   height_field { gif "noise2.gif"
                  scale <16,-0.25,16>
                  rotate z*-90
                  smooth
                  translate <1.15,2,-2>
                  //pigment {Red}
                }
   height_field { gif "noise2.gif"
                  scale <16,-0.25,16>
                  rotate z*80
                  smooth
                  translate <-1.0,-2,-2>
                  //pigment {Red}
                }
   height_field { gif "noise2.gif"
                  scale <10,0.2,10>
                  smooth
                  translate <-2,0,-2>
                  //pigment {Red}
                }

  }
  bounded_by {
   box {
    <-1.05,-0.05,-0.25>,<1.05,1.05,0.25>
   }
  }
 }

#declare HalfColumn=
 difference {
  object {column1}
  height_field { gif "noise2.gif"
                 scale <8,-0.3,8>
                 smooth
                 rotate z*-20
                 translate <-2,2.5,-2>
                 //pigment {Red}
               }
  bounded_by {
   cylinder {
    <0,-0.3,0>,<0,3,0>,0.35
   }
  }
 }

#declare Columnpiece=
 difference {
  object {column1}
  height_field { gif "noise2.gif"
                 scale <8,-0.3,8>
                 smooth
                 rotate z*-20
                 translate <-2,2.5,-2>
                 //pigment {Red}
               }
  height_field { gif "noise2.gif"
                 scale <8,0.3,8>
                 smooth
                 rotate z*-10
                 rotate x*10
                 translate <-2,1,-2>
                 //pigment {Red}
               }
  bounded_by {
   cylinder {
    <0,0,0>,<0,3,0>,0.35
   }
  }
 }

#declare BrokenDoorway=
 difference {
  object {Doorway}
  union {
   height_field { gif "noise2.gif"
                  scale <8,-0.3,8>
                  smooth
                  rotate z*-40
                  rotate x*-10
                  translate <-2,4,-2>
                  //pigment {Red}
                }
   height_field { gif "noise2.gif"
                  scale <8,-0.2,8>
                  smooth
                  //rotate z*-20
                  rotate x*-93
                  translate <-2,0,-0.38>
                  //pigment {Red}
                }
   height_field { gif "noise2.gif"
                  scale <8,-0.2,8>
                  smooth
                  //rotate z*-20
                  rotate x*-88
                  translate <-2,-7.75,-0.59>
                  //pigment {Red}
                }
  }
  bounded_by {
   box {
    <-1.45,-0.5,-0.4>,<1.45,3.6,0.4>
   }
  }
 }

/*

light_source {
 <5,20,-40> color White
}

light_source {
 <-15,2,-1> color White
}

camera {
 location <0,1.5,-7>
 look_at <0,0.5,0>
}*/
/*
object {BrokenDoorway
        texture {T_Grnt8 }
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        normal { crackle 3.0
                 turbulence .5
                 lambda 2
                 scale <2,1,2>
               }
       }


*/
/*
union {
 object {RuinedDome2
  texture {T_Grnt8 }
  normal { bumps 1
           turbulence 0.6
           scale 0.8
         }
  normal { crackle 3.0
            turbulence .5
           lambda 2
           scale <2,1,2>
        }
 }
 object {Altar
         texture {Grey_Blue_Alabaster scale 0.4}
         scale 0.8
         translate y*0.05
         rotate y*120
        }
 /*box {
  <-0.5,-0.5,-0.5>,<0.5,0.5,0.5> //<-1.5,0,-1>,<1.5,1.2,1>
  pigment { Clear}
  scale <1.4,3.5,1.4>
  halo { emitting
         box_mapping
         linear
         color_map {
                   [0.0 rgbt <1.0,1.0,1.0,1.0>]
                   [0.2 rgbt <1.0,1.0,1.0,1.0>]
                   [0.5 rgbt <0.8,0.8,1.0,0.4>]
                   [1.0 rgbt <0.6,0.6,1.0,0.15>]
                  }
         turbulence <0.1,1,0.1>
         scale <1,1.5,1>
        }
  scale <1.8,0.3,1.8>
  hollow
  rotate y*120
  translate y*0.535
 }*/
 rotate y*55
}
*/
/*
intersection {
     height_field { gif "noise2.gif"
                    scale <10,-0.2,10>
                    rotate z*-90
                    translate <-0.85,5,-5>
                    pigment {rgb <1.0,0.0,0.0>}
                  }
    box {
     <-3,3.2,-3.8>,<3,6,3.8>
    }
   rotate y*55
   pigment { rgbt <1.0,0.0,0.0,1.0> }
  }

// The texture and normal for the ruined dome
// texture {T_Grnt8 }
// normal { bumps 1
//          turbulence 0.6
//          scale 0.8
//        }
// normal { crackle 3.0
//          turbulence .5
//          lambda 2
//          scale <2,1,2>
//       }

//The texture and normal for the sign
//texture {T_Grnt8 }
// normal { bumps 1
//          turbulence 0.6
//          scale 0.5
//        }
// normal { crackle 3.0
//          turbulence .5
//          lambda 2
//          scale <1,0.5,1>
//
*/
/*
box {
 <-12,-5,-12>,<12,5,-10>
 pigment {White}
 no_shadow
}
*/
