//seafloor ruins with a few fish and a hammerhead overhead

#include "colors.inc"
#include "architecture.inc"
#include "hammerhead.inc"
#include "seaweed.inc"

light_source {
 <5,30,5> color White
 area_light <1,0,0>,<0,0,1>,2,2
 adaptive 1
 jitter
}


light_source {
 <5,10,-15> color LightBlue*0.3
 shadowless
 atmosphere off
}

/*
light_source {
 <0,3,-10> color White
}
*/
camera {
 location <0.01,2,-15>
 angle 64
 look_at <0,0.5,0>
}

#declare Bottle=
 difference {
  union {
   cylinder {
    <0,0,0>,<0,2.8,0>,0.5
   }
   torus {
    0.4,0.1
   }
  }
  union {
   cylinder {
    <0,0.5,0>,<0,3,0>,0.4
   }
   height_field { gif "noise.gif"
                  translate <-0.5,0,-0.5>
                  scale <20,-0.8,20>
                  translate y*2.2
                  //pigment {rgb <1.0,0.0,0.0>}
                }
  }
 }

#declare BoatHull =
union {
  intersection {
   sphere {
    <0.5,0,0>,2.2
   }
   box {
    <-1.1,-1.6,-2.4>,<0,0,-1.5>
   }
  }
  intersection {
   box {
    <-1.1,-1.6,-1.5>,<0,0,2.2>
   }
   cylinder {
    <0.49,0.04,-1.51>,<0.49,0.04,2.22>,1.65
   }
  }
  intersection {
   sphere {
    <-0.5,0,0>,2.2
   }
   box {
    <1.1,-1.6,-2.4>,<0,0,-1.5>
   }
  }
  intersection {
   box {
    <1.1,-1.6,-1.5>,<0,0,2.2>
   }
   cylinder {
    <-0.49,0.04,-1.51>,<-0.49,0.04,2.22>,1.65
   }
  }
 }

height_field {
 tga "seafloor.tga"
 smooth
 translate <-0.5,-2,-0.5>
 rotate y*-90
 scale <12,1.2,12>
 pigment {color rgb <1,1,0.2> }
 normal { ripples 0.8
          turbulence 0.7}
 finish {crand 0.4}
 scale 1.5
}

height_field {
 tga "floorpart2.tga"
 smooth
 translate <-0.5,-1.42,-0.5>
 scale <12,4,12>
 translate <-9.5,0,8>
 pigment {color rgb <1,1,0.2> }
 normal { ripples 0.8
          turbulence 0.7}
 finish {crand 0.2}
 scale 1.5
}

height_field {
 tga "floorpart2.tga"
 smooth
 translate <-0.5,-1.42,-0.5>
 scale <12,4,12>
 translate <10.5,0.5,8>
 pigment {color rgb <1,1,0.2> }
 normal { ripples 0.8
          turbulence 0.7}
 finish {crand 0.2}
 scale 1.5
}

height_field {
 tga "slope.tga"
 smooth
 translate <-1.5,-1.55,-0.5>
 scale <25,5,25>
 translate z*30
 pigment {color rgb <1,1,0.2> }
 normal { ripples 0.8
          turbulence 0.7}
 finish {crand 0.2}
 scale 1.5
}

height_field {
 tga "slope.tga"
 smooth
 translate <-0.51,-1.63,-0.5>
 scale <25,5,25>
 translate z*30
 pigment {color rgb <1,1,0.2> }
 normal { ripples 0.8
          turbulence 0.7}
 finish {crand 0.2}
 scale 1.5
}

height_field {
 tga "slope.tga"
 smooth
 translate <0.25,-1.7,-0.5>
 scale <25,5,25>
 translate z*30
 pigment {color rgb <1,1,0.2> }
 normal { ripples 0.8
          turbulence 0.7}
 finish {crand 0.2}
 scale 1.5
}

fog {
 fog_type 2
 distance 35
 color rgb <0,0.1,0.4>
 fog_offset 4
 fog_alt 8
}

/*
atmosphere {
 type 2
 samples 25
 distance 50
 scattering 0.18    // needs to be fairly thick to give the impression of being underwater
 jitter 0.6
 aa_level 8
 aa_threshold 0.1
}
*/

plane {
 y, 11.9
 pigment { rgbf <1,1,1,1> }
 normal { waves 0.9 scale 0.3 turbulence 0.4 translate z*-400}
 finish { caustics 1 }
 hollow
}

plane {
 y,12
 pigment { rgbf <0.4,0.6,1,0.6>} // pigment { color rgbf <0, 0, 0.5, 0.95> }
 normal { waves 0.3 scale 0.001 turbulence 0.3 scale 4000 translate z*-396}
//  normal { ripples 1 }
 finish { specular 0.85  roughness 0.01 refraction 1 ior 1.33 }
 hollow
}

sky_sphere {
 pigment { LightBlue}
}

object {Hammerhead
        scale 3
        rotate x*140
        rotate y*180
        translate <10,10,14>
       }

object {BoatHull
        texture {
         pigment {Tan}
         finish {ambient 0.15 diffuse 0.4}
         normal {bumps 2
                 scale 0.1
                }
        }
        scale 2
        rotate y*-80
        translate <-15,14,25>
       }

object {
 Bottle
 texture {
  pigment { rgbf <0.1,1,0.95,0.7> }
  finish { ambient 0.1
           diffuse 0.1
           reflection 0.1
           refraction 1
           ior 1.45
           specular 8
           roughness 0.003
           phong 1
           phong_size 400
           caustics 1
         }
 }
 texture {
  pigment {
   image_map {gif "label.gif"
              map_type 2
              once
              transmit 228, 1
             }
   scale 1.8
  }
 }
 scale 0.4
 rotate <10,15,-50>
 translate <4.7,-3,-6.6>
}

object {HalfColumn
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        normal { crackle 3.0
                 turbulence .5
                 lambda 2
                 scale <2,1,2>
               }
        rotate z*-10
        scale 1.4
        translate <-13.5,-3.1,10.5>
       }

object {HalfColumn
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        rotate z*-10
        rotate y*80
        scale 1.4
        translate <-8.5,-2.9,6.5>
       }

object {HalfColumn
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        rotate z*-10
        rotate y*120
        scale 1.4
        translate <-5.5,-3.2,0.5>
       }

object {HalfColumn
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        rotate x*-10
        scale 1.4
        translate <11.5,-3.5,10.5>
       }

object {Columnpiece
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        rotate z*-85
        rotate y*40
        scale 1.4
        translate <-6,-3,-2>
       }

object {Columnpiece
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 1
                 turbulence 0.6
                 scale 0.8
               }
        rotate z*-75
        rotate y*30
        scale 1.4
        translate <-4.2,-2.8,-2.8>
       }

object {Columnpiece
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 3
                 turbulence 0.6
                 scale 0.8
               }
        scale <1,1.4,1>
        rotate z*-80
        rotate y*30
        scale 1.4
        translate <-2.4,-2.8,-4.8>
       }

object {Columnpiece
        texture {T_Grnt8 }
        texture {Algae scale 0.8}
        normal { bumps 3
                 turbulence 0.6
                 scale 0.8
               }
        scale <1,1.6,1>
        rotate z*-80
        rotate y*70
        scale 1.4
        translate <5.4,-2.5,0.8>
       }

object {Sign
        texture {T_Grnt8 }
        normal { bumps 3
                 turbulence 0.6
                 scale 0.8
               }
        rotate x*80
        rotate z*-15
        translate <-2,-2.7,-7.2>
       }

object {BrokenDoorway
        texture {T_Grnt8 }
        texture {Algae
                }
        normal { bumps 2
                 turbulence 0.6
                 scale 2
               }
        scale 1.2
        rotate y*-20
        rotate z*20
        rotate x*10
        translate <4.9,-2.9,-5>
       }

object {RuinedDome2
  texture {T_Grnt8 }
  texture {Algae }
  normal { bumps 3
           turbulence 0.6
           scale 3
         }
  /*normal { crackle 1
         //  turbulence .5
           lambda 2
           scale <6,3,6>
        }*/
  scale 1.8
  rotate y*65
  rotate x*7
  rotate z*5
  translate <1.3,-2.75,0>
 }

union {
 object {Altar
         texture {Grey_Blue_Alabaster scale 0.4}
         scale 1.2
         translate y*0.05
         rotate y*120
         no_shadow
        }
 light_source {
  <0,0.45,0> color rgb<0.5,0.0,0.0>
  fade_distance 5
  area_light <0.5,0,0.866>,<0.866,0,0.5>,2,2
  fade_power 2
 }
 box {
  <-0.2,0.6,-0.2>,<0.2,0.7,0.2>
  pigment {Black}
 }  // to block the lightsource. I want it to shine outwards, not upwards.
 box {
  <-0.5,-0.5,-0.5>,<0.5,0.5,0.5> //<-1.5,0,-1>,<1.5,1.2,1>
  pigment { Clear}
  scale <1.4,4,1.4>
  halo { emitting
         box_mapping
         linear
         color_map {
                   [0.0 rgbt <1.0,1.0,1.0,1.0>]
                   [0.2 rgbt <1.0,1.0,1.0,1.0>]
                   [0.5 rgbt <1.0,0.8,0.8,0.3>]
                   [1.0 rgbt <1.0,0.6,0.6,0.15>]
                  }
         turbulence <0.1,1,0.1>
         scale <1,1.5,1>
        }
  scale <2,0.8,2>
  hollow
  rotate y*120
  translate y*0.535
 }
 rotate x*7
 rotate z*5
 translate <1.3,-2.75,0>
}

object {Seaweed
        scale 0.00002
        rotate y*40
        translate <-4.5,-3.2,-7>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

object {Seaweed
        scale 0.00002
        rotate y*80
        translate <-4.1,-3.2,-7.4>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

object {Seaweed
        scale 0.00002
        rotate y*120
        translate <-4.2,-3.2,-6.8>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

object {Seaweed
        scale 0.00002
        rotate y*180
        translate <-4.3,-3.2,-7.4>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

sphere {    // bubble
 <-4.3,3,-6.5>,0.05
 pigment {Clear}
 finish {
  ambient 0
  diffuse 0
  reflection 0.1
  refraction 1
  ior 0.75
  specular 0.9
  roughness 0.005
 }
}

sphere {    // bubble
 <-4.5,3.2,-6.5>,0.03
 pigment {Clear}
 finish {
  ambient 0
  diffuse 0
  reflection 0.1
  refraction 1
  ior 0.75
  specular 0.9
  roughness 0.005
 }
}

sphere {    // bubble
 <-4.1,3.4,-6.3>,0.05
 pigment {Clear}
 finish {
  ambient 0
  diffuse 0
  reflection 0.1
  refraction 1
  ior 0.75
  specular 0.9
  roughness 0.005
 }
}

sphere {    // bubble
 <-4.5,2.8,-6.7>,0.06
 pigment {Clear}
 finish {
  ambient 0
  diffuse 0
  reflection 0.1
  refraction 1
  ior 0.75
  specular 0.9
  roughness 0.005
 }
}

sphere {    // bubble
 <-4.1,1.8,-6.7>,0.07
 pigment {Clear}
 finish {
  ambient 0
  diffuse 0
  reflection 0.1
  refraction 1
  ior 0.75
  specular 0.9
  roughness 0.005
 }
}


object {Seaweed
        scale 0.00002
        rotate y*40
        translate <7.5,-3.2,0>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

object {Seaweed
        scale 0.00002
        rotate y*80
        translate <7.1,-3.2,0.4>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

object {Seaweed
        scale 0.00002
        rotate y*120
        translate <7.2,-3.2,-0.2>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

object {Seaweed
        scale 0.00002
        rotate y*180
        translate <7.2,-3.2,0.4>
        pigment {
         bozo
         color_map {
          [ 0.00 rgbf < 0.300, 0.950, 0.500, 0.500 > ]
          [ 0.20 rgbf < 0.200, 0.780, 0.300, 0.650 > ]
          [ 0.80 rgbf < 0.180, 0.620, 0.100, 0.700 > ]
         }
         frequency 5.0
         turbulence < 0.200, 0.200, 0.200 >
        }
        finish {
         diffuse 0.40
         ambient < 0.100, 0.100, 0.100 >
        }
       }

// Houses in the background

box {
 <6,-12,68>,<0,-10,52>
 texture {T_Stone6}
}

box {
 <-26,-12,58>,<-18,-8,50>
 texture {T_Stone6}
}

box {
 <30,-12,46>,<45,-9,52>
 texture {T_Stone6}
}

box {
 <10,-12,60>,<15,-7,55>
 texture {T_Stone6}
}
