
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.325,0.322,0.275> }

camera {  //  Camera Camera01
  location  <4.876, -18.012, 9.706>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <7.382, -3.645, 5.291>
}


//
// *******  L I G H T S *******
//

light_source {  
  <5.330, -16.502, 9.534>
  color  rgb <1.000, 0.971, 0.843>
  spotlight
  point_at  <6.545, -9.592, 5.691>
  falloff   29.73  
  radius    16.05 
}


//
// ********  TEXTURES  *******
//

#include "surprise.inc"


//
// ********  OBJECTS  *******
//

#include "sink.inc"
#include "plant.inc"
#include "objects_.inc"
#include "mice.inc"
#include "watch.inc"


union { // scene
  object { sink }
  object { miror }
  object { tap }
  object { plant }
  object { neckles }
  object { table }
  object { walls }
  object { objects }
  object { Mice }
  object { watch }
}

text {   // Signature
    ttf      "C:\WIN-95\Fonts\Signetro.ttf",
    "Or",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    texture {
      shiny_black
    }
    no_shadow
    scale <0.15, 0.15, 0.0015>
    rotate <90.0, -0.0, -5.680606>
    translate  <8.0, -11.3, 5.932796>
  }


