//Waterfall
//(c)1998 Sascha Ledinsky
//POV-Ray 3.1

#declare Upper_half=2.5
#declare Lower_half=-5
#declare Clipping_offset=Upper_half

// clipping line=450/600
// for Resolution 800x600 !

global_settings {
  ambient_light 0              
  }

camera {
  orthographic
  right <64*1.6,0,0>
  up <0,48*1.6,0>
  location <450+13,(19.5+2/3)*10+36.75+(2/450*(19.5*2/3)*10),-570+10>
  look_at <13,36.75+(2/450*(19.5*2/3)*10),10>
  }

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0 color rgb <0,0,0.5>]
      [0.99 color rgb <0.4,0.4,1>]
      [1 color rgb <2,1.5,1>]
      }
    scale 2
    translate <0,-1,0>
    }
  rotate -<-90+28,45,0>
  }
    
light_source {
  //<-8000,6000,-8000>
  <-8000,6300,-7500>
  color rgb <1.4,1.2,1.0>/1.1
  area_light <400,400,400>, <400,-400,-400>, 3, 3 adaptive 1 jitter
  }
 
light_source {
  <0,10000,0>
  color rgb <0.2,0.3,0.4>/2*1.5/1.1
  area_light <0,0,7000>,<7000,0,0>,4,4 adaptive 1 jitter
  }
light_source {
  <0,1500,-5000>
  color rgb <0.2,0.3,0.4>/2*1.5/1.1
  area_light <3000,1500,0>,<0,0,0>,4,2 adaptive 1 jitter
  }
light_source {
  <5000,1500,0>
  color rgb <0.2,0.3,0.4>/2*1.5/1.1
  area_light <0,1500,3000>,<0,0,0>,4,2 adaptive 1 jitter
  }


#declare Tx1=texture {
  
  pigment {
    color rgb <0.6,0.6,0.6>
    }
  finish {
    diffuse 1
    ambient 0
    }
  normal {
    bumps 0.5
    turbulence 0.1
    scale <20,20,20>
    }
  }
      
plane { y,-2000 texture { Tx1 } rotate <0,-38,0> }

      
#declare Brick=texture {
  pigment {
    color rgb <0.5,0.5,0.5>
    }
  finish {
    ambient 0.25
    diffuse 1
    specular 0.75 roughness 0.03
    }
  normal {
    bumps
    scale 0.1
    }
  }

#declare Stein_dunkel=texture {
  pigment {
    color rgb <0.4,0.4,0.4>
    }
  finish {
    ambient 0.25
    diffuse 1
    brilliance 0.75
    specular 0.5 roughness 0.02
    crand 0.1
    }
  }
  
#declare Stein=texture {
  pigment {
    color rgb <0.5,0.5,0.5>
    }
  finish {
    ambient 0.25
    diffuse 1
    brilliance 0.75
    specular 0.5 roughness 0.02
    crand 0.1
    }
  }
  
#declare Stein_hell=texture {
  pigment {
    color rgb <0.6,0.6,0.6>
    }
  finish {
    ambient 0.25
    diffuse 1
    brilliance 0.75
    specular 0.5 roughness 0.02
    crand 0.1
    }
  }

#declare Glas=texture {
  pigment {
    colour rgb <1,1,1> filter 0.8
    }
  finish {
    reflection 0.2
    }
  }
    
#declare Gold=texture {
  pigment {
    color rgb <0.9,0.6,0.3>
    }
  finish {
    ambient 0.1
    diffuse 0.3
    reflection <0.6,0.4,0.2>
    specular 1 roughness 0.1 metallic
    }
  }

#declare Metall=texture {
  pigment {
    color rgb <0.2,0.2,0.2>
    }
  finish {
    ambient 0.25
    diffuse 1
    brilliance 1
    specular 1 roughness 0.02
    }
  normal {
    bumps 0.5
    scale 0.25
    }
  }

#declare Stein2=texture {
  pigment {
    color rgb <0.5,0.5,0.5>
    }
  finish {
    ambient 0.25
    diffuse 1
    brilliance 0.75
    specular 0.5 roughness 0.02
    crand 0.1
    }
  }


#declare Water=texture {
  pigment {
    color rgbt <0,0,0,0.9>
    }
  finish {
    ambient 0
    diffuse 0
    reflection <0.33,0.33,0.33>
    refraction 1 ior 1.33
    }
  normal {
    bumps 1
    }
  }

#declare W2=texture {
  pigment {
    color rgbt <1,1,1,1>   
    }
  finish {
    ambient 0
    diffuse 0
    specular 0.75 roughness 0.005
    }
  normal {
    bumps 0.5
    scale <0.25,20,5>
    }
    
  }

#declare W3=texture {
  pigment {
    color rgbt <0,0,0,1>   
    }
  finish {
    ambient 0
    diffuse 0
    }
  normal {
    bumps 0.5
    scale <0.25,20,5>
    }
    
  }
#declare Moertel=texture {
  pigment {
    color rgb <0.4,0.4,0.4>
    }
  finish {
    ambient 0.5
    diffuse 1
    }
  }

#declare Rad_nass=texture {
  pigment {
    color rgb <0.6,0.4,0.3>
    }
  finish {
    ambient 0.15
    diffuse 0.6
    specular 1 roughness 0.02
    reflection 0.25
    crand 0.1
    }
  normal {
    bumps 0.5
    scale 0.5
    }
  }

#declare Rad_trocken=texture {
  pigment {
    color rgb <0.6,0.4,0.3>
    }
  finish {
    ambient 0.25
    diffuse 1
    crand 0.1
    }
  }

#declare Holz=texture {
  pigment {
    color rgb <0.5,0.35,0.25>
    }
  finish {
    ambient 0.25
    diffuse 0.8
    crand 0.1
    }
  }
  
#declare Dachziegel_tx=texture {
  pigment {
    color rgb <1,0.5,0>
    }
  finish {
    diffuse 0.75
    ambient 0
    specular 0.25 roughness 0.1
    crand 0.1
    }
  }
    
#declare Dachziegel1=object {
  union {
    cylinder { <0,0,0>,<0,2/3,0>,3 }
    box { <-3,0,-3>,<0,2/3,3> }
    texture { Dachziegel_tx }    
    matrix <1,1/6,0,0,1,0,0,0,1,0,0,0>
    scale <1,1,0.9>
    }
  }

#declare Dachziegel2=object {
  intersection {
    union {
      object { Dachziegel1 translate <0,0,-3> }
      object { Dachziegel1 translate <0,0,3> }
      }
    box { <-3,0,-3>,<3,2,3> }
    }
    texture { Dachziegel_tx }    
  }
  
#declare X=0;
#declare Z=2;
#declare S=1;

#declare Dach=object {
  union {
    #while (X<14)  
      #while (Z<20)  
        #if (S=0)
          object { Dachziegel1 translate <X*3,0,Z*6> }
          #end
        #if (S=1)
          object { Dachziegel2 translate <X*3,0,Z*6> }
          #end  
        #declare Z=Z+1;
        #end   
      #declare S=1-S;
      #declare Z=2;
      #declare X=X+1;
      #end
    translate <3,0,0>
    scale <14/15/1.5,1,34/20/3>
    rotate <0,0,-35>
    scale <0.5,0.5,0.5>
    }
  }
  
#declare X=0;
#declare Z=0;
#declare S=1;

#declare Dach2=object {
  union {
    #while (X<14)  
      #while (Z<2)  
        #if (S=0)
          object { Dachziegel1 translate <X*3,0,Z*6> }
          #end
        #if (S=1)
          object { Dachziegel2 translate <X*3,0,Z*6> }
          #end  
        #declare Z=Z+1;
        #end   
      #declare S=1-S;
      #declare Z=0;
      #declare X=X+1;
      #end
    translate <3,0,0>
    scale <14/15/1.5,1,34/20/3>
    rotate <0,0,-35>
    scale <0.5,0.5,0.5>
    }
  }
   
declare Rad=object {
union {
#declare A=0;
#while (A<32)
  union {
    polygon { 4 <0,0,-2>,<0,0,2>,<0,1,2>,<0,1,-2> texture { Rad_nass } }
    polygon { 4 <0,1,2>,<0,1,-2>,<-0.2,1,-2>,<-0.2,1,2> texture { Rad_nass } }
    polygon { 4 <-0.2,1,-2>,<-0.2,1,2>,<-0.8,0,2>,<-0.8,0,-2> texture { Rad_nass } }
    polygon { 4 <0,0,-2>,<0,1,-2>,<-0.2,1,-2>,<-0.8,0,-2> texture { Rad_trocken } }
    polygon { 4 <0,0,2>,<0,1,2>,<-0.2,1,2>,<-0.8,0,2> texture { Rad_trocken } }
    translate <0,4,0>
    rotate <0,0,360/32*A>
    }
  #declare A=A+1;
  #end
difference {
  cylinder { <0,0,-2>,<0,0,2>,4.1 }
  cylinder { <0,0,-2.1>,<0,0,2.1>,3.7 }
  texture { Rad_trocken }
  }
#declare A=0;
#while (A<4)
  box {
    <-0.25,-4,-2><0.25,4,2>
    rotate <0,0,45*A>
    texture { Rad_trocken }
    }
  #declare A=A+1;
  #end
}
}

#declare Pfosten4=object {

  union {
    #declare Xdim=1;
    #declare Ydim=4;
    #declare Size=1;
    #declare Radius=0.3;
    #declare A=0;
    #declare Start=0;
    #while (A<2)
      union {
        #include "bricks.inc"
        translate <-0.5,-9-4*2/3,-1.5>
        rotate <0,90*A,0>
        }
      #declare A=A+1;
      #end
    texture { Brick }
    }
  }

#declare Pfosten2=object {

  union {
    #declare Xdim=1;
    #declare Ydim=2;
    #declare Size=1;
    #declare Radius=0.3;
    #declare A=0;
    #declare Start=0;
    #while (A<2)
      union {
        #include "bricks.inc"
        translate <-0.5,-9-2*2/3,-1.5>
        rotate <0,90*A,0>
        }
      #declare A=A+1;
      #end
    texture { Brick }
    }
  }

#declare Pfosten6=object {

  union {
    #declare Xdim=1;
    #declare Ydim=6;
    #declare Size=1;
    #declare Radius=0.3;
    #declare A=0;
    #declare Start=0;
    #while (A<2)
      union {
        #include "bricks.inc"
        translate <-0.5,-9-6*2/3,-1.5>
        rotate <0,90*A,0>
        }
      #declare A=A+1;
      #end
    texture { Brick }
    }
  }

#declare Steher = object {
  union {
    box {
      <-0.5,-2.375,-0.5><0.5,-2.5,0.5>
      texture { Stein }
      }
    box {
      <-0.5,-5.375,-0.5><0.5,-5.25,0.5>
      texture { Stein }
      }
    intersection {
      box {
        <-0.375,-2.5,-0.375><0.375,-2.875,0.375>
        }
      sphere {
        <0,-2.5,0>,0.375*1.414
        }
      texture { Stein }
      }
    union {
      torus {
        0.3125+0.125,0.0625
        translate <0,-2.8125-0.125,0>
        }
      cylinder {
        <0,-2.875,0><0,-3,0>,0.3125+0.125
        }
      texture { Stein }
      }
    sphere {
      <0,0,0>,0.3125
      scale <1,5,1>
      translate <0,-4.125,0>
      clipped_by {
        plane {
          y,-3
          }
        plane {
          -y,5.25
          }
        }
      texture { Stein }
      }
    union {
      torus {
        0.3125+0.125,0.0625
        translate <0,-2.8125-0.125,0>
        }
      cylinder {
        <0,-2.875,0><0,-3,0>,0.3125+0.125
        }
      texture { Stein }
      translate <0,-2.25,0>
      }
    translate <0,2.375,0>
    scale 3
    }
  }

#declare Saeule6=object {
  union {
    object { Steher }
    object { Pfosten6 }
    }
  }

#declare Saeule4=object {
  union {
    object { Steher }
    object { Pfosten4 }
    }
  }

#declare Saeule2=object {
  union {
    object { Steher }
    object { Pfosten2 }
    }
  }

#declare Saeule0=object {
  object { Steher }
  }

#declare Xdim=6;
#declare Ydim=6;
#declare Size=1;
#declare Radius=0.3;

#declare Aufbau=object {

  union {
    #declare A=0;
    #declare Start=0;
    #while (A<2)
      difference {
        union {
          #include "bricks.inc"
          translate <-5.5,-2/3,-6.5>
          }
        cylinder {
          <0,-3,-5.4><0,-3,-6.6>,6
          }
        rotate <0,90*A,0>
        }
      #declare A=A+1;
      #end
    texture { Brick }
    }
  }

#declare Xdim=6;
#declare Ydim=6;
#declare Size=1;
#declare Radius=0.3;

#declare Aufbau1=object {

  union {
    #declare A=0;
    #declare Start=0;
    #while (A<2)
      difference {
        union {
          #include "bricks.inc"
          translate <-5.5,-2/3,-6.5>
          }
        cylinder {
          <0,-3,-5.4><0,-3,-6.6>,6
          }
        rotate <0,90*A,0>
        }
      #declare A=A+1;
      #declare Ydim=5;
      #end
    texture { Brick }
    }
  }

#declare Radius=0.3
#declare Bogen = object {
  union {
    union {
      #include "Bogen.inc"
      texture { Brick }
      }
    difference {
      cylinder {
        <0,0,0.2><0,0,1.8>,5.8
        }
      cylinder {
        <0,0,0><0,0,2>,4.1
        }
      box {
        <-6.1,0,-0.1><6.1,-6.1,2.1>
        }
      texture { Moertel }
      }
    translate <0,-3,-6>
    }
  }


#declare Turm6=object {

union {


  #declare A=0;
  #declare Start=0;
  #while (A<2)
    object { Bogen
      rotate <0,90*A,0>
      }
    #declare A=A+1;
    #end

  object {
    Aufbau
    translate <0,-1/3,0>
    }

  object {
    Saeule6
    translate <-5,-3,-5>
    }
  object {
    Saeule6
    translate <5,-3,-5>
    }
  object {
    Saeule6
    translate <-5,-3,5>
    }
  object {
    Saeule6
    translate <5,-3,5>
    }

  }
 rotate <0,-90,0>
 translate <6.5,16+2/3,6.5>
}

#declare Turm4=object {

union {


  #declare A=0;
  #declare Start=0;
  #while (A<2)
    object { Bogen
      rotate <0,90*A,0>
      }
    #declare A=A+1;
    #end

  object {
    Aufbau
    translate <0,-1/3,0>
    }

  object {
    Saeule4
    translate <-5,-3,-5>
    }
  object {
    Saeule4
    translate <5,-3,-5>
    }
  object {
    Saeule4
    translate <-5,-3,5>
    }
  object {
    Saeule4
    translate <5,-3,5>
    }

  }
 rotate <0,-90,0>
 translate <6.5,16+2/3,6.5>
}

#declare Turm2=object {

union {


  #declare A=0;
  #declare Start=0;
  #while (A<2)
    object { Bogen
      rotate <0,90*A,0>
      }
    #declare A=A+1;
    #end

  object {
    Aufbau1
    translate <0,-1/3,0>
    }

  object {
    Saeule2
    translate <-5,-3,-5>
    }
  object {
    Saeule2
    translate <5,-3,-5>
    }
  object {
    Saeule2
    translate <-5,-3,5>
    }
  object {
    Saeule2
    translate <5,-3,5>
    }

  }
 rotate <0,-90,0>
 translate <6.5,16+2/3,6.5>
}

#declare Turm0=object {

union {


  #declare A=0;
  #declare Start=0;
  #while (A<2)
    object { Bogen
      rotate <0,90*A,0>
      }
    #declare A=A+1;
    #end

  object {
    Aufbau
    translate <0,-1/3,0>
    }

  object {
    Saeule0
    translate <-5,-3,-5>
    }
  object {
    Saeule0
    translate <5,-3,-5>
    }
  object {
    Saeule0
    translate <-5,-3,5>
    }
  object {
    Saeule0
    translate <5,-3,5>
    }

  }
 rotate <0,-90,0>
 translate <6.5,16+2/3,6.5>
}

#declare Simple=object {
  union {
    box {
      <0,0,0><3,19,3>
      texture { Brick }
      }
    box {
      <10,0,10><13,19,13>
      texture { Brick }
      }
    box {
      <0,0,10><3,19,13>
      texture { Brick }
      }
    box {
      <10,0,0><13,19,3>
      texture { Brick }
      }
    }
  }

#declare Bruecke2=object {

union {
union {

#declare Xdim=14;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <12,1*(19.5+2/3),-13>
  texture { Brick }
  }
#declare Xdim=14;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <12,1*(19.5+2/3)+2/3,-13>
  texture { Brick }
  }
#declare Xdim=14;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <12,1*(19.5+2/3)+2*2/3,-13>
  texture { Brick }
  }
#declare Xdim=9;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <12,1*(19.5+2/3)+3*2/3,-13>
  texture { Brick }
  }
#declare Xdim=4;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <12,1*(19.5+2/3)+4*2/3,-13>
  texture { Brick }
  }


#declare Xdim=15;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+2*2/3,-3>
  texture { Brick }
  }
#declare Xdim=12;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+3*2/3,-3>
  texture { Brick }
  }
#declare Xdim=7;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+4*2/3,-3>
  texture { Brick }
  }
rotate <0,-90,0>

}
polygon { 4
  <3,1*(19.5+2/3)+4*2/3,3>,<10,1*(19.5+2/3)+4*2/3,3>,<10,1*(19.5+2/3)+2*2/3,60>,<3,1*(19.5+2/3)+2*2/3,60>
  texture { Water }
  }
polygon { 4
  <3,1*(19.5+2/3)+4*2/3,3>,<10,1*(19.5+2/3)+4*2/3,3>,<10,1*(19.5+2/3)+2*2/3,60>,<3,1*(19.5+2/3)+2*2/3,60>
  texture { Stein }
  translate <0,-2/3,0>
  }
}
}

#declare Bruecke1=object {
union {
union {
#declare Xdim=9;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <10,2*(19.5+2/3),0>
  texture { Brick }
  }

#declare Xdim=7;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <20,2*(19.5+2/3)+2/3,0>
  texture { Brick }
  }

#declare Xdim=2;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <38,2*(19.5+2/3)+2*2/3,0>
  texture { Brick }
  }

#declare Xdim=14;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,2*(19.5+2/3),10>
  texture { Brick }
  }

#declare Xdim=9;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <20,2*(19.5+2/3)+2/3,10>
  texture { Brick }
  }

#declare Xdim=5;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <38,2*(19.5+2/3)+2*2/3,10>
  texture { Brick }
  }
}
polygon { 4
  <55,2*(19.5+2/3)+2*2/3,3>,<55,2*(19.5+2/3)+2*2/3,10>,<10,2*(19.5+2/3)+0*2/3,10>,<10,2*(19.5+2/3)+0*2/3,3>
  texture { Water }
  }
polygon { 4
  <55,2*(19.5+2/3)+2*2/3,3>,<55,2*(19.5+2/3)+2*2/3,10>,<10,2*(19.5+2/3)+0*2/3,10>,<10,2*(19.5+2/3)+0*2/3,3>
  texture { Stein }
  translate <0,-2/3,0>
  }
}
}

#declare Bruecke3=object {
union {
union {

#declare Xdim=11;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+0*2/3,0>
  texture { Brick }
  }
#declare Xdim=11;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+1*2/3,0>
  texture { Brick }
  }
#declare Xdim=11;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+2*2/3,0>
  texture { Brick }
  }
#declare Xdim=11;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+3*2/3,0>
  texture { Brick }
  }

#declare Xdim=11;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,1*(19.5+2/3)+4*2/3,0>
  texture { Brick }
  }

#declare Xdim=7;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <20,1*(19.5+2/3)+5*2/3,0>
  texture { Brick }
  }

#declare Xdim=2;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <38,1*(19.5+2/3)+6*2/3,0>
  texture { Brick }
  }


#declare Xdim=12;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <10,1*(19.5+2/3)+4*2/3,10>
  texture { Brick }
  }

#declare Xdim=9;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <20,1*(19.5+2/3)+5*2/3,10>
  texture { Brick }
  }

#declare Xdim=5;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <38,1*(19.5+2/3)+6*2/3,10>
  texture { Brick }
  }
}
polygon { 4
  <55,1*(19.5+2/3)+6*2/3,3>,<55,1*(19.5+2/3)+6*2/3,10>,<10,1*(19.5+2/3)+4*2/3,10>,<10,1*(19.5+2/3)+4*2/3,3>
  texture { Water }
  }
polygon { 4
  <55,1*(19.5+2/3)+6*2/3,3>,<55,1*(19.5+2/3)+6*2/3,10>,<10,1*(19.5+2/3)+4*2/3,10>,<10,1*(19.5+2/3)+4*2/3,3>
  texture { Stein }
  translate <0,-2/3,0>
  }
}
}



#declare Bruecke4=object {
union {
union {
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)-4*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)-3*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)-2*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)-1*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+0*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+1*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+2*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+3*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+4*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+5*2/3,-13>
  texture { Brick }
  }
#declare Xdim=17;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+6*2/3,-13>
  texture { Brick }
  }
#declare Xdim=12;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+7*2/3,-13>
  texture { Brick }
  }
#declare Xdim=7;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+8*2/3,-13>
  texture { Brick }
  }



#declare Xdim=15;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+6*2/3,-3>
  texture { Brick }
  }
#declare Xdim=12;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+7*2/3,-3>
  texture { Brick }
  }
#declare Xdim=7;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,0*(19.5+2/3)+8*2/3,-3>
  texture { Brick }
  }
rotate <0,-90,0>


}
polygon { 4
  <3,8*2/3,0>,<10,8*2/3,0>,<10,6*2/3,60>,<3,6*2/3,60>
  texture { Water }
  }
polygon { 4
  <0,8*2/3,-13>,<13,8*2/3,-13>,<13,8*2/3,0>,<0,8*2/3,0>
  texture { Water }
  }   
polygon { 4
  <0,8*2/3,-13>,<13,8*2/3,-13>,<13,8*2/3,0>,<0,8*2/3,0>
  texture { Stein }
  translate <0,-2,0>
  }
polygon { 4
  <3,8*2/3,0>,<10,8*2/3,0>,<10,6*2/3,60>,<3,6*2/3,60>
  texture { Stein }
  translate <0,-2/3,0>
  }
}
}


//-----------------------------





object { Turm6
  translate <0,(19.5+2/3)*2,0>
  }



object { Turm2
  translate <0,(19.5+2/3)*1,0>
  }

union {


box {
  <0-1,(19.5+2/3)*3,0-1><13+1,(19.5+2/3)*3-0.5,13+1>
  texture { Stein2 }
  }


object { Bruecke1 }
object { Bruecke3 }

box {
  <13,(19.5+2/3)*2,0-1><58+1,(19.5+2/3)*2-0.5,13+1>
  texture { Stein2 }
  }

box {
  <0-1,(19.5+2/3)*1,0-1><55+1,(19.5+2/3)*1-0.5,13+1>
  texture { Stein2 }
  }
box {
  <0-1,(19.5+2/3)*1,0-1><13+1,(19.5+2/3)*1-0.5,70+1>
  texture { Stein2 }
  }



clipped_by {
  
  plane {
    x,0
    rotate <0,-38.29016319224,0>
    translate <0,0,43.233+Clipping_offset>
    }
  }

}



object { Turm4
  translate <0,(19.5+2/3)*1,57>
  }
object { Turm0
  translate <0,(19.5+2/3)*0,57>
  }

union {

box {
  <0-1,(19.5+2/3)*2,57-1><13+1,(19.5+2/3)*2-0.5,70+1>
  texture { Stein2 }
  }

object { Bruecke1
  translate <-45,-(19.5+2/3),57>
  }
object { Bruecke3
  translate <-45,-(19.5+2/3),57>
  }


box {
  <-45-1,(19.5+2/3)*1,57-1><13+1,(19.5+2/3)*1-0.5,70+1>
  texture { Stein2 }
  }
box {
  <0-1,(19.5+2/3)*1,0-1><13+1,(19.5+2/3)*1-0.5,70+1>
  texture { Stein2 }
  }

box {
  <-45-1,(19.5+2/3)*0,57-1><10+1,(19.5+2/3)*0-0.5,70+1>
  texture { Stein2 }
  }



clipped_by {
  plane {
    -x,0
    rotate <0,-38.29016319224,0>
    translate <0,0,43.233+Clipping_offset>
    }
  }

}



object { Bruecke2 }


object { Bruecke4 }



#declare Xdim=4;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <-3,2*(19.5+2/3),-3>
  rotate <0,-90,0>
  texture { Brick }
  }

#declare Xdim=3;
#declare Size=1;
#declare Radius=0.2;
#declare Start=1;
#declare End=1;
union {
  #include "bricksl.inc"
  translate <-3,2*(19.5+2/3)-1*2/3,-3>
  rotate <0,-90,0>
  texture { Brick }
  }

#declare Xdim=1;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <-3,2*(19.5+2/3),-13>
  rotate <0,-90,0>
  texture { Brick }
  }
union {
  #include "bricksl.inc"
  translate <-3,2*(19.5+2/3)-1*2/3,-13>
  rotate <0,-90,0>
  texture { Brick }
  }

#declare Xdim=3;
#declare Size=1;
#declare Radius=0.2;
#declare Start=0;
#declare End=0;
union {
  #include "bricksl.inc"
  translate <0,2*(19.5+2/3)-2*2/3,-3>
  scale <3.25/3,1,1>
  texture { Brick }
  }

polygon { 4
  <3,2*(19.5+2/3)-1/3,-3>,<10,2*(19.5+2/3)-1/3,-3>,<10,2*(19.5+2/3)-0,10>,<3,2*(19.5+2/3)-0,10>
  texture { Water }
  }
polygon { 4
  <3,2*(19.5+2/3)-2/3,-3>,<10,2*(19.5+2/3)-2/3,-3>,<10,2*(19.5+2/3)-1/3,10>,<3,2*(19.5+2/3)-1/3,10>
  texture { Stein }
  }
polygon { 4
  <3,2*(19.5+2/3)+0/3,10>,<3,2*(19.5+2/3)-1/3,10>,<10,2*(19.5+2/3)-1/3,10>,<10,2*(19.5+2/3)+0/3,10>
  texture { Stein }
  }
polygon { 4
  <3,2*(19.5+2/3),-3>,<3,2*(19.5+2/3)-2/3,-3>,<3,2*(19.5+2/3)-2/3,10>,<3,2*(19.5+2/3),10>
  texture { Stein }
  }




difference {
  cylinder {
    <3,5,0>,<10,5,0>,2*(19.5+2/3)-1/3-5
    }
  cylinder {
    <2.9,5,0>,<10.1,5,0>,2*(19.5+2/3)-2/3-5
    }
  plane {
    y,5
    }
  plane {
    -z,-3
    } 
  texture { W3 }
  interior {
    ior 1.3
    caustics 0.1
    }
  hollow
  scale <1,1,1/7>
  translate <0,0,-3>
  }
    




difference {
  cylinder {
    <3,5,0>,<10,5,0>,2*(19.5+2/3)-1/3-5
    scale <1,1,1.3>
    }
  cylinder {
    <2.9,5,0>,<10.1,5,0>,2*(19.5+2/3)-2/3-5
    scale <1,1,0.7>
    }     
  plane {
    y,5
    }
  plane {
    -z,-3
    }        
  texture { W2 }
  interior {
    //fade_distance 10
    //fade_power 1
		media {
			intervals 50
			emission 0.4
			absorption 0.4
			density {
				marble
				turbulence 2
				color_map {
				  [0.0 color rgb <0,0,0>]
				  [0.7 color rgb <0,0,0>]
				  [1.0 color rgb <2,2,2>]
				  }
				}
				scale <3,20,10>
				rotate <-20,0,0>				
  		}
    }		    
  hollow
  scale <1,1,1/7>
  translate <0,0,-3>
  }




#declare h=1.414213562373;



union {
  box {
    <-1,-1,-1><1,1,1>
    rotate <45,0,0>
    }
  box {
    <-1,-1,-1><1,1,1>
    rotate <0,45,0>
    }
  box {
    <-1,-1,-1><1,1,1>
    rotate <0,0,45>
    }
  texture { Stein }
  scale 5
  rotate <0,45,0>
  translate <6.5,3*(19.5+2/3)+5*h,6.5>
  }

#declare Diamond=object {
  union {
    union {
      polygon { 3 <-1,h,-1>,<1,0,-1>,<-1,-h,-1> }
      polygon { 3 <-1,h,-1>,<-1,0,1>,<-1,-h,-1> }
      polygon { 3 <1,h,1>,<1,0,-1>,<1,-h,1> }
      polygon { 3 <1,h,1>,<-1,0,1>,<1,-h,1> }
      polygon { 3 <-1,h,-1>,<1,0,-1>,<1,h,1> }
      polygon { 3 <-1,h,-1>,<-1,0,1>,<1,h,1> }
      polygon { 3 <-1,-h,-1>,<1,0,-1>,<1,-h,1> }
      polygon { 3 <-1,-h,-1>,<-1,0,1>,<1,-h,1> }
      }
    union {
      polygon { 3 <-1,h,-1>,<1,0,-1>,<-1,-h,-1> }
      polygon { 3 <-1,h,-1>,<-1,0,1>,<-1,-h,-1> }
      polygon { 3 <1,h,1>,<1,0,-1>,<1,-h,1> }
      polygon { 3 <1,h,1>,<-1,0,1>,<1,-h,1> }
      polygon { 3 <-1,h,-1>,<1,0,-1>,<1,h,1> }
      polygon { 3 <-1,h,-1>,<-1,0,1>,<1,h,1> }
      polygon { 3 <-1,-h,-1>,<1,0,-1>,<1,-h,1> }
      polygon { 3 <-1,-h,-1>,<-1,0,1>,<1,-h,1> }
      rotate <0,90,0>
      }
    }
  }



union {
  object { Diamond
    rotate <0,45,0>
    }
  object { Diamond
    rotate <0,45,0>
    rotate <90,0,0>
    }
  texture { Stein }
  scale 5
  rotate <0,45,0>
  translate <6.5,2*(19.5+2/3)+5*h,63.5>
  }

object {
  Rad
  scale <6/4,1.6,1.6>
  rotate <0,-90,0>
  translate <6.5,12,1.5>
  }

cylinder {
  <13.4,12,1.5><-2,12,1.5>,1/3
  texture { Metall }
  }

cylinder {
  <13.2,12,1.5><-2,12,1.5>,2/3
  texture { Metall }
  }




box {
  <10,9*2/3,0><13,19.5,3>
  texture { Stein }
  }

box {
  <10,9*2/3,10><13,19.5,13>
  texture { Stein }
  }



//----------- Haus ----------------

difference {
  box { <-19,-8,-15>,<0,30,18> texture { Stein }}
  box { <-6,6.5,-15.1>,<-2,14,-10> }
  box { <-16,10,-15.1>,<-12,14,-10> }
  difference {
    cylinder { <-9.5,20,-15.1>,<-9.5,20,-10>,2.5 }
    plane { y,21 }
    translate <0,4,0>
    texture { Stein }
    }
  box { <0.1,20,-13>,<-1.1,18,-11> texture { Stein_hell } }
  clipped_by {
    plane { y,0
      rotate <0,0,-35>
      translate <0,23+1/3>
      }
    plane { y,0
      rotate <0,0,35>
      translate <-19,23+1/3>
      }
    }
  no_shadow
  }

box { <-6,0,-14>,<-13,27,-13> }
box { <-1,21,-14.9>,<-1.5,17,-10> }
box { <-17,14.0,-15.1>,<-11,15.0,-14.9> texture { Stein_hell } }
box { <-7,14.0,-15.1>,<-1,15.0,-14.9> texture { Stein_hell } }

superellipsoid {
  <0.25,0.25>
  scale <0.9,0.1,1.5>
  translate <0,18,-12>
  texture { Stein_hell }
  }
  
//------------ Tuere --------------

difference {
  box { <-6,6.5,-14.25>,<-2,14,-14> }
  box { <-5.9,6.6,-15.3>,<-2.1,13.9,-13> }
  texture { Holz }  
  }


difference {
  box { <-5.7,6.55,-14.0>,<-2.3,13.75,-13.8> }
  box { <-5.5,7,-14.6>,<-2.5,9.5,-13.9> }
  box { <-5.5,10,-14.6>,<-2.5,13,-13.9> }
  texture { Holz } 
  }

                                            
union {
  box { <-3.5,9.65,-14.85>,<-2.5,9.85,-14.65> }
  box { <-2.75,9.65,-14.85>,<-2.5,9.85,-14.5> }
  texture { Metall }
  }

//------------- Fenster ---------------

difference {
  box { <-16.0,10,-14.25>,<-12,14,-14> }
  box { <-15.75,10.25,-15.3>,<-12.25,13.75,-13.9> }
  texture { Holz } 
  }
  
difference {
  box { <-15.7,10.3,-14.5>,<-14.02,13.7,-14> }
  box { <-15.5,10.5,-14.6>,<-14.02-0.2,11.9,-13.9> }
  box { <-15.5,12.1,-14.6>,<-14.02-0.2,13.5,-13.9> }
  texture { Holz } 
  }
difference {
  box { <-12.3,10.3,-14.5>,<-13.98,13.7,-14> }
  box { <-12.5,10.5,-14.6>,<-13.98+0.2,11.9,-13.9> }
  box { <-12.5,12.1,-14.6>,<-13.98+0.2,13.5,-13.9> }
  texture { Holz }  
  }
  
box { <-15.75,10.25,-14.2>,<-12.25,13.75,-14.3> texture { Glas } }

union {
  difference {
    box { <0,0,-0.1>,<2,4,0.25> }
    box { <0.2,0.2,-0.2>,<1.8,3.8,0.3> }
    }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,0.5,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,1.0,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,1.5,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,2.0,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,2.5,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,3.0,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,3.5,0.15> }
  texture { Holz } 
  rotate <0,-10,0>
  translate <-18,10,-15.6>
  }

union {
  difference {
    box { <0,0,-0.1>,<2,4,0.25> }
    box { <0.2,0.2,-0.2>,<1.8,3.8,0.3> }
    }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,0.5,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,1.0,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,1.5,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,2.0,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,2.5,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,3.0,0.15> }
  box { <0,0,-0.15>,<2,0.1,0.15> rotate <50,0,0> translate <0,3.5,0.15> }
  texture { Holz }  
  rotate <0,10,0>
  translate <-12,10,-15.4>
  }
         
//----------- Dach ---------------
 
object { Dach translate <-9.5,23+0*1/3+0.71*9.5,-15> no_shadow}
object { Dach matrix <-1,0,0,0,1,0,0,0,1,0,0,0> translate <-9.5,23+0*1/3+0.71*9.5,-15> no_shadow}
object { Dach2 translate <-9.5,23+0*1/3+0.71*9.5,-15> no_shadow}
object { Dach2 matrix <-1,0,0,0,1,0,0,0,1,0,0,0> translate <-9.5,23+0*1/3+0.71*9.5,-15> }

#declare Z=0;
#while (Z<20)
  difference {
    cone { <0,-0.5,-3>,1.5,<0,-0.5,9>,1 }
    cone { <0,-0.5,-3.1>,1.0,<0,-0.5,9.1>,0.5 }
    plane { y,-0.5 }
    texture { Dachziegel_tx }
    scale <1,1,1>
    translate <-19,2*(23+1/3+0.71*9.5),Z*6>
    scale <1,1,34/20/3>
    scale <0.5,0.5,0.5>
    translate <0,0,-15>
    no_shadow
    }
  #declare Z=Z+2;
  #end

//--------------- Rauchfang ----------------

box { <0,0,0>,<3,1.5,3>  //Schatten
  texture { Stein }
  translate <-7.5,26,-13>
  }

union {
  box { <0,0,0>,<3,4,3> texture { Stein } }
  polygon { 3, <0,4,0>,<3,4,0>,<1.5,5.5,1.5> texture { Stein } }
  polygon { 3, <0,4,0>,<0,4,3>,<1.5,5.5,1.5> texture { Stein } }
  polygon { 3, <3,4,3>,<3,4,0>,<1.5,5.5,1.5> texture { Stein } }
  polygon { 3, <3,4,3>,<0,4,3>,<1.5,5.5,1.5> texture { Stein } }
  difference {
    box { <0.5,4,0.5>,<2.5,11,2.5>
      clipped_by {
        plane { y,7 rotate <0,0,-45> translate <1.5,0,0>}
        plane { y,7 rotate <0,0,45> translate <1.5,0,0>}
        }
      texture { Stein } 
      }
    cylinder { <1.5,8.5,0>,<1.5,8.5,1>,0.3 }
    box { <1.2,8.5,0>,<1.8,7,1> }
      }
  translate <-7.5,26,-13>
  no_shadow
  }
  
union {
  intersection {
   union {
    difference {
      cylinder { <4.5,13,0>,<4.5,13,3>,3 }      
      cylinder { <4.5,13,-0.1>,<4.5,13,3.1>,2.75 }
      no_shadow
      translate <-0.3,0,0>
      }
    difference {
      cylinder { <-1.5,13,0>,<-1.5,13,3>,3 }
      cylinder { <-1.5,13,-0.1>,<-1.5,13,3.1>,2.75 }
      no_shadow
      translate <0.3,0,0>
      }  
    difference {
      cylinder { <4.5,13,0>,<4.5,13,1>,3 }
      cylinder { <4.5,13,-0.1>,<4.5,13,1.1>,2.65 }
      no_shadow
      translate <-0.4,0,0>
      }
    difference {
      cylinder { <-1.5,13,0>,<-1.5,13,1>,3 }
      cylinder { <-1.5,13,-0.1>,<-1.5,13,1.1>,2.65 }
      translate <0.4,0,0>
      }
     }
    box { <3.2,12,0>,<-0.2,10,3> }
    }
  texture { Dachziegel_tx }
  translate <-7.5,24.5,-13>
  }  

//--------------- Becken -----------------
 
union {
  box { <13,-8,0>,<16,6.5,3> }
  box { <16,-8,3>,<19,6.5,-15> }
  box { <0,-8,-15>,<19,6.5,-12> }
  box { <-23,6,0>,<-19,6.5,-15> }
  box { <-23,6,-15>,<3,6.5,-19> }
  texture { Stein }
  }

union {
  box { <-0.75,0,-0.75>,<0.75,-0.5,0.75> translate <2,6,-18> }
  box { <-0.75,0,-0.75>,<0.75,-0.5,0.75> translate <-4,6,-18> }
  box { <-0.75,0,-0.75>,<0.75,-0.5,0.75> translate <-10,6,-18> }
  box { <-0.75,0,-0.75>,<0.75,-0.5,0.75> translate <-16,6,-18> }
  box { <-0.75,0,-0.75>,<0.75,-0.5,0.75> translate <-22,6,-18> }
  texture { Stein }
  }
  
union {
  box { <-0.5,4/1.414,4/1.414>,<0.5,-4/1.414,4/1.414-0.5> rotate <-40,0,0> translate <2,5-4/1.414,-15.5-4/1.414> }
  box { <-0.5,4/1.414,4/1.414>,<0.5,-4/1.414,4/1.414-0.5> rotate <-40,0,0> translate <-4,5-4/1.414,-15.5-4/1.414> }
  box { <-0.5,4/1.414,4/1.414>,<0.5,-4/1.414,4/1.414-0.5> rotate <-40,0,0> translate <-10,5-4/1.414,-15.5-4/1.414> }
  box { <-0.5,4/1.414,4/1.414>,<0.5,-4/1.414,4/1.414-0.5> rotate <-40,0,0> translate <-16,5-4/1.414,-15.5-4/1.414> }
  texture { Stein }
  }
  
//------------- Zaun --------------

union {
  cylinder { <14,7.0,2>,<14,9,2>,0.075 }
  cylinder { <16,7.0,2>,<16,9,2>,0.075 }
  cylinder { <18,6.5,2>,<18,9.5,2>,0.1 }
  sphere { <18,9.5,2>,0.2 }
  cylinder { <18,7.0,0>,<18,9,0>,0.075 }
  cylinder { <18,6.5,-2>,<18,9,-2>,0.1 }
  cylinder { <18,7.0,-4>,<18,9,-4>,0.075 }
  cylinder { <18,6.5,-6>,<18,9,-6>,0.1 }
  cylinder { <18,7.0,-8>,<18,9,-8>,0.075 }
  cylinder { <18,6.5,-10>,<18,9,-10>,0.1 }
  cylinder { <18,7.0,-12>,<18,9,-12>,0.075 }
  cylinder { <18,6.5,-14>,<18,9.5,-14>,0.1 }
  sphere { <18,9.5,-14>,0.2 }
  cylinder { <16,7,-14>,<16,9,-14>,0.075 }
  cylinder { <14,6.5,-14>,<14,9,-14>,0.1 }
  cylinder { <12,7.0,-14>,<12,9,-14>,0.075 }
  cylinder { <10,6.5,-14>,<10,9,-14>,0.1 }
  cylinder { <8,7.0,-14>,<8,9,-14>,0.075 }
  cylinder { <6,6.5,-14>,<6,9,-14>,0.1 }
  cylinder { <4,7.0,-14>,<4,9,-14>,0.075 }
  cylinder { <2,6.5,-14>,<2,9.5,-14>,0.1 }
  sphere { <2,9.5,-14>,0.2 }
  cylinder { <2,7,-16>,<2,9,-16>,0.075 }
  cylinder { <2,6.5,-18>,<2,9.5,-18>,0.1 }
  sphere { <2,9.5,-18>,0.2 }
  cylinder { <0,7.0,-18>,<0,9,-18>,0.075 }
  cylinder { <-2,7-0,-18>,<-2,9,-18>,0.075 }
  cylinder { <-4,6.5,-18>,<-4,9,-18>,0.1 }
  cylinder { <-6,7.0,-18>,<-6,9,-18>,0.075 }
  cylinder { <-8,7.0,-18>,<-8,9,-18>,0.075 }
  cylinder { <-10,6.5,-18>,<-10,10,-18>,0.1 }
  torus {
    3,0.1
    rotate <0,0,90>
    clipped_by {
      plane { -y,0 }
      plane { z,0 }
      }
    translate <-10,10,-15>
    }
  cylinder { <-12,7.0,-18>,<-12,9,-18>,0.075 }
  cylinder { <-14,7.0,-18>,<-14,9,-18>,0.075 }
  cylinder { <-16,6.5,-18>,<-16,9,-18>,0.1 }
  cylinder { <-18,7.0,-18>,<-18,9,-18>,0.075 }
  cylinder { <-20,7.0,-18>,<-20,9,-18>,0.075 }
  cylinder { <-22,6.5,-18>,<-22,9.5,-18>,0.1 }
  sphere { <-22,9.5,-18>,0.2 }
  cylinder { <-22,7.0,-16>,<-22,9,-16>,0.075 }
  cylinder { <-22,7.0,-14>,<-22,9,-14>,0.075 }
  cylinder { <-22,6.5,-12>,<-22,9,-12>,0.1 }
  cylinder { <-22,7.0,-10>,<-22,9,-10>,0.075 }
  cylinder { <-22,7.0,-8>,<-22,9,-8>,0.075 }

  cylinder { <13,7,2>,<18,7,2>,0.075 }
  cylinder { <13,8+1/3,2>,<18,8+1/3,2>,0.075 }
  cylinder { <13,9,2>,<18,9,2>,0.075 }

  cylinder { <18,7,-14>,<18,7,2>,0.075 }
  cylinder { <18,8+1/3,-14>,<18,8+1/3,2>,0.075 }
  cylinder { <18,9,-14>,<18,9,2>,0.075 }

  cylinder { <18,7,-14>,<2,7,-14>,0.075 }
  cylinder { <18,8+1/3,-14>,<2,8+1/3,-14>,0.075 }
  cylinder { <18,9,-14>,<2,9,-14>,0.075 }

  cylinder { <2,7,-18>,<2,7,-14>,0.075 }
  cylinder { <2,8+1/3,-18>,<2,8+1/3,-14>,0.075 }
  cylinder { <2,9,-18>,<2,9,-14>,0.075 }

  cylinder { <2,7,-18>,<-22,7,-18>,0.075 }
  cylinder { <2,8+1/3,-18>,<-22,8+1/3,-18>,0.075 }
  cylinder { <2,9,-18>,<-22,9,-18>,0.075 }

  cylinder { <-22,7,0>,<-22,7,-18>,0.075 }
  cylinder { <-22,8+1/3,0>,<-22,8+1/3,-18>,0.075 }
  cylinder { <-22,9,0>,<-22,9,-18>,0.075 }

  texture { Gold }
  translate <0,-6.5,0>
  scale <1,1.25,1>
  translate <0,6.5,0>
  }                       
  
//---------- Zubau -------------

union {
  cylinder { <17.5,-4*2/3+2.5,74.5>,<17.5,-4*2/3+2.5,40>,0.1 }
  cylinder { <17.5,-4*2/3+0.5,74.5>,<17.5,-4*2/3+0.5,40>,0.1 }
  cylinder { <0,-4*2/3+2.5,74.5>,<17.5,-4*2/3+2.5,74.5>,0.1 }
  cylinder { <0,-4*2/3+0.5,74.5>,<17.5,-4*2/3+0.5,74.5>,0.1 }
  
  cylinder { <17.5,-4*2/3+2.5,73.0>,<17.5,-4*2/3+0.5,73.0>,0.075 }
  cylinder { <17.5,-4*2/3+2.5,71.5>,<17.5,-4*2/3+0.5,71.5>,0.075 }
  cylinder { <17.5,-4*2/3+2.5,70.0>,<17.5,-4*2/3+0.5,70.0>,0.075 }
  cylinder { <17.5,-4*2/3+3,68.5>,<17.5,-4*2/3,68.5>,0.1 }
  sphere { <17.5,-4*2/3+3,68.5>,0.2 }
  cylinder { <17.5,-4*2/3+2.5,67.0>,<17.5,-4*2/3+0.5,67.0>,0.075 }
  cylinder { <17.5,-4*2/3+2.5,65.5>,<17.5,-4*2/3+0.5,65.5>,0.075 }
  cylinder { <17.5,-4*2/3+2.5,64.0>,<17.5,-4*2/3+0.5,64.0>,0.075 }
  cylinder { <17.5,-4*2/3+3,62.5>,<17.5,-4*2/3,62.5>,0.1 }
  sphere { <17.5,-4*2/3+3,62.5>,0.2 }
  
  cylinder { <16.0,-4*2/3+2.5,74.5>,<16.0,-4*2/3+0.5,74.5>,0.075 }
  cylinder { <14.5,-4*2/3+2.5,74.5>,<14.5,-4*2/3+0.5,74.5>,0.075 }
  cylinder { <13.0,-4*2/3+2.5,74.5>,<13.0,-4*2/3+0.5,74.5>,0.075 }
  cylinder { <11.5,-4*2/3+3,74.5>,<11.5,-4*2/3,74.5>,0.1 }
  sphere { <11.5,-4*2/3+3,74.5>,0.2 }
  cylinder { <10.0,-4*2/3+2.5,74.5>,<10.0,-4*2/3+0.5,74.5>,0.075 }
  cylinder { <8.5,-4*2/3+2.5,74.5>,<8.5,-4*2/3+0.5,74.5>,0.075 }
  cylinder { <7.0,-4*2/3+2.5,74.5>,<7.0,-4*2/3+0.5,74.5>,0.075 }
  
  texture { Gold }
  }

box { <12,-4*2/3,0>,<30,-5,30> texture { Stein } }
box { <0,-4*2/3,30>,<18,-20,75> texture { Stein } }

union {
  difference {
    box { <13,7*2/3,17.5>,<31,-5,32.5> }
    box { <12,1,17>,<18,-6,33> }
    cylinder { <15.5,1,17>,<15.5,1,32.5>,2.5 }
    box { <23,0.5,17>,<25,3,19> }
    box { <22.5,3,17>,<25.5,3.5,19> }
    }
   
  box { <13,8.5*2/3,17.5>,<31,3.5,18> }
  box { <13,8.5*2/3,32>,<31,3.5,32.5> }
  box { <13,7*2/3,16.5>,<31,6.7*2/3,33.5> }
  box { <17,-4,74>,<18,-4*2/3+3,75> }
  
  box { <17,-4,74>,<18,-4*2/3+3,75> }
  sphere { <17.5,-4*2/3+3.15,74.5>,0.5 }
  
  texture { Stein }
  }

box { <13,7.4*2/3,28>,<14.33,6.5*2/3,32> texture { Brick } }
    
union {

box { <22.5,3,17.5>,<25.5,3.5,19> texture { Stein_dunkel } }

difference {
  box { <23,0.5,18.0>,<25,3.5,18.5> }
  box { <23.25,0.75,17>,<24.75,3.25,18.6> }
  texture { Rad_trocken }
  }
  
box { <23,0.5,18.2>,<25,3.5,18.3> texture { Glas } }

box { <23,0.5,18.4>,<25,3.5,18.5> }


union {
  difference {
    box { <16,7*2/3,17.5>,<31,-5,32.5> }
    box { <12,1,17>,<18,-6,33> }
    cylinder { <15.5,1,17>,<15.5,1,32.5>,2.5 }
    box { <23,0.5,17>,<25,3,19> }
    box { <22.5,3,17>,<25.5,3.5,19> }
    }
  union {
    box { <22.5,-4*2/3,18>,<23,-4*2/3+3,15> }
    box { <23,-4*2/3+3,15.5>,<26,-4*2/3,15> }
    box { <0,-4*2/3,15.5>,<5,-4*2/3+3,15> matrix <1,-0.5,0,0,1,0,0,0,1,26,0,0> }
    translate <-1,-1,0>
    }
        
  box { <31+22,2,30>,<31+40,-20,10> }
  box { <31+22,2,30>,<31+40,5,29.5> }
  
  box { <31+15,2,15>,<31+15.5,5,10> }
  box { <0,2,10>,<10,5,10.5> matrix <1,0,-0.5,0,1,0,0,0,1,31+15,0,0> }
  
  box { <15,8.5*2/3,17.5>,<31,7*2/3,18> }
  box { <15,8.5*2/3,32>,<31,3.5,32.5> }
  box { <15,7*2/3,16.5>,<31,6.7*2/3,33.5> }
  
  difference {
    box { <31,8.5,15>,<31+22,-20,35> }
    box { <34,2,13>,<38,6,18> }
    }
    
  box { <34,2,18>,<38,6,17> }
  
  difference {
    box { <30.5,9.5,14.5>,<31.5+22,8,35.5> }
    box { <31.3,10,15.3>,<30.7+22,7,34.7> }
    cylinder { <29,8,13-1>,<31+24,8,13-1>,3 }
    cylinder { <29,8,37+1>,<31+24,8,37+1>,3 }
    cylinder { <29-1,8,13>,<29-1,8,37>,3 }
    cylinder { <33+22+1,8,13>,<33+22+1,8,37>,3 }
    
    cylinder { <31+18,8.8,34>,<31+18,8.8,36>,0.4 }
    box { <31+17.6,8.8,34>,<31+18.4,8,36> }
    }
  
  superellipsoid {
    <0.25,0.25>
    scale <18/2,4.5,16/2>
    translate <31+22/2,8-2.5,15+20/2>
    }
      
  texture { Stein }
  }

union {
   
  difference {
    box { <-16,10,-14.5>,<-12,14,-14> }
    box { <-15.75,10.25,-15.3>,<-12.25,13.75,-13.9> }
    texture { Holz }  
    }
    
  difference {
    box { <-15.7,10.3,-14.5>,<-14.02,13.7,-14> }
    box { <-15.5,10.5,-14.6>,<-14.02-0.2,11.9,-13.9> }
    box { <-15.5,12.1,-14.6>,<-14.02-0.2,13.5,-13.9> }
    texture { Holz } 
    }
  difference {
    box { <-12.3,10.3,-14.5>,<-13.98,13.7,-14> }
    box { <-12.5,10.5,-14.6>,<-13.98+0.2,11.9,-13.9> }
    box { <-12.5,12.1,-14.6>,<-13.98+0.2,13.5,-13.9> }
    texture { Holz } 
    }
  
  box { <-15.75,10.25,-14.2>,<-12.25,13.75,-14.3> texture { Glas } }
  box { <-17,14,-15.01>,<-11,15,-14.9> texture { Stein_dunkel } }
  box { <-16.5,14,-15.001>,<-15.999,10,-14.9> texture { Stein_dunkel } }
  box { <-11.5,14,-15.001>,<-12.001,10,-14.9> texture { Stein_dunkel } }
  
  superellipsoid {
  <0.25,0.25>
  scale <2.25,0.1,0.9>
  translate <-14,9.9,-15>
  texture { Stein }
  }
  
  translate <16+34,-10+2,+15+15> 
  }
 
translate <45,19.5+2/3,-57>

}   