// Persistence Of Vision raytracer version 3.0 sample file.
// Simple heightfield example

#version 3.0

#include "colors.inc"
#include "spray.inc"
#include "DO_TREE3.inc"
#include"DO_PLANT.inc"
#include "balo.inc"





//textures//

#declare FBM_Clouds =
pigment {
    bozo
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                    color red 0.75 green 0.75 blue 0.75]
        [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                    color Clear]
        [0.5, 1.001 color Clear color Clear]
    }
scale <6, 1, 6>}

#declare Cherry_Wood =


      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.666, 0.312, 0.2, 0.0, 0.0> ]
            [ 0.8     rgbft <0.666, 0.312, 0.2, 0.0, 0.0> ]
            [ 0.8     rgbft <0.4, 0.133, 0.066, 0.0, 0.0> ]
            [ 1.0     rgbft <0.2, 0.065, 0.033, 0.0, 0.0> ]
         }
         turbulence 0.3
      }

#declare Parquet_Wood =
   texture  // txt_167
   {
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.54, 0.35, 0.25, 0.0, 0.0> ]
            [ 0.2     rgbft <0.54, 0.35, 0.25, 0.0, 0.0> ]
            [ 0.4     rgbft <0.57, 0.37, 0.24, 0.0, 0.0> ]
            [ 0.6     rgbft <0.56, 0.31, 0.21, 0.0, 0.0> ]
            [ 0.8     rgbft <0.56, 0.31, 0.21, 0.0, 0.0> ]
            [ 0.9     rgbft <0.57, 0.37, 0.24, 0.0, 0.0> ]
            [ 1.0     rgbft <0.54, 0.35, 0.25, 0.0, 0.0> ]
         }
         turbulence 0.25
         scale  <9.0, 9.0, 1.0>
      }
      finish
      {
         ambient 0.3
         diffuse 1.2
      }
   }
   texture  // txt_168
   {
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.4, 0.21, 0.15, 0.0, 0.0> ]
            [ 0.05    rgbft <0.4, 0.21, 0.15, 0.7, 0.0> ]
            [ 0.2     rgbft <0.4, 0.24, 0.14, 1.0, 0.0> ]
            [ 0.7     rgbft <0.4, 0.24, 0.14, 0.8, 0.0> ]
            [ 0.7     rgbft <0.3, 0.14, 0.02, 0.7, 0.0> ]
            [ 0.8     rgbft <0.3, 0.14, 0.02, 1.0, 0.0> ]
            [ 0.9     rgbft <0.3, 0.14, 0.02, 0.7, 0.0> ]
            [ 1.0     rgbft <0.25, 0.13, 0.09, 0.7, 0.0> ]
         }
         turbulence 0.3
         scale  <5.0, 10.0, 5.0>
      }
      finish
      {
         ambient 0.6
         diffuse 0.9
      }
   }
   texture  // txt_169
   {
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.4, 0.21, 0.15, 0.0, 0.0> ]
            [ 0.05    rgbft <0.4, 0.21, 0.15, 0.4, 0.0> ]
            [ 0.2     rgbft <0.4, 0.24, 0.14, 0.8, 0.0> ]
            [ 0.7     rgbft <0.4, 0.24, 0.14, 0.9, 0.0> ]
            [ 0.7     rgbft <0.3, 0.14, 0.02, 0.8, 0.0> ]
            [ 0.8     rgbft <0.3, 0.14, 0.02, 0.6, 0.0> ]
            [ 0.9     rgbft <0.3, 0.14, 0.02, 0.4, 0.0> ]
            [ 1.0     rgbft <0.25, 0.13, 0.09, 0.8, 0.0> ]
         }
         turbulence 0.2
         scale  <4.0, 20.0, 4.0>
      }
      normal
      {
         dents , 0.2
         scale  <0.1, 0.1, 0.03>
         turbulence 0.85
         frequency 0.0
      }
      finish
      {
         ambient 0.3
         diffuse 0.9
         phong 0.5
         phong_size 20.0
         crand 0.1
      }
   }

#declare Bronze_Metal1 =
   texture  // Bronze_Metal1
   {
      pigment
      {
         color rgb <0.55, 0.47, 0.14>
      }
      finish
      {
         ambient 0.2
         diffuse 0.7
         brilliance 6.0
         phong 0.75
         phong_size 80.0
         reflection 0.25
      }
   }
//lights//

light_source { <7, 8000, -900> Grey fade_distance 12000
     fade_power 1  shadowless}
light_source { <50, 100, 130> <.8,.47,.2> fade_distance 12000
     fade_power 1  }

//camera//

camera
{

//  perspective (default) | orthographic | fisheye |
//  ultra_wide_angle | omnimax | panoramic | cylinder 1
  location  <5.0, 12.0, -68.0> // position of camera <X Y Z>
   up        y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <5.0, 5.0,  0.0> // point center of view at this point <X Y Z>
}

//effects//

 #declare effect_brightness=1

   #declare source_colour = <.95, .8, .6>
   #declare effect_type = "softglow"
   #declare effect_colour =<1,.8,.7>
#declare effect_always_on_top=false
   #declare camera_location = <5, 12, -68>
#declare effect_scale =<10,1.5,.5>
   #declare camera_look_at = <5, 5, 0>
   #declare effect_location = <50,30 , 130>
   #include "Lens.inc"

//plants//
object{DO_Plant1 scale<1.2,1,1>translate<-1.3,10,-58>}
object{DO_Plant1c scale<1,1.2,1>translate<-.5,9.5,-57.5>}
object{DO_Plant5 scale<1,1.2,1>translate<-1.1,10,-57>}
object{DO_Plant5 scale<1,1,1>translate<-.95,10,-58.3>}
object{DO_Plant5 scale<3,5,3>translate<14.4,2,-53>}
object{DO_Plant5 scale<3.5,5.5,4.5>translate<17.9,2.5,-46>}
object{DO_Plant5 scale<4.5,5,3>translate<19.9,2.5,-40>}
object{DO_Plant5 scale<3,4.8,3>translate<17.8,2.5,-49>}
object{DO_Plant5 scale<4,5,4>translate<17.9,2.5,-43>}
object{DO_Plant5 scale<4,5.4,4>translate<13,2.5,-58>}
object{DO_Plant5 scale<4,6,4>translate<13.8,2.5,-56>}
object{DO_Plant5 scale<4,6,3.8>translate<17.5,2.5,-44>}
object{DO_Plant5 scale<4,5.8,3.5>translate<15.6,2.5,-50>}


box
{
  <14, -1, -68>  // one corner position <X1 Y1 Z1>
  <45,  3.1,-40>  // other corner position <X2 Y2 Z2>


texture {
  pigment {
    rgb <0.42,0.52,0.42>
  }
  normal {
    crackle 2.0
    lambda 2
  }
  finish {
    phong 0.6
    reflection 0.06
  }
}
}
//baloon//

#include "balo.in1"
#declare RotSwp001 = object {
  RotSwp001_Raw
  texture {
    body_texture
  }
  rotate -89.617157*x
}
union { // Group001
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      Brushed_Aluminum
    }
    scale <0.042639, 0.026145, 0.835058>
    rotate <0.0, -34.950958, -180.0>
    translate  <0.214424, -0.214424, -1.385511>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      Brushed_Aluminum
    }
    scale <0.042639, 0.026145, 0.835058>
    rotate <-0.0, 26.520565, -180.0>
    translate  <-0.30191, -0.575845, -1.451488>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      Brushed_Aluminum
    }
    scale <0.042639, 0.026145, 0.835058>
    rotate <-0.0, -33.173607, -180.0>
    translate  <0.20941, -0.575845, -1.402006>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      Brushed_Aluminum
    }
    scale <0.042639, 0.026145, 0.835058>
    rotate <0.0, 29.969824, -180.0>
    translate  <-0.296895, -0.214424, -1.402006>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood6
    }
    scale <0.383379, 0.467212, 0.273974>

    translate  <-0.038003, -0.35723, -1.682407>
  }
  object { RotSwp001 }
  text {   // Text001
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "irtc",
    0.04,  // Depth
    <0.0,     0.0, 0.0> // Offset
    texture {
      Flamme_Text
    }
    rotate <-90., -180, 90.>
    translate  <1.082151, .412638, -0.39586>
  }
scale<4,4,4>rotate<-90,105,0> translate <5,42,50>
}

//fog//

      sphere { 0, 5
    pigment { color Clear}
    halo {
      attenuating
      planar_mapping
      linear
      turbulence 3
      color_map {
        [ 0 color rgbt <.90, .90, .90,  1> ]
        [ 1 color rgbt <.95, .95,.95, .81> ]
      }
      samples 10
      scale .75
    }
    hollow
translate<8,14,-8>
  }

   sphere { 0, 6
    pigment { color Clear}
    halo {
      attenuating
      planar_mapping
      linear
      turbulence 3
      color_map {
        [ 0 color rgbt <.90, .90, .90,  1> ]
        [ 1 color rgbt <.95, .95,.95, .81> ]
      }
      samples 10
      scale .75
    }
    hollow
translate<3,3,-15>scale<2,2.1,2>
  }

sphere
{
  <0, 1, 0> // center of sphere <X Y Z>
10000  // radius of sphere
  // scale <1,2,1> // <= Note: Spheres can become ellipses by uneven scaling
texture {                         // The blue sky background for the clouds
    pigment { color SkyBlue }
    finish { ambient 0.8 diffuse 0 }scale<5000,5000,5000>
}
texture {                          // The upper part of the clouds
    pigment { FBM_Clouds }
    finish { ambient 1.0 diffuse 0 }scale<5000,5000,5000>
}
texture {                          // The darker underside of the clouds
    pigment { FBM_Clouds  translate -0.15*y }
    finish { ambient 0.7 diffuse 0 }scale<5000,5000,5000>
}hollow rotate<18,0,0>
}

//water plane//

plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  3.0 // distance from the origin in the direction of the surface normal
texture{
    pigment{ color rgbft <0.0, 0.3, .95,.5,.7> }
    normal {bumps .3

        frequency 10
    }
    finish {
        reflection 0.3
        refraction 1
      ior 1.33

}}}

//terrain//

height_field {
    gif "c:\pov\land\water1.ghf"


    pigment {
        image_map { gif "c:\pov\land\plu.gif" }
    rotate x*90
    }rotate<0,0,0>
    translate <-.5, 0, -.5>
    scale<100,17,100>}

height_field {                   // upper-right of image at <0.5, 0.0, 0.5>
    gif "c:\pov\land\water3.ghf"               // lower-left of image at <0.0, 0.0, 0.0>
    pigment {
        image_map { gif "c:\pov\land\ven3.gif"}
    rotate <90,90,0>                // rotate the image to the x/z plane
    }rotate<0,0,0>

    scale<39,6,38>
    translate <-12, -0.1, -54>

}

height_field {                   // upper-right of image at <0.5, 0.0, 0.5>
    gif "c:\pov\land\water2.ghf"               // lower-left of image at <0.0, 0.0, 0.0>
    pigment {
        image_map { gif "c:\pov\land\plu2.gif"}
  rotate x*90
    }rotate<0,0,0>
    translate <-.3, 0, .52>
    scale<320,58
    ,100>
}

//waterfall//

// SPRAY OPTIONS
   #declare spray_location = <7, 11.8, -11>
   #declare spray_direction = -y
   #declare spray_strength = 6
   #declare spray_angle = 0
   #declare spray_loop = true
#declare ground_plane=true
#declare ground_dist =3
 #declare ground_reflection=.2
   #declare particle_life = 1.5
   #declare particle_count = 1400
   #declare particle_size =2
   #declare particle_stretch = 2
   #declare particle_dist = 1
   #declare particle_sep = 1.5

   #declare nozzle_width = 4
   #declare nozzle_angle = 0

   #declare spray_turb = .1
   #declare spin_turb = 10

   #declare use_blob = true
   #declare spray_texture = texture  // Pacific
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.105833, 0.406233, 0.9916667, 0.0, 0.0> ]
            [ 0.12    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.12    rgbft <0.70, 0.9525, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <.850, .85, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.85    rgbft <0.7, 0.95, 1.0, .0, 0.0> ]
            [ 1.0     rgbft <.7, .7, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.2
      }
      normal{bumps , .4}
      finish
      {
         ambient 0.4
         phong 0.63
         phong_size 81.0
         reflection 0.2158
         refraction on  ior 1.33
      }
   }

// CREATE SPRAY OBJECT
   #include "Spray.inc"

// SPRAY OPTIONS
   #declare spray_location = <5.8, 12, -10.9>
   #declare spray_direction = -y
   #declare spray_strength = 6
   #declare spray_angle = 0
   #declare spray_loop = true
#declare ground_plane=true
#declare ground_dist =3
 #declare ground_reflection=.1
   #declare particle_life = 1.5
   #declare particle_count = 400
   #declare particle_size =2
   #declare particle_stretch = 2
   #declare particle_dist = 1
   #declare particle_sep = 1.8

   #declare nozzle_width = 4
   #declare nozzle_angle = 0

   #declare spray_turb = .3
   #declare spin_turb = 10

   #declare use_blob = true
   #declare spray_texture =  texture  // Pacific
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.605833, 0.706233, 0.816667, 0.0, 0.0> ]
            [ 0.12    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.12    rgbft <0.70, 0.9525, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <.850, .85, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.85    rgbft <0.7, 0.95, 1.0, .0, 0.0> ]
            [ 1.0     rgbft <.7, .7, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.4
      }
      normal{bumps , .4}
      finish
      {
         ambient 0.4
         phong 0.63
         phong_size 81.0
         reflection 0.2158
         refraction on  ior 1.33
      }
   }

   #declare spray_location = <8.2, 11.8, -11>
   #declare spray_direction = -y
   #declare spray_strength = 6
   #declare spray_angle = 0
   #declare spray_loop = true
#declare ground_plane=true
#declare ground_dist =3
 #declare ground_reflection=.2
   #declare particle_life = 1.5
   #declare particle_count = 1400
   #declare particle_size =2
   #declare particle_stretch = 2
   #declare particle_dist = 1
   #declare particle_sep = 1.5

   #declare nozzle_width = 4
   #declare nozzle_angle = 0

   #declare spray_turb = .1
   #declare spin_turb = 10

   #declare use_blob = true
   #declare spray_texture = texture  // Pacific
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.705833, 0.706233, 0.9916667, 0.0, 0.0> ]
            [ 0.12    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.12    rgbft <0.70, 0.9525, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <.850, .85, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.85    rgbft <0.7, 0.95, 1.0, .0, 0.0> ]
            [ 1.0     rgbft <.3, .7, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.4
      }
      normal{bumps , .4}
      finish
      {
         ambient 0.4
         phong 0.63
         phong_size 81.0
         reflection 0.2158
         refraction on  ior 1.33
      }
   }

// CREATE SPRAY OBJECT
   #include "Spray.inc"

// SPRAY OPTIONS
   #declare spray_location = <4.6, 11.8, -10.9>
   #declare spray_direction = -y
   #declare spray_strength = 6
   #declare spray_angle = 0
   #declare spray_loop = true
#declare ground_plane=true
#declare ground_dist =3
 #declare ground_reflection=.1
   #declare particle_life = 1.5
   #declare particle_count = 1400
   #declare particle_size =2
   #declare particle_stretch = 2
   #declare particle_dist = 1
   #declare particle_sep = 1.5

   #declare nozzle_width = 4
   #declare nozzle_angle = 0

   #declare spray_turb = .3
   #declare spin_turb = 10

   #declare use_blob = true
   #declare spray_texture = texture  // Pacific
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.605833, 0.706233, 0.9916667, 0.0, 0.0> ]
            [ 0.12    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.12    rgbft <0.70, 0.9525, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <.850, .85, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.85    rgbft <0.7, 0.95, 1.0, .0, 0.0> ]
            [ 1.0     rgbft <.7, .7, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.4
      }
      normal{bumps , .4}
      finish
      {
         ambient 0.4
         phong 0.63
         phong_size 81.0
         reflection 0.2158
         refraction on  ior 1.33
      }
   }


// CREATE SPRAY OBJECT
   #include "Spray.inc"
// SPRAY OPTIONS
   #declare spray_location = <10.6, 11.8, -11>
   #declare spray_direction = -y
   #declare spray_strength = 6
   #declare spray_angle = 0
   #declare spray_loop = true
#declare ground_plane=true
#declare ground_dist =3
 #declare ground_reflection=.1
   #declare particle_life = 1.5
   #declare particle_count = 400
   #declare particle_size =2
   #declare particle_stretch = 2
   #declare particle_dist = 1.4
   #declare particle_sep = 1.5

   #declare nozzle_width = 4
   #declare nozzle_angle = 0

   #declare spray_turb = .6
   #declare spin_turb = 10

   #declare use_blob = true
   #declare spray_texture = texture  // Pacific
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.105833, 0.406233, 0.9916667, 0.0, 0.0> ]
            [ 0.12    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.12    rgbft <0.70, 0.9525, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <.850, .85, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.85    rgbft <0.7, 0.95, 1.0, .0, 0.0> ]
            [ 1.0     rgbft <.3, .7, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.2
      }
      normal{bumps , .4}
      finish
      {
         ambient 0.4
         phong 0.63
         phong_size 81.0
         reflection 0.2158
         refraction on  ior 1.33
      }
   }


// CREATE SPRAY OBJECT
   #include "Spray.inc"
// SPRAY OPTIONS
   #declare spray_location = <9.4, 11.8, -11>
   #declare spray_direction = -y
   #declare spray_strength = 6
   #declare spray_angle = 0
   #declare spray_loop = true
#declare ground_plane=true
#declare ground_dist =3
 #declare ground_reflection=.1
   #declare particle_life = 1.5
   #declare particle_count = 400
   #declare particle_size =2
   #declare particle_stretch = 2
   #declare particle_dist = 1
   #declare particle_sep = 1.5

   #declare nozzle_width = 4
   #declare nozzle_angle = 3

   #declare spray_turb = .3
   #declare spin_turb = 10

   #declare use_blob = true
   #declare spray_texture = texture  // Pacific
   {
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.105833, 0.406233, 0.9916667, 0.0, 0.0> ]
            [ 0.12    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.12    rgbft <0.70, 0.9525, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <.850, .85, 1.0, 0.0, 0.0> ]
            [ 0.74    rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            [ 0.85    rgbft <0.7, 0.95, 1.0, .0, 0.0> ]
            [ 1.0     rgbft <.3, .7, 1.0, 0.0, 0.0> ]
         }
         turbulence 0.2
      }
      normal{bumps , .4}
      finish
      {
         ambient 0.4
         phong 0.63
         phong_size 81.0
         reflection 0.2158
         refraction on  ior 1.33
      }
   }

// CREATE SPRAY OBJECT
   #include "Spray.inc"

#include "water.inc"

//women//


#declare sPatchObj2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094725, -0.550891, 0.232265>, <-0.184977, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.094701, -0.553857, 0.444363>, <-0.094713, -0.552374, 0.338308>, <-0.184744, -0.443580, 0.143516>, <-0.290809, -0.443580, 0.143516>,
      <-0.184944, -0.555119, 0.534608>, <-0.184711, -0.449070, 0.536091>, <-0.290589, -0.356088, 0.341066>, <-0.290601, -0.354605, 0.235017>,
      <-0.290997, -0.555119, 0.534608>, <-0.290764, -0.449070, 0.536091>, <-0.290577, -0.357571, 0.447114>, <-0.290589, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094725, -0.550891, 0.232265>, <-0.184977, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.094701, -0.553857, 0.444363>, <-0.094713, -0.552374, 0.338308>, <-0.185210, -0.655677, 0.140550>, <-0.291275, -0.655677, 0.140550>,
      <-0.184944, -0.555119, 0.534608>, <-0.185177, -0.661168, 0.533125>, <-0.291451, -0.748661, 0.335575>, <-0.291463, -0.747178, 0.229525>,
      <-0.290997, -0.555119, 0.534608>, <-0.291230, -0.661168, 0.533125>, <-0.291439, -0.750144, 0.441623>, <-0.291451, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094701, -0.553857, 0.444363>, <-0.184944, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.094713, -0.552374, 0.338320>, <-0.094934, -0.660022, 0.442878>, <-0.185177, -0.661168, 0.533125>, <-0.291230, -0.661168, 0.533125>,
      <-0.094713, -0.552374, 0.338320>, <-0.094934, -0.660022, 0.442878>, <-0.185263, -0.750144, 0.441623>, <-0.291439, -0.750144, 0.441623>,
      <-0.094713, -0.552374, 0.338320>, <-0.094946, -0.658539, 0.336835>, <-0.185275, -0.748661, 0.335574>, <-0.291451, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094725, -0.550891, 0.232265>, <-0.184977, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.094713, -0.552374, 0.338320>, <-0.094958, -0.657056, 0.230780>, <-0.185210, -0.655677, 0.140550>, <-0.291275, -0.655677, 0.140550>,
      <-0.094713, -0.552374, 0.338320>, <-0.094958, -0.657056, 0.230780>, <-0.185287, -0.747178, 0.229525>, <-0.291463, -0.747178, 0.229525>,
      <-0.094713, -0.552374, 0.338320>, <-0.094946, -0.658539, 0.336835>, <-0.185275, -0.748661, 0.335574>, <-0.291451, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094725, -0.550891, 0.232265>, <-0.184977, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.094713, -0.552374, 0.338320>, <-0.094493, -0.444959, 0.233747>, <-0.184744, -0.443580, 0.143516>, <-0.290809, -0.443580, 0.143516>,
      <-0.094713, -0.552374, 0.338320>, <-0.094493, -0.444959, 0.233747>, <-0.184659, -0.354605, 0.235017>, <-0.290601, -0.354605, 0.235017>,
      <-0.094713, -0.552374, 0.338320>, <-0.094480, -0.446442, 0.339802>, <-0.184646, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094480, -0.446442, 0.339802>, <-0.184646, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>,
      <-0.094946, -0.658539, 0.336835>, <-0.094714, -0.552607, 0.338317>, <-0.184659, -0.354605, 0.235017>, <-0.290601, -0.354605, 0.235017>,
      <-0.185275, -0.748661, 0.335574>, <-0.185287, -0.747178, 0.229525>, <-0.291042, -0.549629, 0.142033>, <-0.290809, -0.443580, 0.143516>,
      <-0.291451, -0.748661, 0.335574>, <-0.291463, -0.747178, 0.229525>, <-0.291275, -0.655677, 0.140550>, <-0.291042, -0.549628, 0.142033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094701, -0.553857, 0.444363>, <-0.184944, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.094713, -0.552374, 0.338320>, <-0.094468, -0.447925, 0.445845>, <-0.184711, -0.449070, 0.536091>, <-0.290764, -0.449070, 0.536091>,
      <-0.094713, -0.552374, 0.338320>, <-0.094468, -0.447925, 0.445845>, <-0.184634, -0.357571, 0.447114>, <-0.290577, -0.357571, 0.447114>,
      <-0.094713, -0.552374, 0.338320>, <-0.094480, -0.446442, 0.339802>, <-0.184646, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.094713, -0.552374, 0.338320>, <-0.094946, -0.658539, 0.336835>, <-0.185275, -0.748661, 0.335574>, <-0.291451, -0.748661, 0.335574>,
      <-0.094480, -0.446442, 0.339802>, <-0.094714, -0.552607, 0.338317>, <-0.185263, -0.750144, 0.441623>, <-0.291439, -0.750144, 0.441623>,
      <-0.184646, -0.356088, 0.341065>, <-0.184634, -0.357571, 0.447114>, <-0.290997, -0.555120, 0.534608>, <-0.291230, -0.661168, 0.533125>,
      <-0.290589, -0.356088, 0.341065>, <-0.290577, -0.357571, 0.447114>, <-0.290764, -0.449070, 0.536091>, <-0.290997, -0.555119, 0.534608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487313, -0.553857, 0.444375>, <-0.397062, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.487337, -0.550891, 0.232278>, <-0.487325, -0.552374, 0.338332>, <-0.397295, -0.661168, 0.533125>, <-0.291230, -0.661168, 0.533125>,
      <-0.397095, -0.549628, 0.142033>, <-0.397328, -0.655677, 0.140550>, <-0.291451, -0.748661, 0.335575>, <-0.291439, -0.750144, 0.441623>,
      <-0.291042, -0.549628, 0.142033>, <-0.291275, -0.655677, 0.140550>, <-0.291463, -0.747178, 0.229525>, <-0.291451, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487313, -0.553857, 0.444375>, <-0.397062, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.487337, -0.550891, 0.232278>, <-0.487325, -0.552374, 0.338332>, <-0.396829, -0.449070, 0.536091>, <-0.290764, -0.449070, 0.536091>,
      <-0.397095, -0.549628, 0.142033>, <-0.396862, -0.443580, 0.143516>, <-0.290589, -0.356088, 0.341066>, <-0.290577, -0.357571, 0.447114>,
      <-0.291042, -0.549628, 0.142033>, <-0.290809, -0.443580, 0.143516>, <-0.290601, -0.354605, 0.235017>, <-0.290589, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487337, -0.550891, 0.232278>, <-0.397095, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.487092, -0.446210, 0.339805>, <-0.487104, -0.444727, 0.233763>, <-0.291030, -0.549628, 0.142033>, <-0.184977, -0.549628, 0.142033>,
      <-0.396764, -0.356088, 0.341065>, <-0.290821, -0.356088, 0.341065>, <-0.094493, -0.444959, 0.233747>, <-0.094725, -0.550891, 0.232265>,
      <-0.290589, -0.356088, 0.341065>, <-0.184646, -0.356088, 0.341065>, <-0.094480, -0.446442, 0.339802>, <-0.094713, -0.552374, 0.338320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487092, -0.446210, 0.339805>, <-0.396764, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>,
      <-0.487313, -0.553857, 0.444375>, <-0.487080, -0.447693, 0.445860>, <-0.290821, -0.356088, 0.341065>, <-0.184646, -0.356088, 0.341065>,
      <-0.397062, -0.555119, 0.534608>, <-0.291009, -0.555119, 0.534608>, <-0.094468, -0.447925, 0.445845>, <-0.094480, -0.446442, 0.339802>,
      <-0.290997, -0.555119, 0.534608>, <-0.184944, -0.555119, 0.534608>, <-0.094701, -0.553857, 0.444363>, <-0.094713, -0.552374, 0.338320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487092, -0.446210, 0.339805>, <-0.396764, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>,
      <-0.487325, -0.552374, 0.338320>, <-0.487104, -0.444727, 0.233763>, <-0.396776, -0.354605, 0.235017>, <-0.290601, -0.354605, 0.235017>,
      <-0.487325, -0.552374, 0.338320>, <-0.487104, -0.444727, 0.233763>, <-0.396862, -0.443580, 0.143516>, <-0.290809, -0.443580, 0.143516>,
      <-0.487325, -0.552374, 0.338320>, <-0.487337, -0.550891, 0.232278>, <-0.397095, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487313, -0.553857, 0.444375>, <-0.397062, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.487325, -0.552374, 0.338320>, <-0.487080, -0.447693, 0.445860>, <-0.396829, -0.449070, 0.536091>, <-0.290764, -0.449070, 0.536091>,
      <-0.487325, -0.552374, 0.338320>, <-0.487080, -0.447693, 0.445860>, <-0.396752, -0.357571, 0.447114>, <-0.290577, -0.357571, 0.447114>,
      <-0.487325, -0.552374, 0.338320>, <-0.487092, -0.446210, 0.339805>, <-0.396764, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487337, -0.550891, 0.232278>, <-0.397095, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.487558, -0.658306, 0.336838>, <-0.487570, -0.656822, 0.230796>, <-0.291030, -0.549628, 0.142033>, <-0.184977, -0.549628, 0.142033>,
      <-0.397393, -0.748661, 0.335574>, <-0.291218, -0.748661, 0.335574>, <-0.094958, -0.657056, 0.230780>, <-0.094725, -0.550891, 0.232265>,
      <-0.291451, -0.748661, 0.335574>, <-0.185275, -0.748661, 0.335574>, <-0.094946, -0.658539, 0.336835>, <-0.094713, -0.552374, 0.338320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487313, -0.553857, 0.444375>, <-0.397062, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.487558, -0.658306, 0.336838>, <-0.487546, -0.659789, 0.442893>, <-0.291009, -0.555119, 0.534608>, <-0.184944, -0.555119, 0.534608>,
      <-0.397393, -0.748661, 0.335574>, <-0.291218, -0.748661, 0.335574>, <-0.094934, -0.660022, 0.442878>, <-0.094701, -0.553857, 0.444363>,
      <-0.291451, -0.748661, 0.335574>, <-0.185275, -0.748661, 0.335574>, <-0.094946, -0.658539, 0.336835>, <-0.094713, -0.552374, 0.338320>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487313, -0.553857, 0.444375>, <-0.397062, -0.555119, 0.534608>, <-0.290997, -0.555119, 0.534608>,
      <-0.487325, -0.552374, 0.338320>, <-0.487546, -0.659789, 0.442893>, <-0.397295, -0.661168, 0.533125>, <-0.291230, -0.661168, 0.533125>,
      <-0.487325, -0.552374, 0.338320>, <-0.487546, -0.659789, 0.442893>, <-0.397381, -0.750144, 0.441623>, <-0.291439, -0.750144, 0.441623>,
      <-0.487325, -0.552374, 0.338320>, <-0.487558, -0.658306, 0.336838>, <-0.397393, -0.748661, 0.335574>, <-0.291451, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487092, -0.446210, 0.339805>, <-0.396764, -0.356088, 0.341065>, <-0.290589, -0.356088, 0.341065>,
      <-0.487558, -0.658306, 0.336838>, <-0.487324, -0.552141, 0.338323>, <-0.396752, -0.357571, 0.447114>, <-0.290577, -0.357571, 0.447114>,
      <-0.397393, -0.748661, 0.335574>, <-0.397381, -0.750144, 0.441623>, <-0.290997, -0.555120, 0.534608>, <-0.290764, -0.449070, 0.536091>,
      <-0.291451, -0.748661, 0.335574>, <-0.291439, -0.750144, 0.441623>, <-0.291230, -0.661168, 0.533125>, <-0.290997, -0.555119, 0.534608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487337, -0.550891, 0.232278>, <-0.397095, -0.549628, 0.142033>, <-0.291042, -0.549628, 0.142033>,
      <-0.487325, -0.552374, 0.338320>, <-0.487570, -0.656822, 0.230796>, <-0.397328, -0.655677, 0.140550>, <-0.291275, -0.655677, 0.140550>,
      <-0.487325, -0.552374, 0.338320>, <-0.487570, -0.656822, 0.230796>, <-0.397406, -0.747178, 0.229525>, <-0.291463, -0.747178, 0.229525>,
      <-0.487325, -0.552374, 0.338320>, <-0.487558, -0.658306, 0.336838>, <-0.397393, -0.748661, 0.335574>, <-0.291451, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.487325, -0.552374, 0.338320>, <-0.487558, -0.658306, 0.336838>, <-0.397393, -0.748661, 0.335574>, <-0.291451, -0.748661, 0.335574>,
      <-0.487092, -0.446210, 0.339805>, <-0.487324, -0.552141, 0.338323>, <-0.397406, -0.747178, 0.229525>, <-0.291463, -0.747178, 0.229525>,
      <-0.396764, -0.356088, 0.341065>, <-0.396776, -0.354605, 0.235017>, <-0.291042, -0.549629, 0.142033>, <-0.291275, -0.655677, 0.140550>,
      <-0.290589, -0.356088, 0.341065>, <-0.290601, -0.354605, 0.235017>, <-0.290809, -0.443580, 0.143516>, <-0.291042, -0.549628, 0.142033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481509, -0.550910, 0.228492>, <0.389865, -0.549628, 0.140676>, <0.285192, -0.549628, 0.142033>,
      <0.481533, -0.553877, 0.440608>, <0.481521, -0.552413, 0.335937>, <0.390098, -0.443580, 0.142159>, <0.285425, -0.443580, 0.143516>,
      <0.392683, -0.555119, 0.533215>, <0.392916, -0.449070, 0.534698>, <0.285645, -0.356088, 0.341066>, <0.285633, -0.354605, 0.235017>,
      <0.285237, -0.555119, 0.534608>, <0.285470, -0.449070, 0.536091>, <0.285657, -0.357571, 0.447114>, <0.285645, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481509, -0.550910, 0.228492>, <0.389865, -0.549628, 0.140676>, <0.285192, -0.549628, 0.142033>,
      <0.481533, -0.553877, 0.440608>, <0.481521, -0.552413, 0.335937>, <0.389632, -0.655677, 0.139193>, <0.284959, -0.655677, 0.140550>,
      <0.392683, -0.555119, 0.533215>, <0.392450, -0.661168, 0.531732>, <0.284783, -0.748661, 0.335575>, <0.284771, -0.747178, 0.229525>,
      <0.285237, -0.555119, 0.534608>, <0.285004, -0.661168, 0.533125>, <0.284795, -0.750144, 0.441623>, <0.284783, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481533, -0.553877, 0.440608>, <0.392683, -0.555119, 0.533215>, <0.285237, -0.555119, 0.534608>,
      <0.481521, -0.552374, 0.333163>, <0.481300, -0.660041, 0.439123>, <0.392450, -0.661168, 0.531732>, <0.285004, -0.661168, 0.533125>,
      <0.481521, -0.552374, 0.333163>, <0.481300, -0.660041, 0.439123>, <0.390961, -0.750144, 0.440247>, <0.284795, -0.750144, 0.441623>,
      <0.481521, -0.552374, 0.333163>, <0.481288, -0.658538, 0.331678>, <0.390949, -0.748661, 0.334198>, <0.284783, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481509, -0.550910, 0.228492>, <0.389865, -0.549628, 0.140676>, <0.285192, -0.549628, 0.142033>,
      <0.481521, -0.552374, 0.333163>, <0.481276, -0.657074, 0.227007>, <0.389632, -0.655677, 0.139193>, <0.284959, -0.655677, 0.140550>,
      <0.481521, -0.552374, 0.333163>, <0.481276, -0.657074, 0.227007>, <0.390937, -0.747178, 0.228149>, <0.284771, -0.747178, 0.229525>,
      <0.481521, -0.552374, 0.333163>, <0.481288, -0.658538, 0.331678>, <0.390949, -0.748661, 0.334198>, <0.284783, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481509, -0.550910, 0.228492>, <0.389865, -0.549628, 0.140676>, <0.285192, -0.549628, 0.142033>,
      <0.481521, -0.552374, 0.333163>, <0.481742, -0.444940, 0.229974>, <0.390098, -0.443580, 0.142159>, <0.285425, -0.443580, 0.143516>,
      <0.481521, -0.552374, 0.333163>, <0.481742, -0.444940, 0.229974>, <0.391604, -0.354605, 0.233643>, <0.285633, -0.354605, 0.235017>,
      <0.481521, -0.552374, 0.333163>, <0.481754, -0.446404, 0.334645>, <0.391616, -0.356088, 0.339691>, <0.285645, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481754, -0.446404, 0.334645>, <0.391616, -0.356088, 0.339691>, <0.285645, -0.356088, 0.341065>,
      <0.481288, -0.658538, 0.331678>, <0.481521, -0.552568, 0.333160>, <0.391604, -0.354605, 0.233643>, <0.285633, -0.354605, 0.235017>,
      <0.390949, -0.748661, 0.334198>, <0.390937, -0.747178, 0.228149>, <0.285192, -0.549629, 0.142033>, <0.285425, -0.443580, 0.143516>,
      <0.284783, -0.748661, 0.335574>, <0.284771, -0.747178, 0.229525>, <0.284959, -0.655677, 0.140550>, <0.285192, -0.549628, 0.142033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481533, -0.553877, 0.440608>, <0.392683, -0.555119, 0.533215>, <0.285237, -0.555119, 0.534608>,
      <0.481521, -0.552374, 0.333163>, <0.481766, -0.447907, 0.442090>, <0.392916, -0.449070, 0.534698>, <0.285470, -0.449070, 0.536091>,
      <0.481521, -0.552374, 0.333163>, <0.481766, -0.447907, 0.442090>, <0.391629, -0.357571, 0.445740>, <0.285657, -0.357571, 0.447114>,
      <0.481521, -0.552374, 0.333163>, <0.481754, -0.446404, 0.334645>, <0.391616, -0.356088, 0.339691>, <0.285645, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.481521, -0.552374, 0.333163>, <0.481288, -0.658538, 0.331678>, <0.390949, -0.748661, 0.334198>, <0.284783, -0.748661, 0.335574>,
      <0.481754, -0.446404, 0.334645>, <0.481521, -0.552568, 0.333160>, <0.390961, -0.750144, 0.440247>, <0.284795, -0.750144, 0.441623>,
      <0.391616, -0.356088, 0.339691>, <0.391629, -0.357571, 0.445740>, <0.285237, -0.555120, 0.534608>, <0.285004, -0.661168, 0.533125>,
      <0.285645, -0.356088, 0.341065>, <0.285657, -0.357571, 0.447114>, <0.285470, -0.449070, 0.536091>, <0.285237, -0.555119, 0.534608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083764, -0.553877, 0.445777>, <0.177779, -0.555119, 0.536001>, <0.285237, -0.555119, 0.534608>,
      <0.083740, -0.550871, 0.230876>, <0.083752, -0.552374, 0.338333>, <0.177546, -0.661168, 0.534518>, <0.285004, -0.661168, 0.533125>,
      <0.177746, -0.549628, 0.143426>, <0.177513, -0.655677, 0.141943>, <0.284783, -0.748661, 0.335575>, <0.284795, -0.750144, 0.441623>,
      <0.285192, -0.549628, 0.142033>, <0.284959, -0.655677, 0.140550>, <0.284771, -0.747178, 0.229525>, <0.284783, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083764, -0.553877, 0.445777>, <0.177779, -0.555119, 0.536001>, <0.285237, -0.555119, 0.534608>,
      <0.083740, -0.550871, 0.230876>, <0.083752, -0.552374, 0.338333>, <0.178011, -0.449070, 0.537485>, <0.285470, -0.449070, 0.536091>,
      <0.177746, -0.549628, 0.143426>, <0.177979, -0.443580, 0.144909>, <0.285645, -0.356088, 0.341066>, <0.285657, -0.357571, 0.447114>,
      <0.285192, -0.549628, 0.142033>, <0.285425, -0.443580, 0.143516>, <0.285633, -0.354605, 0.235017>, <0.285645, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083740, -0.550871, 0.230876>, <0.177746, -0.549628, 0.143426>, <0.285192, -0.549628, 0.142033>,
      <0.083988, -0.444806, 0.339825>, <0.083976, -0.443303, 0.232380>, <0.282419, -0.549628, 0.142069>, <0.389865, -0.549628, 0.140676>,
      <0.178076, -0.356088, 0.342460>, <0.284047, -0.356088, 0.341086>, <0.481742, -0.444940, 0.229974>, <0.481509, -0.550910, 0.228492>,
      <0.285645, -0.356088, 0.341065>, <0.391616, -0.356088, 0.339691>, <0.481754, -0.446404, 0.334645>, <0.481521, -0.552374, 0.333163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083988, -0.444806, 0.339825>, <0.178076, -0.356088, 0.342460>, <0.285645, -0.356088, 0.341065>,
      <0.083764, -0.553877, 0.445777>, <0.084001, -0.446309, 0.447281>, <0.284047, -0.356088, 0.341086>, <0.391616, -0.356088, 0.339691>,
      <0.177779, -0.555119, 0.536001>, <0.285225, -0.555119, 0.534608>, <0.481766, -0.447907, 0.442090>, <0.481754, -0.446404, 0.334645>,
      <0.285237, -0.555119, 0.534608>, <0.392683, -0.555119, 0.533215>, <0.481533, -0.553877, 0.440608>, <0.481521, -0.552374, 0.333163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083988, -0.444806, 0.339825>, <0.178076, -0.356088, 0.342460>, <0.285645, -0.356088, 0.341065>,
      <0.083752, -0.552374, 0.338320>, <0.083976, -0.443303, 0.232380>, <0.178063, -0.354605, 0.236411>, <0.285633, -0.354605, 0.235017>,
      <0.083752, -0.552374, 0.338320>, <0.083976, -0.443303, 0.232380>, <0.177979, -0.443580, 0.144909>, <0.285425, -0.443580, 0.143516>,
      <0.083752, -0.552374, 0.338320>, <0.083740, -0.550871, 0.230876>, <0.177746, -0.549628, 0.143426>, <0.285192, -0.549628, 0.142033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083764, -0.553877, 0.445777>, <0.177779, -0.555119, 0.536001>, <0.285237, -0.555119, 0.534608>,
      <0.083752, -0.552374, 0.338320>, <0.084001, -0.446309, 0.447281>, <0.178011, -0.449070, 0.537485>, <0.285470, -0.449070, 0.536091>,
      <0.083752, -0.552374, 0.338320>, <0.084001, -0.446309, 0.447281>, <0.178088, -0.357571, 0.448508>, <0.285657, -0.357571, 0.447114>,
      <0.083752, -0.552374, 0.338320>, <0.083988, -0.444806, 0.339825>, <0.178076, -0.356088, 0.342460>, <0.285645, -0.356088, 0.341065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083740, -0.550871, 0.230876>, <0.177746, -0.549628, 0.143426>, <0.285192, -0.549628, 0.142033>,
      <0.083516, -0.659706, 0.336819>, <0.083504, -0.658203, 0.229375>, <0.282419, -0.549628, 0.142069>, <0.389865, -0.549628, 0.140676>,
      <0.177449, -0.748661, 0.336966>, <0.283615, -0.748661, 0.335589>, <0.481276, -0.657074, 0.227007>, <0.481509, -0.550910, 0.228492>,
      <0.284783, -0.748661, 0.335574>, <0.390949, -0.748661, 0.334198>, <0.481288, -0.658538, 0.331678>, <0.481521, -0.552374, 0.333163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083764, -0.553877, 0.445777>, <0.177779, -0.555119, 0.536001>, <0.285237, -0.555119, 0.534608>,
      <0.083516, -0.659706, 0.336819>, <0.083529, -0.661209, 0.444276>, <0.285225, -0.555119, 0.534608>, <0.392683, -0.555119, 0.533215>,
      <0.177449, -0.748661, 0.336966>, <0.283615, -0.748661, 0.335589>, <0.481300, -0.660041, 0.439123>, <0.481533, -0.553877, 0.440608>,
      <0.284783, -0.748661, 0.335574>, <0.390949, -0.748661, 0.334198>, <0.481288, -0.658538, 0.331678>, <0.481521, -0.552374, 0.333163>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083764, -0.553877, 0.445777>, <0.177779, -0.555119, 0.536001>, <0.285237, -0.555119, 0.534608>,
      <0.083752, -0.552374, 0.338320>, <0.083529, -0.661209, 0.444276>, <0.177546, -0.661168, 0.534518>, <0.285004, -0.661168, 0.533125>,
      <0.083752, -0.552374, 0.338320>, <0.083529, -0.661209, 0.444276>, <0.177461, -0.750144, 0.443015>, <0.284795, -0.750144, 0.441623>,
      <0.083752, -0.552374, 0.338320>, <0.083516, -0.659706, 0.336819>, <0.177449, -0.748661, 0.336966>, <0.284783, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083988, -0.444806, 0.339825>, <0.178076, -0.356088, 0.342460>, <0.285645, -0.356088, 0.341065>,
      <0.083516, -0.659706, 0.336819>, <0.083752, -0.552138, 0.338323>, <0.178088, -0.357571, 0.448508>, <0.285657, -0.357571, 0.447114>,
      <0.177449, -0.748661, 0.336966>, <0.177461, -0.750144, 0.443015>, <0.285237, -0.555120, 0.534608>, <0.285470, -0.449070, 0.536091>,
      <0.284783, -0.748661, 0.335574>, <0.284795, -0.750144, 0.441623>, <0.285004, -0.661168, 0.533125>, <0.285237, -0.555119, 0.534608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083740, -0.550871, 0.230876>, <0.177746, -0.549628, 0.143426>, <0.285192, -0.549628, 0.142033>,
      <0.083752, -0.552374, 0.338320>, <0.083504, -0.658203, 0.229375>, <0.177513, -0.655677, 0.141943>, <0.284959, -0.655677, 0.140550>,
      <0.083752, -0.552374, 0.338320>, <0.083504, -0.658203, 0.229375>, <0.177437, -0.747178, 0.230917>, <0.284771, -0.747178, 0.229525>,
      <0.083752, -0.552374, 0.338320>, <0.083516, -0.659706, 0.336819>, <0.177449, -0.748661, 0.336966>, <0.284783, -0.748661, 0.335574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083752, -0.552374, 0.338320>, <0.083516, -0.659706, 0.336819>, <0.177449, -0.748661, 0.336966>, <0.284783, -0.748661, 0.335574>,
      <0.083988, -0.444806, 0.339825>, <0.083752, -0.552138, 0.338323>, <0.177437, -0.747178, 0.230917>, <0.284771, -0.747178, 0.229525>,
      <0.178076, -0.356088, 0.342460>, <0.178063, -0.354605, 0.236411>, <0.285192, -0.549629, 0.142033>, <0.284959, -0.655677, 0.140550>,
      <0.285645, -0.356088, 0.341065>, <0.285633, -0.354605, 0.235017>, <0.285425, -0.443580, 0.143516>, <0.285192, -0.549628, 0.142033>
    }
  }
  texture {
    DGray
  }
}
#declare sPatchObj4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215107, -0.707056, 0.294945>, <-0.250169, -0.706488, 0.259896>, <-0.291369, -0.706397, 0.259902>,
      <-0.215097, -0.708209, 0.377337>, <-0.215102, -0.707632, 0.336141>, <-0.250095, -0.672741, 0.260368>, <-0.291295, -0.672651, 0.260374>,
      <-0.250151, -0.708622, 0.412396>, <-0.250077, -0.674875, 0.412868>, <-0.291262, -0.662867, 0.336776>, <-0.291266, -0.662395, 0.303029>,
      <-0.291351, -0.708531, 0.412402>, <-0.291277, -0.674784, 0.412874>, <-0.291258, -0.663339, 0.370522>, <-0.291262, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215107, -0.707056, 0.294945>, <-0.250169, -0.706488, 0.259896>, <-0.291369, -0.706397, 0.259902>,
      <-0.215097, -0.708209, 0.377337>, <-0.215102, -0.707632, 0.336141>, <-0.250243, -0.740234, 0.259424>, <-0.291443, -0.740144, 0.259430>,
      <-0.250151, -0.708622, 0.412396>, <-0.250225, -0.742368, 0.411924>, <-0.291458, -0.752063, 0.335528>, <-0.291462, -0.751591, 0.301781>,
      <-0.291351, -0.708531, 0.412402>, <-0.291425, -0.742278, 0.411930>, <-0.291454, -0.752535, 0.369275>, <-0.291458, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215097, -0.708209, 0.377337>, <-0.250151, -0.708622, 0.412396>, <-0.291351, -0.708531, 0.412402>,
      <-0.215102, -0.707632, 0.336141>, <-0.215171, -0.741955, 0.376865>, <-0.250225, -0.742368, 0.411924>, <-0.291425, -0.742278, 0.411930>,
      <-0.215102, -0.707632, 0.336141>, <-0.215171, -0.741955, 0.376865>, <-0.257704, -0.752609, 0.369270>, <-0.291454, -0.752535, 0.369275>,
      <-0.215102, -0.707632, 0.336141>, <-0.215176, -0.741379, 0.335669>, <-0.257708, -0.752137, 0.335523>, <-0.291458, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215107, -0.707056, 0.294945>, <-0.250169, -0.706488, 0.259896>, <-0.291369, -0.706397, 0.259902>,
      <-0.215102, -0.707632, 0.336141>, <-0.215181, -0.740803, 0.294473>, <-0.250243, -0.740234, 0.259424>, <-0.291443, -0.740144, 0.259430>,
      <-0.215102, -0.707632, 0.336141>, <-0.215181, -0.740803, 0.294473>, <-0.257712, -0.751665, 0.301776>, <-0.291462, -0.751591, 0.301781>,
      <-0.215102, -0.707632, 0.336141>, <-0.215176, -0.741379, 0.335669>, <-0.257708, -0.752137, 0.335523>, <-0.291458, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215107, -0.707056, 0.294945>, <-0.250169, -0.706488, 0.259896>, <-0.291369, -0.706397, 0.259902>,
      <-0.215102, -0.707632, 0.336141>, <-0.215033, -0.673309, 0.295417>, <-0.250095, -0.672741, 0.260368>, <-0.291295, -0.672651, 0.260374>,
      <-0.215102, -0.707632, 0.336141>, <-0.215033, -0.673309, 0.295417>, <-0.257516, -0.662469, 0.303024>, <-0.291266, -0.662395, 0.303029>,
      <-0.215102, -0.707632, 0.336141>, <-0.215028, -0.673885, 0.336613>, <-0.257512, -0.662941, 0.336770>, <-0.291262, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215028, -0.673885, 0.336613>, <-0.257512, -0.662941, 0.336770>, <-0.291262, -0.662867, 0.336775>,
      <-0.215176, -0.741379, 0.335669>, <-0.215102, -0.707632, 0.336141>, <-0.257516, -0.662469, 0.303024>, <-0.291266, -0.662395, 0.303029>,
      <-0.257708, -0.752137, 0.335523>, <-0.257712, -0.751665, 0.301776>, <-0.291369, -0.706398, 0.259902>, <-0.291295, -0.672651, 0.260374>,
      <-0.291458, -0.752063, 0.335528>, <-0.291462, -0.751591, 0.301781>, <-0.291443, -0.740144, 0.259430>, <-0.291369, -0.706397, 0.259902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215097, -0.708209, 0.377337>, <-0.250151, -0.708622, 0.412396>, <-0.291351, -0.708531, 0.412402>,
      <-0.215102, -0.707632, 0.336141>, <-0.215023, -0.674462, 0.377809>, <-0.250077, -0.674875, 0.412868>, <-0.291277, -0.674784, 0.412874>,
      <-0.215102, -0.707632, 0.336141>, <-0.215023, -0.674462, 0.377809>, <-0.257508, -0.663413, 0.370517>, <-0.291258, -0.663339, 0.370522>,
      <-0.215102, -0.707632, 0.336141>, <-0.215028, -0.673885, 0.336613>, <-0.257512, -0.662941, 0.336770>, <-0.291262, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.215102, -0.707632, 0.336141>, <-0.215176, -0.741379, 0.335669>, <-0.257708, -0.752137, 0.335523>, <-0.291458, -0.752063, 0.335528>,
      <-0.215028, -0.673885, 0.336613>, <-0.215102, -0.707632, 0.336141>, <-0.257704, -0.752609, 0.369270>, <-0.291454, -0.752535, 0.369275>,
      <-0.257512, -0.662941, 0.336770>, <-0.257508, -0.663413, 0.370517>, <-0.291351, -0.708531, 0.412402>, <-0.291425, -0.742278, 0.411930>,
      <-0.291262, -0.662867, 0.336775>, <-0.291258, -0.663339, 0.370522>, <-0.291277, -0.674784, 0.412874>, <-0.291351, -0.708531, 0.412402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367611, -0.707874, 0.377359>, <-0.332551, -0.708441, 0.412408>, <-0.291351, -0.708531, 0.412402>,
      <-0.367621, -0.706721, 0.294968>, <-0.367616, -0.707297, 0.336163>, <-0.332625, -0.742187, 0.411936>, <-0.291425, -0.742278, 0.411930>,
      <-0.332568, -0.706306, 0.259908>, <-0.332643, -0.740053, 0.259436>, <-0.291458, -0.752063, 0.335528>, <-0.291454, -0.752535, 0.369275>,
      <-0.291369, -0.706397, 0.259902>, <-0.291443, -0.740144, 0.259430>, <-0.291462, -0.751591, 0.301781>, <-0.291458, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367611, -0.707874, 0.377359>, <-0.332551, -0.708441, 0.412408>, <-0.291351, -0.708531, 0.412402>,
      <-0.367621, -0.706721, 0.294968>, <-0.367616, -0.707297, 0.336163>, <-0.332476, -0.674694, 0.412880>, <-0.291277, -0.674784, 0.412874>,
      <-0.332568, -0.706306, 0.259908>, <-0.332494, -0.672561, 0.260380>, <-0.291262, -0.662867, 0.336776>, <-0.291258, -0.663339, 0.370522>,
      <-0.291369, -0.706397, 0.259902>, <-0.291295, -0.672651, 0.260374>, <-0.291266, -0.662395, 0.303029>, <-0.291262, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367621, -0.706721, 0.294968>, <-0.332568, -0.706306, 0.259908>, <-0.291369, -0.706397, 0.259902>,
      <-0.367542, -0.673551, 0.336635>, <-0.367547, -0.672975, 0.295439>, <-0.291368, -0.706397, 0.259902>, <-0.250169, -0.706488, 0.259896>,
      <-0.325011, -0.662793, 0.336780>, <-0.291261, -0.662867, 0.336775>, <-0.215033, -0.673309, 0.295417>, <-0.215107, -0.707056, 0.294945>,
      <-0.291262, -0.662867, 0.336775>, <-0.257512, -0.662941, 0.336770>, <-0.215028, -0.673885, 0.336613>, <-0.215102, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367542, -0.673551, 0.336635>, <-0.325011, -0.662793, 0.336780>, <-0.291262, -0.662867, 0.336775>,
      <-0.367611, -0.707874, 0.377359>, <-0.367537, -0.674127, 0.377830>, <-0.291261, -0.662867, 0.336775>, <-0.257512, -0.662941, 0.336770>,
      <-0.332551, -0.708441, 0.412408>, <-0.291351, -0.708531, 0.412402>, <-0.215023, -0.674462, 0.377809>, <-0.215028, -0.673885, 0.336613>,
      <-0.291351, -0.708531, 0.412402>, <-0.250151, -0.708622, 0.412396>, <-0.215097, -0.708209, 0.377337>, <-0.215102, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367542, -0.673551, 0.336635>, <-0.325011, -0.662793, 0.336780>, <-0.291262, -0.662867, 0.336775>,
      <-0.367616, -0.707297, 0.336163>, <-0.367547, -0.672975, 0.295439>, <-0.325015, -0.662321, 0.303034>, <-0.291266, -0.662395, 0.303029>,
      <-0.367616, -0.707297, 0.336163>, <-0.367547, -0.672975, 0.295439>, <-0.332494, -0.672561, 0.260380>, <-0.291295, -0.672651, 0.260374>,
      <-0.367616, -0.707297, 0.336163>, <-0.367621, -0.706721, 0.294968>, <-0.332568, -0.706306, 0.259908>, <-0.291369, -0.706397, 0.259902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367611, -0.707874, 0.377359>, <-0.332551, -0.708441, 0.412408>, <-0.291351, -0.708531, 0.412402>,
      <-0.367616, -0.707297, 0.336163>, <-0.367537, -0.674127, 0.377830>, <-0.332476, -0.674694, 0.412880>, <-0.291277, -0.674784, 0.412874>,
      <-0.367616, -0.707297, 0.336163>, <-0.367537, -0.674127, 0.377830>, <-0.325007, -0.663265, 0.370527>, <-0.291258, -0.663339, 0.370522>,
      <-0.367616, -0.707297, 0.336163>, <-0.367542, -0.673551, 0.336635>, <-0.325011, -0.662793, 0.336780>, <-0.291262, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367621, -0.706721, 0.294968>, <-0.332568, -0.706306, 0.259908>, <-0.291369, -0.706397, 0.259902>,
      <-0.367690, -0.741043, 0.335691>, <-0.367695, -0.740467, 0.294496>, <-0.291368, -0.706397, 0.259902>, <-0.250169, -0.706488, 0.259896>,
      <-0.325208, -0.751989, 0.335533>, <-0.291457, -0.752063, 0.335528>, <-0.215181, -0.740803, 0.294473>, <-0.215107, -0.707056, 0.294945>,
      <-0.291458, -0.752063, 0.335528>, <-0.257708, -0.752137, 0.335523>, <-0.215176, -0.741379, 0.335669>, <-0.215102, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367611, -0.707874, 0.377359>, <-0.332551, -0.708441, 0.412408>, <-0.291351, -0.708531, 0.412402>,
      <-0.367690, -0.741043, 0.335691>, <-0.367685, -0.741620, 0.376887>, <-0.291351, -0.708531, 0.412402>, <-0.250151, -0.708622, 0.412396>,
      <-0.325208, -0.751989, 0.335533>, <-0.291457, -0.752063, 0.335528>, <-0.215171, -0.741955, 0.376865>, <-0.215097, -0.708209, 0.377337>,
      <-0.291458, -0.752063, 0.335528>, <-0.257708, -0.752137, 0.335523>, <-0.215176, -0.741379, 0.335669>, <-0.215102, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367611, -0.707874, 0.377359>, <-0.332551, -0.708441, 0.412408>, <-0.291351, -0.708531, 0.412402>,
      <-0.367616, -0.707297, 0.336163>, <-0.367685, -0.741620, 0.376887>, <-0.332625, -0.742187, 0.411936>, <-0.291425, -0.742278, 0.411930>,
      <-0.367616, -0.707297, 0.336163>, <-0.367685, -0.741620, 0.376887>, <-0.325204, -0.752461, 0.369280>, <-0.291454, -0.752535, 0.369275>,
      <-0.367616, -0.707297, 0.336163>, <-0.367690, -0.741043, 0.335691>, <-0.325208, -0.751989, 0.335533>, <-0.291458, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367542, -0.673551, 0.336635>, <-0.325011, -0.662793, 0.336780>, <-0.291262, -0.662867, 0.336775>,
      <-0.367690, -0.741043, 0.335691>, <-0.367616, -0.707297, 0.336163>, <-0.325007, -0.663265, 0.370527>, <-0.291258, -0.663339, 0.370522>,
      <-0.325208, -0.751989, 0.335533>, <-0.325204, -0.752461, 0.369280>, <-0.291351, -0.708531, 0.412402>, <-0.291277, -0.674784, 0.412874>,
      <-0.291458, -0.752063, 0.335528>, <-0.291454, -0.752535, 0.369275>, <-0.291425, -0.742278, 0.411930>, <-0.291351, -0.708531, 0.412402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367621, -0.706721, 0.294968>, <-0.332568, -0.706306, 0.259908>, <-0.291369, -0.706397, 0.259902>,
      <-0.367616, -0.707297, 0.336163>, <-0.367695, -0.740467, 0.294496>, <-0.332643, -0.740053, 0.259436>, <-0.291443, -0.740144, 0.259430>,
      <-0.367616, -0.707297, 0.336163>, <-0.367695, -0.740467, 0.294496>, <-0.325212, -0.751517, 0.301786>, <-0.291462, -0.751591, 0.301781>,
      <-0.367616, -0.707297, 0.336163>, <-0.367690, -0.741043, 0.335691>, <-0.325208, -0.751989, 0.335533>, <-0.291458, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367616, -0.707297, 0.336163>, <-0.367690, -0.741043, 0.335691>, <-0.325208, -0.751989, 0.335533>, <-0.291458, -0.752063, 0.335528>,
      <-0.367542, -0.673551, 0.336635>, <-0.367616, -0.707297, 0.336163>, <-0.325212, -0.751517, 0.301786>, <-0.291462, -0.751591, 0.301781>,
      <-0.325011, -0.662793, 0.336780>, <-0.325015, -0.662321, 0.303034>, <-0.291369, -0.706398, 0.259902>, <-0.291443, -0.740144, 0.259430>,
      <-0.291262, -0.662867, 0.336775>, <-0.291266, -0.662395, 0.303029>, <-0.291295, -0.672651, 0.260374>, <-0.291369, -0.706397, 0.259902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361127, -0.707056, 0.294945>, <0.326065, -0.706488, 0.259896>, <0.284865, -0.706397, 0.259902>,
      <0.361137, -0.708209, 0.377337>, <0.361132, -0.707632, 0.336141>, <0.326139, -0.672741, 0.260368>, <0.284939, -0.672651, 0.260374>,
      <0.326083, -0.708622, 0.412396>, <0.326157, -0.674875, 0.412868>, <0.284972, -0.662867, 0.336776>, <0.284968, -0.662395, 0.303029>,
      <0.284883, -0.708531, 0.412402>, <0.284957, -0.674784, 0.412874>, <0.284976, -0.663339, 0.370522>, <0.284972, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361127, -0.707056, 0.294945>, <0.326065, -0.706488, 0.259896>, <0.284865, -0.706397, 0.259902>,
      <0.361137, -0.708209, 0.377337>, <0.361132, -0.707632, 0.336141>, <0.325991, -0.740234, 0.259424>, <0.284791, -0.740144, 0.259430>,
      <0.326083, -0.708622, 0.412396>, <0.326009, -0.742368, 0.411924>, <0.284776, -0.752063, 0.335528>, <0.284772, -0.751591, 0.301781>,
      <0.284883, -0.708531, 0.412402>, <0.284809, -0.742278, 0.411930>, <0.284780, -0.752535, 0.369275>, <0.284776, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361137, -0.708209, 0.377337>, <0.326083, -0.708622, 0.412396>, <0.284883, -0.708531, 0.412402>,
      <0.361132, -0.707632, 0.336141>, <0.361063, -0.741955, 0.376865>, <0.326009, -0.742368, 0.411924>, <0.284809, -0.742278, 0.411930>,
      <0.361132, -0.707632, 0.336141>, <0.361063, -0.741955, 0.376865>, <0.318530, -0.752609, 0.369270>, <0.284780, -0.752535, 0.369275>,
      <0.361132, -0.707632, 0.336141>, <0.361058, -0.741379, 0.335669>, <0.318526, -0.752137, 0.335523>, <0.284776, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361127, -0.707056, 0.294945>, <0.326065, -0.706488, 0.259896>, <0.284865, -0.706397, 0.259902>,
      <0.361132, -0.707632, 0.336141>, <0.361053, -0.740803, 0.294473>, <0.325991, -0.740234, 0.259424>, <0.284791, -0.740144, 0.259430>,
      <0.361132, -0.707632, 0.336141>, <0.361053, -0.740803, 0.294473>, <0.318522, -0.751665, 0.301776>, <0.284772, -0.751591, 0.301781>,
      <0.361132, -0.707632, 0.336141>, <0.361058, -0.741379, 0.335669>, <0.318526, -0.752137, 0.335523>, <0.284776, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361127, -0.707056, 0.294945>, <0.326065, -0.706488, 0.259896>, <0.284865, -0.706397, 0.259902>,
      <0.361132, -0.707632, 0.336141>, <0.361201, -0.673309, 0.295417>, <0.326139, -0.672741, 0.260368>, <0.284939, -0.672651, 0.260374>,
      <0.361132, -0.707632, 0.336141>, <0.361201, -0.673309, 0.295417>, <0.318718, -0.662469, 0.303024>, <0.284968, -0.662395, 0.303029>,
      <0.361132, -0.707632, 0.336141>, <0.361206, -0.673885, 0.336613>, <0.318722, -0.662941, 0.336770>, <0.284972, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361206, -0.673885, 0.336613>, <0.318722, -0.662941, 0.336770>, <0.284972, -0.662867, 0.336775>,
      <0.361058, -0.741379, 0.335669>, <0.361132, -0.707632, 0.336141>, <0.318718, -0.662469, 0.303024>, <0.284968, -0.662395, 0.303029>,
      <0.318526, -0.752137, 0.335523>, <0.318522, -0.751665, 0.301776>, <0.284865, -0.706398, 0.259902>, <0.284939, -0.672651, 0.260374>,
      <0.284776, -0.752063, 0.335528>, <0.284772, -0.751591, 0.301781>, <0.284791, -0.740144, 0.259430>, <0.284865, -0.706397, 0.259902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361137, -0.708209, 0.377337>, <0.326083, -0.708622, 0.412396>, <0.284883, -0.708531, 0.412402>,
      <0.361132, -0.707632, 0.336141>, <0.361211, -0.674462, 0.377809>, <0.326157, -0.674875, 0.412868>, <0.284957, -0.674784, 0.412874>,
      <0.361132, -0.707632, 0.336141>, <0.361211, -0.674462, 0.377809>, <0.318726, -0.663413, 0.370517>, <0.284976, -0.663339, 0.370522>,
      <0.361132, -0.707632, 0.336141>, <0.361206, -0.673885, 0.336613>, <0.318722, -0.662941, 0.336770>, <0.284972, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.361132, -0.707632, 0.336141>, <0.361058, -0.741379, 0.335669>, <0.318526, -0.752137, 0.335523>, <0.284776, -0.752063, 0.335528>,
      <0.361206, -0.673885, 0.336613>, <0.361132, -0.707632, 0.336141>, <0.318530, -0.752609, 0.369270>, <0.284780, -0.752535, 0.369275>,
      <0.318722, -0.662941, 0.336770>, <0.318726, -0.663413, 0.370517>, <0.284883, -0.708531, 0.412402>, <0.284809, -0.742278, 0.411930>,
      <0.284972, -0.662867, 0.336775>, <0.284976, -0.663339, 0.370522>, <0.284957, -0.674784, 0.412874>, <0.284883, -0.708531, 0.412402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208623, -0.707874, 0.377359>, <0.243684, -0.708441, 0.412408>, <0.284883, -0.708531, 0.412402>,
      <0.208613, -0.706721, 0.294968>, <0.208618, -0.707297, 0.336163>, <0.243609, -0.742187, 0.411936>, <0.284809, -0.742278, 0.411930>,
      <0.243666, -0.706306, 0.259908>, <0.243591, -0.740053, 0.259436>, <0.284776, -0.752063, 0.335528>, <0.284780, -0.752535, 0.369275>,
      <0.284865, -0.706397, 0.259902>, <0.284791, -0.740144, 0.259430>, <0.284772, -0.751591, 0.301781>, <0.284776, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208623, -0.707874, 0.377359>, <0.243684, -0.708441, 0.412408>, <0.284883, -0.708531, 0.412402>,
      <0.208613, -0.706721, 0.294968>, <0.208618, -0.707297, 0.336163>, <0.243758, -0.674694, 0.412880>, <0.284957, -0.674784, 0.412874>,
      <0.243666, -0.706306, 0.259908>, <0.243740, -0.672561, 0.260380>, <0.284972, -0.662867, 0.336776>, <0.284976, -0.663339, 0.370522>,
      <0.284865, -0.706397, 0.259902>, <0.284939, -0.672651, 0.260374>, <0.284968, -0.662395, 0.303029>, <0.284972, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208613, -0.706721, 0.294968>, <0.243666, -0.706306, 0.259908>, <0.284865, -0.706397, 0.259902>,
      <0.208692, -0.673551, 0.336635>, <0.208687, -0.672975, 0.295439>, <0.284866, -0.706397, 0.259902>, <0.326065, -0.706488, 0.259896>,
      <0.251223, -0.662793, 0.336780>, <0.284973, -0.662867, 0.336775>, <0.361201, -0.673309, 0.295417>, <0.361127, -0.707056, 0.294945>,
      <0.284972, -0.662867, 0.336775>, <0.318722, -0.662941, 0.336770>, <0.361206, -0.673885, 0.336613>, <0.361132, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208692, -0.673551, 0.336635>, <0.251223, -0.662793, 0.336780>, <0.284972, -0.662867, 0.336775>,
      <0.208623, -0.707874, 0.377359>, <0.208697, -0.674127, 0.377830>, <0.284973, -0.662867, 0.336775>, <0.318722, -0.662941, 0.336770>,
      <0.243684, -0.708441, 0.412408>, <0.284883, -0.708531, 0.412402>, <0.361211, -0.674462, 0.377809>, <0.361206, -0.673885, 0.336613>,
      <0.284883, -0.708531, 0.412402>, <0.326083, -0.708622, 0.412396>, <0.361137, -0.708209, 0.377337>, <0.361132, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208692, -0.673551, 0.336635>, <0.251223, -0.662793, 0.336780>, <0.284972, -0.662867, 0.336775>,
      <0.208618, -0.707297, 0.336163>, <0.208687, -0.672975, 0.295439>, <0.251219, -0.662321, 0.303034>, <0.284968, -0.662395, 0.303029>,
      <0.208618, -0.707297, 0.336163>, <0.208687, -0.672975, 0.295439>, <0.243740, -0.672561, 0.260380>, <0.284939, -0.672651, 0.260374>,
      <0.208618, -0.707297, 0.336163>, <0.208613, -0.706721, 0.294968>, <0.243666, -0.706306, 0.259908>, <0.284865, -0.706397, 0.259902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208623, -0.707874, 0.377359>, <0.243684, -0.708441, 0.412408>, <0.284883, -0.708531, 0.412402>,
      <0.208618, -0.707297, 0.336163>, <0.208697, -0.674127, 0.377830>, <0.243758, -0.674694, 0.412880>, <0.284957, -0.674784, 0.412874>,
      <0.208618, -0.707297, 0.336163>, <0.208697, -0.674127, 0.377830>, <0.251227, -0.663265, 0.370527>, <0.284976, -0.663339, 0.370522>,
      <0.208618, -0.707297, 0.336163>, <0.208692, -0.673551, 0.336635>, <0.251223, -0.662793, 0.336780>, <0.284972, -0.662867, 0.336775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208613, -0.706721, 0.294968>, <0.243666, -0.706306, 0.259908>, <0.284865, -0.706397, 0.259902>,
      <0.208544, -0.741043, 0.335691>, <0.208539, -0.740467, 0.294496>, <0.284866, -0.706397, 0.259902>, <0.326065, -0.706488, 0.259896>,
      <0.251026, -0.751989, 0.335533>, <0.284777, -0.752063, 0.335528>, <0.361053, -0.740803, 0.294473>, <0.361127, -0.707056, 0.294945>,
      <0.284776, -0.752063, 0.335528>, <0.318526, -0.752137, 0.335523>, <0.361058, -0.741379, 0.335669>, <0.361132, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208623, -0.707874, 0.377359>, <0.243684, -0.708441, 0.412408>, <0.284883, -0.708531, 0.412402>,
      <0.208544, -0.741043, 0.335691>, <0.208549, -0.741620, 0.376887>, <0.284883, -0.708531, 0.412402>, <0.326083, -0.708622, 0.412396>,
      <0.251026, -0.751989, 0.335533>, <0.284777, -0.752063, 0.335528>, <0.361063, -0.741955, 0.376865>, <0.361137, -0.708209, 0.377337>,
      <0.284776, -0.752063, 0.335528>, <0.318526, -0.752137, 0.335523>, <0.361058, -0.741379, 0.335669>, <0.361132, -0.707632, 0.336141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208623, -0.707874, 0.377359>, <0.243684, -0.708441, 0.412408>, <0.284883, -0.708531, 0.412402>,
      <0.208618, -0.707297, 0.336163>, <0.208549, -0.741620, 0.376887>, <0.243609, -0.742187, 0.411936>, <0.284809, -0.742278, 0.411930>,
      <0.208618, -0.707297, 0.336163>, <0.208549, -0.741620, 0.376887>, <0.251030, -0.752461, 0.369280>, <0.284780, -0.752535, 0.369275>,
      <0.208618, -0.707297, 0.336163>, <0.208544, -0.741043, 0.335691>, <0.251026, -0.751989, 0.335533>, <0.284776, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208692, -0.673551, 0.336635>, <0.251223, -0.662793, 0.336780>, <0.284972, -0.662867, 0.336775>,
      <0.208544, -0.741043, 0.335691>, <0.208618, -0.707297, 0.336163>, <0.251227, -0.663265, 0.370527>, <0.284976, -0.663339, 0.370522>,
      <0.251026, -0.751989, 0.335533>, <0.251030, -0.752461, 0.369280>, <0.284883, -0.708531, 0.412402>, <0.284957, -0.674784, 0.412874>,
      <0.284776, -0.752063, 0.335528>, <0.284780, -0.752535, 0.369275>, <0.284809, -0.742278, 0.411930>, <0.284883, -0.708531, 0.412402>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208613, -0.706721, 0.294968>, <0.243666, -0.706306, 0.259908>, <0.284865, -0.706397, 0.259902>,
      <0.208618, -0.707297, 0.336163>, <0.208539, -0.740467, 0.294496>, <0.243591, -0.740053, 0.259436>, <0.284791, -0.740144, 0.259430>,
      <0.208618, -0.707297, 0.336163>, <0.208539, -0.740467, 0.294496>, <0.251022, -0.751517, 0.301786>, <0.284772, -0.751591, 0.301781>,
      <0.208618, -0.707297, 0.336163>, <0.208544, -0.741043, 0.335691>, <0.251026, -0.751989, 0.335533>, <0.284776, -0.752063, 0.335528>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.208618, -0.707297, 0.336163>, <0.208544, -0.741043, 0.335691>, <0.251026, -0.751989, 0.335533>, <0.284776, -0.752063, 0.335528>,
      <0.208692, -0.673551, 0.336635>, <0.208618, -0.707297, 0.336163>, <0.251022, -0.751517, 0.301786>, <0.284772, -0.751591, 0.301781>,
      <0.251223, -0.662793, 0.336780>, <0.251219, -0.662321, 0.303034>, <0.284865, -0.706398, 0.259902>, <0.284791, -0.740144, 0.259430>,
      <0.284972, -0.662867, 0.336775>, <0.284968, -0.662395, 0.303029>, <0.284939, -0.672651, 0.260374>, <0.284865, -0.706397, 0.259902>
    }
  }
  texture {
    Parafin
  }
}


#declare sPatchObj = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.824509, 0.124545, -0.485942>, <0.839679, 0.134725, -0.272739>, <0.858228, 0.205398, 0.016639>, <0.875076, 0.158478, 0.224735>,
      <0.802440, 0.094082, -0.302313>, <0.817610, 0.104262, -0.089110>, <0.785742, 0.206684, -0.004925>, <0.802590, 0.159764, 0.203172>,
      <0.788337, 0.219909, -0.060635>, <0.782967, 0.255716, -0.029554>, <0.786216, 0.350914, 0.195682>, <0.790978, 0.313638, 0.225091>,
      <0.772834, 0.260779, 0.121639>, <0.767465, 0.296586, 0.152720>, <0.750174, 0.417411, 0.195835>, <0.754936, 0.380135, 0.225243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.867136, 0.390950, -0.663018>, <0.891156, 0.386683, -0.379381>, <0.926705, 0.442944, 0.006322>, <0.947201, 0.376725, 0.282438>,
      <0.843899, 0.330967, -0.590665>, <0.867918, 0.326699, -0.307028>, <0.865765, 0.411758, -0.012872>, <0.886261, 0.345539, 0.263244>,
      <0.835908, 0.140280, -0.580787>, <0.851078, 0.150460, -0.367584>, <0.926363, 0.204190, 0.036908>, <0.943212, 0.157270, 0.245004>,
      <0.824509, 0.124545, -0.485942>, <0.839679, 0.134725, -0.272739>, <0.858228, 0.205398, 0.016639>, <0.875076, 0.158478, 0.224735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.926991, 0.389084, -0.805034>, <0.971725, 0.350765, -0.477108>, <1.052824, 0.263204, -0.044303>, <1.076105, 0.261353, 0.288051>,
      <0.921386, 0.345921, -0.789432>, <0.966120, 0.307602, -0.461507>, <1.031215, 0.216163, -0.048361>, <1.054496, 0.214312, 0.283993>,
      <0.878234, 0.419598, -0.697573>, <0.902254, 0.415330, -0.413936>, <0.971213, 0.465721, 0.020340>, <0.991709, 0.399502, 0.296456>,
      <0.867136, 0.390950, -0.663018>, <0.891156, 0.386683, -0.379381>, <0.926705, 0.442944, 0.006322>, <0.947201, 0.376725, 0.282438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.901945, 0.658990, -0.759904>, <0.954119, 0.658332, -0.439953>, <1.042922, 0.657300, -0.015901>, <1.075856, 0.656797, 0.306599>,
      <0.895881, 0.606558, -0.696577>, <0.948054, 0.605900, -0.376626>, <1.049702, 0.538988, -0.023713>, <1.082636, 0.538485, 0.298787>,
      <0.936985, 0.466042, -0.832851>, <0.981720, 0.427723, -0.504926>, <1.102248, 0.370795, -0.035021>, <1.125529, 0.368945, 0.297333>,
      <0.926991, 0.389084, -0.805034>, <0.971725, 0.350765, -0.477108>, <1.052824, 0.263204, -0.044303>, <1.076105, 0.261353, 0.288051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.001259, 1.031196, -1.580570>, <1.012250, 1.000264, -1.006777>, <1.035910, 0.939559, -0.242540>, <1.037896, 0.928087, 0.332074>,
      <1.026881, 0.910040, -1.338423>, <1.037872, 0.879107, -0.764630>, <1.069170, 0.866133, -0.224809>, <1.071157, 0.854662, 0.349805>,
      <0.921952, 0.831969, -0.968826>, <0.974126, 0.831311, -0.648875>, <1.038210, 0.739521, -0.010472>, <1.071144, 0.739018, 0.312028>,
      <0.901945, 0.658990, -0.759904>, <0.954119, 0.658332, -0.439953>, <1.042922, 0.657300, -0.015901>, <1.075856, 0.656797, 0.306599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.792629, 1.175901, -1.793018>, <0.800380, 1.190636, -1.204297>, <0.820920, 1.191568, -0.418615>, <0.818464, 1.225017, 0.169386>,
      <0.870569, 1.161742, -1.733110>, <0.878319, 1.176477, -1.144389>, <0.917413, 1.123479, -0.392084>, <0.914957, 1.156929, 0.195916>,
      <0.991903, 1.075439, -1.668995>, <1.002894, 1.044507, -1.095202>, <0.987133, 1.047240, -0.268542>, <0.989119, 1.035769, 0.306071>,
      <1.001259, 1.031196, -1.580570>, <1.012250, 1.000264, -1.006777>, <1.035910, 0.939559, -0.242540>, <1.037896, 0.928087, 0.332074>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.634885, 1.068554, -1.764851>, <0.543534, 1.196628, -1.262266>, <0.409087, 1.330949, -0.464568>, <0.330380, 1.427334, 0.137543>,
      <0.668308, 1.139442, -1.784687>, <0.576956, 1.238316, -1.243169>, <0.496288, 1.331916, -0.331864>, <0.417581, 1.428301, 0.270248>,
      <0.748101, 1.183991, -1.827245>, <0.755852, 1.198725, -1.238524>, <0.694331, 1.280894, -0.453421>, <0.691875, 1.314343, 0.134580>,
      <0.792629, 1.175901, -1.793018>, <0.800380, 1.190636, -1.204297>, <0.820920, 1.191568, -0.418615>, <0.818464, 1.225017, 0.169386>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.450469, -0.133456, -1.583430>, <0.229677, 0.888218, -1.762433>, <-0.211849, 1.147673, -1.791703>, <-0.285504, 1.212775, -1.510659>,
      <0.512349, 0.013453, -1.535754>, <0.291557, 0.937372, -1.683620>, <0.043379, 1.323213, -1.359479>, <-0.030276, 1.388315, -1.078435>,
      <0.561703, 0.987007, -1.772600>, <0.470351, 1.105348, -1.304082>, <0.117071, 1.327711, -0.908965>, <0.038364, 1.424096, -0.306854>,
      <0.634885, 1.068554, -1.764851>, <0.543534, 1.196628, -1.262266>, <0.409087, 1.330949, -0.464568>, <0.330380, 1.427334, 0.137543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.079831, -1.405269, -1.806409>, <-0.087255, -1.001720, -1.572999>, <-0.415996, 0.793583, -1.665353>, <-0.477123, 0.871950, -1.229952>,
      <0.165570, -1.879043, -1.952362>, <-0.001516, -0.284548, -1.520725>, <-0.403661, 0.863055, -1.757272>, <-0.464787, 0.941423, -1.355937>,
      <0.129003, -0.609035, -1.616288>, <0.118753, 0.156795, -1.451593>, <-0.281155, 1.051339, -1.772805>, <-0.354810, 1.165108, -1.628028>,
      <0.450469, -0.133456, -1.583430>, <0.229677, 0.888218, -1.762433>, <-0.211849, 1.147673, -1.791703>, <-0.285504, 1.212775, -1.510659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.021753, -1.346068, -1.816969>, <-0.104059, -0.902567, -1.548390>, <-0.311323, 0.483089, -1.120450>, <-0.397621, 0.581338, -0.365570>,
      <0.017826, -1.335184, -1.789832>, <-0.107986, -0.611783, -1.549079>, <-0.322428, 0.564425, -1.382509>, <-0.408726, 0.662674, -0.627629>,
      <0.034891, -1.711740, -1.932477>, <-0.132195, -0.857865, -1.616377>, <-0.439455, 0.661461, -1.425755>, <-0.500582, 0.739829, -0.990354>,
      <0.079831, -1.405269, -1.806409>, <-0.087255, -1.001720, -1.572999>, <-0.415996, 0.793583, -1.665353>, <-0.477123, 0.871950, -1.229952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105682, -1.989809, -2.021246>, <-0.049423, -0.916070, -1.651083>, <-0.272825, 0.259576, -0.715432>, <-0.411337, 0.390106, 0.322521>,
      <0.103722, -1.792404, -1.941071>, <-0.051384, -0.545823, -1.648334>, <-0.241343, 0.352021, -0.906175>, <-0.379854, 0.482552, 0.131778>,
      <0.025781, -1.751130, -1.946637>, <-0.100032, -1.536660, -1.882735>, <-0.302658, 0.419620, -0.915957>, <-0.388955, 0.517870, -0.161078>,
      <0.021753, -1.346068, -1.816969>, <-0.104059, -0.902567, -1.548390>, <-0.311323, 0.483089, -1.120450>, <-0.397621, 0.581338, -0.365570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.037660, -2.059259, -2.003133>, <-0.124157, -1.242353, -1.689605>, <-0.392943, 0.209208, -0.955213>, <-0.501731, 0.275627, 0.265203>,
      <0.099461, -2.024900, -2.003081>, <-0.062356, -1.456838, -1.874486>, <-0.352770, 0.233173, -0.950480>, <-0.461558, 0.299592, 0.269936>,
      <0.108875, -1.999601, -1.950167>, <-0.046231, -1.102359, -1.754718>, <-0.279733, 0.239292, -0.673581>, <-0.418244, 0.369823, 0.364371>,
      <0.105682, -1.989809, -2.021246>, <-0.049423, -0.916070, -1.651083>, <-0.272825, 0.259576, -0.715432>, <-0.411337, 0.390106, 0.322521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.555187, 0.049007, -0.894926>, <-0.341473, 0.052734, -0.538346>, <-0.423349, 0.151052, -0.052935>, <-0.507307, 0.173000, 0.293675>,
      <-0.507016, -0.503718, -1.625174>, <-0.420109, 0.265586, -1.484995>, <-0.388289, 0.130333, -0.054676>, <-0.511193, 0.150613, 0.291934>,
      <-0.243891, -1.545440, -1.809798>, <-0.405708, -0.517807, -1.512356>, <-0.434003, 0.184713, -0.960050>, <-0.517417, 0.176700, 0.260365>,
      <0.037660, -2.059259, -2.003133>, <-0.124157, -1.242353, -1.689605>, <-0.392943, 0.209208, -0.955213>, <-0.501731, 0.275627, 0.265203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.357087, 0.070663, 0.190579>, <-0.466575, 0.134945, 0.216490>, <-0.285043, 0.151913, 0.199901>, <-0.224857, 0.107370, 0.276948>,
      <-0.539115, 0.107963, -0.135073>, <-0.537020, 0.131670, -0.109162>, <-0.414437, 0.192917, 0.204919>, <-0.354252, 0.148374, 0.281966>,
      <-0.508317, 0.087023, -0.572521>, <-0.330089, 0.090740, -0.215941>, <-0.413890, 0.034899, -0.048014>, <-0.504648, 0.154948, 0.298596>,
      <-0.555187, 0.049007, -0.894926>, <-0.341473, 0.052734, -0.538346>, <-0.423349, 0.151052, -0.052935>, <-0.507307, 0.173000, 0.293675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.904168, -0.097295, 0.497948>, <0.888850, -0.133762, 0.485034>, <0.854947, -0.180980, 0.498304>, <0.833852, -0.216846, 0.498456>,
      <0.921390, -0.060022, 0.393085>, <0.906072, -0.096490, 0.380171>, <0.861509, -0.040342, 0.358550>, <0.840414, -0.076207, 0.358703>,
      <0.883943, 0.133786, 0.334251>, <0.811457, 0.135071, 0.312687>, <0.810776, 0.158673, 0.347349>, <0.774734, 0.225170, 0.347501>,
      <0.875076, 0.158478, 0.224735>, <0.802590, 0.159764, 0.203172>, <0.790978, 0.313638, 0.225091>, <0.754936, 0.380135, 0.225243>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.961329, 0.086630, 0.605926>, <0.945361, 0.025870, 0.584924>, <0.928555, -0.039238, 0.518508>, <0.904168, -0.097295, 0.497948>,
      <0.983352, 0.129030, 0.484570>, <0.967384, 0.068269, 0.463568>, <0.945777, -0.001966, 0.413645>, <0.921390, -0.060022, 0.393085>,
      <0.956591, 0.346389, 0.408935>, <0.895651, 0.315203, 0.389741>, <0.952078, 0.132577, 0.354520>, <0.883943, 0.133786, 0.334251>,
      <0.947201, 0.376725, 0.282438>, <0.886261, 0.345539, 0.263244>, <0.943212, 0.157270, 0.245004>, <0.875076, 0.158478, 0.224735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.029843, 0.380910, 0.663244>, <1.016380, 0.289876, 0.656635>, <0.983570, 0.171258, 0.635178>, <0.961329, 0.086630, 0.605926>,
      <1.058723, 0.365838, 0.548845>, <1.045259, 0.274804, 0.542235>, <1.005593, 0.213658, 0.513823>, <0.983352, 0.129030, 0.484570>,
      <1.084417, 0.260693, 0.406705>, <1.062808, 0.213652, 0.402647>, <1.001099, 0.369165, 0.422953>, <0.956591, 0.346389, 0.408935>,
      <1.076105, 0.261353, 0.288051>, <1.054496, 0.214312, 0.283993>, <0.991709, 0.399502, 0.296456>, <0.947201, 0.376725, 0.282438>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.045655, 0.656797, 0.647323>, <1.048517, 0.574405, 0.657265>, <1.041961, 0.462845, 0.669193>, <1.029843, 0.380910, 0.663244>,
      <1.070620, 0.656797, 0.547788>, <1.073482, 0.574405, 0.557730>, <1.070841, 0.447773, 0.554794>, <1.058723, 0.365838, 0.548845>,
      <1.086282, 0.656638, 0.408686>, <1.093062, 0.538326, 0.400874>, <1.133841, 0.368284, 0.415987>, <1.084417, 0.260693, 0.406705>,
      <1.075856, 0.656797, 0.306599>, <1.082636, 0.538485, 0.298787>, <1.125529, 0.368945, 0.297333>, <1.076105, 0.261353, 0.288051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.008762, 0.987863, 0.590005>, <1.044237, 0.900978, 0.628411>, <1.042161, 0.757410, 0.635182>, <1.045655, 0.656797, 0.647323>,
      <1.029649, 0.987863, 0.512873>, <1.065123, 0.900978, 0.551280>, <1.067126, 0.757410, 0.535648>, <1.070620, 0.656797, 0.547788>,
      <1.038172, 0.926492, 0.411967>, <1.071433, 0.853067, 0.429698>, <1.081570, 0.738859, 0.414115>, <1.086282, 0.656638, 0.408686>,
      <1.037896, 0.928087, 0.332074>, <1.071157, 0.854662, 0.349805>, <1.071144, 0.739018, 0.312028>, <1.075856, 0.656797, 0.306599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.783621, 1.298587, 0.363631>, <0.891875, 1.220990, 0.374733>, <0.962005, 1.102383, 0.539384>, <1.008762, 0.987863, 0.590005>,
      <0.794388, 1.299164, 0.301374>, <0.902642, 1.221567, 0.312476>, <0.982892, 1.102383, 0.462252>, <1.029649, 0.987863, 0.512873>,
      <0.818201, 1.228606, 0.232467>, <0.914693, 1.160518, 0.258998>, <0.989395, 1.034174, 0.385964>, <1.038172, 0.926492, 0.411967>,
      <0.818464, 1.225017, 0.169386>, <0.914957, 1.156929, 0.195916>, <0.989119, 1.035769, 0.306071>, <1.037896, 0.928087, 0.332074>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.323526, 1.479048, 0.519731>, <0.479010, 1.479801, 0.519731>, <0.657685, 1.388860, 0.350716>, <0.783621, 1.298587, 0.363631>,
      <0.324745, 1.471701, 0.404251>, <0.480230, 1.472454, 0.404251>, <0.668452, 1.389437, 0.288459>, <0.794388, 1.299164, 0.301374>,
      <0.315567, 1.445475, 0.250868>, <0.402768, 1.446442, 0.383572>, <0.691611, 1.317932, 0.197661>, <0.818201, 1.228606, 0.232467>,
      <0.330380, 1.427334, 0.137543>, <0.417581, 1.428301, 0.270248>, <0.691875, 1.314343, 0.134580>, <0.818464, 1.225017, 0.169386>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165977, 1.293989, 0.363631>, <-0.036504, 1.393482, 0.350272>, <0.159698, 1.478255, 0.519731>, <0.323526, 1.479048, 0.519731>,
      <-0.218770, 1.292851, -0.197847>, <-0.089297, 1.392343, -0.211206>, <0.160917, 1.470908, 0.404251>, <0.324745, 1.471701, 0.404251>,
      <-0.425016, 1.336088, -0.978328>, <-0.169788, 1.511628, -0.546104>, <0.023551, 1.442237, -0.193529>, <0.315567, 1.445475, 0.250868>,
      <-0.285504, 1.212775, -1.510659>, <-0.030276, 1.388315, -1.078435>, <0.038364, 1.424096, -0.306854>, <0.330380, 1.427334, 0.137543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.357557, 0.955676, 0.590005>, <-0.318411, 1.073816, 0.537784>, <-0.272640, 1.212025, 0.374636>, <-0.165977, 1.293989, 0.363631>,
      <-0.428019, 0.943635, 0.046949>, <-0.388873, 1.061774, -0.005272>, <-0.325434, 1.210886, -0.186842>, <-0.218770, 1.292851, -0.197847>,
      <-0.552093, 0.968065, -0.695947>, <-0.539757, 1.037537, -0.821933>, <-0.494321, 1.288421, -1.095696>, <-0.425016, 1.336088, -0.978328>,
      <-0.477123, 0.871950, -1.229952>, <-0.464787, 0.941423, -1.355937>, <-0.354810, 1.165108, -1.628028>, <-0.285504, 1.212775, -1.510659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.378637, 0.652199, 0.647323>, <-0.371790, 0.744048, 0.635429>, <-0.384492, 0.874388, 0.625937>, <-0.357557, 0.955676, 0.590005>,
      <-0.419143, 0.638303, 0.345684>, <-0.412295, 0.730151, 0.333790>, <-0.454955, 0.862346, 0.082882>, <-0.428019, 0.943635, 0.046949>,
      <-0.431939, 0.620409, -0.065377>, <-0.443043, 0.701745, -0.327436>, <-0.575552, 0.835943, -0.456349>, <-0.552093, 0.968065, -0.695947>,
      <-0.397621, 0.581338, -0.365570>, <-0.408726, 0.662674, -0.627629>, <-0.500582, 0.739829, -0.990354>, <-0.477123, 0.871950, -1.229952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399720, 0.390106, 0.663244>, <-0.403510, 0.468817, 0.669199>, <-0.384464, 0.574041, 0.657444>, <-0.378637, 0.652199, 0.647323>,
      <-0.423071, 0.390106, 0.563669>, <-0.426861, 0.468817, 0.569624>, <-0.424969, 0.560144, 0.355805>, <-0.419143, 0.638303, 0.345684>,
      <-0.424761, 0.402757, 0.423120>, <-0.393279, 0.495203, 0.232377>, <-0.423273, 0.556941, 0.139115>, <-0.431939, 0.620409, -0.065377>,
      <-0.411337, 0.390106, 0.322521>, <-0.379854, 0.482552, 0.131778>, <-0.388955, 0.517870, -0.161078>, <-0.397621, 0.581338, -0.365570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352287, 0.105023, 0.605926>, <-0.370289, 0.186975, 0.633719>, <-0.395480, 0.302070, 0.656584>, <-0.399720, 0.390106, 0.663244>,
      <-0.396084, 0.127661, 0.493466>, <-0.414086, 0.209613, 0.521259>, <-0.418831, 0.302070, 0.557009>, <-0.423071, 0.390106, 0.563669>,
      <-0.284316, 0.190954, 0.387331>, <-0.472445, 0.306239, 0.392064>, <-0.431669, 0.382474, 0.464970>, <-0.424761, 0.402757, 0.423120>,
      <-0.501731, 0.275627, 0.265203>, <-0.461558, 0.299592, 0.269936>, <-0.418244, 0.369823, 0.364371>, <-0.411337, 0.390106, 0.322521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.292654, -0.097295, 0.497948>, <-0.331090, -0.039636, 0.482090>, <-0.337809, 0.039114, 0.583574>, <-0.352287, 0.105023, 0.605926>,
      <-0.384853, -0.036202, 0.380042>, <-0.423289, 0.021456, 0.364183>, <-0.381606, 0.061751, 0.471114>, <-0.396084, 0.127661, 0.493466>,
      <-0.514004, 0.166782, 0.449321>, <-0.502604, 0.162965, 0.447580>, <-0.482629, 0.176580, 0.382493>, <-0.284316, 0.190954, 0.387331>,
      <-0.507307, 0.173000, 0.293675>, <-0.511193, 0.150613, 0.291934>, <-0.517417, 0.176700, 0.260365>, <-0.501731, 0.275627, 0.265203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.195037, -0.130872, 0.670807>, <-0.224322, -0.120799, 0.618949>, <-0.259995, -0.146286, 0.511423>, <-0.292654, -0.097295, 0.497948>,
      <-0.227179, -0.061731, 0.555325>, <-0.256464, -0.051658, 0.503468>, <-0.352195, -0.085194, 0.393517>, <-0.384853, -0.036202, 0.380042>,
      <-0.147336, 0.049997, 0.376187>, <-0.276731, 0.091001, 0.381205>, <-0.501195, 0.153805, 0.454242>, <-0.514004, 0.166782, 0.449321>,
      <-0.224857, 0.107370, 0.276948>, <-0.354252, 0.148374, 0.281966>, <-0.504648, 0.154948, 0.298596>, <-0.507307, 0.173000, 0.293675>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752646, -0.106491, 0.970204>, <0.743438, -0.146733, 0.931181>, <0.734751, -0.183739, 0.863987>, <0.727081, -0.216846, 0.818466>,
      <0.828480, -0.104733, 0.842171>, <0.819272, -0.144976, 0.803148>, <0.791226, -0.183739, 0.780004>, <0.783556, -0.216846, 0.734483>,
      <0.881410, -0.146549, 0.636521>, <0.866092, -0.183017, 0.623606>, <0.851599, -0.252730, 0.569601>, <0.830504, -0.288595, 0.569754>,
      <0.904168, -0.097295, 0.497948>, <0.888850, -0.133762, 0.485034>, <0.854947, -0.180980, 0.498304>, <0.833852, -0.216846, 0.498456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.796520, 0.086630, 1.112746>, <0.783849, 0.021187, 1.082494>, <0.764512, -0.054634, 1.020489>, <0.752646, -0.106491, 0.970204>,
      <0.883101, 0.083123, 0.978381>, <0.870430, 0.017680, 0.948129>, <0.840345, -0.052877, 0.892456>, <0.828480, -0.104733, 0.842171>,
      <0.934331, 0.034653, 0.754695>, <0.918363, -0.026107, 0.733692>, <0.905797, -0.088492, 0.657080>, <0.881410, -0.146549, 0.636521>,
      <0.961329, 0.086630, 0.605926>, <0.945361, 0.025870, 0.584924>, <0.928555, -0.039238, 0.518508>, <0.904168, -0.097295, 0.497948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.847017, 0.380910, 1.195512>, <0.836999, 0.289003, 1.185877>, <0.812610, 0.169730, 1.151160>, <0.796520, 0.086630, 1.112746>,
      <0.946700, 0.380910, 1.059242>, <0.936681, 0.289003, 1.049606>, <0.899191, 0.166222, 1.016795>, <0.883101, 0.083123, 0.978381>,
      <0.988850, 0.402304, 0.825626>, <0.975386, 0.311270, 0.819017>, <0.956572, 0.119281, 0.783947>, <0.934331, 0.034653, 0.754695>,
      <1.029843, 0.380910, 0.663244>, <1.016380, 0.289876, 0.656635>, <0.983570, 0.171258, 0.635178>, <0.961329, 0.086630, 0.605926>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.858670, 0.656797, 1.172522>, <0.860991, 0.575088, 1.187628>, <0.855976, 0.463102, 1.204129>, <0.847017, 0.380910, 1.195512>,
      <0.959867, 0.651719, 1.039461>, <0.962187, 0.570010, 1.054567>, <0.955659, 0.463102, 1.067859>, <0.946700, 0.380910, 1.059242>,
      <1.004967, 0.656797, 0.809546>, <1.007829, 0.574405, 0.819488>, <1.000968, 0.484239, 0.831575>, <0.988850, 0.402304, 0.825626>,
      <1.045655, 0.656797, 0.647323>, <1.048517, 0.574405, 0.657265>, <1.041961, 0.462845, 0.669193>, <1.029843, 0.380910, 0.663244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.831479, 0.928087, 1.094354>, <0.855267, 0.852063, 1.124265>, <0.856295, 0.740437, 1.157059>, <0.858670, 0.656797, 1.172522>,
      <0.925666, 0.939205, 0.963784>, <0.949453, 0.863180, 0.993695>, <0.957492, 0.735359, 1.023999>, <0.959867, 0.651719, 1.039461>,
      <0.966582, 0.987863, 0.745775>, <1.002056, 0.900978, 0.784181>, <1.001473, 0.757410, 0.797405>, <1.004967, 0.656797, 0.809546>,
      <1.008762, 0.987863, 0.590005>, <1.044237, 0.900978, 0.628411>, <1.042161, 0.757410, 0.635182>, <1.045655, 0.656797, 0.647323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.683146, 1.217768, 0.951812>, <0.746664, 1.150958, 1.005320>, <0.801681, 1.023321, 1.056885>, <0.831479, 0.928087, 1.094354>,
      <0.735213, 1.247263, 0.781367>, <0.798730, 1.180453, 0.834875>, <0.895868, 1.034438, 0.926315>, <0.925666, 0.939205, 0.963784>,
      <0.752838, 1.296938, 0.541626>, <0.861091, 1.219341, 0.552728>, <0.919825, 1.102383, 0.695153>, <0.966582, 0.987863, 0.745775>,
      <0.783621, 1.298587, 0.363631>, <0.891875, 1.220990, 0.374733>, <0.962005, 1.102383, 0.539384>, <1.008762, 0.987863, 0.590005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324785, 1.461052, 0.667504>, <0.480219, 1.461052, 0.667504>, <0.590522, 1.315195, 0.873783>, <0.683146, 1.217768, 0.951812>,
      <0.324172, 1.470258, 0.623806>, <0.479605, 1.470258, 0.623806>, <0.642589, 1.344690, 0.703338>, <0.735213, 1.247263, 0.781367>,
      <0.323056, 1.481884, 0.564299>, <0.478540, 1.482637, 0.564299>, <0.626901, 1.387211, 0.528711>, <0.752838, 1.296938, 0.541626>,
      <0.323526, 1.479048, 0.519731>, <0.479010, 1.479801, 0.519731>, <0.657685, 1.388860, 0.350716>, <0.783621, 1.298587, 0.363631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.053968, 1.217768, 0.951812>, <0.040115, 1.318854, 0.871546>, <0.165059, 1.461052, 0.667504>, <0.324785, 1.461052, 0.667504>,
      <-0.105159, 1.246411, 0.780502>, <-0.011077, 1.347496, 0.700236>, <0.164445, 1.470258, 0.623806>, <0.324172, 1.470258, 0.623806>,
      <-0.149026, 1.294355, 0.543910>, <-0.019553, 1.393847, 0.530551>, <0.159227, 1.481091, 0.564299>, <0.323056, 1.481884, 0.564299>,
      <-0.165977, 1.293989, 0.363631>, <-0.036504, 1.393482, 0.350272>, <0.159698, 1.478255, 0.519731>, <0.323526, 1.479048, 0.519731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.175540, 0.923489, 1.094354>, <-0.152485, 1.018589, 1.057242>, <-0.115613, 1.151535, 1.004404>, <-0.053968, 1.217768, 0.951812>,
      <-0.264955, 0.928754, 0.960394>, <-0.241900, 1.023853, 0.923282>, <-0.166804, 1.180178, 0.833094>, <-0.105159, 1.246411, 0.780502>,
      <-0.336827, 0.959219, 0.749773>, <-0.297681, 1.077358, 0.697552>, <-0.255689, 1.212391, 0.554916>, <-0.149026, 1.294355, 0.543910>,
      <-0.357557, 0.955676, 0.590005>, <-0.318411, 1.073816, 0.537784>, <-0.272640, 1.212025, 0.374636>, <-0.165977, 1.293989, 0.363631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.191077, 0.652199, 1.172522>, <-0.186229, 0.735404, 1.156742>, <-0.194226, 0.846408, 1.124435>, <-0.175540, 0.923489, 1.094354>,
      <-0.288786, 0.646159, 1.036847>, <-0.283939, 0.729363, 1.021068>, <-0.283641, 0.851673, 0.990475>, <-0.264955, 0.928754, 0.960394>,
      <-0.356393, 0.659831, 0.812968>, <-0.349546, 0.751679, 0.801074>, <-0.363762, 0.877930, 0.785705>, <-0.336827, 0.959219, 0.749773>,
      <-0.378637, 0.652199, 0.647323>, <-0.371790, 0.744048, 0.635429>, <-0.384492, 0.874388, 0.625937>, <-0.357557, 0.955676, 0.590005>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.206615, 0.390106, 1.195512>, <-0.209403, 0.468657, 1.204093>, <-0.195595, 0.574644, 1.187231>, <-0.191077, 0.652199, 1.172522>,
      <-0.307836, 0.391825, 1.059111>, <-0.310624, 0.470376, 1.067692>, <-0.293304, 0.568603, 1.051556>, <-0.288786, 0.646159, 1.036847>,
      <-0.360938, 0.390106, 0.828622>, <-0.364728, 0.468817, 0.834577>, <-0.362220, 0.581672, 0.823089>, <-0.356393, 0.659831, 0.812968>,
      <-0.399720, 0.390106, 0.663244>, <-0.403510, 0.468817, 0.669199>, <-0.384464, 0.574041, 0.657444>, <-0.378637, 0.652199, 0.647323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171656, 0.105023, 1.112746>, <-0.184588, 0.185830, 1.149408>, <-0.203453, 0.301020, 1.185780>, <-0.206615, 0.390106, 1.195512>,
      <-0.262889, 0.105023, 0.979588>, <-0.275821, 0.185830, 1.016251>, <-0.304674, 0.302739, 1.049379>, <-0.307836, 0.391825, 1.059111>,
      <-0.294714, 0.075266, 0.753758>, <-0.312716, 0.157218, 0.781551>, <-0.356698, 0.302070, 0.821962>, <-0.360938, 0.390106, 0.828622>,
      <-0.352287, 0.105023, 0.605926>, <-0.370289, 0.186975, 0.633719>, <-0.395480, 0.302070, 0.656584>, <-0.399720, 0.390106, 0.663244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.127142, -0.106491, 0.970204>, <-0.144092, -0.050546, 1.021354>, <-0.160454, 0.035028, 1.080989>, <-0.171656, 0.105023, 1.112746>,
      <-0.207308, -0.104748, 0.843256>, <-0.224259, -0.048803, 0.894406>, <-0.251687, 0.035028, 0.947831>, <-0.262889, 0.105023, 0.979588>,
      <-0.207019, -0.154037, 0.607458>, <-0.245455, -0.096378, 0.591600>, <-0.280236, 0.009356, 0.731406>, <-0.294714, 0.075266, 0.753758>,
      <-0.292654, -0.097295, 0.497948>, <-0.331090, -0.039636, 0.482090>, <-0.337809, 0.039114, 0.583574>, <-0.352287, 0.105023, 0.605926>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.074135, -0.216846, 0.818466>, <-0.090037, -0.183739, 0.863987>, <-0.114378, -0.148618, 0.931688>, <-0.127142, -0.106491, 0.970204>,
      <-0.118584, -0.205104, 0.775693>, <-0.134486, -0.171998, 0.821215>, <-0.194544, -0.146875, 0.804740>, <-0.207308, -0.104748, 0.843256>,
      <-0.180451, -0.162246, 0.723209>, <-0.209737, -0.152173, 0.671352>, <-0.174361, -0.203028, 0.620933>, <-0.207019, -0.154037, 0.607458>,
      <-0.195037, -0.130872, 0.670807>, <-0.224322, -0.120799, 0.618949>, <-0.259995, -0.146286, 0.511423>, <-0.292654, -0.097295, 0.497948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.507345, -0.106491, 1.167922>, <0.507345, -0.151667, 1.122100>, <0.507345, -0.183739, 1.039175>, <0.507345, -0.216846, 0.983998>,
      <0.589888, -0.106491, 1.121872>, <0.589888, -0.151667, 1.076050>, <0.581064, -0.183739, 1.002066>, <0.581064, -0.216846, 0.946889>,
      <0.704481, -0.107607, 1.051523>, <0.695273, -0.147849, 1.012500>, <0.688696, -0.183739, 0.932475>, <0.681026, -0.216846, 0.886954>,
      <0.752646, -0.106491, 0.970204>, <0.743438, -0.146733, 0.931181>, <0.734751, -0.183739, 0.863987>, <0.727081, -0.216846, 0.818466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.507345, 0.105023, 1.310465>, <0.508982, 0.035583, 1.278365>, <0.507345, -0.052769, 1.222411>, <0.507345, -0.106491, 1.167922>,
      <0.601525, 0.100674, 1.263710>, <0.603162, 0.031233, 1.231610>, <0.589888, -0.052769, 1.176361>, <0.589888, -0.106491, 1.121872>,
      <0.739532, 0.088939, 1.201187>, <0.726861, 0.023496, 1.170935>, <0.716347, -0.055750, 1.101808>, <0.704481, -0.107607, 1.051523>,
      <0.796520, 0.086630, 1.112746>, <0.783849, 0.021187, 1.082494>, <0.764512, -0.054634, 1.020489>, <0.752646, -0.106491, 0.970204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.495854, 0.380910, 1.393230>, <0.497560, 0.294905, 1.384356>, <0.505495, 0.183503, 1.346743>, <0.507345, 0.105023, 1.310465>,
      <0.606683, 0.380910, 1.344921>, <0.608388, 0.294905, 1.336047>, <0.599675, 0.179154, 1.299989>, <0.601525, 0.100674, 1.263710>,
      <0.775638, 0.380910, 1.293091>, <0.765619, 0.289003, 1.283456>, <0.755622, 0.172039, 1.239601>, <0.739532, 0.088939, 1.201187>,
      <0.847017, 0.380910, 1.195512>, <0.836999, 0.289003, 1.185877>, <0.812610, 0.169730, 1.151160>, <0.796520, 0.086630, 1.112746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.495854, 0.684386, 1.370240>, <0.494792, 0.594610, 1.386837>, <0.494053, 0.471714, 1.402599>, <0.495854, 0.380910, 1.393230>,
      <0.610021, 0.677616, 1.321722>, <0.608959, 0.587840, 1.338319>, <0.604882, 0.471714, 1.354289>, <0.606683, 0.380910, 1.344921>,
      <0.783500, 0.660569, 1.271361>, <0.785820, 0.578860, 1.286467>, <0.784597, 0.463102, 1.301708>, <0.775638, 0.380910, 1.293091>,
      <0.858670, 0.656797, 1.172522>, <0.860991, 0.575088, 1.187628>, <0.855976, 0.463102, 1.204129>, <0.847017, 0.380910, 1.195512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.502328, 0.928087, 1.292073>, <0.495401, 0.858637, 1.324127>, <0.496748, 0.759905, 1.356279>, <0.495854, 0.684386, 1.370240>,
      <0.604488, 0.928087, 1.238854>, <0.597561, 0.858637, 1.270907>, <0.610915, 0.753135, 1.307760>, <0.610021, 0.677616, 1.321722>,
      <0.764250, 0.920152, 1.187554>, <0.788038, 0.844127, 1.217465>, <0.781125, 0.744209, 1.255899>, <0.783500, 0.660569, 1.271361>,
      <0.831479, 0.928087, 1.094354>, <0.855267, 0.852063, 1.124265>, <0.856295, 0.740437, 1.157059>, <0.858670, 0.656797, 1.172522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.543549, 1.162591, 1.149530>, <0.565567, 1.102254, 1.202497>, <0.509837, 1.003369, 1.257328>, <0.502328, 0.928087, 1.292073>,
      <0.591064, 1.181606, 1.095429>, <0.613082, 1.121269, 1.148396>, <0.611997, 1.003369, 1.204108>, <0.604488, 0.928087, 1.238854>,
      <0.661681, 1.205609, 1.022080>, <0.725199, 1.138798, 1.075588>, <0.734452, 1.015386, 1.150085>, <0.764250, 0.920152, 1.187554>,
      <0.683146, 1.217768, 0.951812>, <0.746664, 1.150958, 1.005320>, <0.801681, 1.023321, 1.056885>, <0.831479, 0.928087, 1.094354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328500, 1.404437, 0.873909>, <0.456028, 1.404437, 0.873909>, <0.509821, 1.255017, 1.068394>, <0.543549, 1.162591, 1.149530>,
      <0.327980, 1.429764, 0.814898>, <0.455507, 1.429764, 0.814898>, <0.557337, 1.274032, 1.014293>, <0.591064, 1.181606, 1.095429>,
      <0.325668, 1.447816, 0.730337>, <0.481101, 1.447816, 0.730337>, <0.569057, 1.303035, 0.944051>, <0.661681, 1.205609, 1.022080>,
      <0.324785, 1.461052, 0.667504>, <0.480219, 1.461052, 0.667504>, <0.590522, 1.315195, 0.873783>, <0.683146, 1.217768, 0.951812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.068869, 1.162591, 1.149530>, <0.112606, 1.258405, 1.065420>, <0.193712, 1.404437, 0.873909>, <0.328500, 1.404437, 0.873909>,
      <0.022390, 1.179034, 1.097380>, <0.066127, 1.274848, 1.013270>, <0.193191, 1.429764, 0.814898>, <0.327980, 1.429764, 0.814898>,
      <-0.033679, 1.206417, 1.019708>, <0.060404, 1.307502, 0.939441>, <0.165941, 1.447816, 0.730337>, <0.325668, 1.447816, 0.730337>,
      <-0.053968, 1.217768, 0.951812>, <0.040115, 1.318854, 0.871546>, <0.165059, 1.461052, 0.667504>, <0.324785, 1.461052, 0.667504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.111057, 0.928087, 1.292073>, <0.099603, 1.002998, 1.257499>, <0.041841, 1.103381, 1.201508>, <0.068869, 1.162591, 1.149530>,
      <0.019798, 0.930041, 1.241273>, <0.008344, 1.004952, 1.206698>, <-0.004639, 1.119823, 1.149358>, <0.022390, 1.179034, 1.097380>,
      <-0.117576, 0.920077, 1.181194>, <-0.094521, 1.015177, 1.144082>, <-0.095324, 1.140184, 1.072300>, <-0.033679, 1.206417, 1.019708>,
      <-0.175540, 0.923489, 1.094354>, <-0.152485, 1.018589, 1.057242>, <-0.115613, 1.151535, 1.004404>, <-0.053968, 1.217768, 0.951812>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141989, 0.684386, 1.370240>, <0.137697, 0.760318, 1.356202>, <0.121692, 0.858535, 1.324174>, <0.111057, 0.928087, 1.292073>,
      <0.036004, 0.676576, 1.322265>, <0.031711, 0.752508, 1.308227>, <0.030433, 0.860489, 1.273374>, <0.019798, 0.930041, 1.241273>,
      <-0.122981, 0.656409, 1.267077>, <-0.118133, 0.739614, 1.251297>, <-0.136262, 0.842996, 1.211275>, <-0.117576, 0.920077, 1.181194>,
      <-0.191077, 0.652199, 1.172522>, <-0.186229, 0.735404, 1.156742>, <-0.194226, 0.846408, 1.124435>, <-0.175540, 0.923489, 1.094354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141989, 0.380910, 1.393230>, <0.143801, 0.471714, 1.402599>, <0.147057, 0.594742, 1.386812>, <0.141989, 0.684386, 1.370240>,
      <0.031813, 0.383150, 1.345071>, <0.033625, 0.473954, 1.354439>, <0.041072, 0.586932, 1.338837>, <0.036004, 0.676576, 1.322265>,
      <-0.134951, 0.388890, 1.292083>, <-0.137739, 0.467441, 1.300664>, <-0.127499, 0.578854, 1.281786>, <-0.122981, 0.656409, 1.267077>,
      <-0.206615, 0.390106, 1.195512>, <-0.209403, 0.468657, 1.204093>, <-0.195595, 0.574644, 1.187231>, <-0.191077, 0.652199, 1.172522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130430, 0.105023, 1.310465>, <0.132291, 0.183504, 1.346744>, <0.140273, 0.294904, 1.384356>, <0.141989, 0.380910, 1.393230>,
      <0.032756, 0.105023, 1.263655>, <0.034617, 0.183504, 1.299934>, <0.030097, 0.297144, 1.336197>, <0.031813, 0.383150, 1.345071>,
      <-0.110437, 0.105023, 1.202097>, <-0.123369, 0.185830, 1.238759>, <-0.131789, 0.299804, 1.282351>, <-0.134951, 0.388890, 1.292083>,
      <-0.171656, 0.105023, 1.112746>, <-0.184588, 0.185830, 1.149408>, <-0.203453, 0.301020, 1.185780>, <-0.206615, 0.390106, 1.195512>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130430, -0.106491, 1.167922>, <0.130430, -0.052769, 1.222411>, <0.128783, 0.035583, 1.278365>, <0.130430, 0.105023, 1.310465>,
      <0.044616, -0.106491, 1.121823>, <0.044616, -0.052769, 1.176312>, <0.031109, 0.035583, 1.231556>, <0.032756, 0.105023, 1.263655>,
      <-0.075133, -0.107621, 1.052563>, <-0.092083, -0.051676, 1.103712>, <-0.099235, 0.035028, 1.170340>, <-0.110437, 0.105023, 1.202097>,
      <-0.127142, -0.106491, 0.970204>, <-0.144092, -0.050546, 1.021354>, <-0.160454, 0.035028, 1.080989>, <-0.171656, 0.105023, 1.112746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130430, -0.216846, 0.983998>, <0.130430, -0.183739, 1.039175>, <0.130430, -0.151667, 1.122100>, <0.130430, -0.106491, 1.167922>,
      <0.060545, -0.216846, 0.947279>, <0.060545, -0.183739, 1.002456>, <0.044616, -0.151667, 1.076001>, <0.044616, -0.106491, 1.121823>,
      <-0.018253, -0.231607, 0.872240>, <-0.034155, -0.198501, 0.917761>, <-0.062369, -0.149748, 1.014047>, <-0.075133, -0.107621, 1.052563>,
      <-0.074135, -0.216846, 0.818466>, <-0.090037, -0.183739, 0.863987>, <-0.114378, -0.148618, 0.931688>, <-0.127142, -0.106491, 0.970204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.398245, -0.106491, 1.167922>, <0.398245, -0.151667, 1.122100>, <0.398245, -0.183739, 1.039175>, <0.398245, -0.216846, 0.983998>,
      <0.427875, -0.106491, 1.181827>, <0.427875, -0.151667, 1.136005>, <0.429626, -0.183739, 1.048477>, <0.429626, -0.216846, 0.993299>,
      <0.478763, -0.106491, 1.183868>, <0.478763, -0.151667, 1.138046>, <0.478110, -0.183739, 1.053892>, <0.478110, -0.216846, 0.998714>,
      <0.507345, -0.106491, 1.167922>, <0.507345, -0.151667, 1.122100>, <0.507345, -0.183739, 1.039175>, <0.507345, -0.216846, 0.983998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.398245, 0.105023, 1.310465>, <0.398932, 0.035569, 1.278359>, <0.398245, -0.052769, 1.222411>, <0.398245, -0.106491, 1.167922>,
      <0.427875, 0.105023, 1.324370>, <0.428561, 0.035569, 1.292264>, <0.427875, -0.052769, 1.236316>, <0.427875, -0.106491, 1.181827>,
      <0.478054, 0.106376, 1.325006>, <0.479691, 0.036935, 1.292906>, <0.478763, -0.052769, 1.238357>, <0.478763, -0.106491, 1.183868>,
      <0.507345, 0.105023, 1.310465>, <0.508982, 0.035583, 1.278365>, <0.507345, -0.052769, 1.222411>, <0.507345, -0.106491, 1.167922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.393426, 0.380910, 1.393230>, <0.394141, 0.294947, 1.384361>, <0.397470, 0.183466, 1.346726>, <0.398245, 0.105023, 1.310465>,
      <0.420912, 0.380910, 1.406969>, <0.421627, 0.294947, 1.398100>, <0.427099, 0.183466, 1.360632>, <0.427875, 0.105023, 1.324370>,
      <0.467686, 0.380910, 1.405509>, <0.469391, 0.294905, 1.396635>, <0.476204, 0.184856, 1.361285>, <0.478054, 0.106376, 1.325006>,
      <0.495854, 0.380910, 1.393230>, <0.497560, 0.294905, 1.384356>, <0.505495, 0.183503, 1.346743>, <0.507345, 0.105023, 1.310465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.393426, 0.684386, 1.370240>, <0.395431, 0.593730, 1.380905>, <0.392671, 0.471729, 1.402600>, <0.393426, 0.380910, 1.393230>,
      <0.420912, 0.684386, 1.383979>, <0.422917, 0.593730, 1.394645>, <0.420157, 0.471729, 1.416340>, <0.420912, 0.380910, 1.406969>,
      <0.467616, 0.686061, 1.382241>, <0.466554, 0.596285, 1.398838>, <0.465885, 0.471714, 1.414877>, <0.467686, 0.380910, 1.405509>,
      <0.495854, 0.684386, 1.370240>, <0.494792, 0.594610, 1.386837>, <0.494053, 0.471714, 1.402599>, <0.495854, 0.380910, 1.393230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.381326, 0.928087, 1.328858>, <0.376152, 0.856929, 1.349405>, <0.391796, 0.758106, 1.361567>, <0.393426, 0.684386, 1.370240>,
      <0.415578, 0.928087, 1.345177>, <0.410404, 0.856929, 1.365724>, <0.419282, 0.758106, 1.375307>, <0.420912, 0.684386, 1.383979>,
      <0.468679, 0.928087, 1.309602>, <0.461753, 0.858637, 1.341656>, <0.468509, 0.761580, 1.368280>, <0.467616, 0.686061, 1.382241>,
      <0.502328, 0.928087, 1.292073>, <0.495401, 0.858637, 1.324127>, <0.496748, 0.759905, 1.356279>, <0.495854, 0.684386, 1.370240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.424691, 1.114340, 1.246091>, <0.433110, 1.060897, 1.277409>, <0.385683, 0.988001, 1.311558>, <0.381326, 0.928087, 1.328858>,
      <0.469511, 1.114340, 1.263735>, <0.477930, 1.060897, 1.295053>, <0.419935, 0.988001, 1.327877>, <0.415578, 0.928087, 1.345177>,
      <0.512817, 1.150293, 1.184522>, <0.534835, 1.089956, 1.237489>, <0.476188, 1.003369, 1.274857>, <0.468679, 0.928087, 1.309602>,
      <0.543549, 1.162591, 1.149530>, <0.565567, 1.102254, 1.202497>, <0.509837, 1.003369, 1.257328>, <0.502328, 0.928087, 1.292073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.328900, 1.260912, 1.133825>, <0.391226, 1.258212, 1.132475>, <0.416288, 1.167687, 1.214830>, <0.424691, 1.114340, 1.246091>,
      <0.332008, 1.338440, 1.090077>, <0.394334, 1.335740, 1.088727>, <0.461108, 1.167687, 1.232475>, <0.469511, 1.114340, 1.263735>,
      <0.329223, 1.369308, 0.955759>, <0.456750, 1.369308, 0.955759>, <0.479089, 1.242719, 1.103386>, <0.512817, 1.150293, 1.184522>,
      <0.328500, 1.404437, 0.873909>, <0.456028, 1.404437, 0.873909>, <0.509821, 1.255017, 1.068394>, <0.543549, 1.162591, 1.149530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.212410, 1.123536, 1.250689>, <0.224267, 1.178399, 1.219091>, <0.264563, 1.263699, 1.135218>, <0.328900, 1.260912, 1.133825>,
      <0.161475, 1.123536, 1.268527>, <0.173332, 1.178399, 1.236929>, <0.267671, 1.341227, 1.091471>, <0.332008, 1.338440, 1.090077>,
      <0.103822, 1.150227, 1.188748>, <0.147559, 1.246041, 1.104637>, <0.194434, 1.369308, 0.955759>, <0.329223, 1.369308, 0.955759>,
      <0.068869, 1.162591, 1.149530>, <0.112606, 1.258405, 1.065420>, <0.193712, 1.404437, 0.873909>, <0.328500, 1.404437, 0.873909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.253987, 0.914293, 1.333456>, <0.248978, 0.980354, 1.315472>, <0.199773, 1.065066, 1.284365>, <0.212410, 1.123536, 1.250689>,
      <0.212721, 0.914293, 1.350976>, <0.207711, 0.980354, 1.332992>, <0.148838, 1.065066, 1.302202>, <0.161475, 1.123536, 1.268527>,
      <0.150222, 0.927249, 1.313875>, <0.138768, 1.002159, 1.279301>, <0.076794, 1.091016, 1.240725>, <0.103822, 1.150227, 1.188748>,
      <0.111057, 0.928087, 1.292073>, <0.099603, 1.002998, 1.257499>, <0.041841, 1.103381, 1.201508>, <0.068869, 1.162591, 1.149530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.245713, 0.684386, 1.370240>, <0.246791, 0.753837, 1.362457>, <0.259088, 0.847034, 1.351766>, <0.253987, 0.914293, 1.333456>,
      <0.217821, 0.684386, 1.384036>, <0.218899, 0.753837, 1.376253>, <0.217822, 0.847034, 1.369286>, <0.212721, 0.914293, 1.350976>,
      <0.170274, 0.686471, 1.383043>, <0.165981, 0.762403, 1.369006>, <0.160857, 0.857696, 1.345976>, <0.150222, 0.927249, 1.313875>,
      <0.141989, 0.684386, 1.370240>, <0.137697, 0.760318, 1.356202>, <0.121692, 0.858535, 1.324174>, <0.111057, 0.928087, 1.292073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.245713, 0.380910, 1.393230>, <0.246466, 0.471729, 1.402600>, <0.244306, 0.593661, 1.380407>, <0.245713, 0.684386, 1.370240>,
      <0.217821, 0.380910, 1.407026>, <0.218574, 0.471729, 1.416396>, <0.216414, 0.593661, 1.394203>, <0.217821, 0.684386, 1.384036>,
      <0.170497, 0.380331, 1.405691>, <0.172308, 0.471134, 1.415059>, <0.175341, 0.596827, 1.399616>, <0.170274, 0.686471, 1.383043>,
      <0.141989, 0.380910, 1.393230>, <0.143801, 0.471714, 1.402599>, <0.147057, 0.594742, 1.386812>, <0.141989, 0.684386, 1.370240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240910, 0.105023, 1.310465>, <0.241683, 0.183466, 1.346726>, <0.245001, 0.294947, 1.384361>, <0.245713, 0.380910, 1.393230>,
      <0.210849, 0.105023, 1.324425>, <0.211622, 0.183466, 1.360686>, <0.217109, 0.294947, 1.398157>, <0.217821, 0.380910, 1.407026>,
      <0.160319, 0.105023, 1.324789>, <0.162180, 0.183504, 1.361068>, <0.168781, 0.294325, 1.396817>, <0.170497, 0.380331, 1.405691>,
      <0.130430, 0.105023, 1.310465>, <0.132291, 0.183504, 1.346744>, <0.140273, 0.294904, 1.384356>, <0.141989, 0.380910, 1.393230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240910, -0.106491, 1.167922>, <0.240910, -0.052769, 1.222411>, <0.240226, 0.035569, 1.278359>, <0.240910, 0.105023, 1.310465>,
      <0.210849, -0.106491, 1.181882>, <0.210849, -0.052769, 1.236371>, <0.210165, 0.035569, 1.292319>, <0.210849, 0.105023, 1.324425>,
      <0.159628, -0.106491, 1.183607>, <0.159628, -0.052769, 1.238096>, <0.158672, 0.035583, 1.292689>, <0.160319, 0.105023, 1.324789>,
      <0.130430, -0.106491, 1.167922>, <0.130430, -0.052769, 1.222411>, <0.128783, 0.035583, 1.278365>, <0.130430, 0.105023, 1.310465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.240910, -0.216846, 0.983998>, <0.240910, -0.183739, 1.039175>, <0.240910, -0.151667, 1.122100>, <0.240910, -0.106491, 1.167922>,
      <0.209106, -0.216846, 0.993326>, <0.209106, -0.183739, 1.048503>, <0.210849, -0.151667, 1.136060>, <0.210849, -0.106491, 1.181882>,
      <0.159771, -0.216846, 0.999414>, <0.159771, -0.183739, 1.054591>, <0.159628, -0.151667, 1.137785>, <0.159628, -0.106491, 1.183607>,
      <0.130430, -0.216846, 0.983998>, <0.130430, -0.183739, 1.039175>, <0.130430, -0.151667, 1.122100>, <0.130430, -0.106491, 1.167922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321189, -0.106491, 1.080559>, <0.321189, -0.148032, 1.042578>, <0.321189, -0.183739, 0.974342>, <0.321189, -0.216846, 0.928820>,
      <0.344306, -0.106491, 1.106768>, <0.344306, -0.148032, 1.068787>, <0.344306, -0.183739, 0.990895>, <0.344306, -0.216846, 0.945373>,
      <0.366609, -0.106491, 1.153075>, <0.366609, -0.151667, 1.107253>, <0.370985, -0.183739, 1.031095>, <0.370985, -0.216846, 0.975918>,
      <0.398245, -0.106491, 1.167922>, <0.398245, -0.151667, 1.122100>, <0.398245, -0.183739, 1.039175>, <0.398245, -0.216846, 0.983998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321189, 0.105023, 1.223100>, <0.321204, 0.035567, 1.190993>, <0.321189, -0.050018, 1.132191>, <0.321189, -0.106491, 1.080559>,
      <0.344306, 0.105023, 1.249309>, <0.344321, 0.035567, 1.217202>, <0.344306, -0.050018, 1.158400>, <0.344306, -0.106491, 1.106768>,
      <0.366609, 0.105023, 1.295618>, <0.367295, 0.035569, 1.263511>, <0.366609, -0.052769, 1.207564>, <0.366609, -0.106491, 1.153075>,
      <0.398245, 0.105023, 1.310465>, <0.398932, 0.035569, 1.278359>, <0.398245, -0.052769, 1.222411>, <0.398245, -0.106491, 1.167922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321083, 0.380910, 1.305866>, <0.321099, 0.294956, 1.296998>, <0.321172, 0.183459, 1.259358>, <0.321189, 0.105023, 1.223100>,
      <0.342786, 0.380910, 1.332075>, <0.342802, 0.294956, 1.323207>, <0.344289, 0.183459, 1.285567>, <0.344306, 0.105023, 1.249309>,
      <0.362989, 0.380910, 1.378015>, <0.363704, 0.294947, 1.369146>, <0.365833, 0.183466, 1.331879>, <0.366609, 0.105023, 1.295618>,
      <0.393426, 0.380910, 1.393230>, <0.394141, 0.294947, 1.384361>, <0.397470, 0.183466, 1.346726>, <0.398245, 0.105023, 1.310465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321083, 0.684386, 1.282876>, <0.321431, 0.594605, 1.299474>, <0.321067, 0.471732, 1.315237>, <0.321083, 0.380910, 1.305866>,
      <0.342786, 0.684386, 1.309085>, <0.343134, 0.594605, 1.325684>, <0.342770, 0.471732, 1.341446>, <0.342786, 0.380910, 1.332075>,
      <0.362989, 0.684386, 1.355025>, <0.364993, 0.593730, 1.365690>, <0.362233, 0.471729, 1.387385>, <0.362989, 0.380910, 1.378015>,
      <0.393426, 0.684386, 1.370240>, <0.395431, 0.593730, 1.380905>, <0.392671, 0.471729, 1.402600>, <0.393426, 0.380910, 1.393230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318961, 0.928087, 1.204708>, <0.318882, 0.858373, 1.236884>, <0.320790, 0.759888, 1.268918>, <0.321083, 0.684386, 1.282876>,
      <0.337671, 0.928087, 1.241953>, <0.337591, 0.858373, 1.274129>, <0.342493, 0.759888, 1.295127>, <0.342786, 0.684386, 1.309085>,
      <0.343699, 0.928087, 1.310930>, <0.338524, 0.856929, 1.331477>, <0.361359, 0.758106, 1.346352>, <0.362989, 0.684386, 1.355025>,
      <0.381326, 0.928087, 1.328858>, <0.376152, 0.856929, 1.349405>, <0.391796, 0.758106, 1.361567>, <0.393426, 0.684386, 1.370240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321628, 1.162591, 1.062166>, <0.321390, 1.098311, 1.113611>, <0.319046, 1.002841, 1.170206>, <0.318961, 0.928087, 1.204708>,
      <0.352547, 1.148116, 1.117344>, <0.352309, 1.083836, 1.168789>, <0.337756, 1.002841, 1.207451>, <0.337671, 0.928087, 1.241953>,
      <0.364316, 1.114340, 1.222323>, <0.372735, 1.060897, 1.253640>, <0.348055, 0.988001, 1.293630>, <0.343699, 0.928087, 1.310930>,
      <0.424691, 1.114340, 1.246091>, <0.433110, 1.060897, 1.277409>, <0.385683, 0.988001, 1.311558>, <0.381326, 0.928087, 1.328858>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.319935, 1.190756, 0.994486>, <0.341933, 1.190756, 0.994486>, <0.321692, 1.179766, 1.048421>, <0.321628, 1.162591, 1.062166>,
      <0.322625, 1.211803, 1.036288>, <0.344623, 1.211803, 1.036288>, <0.352611, 1.165291, 1.103598>, <0.352547, 1.148116, 1.117344>,
      <0.327265, 1.220110, 1.156849>, <0.389591, 1.217410, 1.155499>, <0.355913, 1.167687, 1.191062>, <0.364316, 1.114340, 1.222323>,
      <0.328900, 1.260912, 1.133825>, <0.391226, 1.258212, 1.132475>, <0.416288, 1.167687, 1.214830>, <0.424691, 1.114340, 1.246091>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318338, 1.162591, 1.062166>, <0.318541, 1.179765, 1.048422>, <0.297938, 1.190756, 0.994486>, <0.319935, 1.190756, 0.994486>,
      <0.286560, 1.150875, 1.118723>, <0.286763, 1.168048, 1.104979>, <0.300628, 1.211803, 1.036288>, <0.322625, 1.211803, 1.036288>,
      <0.274628, 1.123536, 1.228900>, <0.286485, 1.178399, 1.197303>, <0.262928, 1.222897, 1.158243>, <0.327265, 1.220110, 1.156849>,
      <0.212410, 1.123536, 1.250689>, <0.224267, 1.178399, 1.219091>, <0.264563, 1.263699, 1.135218>, <0.328900, 1.260912, 1.133825>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316834, 0.928087, 1.204708>, <0.316791, 1.002839, 1.170207>, <0.317579, 1.098316, 1.113608>, <0.318338, 1.162591, 1.062166>,
      <0.297980, 0.923949, 1.243332>, <0.297937, 0.998701, 1.208832>, <0.285801, 1.086599, 1.170165>, <0.286560, 1.150875, 1.118723>,
      <0.293733, 0.914293, 1.316582>, <0.288723, 0.980354, 1.298598>, <0.261991, 1.065066, 1.262576>, <0.274628, 1.123536, 1.228900>,
      <0.253987, 0.914293, 1.333456>, <0.248978, 0.980354, 1.315472>, <0.199773, 1.065066, 1.284365>, <0.212410, 1.123536, 1.250689>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318615, 0.684386, 1.282876>, <0.318370, 0.759888, 1.268918>, <0.316875, 0.858373, 1.236884>, <0.316834, 0.928087, 1.204708>,
      <0.296745, 0.684386, 1.309085>, <0.296499, 0.759888, 1.295127>, <0.298021, 0.854235, 1.275508>, <0.297980, 0.923949, 1.243332>,
      <0.276311, 0.684386, 1.355106>, <0.277388, 0.753837, 1.347323>, <0.298833, 0.847034, 1.334892>, <0.293733, 0.914293, 1.316582>,
      <0.245713, 0.684386, 1.370240>, <0.246791, 0.753837, 1.362457>, <0.259088, 0.847034, 1.351766>, <0.253987, 0.914293, 1.333456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318615, 0.380910, 1.305866>, <0.318624, 0.471732, 1.315237>, <0.318907, 0.594605, 1.299474>, <0.318615, 0.684386, 1.282876>,
      <0.296745, 0.380910, 1.332075>, <0.296753, 0.471732, 1.341446>, <0.297037, 0.594605, 1.325684>, <0.296745, 0.684386, 1.309085>,
      <0.276311, 0.380910, 1.378096>, <0.277064, 0.471729, 1.387466>, <0.274903, 0.593661, 1.365273>, <0.276311, 0.684386, 1.355106>,
      <0.245713, 0.380910, 1.393230>, <0.246466, 0.471729, 1.402600>, <0.244306, 0.593661, 1.380407>, <0.245713, 0.684386, 1.370240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318561, 0.105023, 1.223100>, <0.318570, 0.183459, 1.259358>, <0.318607, 0.294956, 1.296998>, <0.318615, 0.380910, 1.305866>,
      <0.295266, 0.105023, 1.249309>, <0.295275, 0.183459, 1.285567>, <0.296737, 0.294956, 1.323207>, <0.296745, 0.380910, 1.332075>,
      <0.272714, 0.105023, 1.295696>, <0.273487, 0.183466, 1.331957>, <0.275598, 0.294947, 1.369227>, <0.276311, 0.380910, 1.378096>,
      <0.240910, 0.105023, 1.310465>, <0.241683, 0.183466, 1.346726>, <0.245001, 0.294947, 1.384361>, <0.245713, 0.380910, 1.393230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318561, -0.106491, 1.080559>, <0.318561, -0.050018, 1.132191>, <0.318554, 0.035567, 1.190993>, <0.318561, 0.105023, 1.223100>,
      <0.295266, -0.106491, 1.106768>, <0.295266, -0.050018, 1.158400>, <0.295258, 0.035567, 1.217202>, <0.295266, 0.105023, 1.249309>,
      <0.272714, -0.106491, 1.153153>, <0.272714, -0.052769, 1.207643>, <0.272030, 0.035569, 1.263590>, <0.272714, 0.105023, 1.295696>,
      <0.240910, -0.106491, 1.167922>, <0.240910, -0.052769, 1.222411>, <0.240226, 0.035569, 1.278359>, <0.240910, 0.105023, 1.310465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.318561, -0.216846, 0.928820>, <0.318561, -0.183739, 0.974342>, <0.318561, -0.148032, 1.042578>, <0.318561, -0.106491, 1.080559>,
      <0.295266, -0.216846, 0.945373>, <0.295266, -0.183739, 0.990895>, <0.295266, -0.148032, 1.068787>, <0.295266, -0.106491, 1.106768>,
      <0.268333, -0.216846, 0.975955>, <0.268333, -0.183739, 1.031132>, <0.272714, -0.151667, 1.107331>, <0.272714, -0.106491, 1.153153>,
      <0.240910, -0.216846, 0.983998>, <0.240910, -0.183739, 1.039175>, <0.240910, -0.151667, 1.122100>, <0.240910, -0.106491, 1.167922>
    }
  }
  texture {
    Onion_Peel
  }
  scale <1.316109, 1.11384, 1.061378>
  rotate <-0.388928, -4.534126, 6.020092>
  translate  <-0.290179, -0.437161, -0.008162>
}
#declare sPatchObj1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324512, -0.707232, 0.312686>, <0.304546, -0.706909, 0.292727>, <0.281083, -0.706857, 0.292730>,
      <0.324517, -0.707888, 0.359605>, <0.324514, -0.707560, 0.336146>, <0.304588, -0.687691, 0.292995>, <0.281126, -0.687640, 0.292999>,
      <0.304555, -0.708124, 0.379570>, <0.304597, -0.688906, 0.379838>, <0.281145, -0.682068, 0.336507>, <0.281142, -0.681799, 0.317290>,
      <0.281093, -0.708072, 0.379573>, <0.281136, -0.688855, 0.379842>, <0.281147, -0.682337, 0.355724>, <0.281145, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324512, -0.707232, 0.312686>, <0.304546, -0.706909, 0.292727>, <0.281083, -0.706857, 0.292730>,
      <0.324517, -0.707888, 0.359605>, <0.324514, -0.707560, 0.336146>, <0.304503, -0.726127, 0.292458>, <0.281041, -0.726075, 0.292461>,
      <0.304555, -0.708124, 0.379570>, <0.304513, -0.727341, 0.379301>, <0.281033, -0.732862, 0.335797>, <0.281030, -0.732593, 0.316579>,
      <0.281093, -0.708072, 0.379573>, <0.281051, -0.727289, 0.379304>, <0.281035, -0.733131, 0.355014>, <0.281033, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324517, -0.707888, 0.359605>, <0.304555, -0.708124, 0.379570>, <0.281093, -0.708072, 0.379573>,
      <0.324514, -0.707560, 0.336146>, <0.324475, -0.727106, 0.359337>, <0.304513, -0.727341, 0.379301>, <0.281051, -0.727289, 0.379304>,
      <0.324514, -0.707560, 0.336146>, <0.324475, -0.727106, 0.359337>, <0.300254, -0.733173, 0.355012>, <0.281035, -0.733131, 0.355014>,
      <0.324514, -0.707560, 0.336146>, <0.324472, -0.726778, 0.335877>, <0.300252, -0.732904, 0.335794>, <0.281033, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324512, -0.707232, 0.312686>, <0.304546, -0.706909, 0.292727>, <0.281083, -0.706857, 0.292730>,
      <0.324514, -0.707560, 0.336146>, <0.324469, -0.726449, 0.312418>, <0.304503, -0.726127, 0.292458>, <0.281041, -0.726075, 0.292461>,
      <0.324514, -0.707560, 0.336146>, <0.324469, -0.726449, 0.312418>, <0.300250, -0.732635, 0.316576>, <0.281030, -0.732593, 0.316579>,
      <0.324514, -0.707560, 0.336146>, <0.324472, -0.726778, 0.335877>, <0.300252, -0.732904, 0.335794>, <0.281033, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324512, -0.707232, 0.312686>, <0.304546, -0.706909, 0.292727>, <0.281083, -0.706857, 0.292730>,
      <0.324514, -0.707560, 0.336146>, <0.324554, -0.688014, 0.312955>, <0.304588, -0.687691, 0.292995>, <0.281126, -0.687640, 0.292999>,
      <0.324514, -0.707560, 0.336146>, <0.324554, -0.688014, 0.312955>, <0.300362, -0.681841, 0.317287>, <0.281142, -0.681799, 0.317290>,
      <0.324514, -0.707560, 0.336146>, <0.324557, -0.688343, 0.336415>, <0.300364, -0.682110, 0.336504>, <0.281145, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324557, -0.688343, 0.336415>, <0.300364, -0.682110, 0.336504>, <0.281145, -0.682068, 0.336507>,
      <0.324472, -0.726778, 0.335877>, <0.324514, -0.707560, 0.336146>, <0.300362, -0.681841, 0.317287>, <0.281142, -0.681799, 0.317290>,
      <0.300252, -0.732904, 0.335794>, <0.300250, -0.732635, 0.316576>, <0.281083, -0.706857, 0.292730>, <0.281126, -0.687640, 0.292999>,
      <0.281033, -0.732862, 0.335797>, <0.281030, -0.732593, 0.316579>, <0.281041, -0.726075, 0.292461>, <0.281083, -0.706857, 0.292730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324517, -0.707888, 0.359605>, <0.304555, -0.708124, 0.379570>, <0.281093, -0.708072, 0.379573>,
      <0.324514, -0.707560, 0.336146>, <0.324560, -0.688671, 0.359874>, <0.304597, -0.688906, 0.379838>, <0.281136, -0.688855, 0.379842>,
      <0.324514, -0.707560, 0.336146>, <0.324560, -0.688671, 0.359874>, <0.300366, -0.682379, 0.355722>, <0.281147, -0.682337, 0.355724>,
      <0.324514, -0.707560, 0.336146>, <0.324557, -0.688343, 0.336415>, <0.300364, -0.682110, 0.336504>, <0.281145, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324514, -0.707560, 0.336146>, <0.324472, -0.726778, 0.335877>, <0.300252, -0.732904, 0.335794>, <0.281033, -0.732862, 0.335797>,
      <0.324557, -0.688343, 0.336415>, <0.324514, -0.707560, 0.336146>, <0.300254, -0.733173, 0.355012>, <0.281035, -0.733131, 0.355014>,
      <0.300364, -0.682110, 0.336504>, <0.300366, -0.682379, 0.355722>, <0.281093, -0.708072, 0.379573>, <0.281051, -0.727289, 0.379304>,
      <0.281145, -0.682068, 0.336507>, <0.281147, -0.682337, 0.355724>, <0.281136, -0.688855, 0.379842>, <0.281093, -0.708072, 0.379573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237666, -0.707697, 0.359617>, <0.257632, -0.708020, 0.379576>, <0.281093, -0.708072, 0.379573>,
      <0.237661, -0.707041, 0.312699>, <0.237664, -0.707369, 0.336158>, <0.257590, -0.727238, 0.379308>, <0.281051, -0.727289, 0.379304>,
      <0.257622, -0.706805, 0.292733>, <0.257580, -0.726023, 0.292465>, <0.281033, -0.732862, 0.335797>, <0.281035, -0.733131, 0.355014>,
      <0.281083, -0.706857, 0.292730>, <0.281041, -0.726075, 0.292461>, <0.281030, -0.732593, 0.316579>, <0.281033, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237666, -0.707697, 0.359617>, <0.257632, -0.708020, 0.379576>, <0.281093, -0.708072, 0.379573>,
      <0.237661, -0.707041, 0.312699>, <0.237664, -0.707369, 0.336158>, <0.257674, -0.688803, 0.379845>, <0.281136, -0.688855, 0.379842>,
      <0.257622, -0.706805, 0.292733>, <0.257664, -0.687588, 0.293002>, <0.281145, -0.682068, 0.336507>, <0.281147, -0.682337, 0.355724>,
      <0.281083, -0.706857, 0.292730>, <0.281126, -0.687640, 0.292999>, <0.281142, -0.681799, 0.317290>, <0.281145, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237661, -0.707041, 0.312699>, <0.257622, -0.706805, 0.292733>, <0.281083, -0.706857, 0.292730>,
      <0.237706, -0.688152, 0.336427>, <0.237703, -0.687824, 0.312967>, <0.281084, -0.706857, 0.292730>, <0.304546, -0.706909, 0.292727>,
      <0.261925, -0.682026, 0.336510>, <0.281145, -0.682068, 0.336507>, <0.324554, -0.688014, 0.312955>, <0.324512, -0.707232, 0.312686>,
      <0.281145, -0.682068, 0.336507>, <0.300364, -0.682110, 0.336504>, <0.324557, -0.688343, 0.336415>, <0.324514, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237706, -0.688152, 0.336427>, <0.261925, -0.682026, 0.336510>, <0.281145, -0.682068, 0.336507>,
      <0.237666, -0.707697, 0.359617>, <0.237708, -0.688480, 0.359886>, <0.281145, -0.682068, 0.336507>, <0.300364, -0.682110, 0.336504>,
      <0.257632, -0.708020, 0.379576>, <0.281094, -0.708072, 0.379573>, <0.324560, -0.688671, 0.359874>, <0.324557, -0.688343, 0.336415>,
      <0.281093, -0.708072, 0.379573>, <0.304555, -0.708124, 0.379570>, <0.324517, -0.707888, 0.359605>, <0.324514, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237706, -0.688152, 0.336427>, <0.261925, -0.682026, 0.336510>, <0.281145, -0.682068, 0.336507>,
      <0.237663, -0.707369, 0.336158>, <0.237703, -0.687824, 0.312967>, <0.261923, -0.681757, 0.317292>, <0.281142, -0.681799, 0.317290>,
      <0.237663, -0.707369, 0.336158>, <0.237703, -0.687824, 0.312967>, <0.257664, -0.687588, 0.293002>, <0.281126, -0.687640, 0.292999>,
      <0.237663, -0.707369, 0.336158>, <0.237661, -0.707041, 0.312699>, <0.257622, -0.706805, 0.292733>, <0.281083, -0.706857, 0.292730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237666, -0.707697, 0.359617>, <0.257632, -0.708020, 0.379576>, <0.281093, -0.708072, 0.379573>,
      <0.237663, -0.707369, 0.336158>, <0.237708, -0.688480, 0.359886>, <0.257674, -0.688803, 0.379845>, <0.281136, -0.688855, 0.379842>,
      <0.237663, -0.707369, 0.336158>, <0.237708, -0.688480, 0.359886>, <0.261928, -0.682295, 0.355727>, <0.281147, -0.682337, 0.355724>,
      <0.237663, -0.707369, 0.336158>, <0.237706, -0.688152, 0.336427>, <0.261925, -0.682026, 0.336510>, <0.281145, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237661, -0.707041, 0.312699>, <0.257622, -0.706805, 0.292733>, <0.281083, -0.706857, 0.292730>,
      <0.237621, -0.726586, 0.335889>, <0.237618, -0.726258, 0.312430>, <0.281084, -0.706857, 0.292730>, <0.304546, -0.706909, 0.292727>,
      <0.261813, -0.732820, 0.335800>, <0.281033, -0.732862, 0.335797>, <0.324469, -0.726449, 0.312418>, <0.324512, -0.707232, 0.312686>,
      <0.281033, -0.732862, 0.335797>, <0.300252, -0.732904, 0.335794>, <0.324472, -0.726778, 0.335877>, <0.324514, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237666, -0.707697, 0.359617>, <0.257632, -0.708020, 0.379576>, <0.281093, -0.708072, 0.379573>,
      <0.237621, -0.726586, 0.335889>, <0.237624, -0.726915, 0.359349>, <0.281094, -0.708072, 0.379573>, <0.304555, -0.708124, 0.379570>,
      <0.261813, -0.732820, 0.335800>, <0.281033, -0.732862, 0.335797>, <0.324475, -0.727106, 0.359337>, <0.324517, -0.707888, 0.359605>,
      <0.281033, -0.732862, 0.335797>, <0.300252, -0.732904, 0.335794>, <0.324472, -0.726778, 0.335877>, <0.324514, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237666, -0.707697, 0.359617>, <0.257632, -0.708020, 0.379576>, <0.281093, -0.708072, 0.379573>,
      <0.237663, -0.707369, 0.336158>, <0.237624, -0.726915, 0.359349>, <0.257590, -0.727238, 0.379308>, <0.281051, -0.727289, 0.379304>,
      <0.237663, -0.707369, 0.336158>, <0.237624, -0.726915, 0.359349>, <0.261815, -0.733089, 0.355017>, <0.281035, -0.733131, 0.355014>,
      <0.237663, -0.707369, 0.336158>, <0.237621, -0.726586, 0.335889>, <0.261813, -0.732820, 0.335800>, <0.281033, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237706, -0.688152, 0.336427>, <0.261925, -0.682026, 0.336510>, <0.281145, -0.682068, 0.336507>,
      <0.237621, -0.726586, 0.335889>, <0.237663, -0.707369, 0.336158>, <0.261928, -0.682295, 0.355727>, <0.281147, -0.682337, 0.355724>,
      <0.261813, -0.732820, 0.335800>, <0.261815, -0.733089, 0.355017>, <0.281093, -0.708072, 0.379573>, <0.281136, -0.688855, 0.379842>,
      <0.281033, -0.732862, 0.335797>, <0.281035, -0.733131, 0.355014>, <0.281051, -0.727289, 0.379304>, <0.281093, -0.708072, 0.379573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237661, -0.707041, 0.312699>, <0.257622, -0.706805, 0.292733>, <0.281083, -0.706857, 0.292730>,
      <0.237663, -0.707369, 0.336158>, <0.237618, -0.726258, 0.312430>, <0.257580, -0.726023, 0.292465>, <0.281041, -0.726075, 0.292461>,
      <0.237663, -0.707369, 0.336158>, <0.237618, -0.726258, 0.312430>, <0.261811, -0.732551, 0.316582>, <0.281030, -0.732593, 0.316579>,
      <0.237663, -0.707369, 0.336158>, <0.237621, -0.726586, 0.335889>, <0.261813, -0.732820, 0.335800>, <0.281033, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237663, -0.707369, 0.336158>, <0.237621, -0.726586, 0.335889>, <0.261813, -0.732820, 0.335800>, <0.281033, -0.732862, 0.335797>,
      <0.237706, -0.688152, 0.336427>, <0.237663, -0.707369, 0.336158>, <0.261811, -0.732551, 0.316582>, <0.281030, -0.732593, 0.316579>,
      <0.261925, -0.682026, 0.336510>, <0.261923, -0.681757, 0.317292>, <0.281083, -0.706857, 0.292730>, <0.281041, -0.726075, 0.292461>,
      <0.281145, -0.682068, 0.336507>, <0.281142, -0.681799, 0.317290>, <0.281126, -0.687640, 0.292999>, <0.281083, -0.706857, 0.292730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247937, -0.707232, 0.312686>, <-0.267903, -0.706909, 0.292727>, <-0.291365, -0.706857, 0.292730>,
      <-0.247931, -0.707888, 0.359605>, <-0.247934, -0.707560, 0.336146>, <-0.267861, -0.687691, 0.292995>, <-0.291323, -0.687640, 0.292999>,
      <-0.267893, -0.708124, 0.379570>, <-0.267851, -0.688906, 0.379838>, <-0.291304, -0.682068, 0.336507>, <-0.291306, -0.681799, 0.317290>,
      <-0.291355, -0.708072, 0.379573>, <-0.291313, -0.688855, 0.379842>, <-0.291302, -0.682337, 0.355724>, <-0.291304, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247937, -0.707232, 0.312686>, <-0.267903, -0.706909, 0.292727>, <-0.291365, -0.706857, 0.292730>,
      <-0.247931, -0.707888, 0.359605>, <-0.247934, -0.707560, 0.336146>, <-0.267945, -0.726127, 0.292458>, <-0.291407, -0.726075, 0.292461>,
      <-0.267893, -0.708124, 0.379570>, <-0.267936, -0.727341, 0.379301>, <-0.291416, -0.732862, 0.335797>, <-0.291418, -0.732593, 0.316579>,
      <-0.291355, -0.708072, 0.379573>, <-0.291397, -0.727289, 0.379304>, <-0.291414, -0.733131, 0.355014>, <-0.291416, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247931, -0.707888, 0.359605>, <-0.267893, -0.708124, 0.379570>, <-0.291355, -0.708072, 0.379573>,
      <-0.247934, -0.707560, 0.336146>, <-0.247974, -0.727106, 0.359337>, <-0.267936, -0.727341, 0.379301>, <-0.291397, -0.727289, 0.379304>,
      <-0.247934, -0.707560, 0.336146>, <-0.247974, -0.727106, 0.359337>, <-0.272194, -0.733173, 0.355012>, <-0.291414, -0.733131, 0.355014>,
      <-0.247934, -0.707560, 0.336146>, <-0.247976, -0.726778, 0.335877>, <-0.272197, -0.732904, 0.335794>, <-0.291416, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247937, -0.707232, 0.312686>, <-0.267903, -0.706909, 0.292727>, <-0.291365, -0.706857, 0.292730>,
      <-0.247934, -0.707560, 0.336146>, <-0.247979, -0.726449, 0.312418>, <-0.267945, -0.726127, 0.292458>, <-0.291407, -0.726075, 0.292461>,
      <-0.247934, -0.707560, 0.336146>, <-0.247979, -0.726449, 0.312418>, <-0.272199, -0.732635, 0.316576>, <-0.291418, -0.732593, 0.316579>,
      <-0.247934, -0.707560, 0.336146>, <-0.247976, -0.726778, 0.335877>, <-0.272197, -0.732904, 0.335794>, <-0.291416, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247937, -0.707232, 0.312686>, <-0.267903, -0.706909, 0.292727>, <-0.291365, -0.706857, 0.292730>,
      <-0.247934, -0.707560, 0.336146>, <-0.247894, -0.688014, 0.312955>, <-0.267861, -0.687691, 0.292995>, <-0.291323, -0.687640, 0.292999>,
      <-0.247934, -0.707560, 0.336146>, <-0.247894, -0.688014, 0.312955>, <-0.272087, -0.681841, 0.317287>, <-0.291306, -0.681799, 0.317290>,
      <-0.247934, -0.707560, 0.336146>, <-0.247892, -0.688343, 0.336415>, <-0.272085, -0.682110, 0.336504>, <-0.291304, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247892, -0.688343, 0.336415>, <-0.272085, -0.682110, 0.336504>, <-0.291304, -0.682068, 0.336507>,
      <-0.247976, -0.726778, 0.335877>, <-0.247934, -0.707560, 0.336146>, <-0.272087, -0.681841, 0.317287>, <-0.291306, -0.681799, 0.317290>,
      <-0.272197, -0.732904, 0.335794>, <-0.272199, -0.732635, 0.316576>, <-0.291365, -0.706857, 0.292730>, <-0.291323, -0.687640, 0.292999>,
      <-0.291416, -0.732862, 0.335797>, <-0.291418, -0.732593, 0.316579>, <-0.291407, -0.726075, 0.292461>, <-0.291365, -0.706857, 0.292730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247931, -0.707888, 0.359605>, <-0.267893, -0.708124, 0.379570>, <-0.291355, -0.708072, 0.379573>,
      <-0.247934, -0.707560, 0.336146>, <-0.247889, -0.688671, 0.359874>, <-0.267851, -0.688906, 0.379838>, <-0.291313, -0.688855, 0.379842>,
      <-0.247934, -0.707560, 0.336146>, <-0.247889, -0.688671, 0.359874>, <-0.272083, -0.682379, 0.355722>, <-0.291302, -0.682337, 0.355724>,
      <-0.247934, -0.707560, 0.336146>, <-0.247892, -0.688343, 0.336415>, <-0.272085, -0.682110, 0.336504>, <-0.291304, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247934, -0.707560, 0.336146>, <-0.247976, -0.726778, 0.335877>, <-0.272197, -0.732904, 0.335794>, <-0.291416, -0.732862, 0.335797>,
      <-0.247892, -0.688343, 0.336415>, <-0.247934, -0.707560, 0.336146>, <-0.272194, -0.733173, 0.355012>, <-0.291414, -0.733131, 0.355014>,
      <-0.272085, -0.682110, 0.336504>, <-0.272083, -0.682379, 0.355722>, <-0.291355, -0.708072, 0.379573>, <-0.291397, -0.727289, 0.379304>,
      <-0.291304, -0.682068, 0.336507>, <-0.291302, -0.682337, 0.355724>, <-0.291313, -0.688855, 0.379842>, <-0.291355, -0.708072, 0.379573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334782, -0.707697, 0.359617>, <-0.314817, -0.708020, 0.379576>, <-0.291355, -0.708072, 0.379573>,
      <-0.334788, -0.707041, 0.312699>, <-0.334785, -0.707369, 0.336158>, <-0.314859, -0.727238, 0.379308>, <-0.291397, -0.727289, 0.379304>,
      <-0.314827, -0.706805, 0.292733>, <-0.314869, -0.726023, 0.292465>, <-0.291416, -0.732862, 0.335797>, <-0.291414, -0.733131, 0.355014>,
      <-0.291365, -0.706857, 0.292730>, <-0.291407, -0.726075, 0.292461>, <-0.291418, -0.732593, 0.316579>, <-0.291416, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334782, -0.707697, 0.359617>, <-0.314817, -0.708020, 0.379576>, <-0.291355, -0.708072, 0.379573>,
      <-0.334788, -0.707041, 0.312699>, <-0.334785, -0.707369, 0.336158>, <-0.314774, -0.688803, 0.379845>, <-0.291313, -0.688855, 0.379842>,
      <-0.314827, -0.706805, 0.292733>, <-0.314784, -0.687588, 0.293002>, <-0.291304, -0.682068, 0.336507>, <-0.291302, -0.682337, 0.355724>,
      <-0.291365, -0.706857, 0.292730>, <-0.291323, -0.687640, 0.292999>, <-0.291306, -0.681799, 0.317290>, <-0.291304, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334788, -0.707041, 0.312699>, <-0.314827, -0.706805, 0.292733>, <-0.291365, -0.706857, 0.292730>,
      <-0.334743, -0.688152, 0.336427>, <-0.334745, -0.687824, 0.312967>, <-0.291365, -0.706857, 0.292730>, <-0.267903, -0.706909, 0.292727>,
      <-0.310523, -0.682026, 0.336510>, <-0.291304, -0.682068, 0.336507>, <-0.247894, -0.688014, 0.312955>, <-0.247937, -0.707232, 0.312686>,
      <-0.291304, -0.682068, 0.336507>, <-0.272085, -0.682110, 0.336504>, <-0.247892, -0.688343, 0.336415>, <-0.247934, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334743, -0.688152, 0.336427>, <-0.310523, -0.682026, 0.336510>, <-0.291304, -0.682068, 0.336507>,
      <-0.334782, -0.707697, 0.359617>, <-0.334740, -0.688480, 0.359886>, <-0.291304, -0.682068, 0.336507>, <-0.272085, -0.682110, 0.336504>,
      <-0.314817, -0.708020, 0.379576>, <-0.291355, -0.708072, 0.379573>, <-0.247889, -0.688671, 0.359874>, <-0.247892, -0.688343, 0.336415>,
      <-0.291355, -0.708072, 0.379573>, <-0.267893, -0.708124, 0.379570>, <-0.247931, -0.707888, 0.359605>, <-0.247934, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334743, -0.688152, 0.336427>, <-0.310523, -0.682026, 0.336510>, <-0.291304, -0.682068, 0.336507>,
      <-0.334785, -0.707369, 0.336158>, <-0.334745, -0.687824, 0.312967>, <-0.310525, -0.681757, 0.317292>, <-0.291306, -0.681799, 0.317290>,
      <-0.334785, -0.707369, 0.336158>, <-0.334745, -0.687824, 0.312967>, <-0.314784, -0.687588, 0.293002>, <-0.291323, -0.687640, 0.292999>,
      <-0.334785, -0.707369, 0.336158>, <-0.334788, -0.707041, 0.312699>, <-0.314827, -0.706805, 0.292733>, <-0.291365, -0.706857, 0.292730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334782, -0.707697, 0.359617>, <-0.314817, -0.708020, 0.379576>, <-0.291355, -0.708072, 0.379573>,
      <-0.334785, -0.707369, 0.336158>, <-0.334740, -0.688480, 0.359886>, <-0.314774, -0.688803, 0.379845>, <-0.291313, -0.688855, 0.379842>,
      <-0.334785, -0.707369, 0.336158>, <-0.334740, -0.688480, 0.359886>, <-0.310521, -0.682295, 0.355727>, <-0.291302, -0.682337, 0.355724>,
      <-0.334785, -0.707369, 0.336158>, <-0.334743, -0.688152, 0.336427>, <-0.310523, -0.682026, 0.336510>, <-0.291304, -0.682068, 0.336507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334788, -0.707041, 0.312699>, <-0.314827, -0.706805, 0.292733>, <-0.291365, -0.706857, 0.292730>,
      <-0.334827, -0.726586, 0.335889>, <-0.334830, -0.726258, 0.312430>, <-0.291365, -0.706857, 0.292730>, <-0.267903, -0.706909, 0.292727>,
      <-0.310635, -0.732820, 0.335800>, <-0.291416, -0.732862, 0.335797>, <-0.247979, -0.726449, 0.312418>, <-0.247937, -0.707232, 0.312686>,
      <-0.291416, -0.732862, 0.335797>, <-0.272197, -0.732904, 0.335794>, <-0.247976, -0.726778, 0.335877>, <-0.247934, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334782, -0.707697, 0.359617>, <-0.314817, -0.708020, 0.379576>, <-0.291355, -0.708072, 0.379573>,
      <-0.334827, -0.726586, 0.335889>, <-0.334825, -0.726915, 0.359349>, <-0.291355, -0.708072, 0.379573>, <-0.267893, -0.708124, 0.379570>,
      <-0.310635, -0.732820, 0.335800>, <-0.291416, -0.732862, 0.335797>, <-0.247974, -0.727106, 0.359337>, <-0.247931, -0.707888, 0.359605>,
      <-0.291416, -0.732862, 0.335797>, <-0.272197, -0.732904, 0.335794>, <-0.247976, -0.726778, 0.335877>, <-0.247934, -0.707560, 0.336146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334782, -0.707697, 0.359617>, <-0.314817, -0.708020, 0.379576>, <-0.291355, -0.708072, 0.379573>,
      <-0.334785, -0.707369, 0.336158>, <-0.334825, -0.726915, 0.359349>, <-0.314859, -0.727238, 0.379308>, <-0.291397, -0.727289, 0.379304>,
      <-0.334785, -0.707369, 0.336158>, <-0.334825, -0.726915, 0.359349>, <-0.310633, -0.733089, 0.355017>, <-0.291414, -0.733131, 0.355014>,
      <-0.334785, -0.707369, 0.336158>, <-0.334827, -0.726586, 0.335889>, <-0.310635, -0.732820, 0.335800>, <-0.291416, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334743, -0.688152, 0.336427>, <-0.310523, -0.682026, 0.336510>, <-0.291304, -0.682068, 0.336507>,
      <-0.334827, -0.726586, 0.335889>, <-0.334785, -0.707369, 0.336158>, <-0.310521, -0.682295, 0.355727>, <-0.291302, -0.682337, 0.355724>,
      <-0.310635, -0.732820, 0.335800>, <-0.310633, -0.733089, 0.355017>, <-0.291355, -0.708072, 0.379573>, <-0.291313, -0.688855, 0.379842>,
      <-0.291416, -0.732862, 0.335797>, <-0.291414, -0.733131, 0.355014>, <-0.291397, -0.727289, 0.379304>, <-0.291355, -0.708072, 0.379573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334788, -0.707041, 0.312699>, <-0.314827, -0.706805, 0.292733>, <-0.291365, -0.706857, 0.292730>,
      <-0.334785, -0.707369, 0.336158>, <-0.334830, -0.726258, 0.312430>, <-0.314869, -0.726023, 0.292465>, <-0.291407, -0.726075, 0.292461>,
      <-0.334785, -0.707369, 0.336158>, <-0.334830, -0.726258, 0.312430>, <-0.310637, -0.732551, 0.316582>, <-0.291418, -0.732593, 0.316579>,
      <-0.334785, -0.707369, 0.336158>, <-0.334827, -0.726586, 0.335889>, <-0.310635, -0.732820, 0.335800>, <-0.291416, -0.732862, 0.335797>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.334785, -0.707369, 0.336158>, <-0.334827, -0.726586, 0.335889>, <-0.310635, -0.732820, 0.335800>, <-0.291416, -0.732862, 0.335797>,
      <-0.334743, -0.688152, 0.336427>, <-0.334785, -0.707369, 0.336158>, <-0.310637, -0.732551, 0.316582>, <-0.291418, -0.732593, 0.316579>,
      <-0.310523, -0.682026, 0.336510>, <-0.310525, -0.681757, 0.317292>, <-0.291365, -0.706857, 0.292730>, <-0.291407, -0.726075, 0.292461>,
      <-0.291304, -0.682068, 0.336507>, <-0.291306, -0.681799, 0.317290>, <-0.291323, -0.687640, 0.292999>, <-0.291365, -0.706857, 0.292730>
    }
  }
  texture {
    Texture2
  }
  rotate -0.0*z
  translate  <-0.001716, -0.013528, 0.0>
}
#declare sPatchObj5 = union {
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.121909, -0.895872, -0.302626>, <0.121299, -0.892988, -0.305636>, <0.122496, -0.888427, -0.309018>, <0.122748, -0.885236, -0.311757>,
      <0.145209, -0.882942, -0.302577>, <0.144599, -0.880058, -0.305586>, <0.145492, -0.877401, -0.305241>, <0.145744, -0.874210, -0.307981>,
      <0.175182, -0.865211, -0.292146>, <0.174914, -0.864484, -0.292907>, <0.175142, -0.860598, -0.295890>, <0.175198, -0.859689, -0.296483>,
      <0.197904, -0.851319, -0.291254>, <0.197636, -0.850592, -0.292016>, <0.198036, -0.849199, -0.292639>, <0.198092, -0.848291, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.071137, -0.927786, -0.336542>, <0.066580, -0.925772, -0.329421>, <0.057429, -0.921321, -0.323070>, <0.051554, -0.918550, -0.317296>,
      <0.051119, -0.935753, -0.340936>, <0.046562, -0.933739, -0.333816>, <0.041848, -0.926289, -0.324591>, <0.035973, -0.923519, -0.318818>,
      <0.022505, -0.941648, -0.350479>, <0.021661, -0.938313, -0.341732>, <0.014902, -0.930110, -0.332464>, <0.014032, -0.925172, -0.324515>,
      <0.000517, -0.941600, -0.350475>, <-0.000328, -0.938264, -0.341729>, <-0.001514, -0.930078, -0.331926>, <-0.002384, -0.925140, -0.323977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.075112, -0.927465, -0.336518>, <-0.069626, -0.925358, -0.328434>, <-0.059234, -0.921082, -0.320677>, <-0.052429, -0.918347, -0.313888>,
      <-0.053451, -0.935369, -0.340834>, <-0.047966, -0.933262, -0.332750>, <-0.044529, -0.925617, -0.322066>, <-0.037724, -0.922882, -0.315277>,
      <-0.022941, -0.941549, -0.350471>, <-0.023786, -0.938213, -0.341725>, <-0.016956, -0.930048, -0.331420>, <-0.017826, -0.925110, -0.323471>,
      <0.000517, -0.941600, -0.350475>, <-0.000328, -0.938264, -0.341729>, <-0.001514, -0.930078, -0.331926>, <-0.002384, -0.925140, -0.323977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.211907, -0.840846, -0.299095>, <0.207337, -0.842871, -0.299614>, <0.202555, -0.846069, -0.292598>, <0.198092, -0.848291, -0.293232>,
      <0.211907, -0.840846, -0.299095>, <0.203136, -0.846013, -0.297262>, <0.202499, -0.846977, -0.292005>, <0.198036, -0.849199, -0.292639>,
      <0.211907, -0.840846, -0.299095>, <0.203136, -0.846013, -0.297262>, <0.202538, -0.847595, -0.291823>, <0.197636, -0.850592, -0.292016>,
      <0.211907, -0.840846, -0.299095>, <0.207706, -0.843988, -0.296743>, <0.202806, -0.848322, -0.291062>, <0.197904, -0.851319, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.211907, -0.840846, -0.299095>, <0.207706, -0.843988, -0.296743>, <0.202806, -0.848322, -0.291062>, <0.197904, -0.851319, -0.291254>,
      <0.209394, -0.842131, -0.297570>, <0.205193, -0.845272, -0.295218>, <0.202538, -0.847595, -0.291823>, <0.197636, -0.850592, -0.292016>,
      <0.206202, -0.843518, -0.293262>, <0.204301, -0.843580, -0.293247>, <0.199667, -0.848251, -0.292873>, <0.198036, -0.849199, -0.292639>,
      <0.203530, -0.845128, -0.294012>, <0.201629, -0.845190, -0.293997>, <0.199723, -0.847342, -0.293466>, <0.198092, -0.848291, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.211907, -0.840846, -0.299095>, <0.207337, -0.842871, -0.299614>, <0.202555, -0.846069, -0.292598>, <0.198092, -0.848291, -0.293232>,
      <0.211907, -0.840846, -0.299095>, <0.204823, -0.844156, -0.298089>, <0.204187, -0.845120, -0.292832>, <0.199723, -0.847342, -0.293466>,
      <0.211907, -0.840846, -0.299095>, <0.204823, -0.844156, -0.298089>, <0.204301, -0.843580, -0.293247>, <0.201629, -0.845190, -0.293997>,
      <0.211907, -0.840846, -0.299095>, <0.209394, -0.842131, -0.297570>, <0.206202, -0.843518, -0.293262>, <0.203530, -0.845128, -0.294012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.213532, -0.813962, -0.291624>, <-0.212386, -0.823209, -0.291423>, <-0.215824, -0.838256, -0.288330>, <-0.209712, -0.844784, -0.290954>,
      <-0.213532, -0.813962, -0.291624>, <-0.211591, -0.833369, -0.288836>, <-0.215780, -0.840018, -0.288398>, <-0.209667, -0.846546, -0.291022>,
      <-0.213532, -0.813962, -0.291624>, <-0.211591, -0.833369, -0.288836>, <-0.216867, -0.840578, -0.292170>, <-0.209074, -0.847372, -0.294089>,
      <-0.213532, -0.813962, -0.291624>, <-0.212737, -0.824123, -0.289037>, <-0.216593, -0.841687, -0.293514>, <-0.208801, -0.848481, -0.295433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.081719, -0.931880, -0.364428>, <0.080824, -0.934334, -0.355782>, <0.075873, -0.929879, -0.343942>, <0.071137, -0.927786, -0.336542>,
      <0.059344, -0.940426, -0.370455>, <0.058450, -0.942880, -0.361809>, <0.055855, -0.937846, -0.348336>, <0.051119, -0.935753, -0.340936>,
      <0.028116, -0.948104, -0.384057>, <0.028116, -0.950687, -0.374092>, <0.023431, -0.945301, -0.360058>, <0.022505, -0.941648, -0.350479>,
      <0.003418, -0.948050, -0.384051>, <0.003418, -0.950633, -0.374086>, <0.001442, -0.945253, -0.360054>, <0.000517, -0.941600, -0.350475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.086699, -0.931511, -0.364390>, <-0.060631, -0.940111, -0.370455>, <-0.024694, -0.947989, -0.384045>, <0.003418, -0.948050, -0.384051>,
      <-0.085144, -0.933947, -0.355723>, <-0.059076, -0.942547, -0.361788>, <-0.024694, -0.950572, -0.374080>, <0.003418, -0.950633, -0.374086>,
      <-0.080127, -0.929391, -0.343908>, <-0.058466, -0.937295, -0.348224>, <-0.022016, -0.945202, -0.360050>, <0.001442, -0.945253, -0.360054>,
      <-0.075112, -0.927465, -0.336518>, <-0.053451, -0.935369, -0.340834>, <-0.022941, -0.941549, -0.350471>, <0.000517, -0.941600, -0.350475>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.126552, -0.903226, -0.292982>, <0.125180, -0.902622, -0.296578>, <0.122473, -0.898539, -0.299843>, <0.121909, -0.895872, -0.302626>,
      <0.149628, -0.889902, -0.293674>, <0.148256, -0.889298, -0.297269>, <0.145773, -0.885609, -0.299793>, <0.145209, -0.882942, -0.302577>,
      <0.177698, -0.868074, -0.288586>, <0.177289, -0.867570, -0.289836>, <0.175530, -0.866154, -0.291158>, <0.175182, -0.865211, -0.292146>,
      <0.200035, -0.853555, -0.287715>, <0.199626, -0.853050, -0.288966>, <0.198252, -0.852262, -0.290266>, <0.197904, -0.851319, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238845, -0.830234, -0.288605>, <0.227202, -0.837230, -0.288338>, <0.211420, -0.846155, -0.287271>, <0.200035, -0.853555, -0.287715>,
      <0.231348, -0.831812, -0.293767>, <0.219705, -0.838808, -0.293500>, <0.211011, -0.845650, -0.288522>, <0.199626, -0.853050, -0.288966>,
      <0.220308, -0.837124, -0.298141>, <0.216107, -0.840265, -0.295789>, <0.203154, -0.849264, -0.290074>, <0.198252, -0.852262, -0.290266>,
      <0.211907, -0.840846, -0.299095>, <0.207706, -0.843988, -0.296743>, <0.202806, -0.848322, -0.291062>, <0.197904, -0.851319, -0.291254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238845, -0.830234, -0.288605>, <0.231348, -0.831812, -0.293767>, <0.220308, -0.837124, -0.298141>, <0.211907, -0.840846, -0.299095>,
      <0.234252, -0.835403, -0.290055>, <0.226755, -0.836981, -0.295217>, <0.217795, -0.838408, -0.296616>, <0.209394, -0.842131, -0.297570>,
      <0.228741, -0.843915, -0.290241>, <0.227555, -0.844212, -0.284321>, <0.212243, -0.843322, -0.293311>, <0.206202, -0.843518, -0.293262>,
      <0.223535, -0.847465, -0.293437>, <0.222349, -0.847763, -0.287517>, <0.209571, -0.844932, -0.294061>, <0.203530, -0.845128, -0.294012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.210236, -0.830142, -0.300102>, <-0.205472, -0.828145, -0.302182>, <-0.213953, -0.808581, -0.292994>, <-0.213532, -0.813962, -0.291624>,
      <-0.209983, -0.828641, -0.298432>, <-0.205219, -0.826645, -0.300513>, <-0.212807, -0.817828, -0.292793>, <-0.212386, -0.823209, -0.291423>,
      <-0.210588, -0.823581, -0.293418>, <-0.209152, -0.823820, -0.287606>, <-0.215976, -0.832271, -0.288100>, <-0.215824, -0.838256, -0.288330>,
      <-0.209393, -0.825139, -0.294536>, <-0.207957, -0.825378, -0.288724>, <-0.209864, -0.838799, -0.290724>, <-0.209712, -0.844784, -0.290954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.889804, -0.321905>, <0.128403, -0.888983, -0.318589>, <0.125123, -0.886606, -0.314801>, <0.122748, -0.885236, -0.311757>,
      <0.152739, -0.876022, -0.314814>, <0.150477, -0.875201, -0.311497>, <0.148119, -0.875581, -0.311025>, <0.145744, -0.874210, -0.307981>,
      <0.181068, -0.858664, -0.300318>, <0.179168, -0.858725, -0.300303>, <0.176829, -0.858740, -0.296717>, <0.175198, -0.859689, -0.296483>,
      <0.203530, -0.845128, -0.294012>, <0.201629, -0.845190, -0.293997>, <0.199723, -0.847342, -0.293466>, <0.198092, -0.848291, -0.293232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.889804, -0.321905>, <0.135380, -0.891517, -0.328822>, <0.144585, -0.895160, -0.337369>, <0.145876, -0.893639, -0.345678>,
      <0.152739, -0.876022, -0.314814>, <0.157454, -0.877736, -0.321730>, <0.169300, -0.880449, -0.324998>, <0.170591, -0.878928, -0.333306>,
      <0.181068, -0.858664, -0.300318>, <0.187110, -0.858468, -0.300367>, <0.199280, -0.863496, -0.301679>, <0.200466, -0.863198, -0.307599>,
      <0.203530, -0.845128, -0.294012>, <0.209571, -0.844932, -0.294061>, <0.222349, -0.847763, -0.287517>, <0.223535, -0.847465, -0.293437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.889804, -0.321905>, <0.135380, -0.891517, -0.328822>, <0.144585, -0.895160, -0.337369>, <0.145876, -0.893639, -0.345678>,
      <0.112959, -0.900858, -0.327593>, <0.117674, -0.902572, -0.334509>, <0.126349, -0.906015, -0.346498>, <0.127640, -0.904494, -0.354807>,
      <0.090832, -0.919948, -0.332219>, <0.095568, -0.922041, -0.339619>, <0.101753, -0.926341, -0.350145>, <0.102648, -0.923886, -0.358791>,
      <0.071137, -0.927786, -0.336542>, <0.075873, -0.929879, -0.343942>, <0.080824, -0.934334, -0.355782>, <0.081719, -0.931880, -0.364428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.130664, -0.889804, -0.321905>, <0.112959, -0.900858, -0.327593>, <0.090832, -0.919948, -0.332219>, <0.071137, -0.927786, -0.336542>,
      <0.128403, -0.888983, -0.318589>, <0.110697, -0.900037, -0.324276>, <0.086275, -0.917934, -0.325098>, <0.066580, -0.925772, -0.329421>,
      <0.125123, -0.886606, -0.314801>, <0.104037, -0.896716, -0.318264>, <0.079854, -0.914169, -0.320880>, <0.057429, -0.921321, -0.323070>,
      <0.122748, -0.885236, -0.311757>, <0.101662, -0.895346, -0.315220>, <0.073979, -0.911399, -0.315106>, <0.051554, -0.918550, -0.317296>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.889203, -0.321865>, <-0.140031, -0.888342, -0.318390>, <-0.135171, -0.886426, -0.314789>, <-0.131782, -0.885236, -0.311757>,
      <-0.123585, -0.901176, -0.328463>, <-0.120540, -0.900315, -0.324988>, <-0.111748, -0.896891, -0.317554>, <-0.108359, -0.895701, -0.314521>,
      <-0.097096, -0.919443, -0.332138>, <-0.091610, -0.917336, -0.324054>, <-0.083791, -0.913509, -0.318358>, <-0.076986, -0.910774, -0.311569>,
      <-0.075112, -0.927465, -0.336518>, <-0.069626, -0.925358, -0.328434>, <-0.059234, -0.921082, -0.320677>, <-0.052429, -0.918347, -0.313888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.889203, -0.321865>, <-0.148995, -0.890876, -0.328616>, <-0.159580, -0.895193, -0.336889>, <-0.161514, -0.893639, -0.345678>,
      <-0.123585, -0.901176, -0.328463>, <-0.129503, -0.902849, -0.335215>, <-0.141690, -0.910703, -0.347075>, <-0.143624, -0.909149, -0.355863>,
      <-0.097096, -0.919443, -0.332138>, <-0.102111, -0.921370, -0.339528>, <-0.109045, -0.926062, -0.350162>, <-0.110600, -0.923626, -0.358829>,
      <-0.075112, -0.927465, -0.336518>, <-0.080127, -0.929391, -0.343908>, <-0.085144, -0.933947, -0.355723>, <-0.086699, -0.931511, -0.364390>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.889203, -0.321865>, <-0.164161, -0.876252, -0.314728>, <-0.192822, -0.862822, -0.298204>, <-0.209712, -0.844784, -0.290954>,
      <-0.140031, -0.888342, -0.318390>, <-0.161115, -0.875391, -0.311253>, <-0.192777, -0.864583, -0.298271>, <-0.209667, -0.846546, -0.291022>,
      <-0.135171, -0.886426, -0.314789>, <-0.158832, -0.875854, -0.311997>, <-0.189757, -0.864214, -0.298847>, <-0.209074, -0.847372, -0.294089>,
      <-0.131782, -0.885236, -0.311757>, <-0.155444, -0.874664, -0.308964>, <-0.189484, -0.865323, -0.300190>, <-0.208801, -0.848481, -0.295433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.143077, -0.889203, -0.321865>, <-0.148995, -0.890876, -0.328616>, <-0.159580, -0.895193, -0.336889>, <-0.161514, -0.893639, -0.345678>,
      <-0.164161, -0.876252, -0.314728>, <-0.170078, -0.877924, -0.321479>, <-0.179982, -0.877505, -0.325274>, <-0.181916, -0.875951, -0.334062>,
      <-0.192822, -0.862822, -0.298204>, <-0.192974, -0.856837, -0.297974>, <-0.192408, -0.845643, -0.303270>, <-0.193844, -0.845404, -0.309081>,
      <-0.209712, -0.844784, -0.290954>, <-0.209864, -0.838799, -0.290724>, <-0.207957, -0.825378, -0.288724>, <-0.209393, -0.825139, -0.294536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203507, -0.851179, -0.291281>, <-0.202958, -0.849205, -0.292009>, <-0.207213, -0.849290, -0.294187>, <-0.208801, -0.848481, -0.295433>,
      <-0.211777, -0.843169, -0.290201>, <-0.211228, -0.841194, -0.290929>, <-0.207486, -0.848181, -0.292844>, <-0.209074, -0.847372, -0.294089>,
      <-0.210525, -0.825127, -0.291521>, <-0.209379, -0.834374, -0.291320>, <-0.215780, -0.840018, -0.288398>, <-0.209667, -0.846546, -0.291022>,
      <-0.213532, -0.813962, -0.291624>, <-0.212386, -0.823209, -0.291423>, <-0.215824, -0.838256, -0.288330>, <-0.209712, -0.844784, -0.290954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203507, -0.851179, -0.291281>, <-0.202958, -0.849205, -0.292009>, <-0.207213, -0.849290, -0.294187>, <-0.208801, -0.848481, -0.295433>,
      <-0.203507, -0.851179, -0.291281>, <-0.211228, -0.841194, -0.290929>, <-0.215005, -0.842497, -0.292268>, <-0.216593, -0.841687, -0.293514>,
      <-0.203507, -0.851179, -0.291281>, <-0.211228, -0.841194, -0.290929>, <-0.209730, -0.835288, -0.288934>, <-0.212737, -0.824123, -0.289037>,
      <-0.203507, -0.851179, -0.291281>, <-0.211777, -0.843169, -0.290201>, <-0.210525, -0.825127, -0.291521>, <-0.213532, -0.813962, -0.291624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203507, -0.851179, -0.291281>, <-0.211777, -0.843169, -0.290201>, <-0.210525, -0.825127, -0.291521>, <-0.213532, -0.813962, -0.291624>,
      <-0.204233, -0.853792, -0.290318>, <-0.212503, -0.845781, -0.289238>, <-0.210946, -0.819746, -0.292891>, <-0.213953, -0.808581, -0.292994>,
      <-0.210362, -0.854878, -0.294230>, <-0.216557, -0.849477, -0.295768>, <-0.205743, -0.836171, -0.299851>, <-0.205472, -0.828145, -0.302182>,
      <-0.211139, -0.856895, -0.292330>, <-0.217334, -0.851494, -0.293868>, <-0.210507, -0.838168, -0.297770>, <-0.210236, -0.830142, -0.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203507, -0.851179, -0.291281>, <-0.204233, -0.853792, -0.290318>, <-0.210362, -0.854878, -0.294230>, <-0.211139, -0.856895, -0.292330>,
      <-0.184869, -0.869233, -0.293714>, <-0.185595, -0.871846, -0.292751>, <-0.188798, -0.873680, -0.288875>, <-0.189575, -0.875696, -0.286975>,
      <-0.152955, -0.883909, -0.303487>, <-0.151955, -0.887417, -0.297071>, <-0.151041, -0.889679, -0.287767>, <-0.153227, -0.890983, -0.280838>,
      <-0.129541, -0.895321, -0.302590>, <-0.128541, -0.898829, -0.296173>, <-0.124547, -0.901641, -0.286295>, <-0.126733, -0.902946, -0.279366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.203507, -0.851179, -0.291281>, <-0.184869, -0.869233, -0.293714>, <-0.152955, -0.883909, -0.303487>, <-0.129541, -0.895321, -0.302590>,
      <-0.202958, -0.849205, -0.292009>, <-0.184320, -0.867259, -0.294443>, <-0.153517, -0.881939, -0.307089>, <-0.130103, -0.893352, -0.306192>,
      <-0.207213, -0.849290, -0.294187>, <-0.187895, -0.866132, -0.298945>, <-0.154771, -0.877690, -0.306214>, <-0.131110, -0.888262, -0.309007>,
      <-0.208801, -0.848481, -0.295433>, <-0.189484, -0.865323, -0.300190>, <-0.155444, -0.874664, -0.308964>, <-0.131782, -0.885236, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033943, -0.933826, -0.284783>, <-0.063621, -0.923798, -0.286553>, <-0.101353, -0.909060, -0.301510>, <-0.129541, -0.895321, -0.302590>,
      <-0.033291, -0.934665, -0.283126>, <-0.062969, -0.924637, -0.284896>, <-0.100353, -0.912568, -0.295093>, <-0.128541, -0.898829, -0.296173>,
      <-0.039880, -0.933959, -0.284770>, <-0.066470, -0.926550, -0.285236>, <-0.099418, -0.912988, -0.284898>, <-0.124547, -0.901641, -0.286295>,
      <-0.040204, -0.934077, -0.282831>, <-0.066794, -0.926668, -0.283298>, <-0.101604, -0.914292, -0.277970>, <-0.126733, -0.902946, -0.279366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.033943, -0.933826, -0.284783>, <-0.037700, -0.928992, -0.294327>, <-0.046883, -0.922991, -0.305157>, <-0.052429, -0.918347, -0.313888>,
      <-0.063621, -0.923798, -0.286553>, <-0.067378, -0.918964, -0.296097>, <-0.071441, -0.915418, -0.302837>, <-0.076986, -0.910774, -0.311569>,
      <-0.101353, -0.909060, -0.301510>, <-0.101915, -0.907091, -0.305112>, <-0.107687, -0.898727, -0.311771>, <-0.108359, -0.895701, -0.314521>,
      <-0.129541, -0.895321, -0.302590>, <-0.130103, -0.893352, -0.306192>, <-0.131110, -0.888262, -0.309007>, <-0.131782, -0.885236, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000612, -0.939299, -0.294826>, <-0.010254, -0.938804, -0.293865>, <-0.023615, -0.937316, -0.284167>, <-0.033943, -0.933826, -0.284783>,
      <0.000969, -0.940754, -0.289725>, <-0.009897, -0.940260, -0.288764>, <-0.022962, -0.938155, -0.282510>, <-0.033291, -0.934665, -0.283126>,
      <0.001043, -0.937409, -0.282324>, <-0.011437, -0.936431, -0.282276>, <-0.027823, -0.937318, -0.284558>, <-0.039880, -0.933959, -0.284770>,
      <0.000892, -0.938508, -0.277125>, <-0.011588, -0.937530, -0.277077>, <-0.028147, -0.937437, -0.282619>, <-0.040204, -0.934077, -0.282831>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000612, -0.939299, -0.294826>, <-0.000043, -0.936626, -0.304194>, <-0.001485, -0.929388, -0.315232>, <-0.002384, -0.925140, -0.323977>,
      <-0.010254, -0.938804, -0.293865>, <-0.010909, -0.936131, -0.303233>, <-0.016927, -0.929357, -0.314726>, <-0.017826, -0.925110, -0.323471>,
      <-0.023615, -0.937316, -0.284167>, <-0.027371, -0.932482, -0.293710>, <-0.032178, -0.927525, -0.306545>, <-0.037724, -0.922882, -0.315277>,
      <-0.033943, -0.933826, -0.284783>, <-0.037700, -0.928992, -0.294327>, <-0.046883, -0.922991, -0.305157>, <-0.052429, -0.918347, -0.313888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042921, -0.937326, -0.291583>, <0.030945, -0.941614, -0.290813>, <0.013293, -0.939876, -0.295948>, <0.000612, -0.939299, -0.294826>,
      <0.042683, -0.939098, -0.288893>, <0.030707, -0.943386, -0.288123>, <0.013650, -0.941332, -0.290847>, <0.000969, -0.940754, -0.289725>,
      <0.048074, -0.941016, -0.286372>, <0.034285, -0.944887, -0.284632>, <0.015426, -0.938536, -0.282380>, <0.001043, -0.937409, -0.282324>,
      <0.048535, -0.941032, -0.283175>, <0.034746, -0.944904, -0.281435>, <0.015275, -0.939635, -0.277181>, <0.000892, -0.938508, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042921, -0.937326, -0.291583>, <0.043650, -0.931896, -0.299824>, <0.048964, -0.924183, -0.309582>, <0.051554, -0.918550, -0.317296>,
      <0.030945, -0.941614, -0.290813>, <0.031674, -0.936183, -0.299054>, <0.033383, -0.929152, -0.311104>, <0.035973, -0.923519, -0.318818>,
      <0.013293, -0.939876, -0.295948>, <0.012638, -0.937204, -0.305316>, <0.014930, -0.929420, -0.315770>, <0.014032, -0.925172, -0.324515>,
      <0.000612, -0.939299, -0.294826>, <-0.000043, -0.936626, -0.304194>, <-0.001485, -0.929388, -0.315232>, <-0.002384, -0.925140, -0.323977>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042921, -0.937326, -0.291583>, <0.068262, -0.928253, -0.293213>, <0.098331, -0.908957, -0.302676>, <0.121909, -0.895872, -0.302626>,
      <0.043650, -0.931896, -0.299824>, <0.068991, -0.922823, -0.301454>, <0.097721, -0.906073, -0.305686>, <0.121299, -0.892988, -0.305636>,
      <0.048964, -0.924183, -0.309582>, <0.071389, -0.917032, -0.307392>, <0.101410, -0.898537, -0.312480>, <0.122496, -0.888427, -0.309018>,
      <0.051554, -0.918550, -0.317296>, <0.073979, -0.911399, -0.315106>, <0.101662, -0.895346, -0.315220>, <0.122748, -0.885236, -0.311757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.042921, -0.937326, -0.291583>, <0.042683, -0.939098, -0.288893>, <0.048074, -0.941016, -0.286372>, <0.048535, -0.941032, -0.283175>,
      <0.068262, -0.928253, -0.293213>, <0.068024, -0.930026, -0.290523>, <0.073090, -0.933992, -0.289529>, <0.073551, -0.934008, -0.286332>,
      <0.098331, -0.908957, -0.302676>, <0.098894, -0.911624, -0.299893>, <0.102520, -0.915706, -0.295899>, <0.103893, -0.916310, -0.292303>,
      <0.121909, -0.895872, -0.302626>, <0.122473, -0.898539, -0.299843>, <0.125180, -0.902622, -0.296578>, <0.126552, -0.903226, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.219617, 0.629897, -0.357664>, <0.198242, 0.592692, -0.611904>, <0.206751, 0.601955, -0.958494>, <0.201237, 0.589980, -1.215992>,
      <0.180424, 0.643462, -0.357294>, <0.159049, 0.606257, -0.611534>, <0.173787, 0.614010, -0.958494>, <0.168273, 0.602035, -1.215992>,
      <0.128665, 0.664391, -0.350969>, <0.109024, 0.627605, -0.605801>, <0.124525, 0.634489, -0.958124>, <0.125239, 0.621004, -1.215992>,
      <0.088974, 0.675114, -0.356431>, <0.069333, 0.638328, -0.611263>, <0.090641, 0.643648, -0.958124>, <0.091356, 0.630162, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287459, 0.574592, -0.359450>, <0.257734, 0.538929, -0.612509>, <0.270709, 0.549807, -0.959029>, <0.263531, 0.539185, -1.215992>,
      <0.268484, 0.592587, -0.357018>, <0.238759, 0.556925, -0.610077>, <0.253227, 0.566415, -0.959029>, <0.246049, 0.555793, -1.215992>,
      <0.239970, 0.613305, -0.358200>, <0.218595, 0.576101, -0.612440>, <0.225439, 0.586717, -0.958494>, <0.219925, 0.574742, -1.215992>,
      <0.219617, 0.629897, -0.357664>, <0.198242, 0.592692, -0.611904>, <0.206751, 0.601955, -0.958494>, <0.201237, 0.589980, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.401858, 0.457063, -0.381021>, <0.367742, 0.438095, -0.628777>, <0.378561, 0.438828, -0.965501>, <0.368576, 0.431013, -1.215992>,
      <0.375272, 0.497844, -0.371380>, <0.341156, 0.478876, -0.619136>, <0.353910, 0.476756, -0.965501>, <0.343925, 0.468941, -1.215992>,
      <0.323313, 0.540588, -0.364045>, <0.293588, 0.504926, -0.617104>, <0.303505, 0.518652, -0.959029>, <0.296327, 0.508030, -1.215992>,
      <0.287459, 0.574592, -0.359450>, <0.257734, 0.538929, -0.612509>, <0.270709, 0.549807, -0.959029>, <0.263531, 0.539185, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.477269, 0.283437, -0.428282>, <0.447288, 0.283554, -0.663014>, <0.449658, 0.274738, -0.979679>, <0.437825, 0.271010, -1.215992>,
      <0.460591, 0.337579, -0.413570>, <0.430610, 0.337696, -0.648301>, <0.434309, 0.324739, -0.979679>, <0.422476, 0.321011, -1.215992>,
      <0.433214, 0.408965, -0.392392>, <0.399098, 0.389996, -0.640148>, <0.407063, 0.394973, -0.965501>, <0.397079, 0.387158, -1.215992>,
      <0.401858, 0.457063, -0.381021>, <0.367742, 0.438095, -0.628777>, <0.378561, 0.438828, -0.965501>, <0.368576, 0.431013, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.490079, 0.170677, -0.458841>, <0.462000, 0.182590, -0.684259>, <0.461737, 0.168173, -0.988847>, <0.449590, 0.167100, -1.215992>,
      <0.489588, 0.204491, -0.448866>, <0.461509, 0.216405, -0.674284>, <0.461282, 0.199542, -0.988847>, <0.449136, 0.198469, -1.215992>,
      <0.487316, 0.250823, -0.437144>, <0.457335, 0.250940, -0.671876>, <0.458865, 0.244747, -0.979679>, <0.447031, 0.241019, -1.215992>,
      <0.477269, 0.283437, -0.428282>, <0.447288, 0.283554, -0.663014>, <0.449658, 0.274738, -0.979679>, <0.437825, 0.271010, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.480615, 0.052883, -0.496291>, <0.454661, 0.076292, -0.709693>, <0.452817, 0.056800, -1.000082>, <0.440904, 0.058479, -1.215992>,
      <0.487356, 0.087064, -0.483279>, <0.461402, 0.110473, -0.696681>, <0.459110, 0.088879, -1.000082>, <0.447197, 0.090558, -1.215992>,
      <0.490597, 0.135010, -0.469362>, <0.462518, 0.146924, -0.694780>, <0.462210, 0.135486, -0.988847>, <0.450064, 0.134413, -1.215992>,
      <0.490079, 0.170677, -0.458841>, <0.462000, 0.182590, -0.684259>, <0.461737, 0.168173, -0.988847>, <0.449590, 0.167100, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.444215, -0.061871, -0.547365>, <0.421740, 0.014109, -0.732020>, <0.418505, -0.051829, -1.015404>, <0.407486, -0.047525, -1.215992>,
      <0.459961, -0.029710, -0.531337>, <0.437487, 0.046270, -0.715992>, <0.432559, -0.021591, -1.015404>, <0.421540, -0.017287, -1.215992>,
      <0.473504, 0.016825, -0.510017>, <0.447549, 0.040234, -0.723419>, <0.446398, 0.024080, -1.000082>, <0.434485, 0.025759, -1.215992>,
      <0.480615, 0.052883, -0.496291>, <0.454661, 0.076292, -0.709693>, <0.452817, 0.056800, -1.000082>, <0.440904, 0.058479, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.351813, -0.210187, -0.627398>, <0.336664, -0.121895, -0.780378>, <0.343387, -0.174428, -1.039414>, <0.339776, -0.159102, -1.215992>,
      <0.381454, -0.167325, -0.602721>, <0.366306, -0.079034, -0.755701>, <0.364818, -0.141659, -1.039414>, <0.361207, -0.126333, -1.215992>,
      <0.421072, -0.109138, -0.570922>, <0.398598, -0.033158, -0.755577>, <0.402002, -0.087335, -1.015404>, <0.390983, -0.083032, -1.215992>,
      <0.444215, -0.061871, -0.547365>, <0.421740, 0.014109, -0.732020>, <0.418505, -0.051829, -1.015404>, <0.407486, -0.047525, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.283412, -0.294394, -0.681239>, <0.270635, -0.209336, -0.817477>, <0.279890, -0.259773, -1.055566>, <0.278381, -0.244935, -1.215992>,
      <0.306582, -0.270814, -0.666162>, <0.293805, -0.185756, -0.802400>, <0.300677, -0.235893, -1.055566>, <0.299167, -0.221056, -1.215992>,
      <0.333135, -0.237196, -0.642948>, <0.317986, -0.148904, -0.795928>, <0.326059, -0.200923, -1.039414>, <0.322448, -0.185598, -1.215992>,
      <0.351813, -0.210187, -0.627398>, <0.336664, -0.121895, -0.780378>, <0.343387, -0.174428, -1.039414>, <0.339776, -0.159102, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.225173, -0.339069, -0.709803>, <0.213976, -0.252097, -0.834562>, <0.223982, -0.306621, -1.064135>, <0.223471, -0.292714, -1.215992>,
      <0.244036, -0.327079, -0.702138>, <0.232839, -0.240107, -0.826897>, <0.241351, -0.293387, -1.064135>, <0.240840, -0.279481, -1.215992>,
      <0.268344, -0.309729, -0.691044>, <0.255567, -0.224671, -0.827282>, <0.265554, -0.276243, -1.055566>, <0.264044, -0.261405, -1.215992>,
      <0.283412, -0.294394, -0.681239>, <0.270635, -0.209336, -0.817477>, <0.279890, -0.259773, -1.055566>, <0.278381, -0.244935, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.161040, -0.372179, -0.730963>, <0.150688, -0.284090, -0.847179>, <0.168496, -0.340006, -1.070483>, <0.171692, -0.326218, -1.215992>,
      <0.181442, -0.364007, -0.725852>, <0.171090, -0.275917, -0.842068>, <0.185213, -0.332077, -1.070483>, <0.188409, -0.318288, -1.215992>,
      <0.207160, -0.350519, -0.717122>, <0.195963, -0.263547, -0.841881>, <0.209264, -0.317833, -1.064135>, <0.208754, -0.303927, -1.215992>,
      <0.225173, -0.339069, -0.709803>, <0.213976, -0.252097, -0.834562>, <0.223982, -0.306621, -1.064135>, <0.223471, -0.292714, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.107291, -0.386289, -0.739335>, <0.095755, -0.294625, -0.849208>, <0.111842, -0.357205, -1.072995>, <0.113792, -0.344741, -1.215992>,
      <0.123570, -0.382587, -0.736983>, <0.112033, -0.290924, -0.846856>, <0.129500, -0.352648, -1.072995>, <0.131451, -0.340183, -1.215992>,
      <0.145797, -0.378285, -0.734782>, <0.135445, -0.290196, -0.850998>, <0.152019, -0.347822, -1.070483>, <0.155215, -0.334034, -1.215992>,
      <0.161040, -0.372179, -0.730963>, <0.150688, -0.284090, -0.847179>, <0.168496, -0.340006, -1.070483>, <0.171692, -0.326218, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.065445, -0.393917, -0.744775>, <0.057036, -0.299241, -0.850082>, <0.062428, -0.366501, -1.074627>, <0.061135, -0.354752, -1.215992>,
      <0.078133, -0.392142, -0.743611>, <0.069725, -0.297466, -0.848918>, <0.078332, -0.364127, -1.074627>, <0.077039, -0.352377, -1.215992>,
      <0.094869, -0.389114, -0.741130>, <0.083333, -0.297450, -0.851003>, <0.096272, -0.361224, -1.072995>, <0.098222, -0.348760, -1.215992>,
      <0.107291, -0.386289, -0.739335>, <0.095755, -0.294625, -0.849208>, <0.111842, -0.357205, -1.072995>, <0.113792, -0.344741, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.401224, -0.749129>, <0.000517, -0.304210, -0.850842>, <0.000517, -0.373525, -1.075933>, <0.000517, -0.361654, -1.215992>,
      <0.020162, -0.401267, -0.749132>, <0.020162, -0.304253, -0.850845>, <0.018820, -0.373525, -1.075933>, <0.018820, -0.361654, -1.215992>,
      <0.046069, -0.396627, -0.746552>, <0.037661, -0.301951, -0.851859>, <0.044326, -0.369204, -1.074627>, <0.043033, -0.357455, -1.215992>,
      <0.065445, -0.393917, -0.744775>, <0.057036, -0.299241, -0.850082>, <0.062428, -0.366501, -1.074627>, <0.061135, -0.354752, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.072261, -0.393615, -0.744755>, <-0.063246, -0.298962, -0.850036>, <-0.068390, -0.366411, -1.074621>, <-0.066731, -0.354752, -1.215992>,
      <-0.050507, -0.396337, -0.746487>, <-0.041492, -0.301684, -0.851768>, <-0.048285, -0.369068, -1.074621>, <-0.046626, -0.357409, -1.215992>,
      <-0.021475, -0.401176, -0.749126>, <-0.021475, -0.304161, -0.850839>, <-0.019763, -0.373525, -1.075933>, <-0.019763, -0.361654, -1.215992>,
      <0.000517, -0.401224, -0.749129>, <0.000517, -0.304210, -0.850842>, <0.000517, -0.373525, -1.075933>, <0.000517, -0.361654, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.122890, -0.385783, -0.739302>, <-0.112278, -0.294097, -0.849236>, <-0.126075, -0.357054, -1.072985>, <-0.127440, -0.344741, -1.215992>,
      <-0.107917, -0.389007, -0.741375>, <-0.097305, -0.297321, -0.851310>, <-0.108180, -0.361581, -1.072985>, <-0.109545, -0.349268, -1.215992>,
      <-0.087550, -0.391702, -0.743538>, <-0.078535, -0.297049, -0.848818>, <-0.086690, -0.363992, -1.074621>, <-0.085030, -0.352333, -1.215992>,
      <-0.072261, -0.393615, -0.744755>, <-0.063246, -0.298962, -0.850036>, <-0.068390, -0.366411, -1.074621>, <-0.066731, -0.354752, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.171877, -0.372165, -0.730962>, <-0.160609, -0.284143, -0.847123>, <-0.177228, -0.340002, -1.070483>, <-0.179521, -0.326218, -1.215992>,
      <-0.157829, -0.377617, -0.734405>, <-0.146561, -0.289595, -0.850566>, <-0.162260, -0.347140, -1.070483>, <-0.164553, -0.333356, -1.215992>,
      <-0.137864, -0.382559, -0.737229>, <-0.127252, -0.290873, -0.847163>, <-0.142152, -0.352986, -1.072985>, <-0.143517, -0.340674, -1.215992>,
      <-0.122890, -0.385783, -0.739302>, <-0.112278, -0.294097, -0.849236>, <-0.126075, -0.357054, -1.072985>, <-0.127440, -0.344741, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.243267, -0.339069, -0.709803>, <-0.233011, -0.252103, -0.834661>, <-0.238554, -0.306621, -1.064135>, <-0.236534, -0.292714, -1.215992>,
      <-0.223345, -0.351005, -0.717434>, <-0.213089, -0.264038, -0.842292>, <-0.222566, -0.318366, -1.064135>, <-0.220546, -0.304459, -1.215992>,
      <-0.194094, -0.363543, -0.725518>, <-0.182826, -0.275522, -0.841679>, <-0.195134, -0.331462, -1.070483>, <-0.197428, -0.317678, -1.215992>,
      <-0.171877, -0.372165, -0.730962>, <-0.160609, -0.284143, -0.847123>, <-0.177228, -0.340002, -1.070483>, <-0.179521, -0.326218, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.301686, -0.294394, -0.681239>, <-0.288915, -0.209320, -0.817503>, <-0.293621, -0.259773, -1.055566>, <-0.290164, -0.244935, -1.215992>,
      <-0.286800, -0.309897, -0.691152>, <-0.274030, -0.224823, -0.827416>, <-0.278990, -0.275593, -1.055566>, <-0.275534, -0.260755, -1.215992>,
      <-0.262556, -0.327513, -0.702414>, <-0.252300, -0.240546, -0.827273>, <-0.255919, -0.293863, -1.064135>, <-0.253900, -0.279957, -1.215992>,
      <-0.243267, -0.339069, -0.709803>, <-0.233011, -0.252103, -0.834661>, <-0.238554, -0.306621, -1.064135>, <-0.236534, -0.292714, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.367014, -0.210187, -0.627398>, <-0.354595, -0.121801, -0.780541>, <-0.362171, -0.174428, -1.039414>, <-0.360096, -0.159102, -1.215992>,
      <-0.349728, -0.237377, -0.643053>, <-0.337309, -0.148991, -0.796195>, <-0.344608, -0.202618, -1.039414>, <-0.342533, -0.187293, -1.215992>,
      <-0.324215, -0.270930, -0.666237>, <-0.311444, -0.185856, -0.802501>, <-0.316172, -0.235387, -1.055566>, <-0.312715, -0.220550, -1.215992>,
      <-0.301686, -0.294394, -0.681239>, <-0.288915, -0.209320, -0.817503>, <-0.293621, -0.259773, -1.055566>, <-0.290164, -0.244935, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.449516, -0.061871, -0.547365>, <-0.426818, 0.014097, -0.731991>, <-0.424063, -0.051829, -1.015404>, <-0.413154, -0.047525, -1.215992>,
      <-0.428485, -0.108605, -0.570656>, <-0.405788, -0.032637, -0.755282>, <-0.410437, -0.086298, -1.015404>, <-0.399528, -0.081994, -1.215992>,
      <-0.394179, -0.167459, -0.602797>, <-0.381760, -0.079073, -0.755940>, <-0.381771, -0.142969, -1.039414>, <-0.379696, -0.127643, -1.215992>,
      <-0.367014, -0.210187, -0.627398>, <-0.354595, -0.121801, -0.780541>, <-0.362171, -0.174428, -1.039414>, <-0.360096, -0.159102, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.485397, 0.052883, -0.496291>, <-0.463360, 0.077040, -0.710043>, <-0.457894, 0.056800, -1.000082>, <-0.446107, 0.058479, -1.215992>,
      <-0.478450, 0.016838, -0.510012>, <-0.456413, 0.040995, -0.723764>, <-0.451622, 0.024094, -1.000082>, <-0.439835, 0.025773, -1.215992>,
      <-0.464157, -0.029336, -0.531150>, <-0.441460, 0.046632, -0.715777>, <-0.436305, -0.020858, -1.015404>, <-0.425397, -0.016555, -1.215992>,
      <-0.449516, -0.061871, -0.547365>, <-0.426818, 0.014097, -0.731991>, <-0.424063, -0.051829, -1.015404>, <-0.413154, -0.047525, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.494335, 0.170677, -0.458841>, <-0.466315, 0.182585, -0.684259>, <-0.466321, 0.168173, -0.988847>, <-0.454315, 0.167100, -1.215992>,
      <-0.495012, 0.135024, -0.469358>, <-0.466992, 0.146932, -0.694776>, <-0.466938, 0.135500, -0.988847>, <-0.454932, 0.134427, -1.215992>,
      <-0.491988, 0.087078, -0.483274>, <-0.469950, 0.111236, -0.697026>, <-0.464049, 0.088895, -1.000082>, <-0.452262, 0.090573, -1.215992>,
      <-0.485397, 0.052883, -0.496291>, <-0.463360, 0.077040, -0.710043>, <-0.457894, 0.056800, -1.000082>, <-0.446107, 0.058479, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.481021, 0.283437, -0.428282>, <-0.451152, 0.283554, -0.663020>, <-0.453773, 0.274738, -0.979679>, <-0.442095, 0.271010, -1.215992>,
      <-0.491206, 0.250846, -0.437138>, <-0.461337, 0.250963, -0.671876>, <-0.463104, 0.244769, -0.979679>, <-0.451426, 0.241041, -1.215992>,
      <-0.493693, 0.204505, -0.448862>, <-0.465673, 0.216414, -0.674280>, <-0.465729, 0.199555, -0.988847>, <-0.453723, 0.198482, -1.215992>,
      <-0.494335, 0.170677, -0.458841>, <-0.466315, 0.182585, -0.684259>, <-0.466321, 0.168173, -0.988847>, <-0.454315, 0.167100, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.404834, 0.457063, -0.381021>, <-0.370972, 0.438093, -0.628804>, <-0.381951, 0.438828, -0.965501>, <-0.372144, 0.431013, -1.215992>,
      <-0.436392, 0.408985, -0.392387>, <-0.402530, 0.390014, -0.640171>, <-0.410635, 0.394991, -0.965501>, <-0.400828, 0.387176, -1.215992>,
      <-0.464095, 0.337598, -0.413565>, <-0.434225, 0.337715, -0.648303>, <-0.438199, 0.324757, -0.979679>, <-0.426521, 0.321029, -1.215992>,
      <-0.481021, 0.283437, -0.428282>, <-0.451152, 0.283554, -0.663020>, <-0.453773, 0.274738, -0.979679>, <-0.442095, 0.271010, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.289912, 0.574592, -0.359450>, <-0.260456, 0.538926, -0.612534>, <-0.273609, 0.549807, -0.959029>, <-0.266622, 0.539185, -1.215992>,
      <-0.325917, 0.540589, -0.364045>, <-0.296460, 0.504922, -0.617130>, <-0.306542, 0.518652, -0.959029>, <-0.299555, 0.508030, -1.215992>,
      <-0.378060, 0.497853, -0.371378>, <-0.344198, 0.478883, -0.619161>, <-0.357129, 0.476764, -0.965501>, <-0.347322, 0.468949, -1.215992>,
      <-0.404834, 0.457063, -0.381021>, <-0.370972, 0.438093, -0.628804>, <-0.381951, 0.438828, -0.965501>, <-0.372144, 0.431013, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.221828, 0.629897, -0.357664>, <-0.201143, 0.592684, -0.611956>, <-0.209422, 0.601955, -0.958494>, <-0.204105, 0.589980, -1.215992>,
      <-0.242253, 0.613305, -0.358200>, <-0.221568, 0.576093, -0.612492>, <-0.228177, 0.586717, -0.958494>, <-0.222860, 0.574742, -1.215992>,
      <-0.270858, 0.592587, -0.357018>, <-0.241402, 0.556920, -0.610102>, <-0.256054, 0.566414, -0.959029>, <-0.249067, 0.555792, -1.215992>,
      <-0.289912, 0.574592, -0.359450>, <-0.260456, 0.538926, -0.612534>, <-0.273609, 0.549807, -0.959029>, <-0.266622, 0.539185, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.101969, 0.673699, -0.360023>, <-0.082683, 0.637059, -0.613801>, <-0.096424, 0.643223, -0.959201>, <-0.094048, 0.630162, -1.215992>,
      <-0.138657, 0.663932, -0.355048>, <-0.119371, 0.627292, -0.608826>, <-0.130399, 0.634215, -0.959201>, <-0.128023, 0.621154, -1.215992>,
      <-0.185870, 0.643038, -0.358372>, <-0.165185, 0.605825, -0.612664>, <-0.176405, 0.614010, -0.958494>, <-0.171088, 0.602035, -1.215992>,
      <-0.221828, 0.629897, -0.357664>, <-0.201143, 0.592684, -0.611956>, <-0.209422, 0.601955, -0.958494>, <-0.204105, 0.589980, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, 0.689090, -0.387815>, <0.000517, 0.651599, -0.633791>, <0.000517, 0.657690, -0.967539>, <0.000517, 0.644233, -1.215992>,
      <-0.031665, 0.688852, -0.388420>, <-0.031665, 0.651360, -0.634397>, <-0.028165, 0.657690, -0.967539>, <-0.028165, 0.644233, -1.215992>,
      <-0.071127, 0.681910, -0.364205>, <-0.051841, 0.645270, -0.617983>, <-0.068700, 0.650574, -0.959201>, <-0.066324, 0.637513, -1.215992>,
      <-0.101969, 0.673699, -0.360023>, <-0.082683, 0.637059, -0.613801>, <-0.096424, 0.643223, -0.959201>, <-0.094048, 0.630162, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, 0.689090, -0.387815>, <0.028979, 0.689301, -0.387280>, <0.061730, 0.682474, -0.360180>, <0.088974, 0.675114, -0.356431>,
      <0.000517, 0.651599, -0.633791>, <0.028979, 0.651810, -0.633256>, <0.042089, 0.645688, -0.615012>, <0.069333, 0.638328, -0.611263>,
      <0.000517, 0.657690, -0.967539>, <0.028094, 0.657690, -0.967539>, <0.064020, 0.650843, -0.958124>, <0.090641, 0.643648, -0.958124>,
      <0.000517, 0.644233, -1.215992>, <0.028094, 0.644233, -1.215992>, <0.064735, 0.637358, -1.215992>, <0.091356, 0.630162, -1.215992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147380, -0.888722, -0.045413>, <-0.145471, -0.887734, -0.029920>, <-0.138390, -0.877583, -0.011703>, <-0.135831, -0.870891, 0.002201>,
      <-0.148734, -0.889423, -0.056401>, <-0.146825, -0.888435, -0.040908>, <-0.149473, -0.870618, -0.025240>, <-0.146915, -0.863925, -0.011336>,
      <-0.147563, -0.879852, -0.069823>, <-0.156004, -0.872035, -0.064952>, <-0.168396, -0.859211, -0.043496>, <-0.166872, -0.858421, -0.031122>,
      <-0.145980, -0.876143, -0.080157>, <-0.154421, -0.868326, -0.075287>, <-0.170695, -0.860400, -0.062149>, <-0.169170, -0.859611, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147380, -0.888722, -0.045413>, <-0.145471, -0.887734, -0.029920>, <-0.138390, -0.877583, -0.011703>, <-0.135831, -0.870891, 0.002201>,
      <-0.147380, -0.888722, -0.045413>, <-0.153101, -0.880301, -0.032611>, <-0.149473, -0.870618, -0.025240>, <-0.146915, -0.863925, -0.011336>,
      <-0.147380, -0.888722, -0.045413>, <-0.153101, -0.880301, -0.032611>, <-0.162736, -0.868568, -0.031939>, <-0.166872, -0.858421, -0.031122>,
      <-0.147380, -0.888722, -0.045413>, <-0.155011, -0.881289, -0.048104>, <-0.165034, -0.869757, -0.050591>, <-0.169170, -0.859611, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.147380, -0.888722, -0.045413>, <-0.148734, -0.889423, -0.056401>, <-0.147563, -0.879852, -0.069823>, <-0.145980, -0.876143, -0.080157>,
      <-0.147380, -0.888722, -0.045413>, <-0.156365, -0.881990, -0.059092>, <-0.156004, -0.872035, -0.064952>, <-0.154421, -0.868326, -0.075287>,
      <-0.147380, -0.888722, -0.045413>, <-0.156365, -0.881990, -0.059092>, <-0.166559, -0.870546, -0.062966>, <-0.170695, -0.860400, -0.062149>,
      <-0.147380, -0.888722, -0.045413>, <-0.155011, -0.881289, -0.048104>, <-0.165034, -0.869757, -0.050591>, <-0.169170, -0.859611, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.037896, -0.906729, -0.049223>, <0.037832, -0.907797, -0.035208>, <0.049485, -0.940334, -0.054899>, <0.050716, -0.951726, -0.046758>,
      <0.019585, -0.911887, -0.046684>, <0.019521, -0.912955, -0.032669>, <0.029746, -0.958030, -0.038141>, <0.030977, -0.969422, -0.029999>,
      <0.021393, -0.910251, -0.102203>, <0.020722, -0.921993, -0.056439>, <0.026718, -0.991039, -0.030731>, <0.026232, -1.016537, 0.009046>,
      <0.002200, -0.910209, -0.102200>, <0.001530, -0.921951, -0.056437>, <-0.004217, -0.990596, -0.025584>, <-0.004703, -1.016093, 0.014193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213828, -0.842543, -0.345421>, <0.231860, -0.836204, -0.321871>, <0.251408, -0.833162, -0.286191>, <0.267513, -0.829141, -0.260806>,
      <0.213741, -0.845705, -0.329805>, <0.231773, -0.839367, -0.306255>, <0.240275, -0.837592, -0.285924>, <0.256381, -0.833571, -0.260539>,
      <0.226661, -0.846680, -0.309041>, <0.231867, -0.843130, -0.305845>, <0.243978, -0.833356, -0.283358>, <0.248571, -0.828187, -0.281908>,
      <0.223535, -0.847465, -0.293437>, <0.228741, -0.843915, -0.290241>, <0.234252, -0.835403, -0.290055>, <0.238845, -0.830234, -0.288605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213828, -0.842543, -0.345421>, <0.213741, -0.845705, -0.329805>, <0.226661, -0.846680, -0.309041>, <0.223535, -0.847465, -0.293437>,
      <0.195124, -0.849118, -0.369848>, <0.195037, -0.852280, -0.354232>, <0.203592, -0.862414, -0.323203>, <0.200466, -0.863198, -0.307599>,
      <0.168986, -0.862710, -0.400443>, <0.166824, -0.867933, -0.378005>, <0.174086, -0.874809, -0.355807>, <0.170591, -0.878928, -0.333306>,
      <0.145856, -0.871906, -0.419685>, <0.143695, -0.877128, -0.397246>, <0.149372, -0.889521, -0.368178>, <0.145876, -0.893639, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.083294, -0.894439, -0.454013>, <0.104015, -0.888746, -0.447513>, <0.129351, -0.878468, -0.433416>, <0.145856, -0.871906, -0.419685>,
      <0.081006, -0.901699, -0.425893>, <0.101727, -0.896006, -0.419393>, <0.127190, -0.883690, -0.410977>, <0.143695, -0.877128, -0.397246>,
      <0.084605, -0.923964, -0.392315>, <0.105534, -0.915970, -0.386678>, <0.131136, -0.900375, -0.377307>, <0.149372, -0.889521, -0.368178>,
      <0.081719, -0.931880, -0.364428>, <0.102648, -0.923886, -0.358791>, <0.127640, -0.904494, -0.354807>, <0.145876, -0.893639, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.911839, -0.465280>, <0.026117, -0.911839, -0.465280>, <0.059666, -0.900931, -0.461425>, <0.083294, -0.894439, -0.454013>,
      <0.000778, -0.917966, -0.439299>, <0.026378, -0.917966, -0.439299>, <0.057378, -0.908191, -0.433305>, <0.081006, -0.901699, -0.425893>,
      <0.003418, -0.941351, -0.409892>, <0.028116, -0.941406, -0.409897>, <0.062230, -0.932509, -0.398342>, <0.084605, -0.923964, -0.392315>,
      <0.003418, -0.948050, -0.384051>, <0.028116, -0.948104, -0.384057>, <0.059344, -0.940426, -0.370455>, <0.081719, -0.931880, -0.364428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.096191, -0.894439, -0.454013>, <-0.068337, -0.901175, -0.461705>, <-0.029154, -0.911839, -0.465280>, <0.000517, -0.911839, -0.465280>,
      <-0.093529, -0.901683, -0.425815>, <-0.065675, -0.908420, -0.433506>, <-0.028893, -0.917966, -0.439299>, <0.000778, -0.917966, -0.439299>,
      <-0.091675, -0.923715, -0.392124>, <-0.065606, -0.932315, -0.398189>, <-0.024694, -0.941290, -0.409885>, <0.003418, -0.941351, -0.409892>,
      <-0.086699, -0.931511, -0.364390>, <-0.060631, -0.940111, -0.370455>, <-0.024694, -0.947989, -0.384045>, <0.003418, -0.948050, -0.384051>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.096191, -0.894439, -0.454013>, <-0.093529, -0.901683, -0.425815>, <-0.091675, -0.923715, -0.392124>, <-0.086699, -0.931511, -0.364390>,
      <-0.118662, -0.889005, -0.447808>, <-0.116000, -0.896249, -0.419610>, <-0.115576, -0.915830, -0.386563>, <-0.110600, -0.923626, -0.358829>,
      <-0.147229, -0.879006, -0.434542>, <-0.145587, -0.884254, -0.412046>, <-0.148528, -0.905208, -0.378151>, <-0.143624, -0.909149, -0.355863>,
      <-0.164602, -0.871906, -0.419685>, <-0.162960, -0.877153, -0.397189>, <-0.166418, -0.889698, -0.367965>, <-0.161514, -0.893639, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.223169, -0.842543, -0.345421>, <-0.221700, -0.844741, -0.328977>, <-0.213385, -0.824474, -0.310692>, <-0.209393, -0.825139, -0.294536>,
      <-0.208378, -0.849778, -0.370150>, <-0.206909, -0.851976, -0.353707>, <-0.197835, -0.844739, -0.325237>, <-0.193844, -0.845404, -0.309081>,
      <-0.186165, -0.863093, -0.401245>, <-0.184522, -0.868341, -0.378748>, <-0.186820, -0.872010, -0.356350>, <-0.181916, -0.875951, -0.334062>,
      <-0.164602, -0.871906, -0.419685>, <-0.162960, -0.877153, -0.397189>, <-0.166418, -0.889698, -0.367965>, <-0.161514, -0.893639, -0.345678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.223169, -0.842543, -0.345421>, <-0.234603, -0.836950, -0.326305>, <-0.242636, -0.833522, -0.296316>, <-0.250979, -0.829656, -0.275271>,
      <-0.221700, -0.844741, -0.328977>, <-0.233134, -0.839148, -0.309861>, <-0.228901, -0.837408, -0.297395>, <-0.237244, -0.833542, -0.276350>,
      <-0.213385, -0.824474, -0.310692>, <-0.214580, -0.822917, -0.309574>, <-0.222229, -0.833773, -0.293084>, <-0.222482, -0.835274, -0.294754>,
      <-0.209393, -0.825139, -0.294536>, <-0.210588, -0.823581, -0.293418>, <-0.209983, -0.828641, -0.298432>, <-0.210236, -0.830142, -0.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.208529, -0.864211, -0.279004>, <-0.210220, -0.863981, -0.283305>, <-0.212389, -0.860138, -0.289275>, <-0.211139, -0.856895, -0.292330>,
      <-0.221689, -0.854792, -0.282003>, <-0.223381, -0.854563, -0.286304>, <-0.218584, -0.854737, -0.290813>, <-0.217334, -0.851494, -0.293868>,
      <-0.238244, -0.840023, -0.276391>, <-0.224509, -0.843909, -0.277469>, <-0.222753, -0.843300, -0.292422>, <-0.210507, -0.838168, -0.297770>,
      <-0.250979, -0.829656, -0.275271>, <-0.237244, -0.833542, -0.276350>, <-0.222482, -0.835274, -0.294754>, <-0.210236, -0.830142, -0.300102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.145727, -0.904982, -0.251286>, <-0.147442, -0.906068, -0.261270>, <-0.129750, -0.904747, -0.269803>, <-0.126733, -0.902946, -0.279366>,
      <-0.166718, -0.895652, -0.258072>, <-0.168433, -0.896738, -0.268056>, <-0.156244, -0.892784, -0.271275>, <-0.153227, -0.890983, -0.280838>,
      <-0.189377, -0.877918, -0.274640>, <-0.191068, -0.877688, -0.278941>, <-0.190825, -0.878939, -0.283920>, <-0.189575, -0.875696, -0.286975>,
      <-0.208529, -0.864211, -0.279004>, <-0.210220, -0.863981, -0.283305>, <-0.212389, -0.860138, -0.289275>, <-0.211139, -0.856895, -0.292330>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.043809, -0.937424, -0.225753>, <-0.043568, -0.939435, -0.242820>, <-0.043032, -0.935108, -0.265910>, <-0.040204, -0.934077, -0.282831>,
      <-0.075161, -0.927470, -0.228252>, <-0.074920, -0.929481, -0.245319>, <-0.069622, -0.927699, -0.266377>, <-0.066794, -0.926668, -0.283298>,
      <-0.116817, -0.917832, -0.241940>, <-0.118532, -0.918918, -0.251924>, <-0.104621, -0.916093, -0.268406>, <-0.101604, -0.914292, -0.277970>,
      <-0.145727, -0.904982, -0.251286>, <-0.147442, -0.906068, -0.261270>, <-0.129750, -0.904747, -0.269803>, <-0.126733, -0.902946, -0.279366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.043809, -0.937424, -0.225753>, <-0.030398, -0.941682, -0.224684>, <-0.015067, -0.950908, -0.238872>, <-0.000983, -0.950939, -0.239750>,
      <-0.043568, -0.939435, -0.242820>, <-0.030157, -0.943693, -0.241751>, <-0.015155, -0.952798, -0.250550>, <-0.001070, -0.952828, -0.251428>,
      <-0.043032, -0.935108, -0.265910>, <-0.030975, -0.938468, -0.265698>, <-0.011923, -0.939975, -0.265507>, <0.000557, -0.940953, -0.265556>,
      <-0.040204, -0.934077, -0.282831>, <-0.028147, -0.937437, -0.282619>, <-0.011588, -0.937530, -0.277077>, <0.000892, -0.938508, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051559, -0.937631, -0.231696>, <0.035928, -0.942634, -0.230756>, <0.015424, -0.950975, -0.240772>, <-0.000983, -0.950939, -0.239750>,
      <0.049057, -0.929563, -0.176668>, <0.033426, -0.934565, -0.175728>, <0.015742, -0.944100, -0.198279>, <-0.000665, -0.944065, -0.197257>,
      <0.038149, -0.902498, -0.104734>, <0.019838, -0.907656, -0.102195>, <0.022003, -0.899554, -0.143895>, <0.002811, -0.899512, -0.143892>,
      <0.037896, -0.906729, -0.049223>, <0.019585, -0.911887, -0.046684>, <0.021393, -0.910251, -0.102203>, <0.002200, -0.910209, -0.102200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051559, -0.937631, -0.231696>, <0.052256, -0.939878, -0.247020>, <0.050748, -0.941110, -0.267830>, <0.048535, -0.941032, -0.283175>,
      <0.035928, -0.942634, -0.230756>, <0.036625, -0.944881, -0.246080>, <0.036959, -0.944982, -0.266090>, <0.034746, -0.944904, -0.281435>,
      <0.015424, -0.950975, -0.240772>, <0.015337, -0.952864, -0.252450>, <0.014940, -0.942080, -0.265611>, <0.015275, -0.939635, -0.277181>,
      <-0.000983, -0.950939, -0.239750>, <-0.001070, -0.952828, -0.251428>, <0.000557, -0.940953, -0.265556>, <0.000892, -0.938508, -0.277125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.051559, -0.937631, -0.231696>, <0.079558, -0.928670, -0.233380>, <0.117427, -0.918334, -0.240984>, <0.142607, -0.904982, -0.248385>,
      <0.052256, -0.939878, -0.247020>, <0.080255, -0.930917, -0.248704>, <0.120250, -0.919719, -0.254862>, <0.145430, -0.906366, -0.262263>,
      <0.050748, -0.941110, -0.267830>, <0.075764, -0.934086, -0.270987>, <0.108904, -0.918516, -0.279169>, <0.131564, -0.905432, -0.279848>,
      <0.048535, -0.941032, -0.283175>, <0.073551, -0.934008, -0.286332>, <0.103893, -0.916310, -0.292303>, <0.126552, -0.903226, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202837, -0.857410, -0.276161>, <0.204131, -0.857153, -0.279671>, <0.201123, -0.854898, -0.284388>, <0.200035, -0.853555, -0.287715>,
      <0.181982, -0.870073, -0.274087>, <0.183276, -0.869816, -0.277597>, <0.178785, -0.869417, -0.285258>, <0.177698, -0.868074, -0.288586>,
      <0.163546, -0.893878, -0.254539>, <0.166369, -0.895263, -0.268417>, <0.154640, -0.892108, -0.280540>, <0.149628, -0.889902, -0.293674>,
      <0.142607, -0.904982, -0.248385>, <0.145430, -0.906366, -0.262263>, <0.131564, -0.905432, -0.279848>, <0.126552, -0.903226, -0.292982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.202837, -0.857410, -0.276161>, <0.204131, -0.857153, -0.279671>, <0.201123, -0.854898, -0.284388>, <0.200035, -0.853555, -0.287715>,
      <0.221294, -0.846203, -0.277996>, <0.222588, -0.845946, -0.281506>, <0.212507, -0.847498, -0.283944>, <0.211420, -0.846155, -0.287271>,
      <0.248110, -0.837622, -0.265413>, <0.236978, -0.842052, -0.265145>, <0.236928, -0.835183, -0.281641>, <0.227202, -0.837230, -0.288338>,
      <0.267513, -0.829141, -0.260806>, <0.256381, -0.833571, -0.260539>, <0.248571, -0.828187, -0.281908>, <0.238845, -0.830234, -0.288605>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.225319, -0.782561, -0.613940>, <0.210281, -0.795604, -0.621905>, <0.191666, -0.814409, -0.633730>, <0.174246, -0.825091, -0.640220>,
      <0.214124, -0.682808, -0.695705>, <0.199086, -0.695851, -0.703670>, <0.182635, -0.700689, -0.708584>, <0.165215, -0.711371, -0.715074>,
      <0.170207, -0.450188, -0.628045>, <0.154964, -0.456295, -0.631864>, <0.134535, -0.469712, -0.632551>, <0.118256, -0.473413, -0.634903>,
      <0.161040, -0.372179, -0.730963>, <0.145797, -0.378285, -0.734782>, <0.123570, -0.382587, -0.736983>, <0.107291, -0.386289, -0.739335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.225319, -0.782561, -0.613940>, <0.232463, -0.846214, -0.561766>, <0.214279, -0.826146, -0.426389>, <0.213828, -0.842543, -0.345421>,
      <0.210281, -0.795604, -0.621905>, <0.217424, -0.859257, -0.569731>, <0.195574, -0.832721, -0.450817>, <0.195124, -0.849118, -0.369848>,
      <0.191666, -0.814409, -0.633730>, <0.196178, -0.871224, -0.596332>, <0.175353, -0.847326, -0.466548>, <0.168986, -0.862710, -0.400443>,
      <0.174246, -0.825091, -0.640220>, <0.178758, -0.881907, -0.602822>, <0.152223, -0.856522, -0.485789>, <0.145856, -0.871906, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.782449, -0.613909>, <-0.244870, -0.846151, -0.561696>, <-0.230460, -0.831634, -0.427031>, <-0.223169, -0.842543, -0.345421>,
      <-0.222355, -0.796048, -0.622200>, <-0.229301, -0.859750, -0.569987>, <-0.215668, -0.838869, -0.451760>, <-0.208378, -0.849778, -0.370150>,
      <-0.201297, -0.814052, -0.633621>, <-0.206151, -0.870619, -0.596429>, <-0.190979, -0.847714, -0.467175>, <-0.186165, -0.863093, -0.401245>,
      <-0.183020, -0.824933, -0.640226>, <-0.187874, -0.881500, -0.603035>, <-0.169416, -0.856527, -0.485616>, <-0.164602, -0.871906, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.782449, -0.613909>, <-0.227040, -0.682631, -0.695724>, <-0.181861, -0.450156, -0.628038>, <-0.171877, -0.372165, -0.730962>,
      <-0.222355, -0.796048, -0.622200>, <-0.211471, -0.696231, -0.704014>, <-0.167813, -0.455608, -0.631480>, <-0.157829, -0.377617, -0.734405>,
      <-0.201297, -0.814052, -0.633621>, <-0.191553, -0.700492, -0.708285>, <-0.147938, -0.469590, -0.632875>, <-0.137864, -0.382559, -0.737229>,
      <-0.183020, -0.824933, -0.640226>, <-0.173276, -0.711373, -0.714890>, <-0.132964, -0.472814, -0.634949>, <-0.122890, -0.385783, -0.739302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.782449, -0.613909>, <-0.254034, -0.768377, -0.605330>, <-0.273670, -0.748459, -0.592409>, <-0.288441, -0.732848, -0.584087>,
      <-0.244870, -0.846151, -0.561696>, <-0.260980, -0.832079, -0.553118>, <-0.274821, -0.821619, -0.527609>, <-0.289591, -0.806008, -0.519286>,
      <-0.230460, -0.831634, -0.427031>, <-0.241893, -0.826042, -0.407915>, <-0.263363, -0.815538, -0.390123>, <-0.271706, -0.811672, -0.369078>,
      <-0.223169, -0.842543, -0.345421>, <-0.234603, -0.836950, -0.326305>, <-0.242636, -0.833522, -0.296316>, <-0.250979, -0.829656, -0.275271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.237924, -0.782449, -0.613909>, <-0.227040, -0.682631, -0.695724>, <-0.181861, -0.450156, -0.628038>, <-0.171877, -0.372165, -0.730962>,
      <-0.254034, -0.768377, -0.605330>, <-0.243149, -0.668559, -0.687145>, <-0.204078, -0.441535, -0.622594>, <-0.194094, -0.363543, -0.725518>,
      <-0.273670, -0.748459, -0.592409>, <-0.272203, -0.655083, -0.675116>, <-0.231735, -0.422141, -0.615302>, <-0.223345, -0.351005, -0.717434>,
      <-0.288441, -0.732848, -0.584087>, <-0.286973, -0.639472, -0.666794>, <-0.251657, -0.410206, -0.607672>, <-0.243267, -0.339069, -0.709803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.138035, -0.866827, -0.106417>, <-0.154791, -0.863630, -0.159687>, <-0.188086, -0.866989, -0.227014>, <-0.208529, -0.864211, -0.279004>,
      <-0.152646, -0.856806, -0.091173>, <-0.169403, -0.853609, -0.144443>, <-0.201246, -0.857570, -0.230013>, <-0.221689, -0.854792, -0.282003>,
      <-0.169457, -0.839844, -0.064412>, <-0.167999, -0.851606, -0.137936>, <-0.222451, -0.853726, -0.204913>, <-0.238244, -0.840023, -0.276391>,
      <-0.168496, -0.836921, -0.041242>, <-0.167038, -0.848683, -0.114766>, <-0.235185, -0.843360, -0.203793>, <-0.250979, -0.829656, -0.275271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.138035, -0.866827, -0.106417>, <-0.152646, -0.856806, -0.091173>, <-0.169457, -0.839844, -0.064412>, <-0.168496, -0.836921, -0.041242>,
      <-0.135431, -0.867324, -0.098139>, <-0.150043, -0.857302, -0.082895>, <-0.162630, -0.841761, -0.066039>, <-0.161669, -0.838839, -0.042869>,
      <-0.144740, -0.873237, -0.088255>, <-0.153181, -0.865419, -0.083384>, <-0.173433, -0.853682, -0.061608>, <-0.171909, -0.852893, -0.049233>,
      <-0.145980, -0.876143, -0.080157>, <-0.154421, -0.868326, -0.075287>, <-0.170695, -0.860400, -0.062149>, <-0.169170, -0.859611, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141058, -0.888722, -0.045413>, <0.138859, -0.887695, -0.029896>, <0.131417, -0.877591, -0.011718>, <0.128581, -0.870891, 0.002201>,
      <0.142497, -0.889394, -0.055567>, <0.140298, -0.888367, -0.040050>, <0.141479, -0.870843, -0.024836>, <0.138643, -0.864143, -0.010917>,
      <0.141079, -0.879598, -0.067655>, <0.147316, -0.872225, -0.063096>, <0.154310, -0.859174, -0.042685>, <0.152815, -0.858476, -0.032134>,
      <0.139841, -0.876152, -0.077257>, <0.146078, -0.868779, -0.072698>, <0.156810, -0.860343, -0.060327>, <0.155315, -0.859644, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141058, -0.888722, -0.045413>, <0.142497, -0.889394, -0.055567>, <0.141079, -0.879598, -0.067655>, <0.139841, -0.876152, -0.077257>,
      <0.141058, -0.888722, -0.045413>, <0.145829, -0.880410, -0.057634>, <0.147316, -0.872225, -0.063096>, <0.146078, -0.868779, -0.072698>,
      <0.141058, -0.888722, -0.045413>, <0.145829, -0.880410, -0.057634>, <0.153113, -0.869393, -0.061056>, <0.156810, -0.860343, -0.060327>,
      <0.141058, -0.888722, -0.045413>, <0.144391, -0.879737, -0.047481>, <0.151618, -0.868694, -0.050505>, <0.155315, -0.859644, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.141058, -0.888722, -0.045413>, <0.144391, -0.879737, -0.047481>, <0.151618, -0.868694, -0.050505>, <0.155315, -0.859644, -0.049776>,
      <0.141058, -0.888722, -0.045413>, <0.142192, -0.878710, -0.031964>, <0.149118, -0.867526, -0.032863>, <0.152815, -0.858476, -0.032134>,
      <0.141058, -0.888722, -0.045413>, <0.142192, -0.878710, -0.031964>, <0.141479, -0.870843, -0.024836>, <0.138643, -0.864143, -0.010917>,
      <0.141058, -0.888722, -0.045413>, <0.138859, -0.887695, -0.029896>, <0.131417, -0.877591, -0.011718>, <0.128581, -0.870891, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.133196, -0.866827, -0.106417>, <0.149770, -0.861896, -0.158749>, <0.183817, -0.861187, -0.224570>, <0.202837, -0.857410, -0.276161>,
      <0.147914, -0.856913, -0.091460>, <0.164489, -0.851982, -0.143792>, <0.202274, -0.849980, -0.226406>, <0.221294, -0.846203, -0.277996>,
      <0.163671, -0.839820, -0.064222>, <0.165364, -0.851612, -0.136334>, <0.232854, -0.851035, -0.195203>, <0.248110, -0.837622, -0.265413>,
      <0.162220, -0.836921, -0.041242>, <0.163913, -0.848714, -0.113354>, <0.252257, -0.842554, -0.190597>, <0.267513, -0.829141, -0.260806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.133196, -0.866827, -0.106417>, <0.130370, -0.867668, -0.097493>, <0.138709, -0.873000, -0.086038>, <0.139841, -0.876152, -0.077257>,
      <0.147914, -0.856913, -0.091460>, <0.145088, -0.857754, -0.082536>, <0.144946, -0.865627, -0.081480>, <0.146078, -0.868779, -0.072698>,
      <0.163671, -0.839820, -0.064222>, <0.156316, -0.841459, -0.064947>, <0.159665, -0.853353, -0.059764>, <0.156810, -0.860343, -0.060327>,
      <0.162220, -0.836921, -0.041242>, <0.154865, -0.838561, -0.041967>, <0.158170, -0.852655, -0.049213>, <0.155315, -0.859644, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.352649, -0.661193, -0.549270>, <-0.334806, -0.683483, -0.560542>, <-0.308114, -0.712055, -0.573003>, <-0.288441, -0.732848, -0.584087>,
      <-0.347316, -0.568223, -0.621644>, <-0.329473, -0.590512, -0.632915>, <-0.306646, -0.618679, -0.655709>, <-0.286973, -0.639472, -0.666794>,
      <-0.311032, -0.356658, -0.581511>, <-0.296147, -0.372161, -0.591423>, <-0.270946, -0.398649, -0.600283>, <-0.251657, -0.410206, -0.607672>,
      <-0.301686, -0.294394, -0.681239>, <-0.286800, -0.309897, -0.691152>, <-0.262556, -0.327513, -0.702414>, <-0.243267, -0.339069, -0.709803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.677951, -0.194697, 0.458256>, <-0.679664, -0.135888, 0.496637>, <-0.673951, -0.044485, 0.528023>, <-0.671937, 0.024754, 0.539703>,
      <-0.683603, -0.101230, 0.425490>, <-0.685316, -0.042421, 0.463872>, <-0.672769, -0.003841, 0.534879>, <-0.670755, 0.065399, 0.546559>,
      <-0.674563, 0.036440, 0.446151>, <-0.673458, 0.043119, 0.469587>, <-0.668207, 0.110543, 0.502040>, <-0.668916, 0.119735, 0.524626>,
      <-0.673111, 0.135499, 0.440963>, <-0.672007, 0.142178, 0.464400>, <-0.666912, 0.151249, 0.495578>, <-0.667621, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.668869, -0.194697, 0.458256>, <0.674260, -0.101222, 0.425488>, <0.666668, 0.036440, 0.446151>, <0.665725, 0.135499, 0.440963>,
      <0.670848, -0.136016, 0.496572>, <0.676239, -0.042541, 0.463804>, <0.665975, 0.043108, 0.469549>, <0.665032, 0.142167, 0.464361>,
      <0.667884, -0.044775, 0.528015>, <0.667556, -0.004018, 0.534891>, <0.665210, 0.110452, 0.502101>, <0.664813, 0.151277, 0.495647>,
      <0.667327, 0.024357, 0.539677>, <0.666998, 0.065114, 0.546552>, <0.666402, 0.119616, 0.524618>, <0.666006, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.374191, -0.810852, -0.028206>, <0.314664, -0.829753, -0.043027>, <0.224584, -0.823019, -0.035096>, <0.162220, -0.836921, -0.041242>,
      <0.367293, -0.821473, -0.107454>, <0.307767, -0.840374, -0.122275>, <0.226277, -0.834811, -0.107208>, <0.163913, -0.848714, -0.113354>,
      <0.329471, -0.818237, -0.213671>, <0.312043, -0.831095, -0.212232>, <0.272420, -0.834530, -0.191080>, <0.252257, -0.842554, -0.190597>,
      <0.324554, -0.796124, -0.290661>, <0.307126, -0.808982, -0.289222>, <0.287676, -0.821117, -0.261290>, <0.267513, -0.829141, -0.260806>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.330468, -0.796124, -0.290661>, <-0.308316, -0.810281, -0.290875>, <-0.276204, -0.822519, -0.273290>, <-0.250979, -0.829656, -0.275271>,
      <-0.328519, -0.773850, -0.375526>, <-0.306367, -0.788008, -0.375740>, <-0.296932, -0.804534, -0.367097>, <-0.271706, -0.811672, -0.369078>,
      <-0.356618, -0.730373, -0.495416>, <-0.338775, -0.752663, -0.506687>, <-0.309264, -0.785215, -0.508202>, <-0.289591, -0.806008, -0.519286>,
      <-0.352649, -0.661193, -0.549270>, <-0.334806, -0.683483, -0.560542>, <-0.308114, -0.712055, -0.573003>, <-0.288441, -0.732848, -0.584087>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.365195, -0.804551, -0.003063>, <-0.306938, -0.820527, -0.010714>, <-0.225633, -0.820872, -0.027627>, <-0.168496, -0.836921, -0.041242>,
      <-0.357634, -0.816056, -0.088909>, <-0.299377, -0.832031, -0.096560>, <-0.224176, -0.832634, -0.101151>, <-0.167038, -0.848683, -0.114766>,
      <-0.332399, -0.818190, -0.206587>, <-0.310247, -0.832347, -0.206801>, <-0.260411, -0.836222, -0.201812>, <-0.235185, -0.843360, -0.203793>,
      <-0.330468, -0.796124, -0.290661>, <-0.308316, -0.810281, -0.290875>, <-0.276204, -0.822519, -0.273290>, <-0.250979, -0.829656, -0.275271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.043502, -0.906550, -0.049212>, <-0.044803, -0.907534, -0.033909>, <-0.058509, -0.936906, -0.035826>, <-0.060603, -0.950129, -0.028236>,
      <-0.023251, -0.911625, -0.046761>, <-0.024552, -0.912609, -0.031458>, <-0.041112, -0.953696, -0.020005>, <-0.043206, -0.966919, -0.012415>,
      <-0.018821, -0.910163, -0.102197>, <-0.019491, -0.921904, -0.056434>, <-0.032716, -0.990187, -0.020842>, <-0.033202, -1.015684, 0.018935>,
      <0.002200, -0.910209, -0.102200>, <0.001530, -0.921951, -0.056437>, <-0.004217, -0.990596, -0.025584>, <-0.004703, -1.016093, 0.014193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.043502, -0.906550, -0.049212>, <-0.023251, -0.911625, -0.046761>, <-0.018821, -0.910163, -0.102197>, <0.002200, -0.910209, -0.102200>,
      <-0.038956, -0.903111, -0.102675>, <-0.018705, -0.908186, -0.100224>, <-0.018210, -0.899466, -0.143889>, <0.002811, -0.899512, -0.143892>,
      <-0.044563, -0.931133, -0.172362>, <-0.031151, -0.935391, -0.171293>, <-0.014750, -0.944034, -0.196379>, <-0.000665, -0.944065, -0.197257>,
      <-0.043809, -0.937424, -0.225753>, <-0.030398, -0.941682, -0.224684>, <-0.015067, -0.950908, -0.238872>, <-0.000983, -0.950939, -0.239750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.110700, -0.979929, -0.022097>, <0.128187, -0.959052, -0.033884>, <0.130971, -0.915918, -0.039155>, <0.141058, -0.888722, -0.045413>,
      <0.102829, -0.979916, 0.009217>, <0.120316, -0.959039, -0.002570>, <0.128772, -0.914891, -0.023638>, <0.138859, -0.887695, -0.029896>,
      <0.082178, -0.934008, 0.030839>, <0.099248, -0.920960, 0.016520>, <0.116869, -0.887348, 0.007250>, <0.131417, -0.877591, -0.011718>,
      <0.075203, -0.913373, 0.054673>, <0.092272, -0.900325, 0.040353>, <0.114032, -0.880648, 0.021169>, <0.128581, -0.870891, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.110700, -0.979929, -0.022097>, <0.117296, -0.979940, -0.048341>, <0.113959, -0.932561, -0.064349>, <0.109815, -0.913430, -0.083032>,
      <0.128187, -0.959052, -0.033884>, <0.134783, -0.959063, -0.060127>, <0.124633, -0.923509, -0.068001>, <0.120489, -0.904379, -0.086685>,
      <0.130971, -0.915918, -0.039155>, <0.132410, -0.916590, -0.049308>, <0.132631, -0.889585, -0.073829>, <0.131393, -0.886138, -0.083431>,
      <0.141058, -0.888722, -0.045413>, <0.142497, -0.889394, -0.055567>, <0.141079, -0.879598, -0.067655>, <0.139841, -0.876152, -0.077257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355611, 0.462296, 1.090388>, <-0.390686, 0.452966, 1.070550>, <-0.433891, 0.437125, 1.038279>, <-0.460369, 0.422607, 1.010012>,
      <-0.356708, 0.582608, 1.018007>, <-0.391784, 0.573279, 0.998169>, <-0.432209, 0.554077, 0.964799>, <-0.458688, 0.539559, 0.936533>,
      <-0.342177, 0.706635, 0.859475>, <-0.381389, 0.692900, 0.838165>, <-0.433562, 0.679350, 0.802613>, <-0.461941, 0.654402, 0.775180>,
      <-0.337234, 0.759978, 0.729686>, <-0.376445, 0.746243, 0.708375>, <-0.429226, 0.730912, 0.674541>, <-0.457605, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.132050, -0.848624, 0.037892>, <-0.131161, -0.853935, 0.026422>, <-0.133758, -0.865469, 0.013465>, <-0.135831, -0.870891, 0.002201>,
      <-0.145373, -0.843003, 0.015838>, <-0.144484, -0.848314, 0.004368>, <-0.144842, -0.858503, -0.000072>, <-0.146915, -0.863925, -0.011336>,
      <-0.167412, -0.833623, -0.015100>, <-0.160585, -0.835541, -0.016726>, <-0.169610, -0.851703, -0.030581>, <-0.166872, -0.858421, -0.031122>,
      <-0.168496, -0.836921, -0.041242>, <-0.161669, -0.838839, -0.042869>, <-0.171909, -0.852893, -0.049233>, <-0.169170, -0.859611, -0.049774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.082473, -0.873217, 0.101158>, <-0.080902, -0.883424, 0.085895>, <-0.082559, -0.905003, 0.071063>, <-0.083650, -0.913360, 0.054674>,
      <-0.096987, -0.865043, 0.082226>, <-0.095416, -0.875251, 0.066963>, <-0.098586, -0.891594, 0.056280>, <-0.099677, -0.899951, 0.039891>,
      <-0.119311, -0.853999, 0.058980>, <-0.118422, -0.859310, 0.047510>, <-0.118693, -0.874938, 0.031865>, <-0.120765, -0.880360, 0.020601>,
      <-0.132050, -0.848624, 0.037892>, <-0.131161, -0.853935, 0.026422>, <-0.133758, -0.865469, 0.013465>, <-0.135831, -0.870891, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042169, -0.899241, 0.155131>, <-0.029837, -0.903818, 0.160637>, <-0.011895, -0.903478, 0.140765>, <0.002202, -0.904645, 0.138962>,
      <-0.043423, -0.873195, 0.210915>, <-0.031091, -0.877772, 0.216421>, <-0.013155, -0.873862, 0.200216>, <0.000943, -0.875029, 0.198413>,
      <-0.041834, -0.839059, 0.287015>, <-0.029691, -0.849316, 0.288883>, <-0.014862, -0.842069, 0.278321>, <0.000855, -0.840908, 0.281107>,
      <-0.052796, -0.823271, 0.345516>, <-0.040653, -0.833528, 0.347384>, <-0.015200, -0.826376, 0.342872>, <0.000517, -0.825215, 0.345658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042169, -0.899241, 0.155131>, <-0.041652, -0.909987, 0.132116>, <-0.044591, -0.930718, 0.104900>, <-0.046921, -0.945276, 0.084210>,
      <-0.029837, -0.903818, 0.160637>, <-0.029319, -0.914564, 0.137622>, <-0.030343, -0.937721, 0.108939>, <-0.032673, -0.952279, 0.088248>,
      <-0.011895, -0.903478, 0.140765>, <-0.011445, -0.914069, 0.119506>, <-0.009742, -0.941538, 0.097949>, <-0.010058, -0.959096, 0.081951>,
      <0.002202, -0.904645, 0.138962>, <0.002652, -0.915236, 0.117703>, <0.006459, -0.939936, 0.096123>, <0.006142, -0.957494, 0.080125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042169, -0.899241, 0.155131>, <-0.043423, -0.873195, 0.210915>, <-0.041834, -0.839059, 0.287015>, <-0.052796, -0.823271, 0.345516>,
      <-0.060904, -0.892287, 0.146766>, <-0.062158, -0.866242, 0.202550>, <-0.067198, -0.817633, 0.283114>, <-0.078160, -0.801845, 0.341615>,
      <-0.070004, -0.880239, 0.117423>, <-0.076910, -0.835372, 0.184514>, <-0.058876, -0.755536, 0.239025>, <-0.082740, -0.739648, 0.314788>,
      <-0.082473, -0.873217, 0.101158>, <-0.089379, -0.828350, 0.168249>, <-0.087960, -0.746207, 0.252616>, <-0.111824, -0.730319, 0.328379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.042169, -0.899241, 0.155131>, <-0.060904, -0.892287, 0.146766>, <-0.070004, -0.880239, 0.117423>, <-0.082473, -0.873217, 0.101158>,
      <-0.041652, -0.909987, 0.132116>, <-0.060387, -0.903033, 0.123751>, <-0.068433, -0.890446, 0.102159>, <-0.080902, -0.883424, 0.085895>,
      <-0.044591, -0.930718, 0.104900>, <-0.059443, -0.923418, 0.100690>, <-0.071867, -0.913948, 0.080925>, <-0.082559, -0.905003, 0.071063>,
      <-0.046921, -0.945276, 0.084210>, <-0.061773, -0.937976, 0.080000>, <-0.072958, -0.922305, 0.064536>, <-0.083650, -0.913360, 0.054674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.588565, 0.539033, 0.486731>, <-0.594700, 0.504232, 0.603163>, <-0.594439, 0.430623, 0.764929>, <-0.594951, 0.331069, 0.834885>,
      <-0.623896, 0.462172, 0.412946>, <-0.630031, 0.427371, 0.529378>, <-0.629748, 0.395055, 0.699633>, <-0.630261, 0.295501, 0.769589>,
      <-0.644313, 0.359383, 0.303257>, <-0.659493, 0.346563, 0.416179>, <-0.660786, 0.306584, 0.583734>, <-0.662022, 0.241326, 0.678000>,
      <-0.656388, 0.273520, 0.231970>, <-0.671568, 0.260700, 0.344892>, <-0.677084, 0.268317, 0.512703>, <-0.678320, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.588565, 0.539033, 0.486731>, <-0.594700, 0.504232, 0.603163>, <-0.594439, 0.430623, 0.764929>, <-0.594951, 0.331069, 0.834885>,
      <-0.563451, 0.593667, 0.539179>, <-0.569587, 0.558866, 0.655610>, <-0.563671, 0.461616, 0.821826>, <-0.564183, 0.362062, 0.891782>,
      <-0.506098, 0.663334, 0.600231>, <-0.510434, 0.611772, 0.728303>, <-0.504603, 0.514385, 0.887517>, <-0.506284, 0.397432, 0.960996>,
      <-0.457605, 0.705964, 0.647108>, <-0.461941, 0.654402, 0.775180>, <-0.458688, 0.539559, 0.936533>, <-0.460369, 0.422607, 1.010012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.417975, -0.571031, -0.502258>, <-0.401539, -0.599780, -0.517022>, <-0.373725, -0.634865, -0.535956>, <-0.352649, -0.661193, -0.549270>,
      <-0.406256, -0.476843, -0.568237>, <-0.389820, -0.505592, -0.583001>, <-0.368391, -0.541894, -0.608330>, <-0.347316, -0.568223, -0.621644>,
      <-0.375113, -0.267827, -0.527528>, <-0.357826, -0.295016, -0.543183>, <-0.333561, -0.333194, -0.566508>, <-0.311032, -0.356658, -0.581511>,
      <-0.367014, -0.210187, -0.627398>, <-0.349728, -0.237377, -0.643053>, <-0.324215, -0.270930, -0.666237>, <-0.301686, -0.294394, -0.681239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.090679, -0.936068, -0.022092>, <-0.085885, -0.936140, 0.001535>, <-0.085078, -0.924293, 0.033234>, <-0.083650, -0.913360, 0.054674>,
      <-0.104017, -0.918727, -0.029930>, <-0.099223, -0.918798, -0.006303>, <-0.101104, -0.910884, 0.018451>, <-0.099677, -0.899951, 0.039891>,
      <-0.131240, -0.904443, -0.039721>, <-0.129331, -0.903455, -0.024228>, <-0.123324, -0.887052, 0.006697>, <-0.120765, -0.880360, 0.020601>,
      <-0.147380, -0.888722, -0.045413>, <-0.145471, -0.887734, -0.029920>, <-0.138390, -0.877583, -0.011703>, <-0.135831, -0.870891, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.090679, -0.936068, -0.022092>, <-0.094760, -0.936007, -0.042209>, <-0.110085, -0.922855, -0.065088>, <-0.111583, -0.912943, -0.083000>,
      <-0.104017, -0.918727, -0.029930>, <-0.108099, -0.918666, -0.050046>, <-0.120479, -0.913849, -0.071409>, <-0.121976, -0.903936, -0.089321>,
      <-0.131240, -0.904443, -0.039721>, <-0.132595, -0.905144, -0.050709>, <-0.137337, -0.889323, -0.075723>, <-0.135754, -0.885614, -0.086057>,
      <-0.147380, -0.888722, -0.045413>, <-0.148734, -0.889423, -0.056401>, <-0.147563, -0.879852, -0.069823>, <-0.145980, -0.876143, -0.080157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058897, -1.003761, 0.006583>, <-0.055352, -1.002504, 0.035720>, <-0.049615, -0.962110, 0.060284>, <-0.046921, -0.945276, 0.084210>,
      <-0.075251, -0.991247, -0.005797>, <-0.071706, -0.989989, 0.023339>, <-0.064467, -0.954810, 0.056075>, <-0.061773, -0.937976, 0.080000>,
      <-0.076888, -0.953998, -0.013988>, <-0.072095, -0.954069, 0.009639>, <-0.074385, -0.933238, 0.043097>, <-0.072958, -0.922305, 0.064536>,
      <-0.090679, -0.936068, -0.022092>, <-0.085885, -0.936140, 0.001535>, <-0.085078, -0.924293, 0.033234>, <-0.083650, -0.913360, 0.054674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.058897, -1.003761, 0.006583>, <-0.061213, -1.004582, -0.012449>, <-0.063214, -0.966618, -0.018772>, <-0.060603, -0.950129, -0.028236>,
      <-0.075251, -0.991247, -0.005797>, <-0.077567, -0.992068, -0.024829>, <-0.078306, -0.952052, -0.032496>, <-0.075695, -0.935564, -0.041960>,
      <-0.076888, -0.953998, -0.013988>, <-0.080970, -0.953937, -0.034105>, <-0.092873, -0.937771, -0.054621>, <-0.094371, -0.927858, -0.072533>,
      <-0.090679, -0.936068, -0.022092>, <-0.094760, -0.936007, -0.042209>, <-0.110085, -0.922855, -0.065088>, <-0.111583, -0.912943, -0.083000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000379, -1.005746, 0.046842>, <0.002535, -0.994095, 0.059951>, <0.005907, -0.970554, 0.068225>, <0.006142, -0.957494, 0.080125>,
      <-0.021004, -1.006525, 0.044690>, <-0.018847, -0.994874, 0.057799>, <-0.010294, -0.972156, 0.070051>, <-0.010058, -0.959096, 0.081951>,
      <-0.044260, -1.014961, 0.017663>, <-0.040715, -1.013704, 0.046800>, <-0.035368, -0.969113, 0.064323>, <-0.032673, -0.952279, 0.088248>,
      <-0.058897, -1.003761, 0.006583>, <-0.055352, -1.002504, 0.035720>, <-0.049615, -0.962110, 0.060284>, <-0.046921, -0.945276, 0.084210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000379, -1.005746, 0.046842>, <-0.021004, -1.006525, 0.044690>, <-0.044260, -1.014961, 0.017663>, <-0.058897, -1.003761, 0.006583>,
      <-0.000888, -1.012595, 0.039136>, <-0.022271, -1.013374, 0.036984>, <-0.046576, -1.015783, -0.001368>, <-0.061213, -1.004582, -0.012449>,
      <-0.004810, -1.021698, 0.022938>, <-0.033309, -1.021289, 0.027679>, <-0.045817, -0.983408, -0.002952>, <-0.063214, -0.966618, -0.018772>,
      <-0.004703, -1.016093, 0.014193>, <-0.033202, -1.015684, 0.018935>, <-0.043206, -0.966919, -0.012415>, <-0.060603, -0.950129, -0.028236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.662598, -0.054363, 0.705599>, <-0.667774, 0.028306, 0.706503>, <-0.679213, 0.155912, 0.675073>, <-0.678320, 0.203059, 0.606969>,
      <-0.673147, -0.038444, 0.653797>, <-0.678323, 0.044225, 0.654701>, <-0.685098, 0.142094, 0.649422>, <-0.684205, 0.189240, 0.581319>,
      <-0.669135, 0.001019, 0.589472>, <-0.667953, 0.041664, 0.596328>, <-0.669779, 0.130935, 0.552146>, <-0.668485, 0.171641, 0.545684>,
      <-0.671937, 0.024754, 0.539703>, <-0.670755, 0.065399, 0.546559>, <-0.668916, 0.119735, 0.524626>, <-0.667621, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.546115, -0.051149, -0.245962>, <-0.526027, -0.007115, -0.313808>, <-0.493891, 0.043573, -0.413909>, <-0.485397, 0.052883, -0.496291>,
      <-0.556078, 0.007279, -0.206532>, <-0.535990, 0.051313, -0.274379>, <-0.500481, 0.077768, -0.400892>, <-0.491988, 0.087078, -0.483274>,
      <-0.587041, 0.051951, -0.120505>, <-0.555379, 0.068400, -0.235424>, <-0.509835, 0.128724, -0.350110>, <-0.495012, 0.135024, -0.469358>,
      <-0.596005, 0.106883, -0.076120>, <-0.564343, 0.123332, -0.191039>, <-0.509158, 0.164377, -0.339593>, <-0.494335, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.546115, -0.051149, -0.245962>, <-0.556078, 0.007279, -0.206532>, <-0.587041, 0.051951, -0.120505>, <-0.596005, 0.106883, -0.076120>,
      <-0.564056, -0.090477, -0.185366>, <-0.574019, -0.032049, -0.145937>, <-0.602670, 0.043832, -0.063781>, <-0.611634, 0.098764, -0.019396>,
      <-0.593192, -0.181606, -0.137282>, <-0.611808, -0.086743, -0.086241>, <-0.624599, -0.000575, -0.001120>, <-0.637190, 0.092088, 0.055499>,
      <-0.609904, -0.220045, -0.075771>, <-0.628519, -0.125182, -0.024731>, <-0.639284, -0.003831, 0.056339>, <-0.651876, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284527, -0.762097, 0.390475>, <-0.279160, -0.748351, 0.377110>, <-0.278432, -0.719043, 0.406825>, <-0.275820, -0.700591, 0.413832>,
      <-0.221363, -0.770869, 0.385138>, <-0.215996, -0.757123, 0.371773>, <-0.220773, -0.722877, 0.402350>, <-0.218161, -0.704425, 0.409357>,
      <-0.179666, -0.738919, 0.346444>, <-0.187138, -0.734376, 0.346488>, <-0.184072, -0.711165, 0.353867>, <-0.189335, -0.704189, 0.354179>,
      <-0.134725, -0.728985, 0.327574>, <-0.142197, -0.724443, 0.327617>, <-0.147007, -0.712707, 0.328301>, <-0.152270, -0.705731, 0.328613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.453995, -0.684644, 0.354552>, <-0.448956, -0.686431, 0.354121>, <-0.441870, -0.686167, 0.351846>, <-0.436674, -0.686819, 0.350686>,
      <-0.403155, -0.707880, 0.365329>, <-0.398115, -0.709667, 0.364898>, <-0.393614, -0.690298, 0.370790>, <-0.388418, -0.690951, 0.369630>,
      <-0.356814, -0.752058, 0.396583>, <-0.351446, -0.738312, 0.383218>, <-0.344989, -0.714617, 0.411990>, <-0.342377, -0.696165, 0.418998>,
      <-0.284527, -0.762097, 0.390475>, <-0.279160, -0.748351, 0.377110>, <-0.278432, -0.719043, 0.406825>, <-0.275820, -0.700591, 0.413832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.453995, -0.684644, 0.354552>, <-0.448956, -0.686431, 0.354121>, <-0.441870, -0.686167, 0.351846>, <-0.436674, -0.686819, 0.350686>,
      <-0.434874, -0.695357, 0.343631>, <-0.429834, -0.697144, 0.343200>, <-0.427923, -0.686361, 0.345487>, <-0.422727, -0.687013, 0.344327>,
      <-0.412484, -0.711712, 0.323710>, <-0.414063, -0.706541, 0.332637>, <-0.404972, -0.694410, 0.328985>, <-0.404950, -0.684544, 0.332388>,
      <-0.390257, -0.720353, 0.318149>, <-0.391836, -0.715183, 0.327076>, <-0.390205, -0.697333, 0.326088>, <-0.390183, -0.687467, 0.329490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.453995, -0.684644, 0.354552>, <-0.464187, -0.681030, 0.355423>, <-0.476849, -0.673763, 0.354836>, <-0.486643, -0.669100, 0.354958>,
      <-0.434874, -0.695357, 0.343631>, <-0.445065, -0.691743, 0.344502>, <-0.443576, -0.701324, 0.351132>, <-0.453370, -0.696661, 0.351254>,
      <-0.412484, -0.711712, 0.323710>, <-0.410343, -0.718722, 0.311607>, <-0.418337, -0.704347, 0.303928>, <-0.417272, -0.707925, 0.290280>,
      <-0.390257, -0.720353, 0.318149>, <-0.388116, -0.727363, 0.306046>, <-0.381097, -0.717126, 0.285754>, <-0.380032, -0.720704, 0.272105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.259867, -0.760116, 0.305981>, <-0.300644, -0.756076, 0.303397>, <-0.352989, -0.734842, 0.308825>, <-0.390257, -0.720353, 0.318149>,
      <-0.259672, -0.756219, 0.317213>, <-0.300449, -0.752179, 0.314629>, <-0.354568, -0.729672, 0.317751>, <-0.391836, -0.715183, 0.327076>,
      <-0.260004, -0.733278, 0.313016>, <-0.300318, -0.728976, 0.311496>, <-0.351123, -0.705068, 0.318419>, <-0.390205, -0.697333, 0.326088>,
      <-0.260062, -0.721776, 0.316031>, <-0.300376, -0.717474, 0.314511>, <-0.351101, -0.695203, 0.321821>, <-0.390183, -0.687467, 0.329490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.177921, -0.741388, 0.331604>, <-0.210381, -0.749463, 0.326003>, <-0.233684, -0.762710, 0.307640>, <-0.259867, -0.760116, 0.305981>,
      <-0.182026, -0.736790, 0.339446>, <-0.214486, -0.744865, 0.333845>, <-0.233489, -0.758813, 0.318872>, <-0.259672, -0.756219, 0.317213>,
      <-0.182815, -0.718978, 0.335543>, <-0.212796, -0.723441, 0.332043>, <-0.236435, -0.735793, 0.313905>, <-0.260004, -0.733278, 0.313016>,
      <-0.184912, -0.709374, 0.337231>, <-0.214893, -0.713837, 0.333732>, <-0.236494, -0.724291, 0.316920>, <-0.260062, -0.721776, 0.316031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.177921, -0.741388, 0.331604>, <-0.182026, -0.736790, 0.339446>, <-0.182815, -0.718978, 0.335543>, <-0.184912, -0.709374, 0.337231>,
      <-0.161254, -0.737242, 0.334480>, <-0.165358, -0.732644, 0.342322>, <-0.169938, -0.717062, 0.337046>, <-0.172035, -0.707457, 0.338734>,
      <-0.147684, -0.732706, 0.328783>, <-0.155156, -0.728163, 0.328826>, <-0.156799, -0.713800, 0.330887>, <-0.162063, -0.706824, 0.331198>,
      <-0.134725, -0.728985, 0.327574>, <-0.142197, -0.724443, 0.327617>, <-0.147007, -0.712707, 0.328301>, <-0.152270, -0.705731, 0.328613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.157780, -0.739768, 0.285392>, <-0.141183, -0.737979, 0.294653>, <-0.120758, -0.734497, 0.312034>, <-0.111824, -0.730319, 0.328379>,
      <-0.145953, -0.767417, 0.209664>, <-0.129356, -0.765628, 0.218924>, <-0.096894, -0.750386, 0.236271>, <-0.087960, -0.746207, 0.252616>,
      <-0.137767, -0.814473, 0.111649>, <-0.125028, -0.819848, 0.132737>, <-0.103893, -0.820176, 0.149317>, <-0.089379, -0.828350, 0.168249>,
      <-0.132050, -0.848624, 0.037892>, <-0.119311, -0.853999, 0.058980>, <-0.096987, -0.865043, 0.082226>, <-0.082473, -0.873217, 0.101158>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.157780, -0.739768, 0.285392>, <-0.159976, -0.734634, 0.299455>, <-0.171695, -0.748363, 0.319708>, <-0.177921, -0.741388, 0.331604>,
      <-0.141183, -0.737979, 0.294653>, <-0.143379, -0.732845, 0.308715>, <-0.155027, -0.744217, 0.322584>, <-0.161254, -0.737242, 0.334480>,
      <-0.120758, -0.734497, 0.312034>, <-0.117535, -0.732990, 0.317930>, <-0.141800, -0.736283, 0.328749>, <-0.147684, -0.732706, 0.328783>,
      <-0.111824, -0.730319, 0.328379>, <-0.108602, -0.728812, 0.334275>, <-0.128841, -0.732562, 0.327540>, <-0.134725, -0.728985, 0.327574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261295, -0.746429, 0.244978>, <-0.298438, -0.743243, 0.242757>, <-0.347961, -0.731709, 0.256453>, <-0.380032, -0.720704, 0.272105>,
      <-0.265964, -0.742505, 0.262720>, <-0.303106, -0.739319, 0.260499>, <-0.349026, -0.728132, 0.270102>, <-0.381097, -0.717126, 0.285754>,
      <-0.260175, -0.766265, 0.288259>, <-0.300952, -0.762225, 0.285675>, <-0.350848, -0.741852, 0.296721>, <-0.388116, -0.727363, 0.306046>,
      <-0.259867, -0.760116, 0.305981>, <-0.300644, -0.756076, 0.303397>, <-0.352989, -0.734842, 0.308825>, <-0.390257, -0.720353, 0.318149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261295, -0.746429, 0.244978>, <-0.237838, -0.766147, 0.155838>, <-0.170341, -0.822034, 0.051817>, <-0.168496, -0.836921, -0.041242>,
      <-0.298438, -0.743243, 0.242757>, <-0.274981, -0.762961, 0.153617>, <-0.227479, -0.805985, 0.065432>, <-0.225633, -0.820872, -0.027627>,
      <-0.347961, -0.731709, 0.256453>, <-0.341458, -0.753558, 0.173101>, <-0.314453, -0.809092, 0.074608>, <-0.306938, -0.820527, -0.010714>,
      <-0.380032, -0.720704, 0.272105>, <-0.373529, -0.742553, 0.188754>, <-0.372710, -0.793116, 0.082259>, <-0.365195, -0.804551, -0.003063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261295, -0.746429, 0.244978>, <-0.265964, -0.742505, 0.262720>, <-0.260175, -0.766265, 0.288259>, <-0.259867, -0.760116, 0.305981>,
      <-0.228079, -0.749278, 0.246964>, <-0.232748, -0.745354, 0.264705>, <-0.233992, -0.768859, 0.289918>, <-0.233684, -0.762710, 0.307640>,
      <-0.186816, -0.742898, 0.269191>, <-0.189012, -0.737763, 0.283253>, <-0.204155, -0.756438, 0.314107>, <-0.210381, -0.749463, 0.326003>,
      <-0.157780, -0.739768, 0.285392>, <-0.159976, -0.734634, 0.299455>, <-0.171695, -0.748363, 0.319708>, <-0.177921, -0.741388, 0.331604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.261295, -0.746429, 0.244978>, <-0.228079, -0.749278, 0.246964>, <-0.186816, -0.742898, 0.269191>, <-0.157780, -0.739768, 0.285392>,
      <-0.237838, -0.766147, 0.155838>, <-0.204622, -0.768996, 0.157824>, <-0.174989, -0.770546, 0.193462>, <-0.145953, -0.767417, 0.209664>,
      <-0.170341, -0.822034, 0.051817>, <-0.169257, -0.818736, 0.077959>, <-0.151089, -0.808852, 0.089595>, <-0.137767, -0.814473, 0.111649>,
      <-0.168496, -0.836921, -0.041242>, <-0.167412, -0.833623, -0.015100>, <-0.145373, -0.843003, 0.015838>, <-0.132050, -0.848624, 0.037892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.207866, 0.846401, 0.281739>, <-0.189331, 0.825454, 0.081793>, <-0.117111, 0.702468, -0.160765>, <-0.101969, 0.673699, -0.360023>,
      <-0.146444, 0.859896, 0.291753>, <-0.127909, 0.838949, 0.091807>, <-0.086269, 0.710678, -0.164947>, <-0.071127, 0.681910, -0.364205>,
      <-0.063163, 0.876611, 0.308590>, <-0.063163, 0.853542, 0.093461>, <-0.031665, 0.721453, -0.174528>, <-0.031665, 0.688852, -0.388420>,
      <0.000517, 0.876606, 0.308590>, <0.000517, 0.853537, 0.093461>, <0.000517, 0.721691, -0.173923>, <0.000517, 0.689090, -0.387815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.207866, 0.846401, 0.281739>, <-0.221743, 0.862085, 0.431442>, <-0.208846, 0.850301, 0.642765>, <-0.207910, 0.793428, 0.782815>,
      <-0.146444, 0.859896, 0.291753>, <-0.160321, 0.875580, 0.441456>, <-0.147881, 0.860943, 0.659618>, <-0.146945, 0.804070, 0.799669>,
      <-0.063163, 0.876611, 0.308590>, <-0.063163, 0.893171, 0.463011>, <-0.063624, 0.879506, 0.680047>, <-0.063624, 0.818937, 0.823055>,
      <0.000517, 0.876606, 0.308590>, <0.000517, 0.893165, 0.463011>, <0.000517, 0.879506, 0.680047>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.202024, 0.491323, 1.156127>, <-0.250959, 0.485169, 1.143667>, <-0.312473, 0.473770, 1.114786>, <-0.355611, 0.462296, 1.090388>,
      <-0.204983, 0.616506, 1.084852>, <-0.253918, 0.610352, 1.072392>, <-0.313570, 0.594082, 1.042405>, <-0.356708, 0.582608, 1.018007>,
      <-0.207018, 0.739218, 0.916308>, <-0.248010, 0.732063, 0.904976>, <-0.305961, 0.719321, 0.879159>, <-0.342177, 0.706635, 0.859475>,
      <-0.207910, 0.793428, 0.782815>, <-0.248902, 0.786272, 0.771483>, <-0.301018, 0.772664, 0.749369>, <-0.337234, 0.759978, 0.729686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.202024, 0.491323, 1.156127>, <-0.142956, 0.498752, 1.171166>, <-0.060886, 0.507086, 1.181063>, <0.000517, 0.507086, 1.181063>,
      <-0.204983, 0.616506, 1.084852>, <-0.145915, 0.623935, 1.099891>, <-0.060886, 0.632809, 1.114118>, <0.000517, 0.632809, 1.114118>,
      <-0.207018, 0.739218, 0.916308>, <-0.146053, 0.749861, 0.933161>, <-0.063624, 0.763388, 0.954212>, <0.000517, 0.763388, 0.954212>,
      <-0.207910, 0.793428, 0.782815>, <-0.146945, 0.804070, 0.799669>, <-0.063624, 0.818937, 0.823055>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512806, -0.381058, -0.405403>, <-0.497693, -0.442373, -0.435631>, <-0.449713, -0.515518, -0.473749>, <-0.417975, -0.571031, -0.502258>,
      <-0.495879, -0.299606, -0.471906>, <-0.480766, -0.360922, -0.502134>, <-0.437993, -0.421331, -0.539728>, <-0.406256, -0.476843, -0.568237>,
      <-0.461547, -0.102139, -0.449502>, <-0.440516, -0.148873, -0.472793>, <-0.402278, -0.225098, -0.502927>, <-0.375113, -0.267827, -0.527528>,
      <-0.449516, -0.061871, -0.547365>, <-0.428485, -0.108605, -0.570656>, <-0.394179, -0.167459, -0.602797>, <-0.367014, -0.210187, -0.627398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.512806, -0.381058, -0.405403>, <-0.495879, -0.299606, -0.471906>, <-0.461547, -0.102139, -0.449502>, <-0.449516, -0.061871, -0.547365>,
      <-0.536632, -0.284391, -0.357747>, <-0.519706, -0.202939, -0.424250>, <-0.476188, -0.069604, -0.433287>, <-0.464157, -0.029336, -0.531150>,
      <-0.530668, -0.141742, -0.307098>, <-0.510580, -0.097708, -0.374945>, <-0.486943, 0.007527, -0.427630>, <-0.478450, 0.016838, -0.510012>,
      <-0.546115, -0.051149, -0.245962>, <-0.526027, -0.007115, -0.313808>, <-0.493891, 0.043573, -0.413909>, <-0.485397, 0.052883, -0.496291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.538386, -0.489508, -0.198213>, <-0.527805, -0.466174, -0.263974>, <-0.524023, -0.435032, -0.361335>, <-0.512806, -0.381058, -0.405403>,
      <-0.567604, -0.409129, -0.166117>, <-0.557022, -0.385795, -0.231878>, <-0.547849, -0.338364, -0.313679>, <-0.536632, -0.284391, -0.357747>,
      <-0.594349, -0.299314, -0.118421>, <-0.577637, -0.260875, -0.179931>, <-0.548609, -0.181070, -0.246503>, <-0.530668, -0.141742, -0.307098>,
      <-0.609904, -0.220045, -0.075771>, <-0.593192, -0.181606, -0.137282>, <-0.564056, -0.090477, -0.185366>, <-0.546115, -0.051149, -0.245962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591808, -0.555274, 0.085570>, <-0.600410, -0.560896, 0.148714>, <-0.600117, -0.546909, 0.234936>, <-0.605886, -0.533619, 0.297248>,
      <-0.616729, -0.476696, 0.105461>, <-0.625331, -0.482318, 0.168604>, <-0.629923, -0.479057, 0.214337>, <-0.635692, -0.465767, 0.276650>,
      <-0.636147, -0.363029, 0.106118>, <-0.641002, -0.370589, 0.140939>, <-0.643280, -0.365394, 0.205825>, <-0.646110, -0.364973, 0.241672>,
      <-0.645577, -0.279927, 0.120129>, <-0.650432, -0.287487, 0.154950>, <-0.651014, -0.288898, 0.203562>, <-0.653844, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591808, -0.555274, 0.085570>, <-0.579861, -0.547466, -0.002125>, <-0.551707, -0.518884, -0.115426>, <-0.538386, -0.489508, -0.198213>,
      <-0.616729, -0.476696, 0.105461>, <-0.604781, -0.468889, 0.017766>, <-0.580925, -0.438505, -0.083330>, <-0.567604, -0.409129, -0.166117>,
      <-0.636147, -0.363029, 0.106118>, <-0.627727, -0.349915, 0.045717>, <-0.608354, -0.331528, -0.066872>, <-0.594349, -0.299314, -0.118421>,
      <-0.645577, -0.279927, 0.120129>, <-0.637156, -0.266813, 0.059728>, <-0.623909, -0.252259, -0.024222>, <-0.609904, -0.220045, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.621533, -0.486799, 0.406624>, <-0.617710, -0.507271, 0.377260>, <-0.609132, -0.526140, 0.332313>, <-0.605886, -0.533619, 0.297248>,
      <-0.644951, -0.430087, 0.379978>, <-0.641128, -0.450559, 0.350613>, <-0.638939, -0.458288, 0.311714>, <-0.635692, -0.465767, 0.276650>,
      <-0.657283, -0.343811, 0.346881>, <-0.654135, -0.356057, 0.318303>, <-0.648569, -0.364607, 0.272824>, <-0.646110, -0.364973, 0.241672>,
      <-0.663137, -0.277314, 0.342560>, <-0.659989, -0.289560, 0.313982>, <-0.656303, -0.288111, 0.270560>, <-0.653844, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.645465, -0.321685, 0.601232>, <-0.652181, -0.250959, 0.650130>, <-0.657209, -0.140434, 0.704658>, <-0.662598, -0.054363, 0.705599>,
      <-0.660091, -0.287900, 0.556168>, <-0.666807, -0.217175, 0.605066>, <-0.667758, -0.124516, 0.652856>, <-0.673147, -0.038444, 0.653797>,
      <-0.674636, -0.249522, 0.477475>, <-0.676349, -0.190713, 0.515857>, <-0.671149, -0.068221, 0.577792>, <-0.669135, 0.001019, 0.589472>,
      <-0.677951, -0.194697, 0.458256>, <-0.679664, -0.135888, 0.496637>, <-0.673951, -0.044485, 0.528023>, <-0.671937, 0.024754, 0.539703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.645465, -0.321685, 0.601232>, <-0.639477, -0.384748, 0.557632>, <-0.629700, -0.443067, 0.469350>, <-0.621533, -0.486799, 0.406624>,
      <-0.660091, -0.287900, 0.556168>, <-0.654103, -0.350963, 0.512568>, <-0.653118, -0.386355, 0.442704>, <-0.644951, -0.430087, 0.379978>,
      <-0.674636, -0.249522, 0.477475>, <-0.673590, -0.285421, 0.454046>, <-0.661603, -0.327007, 0.386095>, <-0.657283, -0.343811, 0.346881>,
      <-0.677951, -0.194697, 0.458256>, <-0.676905, -0.230596, 0.434827>, <-0.667457, -0.260510, 0.381774>, <-0.663137, -0.277314, 0.342560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.598586, 0.270397, 0.013847>, <-0.602859, 0.221036, -0.012242>, <-0.603056, 0.150090, -0.041209>, <-0.596005, 0.106883, -0.076120>,
      <-0.563343, 0.272390, -0.118842>, <-0.567617, 0.223029, -0.144931>, <-0.571394, 0.166539, -0.156127>, <-0.564343, 0.123332, -0.191039>,
      <-0.498352, 0.283369, -0.292077>, <-0.508538, 0.250778, -0.300933>, <-0.508516, 0.198206, -0.329615>, <-0.509158, 0.164377, -0.339593>,
      <-0.481021, 0.283437, -0.428282>, <-0.491206, 0.250846, -0.437138>, <-0.493693, 0.204505, -0.448862>, <-0.494335, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.598586, 0.270397, 0.013847>, <-0.615964, 0.269414, 0.079273>, <-0.647424, 0.281090, 0.165292>, <-0.656388, 0.273520, 0.231970>,
      <-0.602859, 0.221036, -0.012242>, <-0.620237, 0.220054, 0.053184>, <-0.654516, 0.230660, 0.123424>, <-0.663480, 0.223090, 0.190101>,
      <-0.603056, 0.150090, -0.041209>, <-0.618684, 0.141971, 0.015516>, <-0.638544, 0.147494, 0.091203>, <-0.653230, 0.144238, 0.148662>,
      <-0.596005, 0.106883, -0.076120>, <-0.611634, 0.098764, -0.019396>, <-0.637190, 0.092088, 0.055499>, <-0.651876, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.665203, 0.091543, 0.194622>, <-0.659315, -0.019898, 0.172274>, <-0.658233, -0.168395, 0.138933>, <-0.645577, -0.279927, 0.120129>,
      <-0.662557, 0.090329, 0.169957>, <-0.656669, -0.021112, 0.147609>, <-0.649812, -0.155280, 0.078532>, <-0.637156, -0.266813, 0.059728>,
      <-0.658017, 0.087471, 0.136985>, <-0.645425, -0.005192, 0.080366>, <-0.642525, -0.157396, 0.026818>, <-0.623909, -0.252259, -0.024222>,
      <-0.651876, 0.088832, 0.112958>, <-0.639284, -0.003831, 0.056339>, <-0.628519, -0.125182, -0.024731>, <-0.609904, -0.220045, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.669643, 0.096985, 0.278592>, <-0.664903, -0.018654, 0.266837>, <-0.665541, -0.172786, 0.235986>, <-0.653844, -0.288477, 0.239409>,
      <-0.668267, 0.093239, 0.253630>, <-0.663527, -0.022400, 0.241875>, <-0.662711, -0.173207, 0.200139>, <-0.651014, -0.288898, 0.203562>,
      <-0.667896, 0.092779, 0.219727>, <-0.662008, -0.018662, 0.197379>, <-0.663087, -0.175955, 0.173754>, <-0.650432, -0.287487, 0.154950>,
      <-0.665203, 0.091543, 0.194622>, <-0.659315, -0.019898, 0.172274>, <-0.658233, -0.168395, 0.138933>, <-0.645577, -0.279927, 0.120129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.674728, 0.117465, 0.367358>, <-0.675200, 0.122712, 0.389479>, <-0.674141, 0.129273, 0.419116>, <-0.673111, 0.135499, 0.440963>,
      <-0.671251, -0.000969, 0.359919>, <-0.671723, 0.004278, 0.382040>, <-0.675593, 0.030214, 0.424304>, <-0.674563, 0.036440, 0.446151>,
      <-0.673526, -0.159300, 0.334891>, <-0.677846, -0.142496, 0.374105>, <-0.682557, -0.137129, 0.402061>, <-0.683603, -0.101230, 0.425490>,
      <-0.663137, -0.277314, 0.342560>, <-0.667457, -0.260510, 0.381774>, <-0.676905, -0.230596, 0.434827>, <-0.677951, -0.194697, 0.458256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.674728, 0.117465, 0.367358>, <-0.671251, -0.000969, 0.359919>, <-0.673526, -0.159300, 0.334891>, <-0.663137, -0.277314, 0.342560>,
      <-0.674159, 0.111149, 0.340731>, <-0.670682, -0.007285, 0.333291>, <-0.670378, -0.171547, 0.306313>, <-0.659989, -0.289560, 0.313982>,
      <-0.671133, 0.101041, 0.305621>, <-0.666394, -0.014597, 0.293866>, <-0.668000, -0.172420, 0.267138>, <-0.656303, -0.288111, 0.270560>,
      <-0.669643, 0.096985, 0.278592>, <-0.664903, -0.018654, 0.266837>, <-0.665541, -0.172786, 0.235986>, <-0.653844, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429867, -0.715328, -0.273542>, <-0.408755, -0.746461, -0.282929>, <-0.363135, -0.775246, -0.290345>, <-0.330468, -0.796124, -0.290661>,
      <-0.417897, -0.688905, -0.349392>, <-0.396786, -0.720038, -0.358779>, <-0.361186, -0.752973, -0.375210>, <-0.328519, -0.773850, -0.375526>,
      <-0.426208, -0.637200, -0.455906>, <-0.409772, -0.665949, -0.470670>, <-0.377693, -0.704045, -0.482102>, <-0.356618, -0.730373, -0.495416>,
      <-0.417975, -0.571031, -0.502258>, <-0.401539, -0.599780, -0.517022>, <-0.373725, -0.634865, -0.535956>, <-0.352649, -0.661193, -0.549270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429867, -0.715328, -0.273542>, <-0.417897, -0.688905, -0.349392>, <-0.426208, -0.637200, -0.455906>, <-0.417975, -0.571031, -0.502258>,
      <-0.472606, -0.652301, -0.254539>, <-0.460636, -0.625878, -0.330389>, <-0.457946, -0.581687, -0.427397>, <-0.449713, -0.515518, -0.473749>,
      <-0.513282, -0.558569, -0.225790>, <-0.502701, -0.535235, -0.291550>, <-0.508910, -0.496347, -0.391563>, <-0.497693, -0.442373, -0.435631>,
      <-0.538386, -0.489508, -0.198213>, <-0.527805, -0.466174, -0.263974>, <-0.524023, -0.435032, -0.361335>, <-0.512806, -0.381058, -0.405403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497547, -0.746687, 0.001975>, <-0.507280, -0.738762, 0.109719>, <-0.482621, -0.693092, 0.249249>, <-0.486643, -0.669100, 0.354958>,
      <-0.542269, -0.697492, 0.019467>, <-0.552002, -0.689568, 0.127210>, <-0.526238, -0.656962, 0.254105>, <-0.530260, -0.632970, 0.359814>,
      <-0.571605, -0.618976, 0.069445>, <-0.580208, -0.624598, 0.132588>, <-0.578089, -0.597053, 0.250159>, <-0.583858, -0.583763, 0.312471>,
      <-0.591808, -0.555274, 0.085570>, <-0.600410, -0.560896, 0.148714>, <-0.600117, -0.546909, 0.234936>, <-0.605886, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497547, -0.746687, 0.001975>, <-0.489864, -0.752943, -0.083081>, <-0.442489, -0.743190, -0.193561>, <-0.429867, -0.715328, -0.273542>,
      <-0.542269, -0.697492, 0.019467>, <-0.534585, -0.703749, -0.065589>, <-0.485227, -0.680164, -0.174558>, <-0.472606, -0.652301, -0.254539>,
      <-0.571605, -0.618976, 0.069445>, <-0.559658, -0.611168, -0.018250>, <-0.526603, -0.587945, -0.143003>, <-0.513282, -0.558569, -0.225790>,
      <-0.591808, -0.555274, 0.085570>, <-0.579861, -0.547466, -0.002125>, <-0.551707, -0.518884, -0.115426>, <-0.538386, -0.489508, -0.198213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497547, -0.746687, 0.001975>, <-0.507280, -0.738762, 0.109719>, <-0.482621, -0.693092, 0.249249>, <-0.486643, -0.669100, 0.354958>,
      <-0.469340, -0.777716, -0.009058>, <-0.479073, -0.769791, 0.098686>, <-0.449348, -0.720653, 0.245545>, <-0.453370, -0.696661, 0.351254>,
      <-0.406681, -0.793175, 0.002386>, <-0.414195, -0.781740, 0.087708>, <-0.410768, -0.729774, 0.206928>, <-0.417272, -0.707925, 0.290280>,
      <-0.365195, -0.804551, -0.003063>, <-0.372710, -0.793116, 0.082259>, <-0.373529, -0.742553, 0.188754>, <-0.380032, -0.720704, 0.272105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.497547, -0.746687, 0.001975>, <-0.469340, -0.777716, -0.009058>, <-0.406681, -0.793175, 0.002386>, <-0.365195, -0.804551, -0.003063>,
      <-0.489864, -0.752943, -0.083081>, <-0.461656, -0.783972, -0.094113>, <-0.399120, -0.804679, -0.083460>, <-0.357634, -0.816056, -0.088909>,
      <-0.442489, -0.743190, -0.193561>, <-0.421377, -0.774324, -0.202948>, <-0.365066, -0.797312, -0.206271>, <-0.332399, -0.818190, -0.206587>,
      <-0.429867, -0.715328, -0.273542>, <-0.408755, -0.746461, -0.282929>, <-0.363135, -0.775246, -0.290345>, <-0.330468, -0.796124, -0.290661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.516840, -0.631607, 0.509025>, <-0.558497, -0.591026, 0.488161>, <-0.599903, -0.539181, 0.431236>, <-0.621533, -0.486799, 0.406624>,
      <-0.508383, -0.654331, 0.467109>, <-0.550040, -0.613750, 0.446245>, <-0.596080, -0.559653, 0.401871>, <-0.617710, -0.507271, 0.377260>,
      <-0.488439, -0.658390, 0.402149>, <-0.532056, -0.622260, 0.407004>, <-0.587105, -0.576285, 0.347536>, <-0.609132, -0.526140, 0.332313>,
      <-0.486643, -0.669100, 0.354958>, <-0.530260, -0.632970, 0.359814>, <-0.583858, -0.583763, 0.312471>, <-0.605886, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.572832, -0.437511, 0.782138>, <-0.605951, -0.408674, 0.730184>, <-0.628367, -0.361181, 0.653914>, <-0.645465, -0.321685, 0.601232>,
      <-0.561710, -0.516930, 0.719250>, <-0.594829, -0.488093, 0.667296>, <-0.622378, -0.424243, 0.610314>, <-0.639477, -0.384748, 0.557632>,
      <-0.534639, -0.583782, 0.597240>, <-0.576295, -0.543201, 0.576376>, <-0.608070, -0.495449, 0.493962>, <-0.629700, -0.443067, 0.469350>,
      <-0.516840, -0.631607, 0.509025>, <-0.558497, -0.591026, 0.488161>, <-0.599903, -0.539181, 0.431236>, <-0.621533, -0.486799, 0.406624>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591833, -0.096123, 0.933049>, <-0.595607, 0.035015, 0.942049>, <-0.595505, 0.223476, 0.910489>, <-0.594951, 0.331069, 0.834885>,
      <-0.621171, -0.091815, 0.866834>, <-0.624945, 0.039324, 0.875834>, <-0.630814, 0.187908, 0.845193>, <-0.630261, 0.295501, 0.769589>,
      <-0.648735, -0.075282, 0.773672>, <-0.653911, 0.007387, 0.774575>, <-0.662915, 0.194179, 0.746104>, <-0.662022, 0.241326, 0.678000>,
      <-0.662598, -0.054363, 0.705599>, <-0.667774, 0.028306, 0.706503>, <-0.679213, 0.155912, 0.675073>, <-0.678320, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.591833, -0.096123, 0.933049>, <-0.621171, -0.091815, 0.866834>, <-0.648735, -0.075282, 0.773672>, <-0.662598, -0.054363, 0.705599>,
      <-0.588615, -0.207936, 0.925375>, <-0.617953, -0.203627, 0.859161>, <-0.643346, -0.161354, 0.772731>, <-0.657209, -0.140434, 0.704658>,
      <-0.585069, -0.350135, 0.851326>, <-0.618188, -0.321299, 0.799373>, <-0.635083, -0.290455, 0.702812>, <-0.652181, -0.250959, 0.650130>,
      <-0.572832, -0.437511, 0.782138>, <-0.605951, -0.408674, 0.730184>, <-0.628367, -0.361181, 0.653914>, <-0.645465, -0.321685, 0.601232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558886, 0.535632, 0.150492>, <-0.586517, 0.456780, 0.116247>, <-0.591695, 0.349997, 0.055919>, <-0.598586, 0.270397, 0.013847>,
      <-0.524300, 0.520202, -0.012856>, <-0.551931, 0.441350, -0.047101>, <-0.556452, 0.351990, -0.076769>, <-0.563343, 0.272390, -0.118842>,
      <-0.427473, 0.469746, -0.215360>, <-0.459031, 0.421668, -0.226726>, <-0.481426, 0.337531, -0.277359>, <-0.498352, 0.283369, -0.292077>,
      <-0.404834, 0.457063, -0.381021>, <-0.436392, 0.408985, -0.392387>, <-0.464095, 0.337598, -0.413565>, <-0.481021, 0.283437, -0.428282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.558886, 0.535632, 0.150492>, <-0.579774, 0.544951, 0.249144>, <-0.583458, 0.567997, 0.389827>, <-0.588565, 0.539033, 0.486731>,
      <-0.586517, 0.456780, 0.116247>, <-0.607405, 0.466099, 0.214899>, <-0.618789, 0.491137, 0.316042>, <-0.623896, 0.462172, 0.412946>,
      <-0.591695, 0.349997, 0.055919>, <-0.609072, 0.349015, 0.121346>, <-0.635350, 0.366953, 0.236579>, <-0.644313, 0.359383, 0.303257>,
      <-0.598586, 0.270397, 0.013847>, <-0.615964, 0.269414, 0.079273>, <-0.647424, 0.281090, 0.165292>, <-0.656388, 0.273520, 0.231970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.293568, -0.746043, 0.458025>, <-0.362088, -0.734852, 0.462884>, <-0.428721, -0.692183, 0.385878>, <-0.486643, -0.669100, 0.354958>,
      <-0.286008, -0.746708, 0.438439>, <-0.354529, -0.735517, 0.443297>, <-0.418926, -0.696846, 0.385756>, <-0.476849, -0.673763, 0.354836>,
      <-0.290190, -0.776600, 0.404576>, <-0.362476, -0.766560, 0.410684>, <-0.413346, -0.704266, 0.366200>, <-0.464187, -0.681030, 0.355423>,
      <-0.284527, -0.762097, 0.390475>, <-0.356814, -0.752058, 0.396583>, <-0.403155, -0.707880, 0.365329>, <-0.453995, -0.684644, 0.354552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.293568, -0.746043, 0.458025>, <-0.286008, -0.746708, 0.438439>, <-0.290190, -0.776600, 0.404576>, <-0.284527, -0.762097, 0.390475>,
      <-0.227468, -0.756839, 0.453338>, <-0.219908, -0.757505, 0.433751>, <-0.227026, -0.785372, 0.399239>, <-0.221363, -0.770869, 0.385138>,
      <-0.170234, -0.711584, 0.355673>, <-0.167012, -0.710077, 0.361569>, <-0.173782, -0.742496, 0.346410>, <-0.179666, -0.738919, 0.346444>,
      <-0.111824, -0.730319, 0.328379>, <-0.108602, -0.728812, 0.334275>, <-0.128841, -0.732562, 0.327540>, <-0.134725, -0.728985, 0.327574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.344344, -0.756832, 0.545457>, <-0.402055, -0.727635, 0.540387>, <-0.473100, -0.674217, 0.530932>, <-0.516840, -0.631607, 0.509025>,
      <-0.337925, -0.768767, 0.518128>, <-0.395636, -0.739570, 0.513058>, <-0.464643, -0.696941, 0.489016>, <-0.508383, -0.654331, 0.467109>,
      <-0.304546, -0.745077, 0.486469>, <-0.373067, -0.733885, 0.491328>, <-0.430516, -0.681473, 0.433069>, <-0.488439, -0.658390, 0.402149>,
      <-0.293568, -0.746043, 0.458025>, <-0.362088, -0.734852, 0.462884>, <-0.428721, -0.692183, 0.385878>, <-0.486643, -0.669100, 0.354958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.412901, -0.524179, 0.966055>, <-0.467275, -0.500559, 0.915976>, <-0.535050, -0.470408, 0.841406>, <-0.572832, -0.437511, 0.782138>,
      <-0.392938, -0.632169, 0.870371>, <-0.447313, -0.608549, 0.820293>, <-0.523928, -0.549826, 0.778518>, <-0.561710, -0.516930, 0.719250>,
      <-0.374996, -0.699844, 0.675950>, <-0.432707, -0.670647, 0.670880>, <-0.490899, -0.626393, 0.619148>, <-0.534639, -0.583782, 0.597240>,
      <-0.344344, -0.756832, 0.545457>, <-0.402055, -0.727635, 0.540387>, <-0.473100, -0.674217, 0.530932>, <-0.516840, -0.631607, 0.509025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.468943, -0.082802, 1.142677>, <-0.476785, 0.073614, 1.149939>, <-0.462277, 0.289864, 1.093412>, <-0.460369, 0.422607, 1.010012>,
      <-0.517387, -0.088196, 1.088325>, <-0.525229, 0.068219, 1.095587>, <-0.508192, 0.264689, 1.044397>, <-0.506284, 0.397432, 0.960996>,
      <-0.562311, -0.100459, 0.999680>, <-0.566085, 0.030680, 1.008680>, <-0.564737, 0.254470, 0.967386>, <-0.564183, 0.362062, 0.891782>,
      <-0.591833, -0.096123, 0.933049>, <-0.595607, 0.035015, 0.942049>, <-0.595505, 0.223476, 0.910489>, <-0.594951, 0.331069, 0.834885>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.468943, -0.082802, 1.142677>, <-0.517387, -0.088196, 1.088325>, <-0.562311, -0.100459, 0.999680>, <-0.591833, -0.096123, 0.933049>,
      <-0.461760, -0.226077, 1.136025>, <-0.510204, -0.231471, 1.081673>, <-0.559093, -0.212271, 0.992007>, <-0.588615, -0.207936, 0.925375>,
      <-0.432583, -0.417707, 1.060394>, <-0.486957, -0.394087, 1.010315>, <-0.547287, -0.383032, 0.910594>, <-0.585069, -0.350135, 0.851326>,
      <-0.412901, -0.524179, 0.966055>, <-0.467275, -0.500559, 0.915976>, <-0.535050, -0.470408, 0.841406>, <-0.572832, -0.437511, 0.782138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433567, 0.741324, 0.218367>, <-0.480888, 0.687029, 0.197186>, <-0.535914, 0.601188, 0.178963>, <-0.558886, 0.535632, 0.150492>,
      <-0.403333, 0.717639, 0.036893>, <-0.450654, 0.663343, 0.015712>, <-0.501328, 0.585758, 0.015614>, <-0.524300, 0.520202, -0.012856>,
      <-0.311150, 0.600307, -0.176980>, <-0.347154, 0.566303, -0.181575>, <-0.400699, 0.510536, -0.205717>, <-0.427473, 0.469746, -0.215360>,
      <-0.289912, 0.574592, -0.359450>, <-0.325917, 0.540589, -0.364045>, <-0.378060, 0.497853, -0.371378>, <-0.404834, 0.457063, -0.381021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.433567, 0.741324, 0.218367>, <-0.454635, 0.757829, 0.344826>, <-0.453547, 0.754215, 0.527260>, <-0.457605, 0.705964, 0.647108>,
      <-0.480888, 0.687029, 0.197186>, <-0.501956, 0.703534, 0.323645>, <-0.502041, 0.711585, 0.480383>, <-0.506098, 0.663334, 0.600231>,
      <-0.535914, 0.601188, 0.178963>, <-0.556802, 0.610507, 0.277615>, <-0.558345, 0.622632, 0.442275>, <-0.563451, 0.593667, 0.539179>,
      <-0.558886, 0.535632, 0.150492>, <-0.579774, 0.544951, 0.249144>, <-0.583458, 0.567997, 0.389827>, <-0.588565, 0.539033, 0.486731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.855945, -0.658526>, <-0.080946, -0.866007, -0.664423>, <-0.034975, -0.880022, -0.672515>, <0.000517, -0.880022, -0.672515>,
      <-0.117055, -0.910099, -0.627088>, <-0.083533, -0.920161, -0.632985>, <-0.034975, -0.934998, -0.641954>, <0.000517, -0.934998, -0.641954>,
      <-0.101898, -0.878909, -0.514461>, <-0.074043, -0.885646, -0.522153>, <-0.029770, -0.897402, -0.526497>, <-0.000099, -0.897402, -0.526497>,
      <-0.096191, -0.894439, -0.454013>, <-0.068337, -0.901175, -0.461705>, <-0.029154, -0.911839, -0.465280>, <0.000517, -0.911839, -0.465280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.855945, -0.658526>, <-0.108618, -0.733539, -0.729586>, <-0.081263, -0.488133, -0.639625>, <-0.072261, -0.393615, -0.744755>,
      <-0.080946, -0.866007, -0.664423>, <-0.075097, -0.743601, -0.735483>, <-0.059510, -0.490855, -0.641357>, <-0.050507, -0.396337, -0.746487>,
      <-0.034975, -0.880022, -0.672515>, <-0.034975, -0.752880, -0.743193>, <-0.021475, -0.501576, -0.643863>, <-0.021475, -0.401176, -0.749126>,
      <0.000517, -0.880022, -0.672515>, <0.000517, -0.752880, -0.743193>, <0.000517, -0.501624, -0.643866>, <0.000517, -0.401224, -0.749129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.855945, -0.658526>, <-0.117055, -0.910099, -0.627088>, <-0.101898, -0.878909, -0.514461>, <-0.096191, -0.894439, -0.454013>,
      <-0.136407, -0.849360, -0.654666>, <-0.138995, -0.903514, -0.623228>, <-0.124368, -0.873475, -0.508256>, <-0.118662, -0.889005, -0.447808>,
      <-0.163957, -0.836282, -0.647115>, <-0.168811, -0.892848, -0.609924>, <-0.152043, -0.863627, -0.500473>, <-0.147229, -0.879006, -0.434542>,
      <-0.183020, -0.824933, -0.640226>, <-0.187874, -0.881500, -0.603035>, <-0.169416, -0.856527, -0.485616>, <-0.164602, -0.871906, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.114467, -0.855945, -0.658526>, <-0.136407, -0.849360, -0.654666>, <-0.163957, -0.836282, -0.647115>, <-0.183020, -0.824933, -0.640226>,
      <-0.108618, -0.733539, -0.729586>, <-0.130559, -0.726954, -0.725726>, <-0.154213, -0.722721, -0.721779>, <-0.173276, -0.711373, -0.714890>,
      <-0.081263, -0.488133, -0.639625>, <-0.096552, -0.486220, -0.638408>, <-0.117990, -0.476039, -0.637022>, <-0.132964, -0.472814, -0.634949>,
      <-0.072261, -0.393615, -0.744755>, <-0.087550, -0.391702, -0.743538>, <-0.107917, -0.389007, -0.741375>, <-0.122890, -0.385783, -0.739302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.323820, 0.805346, 0.255711>, <-0.338796, 0.822227, 0.396817>, <-0.332203, 0.814266, 0.597597>, <-0.337234, 0.759978, 0.729686>,
      <-0.358724, 0.789096, 0.245911>, <-0.373700, 0.805977, 0.387017>, <-0.371414, 0.800531, 0.576286>, <-0.376445, 0.746243, 0.708375>,
      <-0.408525, 0.770058, 0.229576>, <-0.429593, 0.786563, 0.356036>, <-0.425169, 0.779163, 0.554693>, <-0.429226, 0.730912, 0.674541>,
      <-0.433567, 0.741324, 0.218367>, <-0.454635, 0.757829, 0.344826>, <-0.453547, 0.754215, 0.527260>, <-0.457605, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.323820, 0.805346, 0.255711>, <-0.358724, 0.789096, 0.245911>, <-0.408525, 0.770058, 0.229576>, <-0.433567, 0.741324, 0.218367>,
      <-0.303507, 0.782450, 0.064320>, <-0.338411, 0.766200, 0.054520>, <-0.378291, 0.746372, 0.048103>, <-0.403333, 0.717639, 0.036893>,
      <-0.237378, 0.657871, -0.166502>, <-0.257803, 0.641280, -0.167038>, <-0.292096, 0.618301, -0.174548>, <-0.311150, 0.600307, -0.176980>,
      <-0.221828, 0.629897, -0.357664>, <-0.242253, 0.613305, -0.358200>, <-0.270858, 0.592587, -0.357018>, <-0.289912, 0.574592, -0.359450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.323820, 0.805346, 0.255711>, <-0.303507, 0.782450, 0.064320>, <-0.237378, 0.657871, -0.166502>, <-0.221828, 0.629897, -0.357664>,
      <-0.290682, 0.820774, 0.265016>, <-0.270368, 0.797878, 0.073625>, <-0.201420, 0.671012, -0.167210>, <-0.185870, 0.643038, -0.358372>,
      <-0.244248, 0.838407, 0.275807>, <-0.225713, 0.817460, 0.075861>, <-0.153799, 0.692701, -0.155790>, <-0.138657, 0.663932, -0.355048>,
      <-0.207866, 0.846401, 0.281739>, <-0.189331, 0.825454, 0.081793>, <-0.117111, 0.702468, -0.160765>, <-0.101969, 0.673699, -0.360023>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.323820, 0.805346, 0.255711>, <-0.290682, 0.820774, 0.265016>, <-0.244248, 0.838407, 0.275807>, <-0.207866, 0.846401, 0.281739>,
      <-0.338796, 0.822227, 0.396817>, <-0.305658, 0.837655, 0.406122>, <-0.258126, 0.854091, 0.425510>, <-0.221743, 0.862085, 0.431442>,
      <-0.332203, 0.814266, 0.597597>, <-0.295987, 0.826952, 0.617280>, <-0.249838, 0.843145, 0.631433>, <-0.208846, 0.850301, 0.642765>,
      <-0.337234, 0.759978, 0.729686>, <-0.301018, 0.772664, 0.749369>, <-0.248902, 0.786272, 0.771483>, <-0.207910, 0.793428, 0.782815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.329692, -0.066933, 1.227160>, <-0.336821, 0.096718, 1.238067>, <-0.354328, 0.321626, 1.175016>, <-0.355611, 0.462296, 1.090388>,
      <-0.374204, -0.069463, 1.206606>, <-0.381333, 0.094188, 1.217512>, <-0.389404, 0.312296, 1.155178>, <-0.390686, 0.452966, 1.070550>,
      <-0.436367, -0.079175, 1.179226>, <-0.444209, 0.077241, 1.186488>, <-0.435799, 0.304382, 1.121679>, <-0.433891, 0.437125, 1.038279>,
      <-0.468943, -0.082802, 1.142677>, <-0.476785, 0.073614, 1.149939>, <-0.462277, 0.289864, 1.093412>, <-0.460369, 0.422607, 1.010012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.311468, -0.551045, 1.022853>, <-0.328876, -0.438374, 1.131856>, <-0.322843, -0.224167, 1.216681>, <-0.329692, -0.066933, 1.227160>,
      <-0.343958, -0.543482, 1.009874>, <-0.361367, -0.430811, 1.118877>, <-0.367355, -0.226698, 1.196127>, <-0.374204, -0.069463, 1.206606>,
      <-0.387821, -0.535074, 0.989154>, <-0.407503, -0.428602, 1.083493>, <-0.429184, -0.222449, 1.172574>, <-0.436367, -0.079175, 1.179226>,
      <-0.412901, -0.524179, 0.966055>, <-0.432583, -0.417707, 1.060394>, <-0.461760, -0.226077, 1.136025>, <-0.468943, -0.082802, 1.142677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219180, -0.782198, 0.535177>, <-0.256189, -0.774532, 0.542173>, <-0.310152, -0.774130, 0.548461>, <-0.344344, -0.756832, 0.545457>,
      <-0.199977, -0.799442, 0.468377>, <-0.236985, -0.791776, 0.475373>, <-0.303733, -0.786065, 0.521132>, <-0.337925, -0.768767, 0.518128>,
      <-0.132921, -0.716273, 0.395357>, <-0.191331, -0.697538, 0.422651>, <-0.238446, -0.755873, 0.481782>, <-0.304546, -0.745077, 0.486469>,
      <-0.111824, -0.730319, 0.328379>, <-0.170234, -0.711584, 0.355673>, <-0.227468, -0.756839, 0.453338>, <-0.293568, -0.746043, 0.458025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.219180, -0.782198, 0.535177>, <-0.263226, -0.742646, 0.688394>, <-0.293340, -0.668376, 0.909342>, <-0.311468, -0.551045, 1.022853>,
      <-0.256189, -0.774532, 0.542173>, <-0.300235, -0.734980, 0.695390>, <-0.325830, -0.660812, 0.896363>, <-0.343958, -0.543482, 1.009874>,
      <-0.310152, -0.774130, 0.548461>, <-0.340804, -0.717142, 0.678954>, <-0.367858, -0.643064, 0.893470>, <-0.387821, -0.535074, 0.989154>,
      <-0.344344, -0.756832, 0.545457>, <-0.374996, -0.699844, 0.675950>, <-0.392938, -0.632169, 0.870371>, <-0.412901, -0.524179, 0.966055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.884999, -0.114376>, <-0.109102, -0.880500, -0.120855>, <-0.129722, -0.872529, -0.115090>, <-0.138035, -0.866827, -0.106417>,
      <-0.095772, -0.885611, -0.101443>, <-0.106478, -0.881112, -0.107921>, <-0.127118, -0.873025, -0.106812>, <-0.135431, -0.867324, -0.098139>,
      <-0.112547, -0.906563, -0.094528>, <-0.122940, -0.897557, -0.100849>, <-0.134513, -0.882708, -0.094155>, <-0.144740, -0.873237, -0.088255>,
      <-0.111583, -0.912943, -0.083000>, <-0.121976, -0.903936, -0.089321>, <-0.135754, -0.885614, -0.086057>, <-0.145980, -0.876143, -0.080157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.884999, -0.114376>, <-0.107110, -0.882967, -0.157324>, <-0.138343, -0.900306, -0.208296>, <-0.145727, -0.904982, -0.251286>,
      <-0.109102, -0.880500, -0.120855>, <-0.117816, -0.878469, -0.163802>, <-0.159334, -0.890976, -0.215082>, <-0.166718, -0.895652, -0.258072>,
      <-0.129722, -0.872529, -0.115090>, <-0.146478, -0.869332, -0.168359>, <-0.168934, -0.880695, -0.222649>, <-0.189377, -0.877918, -0.274640>,
      <-0.138035, -0.866827, -0.106417>, <-0.154791, -0.863630, -0.159687>, <-0.188086, -0.866989, -0.227014>, <-0.208529, -0.864211, -0.279004>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.884999, -0.114376>, <-0.095772, -0.885611, -0.101443>, <-0.112547, -0.906563, -0.094528>, <-0.111583, -0.912943, -0.083000>,
      <-0.077169, -0.893919, -0.101531>, <-0.074545, -0.894531, -0.088597>, <-0.095335, -0.921479, -0.084061>, <-0.094371, -0.927858, -0.072533>,
      <-0.068903, -0.900184, -0.052287>, <-0.070204, -0.901169, -0.036984>, <-0.073601, -0.922340, -0.049550>, <-0.075695, -0.935564, -0.041960>,
      <-0.043502, -0.906550, -0.049212>, <-0.044803, -0.907534, -0.033909>, <-0.058509, -0.936906, -0.035826>, <-0.060603, -0.950129, -0.028236>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.098396, -0.884999, -0.114376>, <-0.077169, -0.893919, -0.101531>, <-0.068903, -0.900184, -0.052287>, <-0.043502, -0.906550, -0.049212>,
      <-0.107110, -0.882967, -0.157324>, <-0.085882, -0.891887, -0.144478>, <-0.064357, -0.896745, -0.105750>, <-0.038956, -0.903111, -0.102675>,
      <-0.138343, -0.900306, -0.208296>, <-0.109433, -0.913155, -0.198950>, <-0.075914, -0.921179, -0.174860>, <-0.044563, -0.931133, -0.172362>,
      <-0.145727, -0.904982, -0.251286>, <-0.116817, -0.917832, -0.241940>, <-0.075161, -0.927470, -0.228252>, <-0.043809, -0.937424, -0.225753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.187575, -0.066809, 1.272605>, <-0.191200, 0.103560, 1.288009>, <-0.198510, 0.342664, 1.240768>, <-0.202024, 0.491323, 1.156127>,
      <-0.231452, -0.067056, 1.263753>, <-0.235077, 0.103313, 1.279157>, <-0.247445, 0.336510, 1.228309>, <-0.250959, 0.485169, 1.143667>,
      <-0.289108, -0.064626, 1.245901>, <-0.296237, 0.099025, 1.256807>, <-0.311190, 0.333100, 1.199413>, <-0.312473, 0.473770, 1.114786>,
      <-0.329692, -0.066933, 1.227160>, <-0.336821, 0.096718, 1.238067>, <-0.354328, 0.321626, 1.175016>, <-0.355611, 0.462296, 1.090388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.179259, -0.578567, 1.059389>, <-0.191778, -0.463857, 1.179194>, <-0.184051, -0.232434, 1.257629>, <-0.187575, -0.066809, 1.272605>,
      <-0.220299, -0.572904, 1.052673>, <-0.232818, -0.458193, 1.172478>, <-0.227928, -0.232681, 1.248777>, <-0.231452, -0.067056, 1.263753>,
      <-0.273373, -0.559913, 1.038071>, <-0.290781, -0.447242, 1.147074>, <-0.282258, -0.221861, 1.235422>, <-0.289108, -0.064626, 1.245901>,
      <-0.311468, -0.551045, 1.022853>, <-0.328876, -0.438374, 1.131856>, <-0.322843, -0.224167, 1.216681>, <-0.329692, -0.066933, 1.227160>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106900, -0.806017, 0.500570>, <-0.137029, -0.747718, 0.670646>, <-0.165539, -0.704283, 0.928090>, <-0.179259, -0.578567, 1.059389>,
      <-0.140357, -0.799281, 0.511917>, <-0.170486, -0.740981, 0.681992>, <-0.206579, -0.698620, 0.921374>, <-0.220299, -0.572904, 1.052673>,
      <-0.184551, -0.789371, 0.528631>, <-0.228597, -0.749819, 0.681848>, <-0.255245, -0.677243, 0.924560>, <-0.273373, -0.559913, 1.038071>,
      <-0.219180, -0.782198, 0.535177>, <-0.263226, -0.742646, 0.688394>, <-0.293340, -0.668376, 0.909342>, <-0.311468, -0.551045, 1.022853>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.106900, -0.806017, 0.500570>, <-0.140357, -0.799281, 0.511917>, <-0.184551, -0.789371, 0.528631>, <-0.219180, -0.782198, 0.535177>,
      <-0.098713, -0.821859, 0.454353>, <-0.132169, -0.815123, 0.465700>, <-0.165348, -0.806615, 0.461830>, <-0.199977, -0.799442, 0.468377>,
      <-0.061615, -0.810570, 0.392579>, <-0.086979, -0.789145, 0.388678>, <-0.103836, -0.725602, 0.381766>, <-0.132921, -0.716273, 0.395357>,
      <-0.052796, -0.823271, 0.345516>, <-0.078160, -0.801845, 0.341615>, <-0.082740, -0.739648, 0.314788>, <-0.111824, -0.730319, 0.328379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.065075, 1.293777>, <0.000517, 0.109050, 1.310721>, <0.000517, 0.352666, 1.263289>, <0.000517, 0.507086, 1.181063>,
      <-0.056269, -0.065075, 1.293777>, <-0.056269, 0.109050, 1.310721>, <-0.060886, 0.352666, 1.263289>, <-0.060886, 0.507086, 1.181063>,
      <-0.131911, -0.066496, 1.283835>, <-0.135536, 0.103873, 1.299239>, <-0.139442, 0.350093, 1.255808>, <-0.142956, 0.498752, 1.171166>,
      <-0.187575, -0.066809, 1.272605>, <-0.191200, 0.103560, 1.288009>, <-0.198510, 0.342664, 1.240768>, <-0.202024, 0.491323, 1.156127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.065075, 1.293777>, <-0.056269, -0.065075, 1.293777>, <-0.131911, -0.066496, 1.283835>, <-0.187575, -0.066809, 1.272605>,
      <0.000517, -0.236136, 1.277131>, <-0.056269, -0.236136, 1.277131>, <-0.128387, -0.232121, 1.268859>, <-0.184051, -0.232434, 1.257629>,
      <0.000517, -0.478156, 1.200777>, <-0.053792, -0.478156, 1.200777>, <-0.138673, -0.471185, 1.187884>, <-0.191778, -0.463857, 1.179194>,
      <0.000517, -0.594099, 1.073907>, <-0.053792, -0.594099, 1.073907>, <-0.126154, -0.585896, 1.068079>, <-0.179259, -0.578567, 1.059389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.826433, 0.460669>, <0.000517, -0.756733, 0.644640>, <0.000517, -0.726815, 0.928683>, <0.000517, -0.594099, 1.073907>,
      <-0.034401, -0.826433, 0.460669>, <-0.034401, -0.756733, 0.644640>, <-0.053792, -0.726815, 0.928683>, <-0.053792, -0.594099, 1.073907>,
      <-0.074417, -0.812557, 0.489554>, <-0.104546, -0.754258, 0.659630>, <-0.112433, -0.711612, 0.936780>, <-0.126154, -0.585896, 1.068079>,
      <-0.106900, -0.806017, 0.500570>, <-0.137029, -0.747718, 0.670646>, <-0.165539, -0.704283, 0.928090>, <-0.179259, -0.578567, 1.059389>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000517, -0.826433, 0.460669>, <-0.034401, -0.826433, 0.460669>, <-0.074417, -0.812557, 0.489554>, <-0.106900, -0.806017, 0.500570>,
      <0.000517, -0.826068, 0.426166>, <-0.034401, -0.826068, 0.426166>, <-0.066230, -0.828400, 0.443337>, <-0.098713, -0.821859, 0.454353>,
      <0.000341, -0.817064, 0.379186>, <-0.015376, -0.818224, 0.376400>, <-0.049472, -0.820827, 0.394447>, <-0.061615, -0.810570, 0.392579>,
      <0.000517, -0.825215, 0.345658>, <-0.015200, -0.826376, 0.342872>, <-0.040653, -0.833528, 0.347384>, <-0.052796, -0.823271, 0.345516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.124083, -0.848624, 0.037892>, <0.123131, -0.853942, 0.026407>, <0.126289, -0.865477, 0.013449>, <0.128581, -0.870891, 0.002201>,
      <0.137695, -0.842984, 0.015762>, <0.136743, -0.848301, 0.004278>, <0.136351, -0.858729, 0.000331>, <0.138643, -0.864143, -0.010917>,
      <0.160558, -0.833600, -0.014916>, <0.153202, -0.835240, -0.015641>, <0.155670, -0.851487, -0.031571>, <0.152815, -0.858476, -0.032134>,
      <0.162220, -0.836921, -0.041242>, <0.154865, -0.838561, -0.041967>, <0.158170, -0.852655, -0.049213>, <0.155315, -0.859644, -0.049776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.074627, -0.873217, 0.101158>, <0.072897, -0.883417, 0.085907>, <0.071222, -0.901595, 0.068277>, <0.075203, -0.913373, 0.054673>,
      <0.089276, -0.863558, 0.083077>, <0.087547, -0.873758, 0.067826>, <0.088291, -0.888547, 0.053957>, <0.092272, -0.900325, 0.040353>,
      <0.111183, -0.853969, 0.058864>, <0.110230, -0.859287, 0.047379>, <0.111741, -0.875234, 0.032417>, <0.114032, -0.880648, 0.021169>,
      <0.124083, -0.848624, 0.037892>, <0.123131, -0.853942, 0.026407>, <0.126289, -0.865477, 0.013449>, <0.128581, -0.870891, 0.002201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.037331, -0.905821, 0.144963>, <0.036897, -0.914750, 0.123537>, <0.041337, -0.922651, 0.092736>, <0.042890, -0.936393, 0.074088>,
      <0.053745, -0.898698, 0.136395>, <0.053311, -0.907628, 0.114969>, <0.052001, -0.915838, 0.088806>, <0.053554, -0.929580, 0.070158>,
      <0.063092, -0.880822, 0.115394>, <0.061363, -0.891022, 0.100143>, <0.062461, -0.908291, 0.075626>, <0.066443, -0.920069, 0.062022>,
      <0.074627, -0.873217, 0.101158>, <0.072897, -0.883417, 0.085907>, <0.071222, -0.901595, 0.068277>, <0.075203, -0.913373, 0.054673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.037331, -0.905821, 0.144963>, <0.038657, -0.878515, 0.210485>, <0.036470, -0.834669, 0.296193>, <0.048747, -0.815773, 0.363518>,
      <0.028480, -0.909662, 0.149583>, <0.029806, -0.882356, 0.215105>, <0.024881, -0.845070, 0.298087>, <0.037158, -0.826175, 0.365412>,
      <0.012777, -0.905520, 0.137609>, <0.011518, -0.875904, 0.197061>, <0.016261, -0.839771, 0.283839>, <0.015922, -0.824078, 0.348389>,
      <0.002202, -0.904645, 0.138962>, <0.000943, -0.875029, 0.198413>, <0.000855, -0.840908, 0.281107>, <0.000517, -0.825215, 0.345658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.037331, -0.905821, 0.144963>, <0.028480, -0.909662, 0.149583>, <0.012777, -0.905520, 0.137609>, <0.002202, -0.904645, 0.138962>,
      <0.036897, -0.914750, 0.123537>, <0.028047, -0.918591, 0.128157>, <0.013228, -0.916111, 0.116350>, <0.002652, -0.915236, 0.117703>,
      <0.041337, -0.922651, 0.092736>, <0.031003, -0.929254, 0.096545>, <0.019158, -0.938680, 0.094692>, <0.006459, -0.939936, 0.096123>,
      <0.042890, -0.936393, 0.074088>, <0.032556, -0.942995, 0.077897>, <0.018841, -0.956238, 0.078694>, <0.006142, -0.957494, 0.080125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586202, 0.539033, 0.486731>, <0.592163, 0.504231, 0.603168>, <0.591681, 0.430621, 0.764931>, <0.591777, 0.331069, 0.834885>,
      <0.621188, 0.462141, 0.412916>, <0.627149, 0.427339, 0.529353>, <0.625389, 0.394729, 0.699040>, <0.625485, 0.295177, 0.768994>,
      <0.641111, 0.359364, 0.303241>, <0.656269, 0.346544, 0.416163>, <0.656920, 0.306525, 0.583626>, <0.657897, 0.241267, 0.677891>,
      <0.652785, 0.273520, 0.231970>, <0.667942, 0.260700, 0.344892>, <0.673542, 0.268317, 0.512704>, <0.674519, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.410452, -0.571031, -0.502258>, <0.393281, -0.600142, -0.517208>, <0.362446, -0.634381, -0.535738>, <0.340910, -0.661193, -0.549270>,
      <0.397386, -0.476693, -0.568343>, <0.380215, -0.505804, -0.583293>, <0.354813, -0.541297, -0.608200>, <0.333277, -0.568109, -0.621732>,
      <0.361719, -0.267920, -0.527366>, <0.343040, -0.294929, -0.542916>, <0.315956, -0.333220, -0.566206>, <0.292787, -0.356800, -0.581283>,
      <0.351813, -0.210187, -0.627398>, <0.333135, -0.237196, -0.642948>, <0.306582, -0.270814, -0.666162>, <0.283412, -0.294394, -0.681239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.047959, -0.999867, 0.017338>, <0.046318, -0.996653, 0.042671>, <0.044602, -0.951539, 0.053534>, <0.042890, -0.936393, 0.074088>,
      <0.033911, -1.003154, 0.026116>, <0.032271, -0.999940, 0.051449>, <0.034267, -0.958141, 0.057343>, <0.032556, -0.942995, 0.077897>,
      <0.017171, -1.005134, 0.048532>, <0.019327, -0.993483, 0.061641>, <0.018606, -0.969298, 0.066794>, <0.018841, -0.956238, 0.078694>,
      <0.000379, -1.005746, 0.046842>, <0.002535, -0.994095, 0.059951>, <0.005907, -0.970554, 0.068225>, <0.006142, -0.957494, 0.080125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.047959, -0.999867, 0.017338>, <0.033911, -1.003154, 0.026116>, <0.017171, -1.005134, 0.048532>, <0.000379, -1.005746, 0.046842>,
      <0.049502, -1.002890, -0.006484>, <0.035454, -1.006177, 0.002294>, <0.015903, -1.011983, 0.040826>, <-0.000888, -1.012595, 0.039136>,
      <0.052823, -0.971228, -0.032821>, <0.033084, -0.988924, -0.016062>, <0.026125, -1.022142, 0.017790>, <-0.004810, -1.021698, 0.022938>,
      <0.050716, -0.951726, -0.046758>, <0.030977, -0.969422, -0.029999>, <0.026232, -1.016537, 0.009046>, <-0.004703, -1.016093, 0.014193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.047959, -0.999867, 0.017338>, <0.049502, -1.002890, -0.006484>, <0.052823, -0.971228, -0.032821>, <0.050716, -0.951726, -0.046758>,
      <0.067109, -0.995386, 0.005371>, <0.068652, -0.998408, -0.018451>, <0.067780, -0.957819, -0.045519>, <0.065673, -0.938317, -0.059456>,
      <0.097133, -0.996126, -0.012953>, <0.103729, -0.996136, -0.039196>, <0.096421, -0.947432, -0.058347>, <0.092277, -0.928301, -0.077030>,
      <0.110700, -0.979929, -0.022097>, <0.117296, -0.979940, -0.048341>, <0.113959, -0.932561, -0.064349>, <0.109815, -0.913430, -0.083032>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.047959, -0.999867, 0.017338>, <0.067109, -0.995386, 0.005371>, <0.097133, -0.996126, -0.012953>, <0.110700, -0.979929, -0.022097>,
      <0.046318, -0.996653, 0.042671>, <0.065469, -0.992171, 0.030704>, <0.089262, -0.996113, 0.018361>, <0.102829, -0.979916, 0.009217>,
      <0.044602, -0.951539, 0.053534>, <0.055266, -0.944726, 0.049604>, <0.073418, -0.940704, 0.038188>, <0.082178, -0.934008, 0.030839>,
      <0.042890, -0.936393, 0.074088>, <0.053554, -0.929580, 0.070158>, <0.066443, -0.920069, 0.062022>, <0.075203, -0.913373, 0.054673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.657695, -0.054363, 0.705599>, <0.668291, -0.038507, 0.653829>, <0.664437, 0.000741, 0.589454>, <0.667327, 0.024357, 0.539677>,
      <0.663234, 0.028302, 0.706503>, <0.673830, 0.044157, 0.654733>, <0.664109, 0.041498, 0.596329>, <0.666998, 0.065114, 0.546552>,
      <0.675225, 0.155900, 0.675090>, <0.681219, 0.142123, 0.649516>, <0.667856, 0.130783, 0.552058>, <0.666402, 0.119616, 0.524618>,
      <0.674519, 0.203059, 0.606969>, <0.680513, 0.189282, 0.581395>, <0.667460, 0.171608, 0.545604>, <0.666006, 0.160441, 0.518164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.559317, -0.048324, -0.242370>, <0.569215, 0.008202, -0.204222>, <0.585604, 0.053353, -0.119133>, <0.591578, 0.106858, -0.076121>,
      <0.575134, -0.086549, -0.183190>, <0.585032, -0.030023, -0.145041>, <0.601213, 0.045234, -0.062406>, <0.607188, 0.098738, -0.019394>,
      <0.579776, -0.180516, -0.135588>, <0.598204, -0.085738, -0.083980>, <0.621522, -0.000261, -0.002229>, <0.632736, 0.092082, 0.055502>,
      <0.593008, -0.218733, -0.075771>, <0.611437, -0.123955, -0.024163>, <0.636209, -0.003511, 0.055228>, <0.647423, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.559317, -0.048324, -0.242370>, <0.540624, -0.003148, -0.312312>, <0.490857, 0.043645, -0.412078>, <0.480615, 0.052883, -0.496291>,
      <0.569215, 0.008202, -0.204222>, <0.550521, 0.053378, -0.274164>, <0.497598, 0.077826, -0.399066>, <0.487356, 0.087064, -0.483279>,
      <0.585604, 0.053353, -0.119133>, <0.553982, 0.069802, -0.234050>, <0.505449, 0.128709, -0.350131>, <0.490597, 0.135010, -0.469362>,
      <0.591578, 0.106858, -0.076121>, <0.559956, 0.123307, -0.191038>, <0.504931, 0.164376, -0.339610>, <0.490079, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.278835, -0.762097, 0.390475>, <0.215697, -0.770769, 0.385199>, <0.174062, -0.738919, 0.346444>, <0.129159, -0.728985, 0.327574>,
      <0.273500, -0.748352, 0.377111>, <0.210362, -0.757025, 0.371835>, <0.181556, -0.734376, 0.346488>, <0.136653, -0.724442, 0.327617>,
      <0.272934, -0.719043, 0.406825>, <0.215252, -0.722829, 0.402406>, <0.178592, -0.711165, 0.353867>, <0.141512, -0.712707, 0.328301>,
      <0.270405, -0.700591, 0.413832>, <0.212723, -0.704377, 0.409413>, <0.183886, -0.704189, 0.354179>, <0.146806, -0.705731, 0.328613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.451985, -0.684644, 0.354552>, <0.400040, -0.707880, 0.365329>, <0.352398, -0.751993, 0.396622>, <0.278835, -0.762097, 0.390475>,
      <0.447099, -0.686625, 0.354075>, <0.395154, -0.709861, 0.364851>, <0.347063, -0.738248, 0.383259>, <0.273500, -0.748352, 0.377111>,
      <0.440029, -0.686167, 0.351846>, <0.390679, -0.690298, 0.370790>, <0.340801, -0.714588, 0.412025>, <0.272934, -0.719043, 0.406825>,
      <0.434905, -0.686819, 0.350686>, <0.385555, -0.690951, 0.369630>, <0.338272, -0.696136, 0.419032>, <0.270405, -0.700591, 0.413832>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.451985, -0.684644, 0.354552>, <0.447099, -0.686625, 0.354075>, <0.440029, -0.686167, 0.351846>, <0.434905, -0.686819, 0.350686>,
      <0.432024, -0.695357, 0.343631>, <0.427138, -0.697337, 0.343154>, <0.425809, -0.686361, 0.345487>, <0.420685, -0.687013, 0.344327>,
      <0.408349, -0.711614, 0.323773>, <0.410504, -0.706487, 0.332625>, <0.401914, -0.694413, 0.328983>, <0.402531, -0.684547, 0.332385>,
      <0.385448, -0.720353, 0.318149>, <0.387603, -0.715226, 0.327001>, <0.386889, -0.697333, 0.326088>, <0.387506, -0.687467, 0.329490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.451985, -0.684644, 0.354552>, <0.432024, -0.695357, 0.343631>, <0.408349, -0.711614, 0.323773>, <0.385448, -0.720353, 0.318149>,
      <0.460524, -0.681183, 0.355386>, <0.440563, -0.691895, 0.344466>, <0.405408, -0.718612, 0.311691>, <0.382507, -0.727351, 0.306067>,
      <0.470627, -0.673763, 0.354836>, <0.438171, -0.701758, 0.351074>, <0.410832, -0.704320, 0.304077>, <0.373986, -0.717099, 0.285903>,
      <0.478617, -0.669100, 0.354958>, <0.446161, -0.697094, 0.351196>, <0.410384, -0.707926, 0.290279>, <0.373537, -0.720704, 0.272105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254203, -0.760116, 0.305981>, <0.295225, -0.756069, 0.303393>, <0.347837, -0.734705, 0.308912>, <0.385448, -0.720353, 0.318149>,
      <0.254107, -0.756218, 0.317217>, <0.295129, -0.752171, 0.314628>, <0.349992, -0.729578, 0.317765>, <0.387603, -0.715226, 0.327001>,
      <0.254781, -0.733278, 0.313016>, <0.295783, -0.728998, 0.311504>, <0.347099, -0.705066, 0.318422>, <0.386889, -0.697333, 0.326088>,
      <0.255028, -0.721776, 0.316031>, <0.296030, -0.717496, 0.314519>, <0.347716, -0.695200, 0.321824>, <0.387506, -0.687467, 0.329490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172216, -0.741388, 0.331604>, <0.204688, -0.749472, 0.325997>, <0.228007, -0.762700, 0.307634>, <0.254203, -0.760116, 0.305981>,
      <0.176088, -0.736787, 0.339451>, <0.208560, -0.744871, 0.333844>, <0.227911, -0.758802, 0.318870>, <0.254107, -0.756218, 0.317217>,
      <0.176016, -0.718978, 0.335543>, <0.206808, -0.723543, 0.331963>, <0.230572, -0.735805, 0.313909>, <0.254781, -0.733278, 0.313016>,
      <0.177645, -0.709374, 0.337231>, <0.208437, -0.713939, 0.333651>, <0.230820, -0.724303, 0.316924>, <0.255028, -0.721776, 0.316031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172216, -0.741388, 0.331604>, <0.176088, -0.736787, 0.339451>, <0.176016, -0.718978, 0.335543>, <0.177645, -0.709374, 0.337231>,
      <0.155599, -0.737251, 0.334473>, <0.159471, -0.732650, 0.342321>, <0.163794, -0.717166, 0.336964>, <0.165422, -0.707562, 0.338652>,
      <0.142076, -0.732706, 0.328783>, <0.149570, -0.728163, 0.328826>, <0.150764, -0.713800, 0.330887>, <0.156058, -0.706824, 0.331198>,
      <0.129159, -0.728985, 0.327574>, <0.136653, -0.724442, 0.327617>, <0.141512, -0.712707, 0.328301>, <0.146806, -0.705731, 0.328613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106245, -0.730319, 0.328379>, <0.082974, -0.746261, 0.252361>, <0.082237, -0.828340, 0.168259>, <0.074627, -0.873217, 0.101158>,
      <0.115121, -0.734497, 0.312036>, <0.091850, -0.750439, 0.236018>, <0.096887, -0.818681, 0.150178>, <0.089276, -0.863558, 0.083077>,
      <0.135498, -0.737981, 0.294642>, <0.123091, -0.765623, 0.218933>, <0.117303, -0.819802, 0.132655>, <0.111183, -0.853969, 0.058864>,
      <0.152068, -0.739768, 0.285392>, <0.139661, -0.767410, 0.209682>, <0.130203, -0.814457, 0.111684>, <0.124083, -0.848624, 0.037892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106245, -0.730319, 0.328379>, <0.115121, -0.734497, 0.312036>, <0.135498, -0.737981, 0.294642>, <0.152068, -0.739768, 0.285392>,
      <0.103037, -0.728809, 0.334287>, <0.111912, -0.732987, 0.317944>, <0.137800, -0.732852, 0.308691>, <0.154370, -0.734639, 0.299441>,
      <0.123267, -0.732557, 0.327540>, <0.136184, -0.736278, 0.328749>, <0.149673, -0.744293, 0.322463>, <0.166290, -0.748430, 0.319593>,
      <0.129159, -0.728985, 0.327574>, <0.142076, -0.732706, 0.328783>, <0.155599, -0.737251, 0.334473>, <0.172216, -0.741388, 0.331604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.106245, -0.730319, 0.328379>, <0.076937, -0.738859, 0.316804>, <0.072866, -0.794125, 0.359576>, <0.048747, -0.815773, 0.363518>,
      <0.082974, -0.746261, 0.252361>, <0.053666, -0.754801, 0.240786>, <0.060589, -0.813021, 0.292251>, <0.036470, -0.834669, 0.296193>,
      <0.082237, -0.828340, 0.168259>, <0.070702, -0.835945, 0.182495>, <0.055071, -0.871392, 0.201917>, <0.038657, -0.878515, 0.210485>,
      <0.074627, -0.873217, 0.101158>, <0.063092, -0.880822, 0.115394>, <0.053745, -0.898698, 0.136395>, <0.037331, -0.905821, 0.144963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.255638, -0.746429, 0.244978>, <0.292541, -0.743252, 0.242764>, <0.341761, -0.731724, 0.256432>, <0.373537, -0.720704, 0.272105>,
      <0.260336, -0.742506, 0.262712>, <0.297239, -0.739330, 0.260498>, <0.342209, -0.728119, 0.270230>, <0.373986, -0.717099, 0.285903>,
      <0.254355, -0.766266, 0.288257>, <0.295377, -0.762219, 0.285669>, <0.344896, -0.741703, 0.296831>, <0.382507, -0.727351, 0.306067>,
      <0.254203, -0.760116, 0.305981>, <0.295225, -0.756069, 0.303393>, <0.347837, -0.734705, 0.308912>, <0.385448, -0.720353, 0.318149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.255638, -0.746429, 0.244978>, <0.232020, -0.766150, 0.155823>, <0.160035, -0.821704, 0.051812>, <0.162220, -0.836921, -0.041242>,
      <0.292541, -0.743252, 0.242764>, <0.268923, -0.762973, 0.153609>, <0.222399, -0.807801, 0.057958>, <0.224584, -0.823019, -0.035096>,
      <0.341761, -0.731724, 0.256432>, <0.338804, -0.755492, 0.165467>, <0.322749, -0.817305, 0.049860>, <0.314664, -0.829753, -0.043027>,
      <0.373537, -0.720704, 0.272105>, <0.370580, -0.744472, 0.181140>, <0.382276, -0.798404, 0.064681>, <0.374191, -0.810852, -0.028206>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.255638, -0.746429, 0.244978>, <0.260336, -0.742506, 0.262712>, <0.254355, -0.766266, 0.288257>, <0.254203, -0.760116, 0.305981>,
      <0.222408, -0.749290, 0.246972>, <0.227106, -0.745367, 0.264706>, <0.228159, -0.768850, 0.289910>, <0.228007, -0.762700, 0.307634>,
      <0.181114, -0.742900, 0.269177>, <0.183416, -0.737771, 0.283225>, <0.198762, -0.756514, 0.313986>, <0.204688, -0.749472, 0.325997>,
      <0.152068, -0.739768, 0.285392>, <0.154370, -0.734639, 0.299441>, <0.166290, -0.748430, 0.319593>, <0.172216, -0.741388, 0.331604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.255638, -0.746429, 0.244978>, <0.222408, -0.749290, 0.246972>, <0.181114, -0.742900, 0.269177>, <0.152068, -0.739768, 0.285392>,
      <0.232020, -0.766150, 0.155823>, <0.198790, -0.769010, 0.157816>, <0.168707, -0.770542, 0.193467>, <0.139661, -0.767410, 0.209682>,
      <0.160035, -0.821704, 0.051812>, <0.158373, -0.818383, 0.078137>, <0.143815, -0.808817, 0.089554>, <0.130203, -0.814457, 0.111684>,
      <0.162220, -0.836921, -0.041242>, <0.160558, -0.833600, -0.014916>, <0.137695, -0.842984, 0.015762>, <0.124083, -0.848624, 0.037892>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206793, 0.846365, 0.281736>, <0.186197, 0.825675, 0.082513>, <0.104289, 0.703798, -0.157724>, <0.088974, 0.675114, -0.356431>,
      <0.145966, 0.859725, 0.291650>, <0.125370, 0.839035, 0.092427>, <0.077046, 0.711159, -0.161473>, <0.061730, 0.682474, -0.360180>,
      <0.063578, 0.876601, 0.308590>, <0.063578, 0.853531, 0.093460>, <0.028979, 0.721902, -0.173387>, <0.028979, 0.689301, -0.387280>,
      <0.000517, 0.876606, 0.308590>, <0.000517, 0.853537, 0.093461>, <0.000517, 0.721691, -0.173923>, <0.000517, 0.689090, -0.387815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206793, 0.846365, 0.281736>, <0.145966, 0.859725, 0.291650>, <0.063578, 0.876601, 0.308590>, <0.000517, 0.876606, 0.308590>,
      <0.222255, 0.861897, 0.431299>, <0.161428, 0.875257, 0.441213>, <0.063578, 0.893160, 0.463010>, <0.000517, 0.893165, 0.463011>,
      <0.206796, 0.850297, 0.642760>, <0.146482, 0.860899, 0.659551>, <0.064016, 0.879506, 0.680047>, <0.000517, 0.879506, 0.680047>,
      <0.206749, 0.793428, 0.782815>, <0.146435, 0.804031, 0.799606>, <0.064016, 0.818937, 0.823055>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.206497, 0.491323, 1.156127>, <0.209984, 0.616487, 1.084863>, <0.206704, 0.739226, 0.916302>, <0.206749, 0.793428, 0.782815>,
      <0.146451, 0.498883, 1.171431>, <0.149939, 0.624046, 1.100167>, <0.146390, 0.749829, 0.933093>, <0.146435, 0.804031, 0.799606>,
      <0.062941, 0.507086, 1.181063>, <0.062941, 0.632809, 1.114118>, <0.064016, 0.763388, 0.954212>, <0.064016, 0.818937, 0.823055>,
      <0.000517, 0.507086, 1.181063>, <0.000517, 0.632809, 1.114118>, <0.000517, 0.763388, 0.954212>, <0.000517, 0.818937, 0.823055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506145, -0.381058, -0.405403>, <0.488794, -0.299402, -0.471429>, <0.456120, -0.102117, -0.449555>, <0.444215, -0.061871, -0.547365>,
      <0.533894, -0.283622, -0.356958>, <0.516543, -0.201966, -0.422984>, <0.471866, -0.069956, -0.433527>, <0.459961, -0.029710, -0.531337>,
      <0.543187, -0.140442, -0.304538>, <0.524494, -0.095266, -0.374480>, <0.483746, 0.007587, -0.425804>, <0.473504, 0.016825, -0.510017>,
      <0.559317, -0.048324, -0.242370>, <0.540624, -0.003148, -0.312312>, <0.490857, 0.043645, -0.412078>, <0.480615, 0.052883, -0.496291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.506145, -0.381058, -0.405403>, <0.488818, -0.441896, -0.435652>, <0.443030, -0.515799, -0.473893>, <0.410452, -0.571031, -0.502258>,
      <0.488794, -0.299402, -0.471429>, <0.471467, -0.360240, -0.501678>, <0.429964, -0.421461, -0.539978>, <0.397386, -0.476693, -0.568343>,
      <0.456120, -0.102117, -0.449555>, <0.432977, -0.149384, -0.473112>, <0.391360, -0.225058, -0.502689>, <0.361719, -0.267920, -0.527366>,
      <0.444215, -0.061871, -0.547365>, <0.421072, -0.109138, -0.570922>, <0.381454, -0.167325, -0.602721>, <0.351813, -0.210187, -0.627398>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.535025, -0.489233, -0.201805>, <0.524747, -0.466178, -0.266780>, <0.517509, -0.434536, -0.362161>, <0.506145, -0.381058, -0.405403>,
      <0.562847, -0.408544, -0.169670>, <0.552570, -0.385488, -0.234645>, <0.545258, -0.337100, -0.313716>, <0.533894, -0.283622, -0.356958>,
      <0.577657, -0.297686, -0.118762>, <0.564424, -0.259469, -0.178579>, <0.559005, -0.178667, -0.245358>, <0.543187, -0.140442, -0.304538>,
      <0.593008, -0.218733, -0.075771>, <0.579776, -0.180516, -0.135588>, <0.575134, -0.086549, -0.183190>, <0.559317, -0.048324, -0.242370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583809, -0.555274, 0.085570>, <0.613348, -0.477012, 0.100152>, <0.629611, -0.363087, 0.106108>, <0.639508, -0.279927, 0.120129>,
      <0.590830, -0.560898, 0.148799>, <0.620370, -0.482636, 0.163381>, <0.635626, -0.370747, 0.140726>, <0.645523, -0.287587, 0.154746>,
      <0.585197, -0.546889, 0.234996>, <0.615524, -0.478650, 0.214281>, <0.635802, -0.365782, 0.205838>, <0.644931, -0.288861, 0.203562>,
      <0.590441, -0.533619, 0.297248>, <0.620768, -0.465380, 0.276532>, <0.638645, -0.365399, 0.241685>, <0.647773, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.583809, -0.555274, 0.085570>, <0.573952, -0.547379, -0.003198>, <0.548246, -0.518889, -0.118228>, <0.535025, -0.489233, -0.201805>,
      <0.613348, -0.477012, 0.100152>, <0.603491, -0.469117, 0.011383>, <0.576068, -0.438200, -0.086094>, <0.562847, -0.408544, -0.169670>,
      <0.629611, -0.363087, 0.106108>, <0.619052, -0.349639, 0.045337>, <0.589226, -0.331101, -0.066463>, <0.577657, -0.297686, -0.118762>,
      <0.639508, -0.279927, 0.120129>, <0.628949, -0.266479, 0.059357>, <0.604577, -0.252147, -0.023472>, <0.593008, -0.218733, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.610854, -0.486838, 0.406621>, <0.606115, -0.507368, 0.377174>, <0.593414, -0.526096, 0.332542>, <0.590441, -0.533619, 0.297248>,
      <0.634795, -0.430033, 0.380076>, <0.630057, -0.450563, 0.350629>, <0.623741, -0.457857, 0.311826>, <0.620768, -0.465380, 0.276532>,
      <0.650568, -0.344200, 0.346876>, <0.647811, -0.356457, 0.318272>, <0.641114, -0.365065, 0.272826>, <0.638645, -0.365399, 0.241685>,
      <0.657144, -0.277547, 0.342545>, <0.654387, -0.289804, 0.313942>, <0.650242, -0.288144, 0.270550>, <0.647773, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.639358, -0.321685, 0.601232>, <0.653910, -0.287977, 0.556271>, <0.665714, -0.249395, 0.477431>, <0.668869, -0.194697, 0.458256>,
      <0.647014, -0.251004, 0.650095>, <0.661566, -0.217296, 0.605134>, <0.667694, -0.190714, 0.515747>, <0.670848, -0.136016, 0.496572>,
      <0.651928, -0.140432, 0.704658>, <0.662524, -0.124577, 0.652888>, <0.664995, -0.068391, 0.577792>, <0.667884, -0.044775, 0.528015>,
      <0.657695, -0.054363, 0.705599>, <0.668291, -0.038507, 0.653829>, <0.664437, 0.000741, 0.589454>, <0.667327, 0.024357, 0.539677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.639358, -0.321685, 0.601232>, <0.632521, -0.384813, 0.557590>, <0.620937, -0.443152, 0.469282>, <0.610854, -0.486838, 0.406621>,
      <0.653910, -0.287977, 0.556271>, <0.647073, -0.351106, 0.512629>, <0.644879, -0.386347, 0.442737>, <0.634795, -0.430033, 0.380076>,
      <0.665714, -0.249395, 0.477431>, <0.664505, -0.285250, 0.454019>, <0.654349, -0.327392, 0.386098>, <0.650568, -0.344200, 0.346876>,
      <0.668869, -0.194697, 0.458256>, <0.667660, -0.230552, 0.434844>, <0.660925, -0.260740, 0.381767>, <0.657144, -0.277547, 0.342545>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594905, 0.270397, 0.013847>, <0.612298, 0.269414, 0.079275>, <0.643834, 0.281091, 0.165285>, <0.652785, 0.273520, 0.231970>,
      <0.598918, 0.221010, -0.012255>, <0.616311, 0.220027, 0.053174>, <0.650695, 0.230638, 0.123397>, <0.659646, 0.223067, 0.190082>,
      <0.596433, 0.150343, -0.041164>, <0.612043, 0.142223, 0.015563>, <0.639490, 0.147695, 0.090269>, <0.654176, 0.144445, 0.147726>,
      <0.591578, 0.106858, -0.076121>, <0.607188, 0.098738, -0.019394>, <0.632736, 0.092082, 0.055502>, <0.647423, 0.088832, 0.112958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.594905, 0.270397, 0.013847>, <0.598918, 0.221010, -0.012255>, <0.596433, 0.150343, -0.041164>, <0.591578, 0.106858, -0.076121>,
      <0.559633, 0.272390, -0.118839>, <0.563645, 0.223003, -0.144941>, <0.564811, 0.166792, -0.156081>, <0.559956, 0.123307, -0.191038>,
      <0.494665, 0.283369, -0.292079>, <0.504712, 0.250755, -0.300942>, <0.504440, 0.198190, -0.329635>, <0.504931, 0.164376, -0.339610>,
      <0.477269, 0.283437, -0.428282>, <0.487316, 0.250823, -0.437144>, <0.489588, 0.204491, -0.448866>, <0.490079, 0.170677, -0.458841>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.660785, 0.091543, 0.194622>, <0.654402, -0.019898, 0.172274>, <0.652776, -0.168437, 0.138926>, <0.639508, -0.279927, 0.120129>,
      <0.658127, 0.090329, 0.169956>, <0.651744, -0.021112, 0.147608>, <0.642216, -0.154990, 0.078154>, <0.628949, -0.266479, 0.059357>,
      <0.653565, 0.087473, 0.136987>, <0.642351, -0.004871, 0.079256>, <0.623006, -0.157369, 0.028136>, <0.604577, -0.252147, -0.023472>,
      <0.647423, 0.088832, 0.112958>, <0.636209, -0.003511, 0.055228>, <0.611437, -0.123955, -0.024163>, <0.593008, -0.218733, -0.075771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.665274, 0.096985, 0.278592>, <0.660024, -0.018654, 0.266837>, <0.661478, -0.172985, 0.235992>, <0.647773, -0.288477, 0.239409>,
      <0.663874, 0.093239, 0.253631>, <0.658623, -0.022399, 0.241876>, <0.658636, -0.173368, 0.200145>, <0.644931, -0.288861, 0.203562>,
      <0.663491, 0.092779, 0.219726>, <0.657107, -0.018662, 0.197378>, <0.658791, -0.176098, 0.173543>, <0.645523, -0.287587, 0.154746>,
      <0.660785, 0.091543, 0.194622>, <0.654402, -0.019898, 0.172274>, <0.652776, -0.168437, 0.138926>, <0.639508, -0.279927, 0.120129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.670476, 0.117465, 0.367358>, <0.670538, 0.122722, 0.389522>, <0.666374, 0.129259, 0.419065>, <0.665725, 0.135499, 0.440963>,
      <0.666477, -0.001039, 0.359914>, <0.666538, 0.004219, 0.382078>, <0.667317, 0.030200, 0.424253>, <0.666668, 0.036440, 0.446151>,
      <0.668785, -0.159563, 0.334879>, <0.672566, -0.142756, 0.374101>, <0.673051, -0.137077, 0.402076>, <0.674260, -0.101222, 0.425488>,
      <0.657144, -0.277547, 0.342545>, <0.660925, -0.260740, 0.381767>, <0.667660, -0.230552, 0.434844>, <0.668869, -0.194697, 0.458256>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.670476, 0.117465, 0.367358>, <0.666477, -0.001039, 0.359914>, <0.668785, -0.159563, 0.334879>, <0.657144, -0.277547, 0.342545>,
      <0.670402, 0.111147, 0.340723>, <0.666403, -0.007356, 0.333279>, <0.666027, -0.171820, 0.306276>, <0.654387, -0.289804, 0.313942>,
      <0.666790, 0.101041, 0.305621>, <0.661540, -0.014597, 0.293866>, <0.663948, -0.172651, 0.267134>, <0.650242, -0.288144, 0.270550>,
      <0.665274, 0.096985, 0.278592>, <0.660024, -0.018654, 0.266837>, <0.661478, -0.172985, 0.235992>, <0.647773, -0.288477, 0.239409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.421777, -0.715328, -0.273542>, <0.413851, -0.690979, -0.350599>, <0.419605, -0.637113, -0.455967>, <0.410452, -0.571031, -0.502258>,
      <0.465157, -0.652075, -0.255228>, <0.457231, -0.627726, -0.332285>, <0.452183, -0.581881, -0.427602>, <0.443030, -0.515799, -0.473893>,
      <0.510969, -0.559000, -0.229590>, <0.500691, -0.535944, -0.294565>, <0.500182, -0.495375, -0.392410>, <0.488818, -0.441896, -0.435652>,
      <0.535025, -0.489233, -0.201805>, <0.524747, -0.466178, -0.266780>, <0.517509, -0.434536, -0.362161>, <0.506145, -0.381058, -0.405403>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.421777, -0.715328, -0.273542>, <0.400724, -0.746026, -0.282430>, <0.355282, -0.773453, -0.293198>, <0.324554, -0.796124, -0.290661>,
      <0.413851, -0.690979, -0.350599>, <0.392798, -0.721677, -0.359487>, <0.349912, -0.749304, -0.377279>, <0.319184, -0.771974, -0.374742>,
      <0.419605, -0.637113, -0.455967>, <0.402434, -0.666224, -0.470917>, <0.368105, -0.703397, -0.482012>, <0.346569, -0.730209, -0.495544>,
      <0.410452, -0.571031, -0.502258>, <0.393281, -0.600142, -0.517208>, <0.362446, -0.634381, -0.535738>, <0.340910, -0.661193, -0.549270>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.740579, 0.034301>, <0.474499, -0.733373, 0.132273>, <0.469898, -0.691537, 0.259305>, <0.478617, -0.669100, 0.354958>,
      <0.442041, -0.769351, 0.021493>, <0.450902, -0.762145, 0.119464>, <0.437442, -0.719531, 0.255543>, <0.446161, -0.697094, 0.351196>,
      <0.410686, -0.799264, -0.019120>, <0.418771, -0.786816, 0.073767>, <0.407427, -0.731694, 0.199314>, <0.410384, -0.707926, 0.290279>,
      <0.374191, -0.810852, -0.028206>, <0.382276, -0.798404, 0.064681>, <0.370580, -0.744472, 0.181140>, <0.373537, -0.720704, 0.272105>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.740579, 0.034301>, <0.442041, -0.769351, 0.021493>, <0.410686, -0.799264, -0.019120>, <0.374191, -0.810852, -0.028206>,
      <0.457232, -0.747417, -0.058662>, <0.433634, -0.776189, -0.071471>, <0.403788, -0.809885, -0.098368>, <0.367293, -0.821473, -0.107454>,
      <0.430912, -0.743393, -0.184725>, <0.409859, -0.774091, -0.193613>, <0.360200, -0.795566, -0.216207>, <0.329471, -0.818237, -0.213671>,
      <0.421777, -0.715328, -0.273542>, <0.400724, -0.746026, -0.282430>, <0.355282, -0.773453, -0.293198>, <0.324554, -0.796124, -0.290661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.740579, 0.034301>, <0.457232, -0.747417, -0.058662>, <0.430912, -0.743393, -0.184725>, <0.421777, -0.715328, -0.273542>,
      <0.506236, -0.691081, 0.056336>, <0.497829, -0.697919, -0.036627>, <0.474292, -0.680141, -0.166411>, <0.465157, -0.652075, -0.255228>,
      <0.560256, -0.617675, 0.073944>, <0.550399, -0.609780, -0.014825>, <0.524189, -0.588656, -0.146013>, <0.510969, -0.559000, -0.229590>,
      <0.583809, -0.555274, 0.085570>, <0.573952, -0.547379, -0.003198>, <0.548246, -0.518889, -0.118228>, <0.535025, -0.489233, -0.201805>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.465639, -0.740579, 0.034301>, <0.506236, -0.691081, 0.056336>, <0.560256, -0.617675, 0.073944>, <0.583809, -0.555274, 0.085570>,
      <0.474499, -0.733373, 0.132273>, <0.515096, -0.683875, 0.154308>, <0.567278, -0.623298, 0.137173>, <0.590830, -0.560898, 0.148799>,
      <0.469898, -0.691537, 0.259305>, <0.511743, -0.655445, 0.264156>, <0.563489, -0.595735, 0.249825>, <0.585197, -0.546889, 0.234996>,
      <0.478617, -0.669100, 0.354958>, <0.520462, -0.633008, 0.359808>, <0.568733, -0.582465, 0.312077>, <0.590441, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.508734, -0.629678, 0.507096>, <0.500422, -0.652212, 0.465530>, <0.482861, -0.658180, 0.401513>, <0.478617, -0.669100, 0.354958>,
      <0.549244, -0.589488, 0.486429>, <0.540932, -0.612022, 0.444863>, <0.524705, -0.622088, 0.406364>, <0.520462, -0.633008, 0.359808>,
      <0.589205, -0.538205, 0.430625>, <0.584466, -0.558735, 0.401178>, <0.571706, -0.574942, 0.347371>, <0.568733, -0.582465, 0.312077>,
      <0.610854, -0.486838, 0.406621>, <0.606115, -0.507368, 0.377174>, <0.593414, -0.526096, 0.332542>, <0.590441, -0.533619, 0.297248>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.564041, -0.437511, 0.782138>, <0.552450, -0.516720, 0.718903>, <0.526397, -0.581792, 0.595425>, <0.508734, -0.629678, 0.507096>,
      <0.595828, -0.408179, 0.729293>, <0.584237, -0.487389, 0.666058>, <0.566907, -0.541601, 0.574759>, <0.549244, -0.589488, 0.486429>,
      <0.622238, -0.361340, 0.654126>, <0.615401, -0.424468, 0.610484>, <0.599288, -0.494519, 0.493285>, <0.589205, -0.538205, 0.430625>,
      <0.639358, -0.321685, 0.601232>, <0.632521, -0.384813, 0.557590>, <0.620937, -0.443152, 0.469282>, <0.610854, -0.486838, 0.406621>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586813, -0.096123, 0.933049>, <0.582777, -0.207972, 0.925373>, <0.576788, -0.350406, 0.851677>, <0.564041, -0.437511, 0.782138>,
      <0.616154, -0.091814, 0.866825>, <0.612118, -0.203663, 0.859149>, <0.608575, -0.321074, 0.798832>, <0.595828, -0.408179, 0.729293>,
      <0.643759, -0.075217, 0.773688>, <0.637992, -0.161286, 0.772747>, <0.629894, -0.290658, 0.702990>, <0.622238, -0.361340, 0.654126>,
      <0.657695, -0.054363, 0.705599>, <0.651928, -0.140432, 0.704658>, <0.647014, -0.251004, 0.650095>, <0.639358, -0.321685, 0.601232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.586813, -0.096123, 0.933049>, <0.616154, -0.091814, 0.866825>, <0.643759, -0.075217, 0.773688>, <0.657695, -0.054363, 0.705599>,
      <0.591545, 0.034990, 0.942047>, <0.620886, 0.039299, 0.875823>, <0.649298, 0.007448, 0.774591>, <0.663234, 0.028302, 0.706503>,
      <0.591881, 0.223471, 0.910493>, <0.625588, 0.187579, 0.844602>, <0.658604, 0.194108, 0.746012>, <0.675225, 0.155900, 0.675090>,
      <0.591777, 0.331069, 0.834885>, <0.625485, 0.295177, 0.768994>, <0.657897, 0.241267, 0.677891>, <0.674519, 0.203059, 0.606969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.556742, 0.535632, 0.150492>, <0.577695, 0.544949, 0.249125>, <0.581241, 0.567998, 0.389825>, <0.586202, 0.539033, 0.486731>,
      <0.584031, 0.456738, 0.116229>, <0.604985, 0.466055, 0.214861>, <0.616228, 0.491106, 0.316011>, <0.621188, 0.462141, 0.412916>,
      <0.588440, 0.349973, 0.055904>, <0.605833, 0.348991, 0.121333>, <0.632160, 0.366935, 0.236556>, <0.641111, 0.359364, 0.303241>,
      <0.594905, 0.270397, 0.013847>, <0.612298, 0.269414, 0.079275>, <0.643834, 0.281091, 0.165285>, <0.652785, 0.273520, 0.231970>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.556742, 0.535632, 0.150492>, <0.584031, 0.456738, 0.116229>, <0.588440, 0.349973, 0.055904>, <0.594905, 0.270397, 0.013847>,
      <0.522031, 0.520198, -0.012900>, <0.549320, 0.441303, -0.047164>, <0.553168, 0.351966, -0.076782>, <0.559633, 0.272390, -0.118839>,
      <0.424676, 0.469750, -0.215315>, <0.456032, 0.421651, -0.226686>, <0.477987, 0.337511, -0.277367>, <0.494665, 0.283369, -0.292079>,
      <0.401858, 0.457063, -0.381021>, <0.433214, 0.408965, -0.392392>, <0.460591, 0.337579, -0.413570>, <0.477269, 0.283437, -0.428282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.733210, -0.584111>, <0.299571, -0.712853, -0.573264>, <0.323351, -0.683053, -0.560303>, <0.340910, -0.661193, -0.549270>,
      <0.286619, -0.807708, -0.515857>, <0.306007, -0.787352, -0.505010>, <0.329010, -0.752069, -0.506577>, <0.346569, -0.730209, -0.495544>,
      <0.288646, -0.810562, -0.358060>, <0.308809, -0.802537, -0.358543>, <0.301755, -0.784833, -0.373304>, <0.319184, -0.771974, -0.374742>,
      <0.267513, -0.829141, -0.260806>, <0.287676, -0.821117, -0.261290>, <0.307126, -0.808982, -0.289222>, <0.324554, -0.796124, -0.290661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.733210, -0.584111>, <0.272224, -0.641082, -0.668518>, <0.234366, -0.410475, -0.607372>, <0.225173, -0.339069, -0.709803>,
      <0.299571, -0.712853, -0.573264>, <0.291611, -0.620725, -0.657671>, <0.253229, -0.398485, -0.599708>, <0.244036, -0.327079, -0.702138>,
      <0.323351, -0.683053, -0.560303>, <0.315718, -0.589969, -0.632766>, <0.277719, -0.372135, -0.591087>, <0.268344, -0.309729, -0.691044>,
      <0.340910, -0.661193, -0.549270>, <0.333277, -0.568109, -0.621732>, <0.292787, -0.356800, -0.581283>, <0.283412, -0.294394, -0.681239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.733210, -0.584111>, <0.286619, -0.807708, -0.515857>, <0.288646, -0.810562, -0.358060>, <0.267513, -0.829141, -0.260806>,
      <0.264819, -0.749342, -0.592707>, <0.271255, -0.823840, -0.524452>, <0.272540, -0.814582, -0.383444>, <0.251408, -0.833162, -0.286191>,
      <0.242067, -0.768035, -0.605070>, <0.249211, -0.831688, -0.552895>, <0.232311, -0.819808, -0.402840>, <0.231860, -0.836204, -0.321871>,
      <0.225319, -0.782561, -0.613940>, <0.232463, -0.846214, -0.561766>, <0.214279, -0.826146, -0.426389>, <0.213828, -0.842543, -0.345421>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.280183, -0.733210, -0.584111>, <0.264819, -0.749342, -0.592707>, <0.242067, -0.768035, -0.605070>, <0.225319, -0.782561, -0.613940>,
      <0.272224, -0.641082, -0.668518>, <0.256860, -0.657214, -0.677113>, <0.230872, -0.668282, -0.686834>, <0.214124, -0.682808, -0.695705>,
      <0.234366, -0.410475, -0.607372>, <0.216353, -0.421925, -0.614691>, <0.190609, -0.442016, -0.622934>, <0.170207, -0.450188, -0.628045>,
      <0.225173, -0.339069, -0.709803>, <0.207160, -0.350519, -0.717122>, <0.181442, -0.364007, -0.725852>, <0.161040, -0.372179, -0.730963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.288047, -0.746043, 0.458025>, <0.221946, -0.756910, 0.453307>, <0.166530, -0.712753, 0.352187>, <0.106245, -0.730319, 0.328379>,
      <0.280478, -0.746709, 0.438435>, <0.214377, -0.757576, 0.433717>, <0.163321, -0.711243, 0.358095>, <0.103037, -0.728809, 0.334287>,
      <0.284468, -0.776610, 0.404586>, <0.221330, -0.785283, 0.399310>, <0.168170, -0.742490, 0.346410>, <0.123267, -0.732557, 0.327540>,
      <0.278835, -0.762097, 0.390475>, <0.215697, -0.770769, 0.385199>, <0.174062, -0.738919, 0.346444>, <0.129159, -0.728985, 0.327574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.288047, -0.746043, 0.458025>, <0.280478, -0.746709, 0.438435>, <0.284468, -0.776610, 0.404586>, <0.278835, -0.762097, 0.390475>,
      <0.355939, -0.734881, 0.462871>, <0.348370, -0.735547, 0.443281>, <0.358031, -0.766506, 0.410734>, <0.352398, -0.751993, 0.396622>,
      <0.421446, -0.692183, 0.385878>, <0.413456, -0.696846, 0.385756>, <0.408579, -0.704418, 0.366163>, <0.400040, -0.707880, 0.365329>,
      <0.478617, -0.669100, 0.354958>, <0.470627, -0.673763, 0.354836>, <0.460524, -0.681183, 0.355386>, <0.451985, -0.684644, 0.354552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.338714, -0.756832, 0.545457>, <0.331659, -0.768702, 0.518276>, <0.299029, -0.745077, 0.486450>, <0.288047, -0.746043, 0.458025>,
      <0.396260, -0.727696, 0.540093>, <0.389205, -0.739567, 0.512911>, <0.366921, -0.733916, 0.491296>, <0.355939, -0.734881, 0.462871>,
      <0.465532, -0.672539, 0.529136>, <0.457220, -0.695073, 0.487570>, <0.425690, -0.681263, 0.432433>, <0.421446, -0.692183, 0.385878>,
      <0.508734, -0.629678, 0.507096>, <0.500422, -0.652212, 0.465530>, <0.482861, -0.658180, 0.401513>, <0.478617, -0.669100, 0.354958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.419912, -0.524179, 0.966055>, <0.399754, -0.632590, 0.869998>, <0.372555, -0.699893, 0.675837>, <0.338714, -0.756832, 0.545457>,
      <0.472951, -0.501691, 0.918400>, <0.452793, -0.610102, 0.822343>, <0.430101, -0.670758, 0.670472>, <0.396260, -0.727696, 0.540093>,
      <0.529239, -0.469625, 0.839995>, <0.517648, -0.548834, 0.776760>, <0.483196, -0.624653, 0.617465>, <0.465532, -0.672539, 0.529136>,
      <0.564041, -0.437511, 0.782138>, <0.552450, -0.516720, 0.718903>, <0.526397, -0.581792, 0.595425>, <0.508734, -0.629678, 0.507096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.464043, -0.082802, 1.142677>, <0.456735, -0.225696, 1.136043>, <0.439656, -0.417996, 1.060138>, <0.419912, -0.524179, 0.966055>,
      <0.512456, -0.088162, 1.088318>, <0.505148, -0.231056, 1.081684>, <0.492695, -0.395508, 1.012482>, <0.472951, -0.501691, 0.918400>,
      <0.557299, -0.100457, 0.999664>, <0.553262, -0.212307, 0.991988>, <0.541986, -0.382519, 0.909534>, <0.529239, -0.469625, 0.839995>,
      <0.586813, -0.096123, 0.933049>, <0.582777, -0.207972, 0.925373>, <0.576788, -0.350406, 0.851677>, <0.564041, -0.437511, 0.782138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468335, 0.422607, 1.010012>, <0.469685, 0.289872, 1.093407>, <0.472042, 0.073590, 1.149938>, <0.464043, -0.082802, 1.142677>,
      <0.512652, 0.397911, 0.961929>, <0.514002, 0.265177, 1.045324>, <0.520454, 0.068230, 1.095579>, <0.512456, -0.088162, 1.088318>,
      <0.563133, 0.361569, 0.890877>, <0.563237, 0.253971, 0.966485>, <0.562030, 0.030655, 1.008662>, <0.557299, -0.100457, 0.999664>,
      <0.591777, 0.331069, 0.834885>, <0.591881, 0.223471, 0.910493>, <0.591545, 0.034990, 0.942047>, <0.586813, -0.096123, 0.933049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.468335, 0.422607, 1.010012>, <0.512652, 0.397911, 0.961929>, <0.563133, 0.361569, 0.890877>, <0.591777, 0.331069, 0.834885>,
      <0.467145, 0.539603, 0.936505>, <0.511462, 0.514908, 0.888422>, <0.563038, 0.461121, 0.820923>, <0.591681, 0.430621, 0.764931>,
      <0.461897, 0.654406, 0.775171>, <0.510193, 0.611772, 0.728290>, <0.567315, 0.558841, 0.655592>, <0.592163, 0.504231, 0.603168>,
      <0.456021, 0.705964, 0.647108>, <0.504317, 0.663330, 0.600227>, <0.561354, 0.593643, 0.539156>, <0.586202, 0.539033, 0.486731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.432014, 0.741324, 0.218367>, <0.453188, 0.757827, 0.344808>, <0.450525, 0.754195, 0.527310>, <0.456021, 0.705964, 0.647108>,
      <0.478877, 0.686791, 0.197093>, <0.500051, 0.703293, 0.323534>, <0.498821, 0.711561, 0.480428>, <0.504317, 0.663330, 0.600227>,
      <0.534066, 0.601190, 0.178963>, <0.555019, 0.610507, 0.277596>, <0.556393, 0.622608, 0.442250>, <0.561354, 0.593643, 0.539156>,
      <0.556742, 0.535632, 0.150492>, <0.577695, 0.544949, 0.249125>, <0.581241, 0.567998, 0.389825>, <0.586202, 0.539033, 0.486731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.432014, 0.741324, 0.218367>, <0.478877, 0.686791, 0.197093>, <0.534066, 0.601190, 0.178963>, <0.556742, 0.535632, 0.150492>,
      <0.401618, 0.717634, 0.036857>, <0.448480, 0.663101, 0.015583>, <0.499355, 0.585755, 0.015571>, <0.522031, 0.520198, -0.012900>,
      <0.308897, 0.600313, -0.176940>, <0.344751, 0.566309, -0.181535>, <0.398090, 0.510531, -0.205674>, <0.424676, 0.469750, -0.215315>,
      <0.287459, 0.574592, -0.359450>, <0.323313, 0.540588, -0.364045>, <0.375272, 0.497844, -0.371380>, <0.401858, 0.457063, -0.381021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.855945, -0.658526>, <0.101286, -0.733635, -0.729578>, <0.073833, -0.488366, -0.639721>, <0.065445, -0.393917, -0.744775>,
      <0.127452, -0.849051, -0.654473>, <0.123090, -0.726741, -0.725525>, <0.086522, -0.486591, -0.638558>, <0.078133, -0.392142, -0.743611>,
      <0.155377, -0.836662, -0.647250>, <0.146346, -0.722942, -0.722104>, <0.105834, -0.476238, -0.636698>, <0.094869, -0.389114, -0.741130>,
      <0.174246, -0.825091, -0.640220>, <0.165215, -0.711371, -0.715074>, <0.118256, -0.473413, -0.634903>, <0.107291, -0.386289, -0.739335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.855945, -0.658526>, <0.127452, -0.849051, -0.654473>, <0.155377, -0.836662, -0.647250>, <0.174246, -0.825091, -0.640220>,
      <0.107583, -0.910213, -0.627001>, <0.129387, -0.903319, -0.622947>, <0.159889, -0.893478, -0.609852>, <0.178758, -0.881907, -0.602822>,
      <0.088225, -0.878790, -0.514622>, <0.108946, -0.873097, -0.508121>, <0.135718, -0.863084, -0.499520>, <0.152223, -0.856522, -0.485789>,
      <0.083294, -0.894439, -0.454013>, <0.104015, -0.888746, -0.447513>, <0.129351, -0.878468, -0.433416>, <0.145856, -0.871906, -0.419685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.855945, -0.658526>, <0.107583, -0.910213, -0.627001>, <0.088225, -0.878790, -0.514622>, <0.083294, -0.894439, -0.454013>,
      <0.075017, -0.865630, -0.664220>, <0.076952, -0.919898, -0.632695>, <0.064598, -0.885282, -0.522034>, <0.059666, -0.900931, -0.461425>,
      <0.033144, -0.880022, -0.672515>, <0.033144, -0.934998, -0.641954>, <0.025501, -0.897402, -0.526497>, <0.026117, -0.911839, -0.465280>,
      <0.000517, -0.880022, -0.672515>, <0.000517, -0.934998, -0.641954>, <-0.000099, -0.897402, -0.526497>, <0.000517, -0.911839, -0.465280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.105648, -0.855945, -0.658526>, <0.075017, -0.865630, -0.664220>, <0.033144, -0.880022, -0.672515>, <0.000517, -0.880022, -0.672515>,
      <0.101286, -0.733635, -0.729578>, <0.070655, -0.743320, -0.735272>, <0.033144, -0.752880, -0.743193>, <0.000517, -0.752880, -0.743193>,
      <0.073833, -0.488366, -0.639721>, <0.054458, -0.491076, -0.641499>, <0.020162, -0.501667, -0.643868>, <0.000517, -0.501624, -0.643866>,
      <0.065445, -0.393917, -0.744775>, <0.046069, -0.396627, -0.746552>, <0.020162, -0.401267, -0.749132>, <0.000517, -0.401224, -0.749129>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324967, 0.805346, 0.255711>, <0.291306, 0.821045, 0.265182>, <0.243766, 0.838244, 0.275710>, <0.206793, 0.846365, 0.281736>,
      <0.340055, 0.822223, 0.396786>, <0.306394, 0.837922, 0.406257>, <0.259228, 0.853777, 0.425273>, <0.222255, 0.861897, 0.431299>,
      <0.330956, 0.814260, 0.597612>, <0.294794, 0.826948, 0.617299>, <0.247719, 0.843103, 0.631368>, <0.206796, 0.850297, 0.642760>,
      <0.335912, 0.759978, 0.729686>, <0.299750, 0.772666, 0.749373>, <0.247672, 0.786234, 0.771423>, <0.206749, 0.793428, 0.782815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324967, 0.805346, 0.255711>, <0.304482, 0.782433, 0.064177>, <0.235698, 0.657888, -0.166385>, <0.219617, 0.629897, -0.357664>,
      <0.291306, 0.821045, 0.265182>, <0.270821, 0.798132, 0.073648>, <0.196506, 0.671454, -0.166015>, <0.180424, 0.643462, -0.357294>,
      <0.243766, 0.838244, 0.275710>, <0.223170, 0.817555, 0.076488>, <0.143981, 0.693075, -0.152262>, <0.128665, 0.664391, -0.350969>,
      <0.206793, 0.846365, 0.281736>, <0.186197, 0.825675, 0.082513>, <0.104289, 0.703798, -0.157724>, <0.088974, 0.675114, -0.356431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324967, 0.805346, 0.255711>, <0.340055, 0.822223, 0.396786>, <0.330956, 0.814260, 0.597612>, <0.335912, 0.759978, 0.729686>,
      <0.359269, 0.789348, 0.246060>, <0.374357, 0.806225, 0.387135>, <0.370096, 0.800527, 0.576303>, <0.375053, 0.746244, 0.708377>,
      <0.407602, 0.769732, 0.229449>, <0.428777, 0.786234, 0.355891>, <0.422257, 0.779149, 0.554749>, <0.427753, 0.730918, 0.674547>,
      <0.432014, 0.741324, 0.218367>, <0.453188, 0.757827, 0.344808>, <0.450525, 0.754195, 0.527310>, <0.456021, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324967, 0.805346, 0.255711>, <0.359269, 0.789348, 0.246060>, <0.407602, 0.769732, 0.229449>, <0.432014, 0.741324, 0.218367>,
      <0.304482, 0.782433, 0.064177>, <0.338784, 0.766435, 0.054526>, <0.377206, 0.746042, 0.047939>, <0.401618, 0.717634, 0.036857>,
      <0.235698, 0.657888, -0.166385>, <0.256051, 0.641297, -0.166921>, <0.289922, 0.618308, -0.174508>, <0.308897, 0.600313, -0.176940>,
      <0.219617, 0.629897, -0.357664>, <0.239970, 0.613305, -0.358200>, <0.268484, 0.592587, -0.357018>, <0.287459, 0.574592, -0.359450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356288, 0.462296, 1.090388>, <0.357892, 0.582634, 1.018011>, <0.340783, 0.706624, 0.859501>, <0.335912, 0.759978, 0.729686>,
      <0.313865, 0.473430, 1.114062>, <0.315469, 0.593767, 1.041684>, <0.304622, 0.719313, 0.879188>, <0.299750, 0.772666, 0.749373>,
      <0.254439, 0.485287, 1.143908>, <0.257926, 0.610451, 1.072644>, <0.247627, 0.732032, 0.904910>, <0.247672, 0.786234, 0.771423>,
      <0.206497, 0.491323, 1.156127>, <0.209984, 0.616487, 1.084863>, <0.206704, 0.739226, 0.916302>, <0.206749, 0.793428, 0.782815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.356288, 0.462296, 1.090388>, <0.392929, 0.452680, 1.069941>, <0.441042, 0.437816, 1.039625>, <0.468335, 0.422607, 1.010012>,
      <0.357892, 0.582634, 1.018011>, <0.394533, 0.573018, 0.997564>, <0.439852, 0.554812, 0.966118>, <0.467145, 0.539603, 0.936505>,
      <0.340783, 0.706624, 0.859501>, <0.379924, 0.692891, 0.838192>, <0.433629, 0.679359, 0.802610>, <0.461897, 0.654406, 0.775171>,
      <0.335912, 0.759978, 0.729686>, <0.375053, 0.746244, 0.708377>, <0.427753, 0.730918, 0.674547>, <0.456021, 0.705964, 0.647108>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.324885, -0.067123, 1.227148>, <0.369366, -0.069652, 1.206600>, <0.431500, -0.079199, 1.179217>, <0.464043, -0.082802, 1.142677>,
      <0.334599, 0.096536, 1.238055>, <0.379080, 0.094007, 1.217508>, <0.439499, 0.077193, 1.186478>, <0.472042, 0.073590, 1.149938>,
      <0.354411, 0.321501, 1.175069>, <0.391052, 0.311885, 1.154622>, <0.442392, 0.305081, 1.123020>, <0.469685, 0.289872, 1.093407>,
      <0.356288, 0.462296, 1.090388>, <0.392929, 0.452680, 1.069941>, <0.441042, 0.437816, 1.039625>, <0.468335, 0.422607, 1.010012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.296137, -0.551099, 1.022849>, <0.334312, -0.542719, 1.008468>, <0.390369, -0.536705, 0.992600>, <0.419912, -0.524179, 0.966055>,
      <0.314629, -0.438457, 1.131852>, <0.352804, -0.430077, 1.117470>, <0.410112, -0.430522, 1.086682>, <0.439656, -0.417996, 1.060138>,
      <0.315554, -0.224333, 1.216671>, <0.360034, -0.226862, 1.196123>, <0.424192, -0.222093, 1.172582>, <0.456735, -0.225696, 1.136043>,
      <0.324885, -0.067123, 1.227148>, <0.369366, -0.069652, 1.206600>, <0.431500, -0.079199, 1.179217>, <0.464043, -0.082802, 1.142677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.207492, -0.782198, 0.535177>, <0.189369, -0.799302, 0.468899>, <0.126567, -0.716397, 0.394763>, <0.106245, -0.730319, 0.328379>,
      <0.246201, -0.774149, 0.542523>, <0.228079, -0.791253, 0.476245>, <0.186852, -0.698831, 0.418572>, <0.166530, -0.712753, 0.352187>,
      <0.302960, -0.774934, 0.548790>, <0.295905, -0.786805, 0.521609>, <0.232929, -0.755945, 0.481732>, <0.221946, -0.756910, 0.453307>,
      <0.338714, -0.756832, 0.545457>, <0.331659, -0.768702, 0.518276>, <0.299029, -0.745077, 0.486450>, <0.288047, -0.746043, 0.458025>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.207492, -0.782198, 0.535177>, <0.246201, -0.774149, 0.542523>, <0.302960, -0.774934, 0.548790>, <0.338714, -0.756832, 0.545457>,
      <0.249484, -0.742566, 0.688748>, <0.288193, -0.734517, 0.696094>, <0.336802, -0.717996, 0.679169>, <0.372555, -0.699893, 0.675837>,
      <0.276915, -0.668189, 0.909542>, <0.315089, -0.659809, 0.895161>, <0.370211, -0.645116, 0.896543>, <0.399754, -0.632590, 0.869998>,
      <0.296137, -0.551099, 1.022849>, <0.334312, -0.542719, 1.008468>, <0.390369, -0.536705, 0.992600>, <0.419912, -0.524179, 0.966055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.885413, -0.114403>, <0.098688, -0.883233, -0.157072>, <0.133966, -0.900745, -0.205907>, <0.142607, -0.904982, -0.248385>,
      <0.069342, -0.894157, -0.101869>, <0.077804, -0.891977, -0.144538>, <0.108787, -0.914097, -0.198506>, <0.117427, -0.918334, -0.240984>,
      <0.062587, -0.899774, -0.052646>, <0.062840, -0.895543, -0.108157>, <0.077055, -0.920601, -0.178352>, <0.079558, -0.928670, -0.233380>,
      <0.037896, -0.906729, -0.049223>, <0.038149, -0.902498, -0.104734>, <0.049057, -0.929563, -0.176668>, <0.051559, -0.937631, -0.231696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.885413, -0.114403>, <0.069342, -0.894157, -0.101869>, <0.062587, -0.899774, -0.052646>, <0.037896, -0.906729, -0.049223>,
      <0.087522, -0.886110, -0.100766>, <0.066637, -0.894854, -0.088233>, <0.062523, -0.900842, -0.038631>, <0.037832, -0.907797, -0.035208>,
      <0.107683, -0.903589, -0.092643>, <0.090145, -0.918461, -0.086641>, <0.064442, -0.926925, -0.067598>, <0.049485, -0.940334, -0.054899>,
      <0.109815, -0.913430, -0.083032>, <0.092277, -0.928301, -0.077030>, <0.065673, -0.938317, -0.059456>, <0.050716, -0.951726, -0.046758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.885413, -0.114403>, <0.087522, -0.886110, -0.100766>, <0.107683, -0.903589, -0.092643>, <0.109815, -0.913430, -0.083032>,
      <0.101724, -0.880599, -0.121304>, <0.099020, -0.881295, -0.107667>, <0.118358, -0.894538, -0.096296>, <0.120489, -0.904379, -0.086685>,
      <0.124160, -0.872913, -0.115599>, <0.121334, -0.873754, -0.106676>, <0.130262, -0.882986, -0.092213>, <0.131393, -0.886138, -0.083431>,
      <0.133196, -0.866827, -0.106417>, <0.130370, -0.867668, -0.097493>, <0.138709, -0.873000, -0.086038>, <0.139841, -0.876152, -0.077257>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.090226, -0.885413, -0.114403>, <0.101724, -0.880599, -0.121304>, <0.124160, -0.872913, -0.115599>, <0.133196, -0.866827, -0.106417>,
      <0.098688, -0.883233, -0.157072>, <0.110186, -0.878419, -0.163973>, <0.140734, -0.867982, -0.167931>, <0.149770, -0.861896, -0.158749>,
      <0.133966, -0.900745, -0.205907>, <0.154905, -0.889641, -0.212061>, <0.162962, -0.873850, -0.222496>, <0.183817, -0.861187, -0.224570>,
      <0.142607, -0.904982, -0.248385>, <0.163546, -0.893878, -0.254539>, <0.181982, -0.870073, -0.274087>, <0.202837, -0.857410, -0.276161>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182782, -0.066809, 1.272605>, <0.226625, -0.067086, 1.263599>, <0.284306, -0.064816, 1.245894>, <0.324885, -0.067123, 1.227148>,
      <0.188251, 0.103603, 1.288013>, <0.232094, 0.103327, 1.279008>, <0.294020, 0.098844, 1.256801>, <0.334599, 0.096536, 1.238055>,
      <0.202353, 0.342596, 1.240807>, <0.250295, 0.336560, 1.228588>, <0.311988, 0.332635, 1.198743>, <0.354411, 0.321501, 1.175069>,
      <0.206497, 0.491323, 1.156127>, <0.254439, 0.485287, 1.143908>, <0.313865, 0.473430, 1.114062>, <0.356288, 0.462296, 1.090388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182782, -0.066809, 1.272605>, <0.188251, 0.103603, 1.288013>, <0.202353, 0.342596, 1.240807>, <0.206497, 0.491323, 1.156127>,
      <0.128859, -0.066469, 1.283681>, <0.134329, 0.103944, 1.299090>, <0.142308, 0.350155, 1.256111>, <0.146451, 0.498883, 1.171431>,
      <0.055567, -0.065075, 1.293777>, <0.055567, 0.109050, 1.310721>, <0.062941, 0.352666, 1.263289>, <0.062941, 0.507086, 1.181063>,
      <0.000517, -0.065075, 1.293777>, <0.000517, 0.109050, 1.310721>, <0.000517, 0.352666, 1.263289>, <0.000517, 0.507086, 1.181063>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172158, -0.578567, 1.059389>, <0.210826, -0.572943, 1.052710>, <0.259800, -0.559076, 1.036538>, <0.296137, -0.551099, 1.022849>,
      <0.184667, -0.463848, 1.179203>, <0.223335, -0.458223, 1.172524>, <0.278292, -0.446434, 1.145541>, <0.314629, -0.438457, 1.131852>,
      <0.177467, -0.232399, 1.257632>, <0.221310, -0.232675, 1.248627>, <0.274975, -0.222025, 1.235416>, <0.315554, -0.224333, 1.216671>,
      <0.182782, -0.066809, 1.272605>, <0.226625, -0.067086, 1.263599>, <0.284306, -0.064816, 1.245894>, <0.324885, -0.067123, 1.227148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.172158, -0.578567, 1.059389>, <0.184667, -0.463848, 1.179203>, <0.177467, -0.232399, 1.257632>, <0.182782, -0.066809, 1.272605>,
      <0.121546, -0.585929, 1.068130>, <0.134055, -0.471210, 1.187944>, <0.123545, -0.232058, 1.268709>, <0.128859, -0.066469, 1.283681>,
      <0.052403, -0.594099, 1.073907>, <0.052403, -0.478156, 1.200777>, <0.055567, -0.236136, 1.277131>, <0.055567, -0.065075, 1.293777>,
      <0.000517, -0.594099, 1.073907>, <0.000517, -0.478156, 1.200777>, <0.000517, -0.236136, 1.277131>, <0.000517, -0.065075, 1.293777>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.806017, 0.500570>, <0.094856, -0.820090, 0.459286>, <0.056395, -0.804002, 0.405458>, <0.048747, -0.815773, 0.363518>,
      <0.133555, -0.799311, 0.511865>, <0.126233, -0.813384, 0.470581>, <0.080514, -0.782354, 0.401516>, <0.072866, -0.794125, 0.359576>,
      <0.174749, -0.789007, 0.528964>, <0.156627, -0.806111, 0.462686>, <0.097259, -0.724938, 0.383189>, <0.076937, -0.738859, 0.316804>,
      <0.207492, -0.782198, 0.535177>, <0.189369, -0.799302, 0.468899>, <0.126567, -0.716397, 0.394763>, <0.106245, -0.730319, 0.328379>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.806017, 0.500570>, <0.133555, -0.799311, 0.511865>, <0.174749, -0.789007, 0.528964>, <0.207492, -0.782198, 0.535177>,
      <0.132343, -0.748038, 0.670659>, <0.163719, -0.741332, 0.681954>, <0.216741, -0.749375, 0.682534>, <0.249484, -0.742566, 0.688748>,
      <0.158456, -0.704226, 0.928149>, <0.197124, -0.698602, 0.921471>, <0.240577, -0.676166, 0.923231>, <0.276915, -0.668189, 0.909542>,
      <0.172158, -0.578567, 1.059389>, <0.210826, -0.572943, 1.052710>, <0.259800, -0.559076, 1.036538>, <0.296137, -0.551099, 1.022849>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.806017, 0.500570>, <0.132343, -0.748038, 0.670659>, <0.158456, -0.704226, 0.928149>, <0.172158, -0.578567, 1.059389>,
      <0.071433, -0.812588, 0.489502>, <0.101598, -0.754609, 0.659591>, <0.107844, -0.711588, 0.936891>, <0.121546, -0.585929, 1.068130>,
      <0.033848, -0.826433, 0.460669>, <0.033848, -0.756733, 0.644640>, <0.052403, -0.726815, 0.928683>, <0.052403, -0.594099, 1.073907>,
      <0.000517, -0.826433, 0.460669>, <0.000517, -0.756733, 0.644640>, <0.000517, -0.726815, 0.928683>, <0.000517, -0.594099, 1.073907>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.102178, -0.806017, 0.500570>, <0.071433, -0.812588, 0.489502>, <0.033848, -0.826433, 0.460669>, <0.000517, -0.826433, 0.460669>,
      <0.094856, -0.820090, 0.459286>, <0.064111, -0.826661, 0.448218>, <0.033848, -0.826068, 0.426166>, <0.000517, -0.826068, 0.426166>,
      <0.056395, -0.804002, 0.405458>, <0.044806, -0.814404, 0.407352>, <0.015747, -0.815926, 0.381917>, <0.000341, -0.817064, 0.379186>,
      <0.048747, -0.815773, 0.363518>, <0.037158, -0.826175, 0.365412>, <0.015922, -0.824078, 0.348389>, <0.000517, -0.825215, 0.345658>
    }
  }
  texture {
    Texture1
  }
}
#include "C:\POV\POV-Ray for Windows\INCLUDE\lona.inc"

#declare lona1 =object {
  lona
  texture {
    Texture1
  }
  scale 24.390244
  rotate <2.014957, 2.100056, 166.881805>
  translate  <0.630682, -1.966048, -12.880544>
}
union { // sPatchGroup
 object { sPatchObj2 }
  object { sPatchObj4 }
  object { sPatchObj5 }
 object { sPatchObj }
  object { sPatchObj1 }
  object { lona1 }
  scale .40

  rotate <108., -80, -159.>
  translate  <10.8, 6.6, -46.8>
}

//bridge//

#declare Group001 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <0.25, 0.15, 8.0>
    translate  <-4.996981, -3.405657, 3.081309>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <-0.295514, -0.008271, -21.288996>
    rotate -89.927429*x
    translate  <-4.80077, 16.782058, 2.991476>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.682226, -0.045798, 3.046141>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.428214, 12.584988, 2.921139>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.424504, 9.438741, 2.921139>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.624159, 6.292494, 2.921139>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.497153, 3.146247, 2.956308>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.497153, -3.33132, 2.921139>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.55522, 15.361089, 2.921139>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <-0.295514, -0.008271, -21.288996>
    rotate -89.927429*x
    translate  <3.516394, 16.98095, 2.991476>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <0.25, 0.15, 8.0>
    translate  <4.18378, -3.405657, 3.081309>
  }
  translate  <0.63503, -26.056525, 4.917907>
}
#declare Group2 = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <0.25, 0.15, 8.0>
    translate  <-4.996981, -3.405657, 3.081309>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <-0.295514, -0.008271, -21.288996>
    rotate -89.927429*x
    translate  <-4.80077, 16.782058, 2.991476>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.682226, -0.045798, 3.046141>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.428214, 12.584988, 2.921139>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.424504, 9.438741, 2.921139>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.624159, 6.292494, 2.921139>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.497153, 3.146247, 2.956308>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.497153, -3.33132, 2.921139>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.55522, 15.361089, 2.921139>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <-0.295514, -0.008271, -21.288996>
    rotate -89.927429*x
    translate  <3.516394, 16.98095, 2.991476>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <0.25, 0.15, 8.0>
    translate  <4.18378, -3.405657, 3.081309>
  }
  translate  <0.762036, -4.865225, 4.9864>
}
#declare Group3 = union {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <0.25, 0.15, 8.0>
    translate  <-4.996981, -3.405657, 3.081309>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <-0.295514, -0.008271, -21.288996>
    rotate -89.927429*x
    translate  <-4.80077, 16.782058, 2.991476>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.682226, -0.045798, 3.046141>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.428214, 12.584988, 2.921139>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.424504, 9.438741, 2.921139>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.624159, 6.292494, 2.921139>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.497153, 3.146247, 2.956308>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.497153, -3.33132, 2.921139>
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Parquet_Wood
    }
    scale <5.0, 1.0, 0.2>
    translate  <-0.55522, 15.361089, 2.921139>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <-0.295514, -0.008271, -21.288996>
    rotate -89.927429*x
    translate  <3.516394, 16.98095, 2.991476>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    texture {
      Cherry_Wood
    }
    scale <0.25, 0.15, 8.0>
    translate  <4.18378, -3.405657, 3.081309>
  }
  translate  <0.718034, 16.603744, 4.960296>
}
#declare pont=
union { // Group002
  object { Group001 }
  object { Group2 }
  object { Group3 }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    texture {
      Bronze_Metal1
    }
    scale 0.143036
    rotate <90.727081, 0.135657, -179.994858>
    translate  <4.50, -29.42, 15.4>
  }
  torus { // Torus2
    1.5, 0.5  rotate -x*90
    texture {
      Bronze_Metal1
    }
    scale 0.143036
    rotate <90.727081, 0.135657, -179.994858>
    translate  <-3.91, -29.42,15.4>}
  torus { // Torus3
    1.5, 0.5  rotate -x*90
    texture {
      Bronze_Metal1
    }
    scale 0.143036
    rotate <90.727081, 0.135657, -179.994858>
    translate  <-3.86, -8.2, 14.62>
  }
  torus { // Torus4
    1.5, 0.5  rotate -x*90
    texture {
      Bronze_Metal1
    }
    scale 0.143036
    rotate <90.727081, 0.135657, -179.994858>
    translate  <4.50, -8.17, 14.62>
  }
  torus { // Torus5
    1.5, 0.5  rotate -x*90
    texture {
      Bronze_Metal1
    }
    scale 0.143036
    rotate <90.727081, 0.135657, -179.994858>
    translate  <4.50, 13.18, 15.03>
  }
  torus { // Torus6
    1.5, 0.5  rotate -x*90
    texture {
      Bronze_Metal1
    }
    scale 0.143036
    rotate <90.727081, 0.135657, -179.994858>
    translate  <-3.896393, 13.18, 15.03>
  }
  rotate <90.727081, 0.003417, -179.864288>
}

#declare Rope = sphere {<0, 0, 0>, 1
   pigment {wrinkles color_map {[0 rgb <.9, .7, .5>] [1 rgb <.8, .7, .4>]}}
   normal {radial .75 frequency 11 scallop_wave rotate z * 90 warp {turbulence .2 octaves 2 lambda 4}}
   scale <.9, 1.1, 1.1>
}


#declare grop1 = object{
    #declare link_object = Rope
   #declare link_count = 40
   #declare link_twist = -.1
   #declare link_point1 = <32, 126.5, 15>
   #declare link_point2 = <32, 126.5, -30>
   #include "LINK.INC"
scale<0.12,0.12,1>
   }


#declare grop2= object{
    #declare link_object = Rope
   #declare link_count =40
   #declare link_twist = -.1
   #declare link_point1 = <-38, 126.5, 15>
   #declare link_point2 = <-38, 126.5, -30>

   #include "LINK.INC"
scale<0.12,0.12,1>
   }
union{
object{grop1}
object{grop2}
object{pont}
rotate<0,200,3>scale<0.5,0.51,0.5>translate<10,0,-55>
}

