#include "colors.inc"
#include "textures.inc"
#include "c:\winnt\profiles\kj36340.000\desktop\winseat\wintex.inc"

#declare SceneRotate=-20*y;

camera
{  location  <-4.273838, 21.548540, -1.409919>
   direction <0.0, 2.414214, 0.0>
   sky       <0.0, 0.0, 1.0>
   up        <0.0, 0.0, 1.0>
   right     <1.3333, 0.0, 0.0>
   look_at   <-3.010445, -2.398293, -3.294871>
}

intersection {
  object {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5> }
    scale <30.00, 0.5, 30.00>
  }
  object {
    cone {<0, 0, 0>, 0.5, <0, 0, 1>, 0.0  }
    scale     <8.00, 8.00, 10.00>
    rotate    <90.00, 0.00, 0.00>
    translate <0,1,0>
    scale <1,1,1.5>
    translate <-3.00, -3.00, -3.00>
  }
  texture {Rosewood}
  rotate SceneRotate
}
  
difference {
  object {
    box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5> }
    scale <20.00, 1.00, 20.00>
  }
  object {
    cone {<0, 0, 0>, 0.5, <0, 0, 1>, 0.0  }
    scale     <8.00, 8.00, 10.00>
    rotate    <90.00, 0.00, 0.00>
    translate <0.00, 1.00, 0.00>
  }
  texture {   
    winwall
  }
  scale <1.00, 1.00, 1.50>
  translate <-3.00, -3.00, -3.00>
  rotate SceneRotate
}

object
{   light_source { <-37.469315, -82.263992, 53.022522> color rgb<1.000000, 1.000000, 1.000000>}
}

object
{    cylinder {<0, 0, 0.5>, <0, 0, -0.5>, 0.5 }
      texture
      {   
        Wing
        finish {
          ambient 1.0
        }
      }
       scale     <5.00, 40.00, 180.00>
       rotate    <90.00, 90.00, -9.00>
       translate <-25.55, -124.29, -23.41>
       rotate SceneRotate
}

object
{   light_source { <-4.166433, 19.538433, -1.523895> color rgb<1.50000, 1.50000, 1.50000>}
}

object {
  merge {
    object {
      difference {
        object {
          box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5> }
          texture {winshade}
          scale     <1.90, 0.16, 0.67>
          translate <-2.83, -3.18, -0.04>
        }
    
        object {
          sphere {<0, 0, 0>, 0.5 }
          scale     <1.60, 0.30, 0.40>
          translate <-2.86, -3.02, -0.02>
        }
      }
    }
    object {
      box {<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5> }
      scale     <9.50, 0.20, 4.20>
      translate <-2.83, -3.28, 1.31>
    }
    texture {winshade}
  }
  rotate SceneRotate
}


sky_sphere {
  pigment {
    Bright_Blue_Sky
    scale .035
  }
}

object {
  box {
    <-1000, -1000, -1000>
    <1000,-900, -30.0>
    pigment {
      color Black
    }
  }
}

intersection {
    object {
      height_field {
        gif "waves3.gif"
        smooth 
        scale <105, 4, 105>
        rotate 90*x
        translate <-27,-1.2,-7.5>
        texture{
          pigment {color rgbt <0.15,0.45,0.325*1.5,0.0>}
          finish {
            phong .6
            ambient .4
          }
        }
      }
    }
    object {  
      plane {
        y,-3.2
      }
      texture{
        pigment {color rgbt <0.15,0.45,0.325*1.5,0.2>}
        finish {
          ambient .5
        }
      }
    }
}
 
#declare Fish=
union {
	object {
		union {
			sphere {<0,0,0>,.2	scale <1.5,1,1>}
			cone {<0,0,0>,.2,<1,0,0>,.08}
			sphere {<1,0,0>,.08}
		}
		pigment {
			image_map {
				tga "fishskin.tga"
				map_type 2
			}
			rotate y*180
			rotate z*90
			scale <1.5,1,1>
		}
		finish {ambient .4}
	}
	object {
		union {
			torus {.15,.03	scale <1.5,1,1>}
			torus {.15,.03	scale <1.5,1,1>	rotate z*3}
		}
		pigment {color GreenYellow}
		translate <-.03,-.05,0>
	}
	object {
		union {
			cone {<1,0,0>,.08,<1.2,.2,0>,0	scale <1,1,.1>}
			cone {<1,0,0>,.08,<1.2,-.2,0>,0	scale <1,1,.1>}
			cone {<.1,0,0>,.2,<.4,.3,0>,0 scale <1,1,.01>}
			cone {<.2,0,0>,.125,<.25,-.4,0>,.015 scale <1,1,.01> rotate x*35	translate <0,0,-.1>}
			cone {<.2,0,0>,.125,<.25,-.4,0>,.015 scale <1,1,.01> rotate x*-35	translate <0,0,.1>}
			cone {<.5,0,0>,.15,<.7,-.275,0>,0 scale <1,1,.01>}
		}
		texture {Ruby_Glass}
	}
	object {
		union {
			cylinder {
				<-.06,.055,-.2>,<-.06,.055,.2>,.03
				pigment {color Black}
			}
			cylinder {
				<-.06,.055,-.199>,<-.06,.055,.199>,.05
				texture {Gold_Texture}
			}
		}
	}
	scale <1,1,.5>
}

object {
  Fish
  no_shadow
  scale <0.6,0.6,0.4>
  rotate <90,0,-15>
  translate <-3.0, -0.0, -5.6>
}

object {
  Fish
  no_shadow
  scale <2.2,2.0,2.0>
  rotate <90,0,-89>
  translate <-1.0, 3.0, -5.9>
}