#global_settings { assumed_gamma 2.0 }

#include "colors.inc"
#include "Winseat2.inc"
#include "Winseat3.inc"
#include "Winseat4.inc"
#include "Winseat5.inc"

#declare WallTex1=
  texture {
    pigment {rgb<1, 0.9, 0.8>}
    normal {granite 0.025 turbulence 0.7 scale 0.1}
    finish {specular 0.1 roughness 0.01 brilliance 2.42}
  }

#declare TestTex1=
  texture {
    pigment {
      gradient x
      color_map {
        [0.000 rgb<1, 1, 1>]
        [0.249 rgb<1, 1, 1>]
        [0.250 rgb<0.6, 0.5, 0.5>]
        [0.500 rgb<0.6, 0.5, 0.5>]
        [0.750 rgb<0.6, 0.5, 0.5>]
        [0.751 rgb<1, 1, 1>]
        [1.000 rgb<1, 1, 1>]
      }
    }
    scale 0.01
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0.000 rgbf<0.6, 0.5, 0.5, 0.4>]
        [0.249 rgbf<0.6, 0.5, 0.5, 0.4>]
        [0.250 rgbf<1, 1, 1, 1>]
        [0.500 rgbf<1, 1, 1, 1>]
        [0.750 rgbf<1, 1, 1, 1>]
        [0.751 rgbf<0.6, 0.5, 0.5, 0.4>]
        [1.000 rgbf<0.6, 0.5, 0.5, 0.4>]
      }
    }
    scale 0.01
  }
  texture {
    pigment {
      granite
      turbulence 0.65
      color_map {
        [0.00 rgbf<0.9, 0.2, 0.1, 0.35>]
        [0.17 rgbf<0.9, 0.2, 0.1, 0.35>]
        [0.23 rgbf<0.8, 0.9, 0.0, 0.35>]
        [0.30 rgbf<0.01, 0.01, 0.25, 0.35>]
        [0.75 rgbf<0.0, 0.125, 0.17, 0.35>]
        [1.00 rgbf<0.9, 0.2, 0.1, 0.35>]
      }
    }
    rotate <-15, -35, -25>
  }
  texture {
    pigment {rgbt<1, 1, 1, 1>}
    normal {quilted control0 1 control1 1}
    finish {specular 0.1 roughness 0.075 ambient 0.4 diffuse 0.5 brilliance 3.42}
    scale 0.015
  }

#declare TestTex2=
  texture {
    pigment {
      gradient x
      color_map {
        [0.000 rgb<1, 1, 1>]
        [0.249 rgb<1, 1, 1>]
        [0.250 rgb<0.6, 0.5, 0.5>]
        [0.500 rgb<0.6, 0.5, 0.5>]
        [0.750 rgb<0.6, 0.5, 0.5>]
        [0.751 rgb<1, 1, 1>]
        [1.000 rgb<1, 1, 1>]
      }
    }
    scale 0.01
  }
  texture {
    pigment {
      gradient z
      color_map {
        [0.000 rgbf<0.6, 0.5, 0.5, 0.4>]
        [0.249 rgbf<0.6, 0.5, 0.5, 0.4>]
        [0.250 rgbf<1, 1, 1, 1>]
        [0.500 rgbf<1, 1, 1, 1>]
        [0.750 rgbf<1, 1, 1, 1>]
        [0.751 rgbf<0.6, 0.5, 0.5, 0.4>]
        [1.000 rgbf<0.6, 0.5, 0.5, 0.4>]
      }
    }
    scale 0.01
  }
  texture {
    pigment {
      granite
      turbulence 0.65
      color_map {
        [0.00 rgbf<0.9, 0.2, 0.1, 0.35>]
        [0.17 rgbf<0.9, 0.2, 0.1, 0.35>]
        [0.23 rgbf<0.8, 0.9, 0.0, 0.35>]
        [0.30 rgbf<0.01, 0.01, 0.25, 0.35>]
        [0.75 rgbf<0.0, 0.125, 0.17, 0.35>]
        [1.00 rgbf<0.9, 0.2, 0.1, 0.35>]
      }
    }
    rotate <15, 35, 25>
  }
  texture {
    pigment {rgbt<1, 1, 1, 1>}
    normal {quilted control0 1 control1 1}
    finish {specular 0.1 roughness 0.075 ambient 0.4 diffuse 0.5 brilliance 3.42}
    scale 0.015
  }

#declare TestTex3=
  texture {
    pigment {rgb<0.63, 0.21, 0.0>}
    normal {quilted control0 1 control1 1}
    finish {specular 0.1 roughness 0.175}
    scale 0.0075
  }

/*
camera {
  location  <  -7,  4, -2.25>
////  location  <0,  3, -2.25>
  direction <  0,  0,  1>
  up        <  0,  1,  0>
  right     <4/3,  0,  0>
////  look_at   <  -5,  2,  0.75>
  look_at   <  5,  2,  0.75>
}
*/

camera {
  location <0, 0, 0>
  direction <  0,  0,  1>
  up        <  0,  1,  0>
  right     <4/3,  0,  0>
  rotate 70*y
//  rotate -15*z
  rotate 30*x
  translate  <  -7,  4, -2.25>
//  look_at   <  5,  2,  0.75>
}

light_source {
  <-4.5, 4, 4> 
  color rgb<0.5, 0.5, 0.5>
}
light_source {
  <-4.5, 4, 0> 
  color rgb<0.5, 0.5, 0.5>
}
light_source {
  <-4.5, 4, -4> 
  color rgb<0.5, 0.5, 0.5>
}

// SKY
background {rgb<0.4, 0.8, 0.8>}



// AIRPLANE ROOF
#declare Roof1=
  cylinder {<0, 0, 14>, <0, 0, -14>, 8.2 open
    clipped_by {box {<-15, 0, -15>, <15, 10, 15>}}
    scale <1, 0.35, 1>
    translate <-4.6, 3, 0> 
    texture {WallTex1}
  }


// CUBICLE AT RIGHT OF CAMERA, BEFORE CAMERA
#declare Cubicle1=
superellipsoid {<0.5, 0.5>
  scale <5, 10, 5>
  translate <2.5, 3, -10>
  texture {WallTex1}
}
// CUBICLE AT RIGHT OF CAMERA, BEHIND CAMERA
#declare Cubicle2=
superellipsoid {<0.5, 0.5>
  scale <5, 10, 5>
  translate <-11.5, 3, -10>
  texture {WallTex1}
}

// UPPER COMPARTMENT, BEFORE CAMERA
#declare UC1=
  difference {
    cylinder {<0, 0, 4.2>, <0, 0, -5.2>, 3 
      scale <1, 0.35, 1>
      rotate -7.5*z
      translate <1.4, 4.5, 0>
    }
    superellipsoid {<0.25, 0.25>
      scale <3, 0.6, 1.4>
      translate <0.7, 4.5, 2.3>
    }
    superellipsoid {<0.25, 0.25>
      scale <3, 0.6, 1.4>
      translate <0.7, 4.5, -0.7>
    }
    superellipsoid {<0.25, 0.25>
      scale <3, 0.6, 1.4>
      translate <0.7, 4.5, -3.7>
    }
    texture {WallTex1}
  }

// UPPER COMPARTMENT, BEHIND CAMERA
#declare UC2=
  difference {
    cylinder {<0, 0, 4.2>, <0, 0, -5.2>, 3 
      scale <1, 0.35, 1>
      rotate -7.5*z
      translate <-10.4, 4.5, 0>
    }
    superellipsoid {<0.25, 0.25>
      scale <3, 0.6, 1.4>
      translate <-9.7, 4.5, 2.3>
    }
    superellipsoid {<0.25, 0.25>
      scale <3, 0.6, 1.4>
      translate <-9.7, 4.5, -0.7>
    }
    superellipsoid {<0.25, 0.25>
      scale <3, 0.6, 1.4>
      translate <-9.7, 4.5, -3.7>
    }
    texture {WallTex1}
  }

// INITIAL SHAPE OF COMPARTMENT DOOR, BEFORE CAMERA
#declare Panel1=
  difference {
    cylinder {<0, 0, 4.2>, <0, 0, -5.2>, 3 
      scale <1, 0.35, 1>
      rotate -7.5*z
      translate <1.4, 4.5, 0>
    }
    superellipsoid {<0.25, 0.25>
      inverse
      scale <3, 0.575, 1.375>
      translate <0.7, 4.5, 2.3>
    }
    cylinder {<0, 0, 4.2>, <0, 0, -5.2>, 3 
      scale <0.95, 0.30, 1>
      rotate -7.5*z
      translate <1.4, 4.5, 0>
    }
  }

// COMPARTMENT DOOR WITH DEPRESSION FOR BUTTON/CLASP
#declare Panel2=
  difference {
    object {Panel1}
    superellipsoid {<0.15, 0.15>
      scale <0.15, 0.2, 0.3>
      rotate 15*z
      translate <-1.6, 4.65, 2.3>
    }
    texture {WallTex1}
  }  

// INITIAL SHAPE OF COMPARTMENT DOOR, BEFORE CAMERA
#declare Panel3=
  difference {
    cylinder {<0, 0, 4.2>, <0, 0, -5.2>, 3 
      scale <1, 0.35, 1>
      rotate -7.5*z
      translate <-10.4, 4.5, 0>
    }
    superellipsoid {<0.25, 0.25>
      inverse
      scale <3, 0.575, 1.375>
      translate <-9.7, 4.5, 2.3>
    }
    cylinder {<0, 0, 4.2>, <0, 0, -5.2>, 3 
      scale <0.95, 0.30, 1>
      rotate -7.5*z
      translate <-10.4, 4.5, 0>
    }
  }

// COMPARTMENT DOOR WITH DEPRESSION FOR BUTTON/CLASP, BEHIND CAMERA
#declare Panel4=
  difference {
    object {Panel3}
    superellipsoid {<0.15, 0.15>
      scale <0.15, 0.2, 0.3>
      rotate -15*z
      translate <-7.4, 4.65, 2.3>
    }
    texture {WallTex1}
  }  

// STANDARD BUTTON/CLASP FOR UPPER COMPARTMENT DOOR, BEFORE CAMERA
#declare Button1=
  superellipsoid {<0.15, 0.15>
    scale <0.0175, 0.095, 0.295>
    translate <0.125, 0.09, 0>
    rotate 15*z
    translate <-1.65, 4.65, -0.7>
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .001, .3> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
  }

// STANDARD BUTTON/CLASP FOR UPPER COMPARTMENT DOOR, BEFORE CAMERA
#declare Button2=
  superellipsoid {<0.15, 0.15>
    scale <0.0175, 0.095, 0.295>
    translate <-0.125, 0.09, 0>
    rotate -15*z
    translate <-7.45, 4.65, -0.7>
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .001, .3> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
  }

// WATER LEAK AROUND WINDOW
#declare Leak1=
  difference {
    blob {
      threshold 0.65
      sphere {0, 1, 1
        scale <1, 1.5, 1>
        scale 0.3
        rotate -10*z
        translate <0.7, -0.75, -0.3>
      } 
      sphere {0, 1, 1
        scale <1, 1.5, 0.5>
        scale 0.2
        translate <0.55, -1.05, -0.4>
      } 
      sphere {0, 1, 1
        scale <1, 1.5, 1>
        scale 0.15
        rotate 35*z
        translate <0.93, -1.0, -0.4>
      } 
      sphere {0, 1, 1
        scale <1.5, 1, 1>
        scale 0.3
        rotate -10*z
        translate <0.25, -1.0, -0.3>
      } 
      sphere {0, 1, 1
        scale <1.5, 0.5, 1>
        scale 0.3
        rotate -20*z
        translate <0.1, -0.95, -0.3>
      } 
      rotate 15*z
      scale <1, 1.25, 0.5>
      translate <-0.3, 0.25, -0.2> 
      rotate 90*y
    }
    superellipsoid {<0.1, 0.35>
      scale <0.5, 0.85, 0.6>
    }
    texture {
      pigment {
        bozo
        turbulence 0.952
        color_map {
          [0.00 rgbf<0.8500, 1.0000, 0.9000, 0.95>]
          [0.25 rgbf<0.8500, 0.9000, 1.0000, 0.95>]
          [0.50 rgbf<0.8500, 1.0000, 0.9000, 0.95>]
          [0.75 rgbf<0.8500, 0.9000, 1.0000, 0.95>]
          [1.00 rgbf<0.8500, 1.0000, 0.9000, 0.95>]
        }
        scale 100
      }
      normal {wrinkles 0.73 turbulence 0.35 scale 0.1}
      finish {
        specular 0.7
        roughness 0.003
        reflection 0.25
      }
    }
    interior {ior 1.3}
  }

// WATER LEAK AROUND WINDOW
#declare Leak2=
  difference {
    blob {
      threshold 0.65
      sphere {0, 1, 1
        scale <1, 1.5, 1>
        scale 0.3
        rotate -10*z
        translate <0.7, -0.75, -0.3>
      } 
      sphere {0, 1, 1
        scale <1, 1.5, 0.5>
        scale 0.2
        translate <0.55, -1.05, -0.4>
      } 
      sphere {0, 1, 1
        scale <1, 1.5, 1>
        scale 0.15
        rotate 35*z
        translate <0.575, -1.30, -0.4>
      } 
      rotate 15*z
      scale <1, 1.25, 0.5>
      translate <-0.3, 0.25, -0.2> 
      rotate 90*y
    }
    superellipsoid {<0.1, 0.35>
      scale <0.5, 0.85, 0.6>
    }
    texture {
      pigment {
        bozo
        turbulence 0.952
        color_map {
          [0.00 rgbf<0.8500, 1.0000, 0.9000, 0.95>]
          [0.25 rgbf<0.8500, 0.9000, 1.0000, 0.95>]
          [0.50 rgbf<0.8500, 1.0000, 0.9000, 0.95>]
          [0.75 rgbf<0.8500, 0.9000, 1.0000, 0.95>]
          [1.00 rgbf<0.8500, 1.0000, 0.9000, 0.95>]
        }
        scale 100
      }
      normal {wrinkles 0.73 turbulence 0.35 scale 0.1}
      finish {
        specular 0.7
        roughness 0.003
        reflection 0.25
      }
    }
    interior {ior 1.3}
  }

// STANDARD WINDOW FRAME
#declare Frame1=
  difference {
    superellipsoid {<0.1, 0.35>
      scale <0.5, 0.85, 0.6>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.7, 0.45>
    }
    superellipsoid {<0.1, 0.1>
      scale <0.075, 0.8, 0.55>
    }
    texture {
      pigment {rgb<1, 0.975, 0.886>}
      finish {specular 0.4 roughness 0.003}
    }
  }


//box {<-7.5, 0.5, 14>, <0, -12.2, -14>
//  rotate 45*x
//  translate <11.4, 0.7, -0.75>
// WATER WATER EVERYWHERE, AND NARY A DROP TO DRINK
#declare Water1=
  superellipsoid {<0.15, 0.25>
    scale <3.75, 6.35, 14>
    rotate 45*x
    translate <7.65, -5.65, -0.75>
  //<3.9, 0.7, 14>, <11.1, -1.5, -14>
  //left wall centered at <3.9, 0.7, -0.75>
  //  pigment {blue 0.5}
    texture {
      pigment {
        bozo
        turbulence 0.952
        color_map {
          [0.00 rgbf<0.64595/2, 0.9759/2, 0.9059/2, 0.75>]
          [0.25 rgbf<0.44595/2, 0.7459/2, 0.7059/2, 0.55>]
          [0.50 rgbf<0.64595/2, 0.9059/2, 0.9759/2, 0.35>]
          [0.75 rgbf<0.44595/2, 0.7059/2, 0.7459/2, 0.55>]
          [1.00 rgbf<0.64595/2, 0.9459/2, 0.9059/2, 0.75>]
        }
        scale 100
      }
    }
    texture {
      pigment {
        bozo
        turbulence 0.952
        color_map {
          [0.00 rgbf<0.64595, 0.9759, 0.9059, 0.95>]
          [0.25 rgbf<0.44595, 0.7459, 0.7059, 0.95>]
          [0.50 rgbf<0.64595, 0.9059, 0.9759, 0.95>]
          [0.75 rgbf<0.44595, 0.7059, 0.7459, 0.95>]
          [1.00 rgbf<0.64595, 0.9459, 0.9059, 0.95>]
        }
        scale 100
      }
      normal {wrinkles 0.73 turbulence 0.35 scale 0.1}
      finish {
        specular 0.7
        roughness 0.003
        reflection 0.25
      }
    }
    interior {ior 1.3}
  }



// OUTER WALLS OF PLANE, BEFORE CAMERA
#declare OW1=
  difference {
    box {<3.6, 3.1, 14>, <4.2, -1.5, -14>}
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <4, 1.50, -0.75>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <4, 1.50, -2.75>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <4, 1.50, 1.25>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <4, 1.50, 3.25>
    }
    texture {WallTex1}
  }

// OUTER WALLS OF PLANE, BEHIND CAMERA
#declare OW2=
  difference {
//So, we have 3.9 as the centerpoint, so the centerpoint behind the camera
// will be at -13.1. So, the box will be {<-12.8, 3.1, 14>, <-13.4, -1.5, -14>
    box {<-12.8, 3.1, 14>, <-13.4, -1.5, -14>}
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <-13.1, 1.50, -0.75>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <-13.1, 1.50, -2.75>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <-13.1, 1.50, 1.25>
    }
    superellipsoid {<0.35, 0.35>
      scale <1, 0.75, 0.5>
      translate <-13.1, 1.50, 3.25>
    }
    texture {WallTex1}
  }



// FLOOR
#declare Floor1=
  box {<-16, -1.4, -15>, <3.7, -1.6, 15>
//    pigment {rgb<0.3, 0.3, 0.6>}

    texture {
      pigment {
        agate
        turbulence 0.7
        color_map {
          [0.0 rgb<0.3, 0.3, 0.6>]
          [1.0 rgb<0.3, 0.3, 0.5>]
        }
      }
      normal {agate 6 turbulence 0.7}
      finish {specular 0.1 roughness 0.1}
      scale 0.5
    }

  }



// BACK WALL
#declare BW1=
  difference {
    box {<-13.1, -2, 2>, <4.2, 15, 3>
//      pigment {rgb<0.0, 0.0, 0.5>}

      texture {
        pigment {
          marble
          turbulence 0.5
          color_map {
            [0.00 rgb<0.2, 0.2, 0.7>]
            [0.15 rgb<0.2, 0.2, 0.4>]
            [0.20 rgb<0.7, 0.3, 0.0>]
            [0.35 rgb<0.0, 0.4, 0.5>]
            [0.65 rgb<0.4, 0.4, 0.7>]
            [1.00 rgb<0.2, 0.2, 0.7>]
          }
          scale <3, 1, 1>
          rotate <23, -34, -35>
        }
        normal {crackle 15 turbulence 0.3 scale 0.25}
        finish {specular 0.1 roughness 0.1}
      } 
      texture {
        pigment {
          gradient x
          turbulence 0.5
          color_map {
            [0.00 rgbt<1.0, 1.0, 1.0, 1.0>]
            [0.30 rgbt<1.0, 1.0, 1.0, 1.0>]
            [0.50 rgbt<0.8, 1.0, 1.0, 0.3>]
            [0.70 rgbt<1.0, 1.0, 1.0, 1.0>]
            [1.00 rgbt<1.0, 1.0, 1.0, 1.0>]
          }
        }
        normal {crackle 15 turbulence 0.3 scale 0.5}
        finish {specular 0.1 roughness 0.1}
        scale 0.5
      }
      texture {
        pigment {rgbf<0.0, 0.0, 0.5, 0.9>}
      }

    }
    box {<-3, -3, 1>, <-6, 16, 4>
      texture {
        pigment {rgb<0.0, 0.0, 0.5>}
      }
    }
    translate 2*z
  }


// WINDOW GLASS
#declare Window1=
  superellipsoid {<0.1, 0.1>
    scale <0.075, 0.8, 0.55>
    texture {
      pigment {rgbt<0.9, 0.9, 0.95, 0.98>}
      finish {specular 0.6 roughness 0.008 reflection 0.25}
    }
    interior {ior 1.5}
  }

// SEAT ARMS
#declare SeatArm1=
union {
  superellipsoid {<0.15, 0.15>
    scale <0.25, 1.5, 1.25>
    translate <0, -0.45, -0.55>
    texture {
      pigment {rgb<0.7, 0.6, 0.5>}
      normal {granite 0.025 turbulence 0.7 scale 0.1}
      finish {specular 0.3 roughness 0.1 brilliance 1.72}
    }
  }

  superellipsoid {<0.25, 0.25>
    scale <0.265, 0.05, 0.4>
    translate <0, 1.01, -1.4>
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .001, .3> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
  }

  superellipsoid {<0.25, 0.25>
    scale <0.265, 0.15, 0.05>
    translate <0, 0.90, -1.75>
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .3, .001> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
  }
  sphere {0, 1
    clipped_by {box {<2, -2, -2>, <0, 2, 2>}}
    scale 0.1
    translate <-0.3, 0.70, -1.45>
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .3, .001> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
  }
  torus {0.11, 0.01
    rotate -90*z
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .3, .001> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
    translate <-0.3, 0.70, -1.45>
  }
  cylinder {<0, 0, 0>, <0.11, 0, 0>, 0.11
    texture {
      pigment {rgb<0.75, 0.75, 0.82>}
      normal {bumps 1 scale <.001, .3, .001> turbulence 0.75}
      finish {specular 0.3 roughness 0.03}
    }
    translate <-0.3, 0.70, -1.45>
  }
    
    
    rotate -45*x
    scale <1, 0.75, 1>
    rotate 35*x
}

object {BW1}
object {Roof1}
object {Floor1}

// BEFORE THE CAMERA
// AIRPLANE SEAT

  object {
    SeatBack
    rotate 90*y
    rotate 15*x
    translate 1.4*x
    texture {TestTex1}
  }

  object {
    SeatBottom
    rotate 90*y
    translate 1.4*x
    texture {TestTex2}
  }


  object {
    SeatSheet1
    rotate 90*y
    rotate 15*x
    translate 1.4*x
    texture {TestTex3}
  }

// AIRPLANE SEAT

  object {
    SeatBack
    rotate 90*y
    rotate -10*x
    translate -1.4*x
    texture {TestTex1}
  }


  object {
    SeatBottom
    rotate 90*y
    translate -1.4*x
    texture {TestTex2}
  }


  object {
    SeatSheet2
    rotate 90*y
    rotate -10*x
    translate -1.4*x
    texture {TestTex3}
  }

  
  
object {SeatArm1 translate <0, -0.1, 0.2>}
object {SeatArm1 translate <2.7, -0.1, 0.2>}
object {SeatArm1 translate <-2.7, -0.1, 0.2>}


object {OW1 texture {WallTex1}}
object {Frame1 translate <4, 1.50, -0.75>}
object {Frame1 translate <4, 1.50, -2.75>}
object {Frame1 translate <4, 1.50, 1.25>}
object {Frame1 translate <4, 1.50, 3.25>}

object {Leak1 translate <4, 1.50, -2.75>} 
object {Leak2 translate <4, 1.50, -0.75>}
object {Water1}

object {Window1 translate <4, 1.50, -0.75>}
object {Window1 translate <4, 1.50, -2.75>}
object {Window1 translate <4, 1.50, 1.25>} 
object {Window1 translate <4, 1.50, 3.25>}


object {UC1}
object {Panel2}
object {Panel2 translate -3.0*z}
object {Panel2 translate -6.0*z}
object {Button1}
object {Button1 translate 3*z}
object {Button1 translate -3*z}
object {Cubicle1}




// BEHIND THE CAMERA
// AIRPLANE SEAT

  object {
    SeatBack
    rotate 90*y
    translate -7.6*x
    texture {TestTex1}
  }
  object {
    SeatBottom
    rotate 90*y
    translate -7.6*x
    texture {TestTex2}
  }
  object {
    SeatSheet2
    rotate 90*y
    translate -7.6*x
    texture {TestTex3}
  }
// AIRPLANE SEAT
  object {
    SeatBack
    rotate 90*y
    rotate 5*x
    translate -10.4*x
    texture {TestTex1}
  }
  object {
    SeatBottom
    rotate 90*y
    translate -10.4*x
    texture {TestTex2}
  }
  object {
    SeatSheet1
    rotate 90*y
    rotate 5*x
    translate -10.4*x
    texture {TestTex3}
  }


object {SeatArm1 translate <-9, -0.1, -0.55>}
object {SeatArm1 translate <-6.3, -0.1, 0.2>}
object {SeatArm1 translate <-11.7, -0.1, 0.2>}
object {OW2 texture {TestTex1}}
object {Frame1 translate <-13, 1.50, -0.75>}
object {Frame1 translate <-13, 1.50, -2.75>}
object {Frame1 translate <-13, 1.50, 1.25>}
object {Frame1 translate <-13, 1.50, 3.25>}
object {Window1 translate <-13, 1.50, -0.75>}
object {Window1 translate <-13, 1.50, -2.75>}
object {Window1 translate <-13, 1.50, 1.25>} 
object {Window1 translate <-13, 1.50, 3.25>}
object {UC2}
object {Panel4}
object {Panel4 translate -3.0*z}
object {Panel4 translate -6.0*z}
object {Button2}
object {Button2 translate 3*z}
object {Button2 translate -3*z}
object {Cubicle2}



/*
difference {
object {OW1 }
object {Window1 translate <4, 1.50, -0.75>}
object {Window1 translate <4, 1.50, -2.75>}
object {Window1 translate <4, 1.50, 1.25>} 
object {Window1 translate <4, 1.50, 3.25>}
}
*/


