// Author: Frank Epple.
// Use FAST_RENDER for previews of the scene with less details.
// We're just two souls swimming in a fishbowl...

//#declare FAST_RENDER = 1

#include "colors.inc"

global_settings {
  max_trace_level 7
}

// ----------------------------------------------------------------------------------------
// Material declarations
// ----------------------------------------------------------------------------------------

#declare P_Cloud2 =
pigment {
    wrinkles
    turbulence 0.65
    octaves 6
    omega 0.7
    lambda 2
    color_map {
        [0.0 color red 0.55 green 0.55 blue 0.95]
        [0.1 color red 0.75 green 0.75 blue 0.75]
        [0.8 color rgb <0.99, 0.99, 0.99>]
    }
    scale <6, 1, 6>
}
#declare P_Cloud3 =
pigment {
    bozo
    color_map {
        [0.0 color red 0.3 green 0.3 blue 0.85]
        [0.1 color red 0.5 green 0.5 blue 0.95]
        [0.9 color rgb <0.88, 0.88, 0.88>]
    }
    turbulence 0.65
    octaves 6
    omega 0.707
    lambda 2
    scale <6, 4, 6>
}

#declare SKY_TEXTURE =
texture {
    pigment {
        bozo
        pigment_map {
            [0.25 P_Cloud2 scale 0.25 rotate z*5]
            [0.75 P_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

#declare WATER_TEXTURE =
texture
  {
#ifndef (FAST_RENDER)
    pigment { color rgbt< 0.17, 0.49, 0.42, 0.67> }
    finish
      {
        phong 1
        reflection 0.3
        ambient 0.15
        diffuse 0.4
//        refraction 1
//        ior 1.33
      }
#else
    pigment { color rgbf< 0.8, 0.8, 0.9, 0.0> }
    finish
      {
        ambient 0.4
        diffuse 0.6
      }
#end
  }

#declare WATER_BACK_TEXTURE =
texture
  {
#ifndef (FAST_RENDER)
    pigment { color rgbt< 0.17, 0.49, 0.42, 0.67> }
    finish
      {
        phong 1
//        reflection 0.3
        ambient 0.45
        diffuse 0.6
//        refraction 1
//        ior 1.33
      }
#else
    pigment { color rgbf< 0.8, 0.8, 0.9, 0.0> }
    finish
      {
        ambient 0.4
        diffuse 0.6
      }
#end
  }

// ----------------------------------------------------------------------------------------
// Parameters
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// SCENE
// ----------------------------------------------------------------------------------------

camera { location <-17.0, 16.0, -12.0> look_at <0,-0.8,0> angle 52} // Competition camera.
//camera { location <-18.5, 14.0, -12.0> look_at <0,0,0> }

light_source
  {
    <-1500,1700,-1300>
//    color rgb <1,0.925,0.8>
    rgb 1
  }

sphere
{
  <0,0,0>
  4000

  texture
    {
      SKY_TEXTURE
      scale 2000
    }

  finish { ambient 1.0 diffuse 0.0 }

  hollow
}


height_field
{
  ppm "TopSurface.ppm"
  smooth
  translate <-0.5,-0.5,-0.5>   // First translate that the middle of the field
                              // is in <0,0,0>
  scale <10.0, 27.0, 10.0>
  translate <0,5,0>
  texture { WATER_TEXTURE }
}

height_field
{
  ppm "FrontSurface.ppm"
  smooth
  translate <-0.5,-0.5,-0.5>   // First translate that the middle of the field
                              // is in <0,0,0>
  scale <10.0, -27.0, 10.0>
  rotate <-90,0,0>
  translate <0,0,-5>
  texture { WATER_TEXTURE }
}

height_field
{
  ppm "SideSurface.ppm"
  smooth
  translate <-0.5,-0.5,-0.5>   // First translate that the middle of the field
                              // is in <0,0,0>
  scale <10.0, -27.0, 10.0>
  rotate <0,0,90>
  translate <-5,0,0>
  texture { WATER_TEXTURE }
}

box
  {
    <-4.99,-4.99,-4.99>
    < 4.99,-5.00, 4.99>

    texture { WATER_TEXTURE }
  }

box
  {
    < 4.99,-4.99,-4.99>
    < 5.00, 4.99, 4.99>

    texture { WATER_TEXTURE }
  }

box
  {
    <-4.99,-4.99,4.99>
    < 4.99, 4.99,5>

    texture { WATER_TEXTURE }
  }
