// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"

#declare #FINAL=0;
#declare IMPORT_SPATCH=1;
#include "seat.inc"
/*
global_settings
{
	assumed_gamma 2.2

	radiosity {
		brightness 3.3
		count 175     				//change me for the FINAL!
		distance_maximum 2
		error_bound 0.33			//Change me for the FINAL!
		gray_threshold 0.5
		low_error_factor 0.8
		minimum_reuse 0.015
		nearest_count 6
		recursion_limit 1
	}
	
}
*/
// sets the default texture that objects get when they have no texture specified
#default {
	texture { 
		finish {
			ambient 0.2
			diffuse 0.8
		}
	}
}


// ----------------------------------------
#declare Close_up_LowerLeft=
camera
{
  location  <0.0, 1.5, 4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-1.0, -1.0, 5.0>
}

#declare All=
camera
{
  location  <0.0, 0.0, -0.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-1.0, -0.0,  5.0>
}

#declare Look_Seat=
camera
{
  location  <0.0, 0.0, 3.0>
  direction 1.5*z
  right     4/3*x
  look_at   <-1.0, -1.0, 4>
}

#declare Outside=
camera
{
  location  <3.0, 1.0, -15.0>
  direction 3.5*z
  right     4/3*x
  look_at   <0,0,0>
}

camera{All}


sphere {
	<0,-90000,0>,90100
	pigment {P_Cloud4 scale 500}
	finish { ambient 0.3 }
}

light_source
{
  0*x // light's position (translated below)
  color Gray50  // light's color
  translate <1000, 3000, -3000>
}
                          
                         
light_source              
{
  <1, 5, -30>
  color rgb 0.1// light's color
  spotlight
  point_at <0.71,1,-5>
  radius 30
  falloff 50
  tightness 23    
  shadowless
}


#declare Wall_Tex=
texture {
	pigment {Tan}
	finish {ambient 0.25}
	normal {
		wrinkles 0.05 scale <1,10,1>
	}
}

// Probably more of a "Plexiglas" than glass
#declare Glass2 = 
texture {
	pigment { rgbf <1,1,1,1> }
	finish {
		ambient 0
		diffuse 0
		reflection 0.5
		refraction 0.85
		ior 1.5
		phong 0.3
		phong_size 60
	}
}



#declare HoleWidth=0.75;
#declare HoleHeight=1;
#declare HoleDepth=0.25;
#declare Rounder=0.3;


#declare HoleCylinder=
cylinder {
	<0,0,-HoleDepth+0.01>,<0,0,HoleDepth-0.01>,Rounder
}

#declare HoleShape = 	//This is the outline of the window hole
union {
	box {
		<-HoleWidth+Rounder,-HoleHeight,-HoleDepth>
		<HoleWidth-Rounder,HoleHeight,HoleDepth>
	}
	box {
		<-HoleWidth,Rounder-HoleHeight,-HoleDepth>
		<HoleWidth,-Rounder+HoleHeight,HoleDepth>
	}
	object {HoleCylinder translate <-HoleWidth+Rounder,HoleHeight-Rounder,0>}
	object {HoleCylinder translate <HoleWidth-Rounder,HoleHeight-Rounder,0>}
	object {HoleCylinder translate <-HoleWidth+Rounder,-HoleHeight+Rounder,0>}
	object {HoleCylinder translate <HoleWidth-Rounder,-HoleHeight+Rounder,0>}
	pigment {Clear}
//	scale 1.2
}


#declare Rounder2=Rounder*0.4		//Inner cone radius for the rim
#declare ConeDepth=0.3
#declare HoleCone=
//difference {
	cone {
		<0,0,0>,Rounder
		<0,0,ConeDepth>,Rounder2
		open
	
	clipped_by {
		box {<0,0,-0.001>, <Rounder,Rounder,ConeDepth+0.0001>}
	}
	}
//}


#declare PolyWidth=sqrt(pow((Rounder-Rounder2),2)+pow(ConeDepth,2));
#declare Theta=degrees(asin(ConeDepth/PolyWidth));
#declare SideRim=
polygon {
	5,
	<0,HoleHeight-Rounder>
	<-PolyWidth,HoleHeight-Rounder>
	<-PolyWidth,-HoleHeight+Rounder>
	<0,-HoleHeight+Rounder>
	<0,HoleHeight-Rounder>
	rotate -y*Theta
}
#declare TopRim=
polygon {
	5,
	<HoleWidth-Rounder,0>
	<HoleWidth-Rounder,PolyWidth>
	<-HoleWidth+Rounder,PolyWidth>
	<-HoleWidth+Rounder,0>
	<HoleWidth-Rounder,0>
	rotate -x*Theta
}

#declare WindowRim=
union {
	object {HoleCone rotate <0,0,90> translate <-HoleWidth+Rounder,HoleHeight-Rounder,0>}
	object {HoleCone rotate <0,0,0> translate <HoleWidth-Rounder,HoleHeight-Rounder,0>}
	object {HoleCone rotate <0,0,180> translate <-HoleWidth+Rounder,-HoleHeight+Rounder,0>}
	object {HoleCone rotate <0,0,-90> translate <HoleWidth-Rounder,-HoleHeight+Rounder,0>}
	object {SideRim translate <-HoleWidth+Rounder-Rounder2,0,ConeDepth>}
	object {SideRim translate <-HoleWidth+Rounder-Rounder2,0,ConeDepth> rotate <0,0,180>}
	object {TopRim translate <0,HoleHeight-Rounder+Rounder2,ConeDepth> rotate <0,0,0>}
	object {TopRim translate <0,HoleHeight-Rounder+Rounder2,ConeDepth> rotate <0,0,180>}
	texture {Wall_Tex}
}

#declare Window=
box {
	<-HoleWidth,-HoleHeight,ConeDepth>,
	<HoleWidth,HoleHeight,ConeDepth+0.1>
	#if (FINAL)
		texture {Glass2}
	#else
		pigment {Clear}
	#end
}

#declare ShadeDepth=0.1;
#declare ShadeHeight=1;
#declare WindowShade=
union {
	box {
		<-HoleWidth,0,0>,
		<HoleWidth,ShadeHeight,ShadeDepth>
	}
	superellipsoid {
		<0.6,0.2>
		scale 0.15
		scale <1,0.1,1>
		//rotate x*90
		translate 0.1*y
	}
	texture {Wall_Tex}
}

#declare Seat2=-2.4

#declare Wall=
union {
	polygon {
		5 <0,0>,<0,1>,<1,1>,<1,0>,<0,0>
		pigment {
			image_map {
				png "smoking.png" // the file to read (iff/gif/tga/png/sys)
				//transmit 16,0	//100% transparent
				//filter 16,1	//100% transparent
				map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
				interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
				
			} // image_map
		}
		finish {ambient 0.3}
		scale 0.5
		translate <-1.4,0.5,4.999>
		no_shadow
	}

	intersection {
		plane {-z,-5}
		object {
			HoleShape
			translate <0,0,5>
			inverse
		}
		object {
			HoleShape
			translate <Seat2,0,5>
			inverse
		}
		texture {Wall_Tex}
		
	}
}


#declare Seat_Tex=
texture {
	pigment {
		gradient z
		color_map {
			[0.00 Gray45]
			[0.80 Gray45]
			[0.80 Gray75]
			[0.85 Gray75]
			[0.85 Red]
			[0.90 Red]
			[0.90 Black]
			[1.00 Black]
		}
		phase 0.85
		scale <1,2,0.7>
		turbulence <0,0,0.1>
		triangle_wave
	}
	normal {
		leopard 1
		scale <1,2,0.000000001>
		turbulence 0.6
	}
	finish { ambient 0.3}
//	scale <.03,.03,0.03>
	rotate <0,0,10>
	translate <0,0,6>
}

#declare OverHead=
union {
	polygon {		// Small slanted section of wall
		5
		<10,0>,<-10,0>,<-10,10>,<10,10>,<10,0>
		rotate <-60,0,0>
		translate <0,1.01,5.2>
		texture {Wall_Tex}
	}
	polygon {		//Ceiling
		5
		<10,0>,<-10,0>,<-10,5>,<10,5>,<10,0>
		rotate <-90,0,0>
		translate <0,1.55,5>
		texture {Wall_Tex}
	}



	light_source
	{
		<0,0,0> // light's position (translated below)
		color rgb <0.5,0.5,0.3>*0.5  // light's color
		// <widthVector> <heightVector> nLightsWide mLightsHigh
		translate <-2, 1.00, 4>   // <x y z> position of light
	}
	light_source
	{
		<0,0,0> // light's position (translated below)
		color rgb <0.5,0.5,0.3>*0.5  // light's color
		// <widthVector> <heightVector> nLightsWide mLightsHigh
		translate <0.45, 1.00, 4>   // <x y z> position of light
	}      
	
	#declare I=-3;
	#declare Angle=60;
	#declare Falloff=100;
	#declare Fudge=1;		
	#declare S1=seed(4);
	#while (I<1.1)
		#declare X1=rand(S1);
		#declare Z1=rand(S1);		 
		light_source {
			<0,0,0> // light's position (translated below)
			color rgb <0.5,0.5,0.4>*1.0  // light's color
			spotlight
			point_at <(0.5-X1)*Fudge+I,-1,(0.5-Z1)*Fudge>
			radius Angle
			tightness 10
			falloff Falloff
			translate <I, 1.35, 3.75>   // <x y z> position of light
		}

		/*cone {
			<0,0.0001,0>,0
			<(0.5-X1)*Fudge+I,-1,(0.5-Z1)*Fudge>,vlength(<0,0.0001,0>-<(0.5-X1)*Fudge+I,-1,(0.5-Z1)*Fudge>)* tan (radians(Falloff))
			open
			hollow
			pigment {Green quick_color Green}
			finish {ambient 1}
			translate <I, 1.00, 3.75> 
			
		} */

		#render concat("Value is:",str( 0.2*vlength(<(0.5-X1)*0.2,-1,(0.5-Z1)*0.2>) * tan(radians(Falloff)+0.001),2,2),"\n")
		#declare I=I+0.5;	
	#end 


/*	cone {
		#declare A=<2.01, 1.355, -0.002>;
		#declare B=<0.51,-1,0.75>;
		A,0
		B,vlength(A-B)* tan (radians(9.8))
		open
		pigment {Green}
	}
*/
/*
	light_source {
		<0.8, .35, -0.001> 
		color rgb 1 // light's color
		spotlight
		point_at <0.71,-1,0.75>
		radius 5 
		falloff 10
		tightness 3  
		shadowless
	}
*/
}


union {
	union {
		object {Seat texture {Seat_Tex} scale 0.4 translate <0.5,0,3.5>}
		object {Seat texture {Seat_Tex} scale 0.4 translate <-1.3,0,3.5>}
		object {Seat texture {Seat_Tex} scale 0.4 translate <-3.0,0,3.5>}
		clipped_by {
				box {<-3.0,-6.5,-2>,<5,1.5,4.5>}
		}
		bounded_by {clipped_by}					
	}
	object {Wall}
	object {WindowRim translate 5*z}
	object {WindowRim translate 5*z translate <Seat2,0,0>}
	object {Window translate 5*z+ShadeDepth+ConeDepth}
	object {Window translate 5*z+ShadeDepth+ConeDepth}
	object {WindowShade rotate <0,0,-2> translate 5*z+<0,0.4,ConeDepth>}
	object {WindowShade rotate <0,0,3> translate 5*z+<Seat2,0.0,ConeDepth>}
	object {OverHead}
	clipped_by {
		box {
			<-5,-10,-1>,
			<5,8,6>
		}
	}
	bounded_by {clipped_by}
	rotate <0,0,-30>
}



polygon {		//Water outside the window...
	5
	<-1000,5>,<1000,5>,<1000,1000000000000>,<-1000,1000000000000>,<-1000,5>
	rotate <90,0,0>
	texture {
		pigment{ rgbf <0.2, 0.2, 1.5, 0.9> }
		normal {
			waves 0.75
			frequency 10
		}
		finish {
			reflection 0.3
		}
		scale 2
	}
	translate <0,-0.31,0.40>
}


plane {
	y,-15
	texture {pigment {DarkGreen}}
}
// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>

height_field {			//Water inside the cabin
	tga				
	"water.tga"		
	smooth			// make smoother surface
	texture {Water pigment {transmit 0.5}}
	rotate <0,90,0>
	translate <-0.5,0,1>
	scale <5,0.8,5>
	translate <0,-1,0>
}


#include "paper.inc"

object {		//floating piece of paper.
	Paper
	pigment {
		image_map {
			gif "paper.gif"	
		}
	}
	finish { ambient 0.8}
	scale 1.666667
	translate <-0.0,0,0>
	rotate <70,0,2>
	translate <-0.1,-1.15,1.2>
}